import{r as Ys,i as Vs,d as tu,T as eu}from"./indexhtml-C-01S9XA.js";import{F as iu,R as nu,h as ru,E as au,b as ou}from"./generated-flow-imports-BTB8-DHk.js";/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */Ys("vaadin-map",Vs`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-m);
      --vaadin-map-controls-inset: var(--lumo-space-xs);
      --vaadin-map-icon-zoom-in: var(--lumo-icons-plus);
      --vaadin-map-icon-zoom-out: var(--lumo-icons-minus);
      --vaadin-map-icon-compass: var(--lumo-icons-arrow-up);
      --vaadin-map-icon-overview-map-collapse: var(--lumo-icons-angle-down);
      --vaadin-map-icon-overview-map-expand: var(--lumo-icons-angle-up);
      --vaadin-map-icon-close: var(--lumo-icons-cross);
      --vaadin-map-icon-attribution-collapse: var(--lumo-icons-angle-right);
      --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
      --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    }

    :host(:not([theme~='borderless'])) {
      border-radius: var(--lumo-border-radius-l);
      position: relative;
    }

    :host(:not([theme~='borderless']))::before {
      content: '';
      position: absolute;
      inset: 0;
      border: 1px solid var(--lumo-contrast-10pct);
      border-radius: inherit;
      z-index: 1;
      pointer-events: none;
    }

    :host([focus-ring]) {
      box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
    }

    .ol-control,
    .ol-scale-bar,
    .ol-scale-line {
      margin: var(--lumo-space-xs);
    }

    .ol-control {
      border-radius: var(--lumo-border-radius-m);
      transition:
        0.15s box-shadow,
        0.15s background-color;
      -webkit-backdrop-filter: blur(8px);
    }

    .ol-control:hover {
      background-color: var(--lumo-base-color);
    }

    .ol-control:not(.ol-uncollapsible):hover {
      box-shadow: var(--lumo-box-shadow-s);
      background-color: var(--lumo-shade-20pct);
    }

    .ol-control button {
      width: var(--lumo-size-s);
      height: var(--lumo-size-s);
      border-radius: inherit;
      font-family: 'lumo-icons';
      font-size: var(--lumo-icon-size-s);
      font-weight: 400;
    }

    .ol-control button,
    .ol-attribution:not(.ol-uncollapsible) ul {
      transition: 0.15s opacity;
      background-color: var(--lumo-base-color);
      color: var(--lumo-body-text-color);
      opacity: 0.65;
    }

    .ol-control:hover button,
    .ol-control button:focus,
    .ol-attribution:hover ul {
      opacity: 1;
    }

    .ol-control button:hover {
      color: var(--lumo-primary-text-color);
    }

    .ol-control button:active {
      background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    @supports not selector(:focus-visible) {
      .ol-control button:focus {
        outline: none;
        box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
      }
    }

    .ol-control button:focus-visible {
      outline: none;
      box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
    }

    .ol-zoom {
      gap: 2px;
    }

    button.ol-zoom-in {
      border-bottom-left-radius: 0;
      border-bottom-right-radius: 0;
    }

    button.ol-zoom-out {
      border-top-left-radius: 0;
      border-top-right-radius: 0;
    }

    .ol-attribution.ol-uncollapsible {
      border-radius: var(--lumo-border-radius-m) 0 0 0;
    }

    .ol-attribution ul {
      font-size: var(--lumo-font-size-xxs);
      color: var(--lumo-secondary-text-color);
      padding: var(--lumo-space-xs) var(--lumo-space-s);
      cursor: default;
    }

    .ol-attribution:not(.ol-uncollapsible) ul {
      background-color: var(--lumo-base-color);
    }

    .ol-attribution a {
      color: inherit;
      cursor: pointer;
    }

    .ol-scale-bar-inner {
      border-radius: var(--lumo-border-radius-s);
    }

    .ol-full-screen {
      height: var(--lumo-size-s);
    }

    .ol-overviewmap:not(.ol-collapsed),
    .ol-overviewmap:not(.ol-collapsed):hover {
      background-color: var(--lumo-base-color);
      box-shadow: var(--lumo-box-shadow-s);
      transition: 0.15s box-shadow;
    }

    .ol-overviewmap-map {
      margin: var(--lumo-space-xs);
      border: 0;
      border-radius: var(--lumo-border-radius-s);
    }

    .ol-overviewmap:not(.ol-uncollapsible) .ol-overviewmap-map {
      margin-bottom: 0;
    }

    .ol-zoomslider:not(.ol-uncollapsible):hover {
      box-shadow: none;
      overflow: visible;
    }

    .ol-zoomslider button {
      height: var(--lumo-space-m);
    }

    .ol-zoomslider:hover button {
      box-shadow: var(--lumo-box-shadow-s);
    }
  `,{moduleId:"lumo-map"});var Zt=(function(){function n(e){this.propagationStopped,this.defaultPrevented,this.type=e,this.target=null}return n.prototype.preventDefault=function(){this.defaultPrevented=!0},n.prototype.stopPropagation=function(){this.propagationStopped=!0},n})();const Pi={PROPERTYCHANGE:"propertychange"};var ka=(function(){function n(){this.disposed=!1}return n.prototype.dispose=function(){this.disposed||(this.disposed=!0,this.disposeInternal())},n.prototype.disposeInternal=function(){},n})();function Li(n,e){return n>e?1:n<e?-1:0}function So(n,e){return n.indexOf(e)>=0}function Fr(n,e,t){var i=n.length;if(n[0]<=e)return 0;if(e<=n[i-1])return i-1;var r=void 0;if(t>0){for(r=1;r<i;++r)if(n[r]<e)return r-1}else if(t<0){for(r=1;r<i;++r)if(n[r]<=e)return r}else for(r=1;r<i;++r){if(n[r]==e)return r;if(n[r]<e)return typeof t=="function"?t(e,n[r-1],n[r])>0?r-1:r:n[r-1]-e<e-n[r]?r-1:r}return i-1}function su(n,e,t){for(;e<t;){var i=n[e];n[e]=n[t],n[t]=i,++e,--t}}function qs(n,e){for(var t=Array.isArray(e)?e:[e],i=t.length,r=0;r<i;r++)n[n.length]=t[r]}function ai(n,e){var t=n.length;if(t!==e.length)return!1;for(var i=0;i<t;i++)if(n[i]!==e[i])return!1;return!0}function hu(n,e,t){var i=e||Li;return n.every(function(r,a){if(a===0)return!0;var o=i(n[a-1],r);return!(o>0||o===0)})}function De(){return!0}function Gr(){return!1}function ti(){}function lu(n){var e=!1,t,i,r;return function(){var a=Array.prototype.slice.call(arguments);return(!e||this!==r||!ai(a,i))&&(e=!0,r=this,i=a,t=n.apply(this,arguments)),t}}var it=typeof Object.assign=="function"?Object.assign:function(n,e){if(n==null)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(n),i=1,r=arguments.length;i<r;++i){var a=arguments[i];if(a!=null)for(var o in a)a.hasOwnProperty(o)&&(t[o]=a[o])}return t};function An(n){for(var e in n)delete n[e]}var Ks=typeof Object.values=="function"?Object.values:function(n){var e=[];for(var t in n)e.push(n[t]);return e};function pn(n){var e;for(e in n)return!1;return!e}var uu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),zi=(function(n){uu(e,n);function e(t){var i=n.call(this)||this;return i.eventTarget_=t,i.pendingRemovals_=null,i.dispatching_=null,i.listeners_=null,i}return e.prototype.addEventListener=function(t,i){if(!(!t||!i)){var r=this.listeners_||(this.listeners_={}),a=r[t]||(r[t]=[]);a.indexOf(i)===-1&&a.push(i)}},e.prototype.dispatchEvent=function(t){var i=typeof t=="string",r=i?t:t.type,a=this.listeners_&&this.listeners_[r];if(a){var o=i?new Zt(t):t;o.target||(o.target=this.eventTarget_||this);var s=this.dispatching_||(this.dispatching_={}),h=this.pendingRemovals_||(this.pendingRemovals_={});r in s||(s[r]=0,h[r]=0),++s[r];for(var l,u=0,c=a.length;u<c;++u)if("handleEvent"in a[u]?l=a[u].handleEvent(o):l=a[u].call(this,o),l===!1||o.propagationStopped){l=!1;break}if(--s[r]===0){var f=h[r];for(delete h[r];f--;)this.removeEventListener(r,ti);delete s[r]}return l}},e.prototype.disposeInternal=function(){this.listeners_&&An(this.listeners_)},e.prototype.getListeners=function(t){return this.listeners_&&this.listeners_[t]||void 0},e.prototype.hasListener=function(t){return this.listeners_?t?t in this.listeners_:Object.keys(this.listeners_).length>0:!1},e.prototype.removeEventListener=function(t,i){var r=this.listeners_&&this.listeners_[t];if(r){var a=r.indexOf(i);a!==-1&&(this.pendingRemovals_&&t in this.pendingRemovals_?(r[a]=ti,++this.pendingRemovals_[t]):(r.splice(a,1),r.length===0&&delete this.listeners_[t]))}},e})(ka);const B={CHANGE:"change",ERROR:"error",CONTEXTMENU:"contextmenu",CLICK:"click",DBLCLICK:"dblclick",KEYDOWN:"keydown",KEYPRESS:"keypress",LOAD:"load",RESIZE:"resize",TOUCHMOVE:"touchmove",WHEEL:"wheel"};function Z(n,e,t,i,r){if(i&&i!==n&&(t=t.bind(i)),r){var a=t;t=function(){n.removeEventListener(e,t),a.apply(this,arguments)}}var o={target:n,type:e,listener:t};return n.addEventListener(e,t),o}function _r(n,e,t,i){return Z(n,e,t,i,!0)}function rt(n){n&&n.target&&(n.target.removeEventListener(n.type,n.listener),An(n))}var fu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Pn=(function(n){fu(e,n);function e(){var t=n.call(this)||this;return t.on=t.onInternal,t.once=t.onceInternal,t.un=t.unInternal,t.revision_=0,t}return e.prototype.changed=function(){++this.revision_,this.dispatchEvent(B.CHANGE)},e.prototype.getRevision=function(){return this.revision_},e.prototype.onInternal=function(t,i){if(Array.isArray(t)){for(var r=t.length,a=new Array(r),o=0;o<r;++o)a[o]=Z(this,t[o],i);return a}else return Z(this,t,i)},e.prototype.onceInternal=function(t,i){var r;if(Array.isArray(t)){var a=t.length;r=new Array(a);for(var o=0;o<a;++o)r[o]=_r(this,t[o],i)}else r=_r(this,t,i);return i.ol_key=r,r},e.prototype.unInternal=function(t,i){var r=i.ol_key;if(r)cu(r);else if(Array.isArray(t))for(var a=0,o=t.length;a<o;++a)this.removeEventListener(t[a],i);else this.removeEventListener(t,i)},e})(zi);Pn.prototype.on;Pn.prototype.once;Pn.prototype.un;function cu(n){if(Array.isArray(n))for(var e=0,t=n.length;e<t;++e)rt(n[e]);else rt(n)}function q(){return(function(){throw new Error("Unimplemented abstract method.")})()}var du=0;function H(n){return n.ol_uid||(n.ol_uid=String(++du))}var vu="6.13.0",$s=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Oo=(function(n){$s(e,n);function e(t,i,r){var a=n.call(this,t)||this;return a.key=i,a.oldValue=r,a}return e})(Zt),se=(function(n){$s(e,n);function e(t){var i=n.call(this)||this;return i.on,i.once,i.un,H(i),i.values_=null,t!==void 0&&i.setProperties(t),i}return e.prototype.get=function(t){var i;return this.values_&&this.values_.hasOwnProperty(t)&&(i=this.values_[t]),i},e.prototype.getKeys=function(){return this.values_&&Object.keys(this.values_)||[]},e.prototype.getProperties=function(){return this.values_&&it({},this.values_)||{}},e.prototype.hasProperties=function(){return!!this.values_},e.prototype.notify=function(t,i){var r;r="change:".concat(t),this.hasListener(r)&&this.dispatchEvent(new Oo(r,t,i)),r=Pi.PROPERTYCHANGE,this.hasListener(r)&&this.dispatchEvent(new Oo(r,t,i))},e.prototype.addChangeListener=function(t,i){this.addEventListener("change:".concat(t),i)},e.prototype.removeChangeListener=function(t,i){this.removeEventListener("change:".concat(t),i)},e.prototype.set=function(t,i,r){var a=this.values_||(this.values_={});if(r)a[t]=i;else{var o=a[t];a[t]=i,o!==i&&this.notify(t,o)}},e.prototype.setProperties=function(t,i){for(var r in t)this.set(r,t[r],i)},e.prototype.applyProperties=function(t){t.values_&&it(this.values_||(this.values_={}),t.values_)},e.prototype.unset=function(t,i){if(this.values_&&t in this.values_){var r=this.values_[t];delete this.values_[t],pn(this.values_)&&(this.values_=null),i||this.notify(t,r)}},e})(Pn);const hr={POSTRENDER:"postrender",MOVESTART:"movestart",MOVEEND:"moveend"};var Ni=typeof navigator<"u"&&typeof navigator.userAgent<"u"?navigator.userAgent.toLowerCase():"",_u=Ni.indexOf("firefox")!==-1;Ni.indexOf("safari")!==-1&&Ni.indexOf("chrom")==-1;var pu=Ni.indexOf("webkit")!==-1&&Ni.indexOf("edge")==-1,gu=Ni.indexOf("macintosh")!==-1,Zs=typeof devicePixelRatio<"u"?devicePixelRatio:1,kr=typeof WorkerGlobalScope<"u"&&typeof OffscreenCanvas<"u"&&self instanceof WorkerGlobalScope,yu=typeof Image<"u"&&Image.prototype.decode,Hs=(function(){var n=!1;try{var e=Object.defineProperty({},"passive",{get:function(){n=!0}});window.addEventListener("_",null,e),window.removeEventListener("_",null,e)}catch{}return n})();function Bt(n,e,t,i){var r;return kr?r=new OffscreenCanvas(n||300,e||300):r=document.createElement("canvas"),n&&(r.width=n),e&&(r.height=e),r.getContext("2d",i)}function Ao(n,e){var t=e.parentNode;t&&t.replaceChild(n,e)}function ma(n){return n&&n.parentNode?n.parentNode.removeChild(n):null}function mu(n){for(;n.lastChild;)n.removeChild(n.lastChild)}function xu(n,e){for(var t=n.childNodes,i=0;;++i){var r=t[i],a=e[i];if(!r&&!a)break;if(r!==a){if(!r){n.appendChild(a);continue}if(!a){n.removeChild(r),--i;continue}n.insertBefore(a,r)}}}var Eu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),za=(function(n){Eu(e,n);function e(t){var i=n.call(this)||this,r=t.element;return r&&!t.target&&!r.style.pointerEvents&&(r.style.pointerEvents="auto"),i.element=r||null,i.target_=null,i.map_=null,i.listenerKeys=[],t.render&&(i.render=t.render),t.target&&i.setTarget(t.target),i}return e.prototype.disposeInternal=function(){ma(this.element),n.prototype.disposeInternal.call(this)},e.prototype.getMap=function(){return this.map_},e.prototype.setMap=function(t){this.map_&&ma(this.element);for(var i=0,r=this.listenerKeys.length;i<r;++i)rt(this.listenerKeys[i]);if(this.listenerKeys.length=0,this.map_=t,t){var a=this.target_?this.target_:t.getOverlayContainerStopEvent();a.appendChild(this.element),this.render!==ti&&this.listenerKeys.push(Z(t,hr.POSTRENDER,this.render,this)),t.render()}},e.prototype.render=function(t){},e.prototype.setTarget=function(t){this.target_=typeof t=="string"?document.getElementById(t):t},e})(se),Hn="ol-hidden",zr="ol-unselectable",ja="ol-control",Po="ol-collapsed",Mu=new RegExp(["^\\s*(?=(?:(?:[-a-z]+\\s*){0,2}(italic|oblique))?)","(?=(?:(?:[-a-z]+\\s*){0,2}(small-caps))?)","(?=(?:(?:[-a-z]+\\s*){0,2}(bold(?:er)?|lighter|[1-9]00 ))?)","(?:(?:normal|\\1|\\2|\\3)\\s*){0,3}((?:xx?-)?","(?:small|large)|medium|smaller|larger|[\\.\\d]+(?:\\%|in|[cem]m|ex|p[ctx]))","(?:\\s*\\/\\s*(normal|[\\.\\d]+(?:\\%|in|[cem]m|ex|p[ctx])?))",`?\\s*([-,\\"\\'\\sa-z]+?)\\s*$`].join(""),"i"),Lo=["style","variant","weight","size","lineHeight","family"],Js=function(n){var e=n.match(Mu);if(!e)return null;for(var t={lineHeight:"normal",size:"1.2em",style:"normal",weight:"normal",variant:"normal"},i=0,r=Lo.length;i<r;++i){var a=e[i+1];a!==void 0&&(t[Lo[i]]=a)}return t.families=t.family.split(/,\s?/),t};function Qs(n){return n===1?"":String(Math.round(n*100)/100)}const tt={OPACITY:"opacity",VISIBLE:"visible",EXTENT:"extent",Z_INDEX:"zIndex",MAX_RESOLUTION:"maxResolution",MIN_RESOLUTION:"minResolution",MAX_ZOOM:"maxZoom",MIN_ZOOM:"minZoom",SOURCE:"source",MAP:"map"};var Tu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),th=(function(n){Tu(e,n);function e(t){var i=this,r="v"+vu.split("-")[0],a="Assertion failed. See https://openlayers.org/en/"+r+"/doc/errors/#"+t+" for details.";return i=n.call(this,a)||this,i.code=t,i.name="AssertionError",i.message=a,i}return e})(Error);function Y(n,e){if(!n)throw new th(e)}function ut(n,e,t){return Math.min(Math.max(n,e),t)}var Cu=(function(){var n;return"cosh"in Math?n=Math.cosh:n=function(e){var t=Math.exp(e);return(t+1/t)/2},n})(),Ru=(function(){var n;return"log2"in Math?n=Math.log2:n=function(e){return Math.log(e)*Math.LOG2E},n})();function wu(n,e,t,i,r,a){var o=r-t,s=a-i;if(o!==0||s!==0){var h=((n-t)*o+(e-i)*s)/(o*o+s*s);h>1?(t=r,i=a):h>0&&(t+=o*h,i+=s*h)}return wi(n,e,t,i)}function wi(n,e,t,i){var r=t-n,a=i-e;return r*r+a*a}function Iu(n){for(var e=n.length,t=0;t<e;t++){for(var i=t,r=Math.abs(n[t][t]),a=t+1;a<e;a++){var o=Math.abs(n[a][t]);o>r&&(r=o,i=a)}if(r===0)return null;var s=n[i];n[i]=n[t],n[t]=s;for(var h=t+1;h<e;h++)for(var l=-n[h][t]/n[t][t],u=t;u<e+1;u++)t==u?n[h][u]=0:n[h][u]+=l*n[t][u]}for(var c=new Array(e),f=e-1;f>=0;f--){c[f]=n[f][e]/n[f][f];for(var d=f-1;d>=0;d--)n[d][e]-=n[d][f]*c[f]}return c}function lr(n){return n*Math.PI/180}function He(n,e){var t=n%e;return t*e<0?t+e:t}function Ve(n,e,t){return n+t*(e-n)}function Ua(n,e){var t=Math.pow(10,e);return Math.round(n*t)/t}function No(n,e){return Math.round(Ua(n,e))}function mi(n,e){return Math.floor(Ua(n,e))}function Ae(n,e){return Math.ceil(Ua(n,e))}var Su=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),eh=(function(n){Su(e,n);function e(t){var i=n.call(this)||this;i.on,i.once,i.un,i.background_=t.background;var r=it({},t);return typeof t.properties=="object"&&(delete r.properties,it(r,t.properties)),r[tt.OPACITY]=t.opacity!==void 0?t.opacity:1,Y(typeof r[tt.OPACITY]=="number",64),r[tt.VISIBLE]=t.visible!==void 0?t.visible:!0,r[tt.Z_INDEX]=t.zIndex,r[tt.MAX_RESOLUTION]=t.maxResolution!==void 0?t.maxResolution:1/0,r[tt.MIN_RESOLUTION]=t.minResolution!==void 0?t.minResolution:0,r[tt.MIN_ZOOM]=t.minZoom!==void 0?t.minZoom:-1/0,r[tt.MAX_ZOOM]=t.maxZoom!==void 0?t.maxZoom:1/0,i.className_=r.className!==void 0?r.className:"ol-layer",delete r.className,i.setProperties(r),i.state_=null,i}return e.prototype.getBackground=function(){return this.background_},e.prototype.getClassName=function(){return this.className_},e.prototype.getLayerState=function(t){var i=this.state_||{layer:this,managed:t===void 0?!0:t},r=this.getZIndex();return i.opacity=ut(Math.round(this.getOpacity()*100)/100,0,1),i.visible=this.getVisible(),i.extent=this.getExtent(),i.zIndex=r===void 0&&!i.managed?1/0:r,i.maxResolution=this.getMaxResolution(),i.minResolution=Math.max(this.getMinResolution(),0),i.minZoom=this.getMinZoom(),i.maxZoom=this.getMaxZoom(),this.state_=i,i},e.prototype.getLayersArray=function(t){return q()},e.prototype.getLayerStatesArray=function(t){return q()},e.prototype.getExtent=function(){return this.get(tt.EXTENT)},e.prototype.getMaxResolution=function(){return this.get(tt.MAX_RESOLUTION)},e.prototype.getMinResolution=function(){return this.get(tt.MIN_RESOLUTION)},e.prototype.getMinZoom=function(){return this.get(tt.MIN_ZOOM)},e.prototype.getMaxZoom=function(){return this.get(tt.MAX_ZOOM)},e.prototype.getOpacity=function(){return this.get(tt.OPACITY)},e.prototype.getSourceState=function(){return q()},e.prototype.getVisible=function(){return this.get(tt.VISIBLE)},e.prototype.getZIndex=function(){return this.get(tt.Z_INDEX)},e.prototype.setBackground=function(t){this.background_=t,this.changed()},e.prototype.setExtent=function(t){this.set(tt.EXTENT,t)},e.prototype.setMaxResolution=function(t){this.set(tt.MAX_RESOLUTION,t)},e.prototype.setMinResolution=function(t){this.set(tt.MIN_RESOLUTION,t)},e.prototype.setMaxZoom=function(t){this.set(tt.MAX_ZOOM,t)},e.prototype.setMinZoom=function(t){this.set(tt.MIN_ZOOM,t)},e.prototype.setOpacity=function(t){Y(typeof t=="number",64),this.set(tt.OPACITY,t)},e.prototype.setVisible=function(t){this.set(tt.VISIBLE,t)},e.prototype.setZIndex=function(t){this.set(tt.Z_INDEX,t)},e.prototype.disposeInternal=function(){this.state_&&(this.state_.layer=null,this.state_=null),n.prototype.disposeInternal.call(this)},e})(se);const ei={PRERENDER:"prerender",POSTRENDER:"postrender",PRECOMPOSE:"precompose",POSTCOMPOSE:"postcompose",RENDERCOMPLETE:"rendercomplete"},ii={UNDEFINED:"undefined",READY:"ready"};var Ou=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Ln=(function(n){Ou(e,n);function e(t){var i=this,r=it({},t);delete r.source,i=n.call(this,r)||this,i.on,i.once,i.un,i.mapPrecomposeKey_=null,i.mapRenderKey_=null,i.sourceChangeKey_=null,i.renderer_=null,i.rendered=!1,t.render&&(i.render=t.render),t.map&&i.setMap(t.map),i.addChangeListener(tt.SOURCE,i.handleSourcePropertyChange_);var a=t.source?t.source:null;return i.setSource(a),i}return e.prototype.getLayersArray=function(t){var i=t||[];return i.push(this),i},e.prototype.getLayerStatesArray=function(t){var i=t||[];return i.push(this.getLayerState()),i},e.prototype.getSource=function(){return this.get(tt.SOURCE)||null},e.prototype.getRenderSource=function(){return this.getSource()},e.prototype.getSourceState=function(){var t=this.getSource();return t?t.getState():ii.UNDEFINED},e.prototype.handleSourceChange_=function(){this.changed()},e.prototype.handleSourcePropertyChange_=function(){this.sourceChangeKey_&&(rt(this.sourceChangeKey_),this.sourceChangeKey_=null);var t=this.getSource();t&&(this.sourceChangeKey_=Z(t,B.CHANGE,this.handleSourceChange_,this)),this.changed()},e.prototype.getFeatures=function(t){return this.renderer_?this.renderer_.getFeatures(t):new Promise(function(i){return i([])})},e.prototype.getData=function(t){return!this.renderer_||!this.rendered?null:this.renderer_.getData(t)},e.prototype.render=function(t,i){var r=this.getRenderer();if(r.prepareFrame(t))return this.rendered=!0,r.renderFrame(t,i)},e.prototype.unrender=function(){this.rendered=!1},e.prototype.setMapInternal=function(t){t||this.unrender(),this.set(tt.MAP,t)},e.prototype.getMapInternal=function(){return this.get(tt.MAP)},e.prototype.setMap=function(t){this.mapPrecomposeKey_&&(rt(this.mapPrecomposeKey_),this.mapPrecomposeKey_=null),t||this.changed(),this.mapRenderKey_&&(rt(this.mapRenderKey_),this.mapRenderKey_=null),t&&(this.mapPrecomposeKey_=Z(t,ei.PRECOMPOSE,function(i){var r=i,a=r.frameState.layerStatesArray,o=this.getLayerState(!1);Y(!a.some(function(s){return s.layer===o.layer}),67),a.push(o)},this),this.mapRenderKey_=Z(this,B.CHANGE,t.render,t),this.changed())},e.prototype.setSource=function(t){this.set(tt.SOURCE,t)},e.prototype.getRenderer=function(){return this.renderer_||(this.renderer_=this.createRenderer()),this.renderer_},e.prototype.hasRenderer=function(){return!!this.renderer_},e.prototype.createRenderer=function(){return null},e.prototype.disposeInternal=function(){this.renderer_&&(this.renderer_.dispose(),delete this.renderer_),this.setSource(null),n.prototype.disposeInternal.call(this)},e})(eh);function pr(n,e){if(!n.visible)return!1;var t=e.resolution;if(t<n.minResolution||t>=n.maxResolution)return!1;var i=e.zoom;return i>n.minZoom&&i<=n.maxZoom}var Au=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Pu=(function(n){Au(e,n);function e(t){var i=this,r=t||{};i=n.call(this,{element:document.createElement("div"),render:r.render,target:r.target})||this,i.ulElement_=document.createElement("ul"),i.collapsed_=r.collapsed!==void 0?r.collapsed:!0,i.userCollapsed_=i.collapsed_,i.overrideCollapsible_=r.collapsible!==void 0,i.collapsible_=r.collapsible!==void 0?r.collapsible:!0,i.collapsible_||(i.collapsed_=!1);var a=r.className!==void 0?r.className:"ol-attribution",o=r.tipLabel!==void 0?r.tipLabel:"Attributions",s=r.expandClassName!==void 0?r.expandClassName:a+"-expand",h=r.collapseLabel!==void 0?r.collapseLabel:"›",l=r.collapseClassName!==void 0?r.collapseClassName:a+"-collapse";typeof h=="string"?(i.collapseLabel_=document.createElement("span"),i.collapseLabel_.textContent=h,i.collapseLabel_.className=l):i.collapseLabel_=h;var u=r.label!==void 0?r.label:"i";typeof u=="string"?(i.label_=document.createElement("span"),i.label_.textContent=u,i.label_.className=s):i.label_=u;var c=i.collapsible_&&!i.collapsed_?i.collapseLabel_:i.label_;i.toggleButton_=document.createElement("button"),i.toggleButton_.setAttribute("type","button"),i.toggleButton_.setAttribute("aria-expanded",String(!i.collapsed_)),i.toggleButton_.title=o,i.toggleButton_.appendChild(c),i.toggleButton_.addEventListener(B.CLICK,i.handleClick_.bind(i),!1);var f=a+" "+zr+" "+ja+(i.collapsed_&&i.collapsible_?" "+Po:"")+(i.collapsible_?"":" ol-uncollapsible"),d=i.element;return d.className=f,d.appendChild(i.toggleButton_),d.appendChild(i.ulElement_),i.renderedAttributions_=[],i.renderedVisible_=!0,i}return e.prototype.collectSourceAttributions_=function(t){for(var i={},r=[],a=!0,o=t.layerStatesArray,s=0,h=o.length;s<h;++s){var l=o[s];if(pr(l,t.viewState)){var u=l.layer.getSource();if(u){var c=u.getAttributions();if(c){var f=c(t);if(f)if(a=a&&u.getAttributionsCollapsible()!==!1,Array.isArray(f))for(var d=0,v=f.length;d<v;++d)f[d]in i||(r.push(f[d]),i[f[d]]=!0);else f in i||(r.push(f),i[f]=!0)}}}}return this.overrideCollapsible_||this.setCollapsible(a),r},e.prototype.updateElement_=function(t){if(!t){this.renderedVisible_&&(this.element.style.display="none",this.renderedVisible_=!1);return}var i=this.collectSourceAttributions_(t),r=i.length>0;if(this.renderedVisible_!=r&&(this.element.style.display=r?"":"none",this.renderedVisible_=r),!ai(i,this.renderedAttributions_)){mu(this.ulElement_);for(var a=0,o=i.length;a<o;++a){var s=document.createElement("li");s.innerHTML=i[a],this.ulElement_.appendChild(s)}this.renderedAttributions_=i}},e.prototype.handleClick_=function(t){t.preventDefault(),this.handleToggle_(),this.userCollapsed_=this.collapsed_},e.prototype.handleToggle_=function(){this.element.classList.toggle(Po),this.collapsed_?Ao(this.collapseLabel_,this.label_):Ao(this.label_,this.collapseLabel_),this.collapsed_=!this.collapsed_,this.toggleButton_.setAttribute("aria-expanded",String(!this.collapsed_))},e.prototype.getCollapsible=function(){return this.collapsible_},e.prototype.setCollapsible=function(t){this.collapsible_!==t&&(this.collapsible_=t,this.element.classList.toggle("ol-uncollapsible"),this.userCollapsed_&&this.handleToggle_())},e.prototype.setCollapsed=function(t){this.userCollapsed_=t,!(!this.collapsible_||this.collapsed_===t)&&this.handleToggle_()},e.prototype.getCollapsed=function(){return this.collapsed_},e.prototype.render=function(t){this.updateElement_(t.frameState)},e})(za);const Pt={ADD:"add",REMOVE:"remove"};var ih=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),bo={LENGTH:"length"},Jn=(function(n){ih(e,n);function e(t,i,r){var a=n.call(this,t)||this;return a.element=i,a.index=r,a}return e})(Zt),xt=(function(n){ih(e,n);function e(t,i){var r=n.call(this)||this;r.on,r.once,r.un;var a=i||{};if(r.unique_=!!a.unique,r.array_=t||[],r.unique_)for(var o=0,s=r.array_.length;o<s;++o)r.assertUnique_(r.array_[o],o);return r.updateLength_(),r}return e.prototype.clear=function(){for(;this.getLength()>0;)this.pop()},e.prototype.extend=function(t){for(var i=0,r=t.length;i<r;++i)this.push(t[i]);return this},e.prototype.forEach=function(t){for(var i=this.array_,r=0,a=i.length;r<a;++r)t(i[r],r,i)},e.prototype.getArray=function(){return this.array_},e.prototype.item=function(t){return this.array_[t]},e.prototype.getLength=function(){return this.get(bo.LENGTH)},e.prototype.insertAt=function(t,i){this.unique_&&this.assertUnique_(i),this.array_.splice(t,0,i),this.updateLength_(),this.dispatchEvent(new Jn(Pt.ADD,i,t))},e.prototype.pop=function(){return this.removeAt(this.getLength()-1)},e.prototype.push=function(t){this.unique_&&this.assertUnique_(t);var i=this.getLength();return this.insertAt(i,t),this.getLength()},e.prototype.remove=function(t){for(var i=this.array_,r=0,a=i.length;r<a;++r)if(i[r]===t)return this.removeAt(r)},e.prototype.removeAt=function(t){var i=this.array_[t];return this.array_.splice(t,1),this.updateLength_(),this.dispatchEvent(new Jn(Pt.REMOVE,i,t)),i},e.prototype.setAt=function(t,i){var r=this.getLength();if(t<r){this.unique_&&this.assertUnique_(i,t);var a=this.array_[t];this.array_[t]=i,this.dispatchEvent(new Jn(Pt.REMOVE,a,t)),this.dispatchEvent(new Jn(Pt.ADD,i,t))}else{for(var o=r;o<t;++o)this.insertAt(o,void 0);this.insertAt(t,i)}},e.prototype.updateLength_=function(){this.set(bo.LENGTH,this.array_.length)},e.prototype.assertUnique_=function(t,i){for(var r=0,a=this.array_.length;r<a;++r)if(this.array_[r]===t&&r!==i)throw new th(58)},e})(se);function nh(n){return Math.pow(n,3)}function ji(n){return 1-nh(1-n)}function Lu(n){return 3*n*n-2*n*n*n}function Nu(n){return n}var bu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Du=(function(n){bu(e,n);function e(t){var i=this,r=t||{};i=n.call(this,{element:document.createElement("div"),render:r.render,target:r.target})||this;var a=r.className!==void 0?r.className:"ol-rotate",o=r.label!==void 0?r.label:"⇧",s=r.compassClassName!==void 0?r.compassClassName:"ol-compass";i.label_=null,typeof o=="string"?(i.label_=document.createElement("span"),i.label_.className=s,i.label_.textContent=o):(i.label_=o,i.label_.classList.add(s));var h=r.tipLabel?r.tipLabel:"Reset rotation",l=document.createElement("button");l.className=a+"-reset",l.setAttribute("type","button"),l.title=h,l.appendChild(i.label_),l.addEventListener(B.CLICK,i.handleClick_.bind(i),!1);var u=a+" "+zr+" "+ja,c=i.element;return c.className=u,c.appendChild(l),i.callResetNorth_=r.resetNorth?r.resetNorth:void 0,i.duration_=r.duration!==void 0?r.duration:250,i.autoHide_=r.autoHide!==void 0?r.autoHide:!0,i.rotation_=void 0,i.autoHide_&&i.element.classList.add(Hn),i}return e.prototype.handleClick_=function(t){t.preventDefault(),this.callResetNorth_!==void 0?this.callResetNorth_():this.resetNorth_()},e.prototype.resetNorth_=function(){var t=this.getMap(),i=t.getView();if(i){var r=i.getRotation();r!==void 0&&(this.duration_>0&&r%(2*Math.PI)!==0?i.animate({rotation:0,duration:this.duration_,easing:ji}):i.setRotation(0))}},e.prototype.render=function(t){var i=t.frameState;if(i){var r=i.viewState.rotation;if(r!=this.rotation_){var a="rotate("+r+"rad)";if(this.autoHide_){var o=this.element.classList.contains(Hn);!o&&r===0?this.element.classList.add(Hn):o&&r!==0&&this.element.classList.remove(Hn)}this.label_.style.transform=a}this.rotation_=r}},e})(za),Fu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Gu=(function(n){Fu(e,n);function e(t){var i=this,r=t||{};i=n.call(this,{element:document.createElement("div"),target:r.target})||this;var a=r.className!==void 0?r.className:"ol-zoom",o=r.delta!==void 0?r.delta:1,s=r.zoomInClassName!==void 0?r.zoomInClassName:a+"-in",h=r.zoomOutClassName!==void 0?r.zoomOutClassName:a+"-out",l=r.zoomInLabel!==void 0?r.zoomInLabel:"+",u=r.zoomOutLabel!==void 0?r.zoomOutLabel:"–",c=r.zoomInTipLabel!==void 0?r.zoomInTipLabel:"Zoom in",f=r.zoomOutTipLabel!==void 0?r.zoomOutTipLabel:"Zoom out",d=document.createElement("button");d.className=s,d.setAttribute("type","button"),d.title=c,d.appendChild(typeof l=="string"?document.createTextNode(l):l),d.addEventListener(B.CLICK,i.handleClick_.bind(i,o),!1);var v=document.createElement("button");v.className=h,v.setAttribute("type","button"),v.title=f,v.appendChild(typeof u=="string"?document.createTextNode(u):u),v.addEventListener(B.CLICK,i.handleClick_.bind(i,-o),!1);var _=a+" "+zr+" "+ja,p=i.element;return p.className=_,p.appendChild(d),p.appendChild(v),i.duration_=r.duration!==void 0?r.duration:250,i}return e.prototype.handleClick_=function(t,i){i.preventDefault(),this.zoomByDelta_(t)},e.prototype.zoomByDelta_=function(t){var i=this.getMap(),r=i.getView();if(r){var a=r.getZoom();if(a!==void 0){var o=r.getConstrainedZoom(a+t);this.duration_>0?(r.getAnimating()&&r.cancelAnimations(),r.animate({zoom:o,duration:this.duration_,easing:ji})):r.setZoom(o)}}},e})(za);const yt={LAYERGROUP:"layergroup",SIZE:"size",TARGET:"target",VIEW:"view"},xa={POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown"};var Nt={RADIANS:"radians",DEGREES:"degrees",FEET:"ft",METERS:"m",TILE_PIXELS:"tile-pixels",USFEET:"us-ft"},re={};re[Nt.RADIANS]=6370997/(2*Math.PI);re[Nt.DEGREES]=2*Math.PI*6370997/360;re[Nt.FEET]=.3048;re[Nt.METERS]=1;re[Nt.USFEET]=1200/3937;var Ba=(function(){function n(e){this.code_=e.code,this.units_=e.units,this.extent_=e.extent!==void 0?e.extent:null,this.worldExtent_=e.worldExtent!==void 0?e.worldExtent:null,this.axisOrientation_=e.axisOrientation!==void 0?e.axisOrientation:"enu",this.global_=e.global!==void 0?e.global:!1,this.canWrapX_=!!(this.global_&&this.extent_),this.getPointResolutionFunc_=e.getPointResolution,this.defaultTileGrid_=null,this.metersPerUnit_=e.metersPerUnit}return n.prototype.canWrapX=function(){return this.canWrapX_},n.prototype.getCode=function(){return this.code_},n.prototype.getExtent=function(){return this.extent_},n.prototype.getUnits=function(){return this.units_},n.prototype.getMetersPerUnit=function(){return this.metersPerUnit_||re[this.units_]},n.prototype.getWorldExtent=function(){return this.worldExtent_},n.prototype.getAxisOrientation=function(){return this.axisOrientation_},n.prototype.isGlobal=function(){return this.global_},n.prototype.setGlobal=function(e){this.global_=e,this.canWrapX_=!!(e&&this.extent_)},n.prototype.getDefaultTileGrid=function(){return this.defaultTileGrid_},n.prototype.setDefaultTileGrid=function(e){this.defaultTileGrid_=e},n.prototype.setExtent=function(e){this.extent_=e,this.canWrapX_=!!(this.global_&&e)},n.prototype.setWorldExtent=function(e){this.worldExtent_=e},n.prototype.setGetPointResolution=function(e){this.getPointResolutionFunc_=e},n.prototype.getPointResolutionFunc=function(){return this.getPointResolutionFunc_},n})(),ku=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Nn=6378137,xi=Math.PI*Nn,zu=[-xi,-xi,xi,xi],ju=[-180,-85,180,85],Qn=Nn*Math.log(Math.tan(Math.PI/2)),ci=(function(n){ku(e,n);function e(t){return n.call(this,{code:t,units:Nt.METERS,extent:zu,global:!0,worldExtent:ju,getPointResolution:function(i,r){return i/Cu(r[1]/Nn)}})||this}return e})(Ba),Do=[new ci("EPSG:3857"),new ci("EPSG:102100"),new ci("EPSG:102113"),new ci("EPSG:900913"),new ci("http://www.opengis.net/def/crs/EPSG/0/3857"),new ci("http://www.opengis.net/gml/srs/epsg.xml#3857")];function Uu(n,e,t){var i=n.length,r=t>1?t:2,a=e;a===void 0&&(r>2?a=n.slice():a=new Array(i));for(var o=0;o<i;o+=r){a[o]=xi*n[o]/180;var s=Nn*Math.log(Math.tan(Math.PI*(+n[o+1]+90)/360));s>Qn?s=Qn:s<-Qn&&(s=-Qn),a[o+1]=s}return a}function Bu(n,e,t){var i=n.length,r=t>1?t:2,a=e;a===void 0&&(r>2?a=n.slice():a=new Array(i));for(var o=0;o<i;o+=r)a[o]=180*n[o]/xi,a[o+1]=360*Math.atan(Math.exp(n[o+1]/Nn))/Math.PI-90;return a}var Wu=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Xu=6378137,Fo=[-180,-90,180,90],Yu=Math.PI*Xu/180,Xe=(function(n){Wu(e,n);function e(t,i){return n.call(this,{code:t,units:Nt.DEGREES,extent:Fo,axisOrientation:i,global:!0,metersPerUnit:Yu,worldExtent:Fo})||this}return e})(Ba),Go=[new Xe("CRS:84"),new Xe("EPSG:4326","neu"),new Xe("urn:ogc:def:crs:OGC:1.3:CRS84"),new Xe("urn:ogc:def:crs:OGC:2:84"),new Xe("http://www.opengis.net/def/crs/OGC/1.3/CRS84"),new Xe("http://www.opengis.net/gml/srs/epsg.xml#4326","neu"),new Xe("http://www.opengis.net/def/crs/EPSG/0/4326","neu")],Ea={};function Vu(n){return Ea[n]||Ea[n.replace(/urn:(x-)?ogc:def:crs:EPSG:(.*:)?(\w+)$/,"EPSG:$3")]||null}function qu(n,e){Ea[n]=e}var Ii={};function bi(n,e,t){var i=n.getCode(),r=e.getCode();i in Ii||(Ii[i]={}),Ii[i][r]=t}function rh(n,e){var t;return n in Ii&&e in Ii[n]&&(t=Ii[n][e]),t}const vt={UNKNOWN:0,INTERSECTING:1,ABOVE:2,RIGHT:4,BELOW:8,LEFT:16};function ko(n){for(var e=Wt(),t=0,i=n.length;t<i;++t)un(e,n[t]);return e}function Ku(n,e,t){var i=Math.min.apply(null,n),r=Math.min.apply(null,e),a=Math.max.apply(null,n),o=Math.max.apply(null,e);return ae(i,r,a,o,t)}function gn(n,e,t){return t?(t[0]=n[0]-e,t[1]=n[1]-e,t[2]=n[2]+e,t[3]=n[3]+e,t):[n[0]-e,n[1]-e,n[2]+e,n[3]+e]}function ah(n,e){return e?(e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e):n.slice()}function oh(n,e,t){var i,r;return e<n[0]?i=n[0]-e:n[2]<e?i=e-n[2]:i=0,t<n[1]?r=n[1]-t:n[3]<t?r=t-n[3]:r=0,i*i+r*r}function Ui(n,e){return sh(n,e[0],e[1])}function Pe(n,e){return n[0]<=e[0]&&e[2]<=n[2]&&n[1]<=e[1]&&e[3]<=n[3]}function sh(n,e,t){return n[0]<=e&&e<=n[2]&&n[1]<=t&&t<=n[3]}function Ma(n,e){var t=n[0],i=n[1],r=n[2],a=n[3],o=e[0],s=e[1],h=vt.UNKNOWN;return o<t?h=h|vt.LEFT:o>r&&(h=h|vt.RIGHT),s<i?h=h|vt.BELOW:s>a&&(h=h|vt.ABOVE),h===vt.UNKNOWN&&(h=vt.INTERSECTING),h}function Wt(){return[1/0,1/0,-1/0,-1/0]}function ae(n,e,t,i,r){return r?(r[0]=n,r[1]=e,r[2]=t,r[3]=i,r):[n,e,t,i]}function jr(n){return ae(1/0,1/0,-1/0,-1/0,n)}function $u(n,e){var t=n[0],i=n[1];return ae(t,i,t,i,e)}function Zu(n,e,t,i,r){var a=jr(r);return hh(a,n,e,t,i)}function Di(n,e){return n[0]==e[0]&&n[2]==e[2]&&n[1]==e[1]&&n[3]==e[3]}function Hu(n,e){return e[0]<n[0]&&(n[0]=e[0]),e[2]>n[2]&&(n[2]=e[2]),e[1]<n[1]&&(n[1]=e[1]),e[3]>n[3]&&(n[3]=e[3]),n}function un(n,e){e[0]<n[0]&&(n[0]=e[0]),e[0]>n[2]&&(n[2]=e[0]),e[1]<n[1]&&(n[1]=e[1]),e[1]>n[3]&&(n[3]=e[1])}function hh(n,e,t,i,r){for(;t<i;t+=r)Ju(n,e[t],e[t+1]);return n}function Ju(n,e,t){n[0]=Math.min(n[0],e),n[1]=Math.min(n[1],t),n[2]=Math.max(n[2],e),n[3]=Math.max(n[3],t)}function lh(n,e){var t;return t=e(Wa(n)),t||(t=e(Xa(n)),t)||(t=e(Ya(n)),t)||(t=e(oi(n)),t)?t:!1}function Ta(n){var e=0;return Ur(n)||(e=et(n)*Et(n)),e}function Wa(n){return[n[0],n[1]]}function Xa(n){return[n[2],n[1]]}function Ge(n){return[(n[0]+n[2])/2,(n[1]+n[3])/2]}function Qu(n,e){var t;return t=oi(n),t}function Si(n,e,t,i,r){var a=e*i[0]/2,o=e*i[1]/2,s=Math.cos(t),h=Math.sin(t),l=a*s,u=a*h,c=o*s,f=o*h,d=n[0],v=n[1],_=d-l+f,p=d-l-f,g=d+l-f,y=d+l+f,m=v-u-c,x=v-u+c,E=v+u+c,M=v+u-c;return ae(Math.min(_,p,g,y),Math.min(m,x,E,M),Math.max(_,p,g,y),Math.max(m,x,E,M),r)}function Et(n){return n[3]-n[1]}function Je(n,e,t){var i=t||Wt();return Ct(n,e)?(n[0]>e[0]?i[0]=n[0]:i[0]=e[0],n[1]>e[1]?i[1]=n[1]:i[1]=e[1],n[2]<e[2]?i[2]=n[2]:i[2]=e[2],n[3]<e[3]?i[3]=n[3]:i[3]=e[3]):jr(i),i}function oi(n){return[n[0],n[3]]}function Ya(n){return[n[2],n[3]]}function et(n){return n[2]-n[0]}function Ct(n,e){return n[0]<=e[2]&&n[2]>=e[0]&&n[1]<=e[3]&&n[3]>=e[1]}function Ur(n){return n[2]<n[0]||n[3]<n[1]}function tf(n,e){return e?(e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e):n}function ef(n,e,t){var i=!1,r=Ma(n,e),a=Ma(n,t);if(r===vt.INTERSECTING||a===vt.INTERSECTING)i=!0;else{var o=n[0],s=n[1],h=n[2],l=n[3],u=e[0],c=e[1],f=t[0],d=t[1],v=(d-c)/(f-u),_=void 0,p=void 0;a&vt.ABOVE&&!(r&vt.ABOVE)&&(_=f-(d-l)/v,i=_>=o&&_<=h),!i&&a&vt.RIGHT&&!(r&vt.RIGHT)&&(p=d-(f-h)*v,i=p>=s&&p<=l),!i&&a&vt.BELOW&&!(r&vt.BELOW)&&(_=f-(d-s)/v,i=_>=o&&_<=h),!i&&a&vt.LEFT&&!(r&vt.LEFT)&&(p=d-(f-o)*v,i=p>=s&&p<=l)}return i}function nf(n,e,t,i){var r=[],a;r=[n[0],n[1],n[2],n[1],n[2],n[3],n[0],n[3]],e(r,r,2);for(var o=[],s=[],a=0,h=r.length;a<h;a+=2)o.push(r[a]),s.push(r[a+1]);return Ku(o,s,t)}function rf(n,e){var t=e.getExtent(),i=Ge(n);if(e.canWrapX()&&(i[0]<t[0]||i[0]>=t[2])){var r=et(t),a=Math.floor((i[0]-t[0])/r),o=a*r;n[0]-=o,n[2]-=o}return n}function uh(n,e){for(var t=(""+n).split("."),i=(""+e).split("."),r=0;r<Math.max(t.length,i.length);r++){var a=parseInt(t[r]||"0",10),o=parseInt(i[r]||"0",10);if(a>o)return 1;if(o>a)return-1}return 0}function af(n,e){return n[0]+=+e[0],n[1]+=+e[1],n}function gr(n,e){for(var t=!0,i=n.length-1;i>=0;--i)if(n[i]!=e[i]){t=!1;break}return t}function Va(n,e){var t=Math.cos(e),i=Math.sin(e),r=n[0]*t-n[1]*i,a=n[1]*t+n[0]*i;return n[0]=r,n[1]=a,n}function of(n,e){return n[0]*=e,n[1]*=e,n}function fh(n,e){if(e.canWrapX()){var t=et(e.getExtent()),i=ch(n,e,t);i&&(n[0]-=i*t)}return n}function ch(n,e,t){var i=e.getExtent(),r=0;if(e.canWrapX()&&(n[0]<i[0]||n[0]>i[2])){var a=t||et(i);r=Math.floor((n[0]-i[0])/a)}return r}const W={POINT:"Point",LINE_STRING:"LineString",LINEAR_RING:"LinearRing",POLYGON:"Polygon",MULTI_POINT:"MultiPoint",MULTI_LINE_STRING:"MultiLineString",MULTI_POLYGON:"MultiPolygon",GEOMETRY_COLLECTION:"GeometryCollection",CIRCLE:"Circle"};var sf=63710088e-1;function zo(n,e,t){var i=sf,r=lr(n[1]),a=lr(e[1]),o=(a-r)/2,s=lr(e[0]-n[0])/2,h=Math.sin(o)*Math.sin(o)+Math.sin(s)*Math.sin(s)*Math.cos(r)*Math.cos(a);return 2*i*Math.atan2(Math.sqrt(h),Math.sqrt(1-h))}var Ca=!0;function hf(n){Ca=!1}function qa(n,e,t){var i;if(e!==void 0){for(var r=0,a=n.length;r<a;++r)e[r]=n[r];i=e}else i=n.slice();return i}function dh(n,e,t){if(e!==void 0&&n!==e){for(var i=0,r=n.length;i<r;++i)e[i]=n[i];n=e}return n}function vh(n){qu(n.getCode(),n),bi(n,n,qa)}function lf(n){n.forEach(vh)}function dt(n){return typeof n=="string"?Vu(n):n||null}function jo(n,e,t,i){n=dt(n);var r,a=n.getPointResolutionFunc();if(a){r=a(e,t);var o}else{var s=n.getUnits();if(s==Nt.DEGREES&&!i||i==Nt.DEGREES)r=e;else{var h=Br(n,dt("EPSG:4326"));if(h===dh&&s!==Nt.DEGREES)r=e*n.getMetersPerUnit();else{var l=[t[0]-e/2,t[1],t[0]+e/2,t[1],t[0],t[1]-e/2,t[0],t[1]+e/2];l=h(l,l,2);var u=zo(l.slice(0,2),l.slice(2,4)),c=zo(l.slice(4,6),l.slice(6,8));r=(u+c)/2}var o=n.getMetersPerUnit();o!==void 0&&(r/=o)}}return r}function Ra(n){lf(n),n.forEach(function(e){n.forEach(function(t){e!==t&&bi(e,t,qa)})})}function uf(n,e,t,i){n.forEach(function(r){e.forEach(function(a){bi(r,a,t),bi(a,r,i)})})}function Ka(n,e){return n?typeof n=="string"?dt(n):n:dt(e)}function Uo(n){return(function(e,t,i){for(var r=e.length,a=i!==void 0?i:2,o=t!==void 0?t:new Array(r),s=0;s<r;s+=a){var h=n([e[s],e[s+1]]);o[s]=h[0],o[s+1]=h[1];for(var l=a-1;l>=2;--l)o[s+l]=e[s+l]}return o})}function ff(n,e,t,i){var r=dt(n),a=dt(e);bi(r,a,Uo(t)),bi(a,r,Uo(i))}function Se(n,e){if(n===e)return!0;var t=n.getUnits()===e.getUnits();if(n.getCode()===e.getCode())return t;var i=Br(n,e);return i===qa&&t}function Br(n,e){var t=n.getCode(),i=e.getCode(),r=rh(t,i);return r||(r=dh),r}function yn(n,e){var t=dt(n),i=dt(e);return Br(t,i)}function bn(n,e,t){var i=yn(e,t);return i(n,void 0,n.length)}function $a(n,e,t,i){var r=yn(e,t);return nf(n,r,void 0)}var Xt=null;function _h(n){Xt=dt(n)}function ph(){return Xt}function wa(n,e){return Xt?bn(n,e,Xt):n}function fe(n,e){return Xt?bn(n,Xt,e):(Ca&&!gr(n,[0,0])&&n[0]>=-180&&n[0]<=180&&n[1]>=-90&&n[1]<=90&&(Ca=!1,console.warn("Call useGeographic() ol/proj once to work with [longitude, latitude] coordinates.")),n)}function Ia(n,e){return Xt?$a(n,e,Xt):n}function de(n,e){return Xt?$a(n,Xt,e):n}function cf(n,e){if(!Xt)return n;var t=dt(e).getUnits(),i=Xt.getUnits();return t&&i?n*re[t]/re[i]:n}function Bo(n,e,t){return function(i){var r=i[0],a=i[1],o,s;if(n.canWrapX()){var h=n.getExtent(),l=et(h);s=ch(i,n,l),s&&(r=r-s*l),r=ut(r,h[0],h[2]),a=ut(a,h[1],h[3]),o=t([r,a])}else o=t(i);return s&&e.canWrapX()&&(o[0]+=s*et(e.getExtent())),o}}function df(){Ra(Do),Ra(Go),uf(Go,Do,Uu,Bu)}df();new Array(6);function ie(){return[1,0,0,1,0,0]}function vf(n,e,t,i,r,a,o){return n[0]=e,n[1]=t,n[2]=i,n[3]=r,n[4]=a,n[5]=o,n}function _f(n,e){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n}function ft(n,e){var t=e[0],i=e[1];return e[0]=n[0]*t+n[2]*i+n[4],e[1]=n[1]*t+n[3]*i+n[5],e}function pf(n,e,t){return vf(n,e,0,0,t,0,0)}function $t(n,e,t,i,r,a,o,s){var h=Math.sin(a),l=Math.cos(a);return n[0]=i*l,n[1]=r*h,n[2]=-i*h,n[3]=r*l,n[4]=o*i*l-s*i*h+e,n[5]=o*r*h+s*r*l+t,n}function Wr(n,e){var t=gf(e);Y(t!==0,32);var i=e[0],r=e[1],a=e[2],o=e[3],s=e[4],h=e[5];return n[0]=o/t,n[1]=-r/t,n[2]=-a/t,n[3]=i/t,n[4]=(a*h-o*s)/t,n[5]=-(i*h-r*s)/t,n}function gf(n){return n[0]*n[3]-n[1]*n[2]}var Wo;function Za(n){var e="matrix("+n.join(", ")+")";if(kr)return e;var t=Wo||(Wo=document.createElement("div"));return t.style.transform=e,t.style.transform}var yf=/^#([a-f0-9]{3}|[a-f0-9]{4}(?:[a-f0-9]{2}){0,2})$/i,mf=/^([a-z]*)$|^hsla?\(.*\)$/i;function gh(n){return typeof n=="string"?n:yh(n)}function xf(n){var e=document.createElement("div");if(e.style.color=n,e.style.color!==""){document.body.appendChild(e);var t=getComputedStyle(e).color;return document.body.removeChild(e),t}else return""}var Ef=(function(){var n=1024,e={},t=0;return(function(i){var r;if(e.hasOwnProperty(i))r=e[i];else{if(t>=n){var a=0;for(var o in e)(a++&3)===0&&(delete e[o],--t)}r=Mf(i),e[i]=r,++t}return r})})();function yr(n){return Array.isArray(n)?n:Ef(n)}function Mf(n){var e,t,i,r,a;if(mf.exec(n)&&(n=xf(n)),yf.exec(n)){var o=n.length-1,s=void 0;o<=4?s=1:s=2;var h=o===4||o===8;e=parseInt(n.substr(1+0*s,s),16),t=parseInt(n.substr(1+1*s,s),16),i=parseInt(n.substr(1+2*s,s),16),h?r=parseInt(n.substr(1+3*s,s),16):r=255,s==1&&(e=(e<<4)+e,t=(t<<4)+t,i=(i<<4)+i,h&&(r=(r<<4)+r)),a=[e,t,i,r/255]}else n.indexOf("rgba(")==0?(a=n.slice(5,-1).split(",").map(Number),Xo(a)):n.indexOf("rgb(")==0?(a=n.slice(4,-1).split(",").map(Number),a.push(1),Xo(a)):Y(!1,14);return a}function Xo(n){return n[0]=ut(n[0]+.5|0,0,255),n[1]=ut(n[1]+.5|0,0,255),n[2]=ut(n[2]+.5|0,0,255),n[3]=ut(n[3],0,1),n}function yh(n){var e=n[0];e!=(e|0)&&(e=e+.5|0);var t=n[1];t!=(t|0)&&(t=t+.5|0);var i=n[2];i!=(i|0)&&(i=i+.5|0);var r=n[3]===void 0?1:Math.round(n[3]*100)/100;return"rgba("+e+","+t+","+i+","+r+")"}var Tf=(function(){function n(){this.cache_={},this.cacheSize_=0,this.maxCacheSize_=32}return n.prototype.clear=function(){this.cache_={},this.cacheSize_=0},n.prototype.canExpireCache=function(){return this.cacheSize_>this.maxCacheSize_},n.prototype.expire=function(){if(this.canExpireCache()){var e=0;for(var t in this.cache_){var i=this.cache_[t];(e++&3)===0&&!i.hasListener()&&(delete this.cache_[t],--this.cacheSize_)}}},n.prototype.get=function(e,t,i){var r=Yo(e,t,i);return r in this.cache_?this.cache_[r]:null},n.prototype.set=function(e,t,i,r){var a=Yo(e,t,i);this.cache_[a]=r,++this.cacheSize_},n.prototype.setSize=function(e){this.maxCacheSize_=e,this.expire()},n})();function Yo(n,e,t){var i=t?gh(t):"null";return e+":"+n+":"+i}var mr=new Tf,Cf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Rf=(function(n){Cf(e,n);function e(t){var i=n.call(this)||this;return i.map_=t,i}return e.prototype.dispatchRenderEvent=function(t,i){q()},e.prototype.calculateMatrices2D=function(t){var i=t.viewState,r=t.coordinateToPixelTransform,a=t.pixelToCoordinateTransform;$t(r,t.size[0]/2,t.size[1]/2,1/i.resolution,-1/i.resolution,-i.rotation,-i.center[0],-i.center[1]),Wr(a,r)},e.prototype.forEachFeatureAtCoordinate=function(t,i,r,a,o,s,h,l){var u,c=i.viewState;function f(N,G,D,K){return o.call(s,G,N?D:null,K)}var d=c.projection,v=fh(t.slice(),d),_=[[0,0]];if(d.canWrapX()&&a){var p=d.getExtent(),g=et(p);_.push([-g,0],[g,0])}for(var y=i.layerStatesArray,m=y.length,x=[],E=[],M=0;M<_.length;M++)for(var C=m-1;C>=0;--C){var T=y[C],I=T.layer;if(I.hasRenderer()&&pr(T,c)&&h.call(l,I)){var A=I.getRenderer(),P=I.getSource();if(A&&P){var b=P.getWrapX()?v:t,L=f.bind(null,T.managed);E[0]=b[0]+_[M][0],E[1]=b[1]+_[M][1],u=A.forEachFeatureAtCoordinate(E,i,r,L,x)}if(u)return u}}if(x.length!==0){var j=1/x.length;return x.forEach(function(N,G){return N.distanceSq+=G*j}),x.sort(function(N,G){return N.distanceSq-G.distanceSq}),x.some(function(N){return u=N.callback(N.feature,N.layer,N.geometry)}),u}},e.prototype.forEachLayerAtPixel=function(t,i,r,a,o){return q()},e.prototype.hasFeatureAtCoordinate=function(t,i,r,a,o,s){var h=this.forEachFeatureAtCoordinate(t,i,r,a,De,this,o,s);return h!==void 0},e.prototype.getMap=function(){return this.map_},e.prototype.renderFrame=function(t){q()},e.prototype.scheduleExpireIconCache=function(t){mr.canExpireCache()&&t.postRenderFunctions.push(wf)},e})(ka);function wf(n,e){mr.expire()}var If=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),mh=(function(n){If(e,n);function e(t,i,r,a){var o=n.call(this,t)||this;return o.inversePixelTransform=i,o.frameState=r,o.context=a,o}return e})(Zt),xh="10px sans-serif",ve="#000",xr="round",mn=[],xn=0,Fi="round",En=10,Mn="#000",Tn="center",Er="middle",Ke=[0,0,0,0],Cn=1,ce=new se,Sf=new zi;Sf.setSize=function(){console.warn("labelCache is deprecated.")};var pi=null,Sa,Oa={},Of=(function(){var n=100,e="32px ",t=["monospace","serif"],i=t.length,r="wmytzilWMYTZIL@#/&?$%10",a,o;function s(l,u,c){for(var f=!0,d=0;d<i;++d){var v=t[d];if(o=Mr(l+" "+u+" "+e+v,r),c!=v){var _=Mr(l+" "+u+" "+e+c+","+v,r);f=f&&_!=o}}return!!f}function h(){for(var l=!0,u=ce.getKeys(),c=0,f=u.length;c<f;++c){var d=u[c];ce.get(d)<n&&(s.apply(this,d.split(`
`))?(An(Oa),pi=null,Sa=void 0,ce.set(d,n)):(ce.set(d,ce.get(d)+1,!0),l=!1))}l&&(clearInterval(a),a=void 0)}return function(l){var u=Js(l);if(u)for(var c=u.families,f=0,d=c.length;f<d;++f){var v=c[f],_=u.style+`
`+u.weight+`
`+v;ce.get(_)===void 0&&(ce.set(_,n,!0),s(u.style,u.weight,v)||(ce.set(_,0,!0),a===void 0&&(a=setInterval(h,32))))}}})(),Af=(function(){var n;return function(e){var t=Oa[e];if(t==null){if(kr){var i=Js(e),r=Eh(e,"Žg"),a=isNaN(Number(i.lineHeight))?1.2:Number(i.lineHeight);t=a*(r.actualBoundingBoxAscent+r.actualBoundingBoxDescent)}else n||(n=document.createElement("div"),n.innerHTML="M",n.style.minHeight="0",n.style.maxHeight="none",n.style.height="auto",n.style.padding="0",n.style.border="none",n.style.position="absolute",n.style.display="block",n.style.left="-99999px"),n.style.font=e,document.body.appendChild(n),t=n.offsetHeight,document.body.removeChild(n);Oa[e]=t}return t}})();function Eh(n,e){return pi||(pi=Bt(1,1)),n!=Sa&&(pi.font=n,Sa=pi.font),pi.measureText(e)}function Mr(n,e){return Eh(n,e).width}function Vo(n,e,t){if(e in t)return t[e];var i=Mr(n,e);return t[e]=i,i}function Pf(n,e){for(var t=[],i=[],r=[],a=0,o=0,s=0,h=0,l=0,u=e.length;l<=u;l+=2){var c=e[l];if(c===`
`||l===u){a=Math.max(a,o),r.push(o),o=0,s+=h;continue}var f=e[l+1]||n.font,d=Mr(f,c);t.push(d),o+=d;var v=Af(f);i.push(v),h=Math.max(h,v)}return{width:a,height:s,widths:t,heights:i,lineWidths:r}}function Lf(n,e,t,i,r,a,o,s,h,l,u){n.save(),t!==1&&(n.globalAlpha*=t),e&&n.setTransform.apply(n,e),i.contextInstructions?(n.translate(h,l),n.scale(u[0],u[1]),Nf(i,n)):u[0]<0||u[1]<0?(n.translate(h,l),n.scale(u[0],u[1]),n.drawImage(i,r,a,o,s,0,0,o,s)):n.drawImage(i,r,a,o,s,h,l,o*u[0],s*u[1]),n.restore()}function Nf(n,e){for(var t=n.contextInstructions,i=0,r=t.length;i<r;i+=2)Array.isArray(t[i+1])?e[t[i]].apply(e,t[i+1]):e[t[i]]=t[i+1]}var bf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Df=(function(n){bf(e,n);function e(t){var i=n.call(this,t)||this;i.fontChangeListenerKey_=Z(ce,Pi.PROPERTYCHANGE,t.redrawText.bind(t)),i.element_=document.createElement("div");var r=i.element_.style;r.position="absolute",r.width="100%",r.height="100%",r.zIndex="0",i.element_.className=zr+" ol-layers";var a=t.getViewport();return a.insertBefore(i.element_,a.firstChild||null),i.children_=[],i.renderedVisible_=!0,i}return e.prototype.dispatchRenderEvent=function(t,i){var r=this.getMap();if(r.hasListener(t)){var a=new mh(t,void 0,i);r.dispatchEvent(a)}},e.prototype.disposeInternal=function(){rt(this.fontChangeListenerKey_),this.element_.parentNode.removeChild(this.element_),n.prototype.disposeInternal.call(this)},e.prototype.renderFrame=function(t){if(!t){this.renderedVisible_&&(this.element_.style.display="none",this.renderedVisible_=!1);return}this.calculateMatrices2D(t),this.dispatchRenderEvent(ei.PRECOMPOSE,t);var i=t.layerStatesArray.sort(function(d,v){return d.zIndex-v.zIndex}),r=t.viewState;this.children_.length=0;for(var a=[],o=null,s=0,h=i.length;s<h;++s){var l=i[s];t.layerIndex=s;var u=l.layer,c=u.getSourceState();if(!pr(l,r)||c!=ii.READY&&c!=ii.UNDEFINED){u.unrender();continue}var f=u.render(t,o);f&&(f!==o&&(this.children_.push(f),o=f),"getDeclutter"in u&&a.push(u))}for(var s=a.length-1;s>=0;--s)a[s].renderDeclutter(t);xu(this.element_,this.children_),this.dispatchRenderEvent(ei.POSTCOMPOSE,t),this.renderedVisible_||(this.element_.style.display="",this.renderedVisible_=!0),this.scheduleExpireIconCache(t)},e.prototype.forEachLayerAtPixel=function(t,i,r,a,o){for(var s=i.viewState,h=i.layerStatesArray,l=h.length,u=l-1;u>=0;--u){var c=h[u],f=c.layer;if(f.hasRenderer()&&pr(c,s)&&o(f)){var d=f.getRenderer(),v=d.getDataAtPixel(t,i,r);if(v){var _=a(f,v);if(_)return _}}}},e})(Rf),Mh=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),we=(function(n){Mh(e,n);function e(t,i){var r=n.call(this,t)||this;return r.layer=i,r}return e})(Zt),Qr={LAYERS:"layers"},Xr=(function(n){Mh(e,n);function e(t){var i=this,r=t||{},a=it({},r);delete a.layers;var o=r.layers;return i=n.call(this,a)||this,i.on,i.once,i.un,i.layersListenerKeys_=[],i.listenerKeys_={},i.addChangeListener(Qr.LAYERS,i.handleLayersChanged_),o?Array.isArray(o)?o=new xt(o.slice(),{unique:!0}):Y(typeof o.getArray=="function",43):o=new xt(void 0,{unique:!0}),i.setLayers(o),i}return e.prototype.handleLayerChange_=function(){this.changed()},e.prototype.handleLayersChanged_=function(){this.layersListenerKeys_.forEach(rt),this.layersListenerKeys_.length=0;var t=this.getLayers();this.layersListenerKeys_.push(Z(t,Pt.ADD,this.handleLayersAdd_,this),Z(t,Pt.REMOVE,this.handleLayersRemove_,this));for(var i in this.listenerKeys_)this.listenerKeys_[i].forEach(rt);An(this.listenerKeys_);for(var r=t.getArray(),a=0,o=r.length;a<o;a++){var s=r[a];this.registerLayerListeners_(s),this.dispatchEvent(new we("addlayer",s))}this.changed()},e.prototype.registerLayerListeners_=function(t){var i=[Z(t,Pi.PROPERTYCHANGE,this.handleLayerChange_,this),Z(t,B.CHANGE,this.handleLayerChange_,this)];t instanceof e&&i.push(Z(t,"addlayer",this.handleLayerGroupAdd_,this),Z(t,"removelayer",this.handleLayerGroupRemove_,this)),this.listenerKeys_[H(t)]=i},e.prototype.handleLayerGroupAdd_=function(t){this.dispatchEvent(new we("addlayer",t.layer))},e.prototype.handleLayerGroupRemove_=function(t){this.dispatchEvent(new we("removelayer",t.layer))},e.prototype.handleLayersAdd_=function(t){var i=t.element;this.registerLayerListeners_(i),this.dispatchEvent(new we("addlayer",i)),this.changed()},e.prototype.handleLayersRemove_=function(t){var i=t.element,r=H(i);this.listenerKeys_[r].forEach(rt),delete this.listenerKeys_[r],this.dispatchEvent(new we("removelayer",i)),this.changed()},e.prototype.getLayers=function(){return this.get(Qr.LAYERS)},e.prototype.setLayers=function(t){var i=this.getLayers();if(i)for(var r=i.getArray(),a=0,o=r.length;a<o;++a)this.dispatchEvent(new we("removelayer",r[a]));this.set(Qr.LAYERS,t)},e.prototype.getLayersArray=function(t){var i=t!==void 0?t:[];return this.getLayers().forEach(function(r){r.getLayersArray(i)}),i},e.prototype.getLayerStatesArray=function(t){var i=t!==void 0?t:[],r=i.length;this.getLayers().forEach(function(u){u.getLayerStatesArray(i)});var a=this.getLayerState(),o=a.zIndex;!t&&a.zIndex===void 0&&(o=0);for(var s=r,h=i.length;s<h;s++){var l=i[s];l.opacity*=a.opacity,l.visible=l.visible&&a.visible,l.maxResolution=Math.min(l.maxResolution,a.maxResolution),l.minResolution=Math.max(l.minResolution,a.minResolution),l.minZoom=Math.max(l.minZoom,a.minZoom),l.maxZoom=Math.min(l.maxZoom,a.maxZoom),a.extent!==void 0&&(l.extent!==void 0?l.extent=Je(l.extent,a.extent):l.extent=a.extent),l.zIndex===void 0&&(l.zIndex=o)}return i},e.prototype.getSourceState=function(){return ii.READY},e})(eh),Ff=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ur=(function(n){Ff(e,n);function e(t,i,r){var a=n.call(this,t)||this;return a.map=i,a.frameState=r!==void 0?r:null,a}return e})(Zt),Gf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Re=(function(n){Gf(e,n);function e(t,i,r,a,o){var s=n.call(this,t,i,o)||this;return s.originalEvent=r,s.pixel_=null,s.coordinate_=null,s.dragging=a!==void 0?a:!1,s}return Object.defineProperty(e.prototype,"pixel",{get:function(){return this.pixel_||(this.pixel_=this.map.getEventPixel(this.originalEvent)),this.pixel_},set:function(t){this.pixel_=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"coordinate",{get:function(){return this.coordinate_||(this.coordinate_=this.map.getCoordinateFromPixel(this.pixel)),this.coordinate_},set:function(t){this.coordinate_=t},enumerable:!1,configurable:!0}),e.prototype.preventDefault=function(){n.prototype.preventDefault.call(this),"preventDefault"in this.originalEvent&&this.originalEvent.preventDefault()},e.prototype.stopPropagation=function(){n.prototype.stopPropagation.call(this),"stopPropagation"in this.originalEvent&&this.originalEvent.stopPropagation()},e})(ur);const nt={SINGLECLICK:"singleclick",CLICK:B.CLICK,DBLCLICK:B.DBLCLICK,POINTERDRAG:"pointerdrag",POINTERMOVE:"pointermove",POINTERDOWN:"pointerdown",POINTERUP:"pointerup",POINTEROVER:"pointerover",POINTEROUT:"pointerout",POINTERENTER:"pointerenter",POINTERLEAVE:"pointerleave",POINTERCANCEL:"pointercancel"};var kf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),zf=(function(n){kf(e,n);function e(t,i){var r=n.call(this,t)||this;r.map_=t,r.clickTimeoutId_,r.emulateClicks_=!1,r.dragging_=!1,r.dragListenerKeys_=[],r.moveTolerance_=i===void 0?1:i,r.down_=null;var a=r.map_.getViewport();return r.activePointers_=0,r.trackedTouches_={},r.element_=a,r.pointerdownListenerKey_=Z(a,xa.POINTERDOWN,r.handlePointerDown_,r),r.originalPointerMoveEvent_,r.relayedListenerKey_=Z(a,xa.POINTERMOVE,r.relayEvent_,r),r.boundHandleTouchMove_=r.handleTouchMove_.bind(r),r.element_.addEventListener(B.TOUCHMOVE,r.boundHandleTouchMove_,Hs?{passive:!1}:!1),r}return e.prototype.emulateClick_=function(t){var i=new Re(nt.CLICK,this.map_,t);this.dispatchEvent(i),this.clickTimeoutId_!==void 0?(clearTimeout(this.clickTimeoutId_),this.clickTimeoutId_=void 0,i=new Re(nt.DBLCLICK,this.map_,t),this.dispatchEvent(i)):this.clickTimeoutId_=setTimeout((function(){this.clickTimeoutId_=void 0;var r=new Re(nt.SINGLECLICK,this.map_,t);this.dispatchEvent(r)}).bind(this),250)},e.prototype.updateActivePointers_=function(t){var i=t;i.type==nt.POINTERUP||i.type==nt.POINTERCANCEL?delete this.trackedTouches_[i.pointerId]:i.type==nt.POINTERDOWN&&(this.trackedTouches_[i.pointerId]=!0),this.activePointers_=Object.keys(this.trackedTouches_).length},e.prototype.handlePointerUp_=function(t){this.updateActivePointers_(t);var i=new Re(nt.POINTERUP,this.map_,t);this.dispatchEvent(i),this.emulateClicks_&&!i.defaultPrevented&&!this.dragging_&&this.isMouseActionButton_(t)&&this.emulateClick_(this.down_),this.activePointers_===0&&(this.dragListenerKeys_.forEach(rt),this.dragListenerKeys_.length=0,this.dragging_=!1,this.down_=null)},e.prototype.isMouseActionButton_=function(t){return t.button===0},e.prototype.handlePointerDown_=function(t){this.emulateClicks_=this.activePointers_===0,this.updateActivePointers_(t);var i=new Re(nt.POINTERDOWN,this.map_,t);this.dispatchEvent(i),this.down_={};for(var r in t){var a=t[r];this.down_[r]=typeof a=="function"?ti:a}if(this.dragListenerKeys_.length===0){var o=this.map_.getOwnerDocument();this.dragListenerKeys_.push(Z(o,nt.POINTERMOVE,this.handlePointerMove_,this),Z(o,nt.POINTERUP,this.handlePointerUp_,this),Z(this.element_,nt.POINTERCANCEL,this.handlePointerUp_,this)),this.element_.getRootNode&&this.element_.getRootNode()!==o&&this.dragListenerKeys_.push(Z(this.element_.getRootNode(),nt.POINTERUP,this.handlePointerUp_,this))}},e.prototype.handlePointerMove_=function(t){if(this.isMoving_(t)){this.dragging_=!0;var i=new Re(nt.POINTERDRAG,this.map_,t,this.dragging_);this.dispatchEvent(i)}},e.prototype.relayEvent_=function(t){this.originalPointerMoveEvent_=t;var i=!!(this.down_&&this.isMoving_(t));this.dispatchEvent(new Re(t.type,this.map_,t,i))},e.prototype.handleTouchMove_=function(t){var i=this.originalPointerMoveEvent_;(!i||i.defaultPrevented)&&(typeof t.cancelable!="boolean"||t.cancelable===!0)&&t.preventDefault()},e.prototype.isMoving_=function(t){return this.dragging_||Math.abs(t.clientX-this.down_.clientX)>this.moveTolerance_||Math.abs(t.clientY-this.down_.clientY)>this.moveTolerance_},e.prototype.disposeInternal=function(){this.relayedListenerKey_&&(rt(this.relayedListenerKey_),this.relayedListenerKey_=null),this.element_.removeEventListener(B.TOUCHMOVE,this.boundHandleTouchMove_),this.pointerdownListenerKey_&&(rt(this.pointerdownListenerKey_),this.pointerdownListenerKey_=null),this.dragListenerKeys_.forEach(rt),this.dragListenerKeys_.length=0,this.element_=null,n.prototype.disposeInternal.call(this)},e})(zi),Tr=1/0,jf=(function(){function n(e,t){this.priorityFunction_=e,this.keyFunction_=t,this.elements_=[],this.priorities_=[],this.queuedElements_={}}return n.prototype.clear=function(){this.elements_.length=0,this.priorities_.length=0,An(this.queuedElements_)},n.prototype.dequeue=function(){var e=this.elements_,t=this.priorities_,i=e[0];e.length==1?(e.length=0,t.length=0):(e[0]=e.pop(),t[0]=t.pop(),this.siftUp_(0));var r=this.keyFunction_(i);return delete this.queuedElements_[r],i},n.prototype.enqueue=function(e){Y(!(this.keyFunction_(e)in this.queuedElements_),31);var t=this.priorityFunction_(e);return t!=Tr?(this.elements_.push(e),this.priorities_.push(t),this.queuedElements_[this.keyFunction_(e)]=!0,this.siftDown_(0,this.elements_.length-1),!0):!1},n.prototype.getCount=function(){return this.elements_.length},n.prototype.getLeftChildIndex_=function(e){return e*2+1},n.prototype.getRightChildIndex_=function(e){return e*2+2},n.prototype.getParentIndex_=function(e){return e-1>>1},n.prototype.heapify_=function(){var e;for(e=(this.elements_.length>>1)-1;e>=0;e--)this.siftUp_(e)},n.prototype.isEmpty=function(){return this.elements_.length===0},n.prototype.isKeyQueued=function(e){return e in this.queuedElements_},n.prototype.isQueued=function(e){return this.isKeyQueued(this.keyFunction_(e))},n.prototype.siftUp_=function(e){for(var t=this.elements_,i=this.priorities_,r=t.length,a=t[e],o=i[e],s=e;e<r>>1;){var h=this.getLeftChildIndex_(e),l=this.getRightChildIndex_(e),u=l<r&&i[l]<i[h]?l:h;t[e]=t[u],i[e]=i[u],e=u}t[e]=a,i[e]=o,this.siftDown_(s,e)},n.prototype.siftDown_=function(e,t){for(var i=this.elements_,r=this.priorities_,a=i[t],o=r[t];t>e;){var s=this.getParentIndex_(t);if(r[s]>o)i[t]=i[s],r[t]=r[s],t=s;else break}i[t]=a,r[t]=o},n.prototype.reprioritize=function(){var e=this.priorityFunction_,t=this.elements_,i=this.priorities_,r=0,a=t.length,o,s,h;for(s=0;s<a;++s)o=t[s],h=e(o),h==Tr?delete this.queuedElements_[this.keyFunction_(o)]:(i[r]=h,t[r++]=o);t.length=r,i.length=r,this.heapify_()},n})();const k={IDLE:0,LOADING:1,LOADED:2,ERROR:3,EMPTY:4};var Uf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Bf=(function(n){Uf(e,n);function e(t,i){var r=n.call(this,function(a){return t.apply(null,a)},function(a){return a[0].getKey()})||this;return r.boundHandleTileChange_=r.handleTileChange.bind(r),r.tileChangeCallback_=i,r.tilesLoading_=0,r.tilesLoadingKeys_={},r}return e.prototype.enqueue=function(t){var i=n.prototype.enqueue.call(this,t);if(i){var r=t[0];r.addEventListener(B.CHANGE,this.boundHandleTileChange_)}return i},e.prototype.getTilesLoading=function(){return this.tilesLoading_},e.prototype.handleTileChange=function(t){var i=t.target,r=i.getState();if(r===k.LOADED||r===k.ERROR||r===k.EMPTY){i.removeEventListener(B.CHANGE,this.boundHandleTileChange_);var a=i.getKey();a in this.tilesLoadingKeys_&&(delete this.tilesLoadingKeys_[a],--this.tilesLoading_),this.tileChangeCallback_()}},e.prototype.loadMoreTiles=function(t,i){for(var r=0,a,o,s;this.tilesLoading_<t&&r<i&&this.getCount()>0;)o=this.dequeue()[0],s=o.getKey(),a=o.getState(),a===k.IDLE&&!(s in this.tilesLoadingKeys_)&&(this.tilesLoadingKeys_[s]=!0,++this.tilesLoading_,++r,o.load())},e})(jf);function Wf(n,e,t,i,r){if(!n||!(t in n.wantedTiles)||!n.wantedTiles[t][e.getKey()])return Tr;var a=n.viewState.center,o=i[0]-a[0],s=i[1]-a[1];return 65536*Math.log(r)+Math.sqrt(o*o+s*s)/r}const _t={ANIMATING:0,INTERACTING:1},Yt={CENTER:"center",RESOLUTION:"resolution",ROTATION:"rotation"};var Xf=42,Ha=256;function qo(n,e,t){return(function(i,r,a,o,s){if(i){if(!r&&!e)return i;var h=e?0:a[0]*r,l=e?0:a[1]*r,u=s?s[0]:0,c=s?s[1]:0,f=n[0]+h/2+u,d=n[2]-h/2+u,v=n[1]+l/2+c,_=n[3]-l/2+c;f>d&&(f=(d+f)/2,d=f),v>_&&(v=(_+v)/2,_=v);var p=ut(i[0],f,d),g=ut(i[1],v,_);if(o&&t&&r){var y=30*r;p+=-y*Math.log(1+Math.max(0,f-i[0])/y)+y*Math.log(1+Math.max(0,i[0]-d)/y),g+=-y*Math.log(1+Math.max(0,v-i[1])/y)+y*Math.log(1+Math.max(0,i[1]-_)/y)}return[p,g]}})}function Yf(n){return n}function Ja(n,e,t,i){var r=et(e)/t[0],a=Et(e)/t[1];return i?Math.min(n,Math.max(r,a)):Math.min(n,Math.min(r,a))}function Qa(n,e,t){var i=Math.min(n,e),r=50;return i*=Math.log(1+r*Math.max(0,n/e-1))/r+1,t&&(i=Math.max(i,t),i/=Math.log(1+r*Math.max(0,t/n-1))/r+1),ut(i,t/2,e*2)}function Vf(n,e,t,i){return(function(r,a,o,s){if(r!==void 0){var h=n[0],l=n[n.length-1],u=t?Ja(h,t,o,i):h;if(s){var c=e!==void 0?e:!0;return c?Qa(r,u,l):ut(r,l,u)}var f=Math.min(u,r),d=Math.floor(Fr(n,f,a));return n[d]>u&&d<n.length-1?n[d+1]:n[d]}else return})}function qf(n,e,t,i,r,a){return(function(o,s,h,l){if(o!==void 0){var u=r?Ja(e,r,h,a):e,c=t!==void 0?t:0;if(l){var f=i!==void 0?i:!0;return f?Qa(o,u,c):ut(o,c,u)}var d=1e-9,v=Math.ceil(Math.log(e/u)/Math.log(n)-d),_=-s*(.5-d)+.5,p=Math.min(u,o),g=Math.floor(Math.log(e/p)/Math.log(n)+_),y=Math.max(v,g),m=e/Math.pow(n,y);return ut(m,c,u)}else return})}function Ko(n,e,t,i,r){return(function(a,o,s,h){if(a!==void 0){var l=i?Ja(n,i,s,r):n,u=t!==void 0?t:!0;return!u||!h?ut(a,e,l):Qa(a,l,e)}else return})}function to(n){if(n!==void 0)return 0}function $o(n){if(n!==void 0)return n}function Kf(n){var e=2*Math.PI/n;return(function(t,i){if(i)return t;if(t!==void 0)return t=Math.floor(t/e+.5)*e,t})}function $f(n){var e=lr(5);return(function(t,i){if(i)return t;if(t!==void 0)return Math.abs(t)<=e?0:t})}const kt={XY:"XY",XYZ:"XYZ",XYM:"XYM",XYZM:"XYZM"};function Qe(n,e,t,i,r,a){for(var o=a||[],s=0,h=e;h<t;h+=i){var l=n[h],u=n[h+1];o[s++]=r[0]*l+r[2]*u+r[4],o[s++]=r[1]*l+r[3]*u+r[5]}return a&&o.length!=s&&(o.length=s),o}function Th(n,e,t,i,r,a,o){for(var s=o||[],h=Math.cos(r),l=Math.sin(r),u=a[0],c=a[1],f=0,d=e;d<t;d+=i){var v=n[d]-u,_=n[d+1]-c;s[f++]=u+v*h-_*l,s[f++]=c+v*l+_*h;for(var p=d+2;p<d+i;++p)s[f++]=n[p]}return o&&s.length!=f&&(s.length=f),s}function Zf(n,e,t,i,r,a,o,s){for(var h=s||[],l=o[0],u=o[1],c=0,f=e;f<t;f+=i){var d=n[f]-l,v=n[f+1]-u;h[c++]=l+r*d,h[c++]=u+a*v;for(var _=f+2;_<f+i;++_)h[c++]=n[_]}return s&&h.length!=c&&(h.length=c),h}function Hf(n,e,t,i,r,a,o){for(var s=o||[],h=0,l=e;l<t;l+=i){s[h++]=n[l]+r,s[h++]=n[l+1]+a;for(var u=l+2;u<l+i;++u)s[h++]=n[u]}return o&&s.length!=h&&(s.length=h),s}var Jf=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Zo=ie(),Qf=(function(n){Jf(e,n);function e(){var t=n.call(this)||this;return t.extent_=Wt(),t.extentRevision_=-1,t.simplifiedGeometryMaxMinSquaredTolerance=0,t.simplifiedGeometryRevision=0,t.simplifyTransformedInternal=lu(function(i,r,a){if(!a)return this.getSimplifiedGeometry(r);var o=this.clone();return o.applyTransform(a),o.getSimplifiedGeometry(r)}),t}return e.prototype.simplifyTransformed=function(t,i){return this.simplifyTransformedInternal(this.getRevision(),t,i)},e.prototype.clone=function(){return q()},e.prototype.closestPointXY=function(t,i,r,a){return q()},e.prototype.containsXY=function(t,i){var r=this.getClosestPoint([t,i]);return r[0]===t&&r[1]===i},e.prototype.getClosestPoint=function(t,i){var r=i||[NaN,NaN];return this.closestPointXY(t[0],t[1],r,1/0),r},e.prototype.intersectsCoordinate=function(t){return this.containsXY(t[0],t[1])},e.prototype.computeExtent=function(t){return q()},e.prototype.getExtent=function(t){if(this.extentRevision_!=this.getRevision()){var i=this.computeExtent(this.extent_);(isNaN(i[0])||isNaN(i[1]))&&jr(i),this.extentRevision_=this.getRevision()}return tf(this.extent_,t)},e.prototype.rotate=function(t,i){q()},e.prototype.scale=function(t,i,r){q()},e.prototype.simplify=function(t){return this.getSimplifiedGeometry(t*t)},e.prototype.getSimplifiedGeometry=function(t){return q()},e.prototype.getType=function(){return q()},e.prototype.applyTransform=function(t){q()},e.prototype.intersectsExtent=function(t){return q()},e.prototype.translate=function(t,i){q()},e.prototype.transform=function(t,i){var r=dt(t),a=r.getUnits()==Nt.TILE_PIXELS?function(o,s,h){var l=r.getExtent(),u=r.getWorldExtent(),c=Et(u)/Et(l);return $t(Zo,u[0],u[3],c,-c,0,0,0),Qe(o,0,o.length,h,Zo,s),yn(r,i)(o,s,h)}:yn(r,i);return this.applyTransform(a),this},e})(se),tc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),eo=(function(n){tc(e,n);function e(){var t=n.call(this)||this;return t.layout=kt.XY,t.stride=2,t.flatCoordinates=null,t}return e.prototype.computeExtent=function(t){return Zu(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,t)},e.prototype.getCoordinates=function(){return q()},e.prototype.getFirstCoordinate=function(){return this.flatCoordinates.slice(0,this.stride)},e.prototype.getFlatCoordinates=function(){return this.flatCoordinates},e.prototype.getLastCoordinate=function(){return this.flatCoordinates.slice(this.flatCoordinates.length-this.stride)},e.prototype.getLayout=function(){return this.layout},e.prototype.getSimplifiedGeometry=function(t){if(this.simplifiedGeometryRevision!==this.getRevision()&&(this.simplifiedGeometryMaxMinSquaredTolerance=0,this.simplifiedGeometryRevision=this.getRevision()),t<0||this.simplifiedGeometryMaxMinSquaredTolerance!==0&&t<=this.simplifiedGeometryMaxMinSquaredTolerance)return this;var i=this.getSimplifiedGeometryInternal(t),r=i.getFlatCoordinates();return r.length<this.flatCoordinates.length?i:(this.simplifiedGeometryMaxMinSquaredTolerance=t,this)},e.prototype.getSimplifiedGeometryInternal=function(t){return this},e.prototype.getStride=function(){return this.stride},e.prototype.setFlatCoordinates=function(t,i){this.stride=Ho(t),this.layout=t,this.flatCoordinates=i},e.prototype.setCoordinates=function(t,i){q()},e.prototype.setLayout=function(t,i,r){var a;if(t)a=Ho(t);else{for(var o=0;o<r;++o)if(i.length===0){this.layout=kt.XY,this.stride=2;return}else i=i[0];a=i.length,t=ec(a)}this.layout=t,this.stride=a},e.prototype.applyTransform=function(t){this.flatCoordinates&&(t(this.flatCoordinates,this.flatCoordinates,this.stride),this.changed())},e.prototype.rotate=function(t,i){var r=this.getFlatCoordinates();if(r){var a=this.getStride();Th(r,0,r.length,a,t,i,r),this.changed()}},e.prototype.scale=function(t,i,r){var a=i;a===void 0&&(a=t);var o=r;o||(o=Ge(this.getExtent()));var s=this.getFlatCoordinates();if(s){var h=this.getStride();Zf(s,0,s.length,h,t,a,o,s),this.changed()}},e.prototype.translate=function(t,i){var r=this.getFlatCoordinates();if(r){var a=this.getStride();Hf(r,0,r.length,a,t,i,r),this.changed()}},e})(Qf);function ec(n){var e;return n==2?e=kt.XY:n==3?e=kt.XYZ:n==4&&(e=kt.XYZM),e}function Ho(n){var e;return n==kt.XY?e=2:n==kt.XYZ||n==kt.XYM?e=3:n==kt.XYZM&&(e=4),e}function ic(n,e,t){var i=n.getFlatCoordinates();if(i){var r=n.getStride();return Qe(i,0,i.length,r,e,t)}else return null}function Jo(n,e,t,i,r,a,o){var s=n[e],h=n[e+1],l=n[t]-s,u=n[t+1]-h,c;if(l===0&&u===0)c=e;else{var f=((r-s)*l+(a-h)*u)/(l*l+u*u);if(f>1)c=t;else if(f>0){for(var d=0;d<i;++d)o[d]=Ve(n[e+d],n[t+d],f);o.length=i;return}else c=e}for(var d=0;d<i;++d)o[d]=n[c+d];o.length=i}function Ch(n,e,t,i,r){var a=n[e],o=n[e+1];for(e+=i;e<t;e+=i){var s=n[e],h=n[e+1],l=wi(a,o,s,h);l>r&&(r=l),a=s,o=h}return r}function nc(n,e,t,i,r){for(var a=0,o=t.length;a<o;++a){var s=t[a];r=Ch(n,e,s,i,r),e=s}return r}function Rh(n,e,t,i,r,a,o,s,h,l,u){if(e==t)return l;var c,f;if(r===0)if(f=wi(o,s,n[e],n[e+1]),f<l){for(c=0;c<i;++c)h[c]=n[e+c];return h.length=i,f}else return l;for(var d=u||[NaN,NaN],v=e+i;v<t;)if(Jo(n,v-i,v,i,o,s,d),f=wi(o,s,d[0],d[1]),f<l){for(l=f,c=0;c<i;++c)h[c]=d[c];h.length=i,v+=i}else v+=i*Math.max((Math.sqrt(f)-Math.sqrt(l))/r|0,1);if(Jo(n,t-i,e,i,o,s,d),f=wi(o,s,d[0],d[1]),f<l){for(l=f,c=0;c<i;++c)h[c]=d[c];h.length=i}return l}function rc(n,e,t,i,r,a,o,s,h,l,u){for(var c=[NaN,NaN],f=0,d=t.length;f<d;++f){var v=t[f];l=Rh(n,e,v,i,r,a,o,s,h,l,c),e=v}return l}function ac(n,e,t,i){for(var r=0,a=t.length;r<a;++r)n[e++]=t[r];return e}function wh(n,e,t,i){for(var r=0,a=t.length;r<a;++r)for(var o=t[r],s=0;s<i;++s)n[e++]=o[s];return e}function oc(n,e,t,i,r){for(var a=r||[],o=0,s=0,h=t.length;s<h;++s){var l=wh(n,e,t[s],i);a[o++]=l,e=l}return a.length=o,a}function sc(n,e,t,i,r,a,o){var s=(t-e)/i;if(s<3){for(;e<t;e+=i)a[o++]=n[e],a[o++]=n[e+1];return o}var h=new Array(s);h[0]=1,h[s-1]=1;for(var l=[e,t-i],u=0;l.length>0;){for(var c=l.pop(),f=l.pop(),d=0,v=n[f],_=n[f+1],p=n[c],g=n[c+1],y=f+i;y<c;y+=i){var m=n[y],x=n[y+1],E=wu(m,x,v,_,p,g);E>d&&(u=y,d=E)}d>r&&(h[(u-e)/i]=1,f+i<u&&l.push(f,u),u+i<c&&l.push(u,c))}for(var y=0;y<s;++y)h[y]&&(a[o++]=n[e+y*i],a[o++]=n[e+y*i+1]);return o}function qe(n,e){return e*Math.round(n/e)}function hc(n,e,t,i,r,a,o){if(e==t)return o;var s=qe(n[e],r),h=qe(n[e+1],r);e+=i,a[o++]=s,a[o++]=h;var l,u;do if(l=qe(n[e],r),u=qe(n[e+1],r),e+=i,e==t)return a[o++]=l,a[o++]=u,o;while(l==s&&u==h);for(;e<t;){var c=qe(n[e],r),f=qe(n[e+1],r);if(e+=i,!(c==l&&f==u)){var d=l-s,v=u-h,_=c-s,p=f-h;if(d*p==v*_&&(d<0&&_<d||d==_||d>0&&_>d)&&(v<0&&p<v||v==p||v>0&&p>v)){l=c,u=f;continue}a[o++]=l,a[o++]=u,s=l,h=u,l=c,u=f}}return a[o++]=l,a[o++]=u,o}function lc(n,e,t,i,r,a,o,s){for(var h=0,l=t.length;h<l;++h){var u=t[h];o=hc(n,e,u,i,r,a,o),s.push(o),e=u}return o}function Ei(n,e,t,i,r){for(var a=r!==void 0?r:[],o=0,s=e;s<t;s+=i)a[o++]=n.slice(s,s+i);return a.length=o,a}function Cr(n,e,t,i,r){for(var a=r!==void 0?r:[],o=0,s=0,h=t.length;s<h;++s){var l=t[s];a[o++]=Ei(n,e,l,i,a[o]),e=l}return a.length=o,a}function Qo(n,e,t,i,r){for(var a=r!==void 0?r:[],o=0,s=0,h=t.length;s<h;++s){var l=t[s];a[o++]=Cr(n,e,l,i,a[o]),e=l[l.length-1]}return a.length=o,a}function Ih(n,e,t,i){for(var r=0,a=n[t-i],o=n[t-i+1];e<t;e+=i){var s=n[e],h=n[e+1];r+=o*s-a*h,a=s,o=h}return r/2}function uc(n,e,t,i){for(var r=0,a=0,o=t.length;a<o;++a){var s=t[a];r+=Ih(n,e,s,i),e=s}return r}var fc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ts=(function(n){fc(e,n);function e(t,i){var r=n.call(this)||this;return r.maxDelta_=-1,r.maxDeltaRevision_=-1,i!==void 0&&!Array.isArray(t[0])?r.setFlatCoordinates(i,t):r.setCoordinates(t,i),r}return e.prototype.clone=function(){return new e(this.flatCoordinates.slice(),this.layout)},e.prototype.closestPointXY=function(t,i,r,a){return a<oh(this.getExtent(),t,i)?a:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(Ch(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),Rh(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,this.maxDelta_,!0,t,i,r,a))},e.prototype.getArea=function(){return Ih(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},e.prototype.getCoordinates=function(){return Ei(this.flatCoordinates,0,this.flatCoordinates.length,this.stride)},e.prototype.getSimplifiedGeometryInternal=function(t){var i=[];return i.length=sc(this.flatCoordinates,0,this.flatCoordinates.length,this.stride,t,i,0),new e(i,kt.XY)},e.prototype.getType=function(){return W.LINEAR_RING},e.prototype.intersectsExtent=function(t){return!1},e.prototype.setCoordinates=function(t,i){this.setLayout(i,t,1),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=wh(this.flatCoordinates,0,t,this.stride),this.changed()},e})(eo),cc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Sh=(function(n){cc(e,n);function e(t,i){var r=n.call(this)||this;return r.setCoordinates(t,i),r}return e.prototype.clone=function(){var t=new e(this.flatCoordinates.slice(),this.layout);return t.applyProperties(this),t},e.prototype.closestPointXY=function(t,i,r,a){var o=this.flatCoordinates,s=wi(t,i,o[0],o[1]);if(s<a){for(var h=this.stride,l=0;l<h;++l)r[l]=o[l];return r.length=h,s}else return a},e.prototype.getCoordinates=function(){return this.flatCoordinates?this.flatCoordinates.slice():[]},e.prototype.computeExtent=function(t){return $u(this.flatCoordinates,t)},e.prototype.getType=function(){return W.POINT},e.prototype.intersectsExtent=function(t){return sh(t,this.flatCoordinates[0],this.flatCoordinates[1])},e.prototype.setCoordinates=function(t,i){this.setLayout(i,t,0),this.flatCoordinates||(this.flatCoordinates=[]),this.flatCoordinates.length=ac(this.flatCoordinates,0,t,this.stride),this.changed()},e})(eo);function dc(n,e,t,i,r){var a=lh(r,function(o){return!$e(n,e,t,i,o[0],o[1])});return!a}function $e(n,e,t,i,r,a){for(var o=0,s=n[t-i],h=n[t-i+1];e<t;e+=i){var l=n[e],u=n[e+1];h<=a?u>a&&(l-s)*(a-h)-(r-s)*(u-h)>0&&o++:u<=a&&(l-s)*(a-h)-(r-s)*(u-h)<0&&o--,s=l,h=u}return o!==0}function Oh(n,e,t,i,r,a){if(t.length===0||!$e(n,e,t[0],i,r,a))return!1;for(var o=1,s=t.length;o<s;++o)if($e(n,t[o-1],t[o],i,r,a))return!1;return!0}function vc(n,e,t,i,r,a,o){for(var s,h,l,u,c,f,d,v=r[a+1],_=[],p=0,g=t.length;p<g;++p){var y=t[p];for(u=n[y-i],f=n[y-i+1],s=e;s<y;s+=i)c=n[s],d=n[s+1],(v<=f&&d<=v||f<=v&&v<=d)&&(l=(v-f)/(d-f)*(c-u)+u,_.push(l)),u=c,f=d}var m=NaN,x=-1/0;for(_.sort(Li),u=_[0],s=1,h=_.length;s<h;++s){c=_[s];var E=Math.abs(c-u);E>x&&(l=(u+c)/2,Oh(n,e,t,i,l,v)&&(m=l,x=E)),u=c}return isNaN(m)&&(m=r[a]),[m,v,x]}function _c(n,e,t,i,r){var a;for(e+=i;e<t;e+=i)if(a=r(n.slice(e-i,e),n.slice(e,e+i)),a)return a;return!1}function Ah(n,e,t,i,r){var a=hh(Wt(),n,e,t,i);return Ct(r,a)?Pe(r,a)||a[0]>=r[0]&&a[2]<=r[2]||a[1]>=r[1]&&a[3]<=r[3]?!0:_c(n,e,t,i,function(o,s){return ef(r,o,s)}):!1}function pc(n,e,t,i,r){return!!(Ah(n,e,t,i,r)||$e(n,e,t,i,r[0],r[1])||$e(n,e,t,i,r[0],r[3])||$e(n,e,t,i,r[2],r[1])||$e(n,e,t,i,r[2],r[3]))}function gc(n,e,t,i,r){if(!pc(n,e,t[0],i,r))return!1;if(t.length===1)return!0;for(var a=1,o=t.length;a<o;++a)if(dc(n,t[a-1],t[a],i,r)&&!Ah(n,t[a-1],t[a],i,r))return!1;return!0}function yc(n,e,t,i){for(;e<t-i;){for(var r=0;r<i;++r){var a=n[e+r];n[e+r]=n[t-i+r],n[t-i+r]=a}e+=i,t-=i}}function Ph(n,e,t,i){for(var r=0,a=n[t-i],o=n[t-i+1];e<t;e+=i){var s=n[e],h=n[e+1];r+=(s-a)*(h+o),a=s,o=h}return r===0?void 0:r>0}function mc(n,e,t,i,r){for(var a=0,o=t.length;a<o;++a){var s=t[a],h=Ph(n,e,s,i);if(a===0){if(!h)return!1}else if(h)return!1;e=s}return!0}function es(n,e,t,i,r){for(var a=r!==void 0?r:!1,o=0,s=t.length;o<s;++o){var h=t[o],l=Ph(n,e,h,i),u=o===0?a&&l||!a&&!l:a&&!l||!a&&l;u&&yc(n,e,h,i),e=h}return e}var xc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Lh=(function(n){xc(e,n);function e(t,i,r){var a=n.call(this)||this;return a.ends_=[],a.flatInteriorPointRevision_=-1,a.flatInteriorPoint_=null,a.maxDelta_=-1,a.maxDeltaRevision_=-1,a.orientedRevision_=-1,a.orientedFlatCoordinates_=null,i!==void 0&&r?(a.setFlatCoordinates(i,t),a.ends_=r):a.setCoordinates(t,i),a}return e.prototype.appendLinearRing=function(t){this.flatCoordinates?qs(this.flatCoordinates,t.getFlatCoordinates()):this.flatCoordinates=t.getFlatCoordinates().slice(),this.ends_.push(this.flatCoordinates.length),this.changed()},e.prototype.clone=function(){var t=new e(this.flatCoordinates.slice(),this.layout,this.ends_.slice());return t.applyProperties(this),t},e.prototype.closestPointXY=function(t,i,r,a){return a<oh(this.getExtent(),t,i)?a:(this.maxDeltaRevision_!=this.getRevision()&&(this.maxDelta_=Math.sqrt(nc(this.flatCoordinates,0,this.ends_,this.stride,0)),this.maxDeltaRevision_=this.getRevision()),rc(this.flatCoordinates,0,this.ends_,this.stride,this.maxDelta_,!0,t,i,r,a))},e.prototype.containsXY=function(t,i){return Oh(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t,i)},e.prototype.getArea=function(){return uc(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride)},e.prototype.getCoordinates=function(t){var i;return t!==void 0?(i=this.getOrientedFlatCoordinates().slice(),es(i,0,this.ends_,this.stride,t)):i=this.flatCoordinates,Cr(i,0,this.ends_,this.stride)},e.prototype.getEnds=function(){return this.ends_},e.prototype.getFlatInteriorPoint=function(){if(this.flatInteriorPointRevision_!=this.getRevision()){var t=Ge(this.getExtent());this.flatInteriorPoint_=vc(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t,0),this.flatInteriorPointRevision_=this.getRevision()}return this.flatInteriorPoint_},e.prototype.getInteriorPoint=function(){return new Sh(this.getFlatInteriorPoint(),kt.XYM)},e.prototype.getLinearRingCount=function(){return this.ends_.length},e.prototype.getLinearRing=function(t){return t<0||this.ends_.length<=t?null:new ts(this.flatCoordinates.slice(t===0?0:this.ends_[t-1],this.ends_[t]),this.layout)},e.prototype.getLinearRings=function(){for(var t=this.layout,i=this.flatCoordinates,r=this.ends_,a=[],o=0,s=0,h=r.length;s<h;++s){var l=r[s],u=new ts(i.slice(o,l),t);a.push(u),o=l}return a},e.prototype.getOrientedFlatCoordinates=function(){if(this.orientedRevision_!=this.getRevision()){var t=this.flatCoordinates;mc(t,0,this.ends_,this.stride)?this.orientedFlatCoordinates_=t:(this.orientedFlatCoordinates_=t.slice(),this.orientedFlatCoordinates_.length=es(this.orientedFlatCoordinates_,0,this.ends_,this.stride)),this.orientedRevision_=this.getRevision()}return this.orientedFlatCoordinates_},e.prototype.getSimplifiedGeometryInternal=function(t){var i=[],r=[];return i.length=lc(this.flatCoordinates,0,this.ends_,this.stride,Math.sqrt(t),i,0,r),new e(i,kt.XY,r)},e.prototype.getType=function(){return W.POLYGON},e.prototype.intersectsExtent=function(t){return gc(this.getOrientedFlatCoordinates(),0,this.ends_,this.stride,t)},e.prototype.setCoordinates=function(t,i){this.setLayout(i,t,2),this.flatCoordinates||(this.flatCoordinates=[]);var r=oc(this.flatCoordinates,0,t,this.stride,this.ends_);this.flatCoordinates.length=r.length===0?0:r[r.length-1],this.changed()},e})(eo);function is(n){var e=n[0],t=n[1],i=n[2],r=n[3],a=[e,t,e,r,i,r,i,t,e,t];return new Lh(a,kt.XY,[a.length])}var Ec=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ta=0,Oe=(function(n){Ec(e,n);function e(t){var i=n.call(this)||this;i.on,i.once,i.un;var r=it({},t);return i.hints_=[0,0],i.animations_=[],i.updateAnimationKey_,i.projection_=Ka(r.projection,"EPSG:3857"),i.viewportSize_=[100,100],i.targetCenter_=null,i.targetResolution_,i.targetRotation_,i.nextCenter_=null,i.nextResolution_,i.nextRotation_,i.cancelAnchor_=void 0,r.center&&(r.center=fe(r.center,i.projection_)),r.extent&&(r.extent=de(r.extent,i.projection_)),r.projection&&hf(),i.applyOptions_(r),i}return e.prototype.applyOptions_=function(t){var i=it({},t);for(var r in Yt)delete i[r];this.setProperties(i,!0);var a=Tc(t);this.maxResolution_=a.maxResolution,this.minResolution_=a.minResolution,this.zoomFactor_=a.zoomFactor,this.resolutions_=t.resolutions,this.padding_=t.padding,this.minZoom_=a.minZoom;var o=Mc(t),s=a.constraint,h=Cc(t);this.constraints_={center:o,resolution:s,rotation:h},this.setRotation(t.rotation!==void 0?t.rotation:0),this.setCenterInternal(t.center!==void 0?t.center:null),t.resolution!==void 0?this.setResolution(t.resolution):t.zoom!==void 0&&this.setZoom(t.zoom)},Object.defineProperty(e.prototype,"padding",{get:function(){return this.padding_},set:function(t){var i=this.padding_;this.padding_=t;var r=this.getCenter();if(r){var a=t||[0,0,0,0];i=i||[0,0,0,0];var o=this.getResolution(),s=o/2*(a[3]-i[3]+i[1]-a[1]),h=o/2*(a[0]-i[0]+i[2]-a[2]);this.setCenterInternal([r[0]+s,r[1]-h])}},enumerable:!1,configurable:!0}),e.prototype.getUpdatedOptions_=function(t){var i=this.getProperties();return i.resolution!==void 0?i.resolution=this.getResolution():i.zoom=this.getZoom(),i.center=this.getCenterInternal(),i.rotation=this.getRotation(),it({},i,t)},e.prototype.animate=function(t){this.isDef()&&!this.getAnimating()&&this.resolveConstraints(0);for(var i=new Array(arguments.length),r=0;r<i.length;++r){var a=arguments[r];a.center&&(a=it({},a),a.center=fe(a.center,this.getProjection())),a.anchor&&(a=it({},a),a.anchor=fe(a.anchor,this.getProjection())),i[r]=a}this.animateInternal.apply(this,i)},e.prototype.animateInternal=function(t){var i=arguments.length,r;i>1&&typeof arguments[i-1]=="function"&&(r=arguments[i-1],--i);for(var a=0;a<i&&!this.isDef();++a){var o=arguments[a];o.center&&this.setCenterInternal(o.center),o.zoom!==void 0?this.setZoom(o.zoom):o.resolution&&this.setResolution(o.resolution),o.rotation!==void 0&&this.setRotation(o.rotation)}if(a===i){r&&tr(r,!0);return}for(var s=Date.now(),h=this.targetCenter_.slice(),l=this.targetResolution_,u=this.targetRotation_,c=[];a<i;++a){var f=arguments[a],d={start:s,complete:!1,anchor:f.anchor,duration:f.duration!==void 0?f.duration:1e3,easing:f.easing||Lu,callback:r};if(f.center&&(d.sourceCenter=h,d.targetCenter=f.center.slice(),h=d.targetCenter),f.zoom!==void 0?(d.sourceResolution=l,d.targetResolution=this.getResolutionForZoom(f.zoom),l=d.targetResolution):f.resolution&&(d.sourceResolution=l,d.targetResolution=f.resolution,l=d.targetResolution),f.rotation!==void 0){d.sourceRotation=u;var v=He(f.rotation-u+Math.PI,2*Math.PI)-Math.PI;d.targetRotation=u+v,u=d.targetRotation}Rc(d)?d.complete=!0:s+=d.duration,c.push(d)}this.animations_.push(c),this.setHint(_t.ANIMATING,1),this.updateAnimations_()},e.prototype.getAnimating=function(){return this.hints_[_t.ANIMATING]>0},e.prototype.getInteracting=function(){return this.hints_[_t.INTERACTING]>0},e.prototype.cancelAnimations=function(){this.setHint(_t.ANIMATING,-this.hints_[_t.ANIMATING]);for(var t,i=0,r=this.animations_.length;i<r;++i){var a=this.animations_[i];if(a[0].callback&&tr(a[0].callback,!1),!t)for(var o=0,s=a.length;o<s;++o){var h=a[o];if(!h.complete){t=h.anchor;break}}}this.animations_.length=0,this.cancelAnchor_=t,this.nextCenter_=null,this.nextResolution_=NaN,this.nextRotation_=NaN},e.prototype.updateAnimations_=function(){if(this.updateAnimationKey_!==void 0&&(cancelAnimationFrame(this.updateAnimationKey_),this.updateAnimationKey_=void 0),!!this.getAnimating()){for(var t=Date.now(),i=!1,r=this.animations_.length-1;r>=0;--r){for(var a=this.animations_[r],o=!0,s=0,h=a.length;s<h;++s){var l=a[s];if(!l.complete){var u=t-l.start,c=l.duration>0?u/l.duration:1;c>=1?(l.complete=!0,c=1):o=!1;var f=l.easing(c);if(l.sourceCenter){var d=l.sourceCenter[0],v=l.sourceCenter[1],_=l.targetCenter[0],p=l.targetCenter[1];this.nextCenter_=l.targetCenter;var g=d+f*(_-d),y=v+f*(p-v);this.targetCenter_=[g,y]}if(l.sourceResolution&&l.targetResolution){var m=f===1?l.targetResolution:l.sourceResolution+f*(l.targetResolution-l.sourceResolution);if(l.anchor){var x=this.getViewportSize_(this.getRotation()),E=this.constraints_.resolution(m,0,x,!0);this.targetCenter_=this.calculateCenterZoom(E,l.anchor)}this.nextResolution_=l.targetResolution,this.targetResolution_=m,this.applyTargetState_(!0)}if(l.sourceRotation!==void 0&&l.targetRotation!==void 0){var M=f===1?He(l.targetRotation+Math.PI,2*Math.PI)-Math.PI:l.sourceRotation+f*(l.targetRotation-l.sourceRotation);if(l.anchor){var C=this.constraints_.rotation(M,!0);this.targetCenter_=this.calculateCenterRotate(C,l.anchor)}this.nextRotation_=l.targetRotation,this.targetRotation_=M}if(this.applyTargetState_(!0),i=!0,!l.complete)break}}if(o){this.animations_[r]=null,this.setHint(_t.ANIMATING,-1),this.nextCenter_=null,this.nextResolution_=NaN,this.nextRotation_=NaN;var T=a[0].callback;T&&tr(T,!0)}}this.animations_=this.animations_.filter(Boolean),i&&this.updateAnimationKey_===void 0&&(this.updateAnimationKey_=requestAnimationFrame(this.updateAnimations_.bind(this)))}},e.prototype.calculateCenterRotate=function(t,i){var r,a=this.getCenterInternal();return a!==void 0&&(r=[a[0]-i[0],a[1]-i[1]],Va(r,t-this.getRotation()),af(r,i)),r},e.prototype.calculateCenterZoom=function(t,i){var r,a=this.getCenterInternal(),o=this.getResolution();if(a!==void 0&&o!==void 0){var s=i[0]-t*(i[0]-a[0])/o,h=i[1]-t*(i[1]-a[1])/o;r=[s,h]}return r},e.prototype.getViewportSize_=function(t){var i=this.viewportSize_;if(t){var r=i[0],a=i[1];return[Math.abs(r*Math.cos(t))+Math.abs(a*Math.sin(t)),Math.abs(r*Math.sin(t))+Math.abs(a*Math.cos(t))]}else return i},e.prototype.setViewportSize=function(t){this.viewportSize_=Array.isArray(t)?t.slice():[100,100],this.getAnimating()||this.resolveConstraints(0)},e.prototype.getCenter=function(){var t=this.getCenterInternal();return t&&wa(t,this.getProjection())},e.prototype.getCenterInternal=function(){return this.get(Yt.CENTER)},e.prototype.getConstraints=function(){return this.constraints_},e.prototype.getConstrainResolution=function(){return this.get("constrainResolution")},e.prototype.getHints=function(t){return t!==void 0?(t[0]=this.hints_[0],t[1]=this.hints_[1],t):this.hints_.slice()},e.prototype.calculateExtent=function(t){var i=this.calculateExtentInternal(t);return Ia(i,this.getProjection())},e.prototype.calculateExtentInternal=function(t){var i=t||this.getViewportSizeMinusPadding_(),r=this.getCenterInternal();Y(r,1);var a=this.getResolution();Y(a!==void 0,2);var o=this.getRotation();return Y(o!==void 0,3),Si(r,a,o,i)},e.prototype.getMaxResolution=function(){return this.maxResolution_},e.prototype.getMinResolution=function(){return this.minResolution_},e.prototype.getMaxZoom=function(){return this.getZoomForResolution(this.minResolution_)},e.prototype.setMaxZoom=function(t){this.applyOptions_(this.getUpdatedOptions_({maxZoom:t}))},e.prototype.getMinZoom=function(){return this.getZoomForResolution(this.maxResolution_)},e.prototype.setMinZoom=function(t){this.applyOptions_(this.getUpdatedOptions_({minZoom:t}))},e.prototype.setConstrainResolution=function(t){this.applyOptions_(this.getUpdatedOptions_({constrainResolution:t}))},e.prototype.getProjection=function(){return this.projection_},e.prototype.getResolution=function(){return this.get(Yt.RESOLUTION)},e.prototype.getResolutions=function(){return this.resolutions_},e.prototype.getResolutionForExtent=function(t,i){return this.getResolutionForExtentInternal(de(t,this.getProjection()),i)},e.prototype.getResolutionForExtentInternal=function(t,i){var r=i||this.getViewportSizeMinusPadding_(),a=et(t)/r[0],o=Et(t)/r[1];return Math.max(a,o)},e.prototype.getResolutionForValueFunction=function(t){var i=t||2,r=this.getConstrainedResolution(this.maxResolution_),a=this.minResolution_,o=Math.log(r/a)/Math.log(i);return(function(s){var h=r/Math.pow(i,s*o);return h})},e.prototype.getRotation=function(){return this.get(Yt.ROTATION)},e.prototype.getValueForResolutionFunction=function(t){var i=Math.log(t||2),r=this.getConstrainedResolution(this.maxResolution_),a=this.minResolution_,o=Math.log(r/a)/i;return(function(s){var h=Math.log(r/s)/i/o;return h})},e.prototype.getViewportSizeMinusPadding_=function(t){var i=this.getViewportSize_(t),r=this.padding_;return r&&(i=[i[0]-r[1]-r[3],i[1]-r[0]-r[2]]),i},e.prototype.getState=function(){var t=this.getProjection(),i=this.getResolution(),r=this.getRotation(),a=this.getCenterInternal(),o=this.padding_;if(o){var s=this.getViewportSizeMinusPadding_();a=ea(a,this.getViewportSize_(),[s[0]/2+o[3],s[1]/2+o[0]],i,r)}return{center:a.slice(0),projection:t!==void 0?t:null,resolution:i,nextCenter:this.nextCenter_,nextResolution:this.nextResolution_,nextRotation:this.nextRotation_,rotation:r,zoom:this.getZoom()}},e.prototype.getZoom=function(){var t,i=this.getResolution();return i!==void 0&&(t=this.getZoomForResolution(i)),t},e.prototype.getZoomForResolution=function(t){var i=this.minZoom_||0,r,a;if(this.resolutions_){var o=Fr(this.resolutions_,t,1);i=o,r=this.resolutions_[o],o==this.resolutions_.length-1?a=2:a=r/this.resolutions_[o+1]}else r=this.maxResolution_,a=this.zoomFactor_;return i+Math.log(r/t)/Math.log(a)},e.prototype.getResolutionForZoom=function(t){if(this.resolutions_){if(this.resolutions_.length<=1)return 0;var i=ut(Math.floor(t),0,this.resolutions_.length-2),r=this.resolutions_[i]/this.resolutions_[i+1];return this.resolutions_[i]/Math.pow(r,ut(t-i,0,1))}else return this.maxResolution_/Math.pow(this.zoomFactor_,t-this.minZoom_)},e.prototype.fit=function(t,i){var r;if(Y(Array.isArray(t)||typeof t.getSimplifiedGeometry=="function",24),Array.isArray(t)){Y(!Ur(t),25);var a=de(t,this.getProjection());r=is(a)}else if(t.getType()===W.CIRCLE){var a=de(t.getExtent(),this.getProjection());r=is(a),r.rotate(this.getRotation(),Ge(a))}else{var o=ph();o?r=t.clone().transform(o,this.getProjection()):r=t}this.fitInternal(r,i)},e.prototype.rotatedExtentForGeometry=function(t){for(var i=this.getRotation(),r=Math.cos(i),a=Math.sin(-i),o=t.getFlatCoordinates(),s=t.getStride(),h=1/0,l=1/0,u=-1/0,c=-1/0,f=0,d=o.length;f<d;f+=s){var v=o[f]*r-o[f+1]*a,_=o[f]*a+o[f+1]*r;h=Math.min(h,v),l=Math.min(l,_),u=Math.max(u,v),c=Math.max(c,_)}return[h,l,u,c]},e.prototype.fitInternal=function(t,i){var r=i||{},a=r.size;a||(a=this.getViewportSizeMinusPadding_());var o=r.padding!==void 0?r.padding:[0,0,0,0],s=r.nearest!==void 0?r.nearest:!1,h;r.minResolution!==void 0?h=r.minResolution:r.maxZoom!==void 0?h=this.getResolutionForZoom(r.maxZoom):h=0;var l=this.rotatedExtentForGeometry(t),u=this.getResolutionForExtentInternal(l,[a[0]-o[1]-o[3],a[1]-o[0]-o[2]]);u=isNaN(u)?h:Math.max(u,h),u=this.getConstrainedResolution(u,s?0:1);var c=this.getRotation(),f=Math.sin(c),d=Math.cos(c),v=Ge(l);v[0]+=(o[1]-o[3])/2*u,v[1]+=(o[0]-o[2])/2*u;var _=v[0]*d-v[1]*f,p=v[1]*d+v[0]*f,g=this.getConstrainedCenter([_,p],u),y=r.callback?r.callback:ti;r.duration!==void 0?this.animateInternal({resolution:u,center:g,duration:r.duration,easing:r.easing},y):(this.targetResolution_=u,this.targetCenter_=g,this.applyTargetState_(!1,!0),tr(y,!0))},e.prototype.centerOn=function(t,i,r){this.centerOnInternal(fe(t,this.getProjection()),i,r)},e.prototype.centerOnInternal=function(t,i,r){this.setCenterInternal(ea(t,i,r,this.getResolution(),this.getRotation()))},e.prototype.calculateCenterShift=function(t,i,r,a){var o,s=this.padding_;if(s&&t){var h=this.getViewportSizeMinusPadding_(-r),l=ea(t,a,[h[0]/2+s[3],h[1]/2+s[0]],i,r);o=[t[0]-l[0],t[1]-l[1]]}return o},e.prototype.isDef=function(){return!!this.getCenterInternal()&&this.getResolution()!==void 0},e.prototype.adjustCenter=function(t){var i=wa(this.targetCenter_,this.getProjection());this.setCenter([i[0]+t[0],i[1]+t[1]])},e.prototype.adjustCenterInternal=function(t){var i=this.targetCenter_;this.setCenterInternal([i[0]+t[0],i[1]+t[1]])},e.prototype.adjustResolution=function(t,i){var r=i&&fe(i,this.getProjection());this.adjustResolutionInternal(t,r)},e.prototype.adjustResolutionInternal=function(t,i){var r=this.getAnimating()||this.getInteracting(),a=this.getViewportSize_(this.getRotation()),o=this.constraints_.resolution(this.targetResolution_*t,0,a,r);i&&(this.targetCenter_=this.calculateCenterZoom(o,i)),this.targetResolution_*=t,this.applyTargetState_()},e.prototype.adjustZoom=function(t,i){this.adjustResolution(Math.pow(this.zoomFactor_,-t),i)},e.prototype.adjustRotation=function(t,i){i&&(i=fe(i,this.getProjection())),this.adjustRotationInternal(t,i)},e.prototype.adjustRotationInternal=function(t,i){var r=this.getAnimating()||this.getInteracting(),a=this.constraints_.rotation(this.targetRotation_+t,r);i&&(this.targetCenter_=this.calculateCenterRotate(a,i)),this.targetRotation_+=t,this.applyTargetState_()},e.prototype.setCenter=function(t){this.setCenterInternal(t&&fe(t,this.getProjection()))},e.prototype.setCenterInternal=function(t){this.targetCenter_=t,this.applyTargetState_()},e.prototype.setHint=function(t,i){return this.hints_[t]+=i,this.changed(),this.hints_[t]},e.prototype.setResolution=function(t){this.targetResolution_=t,this.applyTargetState_()},e.prototype.setRotation=function(t){this.targetRotation_=t,this.applyTargetState_()},e.prototype.setZoom=function(t){this.setResolution(this.getResolutionForZoom(t))},e.prototype.applyTargetState_=function(t,i){var r=this.getAnimating()||this.getInteracting()||i,a=this.constraints_.rotation(this.targetRotation_,r),o=this.getViewportSize_(a),s=this.constraints_.resolution(this.targetResolution_,0,o,r),h=this.constraints_.center(this.targetCenter_,s,o,r,this.calculateCenterShift(this.targetCenter_,s,a,o));this.get(Yt.ROTATION)!==a&&this.set(Yt.ROTATION,a),this.get(Yt.RESOLUTION)!==s&&(this.set(Yt.RESOLUTION,s),this.set("zoom",this.getZoom(),!0)),(!h||!this.get(Yt.CENTER)||!gr(this.get(Yt.CENTER),h))&&this.set(Yt.CENTER,h),this.getAnimating()&&!t&&this.cancelAnimations(),this.cancelAnchor_=void 0},e.prototype.resolveConstraints=function(t,i,r){var a=t!==void 0?t:200,o=i||0,s=this.constraints_.rotation(this.targetRotation_),h=this.getViewportSize_(s),l=this.constraints_.resolution(this.targetResolution_,o,h),u=this.constraints_.center(this.targetCenter_,l,h,!1,this.calculateCenterShift(this.targetCenter_,l,s,h));if(a===0&&!this.cancelAnchor_){this.targetResolution_=l,this.targetRotation_=s,this.targetCenter_=u,this.applyTargetState_();return}var c=r||(a===0?this.cancelAnchor_:void 0);this.cancelAnchor_=void 0,(this.getResolution()!==l||this.getRotation()!==s||!this.getCenterInternal()||!gr(this.getCenterInternal(),u))&&(this.getAnimating()&&this.cancelAnimations(),this.animateInternal({rotation:s,center:u,resolution:l,duration:a,easing:ji,anchor:c}))},e.prototype.beginInteraction=function(){this.resolveConstraints(0),this.setHint(_t.INTERACTING,1)},e.prototype.endInteraction=function(t,i,r){var a=r&&fe(r,this.getProjection());this.endInteractionInternal(t,i,a)},e.prototype.endInteractionInternal=function(t,i,r){this.setHint(_t.INTERACTING,-1),this.resolveConstraints(t,i,r)},e.prototype.getConstrainedCenter=function(t,i){var r=this.getViewportSize_(this.getRotation());return this.constraints_.center(t,i||this.getResolution(),r)},e.prototype.getConstrainedZoom=function(t,i){var r=this.getResolutionForZoom(t);return this.getZoomForResolution(this.getConstrainedResolution(r,i))},e.prototype.getConstrainedResolution=function(t,i){var r=i||0,a=this.getViewportSize_(this.getRotation());return this.constraints_.resolution(t,r,a)},e})(se);function tr(n,e){setTimeout(function(){n(e)},0)}function Mc(n){if(n.extent!==void 0){var e=n.smoothExtentConstraint!==void 0?n.smoothExtentConstraint:!0;return qo(n.extent,n.constrainOnlyCenter,e)}var t=Ka(n.projection,"EPSG:3857");if(n.multiWorld!==!0&&t.isGlobal()){var i=t.getExtent().slice();return i[0]=-1/0,i[2]=1/0,qo(i,!1,!1)}return Yf}function Tc(n){var e,t,i,r=28,a=2,o=n.minZoom!==void 0?n.minZoom:ta,s=n.maxZoom!==void 0?n.maxZoom:r,h=n.zoomFactor!==void 0?n.zoomFactor:a,l=n.multiWorld!==void 0?n.multiWorld:!1,u=n.smoothResolutionConstraint!==void 0?n.smoothResolutionConstraint:!0,c=n.showFullExtent!==void 0?n.showFullExtent:!1,f=Ka(n.projection,"EPSG:3857"),d=f.getExtent(),v=n.constrainOnlyCenter,_=n.extent;if(!l&&!_&&f.isGlobal()&&(v=!1,_=d),n.resolutions!==void 0){var p=n.resolutions;t=p[o],i=p[s]!==void 0?p[s]:p[p.length-1],n.constrainResolution?e=Vf(p,u,!v&&_,c):e=Ko(t,i,u,!v&&_,c)}else{var g=d?Math.max(et(d),Et(d)):360*re[Nt.DEGREES]/f.getMetersPerUnit(),y=g/Ha/Math.pow(a,ta),m=y/Math.pow(a,r-ta);t=n.maxResolution,t!==void 0?o=0:t=y/Math.pow(h,o),i=n.minResolution,i===void 0&&(n.maxZoom!==void 0?n.maxResolution!==void 0?i=t/Math.pow(h,s):i=y/Math.pow(h,s):i=m),s=o+Math.floor(Math.log(t/i)/Math.log(h)),i=t/Math.pow(h,s-o),n.constrainResolution?e=qf(h,t,i,u,!v&&_,c):e=Ko(t,i,u,!v&&_,c)}return{constraint:e,maxResolution:t,minResolution:i,minZoom:o,zoomFactor:h}}function Cc(n){var e=n.enableRotation!==void 0?n.enableRotation:!0;if(e){var t=n.constrainRotation;return t===void 0||t===!0?$f():t===!1?$o:typeof t=="number"?Kf(t):$o}else return to}function Rc(n){return!(n.sourceCenter&&n.targetCenter&&!gr(n.sourceCenter,n.targetCenter)||n.sourceResolution!==n.targetResolution||n.sourceRotation!==n.targetRotation)}function ea(n,e,t,i,r){var a=Math.cos(-r),o=Math.sin(-r),s=n[0]*a-n[1]*o,h=n[1]*a+n[0]*o;s+=(e[0]/2-t[0])*i,h+=(t[1]-e[1]/2)*i,o=-o;var l=s*a-h*o,u=h*a+s*o;return[l,u]}function ns(n,e,t){return t===void 0&&(t=[0,0]),t[0]=n[0]+2*e,t[1]=n[1]+2*e,t}function rs(n){return n[0]>0&&n[1]>0}function Nh(n,e,t){return t===void 0&&(t=[0,0]),t[0]=n[0]*e+.5|0,t[1]=n[1]*e+.5|0,t}function Rt(n,e){return Array.isArray(n)?n:(e===void 0?e=[n,n]:(e[0]=n,e[1]=n),e)}var wc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})();function bh(n){if(n instanceof Ln){n.setMapInternal(null);return}n instanceof Xr&&n.getLayers().forEach(bh)}function Dh(n,e){if(n instanceof Ln){n.setMapInternal(e);return}if(n instanceof Xr)for(var t=n.getLayers().getArray(),i=0,r=t.length;i<r;++i)Dh(t[i],e)}var Ic=(function(n){wc(e,n);function e(t){var i=n.call(this)||this;i.on,i.once,i.un;var r=Sc(t);i.renderComplete_,i.boundHandleBrowserEvent_=i.handleBrowserEvent.bind(i),i.maxTilesLoading_=t.maxTilesLoading!==void 0?t.maxTilesLoading:16,i.pixelRatio_=t.pixelRatio!==void 0?t.pixelRatio:Zs,i.postRenderTimeoutHandle_,i.animationDelayKey_,i.animationDelay_=(function(){this.animationDelayKey_=void 0,this.renderFrame_(Date.now())}).bind(i),i.coordinateToPixelTransform_=ie(),i.pixelToCoordinateTransform_=ie(),i.frameIndex_=0,i.frameState_=null,i.previousExtent_=null,i.viewPropertyListenerKey_=null,i.viewChangeListenerKey_=null,i.layerGroupPropertyListenerKeys_=null,i.viewport_=document.createElement("div"),i.viewport_.className="ol-viewport"+("ontouchstart"in window?" ol-touch":""),i.viewport_.style.position="relative",i.viewport_.style.overflow="hidden",i.viewport_.style.width="100%",i.viewport_.style.height="100%",i.overlayContainer_=document.createElement("div"),i.overlayContainer_.style.position="absolute",i.overlayContainer_.style.zIndex="0",i.overlayContainer_.style.width="100%",i.overlayContainer_.style.height="100%",i.overlayContainer_.style.pointerEvents="none",i.overlayContainer_.className="ol-overlaycontainer",i.viewport_.appendChild(i.overlayContainer_),i.overlayContainerStopEvent_=document.createElement("div"),i.overlayContainerStopEvent_.style.position="absolute",i.overlayContainerStopEvent_.style.zIndex="0",i.overlayContainerStopEvent_.style.width="100%",i.overlayContainerStopEvent_.style.height="100%",i.overlayContainerStopEvent_.style.pointerEvents="none",i.overlayContainerStopEvent_.className="ol-overlaycontainer-stopevent",i.viewport_.appendChild(i.overlayContainerStopEvent_),i.mapBrowserEventHandler_=null,i.moveTolerance_=t.moveTolerance,i.keyboardEventTarget_=r.keyboardEventTarget,i.targetChangeHandlerKeys_=null,i.controls=r.controls||new xt,i.interactions=r.interactions||new xt,i.overlays_=r.overlays,i.overlayIdIndex_={},i.renderer_=null,i.postRenderFunctions_=[],i.tileQueue_=new Bf(i.getTilePriority.bind(i),i.handleTileChange_.bind(i)),i.addChangeListener(yt.LAYERGROUP,i.handleLayerGroupChanged_),i.addChangeListener(yt.VIEW,i.handleViewChanged_),i.addChangeListener(yt.SIZE,i.handleSizeChanged_),i.addChangeListener(yt.TARGET,i.handleTargetChanged_),i.setProperties(r.values);var a=i;return t.view&&!(t.view instanceof Oe)&&t.view.then(function(o){a.setView(new Oe(o))}),i.controls.addEventListener(Pt.ADD,(function(o){o.element.setMap(this)}).bind(i)),i.controls.addEventListener(Pt.REMOVE,(function(o){o.element.setMap(null)}).bind(i)),i.interactions.addEventListener(Pt.ADD,(function(o){o.element.setMap(this)}).bind(i)),i.interactions.addEventListener(Pt.REMOVE,(function(o){o.element.setMap(null)}).bind(i)),i.overlays_.addEventListener(Pt.ADD,(function(o){this.addOverlayInternal_(o.element)}).bind(i)),i.overlays_.addEventListener(Pt.REMOVE,(function(o){var s=o.element,h=s.getId();h!==void 0&&delete this.overlayIdIndex_[h.toString()],o.element.setMap(null)}).bind(i)),i.controls.forEach((function(o){o.setMap(this)}).bind(i)),i.interactions.forEach((function(o){o.setMap(this)}).bind(i)),i.overlays_.forEach(i.addOverlayInternal_.bind(i)),i}return e.prototype.createRenderer=function(){throw new Error("Use a map type that has a createRenderer method")},e.prototype.addControl=function(t){this.getControls().push(t)},e.prototype.addInteraction=function(t){this.getInteractions().push(t)},e.prototype.addLayer=function(t){var i=this.getLayerGroup().getLayers();i.push(t)},e.prototype.handleLayerAdd_=function(t){Dh(t.layer,this)},e.prototype.addOverlay=function(t){this.getOverlays().push(t)},e.prototype.addOverlayInternal_=function(t){var i=t.getId();i!==void 0&&(this.overlayIdIndex_[i.toString()]=t),t.setMap(this)},e.prototype.disposeInternal=function(){this.setTarget(null),n.prototype.disposeInternal.call(this)},e.prototype.forEachFeatureAtPixel=function(t,i,r){if(this.frameState_){var a=this.getCoordinateFromPixelInternal(t);r=r!==void 0?r:{};var o=r.hitTolerance!==void 0?r.hitTolerance:0,s=r.layerFilter!==void 0?r.layerFilter:De,h=r.checkWrapped!==!1;return this.renderer_.forEachFeatureAtCoordinate(a,this.frameState_,o,h,i,null,s,null)}},e.prototype.getFeaturesAtPixel=function(t,i){var r=[];return this.forEachFeatureAtPixel(t,function(a){r.push(a)},i),r},e.prototype.getAllLayers=function(){var t=[];function i(r){r.forEach(function(a){a instanceof Xr?i(a.getLayers()):t.push(a)})}return i(this.getLayers()),t},e.prototype.forEachLayerAtPixel=function(t,i,r){if(this.frameState_){var a=r||{},o=a.hitTolerance!==void 0?a.hitTolerance:0,s=a.layerFilter||De;return this.renderer_.forEachLayerAtPixel(t,this.frameState_,o,i,s)}},e.prototype.hasFeatureAtPixel=function(t,i){if(!this.frameState_)return!1;var r=this.getCoordinateFromPixelInternal(t);i=i!==void 0?i:{};var a=i.layerFilter!==void 0?i.layerFilter:De,o=i.hitTolerance!==void 0?i.hitTolerance:0,s=i.checkWrapped!==!1;return this.renderer_.hasFeatureAtCoordinate(r,this.frameState_,o,s,a,null)},e.prototype.getEventCoordinate=function(t){return this.getCoordinateFromPixel(this.getEventPixel(t))},e.prototype.getEventCoordinateInternal=function(t){return this.getCoordinateFromPixelInternal(this.getEventPixel(t))},e.prototype.getEventPixel=function(t){var i=this.viewport_.getBoundingClientRect(),r="changedTouches"in t?t.changedTouches[0]:t;return[r.clientX-i.left,r.clientY-i.top]},e.prototype.getTarget=function(){return this.get(yt.TARGET)},e.prototype.getTargetElement=function(){var t=this.getTarget();return t!==void 0?typeof t=="string"?document.getElementById(t):t:null},e.prototype.getCoordinateFromPixel=function(t){return wa(this.getCoordinateFromPixelInternal(t),this.getView().getProjection())},e.prototype.getCoordinateFromPixelInternal=function(t){var i=this.frameState_;return i?ft(i.pixelToCoordinateTransform,t.slice()):null},e.prototype.getControls=function(){return this.controls},e.prototype.getOverlays=function(){return this.overlays_},e.prototype.getOverlayById=function(t){var i=this.overlayIdIndex_[t.toString()];return i!==void 0?i:null},e.prototype.getInteractions=function(){return this.interactions},e.prototype.getLayerGroup=function(){return this.get(yt.LAYERGROUP)},e.prototype.setLayers=function(t){var i=this.getLayerGroup();if(t instanceof xt){i.setLayers(t);return}var r=i.getLayers();r.clear(),r.extend(t)},e.prototype.getLayers=function(){var t=this.getLayerGroup().getLayers();return t},e.prototype.getLoadingOrNotReady=function(){for(var t=this.getLayerGroup().getLayerStatesArray(),i=0,r=t.length;i<r;++i){var a=t[i].layer;if(!a.getRenderer().ready)return!0;var o=a.getSource();if(o&&o.loading)return!0}return!1},e.prototype.getPixelFromCoordinate=function(t){var i=fe(t,this.getView().getProjection());return this.getPixelFromCoordinateInternal(i)},e.prototype.getPixelFromCoordinateInternal=function(t){var i=this.frameState_;return i?ft(i.coordinateToPixelTransform,t.slice(0,2)):null},e.prototype.getRenderer=function(){return this.renderer_},e.prototype.getSize=function(){return this.get(yt.SIZE)},e.prototype.getView=function(){return this.get(yt.VIEW)},e.prototype.getViewport=function(){return this.viewport_},e.prototype.getOverlayContainer=function(){return this.overlayContainer_},e.prototype.getOverlayContainerStopEvent=function(){return this.overlayContainerStopEvent_},e.prototype.getOwnerDocument=function(){var t=this.getTargetElement();return t?t.ownerDocument:document},e.prototype.getTilePriority=function(t,i,r,a){return Wf(this.frameState_,t,i,r,a)},e.prototype.handleBrowserEvent=function(t,i){var r=i||t.type,a=new Re(r,this,t);this.handleMapBrowserEvent(a)},e.prototype.handleMapBrowserEvent=function(t){if(this.frameState_){var i=t.originalEvent,r=i.type;if(r===xa.POINTERDOWN||r===B.WHEEL||r===B.KEYDOWN){var a=this.getOwnerDocument(),o=this.viewport_.getRootNode?this.viewport_.getRootNode():a,s=i.target;if(this.overlayContainerStopEvent_.contains(s)||!(o===a?a.documentElement:o).contains(s))return}if(t.frameState=this.frameState_,this.dispatchEvent(t)!==!1)for(var h=this.getInteractions().getArray().slice(),l=h.length-1;l>=0;l--){var u=h[l];if(!(u.getMap()!==this||!u.getActive()||!this.getTargetElement())){var c=u.handleEvent(t);if(!c||t.propagationStopped)break}}}},e.prototype.handlePostRender=function(){var t=this.frameState_,i=this.tileQueue_;if(!i.isEmpty()){var r=this.maxTilesLoading_,a=r;if(t){var o=t.viewHints;if(o[_t.ANIMATING]||o[_t.INTERACTING]){var s=Date.now()-t.time>8;r=s?0:8,a=s?0:2}}i.getTilesLoading()<r&&(i.reprioritize(),i.loadMoreTiles(r,a))}t&&this.hasListener(ei.RENDERCOMPLETE)&&!t.animate&&this.renderComplete_&&this.renderer_.dispatchRenderEvent(ei.RENDERCOMPLETE,t);for(var h=this.postRenderFunctions_,l=0,u=h.length;l<u;++l)h[l](this,t);h.length=0},e.prototype.handleSizeChanged_=function(){this.getView()&&!this.getView().getAnimating()&&this.getView().resolveConstraints(0),this.render()},e.prototype.handleTargetChanged_=function(){if(this.mapBrowserEventHandler_){for(var t=0,i=this.targetChangeHandlerKeys_.length;t<i;++t)rt(this.targetChangeHandlerKeys_[t]);this.targetChangeHandlerKeys_=null,this.viewport_.removeEventListener(B.CONTEXTMENU,this.boundHandleBrowserEvent_),this.viewport_.removeEventListener(B.WHEEL,this.boundHandleBrowserEvent_),this.mapBrowserEventHandler_.dispose(),this.mapBrowserEventHandler_=null,ma(this.viewport_)}var r=this.getTargetElement();if(!r)this.renderer_&&(clearTimeout(this.postRenderTimeoutHandle_),this.postRenderTimeoutHandle_=void 0,this.postRenderFunctions_.length=0,this.renderer_.dispose(),this.renderer_=null),this.animationDelayKey_&&(cancelAnimationFrame(this.animationDelayKey_),this.animationDelayKey_=void 0);else{r.appendChild(this.viewport_),this.renderer_||(this.renderer_=this.createRenderer()),this.mapBrowserEventHandler_=new zf(this,this.moveTolerance_);for(var a in nt)this.mapBrowserEventHandler_.addEventListener(nt[a],this.handleMapBrowserEvent.bind(this));this.viewport_.addEventListener(B.CONTEXTMENU,this.boundHandleBrowserEvent_,!1),this.viewport_.addEventListener(B.WHEEL,this.boundHandleBrowserEvent_,Hs?{passive:!1}:!1);var o=this.getOwnerDocument().defaultView,s=this.keyboardEventTarget_?this.keyboardEventTarget_:r;this.targetChangeHandlerKeys_=[Z(s,B.KEYDOWN,this.handleBrowserEvent,this),Z(s,B.KEYPRESS,this.handleBrowserEvent,this),Z(o,B.RESIZE,this.updateSize,this)]}this.updateSize()},e.prototype.handleTileChange_=function(){this.render()},e.prototype.handleViewPropertyChanged_=function(){this.render()},e.prototype.handleViewChanged_=function(){this.viewPropertyListenerKey_&&(rt(this.viewPropertyListenerKey_),this.viewPropertyListenerKey_=null),this.viewChangeListenerKey_&&(rt(this.viewChangeListenerKey_),this.viewChangeListenerKey_=null);var t=this.getView();t&&(this.updateViewportSize_(),this.viewPropertyListenerKey_=Z(t,Pi.PROPERTYCHANGE,this.handleViewPropertyChanged_,this),this.viewChangeListenerKey_=Z(t,B.CHANGE,this.handleViewPropertyChanged_,this),t.resolveConstraints(0)),this.render()},e.prototype.handleLayerGroupChanged_=function(){this.layerGroupPropertyListenerKeys_&&(this.layerGroupPropertyListenerKeys_.forEach(rt),this.layerGroupPropertyListenerKeys_=null);var t=this.getLayerGroup();t&&(this.handleLayerAdd_(new we("addlayer",t)),this.layerGroupPropertyListenerKeys_=[Z(t,Pi.PROPERTYCHANGE,this.render,this),Z(t,B.CHANGE,this.render,this),Z(t,"addlayer",this.handleLayerAdd_,this),Z(t,"removelayer",this.handleLayerRemove_,this)]),this.render()},e.prototype.isRendered=function(){return!!this.frameState_},e.prototype.renderSync=function(){this.animationDelayKey_&&cancelAnimationFrame(this.animationDelayKey_),this.animationDelay_()},e.prototype.redrawText=function(){for(var t=this.getLayerGroup().getLayerStatesArray(),i=0,r=t.length;i<r;++i){var a=t[i].layer;a.hasRenderer()&&a.getRenderer().handleFontsChanged()}},e.prototype.render=function(){this.renderer_&&this.animationDelayKey_===void 0&&(this.animationDelayKey_=requestAnimationFrame(this.animationDelay_))},e.prototype.removeControl=function(t){return this.getControls().remove(t)},e.prototype.removeInteraction=function(t){return this.getInteractions().remove(t)},e.prototype.removeLayer=function(t){var i=this.getLayerGroup().getLayers();return i.remove(t)},e.prototype.handleLayerRemove_=function(t){bh(t.layer)},e.prototype.removeOverlay=function(t){return this.getOverlays().remove(t)},e.prototype.renderFrame_=function(t){var i=this,r=this.getSize(),a=this.getView(),o=this.frameState_,s=null;if(r!==void 0&&rs(r)&&a&&a.isDef()){var h=a.getHints(this.frameState_?this.frameState_.viewHints:void 0),l=a.getState();if(s={animate:!1,coordinateToPixelTransform:this.coordinateToPixelTransform_,declutterTree:null,extent:Si(l.center,l.resolution,l.rotation,r),index:this.frameIndex_++,layerIndex:0,layerStatesArray:this.getLayerGroup().getLayerStatesArray(),pixelRatio:this.pixelRatio_,pixelToCoordinateTransform:this.pixelToCoordinateTransform_,postRenderFunctions:[],size:r,tileQueue:this.tileQueue_,time:t,usedTiles:{},viewState:l,viewHints:h,wantedTiles:{},mapId:H(this),renderTargets:{}},l.nextCenter&&l.nextResolution){var u=isNaN(l.nextRotation)?l.rotation:l.nextRotation;s.nextExtent=Si(l.nextCenter,l.nextResolution,u,r)}}if(this.frameState_=s,this.renderer_.renderFrame(s),s){if(s.animate&&this.render(),Array.prototype.push.apply(this.postRenderFunctions_,s.postRenderFunctions),o){var c=!this.previousExtent_||!Ur(this.previousExtent_)&&!Di(s.extent,this.previousExtent_);c&&(this.dispatchEvent(new ur(hr.MOVESTART,this,o)),this.previousExtent_=jr(this.previousExtent_))}var f=this.previousExtent_&&!s.viewHints[_t.ANIMATING]&&!s.viewHints[_t.INTERACTING]&&!Di(s.extent,this.previousExtent_);f&&(this.dispatchEvent(new ur(hr.MOVEEND,this,s)),ah(s.extent,this.previousExtent_))}this.dispatchEvent(new ur(hr.POSTRENDER,this,s)),this.renderComplete_=!this.tileQueue_.getTilesLoading()&&!this.tileQueue_.getCount()&&!this.getLoadingOrNotReady(),this.postRenderTimeoutHandle_||(this.postRenderTimeoutHandle_=setTimeout(function(){i.postRenderTimeoutHandle_=void 0,i.handlePostRender()},0))},e.prototype.setLayerGroup=function(t){var i=this.getLayerGroup();i&&this.handleLayerRemove_(new we("removelayer",i)),this.set(yt.LAYERGROUP,t)},e.prototype.setSize=function(t){this.set(yt.SIZE,t)},e.prototype.setTarget=function(t){this.set(yt.TARGET,t)},e.prototype.setView=function(t){if(!t||t instanceof Oe){this.set(yt.VIEW,t);return}this.set(yt.VIEW,new Oe);var i=this;t.then(function(r){i.setView(new Oe(r))})},e.prototype.updateSize=function(){var t=this.getTargetElement(),i=void 0;if(t){var r=getComputedStyle(t),a=t.offsetWidth-parseFloat(r.borderLeftWidth)-parseFloat(r.paddingLeft)-parseFloat(r.paddingRight)-parseFloat(r.borderRightWidth),o=t.offsetHeight-parseFloat(r.borderTopWidth)-parseFloat(r.paddingTop)-parseFloat(r.paddingBottom)-parseFloat(r.borderBottomWidth);!isNaN(a)&&!isNaN(o)&&(i=[a,o],!rs(i)&&(t.offsetWidth||t.offsetHeight||t.getClientRects().length)&&console.warn("No map visible because the map container's width or height are 0."))}this.setSize(i),this.updateViewportSize_()},e.prototype.updateViewportSize_=function(){var t=this.getView();if(t){var i=void 0,r=getComputedStyle(this.viewport_);r.width&&r.height&&(i=[parseInt(r.width,10),parseInt(r.height,10)]),t.setViewportSize(i)}},e})(se);function Sc(n){var e=null;n.keyboardEventTarget!==void 0&&(e=typeof n.keyboardEventTarget=="string"?document.getElementById(n.keyboardEventTarget):n.keyboardEventTarget);var t={},i=n.layers&&typeof n.layers.getLayers=="function"?n.layers:new Xr({layers:n.layers});t[yt.LAYERGROUP]=i,t[yt.TARGET]=n.target,t[yt.VIEW]=n.view instanceof Oe?n.view:new Oe;var r;n.controls!==void 0&&(Array.isArray(n.controls)?r=new xt(n.controls.slice()):(Y(typeof n.controls.getArray=="function",47),r=n.controls));var a;n.interactions!==void 0&&(Array.isArray(n.interactions)?a=new xt(n.interactions.slice()):(Y(typeof n.interactions.getArray=="function",48),a=n.interactions));var o;return n.overlays!==void 0?Array.isArray(n.overlays)?o=new xt(n.overlays.slice()):(Y(typeof n.overlays.getArray=="function",49),o=n.overlays):o=new xt,{controls:r,interactions:a,keyboardEventTarget:e,overlays:o,values:t}}function Fh(n){var e=n||{},t=new xt,i=e.zoom!==void 0?e.zoom:!0;i&&t.push(new Gu(e.zoomOptions));var r=e.rotate!==void 0?e.rotate:!0;r&&t.push(new Du(e.rotateOptions));var a=e.attribution!==void 0?e.attribution:!0;return a&&t.push(new Pu(e.attributionOptions)),t}const Aa={ACTIVE:"active"};var Oc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Dn=(function(n){Oc(e,n);function e(t){var i=n.call(this)||this;return i.on,i.once,i.un,t&&t.handleEvent&&(i.handleEvent=t.handleEvent),i.map_=null,i.setActive(!0),i}return e.prototype.getActive=function(){return this.get(Aa.ACTIVE)},e.prototype.getMap=function(){return this.map_},e.prototype.handleEvent=function(t){return!0},e.prototype.setActive=function(t){this.set(Aa.ACTIVE,t)},e.prototype.setMap=function(t){this.map_=t},e})(se);function Ac(n,e,t){var i=n.getCenterInternal();if(i){var r=[i[0]+e[0],i[1]+e[1]];n.animateInternal({duration:t!==void 0?t:250,easing:Nu,center:n.getConstrainedCenter(r)})}}function io(n,e,t,i){var r=n.getZoom();if(r!==void 0){var a=n.getConstrainedZoom(r+e),o=n.getResolutionForZoom(a);n.getAnimating()&&n.cancelAnimations(),n.animate({resolution:o,anchor:t,duration:i!==void 0?i:250,easing:ji})}}var Pc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Lc=(function(n){Pc(e,n);function e(t){var i=n.call(this)||this,r=t||{};return i.delta_=r.delta?r.delta:1,i.duration_=r.duration!==void 0?r.duration:250,i}return e.prototype.handleEvent=function(t){var i=!1;if(t.type==nt.DBLCLICK){var r=t.originalEvent,a=t.map,o=t.coordinate,s=r.shiftKey?-this.delta_:this.delta_,h=a.getView();io(h,s,o,this.duration_),r.preventDefault(),i=!0}return!i},e})(Dn),Nc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Bi=(function(n){Nc(e,n);function e(t){var i=this,r=t||{};return i=n.call(this,r)||this,r.handleDownEvent&&(i.handleDownEvent=r.handleDownEvent),r.handleDragEvent&&(i.handleDragEvent=r.handleDragEvent),r.handleMoveEvent&&(i.handleMoveEvent=r.handleMoveEvent),r.handleUpEvent&&(i.handleUpEvent=r.handleUpEvent),r.stopDown&&(i.stopDown=r.stopDown),i.handlingDownUpSequence=!1,i.trackedPointers_={},i.targetPointers=[],i}return e.prototype.getPointerCount=function(){return this.targetPointers.length},e.prototype.handleDownEvent=function(t){return!1},e.prototype.handleDragEvent=function(t){},e.prototype.handleEvent=function(t){if(!t.originalEvent)return!0;var i=!1;if(this.updateTrackedPointers_(t),this.handlingDownUpSequence){if(t.type==nt.POINTERDRAG)this.handleDragEvent(t),t.originalEvent.preventDefault();else if(t.type==nt.POINTERUP){var r=this.handleUpEvent(t);this.handlingDownUpSequence=r&&this.targetPointers.length>0}}else if(t.type==nt.POINTERDOWN){var a=this.handleDownEvent(t);this.handlingDownUpSequence=a,i=this.stopDown(a)}else t.type==nt.POINTERMOVE&&this.handleMoveEvent(t);return!i},e.prototype.handleMoveEvent=function(t){},e.prototype.handleUpEvent=function(t){return!1},e.prototype.stopDown=function(t){return t},e.prototype.updateTrackedPointers_=function(t){if(bc(t)){var i=t.originalEvent,r=i.pointerId.toString();t.type==nt.POINTERUP?delete this.trackedPointers_[r]:t.type==nt.POINTERDOWN?this.trackedPointers_[r]=i:r in this.trackedPointers_&&(this.trackedPointers_[r]=i),this.targetPointers=Ks(this.trackedPointers_)}},e})(Dn);function no(n){for(var e=n.length,t=0,i=0,r=0;r<e;r++)t+=n[r].clientX,i+=n[r].clientY;return[t/e,i/e]}function bc(n){var e=n.type;return e===nt.POINTERDOWN||e===nt.POINTERDRAG||e===nt.POINTERUP}function Pa(n){var e=arguments;return function(t){for(var i=!0,r=0,a=e.length;r<a&&(i=i&&e[r](t),!!i);++r);return i}}var Dc=function(n){var e=n.originalEvent;return e.altKey&&!(e.metaKey||e.ctrlKey)&&e.shiftKey},Fc=function(n){var e=n.map.getTargetElement(),t=n.map.getOwnerDocument().activeElement;return e.contains(t)},Gh=function(n){return n.map.getTargetElement().hasAttribute("tabindex")?Fc(n):!0},kh=De,zh=function(n){var e=n.originalEvent;return e.button==0&&!(pu&&gu&&e.ctrlKey)},jh=function(n){var e=n.originalEvent;return!e.altKey&&!(e.metaKey||e.ctrlKey)&&!e.shiftKey},Gc=function(n){var e=n.originalEvent;return!e.altKey&&!(e.metaKey||e.ctrlKey)&&e.shiftKey},Uh=function(n){var e=n.originalEvent,t=e.target.tagName;return t!=="INPUT"&&t!=="SELECT"&&t!=="TEXTAREA"},ia=function(n){var e=n.originalEvent;return Y(e!==void 0,56),e.pointerType=="mouse"},kc=function(n){var e=n.originalEvent;return Y(e!==void 0,56),e.isPrimary&&e.button===0},zc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),jc=(function(n){zc(e,n);function e(t){var i=n.call(this,{stopDown:Gr})||this,r=t||{};i.kinetic_=r.kinetic,i.lastCentroid=null,i.lastPointersCount_,i.panning_=!1;var a=r.condition?r.condition:Pa(jh,kc);return i.condition_=r.onFocusOnly?Pa(Gh,a):a,i.noKinetic_=!1,i}return e.prototype.handleDragEvent=function(t){this.panning_||(this.panning_=!0,this.getMap().getView().beginInteraction());var i=this.targetPointers,r=no(i);if(i.length==this.lastPointersCount_){if(this.kinetic_&&this.kinetic_.update(r[0],r[1]),this.lastCentroid){var a=[this.lastCentroid[0]-r[0],r[1]-this.lastCentroid[1]],o=t.map,s=o.getView();of(a,s.getResolution()),Va(a,s.getRotation()),s.adjustCenterInternal(a)}}else this.kinetic_&&this.kinetic_.begin();this.lastCentroid=r,this.lastPointersCount_=i.length,t.originalEvent.preventDefault()},e.prototype.handleUpEvent=function(t){var i=t.map,r=i.getView();if(this.targetPointers.length===0){if(!this.noKinetic_&&this.kinetic_&&this.kinetic_.end()){var a=this.kinetic_.getDistance(),o=this.kinetic_.getAngle(),s=r.getCenterInternal(),h=i.getPixelFromCoordinateInternal(s),l=i.getCoordinateFromPixelInternal([h[0]-a*Math.cos(o),h[1]-a*Math.sin(o)]);r.animateInternal({center:r.getConstrainedCenter(l),duration:500,easing:ji})}return this.panning_&&(this.panning_=!1,r.endInteraction()),!1}else return this.kinetic_&&this.kinetic_.begin(),this.lastCentroid=null,!0},e.prototype.handleDownEvent=function(t){if(this.targetPointers.length>0&&this.condition_(t)){var i=t.map,r=i.getView();return this.lastCentroid=null,r.getAnimating()&&r.cancelAnimations(),this.kinetic_&&this.kinetic_.begin(),this.noKinetic_=this.targetPointers.length>1,!0}else return!1},e})(Bi),Uc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Bc=(function(n){Uc(e,n);function e(t){var i=this,r=t||{};return i=n.call(this,{stopDown:Gr})||this,i.condition_=r.condition?r.condition:Dc,i.lastAngle_=void 0,i.duration_=r.duration!==void 0?r.duration:250,i}return e.prototype.handleDragEvent=function(t){if(ia(t)){var i=t.map,r=i.getView();if(r.getConstraints().rotation!==to){var a=i.getSize(),o=t.pixel,s=Math.atan2(a[1]/2-o[1],o[0]-a[0]/2);if(this.lastAngle_!==void 0){var h=s-this.lastAngle_;r.adjustRotationInternal(-h)}this.lastAngle_=s}}},e.prototype.handleUpEvent=function(t){if(!ia(t))return!0;var i=t.map,r=i.getView();return r.endInteraction(this.duration_),!1},e.prototype.handleDownEvent=function(t){if(!ia(t))return!1;if(zh(t)&&this.condition_(t)){var i=t.map;return i.getView().beginInteraction(),this.lastAngle_=void 0,!0}else return!1},e})(Bi),Wc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Xc=(function(n){Wc(e,n);function e(t){var i=n.call(this)||this;return i.geometry_=null,i.element_=document.createElement("div"),i.element_.style.position="absolute",i.element_.style.pointerEvents="auto",i.element_.className="ol-box "+t,i.map_=null,i.startPixel_=null,i.endPixel_=null,i}return e.prototype.disposeInternal=function(){this.setMap(null)},e.prototype.render_=function(){var t=this.startPixel_,i=this.endPixel_,r="px",a=this.element_.style;a.left=Math.min(t[0],i[0])+r,a.top=Math.min(t[1],i[1])+r,a.width=Math.abs(i[0]-t[0])+r,a.height=Math.abs(i[1]-t[1])+r},e.prototype.setMap=function(t){if(this.map_){this.map_.getOverlayContainer().removeChild(this.element_);var i=this.element_.style;i.left="inherit",i.top="inherit",i.width="inherit",i.height="inherit"}this.map_=t,this.map_&&this.map_.getOverlayContainer().appendChild(this.element_)},e.prototype.setPixels=function(t,i){this.startPixel_=t,this.endPixel_=i,this.createOrUpdateGeometry(),this.render_()},e.prototype.createOrUpdateGeometry=function(){var t=this.startPixel_,i=this.endPixel_,r=[t,[t[0],i[1]],i,[i[0],t[1]]],a=r.map(this.map_.getCoordinateFromPixelInternal,this.map_);a[4]=a[0].slice(),this.geometry_?this.geometry_.setCoordinates([a]):this.geometry_=new Lh([a])},e.prototype.getGeometry=function(){return this.geometry_},e})(ka),Bh=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),er={BOXSTART:"boxstart",BOXDRAG:"boxdrag",BOXEND:"boxend",BOXCANCEL:"boxcancel"},na=(function(n){Bh(e,n);function e(t,i,r){var a=n.call(this,t)||this;return a.coordinate=i,a.mapBrowserEvent=r,a}return e})(Zt),Yc=(function(n){Bh(e,n);function e(t){var i=n.call(this)||this;i.on,i.once,i.un;var r=t||{};return i.box_=new Xc(r.className||"ol-dragbox"),i.minArea_=r.minArea!==void 0?r.minArea:64,r.onBoxEnd&&(i.onBoxEnd=r.onBoxEnd),i.startPixel_=null,i.condition_=r.condition?r.condition:zh,i.boxEndCondition_=r.boxEndCondition?r.boxEndCondition:i.defaultBoxEndCondition,i}return e.prototype.defaultBoxEndCondition=function(t,i,r){var a=r[0]-i[0],o=r[1]-i[1];return a*a+o*o>=this.minArea_},e.prototype.getGeometry=function(){return this.box_.getGeometry()},e.prototype.handleDragEvent=function(t){this.box_.setPixels(this.startPixel_,t.pixel),this.dispatchEvent(new na(er.BOXDRAG,t.coordinate,t))},e.prototype.handleUpEvent=function(t){this.box_.setMap(null);var i=this.boxEndCondition_(t,this.startPixel_,t.pixel);return i&&this.onBoxEnd(t),this.dispatchEvent(new na(i?er.BOXEND:er.BOXCANCEL,t.coordinate,t)),!1},e.prototype.handleDownEvent=function(t){return this.condition_(t)?(this.startPixel_=t.pixel,this.box_.setMap(t.map),this.box_.setPixels(this.startPixel_,this.startPixel_),this.dispatchEvent(new na(er.BOXSTART,t.coordinate,t)),!0):!1},e.prototype.onBoxEnd=function(t){},e})(Bi),Vc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),qc=(function(n){Vc(e,n);function e(t){var i=this,r=t||{},a=r.condition?r.condition:Gc;return i=n.call(this,{condition:a,className:r.className||"ol-dragzoom",minArea:r.minArea})||this,i.duration_=r.duration!==void 0?r.duration:200,i.out_=r.out!==void 0?r.out:!1,i}return e.prototype.onBoxEnd=function(t){var i=this.getMap(),r=i.getView(),a=this.getGeometry();if(this.out_){var o=r.rotatedExtentForGeometry(a),s=r.getResolutionForExtentInternal(o),h=r.getResolution()/s;a=a.clone(),a.scale(h*h)}r.fitInternal(a,{duration:this.duration_,easing:ji})},e})(Yc);const Ye={LEFT:37,UP:38,RIGHT:39,DOWN:40};var Kc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),$c=(function(n){Kc(e,n);function e(t){var i=n.call(this)||this,r=t||{};return i.defaultCondition_=function(a){return jh(a)&&Uh(a)},i.condition_=r.condition!==void 0?r.condition:i.defaultCondition_,i.duration_=r.duration!==void 0?r.duration:100,i.pixelDelta_=r.pixelDelta!==void 0?r.pixelDelta:128,i}return e.prototype.handleEvent=function(t){var i=!1;if(t.type==B.KEYDOWN){var r=t.originalEvent,a=r.keyCode;if(this.condition_(t)&&(a==Ye.DOWN||a==Ye.LEFT||a==Ye.RIGHT||a==Ye.UP)){var o=t.map,s=o.getView(),h=s.getResolution()*this.pixelDelta_,l=0,u=0;a==Ye.DOWN?u=-h:a==Ye.LEFT?l=-h:a==Ye.RIGHT?l=h:u=h;var c=[l,u];Va(c,s.getRotation()),Ac(s,c,this.duration_),r.preventDefault(),i=!0}}return!i},e})(Dn),Zc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Hc=(function(n){Zc(e,n);function e(t){var i=n.call(this)||this,r=t||{};return i.condition_=r.condition?r.condition:Uh,i.delta_=r.delta?r.delta:1,i.duration_=r.duration!==void 0?r.duration:100,i}return e.prototype.handleEvent=function(t){var i=!1;if(t.type==B.KEYDOWN||t.type==B.KEYPRESS){var r=t.originalEvent,a=r.charCode;if(this.condition_(t)&&(a==43||a==45)){var o=t.map,s=a==43?this.delta_:-this.delta_,h=o.getView();io(h,s,void 0,this.duration_),r.preventDefault(),i=!0}}return!i},e})(Dn),Jc=(function(){function n(e,t,i){this.decay_=e,this.minVelocity_=t,this.delay_=i,this.points_=[],this.angle_=0,this.initialVelocity_=0}return n.prototype.begin=function(){this.points_.length=0,this.angle_=0,this.initialVelocity_=0},n.prototype.update=function(e,t){this.points_.push(e,t,Date.now())},n.prototype.end=function(){if(this.points_.length<6)return!1;var e=Date.now()-this.delay_,t=this.points_.length-3;if(this.points_[t+2]<e)return!1;for(var i=t-3;i>0&&this.points_[i+2]>e;)i-=3;var r=this.points_[t+2]-this.points_[i+2];if(r<1e3/60)return!1;var a=this.points_[t]-this.points_[i],o=this.points_[t+1]-this.points_[i+1];return this.angle_=Math.atan2(o,a),this.initialVelocity_=Math.sqrt(a*a+o*o)/r,this.initialVelocity_>this.minVelocity_},n.prototype.getDistance=function(){return(this.minVelocity_-this.initialVelocity_)/this.decay_},n.prototype.getAngle=function(){return this.angle_},n})(),Qc=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ra={TRACKPAD:"trackpad",WHEEL:"wheel"},td=(function(n){Qc(e,n);function e(t){var i=this,r=t||{};i=n.call(this,r)||this,i.totalDelta_=0,i.lastDelta_=0,i.maxDelta_=r.maxDelta!==void 0?r.maxDelta:1,i.duration_=r.duration!==void 0?r.duration:250,i.timeout_=r.timeout!==void 0?r.timeout:80,i.useAnchor_=r.useAnchor!==void 0?r.useAnchor:!0,i.constrainResolution_=r.constrainResolution!==void 0?r.constrainResolution:!1;var a=r.condition?r.condition:kh;return i.condition_=r.onFocusOnly?Pa(Gh,a):a,i.lastAnchor_=null,i.startTime_=void 0,i.timeoutId_,i.mode_=void 0,i.trackpadEventGap_=400,i.trackpadTimeoutId_,i.deltaPerZoom_=300,i}return e.prototype.endInteraction_=function(){this.trackpadTimeoutId_=void 0;var t=this.getMap().getView();t.endInteraction(void 0,this.lastDelta_?this.lastDelta_>0?1:-1:0,this.lastAnchor_)},e.prototype.handleEvent=function(t){if(!this.condition_(t))return!0;var i=t.type;if(i!==B.WHEEL)return!0;var r=t.map,a=t.originalEvent;a.preventDefault(),this.useAnchor_&&(this.lastAnchor_=t.coordinate);var o;if(t.type==B.WHEEL&&(o=a.deltaY,_u&&a.deltaMode===WheelEvent.DOM_DELTA_PIXEL&&(o/=Zs),a.deltaMode===WheelEvent.DOM_DELTA_LINE&&(o*=40)),o===0)return!1;this.lastDelta_=o;var s=Date.now();this.startTime_===void 0&&(this.startTime_=s),(!this.mode_||s-this.startTime_>this.trackpadEventGap_)&&(this.mode_=Math.abs(o)<4?ra.TRACKPAD:ra.WHEEL);var h=r.getView();if(this.mode_===ra.TRACKPAD&&!(h.getConstrainResolution()||this.constrainResolution_))return this.trackpadTimeoutId_?clearTimeout(this.trackpadTimeoutId_):(h.getAnimating()&&h.cancelAnimations(),h.beginInteraction()),this.trackpadTimeoutId_=setTimeout(this.endInteraction_.bind(this),this.timeout_),h.adjustZoom(-o/this.deltaPerZoom_,this.lastAnchor_),this.startTime_=s,!1;this.totalDelta_+=o;var l=Math.max(this.timeout_-(s-this.startTime_),0);return clearTimeout(this.timeoutId_),this.timeoutId_=setTimeout(this.handleWheelZoom_.bind(this,r),l),!1},e.prototype.handleWheelZoom_=function(t){var i=t.getView();i.getAnimating()&&i.cancelAnimations();var r=-ut(this.totalDelta_,-this.maxDelta_*this.deltaPerZoom_,this.maxDelta_*this.deltaPerZoom_)/this.deltaPerZoom_;(i.getConstrainResolution()||this.constrainResolution_)&&(r=r?r>0?1:-1:0),io(i,r,this.lastAnchor_,this.duration_),this.mode_=void 0,this.totalDelta_=0,this.lastAnchor_=null,this.startTime_=void 0,this.timeoutId_=void 0},e.prototype.setMouseAnchor=function(t){this.useAnchor_=t,t||(this.lastAnchor_=null)},e})(Dn),ed=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),id=(function(n){ed(e,n);function e(t){var i=this,r=t||{},a=r;return a.stopDown||(a.stopDown=Gr),i=n.call(this,a)||this,i.anchor_=null,i.lastAngle_=void 0,i.rotating_=!1,i.rotationDelta_=0,i.threshold_=r.threshold!==void 0?r.threshold:.3,i.duration_=r.duration!==void 0?r.duration:250,i}return e.prototype.handleDragEvent=function(t){var i=0,r=this.targetPointers[0],a=this.targetPointers[1],o=Math.atan2(a.clientY-r.clientY,a.clientX-r.clientX);if(this.lastAngle_!==void 0){var s=o-this.lastAngle_;this.rotationDelta_+=s,!this.rotating_&&Math.abs(this.rotationDelta_)>this.threshold_&&(this.rotating_=!0),i=s}this.lastAngle_=o;var h=t.map,l=h.getView();if(l.getConstraints().rotation!==to){var u=h.getViewport().getBoundingClientRect(),c=no(this.targetPointers);c[0]-=u.left,c[1]-=u.top,this.anchor_=h.getCoordinateFromPixelInternal(c),this.rotating_&&(h.render(),l.adjustRotationInternal(i,this.anchor_))}},e.prototype.handleUpEvent=function(t){if(this.targetPointers.length<2){var i=t.map,r=i.getView();return r.endInteraction(this.duration_),!1}else return!0},e.prototype.handleDownEvent=function(t){if(this.targetPointers.length>=2){var i=t.map;return this.anchor_=null,this.lastAngle_=void 0,this.rotating_=!1,this.rotationDelta_=0,this.handlingDownUpSequence||i.getView().beginInteraction(),!0}else return!1},e})(Bi),nd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),rd=(function(n){nd(e,n);function e(t){var i=this,r=t||{},a=r;return a.stopDown||(a.stopDown=Gr),i=n.call(this,a)||this,i.anchor_=null,i.duration_=r.duration!==void 0?r.duration:400,i.lastDistance_=void 0,i.lastScaleDelta_=1,i}return e.prototype.handleDragEvent=function(t){var i=1,r=this.targetPointers[0],a=this.targetPointers[1],o=r.clientX-a.clientX,s=r.clientY-a.clientY,h=Math.sqrt(o*o+s*s);this.lastDistance_!==void 0&&(i=this.lastDistance_/h),this.lastDistance_=h;var l=t.map,u=l.getView();i!=1&&(this.lastScaleDelta_=i);var c=l.getViewport().getBoundingClientRect(),f=no(this.targetPointers);f[0]-=c.left,f[1]-=c.top,this.anchor_=l.getCoordinateFromPixelInternal(f),l.render(),u.adjustResolutionInternal(i,this.anchor_)},e.prototype.handleUpEvent=function(t){if(this.targetPointers.length<2){var i=t.map,r=i.getView(),a=this.lastScaleDelta_>1?1:-1;return r.endInteraction(this.duration_,a),!1}else return!0},e.prototype.handleDownEvent=function(t){if(this.targetPointers.length>=2){var i=t.map;return this.anchor_=null,this.lastDistance_=void 0,this.lastScaleDelta_=1,this.handlingDownUpSequence||i.getView().beginInteraction(),!0}else return!1},e})(Bi);const Qi={ARRAY_BUFFER:"arraybuffer",JSON:"json",TEXT:"text",XML:"xml"};var ad=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),od=(function(n){ad(e,n);function e(t){var i=n.call(this)||this;if(i.on,i.once,i.un,i.id_=void 0,i.geometryName_="geometry",i.style_=null,i.styleFunction_=void 0,i.geometryChangeKey_=null,i.addChangeListener(i.geometryName_,i.handleGeometryChanged_),t)if(typeof t.getSimplifiedGeometry=="function"){var r=t;i.setGeometry(r)}else{var a=t;i.setProperties(a)}return i}return e.prototype.clone=function(){var t=new e(this.hasProperties()?this.getProperties():null);t.setGeometryName(this.getGeometryName());var i=this.getGeometry();i&&t.setGeometry(i.clone());var r=this.getStyle();return r&&t.setStyle(r),t},e.prototype.getGeometry=function(){return this.get(this.geometryName_)},e.prototype.getId=function(){return this.id_},e.prototype.getGeometryName=function(){return this.geometryName_},e.prototype.getStyle=function(){return this.style_},e.prototype.getStyleFunction=function(){return this.styleFunction_},e.prototype.handleGeometryChange_=function(){this.changed()},e.prototype.handleGeometryChanged_=function(){this.geometryChangeKey_&&(rt(this.geometryChangeKey_),this.geometryChangeKey_=null);var t=this.getGeometry();t&&(this.geometryChangeKey_=Z(t,B.CHANGE,this.handleGeometryChange_,this)),this.changed()},e.prototype.setGeometry=function(t){this.set(this.geometryName_,t)},e.prototype.setStyle=function(t){this.style_=t,this.styleFunction_=t?sd(t):void 0,this.changed()},e.prototype.setId=function(t){this.id_=t,this.changed()},e.prototype.setGeometryName=function(t){this.removeChangeListener(this.geometryName_,this.handleGeometryChanged_),this.geometryName_=t,this.addChangeListener(this.geometryName_,this.handleGeometryChanged_),this.handleGeometryChanged_()},e})(se);function sd(n){if(typeof n=="function")return n;var e;if(Array.isArray(n))e=n;else{Y(typeof n.getZIndex=="function",41);var t=n;e=[t]}return function(){return e}}function hd(n,e,t,i){for(var r=n[e],a=n[e+1],o=0,s=e+i;s<t;s+=i){var h=n[s],l=n[s+1];o+=Math.sqrt((h-r)*(h-r)+(l-a)*(l-a)),r=h,a=l}return o}function ld(n,e,t,i,r){Wh(n,e,t||0,i||n.length-1,r||ud)}function Wh(n,e,t,i,r){for(;i>t;){if(i-t>600){var a=i-t+1,o=e-t+1,s=Math.log(a),h=.5*Math.exp(2*s/3),l=.5*Math.sqrt(s*h*(a-h)/a)*(o-a/2<0?-1:1),u=Math.max(t,Math.floor(e-o*h/a+l)),c=Math.min(i,Math.floor(e+(a-o)*h/a+l));Wh(n,e,u,c,r)}var f=n[e],d=t,v=i;for(tn(n,t,e),r(n[i],f)>0&&tn(n,t,i);d<v;){for(tn(n,d,v),d++,v--;r(n[d],f)<0;)d++;for(;r(n[v],f)>0;)v--}r(n[t],f)===0?tn(n,t,v):(v++,tn(n,v,i)),v<=e&&(t=v+1),e<=v&&(i=v-1)}}function tn(n,e,t){var i=n[e];n[e]=n[t],n[t]=i}function ud(n,e){return n<e?-1:n>e?1:0}let Xh=class{constructor(e=9){this._maxEntries=Math.max(4,e),this._minEntries=Math.max(2,Math.ceil(this._maxEntries*.4)),this.clear()}all(){return this._all(this.data,[])}search(e){let t=this.data;const i=[];if(!nr(e,t))return i;const r=this.toBBox,a=[];for(;t;){for(let o=0;o<t.children.length;o++){const s=t.children[o],h=t.leaf?r(s):s;nr(e,h)&&(t.leaf?i.push(s):oa(e,h)?this._all(s,i):a.push(s))}t=a.pop()}return i}collides(e){let t=this.data;if(!nr(e,t))return!1;const i=[];for(;t;){for(let r=0;r<t.children.length;r++){const a=t.children[r],o=t.leaf?this.toBBox(a):a;if(nr(e,o)){if(t.leaf||oa(e,o))return!0;i.push(a)}}t=i.pop()}return!1}load(e){if(!(e&&e.length))return this;if(e.length<this._minEntries){for(let i=0;i<e.length;i++)this.insert(e[i]);return this}let t=this._build(e.slice(),0,e.length-1,0);if(!this.data.children.length)this.data=t;else if(this.data.height===t.height)this._splitRoot(this.data,t);else{if(this.data.height<t.height){const i=this.data;this.data=t,t=i}this._insert(t,this.data.height-t.height-1,!0)}return this}insert(e){return e&&this._insert(e,this.data.height-1),this}clear(){return this.data=gi([]),this}remove(e,t){if(!e)return this;let i=this.data;const r=this.toBBox(e),a=[],o=[];let s,h,l;for(;i||a.length;){if(i||(i=a.pop(),h=a[a.length-1],s=o.pop(),l=!0),i.leaf){const u=fd(e,i.children,t);if(u!==-1)return i.children.splice(u,1),a.push(i),this._condense(a),this}!l&&!i.leaf&&oa(i,r)?(a.push(i),o.push(s),s=0,h=i,i=i.children[0]):h?(s++,i=h.children[s],l=!1):i=null}return this}toBBox(e){return e}compareMinX(e,t){return e.minX-t.minX}compareMinY(e,t){return e.minY-t.minY}toJSON(){return this.data}fromJSON(e){return this.data=e,this}_all(e,t){const i=[];for(;e;)e.leaf?t.push(...e.children):i.push(...e.children),e=i.pop();return t}_build(e,t,i,r){const a=i-t+1;let o=this._maxEntries,s;if(a<=o)return s=gi(e.slice(t,i+1)),di(s,this.toBBox),s;r||(r=Math.ceil(Math.log(a)/Math.log(o)),o=Math.ceil(a/Math.pow(o,r-1))),s=gi([]),s.leaf=!1,s.height=r;const h=Math.ceil(a/o),l=h*Math.ceil(Math.sqrt(o));as(e,t,i,l,this.compareMinX);for(let u=t;u<=i;u+=l){const c=Math.min(u+l-1,i);as(e,u,c,h,this.compareMinY);for(let f=u;f<=c;f+=h){const d=Math.min(f+h-1,c);s.children.push(this._build(e,f,d,r-1))}}return di(s,this.toBBox),s}_chooseSubtree(e,t,i,r){for(;r.push(t),!(t.leaf||r.length-1===i);){let a=1/0,o=1/0,s;for(let h=0;h<t.children.length;h++){const l=t.children[h],u=aa(l),c=vd(e,l)-u;c<o?(o=c,a=u<a?u:a,s=l):c===o&&u<a&&(a=u,s=l)}t=s||t.children[0]}return t}_insert(e,t,i){const r=i?e:this.toBBox(e),a=[],o=this._chooseSubtree(r,this.data,t,a);for(o.children.push(e),an(o,r);t>=0&&a[t].children.length>this._maxEntries;)this._split(a,t),t--;this._adjustParentBBoxes(r,a,t)}_split(e,t){const i=e[t],r=i.children.length,a=this._minEntries;this._chooseSplitAxis(i,a,r);const o=this._chooseSplitIndex(i,a,r),s=gi(i.children.splice(o,i.children.length-o));s.height=i.height,s.leaf=i.leaf,di(i,this.toBBox),di(s,this.toBBox),t?e[t-1].children.push(s):this._splitRoot(i,s)}_splitRoot(e,t){this.data=gi([e,t]),this.data.height=e.height+1,this.data.leaf=!1,di(this.data,this.toBBox)}_chooseSplitIndex(e,t,i){let r,a=1/0,o=1/0;for(let s=t;s<=i-t;s++){const h=rn(e,0,s,this.toBBox),l=rn(e,s,i,this.toBBox),u=_d(h,l),c=aa(h)+aa(l);u<a?(a=u,r=s,o=c<o?c:o):u===a&&c<o&&(o=c,r=s)}return r||i-t}_chooseSplitAxis(e,t,i){const r=e.leaf?this.compareMinX:cd,a=e.leaf?this.compareMinY:dd,o=this._allDistMargin(e,t,i,r),s=this._allDistMargin(e,t,i,a);o<s&&e.children.sort(r)}_allDistMargin(e,t,i,r){e.children.sort(r);const a=this.toBBox,o=rn(e,0,t,a),s=rn(e,i-t,i,a);let h=ir(o)+ir(s);for(let l=t;l<i-t;l++){const u=e.children[l];an(o,e.leaf?a(u):u),h+=ir(o)}for(let l=i-t-1;l>=t;l--){const u=e.children[l];an(s,e.leaf?a(u):u),h+=ir(s)}return h}_adjustParentBBoxes(e,t,i){for(let r=i;r>=0;r--)an(t[r],e)}_condense(e){for(let t=e.length-1,i;t>=0;t--)e[t].children.length===0?t>0?(i=e[t-1].children,i.splice(i.indexOf(e[t]),1)):this.clear():di(e[t],this.toBBox)}};function fd(n,e,t){if(!t)return e.indexOf(n);for(let i=0;i<e.length;i++)if(t(n,e[i]))return i;return-1}function di(n,e){rn(n,0,n.children.length,e,n)}function rn(n,e,t,i,r){r||(r=gi(null)),r.minX=1/0,r.minY=1/0,r.maxX=-1/0,r.maxY=-1/0;for(let a=e;a<t;a++){const o=n.children[a];an(r,n.leaf?i(o):o)}return r}function an(n,e){return n.minX=Math.min(n.minX,e.minX),n.minY=Math.min(n.minY,e.minY),n.maxX=Math.max(n.maxX,e.maxX),n.maxY=Math.max(n.maxY,e.maxY),n}function cd(n,e){return n.minX-e.minX}function dd(n,e){return n.minY-e.minY}function aa(n){return(n.maxX-n.minX)*(n.maxY-n.minY)}function ir(n){return n.maxX-n.minX+(n.maxY-n.minY)}function vd(n,e){return(Math.max(e.maxX,n.maxX)-Math.min(e.minX,n.minX))*(Math.max(e.maxY,n.maxY)-Math.min(e.minY,n.minY))}function _d(n,e){const t=Math.max(n.minX,e.minX),i=Math.max(n.minY,e.minY),r=Math.min(n.maxX,e.maxX),a=Math.min(n.maxY,e.maxY);return Math.max(0,r-t)*Math.max(0,a-i)}function oa(n,e){return n.minX<=e.minX&&n.minY<=e.minY&&e.maxX<=n.maxX&&e.maxY<=n.maxY}function nr(n,e){return e.minX<=n.maxX&&e.minY<=n.maxY&&e.maxX>=n.minX&&e.maxY>=n.minY}function gi(n){return{children:n,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function as(n,e,t,i,r){const a=[e,t];for(;a.length;){if(t=a.pop(),e=a.pop(),t-e<=i)continue;const o=e+Math.ceil((t-e)/i/2)*i;ld(n,o,e,t,r),a.push(e,o,o,t)}}const X={IDLE:0,LOADING:1,LOADED:2,ERROR:3,EMPTY:4};var Yh=(function(){function n(e){this.opacity_=e.opacity,this.rotateWithView_=e.rotateWithView,this.rotation_=e.rotation,this.scale_=e.scale,this.scaleArray_=Rt(e.scale),this.displacement_=e.displacement}return n.prototype.clone=function(){var e=this.getScale();return new n({opacity:this.getOpacity(),scale:Array.isArray(e)?e.slice():e,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),displacement:this.getDisplacement().slice()})},n.prototype.getOpacity=function(){return this.opacity_},n.prototype.getRotateWithView=function(){return this.rotateWithView_},n.prototype.getRotation=function(){return this.rotation_},n.prototype.getScale=function(){return this.scale_},n.prototype.getScaleArray=function(){return this.scaleArray_},n.prototype.getDisplacement=function(){return this.displacement_},n.prototype.getAnchor=function(){return q()},n.prototype.getImage=function(e){return q()},n.prototype.getHitDetectionImage=function(){return q()},n.prototype.getPixelRatio=function(e){return 1},n.prototype.getImageState=function(){return q()},n.prototype.getImageSize=function(){return q()},n.prototype.getOrigin=function(){return q()},n.prototype.getSize=function(){return q()},n.prototype.setDisplacement=function(e){this.displacement_=e},n.prototype.setOpacity=function(e){this.opacity_=e},n.prototype.setRotateWithView=function(e){this.rotateWithView_=e},n.prototype.setRotation=function(e){this.rotation_=e},n.prototype.setScale=function(e){this.scale_=e,this.scaleArray_=Rt(e)},n.prototype.listenImageChange=function(e){q()},n.prototype.load=function(){q()},n.prototype.unlistenImageChange=function(e){q()},n})();function te(n){return Array.isArray(n)?yh(n):n}var pd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),gd=(function(n){pd(e,n);function e(t){var i=this,r=t.rotateWithView!==void 0?t.rotateWithView:!1;return i=n.call(this,{opacity:1,rotateWithView:r,rotation:t.rotation!==void 0?t.rotation:0,scale:t.scale!==void 0?t.scale:1,displacement:t.displacement!==void 0?t.displacement:[0,0]})||this,i.canvas_=void 0,i.hitDetectionCanvas_=null,i.fill_=t.fill!==void 0?t.fill:null,i.origin_=[0,0],i.points_=t.points,i.radius_=t.radius!==void 0?t.radius:t.radius1,i.radius2_=t.radius2,i.angle_=t.angle!==void 0?t.angle:0,i.stroke_=t.stroke!==void 0?t.stroke:null,i.size_=null,i.renderOptions_=null,i.render(),i}return e.prototype.clone=function(){var t=this.getScale(),i=new e({fill:this.getFill()?this.getFill().clone():void 0,points:this.getPoints(),radius:this.getRadius(),radius2:this.getRadius2(),angle:this.getAngle(),stroke:this.getStroke()?this.getStroke().clone():void 0,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),scale:Array.isArray(t)?t.slice():t,displacement:this.getDisplacement().slice()});return i.setOpacity(this.getOpacity()),i},e.prototype.getAnchor=function(){var t=this.size_;if(!t)return null;var i=this.getDisplacement();return[t[0]/2-i[0],t[1]/2+i[1]]},e.prototype.getAngle=function(){return this.angle_},e.prototype.getFill=function(){return this.fill_},e.prototype.getHitDetectionImage=function(){return this.hitDetectionCanvas_||this.createHitDetectionCanvas_(this.renderOptions_),this.hitDetectionCanvas_},e.prototype.getImage=function(t){var i=this.canvas_[t];if(!i){var r=this.renderOptions_,a=Bt(r.size*t,r.size*t);this.draw_(r,a,t),i=a.canvas,this.canvas_[t]=i}return i},e.prototype.getPixelRatio=function(t){return t},e.prototype.getImageSize=function(){return this.size_},e.prototype.getImageState=function(){return X.LOADED},e.prototype.getOrigin=function(){return this.origin_},e.prototype.getPoints=function(){return this.points_},e.prototype.getRadius=function(){return this.radius_},e.prototype.getRadius2=function(){return this.radius2_},e.prototype.getSize=function(){return this.size_},e.prototype.getStroke=function(){return this.stroke_},e.prototype.listenImageChange=function(t){},e.prototype.load=function(){},e.prototype.unlistenImageChange=function(t){},e.prototype.calculateLineJoinSize_=function(t,i,r){if(i===0||this.points_===1/0||t!=="bevel"&&t!=="miter")return i;var a=this.radius_,o=this.radius2_===void 0?a:this.radius2_;if(a<o){var s=a;a=o,o=s}var h=this.radius2_===void 0?this.points_:this.points_*2,l=2*Math.PI/h,u=o*Math.sin(l),c=Math.sqrt(o*o-u*u),f=a-c,d=Math.sqrt(u*u+f*f),v=d/u;if(t==="miter"&&v<=r)return v*i;var _=i/2/v,p=i/2*(f/d),g=Math.sqrt((a+_)*(a+_)+p*p),y=g-a;if(this.radius2_===void 0||t==="bevel")return y*2;var m=a*Math.sin(l),x=Math.sqrt(a*a-m*m),E=o-x,M=Math.sqrt(m*m+E*E),C=M/m;if(C<=r){var T=C*i/2-o-a;return 2*Math.max(y,T)}return y*2},e.prototype.createRenderOptions=function(){var t=Fi,i=0,r=null,a=0,o,s=0;this.stroke_&&(o=this.stroke_.getColor(),o===null&&(o=Mn),o=te(o),s=this.stroke_.getWidth(),s===void 0&&(s=Cn),r=this.stroke_.getLineDash(),a=this.stroke_.getLineDashOffset(),t=this.stroke_.getLineJoin(),t===void 0&&(t=Fi),i=this.stroke_.getMiterLimit(),i===void 0&&(i=En));var h=this.calculateLineJoinSize_(t,s,i),l=Math.max(this.radius_,this.radius2_||0),u=Math.ceil(2*l+h);return{strokeStyle:o,strokeWidth:s,size:u,lineDash:r,lineDashOffset:a,lineJoin:t,miterLimit:i}},e.prototype.render=function(){this.renderOptions_=this.createRenderOptions();var t=this.renderOptions_.size;this.canvas_={},this.size_=[t,t]},e.prototype.draw_=function(t,i,r){if(i.scale(r,r),i.translate(t.size/2,t.size/2),this.createPath_(i),this.fill_){var a=this.fill_.getColor();a===null&&(a=ve),i.fillStyle=te(a),i.fill()}this.stroke_&&(i.strokeStyle=t.strokeStyle,i.lineWidth=t.strokeWidth,i.setLineDash&&t.lineDash&&(i.setLineDash(t.lineDash),i.lineDashOffset=t.lineDashOffset),i.lineJoin=t.lineJoin,i.miterLimit=t.miterLimit,i.stroke())},e.prototype.createHitDetectionCanvas_=function(t){if(this.fill_){var i=this.fill_.getColor(),r=0;if(typeof i=="string"&&(i=yr(i)),i===null?r=1:Array.isArray(i)&&(r=i.length===4?i[3]:1),r===0){var a=Bt(t.size,t.size);this.hitDetectionCanvas_=a.canvas,this.drawHitDetectionCanvas_(t,a)}}this.hitDetectionCanvas_||(this.hitDetectionCanvas_=this.getImage(1))},e.prototype.createPath_=function(t){var i=this.points_,r=this.radius_;if(i===1/0)t.arc(0,0,r,0,2*Math.PI);else{var a=this.radius2_===void 0?r:this.radius2_;this.radius2_!==void 0&&(i*=2);for(var o=this.angle_-Math.PI/2,s=2*Math.PI/i,h=0;h<i;h++){var l=o+h*s,u=h%2===0?r:a;t.lineTo(u*Math.cos(l),u*Math.sin(l))}t.closePath()}},e.prototype.drawHitDetectionCanvas_=function(t,i){i.translate(t.size/2,t.size/2),this.createPath_(i),i.fillStyle=ve,i.fill(),this.stroke_&&(i.strokeStyle=t.strokeStyle,i.lineWidth=t.strokeWidth,t.lineDash&&(i.setLineDash(t.lineDash),i.lineDashOffset=t.lineDashOffset),i.lineJoin=t.lineJoin,i.miterLimit=t.miterLimit,i.stroke())},e})(Yh),yd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),md=(function(n){yd(e,n);function e(t){var i=t||{};return n.call(this,{points:1/0,fill:i.fill,radius:i.radius,stroke:i.stroke,scale:i.scale!==void 0?i.scale:1,rotation:i.rotation!==void 0?i.rotation:0,rotateWithView:i.rotateWithView!==void 0?i.rotateWithView:!1,displacement:i.displacement!==void 0?i.displacement:[0,0]})||this}return e.prototype.clone=function(){var t=this.getScale(),i=new e({fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,radius:this.getRadius(),scale:Array.isArray(t)?t.slice():t,rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),displacement:this.getDisplacement().slice()});return i.setOpacity(this.getOpacity()),i},e.prototype.setRadius=function(t){this.radius_=t,this.render()},e})(gd),Yr=(function(){function n(e){var t=e||{};this.color_=t.color!==void 0?t.color:null}return n.prototype.clone=function(){var e=this.getColor();return new n({color:Array.isArray(e)?e.slice():e||void 0})},n.prototype.getColor=function(){return this.color_},n.prototype.setColor=function(e){this.color_=e},n})(),ro=(function(){function n(e){var t=e||{};this.color_=t.color!==void 0?t.color:null,this.lineCap_=t.lineCap,this.lineDash_=t.lineDash!==void 0?t.lineDash:null,this.lineDashOffset_=t.lineDashOffset,this.lineJoin_=t.lineJoin,this.miterLimit_=t.miterLimit,this.width_=t.width}return n.prototype.clone=function(){var e=this.getColor();return new n({color:Array.isArray(e)?e.slice():e||void 0,lineCap:this.getLineCap(),lineDash:this.getLineDash()?this.getLineDash().slice():void 0,lineDashOffset:this.getLineDashOffset(),lineJoin:this.getLineJoin(),miterLimit:this.getMiterLimit(),width:this.getWidth()})},n.prototype.getColor=function(){return this.color_},n.prototype.getLineCap=function(){return this.lineCap_},n.prototype.getLineDash=function(){return this.lineDash_},n.prototype.getLineDashOffset=function(){return this.lineDashOffset_},n.prototype.getLineJoin=function(){return this.lineJoin_},n.prototype.getMiterLimit=function(){return this.miterLimit_},n.prototype.getWidth=function(){return this.width_},n.prototype.setColor=function(e){this.color_=e},n.prototype.setLineCap=function(e){this.lineCap_=e},n.prototype.setLineDash=function(e){this.lineDash_=e},n.prototype.setLineDashOffset=function(e){this.lineDashOffset_=e},n.prototype.setLineJoin=function(e){this.lineJoin_=e},n.prototype.setMiterLimit=function(e){this.miterLimit_=e},n.prototype.setWidth=function(e){this.width_=e},n})(),Vh=(function(){function n(e){var t=e||{};this.geometry_=null,this.geometryFunction_=os,t.geometry!==void 0&&this.setGeometry(t.geometry),this.fill_=t.fill!==void 0?t.fill:null,this.image_=t.image!==void 0?t.image:null,this.renderer_=t.renderer!==void 0?t.renderer:null,this.hitDetectionRenderer_=t.hitDetectionRenderer!==void 0?t.hitDetectionRenderer:null,this.stroke_=t.stroke!==void 0?t.stroke:null,this.text_=t.text!==void 0?t.text:null,this.zIndex_=t.zIndex}return n.prototype.clone=function(){var e=this.getGeometry();return e&&typeof e=="object"&&(e=e.clone()),new n({geometry:e,fill:this.getFill()?this.getFill().clone():void 0,image:this.getImage()?this.getImage().clone():void 0,renderer:this.getRenderer(),stroke:this.getStroke()?this.getStroke().clone():void 0,text:this.getText()?this.getText().clone():void 0,zIndex:this.getZIndex()})},n.prototype.getRenderer=function(){return this.renderer_},n.prototype.setRenderer=function(e){this.renderer_=e},n.prototype.setHitDetectionRenderer=function(e){this.hitDetectionRenderer_=e},n.prototype.getHitDetectionRenderer=function(){return this.hitDetectionRenderer_},n.prototype.getGeometry=function(){return this.geometry_},n.prototype.getGeometryFunction=function(){return this.geometryFunction_},n.prototype.getFill=function(){return this.fill_},n.prototype.setFill=function(e){this.fill_=e},n.prototype.getImage=function(){return this.image_},n.prototype.setImage=function(e){this.image_=e},n.prototype.getStroke=function(){return this.stroke_},n.prototype.setStroke=function(e){this.stroke_=e},n.prototype.getText=function(){return this.text_},n.prototype.setText=function(e){this.text_=e},n.prototype.getZIndex=function(){return this.zIndex_},n.prototype.setGeometry=function(e){typeof e=="function"?this.geometryFunction_=e:typeof e=="string"?this.geometryFunction_=function(t){return t.get(e)}:e?e!==void 0&&(this.geometryFunction_=function(){return e}):this.geometryFunction_=os,this.geometry_=e},n.prototype.setZIndex=function(e){this.zIndex_=e},n})();function xd(n){var e;if(typeof n=="function")e=n;else{var t;if(Array.isArray(n))t=n;else{Y(typeof n.getZIndex=="function",41);var i=n;t=[i]}e=function(){return t}}return e}var sa=null;function Ed(n,e){if(!sa){var t=new Yr({color:"rgba(255,255,255,0.4)"}),i=new ro({color:"#3399CC",width:1.25});sa=[new Vh({image:new md({fill:t,stroke:i,radius:5}),fill:t,stroke:i})]}return sa}function os(n){return n.getGeometry()}var Md=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ss={RENDER_ORDER:"renderOrder"},Td=(function(n){Md(e,n);function e(t){var i=this,r=t||{},a=it({},r);return delete a.style,delete a.renderBuffer,delete a.updateWhileAnimating,delete a.updateWhileInteracting,i=n.call(this,a)||this,i.declutter_=r.declutter!==void 0?r.declutter:!1,i.renderBuffer_=r.renderBuffer!==void 0?r.renderBuffer:100,i.style_=null,i.styleFunction_=void 0,i.setStyle(r.style),i.updateWhileAnimating_=r.updateWhileAnimating!==void 0?r.updateWhileAnimating:!1,i.updateWhileInteracting_=r.updateWhileInteracting!==void 0?r.updateWhileInteracting:!1,i}return e.prototype.getDeclutter=function(){return this.declutter_},e.prototype.getFeatures=function(t){return n.prototype.getFeatures.call(this,t)},e.prototype.getRenderBuffer=function(){return this.renderBuffer_},e.prototype.getRenderOrder=function(){return this.get(ss.RENDER_ORDER)},e.prototype.getStyle=function(){return this.style_},e.prototype.getStyleFunction=function(){return this.styleFunction_},e.prototype.getUpdateWhileAnimating=function(){return this.updateWhileAnimating_},e.prototype.getUpdateWhileInteracting=function(){return this.updateWhileInteracting_},e.prototype.renderDeclutter=function(t){t.declutterTree||(t.declutterTree=new Xh(9)),this.getRenderer().renderDeclutter(t)},e.prototype.setRenderOrder=function(t){this.set(ss.RENDER_ORDER,t)},e.prototype.setStyle=function(t){this.style_=t!==void 0?t:Ed,this.styleFunction_=t===null?void 0:xd(this.style_),this.changed()},e})(Ln),F={BEGIN_GEOMETRY:0,BEGIN_PATH:1,CIRCLE:2,CLOSE_PATH:3,CUSTOM:4,DRAW_CHARS:5,DRAW_IMAGE:6,END_GEOMETRY:7,FILL:8,MOVE_TO_LINE_TO:9,SET_FILL_STYLE:10,SET_STROKE_STYLE:11,STROKE:12},rr=[F.FILL],Le=[F.STROKE],Ze=[F.BEGIN_PATH],hs=[F.CLOSE_PATH],qh=(function(){function n(){}return n.prototype.drawCustom=function(e,t,i,r){},n.prototype.drawGeometry=function(e){},n.prototype.setStyle=function(e){},n.prototype.drawCircle=function(e,t){},n.prototype.drawFeature=function(e,t){},n.prototype.drawGeometryCollection=function(e,t){},n.prototype.drawLineString=function(e,t){},n.prototype.drawMultiLineString=function(e,t){},n.prototype.drawMultiPoint=function(e,t){},n.prototype.drawMultiPolygon=function(e,t){},n.prototype.drawPoint=function(e,t){},n.prototype.drawPolygon=function(e,t){},n.prototype.drawText=function(e,t){},n.prototype.setFillStrokeStyle=function(e,t){},n.prototype.setImageStyle=function(e,t){},n.prototype.setTextStyle=function(e,t){},n})(),Cd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Fn=(function(n){Cd(e,n);function e(t,i,r,a){var o=n.call(this)||this;return o.tolerance=t,o.maxExtent=i,o.pixelRatio=a,o.maxLineWidth=0,o.resolution=r,o.beginGeometryInstruction1_=null,o.beginGeometryInstruction2_=null,o.bufferedMaxExtent_=null,o.instructions=[],o.coordinates=[],o.tmpCoordinate_=[],o.hitDetectionInstructions=[],o.state={},o}return e.prototype.applyPixelRatio=function(t){var i=this.pixelRatio;return i==1?t:t.map(function(r){return r*i})},e.prototype.appendFlatPointCoordinates=function(t,i){for(var r=this.getBufferedMaxExtent(),a=this.tmpCoordinate_,o=this.coordinates,s=o.length,h=0,l=t.length;h<l;h+=i)a[0]=t[h],a[1]=t[h+1],Ui(r,a)&&(o[s++]=a[0],o[s++]=a[1]);return s},e.prototype.appendFlatLineCoordinates=function(t,i,r,a,o,s){var h=this.coordinates,l=h.length,u=this.getBufferedMaxExtent();s&&(i+=a);var c=t[i],f=t[i+1],d=this.tmpCoordinate_,v=!0,_,p,g;for(_=i+a;_<r;_+=a)d[0]=t[_],d[1]=t[_+1],g=Ma(u,d),g!==p?(v&&(h[l++]=c,h[l++]=f,v=!1),h[l++]=d[0],h[l++]=d[1]):g===vt.INTERSECTING?(h[l++]=d[0],h[l++]=d[1],v=!1):v=!0,c=d[0],f=d[1],p=g;return(o&&v||_===i+a)&&(h[l++]=c,h[l++]=f),l},e.prototype.drawCustomCoordinates_=function(t,i,r,a,o){for(var s=0,h=r.length;s<h;++s){var l=r[s],u=this.appendFlatLineCoordinates(t,i,l,a,!1,!1);o.push(u),i=l}return i},e.prototype.drawCustom=function(t,i,r,a){this.beginGeometry(t,i);var o=t.getType(),s=t.getStride(),h=this.coordinates.length,l,u,c,f,d;switch(o){case W.MULTI_POLYGON:l=t.getOrientedFlatCoordinates(),f=[];var v=t.getEndss();d=0;for(var _=0,p=v.length;_<p;++_){var g=[];d=this.drawCustomCoordinates_(l,d,v[_],s,g),f.push(g)}this.instructions.push([F.CUSTOM,h,f,t,r,Qo]),this.hitDetectionInstructions.push([F.CUSTOM,h,f,t,a||r,Qo]);break;case W.POLYGON:case W.MULTI_LINE_STRING:c=[],l=o==W.POLYGON?t.getOrientedFlatCoordinates():t.getFlatCoordinates(),d=this.drawCustomCoordinates_(l,0,t.getEnds(),s,c),this.instructions.push([F.CUSTOM,h,c,t,r,Cr]),this.hitDetectionInstructions.push([F.CUSTOM,h,c,t,a||r,Cr]);break;case W.LINE_STRING:case W.CIRCLE:l=t.getFlatCoordinates(),u=this.appendFlatLineCoordinates(l,0,l.length,s,!1,!1),this.instructions.push([F.CUSTOM,h,u,t,r,Ei]),this.hitDetectionInstructions.push([F.CUSTOM,h,u,t,a||r,Ei]);break;case W.MULTI_POINT:l=t.getFlatCoordinates(),u=this.appendFlatPointCoordinates(l,s),u>h&&(this.instructions.push([F.CUSTOM,h,u,t,r,Ei]),this.hitDetectionInstructions.push([F.CUSTOM,h,u,t,a||r,Ei]));break;case W.POINT:l=t.getFlatCoordinates(),this.coordinates.push(l[0],l[1]),u=this.coordinates.length,this.instructions.push([F.CUSTOM,h,u,t,r]),this.hitDetectionInstructions.push([F.CUSTOM,h,u,t,a||r]);break}this.endGeometry(i)},e.prototype.beginGeometry=function(t,i){this.beginGeometryInstruction1_=[F.BEGIN_GEOMETRY,i,0,t],this.instructions.push(this.beginGeometryInstruction1_),this.beginGeometryInstruction2_=[F.BEGIN_GEOMETRY,i,0,t],this.hitDetectionInstructions.push(this.beginGeometryInstruction2_)},e.prototype.finish=function(){return{instructions:this.instructions,hitDetectionInstructions:this.hitDetectionInstructions,coordinates:this.coordinates}},e.prototype.reverseHitDetectionInstructions=function(){var t=this.hitDetectionInstructions;t.reverse();var i,r=t.length,a,o,s=-1;for(i=0;i<r;++i)a=t[i],o=a[0],o==F.END_GEOMETRY?s=i:o==F.BEGIN_GEOMETRY&&(a[2]=i,su(this.hitDetectionInstructions,s,i),s=-1)},e.prototype.setFillStrokeStyle=function(t,i){var r=this.state;if(t){var a=t.getColor();r.fillStyle=te(a||ve)}else r.fillStyle=void 0;if(i){var o=i.getColor();r.strokeStyle=te(o||Mn);var s=i.getLineCap();r.lineCap=s!==void 0?s:xr;var h=i.getLineDash();r.lineDash=h?h.slice():mn;var l=i.getLineDashOffset();r.lineDashOffset=l||xn;var u=i.getLineJoin();r.lineJoin=u!==void 0?u:Fi;var c=i.getWidth();r.lineWidth=c!==void 0?c:Cn;var f=i.getMiterLimit();r.miterLimit=f!==void 0?f:En,r.lineWidth>this.maxLineWidth&&(this.maxLineWidth=r.lineWidth,this.bufferedMaxExtent_=null)}else r.strokeStyle=void 0,r.lineCap=void 0,r.lineDash=null,r.lineDashOffset=void 0,r.lineJoin=void 0,r.lineWidth=void 0,r.miterLimit=void 0},e.prototype.createFill=function(t){var i=t.fillStyle,r=[F.SET_FILL_STYLE,i];return typeof i!="string"&&r.push(!0),r},e.prototype.applyStroke=function(t){this.instructions.push(this.createStroke(t))},e.prototype.createStroke=function(t){return[F.SET_STROKE_STYLE,t.strokeStyle,t.lineWidth*this.pixelRatio,t.lineCap,t.lineJoin,t.miterLimit,this.applyPixelRatio(t.lineDash),t.lineDashOffset*this.pixelRatio]},e.prototype.updateFillStyle=function(t,i){var r=t.fillStyle;(typeof r!="string"||t.currentFillStyle!=r)&&(r!==void 0&&this.instructions.push(i.call(this,t)),t.currentFillStyle=r)},e.prototype.updateStrokeStyle=function(t,i){var r=t.strokeStyle,a=t.lineCap,o=t.lineDash,s=t.lineDashOffset,h=t.lineJoin,l=t.lineWidth,u=t.miterLimit;(t.currentStrokeStyle!=r||t.currentLineCap!=a||o!=t.currentLineDash&&!ai(t.currentLineDash,o)||t.currentLineDashOffset!=s||t.currentLineJoin!=h||t.currentLineWidth!=l||t.currentMiterLimit!=u)&&(r!==void 0&&i.call(this,t),t.currentStrokeStyle=r,t.currentLineCap=a,t.currentLineDash=o,t.currentLineDashOffset=s,t.currentLineJoin=h,t.currentLineWidth=l,t.currentMiterLimit=u)},e.prototype.endGeometry=function(t){this.beginGeometryInstruction1_[2]=this.instructions.length,this.beginGeometryInstruction1_=null,this.beginGeometryInstruction2_[2]=this.hitDetectionInstructions.length,this.beginGeometryInstruction2_=null;var i=[F.END_GEOMETRY,t];this.instructions.push(i),this.hitDetectionInstructions.push(i)},e.prototype.getBufferedMaxExtent=function(){if(!this.bufferedMaxExtent_&&(this.bufferedMaxExtent_=ah(this.maxExtent),this.maxLineWidth>0)){var t=this.resolution*(this.maxLineWidth+1)/2;gn(this.bufferedMaxExtent_,t,this.bufferedMaxExtent_)}return this.bufferedMaxExtent_},e})(qh),Rd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),wd=(function(n){Rd(e,n);function e(t,i,r,a){var o=n.call(this,t,i,r,a)||this;return o.hitDetectionImage_=null,o.image_=null,o.imagePixelRatio_=void 0,o.anchorX_=void 0,o.anchorY_=void 0,o.height_=void 0,o.opacity_=void 0,o.originX_=void 0,o.originY_=void 0,o.rotateWithView_=void 0,o.rotation_=void 0,o.scale_=void 0,o.width_=void 0,o.declutterImageWithText_=void 0,o}return e.prototype.drawPoint=function(t,i){if(this.image_){this.beginGeometry(t,i);var r=t.getFlatCoordinates(),a=t.getStride(),o=this.coordinates.length,s=this.appendFlatPointCoordinates(r,a);this.instructions.push([F.DRAW_IMAGE,o,s,this.image_,this.anchorX_*this.imagePixelRatio_,this.anchorY_*this.imagePixelRatio_,Math.ceil(this.height_*this.imagePixelRatio_),this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,[this.scale_[0]*this.pixelRatio/this.imagePixelRatio_,this.scale_[1]*this.pixelRatio/this.imagePixelRatio_],Math.ceil(this.width_*this.imagePixelRatio_),this.declutterImageWithText_]),this.hitDetectionInstructions.push([F.DRAW_IMAGE,o,s,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.width_,this.declutterImageWithText_]),this.endGeometry(i)}},e.prototype.drawMultiPoint=function(t,i){if(this.image_){this.beginGeometry(t,i);var r=t.getFlatCoordinates(),a=t.getStride(),o=this.coordinates.length,s=this.appendFlatPointCoordinates(r,a);this.instructions.push([F.DRAW_IMAGE,o,s,this.image_,this.anchorX_*this.imagePixelRatio_,this.anchorY_*this.imagePixelRatio_,Math.ceil(this.height_*this.imagePixelRatio_),this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,[this.scale_[0]*this.pixelRatio/this.imagePixelRatio_,this.scale_[1]*this.pixelRatio/this.imagePixelRatio_],Math.ceil(this.width_*this.imagePixelRatio_),this.declutterImageWithText_]),this.hitDetectionInstructions.push([F.DRAW_IMAGE,o,s,this.hitDetectionImage_,this.anchorX_,this.anchorY_,this.height_,this.opacity_,this.originX_,this.originY_,this.rotateWithView_,this.rotation_,this.scale_,this.width_,this.declutterImageWithText_]),this.endGeometry(i)}},e.prototype.finish=function(){return this.reverseHitDetectionInstructions(),this.anchorX_=void 0,this.anchorY_=void 0,this.hitDetectionImage_=null,this.image_=null,this.imagePixelRatio_=void 0,this.height_=void 0,this.scale_=void 0,this.opacity_=void 0,this.originX_=void 0,this.originY_=void 0,this.rotateWithView_=void 0,this.rotation_=void 0,this.width_=void 0,n.prototype.finish.call(this)},e.prototype.setImageStyle=function(t,i){var r=t.getAnchor(),a=t.getSize(),o=t.getHitDetectionImage(),s=t.getImage(this.pixelRatio),h=t.getOrigin();this.imagePixelRatio_=t.getPixelRatio(this.pixelRatio),this.anchorX_=r[0],this.anchorY_=r[1],this.hitDetectionImage_=o,this.image_=s,this.height_=a[1],this.opacity_=t.getOpacity(),this.originX_=h[0]*this.imagePixelRatio_,this.originY_=h[1]*this.imagePixelRatio_,this.rotateWithView_=t.getRotateWithView(),this.rotation_=t.getRotation(),this.scale_=t.getScaleArray(),this.width_=a[0],this.declutterImageWithText_=i},e})(Fn),Id=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Sd=(function(n){Id(e,n);function e(t,i,r,a){return n.call(this,t,i,r,a)||this}return e.prototype.drawFlatCoordinates_=function(t,i,r,a){var o=this.coordinates.length,s=this.appendFlatLineCoordinates(t,i,r,a,!1,!1),h=[F.MOVE_TO_LINE_TO,o,s];return this.instructions.push(h),this.hitDetectionInstructions.push(h),r},e.prototype.drawLineString=function(t,i){var r=this.state,a=r.strokeStyle,o=r.lineWidth;if(!(a===void 0||o===void 0)){this.updateStrokeStyle(r,this.applyStroke),this.beginGeometry(t,i),this.hitDetectionInstructions.push([F.SET_STROKE_STYLE,r.strokeStyle,r.lineWidth,r.lineCap,r.lineJoin,r.miterLimit,mn,xn],Ze);var s=t.getFlatCoordinates(),h=t.getStride();this.drawFlatCoordinates_(s,0,s.length,h),this.hitDetectionInstructions.push(Le),this.endGeometry(i)}},e.prototype.drawMultiLineString=function(t,i){var r=this.state,a=r.strokeStyle,o=r.lineWidth;if(!(a===void 0||o===void 0)){this.updateStrokeStyle(r,this.applyStroke),this.beginGeometry(t,i),this.hitDetectionInstructions.push([F.SET_STROKE_STYLE,r.strokeStyle,r.lineWidth,r.lineCap,r.lineJoin,r.miterLimit,r.lineDash,r.lineDashOffset],Ze);for(var s=t.getEnds(),h=t.getFlatCoordinates(),l=t.getStride(),u=0,c=0,f=s.length;c<f;++c)u=this.drawFlatCoordinates_(h,u,s[c],l);this.hitDetectionInstructions.push(Le),this.endGeometry(i)}},e.prototype.finish=function(){var t=this.state;return t.lastStroke!=null&&t.lastStroke!=this.coordinates.length&&this.instructions.push(Le),this.reverseHitDetectionInstructions(),this.state=null,n.prototype.finish.call(this)},e.prototype.applyStroke=function(t){t.lastStroke!=null&&t.lastStroke!=this.coordinates.length&&(this.instructions.push(Le),t.lastStroke=this.coordinates.length),t.lastStroke=0,n.prototype.applyStroke.call(this,t),this.instructions.push(Ze)},e})(Fn),Od=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ls=(function(n){Od(e,n);function e(t,i,r,a){return n.call(this,t,i,r,a)||this}return e.prototype.drawFlatCoordinatess_=function(t,i,r,a){var o=this.state,s=o.fillStyle!==void 0,h=o.strokeStyle!==void 0,l=r.length;this.instructions.push(Ze),this.hitDetectionInstructions.push(Ze);for(var u=0;u<l;++u){var c=r[u],f=this.coordinates.length,d=this.appendFlatLineCoordinates(t,i,c,a,!0,!h),v=[F.MOVE_TO_LINE_TO,f,d];this.instructions.push(v),this.hitDetectionInstructions.push(v),h&&(this.instructions.push(hs),this.hitDetectionInstructions.push(hs)),i=c}return s&&(this.instructions.push(rr),this.hitDetectionInstructions.push(rr)),h&&(this.instructions.push(Le),this.hitDetectionInstructions.push(Le)),i},e.prototype.drawCircle=function(t,i){var r=this.state,a=r.fillStyle,o=r.strokeStyle;if(!(a===void 0&&o===void 0)){this.setFillStrokeStyles_(),this.beginGeometry(t,i),r.fillStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_FILL_STYLE,ve]),r.strokeStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_STROKE_STYLE,r.strokeStyle,r.lineWidth,r.lineCap,r.lineJoin,r.miterLimit,r.lineDash,r.lineDashOffset]);var s=t.getFlatCoordinates(),h=t.getStride(),l=this.coordinates.length;this.appendFlatLineCoordinates(s,0,s.length,h,!1,!1);var u=[F.CIRCLE,l];this.instructions.push(Ze,u),this.hitDetectionInstructions.push(Ze,u),r.fillStyle!==void 0&&(this.instructions.push(rr),this.hitDetectionInstructions.push(rr)),r.strokeStyle!==void 0&&(this.instructions.push(Le),this.hitDetectionInstructions.push(Le)),this.endGeometry(i)}},e.prototype.drawPolygon=function(t,i){var r=this.state,a=r.fillStyle,o=r.strokeStyle;if(!(a===void 0&&o===void 0)){this.setFillStrokeStyles_(),this.beginGeometry(t,i),r.fillStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_FILL_STYLE,ve]),r.strokeStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_STROKE_STYLE,r.strokeStyle,r.lineWidth,r.lineCap,r.lineJoin,r.miterLimit,r.lineDash,r.lineDashOffset]);var s=t.getEnds(),h=t.getOrientedFlatCoordinates(),l=t.getStride();this.drawFlatCoordinatess_(h,0,s,l),this.endGeometry(i)}},e.prototype.drawMultiPolygon=function(t,i){var r=this.state,a=r.fillStyle,o=r.strokeStyle;if(!(a===void 0&&o===void 0)){this.setFillStrokeStyles_(),this.beginGeometry(t,i),r.fillStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_FILL_STYLE,ve]),r.strokeStyle!==void 0&&this.hitDetectionInstructions.push([F.SET_STROKE_STYLE,r.strokeStyle,r.lineWidth,r.lineCap,r.lineJoin,r.miterLimit,r.lineDash,r.lineDashOffset]);for(var s=t.getEndss(),h=t.getOrientedFlatCoordinates(),l=t.getStride(),u=0,c=0,f=s.length;c<f;++c)u=this.drawFlatCoordinatess_(h,u,s[c],l);this.endGeometry(i)}},e.prototype.finish=function(){this.reverseHitDetectionInstructions(),this.state=null;var t=this.tolerance;if(t!==0)for(var i=this.coordinates,r=0,a=i.length;r<a;++r)i[r]=qe(i[r],t);return n.prototype.finish.call(this)},e.prototype.setFillStrokeStyles_=function(){var t=this.state,i=t.fillStyle;i!==void 0&&this.updateFillStyle(t,this.createFill),t.strokeStyle!==void 0&&this.updateStrokeStyle(t,this.applyStroke)},e})(Fn);const Kh={POINT:"point",LINE:"line"};function Ad(n,e,t,i,r){var a=t,o=t,s=0,h=0,l=t,u,c,f,d,v,_,p,g,y,m;for(c=t;c<i;c+=r){var x=e[c],E=e[c+1];v!==void 0&&(y=x-v,m=E-_,d=Math.sqrt(y*y+m*m),p!==void 0&&(h+=f,u=Math.acos((p*y+g*m)/(f*d)),u>n&&(h>s&&(s=h,a=l,o=c),h=0,l=c-r)),f=d,p=y,g=m),v=x,_=E}return h+=d,h>s?[l,c]:[a,o]}var Pd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Rr={left:0,end:0,center:.5,right:1,start:1,top:0,middle:.5,hanging:.2,alphabetic:.8,ideographic:.8,bottom:1},Ld=(function(n){Pd(e,n);function e(t,i,r,a){var o=n.call(this,t,i,r,a)||this;return o.labels_=null,o.text_="",o.textOffsetX_=0,o.textOffsetY_=0,o.textRotateWithView_=void 0,o.textRotation_=0,o.textFillState_=null,o.fillStates={},o.textStrokeState_=null,o.strokeStates={},o.textState_={},o.textStates={},o.textKey_="",o.fillKey_="",o.strokeKey_="",o.declutterImageWithText_=void 0,o}return e.prototype.finish=function(){var t=n.prototype.finish.call(this);return t.textStates=this.textStates,t.fillStates=this.fillStates,t.strokeStates=this.strokeStates,t},e.prototype.drawText=function(t,i){var r=this.textFillState_,a=this.textStrokeState_,o=this.textState_;if(!(this.text_===""||!o||!r&&!a)){var s=this.coordinates,h=s.length,l=t.getType(),u=null,c=t.getStride();if(o.placement===Kh.LINE&&(l==W.LINE_STRING||l==W.MULTI_LINE_STRING||l==W.POLYGON||l==W.MULTI_POLYGON)){if(!Ct(this.getBufferedMaxExtent(),t.getExtent()))return;var f=void 0;if(u=t.getFlatCoordinates(),l==W.LINE_STRING)f=[u.length];else if(l==W.MULTI_LINE_STRING)f=t.getEnds();else if(l==W.POLYGON)f=t.getEnds().slice(0,1);else if(l==W.MULTI_POLYGON){var d=t.getEndss();f=[];for(var v=0,_=d.length;v<_;++v)f.push(d[v][0])}this.beginGeometry(t,i);for(var p=o.textAlign,g=0,y=void 0,m=0,x=f.length;m<x;++m){if(p==null){var E=Ad(o.maxAngle,u,g,f[m],c);g=E[0],y=E[1]}else y=f[m];for(var v=g;v<y;v+=c)s.push(u[v],u[v+1]);var M=s.length;g=f[m],this.drawChars_(h,M),h=M}this.endGeometry(i)}else{var C=o.overflow?null:[];switch(l){case W.POINT:case W.MULTI_POINT:u=t.getFlatCoordinates();break;case W.LINE_STRING:u=t.getFlatMidpoint();break;case W.CIRCLE:u=t.getCenter();break;case W.MULTI_LINE_STRING:u=t.getFlatMidpoints(),c=2;break;case W.POLYGON:u=t.getFlatInteriorPoint(),o.overflow||C.push(u[2]/this.resolution),c=3;break;case W.MULTI_POLYGON:var T=t.getFlatInteriorPoints();u=[];for(var v=0,_=T.length;v<_;v+=3)o.overflow||C.push(T[v+2]/this.resolution),u.push(T[v],T[v+1]);if(u.length===0)return;c=2;break}var M=this.appendFlatPointCoordinates(u,c);if(M===h)return;if(C&&(M-h)/2!==u.length/c){var I=h/2;C=C.filter(function(K,V){var $=s[(I+V)*2]===u[V*c]&&s[(I+V)*2+1]===u[V*c+1];return $||--I,$})}this.saveTextStates_(),(o.backgroundFill||o.backgroundStroke)&&(this.setFillStrokeStyle(o.backgroundFill,o.backgroundStroke),o.backgroundFill&&(this.updateFillStyle(this.state,this.createFill),this.hitDetectionInstructions.push(this.createFill(this.state))),o.backgroundStroke&&(this.updateStrokeStyle(this.state,this.applyStroke),this.hitDetectionInstructions.push(this.createStroke(this.state)))),this.beginGeometry(t,i);var A=o.padding;if(A!=Ke&&(o.scale[0]<0||o.scale[1]<0)){var P=o.padding[0],b=o.padding[1],L=o.padding[2],j=o.padding[3];o.scale[0]<0&&(b=-b,j=-j),o.scale[1]<0&&(P=-P,L=-L),A=[P,b,L,j]}var N=this.pixelRatio;this.instructions.push([F.DRAW_IMAGE,h,M,null,NaN,NaN,NaN,1,0,0,this.textRotateWithView_,this.textRotation_,[1,1],NaN,this.declutterImageWithText_,A==Ke?Ke:A.map(function(K){return K*N}),!!o.backgroundFill,!!o.backgroundStroke,this.text_,this.textKey_,this.strokeKey_,this.fillKey_,this.textOffsetX_,this.textOffsetY_,C]);var G=1/N;this.hitDetectionInstructions.push([F.DRAW_IMAGE,h,M,null,NaN,NaN,NaN,1,0,0,this.textRotateWithView_,this.textRotation_,[G,G],NaN,this.declutterImageWithText_,A,!!o.backgroundFill,!!o.backgroundStroke,this.text_,this.textKey_,this.strokeKey_,this.fillKey_,this.textOffsetX_,this.textOffsetY_,C]),this.endGeometry(i)}}},e.prototype.saveTextStates_=function(){var t=this.textStrokeState_,i=this.textState_,r=this.textFillState_,a=this.strokeKey_;t&&(a in this.strokeStates||(this.strokeStates[a]={strokeStyle:t.strokeStyle,lineCap:t.lineCap,lineDashOffset:t.lineDashOffset,lineWidth:t.lineWidth,lineJoin:t.lineJoin,miterLimit:t.miterLimit,lineDash:t.lineDash}));var o=this.textKey_;o in this.textStates||(this.textStates[o]={font:i.font,textAlign:i.textAlign||Tn,textBaseline:i.textBaseline||Er,scale:i.scale});var s=this.fillKey_;r&&(s in this.fillStates||(this.fillStates[s]={fillStyle:r.fillStyle}))},e.prototype.drawChars_=function(t,i){var r=this.textStrokeState_,a=this.textState_,o=this.strokeKey_,s=this.textKey_,h=this.fillKey_;this.saveTextStates_();var l=this.pixelRatio,u=Rr[a.textBaseline],c=this.textOffsetY_*l,f=this.text_,d=r?r.lineWidth*Math.abs(a.scale[0])/2:0;this.instructions.push([F.DRAW_CHARS,t,i,u,a.overflow,h,a.maxAngle,l,c,o,d*l,f,s,1]),this.hitDetectionInstructions.push([F.DRAW_CHARS,t,i,u,a.overflow,h,a.maxAngle,1,c,o,d,f,s,1/l])},e.prototype.setTextStyle=function(t,i){var r,a,o;if(!t)this.text_="";else{var s=t.getFill();s?(a=this.textFillState_,a||(a={},this.textFillState_=a),a.fillStyle=te(s.getColor()||ve)):(a=null,this.textFillState_=a);var h=t.getStroke();if(!h)o=null,this.textStrokeState_=o;else{o=this.textStrokeState_,o||(o={},this.textStrokeState_=o);var l=h.getLineDash(),u=h.getLineDashOffset(),c=h.getWidth(),f=h.getMiterLimit();o.lineCap=h.getLineCap()||xr,o.lineDash=l?l.slice():mn,o.lineDashOffset=u===void 0?xn:u,o.lineJoin=h.getLineJoin()||Fi,o.lineWidth=c===void 0?Cn:c,o.miterLimit=f===void 0?En:f,o.strokeStyle=te(h.getColor()||Mn)}r=this.textState_;var d=t.getFont()||xh;Of(d);var v=t.getScaleArray();r.overflow=t.getOverflow(),r.font=d,r.maxAngle=t.getMaxAngle(),r.placement=t.getPlacement(),r.textAlign=t.getTextAlign(),r.textBaseline=t.getTextBaseline()||Er,r.backgroundFill=t.getBackgroundFill(),r.backgroundStroke=t.getBackgroundStroke(),r.padding=t.getPadding()||Ke,r.scale=v===void 0?[1,1]:v;var _=t.getOffsetX(),p=t.getOffsetY(),g=t.getRotateWithView(),y=t.getRotation();this.text_=t.getText()||"",this.textOffsetX_=_===void 0?0:_,this.textOffsetY_=p===void 0?0:p,this.textRotateWithView_=g===void 0?!1:g,this.textRotation_=y===void 0?0:y,this.strokeKey_=o?(typeof o.strokeStyle=="string"?o.strokeStyle:H(o.strokeStyle))+o.lineCap+o.lineDashOffset+"|"+o.lineWidth+o.lineJoin+o.miterLimit+"["+o.lineDash.join()+"]":"",this.textKey_=r.font+r.scale+(r.textAlign||"?")+(r.textBaseline||"?"),this.fillKey_=a?typeof a.fillStyle=="string"?a.fillStyle:"|"+H(a.fillStyle):""}this.declutterImageWithText_=i},e})(Fn),Nd={Circle:ls,Default:Fn,Image:wd,LineString:Sd,Polygon:ls,Text:Ld},us=(function(){function n(e,t,i,r){this.tolerance_=e,this.maxExtent_=t,this.pixelRatio_=r,this.resolution_=i,this.buildersByZIndex_={}}return n.prototype.finish=function(){var e={};for(var t in this.buildersByZIndex_){e[t]=e[t]||{};var i=this.buildersByZIndex_[t];for(var r in i){var a=i[r].finish();e[t][r]=a}}return e},n.prototype.getBuilder=function(e,t){var i=e!==void 0?e.toString():"0",r=this.buildersByZIndex_[i];r===void 0&&(r={},this.buildersByZIndex_[i]=r);var a=r[t];if(a===void 0){var o=Nd[t];a=new o(this.tolerance_,this.maxExtent_,this.resolution_,this.pixelRatio_),r[t]=a}return a},n})(),bd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Dd=(function(n){bd(e,n);function e(t){var i=n.call(this)||this;return i.ready=!0,i.boundHandleImageChange_=i.handleImageChange_.bind(i),i.layer_=t,i.declutterExecutorGroup=null,i}return e.prototype.getFeatures=function(t){return q()},e.prototype.getData=function(t){return null},e.prototype.prepareFrame=function(t){return q()},e.prototype.renderFrame=function(t,i){return q()},e.prototype.loadedTileCallback=function(t,i,r){t[i]||(t[i]={}),t[i][r.tileCoord.toString()]=r},e.prototype.createLoadedTileFinder=function(t,i,r){return(function(a,o){var s=this.loadedTileCallback.bind(this,r,a);return t.forEachLoadedTile(i,a,o,s)}).bind(this)},e.prototype.forEachFeatureAtCoordinate=function(t,i,r,a,o){},e.prototype.getDataAtPixel=function(t,i,r){return null},e.prototype.getLayer=function(){return this.layer_},e.prototype.handleFontsChanged=function(){},e.prototype.handleImageChange_=function(t){var i=t.target;i.getState()===X.LOADED&&this.renderIfReadyAndVisible()},e.prototype.loadImage=function(t){var i=t.getState();return i!=X.LOADED&&i!=X.ERROR&&t.addEventListener(B.CHANGE,this.boundHandleImageChange_),i==X.IDLE&&(t.load(),i=t.getState()),i==X.LOADED},e.prototype.renderIfReadyAndVisible=function(){var t=this.getLayer();t.getVisible()&&t.getSourceState()==ii.READY&&t.changed()},e.prototype.disposeInternal=function(){delete this.layer_,n.prototype.disposeInternal.call(this)},e})(Pn),Fd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),on=null;function Gd(){var n=document.createElement("canvas");n.width=1,n.height=1,on=n.getContext("2d")}var ao=(function(n){Fd(e,n);function e(t){var i=n.call(this,t)||this;return i.container=null,i.renderedResolution,i.tempTransform=ie(),i.pixelTransform=ie(),i.inversePixelTransform=ie(),i.context=null,i.containerReused=!1,i.pixelContext_=null,i.frameState=null,i}return e.prototype.getImageData=function(t,i,r){on||Gd(),on.clearRect(0,0,1,1);var a;try{on.drawImage(t,i,r,1,1,0,0,1,1),a=on.getImageData(0,0,1,1).data}catch{return null}return a},e.prototype.getBackground=function(t){var i=this.getLayer(),r=i.getBackground();return typeof r=="function"&&(r=r(t.viewState.resolution)),r||void 0},e.prototype.useContainer=function(t,i,r,a){var o=this.getLayer().getClassName(),s,h;if(t&&t.className===o&&t.style.opacity===""&&r===1&&(!a||t.style.backgroundColor&&ai(yr(t.style.backgroundColor),yr(a)))){var l=t.firstElementChild;l instanceof HTMLCanvasElement&&(h=l.getContext("2d"))}if(h&&h.canvas.style.transform===i?(this.container=t,this.context=h,this.containerReused=!0):this.containerReused&&(this.container=null,this.context=null,this.containerReused=!1),!this.container){s=document.createElement("div"),s.className=o;var u=s.style;u.position="absolute",u.width="100%",u.height="100%",a&&(u.backgroundColor=a),h=Bt();var l=h.canvas;s.appendChild(l),u=l.style,u.position="absolute",u.left="0",u.transformOrigin="top left",this.container=s,this.context=h}},e.prototype.clipUnrotated=function(t,i,r){var a=oi(r),o=Ya(r),s=Xa(r),h=Wa(r);ft(i.coordinateToPixelTransform,a),ft(i.coordinateToPixelTransform,o),ft(i.coordinateToPixelTransform,s),ft(i.coordinateToPixelTransform,h);var l=this.inversePixelTransform;ft(l,a),ft(l,o),ft(l,s),ft(l,h),t.save(),t.beginPath(),t.moveTo(Math.round(a[0]),Math.round(a[1])),t.lineTo(Math.round(o[0]),Math.round(o[1])),t.lineTo(Math.round(s[0]),Math.round(s[1])),t.lineTo(Math.round(h[0]),Math.round(h[1])),t.clip()},e.prototype.dispatchRenderEvent_=function(t,i,r){var a=this.getLayer();if(a.hasListener(t)){var o=new mh(t,this.inversePixelTransform,r,i);a.dispatchEvent(o)}},e.prototype.preRender=function(t,i){this.frameState=i,this.dispatchRenderEvent_(ei.PRERENDER,t,i)},e.prototype.postRender=function(t,i){this.dispatchRenderEvent_(ei.POSTRENDER,t,i)},e.prototype.getRenderTransform=function(t,i,r,a,o,s,h){var l=o/2,u=s/2,c=a/i,f=-c,d=-t[0]+h,v=-t[1];return $t(this.tempTransform,l,u,c,f,-r,d,v)},e.prototype.getDataAtPixel=function(t,i,r){var a=ft(this.inversePixelTransform,t.slice()),o=this.context,s=this.getLayer(),h=s.getExtent();if(h){var l=ft(i.pixelToCoordinateTransform,t.slice());if(!Ui(h,l))return null}var u=Math.round(a[0]),c=Math.round(a[1]),f=this.pixelContext_;if(!f){var d=document.createElement("canvas");d.width=1,d.height=1,f=d.getContext("2d"),this.pixelContext_=f}f.clearRect(0,0,1,1);var v;try{f.drawImage(o.canvas,u,c,1,1,0,0,1,1),v=f.getImageData(0,0,1,1).data}catch(_){return _.name==="SecurityError"?(this.pixelContext_=null,new Uint8Array):v}return v[3]===0?null:v},e.prototype.disposeInternal=function(){delete this.frameState,n.prototype.disposeInternal.call(this)},e})(Dd);const st={CIRCLE:"Circle",DEFAULT:"Default",IMAGE:"Image",LINE_STRING:"LineString",POLYGON:"Polygon",TEXT:"Text"};function kd(n,e,t,i,r,a,o,s,h,l,u,c){var f=n[e],d=n[e+1],v=0,_=0,p=0,g=0;function y(){v=f,_=d,e+=i,f=n[e],d=n[e+1],g+=p,p=Math.sqrt((f-v)*(f-v)+(d-_)*(d-_))}do y();while(e<t-i&&g+p<a);for(var m=p===0?0:(a-g)/p,x=Ve(v,f,m),E=Ve(_,d,m),M=e-i,C=g,T=a+s*h(l,r,u);e<t-i&&g+p<T;)y();m=p===0?0:(T-g)/p;var I=Ve(v,f,m),A=Ve(_,d,m),P;if(c){var b=[x,E,I,A];Th(b,0,4,2,c,b,b),P=b[0]>b[2]}else P=x>I;var L=Math.PI,j=[],N=M+i===e;e=M,p=0,g=C,f=n[e],d=n[e+1];var G;if(N){y(),G=Math.atan2(d-_,f-v),P&&(G+=G>0?-L:L);var D=(I+x)/2,K=(A+E)/2;return j[0]=[D,K,(T-a)/2,G,r],j}for(var V=0,$=r.length;V<$;){y();var at=Math.atan2(d-_,f-v);if(P&&(at+=at>0?-L:L),G!==void 0){var w=at-G;if(w+=w>L?-2*L:w<-L?2*L:0,Math.abs(w)>o)return null}G=at;for(var ht=V,U=0;V<$;++V){var lt=P?$-V-1:V,Mt=s*h(l,r[lt],u);if(e+i<t&&g+p<a+U+Mt/2)break;U+=Mt}if(V!==ht){var Ft=P?r.substring($-ht,$-V):r.substring(ht,V);m=p===0?0:(a+U/2-g)/p;var D=Ve(v,f,m),K=Ve(_,d,m);j.push([D,K,U/2,at,Ft]),a+=U}}return j}var vi=Wt(),xe=[],le=[],ue=[],Ee=[];function fs(n){return n[3].declutterBox}var zd=new RegExp("[֑-ࣿיִ-﷿ﹰ-ﻼࠀ-࿿-]");function cs(n,e){return(e==="start"||e==="end")&&!zd.test(n)&&(e=e==="start"?"left":"right"),Rr[e]}function jd(n,e,t){return t>0&&n.push(`
`,""),n.push(e,""),n}var Ud=(function(){function n(e,t,i,r){this.overlaps=i,this.pixelRatio=t,this.resolution=e,this.alignFill_,this.instructions=r.instructions,this.coordinates=r.coordinates,this.coordinateCache_={},this.renderedTransform_=ie(),this.hitDetectionInstructions=r.hitDetectionInstructions,this.pixelCoordinates_=null,this.viewRotation_=0,this.fillStates=r.fillStates||{},this.strokeStates=r.strokeStates||{},this.textStates=r.textStates||{},this.widths_={},this.labels_={}}return n.prototype.createLabel=function(e,t,i,r){var a=e+t+i+r;if(this.labels_[a])return this.labels_[a];var o=r?this.strokeStates[r]:null,s=i?this.fillStates[i]:null,h=this.textStates[t],l=this.pixelRatio,u=[h.scale[0]*l,h.scale[1]*l],c=Array.isArray(e),f=cs(c?e[0]:e,h.textAlign||Tn),d=r&&o.lineWidth?o.lineWidth:0,v=c?e:e.split(`
`).reduce(jd,[]),_=Pf(h,v),p=_.width,g=_.height,y=_.widths,m=_.heights,x=_.lineWidths,E=p+d,M=[],C=(E+2)*u[0],T=(g+d)*u[1],I={width:C<0?Math.floor(C):Math.ceil(C),height:T<0?Math.floor(T):Math.ceil(T),contextInstructions:M};if((u[0]!=1||u[1]!=1)&&M.push("scale",u),r){M.push("strokeStyle",o.strokeStyle),M.push("lineWidth",d),M.push("lineCap",o.lineCap),M.push("lineJoin",o.lineJoin),M.push("miterLimit",o.miterLimit);var A=kr?OffscreenCanvasRenderingContext2D:CanvasRenderingContext2D;A.prototype.setLineDash&&(M.push("setLineDash",[o.lineDash]),M.push("lineDashOffset",o.lineDashOffset))}i&&M.push("fillStyle",s.fillStyle),M.push("textBaseline","middle"),M.push("textAlign","center");for(var P=.5-f,b=f*E+P*d,L=[],j=[],N=0,G=0,D=0,K=0,V,$=0,at=v.length;$<at;$+=2){var w=v[$];if(w===`
`){G+=N,N=0,b=f*E+P*d,++K;continue}var ht=v[$+1]||h.font;ht!==V&&(r&&L.push("font",ht),i&&j.push("font",ht),V=ht),N=Math.max(N,m[D]);var U=[w,b+P*y[D]+f*(y[D]-x[K]),.5*(d+N)+G];b+=y[D],r&&L.push("strokeText",U),i&&j.push("fillText",U),++D}return Array.prototype.push.apply(M,L),Array.prototype.push.apply(M,j),this.labels_[a]=I,I},n.prototype.replayTextBackground_=function(e,t,i,r,a,o,s){e.beginPath(),e.moveTo.apply(e,t),e.lineTo.apply(e,i),e.lineTo.apply(e,r),e.lineTo.apply(e,a),e.lineTo.apply(e,t),o&&(this.alignFill_=o[2],this.fill_(e)),s&&(this.setStrokeStyle_(e,s),e.stroke())},n.prototype.calculateImageOrLabelDimensions_=function(e,t,i,r,a,o,s,h,l,u,c,f,d,v,_,p){s*=f[0],h*=f[1];var g=i-s,y=r-h,m=a+l>e?e-l:a,x=o+u>t?t-u:o,E=v[3]+m*f[0]+v[1],M=v[0]+x*f[1]+v[2],C=g-v[3],T=y-v[0];(_||c!==0)&&(xe[0]=C,Ee[0]=C,xe[1]=T,le[1]=T,le[0]=C+E,ue[0]=le[0],ue[1]=T+M,Ee[1]=ue[1]);var I;return c!==0?(I=$t(ie(),i,r,1,1,c,-i,-r),ft(I,xe),ft(I,le),ft(I,ue),ft(I,Ee),ae(Math.min(xe[0],le[0],ue[0],Ee[0]),Math.min(xe[1],le[1],ue[1],Ee[1]),Math.max(xe[0],le[0],ue[0],Ee[0]),Math.max(xe[1],le[1],ue[1],Ee[1]),vi)):ae(Math.min(C,C+E),Math.min(T,T+M),Math.max(C,C+E),Math.max(T,T+M),vi),d&&(g=Math.round(g),y=Math.round(y)),{drawImageX:g,drawImageY:y,drawImageW:m,drawImageH:x,originX:l,originY:u,declutterBox:{minX:vi[0],minY:vi[1],maxX:vi[2],maxY:vi[3],value:p},canvasTransform:I,scale:f}},n.prototype.replayImageOrLabel_=function(e,t,i,r,a,o,s){var h=!!(o||s),l=r.declutterBox,u=e.canvas,c=s?s[2]*r.scale[0]/2:0,f=l.minX-c<=u.width/t&&l.maxX+c>=0&&l.minY-c<=u.height/t&&l.maxY+c>=0;return f&&(h&&this.replayTextBackground_(e,xe,le,ue,Ee,o,s),Lf(e,r.canvasTransform,a,i,r.originX,r.originY,r.drawImageW,r.drawImageH,r.drawImageX,r.drawImageY,r.scale)),!0},n.prototype.fill_=function(e){if(this.alignFill_){var t=ft(this.renderedTransform_,[0,0]),i=512*this.pixelRatio;e.save(),e.translate(t[0]%i,t[1]%i),e.rotate(this.viewRotation_)}e.fill(),this.alignFill_&&e.restore()},n.prototype.setStrokeStyle_=function(e,t){e.strokeStyle=t[1],e.lineWidth=t[2],e.lineCap=t[3],e.lineJoin=t[4],e.miterLimit=t[5],e.setLineDash&&(e.lineDashOffset=t[7],e.setLineDash(t[6]))},n.prototype.drawLabelWithPointPlacement_=function(e,t,i,r){var a=this.textStates[t],o=this.createLabel(e,t,r,i),s=this.strokeStates[i],h=this.pixelRatio,l=cs(Array.isArray(e)?e[0]:e,a.textAlign||Tn),u=Rr[a.textBaseline||Er],c=s&&s.lineWidth?s.lineWidth:0,f=o.width/h-2*a.scale[0],d=l*f+2*(.5-l)*c,v=u*o.height/h+2*(.5-u)*c;return{label:o,anchorX:d,anchorY:v}},n.prototype.execute_=function(e,t,i,r,a,o,s,h){var l;this.pixelCoordinates_&&ai(i,this.renderedTransform_)?l=this.pixelCoordinates_:(this.pixelCoordinates_||(this.pixelCoordinates_=[]),l=Qe(this.coordinates,0,this.coordinates.length,2,i,this.pixelCoordinates_),_f(this.renderedTransform_,i));for(var u=0,c=r.length,f=0,d,v,_,p,g,y,m,x,E,M,C,T,I=0,A=0,P=null,b=null,L=this.coordinateCache_,j=this.viewRotation_,N=Math.round(Math.atan2(-i[1],i[0])*1e12)/1e12,G={context:e,pixelRatio:this.pixelRatio,resolution:this.resolution,rotation:j},D=this.instructions!=r||this.overlaps?0:200,K,V,$,at;u<c;){var w=r[u],ht=w[0];switch(ht){case F.BEGIN_GEOMETRY:K=w[1],at=w[3],K.getGeometry()?s!==void 0&&!Ct(s,at.getExtent())?u=w[2]+1:++u:u=w[2];break;case F.BEGIN_PATH:I>D&&(this.fill_(e),I=0),A>D&&(e.stroke(),A=0),!I&&!A&&(e.beginPath(),p=NaN,g=NaN),++u;break;case F.CIRCLE:f=w[1];var U=l[f],lt=l[f+1],Mt=l[f+2],Ft=l[f+3],It=Mt-U,Gt=Ft-lt,si=Math.sqrt(It*It+Gt*Gt);e.moveTo(U+si,lt),e.arc(U,lt,si,0,2*Math.PI,!0),++u;break;case F.CLOSE_PATH:e.closePath(),++u;break;case F.CUSTOM:f=w[1],d=w[2];var Ht=w[3],Bn=w[4],Wn=w.length==6?w[5]:void 0;G.geometry=Ht,G.feature=K,u in L||(L[u]=[]);var ge=L[u];Wn?Wn(l,f,d,2,ge):(ge[0]=l[f],ge[1]=l[f+1],ge.length=2),Bn(ge,G),++u;break;case F.DRAW_IMAGE:f=w[1],d=w[2],x=w[3],v=w[4],_=w[5];var hi=w[6],Xn=w[7],Xi=w[8],Yn=w[9],Ue=w[10],Yi=w[11],Vn=w[12],li=w[13],ye=w[14];if(!x&&w.length>=19){E=w[18],M=w[19],C=w[20],T=w[21];var ui=this.drawLabelWithPointPlacement_(E,M,C,T);x=ui.label,w[3]=x;var Kr=w[22];v=(ui.anchorX-Kr)*this.pixelRatio,w[4]=v;var qn=w[23];_=(ui.anchorY-qn)*this.pixelRatio,w[5]=_,hi=x.height,w[6]=hi,li=x.width,w[13]=li}var Vi=void 0;w.length>24&&(Vi=w[24]);var he=void 0,Jt=void 0,Be=void 0;w.length>16?(he=w[15],Jt=w[16],Be=w[17]):(he=Ke,Jt=!1,Be=!1),Ue&&N?Yi+=j:!Ue&&!N&&(Yi-=j);for(var qi=0;f<d;f+=2)if(!(Vi&&Vi[qi++]<li/this.pixelRatio)){var St=this.calculateImageOrLabelDimensions_(x.width,x.height,l[f],l[f+1],li,hi,v,_,Xi,Yn,Yi,Vn,a,he,Jt||Be,K),Kn=[e,t,x,St,Xn,Jt?P:null,Be?b:null],pt=void 0,fi=void 0;if(h&&ye){var We=d-f;if(!ye[We]){ye[We]=Kn;continue}if(pt=ye[We],delete ye[We],fi=fs(pt),h.collides(fi))continue}h&&h.collides(St.declutterBox)||(pt&&(h&&h.insert(fi),this.replayImageOrLabel_.apply(this,pt)),h&&h.insert(St.declutterBox),this.replayImageOrLabel_.apply(this,Kn))}++u;break;case F.DRAW_CHARS:var xo=w[1],Eo=w[2],$r=w[3],$l=w[4];T=w[5];var Zl=w[6],Mo=w[7],To=w[8];C=w[9];var Zr=w[10];E=w[11],M=w[12];var Co=[w[13],w[13]],Hr=this.textStates[M],Ki=Hr.font,$i=[Hr.scale[0]*Mo,Hr.scale[1]*Mo],Zi=void 0;Ki in this.widths_?Zi=this.widths_[Ki]:(Zi={},this.widths_[Ki]=Zi);var Ro=hd(l,xo,Eo,2),wo=Math.abs($i[0])*Vo(Ki,E,Zi);if($l||wo<=Ro){var Hl=this.textStates[M].textAlign,Jl=(Ro-wo)*Rr[Hl],Hi=kd(l,xo,Eo,2,E,Jl,Zl,Math.abs($i[0]),Vo,Ki,Zi,N?0:this.viewRotation_);t:if(Hi){var Ji=[],me=void 0,$n=void 0,Zn=void 0,Ot=void 0,zt=void 0;if(C)for(me=0,$n=Hi.length;me<$n;++me){zt=Hi[me],Zn=zt[4],Ot=this.createLabel(Zn,M,"",C),v=zt[2]+($i[0]<0?-Zr:Zr),_=$r*Ot.height+(.5-$r)*2*Zr*$i[1]/$i[0]-To;var St=this.calculateImageOrLabelDimensions_(Ot.width,Ot.height,zt[0],zt[1],Ot.width,Ot.height,v,_,0,0,zt[3],Co,!1,Ke,!1,K);if(h&&h.collides(St.declutterBox))break t;Ji.push([e,t,Ot,St,1,null,null])}if(T)for(me=0,$n=Hi.length;me<$n;++me){zt=Hi[me],Zn=zt[4],Ot=this.createLabel(Zn,M,T,""),v=zt[2],_=$r*Ot.height-To;var St=this.calculateImageOrLabelDimensions_(Ot.width,Ot.height,zt[0],zt[1],Ot.width,Ot.height,v,_,0,0,zt[3],Co,!1,Ke,!1,K);if(h&&h.collides(St.declutterBox))break t;Ji.push([e,t,Ot,St,1,null,null])}h&&h.load(Ji.map(fs));for(var Jr=0,Ql=Ji.length;Jr<Ql;++Jr)this.replayImageOrLabel_.apply(this,Ji[Jr])}}++u;break;case F.END_GEOMETRY:if(o!==void 0){K=w[1];var Io=o(K,at);if(Io)return Io}++u;break;case F.FILL:D?I++:this.fill_(e),++u;break;case F.MOVE_TO_LINE_TO:for(f=w[1],d=w[2],V=l[f],$=l[f+1],y=V+.5|0,m=$+.5|0,(y!==p||m!==g)&&(e.moveTo(V,$),p=y,g=m),f+=2;f<d;f+=2)V=l[f],$=l[f+1],y=V+.5|0,m=$+.5|0,(f==d-2||y!==p||m!==g)&&(e.lineTo(V,$),p=y,g=m);++u;break;case F.SET_FILL_STYLE:P=w,this.alignFill_=w[2],I&&(this.fill_(e),I=0,A&&(e.stroke(),A=0)),e.fillStyle=w[1],++u;break;case F.SET_STROKE_STYLE:b=w,A&&(e.stroke(),A=0),this.setStrokeStyle_(e,w),++u;break;case F.STROKE:D?A++:e.stroke(),++u;break;default:++u;break}}I&&this.fill_(e),A&&e.stroke()},n.prototype.execute=function(e,t,i,r,a,o){this.viewRotation_=r,this.execute_(e,t,i,this.instructions,a,void 0,void 0,o)},n.prototype.executeHitDetection=function(e,t,i,r,a){return this.viewRotation_=i,this.execute_(e,1,t,this.hitDetectionInstructions,!0,r,a)},n})(),ha=[st.POLYGON,st.CIRCLE,st.LINE_STRING,st.IMAGE,st.TEXT,st.DEFAULT],ds=(function(){function n(e,t,i,r,a,o){this.maxExtent_=e,this.overlaps_=r,this.pixelRatio_=i,this.resolution_=t,this.renderBuffer_=o,this.executorsByZIndex_={},this.hitDetectionContext_=null,this.hitDetectionTransform_=ie(),this.createExecutors_(a)}return n.prototype.clip=function(e,t){var i=this.getClipCoords(t);e.beginPath(),e.moveTo(i[0],i[1]),e.lineTo(i[2],i[3]),e.lineTo(i[4],i[5]),e.lineTo(i[6],i[7]),e.clip()},n.prototype.createExecutors_=function(e){for(var t in e){var i=this.executorsByZIndex_[t];i===void 0&&(i={},this.executorsByZIndex_[t]=i);var r=e[t];for(var a in r){var o=r[a];i[a]=new Ud(this.resolution_,this.pixelRatio_,this.overlaps_,o)}}},n.prototype.hasExecutors=function(e){for(var t in this.executorsByZIndex_)for(var i=this.executorsByZIndex_[t],r=0,a=e.length;r<a;++r)if(e[r]in i)return!0;return!1},n.prototype.forEachFeatureAtCoordinate=function(e,t,i,r,a,o){r=Math.round(r);var s=r*2+1,h=$t(this.hitDetectionTransform_,r+.5,r+.5,1/t,-1/t,-i,-e[0],-e[1]),l=!this.hitDetectionContext_;l&&(this.hitDetectionContext_=Bt(s,s));var u=this.hitDetectionContext_;u.canvas.width!==s||u.canvas.height!==s?(u.canvas.width=s,u.canvas.height=s):l||u.clearRect(0,0,s,s);var c;this.renderBuffer_!==void 0&&(c=Wt(),un(c,e),gn(c,t*(this.renderBuffer_+r),c));var f=Bd(r),d;function v(M,C){for(var T=u.getImageData(0,0,s,s).data,I=0,A=f.length;I<A;I++)if(T[f[I]]>0){if(!o||d!==st.IMAGE&&d!==st.TEXT||o.indexOf(M)!==-1){var P=(f[I]-3)/4,b=r-P%s,L=r-(P/s|0),j=a(M,C,b*b+L*L);if(j)return j}u.clearRect(0,0,s,s);break}}var _=Object.keys(this.executorsByZIndex_).map(Number);_.sort(Li);var p,g,y,m,x;for(p=_.length-1;p>=0;--p){var E=_[p].toString();for(y=this.executorsByZIndex_[E],g=ha.length-1;g>=0;--g)if(d=ha[g],m=y[d],m!==void 0&&(x=m.executeHitDetection(u,h,i,v,c),x))return x}},n.prototype.getClipCoords=function(e){var t=this.maxExtent_;if(!t)return null;var i=t[0],r=t[1],a=t[2],o=t[3],s=[i,r,i,o,a,o,a,r];return Qe(s,0,8,2,e,s),s},n.prototype.isEmpty=function(){return pn(this.executorsByZIndex_)},n.prototype.execute=function(e,t,i,r,a,o,s){var h=Object.keys(this.executorsByZIndex_).map(Number);h.sort(Li),this.maxExtent_&&(e.save(),this.clip(e,i));var l=o||ha,u,c,f,d,v,_;for(s&&h.reverse(),u=0,c=h.length;u<c;++u){var p=h[u].toString();for(v=this.executorsByZIndex_[p],f=0,d=l.length;f<d;++f){var g=l[f];_=v[g],_!==void 0&&_.execute(e,t,i,r,a,s)}}this.maxExtent_&&e.restore()},n})(),la={};function Bd(n){if(la[n]!==void 0)return la[n];for(var e=n*2+1,t=n*n,i=new Array(t+1),r=0;r<=n;++r)for(var a=0;a<=n;++a){var o=r*r+a*a;if(o>t)break;var s=i[o];s||(s=[],i[o]=s),s.push(((n+r)*e+(n+a))*4+3),r>0&&s.push(((n-r)*e+(n+a))*4+3),a>0&&(s.push(((n+r)*e+(n-a))*4+3),r>0&&s.push(((n-r)*e+(n-a))*4+3))}for(var h=[],r=0,l=i.length;r<l;++r)i[r]&&h.push.apply(h,i[r]);return la[n]=h,h}var Wd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Xd=(function(n){Wd(e,n);function e(t,i,r,a,o,s,h){var l=n.call(this)||this;return l.context_=t,l.pixelRatio_=i,l.extent_=r,l.transform_=a,l.viewRotation_=o,l.squaredTolerance_=s,l.userTransform_=h,l.contextFillState_=null,l.contextStrokeState_=null,l.contextTextState_=null,l.fillState_=null,l.strokeState_=null,l.image_=null,l.imageAnchorX_=0,l.imageAnchorY_=0,l.imageHeight_=0,l.imageOpacity_=0,l.imageOriginX_=0,l.imageOriginY_=0,l.imageRotateWithView_=!1,l.imageRotation_=0,l.imageScale_=[0,0],l.imageWidth_=0,l.text_="",l.textOffsetX_=0,l.textOffsetY_=0,l.textRotateWithView_=!1,l.textRotation_=0,l.textScale_=[0,0],l.textFillState_=null,l.textStrokeState_=null,l.textState_=null,l.pixelCoordinates_=[],l.tmpLocalTransform_=ie(),l}return e.prototype.drawImages_=function(t,i,r,a){if(this.image_){var o=Qe(t,i,r,a,this.transform_,this.pixelCoordinates_),s=this.context_,h=this.tmpLocalTransform_,l=s.globalAlpha;this.imageOpacity_!=1&&(s.globalAlpha=l*this.imageOpacity_);var u=this.imageRotation_;this.imageRotateWithView_&&(u+=this.viewRotation_);for(var c=0,f=o.length;c<f;c+=2){var d=o[c]-this.imageAnchorX_,v=o[c+1]-this.imageAnchorY_;if(u!==0||this.imageScale_[0]!=1||this.imageScale_[1]!=1){var _=d+this.imageAnchorX_,p=v+this.imageAnchorY_;$t(h,_,p,1,1,u,-_,-p),s.setTransform.apply(s,h),s.translate(_,p),s.scale(this.imageScale_[0],this.imageScale_[1]),s.drawImage(this.image_,this.imageOriginX_,this.imageOriginY_,this.imageWidth_,this.imageHeight_,-this.imageAnchorX_,-this.imageAnchorY_,this.imageWidth_,this.imageHeight_),s.setTransform(1,0,0,1,0,0)}else s.drawImage(this.image_,this.imageOriginX_,this.imageOriginY_,this.imageWidth_,this.imageHeight_,d,v,this.imageWidth_,this.imageHeight_)}this.imageOpacity_!=1&&(s.globalAlpha=l)}},e.prototype.drawText_=function(t,i,r,a){if(!(!this.textState_||this.text_==="")){this.textFillState_&&this.setContextFillState_(this.textFillState_),this.textStrokeState_&&this.setContextStrokeState_(this.textStrokeState_),this.setContextTextState_(this.textState_);var o=Qe(t,i,r,a,this.transform_,this.pixelCoordinates_),s=this.context_,h=this.textRotation_;for(this.textRotateWithView_&&(h+=this.viewRotation_);i<r;i+=a){var l=o[i]+this.textOffsetX_,u=o[i+1]+this.textOffsetY_;if(h!==0||this.textScale_[0]!=1||this.textScale_[1]!=1){var c=$t(this.tmpLocalTransform_,l,u,1,1,h,-l,-u);s.setTransform.apply(s,c),s.translate(l,u),s.scale(this.textScale_[0],this.textScale_[1]),this.textStrokeState_&&s.strokeText(this.text_,0,0),this.textFillState_&&s.fillText(this.text_,0,0),s.setTransform(1,0,0,1,0,0)}else this.textStrokeState_&&s.strokeText(this.text_,l,u),this.textFillState_&&s.fillText(this.text_,l,u)}}},e.prototype.moveToLineTo_=function(t,i,r,a,o){var s=this.context_,h=Qe(t,i,r,a,this.transform_,this.pixelCoordinates_);s.moveTo(h[0],h[1]);var l=h.length;o&&(l-=2);for(var u=2;u<l;u+=2)s.lineTo(h[u],h[u+1]);return o&&s.closePath(),r},e.prototype.drawRings_=function(t,i,r,a){for(var o=0,s=r.length;o<s;++o)i=this.moveToLineTo_(t,i,r[o],a,!0);return i},e.prototype.drawCircle=function(t){if(Ct(this.extent_,t.getExtent())){if(this.fillState_||this.strokeState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var i=ic(t,this.transform_,this.pixelCoordinates_),r=i[2]-i[0],a=i[3]-i[1],o=Math.sqrt(r*r+a*a),s=this.context_;s.beginPath(),s.arc(i[0],i[1],o,0,2*Math.PI),this.fillState_&&s.fill(),this.strokeState_&&s.stroke()}this.text_!==""&&this.drawText_(t.getCenter(),0,2,2)}},e.prototype.setStyle=function(t){this.setFillStrokeStyle(t.getFill(),t.getStroke()),this.setImageStyle(t.getImage()),this.setTextStyle(t.getText())},e.prototype.setTransform=function(t){this.transform_=t},e.prototype.drawGeometry=function(t){var i=t.getType();switch(i){case W.POINT:this.drawPoint(t);break;case W.LINE_STRING:this.drawLineString(t);break;case W.POLYGON:this.drawPolygon(t);break;case W.MULTI_POINT:this.drawMultiPoint(t);break;case W.MULTI_LINE_STRING:this.drawMultiLineString(t);break;case W.MULTI_POLYGON:this.drawMultiPolygon(t);break;case W.GEOMETRY_COLLECTION:this.drawGeometryCollection(t);break;case W.CIRCLE:this.drawCircle(t);break}},e.prototype.drawFeature=function(t,i){var r=i.getGeometryFunction()(t);!r||!Ct(this.extent_,r.getExtent())||(this.setStyle(i),this.drawGeometry(r))},e.prototype.drawGeometryCollection=function(t){for(var i=t.getGeometriesArray(),r=0,a=i.length;r<a;++r)this.drawGeometry(i[r])},e.prototype.drawPoint=function(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));var i=t.getFlatCoordinates(),r=t.getStride();this.image_&&this.drawImages_(i,0,i.length,r),this.text_!==""&&this.drawText_(i,0,i.length,r)},e.prototype.drawMultiPoint=function(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));var i=t.getFlatCoordinates(),r=t.getStride();this.image_&&this.drawImages_(i,0,i.length,r),this.text_!==""&&this.drawText_(i,0,i.length,r)},e.prototype.drawLineString=function(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!Ct(this.extent_,t.getExtent())){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);var i=this.context_,r=t.getFlatCoordinates();i.beginPath(),this.moveToLineTo_(r,0,r.length,t.getStride(),!1),i.stroke()}if(this.text_!==""){var a=t.getFlatMidpoint();this.drawText_(a,0,2,2)}}},e.prototype.drawMultiLineString=function(t){this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_));var i=t.getExtent();if(Ct(this.extent_,i)){if(this.strokeState_){this.setContextStrokeState_(this.strokeState_);var r=this.context_,a=t.getFlatCoordinates(),o=0,s=t.getEnds(),h=t.getStride();r.beginPath();for(var l=0,u=s.length;l<u;++l)o=this.moveToLineTo_(a,o,s[l],h,!1);r.stroke()}if(this.text_!==""){var c=t.getFlatMidpoints();this.drawText_(c,0,c.length,2)}}},e.prototype.drawPolygon=function(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!Ct(this.extent_,t.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var i=this.context_;i.beginPath(),this.drawRings_(t.getOrientedFlatCoordinates(),0,t.getEnds(),t.getStride()),this.fillState_&&i.fill(),this.strokeState_&&i.stroke()}if(this.text_!==""){var r=t.getFlatInteriorPoint();this.drawText_(r,0,2,2)}}},e.prototype.drawMultiPolygon=function(t){if(this.squaredTolerance_&&(t=t.simplifyTransformed(this.squaredTolerance_,this.userTransform_)),!!Ct(this.extent_,t.getExtent())){if(this.strokeState_||this.fillState_){this.fillState_&&this.setContextFillState_(this.fillState_),this.strokeState_&&this.setContextStrokeState_(this.strokeState_);var i=this.context_,r=t.getOrientedFlatCoordinates(),a=0,o=t.getEndss(),s=t.getStride();i.beginPath();for(var h=0,l=o.length;h<l;++h){var u=o[h];a=this.drawRings_(r,a,u,s)}this.fillState_&&i.fill(),this.strokeState_&&i.stroke()}if(this.text_!==""){var c=t.getFlatInteriorPoints();this.drawText_(c,0,c.length,2)}}},e.prototype.setContextFillState_=function(t){var i=this.context_,r=this.contextFillState_;r?r.fillStyle!=t.fillStyle&&(r.fillStyle=t.fillStyle,i.fillStyle=t.fillStyle):(i.fillStyle=t.fillStyle,this.contextFillState_={fillStyle:t.fillStyle})},e.prototype.setContextStrokeState_=function(t){var i=this.context_,r=this.contextStrokeState_;r?(r.lineCap!=t.lineCap&&(r.lineCap=t.lineCap,i.lineCap=t.lineCap),i.setLineDash&&(ai(r.lineDash,t.lineDash)||i.setLineDash(r.lineDash=t.lineDash),r.lineDashOffset!=t.lineDashOffset&&(r.lineDashOffset=t.lineDashOffset,i.lineDashOffset=t.lineDashOffset)),r.lineJoin!=t.lineJoin&&(r.lineJoin=t.lineJoin,i.lineJoin=t.lineJoin),r.lineWidth!=t.lineWidth&&(r.lineWidth=t.lineWidth,i.lineWidth=t.lineWidth),r.miterLimit!=t.miterLimit&&(r.miterLimit=t.miterLimit,i.miterLimit=t.miterLimit),r.strokeStyle!=t.strokeStyle&&(r.strokeStyle=t.strokeStyle,i.strokeStyle=t.strokeStyle)):(i.lineCap=t.lineCap,i.setLineDash&&(i.setLineDash(t.lineDash),i.lineDashOffset=t.lineDashOffset),i.lineJoin=t.lineJoin,i.lineWidth=t.lineWidth,i.miterLimit=t.miterLimit,i.strokeStyle=t.strokeStyle,this.contextStrokeState_={lineCap:t.lineCap,lineDash:t.lineDash,lineDashOffset:t.lineDashOffset,lineJoin:t.lineJoin,lineWidth:t.lineWidth,miterLimit:t.miterLimit,strokeStyle:t.strokeStyle})},e.prototype.setContextTextState_=function(t){var i=this.context_,r=this.contextTextState_,a=t.textAlign?t.textAlign:Tn;r?(r.font!=t.font&&(r.font=t.font,i.font=t.font),r.textAlign!=a&&(r.textAlign=a,i.textAlign=a),r.textBaseline!=t.textBaseline&&(r.textBaseline=t.textBaseline,i.textBaseline=t.textBaseline)):(i.font=t.font,i.textAlign=a,i.textBaseline=t.textBaseline,this.contextTextState_={font:t.font,textAlign:a,textBaseline:t.textBaseline})},e.prototype.setFillStrokeStyle=function(t,i){var r=this;if(!t)this.fillState_=null;else{var a=t.getColor();this.fillState_={fillStyle:te(a||ve)}}if(!i)this.strokeState_=null;else{var o=i.getColor(),s=i.getLineCap(),h=i.getLineDash(),l=i.getLineDashOffset(),u=i.getLineJoin(),c=i.getWidth(),f=i.getMiterLimit(),d=h||mn;this.strokeState_={lineCap:s!==void 0?s:xr,lineDash:this.pixelRatio_===1?d:d.map(function(v){return v*r.pixelRatio_}),lineDashOffset:(l||xn)*this.pixelRatio_,lineJoin:u!==void 0?u:Fi,lineWidth:(c!==void 0?c:Cn)*this.pixelRatio_,miterLimit:f!==void 0?f:En,strokeStyle:te(o||Mn)}}},e.prototype.setImageStyle=function(t){var i;if(!t||!(i=t.getSize())){this.image_=null;return}var r=t.getAnchor(),a=t.getOrigin();this.image_=t.getImage(this.pixelRatio_),this.imageAnchorX_=r[0]*this.pixelRatio_,this.imageAnchorY_=r[1]*this.pixelRatio_,this.imageHeight_=i[1]*this.pixelRatio_,this.imageOpacity_=t.getOpacity(),this.imageOriginX_=a[0],this.imageOriginY_=a[1],this.imageRotateWithView_=t.getRotateWithView(),this.imageRotation_=t.getRotation(),this.imageScale_=t.getScaleArray(),this.imageWidth_=i[0]*this.pixelRatio_},e.prototype.setTextStyle=function(t){if(!t)this.text_="";else{var i=t.getFill();if(!i)this.textFillState_=null;else{var r=i.getColor();this.textFillState_={fillStyle:te(r||ve)}}var a=t.getStroke();if(!a)this.textStrokeState_=null;else{var o=a.getColor(),s=a.getLineCap(),h=a.getLineDash(),l=a.getLineDashOffset(),u=a.getLineJoin(),c=a.getWidth(),f=a.getMiterLimit();this.textStrokeState_={lineCap:s!==void 0?s:xr,lineDash:h||mn,lineDashOffset:l||xn,lineJoin:u!==void 0?u:Fi,lineWidth:c!==void 0?c:Cn,miterLimit:f!==void 0?f:En,strokeStyle:te(o||Mn)}}var d=t.getFont(),v=t.getOffsetX(),_=t.getOffsetY(),p=t.getRotateWithView(),g=t.getRotation(),y=t.getScaleArray(),m=t.getText(),x=t.getTextAlign(),E=t.getTextBaseline();this.textState_={font:d!==void 0?d:xh,textAlign:x!==void 0?x:Tn,textBaseline:E!==void 0?E:Er},this.text_=m!==void 0?Array.isArray(m)?m.reduce(function(M,C,T){return M+=T%2?" ":C},""):m:"",this.textOffsetX_=v!==void 0?this.pixelRatio_*v:0,this.textOffsetY_=_!==void 0?this.pixelRatio_*_:0,this.textRotateWithView_=p!==void 0?p:!1,this.textRotation_=g!==void 0?g:0,this.textScale_=[this.pixelRatio_*y[0],this.pixelRatio_*y[1]]}},e})(qh);const Ie={FRACTION:"fraction",PIXELS:"pixels"},jt={BOTTOM_LEFT:"bottom-left",BOTTOM_RIGHT:"bottom-right",TOP_LEFT:"top-left",TOP_RIGHT:"top-right"};var Yd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),$h=(function(n){Yd(e,n);function e(t,i,r,a){var o=n.call(this)||this;return o.extent=t,o.pixelRatio_=r,o.resolution=i,o.state=a,o}return e.prototype.changed=function(){this.dispatchEvent(B.CHANGE)},e.prototype.getExtent=function(){return this.extent},e.prototype.getImage=function(){return q()},e.prototype.getPixelRatio=function(){return this.pixelRatio_},e.prototype.getResolution=function(){return this.resolution},e.prototype.getState=function(){return this.state},e.prototype.load=function(){q()},e})(zi),Vd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),qd=(function(n){Vd(e,n);function e(t,i,r,a,o,s){var h=n.call(this,t,i,r,X.IDLE)||this;return h.src_=a,h.image_=new Image,o!==null&&(h.image_.crossOrigin=o),h.unlisten_=null,h.state=X.IDLE,h.imageLoadFunction_=s,h}return e.prototype.getImage=function(){return this.image_},e.prototype.handleImageError_=function(){this.state=X.ERROR,this.unlistenImage_(),this.changed()},e.prototype.handleImageLoad_=function(){this.resolution===void 0&&(this.resolution=Et(this.extent)/this.image_.height),this.state=X.LOADED,this.unlistenImage_(),this.changed()},e.prototype.load=function(){(this.state==X.IDLE||this.state==X.ERROR)&&(this.state=X.LOADING,this.changed(),this.imageLoadFunction_(this,this.src_),this.unlisten_=oo(this.image_,this.handleImageLoad_.bind(this),this.handleImageError_.bind(this)))},e.prototype.setImage=function(t){this.image_=t,this.resolution=Et(this.extent)/this.image_.height},e.prototype.unlistenImage_=function(){this.unlisten_&&(this.unlisten_(),this.unlisten_=null)},e})($h);function oo(n,e,t){var i=n,r=!0,a=!1,o=!1,s=[_r(i,B.LOAD,function(){o=!0,a||e()})];return i.src&&yu?(a=!0,i.decode().then(function(){r&&e()}).catch(function(h){r&&(o?e():t())})):s.push(_r(i,B.ERROR,t)),function(){r=!1,s.forEach(rt)}}var Kd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),en=null,$d=(function(n){Kd(e,n);function e(t,i,r,a,o,s){var h=n.call(this)||this;return h.hitDetectionImage_=null,h.image_=t||new Image,a!==null&&(h.image_.crossOrigin=a),h.canvas_={},h.color_=s,h.unlisten_=null,h.imageState_=o,h.size_=r,h.src_=i,h.tainted_,h}return e.prototype.isTainted_=function(){if(this.tainted_===void 0&&this.imageState_===X.LOADED){en||(en=Bt(1,1)),en.drawImage(this.image_,0,0);try{en.getImageData(0,0,1,1),this.tainted_=!1}catch{en=null,this.tainted_=!0}}return this.tainted_===!0},e.prototype.dispatchChangeEvent_=function(){this.dispatchEvent(B.CHANGE)},e.prototype.handleImageError_=function(){this.imageState_=X.ERROR,this.unlistenImage_(),this.dispatchChangeEvent_()},e.prototype.handleImageLoad_=function(){this.imageState_=X.LOADED,this.size_?(this.image_.width=this.size_[0],this.image_.height=this.size_[1]):this.size_=[this.image_.width,this.image_.height],this.unlistenImage_(),this.dispatchChangeEvent_()},e.prototype.getImage=function(t){return this.replaceColor_(t),this.canvas_[t]?this.canvas_[t]:this.image_},e.prototype.getPixelRatio=function(t){return this.replaceColor_(t),this.canvas_[t]?t:1},e.prototype.getImageState=function(){return this.imageState_},e.prototype.getHitDetectionImage=function(){if(!this.hitDetectionImage_)if(this.isTainted_()){var t=this.size_[0],i=this.size_[1],r=Bt(t,i);r.fillRect(0,0,t,i),this.hitDetectionImage_=r.canvas}else this.hitDetectionImage_=this.image_;return this.hitDetectionImage_},e.prototype.getSize=function(){return this.size_},e.prototype.getSrc=function(){return this.src_},e.prototype.load=function(){if(this.imageState_==X.IDLE){this.imageState_=X.LOADING;try{this.image_.src=this.src_}catch{this.handleImageError_()}this.unlisten_=oo(this.image_,this.handleImageLoad_.bind(this),this.handleImageError_.bind(this))}},e.prototype.replaceColor_=function(t){if(!(!this.color_||this.canvas_[t]||this.imageState_!==X.LOADED)){var i=document.createElement("canvas");this.canvas_[t]=i,i.width=Math.ceil(this.image_.width*t),i.height=Math.ceil(this.image_.height*t);var r=i.getContext("2d");if(r.scale(t,t),r.drawImage(this.image_,0,0),r.globalCompositeOperation="multiply",r.globalCompositeOperation==="multiply"||this.isTainted_())r.fillStyle=gh(this.color_),r.fillRect(0,0,i.width/t,i.height/t),r.globalCompositeOperation="destination-in",r.drawImage(this.image_,0,0);else{for(var a=r.getImageData(0,0,i.width,i.height),o=a.data,s=this.color_[0]/255,h=this.color_[1]/255,l=this.color_[2]/255,u=this.color_[3],c=0,f=o.length;c<f;c+=4)o[c]*=s,o[c+1]*=h,o[c+2]*=l,o[c+3]*=u;r.putImageData(a,0,0)}}},e.prototype.unlistenImage_=function(){this.unlisten_&&(this.unlisten_(),this.unlisten_=null)},e})(zi);function Zd(n,e,t,i,r,a){var o=mr.get(e,i,a);return o||(o=new $d(n,e,t,i,r,a),mr.set(e,i,a,o)),o}var Hd=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Zh=(function(n){Hd(e,n);function e(t){var i=this,r=t||{},a=r.opacity!==void 0?r.opacity:1,o=r.rotation!==void 0?r.rotation:0,s=r.scale!==void 0?r.scale:1,h=r.rotateWithView!==void 0?r.rotateWithView:!1;i=n.call(this,{opacity:a,rotation:o,scale:s,displacement:r.displacement!==void 0?r.displacement:[0,0],rotateWithView:h})||this,i.anchor_=r.anchor!==void 0?r.anchor:[.5,.5],i.normalizedAnchor_=null,i.anchorOrigin_=r.anchorOrigin!==void 0?r.anchorOrigin:jt.TOP_LEFT,i.anchorXUnits_=r.anchorXUnits!==void 0?r.anchorXUnits:Ie.FRACTION,i.anchorYUnits_=r.anchorYUnits!==void 0?r.anchorYUnits:Ie.FRACTION,i.crossOrigin_=r.crossOrigin!==void 0?r.crossOrigin:null;var l=r.img!==void 0?r.img:null;i.imgSize_=r.imgSize;var u=r.src;Y(!(u!==void 0&&l),4),Y(!l||l&&i.imgSize_,5),(u===void 0||u.length===0)&&l&&(u=l.src||H(l)),Y(u!==void 0&&u.length>0,6);var c=r.src!==void 0?X.IDLE:X.LOADED;return i.color_=r.color!==void 0?yr(r.color):null,i.iconImage_=Zd(l,u,i.imgSize_!==void 0?i.imgSize_:null,i.crossOrigin_,c,i.color_),i.offset_=r.offset!==void 0?r.offset:[0,0],i.offsetOrigin_=r.offsetOrigin!==void 0?r.offsetOrigin:jt.TOP_LEFT,i.origin_=null,i.size_=r.size!==void 0?r.size:null,i}return e.prototype.clone=function(){var t=this.getScale();return new e({anchor:this.anchor_.slice(),anchorOrigin:this.anchorOrigin_,anchorXUnits:this.anchorXUnits_,anchorYUnits:this.anchorYUnits_,color:this.color_&&this.color_.slice?this.color_.slice():this.color_||void 0,crossOrigin:this.crossOrigin_,imgSize:this.imgSize_,offset:this.offset_.slice(),offsetOrigin:this.offsetOrigin_,opacity:this.getOpacity(),rotateWithView:this.getRotateWithView(),rotation:this.getRotation(),scale:Array.isArray(t)?t.slice():t,size:this.size_!==null?this.size_.slice():void 0,src:this.getSrc()})},e.prototype.getAnchor=function(){var t=this.normalizedAnchor_;if(!t){t=this.anchor_;var i=this.getSize();if(this.anchorXUnits_==Ie.FRACTION||this.anchorYUnits_==Ie.FRACTION){if(!i)return null;t=this.anchor_.slice(),this.anchorXUnits_==Ie.FRACTION&&(t[0]*=i[0]),this.anchorYUnits_==Ie.FRACTION&&(t[1]*=i[1])}if(this.anchorOrigin_!=jt.TOP_LEFT){if(!i)return null;t===this.anchor_&&(t=this.anchor_.slice()),(this.anchorOrigin_==jt.TOP_RIGHT||this.anchorOrigin_==jt.BOTTOM_RIGHT)&&(t[0]=-t[0]+i[0]),(this.anchorOrigin_==jt.BOTTOM_LEFT||this.anchorOrigin_==jt.BOTTOM_RIGHT)&&(t[1]=-t[1]+i[1])}this.normalizedAnchor_=t}var r=this.getDisplacement();return[t[0]-r[0],t[1]+r[1]]},e.prototype.setAnchor=function(t){this.anchor_=t,this.normalizedAnchor_=null},e.prototype.getColor=function(){return this.color_},e.prototype.getImage=function(t){return this.iconImage_.getImage(t)},e.prototype.getPixelRatio=function(t){return this.iconImage_.getPixelRatio(t)},e.prototype.getImageSize=function(){return this.iconImage_.getSize()},e.prototype.getImageState=function(){return this.iconImage_.getImageState()},e.prototype.getHitDetectionImage=function(){return this.iconImage_.getHitDetectionImage()},e.prototype.getOrigin=function(){if(this.origin_)return this.origin_;var t=this.offset_;if(this.offsetOrigin_!=jt.TOP_LEFT){var i=this.getSize(),r=this.iconImage_.getSize();if(!i||!r)return null;t=t.slice(),(this.offsetOrigin_==jt.TOP_RIGHT||this.offsetOrigin_==jt.BOTTOM_RIGHT)&&(t[0]=r[0]-i[0]-t[0]),(this.offsetOrigin_==jt.BOTTOM_LEFT||this.offsetOrigin_==jt.BOTTOM_RIGHT)&&(t[1]=r[1]-i[1]-t[1])}return this.origin_=t,this.origin_},e.prototype.getSrc=function(){return this.iconImage_.getSrc()},e.prototype.getSize=function(){return this.size_?this.size_:this.iconImage_.getSize()},e.prototype.listenImageChange=function(t){this.iconImage_.addEventListener(B.CHANGE,t)},e.prototype.load=function(){this.iconImage_.load()},e.prototype.unlistenImageChange=function(t){this.iconImage_.removeEventListener(B.CHANGE,t)},e})(Yh),Jd="#333",Hh=(function(){function n(e){var t=e||{};this.font_=t.font,this.rotation_=t.rotation,this.rotateWithView_=t.rotateWithView,this.scale_=t.scale,this.scaleArray_=Rt(t.scale!==void 0?t.scale:1),this.text_=t.text,this.textAlign_=t.textAlign,this.textBaseline_=t.textBaseline,this.fill_=t.fill!==void 0?t.fill:new Yr({color:Jd}),this.maxAngle_=t.maxAngle!==void 0?t.maxAngle:Math.PI/4,this.placement_=t.placement!==void 0?t.placement:Kh.POINT,this.overflow_=!!t.overflow,this.stroke_=t.stroke!==void 0?t.stroke:null,this.offsetX_=t.offsetX!==void 0?t.offsetX:0,this.offsetY_=t.offsetY!==void 0?t.offsetY:0,this.backgroundFill_=t.backgroundFill?t.backgroundFill:null,this.backgroundStroke_=t.backgroundStroke?t.backgroundStroke:null,this.padding_=t.padding===void 0?null:t.padding}return n.prototype.clone=function(){var e=this.getScale();return new n({font:this.getFont(),placement:this.getPlacement(),maxAngle:this.getMaxAngle(),overflow:this.getOverflow(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),scale:Array.isArray(e)?e.slice():e,text:this.getText(),textAlign:this.getTextAlign(),textBaseline:this.getTextBaseline(),fill:this.getFill()?this.getFill().clone():void 0,stroke:this.getStroke()?this.getStroke().clone():void 0,offsetX:this.getOffsetX(),offsetY:this.getOffsetY(),backgroundFill:this.getBackgroundFill()?this.getBackgroundFill().clone():void 0,backgroundStroke:this.getBackgroundStroke()?this.getBackgroundStroke().clone():void 0,padding:this.getPadding()||void 0})},n.prototype.getOverflow=function(){return this.overflow_},n.prototype.getFont=function(){return this.font_},n.prototype.getMaxAngle=function(){return this.maxAngle_},n.prototype.getPlacement=function(){return this.placement_},n.prototype.getOffsetX=function(){return this.offsetX_},n.prototype.getOffsetY=function(){return this.offsetY_},n.prototype.getFill=function(){return this.fill_},n.prototype.getRotateWithView=function(){return this.rotateWithView_},n.prototype.getRotation=function(){return this.rotation_},n.prototype.getScale=function(){return this.scale_},n.prototype.getScaleArray=function(){return this.scaleArray_},n.prototype.getStroke=function(){return this.stroke_},n.prototype.getText=function(){return this.text_},n.prototype.getTextAlign=function(){return this.textAlign_},n.prototype.getTextBaseline=function(){return this.textBaseline_},n.prototype.getBackgroundFill=function(){return this.backgroundFill_},n.prototype.getBackgroundStroke=function(){return this.backgroundStroke_},n.prototype.getPadding=function(){return this.padding_},n.prototype.setOverflow=function(e){this.overflow_=e},n.prototype.setFont=function(e){this.font_=e},n.prototype.setMaxAngle=function(e){this.maxAngle_=e},n.prototype.setOffsetX=function(e){this.offsetX_=e},n.prototype.setOffsetY=function(e){this.offsetY_=e},n.prototype.setPlacement=function(e){this.placement_=e},n.prototype.setRotateWithView=function(e){this.rotateWithView_=e},n.prototype.setFill=function(e){this.fill_=e},n.prototype.setRotation=function(e){this.rotation_=e},n.prototype.setScale=function(e){this.scale_=e,this.scaleArray_=Rt(e!==void 0?e:1)},n.prototype.setStroke=function(e){this.stroke_=e},n.prototype.setText=function(e){this.text_=e},n.prototype.setTextAlign=function(e){this.textAlign_=e},n.prototype.setTextBaseline=function(e){this.textBaseline_=e},n.prototype.setBackgroundFill=function(e){this.backgroundFill_=e},n.prototype.setBackgroundStroke=function(e){this.backgroundStroke_=e},n.prototype.setPadding=function(e){this.padding_=e},n})(),Qt=.5;function Qd(n,e,t,i,r,a,o){var s=n[0]*Qt,h=n[1]*Qt,l=Bt(s,h);l.imageSmoothingEnabled=!1;for(var u=l.canvas,c=new Xd(l,Qt,r,null,o),f=t.length,d=Math.floor((256*256*256-1)/f),v={},_=1;_<=f;++_){var p=t[_-1],g=p.getStyleFunction()||i;if(i){var y=g(p,a);if(y){Array.isArray(y)||(y=[y]);for(var m=_*d,x="#"+("000000"+m.toString(16)).slice(-6),E=0,M=y.length;E<M;++E){var C=y[E],T=C.getGeometryFunction()(p);if(!(!T||!Ct(r,T.getExtent()))){var I=C.clone(),A=I.getFill();A&&A.setColor(x);var P=I.getStroke();P&&(P.setColor(x),P.setLineDash(null)),I.setText(void 0);var b=C.getImage();if(b&&b.getOpacity()!==0){var L=b.getImageSize();if(!L)continue;var j=Bt(L[0],L[1],void 0,{alpha:!1}),N=j.canvas;j.fillStyle=x,j.fillRect(0,0,N.width,N.height),I.setImage(new Zh({img:N,imgSize:L,anchor:b.getAnchor(),anchorXUnits:Ie.PIXELS,anchorYUnits:Ie.PIXELS,offset:b.getOrigin(),opacity:1,size:b.getSize(),scale:b.getScale(),rotation:b.getRotation(),rotateWithView:b.getRotateWithView()}))}var G=I.getZIndex()||0,D=v[G];D||(D={},v[G]=D,D[W.POLYGON]=[],D[W.CIRCLE]=[],D[W.LINE_STRING]=[],D[W.POINT]=[]),D[T.getType().replace("Multi","")].push(T,I)}}}}}for(var K=Object.keys(v).map(Number).sort(Li),_=0,V=K.length;_<V;++_){var D=v[K[_]];for(var $ in D)for(var at=D[$],E=0,M=at.length;E<M;E+=2){c.setStyle(at[E+1]);for(var w=0,ht=e.length;w<ht;++w)c.setTransform(e[w]),c.drawGeometry(at[E])}}return l.getImageData(0,0,u.width,u.height)}function tv(n,e,t){var i=[];if(t){var r=Math.floor(Math.round(n[0])*Qt),a=Math.floor(Math.round(n[1])*Qt),o=(ut(r,0,t.width-1)+ut(a,0,t.height-1)*t.width)*4,s=t.data[o],h=t.data[o+1],l=t.data[o+2],u=l+256*(h+256*s),c=Math.floor((256*256*256-1)/e.length);u&&u%c===0&&i.push(e[u/c-1])}return i}var ev=.5,Jh={Point:uv,LineString:sv,Polygon:cv,MultiPoint:fv,MultiLineString:hv,MultiPolygon:lv,GeometryCollection:ov,Circle:rv};function iv(n,e){return parseInt(H(n),10)-parseInt(H(e),10)}function nv(n,e){var t=La(n,e);return t*t}function La(n,e){return ev*n/e}function rv(n,e,t,i,r){var a=t.getFill(),o=t.getStroke();if(a||o){var s=n.getBuilder(t.getZIndex(),st.CIRCLE);s.setFillStrokeStyle(a,o),s.drawCircle(e,i)}var h=t.getText();if(h&&h.getText()){var l=(r||n).getBuilder(t.getZIndex(),st.TEXT);l.setTextStyle(h),l.drawText(e,i)}}function vs(n,e,t,i,r,a,o){var s=!1,h=t.getImage();if(h){var l=h.getImageState();l==X.LOADED||l==X.ERROR?h.unlistenImageChange(r):(l==X.IDLE&&h.load(),l=h.getImageState(),h.listenImageChange(r),s=!0)}return av(n,e,t,i,a,o),s}function av(n,e,t,i,r,a){var o=t.getGeometryFunction()(e);if(o){var s=o.simplifyTransformed(i,r),h=t.getRenderer();if(h)Qh(n,s,t,e);else{var l=Jh[s.getType()];l(n,s,t,e,a)}}}function Qh(n,e,t,i){if(e.getType()==W.GEOMETRY_COLLECTION){for(var r=e.getGeometries(),a=0,o=r.length;a<o;++a)Qh(n,r[a],t,i);return}var s=n.getBuilder(t.getZIndex(),st.DEFAULT);s.drawCustom(e,i,t.getRenderer(),t.getHitDetectionRenderer())}function ov(n,e,t,i,r){var a=e.getGeometriesArray(),o,s;for(o=0,s=a.length;o<s;++o){var h=Jh[a[o].getType()];h(n,a[o],t,i,r)}}function sv(n,e,t,i,r){var a=t.getStroke();if(a){var o=n.getBuilder(t.getZIndex(),st.LINE_STRING);o.setFillStrokeStyle(null,a),o.drawLineString(e,i)}var s=t.getText();if(s&&s.getText()){var h=(r||n).getBuilder(t.getZIndex(),st.TEXT);h.setTextStyle(s),h.drawText(e,i)}}function hv(n,e,t,i,r){var a=t.getStroke();if(a){var o=n.getBuilder(t.getZIndex(),st.LINE_STRING);o.setFillStrokeStyle(null,a),o.drawMultiLineString(e,i)}var s=t.getText();if(s&&s.getText()){var h=(r||n).getBuilder(t.getZIndex(),st.TEXT);h.setTextStyle(s),h.drawText(e,i)}}function lv(n,e,t,i,r){var a=t.getFill(),o=t.getStroke();if(o||a){var s=n.getBuilder(t.getZIndex(),st.POLYGON);s.setFillStrokeStyle(a,o),s.drawMultiPolygon(e,i)}var h=t.getText();if(h&&h.getText()){var l=(r||n).getBuilder(t.getZIndex(),st.TEXT);l.setTextStyle(h),l.drawText(e,i)}}function uv(n,e,t,i,r){var a=t.getImage(),o=t.getText(),s;if(r&&(n=r,s=a&&o&&o.getText()?{}:void 0),a){if(a.getImageState()!=X.LOADED)return;var h=n.getBuilder(t.getZIndex(),st.IMAGE);h.setImageStyle(a,s),h.drawPoint(e,i)}if(o&&o.getText()){var l=n.getBuilder(t.getZIndex(),st.TEXT);l.setTextStyle(o,s),l.drawText(e,i)}}function fv(n,e,t,i,r){var a=t.getImage(),o=t.getText(),s;if(r&&(n=r,s=a&&o&&o.getText()?{}:void 0),a){if(a.getImageState()!=X.LOADED)return;var h=n.getBuilder(t.getZIndex(),st.IMAGE);h.setImageStyle(a,s),h.drawMultiPoint(e,i)}if(o&&o.getText()){var l=(r||n).getBuilder(t.getZIndex(),st.TEXT);l.setTextStyle(o,s),l.drawText(e,i)}}function cv(n,e,t,i,r){var a=t.getFill(),o=t.getStroke();if(a||o){var s=n.getBuilder(t.getZIndex(),st.POLYGON);s.setFillStrokeStyle(a,o),s.drawPolygon(e,i)}var h=t.getText();if(h&&h.getText()){var l=(r||n).getBuilder(t.getZIndex(),st.TEXT);l.setTextStyle(h),l.drawText(e,i)}}var dv=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),vv=(function(n){dv(e,n);function e(t){var i=n.call(this,t)||this;return i.boundHandleStyleImageChange_=i.handleStyleImageChange_.bind(i),i.animatingOrInteracting_,i.dirty_=!1,i.hitDetectionImageData_=null,i.renderedFeatures_=null,i.renderedRevision_=-1,i.renderedResolution_=NaN,i.renderedExtent_=Wt(),i.wrappedRenderedExtent_=Wt(),i.renderedRotation_,i.renderedCenter_=null,i.renderedProjection_=null,i.renderedRenderOrder_=null,i.replayGroup_=null,i.replayGroupChanged=!0,i.declutterExecutorGroup=null,i.clipping=!0,i}return e.prototype.renderWorlds=function(t,i,r){var a=i.extent,o=i.viewState,s=o.center,h=o.resolution,l=o.projection,u=o.rotation,c=l.getExtent(),f=this.getLayer().getSource(),d=i.pixelRatio,v=i.viewHints,_=!(v[_t.ANIMATING]||v[_t.INTERACTING]),p=this.context,g=Math.round(i.size[0]*d),y=Math.round(i.size[1]*d),m=f.getWrapX()&&l.canWrapX(),x=m?et(c):null,E=m?Math.ceil((a[2]-c[2])/x)+1:1,M=m?Math.floor((a[0]-c[0])/x):0;do{var C=this.getRenderTransform(s,h,u,d,g,y,M*x);t.execute(p,1,C,u,_,void 0,r)}while(++M<E)},e.prototype.renderDeclutter=function(t){this.declutterExecutorGroup&&this.renderWorlds(this.declutterExecutorGroup,t,t.declutterTree)},e.prototype.renderFrame=function(t,i){var r=t.pixelRatio,a=t.layerStatesArray[t.layerIndex];pf(this.pixelTransform,1/r,1/r),Wr(this.inversePixelTransform,this.pixelTransform);var o=Za(this.pixelTransform);this.useContainer(i,o,a.opacity,this.getBackground(t));var s=this.context,h=s.canvas,l=this.replayGroup_,u=this.declutterExecutorGroup;if((!l||l.isEmpty())&&(!u||u.isEmpty()))return null;var c=Math.round(t.size[0]*r),f=Math.round(t.size[1]*r);h.width!=c||h.height!=f?(h.width=c,h.height=f,h.style.transform!==o&&(h.style.transform=o)):this.containerReused||s.clearRect(0,0,c,f),this.preRender(s,t);var d=t.viewState,v=d.projection,_=!1,p=!0;if(a.extent&&this.clipping){var g=de(a.extent,v);p=Ct(g,t.extent),_=p&&!Pe(g,t.extent),_&&this.clipUnrotated(s,t,g)}p&&this.renderWorlds(l,t),_&&s.restore(),this.postRender(s,t);var y=Qs(a.opacity),m=this.container;return y!==m.style.opacity&&(m.style.opacity=y),this.renderedRotation_!==d.rotation&&(this.renderedRotation_=d.rotation,this.hitDetectionImageData_=null),this.container},e.prototype.getFeatures=function(t){return new Promise((function(i){if(!this.hitDetectionImageData_&&!this.animatingOrInteracting_){var r=[this.context.canvas.width,this.context.canvas.height];ft(this.pixelTransform,r);var a=this.renderedCenter_,o=this.renderedResolution_,s=this.renderedRotation_,h=this.renderedProjection_,l=this.wrappedRenderedExtent_,u=this.getLayer(),c=[],f=r[0]*Qt,d=r[1]*Qt;c.push(this.getRenderTransform(a,o,s,Qt,f,d,0).slice());var v=u.getSource(),_=h.getExtent();if(v.getWrapX()&&h.canWrapX()&&!Pe(_,l)){for(var p=l[0],g=et(_),y=0,m=void 0;p<_[0];)--y,m=g*y,c.push(this.getRenderTransform(a,o,s,Qt,f,d,m).slice()),p+=g;for(y=0,p=l[2];p>_[2];)++y,m=g*y,c.push(this.getRenderTransform(a,o,s,Qt,f,d,m).slice()),p-=g}this.hitDetectionImageData_=Qd(r,c,this.renderedFeatures_,u.getStyleFunction(),l,o,s)}i(tv(t,this.renderedFeatures_,this.hitDetectionImageData_))}).bind(this))},e.prototype.forEachFeatureAtCoordinate=function(t,i,r,a,o){var s=this;if(this.replayGroup_){var h=i.viewState.resolution,l=i.viewState.rotation,u=this.getLayer(),c={},f=function(_,p,g){var y=H(_),m=c[y];if(m){if(m!==!0&&g<m.distanceSq){if(g===0)return c[y]=!0,o.splice(o.lastIndexOf(m),1),a(_,u,p);m.geometry=p,m.distanceSq=g}}else{if(g===0)return c[y]=!0,a(_,u,p);o.push(c[y]={feature:_,layer:u,geometry:p,distanceSq:g,callback:a})}},d,v=[this.replayGroup_];return this.declutterExecutorGroup&&v.push(this.declutterExecutorGroup),v.some(function(_){return d=_.forEachFeatureAtCoordinate(t,h,l,r,f,_===s.declutterExecutorGroup&&i.declutterTree?i.declutterTree.all().map(function(p){return p.value}):null)}),d}},e.prototype.handleFontsChanged=function(){var t=this.getLayer();t.getVisible()&&this.replayGroup_&&t.changed()},e.prototype.handleStyleImageChange_=function(t){this.renderIfReadyAndVisible()},e.prototype.prepareFrame=function(t){var i=this.getLayer(),r=i.getSource();if(!r)return!1;var a=t.viewHints[_t.ANIMATING],o=t.viewHints[_t.INTERACTING],s=i.getUpdateWhileAnimating(),h=i.getUpdateWhileInteracting();if(!this.dirty_&&!s&&a||!h&&o)return this.animatingOrInteracting_=!0,!0;this.animatingOrInteracting_=!1;var l=t.extent,u=t.viewState,c=u.projection,f=u.resolution,d=t.pixelRatio,v=i.getRevision(),_=i.getRenderBuffer(),p=i.getRenderOrder();p===void 0&&(p=iv);var g=u.center.slice(),y=gn(l,_*f),m=y.slice(),x=[y.slice()],E=c.getExtent();if(r.getWrapX()&&c.canWrapX()&&!Pe(E,t.extent)){var M=et(E),C=Math.max(et(y)/2,M);y[0]=E[0]-C,y[2]=E[2]+C,fh(g,c);var T=rf(x[0],c);T[0]<E[0]&&T[2]<E[2]?x.push([T[0]+M,T[1],T[2]+M,T[3]]):T[0]>E[0]&&T[2]>E[2]&&x.push([T[0]-M,T[1],T[2]-M,T[3]])}if(!this.dirty_&&this.renderedResolution_==f&&this.renderedRevision_==v&&this.renderedRenderOrder_==p&&Pe(this.wrappedRenderedExtent_,y))return ai(this.renderedExtent_,m)||(this.hitDetectionImageData_=null,this.renderedExtent_=m),this.renderedCenter_=g,this.replayGroupChanged=!1,!0;this.replayGroup_=null,this.dirty_=!1;var I=new us(La(f,d),y,f,d),A;this.getLayer().getDeclutter()&&(A=new us(La(f,d),y,f,d));var P=ph(),b;if(P){for(var L=0,j=x.length;L<j;++L){var N=x[L],G=Ia(N,c);r.loadFeatures(G,cf(f,c),P)}b=Br(P,c)}else for(var L=0,j=x.length;L<j;++L)r.loadFeatures(x[L],f,c);var D=nv(f,d),K=(function(ht){var U,lt=ht.getStyleFunction()||i.getStyleFunction();if(lt&&(U=lt(ht,f)),U){var Mt=this.renderFeature(ht,D,U,I,b,A);this.dirty_=this.dirty_||Mt}}).bind(this),V=Ia(y,c),$=r.getFeaturesInExtent(V);p&&$.sort(p);for(var L=0,j=$.length;L<j;++L)K($[L]);this.renderedFeatures_=$;var at=I.finish(),w=new ds(y,f,d,r.getOverlaps(),at,i.getRenderBuffer());return A&&(this.declutterExecutorGroup=new ds(y,f,d,r.getOverlaps(),A.finish(),i.getRenderBuffer())),this.renderedResolution_=f,this.renderedRevision_=v,this.renderedRenderOrder_=p,this.renderedExtent_=m,this.wrappedRenderedExtent_=y,this.renderedCenter_=g,this.renderedProjection_=c,this.replayGroup_=w,this.hitDetectionImageData_=null,this.replayGroupChanged=!0,!0},e.prototype.renderFeature=function(t,i,r,a,o,s){if(!r)return!1;var h=!1;if(Array.isArray(r))for(var l=0,u=r.length;l<u;++l)h=vs(a,t,r[l],i,this.boundHandleStyleImageChange_,o,s)||h;else h=vs(a,t,r,i,this.boundHandleStyleImageChange_,o,s);return h},e})(ao),_v=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),pv=(function(n){_v(e,n);function e(t){return n.call(this,t)||this}return e.prototype.createRenderer=function(){return new vv(this)},e})(Td),_s=(function(){function n(e){this.rbush_=new Xh(e),this.items_={}}return n.prototype.insert=function(e,t){var i={minX:e[0],minY:e[1],maxX:e[2],maxY:e[3],value:t};this.rbush_.insert(i),this.items_[H(t)]=i},n.prototype.load=function(e,t){for(var i=new Array(t.length),r=0,a=t.length;r<a;r++){var o=e[r],s=t[r],h={minX:o[0],minY:o[1],maxX:o[2],maxY:o[3],value:s};i[r]=h,this.items_[H(s)]=h}this.rbush_.load(i)},n.prototype.remove=function(e){var t=H(e),i=this.items_[t];return delete this.items_[t],this.rbush_.remove(i)!==null},n.prototype.update=function(e,t){var i=this.items_[H(t)],r=[i.minX,i.minY,i.maxX,i.maxY];Di(r,e)||(this.remove(t),this.insert(e,t))},n.prototype.getAll=function(){var e=this.rbush_.all();return e.map(function(t){return t.value})},n.prototype.getInExtent=function(e){var t={minX:e[0],minY:e[1],maxX:e[2],maxY:e[3]},i=this.rbush_.search(t);return i.map(function(r){return r.value})},n.prototype.forEach=function(e){return this.forEach_(this.getAll(),e)},n.prototype.forEachInExtent=function(e,t){return this.forEach_(this.getInExtent(e),t)},n.prototype.forEach_=function(e,t){for(var i,r=0,a=e.length;r<a;r++)if(i=t(e[r]),i)return i;return i},n.prototype.isEmpty=function(){return pn(this.items_)},n.prototype.clear=function(){this.rbush_.clear(),this.items_={}},n.prototype.getExtent=function(e){var t=this.rbush_.toJSON();return ae(t.minX,t.minY,t.maxX,t.maxY,e)},n.prototype.concat=function(e){this.rbush_.load(e.rbush_.all());for(var t in e.items_)this.items_[t]=e.items_[t]},n})(),gv=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),so=(function(n){gv(e,n);function e(t){var i=n.call(this)||this;i.projection=dt(t.projection),i.attributions_=ps(t.attributions),i.attributionsCollapsible_=t.attributionsCollapsible!==void 0?t.attributionsCollapsible:!0,i.loading=!1,i.state_=t.state!==void 0?t.state:ii.READY,i.wrapX_=t.wrapX!==void 0?t.wrapX:!1,i.interpolate_=!!t.interpolate,i.viewResolver=null,i.viewRejector=null;var r=i;return i.viewPromise_=new Promise(function(a,o){r.viewResolver=a,r.viewRejector=o}),i}return e.prototype.getAttributions=function(){return this.attributions_},e.prototype.getAttributionsCollapsible=function(){return this.attributionsCollapsible_},e.prototype.getProjection=function(){return this.projection},e.prototype.getResolutions=function(){return q()},e.prototype.getView=function(){return this.viewPromise_},e.prototype.getState=function(){return this.state_},e.prototype.getWrapX=function(){return this.wrapX_},e.prototype.getInterpolate=function(){return this.interpolate_},e.prototype.refresh=function(){this.changed()},e.prototype.setAttributions=function(t){this.attributions_=ps(t),this.changed()},e.prototype.setState=function(t){this.state_=t,this.changed()},e})(se);function ps(n){return n?Array.isArray(n)?function(e){return n}:typeof n=="function"?n:function(e){return[n]}:null}const Vt={ADDFEATURE:"addfeature",CHANGEFEATURE:"changefeature",CLEAR:"clear",REMOVEFEATURE:"removefeature",FEATURESLOADSTART:"featuresloadstart",FEATURESLOADEND:"featuresloadend",FEATURESLOADERROR:"featuresloaderror"};function yv(n,e){return[[-1/0,-1/0,1/0,1/0]]}var mv=!1;function xv(n,e,t,i,r,a,o){var s=new XMLHttpRequest;s.open("GET",typeof n=="function"?n(t,i,r):n,!0),e.getType()==Qi.ARRAY_BUFFER&&(s.responseType="arraybuffer"),s.withCredentials=mv,s.onload=function(h){if(!s.status||s.status>=200&&s.status<300){var l=e.getType(),u=void 0;l==Qi.JSON||l==Qi.TEXT?u=s.responseText:l==Qi.XML?(u=s.responseXML,u||(u=new DOMParser().parseFromString(s.responseText,"application/xml"))):l==Qi.ARRAY_BUFFER&&(u=s.response),u?a(e.readFeatures(u,{extent:t,featureProjection:r}),e.readProjection(u)):o()}else o()},s.onerror=o,s.send()}function gs(n,e){return function(t,i,r,a,o){var s=this;xv(n,e,t,i,r,function(h,l){s.addFeatures(h),a!==void 0&&a(h)},o||ti)}}var tl=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Me=(function(n){tl(e,n);function e(t,i,r){var a=n.call(this,t)||this;return a.feature=i,a.features=r,a}return e})(Zt),el=(function(n){tl(e,n);function e(t){var i=this,r=t||{};i=n.call(this,{attributions:r.attributions,interpolate:!0,projection:void 0,state:ii.READY,wrapX:r.wrapX!==void 0?r.wrapX:!0})||this,i.on,i.once,i.un,i.loader_=ti,i.format_=r.format,i.overlaps_=r.overlaps===void 0?!0:r.overlaps,i.url_=r.url,r.loader!==void 0?i.loader_=r.loader:i.url_!==void 0&&(Y(i.format_,7),i.loader_=gs(i.url_,i.format_)),i.strategy_=r.strategy!==void 0?r.strategy:yv;var a=r.useSpatialIndex!==void 0?r.useSpatialIndex:!0;i.featuresRtree_=a?new _s:null,i.loadedExtentsRtree_=new _s,i.loadingExtentsCount_=0,i.nullGeometryFeatures_={},i.idIndex_={},i.uidIndex_={},i.featureChangeKeys_={},i.featuresCollection_=null;var o,s;return Array.isArray(r.features)?s=r.features:r.features&&(o=r.features,s=o.getArray()),!a&&o===void 0&&(o=new xt(s)),s!==void 0&&i.addFeaturesInternal(s),o!==void 0&&i.bindFeaturesCollection_(o),i}return e.prototype.addFeature=function(t){this.addFeatureInternal(t),this.changed()},e.prototype.addFeatureInternal=function(t){var i=H(t);if(!this.addToIndex_(i,t)){this.featuresCollection_&&this.featuresCollection_.remove(t);return}this.setupChangeEvents_(i,t);var r=t.getGeometry();if(r){var a=r.getExtent();this.featuresRtree_&&this.featuresRtree_.insert(a,t)}else this.nullGeometryFeatures_[i]=t;this.dispatchEvent(new Me(Vt.ADDFEATURE,t))},e.prototype.setupChangeEvents_=function(t,i){this.featureChangeKeys_[t]=[Z(i,B.CHANGE,this.handleFeatureChange_,this),Z(i,Pi.PROPERTYCHANGE,this.handleFeatureChange_,this)]},e.prototype.addToIndex_=function(t,i){var r=!0,a=i.getId();return a!==void 0&&(a.toString()in this.idIndex_?r=!1:this.idIndex_[a.toString()]=i),r&&(Y(!(t in this.uidIndex_),30),this.uidIndex_[t]=i),r},e.prototype.addFeatures=function(t){this.addFeaturesInternal(t),this.changed()},e.prototype.addFeaturesInternal=function(t){for(var i=[],r=[],a=[],o=0,s=t.length;o<s;o++){var h=t[o],l=H(h);this.addToIndex_(l,h)&&r.push(h)}for(var o=0,u=r.length;o<u;o++){var h=r[o],l=H(h);this.setupChangeEvents_(l,h);var c=h.getGeometry();if(c){var f=c.getExtent();i.push(f),a.push(h)}else this.nullGeometryFeatures_[l]=h}if(this.featuresRtree_&&this.featuresRtree_.load(i,a),this.hasListener(Vt.ADDFEATURE))for(var o=0,d=r.length;o<d;o++)this.dispatchEvent(new Me(Vt.ADDFEATURE,r[o]))},e.prototype.bindFeaturesCollection_=function(t){var i=!1;this.addEventListener(Vt.ADDFEATURE,function(r){i||(i=!0,t.push(r.feature),i=!1)}),this.addEventListener(Vt.REMOVEFEATURE,function(r){i||(i=!0,t.remove(r.feature),i=!1)}),t.addEventListener(Pt.ADD,(function(r){i||(i=!0,this.addFeature(r.element),i=!1)}).bind(this)),t.addEventListener(Pt.REMOVE,(function(r){i||(i=!0,this.removeFeature(r.element),i=!1)}).bind(this)),this.featuresCollection_=t},e.prototype.clear=function(t){if(t){for(var i in this.featureChangeKeys_){var r=this.featureChangeKeys_[i];r.forEach(rt)}this.featuresCollection_||(this.featureChangeKeys_={},this.idIndex_={},this.uidIndex_={})}else if(this.featuresRtree_){var a=(function(h){this.removeFeatureInternal(h)}).bind(this);this.featuresRtree_.forEach(a);for(var o in this.nullGeometryFeatures_)this.removeFeatureInternal(this.nullGeometryFeatures_[o])}this.featuresCollection_&&this.featuresCollection_.clear(),this.featuresRtree_&&this.featuresRtree_.clear(),this.nullGeometryFeatures_={};var s=new Me(Vt.CLEAR);this.dispatchEvent(s),this.changed()},e.prototype.forEachFeature=function(t){if(this.featuresRtree_)return this.featuresRtree_.forEach(t);this.featuresCollection_&&this.featuresCollection_.forEach(t)},e.prototype.forEachFeatureAtCoordinateDirect=function(t,i){var r=[t[0],t[1],t[0],t[1]];return this.forEachFeatureInExtent(r,function(a){var o=a.getGeometry();if(o.intersectsCoordinate(t))return i(a)})},e.prototype.forEachFeatureInExtent=function(t,i){if(this.featuresRtree_)return this.featuresRtree_.forEachInExtent(t,i);this.featuresCollection_&&this.featuresCollection_.forEach(i)},e.prototype.forEachFeatureIntersectingExtent=function(t,i){return this.forEachFeatureInExtent(t,function(r){var a=r.getGeometry();if(a.intersectsExtent(t)){var o=i(r);if(o)return o}})},e.prototype.getFeaturesCollection=function(){return this.featuresCollection_},e.prototype.getFeatures=function(){var t;return this.featuresCollection_?t=this.featuresCollection_.getArray().slice(0):this.featuresRtree_&&(t=this.featuresRtree_.getAll(),pn(this.nullGeometryFeatures_)||qs(t,Ks(this.nullGeometryFeatures_))),t},e.prototype.getFeaturesAtCoordinate=function(t){var i=[];return this.forEachFeatureAtCoordinateDirect(t,function(r){i.push(r)}),i},e.prototype.getFeaturesInExtent=function(t){return this.featuresRtree_?this.featuresRtree_.getInExtent(t):this.featuresCollection_?this.featuresCollection_.getArray().slice(0):[]},e.prototype.getClosestFeatureToCoordinate=function(t,i){var r=t[0],a=t[1],o=null,s=[NaN,NaN],h=1/0,l=[-1/0,-1/0,1/0,1/0],u=i||De;return this.featuresRtree_.forEachInExtent(l,function(c){if(u(c)){var f=c.getGeometry(),d=h;if(h=f.closestPointXY(r,a,s,h),h<d){o=c;var v=Math.sqrt(h);l[0]=r-v,l[1]=a-v,l[2]=r+v,l[3]=a+v}}}),o},e.prototype.getExtent=function(t){return this.featuresRtree_.getExtent(t)},e.prototype.getFeatureById=function(t){var i=this.idIndex_[t.toString()];return i!==void 0?i:null},e.prototype.getFeatureByUid=function(t){var i=this.uidIndex_[t];return i!==void 0?i:null},e.prototype.getFormat=function(){return this.format_},e.prototype.getOverlaps=function(){return this.overlaps_},e.prototype.getUrl=function(){return this.url_},e.prototype.handleFeatureChange_=function(t){var i=t.target,r=H(i),a=i.getGeometry();if(!a)r in this.nullGeometryFeatures_||(this.featuresRtree_&&this.featuresRtree_.remove(i),this.nullGeometryFeatures_[r]=i);else{var o=a.getExtent();r in this.nullGeometryFeatures_?(delete this.nullGeometryFeatures_[r],this.featuresRtree_&&this.featuresRtree_.insert(o,i)):this.featuresRtree_&&this.featuresRtree_.update(o,i)}var s=i.getId();if(s!==void 0){var h=s.toString();this.idIndex_[h]!==i&&(this.removeFromIdIndex_(i),this.idIndex_[h]=i)}else this.removeFromIdIndex_(i),this.uidIndex_[r]=i;this.changed(),this.dispatchEvent(new Me(Vt.CHANGEFEATURE,i))},e.prototype.hasFeature=function(t){var i=t.getId();return i!==void 0?i in this.idIndex_:H(t)in this.uidIndex_},e.prototype.isEmpty=function(){return this.featuresRtree_?this.featuresRtree_.isEmpty()&&pn(this.nullGeometryFeatures_):this.featuresCollection_?this.featuresCollection_.getLength()===0:!0},e.prototype.loadFeatures=function(t,i,r){for(var a=this.loadedExtentsRtree_,o=this.strategy_(t,i,r),s=function(c,f){var d=o[c],v=a.forEachInExtent(d,function(_){return Pe(_.extent,d)});v||(++h.loadingExtentsCount_,h.dispatchEvent(new Me(Vt.FEATURESLOADSTART)),h.loader_.call(h,d,i,r,(function(_){--this.loadingExtentsCount_,this.dispatchEvent(new Me(Vt.FEATURESLOADEND,void 0,_))}).bind(h),(function(){--this.loadingExtentsCount_,this.dispatchEvent(new Me(Vt.FEATURESLOADERROR))}).bind(h)),a.insert(d,{extent:d.slice()}))},h=this,l=0,u=o.length;l<u;++l)s(l);this.loading=this.loader_.length<4?!1:this.loadingExtentsCount_>0},e.prototype.refresh=function(){this.clear(!0),this.loadedExtentsRtree_.clear(),n.prototype.refresh.call(this)},e.prototype.removeLoadedExtent=function(t){var i=this.loadedExtentsRtree_,r;i.forEachInExtent(t,function(a){if(Di(a.extent,t))return r=a,!0}),r&&i.remove(r)},e.prototype.removeFeature=function(t){if(t){var i=H(t);i in this.nullGeometryFeatures_?delete this.nullGeometryFeatures_[i]:this.featuresRtree_&&this.featuresRtree_.remove(t);var r=this.removeFeatureInternal(t);r&&this.changed()}},e.prototype.removeFeatureInternal=function(t){var i=H(t),r=this.featureChangeKeys_[i];if(r){r.forEach(rt),delete this.featureChangeKeys_[i];var a=t.getId();return a!==void 0&&delete this.idIndex_[a.toString()],delete this.uidIndex_[i],this.dispatchEvent(new Me(Vt.REMOVEFEATURE,t)),t}},e.prototype.removeFromIdIndex_=function(t){var i=!1;for(var r in this.idIndex_)if(this.idIndex_[r]===t){delete this.idIndex_[r],i=!0;break}return i},e.prototype.setLoader=function(t){this.loader_=t},e.prototype.setUrl=function(t){Y(this.format_,7),this.url_=t,this.setLoader(gs(t,this.format_))},e})(so),il=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ua={TRANSLATESTART:"translatestart",TRANSLATING:"translating",TRANSLATEEND:"translateend"},fa=(function(n){il(e,n);function e(t,i,r,a,o){var s=n.call(this,t)||this;return s.features=i,s.coordinate=r,s.startCoordinate=a,s.mapBrowserEvent=o,s}return e})(Zt),Ev=(function(n){il(e,n);function e(t){var i=this,r=t||{};i=n.call(this,r)||this,i.on,i.once,i.un,i.lastCoordinate_=null,i.startCoordinate_=null,i.features_=r.features!==void 0?r.features:null;var a;if(r.layers&&!i.features_)if(typeof r.layers=="function")a=r.layers;else{var o=r.layers;a=function(s){return So(o,s)}}else a=De;return i.layerFilter_=a,i.filter_=r.filter&&!i.features_?r.filter:De,i.hitTolerance_=r.hitTolerance?r.hitTolerance:0,i.condition_=r.condition?r.condition:kh,i.lastFeature_=null,i.addChangeListener(Aa.ACTIVE,i.handleActiveChanged_),i}return e.prototype.handleDownEvent=function(t){if(!t.originalEvent||!this.condition_(t))return!1;if(this.lastFeature_=this.featuresAtPixel_(t.pixel,t.map),!this.lastCoordinate_&&this.lastFeature_){this.startCoordinate_=t.coordinate,this.lastCoordinate_=t.coordinate,this.handleMoveEvent(t);var i=this.features_||new xt([this.lastFeature_]);return this.dispatchEvent(new fa(ua.TRANSLATESTART,i,t.coordinate,this.startCoordinate_,t)),!0}return!1},e.prototype.handleUpEvent=function(t){if(this.lastCoordinate_){this.lastCoordinate_=null,this.handleMoveEvent(t);var i=this.features_||new xt([this.lastFeature_]);return this.dispatchEvent(new fa(ua.TRANSLATEEND,i,t.coordinate,this.startCoordinate_,t)),this.startCoordinate_=null,!0}return!1},e.prototype.handleDragEvent=function(t){if(this.lastCoordinate_){var i=t.coordinate,r=i[0]-this.lastCoordinate_[0],a=i[1]-this.lastCoordinate_[1],o=this.features_||new xt([this.lastFeature_]);o.forEach(function(s){var h=s.getGeometry();h.translate(r,a),s.setGeometry(h)}),this.lastCoordinate_=i,this.dispatchEvent(new fa(ua.TRANSLATING,o,i,this.startCoordinate_,t))}},e.prototype.handleMoveEvent=function(t){var i=t.map.getViewport();this.featuresAtPixel_(t.pixel,t.map)?(i.classList.remove(this.lastCoordinate_?"ol-grab":"ol-grabbing"),i.classList.add(this.lastCoordinate_?"ol-grabbing":"ol-grab")):i.classList.remove("ol-grab","ol-grabbing")},e.prototype.featuresAtPixel_=function(t,i){return i.forEachFeatureAtPixel(t,(function(r,a){if(this.filter_(r,a)&&(!this.features_||So(this.features_.getArray(),r)))return r}).bind(this),{layerFilter:this.layerFilter_,hitTolerance:this.hitTolerance_})},e.prototype.getHitTolerance=function(){return this.hitTolerance_},e.prototype.setHitTolerance=function(t){this.hitTolerance_=t},e.prototype.setMap=function(t){var i=this.getMap();n.prototype.setMap.call(this,t),this.updateState_(i)},e.prototype.handleActiveChanged_=function(){this.updateState_(null)},e.prototype.updateState_=function(t){var i=this.getMap(),r=this.getActive();if((!i||!r)&&(i=i||t,i)){var a=i.getViewport();a.classList.remove("ol-grab","ol-grabbing")}},e})(Bi);function nl(n){var e=n||{},t=new xt,i=new Jc(-.005,.05,100),r=e.altShiftDragRotate!==void 0?e.altShiftDragRotate:!0;r&&t.push(new Bc);var a=e.doubleClickZoom!==void 0?e.doubleClickZoom:!0;a&&t.push(new Lc({delta:e.zoomDelta,duration:e.zoomDuration}));var o=e.dragPan!==void 0?e.dragPan:!0;o&&t.push(new jc({onFocusOnly:e.onFocusOnly,kinetic:i}));var s=e.pinchRotate!==void 0?e.pinchRotate:!0;s&&t.push(new id);var h=e.pinchZoom!==void 0?e.pinchZoom:!0;h&&t.push(new rd({duration:e.zoomDuration}));var l=e.keyboard!==void 0?e.keyboard:!0;l&&(t.push(new $c),t.push(new Hc({delta:e.zoomDelta,duration:e.zoomDuration})));var u=e.mouseWheelZoom!==void 0?e.mouseWheelZoom:!0;u&&t.push(new td({onFocusOnly:e.onFocusOnly,duration:e.zoomDuration}));var c=e.shiftDragZoom!==void 0?e.shiftDragZoom:!0;return c&&t.push(new qc({duration:e.zoomDuration})),t}var Mv=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Tv=(function(n){Mv(e,n);function e(t){return t=it({},t),t.controls||(t.controls=Fh()),t.interactions||(t.interactions=nl({onFocusOnly:!0})),n.call(this,t)||this}return e.prototype.createRenderer=function(){return new Df(this)},e})(Ic);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const Cv=n=>class extends iu(nu(n)){constructor(){super(),this._mapTarget=document.createElement("div"),this._mapTarget.id="map",this._mapTarget.setAttribute("tabindex","0");const e={controls:Fh({rotate:!1,zoomOptions:{zoomInLabel:"",zoomOutLabel:""}}),interactions:nl({onFocusOnly:!1}),target:this._mapTarget};this._configuration=new Tv(e)}get configuration(){return this._configuration}ready(){super.ready(),this.shadowRoot.appendChild(this._mapTarget),this.__addMapFocusListeners()}_onResize(e){this._configuration.updateSize()}__addMapFocusListeners(){this._mapTarget.addEventListener("focusin",e=>{e.target===this._mapTarget&&this._setFocused(!0)}),this._mapTarget.addEventListener("focusout",()=>{this._setFocused(!1)})}_shouldSetFocus(e){return!1}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const Rv=Vs`
  :host {
    display: block;
    height: 400px;
    flex: 1 1 auto;
    align-self: stretch;
    overflow: hidden;
  }

  :host([hidden]) {
    display: none !important;
  }

  #map {
    width: 100%;
    height: 100%;
    outline: none;
  }

  #map,
  .ol-viewport,
  .ol-layers {
    border-radius: inherit;
    overflow: hidden;
  }

  #map:fullscreen {
    border-radius: 0;
  }

  #map:-webkit-full-screen {
    border-radius: 0;
  }

  /* Functional styles, copied from 'ol/ol.css' */

  .ol-box {
    box-sizing: border-box;
    border-radius: 2px;
    border: 1px solid rgba(0, 0, 0, 0.5);
    background-color: rgba(255, 255, 255, 0.2);
    box-shadow: 0 0 0 1px rgba(255, 255, 255, 0.5);
  }

  .ol-unsupported {
    display: none;
  }

  .ol-viewport,
  .ol-unselectable {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    user-select: none;
    -webkit-tap-highlight-color: transparent;
  }

  .ol-viewport canvas {
    all: unset;
  }

  .ol-selectable {
    -webkit-touch-callout: default;
    -webkit-user-select: text;
    user-select: text;
  }

  .ol-grabbing {
    cursor: grabbing;
  }

  .ol-grab {
    cursor: move;
    cursor: grab;
  }

  /* Control positioning and styling */

  .ol-overlaycontainer-stopevent {
    /* stylelint-disable declaration-block-no-redundant-longhand-properties */
    display: grid;
    grid-template-columns: min-content 1fr min-content;
    grid-template-rows: min-content 1fr min-content min-content min-content min-content;
    padding: var(--vaadin-map-controls-inset, 0.25em);
    box-sizing: border-box;
    grid-template-areas:
      'scale mouse-position fullscreen'
      'overview-map . zoom-extent'
      'overview-map . compass'
      'overview-map . zoom-slider'
      'overview-map . zoom'
      'overview-map attribution attribution';
  }

  .ol-mouse-position {
    grid-area: mouse-position;
    align-self: start;
    text-align: center;
    font-size: 0.625em;
    color: #000;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-line,
  .ol-scale-bar {
    grid-area: scale;
    position: relative;
    pointer-events: none !important;
    color: #000;
  }

  .ol-scale-line-inner {
    border: 1px solid rgba(0, 0, 0, 0.5);
    border-top: none;
    font-size: 0.625em;
    text-align: center;
    will-change: contents, width, filter;
    transition: all 0.25s;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-bar-inner {
    border: 1px solid rgba(0, 0, 0, 0.5);
    box-shadow: 0 0 0 1px rgba(255, 255, 255, 0.5);
    overflow: hidden;
  }

  .ol-scale-step-marker {
    display: none;
  }

  .ol-scale-step-text {
    position: absolute;
    top: 0.75em;
    font-size: 0.625em;
    color: #000;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
    white-space: nowrap;
    overflow: hidden;
  }

  .ol-scale-text {
    position: absolute;
    font-size: 0.625em;
    top: 2em;
    color: #000;
    white-space: nowrap;
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
  }

  .ol-scale-singlebar {
    height: 0.25em;
    opacity: 0.5;
  }

  .ol-control {
    margin: 0.25em;
  }

  .ol-control button {
    -webkit-appearance: none;
    border: 0;
    margin: 0;
    padding: 0;
    background: #fff;
    font: inherit;
    color: inherit;
    width: 1.5em;
    height: 1.5em;
  }

  .ol-control button::-moz-focus-inner {
    border: none;
    padding: 0;
  }

  .ol-compass {
    grid-area: compass;
    display: block;
    will-change: transform;
  }

  .ol-zoom {
    grid-area: zoom;
    display: flex;
    flex-direction: column;
  }

  .ol-zoom-in:empty::before {
    content: var(--vaadin-map-icon-zoom-in, '+');
  }

  .ol-zoom-out:empty::before {
    content: var(--vaadin-map-icon-zoom-out, '\\2013');
  }

  .ol-attribution {
    grid-area: attribution;
    margin-inline-start: auto !important;
    display: flex;
    flex-flow: row-reverse;
  }

  .ol-attribution.ol-uncollapsible {
    margin-inline-end: calc(var(--vaadin-map-controls-inset, 0.25em) * -1);
    margin-block-end: calc(var(--vaadin-map-controls-inset, 0.25em) * -1);
  }

  .ol-attribution button span:empty::before {
    content: var(--vaadin-map-icon-attribution-collapse, '\\25B8');
  }

  .ol-attribution.ol-collapsed button span:empty::before {
    content: var(--vaadin-map-icon-attribution-expand, '\\2139');
  }

  .ol-attribution ul {
    display: flex;
    align-items: center;
    gap: 1em;
    list-style: none;
    margin: 0;
    padding: 0.25em 0.5em;
    font-size: 0.8em;
  }

  .ol-attribution.ol-collapsed ul {
    display: none;
  }

  .ol-attribution.ol-uncollapsible button {
    display: none;
  }

  .ol-rotate {
    grid-area: compass;
  }

  .ol-compass:empty::before {
    content: var(--vaadin-map-icon-compass, '\\2191');
  }

  .ol-full-screen {
    grid-area: fullscreen;
  }

  .ol-full-screen button:empty::before {
    content: var(--vaadin-map-icon-fullscreen, '\\2922');
  }

  .ol-full-screen .ol-full-screen-true:empty::before {
    content: var(--vaadin-map-icon-close, '\\00D7');
  }

  .ol-overviewmap {
    grid-area: overview-map;
    align-self: end;
    width: max-content;
  }

  .ol-overviewmap button span:empty::before {
    content: var(--vaadin-map-icon-overview-map-collapse, '\\25BE');
  }

  .ol-overviewmap.ol-collapsed button span:empty::before {
    content: var(--vaadin-map-icon-overview-map-expand, '\\25B4');
  }

  .ol-overviewmap-map {
    height: 10em;
    width: 10em;
    border: 1px solid rgba(0, 0, 0, 0.5);
  }

  .ol-overviewmap.ol-collapsed .ol-overviewmap-map,
  .ol-overviewmap.ol-uncollapsible button {
    display: none;
  }

  .ol-overviewmap-box {
    border: 1px dashed rgba(0, 0, 0, 0.5);
    filter: drop-shadow(0 0 1px #fff) drop-shadow(0 0 1px #fff);
    will-change: filter;
    cursor: move;
  }

  .ol-zoomslider {
    grid-area: zoom-slider;
    height: 8em;
  }

  .ol-zoomslider button {
    position: relative;
    height: 0.5em;
    display: block;
    border-radius: inherit;
  }

  .ol-zoom-extent {
    grid-area: zoom-extent;
    align-self: end;
  }
`;/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */Ys("vaadin-map",Rv,{moduleId:"vaadin-map-styles"});let wv=class extends Cv(eu(au(ou))){static get is(){return"vaadin-map"}static get cvdlName(){return"vaadin-map"}static get template(){return ru``}};tu(wv);function Iv(n){var e=Object.keys(n.defs),t=e.length,i,r;for(i=0;i<t;++i){var a=e[i];if(!dt(a)){var o=n.defs(a),s=o.units;!s&&o.projName==="longlat"&&(s=Nt.DEGREES),vh(new Ba({code:a,axisOrientation:o.axis,metersPerUnit:o.to_meter,units:s}))}}for(i=0;i<t;++i){var h=e[i],l=dt(h);for(r=0;r<t;++r){var u=e[r],c=dt(u);if(!rh(h,u))if(n.defs[h]===n.defs[u])Ra([l,c]);else{var f=n(h,u);ff(l,c,Bo(l,c,f.forward),Bo(c,l,f.inverse))}}}}function Sv(n){n("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),n("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),n("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");for(var e=1;e<=60;++e)n("EPSG:"+(32600+e),"+proj=utm +zone="+e+" +datum=WGS84 +units=m"),n("EPSG:"+(32700+e),"+proj=utm +zone="+e+" +south +datum=WGS84 +units=m");n.WGS84=n["EPSG:4326"],n["EPSG:3785"]=n["EPSG:3857"],n.GOOGLE=n["EPSG:3857"],n["EPSG:900913"]=n["EPSG:3857"],n["EPSG:102113"]=n["EPSG:3857"]}var ni=1,ri=2,Oi=3,Ov=4,Na=5,ys=6378137,Av=6356752314e-3,ms=.0066943799901413165,fn=484813681109536e-20,R=Math.PI/2,Pv=.16666666666666666,Lv=.04722222222222222,Nv=.022156084656084655,S=1e-10,gt=.017453292519943295,ee=57.29577951308232,J=Math.PI/4,Rn=Math.PI*2,ct=3.14159265359,Dt={};Dt.greenwich=0;Dt.lisbon=-9.131906111111;Dt.paris=2.337229166667;Dt.bogota=-74.080916666667;Dt.madrid=-3.687938888889;Dt.rome=12.452333333333;Dt.bern=7.439583333333;Dt.jakarta=106.807719444444;Dt.ferro=-17.666666666667;Dt.brussels=4.367975;Dt.stockholm=18.058277777778;Dt.athens=23.7163375;Dt.oslo=10.722916666667;const bv={mm:{to_meter:.001},cm:{to_meter:.01},ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937},fath:{to_meter:1.8288},kmi:{to_meter:1852},"us-ch":{to_meter:20.1168402336805},"us-mi":{to_meter:1609.34721869444},km:{to_meter:1e3},"ind-ft":{to_meter:.30479841},"ind-yd":{to_meter:.91439523},mi:{to_meter:1609.344},yd:{to_meter:.9144},ch:{to_meter:20.1168},link:{to_meter:.201168},dm:{to_meter:.01},in:{to_meter:.0254},"ind-ch":{to_meter:20.11669506},"us-in":{to_meter:.025400050800101},"us-yd":{to_meter:.914401828803658}};var xs=/[\s_\-\/\(\)]/g;function ke(n,e){if(n[e])return n[e];for(var t=Object.keys(n),i=e.toLowerCase().replace(xs,""),r=-1,a,o;++r<t.length;)if(a=t[r],o=a.toLowerCase().replace(xs,""),o===i)return n[a]}function ba(n){var e={},t=n.split("+").map(function(s){return s.trim()}).filter(function(s){return s}).reduce(function(s,h){var l=h.split("=");return l.push(!0),s[l[0].toLowerCase()]=l[1],s},{}),i,r,a,o={proj:"projName",datum:"datumCode",rf:function(s){e.rf=parseFloat(s)},lat_0:function(s){e.lat0=s*gt},lat_1:function(s){e.lat1=s*gt},lat_2:function(s){e.lat2=s*gt},lat_ts:function(s){e.lat_ts=s*gt},lon_0:function(s){e.long0=s*gt},lon_1:function(s){e.long1=s*gt},lon_2:function(s){e.long2=s*gt},alpha:function(s){e.alpha=parseFloat(s)*gt},gamma:function(s){e.rectified_grid_angle=parseFloat(s)},lonc:function(s){e.longc=s*gt},x_0:function(s){e.x0=parseFloat(s)},y_0:function(s){e.y0=parseFloat(s)},k_0:function(s){e.k0=parseFloat(s)},k:function(s){e.k0=parseFloat(s)},a:function(s){e.a=parseFloat(s)},b:function(s){e.b=parseFloat(s)},r:function(s){e.a=e.b=parseFloat(s)},r_a:function(){e.R_A=!0},zone:function(s){e.zone=parseInt(s,10)},south:function(){e.utmSouth=!0},towgs84:function(s){e.datum_params=s.split(",").map(function(h){return parseFloat(h)})},to_meter:function(s){e.to_meter=parseFloat(s)},units:function(s){e.units=s;var h=ke(bv,s);h&&(e.to_meter=h.to_meter)},from_greenwich:function(s){e.from_greenwich=s*gt},pm:function(s){var h=ke(Dt,s);e.from_greenwich=(h||parseFloat(s))*gt},nadgrids:function(s){s==="@null"?e.datumCode="none":e.nadgrids=s},axis:function(s){var h="ewnsud";s.length===3&&h.indexOf(s.substr(0,1))!==-1&&h.indexOf(s.substr(1,1))!==-1&&h.indexOf(s.substr(2,1))!==-1&&(e.axis=s)},approx:function(){e.approx=!0}};for(i in t)r=t[i],i in o?(a=o[i],typeof a=="function"?a(r):e[a]=r):e[i]=r;return typeof e.datumCode=="string"&&e.datumCode!=="WGS84"&&(e.datumCode=e.datumCode.toLowerCase()),e}class rl{static getId(e){const t=e.find(i=>Array.isArray(i)&&i[0]==="ID");return t&&t.length>=3?{authority:t[1],code:parseInt(t[2],10)}:null}static convertUnit(e,t="unit"){if(!e||e.length<3)return{type:t,name:"unknown",conversion_factor:null};const i=e[1],r=parseFloat(e[2])||null,a=e.find(s=>Array.isArray(s)&&s[0]==="ID"),o=a?{authority:a[1],code:parseInt(a[2],10)}:null;return{type:t,name:i,conversion_factor:r,id:o}}static convertAxis(e){const t=e[1]||"Unknown";let i;const r=t.match(/^\((.)\)$/);if(r){const l=r[1].toUpperCase();if(l==="E")i="east";else if(l==="N")i="north";else if(l==="U")i="up";else throw new Error(`Unknown axis abbreviation: ${l}`)}else i=e[2]?e[2].toLowerCase():"unknown";const a=e.find(l=>Array.isArray(l)&&l[0]==="ORDER"),o=a?parseInt(a[1],10):null,s=e.find(l=>Array.isArray(l)&&(l[0]==="LENGTHUNIT"||l[0]==="ANGLEUNIT"||l[0]==="SCALEUNIT")),h=this.convertUnit(s);return{name:t,direction:i,unit:h,order:o}}static extractAxes(e){return e.filter(t=>Array.isArray(t)&&t[0]==="AXIS").map(t=>this.convertAxis(t)).sort((t,i)=>(t.order||0)-(i.order||0))}static convert(e,t={}){switch(e[0]){case"PROJCRS":t.type="ProjectedCRS",t.name=e[1],t.base_crs=e.find(f=>Array.isArray(f)&&f[0]==="BASEGEOGCRS")?this.convert(e.find(f=>Array.isArray(f)&&f[0]==="BASEGEOGCRS")):null,t.conversion=e.find(f=>Array.isArray(f)&&f[0]==="CONVERSION")?this.convert(e.find(f=>Array.isArray(f)&&f[0]==="CONVERSION")):null;const i=e.find(f=>Array.isArray(f)&&f[0]==="CS");i&&(t.coordinate_system={type:i[1],axis:this.extractAxes(e)});const r=e.find(f=>Array.isArray(f)&&f[0]==="LENGTHUNIT");if(r){const f=this.convertUnit(r);t.coordinate_system.unit=f}t.id=this.getId(e);break;case"BASEGEOGCRS":case"GEOGCRS":t.type="GeographicCRS",t.name=e[1];const a=e.find(f=>Array.isArray(f)&&(f[0]==="DATUM"||f[0]==="ENSEMBLE"));if(a){const f=this.convert(a);a[0]==="ENSEMBLE"?t.datum_ensemble=f:t.datum=f;const d=e.find(v=>Array.isArray(v)&&v[0]==="PRIMEM");d&&d[1]!=="Greenwich"&&(f.prime_meridian={name:d[1],longitude:parseFloat(d[2])})}t.coordinate_system={type:"ellipsoidal",axis:this.extractAxes(e)},t.id=this.getId(e);break;case"DATUM":t.type="GeodeticReferenceFrame",t.name=e[1],t.ellipsoid=e.find(f=>Array.isArray(f)&&f[0]==="ELLIPSOID")?this.convert(e.find(f=>Array.isArray(f)&&f[0]==="ELLIPSOID")):null;break;case"ENSEMBLE":t.type="DatumEnsemble",t.name=e[1],t.members=e.filter(f=>Array.isArray(f)&&f[0]==="MEMBER").map(f=>({type:"DatumEnsembleMember",name:f[1],id:this.getId(f)}));const o=e.find(f=>Array.isArray(f)&&f[0]==="ENSEMBLEACCURACY");o&&(t.accuracy=parseFloat(o[1]));const s=e.find(f=>Array.isArray(f)&&f[0]==="ELLIPSOID");s&&(t.ellipsoid=this.convert(s)),t.id=this.getId(e);break;case"ELLIPSOID":t.type="Ellipsoid",t.name=e[1],t.semi_major_axis=parseFloat(e[2]),t.inverse_flattening=parseFloat(e[3]),e.find(f=>Array.isArray(f)&&f[0]==="LENGTHUNIT")&&this.convert(e.find(f=>Array.isArray(f)&&f[0]==="LENGTHUNIT"),t);break;case"CONVERSION":t.type="Conversion",t.name=e[1],t.method=e.find(f=>Array.isArray(f)&&f[0]==="METHOD")?this.convert(e.find(f=>Array.isArray(f)&&f[0]==="METHOD")):null,t.parameters=e.filter(f=>Array.isArray(f)&&f[0]==="PARAMETER").map(f=>this.convert(f));break;case"METHOD":t.type="Method",t.name=e[1],t.id=this.getId(e);break;case"PARAMETER":t.type="Parameter",t.name=e[1],t.value=parseFloat(e[2]),t.unit=this.convertUnit(e.find(f=>Array.isArray(f)&&(f[0]==="LENGTHUNIT"||f[0]==="ANGLEUNIT"||f[0]==="SCALEUNIT"))),t.id=this.getId(e);break;case"BOUNDCRS":t.type="BoundCRS";const h=e.find(f=>Array.isArray(f)&&f[0]==="SOURCECRS");if(h){const f=h.find(d=>Array.isArray(d));t.source_crs=f?this.convert(f):null}const l=e.find(f=>Array.isArray(f)&&f[0]==="TARGETCRS");if(l){const f=l.find(d=>Array.isArray(d));t.target_crs=f?this.convert(f):null}const u=e.find(f=>Array.isArray(f)&&f[0]==="ABRIDGEDTRANSFORMATION");u?t.transformation=this.convert(u):t.transformation=null;break;case"ABRIDGEDTRANSFORMATION":if(t.type="Transformation",t.name=e[1],t.method=e.find(f=>Array.isArray(f)&&f[0]==="METHOD")?this.convert(e.find(f=>Array.isArray(f)&&f[0]==="METHOD")):null,t.parameters=e.filter(f=>Array.isArray(f)&&(f[0]==="PARAMETER"||f[0]==="PARAMETERFILE")).map(f=>{if(f[0]==="PARAMETER")return this.convert(f);if(f[0]==="PARAMETERFILE")return{name:f[1],value:f[2],id:{authority:"EPSG",code:8656}}}),t.parameters.length===7){const f=t.parameters[6];f.name==="Scale difference"&&(f.value=Math.round((f.value-1)*1e12)/1e6)}t.id=this.getId(e);break;case"AXIS":t.coordinate_system||(t.coordinate_system={type:"unspecified",axis:[]}),t.coordinate_system.axis.push(this.convertAxis(e));break;case"LENGTHUNIT":const c=this.convertUnit(e,"LinearUnit");t.coordinate_system&&t.coordinate_system.axis&&t.coordinate_system.axis.forEach(f=>{f.unit||(f.unit=c)}),c.conversion_factor&&c.conversion_factor!==1&&t.semi_major_axis&&(t.semi_major_axis={value:t.semi_major_axis,unit:c});break;default:t.keyword=e[0];break}return t}}class Dv extends rl{static convert(e,t={}){return super.convert(e,t),t.coordinate_system&&t.coordinate_system.subtype==="Cartesian"&&delete t.coordinate_system,t.usage&&delete t.usage,t}}class Fv extends rl{static convert(e,t={}){super.convert(e,t);const i=e.find(a=>Array.isArray(a)&&a[0]==="CS");i&&(t.coordinate_system={subtype:i[1],axis:this.extractAxes(e)});const r=e.find(a=>Array.isArray(a)&&a[0]==="USAGE");if(r){const a=r.find(h=>Array.isArray(h)&&h[0]==="SCOPE"),o=r.find(h=>Array.isArray(h)&&h[0]==="AREA"),s=r.find(h=>Array.isArray(h)&&h[0]==="BBOX");t.usage={},a&&(t.usage.scope=a[1]),o&&(t.usage.area=o[1]),s&&(t.usage.bbox=s.slice(1))}return t}}function Gv(n){return n.find(e=>Array.isArray(e)&&e[0]==="USAGE")?"2019":(n.find(e=>Array.isArray(e)&&e[0]==="CS")||n[0]==="BOUNDCRS"||n[0]==="PROJCRS"||n[0]==="GEOGCRS","2015")}function kv(n){return(Gv(n)==="2019"?Fv:Dv).convert(n)}function zv(n){const e=n.toUpperCase();return e.includes("PROJCRS")||e.includes("GEOGCRS")||e.includes("BOUNDCRS")||e.includes("VERTCRS")||e.includes("LENGTHUNIT")||e.includes("ANGLEUNIT")||e.includes("SCALEUNIT")?"WKT2":(e.includes("PROJCS")||e.includes("GEOGCS")||e.includes("LOCAL_CS")||e.includes("VERT_CS")||e.includes("UNIT"),"WKT1")}var wn=1,al=2,ol=3,wr=4,sl=5,ho=-1,jv=/\s/,Uv=/[A-Za-z]/,Bv=/[A-Za-z84_]/,Vr=/[,\]]/,hl=/[\d\.E\-\+]/;function _e(n){if(typeof n!="string")throw new Error("not a string");this.text=n.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=wn}_e.prototype.readCharicter=function(){var n=this.text[this.place++];if(this.state!==wr)for(;jv.test(n);){if(this.place>=this.text.length)return;n=this.text[this.place++]}switch(this.state){case wn:return this.neutral(n);case al:return this.keyword(n);case wr:return this.quoted(n);case sl:return this.afterquote(n);case ol:return this.number(n);case ho:return}};_e.prototype.afterquote=function(n){if(n==='"'){this.word+='"',this.state=wr;return}if(Vr.test(n)){this.word=this.word.trim(),this.afterItem(n);return}throw new Error(`havn't handled "`+n+'" in afterquote yet, index '+this.place)};_e.prototype.afterItem=function(n){if(n===","){this.word!==null&&this.currentObject.push(this.word),this.word=null,this.state=wn;return}if(n==="]"){this.level--,this.word!==null&&(this.currentObject.push(this.word),this.word=null),this.state=wn,this.currentObject=this.stack.pop(),this.currentObject||(this.state=ho);return}};_e.prototype.number=function(n){if(hl.test(n)){this.word+=n;return}if(Vr.test(n)){this.word=parseFloat(this.word),this.afterItem(n);return}throw new Error(`havn't handled "`+n+'" in number yet, index '+this.place)};_e.prototype.quoted=function(n){if(n==='"'){this.state=sl;return}this.word+=n};_e.prototype.keyword=function(n){if(Bv.test(n)){this.word+=n;return}if(n==="["){var e=[];e.push(this.word),this.level++,this.root===null?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,this.state=wn;return}if(Vr.test(n)){this.afterItem(n);return}throw new Error(`havn't handled "`+n+'" in keyword yet, index '+this.place)};_e.prototype.neutral=function(n){if(Uv.test(n)){this.word=n,this.state=al;return}if(n==='"'){this.word="",this.state=wr;return}if(hl.test(n)){this.word=n,this.state=ol;return}if(Vr.test(n)){this.afterItem(n);return}throw new Error(`havn't handled "`+n+'" in neutral yet, index '+this.place)};_e.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(this.state===ho)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};function Wv(n){var e=new _e(n);return e.output()}function ca(n,e,t){Array.isArray(e)&&(t.unshift(e),e=null);var i=e?{}:n,r=t.reduce(function(a,o){return Mi(o,a),a},i);e&&(n[e]=r)}function Mi(n,e){if(!Array.isArray(n)){e[n]=!0;return}var t=n.shift();if(t==="PARAMETER"&&(t=n.shift()),n.length===1){if(Array.isArray(n[0])){e[t]={},Mi(n[0],e[t]);return}e[t]=n[0];return}if(!n.length){e[t]=!0;return}if(t==="TOWGS84"){e[t]=n;return}if(t==="AXIS"){t in e||(e[t]=[]),e[t].push(n);return}Array.isArray(t)||(e[t]={});var i;switch(t){case"UNIT":case"PRIMEM":case"VERT_DATUM":e[t]={name:n[0].toLowerCase(),convert:n[1]},n.length===3&&Mi(n[2],e[t]);return;case"SPHEROID":case"ELLIPSOID":e[t]={name:n[0],a:n[1],rf:n[2]},n.length===4&&Mi(n[3],e[t]);return;case"EDATUM":case"ENGINEERINGDATUM":case"LOCAL_DATUM":case"DATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":n[0]=["name",n[0]],ca(e,t,n);return;case"COMPD_CS":case"COMPOUNDCRS":case"FITTED_CS":case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"ENGCRS":case"ENGINEERINGCRS":n[0]=["name",n[0]],ca(e,t,n),e[t].type=t;return;default:for(i=-1;++i<n.length;)if(!Array.isArray(n[i]))return Mi(n,e[t]);return ca(e,t,n)}}var Xv=.017453292519943295;function qt(n){return n*Xv}function ll(n){const e=(n.projName||"").toLowerCase().replace(/_/g," ");!n.long0&&n.longc&&(e==="albers conic equal area"||e==="lambert azimuthal equal area")&&(n.long0=n.longc),!n.lat_ts&&n.lat1&&(e==="stereographic south pole"||e==="polar stereographic (variant b)")?(n.lat0=qt(n.lat1>0?90:-90),n.lat_ts=n.lat1,delete n.lat1):!n.lat_ts&&n.lat0&&(e==="polar stereographic"||e==="polar stereographic (variant a)")&&(n.lat_ts=n.lat0,n.lat0=qt(n.lat0>0?90:-90),delete n.lat1)}function Es(n){let e={units:null,to_meter:void 0};return typeof n=="string"?(e.units=n.toLowerCase(),e.units==="metre"&&(e.units="meter"),e.units==="meter"&&(e.to_meter=1)):n&&n.name&&(e.units=n.name.toLowerCase(),e.units==="metre"&&(e.units="meter"),e.to_meter=n.conversion_factor),e}function Ms(n){return typeof n=="object"?n.value*n.unit.conversion_factor:n}function Ts(n,e){n.ellipsoid.radius?(e.a=n.ellipsoid.radius,e.rf=0):(e.a=Ms(n.ellipsoid.semi_major_axis),n.ellipsoid.inverse_flattening!==void 0?e.rf=n.ellipsoid.inverse_flattening:n.ellipsoid.semi_major_axis!==void 0&&n.ellipsoid.semi_minor_axis!==void 0&&(e.rf=e.a/(e.a-Ms(n.ellipsoid.semi_minor_axis))))}function Ir(n,e={}){return!n||typeof n!="object"?n:n.type==="BoundCRS"?(Ir(n.source_crs,e),n.transformation&&(n.transformation.method&&n.transformation.method.name==="NTv2"?e.nadgrids=n.transformation.parameters[0].value:e.datum_params=n.transformation.parameters.map(t=>t.value)),e):(Object.keys(n).forEach(t=>{const i=n[t];if(i!==null)switch(t){case"name":if(e.srsCode)break;e.name=i,e.srsCode=i;break;case"type":i==="GeographicCRS"?e.projName="longlat":i==="ProjectedCRS"&&n.conversion&&n.conversion.method&&(e.projName=n.conversion.method.name);break;case"datum":case"datum_ensemble":i.ellipsoid&&(e.ellps=i.ellipsoid.name,Ts(i,e)),i.prime_meridian&&(e.from_greenwich=i.prime_meridian.longitude*Math.PI/180);break;case"ellipsoid":e.ellps=i.name,Ts(i,e);break;case"prime_meridian":e.long0=(i.longitude||0)*Math.PI/180;break;case"coordinate_system":if(i.axis){if(e.axis=i.axis.map(r=>{const a=r.direction;if(a==="east")return"e";if(a==="north")return"n";if(a==="west")return"w";if(a==="south")return"s";throw new Error(`Unknown axis direction: ${a}`)}).join("")+"u",i.unit){const{units:r,to_meter:a}=Es(i.unit);e.units=r,e.to_meter=a}else if(i.axis[0]&&i.axis[0].unit){const{units:r,to_meter:a}=Es(i.axis[0].unit);e.units=r,e.to_meter=a}}break;case"id":i.authority&&i.code&&(e.title=i.authority+":"+i.code);break;case"conversion":i.method&&i.method.name&&(e.projName=i.method.name),i.parameters&&i.parameters.forEach(r=>{const a=r.name.toLowerCase().replace(/\s+/g,"_"),o=r.value;r.unit&&r.unit.conversion_factor?e[a]=o*r.unit.conversion_factor:r.unit==="degree"?e[a]=o*Math.PI/180:e[a]=o});break;case"unit":i.name&&(e.units=i.name.toLowerCase(),e.units==="metre"&&(e.units="meter")),i.conversion_factor&&(e.to_meter=i.conversion_factor);break;case"base_crs":Ir(i,e),e.datumCode=i.id?i.id.authority+"_"+i.id.code:i.name;break}}),e.latitude_of_false_origin!==void 0&&(e.lat0=e.latitude_of_false_origin),e.longitude_of_false_origin!==void 0&&(e.long0=e.longitude_of_false_origin),e.latitude_of_standard_parallel!==void 0&&(e.lat0=e.latitude_of_standard_parallel,e.lat1=e.latitude_of_standard_parallel),e.latitude_of_1st_standard_parallel!==void 0&&(e.lat1=e.latitude_of_1st_standard_parallel),e.latitude_of_2nd_standard_parallel!==void 0&&(e.lat2=e.latitude_of_2nd_standard_parallel),e.latitude_of_projection_centre!==void 0&&(e.lat0=e.latitude_of_projection_centre),e.longitude_of_projection_centre!==void 0&&(e.longc=e.longitude_of_projection_centre),e.easting_at_false_origin!==void 0&&(e.x0=e.easting_at_false_origin),e.northing_at_false_origin!==void 0&&(e.y0=e.northing_at_false_origin),e.latitude_of_natural_origin!==void 0&&(e.lat0=e.latitude_of_natural_origin),e.longitude_of_natural_origin!==void 0&&(e.long0=e.longitude_of_natural_origin),e.longitude_of_origin!==void 0&&(e.long0=e.longitude_of_origin),e.false_easting!==void 0&&(e.x0=e.false_easting),e.easting_at_projection_centre&&(e.x0=e.easting_at_projection_centre),e.false_northing!==void 0&&(e.y0=e.false_northing),e.northing_at_projection_centre&&(e.y0=e.northing_at_projection_centre),e.standard_parallel_1!==void 0&&(e.lat1=e.standard_parallel_1),e.standard_parallel_2!==void 0&&(e.lat2=e.standard_parallel_2),e.scale_factor_at_natural_origin!==void 0&&(e.k0=e.scale_factor_at_natural_origin),e.scale_factor_at_projection_centre!==void 0&&(e.k0=e.scale_factor_at_projection_centre),e.scale_factor_on_pseudo_standard_parallel!==void 0&&(e.k0=e.scale_factor_on_pseudo_standard_parallel),e.azimuth!==void 0&&(e.alpha=e.azimuth),e.azimuth_at_projection_centre!==void 0&&(e.alpha=e.azimuth_at_projection_centre),e.angle_from_rectified_to_skew_grid&&(e.rectified_grid_angle=e.angle_from_rectified_to_skew_grid),ll(e),e)}var Yv=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];function Vv(n,e){var t=e[0],i=e[1];!(t in n)&&i in n&&(n[t]=n[i],e.length===3&&(n[t]=e[2](n[t])))}function ul(n){for(var e=Object.keys(n),t=0,i=e.length;t<i;++t){var r=e[t];Yv.indexOf(r)!==-1&&qv(n[r]),typeof n[r]=="object"&&ul(n[r])}}function qv(n){if(n.AUTHORITY){var e=Object.keys(n.AUTHORITY)[0];e&&e in n.AUTHORITY&&(n.title=e+":"+n.AUTHORITY[e])}if(n.type==="GEOGCS"?n.projName="longlat":n.type==="LOCAL_CS"?(n.projName="identity",n.local=!0):typeof n.PROJECTION=="object"?n.projName=Object.keys(n.PROJECTION)[0]:n.projName=n.PROJECTION,n.AXIS){for(var t="",i=0,r=n.AXIS.length;i<r;++i){var a=[n.AXIS[i][0].toLowerCase(),n.AXIS[i][1].toLowerCase()];a[0].indexOf("north")!==-1||(a[0]==="y"||a[0]==="lat")&&a[1]==="north"?t+="n":a[0].indexOf("south")!==-1||(a[0]==="y"||a[0]==="lat")&&a[1]==="south"?t+="s":a[0].indexOf("east")!==-1||(a[0]==="x"||a[0]==="lon")&&a[1]==="east"?t+="e":(a[0].indexOf("west")!==-1||(a[0]==="x"||a[0]==="lon")&&a[1]==="west")&&(t+="w")}t.length===2&&(t+="u"),t.length===3&&(n.axis=t)}n.UNIT&&(n.units=n.UNIT.name.toLowerCase(),n.units==="metre"&&(n.units="meter"),n.UNIT.convert&&(n.type==="GEOGCS"?n.DATUM&&n.DATUM.SPHEROID&&(n.to_meter=n.UNIT.convert*n.DATUM.SPHEROID.a):n.to_meter=n.UNIT.convert));var o=n.GEOGCS;n.type==="GEOGCS"&&(o=n),o&&(o.DATUM?n.datumCode=o.DATUM.name.toLowerCase():n.datumCode=o.name.toLowerCase(),n.datumCode.slice(0,2)==="d_"&&(n.datumCode=n.datumCode.slice(2)),n.datumCode==="new_zealand_1949"&&(n.datumCode="nzgd49"),(n.datumCode==="wgs_1984"||n.datumCode==="world_geodetic_system_1984")&&(n.PROJECTION==="Mercator_Auxiliary_Sphere"&&(n.sphere=!0),n.datumCode="wgs84"),n.datumCode==="belge_1972"&&(n.datumCode="rnb72"),o.DATUM&&o.DATUM.SPHEROID&&(n.ellps=o.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),n.ellps.toLowerCase().slice(0,13)==="international"&&(n.ellps="intl"),n.a=o.DATUM.SPHEROID.a,n.rf=parseFloat(o.DATUM.SPHEROID.rf,10)),o.DATUM&&o.DATUM.TOWGS84&&(n.datum_params=o.DATUM.TOWGS84),~n.datumCode.indexOf("osgb_1936")&&(n.datumCode="osgb36"),~n.datumCode.indexOf("osni_1952")&&(n.datumCode="osni52"),(~n.datumCode.indexOf("tm65")||~n.datumCode.indexOf("geodetic_datum_of_1965"))&&(n.datumCode="ire65"),n.datumCode==="ch1903+"&&(n.datumCode="ch1903"),~n.datumCode.indexOf("israel")&&(n.datumCode="isr93")),n.b&&!isFinite(n.b)&&(n.b=n.a),n.rectified_grid_angle&&(n.rectified_grid_angle=qt(n.rectified_grid_angle));function s(u){var c=n.to_meter||1;return u*c}var h=function(u){return Vv(n,u)},l=[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",qt],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",qt],["x0","false_easting",s],["y0","false_northing",s],["long0","central_meridian",qt],["lat0","latitude_of_origin",qt],["lat0","standard_parallel_1",qt],["lat1","standard_parallel_1",qt],["lat2","standard_parallel_2",qt],["azimuth","Azimuth"],["alpha","azimuth",qt],["srsCode","name"]];l.forEach(h),ll(n)}function fl(n){if(typeof n=="object")return Ir(n);const e=zv(n);var t=Wv(n);if(e==="WKT2"){const a=kv(t);return Ir(a)}var i=t[0],r={};return Mi(t,r),ul(r),r[i]}function Tt(n){var e=this;if(arguments.length===2){var t=arguments[1];typeof t=="string"?t.charAt(0)==="+"?Tt[n]=ba(arguments[1]):Tt[n]=fl(arguments[1]):Tt[n]=t}else if(arguments.length===1){if(Array.isArray(n))return n.map(function(i){Array.isArray(i)?Tt.apply(e,i):Tt(i)});if(typeof n=="string"){if(n in Tt)return Tt[n]}else"EPSG"in n?Tt["EPSG:"+n.EPSG]=n:"ESRI"in n?Tt["ESRI:"+n.ESRI]=n:"IAU2000"in n?Tt["IAU2000:"+n.IAU2000]=n:console.log(n);return}}Sv(Tt);function Kv(n){return typeof n=="string"}function $v(n){return n in Tt}var Zv=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];function Hv(n){return Zv.some(function(e){return n.indexOf(e)>-1})}var Jv=["3857","900913","3785","102113"];function Qv(n){var e=ke(n,"authority");if(e){var t=ke(e,"epsg");return t&&Jv.indexOf(t)>-1}}function t_(n){var e=ke(n,"extension");if(e)return ke(e,"proj4")}function e_(n){return n[0]==="+"}function i_(n){if(Kv(n)){if($v(n))return Tt[n];if(Hv(n)){var e=fl(n);if(Qv(e))return Tt["EPSG:3857"];var t=t_(e);return t?ba(t):e}if(e_(n))return ba(n)}else return n}function Cs(n,e){n=n||{};var t,i;if(!e)return n;for(i in e)t=e[i],t!==void 0&&(n[i]=t);return n}function oe(n,e,t){var i=n*e;return t/Math.sqrt(1-i*i)}function Gn(n){return n<0?-1:1}function O(n){return Math.abs(n)<=ct?n:n-Gn(n)*Rn}function Kt(n,e,t){var i=n*t,r=.5*n;return i=Math.pow((1-i)/(1+i),r),Math.tan(.5*(R-e))/i}function In(n,e){for(var t=.5*n,i,r,a=R-2*Math.atan(e),o=0;o<=15;o++)if(i=n*Math.sin(a),r=R-2*Math.atan(e*Math.pow((1-i)/(1+i),t))-a,a+=r,Math.abs(r)<=1e-10)return a;return-9999}function n_(){var n=this.b/this.a;this.es=1-n*n,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=oe(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function r_(n){var e=n.x,t=n.y;if(t*ee>90&&t*ee<-90&&e*ee>180&&e*ee<-180)return null;var i,r;if(Math.abs(Math.abs(t)-R)<=S)return null;if(this.sphere)i=this.x0+this.a*this.k0*O(e-this.long0),r=this.y0+this.a*this.k0*Math.log(Math.tan(J+.5*t));else{var a=Math.sin(t),o=Kt(this.e,t,a);i=this.x0+this.a*this.k0*O(e-this.long0),r=this.y0-this.a*this.k0*Math.log(o)}return n.x=i,n.y=r,n}function a_(n){var e=n.x-this.x0,t=n.y-this.y0,i,r;if(this.sphere)r=R-2*Math.atan(Math.exp(-t/(this.a*this.k0)));else{var a=Math.exp(-t/(this.a*this.k0));if(r=In(this.e,a),r===-9999)return null}return i=O(this.long0+e/(this.a*this.k0)),n.x=i,n.y=r,n}var o_=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"];const s_={init:n_,forward:r_,inverse:a_,names:o_};function h_(){}function Rs(n){return n}var l_=["longlat","identity"];const u_={init:h_,forward:Rs,inverse:Rs,names:l_};var f_=[s_,u_],fr={},Sr=[];function cl(n,e){var t=Sr.length;return n.names?(Sr[t]=n,n.names.forEach(function(i){fr[i.toLowerCase()]=t}),this):(console.log(e),!0)}function c_(n){if(!n)return!1;var e=n.toLowerCase();if(typeof fr[e]<"u"&&Sr[fr[e]])return Sr[fr[e]]}function d_(){f_.forEach(cl)}const v_={start:d_,add:cl,get:c_};var z={};z.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"};z.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"};z.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"};z.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"};z.airy={a:6377563396e-3,b:635625691e-2,ellipseName:"Airy 1830"};z.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"};z.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"};z.mod_airy={a:6377340189e-3,b:6356034446e-3,ellipseName:"Modified Airy"};z.andrae={a:637710443e-2,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"};z.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"};z.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"};z.bessel={a:6377397155e-3,rf:299.1528128,ellipseName:"Bessel 1841"};z.bess_nam={a:6377483865e-3,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"};z.clrk66={a:63782064e-1,b:63565838e-1,ellipseName:"Clarke 1866"};z.clrk80={a:6378249145e-3,rf:293.4663,ellipseName:"Clarke 1880 mod."};z.clrk80ign={a:63782492e-1,b:6356515,rf:293.4660213,ellipseName:"Clarke 1880 (IGN)"};z.clrk58={a:6378293645208759e-9,rf:294.2606763692654,ellipseName:"Clarke 1858"};z.CPM={a:63757387e-1,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"};z.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"};z.engelis={a:637813605e-2,rf:298.2566,ellipseName:"Engelis 1985"};z.evrst30={a:6377276345e-3,rf:300.8017,ellipseName:"Everest 1830"};z.evrst48={a:6377304063e-3,rf:300.8017,ellipseName:"Everest 1948"};z.evrst56={a:6377301243e-3,rf:300.8017,ellipseName:"Everest 1956"};z.evrst69={a:6377295664e-3,rf:300.8017,ellipseName:"Everest 1969"};z.evrstSS={a:6377298556e-3,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"};z.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"};z.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"};z.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"};z.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"};z.hough={a:6378270,rf:297,ellipseName:"Hough"};z.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"};z.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"};z.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"};z.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"};z.new_intl={a:63781575e-1,b:63567722e-1,ellipseName:"New International 1967"};z.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"};z.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"};z.SEasia={a:6378155,b:63567733205e-4,ellipseName:"Southeast Asia"};z.walbeck={a:6376896,b:63558348467e-4,ellipseName:"Walbeck"};z.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"};z.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"};z.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"};var __=z.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};z.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};function p_(n,e,t,i){var r=n*n,a=e*e,o=(r-a)/r,s=0;i?(n*=1-o*(Pv+o*(Lv+o*Nv)),r=n*n,o=0):s=Math.sqrt(o);var h=(r-a)/a;return{es:o,e:s,ep2:h}}function g_(n,e,t,i,r){if(!n){var a=ke(z,i);a||(a=__),n=a.a,e=a.b,t=a.rf}return t&&!e&&(e=(1-1/t)*n),(t===0||Math.abs(n-e)<S)&&(r=!0,e=n),{a:n,b:e,rf:t,sphere:r}}var cr={wgs84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},ch1903:{towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},ggrs87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},nad83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},nad27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},mgi:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Militar-Geographische Institut"},osni52:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},rassadiran:{towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},osgb36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Ordnance Survey of Great Britain 1936"},s_jtsk:{towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},beduaram:{towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},gunung_segara:{towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},rnb72:{towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}};for(var y_ in cr){var ws=cr[y_];cr[ws.datumName]=ws}function m_(n,e,t,i,r,a,o){var s={};return n===void 0||n==="none"?s.datum_type=Na:s.datum_type=Ov,e&&(s.datum_params=e.map(parseFloat),(s.datum_params[0]!==0||s.datum_params[1]!==0||s.datum_params[2]!==0)&&(s.datum_type=ni),s.datum_params.length>3&&(s.datum_params[3]!==0||s.datum_params[4]!==0||s.datum_params[5]!==0||s.datum_params[6]!==0)&&(s.datum_type=ri,s.datum_params[3]*=fn,s.datum_params[4]*=fn,s.datum_params[5]*=fn,s.datum_params[6]=s.datum_params[6]/1e6+1)),o&&(s.datum_type=Oi,s.grids=o),s.a=t,s.b=i,s.es=r,s.ep2=a,s}var dl={};function x_(n,e){var t=new DataView(e),i=T_(t),r=C_(t,i),a=R_(t,r,i),o={header:r,subgrids:a};return dl[n]=o,o}function E_(n){if(n===void 0)return null;var e=n.split(",");return e.map(M_)}function M_(n){if(n.length===0)return null;var e=n[0]==="@";return e&&(n=n.slice(1)),n==="null"?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:n,mandatory:!e,grid:dl[n]||null,isNull:!1}}function Ti(n){return n/3600*Math.PI/180}function T_(n){var e=n.getInt32(8,!1);return e===11?!1:(e=n.getInt32(8,!0),e!==11&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian"),!0)}function C_(n,e){return{nFields:n.getInt32(8,e),nSubgridFields:n.getInt32(24,e),nSubgrids:n.getInt32(40,e),shiftType:Da(n,56,64).trim(),fromSemiMajorAxis:n.getFloat64(120,e),fromSemiMinorAxis:n.getFloat64(136,e),toSemiMajorAxis:n.getFloat64(152,e),toSemiMinorAxis:n.getFloat64(168,e)}}function Da(n,e,t){return String.fromCharCode.apply(null,new Uint8Array(n.buffer.slice(e,t)))}function R_(n,e,t){for(var i=176,r=[],a=0;a<e.nSubgrids;a++){var o=I_(n,i,t),s=S_(n,i,o,t),h=Math.round(1+(o.upperLongitude-o.lowerLongitude)/o.longitudeInterval),l=Math.round(1+(o.upperLatitude-o.lowerLatitude)/o.latitudeInterval);r.push({ll:[Ti(o.lowerLongitude),Ti(o.lowerLatitude)],del:[Ti(o.longitudeInterval),Ti(o.latitudeInterval)],lim:[h,l],count:o.gridNodeCount,cvs:w_(s)}),i+=176+o.gridNodeCount*16}return r}function w_(n){return n.map(function(e){return[Ti(e.longitudeShift),Ti(e.latitudeShift)]})}function I_(n,e,t){return{name:Da(n,e+8,e+16).trim(),parent:Da(n,e+24,e+24+8).trim(),lowerLatitude:n.getFloat64(e+72,t),upperLatitude:n.getFloat64(e+88,t),lowerLongitude:n.getFloat64(e+104,t),upperLongitude:n.getFloat64(e+120,t),latitudeInterval:n.getFloat64(e+136,t),longitudeInterval:n.getFloat64(e+152,t),gridNodeCount:n.getInt32(e+168,t)}}function S_(n,e,t,i){for(var r=e+176,a=16,o=[],s=0;s<t.gridNodeCount;s++){var h={latitudeShift:n.getFloat32(r+s*a,i),longitudeShift:n.getFloat32(r+s*a+4,i),latitudeAccuracy:n.getFloat32(r+s*a+8,i),longitudeAccuracy:n.getFloat32(r+s*a+12,i)};o.push(h)}return o}function ne(n,e){if(!(this instanceof ne))return new ne(n);e=e||function(l){if(l)throw l};var t=i_(n);if(typeof t!="object"){e("Could not parse to valid json: "+n);return}var i=ne.projections.get(t.projName);if(!i){e("Could not get projection name from: "+n);return}if(t.datumCode&&t.datumCode!=="none"){var r=ke(cr,t.datumCode);r&&(t.datum_params=t.datum_params||(r.towgs84?r.towgs84.split(","):null),t.ellps=r.ellipse,t.datumName=r.datumName?r.datumName:t.datumCode)}t.k0=t.k0||1,t.axis=t.axis||"enu",t.ellps=t.ellps||"wgs84",t.lat1=t.lat1||t.lat0;var a=g_(t.a,t.b,t.rf,t.ellps,t.sphere),o=p_(a.a,a.b,a.rf,t.R_A),s=E_(t.nadgrids),h=t.datum||m_(t.datumCode,t.datum_params,a.a,a.b,o.es,o.ep2,s);Cs(this,t),Cs(this,i),this.a=a.a,this.b=a.b,this.rf=a.rf,this.sphere=a.sphere,this.es=o.es,this.e=o.e,this.ep2=o.ep2,this.datum=h,this.init(),e(null,this)}ne.projections=v_;ne.projections.start();function O_(n,e){return n.datum_type!==e.datum_type||n.a!==e.a||Math.abs(n.es-e.es)>5e-11?!1:n.datum_type===ni?n.datum_params[0]===e.datum_params[0]&&n.datum_params[1]===e.datum_params[1]&&n.datum_params[2]===e.datum_params[2]:n.datum_type===ri?n.datum_params[0]===e.datum_params[0]&&n.datum_params[1]===e.datum_params[1]&&n.datum_params[2]===e.datum_params[2]&&n.datum_params[3]===e.datum_params[3]&&n.datum_params[4]===e.datum_params[4]&&n.datum_params[5]===e.datum_params[5]&&n.datum_params[6]===e.datum_params[6]:!0}function vl(n,e,t){var i=n.x,r=n.y,a=n.z?n.z:0,o,s,h,l;if(r<-R&&r>-1.001*R)r=-R;else if(r>R&&r<1.001*R)r=R;else{if(r<-R)return{x:-1/0,y:-1/0,z:n.z};if(r>R)return{x:1/0,y:1/0,z:n.z}}return i>Math.PI&&(i-=2*Math.PI),s=Math.sin(r),l=Math.cos(r),h=s*s,o=t/Math.sqrt(1-e*h),{x:(o+a)*l*Math.cos(i),y:(o+a)*l*Math.sin(i),z:(o*(1-e)+a)*s}}function _l(n,e,t,i){var r=1e-12,a=r*r,o=30,s,h,l,u,c,f,d,v,_,p,g,y,m,x=n.x,E=n.y,M=n.z?n.z:0,C,T,I;if(s=Math.sqrt(x*x+E*E),h=Math.sqrt(x*x+E*E+M*M),s/t<r){if(C=0,h/t<r)return T=R,I=-i,{x:n.x,y:n.y,z:n.z}}else C=Math.atan2(E,x);l=M/h,u=s/h,c=1/Math.sqrt(1-e*(2-e)*u*u),v=u*(1-e)*c,_=l*c,m=0;do m++,d=t/Math.sqrt(1-e*_*_),I=s*v+M*_-d*(1-e*_*_),f=e*d/(d+I),c=1/Math.sqrt(1-f*(2-f)*u*u),p=u*(1-f)*c,g=l*c,y=g*v-p*_,v=p,_=g;while(y*y>a&&m<o);return T=Math.atan(g/Math.abs(p)),{x:C,y:T,z:I}}function A_(n,e,t){if(e===ni)return{x:n.x+t[0],y:n.y+t[1],z:n.z+t[2]};if(e===ri){var i=t[0],r=t[1],a=t[2],o=t[3],s=t[4],h=t[5],l=t[6];return{x:l*(n.x-h*n.y+s*n.z)+i,y:l*(h*n.x+n.y-o*n.z)+r,z:l*(-s*n.x+o*n.y+n.z)+a}}}function P_(n,e,t){if(e===ni)return{x:n.x-t[0],y:n.y-t[1],z:n.z-t[2]};if(e===ri){var i=t[0],r=t[1],a=t[2],o=t[3],s=t[4],h=t[5],l=t[6],u=(n.x-i)/l,c=(n.y-r)/l,f=(n.z-a)/l;return{x:u+h*c-s*f,y:-h*u+c+o*f,z:s*u-o*c+f}}}function ar(n){return n===ni||n===ri}function L_(n,e,t){if(O_(n,e)||n.datum_type===Na||e.datum_type===Na)return t;var i=n.a,r=n.es;if(n.datum_type===Oi){var a=Is(n,!1,t);if(a!==0)return;i=ys,r=ms}var o=e.a,s=e.b,h=e.es;if(e.datum_type===Oi&&(o=ys,s=Av,h=ms),r===h&&i===o&&!ar(n.datum_type)&&!ar(e.datum_type))return t;if(t=vl(t,r,i),ar(n.datum_type)&&(t=A_(t,n.datum_type,n.datum_params)),ar(e.datum_type)&&(t=P_(t,e.datum_type,e.datum_params)),t=_l(t,h,o,s),e.datum_type===Oi){var l=Is(e,!0,t);if(l!==0)return}return t}function Is(n,e,t){if(n.grids===null||n.grids.length===0)return console.log("Grid shift grids not found"),-1;var i={x:-t.x,y:t.y},r={x:Number.NaN,y:Number.NaN},a=[];t:for(var o=0;o<n.grids.length;o++){var s=n.grids[o];if(a.push(s.name),s.isNull){r=i;break}if(s.mandatory,s.grid===null){if(s.mandatory)return console.log("Unable to find mandatory grid '"+s.name+"'"),-1;continue}for(var h=s.grid.subgrids,l=0,u=h.length;l<u;l++){var c=h[l],f=(Math.abs(c.del[1])+Math.abs(c.del[0]))/1e4,d=c.ll[0]-f,v=c.ll[1]-f,_=c.ll[0]+(c.lim[0]-1)*c.del[0]+f,p=c.ll[1]+(c.lim[1]-1)*c.del[1]+f;if(!(v>i.y||d>i.x||p<i.y||_<i.x)&&(r=N_(i,e,c),!isNaN(r.x)))break t}}return isNaN(r.x)?(console.log("Failed to find a grid shift table for location '"+-i.x*ee+" "+i.y*ee+" tried: '"+a+"'"),-1):(t.x=-r.x,t.y=r.y,0)}function N_(n,e,t){var i={x:Number.NaN,y:Number.NaN};if(isNaN(n.x))return i;var r={x:n.x,y:n.y};r.x-=t.ll[0],r.y-=t.ll[1],r.x=O(r.x-Math.PI)+Math.PI;var a=Ss(r,t);if(e){if(isNaN(a.x))return i;a.x=r.x-a.x,a.y=r.y-a.y;var o=9,s=1e-12,h,l;do{if(l=Ss(a,t),isNaN(l.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}h={x:r.x-(l.x+a.x),y:r.y-(l.y+a.y)},a.x+=h.x,a.y+=h.y}while(o--&&Math.abs(h.x)>s&&Math.abs(h.y)>s);if(o<0)return console.log("Inverse grid shift iterator failed to converge."),i;i.x=O(a.x+t.ll[0]),i.y=a.y+t.ll[1]}else isNaN(a.x)||(i.x=n.x+a.x,i.y=n.y+a.y);return i}function Ss(n,e){var t={x:n.x/e.del[0],y:n.y/e.del[1]},i={x:Math.floor(t.x),y:Math.floor(t.y)},r={x:t.x-1*i.x,y:t.y-1*i.y},a={x:Number.NaN,y:Number.NaN},o;if(i.x<0||i.x>=e.lim[0]||i.y<0||i.y>=e.lim[1])return a;o=i.y*e.lim[0]+i.x;var s={x:e.cvs[o][0],y:e.cvs[o][1]};o++;var h={x:e.cvs[o][0],y:e.cvs[o][1]};o+=e.lim[0];var l={x:e.cvs[o][0],y:e.cvs[o][1]};o--;var u={x:e.cvs[o][0],y:e.cvs[o][1]},c=r.x*r.y,f=r.x*(1-r.y),d=(1-r.x)*(1-r.y),v=(1-r.x)*r.y;return a.x=d*s.x+f*h.x+v*u.x+c*l.x,a.y=d*s.y+f*h.y+v*u.y+c*l.y,a}function Os(n,e,t){var i=t.x,r=t.y,a=t.z||0,o,s,h,l={};for(h=0;h<3;h++)if(!(e&&h===2&&t.z===void 0))switch(h===0?(o=i,"ew".indexOf(n.axis[h])!==-1?s="x":s="y"):h===1?(o=r,"ns".indexOf(n.axis[h])!==-1?s="y":s="x"):(o=a,s="z"),n.axis[h]){case"e":l[s]=o;break;case"w":l[s]=-o;break;case"n":l[s]=o;break;case"s":l[s]=-o;break;case"u":t[s]!==void 0&&(l.z=o);break;case"d":t[s]!==void 0&&(l.z=-o);break;default:return null}return l}function pl(n){var e={x:n[0],y:n[1]};return n.length>2&&(e.z=n[2]),n.length>3&&(e.m=n[3]),e}function b_(n){As(n.x),As(n.y)}function As(n){if(typeof Number.isFinite=="function"){if(Number.isFinite(n))return;throw new TypeError("coordinates must be finite numbers")}if(typeof n!="number"||n!==n||!isFinite(n))throw new TypeError("coordinates must be finite numbers")}function D_(n,e){return(n.datum.datum_type===ni||n.datum.datum_type===ri||n.datum.datum_type===Oi)&&e.datumCode!=="WGS84"||(e.datum.datum_type===ni||e.datum.datum_type===ri||e.datum.datum_type===Oi)&&n.datumCode!=="WGS84"}function Or(n,e,t,i){var r;Array.isArray(t)?t=pl(t):t={x:t.x,y:t.y,z:t.z,m:t.m};var a=t.z!==void 0;if(b_(t),n.datum&&e.datum&&D_(n,e)&&(r=new ne("WGS84"),t=Or(n,r,t,i),n=r),i&&n.axis!=="enu"&&(t=Os(n,!1,t)),n.projName==="longlat")t={x:t.x*gt,y:t.y*gt,z:t.z||0};else if(n.to_meter&&(t={x:t.x*n.to_meter,y:t.y*n.to_meter,z:t.z||0}),t=n.inverse(t),!t)return;if(n.from_greenwich&&(t.x+=n.from_greenwich),t=L_(n.datum,e.datum,t),!!t)return e.from_greenwich&&(t={x:t.x-e.from_greenwich,y:t.y,z:t.z||0}),e.projName==="longlat"?t={x:t.x*ee,y:t.y*ee,z:t.z||0}:(t=e.forward(t),e.to_meter&&(t={x:t.x/e.to_meter,y:t.y/e.to_meter,z:t.z||0})),i&&e.axis!=="enu"?Os(e,!0,t):(t&&!a&&delete t.z,t)}var Ps=ne("WGS84");function da(n,e,t,i){var r,a,o;return Array.isArray(t)?(r=Or(n,e,t,i)||{x:NaN,y:NaN},t.length>2?typeof n.name<"u"&&n.name==="geocent"||typeof e.name<"u"&&e.name==="geocent"?typeof r.z=="number"?[r.x,r.y,r.z].concat(t.slice(3)):[r.x,r.y,t[2]].concat(t.slice(3)):[r.x,r.y].concat(t.slice(2)):[r.x,r.y]):(a=Or(n,e,t,i),o=Object.keys(t),o.length===2||o.forEach(function(s){if(typeof n.name<"u"&&n.name==="geocent"||typeof e.name<"u"&&e.name==="geocent"){if(s==="x"||s==="y"||s==="z")return}else if(s==="x"||s==="y")return;a[s]=t[s]}),a)}function Ls(n){return n instanceof ne?n:n.oProj?n.oProj:ne(n)}function bt(n,e,t){n=Ls(n);var i=!1,r;return typeof e>"u"?(e=n,n=Ps,i=!0):(typeof e.x<"u"||Array.isArray(e))&&(t=e,e=n,n=Ps,i=!0),e=Ls(e),t?da(n,e,t):(r={forward:function(a,o){return da(n,e,a,o)},inverse:function(a,o){return da(e,n,a,o)}},i&&(r.oProj=e),r)}var Ns=6,gl="AJSAJS",yl="AFAFAF",Ci=65,At=73,Ut=79,sn=86,hn=90;const F_={forward:ml,inverse:G_,toPoint:xl};function ml(n,e){return e=e||5,j_(k_({lat:n[1],lon:n[0]}),e)}function G_(n){var e=lo(Ml(n.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat,e.lon,e.lat]:[e.left,e.bottom,e.right,e.top]}function xl(n){var e=lo(Ml(n.toUpperCase()));return e.lat&&e.lon?[e.lon,e.lat]:[(e.left+e.right)/2,(e.top+e.bottom)/2]}function va(n){return n*(Math.PI/180)}function bs(n){return 180*(n/Math.PI)}function k_(n){var e=n.lat,t=n.lon,i=6378137,r=.00669438,a=.9996,o,s,h,l,u,c,f,d=va(e),v=va(t),_,p;p=Math.floor((t+180)/6)+1,t===180&&(p=60),e>=56&&e<64&&t>=3&&t<12&&(p=32),e>=72&&e<84&&(t>=0&&t<9?p=31:t>=9&&t<21?p=33:t>=21&&t<33?p=35:t>=33&&t<42&&(p=37)),o=(p-1)*6-180+3,_=va(o),s=r/(1-r),h=i/Math.sqrt(1-r*Math.sin(d)*Math.sin(d)),l=Math.tan(d)*Math.tan(d),u=s*Math.cos(d)*Math.cos(d),c=Math.cos(d)*(v-_),f=i*((1-r/4-3*r*r/64-5*r*r*r/256)*d-(3*r/8+3*r*r/32+45*r*r*r/1024)*Math.sin(2*d)+(15*r*r/256+45*r*r*r/1024)*Math.sin(4*d)-35*r*r*r/3072*Math.sin(6*d));var g=a*h*(c+(1-l+u)*c*c*c/6+(5-18*l+l*l+72*u-58*s)*c*c*c*c*c/120)+5e5,y=a*(f+h*Math.tan(d)*(c*c/2+(5-l+9*u+4*u*u)*c*c*c*c/24+(61-58*l+l*l+600*u-330*s)*c*c*c*c*c*c/720));return e<0&&(y+=1e7),{northing:Math.round(y),easting:Math.round(g),zoneNumber:p,zoneLetter:z_(e)}}function lo(n){var e=n.northing,t=n.easting,i=n.zoneLetter,r=n.zoneNumber;if(r<0||r>60)return null;var a=.9996,o=6378137,s=.00669438,h,l=(1-Math.sqrt(1-s))/(1+Math.sqrt(1-s)),u,c,f,d,v,_,p,g,y,m=t-5e5,x=e;i<"N"&&(x-=1e7),p=(r-1)*6-180+3,h=s/(1-s),_=x/a,g=_/(o*(1-s/4-3*s*s/64-5*s*s*s/256)),y=g+(3*l/2-27*l*l*l/32)*Math.sin(2*g)+(21*l*l/16-55*l*l*l*l/32)*Math.sin(4*g)+151*l*l*l/96*Math.sin(6*g),u=o/Math.sqrt(1-s*Math.sin(y)*Math.sin(y)),c=Math.tan(y)*Math.tan(y),f=h*Math.cos(y)*Math.cos(y),d=o*(1-s)/Math.pow(1-s*Math.sin(y)*Math.sin(y),1.5),v=m/(u*a);var E=y-u*Math.tan(y)/d*(v*v/2-(5+3*c+10*f-4*f*f-9*h)*v*v*v*v/24+(61+90*c+298*f+45*c*c-252*h-3*f*f)*v*v*v*v*v*v/720);E=bs(E);var M=(v-(1+2*c+f)*v*v*v/6+(5-2*f+28*c-3*f*f+8*h+24*c*c)*v*v*v*v*v/120)/Math.cos(y);M=p+bs(M);var C;if(n.accuracy){var T=lo({northing:n.northing+n.accuracy,easting:n.easting+n.accuracy,zoneLetter:n.zoneLetter,zoneNumber:n.zoneNumber});C={top:T.lat,right:T.lon,bottom:E,left:M}}else C={lat:E,lon:M};return C}function z_(n){var e="Z";return 84>=n&&n>=72?e="X":72>n&&n>=64?e="W":64>n&&n>=56?e="V":56>n&&n>=48?e="U":48>n&&n>=40?e="T":40>n&&n>=32?e="S":32>n&&n>=24?e="R":24>n&&n>=16?e="Q":16>n&&n>=8?e="P":8>n&&n>=0?e="N":0>n&&n>=-8?e="M":-8>n&&n>=-16?e="L":-16>n&&n>=-24?e="K":-24>n&&n>=-32?e="J":-32>n&&n>=-40?e="H":-40>n&&n>=-48?e="G":-48>n&&n>=-56?e="F":-56>n&&n>=-64?e="E":-64>n&&n>=-72?e="D":-72>n&&n>=-80&&(e="C"),e}function j_(n,e){var t="00000"+n.easting,i="00000"+n.northing;return n.zoneNumber+n.zoneLetter+U_(n.easting,n.northing,n.zoneNumber)+t.substr(t.length-5,e)+i.substr(i.length-5,e)}function U_(n,e,t){var i=El(t),r=Math.floor(n/1e5),a=Math.floor(e/1e5)%20;return B_(r,a,i)}function El(n){var e=n%Ns;return e===0&&(e=Ns),e}function B_(n,e,t){var i=t-1,r=gl.charCodeAt(i),a=yl.charCodeAt(i),o=r+n-1,s=a+e,h=!1;o>hn&&(o=o-hn+Ci-1,h=!0),(o===At||r<At&&o>At||(o>At||r<At)&&h)&&o++,(o===Ut||r<Ut&&o>Ut||(o>Ut||r<Ut)&&h)&&(o++,o===At&&o++),o>hn&&(o=o-hn+Ci-1),s>sn?(s=s-sn+Ci-1,h=!0):h=!1,(s===At||a<At&&s>At||(s>At||a<At)&&h)&&s++,(s===Ut||a<Ut&&s>Ut||(s>Ut||a<Ut)&&h)&&(s++,s===At&&s++),s>sn&&(s=s-sn+Ci-1);var l=String.fromCharCode(o)+String.fromCharCode(s);return l}function Ml(n){if(n&&n.length===0)throw"MGRSPoint coverting from nothing";for(var e=n.length,t=null,i="",r,a=0;!/[A-Z]/.test(r=n.charAt(a));){if(a>=2)throw"MGRSPoint bad conversion from: "+n;i+=r,a++}var o=parseInt(i,10);if(a===0||a+3>e)throw"MGRSPoint bad conversion from: "+n;var s=n.charAt(a++);if(s<="A"||s==="B"||s==="Y"||s>="Z"||s==="I"||s==="O")throw"MGRSPoint zone letter "+s+" not handled: "+n;t=n.substring(a,a+=2);for(var h=El(o),l=W_(t.charAt(0),h),u=X_(t.charAt(1),h);u<Y_(s);)u+=2e6;var c=e-a;if(c%2!==0)throw`MGRSPoint has to have an even number 
of digits after the zone letter and two 100km letters - front 
half for easting meters, second half for 
northing meters`+n;var f=c/2,d=0,v=0,_,p,g,y,m;return f>0&&(_=1e5/Math.pow(10,f),p=n.substring(a,a+f),d=parseFloat(p)*_,g=n.substring(a+f),v=parseFloat(g)*_),y=d+l,m=v+u,{easting:y,northing:m,zoneLetter:s,zoneNumber:o,accuracy:_}}function W_(n,e){for(var t=gl.charCodeAt(e-1),i=1e5,r=!1;t!==n.charCodeAt(0);){if(t++,t===At&&t++,t===Ut&&t++,t>hn){if(r)throw"Bad character: "+n;t=Ci,r=!0}i+=1e5}return i}function X_(n,e){if(n>"V")throw"MGRSPoint given invalid Northing "+n;for(var t=yl.charCodeAt(e-1),i=0,r=!1;t!==n.charCodeAt(0);){if(t++,t===At&&t++,t===Ut&&t++,t>sn){if(r)throw"Bad character: "+n;t=Ci,r=!0}i+=1e5}return i}function Y_(n){var e;switch(n){case"C":e=11e5;break;case"D":e=2e6;break;case"E":e=28e5;break;case"F":e=37e5;break;case"G":e=46e5;break;case"H":e=55e5;break;case"J":e=64e5;break;case"K":e=73e5;break;case"L":e=82e5;break;case"M":e=91e5;break;case"N":e=0;break;case"P":e=8e5;break;case"Q":e=17e5;break;case"R":e=26e5;break;case"S":e=35e5;break;case"T":e=44e5;break;case"U":e=53e5;break;case"V":e=62e5;break;case"W":e=7e6;break;case"X":e=79e5;break;default:e=-1}if(e>=0)return e;throw"Invalid zone letter: "+n}function Gi(n,e,t){if(!(this instanceof Gi))return new Gi(n,e,t);if(Array.isArray(n))this.x=n[0],this.y=n[1],this.z=n[2]||0;else if(typeof n=="object")this.x=n.x,this.y=n.y,this.z=n.z||0;else if(typeof n=="string"&&typeof e>"u"){var i=n.split(",");this.x=parseFloat(i[0],10),this.y=parseFloat(i[1],10),this.z=parseFloat(i[2],10)||0}else this.x=n,this.y=e,this.z=t||0;console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}Gi.fromMGRS=function(n){return new Gi(xl(n))};Gi.prototype.toMGRS=function(n){return ml([this.x,this.y],n)};var V_=1,q_=.25,Ds=.046875,Fs=.01953125,Gs=.01068115234375,K_=.75,$_=.46875,Z_=.013020833333333334,H_=.007120768229166667,J_=.3645833333333333,Q_=.005696614583333333,tp=.3076171875;function uo(n){var e=[];e[0]=V_-n*(q_+n*(Ds+n*(Fs+n*Gs))),e[1]=n*(K_-n*(Ds+n*(Fs+n*Gs)));var t=n*n;return e[2]=t*($_-n*(Z_+n*H_)),t*=n,e[3]=t*(J_-n*Q_),e[4]=t*n*tp,e}function Wi(n,e,t,i){return t*=e,e*=e,i[0]*n-t*(i[1]+e*(i[2]+e*(i[3]+e*i[4])))}var ep=20;function fo(n,e,t){for(var i=1/(1-e),r=n,a=ep;a;--a){var o=Math.sin(r),s=1-e*o*o;if(s=(Wi(r,o,Math.cos(r),t)-n)*(s*Math.sqrt(s))*i,r-=s,Math.abs(s)<S)return r}return r}function ip(){this.x0=this.x0!==void 0?this.x0:0,this.y0=this.y0!==void 0?this.y0:0,this.long0=this.long0!==void 0?this.long0:0,this.lat0=this.lat0!==void 0?this.lat0:0,this.es&&(this.en=uo(this.es),this.ml0=Wi(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))}function np(n){var e=n.x,t=n.y,i=O(e-this.long0),r,a,o,s=Math.sin(t),h=Math.cos(t);if(this.es){var u=h*i,c=Math.pow(u,2),f=this.ep2*Math.pow(h,2),d=Math.pow(f,2),v=Math.abs(h)>S?Math.tan(t):0,_=Math.pow(v,2),p=Math.pow(_,2);r=1-this.es*Math.pow(s,2),u=u/Math.sqrt(r);var g=Wi(t,s,h,this.en);a=this.a*(this.k0*u*(1+c/6*(1-_+f+c/20*(5-18*_+p+14*f-58*_*f+c/42*(61+179*p-p*_-479*_)))))+this.x0,o=this.a*(this.k0*(g-this.ml0+s*i*u/2*(1+c/12*(5-_+9*f+4*d+c/30*(61+p-58*_+270*f-330*_*f+c/56*(1385+543*p-p*_-3111*_))))))+this.y0}else{var l=h*Math.sin(i);if(Math.abs(Math.abs(l)-1)<S)return 93;if(a=.5*this.a*this.k0*Math.log((1+l)/(1-l))+this.x0,o=h*Math.cos(i)/Math.sqrt(1-Math.pow(l,2)),l=Math.abs(o),l>=1){if(l-1>S)return 93;o=0}else o=Math.acos(o);t<0&&(o=-o),o=this.a*this.k0*(o-this.lat0)+this.y0}return n.x=a,n.y=o,n}function rp(n){var e,t,i,r,a=(n.x-this.x0)*(1/this.a),o=(n.y-this.y0)*(1/this.a);if(this.es)if(e=this.ml0+o/this.k0,t=fo(e,this.es,this.en),Math.abs(t)<R){var c=Math.sin(t),f=Math.cos(t),d=Math.abs(f)>S?Math.tan(t):0,v=this.ep2*Math.pow(f,2),_=Math.pow(v,2),p=Math.pow(d,2),g=Math.pow(p,2);e=1-this.es*Math.pow(c,2);var y=a*Math.sqrt(e)/this.k0,m=Math.pow(y,2);e=e*d,i=t-e*m/(1-this.es)*.5*(1-m/12*(5+3*p-9*v*p+v-4*_-m/30*(61+90*p-252*v*p+45*g+46*v-m/56*(1385+3633*p+4095*g+1574*g*p)))),r=O(this.long0+y*(1-m/6*(1+2*p+v-m/20*(5+28*p+24*g+8*v*p+6*v-m/42*(61+662*p+1320*g+720*g*p))))/f)}else i=R*Gn(o),r=0;else{var s=Math.exp(a/this.k0),h=.5*(s-1/s),l=this.lat0+o/this.k0,u=Math.cos(l);e=Math.sqrt((1-Math.pow(u,2))/(1+Math.pow(h,2))),i=Math.asin(e),o<0&&(i=-i),h===0&&u===0?r=0:r=O(Math.atan2(h,u)+this.long0)}return n.x=r,n.y=i,n}var ap=["Fast_Transverse_Mercator","Fast Transverse Mercator"];const dr={init:ip,forward:np,inverse:rp,names:ap};function Tl(n){var e=Math.exp(n);return e=(e-1/e)/2,e}function Lt(n,e){n=Math.abs(n),e=Math.abs(e);var t=Math.max(n,e),i=Math.min(n,e)/(t||1);return t*Math.sqrt(1+Math.pow(i,2))}function op(n){var e=1+n,t=e-1;return t===0?n:n*Math.log(e)/t}function sp(n){var e=Math.abs(n);return e=op(e*(1+e/(Lt(1,e)+1))),n<0?-e:e}function co(n,e){for(var t=2*Math.cos(2*e),i=n.length-1,r=n[i],a=0,o;--i>=0;)o=-a+t*r+n[i],a=r,r=o;return e+o*Math.sin(2*e)}function hp(n,e){for(var t=2*Math.cos(e),i=n.length-1,r=n[i],a=0,o;--i>=0;)o=-a+t*r+n[i],a=r,r=o;return Math.sin(e)*o}function lp(n){var e=Math.exp(n);return e=(e+1/e)/2,e}function Cl(n,e,t){for(var i=Math.sin(e),r=Math.cos(e),a=Tl(t),o=lp(t),s=2*r*o,h=-2*i*a,l=n.length-1,u=n[l],c=0,f=0,d=0,v,_;--l>=0;)v=f,_=c,f=u,c=d,u=-v+s*f-h*c+n[l],d=-_+h*f+s*c;return s=i*o,h=r*a,[s*u-h*d,s*d+h*u]}function up(){if(!this.approx&&(isNaN(this.es)||this.es<=0))throw new Error('Incorrect elliptical usage. Try using the +approx option in the proj string, or PROJECTION["Fast_Transverse_Mercator"] in the WKT.');this.approx&&(dr.init.apply(this),this.forward=dr.forward,this.inverse=dr.inverse),this.x0=this.x0!==void 0?this.x0:0,this.y0=this.y0!==void 0?this.y0:0,this.long0=this.long0!==void 0?this.long0:0,this.lat0=this.lat0!==void 0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var n=this.es/(1+Math.sqrt(1-this.es)),e=n/(2-n),t=e;this.cgb[0]=e*(2+e*(-2/3+e*(-2+e*(116/45+e*(26/45+e*(-2854/675)))))),this.cbg[0]=e*(-2+e*(2/3+e*(4/3+e*(-82/45+e*(32/45+e*(4642/4725)))))),t=t*e,this.cgb[1]=t*(7/3+e*(-8/5+e*(-227/45+e*(2704/315+e*(2323/945))))),this.cbg[1]=t*(5/3+e*(-16/15+e*(-13/9+e*(904/315+e*(-1522/945))))),t=t*e,this.cgb[2]=t*(56/15+e*(-136/35+e*(-1262/105+e*(73814/2835)))),this.cbg[2]=t*(-26/15+e*(34/21+e*(8/5+e*(-12686/2835)))),t=t*e,this.cgb[3]=t*(4279/630+e*(-332/35+e*(-399572/14175))),this.cbg[3]=t*(1237/630+e*(-12/5+e*(-24832/14175))),t=t*e,this.cgb[4]=t*(4174/315+e*(-144838/6237)),this.cbg[4]=t*(-734/315+e*(109598/31185)),t=t*e,this.cgb[5]=t*(601676/22275),this.cbg[5]=t*(444337/155925),t=Math.pow(e,2),this.Qn=this.k0/(1+e)*(1+t*(1/4+t*(1/64+t/256))),this.utg[0]=e*(-.5+e*(2/3+e*(-37/96+e*(1/360+e*(81/512+e*(-96199/604800)))))),this.gtu[0]=e*(.5+e*(-2/3+e*(5/16+e*(41/180+e*(-127/288+e*(7891/37800)))))),this.utg[1]=t*(-1/48+e*(-1/15+e*(437/1440+e*(-46/105+e*(1118711/3870720))))),this.gtu[1]=t*(13/48+e*(-3/5+e*(557/1440+e*(281/630+e*(-1983433/1935360))))),t=t*e,this.utg[2]=t*(-17/480+e*(37/840+e*(209/4480+e*(-5569/90720)))),this.gtu[2]=t*(61/240+e*(-103/140+e*(15061/26880+e*(167603/181440)))),t=t*e,this.utg[3]=t*(-4397/161280+e*(11/504+e*(830251/7257600))),this.gtu[3]=t*(49561/161280+e*(-179/168+e*(6601661/7257600))),t=t*e,this.utg[4]=t*(-4583/161280+e*(108847/3991680)),this.gtu[4]=t*(34729/80640+e*(-3418889/1995840)),t=t*e,this.utg[5]=t*(-20648693/638668800),this.gtu[5]=t*(212378941/319334400);var i=co(this.cbg,this.lat0);this.Zb=-this.Qn*(i+hp(this.gtu,2*i))}function fp(n){var e=O(n.x-this.long0),t=n.y;t=co(this.cbg,t);var i=Math.sin(t),r=Math.cos(t),a=Math.sin(e),o=Math.cos(e);t=Math.atan2(i,o*r),e=Math.atan2(a*r,Lt(i,r*o)),e=sp(Math.tan(e));var s=Cl(this.gtu,2*t,2*e);t=t+s[0],e=e+s[1];var h,l;return Math.abs(e)<=2.623395162778?(h=this.a*(this.Qn*e)+this.x0,l=this.a*(this.Qn*t+this.Zb)+this.y0):(h=1/0,l=1/0),n.x=h,n.y=l,n}function cp(n){var e=(n.x-this.x0)*(1/this.a),t=(n.y-this.y0)*(1/this.a);t=(t-this.Zb)/this.Qn,e=e/this.Qn;var i,r;if(Math.abs(e)<=2.623395162778){var a=Cl(this.utg,2*t,2*e);t=t+a[0],e=e+a[1],e=Math.atan(Tl(e));var o=Math.sin(t),s=Math.cos(t),h=Math.sin(e),l=Math.cos(e);t=Math.atan2(o*l,Lt(h,l*s)),e=Math.atan2(h,l*s),i=O(e+this.long0),r=co(this.cgb,t)}else i=1/0,r=1/0;return n.x=i,n.y=r,n}var dp=["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc","Transverse_Mercator","Transverse Mercator","Gauss Kruger","Gauss_Kruger","tmerc"];const vr={init:up,forward:fp,inverse:cp,names:dp};function vp(n,e){if(n===void 0){if(n=Math.floor((O(e)+Math.PI)*30/Math.PI)+1,n<0)return 0;if(n>60)return 60}return n}var _p="etmerc";function pp(){var n=vp(this.zone,this.long0);if(n===void 0)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(n)-183)*gt,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,vr.init.apply(this),this.forward=vr.forward,this.inverse=vr.inverse}var gp=["Universal Transverse Mercator System","utm"];const yp={init:pp,names:gp,dependsOn:_p};function vo(n,e){return Math.pow((1-n)/(1+n),e)}var mp=20;function xp(){var n=Math.sin(this.lat0),e=Math.cos(this.lat0);e*=e,this.rc=Math.sqrt(1-this.es)/(1-this.es*n*n),this.C=Math.sqrt(1+this.es*e*e/(1-this.es)),this.phic0=Math.asin(n/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+J)/(Math.pow(Math.tan(.5*this.lat0+J),this.C)*vo(this.e*n,this.ratexp))}function Ep(n){var e=n.x,t=n.y;return n.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*t+J),this.C)*vo(this.e*Math.sin(t),this.ratexp))-R,n.x=this.C*e,n}function Mp(n){for(var e=1e-14,t=n.x/this.C,i=n.y,r=Math.pow(Math.tan(.5*i+J)/this.K,1/this.C),a=mp;a>0&&(i=2*Math.atan(r*vo(this.e*Math.sin(n.y),-.5*this.e))-R,!(Math.abs(i-n.y)<e));--a)n.y=i;return a?(n.x=t,n.y=i,n):null}const _o={init:xp,forward:Ep,inverse:Mp};function Tp(){_o.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))}function Cp(n){var e,t,i,r;return n.x=O(n.x-this.long0),_o.forward.apply(this,[n]),e=Math.sin(n.y),t=Math.cos(n.y),i=Math.cos(n.x),r=this.k0*this.R2/(1+this.sinc0*e+this.cosc0*t*i),n.x=r*t*Math.sin(n.x),n.y=r*(this.cosc0*e-this.sinc0*t*i),n.x=this.a*n.x+this.x0,n.y=this.a*n.y+this.y0,n}function Rp(n){var e,t,i,r,a;if(n.x=(n.x-this.x0)/this.a,n.y=(n.y-this.y0)/this.a,n.x/=this.k0,n.y/=this.k0,a=Lt(n.x,n.y)){var o=2*Math.atan2(a,this.R2);e=Math.sin(o),t=Math.cos(o),r=Math.asin(t*this.sinc0+n.y*e*this.cosc0/a),i=Math.atan2(n.x*e,a*this.cosc0*t-n.y*this.sinc0*e)}else r=this.phic0,i=0;return n.x=i,n.y=r,_o.inverse.apply(this,[n]),n.x=O(n.x+this.long0),n}var wp=["Stereographic_North_Pole","Oblique_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"];const Ip={init:Tp,forward:Cp,inverse:Rp,names:wp};function Sp(n,e,t){return e*=t,Math.tan(.5*(R+n))*Math.pow((1-e)/(1+e),.5*t)}function Op(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?this.k0===1&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=S&&(this.k0=.5*(1+Gn(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=S&&(this.lat0>0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),this.k0===1&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=S&&Math.abs(Math.cos(this.lat_ts))>S&&(this.k0=.5*this.cons*oe(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/Kt(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=oe(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-R,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))}function Ap(n){var e=n.x,t=n.y,i=Math.sin(t),r=Math.cos(t),a,o,s,h,l,u,c=O(e-this.long0);return Math.abs(Math.abs(e-this.long0)-Math.PI)<=S&&Math.abs(t+this.lat0)<=S?(n.x=NaN,n.y=NaN,n):this.sphere?(a=2*this.k0/(1+this.sinlat0*i+this.coslat0*r*Math.cos(c)),n.x=this.a*a*r*Math.sin(c)+this.x0,n.y=this.a*a*(this.coslat0*i-this.sinlat0*r*Math.cos(c))+this.y0,n):(o=2*Math.atan(this.ssfn_(t,i,this.e))-R,h=Math.cos(o),s=Math.sin(o),Math.abs(this.coslat0)<=S?(l=Kt(this.e,t*this.con,this.con*i),u=2*this.a*this.k0*l/this.cons,n.x=this.x0+u*Math.sin(e-this.long0),n.y=this.y0-this.con*u*Math.cos(e-this.long0),n):(Math.abs(this.sinlat0)<S?(a=2*this.a*this.k0/(1+h*Math.cos(c)),n.y=a*s):(a=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*s+this.cosX0*h*Math.cos(c))),n.y=a*(this.cosX0*s-this.sinX0*h*Math.cos(c))+this.y0),n.x=a*h*Math.sin(c)+this.x0,n))}function Pp(n){n.x-=this.x0,n.y-=this.y0;var e,t,i,r,a,o=Math.sqrt(n.x*n.x+n.y*n.y);if(this.sphere){var s=2*Math.atan(o/(2*this.a*this.k0));return e=this.long0,t=this.lat0,o<=S?(n.x=e,n.y=t,n):(t=Math.asin(Math.cos(s)*this.sinlat0+n.y*Math.sin(s)*this.coslat0/o),Math.abs(this.coslat0)<S?this.lat0>0?e=O(this.long0+Math.atan2(n.x,-1*n.y)):e=O(this.long0+Math.atan2(n.x,n.y)):e=O(this.long0+Math.atan2(n.x*Math.sin(s),o*this.coslat0*Math.cos(s)-n.y*this.sinlat0*Math.sin(s))),n.x=e,n.y=t,n)}else if(Math.abs(this.coslat0)<=S){if(o<=S)return t=this.lat0,e=this.long0,n.x=e,n.y=t,n;n.x*=this.con,n.y*=this.con,i=o*this.cons/(2*this.a*this.k0),t=this.con*In(this.e,i),e=this.con*O(this.con*this.long0+Math.atan2(n.x,-1*n.y))}else r=2*Math.atan(o*this.cosX0/(2*this.a*this.k0*this.ms1)),e=this.long0,o<=S?a=this.X0:(a=Math.asin(Math.cos(r)*this.sinX0+n.y*Math.sin(r)*this.cosX0/o),e=O(this.long0+Math.atan2(n.x*Math.sin(r),o*this.cosX0*Math.cos(r)-n.y*this.sinX0*Math.sin(r)))),t=-1*In(this.e,Math.tan(.5*(R+a)));return n.x=e,n.y=t,n}var Lp=["stere","Stereographic_South_Pole","Polar Stereographic (variant B)","Polar_Stereographic"];const Np={init:Op,forward:Ap,inverse:Pp,names:Lp,ssfn_:Sp};function bp(){var n=this.lat0;this.lambda0=this.long0;var e=Math.sin(n),t=this.a,i=this.rf,r=1/i,a=2*r-Math.pow(r,2),o=this.e=Math.sqrt(a);this.R=this.k0*t*Math.sqrt(1-a)/(1-a*Math.pow(e,2)),this.alpha=Math.sqrt(1+a/(1-a)*Math.pow(Math.cos(n),4)),this.b0=Math.asin(e/this.alpha);var s=Math.log(Math.tan(Math.PI/4+this.b0/2)),h=Math.log(Math.tan(Math.PI/4+n/2)),l=Math.log((1+o*e)/(1-o*e));this.K=s-this.alpha*h+this.alpha*o/2*l}function Dp(n){var e=Math.log(Math.tan(Math.PI/4-n.y/2)),t=this.e/2*Math.log((1+this.e*Math.sin(n.y))/(1-this.e*Math.sin(n.y))),i=-this.alpha*(e+t)+this.K,r=2*(Math.atan(Math.exp(i))-Math.PI/4),a=this.alpha*(n.x-this.lambda0),o=Math.atan(Math.sin(a)/(Math.sin(this.b0)*Math.tan(r)+Math.cos(this.b0)*Math.cos(a))),s=Math.asin(Math.cos(this.b0)*Math.sin(r)-Math.sin(this.b0)*Math.cos(r)*Math.cos(a));return n.y=this.R/2*Math.log((1+Math.sin(s))/(1-Math.sin(s)))+this.y0,n.x=this.R*o+this.x0,n}function Fp(n){for(var e=n.x-this.x0,t=n.y-this.y0,i=e/this.R,r=2*(Math.atan(Math.exp(t/this.R))-Math.PI/4),a=Math.asin(Math.cos(this.b0)*Math.sin(r)+Math.sin(this.b0)*Math.cos(r)*Math.cos(i)),o=Math.atan(Math.sin(i)/(Math.cos(this.b0)*Math.cos(i)-Math.sin(this.b0)*Math.tan(r))),s=this.lambda0+o/this.alpha,h=0,l=a,u=-1e3,c=0;Math.abs(l-u)>1e-7;){if(++c>20)return;h=1/this.alpha*(Math.log(Math.tan(Math.PI/4+a/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(l))/2)),u=l,l=2*Math.atan(Math.exp(h))-Math.PI/2}return n.x=s,n.y=l,n}var Gp=["somerc"];const kp={init:bp,forward:Dp,inverse:Fp,names:Gp};var yi=1e-7;function zp(n){var e=["Hotine_Oblique_Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin"],t=typeof n.PROJECTION=="object"?Object.keys(n.PROJECTION)[0]:n.PROJECTION;return"no_uoff"in n||"no_off"in n||e.indexOf(t)!==-1}function jp(){var n,e,t,i,r,a,o,s,h,l,u=0,c,f=0,d=0,v=0,_=0,p=0,g=0;this.no_off=zp(this),this.no_rot="no_rot"in this;var y=!1;"alpha"in this&&(y=!0);var m=!1;if("rectified_grid_angle"in this&&(m=!0),y&&(g=this.alpha),m&&(u=this.rectified_grid_angle*gt),y||m)f=this.longc;else if(d=this.long1,_=this.lat1,v=this.long2,p=this.lat2,Math.abs(_-p)<=yi||(n=Math.abs(_))<=yi||Math.abs(n-R)<=yi||Math.abs(Math.abs(this.lat0)-R)<=yi||Math.abs(Math.abs(p)-R)<=yi)throw new Error;var x=1-this.es;e=Math.sqrt(x),Math.abs(this.lat0)>S?(s=Math.sin(this.lat0),t=Math.cos(this.lat0),n=1-this.es*s*s,this.B=t*t,this.B=Math.sqrt(1+this.es*this.B*this.B/x),this.A=this.B*this.k0*e/n,i=this.B*e/(t*Math.sqrt(n)),r=i*i-1,r<=0?r=0:(r=Math.sqrt(r),this.lat0<0&&(r=-r)),this.E=r+=i,this.E*=Math.pow(Kt(this.e,this.lat0,s),this.B)):(this.B=1/e,this.A=this.k0,this.E=i=r=1),y||m?(y?(c=Math.asin(Math.sin(g)/i),m||(u=g)):(c=u,g=Math.asin(i*Math.sin(c))),this.lam0=f-Math.asin(.5*(r-1/r)*Math.tan(c))/this.B):(a=Math.pow(Kt(this.e,_,Math.sin(_)),this.B),o=Math.pow(Kt(this.e,p,Math.sin(p)),this.B),r=this.E/a,h=(o-a)/(o+a),l=this.E*this.E,l=(l-o*a)/(l+o*a),n=d-v,n<-Math.pi?v-=Rn:n>Math.pi&&(v+=Rn),this.lam0=O(.5*(d+v)-Math.atan(l*Math.tan(.5*this.B*(d-v))/h)/this.B),c=Math.atan(2*Math.sin(this.B*O(d-this.lam0))/(r-1/r)),u=g=Math.asin(i*Math.sin(c))),this.singam=Math.sin(c),this.cosgam=Math.cos(c),this.sinrot=Math.sin(u),this.cosrot=Math.cos(u),this.rB=1/this.B,this.ArB=this.A*this.rB,this.BrA=1/this.ArB,this.A*this.B,this.no_off?this.u_0=0:(this.u_0=Math.abs(this.ArB*Math.atan(Math.sqrt(i*i-1)/Math.cos(g))),this.lat0<0&&(this.u_0=-this.u_0)),r=.5*c,this.v_pole_n=this.ArB*Math.log(Math.tan(J-r)),this.v_pole_s=this.ArB*Math.log(Math.tan(J+r))}function Up(n){var e={},t,i,r,a,o,s,h,l;if(n.x=n.x-this.lam0,Math.abs(Math.abs(n.y)-R)>S){if(o=this.E/Math.pow(Kt(this.e,n.y,Math.sin(n.y)),this.B),s=1/o,t=.5*(o-s),i=.5*(o+s),a=Math.sin(this.B*n.x),r=(t*this.singam-a*this.cosgam)/i,Math.abs(Math.abs(r)-1)<S)throw new Error;l=.5*this.ArB*Math.log((1-r)/(1+r)),s=Math.cos(this.B*n.x),Math.abs(s)<yi?h=this.A*n.x:h=this.ArB*Math.atan2(t*this.cosgam+a*this.singam,s)}else l=n.y>0?this.v_pole_n:this.v_pole_s,h=this.ArB*n.y;return this.no_rot?(e.x=h,e.y=l):(h-=this.u_0,e.x=l*this.cosrot+h*this.sinrot,e.y=h*this.cosrot-l*this.sinrot),e.x=this.a*e.x+this.x0,e.y=this.a*e.y+this.y0,e}function Bp(n){var e,t,i,r,a,o,s,h={};if(n.x=(n.x-this.x0)*(1/this.a),n.y=(n.y-this.y0)*(1/this.a),this.no_rot?(t=n.y,e=n.x):(t=n.x*this.cosrot-n.y*this.sinrot,e=n.y*this.cosrot+n.x*this.sinrot+this.u_0),i=Math.exp(-this.BrA*t),r=.5*(i-1/i),a=.5*(i+1/i),o=Math.sin(this.BrA*e),s=(o*this.cosgam+r*this.singam)/a,Math.abs(Math.abs(s)-1)<S)h.x=0,h.y=s<0?-R:R;else{if(h.y=this.E/Math.sqrt((1+s)/(1-s)),h.y=In(this.e,Math.pow(h.y,1/this.B)),h.y===1/0)throw new Error;h.x=-this.rB*Math.atan2(r*this.cosgam-o*this.singam,Math.cos(this.BrA*e))}return h.x+=this.lam0,h}var Wp=["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Two_Point_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","Oblique_Mercator","omerc"];const Xp={init:jp,forward:Up,inverse:Bp,names:Wp};function Yp(){if(this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,!(Math.abs(this.lat1+this.lat2)<S)){var n=this.b/this.a;this.e=Math.sqrt(1-n*n);var e=Math.sin(this.lat1),t=Math.cos(this.lat1),i=oe(this.e,e,t),r=Kt(this.e,this.lat1,e),a=Math.sin(this.lat2),o=Math.cos(this.lat2),s=oe(this.e,a,o),h=Kt(this.e,this.lat2,a),l=Kt(this.e,this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>S?this.ns=Math.log(i/s)/Math.log(r/h):this.ns=e,isNaN(this.ns)&&(this.ns=e),this.f0=i/(this.ns*Math.pow(r,this.ns)),this.rh=this.a*this.f0*Math.pow(l,this.ns),this.title||(this.title="Lambert Conformal Conic")}}function Vp(n){var e=n.x,t=n.y;Math.abs(2*Math.abs(t)-Math.PI)<=S&&(t=Gn(t)*(R-2*S));var i=Math.abs(Math.abs(t)-R),r,a;if(i>S)r=Kt(this.e,t,Math.sin(t)),a=this.a*this.f0*Math.pow(r,this.ns);else{if(i=t*this.ns,i<=0)return null;a=0}var o=this.ns*O(e-this.long0);return n.x=this.k0*(a*Math.sin(o))+this.x0,n.y=this.k0*(this.rh-a*Math.cos(o))+this.y0,n}function qp(n){var e,t,i,r,a,o=(n.x-this.x0)/this.k0,s=this.rh-(n.y-this.y0)/this.k0;this.ns>0?(e=Math.sqrt(o*o+s*s),t=1):(e=-Math.sqrt(o*o+s*s),t=-1);var h=0;if(e!==0&&(h=Math.atan2(t*o,t*s)),e!==0||this.ns>0){if(t=1/this.ns,i=Math.pow(e/(this.a*this.f0),t),r=In(this.e,i),r===-9999)return null}else r=-R;return a=O(h/this.ns+this.long0),n.x=a,n.y=r,n}var Kp=["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_1SP","Lambert_Conformal_Conic_2SP","lcc","Lambert Conic Conformal (1SP)","Lambert Conic Conformal (2SP)"];const $p={init:Yp,forward:Vp,inverse:qp,names:Kp};function Zp(){this.a=6377397155e-3,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.7417649320975901-.308341501185665),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq}function Hp(n){var e,t,i,r,a,o,s,h=n.x,l=n.y,u=O(h-this.long0);return e=Math.pow((1+this.e*Math.sin(l))/(1-this.e*Math.sin(l)),this.alfa*this.e/2),t=2*(Math.atan(this.k*Math.pow(Math.tan(l/2+this.s45),this.alfa)/e)-this.s45),i=-u*this.alfa,r=Math.asin(Math.cos(this.ad)*Math.sin(t)+Math.sin(this.ad)*Math.cos(t)*Math.cos(i)),a=Math.asin(Math.cos(t)*Math.sin(i)/Math.cos(r)),o=this.n*a,s=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(r/2+this.s45),this.n),n.y=s*Math.cos(o)/1,n.x=s*Math.sin(o)/1,this.czech||(n.y*=-1,n.x*=-1),n}function Jp(n){var e,t,i,r,a,o,s,h,l=n.x;n.x=n.y,n.y=l,this.czech||(n.y*=-1,n.x*=-1),o=Math.sqrt(n.x*n.x+n.y*n.y),a=Math.atan2(n.y,n.x),r=a/Math.sin(this.s0),i=2*(Math.atan(Math.pow(this.ro0/o,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),e=Math.asin(Math.cos(this.ad)*Math.sin(i)-Math.sin(this.ad)*Math.cos(i)*Math.cos(r)),t=Math.asin(Math.cos(i)*Math.sin(r)/Math.cos(e)),n.x=this.long0-t/this.alfa,s=e,h=0;var u=0;do n.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(e/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(s))/(1-this.e*Math.sin(s)),this.e/2))-this.s45),Math.abs(s-n.y)<1e-10&&(h=1),s=n.y,u+=1;while(h===0&&u<15);return u>=15?null:n}var Qp=["Krovak","krovak"];const tg={init:Zp,forward:Hp,inverse:Jp,names:Qp};function wt(n,e,t,i,r){return n*r-e*Math.sin(2*r)+t*Math.sin(4*r)-i*Math.sin(6*r)}function kn(n){return 1-.25*n*(1+n/16*(3+1.25*n))}function zn(n){return .375*n*(1+.25*n*(1+.46875*n))}function jn(n){return .05859375*n*n*(1+.75*n)}function Un(n){return n*n*n*(35/3072)}function ki(n,e,t){var i=e*t;return n/Math.sqrt(1-i*i)}function je(n){return Math.abs(n)<R?n:n-Gn(n)*Math.PI}function Ar(n,e,t,i,r){var a,o;a=n/e;for(var s=0;s<15;s++)if(o=(n-(e*a-t*Math.sin(2*a)+i*Math.sin(4*a)-r*Math.sin(6*a)))/(e-2*t*Math.cos(2*a)+4*i*Math.cos(4*a)-6*r*Math.cos(6*a)),a+=o,Math.abs(o)<=1e-10)return a;return NaN}function eg(){this.sphere||(this.e0=kn(this.es),this.e1=zn(this.es),this.e2=jn(this.es),this.e3=Un(this.es),this.ml0=this.a*wt(this.e0,this.e1,this.e2,this.e3,this.lat0))}function ig(n){var e,t,i=n.x,r=n.y;if(i=O(i-this.long0),this.sphere)e=this.a*Math.asin(Math.cos(r)*Math.sin(i)),t=this.a*(Math.atan2(Math.tan(r),Math.cos(i))-this.lat0);else{var a=Math.sin(r),o=Math.cos(r),s=ki(this.a,this.e,a),h=Math.tan(r)*Math.tan(r),l=i*Math.cos(r),u=l*l,c=this.es*o*o/(1-this.es),f=this.a*wt(this.e0,this.e1,this.e2,this.e3,r);e=s*l*(1-u*h*(1/6-(8-h+8*c)*u/120)),t=f-this.ml0+s*a/o*u*(.5+(5-h+6*c)*u/24)}return n.x=e+this.x0,n.y=t+this.y0,n}function ng(n){n.x-=this.x0,n.y-=this.y0;var e=n.x/this.a,t=n.y/this.a,i,r;if(this.sphere){var a=t+this.lat0;i=Math.asin(Math.sin(a)*Math.cos(e)),r=Math.atan2(Math.tan(e),Math.cos(a))}else{var o=this.ml0/this.a+t,s=Ar(o,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(s)-R)<=S)return n.x=this.long0,n.y=R,t<0&&(n.y*=-1),n;var h=ki(this.a,this.e,Math.sin(s)),l=h*h*h/this.a/this.a*(1-this.es),u=Math.pow(Math.tan(s),2),c=e*this.a/h,f=c*c;i=s-h*Math.tan(s)/l*c*c*(.5-(1+3*u)*c*c/24),r=c*(1-f*(u/3+(1+3*u)*u*f/15))/Math.cos(s)}return n.x=O(r+this.long0),n.y=je(i),n}var rg=["Cassini","Cassini_Soldner","cass"];const ag={init:eg,forward:ig,inverse:ng,names:rg};function Fe(n,e){var t;return n>1e-7?(t=n*e,(1-n*n)*(e/(1-t*t)-.5/n*Math.log((1-t)/(1+t)))):2*e}var og=1,sg=2,hg=3,lg=4;function ug(){var n=Math.abs(this.lat0);if(Math.abs(n-R)<S?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(n)<S?this.mode=this.EQUIT:this.mode=this.OBLIQ,this.es>0){var e;switch(this.qp=Fe(this.e,1),this.mmf=.5/(1-this.es),this.apa=mg(this.es),this.mode){case this.N_POLE:this.dd=1;break;case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),e=Math.sin(this.lat0),this.sinb1=Fe(this.e,e)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*e*e)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd;break}}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))}function fg(n){var e,t,i,r,a,o,s,h,l,u,c=n.x,f=n.y;if(c=O(c-this.long0),this.sphere){if(a=Math.sin(f),u=Math.cos(f),i=Math.cos(c),this.mode===this.OBLIQ||this.mode===this.EQUIT){if(t=this.mode===this.EQUIT?1+u*i:1+this.sinph0*a+this.cosph0*u*i,t<=S)return null;t=Math.sqrt(2/t),e=t*u*Math.sin(c),t*=this.mode===this.EQUIT?a:this.cosph0*a-this.sinph0*u*i}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(i=-i),Math.abs(f+this.lat0)<S)return null;t=J-f*.5,t=2*(this.mode===this.S_POLE?Math.cos(t):Math.sin(t)),e=t*Math.sin(c),t*=i}}else{switch(s=0,h=0,l=0,i=Math.cos(c),r=Math.sin(c),a=Math.sin(f),o=Fe(this.e,a),(this.mode===this.OBLIQ||this.mode===this.EQUIT)&&(s=o/this.qp,h=Math.sqrt(1-s*s)),this.mode){case this.OBLIQ:l=1+this.sinb1*s+this.cosb1*h*i;break;case this.EQUIT:l=1+h*i;break;case this.N_POLE:l=R+f,o=this.qp-o;break;case this.S_POLE:l=f-R,o=this.qp+o;break}if(Math.abs(l)<S)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:l=Math.sqrt(2/l),this.mode===this.OBLIQ?t=this.ymf*l*(this.cosb1*s-this.sinb1*h*i):t=(l=Math.sqrt(2/(1+h*i)))*s*this.ymf,e=this.xmf*l*h*r;break;case this.N_POLE:case this.S_POLE:o>=0?(e=(l=Math.sqrt(o))*r,t=i*(this.mode===this.S_POLE?l:-l)):e=t=0;break}}return n.x=this.a*e+this.x0,n.y=this.a*t+this.y0,n}function cg(n){n.x-=this.x0,n.y-=this.y0;var e=n.x/this.a,t=n.y/this.a,i,r,a,o,s,h,l;if(this.sphere){var u=0,c,f=0;if(c=Math.sqrt(e*e+t*t),r=c*.5,r>1)return null;switch(r=2*Math.asin(r),(this.mode===this.OBLIQ||this.mode===this.EQUIT)&&(f=Math.sin(r),u=Math.cos(r)),this.mode){case this.EQUIT:r=Math.abs(c)<=S?0:Math.asin(t*f/c),e*=f,t=u*c;break;case this.OBLIQ:r=Math.abs(c)<=S?this.lat0:Math.asin(u*this.sinph0+t*f*this.cosph0/c),e*=f*this.cosph0,t=(u-Math.sin(r)*this.sinph0)*c;break;case this.N_POLE:t=-t,r=R-r;break;case this.S_POLE:r-=R;break}i=t===0&&(this.mode===this.EQUIT||this.mode===this.OBLIQ)?0:Math.atan2(e,t)}else{if(l=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(e/=this.dd,t*=this.dd,h=Math.sqrt(e*e+t*t),h<S)return n.x=this.long0,n.y=this.lat0,n;o=2*Math.asin(.5*h/this.rq),a=Math.cos(o),e*=o=Math.sin(o),this.mode===this.OBLIQ?(l=a*this.sinb1+t*o*this.cosb1/h,s=this.qp*l,t=h*this.cosb1*a-t*this.sinb1*o):(l=t*o/h,s=this.qp*l,t=h*a)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(t=-t),s=e*e+t*t,!s)return n.x=this.long0,n.y=this.lat0,n;l=1-s/this.qp,this.mode===this.S_POLE&&(l=-l)}i=Math.atan2(e,t),r=xg(Math.asin(l),this.apa)}return n.x=O(this.long0+i),n.y=r,n}var dg=.3333333333333333,vg=.17222222222222222,_g=.10257936507936508,pg=.06388888888888888,gg=.0664021164021164,yg=.016415012942191543;function mg(n){var e,t=[];return t[0]=n*dg,e=n*n,t[0]+=e*vg,t[1]=e*pg,e*=n,t[0]+=e*_g,t[1]+=e*gg,t[2]=e*yg,t}function xg(n,e){var t=n+n;return n+e[0]*Math.sin(t)+e[1]*Math.sin(t+t)+e[2]*Math.sin(t+t+t)}var Eg=["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"];const Mg={init:ug,forward:fg,inverse:cg,names:Eg,S_POLE:og,N_POLE:sg,EQUIT:hg,OBLIQ:lg};function ze(n){return Math.abs(n)>1&&(n=n>1?1:-1),Math.asin(n)}function Tg(){Math.abs(this.lat1+this.lat2)<S||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=oe(this.e3,this.sin_po,this.cos_po),this.qs1=Fe(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=oe(this.e3,this.sin_po,this.cos_po),this.qs2=Fe(this.e3,this.sin_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=Fe(this.e3,this.sin_po),Math.abs(this.lat1-this.lat2)>S?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)}function Cg(n){var e=n.x,t=n.y;this.sin_phi=Math.sin(t),this.cos_phi=Math.cos(t);var i=Fe(this.e3,this.sin_phi),r=this.a*Math.sqrt(this.c-this.ns0*i)/this.ns0,a=this.ns0*O(e-this.long0),o=r*Math.sin(a)+this.x0,s=this.rh-r*Math.cos(a)+this.y0;return n.x=o,n.y=s,n}function Rg(n){var e,t,i,r,a,o;return n.x-=this.x0,n.y=this.rh-n.y+this.y0,this.ns0>=0?(e=Math.sqrt(n.x*n.x+n.y*n.y),i=1):(e=-Math.sqrt(n.x*n.x+n.y*n.y),i=-1),r=0,e!==0&&(r=Math.atan2(i*n.x,i*n.y)),i=e*this.ns0/this.a,this.sphere?o=Math.asin((this.c-i*i)/(2*this.ns0)):(t=(this.c-i*i)/this.ns0,o=this.phi1z(this.e3,t)),a=O(r/this.ns0+this.long0),n.x=a,n.y=o,n}function wg(n,e){var t,i,r,a,o,s=ze(.5*e);if(n<S)return s;for(var h=n*n,l=1;l<=25;l++)if(t=Math.sin(s),i=Math.cos(s),r=n*t,a=1-r*r,o=.5*a*a/i*(e/(1-h)-t/a+.5/n*Math.log((1-r)/(1+r))),s=s+o,Math.abs(o)<=1e-7)return s;return null}var Ig=["Albers_Conic_Equal_Area","Albers","aea"];const Sg={init:Tg,forward:Cg,inverse:Rg,names:Ig,phi1z:wg};function Og(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1}function Ag(n){var e,t,i,r,a,o,s,h,l=n.x,u=n.y;return i=O(l-this.long0),e=Math.sin(u),t=Math.cos(u),r=Math.cos(i),o=this.sin_p14*e+this.cos_p14*t*r,a=1,o>0||Math.abs(o)<=S?(s=this.x0+this.a*a*t*Math.sin(i)/o,h=this.y0+this.a*a*(this.cos_p14*e-this.sin_p14*t*r)/o):(s=this.x0+this.infinity_dist*t*Math.sin(i),h=this.y0+this.infinity_dist*(this.cos_p14*e-this.sin_p14*t*r)),n.x=s,n.y=h,n}function Pg(n){var e,t,i,r,a,o;return n.x=(n.x-this.x0)/this.a,n.y=(n.y-this.y0)/this.a,n.x/=this.k0,n.y/=this.k0,(e=Math.sqrt(n.x*n.x+n.y*n.y))?(r=Math.atan2(e,this.rc),t=Math.sin(r),i=Math.cos(r),o=ze(i*this.sin_p14+n.y*t*this.cos_p14/e),a=Math.atan2(n.x*t,e*this.cos_p14*i-n.y*this.sin_p14*t),a=O(this.long0+a)):(o=this.phic0,a=0),n.x=a,n.y=o,n}var Lg=["gnom"];const Ng={init:Og,forward:Ag,inverse:Pg,names:Lg};function bg(n,e){var t=1-(1-n*n)/(2*n)*Math.log((1-n)/(1+n));if(Math.abs(Math.abs(e)-t)<1e-6)return e<0?-1*R:R;for(var i=Math.asin(.5*e),r,a,o,s,h=0;h<30;h++)if(a=Math.sin(i),o=Math.cos(i),s=n*a,r=Math.pow(1-s*s,2)/(2*o)*(e/(1-n*n)-a/(1-s*s)+.5/n*Math.log((1-s)/(1+s))),i+=r,Math.abs(r)<=1e-10)return i;return NaN}function Dg(){this.sphere||(this.k0=oe(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))}function Fg(n){var e=n.x,t=n.y,i,r,a=O(e-this.long0);if(this.sphere)i=this.x0+this.a*a*Math.cos(this.lat_ts),r=this.y0+this.a*Math.sin(t)/Math.cos(this.lat_ts);else{var o=Fe(this.e,Math.sin(t));i=this.x0+this.a*this.k0*a,r=this.y0+this.a*o*.5/this.k0}return n.x=i,n.y=r,n}function Gg(n){n.x-=this.x0,n.y-=this.y0;var e,t;return this.sphere?(e=O(this.long0+n.x/this.a/Math.cos(this.lat_ts)),t=Math.asin(n.y/this.a*Math.cos(this.lat_ts))):(t=bg(this.e,2*n.y*this.k0/this.a),e=O(this.long0+n.x/(this.a*this.k0))),n.x=e,n.y=t,n}var kg=["cea"];const zg={init:Dg,forward:Fg,inverse:Gg,names:kg};function jg(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)}function Ug(n){var e=n.x,t=n.y,i=O(e-this.long0),r=je(t-this.lat0);return n.x=this.x0+this.a*i*this.rc,n.y=this.y0+this.a*r,n}function Bg(n){var e=n.x,t=n.y;return n.x=O(this.long0+(e-this.x0)/(this.a*this.rc)),n.y=je(this.lat0+(t-this.y0)/this.a),n}var Wg=["Equirectangular","Equidistant_Cylindrical","eqc"];const Xg={init:jg,forward:Ug,inverse:Bg,names:Wg};var ks=20;function Yg(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=kn(this.es),this.e1=zn(this.es),this.e2=jn(this.es),this.e3=Un(this.es),this.ml0=this.a*wt(this.e0,this.e1,this.e2,this.e3,this.lat0)}function Vg(n){var e=n.x,t=n.y,i,r,a,o=O(e-this.long0);if(a=o*Math.sin(t),this.sphere)Math.abs(t)<=S?(i=this.a*o,r=-1*this.a*this.lat0):(i=this.a*Math.sin(a)/Math.tan(t),r=this.a*(je(t-this.lat0)+(1-Math.cos(a))/Math.tan(t)));else if(Math.abs(t)<=S)i=this.a*o,r=-1*this.ml0;else{var s=ki(this.a,this.e,Math.sin(t))/Math.tan(t);i=s*Math.sin(a),r=this.a*wt(this.e0,this.e1,this.e2,this.e3,t)-this.ml0+s*(1-Math.cos(a))}return n.x=i+this.x0,n.y=r+this.y0,n}function qg(n){var e,t,i,r,a,o,s,h,l;if(i=n.x-this.x0,r=n.y-this.y0,this.sphere)if(Math.abs(r+this.a*this.lat0)<=S)e=O(i/this.a+this.long0),t=0;else{o=this.lat0+r/this.a,s=i*i/this.a/this.a+o*o,h=o;var u;for(a=ks;a;--a)if(u=Math.tan(h),l=-1*(o*(h*u+1)-h-.5*(h*h+s)*u)/((h-o)/u-1),h+=l,Math.abs(l)<=S){t=h;break}e=O(this.long0+Math.asin(i*Math.tan(h)/this.a)/Math.sin(t))}else if(Math.abs(r+this.ml0)<=S)t=0,e=O(this.long0+i/this.a);else{o=(this.ml0+r)/this.a,s=i*i/this.a/this.a+o*o,h=o;var c,f,d,v,_;for(a=ks;a;--a)if(_=this.e*Math.sin(h),c=Math.sqrt(1-_*_)*Math.tan(h),f=this.a*wt(this.e0,this.e1,this.e2,this.e3,h),d=this.e0-2*this.e1*Math.cos(2*h)+4*this.e2*Math.cos(4*h)-6*this.e3*Math.cos(6*h),v=f/this.a,l=(o*(c*v+1)-v-.5*c*(v*v+s))/(this.es*Math.sin(2*h)*(v*v+s-2*o*v)/(4*c)+(o-v)*(c*d-2/Math.sin(2*h))-d),h-=l,Math.abs(l)<=S){t=h;break}c=Math.sqrt(1-this.es*Math.pow(Math.sin(t),2))*Math.tan(t),e=O(this.long0+Math.asin(i*c/this.a)/Math.sin(t))}return n.x=e,n.y=t,n}var Kg=["Polyconic","poly"];const $g={init:Yg,forward:Vg,inverse:qg,names:Kg};function Zg(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013}function Hg(n){var e,t=n.x,i=n.y,r=i-this.lat0,a=t-this.long0,o=r/fn*1e-5,s=a,h=1,l=0;for(e=1;e<=10;e++)h=h*o,l=l+this.A[e]*h;var u=l,c=s,f=1,d=0,v,_,p=0,g=0;for(e=1;e<=6;e++)v=f*u-d*c,_=d*u+f*c,f=v,d=_,p=p+this.B_re[e]*f-this.B_im[e]*d,g=g+this.B_im[e]*f+this.B_re[e]*d;return n.x=g*this.a+this.x0,n.y=p*this.a+this.y0,n}function Jg(n){var e,t=n.x,i=n.y,r=t-this.x0,a=i-this.y0,o=a/this.a,s=r/this.a,h=1,l=0,u,c,f=0,d=0;for(e=1;e<=6;e++)u=h*o-l*s,c=l*o+h*s,h=u,l=c,f=f+this.C_re[e]*h-this.C_im[e]*l,d=d+this.C_im[e]*h+this.C_re[e]*l;for(var v=0;v<this.iterations;v++){var _=f,p=d,g,y,m=o,x=s;for(e=2;e<=6;e++)g=_*f-p*d,y=p*f+_*d,_=g,p=y,m=m+(e-1)*(this.B_re[e]*_-this.B_im[e]*p),x=x+(e-1)*(this.B_im[e]*_+this.B_re[e]*p);_=1,p=0;var E=this.B_re[1],M=this.B_im[1];for(e=2;e<=6;e++)g=_*f-p*d,y=p*f+_*d,_=g,p=y,E=E+e*(this.B_re[e]*_-this.B_im[e]*p),M=M+e*(this.B_im[e]*_+this.B_re[e]*p);var C=E*E+M*M;f=(m*E+x*M)/C,d=(x*E-m*M)/C}var T=f,I=d,A=1,P=0;for(e=1;e<=9;e++)A=A*T,P=P+this.D[e]*A;var b=this.lat0+P*fn*1e5,L=this.long0+I;return n.x=L,n.y=b,n}var Qg=["New_Zealand_Map_Grid","nzmg"];const t0={init:Zg,forward:Hg,inverse:Jg,names:Qg};function e0(){}function i0(n){var e=n.x,t=n.y,i=O(e-this.long0),r=this.x0+this.a*i,a=this.y0+this.a*Math.log(Math.tan(Math.PI/4+t/2.5))*1.25;return n.x=r,n.y=a,n}function n0(n){n.x-=this.x0,n.y-=this.y0;var e=O(this.long0+n.x/this.a),t=2.5*(Math.atan(Math.exp(.8*n.y/this.a))-Math.PI/4);return n.x=e,n.y=t,n}var r0=["Miller_Cylindrical","mill"];const a0={init:e0,forward:i0,inverse:n0,names:r0};var o0=20;function s0(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=uo(this.es)}function h0(n){var e,t,i=n.x,r=n.y;if(i=O(i-this.long0),this.sphere){if(!this.m)r=this.n!==1?Math.asin(this.n*Math.sin(r)):r;else for(var a=this.n*Math.sin(r),o=o0;o;--o){var s=(this.m*r+Math.sin(r)-a)/(this.m+Math.cos(r));if(r-=s,Math.abs(s)<S)break}e=this.a*this.C_x*i*(this.m+Math.cos(r)),t=this.a*this.C_y*r}else{var h=Math.sin(r),l=Math.cos(r);t=this.a*Wi(r,h,l,this.en),e=this.a*i*l/Math.sqrt(1-this.es*h*h)}return n.x=e,n.y=t,n}function l0(n){var e,t,i,r;return n.x-=this.x0,i=n.x/this.a,n.y-=this.y0,e=n.y/this.a,this.sphere?(e/=this.C_y,i=i/(this.C_x*(this.m+Math.cos(e))),this.m?e=ze((this.m*e+Math.sin(e))/this.n):this.n!==1&&(e=ze(Math.sin(e)/this.n)),i=O(i+this.long0),e=je(e)):(e=fo(n.y/this.a,this.es,this.en),r=Math.abs(e),r<R?(r=Math.sin(e),t=this.long0+n.x*Math.sqrt(1-this.es*r*r)/(this.a*Math.cos(e)),i=O(t)):r-S<R&&(i=this.long0)),n.x=i,n.y=e,n}var u0=["Sinusoidal","sinu"];const f0={init:s0,forward:h0,inverse:l0,names:u0};function c0(){}function d0(n){for(var e=n.x,t=n.y,i=O(e-this.long0),r=t,a=Math.PI*Math.sin(t);;){var o=-(r+Math.sin(r)-a)/(1+Math.cos(r));if(r+=o,Math.abs(o)<S)break}r/=2,Math.PI/2-Math.abs(t)<S&&(i=0);var s=.900316316158*this.a*i*Math.cos(r)+this.x0,h=1.4142135623731*this.a*Math.sin(r)+this.y0;return n.x=s,n.y=h,n}function v0(n){var e,t;n.x-=this.x0,n.y-=this.y0,t=n.y/(1.4142135623731*this.a),Math.abs(t)>.999999999999&&(t=.999999999999),e=Math.asin(t);var i=O(this.long0+n.x/(.900316316158*this.a*Math.cos(e)));i<-Math.PI&&(i=-Math.PI),i>Math.PI&&(i=Math.PI),t=(2*e+Math.sin(2*e))/Math.PI,Math.abs(t)>1&&(t=1);var r=Math.asin(t);return n.x=i,n.y=r,n}var _0=["Mollweide","moll"];const p0={init:c0,forward:d0,inverse:v0,names:_0};function g0(){Math.abs(this.lat1+this.lat2)<S||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=kn(this.es),this.e1=zn(this.es),this.e2=jn(this.es),this.e3=Un(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=oe(this.e,this.sinphi,this.cosphi),this.ml1=wt(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<S?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=oe(this.e,this.sinphi,this.cosphi),this.ml2=wt(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=wt(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))}function y0(n){var e=n.x,t=n.y,i;if(this.sphere)i=this.a*(this.g-t);else{var r=wt(this.e0,this.e1,this.e2,this.e3,t);i=this.a*(this.g-r)}var a=this.ns*O(e-this.long0),o=this.x0+i*Math.sin(a),s=this.y0+this.rh-i*Math.cos(a);return n.x=o,n.y=s,n}function m0(n){n.x-=this.x0,n.y=this.rh-n.y+this.y0;var e,t,i,r;this.ns>=0?(t=Math.sqrt(n.x*n.x+n.y*n.y),e=1):(t=-Math.sqrt(n.x*n.x+n.y*n.y),e=-1);var a=0;if(t!==0&&(a=Math.atan2(e*n.x,e*n.y)),this.sphere)return r=O(this.long0+a/this.ns),i=je(this.g-t/this.a),n.x=r,n.y=i,n;var o=this.g-t/this.a;return i=Ar(o,this.e0,this.e1,this.e2,this.e3),r=O(this.long0+a/this.ns),n.x=r,n.y=i,n}var x0=["Equidistant_Conic","eqdc"];const E0={init:g0,forward:y0,inverse:m0,names:x0};function M0(){this.R=this.a}function T0(n){var e=n.x,t=n.y,i=O(e-this.long0),r,a;Math.abs(t)<=S&&(r=this.x0+this.R*i,a=this.y0);var o=ze(2*Math.abs(t/Math.PI));(Math.abs(i)<=S||Math.abs(Math.abs(t)-R)<=S)&&(r=this.x0,t>=0?a=this.y0+Math.PI*this.R*Math.tan(.5*o):a=this.y0+Math.PI*this.R*-Math.tan(.5*o));var s=.5*Math.abs(Math.PI/i-i/Math.PI),h=s*s,l=Math.sin(o),u=Math.cos(o),c=u/(l+u-1),f=c*c,d=c*(2/l-1),v=d*d,_=Math.PI*this.R*(s*(c-v)+Math.sqrt(h*(c-v)*(c-v)-(v+h)*(f-v)))/(v+h);i<0&&(_=-_),r=this.x0+_;var p=h+c;return _=Math.PI*this.R*(d*p-s*Math.sqrt((v+h)*(h+1)-p*p))/(v+h),t>=0?a=this.y0+_:a=this.y0-_,n.x=r,n.y=a,n}function C0(n){var e,t,i,r,a,o,s,h,l,u,c,f,d;return n.x-=this.x0,n.y-=this.y0,c=Math.PI*this.R,i=n.x/c,r=n.y/c,a=i*i+r*r,o=-Math.abs(r)*(1+a),s=o-2*r*r+i*i,h=-2*o+1+2*r*r+a*a,d=r*r/h+(2*s*s*s/h/h/h-9*o*s/h/h)/27,l=(o-s*s/3/h)/h,u=2*Math.sqrt(-l/3),c=3*d/l/u,Math.abs(c)>1&&(c>=0?c=1:c=-1),f=Math.acos(c)/3,n.y>=0?t=(-u*Math.cos(f+Math.PI/3)-s/3/h)*Math.PI:t=-(-u*Math.cos(f+Math.PI/3)-s/3/h)*Math.PI,Math.abs(i)<S?e=this.long0:e=O(this.long0+Math.PI*(a-1+Math.sqrt(1+2*(i*i-r*r)+a*a))/2/i),n.x=e,n.y=t,n}var R0=["Van_der_Grinten_I","VanDerGrinten","vandg"];const w0={init:M0,forward:T0,inverse:C0,names:R0};function I0(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)}function S0(n){var e=n.x,t=n.y,i=Math.sin(n.y),r=Math.cos(n.y),a=O(e-this.long0),o,s,h,l,u,c,f,d,v,_,p,g,y,m,x,E,M,C,T,I,A,P,b;return this.sphere?Math.abs(this.sin_p12-1)<=S?(n.x=this.x0+this.a*(R-t)*Math.sin(a),n.y=this.y0-this.a*(R-t)*Math.cos(a),n):Math.abs(this.sin_p12+1)<=S?(n.x=this.x0+this.a*(R+t)*Math.sin(a),n.y=this.y0+this.a*(R+t)*Math.cos(a),n):(C=this.sin_p12*i+this.cos_p12*r*Math.cos(a),E=Math.acos(C),M=E?E/Math.sin(E):1,n.x=this.x0+this.a*M*r*Math.sin(a),n.y=this.y0+this.a*M*(this.cos_p12*i-this.sin_p12*r*Math.cos(a)),n):(o=kn(this.es),s=zn(this.es),h=jn(this.es),l=Un(this.es),Math.abs(this.sin_p12-1)<=S?(u=this.a*wt(o,s,h,l,R),c=this.a*wt(o,s,h,l,t),n.x=this.x0+(u-c)*Math.sin(a),n.y=this.y0-(u-c)*Math.cos(a),n):Math.abs(this.sin_p12+1)<=S?(u=this.a*wt(o,s,h,l,R),c=this.a*wt(o,s,h,l,t),n.x=this.x0+(u+c)*Math.sin(a),n.y=this.y0+(u+c)*Math.cos(a),n):(f=i/r,d=ki(this.a,this.e,this.sin_p12),v=ki(this.a,this.e,i),_=Math.atan((1-this.es)*f+this.es*d*this.sin_p12/(v*r)),p=Math.atan2(Math.sin(a),this.cos_p12*Math.tan(_)-this.sin_p12*Math.cos(a)),p===0?T=Math.asin(this.cos_p12*Math.sin(_)-this.sin_p12*Math.cos(_)):Math.abs(Math.abs(p)-Math.PI)<=S?T=-Math.asin(this.cos_p12*Math.sin(_)-this.sin_p12*Math.cos(_)):T=Math.asin(Math.sin(a)*Math.cos(_)/Math.sin(p)),g=this.e*this.sin_p12/Math.sqrt(1-this.es),y=this.e*this.cos_p12*Math.cos(p)/Math.sqrt(1-this.es),m=g*y,x=y*y,I=T*T,A=I*T,P=A*T,b=P*T,E=d*T*(1-I*x*(1-x)/6+A/8*m*(1-2*x)+P/120*(x*(4-7*x)-3*g*g*(1-7*x))-b/48*m),n.x=this.x0+E*Math.sin(p),n.y=this.y0+E*Math.cos(p),n))}function O0(n){n.x-=this.x0,n.y-=this.y0;var e,t,i,r,a,o,s,h,l,u,c,f,d,v,_,p,g,y,m,x,E,M,C,T;return this.sphere?(e=Math.sqrt(n.x*n.x+n.y*n.y),e>2*R*this.a?void 0:(t=e/this.a,i=Math.sin(t),r=Math.cos(t),a=this.long0,Math.abs(e)<=S?o=this.lat0:(o=ze(r*this.sin_p12+n.y*i*this.cos_p12/e),s=Math.abs(this.lat0)-R,Math.abs(s)<=S?this.lat0>=0?a=O(this.long0+Math.atan2(n.x,-n.y)):a=O(this.long0-Math.atan2(-n.x,n.y)):a=O(this.long0+Math.atan2(n.x*i,e*this.cos_p12*r-n.y*this.sin_p12*i))),n.x=a,n.y=o,n)):(h=kn(this.es),l=zn(this.es),u=jn(this.es),c=Un(this.es),Math.abs(this.sin_p12-1)<=S?(f=this.a*wt(h,l,u,c,R),e=Math.sqrt(n.x*n.x+n.y*n.y),d=f-e,o=Ar(d/this.a,h,l,u,c),a=O(this.long0+Math.atan2(n.x,-1*n.y)),n.x=a,n.y=o,n):Math.abs(this.sin_p12+1)<=S?(f=this.a*wt(h,l,u,c,R),e=Math.sqrt(n.x*n.x+n.y*n.y),d=e-f,o=Ar(d/this.a,h,l,u,c),a=O(this.long0+Math.atan2(n.x,n.y)),n.x=a,n.y=o,n):(e=Math.sqrt(n.x*n.x+n.y*n.y),p=Math.atan2(n.x,n.y),v=ki(this.a,this.e,this.sin_p12),g=Math.cos(p),y=this.e*this.cos_p12*g,m=-y*y/(1-this.es),x=3*this.es*(1-m)*this.sin_p12*this.cos_p12*g/(1-this.es),E=e/v,M=E-m*(1+m)*Math.pow(E,3)/6-x*(1+3*m)*Math.pow(E,4)/24,C=1-m*M*M/2-E*M*M*M/6,_=Math.asin(this.sin_p12*Math.cos(M)+this.cos_p12*Math.sin(M)*g),a=O(this.long0+Math.asin(Math.sin(p)*Math.sin(M)/Math.cos(_))),T=Math.sin(_),o=Math.atan2((T-this.es*C*this.sin_p12)*Math.tan(_),T*(1-this.es)),n.x=a,n.y=o,n))}var A0=["Azimuthal_Equidistant","aeqd"];const P0={init:I0,forward:S0,inverse:O0,names:A0};function L0(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)}function N0(n){var e,t,i,r,a,o,s,h,l=n.x,u=n.y;return i=O(l-this.long0),e=Math.sin(u),t=Math.cos(u),r=Math.cos(i),o=this.sin_p14*e+this.cos_p14*t*r,a=1,(o>0||Math.abs(o)<=S)&&(s=this.a*a*t*Math.sin(i),h=this.y0+this.a*a*(this.cos_p14*e-this.sin_p14*t*r)),n.x=s,n.y=h,n}function b0(n){var e,t,i,r,a,o,s;return n.x-=this.x0,n.y-=this.y0,e=Math.sqrt(n.x*n.x+n.y*n.y),t=ze(e/this.a),i=Math.sin(t),r=Math.cos(t),o=this.long0,Math.abs(e)<=S?(s=this.lat0,n.x=o,n.y=s,n):(s=ze(r*this.sin_p14+n.y*i*this.cos_p14/e),a=Math.abs(this.lat0)-R,Math.abs(a)<=S?(this.lat0>=0?o=O(this.long0+Math.atan2(n.x,-n.y)):o=O(this.long0-Math.atan2(-n.x,n.y)),n.x=o,n.y=s,n):(o=O(this.long0+Math.atan2(n.x*i,e*this.cos_p14*r-n.y*this.sin_p14*i)),n.x=o,n.y=s,n))}var D0=["ortho"];const F0={init:L0,forward:N0,inverse:b0,names:D0};var ot={FRONT:1,RIGHT:2,BACK:3,LEFT:4,TOP:5,BOTTOM:6},Q={AREA_0:1,AREA_1:2,AREA_2:3,AREA_3:4};function G0(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=R-J/2?this.face=ot.TOP:this.lat0<=-(R-J/2)?this.face=ot.BOTTOM:Math.abs(this.long0)<=J?this.face=ot.FRONT:Math.abs(this.long0)<=R+J?this.face=this.long0>0?ot.RIGHT:ot.LEFT:this.face=ot.BACK,this.es!==0&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)}function k0(n){var e={x:0,y:0},t,i,r,a,o,s,h={value:0};if(n.x-=this.long0,this.es!==0?t=Math.atan(this.one_minus_f_squared*Math.tan(n.y)):t=n.y,i=n.x,this.face===ot.TOP)a=R-t,i>=J&&i<=R+J?(h.value=Q.AREA_0,r=i-R):i>R+J||i<=-(R+J)?(h.value=Q.AREA_1,r=i>0?i-ct:i+ct):i>-(R+J)&&i<=-J?(h.value=Q.AREA_2,r=i+R):(h.value=Q.AREA_3,r=i);else if(this.face===ot.BOTTOM)a=R+t,i>=J&&i<=R+J?(h.value=Q.AREA_0,r=-i+R):i<J&&i>=-J?(h.value=Q.AREA_1,r=-i):i<-J&&i>=-(R+J)?(h.value=Q.AREA_2,r=-i-R):(h.value=Q.AREA_3,r=i>0?-i+ct:-i-ct);else{var l,u,c,f,d,v,_;this.face===ot.RIGHT?i=Ai(i,+R):this.face===ot.BACK?i=Ai(i,+ct):this.face===ot.LEFT&&(i=Ai(i,-R)),f=Math.sin(t),d=Math.cos(t),v=Math.sin(i),_=Math.cos(i),l=d*_,u=d*v,c=f,this.face===ot.FRONT?(a=Math.acos(l),r=or(a,c,u,h)):this.face===ot.RIGHT?(a=Math.acos(u),r=or(a,c,-l,h)):this.face===ot.BACK?(a=Math.acos(-l),r=or(a,c,-u,h)):this.face===ot.LEFT?(a=Math.acos(-u),r=or(a,c,l,h)):(a=r=0,h.value=Q.AREA_0)}return s=Math.atan(12/ct*(r+Math.acos(Math.sin(r)*Math.cos(J))-R)),o=Math.sqrt((1-Math.cos(a))/(Math.cos(s)*Math.cos(s))/(1-Math.cos(Math.atan(1/Math.cos(r))))),h.value===Q.AREA_1?s+=R:h.value===Q.AREA_2?s+=ct:h.value===Q.AREA_3&&(s+=1.5*ct),e.x=o*Math.cos(s),e.y=o*Math.sin(s),e.x=e.x*this.a+this.x0,e.y=e.y*this.a+this.y0,n.x=e.x,n.y=e.y,n}function z0(n){var e={lam:0,phi:0},t,i,r,a,o,s,h,l,u,c={value:0};if(n.x=(n.x-this.x0)/this.a,n.y=(n.y-this.y0)/this.a,i=Math.atan(Math.sqrt(n.x*n.x+n.y*n.y)),t=Math.atan2(n.y,n.x),n.x>=0&&n.x>=Math.abs(n.y)?c.value=Q.AREA_0:n.y>=0&&n.y>=Math.abs(n.x)?(c.value=Q.AREA_1,t-=R):n.x<0&&-n.x>=Math.abs(n.y)?(c.value=Q.AREA_2,t=t<0?t+ct:t-ct):(c.value=Q.AREA_3,t+=R),u=ct/12*Math.tan(t),o=Math.sin(u)/(Math.cos(u)-1/Math.sqrt(2)),s=Math.atan(o),r=Math.cos(t),a=Math.tan(i),h=1-r*r*a*a*(1-Math.cos(Math.atan(1/Math.cos(s)))),h<-1?h=-1:h>1&&(h=1),this.face===ot.TOP)l=Math.acos(h),e.phi=R-l,c.value===Q.AREA_0?e.lam=s+R:c.value===Q.AREA_1?e.lam=s<0?s+ct:s-ct:c.value===Q.AREA_2?e.lam=s-R:e.lam=s;else if(this.face===ot.BOTTOM)l=Math.acos(h),e.phi=l-R,c.value===Q.AREA_0?e.lam=-s+R:c.value===Q.AREA_1?e.lam=-s:c.value===Q.AREA_2?e.lam=-s-R:e.lam=s<0?-s-ct:-s+ct;else{var f,d,v;f=h,u=f*f,u>=1?v=0:v=Math.sqrt(1-u)*Math.sin(s),u+=v*v,u>=1?d=0:d=Math.sqrt(1-u),c.value===Q.AREA_1?(u=d,d=-v,v=u):c.value===Q.AREA_2?(d=-d,v=-v):c.value===Q.AREA_3&&(u=d,d=v,v=-u),this.face===ot.RIGHT?(u=f,f=-d,d=u):this.face===ot.BACK?(f=-f,d=-d):this.face===ot.LEFT&&(u=f,f=d,d=-u),e.phi=Math.acos(-v)-R,e.lam=Math.atan2(d,f),this.face===ot.RIGHT?e.lam=Ai(e.lam,-R):this.face===ot.BACK?e.lam=Ai(e.lam,-ct):this.face===ot.LEFT&&(e.lam=Ai(e.lam,+R))}if(this.es!==0){var _,p,g;_=e.phi<0?1:0,p=Math.tan(e.phi),g=this.b/Math.sqrt(p*p+this.one_minus_f_squared),e.phi=Math.atan(Math.sqrt(this.a*this.a-g*g)/(this.one_minus_f*g)),_&&(e.phi=-e.phi)}return e.lam+=this.long0,n.x=e.lam,n.y=e.phi,n}function or(n,e,t,i){var r;return n<S?(i.value=Q.AREA_0,r=0):(r=Math.atan2(e,t),Math.abs(r)<=J?i.value=Q.AREA_0:r>J&&r<=R+J?(i.value=Q.AREA_1,r-=R):r>R+J||r<=-(R+J)?(i.value=Q.AREA_2,r=r>=0?r-ct:r+ct):(i.value=Q.AREA_3,r+=R)),r}function Ai(n,e){var t=n+e;return t<-ct?t+=Rn:t>+ct&&(t-=Rn),t}var j0=["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"];const U0={init:G0,forward:k0,inverse:z0,names:j0};var Fa=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-986701e-12],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,18736e-12],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,934959e-12],[.7986,-.00755338,-500009e-10,935324e-12],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],ln=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-126793e-14,422642e-15],[.124,.0124,507171e-14,-160604e-14],[.186,.0123999,-190189e-13,600152e-14],[.248,.0124002,710039e-13,-224e-10],[.31,.0123992,-264997e-12,835986e-13],[.372,.0124029,988983e-12,-311994e-12],[.434,.0123893,-369093e-11,-435621e-12],[.4958,.0123198,-102252e-10,-345523e-12],[.5571,.0121916,-154081e-10,-582288e-12],[.6176,.0119938,-241424e-10,-525327e-12],[.6769,.011713,-320223e-10,-516405e-12],[.7346,.0113541,-397684e-10,-609052e-12],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-140374e-14],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Rl=.8487,wl=1.3523,Il=ee/5,B0=1/Il,Ri=18,Pr=function(n,e){return n[0]+e*(n[1]+e*(n[2]+e*n[3]))},W0=function(n,e){return n[1]+e*(2*n[2]+e*3*n[3])};function X0(n,e,t,i){for(var r=e;i;--i){var a=n(r);if(r-=a,Math.abs(a)<t)break}return r}function Y0(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"}function V0(n){var e=O(n.x-this.long0),t=Math.abs(n.y),i=Math.floor(t*Il);i<0?i=0:i>=Ri&&(i=Ri-1),t=ee*(t-B0*i);var r={x:Pr(Fa[i],t)*e,y:Pr(ln[i],t)};return n.y<0&&(r.y=-r.y),r.x=r.x*this.a*Rl+this.x0,r.y=r.y*this.a*wl+this.y0,r}function q0(n){var e={x:(n.x-this.x0)/(this.a*Rl),y:Math.abs(n.y-this.y0)/(this.a*wl)};if(e.y>=1)e.x/=Fa[Ri][0],e.y=n.y<0?-R:R;else{var t=Math.floor(e.y*Ri);for(t<0?t=0:t>=Ri&&(t=Ri-1);;)if(ln[t][0]>e.y)--t;else if(ln[t+1][0]<=e.y)++t;else break;var i=ln[t],r=5*(e.y-i[0])/(ln[t+1][0]-i[0]);r=X0(function(a){return(Pr(i,a)-e.y)/W0(i,a)},r,S,100),e.x/=Pr(Fa[t],r),e.y=(5*t+r)*gt,n.y<0&&(e.y=-e.y)}return e.x=O(e.x+this.long0),e}var K0=["Robinson","robin"];const $0={init:Y0,forward:V0,inverse:q0,names:K0};function Z0(){this.name="geocent"}function H0(n){var e=vl(n,this.es,this.a);return e}function J0(n){var e=_l(n,this.es,this.a,this.b);return e}var Q0=["Geocentric","geocentric","geocent","Geocent"];const ty={init:Z0,forward:H0,inverse:J0,names:Q0};var mt={N_POLE:0,S_POLE:1,EQUIT:2,OBLIQ:3},nn={h:{def:1e5,num:!0},azi:{def:0,num:!0,degrees:!0},tilt:{def:0,num:!0,degrees:!0},long0:{def:0,num:!0},lat0:{def:0,num:!0}};function ey(){if(Object.keys(nn).forEach((function(t){if(typeof this[t]>"u")this[t]=nn[t].def;else{if(nn[t].num&&isNaN(this[t]))throw new Error("Invalid parameter value, must be numeric "+t+" = "+this[t]);nn[t].num&&(this[t]=parseFloat(this[t]))}nn[t].degrees&&(this[t]=this[t]*gt)}).bind(this)),Math.abs(Math.abs(this.lat0)-R)<S?this.mode=this.lat0<0?mt.S_POLE:mt.N_POLE:Math.abs(this.lat0)<S?this.mode=mt.EQUIT:(this.mode=mt.OBLIQ,this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0)),this.pn1=this.h/this.a,this.pn1<=0||this.pn1>1e10)throw new Error("Invalid height");this.p=1+this.pn1,this.rp=1/this.p,this.h1=1/this.pn1,this.pfact=(this.p+1)*this.h1,this.es=0;var n=this.tilt,e=this.azi;this.cg=Math.cos(e),this.sg=Math.sin(e),this.cw=Math.cos(n),this.sw=Math.sin(n)}function iy(n){n.x-=this.long0;var e=Math.sin(n.y),t=Math.cos(n.y),i=Math.cos(n.x),r,a;switch(this.mode){case mt.OBLIQ:a=this.sinph0*e+this.cosph0*t*i;break;case mt.EQUIT:a=t*i;break;case mt.S_POLE:a=-e;break;case mt.N_POLE:a=e;break}switch(a=this.pn1/(this.p-a),r=a*t*Math.sin(n.x),this.mode){case mt.OBLIQ:a*=this.cosph0*e-this.sinph0*t*i;break;case mt.EQUIT:a*=e;break;case mt.N_POLE:a*=-(t*i);break;case mt.S_POLE:a*=t*i;break}var o,s;return o=a*this.cg+r*this.sg,s=1/(o*this.sw*this.h1+this.cw),r=(r*this.cg-a*this.sg)*this.cw*s,a=o*s,n.x=r*this.a,n.y=a*this.a,n}function ny(n){n.x/=this.a,n.y/=this.a;var e={x:n.x,y:n.y},t,i,r;r=1/(this.pn1-n.y*this.sw),t=this.pn1*n.x*r,i=this.pn1*n.y*this.cw*r,n.x=t*this.cg+i*this.sg,n.y=i*this.cg-t*this.sg;var a=Lt(n.x,n.y);if(Math.abs(a)<S)e.x=0,e.y=n.y;else{var o,s;switch(s=1-a*a*this.pfact,s=(this.p-Math.sqrt(s))/(this.pn1/a+a/this.pn1),o=Math.sqrt(1-s*s),this.mode){case mt.OBLIQ:e.y=Math.asin(o*this.sinph0+n.y*s*this.cosph0/a),n.y=(o-this.sinph0*Math.sin(e.y))*a,n.x*=s*this.cosph0;break;case mt.EQUIT:e.y=Math.asin(n.y*s/a),n.y=o*a,n.x*=s;break;case mt.N_POLE:e.y=Math.asin(o),n.y=-n.y;break;case mt.S_POLE:e.y=-Math.asin(o);break}e.x=Math.atan2(n.x,n.y)}return n.x=e.x+this.long0,n.y=e.y,n}var ry=["Tilted_Perspective","tpers"];const ay={init:ey,forward:iy,inverse:ny,names:ry};function oy(){if(this.flip_axis=this.sweep==="x"?1:0,this.h=Number(this.h),this.radius_g_1=this.h/this.a,this.radius_g_1<=0||this.radius_g_1>1e10)throw new Error;if(this.radius_g=1+this.radius_g_1,this.C=this.radius_g*this.radius_g-1,this.es!==0){var n=1-this.es,e=1/n;this.radius_p=Math.sqrt(n),this.radius_p2=n,this.radius_p_inv2=e,this.shape="ellipse"}else this.radius_p=1,this.radius_p2=1,this.radius_p_inv2=1,this.shape="sphere";this.title||(this.title="Geostationary Satellite View")}function sy(n){var e=n.x,t=n.y,i,r,a,o;if(e=e-this.long0,this.shape==="ellipse"){t=Math.atan(this.radius_p2*Math.tan(t));var s=this.radius_p/Lt(this.radius_p*Math.cos(t),Math.sin(t));if(r=s*Math.cos(e)*Math.cos(t),a=s*Math.sin(e)*Math.cos(t),o=s*Math.sin(t),(this.radius_g-r)*r-a*a-o*o*this.radius_p_inv2<0)return n.x=Number.NaN,n.y=Number.NaN,n;i=this.radius_g-r,this.flip_axis?(n.x=this.radius_g_1*Math.atan(a/Lt(o,i)),n.y=this.radius_g_1*Math.atan(o/i)):(n.x=this.radius_g_1*Math.atan(a/i),n.y=this.radius_g_1*Math.atan(o/Lt(a,i)))}else this.shape==="sphere"&&(i=Math.cos(t),r=Math.cos(e)*i,a=Math.sin(e)*i,o=Math.sin(t),i=this.radius_g-r,this.flip_axis?(n.x=this.radius_g_1*Math.atan(a/Lt(o,i)),n.y=this.radius_g_1*Math.atan(o/i)):(n.x=this.radius_g_1*Math.atan(a/i),n.y=this.radius_g_1*Math.atan(o/Lt(a,i))));return n.x=n.x*this.a,n.y=n.y*this.a,n}function hy(n){var e=-1,t=0,i=0,r,a,o,s;if(n.x=n.x/this.a,n.y=n.y/this.a,this.shape==="ellipse"){this.flip_axis?(i=Math.tan(n.y/this.radius_g_1),t=Math.tan(n.x/this.radius_g_1)*Lt(1,i)):(t=Math.tan(n.x/this.radius_g_1),i=Math.tan(n.y/this.radius_g_1)*Lt(1,t));var h=i/this.radius_p;if(r=t*t+h*h+e*e,a=2*this.radius_g*e,o=a*a-4*r*this.C,o<0)return n.x=Number.NaN,n.y=Number.NaN,n;s=(-a-Math.sqrt(o))/(2*r),e=this.radius_g+s*e,t*=s,i*=s,n.x=Math.atan2(t,e),n.y=Math.atan(i*Math.cos(n.x)/e),n.y=Math.atan(this.radius_p_inv2*Math.tan(n.y))}else if(this.shape==="sphere"){if(this.flip_axis?(i=Math.tan(n.y/this.radius_g_1),t=Math.tan(n.x/this.radius_g_1)*Math.sqrt(1+i*i)):(t=Math.tan(n.x/this.radius_g_1),i=Math.tan(n.y/this.radius_g_1)*Math.sqrt(1+t*t)),r=t*t+i*i+e*e,a=2*this.radius_g*e,o=a*a-4*r*this.C,o<0)return n.x=Number.NaN,n.y=Number.NaN,n;s=(-a-Math.sqrt(o))/(2*r),e=this.radius_g+s*e,t*=s,i*=s,n.x=Math.atan2(t,e),n.y=Math.atan(i*Math.cos(n.x)/e)}return n.x=n.x+this.long0,n}var ly=["Geostationary Satellite View","Geostationary_Satellite","geos"];const uy={init:oy,forward:sy,inverse:hy,names:ly};var cn=1.340264,dn=-.081106,vn=893e-6,_n=.003796,Lr=Math.sqrt(3)/2;function fy(){this.es=0,this.long0=this.long0!==void 0?this.long0:0}function cy(n){var e=O(n.x-this.long0),t=n.y,i=Math.asin(Lr*Math.sin(t)),r=i*i,a=r*r*r;return n.x=e*Math.cos(i)/(Lr*(cn+3*dn*r+a*(7*vn+9*_n*r))),n.y=i*(cn+dn*r+a*(vn+_n*r)),n.x=this.a*n.x+this.x0,n.y=this.a*n.y+this.y0,n}function dy(n){n.x=(n.x-this.x0)/this.a,n.y=(n.y-this.y0)/this.a;var e=1e-9,t=12,i=n.y,r,a,o,s,h,l;for(l=0;l<t&&(r=i*i,a=r*r*r,o=i*(cn+dn*r+a*(vn+_n*r))-n.y,s=cn+3*dn*r+a*(7*vn+9*_n*r),i-=h=o/s,!(Math.abs(h)<e));++l);return r=i*i,a=r*r*r,n.x=Lr*n.x*(cn+3*dn*r+a*(7*vn+9*_n*r))/Math.cos(i),n.y=Math.asin(Math.sin(i)/Lr),n.x=O(n.x+this.long0),n}var vy=["eqearth","Equal Earth","Equal_Earth"];const _y={init:fy,forward:cy,inverse:dy,names:vy};var Sn=1e-10;function py(){var n;if(this.phi1=this.lat1,Math.abs(this.phi1)<Sn)throw new Error;this.es?(this.en=uo(this.es),this.m1=Wi(this.phi1,this.am1=Math.sin(this.phi1),n=Math.cos(this.phi1),this.en),this.am1=n/(Math.sqrt(1-this.es*this.am1*this.am1)*this.am1),this.inverse=yy,this.forward=gy):(Math.abs(this.phi1)+Sn>=R?this.cphi1=0:this.cphi1=1/Math.tan(this.phi1),this.inverse=xy,this.forward=my)}function gy(n){var e=O(n.x-(this.long0||0)),t=n.y,i,r,a;return i=this.am1+this.m1-Wi(t,r=Math.sin(t),a=Math.cos(t),this.en),r=a*e/(i*Math.sqrt(1-this.es*r*r)),n.x=i*Math.sin(r),n.y=this.am1-i*Math.cos(r),n.x=this.a*n.x+(this.x0||0),n.y=this.a*n.y+(this.y0||0),n}function yy(n){n.x=(n.x-(this.x0||0))/this.a,n.y=(n.y-(this.y0||0))/this.a;var e,t,i,r;if(t=Lt(n.x,n.y=this.am1-n.y),r=fo(this.am1+this.m1-t,this.es,this.en),(e=Math.abs(r))<R)e=Math.sin(r),i=t*Math.atan2(n.x,n.y)*Math.sqrt(1-this.es*e*e)/Math.cos(r);else if(Math.abs(e-R)<=Sn)i=0;else throw new Error;return n.x=O(i+(this.long0||0)),n.y=je(r),n}function my(n){var e=O(n.x-(this.long0||0)),t=n.y,i,r;return r=this.cphi1+this.phi1-t,Math.abs(r)>Sn?(n.x=r*Math.sin(i=e*Math.cos(t)/r),n.y=this.cphi1-r*Math.cos(i)):n.x=n.y=0,n.x=this.a*n.x+(this.x0||0),n.y=this.a*n.y+(this.y0||0),n}function xy(n){n.x=(n.x-(this.x0||0))/this.a,n.y=(n.y-(this.y0||0))/this.a;var e,t,i=Lt(n.x,n.y=this.cphi1-n.y);if(t=this.cphi1+this.phi1-i,Math.abs(t)>R)throw new Error;return Math.abs(Math.abs(t)-R)<=Sn?e=0:e=i*Math.atan2(n.x,n.y)/Math.cos(t),n.x=O(e+(this.long0||0)),n.y=je(t),n}var Ey=["bonne","Bonne (Werner lat_1=90)"];const My={init:py,names:Ey};function Ty(n){n.Proj.projections.add(dr),n.Proj.projections.add(vr),n.Proj.projections.add(yp),n.Proj.projections.add(Ip),n.Proj.projections.add(Np),n.Proj.projections.add(kp),n.Proj.projections.add(Xp),n.Proj.projections.add($p),n.Proj.projections.add(tg),n.Proj.projections.add(ag),n.Proj.projections.add(Mg),n.Proj.projections.add(Sg),n.Proj.projections.add(Ng),n.Proj.projections.add(zg),n.Proj.projections.add(Xg),n.Proj.projections.add($g),n.Proj.projections.add(t0),n.Proj.projections.add(a0),n.Proj.projections.add(f0),n.Proj.projections.add(p0),n.Proj.projections.add(E0),n.Proj.projections.add(w0),n.Proj.projections.add(P0),n.Proj.projections.add(F0),n.Proj.projections.add(U0),n.Proj.projections.add($0),n.Proj.projections.add(ty),n.Proj.projections.add(ay),n.Proj.projections.add(uy),n.Proj.projections.add(_y),n.Proj.projections.add(My)}bt.defaultDatum="WGS84";bt.Proj=ne;bt.WGS84=new bt.Proj("WGS84");bt.Point=Gi;bt.toPoint=pl;bt.defs=Tt;bt.nadgrid=x_;bt.transform=Or;bt.mgrs=F_;bt.version="__VERSION__";Ty(bt);var Cy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Ry=(function(n){Cy(e,n);function e(t){var i=t||{};return n.call(this,i)||this}return e})(Ln),Sl=.5,Nr={imageSmoothingEnabled:!1,msImageSmoothingEnabled:!1},Ol={imageSmoothingEnabled:!0,msImageSmoothingEnabled:!0},wy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Iy=(function(n){wy(e,n);function e(t){var i=n.call(this,t)||this;return i.image_=null,i}return e.prototype.getImage=function(){return this.image_?this.image_.getImage():null},e.prototype.prepareFrame=function(t){var i=t.layerStatesArray[t.layerIndex],r=t.pixelRatio,a=t.viewState,o=a.resolution,s=this.getLayer().getSource(),h=t.viewHints,l=t.extent;if(i.extent!==void 0&&(l=Je(l,de(i.extent,a.projection))),!h[_t.ANIMATING]&&!h[_t.INTERACTING]&&!Ur(l))if(s){var u=a.projection,c=s.getImage(l,o,r,u);c&&this.loadImage(c)?this.image_=c:this.image_=null}else this.image_=null;return!!this.image_},e.prototype.getData=function(t){var i=this.frameState;if(!i)return null;var r=this.getLayer(),a=ft(i.pixelToCoordinateTransform,t.slice()),o=r.getExtent();if(o&&!Ui(o,a))return null;var s=this.image_.getExtent(),h=this.image_.getImage(),l=et(s),u=Math.floor(h.width*((a[0]-s[0])/l));if(u<0||u>=h.width)return null;var c=Et(s),f=Math.floor(h.height*((s[3]-a[1])/c));return f<0||f>=h.height?null:this.getImageData(h,u,f)},e.prototype.renderFrame=function(t,i){var r=this.image_,a=r.getExtent(),o=r.getResolution(),s=r.getPixelRatio(),h=t.layerStatesArray[t.layerIndex],l=t.pixelRatio,u=t.viewState,c=u.center,f=u.resolution,d=t.size,v=l*o/(f*s),_=Math.round(d[0]*l),p=Math.round(d[1]*l),g=u.rotation;if(g){var y=Math.round(Math.sqrt(_*_+p*p));_=y,p=y}$t(this.pixelTransform,t.size[0]/2,t.size[1]/2,1/l,1/l,g,-_/2,-p/2),Wr(this.inversePixelTransform,this.pixelTransform);var m=Za(this.pixelTransform);this.useContainer(i,m,h.opacity,this.getBackground(t));var x=this.context,E=x.canvas;E.width!=_||E.height!=p?(E.width=_,E.height=p):this.containerReused||x.clearRect(0,0,_,p);var M=!1,C=!0;if(h.extent){var T=de(h.extent,u.projection);C=Ct(T,t.extent),M=C&&!Pe(T,t.extent),M&&this.clipUnrotated(x,t,T)}var I=r.getImage(),A=$t(this.tempTransform,_/2,p/2,v,v,0,s*(a[0]-c[0])/o,s*(c[1]-a[3])/o);this.renderedResolution=o*l/s;var P=I.width*A[0],b=I.height*A[3];if(this.getLayer().getSource().getInterpolate()||it(x,Nr),this.preRender(x,t),C&&P>=.5&&b>=.5){var L=A[4],j=A[5],N=h.opacity,G=void 0;N!==1&&(G=x.globalAlpha,x.globalAlpha=N),x.drawImage(I,0,0,+I.width,+I.height,Math.round(L),Math.round(j),Math.round(P),Math.round(b)),N!==1&&(x.globalAlpha=G)}return this.postRender(x,t),M&&x.restore(),it(x,Ol),m!==E.style.transform&&(E.style.transform=m),this.container},e})(ao),Sy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Oy=(function(n){Sy(e,n);function e(t){return n.call(this,t)||this}return e.prototype.createRenderer=function(){return new Iy(this)},e.prototype.getData=function(t){return n.prototype.getData.call(this,t)},e})(Ry);const sr={PRELOAD:"preload",USE_INTERIM_TILES_ON_ERROR:"useInterimTilesOnError"};var Ay=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Py=(function(n){Ay(e,n);function e(t){var i=this,r=t||{},a=it({},r);return delete a.preload,delete a.useInterimTilesOnError,i=n.call(this,a)||this,i.on,i.once,i.un,i.setPreload(r.preload!==void 0?r.preload:0),i.setUseInterimTilesOnError(r.useInterimTilesOnError!==void 0?r.useInterimTilesOnError:!0),i}return e.prototype.getPreload=function(){return this.get(sr.PRELOAD)},e.prototype.setPreload=function(t){this.set(sr.PRELOAD,t)},e.prototype.getUseInterimTilesOnError=function(){return this.get(sr.USE_INTERIM_TILES_ON_ERROR)},e.prototype.setUseInterimTilesOnError=function(t){this.set(sr.USE_INTERIM_TILES_ON_ERROR,t)},e.prototype.getData=function(t){return n.prototype.getData.call(this,t)},e})(Ln),Ly=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Al=(function(n){Ly(e,n);function e(t,i,r){var a=n.call(this)||this,o=r||{};return a.tileCoord=t,a.state=i,a.interimTile=null,a.key="",a.transition_=o.transition===void 0?250:o.transition,a.transitionStarts_={},a.interpolate=!!o.interpolate,a}return e.prototype.changed=function(){this.dispatchEvent(B.CHANGE)},e.prototype.release=function(){},e.prototype.getKey=function(){return this.key+"/"+this.tileCoord},e.prototype.getInterimTile=function(){if(!this.interimTile)return this;var t=this.interimTile;do{if(t.getState()==k.LOADED)return this.transition_=0,t;t=t.interimTile}while(t);return this},e.prototype.refreshInterimChain=function(){if(this.interimTile){var t=this.interimTile,i=this;do{if(t.getState()==k.LOADED){t.interimTile=null;break}else t.getState()==k.LOADING?i=t:t.getState()==k.IDLE?i.interimTile=t.interimTile:i=t;t=i.interimTile}while(t)}},e.prototype.getTileCoord=function(){return this.tileCoord},e.prototype.getState=function(){return this.state},e.prototype.setState=function(t){if(this.state!==k.ERROR&&this.state>t)throw new Error("Tile load sequence violation");this.state=t,this.changed()},e.prototype.load=function(){q()},e.prototype.getAlpha=function(t,i){if(!this.transition_)return 1;var r=this.transitionStarts_[t];if(!r)r=i,this.transitionStarts_[t]=r;else if(r===-1)return 1;var a=i-r+1e3/60;return a>=this.transition_?1:nh(a/this.transition_)},e.prototype.inTransition=function(t){return this.transition_?this.transitionStarts_[t]!==-1:!1},e.prototype.endTransition=function(t){this.transition_&&(this.transitionStarts_[t]=-1)},e})(zi),Ny=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Pl=(function(n){Ny(e,n);function e(t,i,r,a,o,s){var h=n.call(this,t,i,s)||this;return h.crossOrigin_=a,h.src_=r,h.key=r,h.image_=new Image,a!==null&&(h.image_.crossOrigin=a),h.unlisten_=null,h.tileLoadFunction_=o,h}return e.prototype.getImage=function(){return this.image_},e.prototype.setImage=function(t){this.image_=t,this.state=k.LOADED,this.unlistenImage_(),this.changed()},e.prototype.handleImageError_=function(){this.state=k.ERROR,this.unlistenImage_(),this.image_=by(),this.changed()},e.prototype.handleImageLoad_=function(){var t=this.image_;t.naturalWidth&&t.naturalHeight?this.state=k.LOADED:this.state=k.EMPTY,this.unlistenImage_(),this.changed()},e.prototype.load=function(){this.state==k.ERROR&&(this.state=k.IDLE,this.image_=new Image,this.crossOrigin_!==null&&(this.image_.crossOrigin=this.crossOrigin_)),this.state==k.IDLE&&(this.state=k.LOADING,this.changed(),this.tileLoadFunction_(this,this.src_),this.unlisten_=oo(this.image_,this.handleImageLoad_.bind(this),this.handleImageError_.bind(this)))},e.prototype.unlistenImage_=function(){this.unlisten_&&(this.unlisten_(),this.unlisten_=null)},e})(Al);function by(){var n=Bt(1,1);return n.fillStyle="rgba(0,0,0,0)",n.fillRect(0,0,1,1),n.canvas}var Dy=10,zs=.25,Ll=(function(){function n(e,t,i,r,a,o){this.sourceProj_=e,this.targetProj_=t;var s={},h=yn(this.targetProj_,this.sourceProj_);this.transformInv_=function(m){var x=m[0]+"/"+m[1];return s[x]||(s[x]=h(m)),s[x]},this.maxSourceExtent_=r,this.errorThresholdSquared_=a*a,this.triangles_=[],this.wrapsXInSource_=!1,this.canWrapXInSource_=this.sourceProj_.canWrapX()&&!!r&&!!this.sourceProj_.getExtent()&&et(r)==et(this.sourceProj_.getExtent()),this.sourceWorldWidth_=this.sourceProj_.getExtent()?et(this.sourceProj_.getExtent()):null,this.targetWorldWidth_=this.targetProj_.getExtent()?et(this.targetProj_.getExtent()):null;var l=oi(i),u=Ya(i),c=Xa(i),f=Wa(i),d=this.transformInv_(l),v=this.transformInv_(u),_=this.transformInv_(c),p=this.transformInv_(f),g=Dy+(o?Math.max(0,Math.ceil(Ru(Ta(i)/(o*o*256*256)))):0);if(this.addQuad_(l,u,c,f,d,v,_,p,g),this.wrapsXInSource_){var y=1/0;this.triangles_.forEach(function(m,x,E){y=Math.min(y,m.source[0][0],m.source[1][0],m.source[2][0])}),this.triangles_.forEach((function(m){if(Math.max(m.source[0][0],m.source[1][0],m.source[2][0])-y>this.sourceWorldWidth_/2){var x=[[m.source[0][0],m.source[0][1]],[m.source[1][0],m.source[1][1]],[m.source[2][0],m.source[2][1]]];x[0][0]-y>this.sourceWorldWidth_/2&&(x[0][0]-=this.sourceWorldWidth_),x[1][0]-y>this.sourceWorldWidth_/2&&(x[1][0]-=this.sourceWorldWidth_),x[2][0]-y>this.sourceWorldWidth_/2&&(x[2][0]-=this.sourceWorldWidth_);var E=Math.min(x[0][0],x[1][0],x[2][0]),M=Math.max(x[0][0],x[1][0],x[2][0]);M-E<this.sourceWorldWidth_/2&&(m.source=x)}}).bind(this))}s={}}return n.prototype.addTriangle_=function(e,t,i,r,a,o){this.triangles_.push({source:[r,a,o],target:[e,t,i]})},n.prototype.addQuad_=function(e,t,i,r,a,o,s,h,l){var u=ko([a,o,s,h]),c=this.sourceWorldWidth_?et(u)/this.sourceWorldWidth_:null,f=this.sourceWorldWidth_,d=this.sourceProj_.canWrapX()&&c>.5&&c<1,v=!1;if(l>0){if(this.targetProj_.isGlobal()&&this.targetWorldWidth_){var _=ko([e,t,i,r]),p=et(_)/this.targetWorldWidth_;v=p>zs||v}!d&&this.sourceProj_.isGlobal()&&c&&(v=c>zs||v)}if(!(!v&&this.maxSourceExtent_&&isFinite(u[0])&&isFinite(u[1])&&isFinite(u[2])&&isFinite(u[3])&&!Ct(u,this.maxSourceExtent_))){var g=0;if(!v&&(!isFinite(a[0])||!isFinite(a[1])||!isFinite(o[0])||!isFinite(o[1])||!isFinite(s[0])||!isFinite(s[1])||!isFinite(h[0])||!isFinite(h[1]))){if(l>0)v=!0;else if(g=(!isFinite(a[0])||!isFinite(a[1])?8:0)+(!isFinite(o[0])||!isFinite(o[1])?4:0)+(!isFinite(s[0])||!isFinite(s[1])?2:0)+(!isFinite(h[0])||!isFinite(h[1])?1:0),g!=1&&g!=2&&g!=4&&g!=8)return}if(l>0){if(!v){var y=[(e[0]+i[0])/2,(e[1]+i[1])/2],m=this.transformInv_(y),x=void 0;if(d){var E=(He(a[0],f)+He(s[0],f))/2;x=E-He(m[0],f)}else x=(a[0]+s[0])/2-m[0];var M=(a[1]+s[1])/2-m[1],C=x*x+M*M;v=C>this.errorThresholdSquared_}if(v){if(Math.abs(e[0]-i[0])<=Math.abs(e[1]-i[1])){var T=[(t[0]+i[0])/2,(t[1]+i[1])/2],I=this.transformInv_(T),A=[(r[0]+e[0])/2,(r[1]+e[1])/2],P=this.transformInv_(A);this.addQuad_(e,t,T,A,a,o,I,P,l-1),this.addQuad_(A,T,i,r,P,I,s,h,l-1)}else{var b=[(e[0]+t[0])/2,(e[1]+t[1])/2],L=this.transformInv_(b),j=[(i[0]+r[0])/2,(i[1]+r[1])/2],N=this.transformInv_(j);this.addQuad_(e,b,j,r,a,L,N,h,l-1),this.addQuad_(b,t,i,j,L,o,s,N,l-1)}return}}if(d){if(!this.canWrapXInSource_)return;this.wrapsXInSource_=!0}(g&11)==0&&this.addTriangle_(e,i,r,a,s,h),(g&14)==0&&this.addTriangle_(e,i,t,a,s,o),g&&((g&13)==0&&this.addTriangle_(t,r,e,o,h,a),(g&7)==0&&this.addTriangle_(t,r,i,o,h,s))}},n.prototype.calculateSourceExtent=function(){var e=Wt();return this.triangles_.forEach(function(t,i,r){var a=t.source;un(e,a[0]),un(e,a[1]),un(e,a[2])}),e},n.prototype.getTriangles=function(){return this.triangles_},n})(),_a;function js(n,e,t,i,r){n.beginPath(),n.moveTo(0,0),n.lineTo(e,t),n.lineTo(i,r),n.closePath(),n.save(),n.clip(),n.fillRect(0,0,Math.max(e,i)+1,Math.max(t,r)),n.restore()}function pa(n,e){return Math.abs(n[e*4]-210)>2||Math.abs(n[e*4+3]-.75*255)>2}function Fy(){if(_a===void 0){var n=document.createElement("canvas").getContext("2d");n.globalCompositeOperation="lighter",n.fillStyle="rgba(210, 0, 0, 0.75)",js(n,4,5,4,0),js(n,4,5,0,5);var e=n.getImageData(0,0,3,3).data;_a=pa(e,0)||pa(e,4)||pa(e,8)}return _a}function On(n,e,t,i){var r=bn(t,e,n),a=jo(e,i,t),o=e.getMetersPerUnit();o!==void 0&&(a*=o);var s=n.getMetersPerUnit();s!==void 0&&(a/=s);var h=n.getExtent();if(!h||Ui(h,r)){var l=jo(n,a,r)/a;isFinite(l)&&l>0&&(a/=l)}return a}function Gy(n,e,t,i){var r=Ge(t),a=On(n,e,r,i);return(!isFinite(a)||a<=0)&&lh(t,function(o){return a=On(n,e,o,i),isFinite(a)&&a>0}),a}function Nl(n,e,t,i,r,a,o,s,h,l,u,c){var f=Bt(Math.round(t*n),Math.round(t*e));if(c||it(f,Nr),h.length===0)return f.canvas;f.scale(t,t);function d(x){return Math.round(x*t)/t}f.globalCompositeOperation="lighter";var v=Wt();h.forEach(function(x,E,M){Hu(v,x.extent)});var _=et(v),p=Et(v),g=Bt(Math.round(t*_/i),Math.round(t*p/i));c||it(g,Nr);var y=t/i;h.forEach(function(x,E,M){var C=x.extent[0]-v[0],T=-(x.extent[3]-v[3]),I=et(x.extent),A=Et(x.extent);x.image.width>0&&x.image.height>0&&g.drawImage(x.image,l,l,x.image.width-2*l,x.image.height-2*l,C*y,T*y,I*y,A*y)});var m=oi(o);return s.getTriangles().forEach(function(x,E,M){var C=x.source,T=x.target,I=C[0][0],A=C[0][1],P=C[1][0],b=C[1][1],L=C[2][0],j=C[2][1],N=d((T[0][0]-m[0])/a),G=d(-(T[0][1]-m[1])/a),D=d((T[1][0]-m[0])/a),K=d(-(T[1][1]-m[1])/a),V=d((T[2][0]-m[0])/a),$=d(-(T[2][1]-m[1])/a),at=I,w=A;I=0,A=0,P-=at,b-=w,L-=at,j-=w;var ht=[[P,b,0,0,D-N],[L,j,0,0,V-N],[0,0,P,b,K-G],[0,0,L,j,$-G]],U=Iu(ht);if(U){if(f.save(),f.beginPath(),Fy()||!c){f.moveTo(D,K);for(var lt=4,Mt=N-D,Ft=G-K,It=0;It<lt;It++)f.lineTo(D+d((It+1)*Mt/lt),K+d(It*Ft/(lt-1))),It!=lt-1&&f.lineTo(D+d((It+1)*Mt/lt),K+d((It+1)*Ft/(lt-1)));f.lineTo(V,$)}else f.moveTo(D,K),f.lineTo(N,G),f.lineTo(V,$);f.clip(),f.transform(U[0],U[2],U[1],U[3],N,G),f.translate(v[0]-at,v[3]-w),f.scale(i/t,-i/t),f.drawImage(g.canvas,0,0),f.restore()}}),u&&(f.save(),f.globalCompositeOperation="source-over",f.strokeStyle="black",f.lineWidth=1,s.getTriangles().forEach(function(x,E,M){var C=x.target,T=(C[0][0]-m[0])/a,I=-(C[0][1]-m[1])/a,A=(C[1][0]-m[0])/a,P=-(C[1][1]-m[1])/a,b=(C[2][0]-m[0])/a,L=-(C[2][1]-m[1])/a;f.beginPath(),f.moveTo(A,P),f.lineTo(T,I),f.lineTo(b,L),f.closePath(),f.stroke()}),f.restore()),f.canvas}var ky=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),bl=(function(n){ky(e,n);function e(t,i,r,a,o,s,h,l,u,c,f,d){var v=n.call(this,o,k.IDLE,{interpolate:!!d})||this;v.renderEdges_=f!==void 0?f:!1,v.pixelRatio_=h,v.gutter_=l,v.canvas_=null,v.sourceTileGrid_=i,v.targetTileGrid_=a,v.wrappedTileCoord_=s||o,v.sourceTiles_=[],v.sourcesListenerKeys_=null,v.sourceZ_=0;var _=a.getTileCoordExtent(v.wrappedTileCoord_),p=v.targetTileGrid_.getExtent(),g=v.sourceTileGrid_.getExtent(),y=p?Je(_,p):_;if(Ta(y)===0)return v.state=k.EMPTY,v;var m=t.getExtent();m&&(g?g=Je(g,m):g=m);var x=a.getResolution(v.wrappedTileCoord_[0]),E=Gy(t,r,y,x);if(!isFinite(E)||E<=0)return v.state=k.EMPTY,v;var M=c!==void 0?c:Sl;if(v.triangulation_=new Ll(t,r,y,g,E*M,x),v.triangulation_.getTriangles().length===0)return v.state=k.EMPTY,v;v.sourceZ_=i.getZForResolution(E);var C=v.triangulation_.calculateSourceExtent();if(g&&(t.canWrapX()?(C[1]=ut(C[1],g[1],g[3]),C[3]=ut(C[3],g[1],g[3])):C=Je(C,g)),!Ta(C))v.state=k.EMPTY;else{for(var T=i.getTileRangeForExtentAndZ(C,v.sourceZ_),I=T.minX;I<=T.maxX;I++)for(var A=T.minY;A<=T.maxY;A++){var P=u(v.sourceZ_,I,A,h);P&&v.sourceTiles_.push(P)}v.sourceTiles_.length===0&&(v.state=k.EMPTY)}return v}return e.prototype.getImage=function(){return this.canvas_},e.prototype.reproject_=function(){var t=[];if(this.sourceTiles_.forEach((function(u,c,f){u&&u.getState()==k.LOADED&&t.push({extent:this.sourceTileGrid_.getTileCoordExtent(u.tileCoord),image:u.getImage()})}).bind(this)),this.sourceTiles_.length=0,t.length===0)this.state=k.ERROR;else{var i=this.wrappedTileCoord_[0],r=this.targetTileGrid_.getTileSize(i),a=typeof r=="number"?r:r[0],o=typeof r=="number"?r:r[1],s=this.targetTileGrid_.getResolution(i),h=this.sourceTileGrid_.getResolution(this.sourceZ_),l=this.targetTileGrid_.getTileCoordExtent(this.wrappedTileCoord_);this.canvas_=Nl(a,o,this.pixelRatio_,h,this.sourceTileGrid_.getExtent(),s,l,this.triangulation_,t,this.gutter_,this.renderEdges_,this.interpolate),this.state=k.LOADED}this.changed()},e.prototype.load=function(){if(this.state==k.IDLE){this.state=k.LOADING,this.changed();var t=0;this.sourcesListenerKeys_=[],this.sourceTiles_.forEach((function(i,r,a){var o=i.getState();if(o==k.IDLE||o==k.LOADING){t++;var s=Z(i,B.CHANGE,function(h){var l=i.getState();(l==k.LOADED||l==k.ERROR||l==k.EMPTY)&&(rt(s),t--,t===0&&(this.unlistenSources_(),this.reproject_()))},this);this.sourcesListenerKeys_.push(s)}}).bind(this)),t===0?setTimeout(this.reproject_.bind(this),0):this.sourceTiles_.forEach(function(i,r,a){var o=i.getState();o==k.IDLE&&i.load()})}},e.prototype.unlistenSources_=function(){this.sourcesListenerKeys_.forEach(rt),this.sourcesListenerKeys_=null},e})(Al),po=(function(){function n(e,t,i,r){this.minX=e,this.maxX=t,this.minY=i,this.maxY=r}return n.prototype.contains=function(e){return this.containsXY(e[1],e[2])},n.prototype.containsTileRange=function(e){return this.minX<=e.minX&&e.maxX<=this.maxX&&this.minY<=e.minY&&e.maxY<=this.maxY},n.prototype.containsXY=function(e,t){return this.minX<=e&&e<=this.maxX&&this.minY<=t&&t<=this.maxY},n.prototype.equals=function(e){return this.minX==e.minX&&this.minY==e.minY&&this.maxX==e.maxX&&this.maxY==e.maxY},n.prototype.extend=function(e){e.minX<this.minX&&(this.minX=e.minX),e.maxX>this.maxX&&(this.maxX=e.maxX),e.minY<this.minY&&(this.minY=e.minY),e.maxY>this.maxY&&(this.maxY=e.maxY)},n.prototype.getHeight=function(){return this.maxY-this.minY+1},n.prototype.getSize=function(){return[this.getWidth(),this.getHeight()]},n.prototype.getWidth=function(){return this.maxX-this.minX+1},n.prototype.intersects=function(e){return this.minX<=e.maxX&&this.maxX>=e.minX&&this.minY<=e.maxY&&this.maxY>=e.minY},n})();function _i(n,e,t,i,r){return r!==void 0?(r.minX=n,r.maxX=e,r.minY=t,r.maxY=i,r):new po(n,e,t,i)}var zy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),jy=(function(n){zy(e,n);function e(t){var i=n.call(this,t)||this;return i.extentChanged=!0,i.renderedExtent_=null,i.renderedPixelRatio,i.renderedProjection=null,i.renderedRevision,i.renderedTiles=[],i.newTiles_=!1,i.tmpExtent=Wt(),i.tmpTileRange_=new po(0,0,0,0),i}return e.prototype.isDrawableTile=function(t){var i=this.getLayer(),r=t.getState(),a=i.getUseInterimTilesOnError();return r==k.LOADED||r==k.EMPTY||r==k.ERROR&&!a},e.prototype.getTile=function(t,i,r,a){var o=a.pixelRatio,s=a.viewState.projection,h=this.getLayer(),l=h.getSource(),u=l.getTile(t,i,r,o,s);return u.getState()==k.ERROR&&(h.getUseInterimTilesOnError()?h.getPreload()>0&&(this.newTiles_=!0):u.setState(k.LOADED)),this.isDrawableTile(u)||(u=u.getInterimTile()),u},e.prototype.getData=function(t){var i=this.frameState;if(!i)return null;var r=this.getLayer(),a=ft(i.pixelToCoordinateTransform,t.slice()),o=r.getExtent();if(o&&!Ui(o,a))return null;for(var s=i.pixelRatio,h=i.viewState.projection,l=i.viewState,u=r.getRenderSource(),c=u.getTileGridForProjection(l.projection),f=u.getTilePixelRatio(i.pixelRatio),d=c.getZForResolution(l.resolution);d>=c.getMinZoom();--d){var v=c.getTileCoordForCoordAndZ(a,d),_=u.getTile(d,v[1],v[2],s,h);if(!(_ instanceof Pl||_ instanceof bl))return null;if(_.getState()===k.LOADED){var p=c.getOrigin(d),g=Rt(c.getTileSize(d)),y=c.getResolution(d),m=Math.floor(f*((a[0]-p[0])/y-v[1]*g[0])),x=Math.floor(f*((p[1]-a[1])/y-v[2]*g[1]));return this.getImageData(_.getImage(),m,x)}}return null},e.prototype.loadedTileCallback=function(t,i,r){return this.isDrawableTile(r)?n.prototype.loadedTileCallback.call(this,t,i,r):!1},e.prototype.prepareFrame=function(t){return!!this.getLayer().getSource()},e.prototype.renderFrame=function(t,i){var r=t.layerStatesArray[t.layerIndex],a=t.viewState,o=a.projection,s=a.resolution,h=a.center,l=a.rotation,u=t.pixelRatio,c=this.getLayer(),f=c.getSource(),d=f.getRevision(),v=f.getTileGridForProjection(o),_=v.getZForResolution(s,f.zDirection),p=v.getResolution(_),g=t.extent,y=r.extent&&de(r.extent,o);y&&(g=Je(g,de(r.extent,o)));var m=f.getTilePixelRatio(u),x=Math.round(t.size[0]*m),E=Math.round(t.size[1]*m);if(l){var M=Math.round(Math.sqrt(x*x+E*E));x=M,E=M}var C=p*x/2/m,T=p*E/2/m,I=[h[0]-C,h[1]-T,h[0]+C,h[1]+T],A=v.getTileRangeForExtentAndZ(g,_),P={};P[_]={};var b=this.createLoadedTileFinder(f,o,P),L=this.tmpExtent,j=this.tmpTileRange_;this.newTiles_=!1;for(var N=A.minX;N<=A.maxX;++N)for(var G=A.minY;G<=A.maxY;++G){var D=this.getTile(_,N,G,t);if(this.isDrawableTile(D)){var K=H(this);if(D.getState()==k.LOADED){P[_][D.tileCoord.toString()]=D;var V=D.inTransition(K);!this.newTiles_&&(V||this.renderedTiles.indexOf(D)===-1)&&(this.newTiles_=!0)}if(D.getAlpha(K,t.time)===1)continue}var $=v.getTileCoordChildTileRange(D.tileCoord,j,L),at=!1;$&&(at=b(_+1,$)),at||v.forEachTileCoordParentTileRange(D.tileCoord,b,j,L)}var w=p/s;$t(this.pixelTransform,t.size[0]/2,t.size[1]/2,1/m,1/m,l,-x/2,-E/2);var ht=Za(this.pixelTransform);this.useContainer(i,ht,r.opacity,this.getBackground(t));var U=this.context,lt=U.canvas;Wr(this.inversePixelTransform,this.pixelTransform),$t(this.tempTransform,x/2,E/2,w,w,0,-x/2,-E/2),lt.width!=x||lt.height!=E?(lt.width=x,lt.height=E):this.containerReused||U.clearRect(0,0,x,E),y&&this.clipUnrotated(U,t,y),f.getInterpolate()||it(U,Nr),this.preRender(U,t),this.renderedTiles.length=0;var Mt=Object.keys(P).map(Number);Mt.sort(Li);var Ft,It,Gt;r.opacity===1&&(!this.containerReused||f.getOpaque(t.viewState.projection))?Mt=Mt.reverse():(Ft=[],It=[]);for(var si=Mt.length-1;si>=0;--si){var Ht=Mt[si],Bn=f.getTilePixelSize(Ht,u,o),Wn=v.getResolution(Ht),ge=Wn/p,hi=Bn[0]*ge*w,Xn=Bn[1]*ge*w,Xi=v.getTileCoordForCoordAndZ(oi(I),Ht),Yn=v.getTileCoordExtent(Xi),Ue=ft(this.tempTransform,[m*(Yn[0]-I[0])/p,m*(I[3]-Yn[3])/p]),Yi=m*f.getGutterForProjection(o),Vn=P[Ht];for(var li in Vn){var D=Vn[li],ye=D.tileCoord,ui=Xi[1]-ye[1],Kr=Math.round(Ue[0]-(ui-1)*hi),qn=Xi[2]-ye[2],Vi=Math.round(Ue[1]-(qn-1)*Xn),N=Math.round(Ue[0]-ui*hi),G=Math.round(Ue[1]-qn*Xn),he=Kr-N,Jt=Vi-G,Be=_===Ht,V=Be&&D.getAlpha(H(this),t.time)!==1,qi=!1;if(!V)if(Ft){Gt=[N,G,N+he,G,N+he,G+Jt,N,G+Jt];for(var St=0,Kn=Ft.length;St<Kn;++St)if(_!==Ht&&Ht<It[St]){var pt=Ft[St];Ct([N,G,N+he,G+Jt],[pt[0],pt[3],pt[4],pt[7]])&&(qi||(U.save(),qi=!0),U.beginPath(),U.moveTo(Gt[0],Gt[1]),U.lineTo(Gt[2],Gt[3]),U.lineTo(Gt[4],Gt[5]),U.lineTo(Gt[6],Gt[7]),U.moveTo(pt[6],pt[7]),U.lineTo(pt[4],pt[5]),U.lineTo(pt[2],pt[3]),U.lineTo(pt[0],pt[1]),U.clip())}Ft.push(Gt),It.push(Ht)}else U.clearRect(N,G,he,Jt);this.drawTileImage(D,t,N,G,he,Jt,Yi,Be),Ft&&!V?(qi&&U.restore(),this.renderedTiles.unshift(D)):this.renderedTiles.push(D),this.updateUsedTiles(t.usedTiles,f,D)}}this.renderedRevision=d,this.renderedResolution=p,this.extentChanged=!this.renderedExtent_||!Di(this.renderedExtent_,I),this.renderedExtent_=I,this.renderedPixelRatio=u,this.renderedProjection=o,this.manageTilePyramid(t,f,v,u,o,g,_,c.getPreload()),this.scheduleExpireCache(t,f),this.postRender(U,t),r.extent&&U.restore(),it(U,Ol),ht!==lt.style.transform&&(lt.style.transform=ht);var fi=Qs(r.opacity),We=this.container;return fi!==We.style.opacity&&(We.style.opacity=fi),this.container},e.prototype.drawTileImage=function(t,i,r,a,o,s,h,l){var u=this.getTileImage(t);if(u){var c=H(this),f=l?t.getAlpha(c,i.time):1,d=f!==this.context.globalAlpha;d&&(this.context.save(),this.context.globalAlpha=f),this.context.drawImage(u,h,h,u.width-2*h,u.height-2*h,r,a,o,s),d&&this.context.restore(),f!==1?i.animate=!0:l&&t.endTransition(c)}},e.prototype.getImage=function(){var t=this.context;return t?t.canvas:null},e.prototype.getTileImage=function(t){return t.getImage()},e.prototype.scheduleExpireCache=function(t,i){if(i.canExpireCache()){var r=(function(a,o,s){var h=H(a);h in s.usedTiles&&a.expireCache(s.viewState.projection,s.usedTiles[h])}).bind(null,i);t.postRenderFunctions.push(r)}},e.prototype.updateUsedTiles=function(t,i,r){var a=H(i);a in t||(t[a]={}),t[a][r.getKey()]=!0},e.prototype.manageTilePyramid=function(t,i,r,a,o,s,h,l,u){var c=H(i);c in t.wantedTiles||(t.wantedTiles[c]={});var f=t.wantedTiles[c],d=t.tileQueue,v=r.getMinZoom(),_=0,p,g,y,m,x,E;for(E=v;E<=h;++E)for(g=r.getTileRangeForExtentAndZ(s,E,g),y=r.getResolution(E),m=g.minX;m<=g.maxX;++m)for(x=g.minY;x<=g.maxY;++x)h-E<=l?(++_,p=i.getTile(E,m,x,a,o),p.getState()==k.IDLE&&(f[p.getKey()]=!0,d.isKeyQueued(p.getKey())||d.enqueue([p,c,r.getTileCoordCenter(p.tileCoord),y])),u!==void 0&&u(p)):i.useTile(E,m,x,o);i.updateCacheSize(_,o)},e})(ao),Uy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),By=(function(n){Uy(e,n);function e(t){return n.call(this,t)||this}return e.prototype.createRenderer=function(){return new jy(this)},e})(Py);/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function br(n){return[n.x,n.y]}function Wy(n){return[n.width,n.height]}function Ga(n){return n.toLowerCase().replace(/_/,"-")}function Dl(n,e,t){if(!(e.length!==n.getLength()||n.getArray().some((a,o)=>a.id!==e[o])))return;const r=e.map(a=>t.lookup.get(a)).filter(a=>!!a);n.clear(),r.forEach(a=>n.push(a))}function pe(n){const e={...n};return Object.keys(n).forEach(t=>{n[t]===null&&delete e[t]}),e}/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function go(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/layer/Layer");return n.setOpacity(e.opacity),n.setVisible(e.visible),n.setZIndex(e.zIndex||void 0),n.setMinZoom(e.minZoom||-1/0),n.setMaxZoom(e.maxZoom||1/0),n.setBackground(e.background||void 0),n}function Xy(n,e,t){return n||(n=new By(pe({...e,source:t.lookup.get(e.source)}))),go(n,e),n.setSource(t.lookup.get(e.source)),n}function Yy(n,e,t){return n||(n=new pv(pe({...e,source:t.lookup.get(e.source)}))),go(n,e),n.setSource(t.lookup.get(e.source)),n}function Vy(n,e,t){return n||(n=new Oy(pe({...e,source:t.lookup.get(e.source)}))),go(n,e),n.setSource(t.lookup.get(e.source)),n}var Ne="1.3.0",qy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Ky=(function(n){qy(e,n);function e(t,i,r,a,o,s,h){var l=this,u=t.getExtent(),c=i.getExtent(),f=c?Je(r,c):r,d=Ge(f),v=On(t,i,d,a),_=Sl,p=new Ll(t,i,f,u,v*_,a),g=p.calculateSourceExtent(),y=s(g,v,o),m=y?X.IDLE:X.EMPTY,x=y?y.getPixelRatio():1;return l=n.call(this,r,a,x,m)||this,l.targetProj_=i,l.maxSourceExtent_=u,l.triangulation_=p,l.targetResolution_=a,l.targetExtent_=r,l.sourceImage_=y,l.sourcePixelRatio_=x,l.interpolate_=h,l.canvas_=null,l.sourceListenerKey_=null,l}return e.prototype.disposeInternal=function(){this.state==X.LOADING&&this.unlistenSource_(),n.prototype.disposeInternal.call(this)},e.prototype.getImage=function(){return this.canvas_},e.prototype.getProjection=function(){return this.targetProj_},e.prototype.reproject_=function(){var t=this.sourceImage_.getState();if(t==X.LOADED){var i=et(this.targetExtent_)/this.targetResolution_,r=Et(this.targetExtent_)/this.targetResolution_;this.canvas_=Nl(i,r,this.sourcePixelRatio_,this.sourceImage_.getResolution(),this.maxSourceExtent_,this.targetResolution_,this.targetExtent_,this.triangulation_,[{extent:this.sourceImage_.getExtent(),image:this.sourceImage_.getImage()}],0,void 0,this.interpolate_)}this.state=t,this.changed()},e.prototype.load=function(){if(this.state==X.IDLE){this.state=X.LOADING,this.changed();var t=this.sourceImage_.getState();t==X.LOADED||t==X.ERROR?this.reproject_():(this.sourceListenerKey_=Z(this.sourceImage_,B.CHANGE,function(i){var r=this.sourceImage_.getState();(r==X.LOADED||r==X.ERROR)&&(this.unlistenSource_(),this.reproject_())},this),this.sourceImage_.load())}},e.prototype.unlistenSource_=function(){rt(this.sourceListenerKey_),this.sourceListenerKey_=null},e})($h),Fl=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),ga={IMAGELOADSTART:"imageloadstart",IMAGELOADEND:"imageloadend",IMAGELOADERROR:"imageloaderror"},$y=(function(n){Fl(e,n);function e(t,i){var r=n.call(this,t)||this;return r.image=i,r}return e})(Zt),Zy=(function(n){Fl(e,n);function e(t){var i=this,r=t.imageSmoothing!==void 0?t.imageSmoothing:!0;return t.interpolate!==void 0&&(r=t.interpolate),i=n.call(this,{attributions:t.attributions,projection:t.projection,state:t.state,interpolate:r})||this,i.on,i.once,i.un,i.resolutions_=t.resolutions!==void 0?t.resolutions:null,i.reprojectedImage_=null,i.reprojectedRevision_=0,i}return e.prototype.getResolutions=function(){return this.resolutions_},e.prototype.findNearestResolution=function(t){if(this.resolutions_){var i=Fr(this.resolutions_,t,0);t=this.resolutions_[i]}return t},e.prototype.getImage=function(t,i,r,a){var o=this.getProjection();if(!o||!a||Se(o,a))return o&&(a=o),this.getImageInternal(t,i,r,a);if(this.reprojectedImage_){if(this.reprojectedRevision_==this.getRevision()&&Se(this.reprojectedImage_.getProjection(),a)&&this.reprojectedImage_.getResolution()==i&&Di(this.reprojectedImage_.getExtent(),t))return this.reprojectedImage_;this.reprojectedImage_.dispose(),this.reprojectedImage_=null}return this.reprojectedImage_=new Ky(o,a,t,i,r,(function(s,h,l){return this.getImageInternal(s,h,l,o)}).bind(this),this.getInterpolate()),this.reprojectedRevision_=this.getRevision(),this.reprojectedImage_},e.prototype.getImageInternal=function(t,i,r,a){return q()},e.prototype.handleImageChange=function(t){var i=t.target,r;switch(i.getState()){case X.LOADING:this.loading=!0,r=ga.IMAGELOADSTART;break;case X.LOADED:this.loading=!1,r=ga.IMAGELOADEND;break;case X.ERROR:this.loading=!1,r=ga.IMAGELOADERROR;break;default:return}this.hasListener(r)&&this.dispatchEvent(new $y(r,i))},e})(so);function Hy(n,e){n.getImage().src=e}const be={CARMENTA_SERVER:"carmentaserver",GEOSERVER:"geoserver",MAPSERVER:"mapserver",QGIS:"qgis"};function Dr(n,e){var t=[];Object.keys(e).forEach(function(r){e[r]!==null&&e[r]!==void 0&&t.push(r+"="+encodeURIComponent(e[r]))});var i=t.join("&");return n=n.replace(/[?&]$/,""),n=n.indexOf("?")===-1?n+"?":n+"&",n+i}var Jy=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Te=4,Us=[101,101],Qy=(function(n){Jy(e,n);function e(t){var i=this,r=t||{},a=r.imageSmoothing!==void 0?r.imageSmoothing:!0;return r.interpolate!==void 0&&(a=r.interpolate),i=n.call(this,{attributions:r.attributions,interpolate:a,projection:r.projection,resolutions:r.resolutions})||this,i.crossOrigin_=r.crossOrigin!==void 0?r.crossOrigin:null,i.url_=r.url,i.imageLoadFunction_=r.imageLoadFunction!==void 0?r.imageLoadFunction:Hy,i.params_=r.params||{},i.v13_=!0,i.updateV13_(),i.serverType_=r.serverType,i.hidpi_=r.hidpi!==void 0?r.hidpi:!0,i.image_=null,i.imageSize_=[0,0],i.renderedRevision_=0,i.ratio_=r.ratio!==void 0?r.ratio:1.5,i}return e.prototype.getFeatureInfoUrl=function(t,i,r,a){if(this.url_!==void 0){var o=dt(r),s=this.getProjection();s&&s!==o&&(i=On(s,o,t,i),t=bn(t,o,s));var h=Si(t,i,0,Us),l={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetFeatureInfo",FORMAT:"image/png",TRANSPARENT:!0,QUERY_LAYERS:this.params_.LAYERS};it(l,this.params_,a);var u=mi((t[0]-h[0])/i,Te),c=mi((h[3]-t[1])/i,Te);return l[this.v13_?"I":"X"]=u,l[this.v13_?"J":"Y"]=c,this.getRequestUrl_(h,Us,1,s||o,l)}},e.prototype.getLegendUrl=function(t,i){if(this.url_!==void 0){var r={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetLegendGraphic",FORMAT:"image/png"};if(i===void 0||i.LAYER===void 0){var a=this.params_.LAYERS,o=!Array.isArray(a)||a.length===1;if(!o)return;r.LAYER=a}if(t!==void 0){var s=this.getProjection()?this.getProjection().getMetersPerUnit():1,h=28e-5;r.SCALE=t*s/h}return it(r,i),Dr(this.url_,r)}},e.prototype.getParams=function(){return this.params_},e.prototype.getImageInternal=function(t,i,r,a){if(this.url_===void 0)return null;i=this.findNearestResolution(i),r!=1&&(!this.hidpi_||this.serverType_===void 0)&&(r=1);var o=i/r,s=Ge(t),h=Ae(et(t)/o,Te),l=Ae(Et(t)/o,Te),u=Si(s,o,0,[h,l]),c=Ae(this.ratio_*et(t)/o,Te),f=Ae(this.ratio_*Et(t)/o,Te),d=Si(s,o,0,[c,f]),v=this.image_;if(v&&this.renderedRevision_==this.getRevision()&&v.getResolution()==i&&v.getPixelRatio()==r&&Pe(v.getExtent(),u))return v;var _={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetMap",FORMAT:"image/png",TRANSPARENT:!0};it(_,this.params_),this.imageSize_[0]=No(et(d)/o,Te),this.imageSize_[1]=No(Et(d)/o,Te);var p=this.getRequestUrl_(d,this.imageSize_,r,a,_);return this.image_=new qd(d,i,r,p,this.crossOrigin_,this.imageLoadFunction_),this.renderedRevision_=this.getRevision(),this.image_.addEventListener(B.CHANGE,this.handleImageChange.bind(this)),this.image_},e.prototype.getImageLoadFunction=function(){return this.imageLoadFunction_},e.prototype.getRequestUrl_=function(t,i,r,a,o){if(Y(this.url_!==void 0,9),o[this.v13_?"CRS":"SRS"]=a.getCode(),"STYLES"in this.params_||(o.STYLES=""),r!=1)switch(this.serverType_){case be.GEOSERVER:var s=90*r+.5|0;"FORMAT_OPTIONS"in o?o.FORMAT_OPTIONS+=";dpi:"+s:o.FORMAT_OPTIONS="dpi:"+s;break;case be.MAPSERVER:o.MAP_RESOLUTION=90*r;break;case be.CARMENTA_SERVER:case be.QGIS:o.DPI=90*r;break;default:Y(!1,8);break}o.WIDTH=i[0],o.HEIGHT=i[1];var h=a.getAxisOrientation(),l;return this.v13_&&h.substr(0,2)=="ne"?l=[t[1],t[0],t[3],t[2]]:l=t,o.BBOX=l.join(","),Dr(this.url_,o)},e.prototype.getUrl=function(){return this.url_},e.prototype.setImageLoadFunction=function(t){this.image_=null,this.imageLoadFunction_=t,this.changed()},e.prototype.setUrl=function(t){t!=this.url_&&(this.url_=t,this.image_=null,this.changed())},e.prototype.updateParams=function(t){it(this.params_,t),this.updateV13_(),this.image_=null,this.changed()},e.prototype.updateV13_=function(){var t=this.params_.VERSION||Ne;this.v13_=uh(t,"1.3")>=0},e})(Zy),tm=(function(){function n(e){this.highWaterMark=e!==void 0?e:2048,this.count_=0,this.entries_={},this.oldest_=null,this.newest_=null}return n.prototype.canExpireCache=function(){return this.highWaterMark>0&&this.getCount()>this.highWaterMark},n.prototype.expireCache=function(e){for(;this.canExpireCache();)this.pop()},n.prototype.clear=function(){this.count_=0,this.entries_={},this.oldest_=null,this.newest_=null},n.prototype.containsKey=function(e){return this.entries_.hasOwnProperty(e)},n.prototype.forEach=function(e){for(var t=this.oldest_;t;)e(t.value_,t.key_,this),t=t.newer},n.prototype.get=function(e,t){var i=this.entries_[e];return Y(i!==void 0,15),i===this.newest_||(i===this.oldest_?(this.oldest_=this.oldest_.newer,this.oldest_.older=null):(i.newer.older=i.older,i.older.newer=i.newer),i.newer=null,i.older=this.newest_,this.newest_.newer=i,this.newest_=i),i.value_},n.prototype.remove=function(e){var t=this.entries_[e];return Y(t!==void 0,15),t===this.newest_?(this.newest_=t.older,this.newest_&&(this.newest_.newer=null)):t===this.oldest_?(this.oldest_=t.newer,this.oldest_&&(this.oldest_.older=null)):(t.newer.older=t.older,t.older.newer=t.newer),delete this.entries_[e],--this.count_,t.value_},n.prototype.getCount=function(){return this.count_},n.prototype.getKeys=function(){var e=new Array(this.count_),t=0,i;for(i=this.newest_;i;i=i.older)e[t++]=i.key_;return e},n.prototype.getValues=function(){var e=new Array(this.count_),t=0,i;for(i=this.newest_;i;i=i.older)e[t++]=i.value_;return e},n.prototype.peekLast=function(){return this.oldest_.value_},n.prototype.peekLastKey=function(){return this.oldest_.key_},n.prototype.peekFirstKey=function(){return this.newest_.key_},n.prototype.pop=function(){var e=this.oldest_;return delete this.entries_[e.key_],e.newer&&(e.newer.older=null),this.oldest_=e.newer,this.oldest_||(this.newest_=null),--this.count_,e.value_},n.prototype.replace=function(e,t){this.get(e),this.entries_[e].value_=t},n.prototype.set=function(e,t){Y(!(e in this.entries_),16);var i={key_:e,newer:null,older:this.newest_,value_:t};this.newest_?this.newest_.newer=i:this.oldest_=i,this.newest_=i,this.entries_[e]=i,++this.count_},n.prototype.setSize=function(e){this.highWaterMark=e},n})();function Bs(n,e,t,i){return i!==void 0?(i[0]=n,i[1]=e,i[2]=t,i):[n,e,t]}function qr(n,e,t){return n+"/"+e+"/"+t}function Gl(n){return qr(n[0],n[1],n[2])}function em(n){return n.split("/").map(Number)}function kl(n){return(n[1]<<n[0])+n[2]}function im(n,e){var t=n[0],i=n[1],r=n[2];if(e.getMinZoom()>t||t>e.getMaxZoom())return!1;var a=e.getFullTileRange(t);return a?a.containsXY(i,r):!0}var nm=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),zl=(function(n){nm(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.expireCache=function(t){for(;this.canExpireCache();){var i=this.peekLast();if(i.getKey()in t)break;this.pop().release()}},e.prototype.pruneExceptNewestZ=function(){if(this.getCount()!==0){var t=this.peekFirstKey(),i=em(t),r=i[0];this.forEach((function(a){a.tileCoord[0]!==r&&(this.remove(Gl(a.tileCoord)),a.release())}).bind(this))}},e})(tm);const ya={TILELOADSTART:"tileloadstart",TILELOADEND:"tileloadend",TILELOADERROR:"tileloaderror"};var rm=[0,0,0],Ce=5,jl=(function(){function n(e){this.minZoom=e.minZoom!==void 0?e.minZoom:0,this.resolutions_=e.resolutions,Y(hu(this.resolutions_,function(o,s){return s-o}),17);var t;if(!e.origins){for(var i=0,r=this.resolutions_.length-1;i<r;++i)if(!t)t=this.resolutions_[i]/this.resolutions_[i+1];else if(this.resolutions_[i]/this.resolutions_[i+1]!==t){t=void 0;break}}this.zoomFactor_=t,this.maxZoom=this.resolutions_.length-1,this.origin_=e.origin!==void 0?e.origin:null,this.origins_=null,e.origins!==void 0&&(this.origins_=e.origins,Y(this.origins_.length==this.resolutions_.length,20));var a=e.extent;a!==void 0&&!this.origin_&&!this.origins_&&(this.origin_=oi(a)),Y(!this.origin_&&this.origins_||this.origin_&&!this.origins_,18),this.tileSizes_=null,e.tileSizes!==void 0&&(this.tileSizes_=e.tileSizes,Y(this.tileSizes_.length==this.resolutions_.length,19)),this.tileSize_=e.tileSize!==void 0?e.tileSize:this.tileSizes_?null:Ha,Y(!this.tileSize_&&this.tileSizes_||this.tileSize_&&!this.tileSizes_,22),this.extent_=a!==void 0?a:null,this.fullTileRanges_=null,this.tmpSize_=[0,0],this.tmpExtent_=[0,0,0,0],e.sizes!==void 0?this.fullTileRanges_=e.sizes.map(function(o,s){var h=new po(Math.min(0,o[0]),Math.max(o[0]-1,-1),Math.min(0,o[1]),Math.max(o[1]-1,-1));if(a){var l=this.getTileRangeForExtentAndZ(a,s);h.minX=Math.max(l.minX,h.minX),h.maxX=Math.min(l.maxX,h.maxX),h.minY=Math.max(l.minY,h.minY),h.maxY=Math.min(l.maxY,h.maxY)}return h},this):a&&this.calculateTileRanges_(a)}return n.prototype.forEachTileCoord=function(e,t,i){for(var r=this.getTileRangeForExtentAndZ(e,t),a=r.minX,o=r.maxX;a<=o;++a)for(var s=r.minY,h=r.maxY;s<=h;++s)i([t,a,s])},n.prototype.forEachTileCoordParentTileRange=function(e,t,i,r){var a,o,s,h=null,l=e[0]-1;for(this.zoomFactor_===2?(o=e[1],s=e[2]):h=this.getTileCoordExtent(e,r);l>=this.minZoom;){if(this.zoomFactor_===2?(o=Math.floor(o/2),s=Math.floor(s/2),a=_i(o,o,s,s,i)):a=this.getTileRangeForExtentAndZ(h,l,i),t(l,a))return!0;--l}return!1},n.prototype.getExtent=function(){return this.extent_},n.prototype.getMaxZoom=function(){return this.maxZoom},n.prototype.getMinZoom=function(){return this.minZoom},n.prototype.getOrigin=function(e){return this.origin_?this.origin_:this.origins_[e]},n.prototype.getResolution=function(e){return this.resolutions_[e]},n.prototype.getResolutions=function(){return this.resolutions_},n.prototype.getTileCoordChildTileRange=function(e,t,i){if(e[0]<this.maxZoom){if(this.zoomFactor_===2){var r=e[1]*2,a=e[2]*2;return _i(r,r+1,a,a+1,t)}var o=this.getTileCoordExtent(e,i||this.tmpExtent_);return this.getTileRangeForExtentAndZ(o,e[0]+1,t)}return null},n.prototype.getTileRangeForTileCoordAndZ=function(e,t,i){if(t>this.maxZoom||t<this.minZoom)return null;var r=e[0],a=e[1],o=e[2];if(t===r)return _i(a,o,a,o,i);if(this.zoomFactor_){var s=Math.pow(this.zoomFactor_,t-r),h=Math.floor(a*s),l=Math.floor(o*s);if(t<r)return _i(h,h,l,l,i);var u=Math.floor(s*(a+1))-1,c=Math.floor(s*(o+1))-1;return _i(h,u,l,c,i)}var f=this.getTileCoordExtent(e,this.tmpExtent_);return this.getTileRangeForExtentAndZ(f,t,i)},n.prototype.getTileRangeExtent=function(e,t,i){var r=this.getOrigin(e),a=this.getResolution(e),o=Rt(this.getTileSize(e),this.tmpSize_),s=r[0]+t.minX*o[0]*a,h=r[0]+(t.maxX+1)*o[0]*a,l=r[1]+t.minY*o[1]*a,u=r[1]+(t.maxY+1)*o[1]*a;return ae(s,l,h,u,i)},n.prototype.getTileRangeForExtentAndZ=function(e,t,i){var r=rm;this.getTileCoordForXYAndZ_(e[0],e[3],t,!1,r);var a=r[1],o=r[2];return this.getTileCoordForXYAndZ_(e[2],e[1],t,!0,r),_i(a,r[1],o,r[2],i)},n.prototype.getTileCoordCenter=function(e){var t=this.getOrigin(e[0]),i=this.getResolution(e[0]),r=Rt(this.getTileSize(e[0]),this.tmpSize_);return[t[0]+(e[1]+.5)*r[0]*i,t[1]-(e[2]+.5)*r[1]*i]},n.prototype.getTileCoordExtent=function(e,t){var i=this.getOrigin(e[0]),r=this.getResolution(e[0]),a=Rt(this.getTileSize(e[0]),this.tmpSize_),o=i[0]+e[1]*a[0]*r,s=i[1]-(e[2]+1)*a[1]*r,h=o+a[0]*r,l=s+a[1]*r;return ae(o,s,h,l,t)},n.prototype.getTileCoordForCoordAndResolution=function(e,t,i){return this.getTileCoordForXYAndResolution_(e[0],e[1],t,!1,i)},n.prototype.getTileCoordForXYAndResolution_=function(e,t,i,r,a){var o=this.getZForResolution(i),s=i/this.getResolution(o),h=this.getOrigin(o),l=Rt(this.getTileSize(o),this.tmpSize_),u=s*(e-h[0])/i/l[0],c=s*(h[1]-t)/i/l[1];return r?(u=Ae(u,Ce)-1,c=Ae(c,Ce)-1):(u=mi(u,Ce),c=mi(c,Ce)),Bs(o,u,c,a)},n.prototype.getTileCoordForXYAndZ_=function(e,t,i,r,a){var o=this.getOrigin(i),s=this.getResolution(i),h=Rt(this.getTileSize(i),this.tmpSize_),l=(e-o[0])/s/h[0],u=(o[1]-t)/s/h[1];return r?(l=Ae(l,Ce)-1,u=Ae(u,Ce)-1):(l=mi(l,Ce),u=mi(u,Ce)),Bs(i,l,u,a)},n.prototype.getTileCoordForCoordAndZ=function(e,t,i){return this.getTileCoordForXYAndZ_(e[0],e[1],t,!1,i)},n.prototype.getTileCoordResolution=function(e){return this.resolutions_[e[0]]},n.prototype.getTileSize=function(e){return this.tileSize_?this.tileSize_:this.tileSizes_[e]},n.prototype.getFullTileRange=function(e){return this.fullTileRanges_?this.fullTileRanges_[e]:this.extent_?this.getTileRangeForExtentAndZ(this.extent_,e):null},n.prototype.getZForResolution=function(e,t){var i=Fr(this.resolutions_,e,t||0);return ut(i,this.minZoom,this.maxZoom)},n.prototype.calculateTileRanges_=function(e){for(var t=this.resolutions_.length,i=new Array(t),r=this.minZoom;r<t;++r)i[r]=this.getTileRangeForExtentAndZ(e,r);this.fullTileRanges_=i},n})();function Ul(n){var e=n.getDefaultTileGrid();return e||(e=hm(n),n.setDefaultTileGrid(e)),e}function am(n,e,t){var i=e[0],r=n.getTileCoordCenter(e),a=yo(t);if(Ui(a,r))return e;var o=et(a),s=Math.ceil((a[0]-r[0])/o);return r[0]+=o*s,n.getTileCoordForCoordAndZ(r,i)}function om(n,e,t,i){var r=Bl(n,e,t);return new jl({extent:n,origin:Qu(n),resolutions:r,tileSize:t})}function sm(n){var e=n||{},t=e.extent||dt("EPSG:3857").getExtent(),i={extent:t,minZoom:e.minZoom,tileSize:e.tileSize,resolutions:Bl(t,e.maxZoom,e.tileSize,e.maxResolution)};return new jl(i)}function Bl(n,e,t,i){for(var r=e!==void 0?e:Xf,a=Et(n),o=et(n),s=Rt(t!==void 0?t:Ha),h=i>0?i:Math.max(o/s[0],a/s[1]),l=r+1,u=new Array(l),c=0;c<l;++c)u[c]=h/Math.pow(2,c);return u}function hm(n,e,t,i){var r=yo(n);return om(r,e,t)}function yo(n){n=dt(n);var e=n.getExtent();if(!e){var t=180*re[Nt.DEGREES]/n.getMetersPerUnit();e=ae(-t,-t,t,t)}return e}var Wl=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),lm=(function(n){Wl(e,n);function e(t){var i=n.call(this,{attributions:t.attributions,attributionsCollapsible:t.attributionsCollapsible,projection:t.projection,state:t.state,wrapX:t.wrapX,interpolate:t.interpolate})||this;i.on,i.once,i.un,i.opaque_=t.opaque!==void 0?t.opaque:!1,i.tilePixelRatio_=t.tilePixelRatio!==void 0?t.tilePixelRatio:1,i.tileGrid=t.tileGrid!==void 0?t.tileGrid:null;var r=[256,256];return i.tileGrid&&Rt(i.tileGrid.getTileSize(i.tileGrid.getMinZoom()),r),i.tileCache=new zl(t.cacheSize||0),i.tmpSize=[0,0],i.key_=t.key||"",i.tileOptions={transition:t.transition,interpolate:t.interpolate},i.zDirection=t.zDirection?t.zDirection:0,i}return e.prototype.canExpireCache=function(){return this.tileCache.canExpireCache()},e.prototype.expireCache=function(t,i){var r=this.getTileCacheForProjection(t);r&&r.expireCache(i)},e.prototype.forEachLoadedTile=function(t,i,r,a){var o=this.getTileCacheForProjection(t);if(!o)return!1;for(var s=!0,h,l,u,c=r.minX;c<=r.maxX;++c)for(var f=r.minY;f<=r.maxY;++f)l=qr(i,c,f),u=!1,o.containsKey(l)&&(h=o.get(l),u=h.getState()===k.LOADED,u&&(u=a(h)!==!1)),u||(s=!1);return s},e.prototype.getGutterForProjection=function(t){return 0},e.prototype.getKey=function(){return this.key_},e.prototype.setKey=function(t){this.key_!==t&&(this.key_=t,this.changed())},e.prototype.getOpaque=function(t){return this.opaque_},e.prototype.getResolutions=function(){return this.tileGrid?this.tileGrid.getResolutions():null},e.prototype.getTile=function(t,i,r,a,o){return q()},e.prototype.getTileGrid=function(){return this.tileGrid},e.prototype.getTileGridForProjection=function(t){return this.tileGrid?this.tileGrid:Ul(t)},e.prototype.getTileCacheForProjection=function(t){return Y(Se(this.getProjection(),t),68),this.tileCache},e.prototype.getTilePixelRatio=function(t){return this.tilePixelRatio_},e.prototype.getTilePixelSize=function(t,i,r){var a=this.getTileGridForProjection(r),o=this.getTilePixelRatio(i),s=Rt(a.getTileSize(t),this.tmpSize);return o==1?s:Nh(s,o,this.tmpSize)},e.prototype.getTileCoordForTileUrlFunction=function(t,i){var r=i!==void 0?i:this.getProjection(),a=this.getTileGridForProjection(r);return this.getWrapX()&&r.isGlobal()&&(t=am(a,t,r)),im(t,a)?t:null},e.prototype.clear=function(){this.tileCache.clear()},e.prototype.refresh=function(){this.clear(),n.prototype.refresh.call(this)},e.prototype.updateCacheSize=function(t,i){var r=this.getTileCacheForProjection(i);t>r.highWaterMark&&(r.highWaterMark=t)},e.prototype.useTile=function(t,i,r,a){},e})(so),um=(function(n){Wl(e,n);function e(t,i){var r=n.call(this,t)||this;return r.tile=i,r}return e})(Zt);function fm(n,e){var t=/\{z\}/g,i=/\{x\}/g,r=/\{y\}/g,a=/\{-y\}/g;return(function(o,s,h){if(o)return n.replace(t,o[0].toString()).replace(i,o[1].toString()).replace(r,o[2].toString()).replace(a,function(){var l=o[0],u=e.getFullTileRange(l);Y(u,55);var c=u.getHeight()-o[2]-1;return c.toString()})})}function cm(n,e){for(var t=n.length,i=new Array(t),r=0;r<t;++r)i[r]=fm(n[r],e);return dm(i)}function dm(n){return n.length===1?n[0]:(function(e,t,i){if(e){var r=kl(e),a=He(r,n.length);return n[a](e,t,i)}else return})}function vm(n){var e=[],t=/\{([a-z])-([a-z])\}/.exec(n);if(t){var i=t[1].charCodeAt(0),r=t[2].charCodeAt(0),a=void 0;for(a=i;a<=r;++a)e.push(n.replace(t[0],String.fromCharCode(a)));return e}if(t=/\{(\d+)-(\d+)\}/.exec(n),t){for(var o=parseInt(t[2],10),s=parseInt(t[1],10);s<=o;s++)e.push(n.replace(t[0],s.toString()));return e}return e.push(n),e}var _m=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),pm=(function(n){_m(e,n);function e(t){var i=n.call(this,{attributions:t.attributions,cacheSize:t.cacheSize,opaque:t.opaque,projection:t.projection,state:t.state,tileGrid:t.tileGrid,tilePixelRatio:t.tilePixelRatio,wrapX:t.wrapX,transition:t.transition,interpolate:t.interpolate,key:t.key,attributionsCollapsible:t.attributionsCollapsible,zDirection:t.zDirection})||this;return i.generateTileUrlFunction_=i.tileUrlFunction===e.prototype.tileUrlFunction,i.tileLoadFunction=t.tileLoadFunction,t.tileUrlFunction&&(i.tileUrlFunction=t.tileUrlFunction),i.urls=null,t.urls?i.setUrls(t.urls):t.url&&i.setUrl(t.url),i.tileLoadingKeys_={},i}return e.prototype.getTileLoadFunction=function(){return this.tileLoadFunction},e.prototype.getTileUrlFunction=function(){return Object.getPrototypeOf(this).tileUrlFunction===this.tileUrlFunction?this.tileUrlFunction.bind(this):this.tileUrlFunction},e.prototype.getUrls=function(){return this.urls},e.prototype.handleTileChange=function(t){var i=t.target,r=H(i),a=i.getState(),o;a==k.LOADING?(this.tileLoadingKeys_[r]=!0,o=ya.TILELOADSTART):r in this.tileLoadingKeys_&&(delete this.tileLoadingKeys_[r],o=a==k.ERROR?ya.TILELOADERROR:a==k.LOADED?ya.TILELOADEND:void 0),o!=null&&this.dispatchEvent(new um(o,i))},e.prototype.setTileLoadFunction=function(t){this.tileCache.clear(),this.tileLoadFunction=t,this.changed()},e.prototype.setTileUrlFunction=function(t,i){this.tileUrlFunction=t,this.tileCache.pruneExceptNewestZ(),typeof i<"u"?this.setKey(i):this.changed()},e.prototype.setUrl=function(t){var i=vm(t);this.urls=i,this.setUrls(i)},e.prototype.setUrls=function(t){this.urls=t;var i=t.join(`
`);this.generateTileUrlFunction_?this.setTileUrlFunction(cm(t,this.tileGrid),i):this.setKey(i)},e.prototype.tileUrlFunction=function(t,i,r){},e.prototype.useTile=function(t,i,r){var a=qr(t,i,r);this.tileCache.containsKey(a)&&this.tileCache.get(a)},e})(lm),gm=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Xl=(function(n){gm(e,n);function e(t){var i=this,r=t.imageSmoothing!==void 0?t.imageSmoothing:!0;return t.interpolate!==void 0&&(r=t.interpolate),i=n.call(this,{attributions:t.attributions,cacheSize:t.cacheSize,opaque:t.opaque,projection:t.projection,state:t.state,tileGrid:t.tileGrid,tileLoadFunction:t.tileLoadFunction?t.tileLoadFunction:ym,tilePixelRatio:t.tilePixelRatio,tileUrlFunction:t.tileUrlFunction,url:t.url,urls:t.urls,wrapX:t.wrapX,transition:t.transition,interpolate:r,key:t.key,attributionsCollapsible:t.attributionsCollapsible,zDirection:t.zDirection})||this,i.crossOrigin=t.crossOrigin!==void 0?t.crossOrigin:null,i.tileClass=t.tileClass!==void 0?t.tileClass:Pl,i.tileCacheForProjection={},i.tileGridForProjection={},i.reprojectionErrorThreshold_=t.reprojectionErrorThreshold,i.renderReprojectionEdges_=!1,i}return e.prototype.canExpireCache=function(){if(this.tileCache.canExpireCache())return!0;for(var t in this.tileCacheForProjection)if(this.tileCacheForProjection[t].canExpireCache())return!0;return!1},e.prototype.expireCache=function(t,i){var r=this.getTileCacheForProjection(t);this.tileCache.expireCache(this.tileCache==r?i:{});for(var a in this.tileCacheForProjection){var o=this.tileCacheForProjection[a];o.expireCache(o==r?i:{})}},e.prototype.getGutterForProjection=function(t){return this.getProjection()&&t&&!Se(this.getProjection(),t)?0:this.getGutter()},e.prototype.getGutter=function(){return 0},e.prototype.getKey=function(){var t=n.prototype.getKey.call(this);return this.getInterpolate()||(t+=":disable-interpolation"),t},e.prototype.getOpaque=function(t){return this.getProjection()&&t&&!Se(this.getProjection(),t)?!1:n.prototype.getOpaque.call(this,t)},e.prototype.getTileGridForProjection=function(t){var i=this.getProjection();if(this.tileGrid&&(!i||Se(i,t)))return this.tileGrid;var r=H(t);return r in this.tileGridForProjection||(this.tileGridForProjection[r]=Ul(t)),this.tileGridForProjection[r]},e.prototype.getTileCacheForProjection=function(t){var i=this.getProjection();if(!i||Se(i,t))return this.tileCache;var r=H(t);return r in this.tileCacheForProjection||(this.tileCacheForProjection[r]=new zl(this.tileCache.highWaterMark)),this.tileCacheForProjection[r]},e.prototype.createTile_=function(t,i,r,a,o,s){var h=[t,i,r],l=this.getTileCoordForTileUrlFunction(h,o),u=l?this.tileUrlFunction(l,a,o):void 0,c=new this.tileClass(h,u!==void 0?k.IDLE:k.EMPTY,u!==void 0?u:"",this.crossOrigin,this.tileLoadFunction,this.tileOptions);return c.key=s,c.addEventListener(B.CHANGE,this.handleTileChange.bind(this)),c},e.prototype.getTile=function(t,i,r,a,o){var s=this.getProjection();if(!s||!o||Se(s,o))return this.getTileInternal(t,i,r,a,s||o);var h=this.getTileCacheForProjection(o),l=[t,i,r],u=void 0,c=Gl(l);h.containsKey(c)&&(u=h.get(c));var f=this.getKey();if(u&&u.key==f)return u;var d=this.getTileGridForProjection(s),v=this.getTileGridForProjection(o),_=this.getTileCoordForTileUrlFunction(l,o),p=new bl(s,d,o,v,l,_,this.getTilePixelRatio(a),this.getGutter(),(function(g,y,m,x){return this.getTileInternal(g,y,m,x,s)}).bind(this),this.reprojectionErrorThreshold_,this.renderReprojectionEdges_,this.getInterpolate());return p.key=f,u?(p.interimTile=u,p.refreshInterimChain(),h.replace(c,p)):h.set(c,p),p},e.prototype.getTileInternal=function(t,i,r,a,o){var s=null,h=qr(t,i,r),l=this.getKey();if(!this.tileCache.containsKey(h))s=this.createTile_(t,i,r,a,o,l),this.tileCache.set(h,s);else if(s=this.tileCache.get(h),s.key!=l){var u=s;s=this.createTile_(t,i,r,a,o,l),u.getState()==k.IDLE?s.interimTile=u.interimTile:s.interimTile=u,s.refreshInterimChain(),this.tileCache.replace(h,s)}return s},e.prototype.setRenderReprojectionEdges=function(t){if(this.renderReprojectionEdges_!=t){this.renderReprojectionEdges_=t;for(var i in this.tileCacheForProjection)this.tileCacheForProjection[i].clear();this.changed()}},e.prototype.setTileGridForProjection=function(t,i){{var r=dt(t);if(r){var a=H(r);a in this.tileGridForProjection||(this.tileGridForProjection[a]=i)}}},e})(pm);function ym(n,e){n.getImage().src=e}var mm=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Yl=(function(n){mm(e,n);function e(t){var i=t||{},r=i.imageSmoothing!==void 0?i.imageSmoothing:!0;i.interpolate!==void 0&&(r=i.interpolate);var a=i.projection!==void 0?i.projection:"EPSG:3857",o=i.tileGrid!==void 0?i.tileGrid:sm({extent:yo(a),maxResolution:i.maxResolution,maxZoom:i.maxZoom,minZoom:i.minZoom,tileSize:i.tileSize});return n.call(this,{attributions:i.attributions,cacheSize:i.cacheSize,crossOrigin:i.crossOrigin,interpolate:r,opaque:i.opaque,projection:a,reprojectionErrorThreshold:i.reprojectionErrorThreshold,tileGrid:o,tileLoadFunction:i.tileLoadFunction,tilePixelRatio:i.tilePixelRatio,tileUrlFunction:i.tileUrlFunction,url:i.url,urls:i.urls,wrapX:i.wrapX!==void 0?i.wrapX:!0,transition:i.transition,attributionsCollapsible:i.attributionsCollapsible,zDirection:i.zDirection})||this}return e})(Xl),xm=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Vl='&#169; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a> contributors.',Em=(function(n){xm(e,n);function e(t){var i=t||{},r=i.imageSmoothing!==void 0?i.imageSmoothing:!0;i.interpolate!==void 0&&(r=i.interpolate);var a;i.attributions!==void 0?a=i.attributions:a=[Vl];var o=i.crossOrigin!==void 0?i.crossOrigin:"anonymous",s=i.url!==void 0?i.url:"https://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png";return n.call(this,{attributions:a,attributionsCollapsible:!1,cacheSize:i.cacheSize,crossOrigin:o,interpolate:r,maxZoom:i.maxZoom!==void 0?i.maxZoom:19,opaque:i.opaque!==void 0?i.opaque:!0,reprojectionErrorThreshold:i.reprojectionErrorThreshold,tileLoadFunction:i.tileLoadFunction,transition:i.transition,url:s,wrapX:i.wrapX,zDirection:i.zDirection})||this}return e})(Yl),Mm=(function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(i,r){i.__proto__=r}||function(i,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(i[a]=r[a])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function i(){this.constructor=e}e.prototype=t===null?Object.create(t):(i.prototype=t.prototype,new i)}})(),Tm=(function(n){Mm(e,n);function e(t){var i=this,r=t||{},a=r.imageSmoothing!==void 0?r.imageSmoothing:!0;r.interpolate!==void 0&&(a=r.interpolate);var o=r.params||{},s="TRANSPARENT"in o?o.TRANSPARENT:!0;return i=n.call(this,{attributions:r.attributions,attributionsCollapsible:r.attributionsCollapsible,cacheSize:r.cacheSize,crossOrigin:r.crossOrigin,interpolate:a,opaque:!s,projection:r.projection,reprojectionErrorThreshold:r.reprojectionErrorThreshold,tileClass:r.tileClass,tileGrid:r.tileGrid,tileLoadFunction:r.tileLoadFunction,url:r.url,urls:r.urls,wrapX:r.wrapX!==void 0?r.wrapX:!0,transition:r.transition,zDirection:r.zDirection})||this,i.gutter_=r.gutter!==void 0?r.gutter:0,i.params_=o,i.v13_=!0,i.serverType_=r.serverType,i.hidpi_=r.hidpi!==void 0?r.hidpi:!0,i.tmpExtent_=Wt(),i.updateV13_(),i.setKey(i.getKeyForParams_()),i}return e.prototype.getFeatureInfoUrl=function(t,i,r,a){var o=dt(r),s=this.getProjection(),h=this.getTileGrid();h||(h=this.getTileGridForProjection(o));var l=h.getZForResolution(i,this.zDirection),u=h.getTileCoordForCoordAndZ(t,l);if(!(h.getResolutions().length<=u[0])){var c=h.getResolution(u[0]),f=h.getTileCoordExtent(u,this.tmpExtent_),d=Rt(h.getTileSize(u[0]),this.tmpSize),v=this.gutter_;v!==0&&(d=ns(d,v,this.tmpSize),f=gn(f,c*v,f)),s&&s!==o&&(c=On(s,o,t,c),f=$a(f,o,s),t=bn(t,o,s));var _={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetFeatureInfo",FORMAT:"image/png",TRANSPARENT:!0,QUERY_LAYERS:this.params_.LAYERS};it(_,this.params_,a);var p=Math.floor((t[0]-f[0])/c),g=Math.floor((f[3]-t[1])/c);return _[this.v13_?"I":"X"]=p,_[this.v13_?"J":"Y"]=g,this.getRequestUrl_(u,d,f,1,s||o,_)}},e.prototype.getLegendUrl=function(t,i){if(this.urls[0]!==void 0){var r={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetLegendGraphic",FORMAT:"image/png"};if(i===void 0||i.LAYER===void 0){var a=this.params_.LAYERS,o=!Array.isArray(a)||a.length===1;if(!o)return;r.LAYER=a}if(t!==void 0){var s=this.getProjection()?this.getProjection().getMetersPerUnit():1,h=28e-5;r.SCALE=t*s/h}return it(r,i),Dr(this.urls[0],r)}},e.prototype.getGutter=function(){return this.gutter_},e.prototype.getParams=function(){return this.params_},e.prototype.getRequestUrl_=function(t,i,r,a,o,s){var h=this.urls;if(h){if(s.WIDTH=i[0],s.HEIGHT=i[1],s[this.v13_?"CRS":"SRS"]=o.getCode(),"STYLES"in this.params_||(s.STYLES=""),a!=1)switch(this.serverType_){case be.GEOSERVER:var l=90*a+.5|0;"FORMAT_OPTIONS"in s?s.FORMAT_OPTIONS+=";dpi:"+l:s.FORMAT_OPTIONS="dpi:"+l;break;case be.MAPSERVER:s.MAP_RESOLUTION=90*a;break;case be.CARMENTA_SERVER:case be.QGIS:s.DPI=90*a;break;default:Y(!1,52);break}var u=o.getAxisOrientation(),c=r;if(this.v13_&&u.substr(0,2)=="ne"){var f=void 0;f=r[0],c[0]=r[1],c[1]=f,f=r[2],c[2]=r[3],c[3]=f}s.BBOX=c.join(",");var d;if(h.length==1)d=h[0];else{var v=He(kl(t),h.length);d=h[v]}return Dr(d,s)}},e.prototype.getTilePixelRatio=function(t){return!this.hidpi_||this.serverType_===void 0?1:t},e.prototype.getKeyForParams_=function(){var t=0,i=[];for(var r in this.params_)i[t++]=r+"-"+this.params_[r];return i.join("/")},e.prototype.updateParams=function(t){it(this.params_,t),this.updateV13_(),this.setKey(this.getKeyForParams_())},e.prototype.updateV13_=function(){var t=this.params_.VERSION||Ne;this.v13_=uh(t,"1.3")>=0},e.prototype.tileUrlFunction=function(t,i,r){var a=this.getTileGrid();if(a||(a=this.getTileGridForProjection(r)),!(a.getResolutions().length<=t[0])){i!=1&&(!this.hidpi_||this.serverType_===void 0)&&(i=1);var o=a.getResolution(t[0]),s=a.getTileCoordExtent(t,this.tmpExtent_),h=Rt(a.getTileSize(t[0]),this.tmpSize),l=this.gutter_;l!==0&&(h=ns(h,l,this.tmpSize),s=gn(s,o*l,s)),i!=1&&(h=Nh(h,i,this.tmpSize));var u={SERVICE:"WMS",VERSION:Ne,REQUEST:"GetMap",FORMAT:"image/png",TRANSPARENT:!0};return it(u,this.params_),this.getRequestUrl_(t,h,s,i,r,u)}},e})(Xl);/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function mo(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/source/Source");return n.setAttributions(e.attributions),n}function Cm(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/source/Tile");return mo(n,e),n}function Rm(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/source/UrlTile");return Cm(n,e),e.url&&n.setUrl(e.url),n}function ql(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/source/TileImage");return Rm(n,e),n}function wm(n,e,t){return n||(n=new Tm(pe(e))),ql(n,e),n}function Kl(n,e,t){return n||(n=new Yl(pe(e))),ql(n,e),n}function Im(n,e,t){return n||(n=new Em(pe(e))),e.attributions||(e.attributions=Vl),Kl(n,e),n}function Sm(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/source/Image");return mo(n,e),n}function Om(n,e,t){return n||(n=new Qy(pe(e))),Sm(n,e),e.url&&n.setUrl(e.url),n}function Am(n,e,t){return n||(n=new el(pe({...e,features:new xt}))),mo(n,e),Dl(n.getFeaturesCollection(),e.features,t),n}/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */function Pm(n,e,t){return n||(n=new Yr),n.setColor(e.color),t.connector.forceRender(),n}function Lm(n,e,t){return n||(n=new ro),n.setColor(e.color),n.setWidth(e.width),t.connector.forceRender(),n}function Nm(n,e,t){if(!n)throw new Error("Can not instantiate base class: ol/style/Image");return n.setOpacity(e.opacity),n.setRotateWithView(e.rotateWithView),n.setRotation(e.rotation),n.setScale(e.scale),n}function bm(n,e,t){if(!n){const i=e.img||e.src;n=new Zh(pe({...e,img:void 0,src:i,imgSize:e.imgSize?Wy(e.imgSize):void 0,anchor:e.anchor?br(e.anchor):void 0,anchorOrigin:e.anchorOrigin?Ga(e.anchorOrigin):void 0}))}return Nm(n,e),t.connector.forceRender(),n}function Dm(n,e,t){return n||(n=new Hh),n.setFont(e.font),n.setOffsetX(e.offset&&e.offset.x||0),n.setOffsetY(e.offset&&e.offset.y||0),n.setScale(e.scale),n.setRotation(e.rotation),n.setRotateWithView(e.rotateWithView),n.setTextAlign(e.textAlign?Ga(e.textAlign):void 0),n.setTextBaseline(e.textBaseline?Ga(e.textBaseline):void 0),n.setFill(e.fill?t.lookup.get(e.fill):void 0),n.setStroke(e.stroke?t.lookup.get(e.stroke):void 0),n.setBackgroundFill(e.backgroundFill?t.lookup.get(e.backgroundFill):void 0),n.setBackgroundStroke(e.backgroundStroke?t.lookup.get(e.backgroundStroke):void 0),n.setPadding([e.padding,e.padding,e.padding,e.padding]),t.connector.forceRender(),n}function Fm(n,e,t){return n||(n=new Vh),n.setImage(e.image?t.lookup.get(e.image):void 0),n.setFill(e.fill?t.lookup.get(e.fill):void 0),n.setStroke(e.stroke?t.lookup.get(e.stroke):void 0),n.setText(e.text?t.lookup.get(e.text):void 0),t.connector.forceRender(),n}/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */const Gm=new Hh({font:"13px sans-serif",offsetY:10,fill:new Yr({color:"#333"}),stroke:new ro({color:"#fff",width:3})});function km(n,e,t){if(!n)throw new Error("Existing map instance must be provided");return Dl(n.getLayers(),e.layers,t),n.setView(t.lookup.get(e.view)),n}function zm(n,e,t){return n||(n=new Oe({projection:e.projection})),n.setCenter(e.center?br(e.center):[0,0]),n.setRotation(e.rotation||0),n.setZoom(e.zoom||0),n}function jm(n,e,t){return n||(n=new Sh(br(e.coordinates))),n.setCoordinates(br(e.coordinates)),n}function Um(n,e,t){n||(n=new od),n.setGeometry(t.lookup.get(e.geometry));const i=t.lookup.get(e.style);return n.setStyle(()=>{if(i)return e.text&&!i.getText()&&i.setText(Gm),i.getText()&&i.getText().setText(e.text),i}),n.draggable=e.draggable,n}const Bm={"ol/Feature":Um,"ol/Map":km,"ol/View":zm,"ol/layer/Image":Vy,"ol/layer/Tile":Xy,"ol/layer/Vector":Yy,"ol/source/ImageWMS":Om,"ol/source/OSM":Im,"ol/source/TileWMS":wm,"ol/source/Vector":Am,"ol/source/XYZ":Kl,"ol/geom/Point":jm,"ol/style/Icon":bm,"ol/style/Fill":Pm,"ol/style/Stroke":Lm,"ol/style/Style":Fm,"ol/style/Text":Dm};function Ws(n,e){const t=n.type;if(!t)throw new Error("Configuration object must have a type");if(!n.id)throw new Error("Configuration object must have an ID");let i=e.lookup.get(n.id);const r=Bm[t];if(!r)throw new Error(`Unsupported configuration object type: ${t}`);return i=r(i,n,e),e.lookup.put(n.id,i),i.id=n.id,i.typeName=t,i}/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */class Wm{constructor(){this.map=new Map}get(e){return this.map.get(e)}put(e,t){this.map.set(e,t)}}class Xm{constructor(){this.map=new Map,this.registry=new FinalizationRegistry(e=>{this.map.delete(e)})}get(e){const t=this.map.get(e);return t?t.deref():void 0}put(e,t){if(this.map.has(e))return;const i=new WeakRef(t);this.map.set(e,i),this.registry.register(t,e)}}const Ym=window.WeakRef&&window.FinalizationRegistry;function Vm(){return Ym?new Xm:new Wm}function Xs(n,e){return n.find(t=>{const i=t.getSource&&t.getSource();return i&&i instanceof el&&i.getFeatures().includes(e)})}/**
 * @license
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */_h("EPSG:4326");function qm(n){n.$connector={lookup:Vm(),synchronize(t){const i={synchronize:Ws,lookup:this.lookup,mapElement:n,connector:n.$connector};t.forEach(r=>{r.type==="ol/Map"&&this.lookup.put(r.id,n.configuration),Ws(r,i)})},forceRender(){this._forceRenderTimeout||(this._forceRenderTimeout=setTimeout(()=>{this._forceRenderTimeout=null,n.configuration.getLayers().getArray().forEach(t=>t.changed())}))}},n.configuration.on("moveend",t=>{const i=n.configuration.getView(),r=i.getCenter(),a=i.getRotation(),o=i.getZoom(),s=i.calculateExtent(),h=new CustomEvent("map-view-moveend",{detail:{center:r,rotation:a,zoom:o,extent:s}});n.dispatchEvent(h)}),n.configuration.on("singleclick",t=>{const i=t.coordinate,r=t.pixel,o=n.configuration.getFeaturesAtPixel(r).map(h=>{const l=Xs(n.configuration.getLayers().getArray(),h);return{feature:h,layer:l}}),s=new CustomEvent("map-click",{detail:{coordinate:i,features:o,originalEvent:t.originalEvent}});if(n.dispatchEvent(s),o.length>0){const h=o[0],l=new CustomEvent("map-feature-click",{detail:{feature:h.feature,layer:h.layer,originalEvent:t.originalEvent}});n.dispatchEvent(l)}});const e=new Ev({filter(t){return!!t.draggable}});e.on("translateend",t=>{const i=t.features.item(0);if(!i)return;const r=Xs(n.configuration.getLayers().getArray(),i),a=new CustomEvent("map-feature-drop",{detail:{feature:i,layer:r,coordinate:t.coordinate,startCoordinate:t.startCoordinate}});n.dispatchEvent(a)}),n.configuration.addInteraction(e)}function Km(n){_h(n)}function $m(n,e){bt.defs(n,e),Iv(bt)}window.Vaadin.Flow.mapConnector={init:qm,setUserProjection:Km,defineProjection:$m};
