import{S,i,f as f$2,a as addGlobalThemeStyles,T as ThemableMixin,x,d as defineCustomElement,b as i$1,r as r$1,E as E$1,c as ThemePropertyMixin,B,e as i$2,t as t$1,g as e$2,h as T,j as b,_ as __vitePreload,k as reactExports,l as clientExports,m as jsxRuntimeExports,O as Outlet,n as injectGlobalCss}from"./indexhtml-By-amN3z.js";/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getEffectiveStyles(v){const{baseStyles:d,themeStyles:a,elementStyles:p,lumoInjector:y}=v.constructor,C=v.__lumoStyleSheet;return C&&(d||a)?[...y.includeBaseStyles?d:[],C,...a]:[C,...p].filter(Boolean)}function applyInstanceStyles(v){S(v.shadowRoot,getEffectiveStyles(v))}function injectLumoStyleSheet(v,d){v.__lumoStyleSheet=d,applyInstanceStyles(v)}function removeLumoStyleSheet(v){v.__lumoStyleSheet=void 0,applyInstanceStyles(v)}const $cssFromFile_0=i`:where(:root,:host){--vaadin-focus-ring-color: inherit;--vaadin-focus-ring-width: inherit}@font-face{font-family:lumo-icons;src:url(data:application/font-woff;charset=utf-8;base64,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) format("woff");font-weight:400;font-style:normal}:where(:root,:host){--lumo-icons-align-center: "";--lumo-icons-align-left: "";--lumo-icons-align-right: "";--lumo-icons-angle-down: "";--lumo-icons-angle-left: "";--lumo-icons-angle-right: "";--lumo-icons-angle-up: "";--lumo-icons-arrow-down: "";--lumo-icons-arrow-left: "";--lumo-icons-arrow-right: "";--lumo-icons-arrow-up: "";--lumo-icons-bar-chart: "";--lumo-icons-bell: "";--lumo-icons-calendar: "";--lumo-icons-checkmark: "";--lumo-icons-chevron-down: "";--lumo-icons-chevron-left: "";--lumo-icons-chevron-right: "";--lumo-icons-chevron-up: "";--lumo-icons-clean: "";--lumo-icons-clock: "";--lumo-icons-cog: "";--lumo-icons-cross: "";--lumo-icons-download: "";--lumo-icons-drag-handle: "";--lumo-icons-dropdown: "";--lumo-icons-edit: "";--lumo-icons-error: "";--lumo-icons-eye: "";--lumo-icons-eye-disabled: "";--lumo-icons-indent: "";--lumo-icons-link: "";--lumo-icons-menu: "";--lumo-icons-minus: "";--lumo-icons-ordered-list: "";--lumo-icons-outdent: "";--lumo-icons-phone: "";--lumo-icons-photo: "";--lumo-icons-play: "";--lumo-icons-plus: "";--lumo-icons-redo: "";--lumo-icons-reload: "";--lumo-icons-resize-handle: "";--lumo-icons-search: "";--lumo-icons-undo: "";--lumo-icons-unordered-list: "";--lumo-icons-upload: "";--lumo-icons-user: ""}:where(:root,:host){--lumo-border-radius-s: .25em;--lumo-border-radius-m: var(--lumo-border-radius, .25em);--lumo-border-radius-l: .5em;--lumo-box-shadow-xs: 0 1px 4px -1px var(--lumo-shade-50pct);--lumo-box-shadow-s: 0 2px 4px -1px var(--lumo-shade-20pct), 0 3px 12px -1px var(--lumo-shade-30pct);--lumo-box-shadow-m: 0 2px 6px -1px var(--lumo-shade-20pct), 0 8px 24px -4px var(--lumo-shade-40pct);--lumo-box-shadow-l: 0 3px 18px -2px var(--lumo-shade-20pct), 0 12px 48px -6px var(--lumo-shade-40pct);--lumo-box-shadow-xl: 0 4px 24px -3px var(--lumo-shade-20pct), 0 18px 64px -8px var(--lumo-shade-40pct);--lumo-clickable-cursor: default}:where(:root,:host){--lumo-base-color: #fff;--lumo-tint-5pct: hsla(0, 0%, 100%, .3);--lumo-tint-10pct: hsla(0, 0%, 100%, .37);--lumo-tint-20pct: hsla(0, 0%, 100%, .44);--lumo-tint-30pct: hsla(0, 0%, 100%, .5);--lumo-tint-40pct: hsla(0, 0%, 100%, .57);--lumo-tint-50pct: hsla(0, 0%, 100%, .64);--lumo-tint-60pct: hsla(0, 0%, 100%, .7);--lumo-tint-70pct: hsla(0, 0%, 100%, .77);--lumo-tint-80pct: hsla(0, 0%, 100%, .84);--lumo-tint-90pct: hsla(0, 0%, 100%, .9);--lumo-tint: #fff;--lumo-shade-5pct: hsla(214, 61%, 25%, .05);--lumo-shade-10pct: hsla(214, 57%, 24%, .1);--lumo-shade-20pct: hsla(214, 53%, 23%, .16);--lumo-shade-30pct: hsla(214, 50%, 22%, .26);--lumo-shade-40pct: hsla(214, 47%, 21%, .38);--lumo-shade-50pct: hsla(214, 45%, 20%, .52);--lumo-shade-60pct: hsla(214, 43%, 19%, .6);--lumo-shade-70pct: hsla(214, 42%, 18%, .69);--lumo-shade-80pct: hsla(214, 41%, 17%, .83);--lumo-shade-90pct: hsla(214, 40%, 16%, .94);--lumo-shade: hsl(214, 35%, 15%);--lumo-contrast-5pct: var(--lumo-shade-5pct);--lumo-contrast-10pct: var(--lumo-shade-10pct);--lumo-contrast-20pct: var(--lumo-shade-20pct);--lumo-contrast-30pct: var(--lumo-shade-30pct);--lumo-contrast-40pct: var(--lumo-shade-40pct);--lumo-contrast-50pct: var(--lumo-shade-50pct);--lumo-contrast-60pct: var(--lumo-shade-60pct);--lumo-contrast-70pct: var(--lumo-shade-70pct);--lumo-contrast-80pct: var(--lumo-shade-80pct);--lumo-contrast-90pct: var(--lumo-shade-90pct);--lumo-contrast: var(--lumo-shade);--lumo-header-text-color: var(--lumo-contrast);--lumo-body-text-color: var(--lumo-contrast-90pct);--lumo-secondary-text-color: var(--lumo-contrast-70pct);--lumo-tertiary-text-color: var(--lumo-contrast-50pct);--lumo-disabled-text-color: var(--lumo-contrast-30pct);--lumo-primary-color: hsl(214, 100%, 48%);--lumo-primary-color-50pct: hsla(214, 100%, 49%, .76);--lumo-primary-color-10pct: hsla(214, 100%, 60%, .13);--lumo-primary-text-color: hsl(214, 100%, 43%);--lumo-primary-contrast-color: #fff;--lumo-error-color: hsl(3, 85%, 48%);--lumo-error-color-50pct: hsla(3, 85%, 49%, .5);--lumo-error-color-10pct: hsla(3, 85%, 49%, .1);--lumo-error-text-color: hsl(3, 89%, 42%);--lumo-error-contrast-color: #fff;--lumo-success-color: hsl(145, 72%, 30%);--lumo-success-color-50pct: hsla(145, 72%, 31%, .5);--lumo-success-color-10pct: hsla(145, 72%, 31%, .1);--lumo-success-text-color: hsl(145, 85%, 25%);--lumo-success-contrast-color: #fff;--lumo-warning-color: hsl(48, 100%, 50%);--lumo-warning-color-10pct: hsla(48, 100%, 50%, .25);--lumo-warning-text-color: hsl(32, 100%, 30%);--lumo-warning-contrast-color: var(--lumo-shade-90pct);--vaadin-user-color-0: #df0b92;--vaadin-user-color-1: #650acc;--vaadin-user-color-2: #097faa;--vaadin-user-color-3: #ad6200;--vaadin-user-color-4: #bf16f3;--vaadin-user-color-5: #084391;--vaadin-user-color-6: #078836}@media (forced-colors: active){:where(:root,:host){--lumo-disabled-text-color: GrayText}}:where(:root,:host){--lumo-size-xs: 1.625rem;--lumo-size-s: 1.875rem;--lumo-size-m: 2.25rem;--lumo-size-l: 2.75rem;--lumo-size-xl: 3.5rem;--lumo-icon-size-s: 1.25em;--lumo-icon-size-m: 1.5em;--lumo-icon-size-l: 2.25em;--lumo-icon-size: var(--lumo-icon-size-m)}:where(:root,:host){--lumo-space-xs: .25rem;--lumo-space-s: .5rem;--lumo-space-m: 1rem;--lumo-space-l: 1.5rem;--lumo-space-xl: 2.5rem;--lumo-space-wide-xs: calc(var(--lumo-space-xs) / 2) var(--lumo-space-xs);--lumo-space-wide-s: calc(var(--lumo-space-s) / 2) var(--lumo-space-s);--lumo-space-wide-m: calc(var(--lumo-space-m) / 2) var(--lumo-space-m);--lumo-space-wide-l: calc(var(--lumo-space-l) / 2) var(--lumo-space-l);--lumo-space-wide-xl: calc(var(--lumo-space-xl) / 2) var(--lumo-space-xl);--lumo-space-tall-xs: var(--lumo-space-xs) calc(var(--lumo-space-xs) / 2);--lumo-space-tall-s: var(--lumo-space-s) calc(var(--lumo-space-s) / 2);--lumo-space-tall-m: var(--lumo-space-m) calc(var(--lumo-space-m) / 2);--lumo-space-tall-l: var(--lumo-space-l) calc(var(--lumo-space-l) / 2);--lumo-space-tall-xl: var(--lumo-space-xl) calc(var(--lumo-space-xl) / 2)}:where(:root,:host){--lumo-font-family: -apple-system, BlinkMacSystemFont, "Roboto", "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";--lumo-font-size-xxs: .75rem;--lumo-font-size-xs: .8125rem;--lumo-font-size-s: .875rem;--lumo-font-size-m: 1rem;--lumo-font-size-l: 1.125rem;--lumo-font-size-xl: 1.375rem;--lumo-font-size-xxl: 1.75rem;--lumo-font-size-xxxl: 2.5rem;--lumo-line-height-xs: 1.25;--lumo-line-height-s: 1.375;--lumo-line-height-m: 1.625}[theme~=badge]{display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;padding:.4em calc(.5em + var(--lumo-border-radius-s) / 4);color:var(--lumo-primary-text-color);background-color:var(--lumo-primary-color-10pct);border-radius:var(--lumo-border-radius-s);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-s);line-height:1;font-weight:500;text-transform:initial;letter-spacing:initial;min-width:calc(var(--lumo-line-height-xs) * 1em + .45em);flex-shrink:0}[theme~=badge]:before{display:inline-block;content:" ";width:0}[theme~=badge][theme~=small]{font-size:var(--lumo-font-size-xxs);line-height:1}[theme~=badge][theme~=success]{color:var(--lumo-success-text-color);background-color:var(--lumo-success-color-10pct)}[theme~=badge][theme~=error]{color:var(--lumo-error-text-color);background-color:var(--lumo-error-color-10pct)}[theme~=badge][theme~=warning]{color:var(--lumo-warning-text-color);background-color:var(--lumo-warning-color-10pct)}[theme~=badge][theme~=contrast]{color:var(--lumo-contrast-80pct);background-color:var(--lumo-contrast-5pct)}[theme~=badge][theme~=primary]{color:var(--lumo-primary-contrast-color);background-color:var(--lumo-primary-color)}[theme~=badge][theme~=success][theme~=primary]{color:var(--lumo-success-contrast-color);background-color:var(--lumo-success-color)}[theme~=badge][theme~=error][theme~=primary]{color:var(--lumo-error-contrast-color);background-color:var(--lumo-error-color)}[theme~=badge][theme~=warning][theme~=primary]{color:var(--lumo-warning-contrast-color);background-color:var(--lumo-warning-color)}[theme~=badge][theme~=contrast][theme~=primary]{color:var(--lumo-base-color);background-color:var(--lumo-contrast)}[theme~=badge][href]:hover{text-decoration:none}[theme~=badge]>vaadin-icon{margin:-.25em 0}[theme~=badge]>vaadin-icon:first-child{margin-left:-.375em}[theme~=badge]>vaadin-icon:last-child{margin-right:-.375em}vaadin-icon[theme~=badge][icon]{min-width:0;padding:0;font-size:1rem;width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}vaadin-icon[theme~=badge][icon][theme~=small]{width:var(--lumo-icon-size-s);height:var(--lumo-icon-size-s)}[theme~=badge]:not([icon]):empty{min-width:0;width:1em;height:1em;padding:0;border-radius:50%;background-color:var(--lumo-primary-color)}[theme~=badge][theme~=small]:not([icon]):empty{width:.75em;height:.75em}[theme~=badge][theme~=contrast]:not([icon]):empty{background-color:var(--lumo-contrast)}[theme~=badge][theme~=success]:not([icon]):empty{background-color:var(--lumo-success-color)}[theme~=badge][theme~=error]:not([icon]):empty{background-color:var(--lumo-error-color)}[theme~=badge][theme~=warning]:not([icon]):empty{background-color:var(--lumo-warning-color)}[theme~=badge][theme~=pill]{--lumo-border-radius-s: 1em}[dir=rtl][theme~=badge] vaadin-icon:first-child{margin-right:-.375em;margin-left:0}[dir=rtl][theme~=badge] vaadin-icon:last-child{margin-left:-.375em;margin-right:0}:where(:root,:host){color:var(--lumo-body-text-color);background-color:var(--lumo-base-color);color-scheme:light}[theme~=dark]{--lumo-base-color: hsl(214, 35%, 21%);--lumo-tint-5pct: hsla(214, 65%, 85%, .06);--lumo-tint-10pct: hsla(214, 60%, 80%, .14);--lumo-tint-20pct: hsla(214, 64%, 82%, .23);--lumo-tint-30pct: hsla(214, 69%, 84%, .32);--lumo-tint-40pct: hsla(214, 73%, 86%, .41);--lumo-tint-50pct: hsla(214, 78%, 88%, .5);--lumo-tint-60pct: hsla(214, 82%, 90%, .58);--lumo-tint-70pct: hsla(214, 87%, 92%, .69);--lumo-tint-80pct: hsla(214, 91%, 94%, .8);--lumo-tint-90pct: hsla(214, 96%, 96%, .9);--lumo-tint: hsl(214, 100%, 98%);--lumo-shade-5pct: hsla(214, 0%, 0%, .07);--lumo-shade-10pct: hsla(214, 4%, 2%, .15);--lumo-shade-20pct: hsla(214, 8%, 4%, .23);--lumo-shade-30pct: hsla(214, 12%, 6%, .32);--lumo-shade-40pct: hsla(214, 16%, 8%, .41);--lumo-shade-50pct: hsla(214, 20%, 10%, .5);--lumo-shade-60pct: hsla(214, 24%, 12%, .6);--lumo-shade-70pct: hsla(214, 28%, 13%, .7);--lumo-shade-80pct: hsla(214, 32%, 13%, .8);--lumo-shade-90pct: hsla(214, 33%, 13%, .9);--lumo-shade: hsl(214, 33%, 13%);--lumo-contrast-5pct: var(--lumo-tint-5pct);--lumo-contrast-10pct: var(--lumo-tint-10pct);--lumo-contrast-20pct: var(--lumo-tint-20pct);--lumo-contrast-30pct: var(--lumo-tint-30pct);--lumo-contrast-40pct: var(--lumo-tint-40pct);--lumo-contrast-50pct: var(--lumo-tint-50pct);--lumo-contrast-60pct: var(--lumo-tint-60pct);--lumo-contrast-70pct: var(--lumo-tint-70pct);--lumo-contrast-80pct: var(--lumo-tint-80pct);--lumo-contrast-90pct: var(--lumo-tint-90pct);--lumo-contrast: var(--lumo-tint);--lumo-header-text-color: var(--lumo-contrast);--lumo-body-text-color: var(--lumo-contrast-90pct);--lumo-secondary-text-color: var(--lumo-contrast-70pct);--lumo-tertiary-text-color: var(--lumo-contrast-50pct);--lumo-disabled-text-color: var(--lumo-contrast-30pct);--lumo-primary-color: hsl(214, 90%, 48%);--lumo-primary-color-50pct: hsla(214, 90%, 70%, .69);--lumo-primary-color-10pct: hsla(214, 90%, 55%, .13);--lumo-primary-text-color: hsl(214, 90%, 77%);--lumo-primary-contrast-color: #fff;--lumo-error-color: hsl(3, 79%, 49%);--lumo-error-color-50pct: hsla(3, 75%, 62%, .5);--lumo-error-color-10pct: hsla(3, 75%, 62%, .14);--lumo-error-text-color: hsl(3, 100%, 80%);--lumo-success-color: hsl(145, 72%, 30%);--lumo-success-color-50pct: hsla(145, 92%, 51%, .5);--lumo-success-color-10pct: hsla(145, 92%, 51%, .1);--lumo-success-text-color: hsl(145, 85%, 46%);--lumo-warning-color: hsl(43, 100%, 48%);--lumo-warning-color-10pct: hsla(40, 100%, 50%, .2);--lumo-warning-text-color: hsl(45, 100%, 60%);--lumo-warning-contrast-color: var(--lumo-shade-90pct);--vaadin-user-color-0: #ff66c7;--vaadin-user-color-1: #9d8aff;--vaadin-user-color-2: #8aff66;--vaadin-user-color-3: #ffbd66;--vaadin-user-color-4: #dc6bff;--vaadin-user-color-5: #66fffa;--vaadin-user-color-6: #e6ff66;color:var(--lumo-body-text-color);background-color:var(--lumo-base-color);color-scheme:dark}:where(body,:host){font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}small,[theme~=font-size-s]{font-size:var(--lumo-font-size-s);line-height:var(--lumo-line-height-s)}[theme~=font-size-xs]{font-size:var(--lumo-font-size-xs);line-height:var(--lumo-line-height-xs)}:where(h1,h2,h3,h4,h5,h6){font-weight:600;line-height:var(--lumo-line-height-xs);color:var(--lumo-header-text-color);margin-block:0}:where(h1){font-size:var(--lumo-font-size-xxxl)}:where(h2){font-size:var(--lumo-font-size-xxl)}:where(h3){font-size:var(--lumo-font-size-xl)}:where(h4){font-size:var(--lumo-font-size-l)}:where(h5){font-size:var(--lumo-font-size-m)}:where(h6){font-size:var(--lumo-font-size-xs);text-transform:uppercase;letter-spacing:.03em}p,blockquote{margin-top:.5em;margin-bottom:.75em}a{text-decoration:none}a:where(:any-link){color:var(--lumo-primary-text-color)}a:where(:any-link):hover{text-decoration:underline}a:not(:any-link){color:var(--lumo-disabled-text-color)}hr{display:block;align-self:stretch;height:1px;border:0;padding:0;margin:var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);background-color:var(--lumo-contrast-10pct)}b,strong{font-weight:600}code,pre{border-radius:var(--lumo-border-radius-m)}pre code{background:transparent}blockquote{border-left:2px solid var(--lumo-contrast-30pct);color:var(--lumo-secondary-text-color)}blockquote[dir=rtl]{border-left:none;border-right:2px solid var(--lumo-contrast-30pct)}@media lumo_components_accordion-heading{:host{display:block;outline:none;-webkit-user-select:none;user-select:none;padding:0}:host([hidden]){display:none!important}button{display:flex;align-items:center;justify-content:inherit;width:100%;margin:0;padding:0;background-color:initial;color:inherit;border:initial;outline:none;font:inherit;text-align:inherit}[part=content]{padding:var(--lumo-space-s) 0}:host([theme~="filled"]){padding-top:0;padding-bottom:0}}@media lumo_components_details-summary{:host{white-space:nowrap;-webkit-user-select:none;user-select:none;display:flex;align-items:center;width:100%;outline:none;padding:var(--lumo-space-s) 0;box-sizing:border-box;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);font-weight:500;line-height:var(--lumo-line-height-xs);color:var(--lumo-secondary-text-color);background-color:inherit;border-radius:var(--lumo-border-radius-m);cursor:var(--lumo-clickable-cursor);-webkit-tap-highlight-color:transparent;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}:host([hidden]){display:none!important}:host([disabled]){pointer-events:none}:host([disabled]),:host([disabled]) [part=toggle]{color:var(--lumo-disabled-text-color);cursor:default}@media (hover: hover){:host(:hover:not([disabled])),:host(:hover:not([disabled])) [part=toggle]{color:var(--lumo-contrast-80pct)}}[part=toggle]{display:block;width:1em;height:1em;margin-left:calc(var(--lumo-space-xs) * -1);margin-right:var(--lumo-space-xs);font-size:var(--lumo-icon-size-s);line-height:1;color:var(--lumo-contrast-60pct);font-family:lumo-icons;cursor:var(--lumo-clickable-cursor)}[part=toggle]:before{content:var(--lumo-icons-angle-right)}:host([opened]) [part=toggle]{transform:rotate(90deg)}[part=content]{flex-grow:1}:host([dir="rtl"]) [part=toggle]{margin-left:var(--lumo-space-xs);margin-right:calc(var(--lumo-space-xs) * -1)}:host([dir="rtl"]) [part=toggle]:before{content:var(--lumo-icons-angle-left)}:host([opened][dir="rtl"]) [part=toggle]{transform:rotate(-90deg)}:host([theme~="small"]){padding-top:var(--lumo-space-xs);padding-bottom:var(--lumo-space-xs)}:host([theme~="small"]) [part=toggle]{margin-right:calc(var(--lumo-space-xs) / 2)}:host([theme~="small"][dir="rtl"]) [part=toggle]{margin-left:calc(var(--lumo-space-xs) / 2)}:host([theme~="filled"]){padding:var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2)}:host([theme~="reverse"]){justify-content:space-between}:host([theme~="reverse"]) [part=toggle]{order:1;margin-right:0}:host([theme~="reverse"][dir="rtl"]) [part=toggle]{margin-left:0}:host([theme~="reverse"][theme~="filled"]){padding-left:var(--lumo-space-m)}:host([theme~="reverse"][theme~="filled"][dir="rtl"]){padding-right:var(--lumo-space-m)}}:is(:root,:host):before{--vaadin-accordion-heading-lumo-inject: 1;--vaadin-accordion-heading-lumo-inject-modules: lumo_components_details-summary, lumo_components_accordion-heading}@media lumo_components_accordion-panel{:host{display:block;margin:0;border-bottom:solid 1px var(--lumo-contrast-10pct)}:host([hidden]){display:none!important}[part=content]{display:none;overflow:hidden}:host([opened]) [part=content]{display:block;overflow:visible}:host(:last-child){border-bottom:none}:host([theme~="filled"]){border-bottom:none}:host([theme~="filled"]:not(:last-child)){margin-bottom:2px}}@media lumo_components_details{:host{margin:var(--lumo-space-xs) 0;outline:none;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([focus-ring]) ::slotted([slot="summary"]){box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part=content]{padding:var(--lumo-space-xs) 0 var(--lumo-space-s);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m)}:host([theme~="filled"]){background-color:var(--lumo-contrast-5pct);border-radius:var(--lumo-border-radius-m)}:host([theme~="filled"]) [part=content]{padding-left:var(--lumo-space-m);padding-right:var(--lumo-space-m)}:host([theme~="small"]) [part$=content]{font-size:var(--lumo-font-size-s)}}:is(:root,:host):before{--vaadin-accordion-panel-lumo-inject: 1;--vaadin-accordion-panel-lumo-inject-modules: lumo_components_details, lumo_components_accordion-panel}@media lumo_components_app-layout{:host{display:block;box-sizing:border-box;height:100%;--vaadin-app-layout-transition-duration: .2s;transition:padding var(--vaadin-app-layout-transition-duration);--_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);--vaadin-app-layout-touch-optimized: false;--vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);--vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);padding-block:var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);padding-inline-start:var(--vaadin-app-layout-navbar-offset-left)}:host([hidden]),[hidden]{display:none!important}:host([no-anim]){--vaadin-app-layout-transition-duration: 0s !important}:host([drawer-opened]){--vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size)}:host([overlay]){--vaadin-app-layout-drawer-offset-left: 0;--vaadin-app-layout-navbar-offset-left: 0}:host(:not([no-scroll])) [content]{overflow:auto}[content]{height:100%}@media (pointer: coarse) and (max-width: 800px) and (min-height: 500px){:host{--vaadin-app-layout-touch-optimized: true}}[part=navbar]{position:fixed;display:flex;align-items:center;top:0;inset-inline:0;transition:inset-inline-start var(--vaadin-app-layout-transition-duration);padding-top:var(--safe-area-inset-top);padding-left:var(--safe-area-inset-left);padding-right:var(--safe-area-inset-right);z-index:1;min-height:var(--lumo-size-xl);border-bottom:1px solid var(--lumo-contrast-10pct)}:host([primary-section="drawer"][drawer-opened]:not([overlay])) [part=navbar]{inset-inline-start:var(--vaadin-app-layout-drawer-offset-left, 0)}:host([primary-section="drawer"]) [part=drawer]{top:0}[part=navbar][bottom]{top:auto;bottom:0;padding-bottom:var(--safe-area-inset-bottom);border-bottom:none;border-top:1px solid var(--lumo-contrast-10pct)}[part=drawer]{overflow:auto;position:fixed;top:var(--vaadin-app-layout-navbar-offset-top, 0);bottom:var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));inset-inline:var(--vaadin-app-layout-navbar-offset-left, 0) auto;transition:transform var(--vaadin-app-layout-transition-duration),visibility var(--vaadin-app-layout-transition-duration);transform:translate(-100%);max-width:90%;width:var(--_vaadin-app-layout-drawer-width);box-sizing:border-box;padding:var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);outline:none;visibility:hidden;display:flex;flex-direction:column;border-inline-end:1px solid var(--lumo-contrast-10pct)}:host([drawer-opened]) [part=drawer]{visibility:visible;transform:translate(0);touch-action:manipulation}[part=backdrop]{background-color:var(--lumo-shade-20pct);opacity:1}:host(:not([drawer-opened])) [part=backdrop]{opacity:0}:host([overlay]) [part=backdrop]{position:fixed;inset:0;pointer-events:none;transition:opacity var(--vaadin-app-layout-transition-duration);-webkit-tap-highlight-color:transparent}:host([overlay]) [part=drawer]{top:0;bottom:0;border-inline-end:none;box-shadow:var(--lumo-box-shadow-s)}:host([overlay]) [part=drawer],:host([overlay]) [part=backdrop]{z-index:2}:host([drawer-opened][overlay]) [part=backdrop]{pointer-events:auto;touch-action:manipulation}:host([dir="rtl"]) [part=drawer]{transform:translate(100%)}:host([dir="rtl"][drawer-opened]) [part=drawer]{transform:translate(0)}:host([drawer-opened]:not([overlay])){padding-inline-start:var(--vaadin-app-layout-drawer-offset-left)}@media (max-width: 800px),(max-height: 600px){:host{--vaadin-app-layout-drawer-overlay: true;--_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em)}}[part=drawer] ::slotted(vaadin-scroller){flex:1;overscroll-behavior:contain}[part=navbar],[part=drawer]{background-color:var(--lumo-base-color);background-clip:padding-box}:host([primary-section="navbar"]) [part=navbar]{border:none;background-image:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}:host([primary-section="drawer"]:not([overlay])) [part=drawer]{background-image:linear-gradient(var(--lumo-shade-5pct),var(--lumo-shade-5pct))}[part] ::slotted(h2),[part] ::slotted(h3),[part] ::slotted(h4){margin-top:var(--lumo-space-xs)!important;margin-bottom:var(--lumo-space-xs)!important}}:is(:root,:host):before{--vaadin-app-layout-lumo-inject: 1;--vaadin-app-layout-lumo-inject-modules: lumo_components_app-layout}@media lumo_mixins_menu-overlay-core{:host([opening]),:host([closing]){animation:.14s lumo-overlay-dummy-animation}[part=overlay]{will-change:opacity,transform}:host([opening]) [part=overlay]{animation:.1s lumo-menu-overlay-enter ease-out both}@keyframes lumo-menu-overlay-enter{0%{opacity:0;transform:translateY(-4px)}}:host([closing]) [part=overlay]{animation:.1s lumo-menu-overlay-exit both}@keyframes lumo-menu-overlay-exit{to{opacity:0}}}@media lumo_mixins_overlay{:host{z-index:200;position:fixed;display:flex;flex-direction:column;align-items:center;justify-content:center;width:auto;height:auto;border:none;padding:0;background-color:transparent;overflow:visible;margin:auto;pointer-events:none;-webkit-tap-highlight-color:transparent;--vaadin-overlay-viewport-bottom: 0;inset:var(--lumo-space-m) var(--lumo-space-m) var(--lumo-space-m) var(--lumo-space-m);outline:0px solid transparent}:host([hidden]),:host(:not([opened]):not([closing])),:host(:not([opened]):not([closing])) [part=overlay]{display:none!important}[part=overlay]{overflow:auto;pointer-events:auto;max-width:100%;box-sizing:border-box;-webkit-tap-highlight-color:initial;background-color:var(--lumo-base-color);background-image:linear-gradient(var(--lumo-tint-5pct),var(--lumo-tint-5pct));border-radius:var(--lumo-border-radius-m);box-shadow:0 0 0 1px var(--lumo-shade-5pct),var(--lumo-box-shadow-m);color:var(--lumo-body-text-color);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);font-weight:400;line-height:var(--lumo-line-height-m);letter-spacing:0;text-transform:none;-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}[part=backdrop]{z-index:-1;content:"";background:#00000080;position:fixed;inset:0;pointer-events:auto;background-color:var(--lumo-shade-20pct);animation:.2s lumo-overlay-backdrop-enter both;will-change:opacity}[part=content]{padding:var(--lumo-space-xs)}@keyframes lumo-overlay-backdrop-enter{0%{opacity:0}}:host([closing]) [part=backdrop]{animation:.2s lumo-overlay-backdrop-exit both}@keyframes lumo-overlay-backdrop-exit{to{opacity:0}}@keyframes lumo-overlay-dummy-animation{0%{opacity:1}to{opacity:1}}}@media lumo_components_avatar-group-menu-item{:host{padding:var(--lumo-space-xs);padding-inline-end:var(--lumo-space-m)}[part=content]{display:flex;align-items:center}[part=content] ::slotted(vaadin-avatar){width:var(--lumo-size-xs);height:var(--lumo-size-xs);margin-inline-end:var(--lumo-space-s)}}@media lumo_components_avatar-group-overlay{:host{--_lumo-list-box-item-selected-icon-display: none;--_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4)}}@media lumo_components_avatar-group{:host{display:block;width:100%;--vaadin-avatar-size: var(--lumo-size-m);--vaadin-avatar-group-overlap: 8px;--vaadin-avatar-group-overlap-border: var(--vaadin-avatar-group-gap, 2px)}:host([hidden]){display:none!important}[part=container]{display:flex;position:relative;width:100%;flex-wrap:nowrap}::slotted(vaadin-avatar:not(:first-of-type)){-webkit-mask-image:url("data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>");mask-image:url("data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>");-webkit-mask-size:calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6);mask-size:calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6)}::slotted(vaadin-avatar:not([dir="rtl"]):not(:first-of-type)){margin-left:calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));-webkit-mask-position:calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));mask-position:calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap))}::slotted(vaadin-avatar[dir="rtl"]:not(:first-of-type)){margin-right:calc(var(--vaadin-avatar-group-overlap) * -1);-webkit-mask-position:calc(50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width));mask-position:calc(50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width))}:host([theme~="xlarge"]){--vaadin-avatar-group-overlap: 12px;--vaadin-avatar-group-overlap-border: 3px;--vaadin-avatar-size: var(--lumo-size-xl)}:host([theme~="large"]){--vaadin-avatar-group-overlap: 10px;--vaadin-avatar-group-overlap-border: 3px;--vaadin-avatar-size: var(--lumo-size-l)}:host([theme~="small"]){--vaadin-avatar-group-overlap: 6px;--vaadin-avatar-group-overlap-border: 2px;--vaadin-avatar-size: var(--lumo-size-s)}:host([theme~="xsmall"]){--vaadin-avatar-group-overlap: 4px;--vaadin-avatar-group-overlap-border: 2px;--vaadin-avatar-size: var(--lumo-size-xs)}}@media lumo_components_item{:host{display:flex;align-items:center;box-sizing:border-box;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-xs);padding:.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) .5em var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));min-height:var(--lumo-size-m);outline:none;border-radius:var(--lumo-border-radius-m);cursor:var(--lumo-clickable-cursor);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:var(--lumo-primary-color-10pct);--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color))}:host([hidden]){display:none!important}[part=checkmark]:before{display:var(--_lumo-item-selected-icon-display, none);content:var(--lumo-icons-checkmark);font-family:lumo-icons;font-size:var(--lumo-icon-size-m);line-height:1;font-weight:400;width:1em;height:1em;margin:calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;color:var(--_selection-color-text);flex:none;opacity:0;transition:transform .2s cubic-bezier(.12,.32,.54,2),opacity .1s}:host([selected]) [part=checkmark]:before{opacity:1}:host([active]:not([selected])) [part=checkmark]:before{transform:scale(.8);opacity:0;transition-duration:0s}[part=content]{flex:auto}:host([disabled]){color:var(--lumo-disabled-text-color);cursor:default;pointer-events:none}@media (any-hover: hover){:host(:hover:not([disabled])){background-color:var(--lumo-primary-color-10pct)}}:host([focus-ring]:not([disabled])){box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host([dir="rtl"]){padding-left:calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);padding-right:var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4))}:host ::slotted(vaadin-icon){width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}}@media lumo_components_list-box{:host{display:flex;-webkit-tap-highlight-color:transparent;--_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block)}:host([hidden]){display:none!important}[part=items]{height:100%;width:100%;overflow-y:auto}[part=items] ::slotted(hr){height:1px;border:0;padding:0;margin:var(--lumo-space-s) var(--lumo-border-radius-m);background-color:var(--lumo-contrast-10pct)}}:is(:root,:host):before{--vaadin-avatar-group-lumo-inject: 1;--vaadin-avatar-group-lumo-inject-modules: lumo_components_avatar-group;--vaadin-avatar-group-overlay-lumo-inject: 1;--vaadin-avatar-group-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_components_avatar-group-overlay;--vaadin-avatar-group-menu-lumo-inject: 1;--vaadin-avatar-group-menu-lumo-inject-modules: lumo_components_list-box;--vaadin-avatar-group-menu-item-lumo-inject: 1;--vaadin-avatar-group-menu-item-lumo-inject-modules: lumo_components_item, lumo_components_avatar-group-menu-item}@media lumo_components_avatar{:host{--vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);border:var(--vaadin-avatar-outline-width) solid transparent;margin:calc(var(--vaadin-avatar-outline-width) * -1);color:var(--lumo-secondary-text-color);background-color:var(--lumo-contrast-10pct);outline:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;vertical-align:baseline}[part=icon]{display:flex;align-items:center;justify-content:center;font-size:var(--vaadin-avatar-size, 64px);line-height:1;mask:none;background:none}[part=icon]:before{content:var(--lumo-icons-user);font-family:lumo-icons;font-size:.9em}[part=abbr]{font-family:var(--lumo-font-family);font-size:2.4375em;font-weight:500}:host([has-color-index]){color:var(--lumo-base-color)}:host([has-color-index]):before{border:none;box-shadow:inset 0 0 0 2px var(--vaadin-avatar-user-color)}:host([focus-ring]){outline:none;border-color:var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct))}:host([theme~="xlarge"]) [part=abbr]{font-size:2.5em}:host([theme~="large"]) [part=abbr]{font-size:2.375em}:host([theme~="small"]) [part=abbr]{font-size:2.75em}:host([theme~="xsmall"]) [part=abbr]{font-size:3em}:host([theme~="xlarge"]){--vaadin-avatar-size: var(--lumo-size-xl)}:host([theme~="large"]){--vaadin-avatar-size: var(--lumo-size-l)}:host([theme~="small"]){--vaadin-avatar-size: var(--lumo-size-s)}:host([theme~="xsmall"]){--vaadin-avatar-size: var(--lumo-size-xs)}}:is(:root,:host):before{--vaadin-avatar-lumo-inject: 1;--vaadin-avatar-lumo-inject-modules: lumo_components_avatar}:where(:root,:host){--vaadin-avatar-size: var( --lumo-size-m )}@media lumo_components_button{:host{display:inline-block;position:relative;outline:none;white-space:nowrap;-webkit-user-select:none;user-select:none;--lumo-button-size: var(--lumo-size-m);min-width:var(--vaadin-button-min-width, calc(var(--_button-size) * 2));height:var(--_button-size);padding:var(--vaadin-button-padding, 0 calc(var(--_button-size) / 3 + var(--lumo-border-radius-m) / 2));margin:var(--vaadin-button-margin, var(--lumo-space-xs) 0);box-sizing:border-box;font-family:var(--lumo-font-family);font-size:var(--vaadin-button-font-size, var(--lumo-font-size-m));font-weight:var(--vaadin-button-font-weight, 500);color:var(--_lumo-button-text-color);background:var(--_lumo-button-background);border:var(--vaadin-button-border, none);border-radius:var(--vaadin-button-border-radius, var(--lumo-border-radius-m));cursor:var(--lumo-clickable-cursor);-webkit-tap-highlight-color:transparent;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;flex-shrink:0;--_button-size: var(--vaadin-button-height, var(--lumo-button-size));--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_lumo-button-background: var(--vaadin-button-background, var(--lumo-contrast-5pct));--_lumo-button-text-color: var(--vaadin-button-text-color, var(--lumo-primary-text-color));--_lumo-button-primary-background: var(--vaadin-button-primary-background, var(--lumo-primary-color));--_lumo-button-primary-text-color: var(--vaadin-button-primary-text-color, var(--lumo-primary-contrast-color))}:host([hidden]){display:none!important}.vaadin-button-container{display:inline-flex;align-items:center;justify-content:center;text-align:center;width:100%;height:100%;min-height:inherit;text-shadow:inherit}.vaadin-button-container:before{content:" ";display:inline-block;width:0;max-height:100%}[part=prefix],[part=suffix]{flex:none}[part=label],[part=prefix],[part=suffix]{line-height:var(--lumo-line-height-xs)}[part=label]{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;padding:calc(var(--lumo-button-size) / 6) 0}:host([theme~="small"]){font-size:var(--lumo-font-size-s);--lumo-button-size: var(--lumo-size-s)}:host([theme~="large"]){font-size:var(--lumo-font-size-l);--lumo-button-size: var(--lumo-size-l)}:host:before,:host:after{content:"";position:absolute;z-index:1;inset:0;background-color:currentColor;border-radius:inherit;opacity:0;pointer-events:none}@media (any-hover: hover){:host(:not([disabled]):hover):before{opacity:.02}}:host:after{transition:opacity 1.4s,transform .1s;filter:blur(8px)}:host([active]):before{opacity:.05;transition-duration:0s}:host([active]):after{opacity:.1;transition-duration:0s,0s;transform:scale(0)}:host([focus-ring]){box-shadow:0 0 0 calc(1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-gap-color, var(--lumo-base-color)),0 0 0 calc(var(--_focus-ring-width) + 1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-color)}:host([theme~="primary"][focus-ring]){--_focus-ring-gap-on: 1}:host([theme~="tertiary"]),:host([theme~="tertiary-inline"]){--_background: transparent !important;background:var(--vaadin-button-tertiary-background, var(--_background));min-width:0}:host([theme~="tertiary"]){border:var(--vaadin-button-tertiary-border, none);color:var(--vaadin-button-tertiary-text-color, var(--lumo-primary-text-color));font-weight:var(--vaadin-button-tertiary-font-weight, 500);padding:var(--vaadin-button-tertiary-padding, 0 calc(var(--_button-size) / 6))}:host([theme~="tertiary-inline"]):before{display:none}:host([theme~="tertiary-inline"]){margin:0;height:auto;padding:0;line-height:inherit;font-size:inherit}:host([theme~="tertiary-inline"]) [part=label]{padding:0;overflow:visible;line-height:inherit}:host([theme~="primary"]){background:var(--_lumo-button-primary-background);border:var(--vaadin-button-primary-border, none);color:var(--_lumo-button-primary-text-color);font-weight:var(--vaadin-button-primary-font-weight, 600);min-width:calc(var(--lumo-button-size) * 2.5)}:host([theme~="primary"]):before{background-color:#000}@media (any-hover: hover){:host([theme~="primary"]:not([disabled]):hover):before{opacity:.05}}:host([theme~="primary"][active]):before{opacity:.1}:host([theme~="primary"][active]):after{opacity:.2}:host([theme~="success"]){color:var(--lumo-success-text-color)}:host([theme~="success"][theme~="primary"]){background-color:var(--lumo-success-color);color:var(--lumo-success-contrast-color)}:host([theme~="warning"]){color:var(--lumo-warning-text-color)}:host([theme~="warning"][theme~="primary"]){background-color:var(--lumo-warning-color);color:var(--lumo-warning-contrast-color)}:host([theme~="error"]){color:var(--lumo-error-text-color)}:host([theme~="error"][theme~="primary"]){background-color:var(--lumo-error-color);color:var(--lumo-error-contrast-color)}:host([theme~="contrast"]){color:var(--lumo-contrast)}:host([theme~="contrast"][theme~="primary"]){background-color:var(--lumo-contrast);color:var(--lumo-base-color)}:host([disabled]){color:var(--lumo-disabled-text-color);pointer-events:var(--_vaadin-button-disabled-pointer-events, none);cursor:not-allowed}:host([theme~="primary"][disabled]){background-color:var(--lumo-contrast-30pct);color:var(--lumo-base-color)}:host([theme~="primary"][disabled]) [part]{opacity:.7}[part] ::slotted(vaadin-icon){width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}[part] ::slotted(vaadin-icon[icon^="vaadin:"]){padding:.25em;box-sizing:border-box!important}[part=prefix]{margin-left:-.25em;margin-right:.25em}[part=suffix]{margin-left:.25em;margin-right:-.25em}:host([theme~="icon"]:not([theme~="tertiary-inline"])){min-width:var(--lumo-button-size);padding-left:calc(var(--lumo-button-size) / 4);padding-right:calc(var(--lumo-button-size) / 4)}:host([theme~="icon"]) [part=prefix],:host([theme~="icon"]) [part=suffix]{margin-left:0;margin-right:0}:host([dir="rtl"]) [part=prefix]{margin-left:.25em;margin-right:-.25em}:host([dir="rtl"]) [part=suffix]{margin-left:-.25em;margin-right:.25em}:host([dir="rtl"][theme~="icon"]) [part=prefix],:host([dir="rtl"][theme~="icon"]) [part=suffix]{margin-left:0;margin-right:0}@media (forced-colors: active){:host{outline:1px solid;outline-offset:-1px}:host([focused]){outline-width:2px}:host([disabled]){outline-color:GrayText}}}:is(:root,:host):before{--vaadin-button-lumo-inject: 1;--vaadin-button-lumo-inject-modules: lumo_components_button}@media lumo_components_card{:host:before{inset:var(--_card-border-inset, 0);border-radius:var(--_card-border-pseudo-radius, inherit)}:host([theme~="outlined"]){--vaadin-card-border-width: 1px;--vaadin-card-background: var(--lumo-base-color)}:host([theme~="elevated"]){--vaadin-card-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color);--vaadin-card-shadow: var(--lumo-box-shadow-xs);--vaadin-card-border-width: 1px;--_card-border-inset: calc(-1 * var(--vaadin-card-border-width));--_card-border-pseudo-radius: calc(var(--vaadin-card-border-radius) + var(--vaadin-card-border-width))}:host([theme~="elevated"]:not([theme~="outlined"])){--vaadin-card-border-color: var(--lumo-contrast-10pct)}:host(:where([theme~="stretch-media"])) ::slotted([slot="media"]:is(img,video,svg,vaadin-icon)){border-radius:var(--lumo-border-radius-m)}:host([theme~="elevated"][theme~="cover-media"]) ::slotted([slot="media"]:is(img,video,svg,vaadin-icon)){margin-top:calc((var(--_padding) + var(--vaadin-card-border-width)) * -1);margin-inline:calc((var(--_padding) + var(--vaadin-card-border-width)) * -1);width:calc(100% + (var(--_padding) + var(--vaadin-card-border-width)) * 2)}}:is(:root,:host):before{--vaadin-card-lumo-inject: 1;--vaadin-card-lumo-inject-modules: lumo_components_card}:where(:root,:host){--vaadin-card-background: var( --lumo-contrast-5pct );--vaadin-card-border-radius: var( --lumo-border-radius-l );--vaadin-card-border-width: 0;--vaadin-card-border-color: var( --lumo-contrast-20pct );--vaadin-card-padding: var( --lumo-space-m );--vaadin-card-gap: var( --lumo-space-m );--vaadin-card-shadow: none;--vaadin-card-title-font-color: var( --lumo-header-text-color );--vaadin-card-title-font-size: var( --lumo-font-size-l );--vaadin-card-title-font-weight: 600;--vaadin-card-title-line-height: var( --lumo-line-height-xs );--vaadin-card-subtitle-font-color: var( --lumo-secondary-text-color );--vaadin-card-subtitle-font-size: var( --lumo-font-size-m );--vaadin-card-subtitle-line-height: var( --lumo-line-height-xs )}@media lumo_components_chart{:host,:root{--vaadin-charts-background: var(--lumo-base-color);--vaadin-charts-title-label: var(--lumo-header-text-color);--vaadin-charts-axis-title: var(--lumo-secondary-text-color);--vaadin-charts-axis-label: var(--lumo-secondary-text-color);--vaadin-charts-data-label: var(--lumo-body-text-color);--vaadin-charts-secondary-label: var(--lumo-secondary-text-color);--vaadin-charts-axis-line: var(--lumo-contrast-5pct);--vaadin-charts-grid-line: var(--lumo-contrast-20pct);--vaadin-charts-disabled-label: var(--lumo-disabled-text-color);--vaadin-charts-contrast: var(--lumo-contrast);--vaadin-charts-tooltip-background: var(--lumo-base-color);--vaadin-charts-tooltip-border-color: inherit;--vaadin-charts-button-label: var(--lumo-primary-text-color);--vaadin-charts-button-background: var(--lumo-contrast-5pct);--vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);--vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);--vaadin-charts-button-active-background: var(--lumo-primary-color);--vaadin-charts-button-border-radius: 2px;--vaadin-charts-xaxis-line-width: 0;--vaadin-charts-tooltip-background-opacity: 1;--vaadin-charts-color-0: #5ac2f7;--vaadin-charts-color-1: #1676f3;--vaadin-charts-color-2: #ff7d94;--vaadin-charts-color-3: #c5164e;--vaadin-charts-color-4: #15c15d;--vaadin-charts-color-5: #0e8151;--vaadin-charts-color-6: #c18ed2;--vaadin-charts-color-7: #9233b3;--vaadin-charts-color-8: #fda253;--vaadin-charts-color-9: #e24932;--vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);--vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);font-family:var(--lumo-font-family)}:host([theme~="gradient"]){--vaadin-charts-color-0: #1676f3;--vaadin-charts-color-1: #13bbf0;--vaadin-charts-color-2: #1ee;--vaadin-charts-color-3: #0cd9bf;--vaadin-charts-color-4: #06be81;--vaadin-charts-color-5: #00a344;--vaadin-charts-color-6: #41c639;--vaadin-charts-color-7: #8aed2c;--vaadin-charts-color-8: #c0e632;--vaadin-charts-color-9: #f6db3a;--vaadin-charts-color-positive: var(--vaadin-charts-color-6);--vaadin-charts-color-negative: var(--vaadin-charts-color-1)}:host([theme~="monotone"]){--vaadin-charts-color-0: #1676f3;--vaadin-charts-color-1: #4795f5;--vaadin-charts-color-2: #71b0f7;--vaadin-charts-color-3: #a0cef9;--vaadin-charts-color-4: #bce0fa;--vaadin-charts-color-5: #a8d8ed;--vaadin-charts-color-6: #7fc3dd;--vaadin-charts-color-7: #54adcc;--vaadin-charts-color-8: #2b99bc;--vaadin-charts-color-9: #0284ac;--vaadin-charts-color-positive: var(--vaadin-charts-color-3);--vaadin-charts-color-negative: var(--vaadin-charts-color-9)}:host([theme~="classic"]){--vaadin-charts-color-0: #7cb5ec;--vaadin-charts-color-1: #434348;--vaadin-charts-color-2: #90ed7d;--vaadin-charts-color-3: #f7a35c;--vaadin-charts-color-4: #8085e9;--vaadin-charts-color-5: #f15c80;--vaadin-charts-color-6: #e4d354;--vaadin-charts-color-7: #2b908f;--vaadin-charts-color-8: #f45b5b;--vaadin-charts-color-9: #91e8e1}}:is(:root,:host):before{--vaadin-chart-lumo-inject: 1;--vaadin-chart-lumo-inject-modules: lumo_components_chart}@media lumo_mixins_field-error-message{[part=error-message]{margin-left:calc(var(--lumo-border-radius-m) / 4);font-size:var(--vaadin-input-field-error-font-size, var(--lumo-font-size-xs));line-height:var(--lumo-line-height-xs);font-weight:var(--vaadin-input-field-error-font-weight, 400);color:var(--vaadin-input-field-error-color, var(--lumo-error-text-color));will-change:max-height;transition:.4s max-height;max-height:5em}:host([has-error-message]) [part=error-message]:before,:host([has-error-message]) [part=error-message]:after{content:"";display:block;height:.4em}:host(:not([invalid])) [part=error-message]{max-height:0;overflow:hidden}:host([dir="rtl"]) [part=error-message]{margin-left:0;margin-right:calc(var(--lumo-border-radius-m) / 4)}}@media lumo_mixins_field-helper{:host{--_helper-spacing: var(--vaadin-input-field-helper-spacing, .4em)}:host([has-helper]) [part=helper-text]:before{content:"";display:block;height:var(--_helper-spacing)}[part=helper-text]{display:block;color:var(--vaadin-input-field-helper-color, var(--lumo-secondary-text-color));font-size:var(--vaadin-input-field-helper-font-size, var(--lumo-font-size-xs));line-height:var(--lumo-line-height-xs);font-weight:var(--vaadin-input-field-helper-font-weight, 400);margin-left:calc(var(--lumo-border-radius-m) / 4);transition:color .2s}:host(:hover:not([readonly])) [part=helper-text]{color:var(--lumo-body-text-color)}:host([disabled]) [part=helper-text]{color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color)}:host([has-helper][theme~="helper-above-field"]) [part=helper-text]:before{display:none}:host([has-helper][theme~="helper-above-field"]) [part=helper-text]:after{content:"";display:block;height:var(--_helper-spacing)}:host([has-helper][theme~="helper-above-field"]) [part=label]{order:0;padding-bottom:var(--_helper-spacing)}:host([has-helper][theme~="helper-above-field"]) [part=helper-text]{order:1}:host([has-helper][theme~="helper-above-field"]) [part=label]+*{order:2}:host([has-helper][theme~="helper-above-field"]) [part=error-message]{order:3}}@media lumo_mixins_field-label{[part=label]{align-self:flex-start;color:var(--vaadin-input-field-label-color, var(--lumo-secondary-text-color));font-weight:var(--vaadin-input-field-label-font-weight, 500);font-size:var(--vaadin-input-field-label-font-size, var(--lumo-font-size-s));transition:color .2s;line-height:1;padding-inline:calc(var(--lumo-border-radius-m) / 4) 1em;padding-bottom:.5em;padding-top:.25em;margin-top:-.25em;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;position:relative;max-width:100%;box-sizing:border-box}:host([focused]:not([readonly])) [part=label]{color:var(--vaadin-input-field-focused-label-color, var(--lumo-primary-text-color))}:host(:hover:not([readonly]):not([focused])) [part=label]{color:var(--vaadin-input-field-hovered-label-color, var(--lumo-body-text-color))}@media (pointer: coarse){:host(:hover:not([readonly]):not([focused])) [part=label]{color:var(--vaadin-input-field-label-color, var(--lumo-secondary-text-color))}}:host(:not([has-label])) [part=label]{display:none}:host([has-label]):before{margin-top:calc(var(--lumo-font-size-s) * 1.5)}:host([has-label][theme~="small"]):before{margin-top:calc(var(--lumo-font-size-xs) * 1.5)}:host([has-label]){padding-top:var(--lumo-space-m)}:host([has-label]) ::slotted([slot="tooltip"]){--vaadin-tooltip-offset-bottom: calc((var(--lumo-space-m) - var(--lumo-space-xs)) * -1)}}@media lumo_mixins_field-required{:host([required]) [part=required-indicator]:after{content:var(--lumo-required-field-indicator, "•");color:var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));position:absolute;right:0;width:1em;text-align:center}:host([invalid]) [part=required-indicator]:after{color:var(--lumo-required-field-indicator-color, var(--lumo-error-text-color))}:host([dir="rtl"]) [part=required-indicator]:after{right:auto;left:0}}@media lumo_mixins_group-field{:host{display:inline-flex;color:var(--lumo-body-text-color);font-size:var(--lumo-font-size-m);font-family:var(--lumo-font-family);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:transparent;padding:var(--lumo-space-xs) 0}:host:before{content:" ";width:0;height:var(--lumo-size-s);box-sizing:border-box;display:inline-flex;align-items:center}:host([hidden]){display:none!important}.vaadin-group-field-container{display:flex;flex-direction:column;width:100%}[part=group-field]{display:flex;flex-wrap:wrap}:host(:not([has-label])) [part=label]{display:none}:host([theme~="vertical"]) [part=group-field]{flex-direction:column}:host([disabled]) [part=label]{color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color)}:host([focused]:not([readonly])) [part=label]{color:var(--lumo-primary-text-color)}}@media lumo_components_checkbox-group{:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=label],:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=helper-text]{color:var(--lumo-body-text-color)}@media (pointer: coarse){:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=label]{color:var(--lumo-secondary-text-color)}}}@media lumo_mixins_checkable-field{:host{display:inline-block}:host([hidden]){display:none!important}:host([disabled]){-webkit-tap-highlight-color:transparent}.vaadin-checkbox-container,.vaadin-radio-button-container{display:grid;grid-template-columns:auto 1fr;align-items:baseline}[part=checkbox],[part=radio],[part=label],::slotted(input),::slotted(label){grid-row:1}[part=checkbox],[part=radio],::slotted(input){grid-column:1}[part=checkbox],[part=radio]{width:var(--_input-size, 1em);height:var(--_input-size, 1em);--_input-border-width: var(--vaadin-input-field-border-width, 0);--_input-border-color: var(--vaadin-input-field-border-color, transparent);box-shadow:inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color)}[part=checkbox]:before,[part=radio]:before{display:block;content:" ";line-height:var(--_input-size, 1em);contain:paint}::slotted(input){cursor:inherit;margin:0;align-self:stretch;-webkit-appearance:none;appearance:none;width:initial;height:initial}}@media lumo_components_checkbox{:host{color:var(--vaadin-checkbox-label-color, var(--lumo-body-text-color));font-size:var(--vaadin-checkbox-label-font-size, var(--lumo-font-size-m));font-family:var(--lumo-font-family);line-height:var(--lumo-line-height-s);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:transparent;-webkit-user-select:none;user-select:none;cursor:default;outline:none;--_checkbox-size: var(--vaadin-checkbox-size, calc(var(--lumo-size-m) / 2));--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));--_invalid-background: var(--vaadin-input-field-invalid-background, var(--lumo-error-color-10pct));--_disabled-checkmark-color: var(--vaadin-checkbox-disabled-checkmark-color, var(--lumo-contrast-30pct))}[part=label]{display:flex;position:relative;max-width:max-content}:host([has-label]) ::slotted(label){padding:var( --vaadin-checkbox-label-padding, var(--lumo-space-xs) var(--lumo-space-s) var(--lumo-space-xs) var(--lumo-space-xs) )}:host([dir="rtl"][has-label]) ::slotted(label){padding:var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-s)}:host([has-label][required]) ::slotted(label){padding-inline-end:var(--lumo-space-m)}[part=checkbox]{--_input-size: var(--_checkbox-size);margin:var(--lumo-space-xs);position:relative;border-radius:var(--vaadin-checkbox-border-radius, var(--lumo-border-radius-s));background:var(--vaadin-checkbox-background, var(--lumo-contrast-20pct));transition:transform .2s cubic-bezier(.12,.32,.54,2),background-color .15s;cursor:var(--lumo-clickable-cursor);--_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct))}:host([indeterminate]),:host([checked]){--vaadin-input-field-border-color: transparent}:host([indeterminate]) [part=checkbox],:host([checked]) [part=checkbox]{background-color:var(--_selection-color)}[part=checkbox]:before{pointer-events:none;color:transparent;width:100%;height:100%;border-radius:inherit;background-color:inherit;transform:scale(1.4);opacity:0;transition:transform .1s,opacity .8s}[part=checkbox]:after{pointer-events:none;font-family:lumo-icons;content:var(--vaadin-checkbox-checkmark-char, var(--lumo-icons-checkmark));color:var(--vaadin-checkbox-checkmark-color, var(--lumo-primary-contrast-color));font-size:var(--vaadin-checkbox-checkmark-size, calc(var(--_checkbox-size) + 2px));line-height:1;position:absolute;top:-1px;left:-1px;contain:content;opacity:0}:host([checked]) [part=checkbox]:after{opacity:1}:host([readonly]:not([checked]):not([indeterminate])){color:var(--lumo-secondary-text-color)}:host([readonly]:not([checked]):not([indeterminate])) [part=checkbox]{background:transparent;box-shadow:none}:host([readonly]:not([checked]):not([indeterminate])) [part=checkbox]:after{content:"";box-sizing:border-box;width:100%;height:100%;border-radius:inherit;top:0;left:0;opacity:1;border:var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-50pct))}:host([indeterminate]) [part=checkbox]:after{content:var(--vaadin-checkbox-checkmark-char-indeterminate, "");opacity:1;top:45%;height:10%;left:22%;right:22%;width:auto;border:0;background-color:var(--lumo-primary-contrast-color)}:host([focus-ring]) [part=checkbox]{box-shadow:0 0 0 1px var(--lumo-base-color),0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color),inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color)}:host([focus-ring][readonly]:not([checked]):not([indeterminate])) [part=checkbox]{box-shadow:0 0 0 1px var(--lumo-base-color),0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color)}:host([disabled]){pointer-events:none;--vaadin-input-field-border-color: var(--lumo-contrast-20pct)}:host([disabled]) ::slotted(label){color:inherit}:host([disabled]) [part=checkbox]{background-color:var(--vaadin-checkbox-disabled-background, var(--lumo-contrast-10pct))}:host([disabled]) [part=checkbox]:after{color:var(--_disabled-checkmark-color)}:host([disabled]) [part=label],:host([disabled]) [part=helper-text]{color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color)}:host([indeterminate][disabled]) [part=checkbox]:after{background-color:var(--_disabled-checkmark-color)}:host([readonly][checked]:not([disabled])) [part=checkbox],:host([readonly][indeterminate]:not([disabled])) [part=checkbox]{background-color:var(--vaadin-checkbox-readonly-checked-background, var(--lumo-contrast-70pct))}:host(:not([checked]):not([indeterminate]):not([disabled]):not([readonly]):not([invalid]):hover) [part=checkbox]{background:var(--vaadin-checkbox-background-hover, var(--lumo-contrast-30pct))}@media (pointer: coarse){:host(:not([checked]):not([indeterminate]):not([disabled]):not([readonly]):not([invalid]):hover) [part=checkbox]{background:var(--vaadin-checkbox-background, var(--lumo-contrast-20pct))}}:host([active]) [part=checkbox]{transform:scale(.9);transition-duration:.05s}:host([active][checked]) [part=checkbox]{transform:scale(1.1)}:host([active]:not([checked])) [part=checkbox]:before{transition-duration:.01s,.01s;transform:scale(0);opacity:.4}:host([required]) [part=required-indicator]{position:absolute;top:var(--lumo-space-xs);right:var(--lumo-space-xs)}:host([required][dir="rtl"]) [part=required-indicator]{right:auto;left:var(--lumo-space-xs)}:host([required]) [part=required-indicator]:after{content:var(--lumo-required-field-indicator, "•");transition:opacity .2s;color:var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));width:1em;text-align:center}:host(:not([has-label])) [part=required-indicator]{display:none}:host([invalid]){--vaadin-input-field-border-color: var(--lumo-error-color)}:host([invalid]) [part=checkbox]{background-color:var(--_invalid-background);background-image:linear-gradient(var(--_invalid-background) 0%,var(--_invalid-background) 100%)}:host([invalid]:hover) [part=checkbox]{background-image:linear-gradient(var(--_invalid-background) 0%,var(--_invalid-background) 100%),linear-gradient(var(--_invalid-background) 0%,var(--_invalid-background) 100%)}:host([invalid][focus-ring]){--_focus-ring-color: var(--lumo-error-color-50pct)}:host([invalid]) [part=required-indicator]:after{color:var(--lumo-required-field-indicator-color, var(--lumo-error-text-color))}[part=error-message]{font-size:var(--vaadin-input-field-error-font-size, var(--lumo-font-size-xs));line-height:var(--lumo-line-height-xs);font-weight:var(--vaadin-input-field-error-font-weight, 400);color:var(--vaadin-input-field-error-color, var(--lumo-error-text-color));will-change:max-height;transition:.4s max-height;max-height:5em;padding-inline-start:var(--lumo-space-xs)}[part=helper-text],[part=error-message]{grid-column:2}:host(:not([has-helper])) [part=helper-text],:host(:not([has-error-message])) [part=error-message]{display:none}:host([has-error-message]) [part=error-message]:after,:host([has-helper]) [part=helper-text]:after{content:"";display:block;height:.4em}:host(:not([invalid])) [part=error-message]{max-height:0;overflow:hidden}[part=helper-text]{display:block;color:var(--vaadin-input-field-helper-color, var(--lumo-secondary-text-color));font-size:var(--vaadin-input-field-helper-font-size, var(--lumo-font-size-xs));line-height:var(--lumo-line-height-xs);font-weight:var(--vaadin-input-field-helper-font-weight, 400);margin-left:calc(var(--lumo-border-radius-m) / 4);transition:color .2s;padding-inline-start:var(--lumo-space-xs)}:host(:hover:not([readonly])) [part=helper-text]{color:var(--lumo-body-text-color)}:host([has-error-message]) ::slotted(label),:host([has-helper]) ::slotted(label){padding-bottom:0}@media (forced-colors: active){[part=checkbox]{outline:1px solid;outline-offset:-1px}:host([disabled]) [part=checkbox],:host([disabled]) [part=checkbox]:after{outline-color:GrayText}:host(:is([checked],[indeterminate])) [part=checkbox]:after{outline:1px solid;outline-offset:-1px;border-radius:inherit}:host([focused]) [part=checkbox],:host([focused]) [part=checkbox]:after{outline-width:2px}}}:is(:root,:host):before{--vaadin-checkbox-lumo-inject: 1;--vaadin-checkbox-lumo-inject-modules: lumo_mixins_checkable-field, lumo_components_checkbox}:is(:root,:host):before{--vaadin-checkbox-group-lumo-inject: 1;--vaadin-checkbox-group-lumo-inject-modules: lumo_mixins_group-field, lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-helper, lumo_components_checkbox-group}@media lumo_mixins_combo-box-loader{[part=loader]{position:absolute;z-index:1;inset-inline:var(--lumo-space-s);top:var(--lumo-space-s);margin-inline:auto 0}}@media lumo_mixins_combo-box-overlay{[part=content]{display:flex;flex-direction:column;height:100%;padding:0}:host(:not([closing])) [part=content]{min-height:calc(2 * var(--lumo-space-s) + var(--lumo-icon-size-s))}[part=overlay]{position:relative}:host([top-aligned]) [part=overlay]{margin-top:var(--lumo-space-xs)}:host([bottom-aligned]) [part=overlay]{margin-bottom:var(--lumo-space-xs)}}@media lumo_mixins_field-base{:host{display:inline-flex;outline:none;--lumo-text-field-size: var(--lumo-size-m);color:var(--vaadin-input-field-value-color, var(--lumo-body-text-color));font-size:var(--vaadin-input-field-value-font-size, var(--lumo-font-size-m));font-family:var(--lumo-font-family);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:transparent;padding:var(--lumo-space-xs) 0;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_input-height: var(--vaadin-input-field-height, var(--lumo-text-field-size));--_disabled-value-color: var(--vaadin-input-field-disabled-value-color, var(--lumo-disabled-text-color))}:host:before{content:" ";width:0;height:var(--_input-height);box-sizing:border-box;display:inline-flex;align-items:center}[class$=container]{display:flex;flex-direction:column;min-width:100%;max-width:100%;width:var(--vaadin-field-default-width, 12em)}:host([hidden]){display:none!important}:host([focused]) [part=input-field] ::slotted(:is(input,textarea)){-webkit-mask-image:none;mask-image:none}::slotted(:is(input,textarea):placeholder-shown){color:var(--vaadin-input-field-placeholder-color, var(--lumo-secondary-text-color))}:host(:hover:not([readonly]):not([focused]):not([disabled])) [part=input-field]:after{opacity:var(--vaadin-input-field-hover-highlight-opacity, .1)}@media (pointer: coarse){:host(:hover:not([readonly]):not([focused]):not([disabled])) [part=input-field]:after{opacity:0}:host(:active:not([readonly]):not([focused]):not([disabled])) [part=input-field]:after{opacity:.2}}:host([focused]:not([focus-ring]):not([readonly])) [part=input-field]:after{transform:scaleX(0);transition-duration:.15s,1s}:host([focused]) [part=input-field]{--_pointer-focus-visible: clamp(0, var(--lumo-input-field-pointer-focus-visible, 0), 1);--_conditional-border-width: calc(calc(1 - var(--_pointer-focus-visible)) * var(--_input-border-width));--_conditional-focus-ring-width: calc(var(--_pointer-focus-visible) * var(--_focus-ring-width));box-shadow:inset 0 0 0 var(--_conditional-border-width) var(--_input-border-color),0 0 0 var(--_conditional-focus-ring-width) var(--_focus-ring-color)}:host([focus-ring]) [part=input-field]{box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host(:is([readonly],[disabled])) ::slotted(:is(input,textarea):placeholder-shown){opacity:0}:host([readonly]){--vaadin-input-field-border-color: transparent}:host([disabled]){pointer-events:none;--vaadin-input-field-border-color: var(--lumo-contrast-20pct)}:host([disabled]) [part=label],:host([disabled]) [part=input-field] ::slotted([slot$="fix"]){color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color)}:host([disabled]) [part=input-field] ::slotted(:not([slot$="fix"])){color:var(--_disabled-value-color);-webkit-text-fill-color:var(--_disabled-value-color)}:host([invalid]){--vaadin-input-field-border-color: var(--lumo-error-color);--_focus-ring-color: var(--lumo-error-color-50pct)}:host([input-prevented]) [part=input-field]{animation:shake .15s infinite}@keyframes shake{25%{transform:translate(4px)}75%{transform:translate(-4px)}}:host([theme~="small"]){font-size:var(--lumo-font-size-s);--lumo-text-field-size: var(--lumo-size-s)}:host([theme~="small"]) [part=label]{font-size:var(--lumo-font-size-xs)}:host([theme~="small"]) [part=error-message]{font-size:var(--lumo-font-size-xxs)}[part=input-field] ::slotted(:not(vaadin-icon):not(input):not(textarea)){color:var(--lumo-secondary-text-color);font-weight:400}[part=clear-button]:before{content:var(--lumo-icons-cross)}@media (forced-colors: active){:host(:not([readonly])) [part=input-field]{outline:1px solid;outline-offset:-1px}:host([focused]) [part=input-field]{outline-width:2px}:host([disabled]) [part=input-field]{outline-color:GrayText}}}@media lumo_mixins_field-button{[part$=button]{flex:none;width:1em;height:1em;line-height:1;font-size:var(--lumo-icon-size-m);text-align:center;color:var(--lumo-contrast-60pct);transition:.2s color;cursor:var(--lumo-clickable-cursor)}[part$=button]:hover{color:var(--lumo-contrast-90pct)}:host([disabled]) [part$=button],:host([readonly]) [part$=button]{color:var(--lumo-contrast-20pct);cursor:default}[part$=button]:before{font-family:lumo-icons;display:block}[part=clear-button]{display:none;cursor:default}[part=clear-button]:before{content:"✕"}:host([clear-button-visible][has-value]:not([disabled]):not([readonly])) [part=clear-button]{display:block}}@media lumo_mixins_loader{[part=loader]{box-sizing:border-box;width:var(--lumo-icon-size-s);height:var(--lumo-icon-size-s);border:2px solid transparent;border-color:var(--lumo-primary-color-10pct) var(--lumo-primary-color-10pct) var(--lumo-primary-color) var(--lumo-primary-color);border-radius:calc(.5 * var(--lumo-icon-size-s));opacity:0;pointer-events:none}:host(:not([loading])) [part=loader]{display:none}:host([loading]) [part=loader]{animation:1s linear infinite lumo-loader-rotate,.3s .1s lumo-loader-fade-in both}@keyframes lumo-loader-fade-in{0%{opacity:0}to{opacity:1}}@keyframes lumo-loader-rotate{0%{transform:rotate(0)}to{transform:rotate(360deg)}}}@media lumo_components_combo-box-item{:host{transition:background-color .1s;overflow:hidden;--_lumo-item-selected-icon-display: block;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([focused]:not([disabled])){box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}}@media lumo_components_combo-box-overlay{:host{--_vaadin-combo-box-items-container-border-width: var(--lumo-space-xs);--_vaadin-combo-box-items-container-border-style: solid}#overlay{width:var(--vaadin-combo-box-overlay-width, var(--_vaadin-combo-box-overlay-default-width, auto))}}@media lumo_components_combo-box{:host([opened]){pointer-events:auto}[part=toggle-button]:before{content:var(--lumo-icons-dropdown)}}@media lumo_components_input-container{:host{display:flex;align-items:center;flex:0 1 auto;--_border-radius: var(--vaadin-input-field-border-radius, 0);--_input-border-width: var(--vaadin-input-field-border-width, 0px);box-shadow:inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color);background:var(--_background);padding:0 calc(.375em + var(--_input-container-radius) / 4 - 1px);font-weight:var(--vaadin-input-field-value-font-weight, 500);line-height:1;position:relative;cursor:text;box-sizing:border-box;border-radius:var(--vaadin-input-field-top-start-radius, var(--_input-container-radius)) var(--vaadin-input-field-top-end-radius, var(--_input-container-radius)) var(--vaadin-input-field-bottom-end-radius, var(--_input-container-radius)) var(--vaadin-input-field-bottom-start-radius, var(--_input-container-radius));--_input-container-radius: var(--vaadin-input-field-border-radius, var(--lumo-border-radius-m));--_input-height: var(--lumo-text-field-size, var(--lumo-size-m));--_background: var(--vaadin-input-field-background, var(--lumo-contrast-10pct));--_hover-highlight: var(--vaadin-input-field-hover-highlight, var(--lumo-contrast-50pct));--_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct));--_icon-color: var(--vaadin-input-field-icon-color, var(--lumo-contrast-60pct));--_icon-size: var(--vaadin-input-field-icon-size, var(--lumo-icon-size-m));--_invalid-background: var(--vaadin-input-field-invalid-background, var(--lumo-error-color-10pct));--_invalid-hover-highlight: var(--vaadin-input-field-invalid-hover-highlight, var(--lumo-error-color-50pct));--_disabled-background: var(--vaadin-input-field-disabled-background, var(--lumo-contrast-5pct));--_disabled-value-color: var(--vaadin-input-field-disabled-value-color, var(--lumo-disabled-text-color))}:host([dir="rtl"]){border-radius:var(--vaadin-input-field-top-end-radius, var(--_input-container-radius)) var(--vaadin-input-field-top-start-radius, var(--_input-container-radius)) var(--vaadin-input-field-bottom-start-radius, var(--_input-container-radius)) var(--vaadin-input-field-bottom-end-radius, var(--_input-container-radius))}:host:after{content:"";position:absolute;inset:0;border-radius:inherit;pointer-events:none;background:var(--_hover-highlight);opacity:0;transition:transform .15s,opacity .2s;transform-origin:100% 0}:host([hidden]){display:none!important}::slotted(input){-webkit-appearance:none;appearance:none;flex:auto;white-space:nowrap;overflow:hidden;width:100%;height:100%;outline:none;margin:0;padding:0;border:0;border-radius:0;min-width:0;font:inherit;line-height:normal;color:inherit;background-color:transparent;box-shadow:none}::slotted(*){flex:none}::slotted(:is(input,textarea))::placeholder{font:inherit;color:inherit;opacity:1}::slotted(:not([slot$="fix"])){cursor:inherit;min-height:var(--vaadin-input-field-height, var(--_input-height));padding:0 .25em;--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);-webkit-mask-image:var(--_lumo-text-field-overflow-mask-image);mask-image:var(--_lumo-text-field-overflow-mask-image)}:host([readonly]){color:var(--lumo-secondary-text-color);background-color:transparent;cursor:default}:host([readonly]):after{background-color:transparent;opacity:1;border:var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-30pct))}:host([disabled]){background:var(--_disabled-background)}:host([disabled]) ::slotted(:not([slot$="fix"])){-webkit-text-fill-color:var(--_disabled-value-color);color:var(--_disabled-value-color)}:host([invalid]){background:var(--_invalid-background)}:host([invalid]:not([readonly])):after{background:var(--_invalid-hover-highlight)}::slotted(vaadin-icon){color:var(--_icon-color);width:var(--_icon-size);height:var(--_icon-size)}::slotted(vaadin-icon[icon^="vaadin:"]){padding:.25em;box-sizing:border-box!important}:host([dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent, #000 1.25em)}@-moz-document url-prefix(){:host([dir="rtl"]) ::slotted(:not([slot$="fix"])){-webkit-mask-image:var(--_lumo-text-field-overflow-mask-image);mask-image:var(--_lumo-text-field-overflow-mask-image)}}:host([theme~="align-left"]) ::slotted(:not([slot$="fix"])){text-align:start;--_lumo-text-field-overflow-mask-image: none}:host([theme~="align-center"]) ::slotted(:not([slot$="fix"])){text-align:center;--_lumo-text-field-overflow-mask-image: none}:host([theme~="align-right"]) ::slotted(:not([slot$="fix"])){text-align:end;--_lumo-text-field-overflow-mask-image: none}@-moz-document url-prefix(){:host([theme~="align-right"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent .25em, #000 1.5em)}}@-moz-document url-prefix(){:host([theme~="align-left"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent .25em, #000 1.5em)}}:host([dir="rtl"]):after{transform-origin:0% 0}:host([theme~="align-left"][dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: none}:host([theme~="align-center"][dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: none}:host([theme~="align-right"][dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: none}@-moz-document url-prefix(){:host([theme~="align-right"][dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent .25em, #000 1.5em)}}@-moz-document url-prefix(){:host([theme~="align-left"][dir="rtl"]) ::slotted(:not([slot$="fix"])){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent .25em, #000 1.5em)}}}:is(:root,:host):before{--vaadin-input-container-lumo-inject: 1;--vaadin-input-container-lumo-inject-modules: lumo_components_input-container}:is(:root,:host):before{--vaadin-combo-box-lumo-inject: 1;--vaadin-combo-box-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_combo-box;--vaadin-combo-box-item-lumo-inject: 1;--vaadin-combo-box-item-lumo-inject-modules: lumo_components_item, lumo_components_combo-box-item;--vaadin-combo-box-overlay-lumo-inject: 1;--vaadin-combo-box-overlay-lumo-inject-modules: lumo_mixins_loader, lumo_mixins_combo-box-loader, lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_combo-box-overlay, lumo_components_combo-box-overlay}@media lumo_components_confirm-dialog-overlay{[part=header]{pointer-events:auto;margin-inline-start:calc(var(--lumo-space-l) - var(--lumo-space-m));font-weight:600;line-height:var(--lumo-line-height-xs);font-size:var(--lumo-font-size-xl);color:var(--lumo-header-text-color)}::slotted([slot="header"]){display:contents!important;font:inherit!important;color:inherit!important}[part=footer]>*{pointer-events:all}[part=message]{width:25em;min-width:100%;max-width:100%}::slotted([slot$="button"][theme~="tertiary"]){padding-left:var(--lumo-space-s);padding-right:var(--lumo-space-s)}[part=cancel-button]{flex-grow:1}@media (max-width: 360px){[part=footer]{flex-direction:column-reverse;align-items:stretch;padding:var(--lumo-space-s) var(--lumo-space-l);gap:var(--lumo-space-s)}::slotted([slot$="button"]){width:100%;margin:0}}}@media lumo_components_dialog-overlay{[part=header],[part=header-content],[part=footer]{display:flex;align-items:center;flex-wrap:wrap;flex:none;pointer-events:none;z-index:1;gap:var(--lumo-space-xs) var(--lumo-space-s);line-height:var(--lumo-line-height-s)}[part=header]{flex-wrap:nowrap;padding:var(--lumo-space-m);background-color:var(--lumo-base-color);border-radius:var(--lumo-border-radius-l) var(--lumo-border-radius-l) 0 0}[part=footer]{padding:var(--lumo-space-s) var(--lumo-space-m);background-color:var(--lumo-contrast-5pct);border-radius:0 0 var(--lumo-border-radius-l) var(--lumo-border-radius-l)}[part=title]{font-size:var(--lumo-font-size-xl);font-weight:600;color:var(--lumo-header-text-color);margin-inline-start:calc(var(--lumo-space-l) - var(--lumo-space-m))}::slotted([slot="header-content"]),::slotted([slot="title"]),::slotted([slot="footer"]){display:contents;pointer-events:auto}::slotted([slot="title"]){font:inherit!important;overflow-wrap:anywhere}[part=header-content]{flex:1}:host([has-title]) [part=header-content],[part=footer]{justify-content:flex-end}:host(:not([has-title]):not([has-header])) [part=header],:host(:not([has-header])) [part=header-content],:host(:not([has-title])) [part=title],:host(:not([has-footer])) [part=footer]{display:none!important}:host(:is([has-title],[has-header],[has-footer])) [part=content]{height:auto}[part=content]{min-width:12em;padding:var(--lumo-space-l);flex:1;min-height:0}:host([overflow]) [part=content]{overflow:auto}:host([overflow~="top"]) [part=header]{box-shadow:0 1px 0 0 var(--lumo-contrast-10pct)}:host([has-bounds-set]) [part=overlay]{max-width:none}:host:before,:host:after{content:"";flex-basis:0;flex-grow:1}:host:after{flex-grow:1.1}[part=overlay]{border-radius:var(--lumo-border-radius-l);box-shadow:0 0 0 1px var(--lumo-shade-5pct),var(--lumo-box-shadow-xl);background-image:none;outline:none;-webkit-tap-highlight-color:transparent}:host(:is([has-header],[has-title])) [part=header]+[part=content]{padding-top:0}:host([theme~="no-padding"]) [part=content]{padding:0!important}:host([opening]),:host([closing]){animation:.25s lumo-overlay-dummy-animation}:host([opening]) [part=overlay]{animation:.12s .05s vaadin-dialog-enter cubic-bezier(.215,.61,.355,1) both}@keyframes vaadin-dialog-enter{0%{opacity:0;transform:scale(.95)}}:host([closing]) [part=overlay]{animation:.1s .03s vaadin-dialog-exit cubic-bezier(.55,.055,.675,.19) both}:host([closing]) [part=backdrop]{animation-delay:.05s}@keyframes vaadin-dialog-exit{to{opacity:0;transform:scale(1.02)}}@media (forced-colors: active){[part=overlay]{outline:3px solid!important}}}:is(:root,:host):before{--vaadin-confirm-dialog-overlay-lumo-inject: 1;--vaadin-confirm-dialog-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_dialog-overlay, lumo_components_confirm-dialog-overlay}@media lumo_mixins_menu-overlay-ext{@media (max-width: 450px),(max-height: 450px){:host{inset:0 0 var(--vaadin-overlay-viewport-bottom, 0) 0!important;align-items:stretch!important;justify-content:flex-end!important}[part=overlay]{max-height:50vh;width:100vw;border-radius:0;box-shadow:var(--lumo-box-shadow-xl)}[part=content]{padding:30px var(--lumo-space-m);max-height:inherit;box-sizing:border-box;overflow:auto;-webkit-mask-image:linear-gradient(transparent,#000 40px,#000 calc(100% - 40px),transparent);mask-image:linear-gradient(transparent,#000 40px,#000 calc(100% - 40px),transparent)}[part=backdrop]{display:block}:host([opening]) [part=overlay]{animation:.2s lumo-mobile-menu-overlay-enter cubic-bezier(.215,.61,.355,1) both}:host([closing]),:host([closing]) [part=backdrop]{animation-delay:.14s}:host([closing]) [part=overlay]{animation:.14s .14s lumo-mobile-menu-overlay-exit cubic-bezier(.55,.055,.675,.19) both}}@keyframes lumo-mobile-menu-overlay-enter{0%{transform:translateY(150%)}}@keyframes lumo-mobile-menu-overlay-exit{to{transform:translateY(150%)}}}@media lumo_components_context-menu-item{:host(:hover){user-select:none;-webkit-user-select:none}:host([role="menuitem"][menu-item-checked]) [part=checkmark]:before{opacity:1}:host([aria-haspopup="true"]):after{font-family:lumo-icons;font-size:var(--lumo-icon-size-xs);content:var(--lumo-icons-angle-right);color:var(--lumo-tertiary-text-color)}:host(:not([dir="rtl"])[aria-haspopup="true"]):after{margin-right:calc(var(--lumo-space-m) * -1);padding-left:var(--lumo-space-m)}:host([expanded]){background-color:var(--lumo-primary-color-10pct)}:host([dir="rtl"][aria-haspopup="true"]):after{content:var(--lumo-icons-angle-left);margin-left:calc(var(--lumo-space-m) * -1);padding-right:var(--lumo-space-m)}}@media lumo_components_context-menu-list-box{:host{--_lumo-list-box-item-selected-icon-display: block}[part=items] ::slotted([role="menuitem"]){-webkit-tap-highlight-color:var(--lumo-primary-color-10pct);cursor:default;outline:none;border-radius:var(--lumo-border-radius-m);padding-left:calc(var(--lumo-border-radius-m) / 4);padding-right:calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4)}[part=items] ::slotted([role="menuitem"]:hover:not([disabled])),[part=items] ::slotted([role="menuitem"][expanded]:not([disabled])){background-color:var(--lumo-primary-color-10pct)}:host([dir="rtl"]) [part=items] ::slotted([role="menuitem"]){padding-left:calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);padding-right:calc(var(--lumo-border-radius-m) / 4)}@media (pointer: coarse){[part=items] ::slotted([role="menuitem"]:hover:not([expanded]):not([disabled])){background-color:transparent}}}@media lumo_components_context-menu-overlay{:host{align-items:flex-start;justify-content:flex-start;--_lumo-list-box-item-selected-icon-display: none;--_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4)}:host([right-aligned]),:host([end-aligned]){align-items:flex-end}:host([bottom-aligned]){justify-content:flex-end}[part=overlay]{background-color:#fff;outline:none}:host([phone]){inset:0 0 var(--vaadin-overlay-viewport-bottom, 0) 0!important;align-items:stretch;justify-content:flex-end}@media (forced-colors: active){[part=overlay]{outline:3px solid!important}}}:is(:root,:host):before{--vaadin-context-menu-overlay-lumo-inject: 1;--vaadin-context-menu-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_menu-overlay-ext, lumo_components_context-menu-overlay;--vaadin-context-menu-list-box-lumo-inject: 1;--vaadin-context-menu-list-box-lumo-inject-modules: lumo_components_list-box, lumo_components_context-menu-list-box;--vaadin-context-menu-item-lumo-inject: 1;--vaadin-context-menu-item-lumo-inject-modules: lumo_components_item, lumo_components_context-menu-item}@media lumo_components_crud-dialog-overlay{[part=overlay]{max-width:54em;min-width:20em;display:flex}.resizer-container{display:flex;flex-direction:column;flex-grow:1}[part=footer]{justify-content:flex-start;flex-direction:row-reverse}[part=footer] ::slotted(:not([disabled])){pointer-events:all}:host([fullscreen]){inset:0;padding:0}:host([fullscreen]) [part=overlay]{height:100vh;width:100vw;border-radius:0!important}:host([fullscreen]) [part=content]{flex:1}[part=header] ::slotted(h3){margin-top:0!important;margin-bottom:0!important;margin-inline-start:var(--lumo-space-s)}:host(:not([dir="rtl"])) ::slotted([slot="delete-button"]){margin-right:auto}:host([dir="rtl"]) ::slotted([slot="delete-button"]){margin-left:auto}}@media lumo_components_crud-edit{:host{display:block;min-width:auto;margin:0;font-family:"lumo-icons",var(--lumo-font-family);font-size:var(--lumo-icon-size-m);line-height:1;position:relative;width:var(--lumo-size-s);height:var(--lumo-size-s);outline:none}[part=icon]:before{content:var(--lumo-icons-edit);width:var(--lumo-size-m);height:var(--lumo-size-m);line-height:var(--lumo-size-m);text-align:center;position:absolute;top:calc((var(--lumo-size-m) - var(--lumo-size-s)) / -2);left:calc((var(--lumo-size-m) - var(--lumo-size-s)) / -2)}}@media lumo_components_crud{:host{--vaadin-crud-editor-max-height: 40%;--vaadin-crud-editor-max-width: 40%;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);width:100%;height:400px;font-family:var(--lumo-font-family)}:host,#main{display:flex;flex-direction:column;align-self:stretch;position:relative;overflow:hidden}#main{flex:1 1 100%;height:100%}:host([hidden]),[hidden]{display:none!important}[part=toolbar]{display:flex;flex-shrink:0;align-items:baseline;justify-content:flex-end;padding:var(--lumo-space-s) var(--lumo-space-m);background-color:var(--lumo-contrast-5pct);border-right:1px solid var(--lumo-contrast-10pct);border-left:1px solid var(--lumo-contrast-10pct);border-bottom:1px solid var(--lumo-contrast-10pct)}:host([no-toolbar]) [part=toolbar]{display:none}#container{display:flex;height:100%}:host([editor-position="bottom"]) #container{flex-direction:column}[part=editor]{z-index:1;display:flex;flex-direction:column;height:100%;outline:none;background:var(--lumo-base-color);box-sizing:border-box;position:relative}:host(:not([editor-position=""])[editor-opened]:not([fullscreen])) [part=editor]{flex:1 0 100%}:host([editor-position="bottom"][editor-opened]:not([fullscreen])) [part=editor]{max-height:var(--vaadin-crud-editor-max-height)}:host([editor-position="aside"][editor-opened]:not([fullscreen])) [part=editor]{min-width:300px;max-width:var(--vaadin-crud-editor-max-width)}[part=scroller]{display:flex;flex-direction:column;overflow:auto;flex:auto;padding:var(--lumo-space-l)}[part=footer]{display:flex;flex:none;flex-direction:row-reverse;background-color:var(--lumo-contrast-5pct);padding:var(--lumo-space-s)}[part=header] ::slotted(h3){margin-top:0!important}:host(:not([dir="rtl"])) ::slotted([slot="delete-button"]){margin-right:auto}:host([dir="rtl"]) ::slotted([slot="delete-button"]){margin-left:auto}:host(:not([dir="rtl"])) [part=toolbar] ::slotted(*:not(:first-child)){margin-left:var(--lumo-space-s)}:host([dir="rtl"]) [part=toolbar] ::slotted(*:not(:first-child)){margin-right:var(--lumo-space-s)}:host([theme~="no-border"]) [part=toolbar]{border:0}[part=footer] ::slotted(*){margin-left:var(--lumo-space-s);margin-right:var(--lumo-space-s)}[part=editor]:focus:before{position:absolute;inset:0;content:"";box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);pointer-events:none}:host(:not([editor-position=""])) [part=editor]:not([hidden]){box-shadow:var(--lumo-box-shadow-m)}:host(:not([theme~="no-border"]):not([editor-position=""])) [part=editor]:not([hidden]){border:1px solid var(--lumo-contrast-20pct)}:host(:not([theme~="no-border"])[editor-position="bottom"]) [part=editor]:not([hidden]){border-top:0}:host(:not([dir="rtl"])[editor-position="aside"]) [part=editor]:not([hidden]){border-left:0}:host([dir="rtl"]:not([theme~="no-border"])[editor-position="aside"]) [part=editor]:not([hidden]){border-right:0}}@media lumo_components_form-layout{:host{--vaadin-form-layout-column-spacing: var(--lumo-space-l);--vaadin-form-layout-row-spacing: 0;--vaadin-form-layout-label-spacing: 1em}}@media lumo_components_grid{@keyframes vaadin-grid-appear{to{opacity:1}}:host{display:flex;flex-direction:column;animation:1ms vaadin-grid-appear;height:400px;min-height:var(--_grid-min-height, 0);flex:1 1 auto;align-self:stretch;position:relative;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-s);color:var(--lumo-body-text-color);background-color:var(--lumo-base-color);box-sizing:border-box;-webkit-text-size-adjust:100%;-webkit-tap-highlight-color:transparent;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_lumo-grid-border-color: var(--lumo-contrast-20pct);--_lumo-grid-secondary-border-color: var(--lumo-contrast-10pct);--_lumo-grid-border-width: 1px;--_lumo-grid-selected-row-color: var(--lumo-primary-color-10pct)}:host([hidden]){display:none!important}:host([disabled]){pointer-events:none;opacity:.7}#scroller{display:flex;flex-direction:column;min-height:100%;transform:translateY(0);width:auto;height:auto;position:absolute;inset:0}:host([all-rows-visible]){height:auto;align-self:flex-start;min-height:auto;flex-grow:0;width:100%}:host([all-rows-visible]) #scroller{width:100%;height:100%;position:relative}:host([all-rows-visible]) #items{min-height:1px}#table{display:flex;flex-direction:column;width:100%;height:100%;overflow:auto;position:relative;outline:none;z-index:0}#header,#footer{display:block;position:sticky;left:0;overflow:visible;width:100%;z-index:1}#header{top:0}th{text-align:inherit}[safari] th{text-align:initial}#footer{bottom:0}#items{flex-grow:1;flex-shrink:0;display:block;position:sticky;width:100%;left:0;overflow:visible}[part~=row]{display:flex;width:100%;box-sizing:border-box;margin:0;position:relative}[part~=row][loading] [part~=body-cell] ::slotted(vaadin-grid-cell-content){visibility:hidden}[column-rendering=lazy] [part~=body-cell]:not([frozen]):not([frozen-to-end]){transform:translate(var(--_grid-lazy-columns-start))}#items [part~=row]{position:absolute}#items [part~=row]:empty{height:100%}[part~=cell]:not([part~=details-cell]){flex-shrink:0;flex-grow:1;box-sizing:border-box;display:flex;width:100%;position:relative;align-items:center;padding:0;white-space:nowrap}[part~=cell]{outline:none;min-height:var(--lumo-size-m);background-color:var(--vaadin-grid-cell-background, var(--lumo-base-color));cursor:default;--_cell-padding: var(--vaadin-grid-cell-padding, var(--_cell-default-padding));--_cell-default-padding: var(--lumo-space-xs) var(--lumo-space-m)}[part~=cell]>[tabindex]{display:flex;align-items:inherit;outline:none;position:absolute;inset:0}[measuring-auto-width] [part~=cell]>[tabindex]{position:static}[part~=details-cell]{position:absolute;bottom:0;width:100%;box-sizing:border-box;padding:0}[part~=cell] ::slotted(vaadin-grid-cell-content){display:block;width:100%;box-sizing:border-box;overflow:hidden;text-overflow:ellipsis;cursor:inherit;padding:var(--_cell-padding)}[hidden]{display:none!important}[frozen],[frozen-to-end]{z-index:2;will-change:transform}[no-scrollbars][safari] #table,[no-scrollbars][firefox] #table{overflow:hidden}#scroller:not([empty-state]) #emptystatebody,#scroller[empty-state] #items{display:none}#emptystatebody{display:flex;position:sticky;inset:0;flex:1;overflow:hidden}#emptystaterow{display:flex;flex:1}#emptystatecell{display:block;flex:1;overflow:auto}:host([reordering]) [part~=cell] ::slotted(vaadin-grid-cell-content),:host([reordering]) [part~=resize-handle],#scroller[no-content-pointer-events] [part~=cell] ::slotted(vaadin-grid-cell-content){pointer-events:none}[part~=reorder-ghost]{visibility:hidden;position:fixed;pointer-events:none;top:0;left:0;opacity:.85;box-shadow:var(--lumo-box-shadow-s);padding:var(--lumo-space-s) var(--lumo-space-m)!important}:host([reordering]){-webkit-user-select:none;user-select:none}[part~=resize-handle]{position:absolute;top:0;right:0;height:100%;cursor:col-resize;z-index:1}[part~=resize-handle]:before{position:absolute;content:"";height:100%;width:35px;transform:translate(-50%)}[last-column] [part~=resize-handle]:before,[last-frozen] [part~=resize-handle]:before{width:18px;transform:none;right:0}[frozen-to-end] [part~=resize-handle]{left:0;right:auto}[frozen-to-end] [part~=resize-handle]:before{left:0;right:auto}[first-frozen-to-end] [part~=resize-handle]:before{width:18px;transform:none}[first-frozen-to-end]{margin-inline-start:auto;border-left:var(--_lumo-grid-border-width) solid transparent}:host(:not([overflow~="end"])) [first-frozen-to-end] [part~=resize-handle]{display:none}#scroller[column-resizing],#scroller[range-selecting]{-webkit-user-select:none;user-select:none}#sizer{display:flex;position:absolute;visibility:hidden}#sizer [part~=details-cell],#sizer [part~=cell][hidden]{display:none!important}#sizer [part~=cell]{display:block;flex-shrink:0;line-height:0;height:0!important;min-height:0!important;max-height:0!important;padding:0!important;border:none!important}#sizer [part~=cell]:before{content:"-"}#sizer [part~=cell] ::slotted(vaadin-grid-cell-content){display:none!important}:host([dir="rtl"]) #items,:host([dir="rtl"]) #header,:host([dir="rtl"]) #footer{left:auto}:host([dir="rtl"]) [part~=reorder-ghost]{left:auto;right:0}:host([dir="rtl"]) [part~=resize-handle]{left:0;right:auto}:host([dir="rtl"]) [part~=resize-handle]:before{transform:translate(50%)}:host([dir="rtl"]) [last-column] [part~=resize-handle]:before,:host([dir="rtl"]) [last-frozen] [part~=resize-handle]:before{left:0;right:auto}:host([dir="rtl"]) [frozen-to-end] [part~=resize-handle]{right:0;left:auto}:host([dir="rtl"]) [frozen-to-end] [part~=resize-handle]:before{right:0;left:auto}:host(:not([theme~="no-border"])){border:var(--_lumo-grid-border-width) solid var(--_lumo-grid-border-color)}:host(:not([theme~="no-row-borders"])) [part~=cell]:not([part~=details-cell]){border-top:var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color)}:host(:not([theme~="no-row-borders"])) [part~=first-row] [part~=cell]:not([part~=details-cell]){border-top:0;min-height:calc(var(--lumo-size-m) - var(--_lumo-grid-border-width))}[part~=row]:focus,[part~=focused-cell]:focus{outline:none}:host([navigating]) [part~=row]:focus:before,:host([navigating]) [part~=focused-cell]:focus:before{content:"";position:absolute;inset:0;pointer-events:none;box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host([navigating]) [part~=row]:focus:before{transform:translate(var(--_grid-horizontal-scroll-position));z-index:3}[part~=empty-state]{padding:var(--lumo-space-m);color:var(--lumo-secondary-text-color)}:host([dragover]):after{content:"";position:absolute;z-index:100;inset:0;pointer-events:none;box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part~=row][dragover]{z-index:100!important}[part~=row][dragover] [part~=cell]{overflow:visible}[part~=row][dragover] [part~=cell]:after{content:"";position:absolute;inset:0;height:calc(var(--_lumo-grid-border-width) + 2px);pointer-events:none;background:var(--lumo-primary-color-50pct)}[part~=row][dragover] [part~=cell][last-frozen]:after{right:-1px}:host([theme~="no-row-borders"]) [dragover] [part~=cell]:after{height:2px}[part~=row][dragover=below] [part~=cell]:after{top:100%;bottom:auto;margin-top:-1px}:host([all-rows-visible]) [part~=last-row][dragover=below] [part~=cell]:after{height:1px}[part~=row][dragover=above] [part~=cell]:after{top:auto;bottom:100%;margin-bottom:-1px}[part~=row][details-opened][dragover=below] [part~=cell]:not([part~=details-cell]):after,[part~=row][details-opened][dragover=above] [part~=details-cell]:after{display:none}[part~=row][dragover][dragover=on-top] [part~=cell]:after{height:100%;opacity:.5}[part~=row][dragstart] [part~=cell]{border:none!important;box-shadow:none!important}[part~=row][dragstart] [part~=cell][last-column]{border-radius:0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0}[part~=row][dragstart] [part~=cell][first-column]{border-radius:var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s)}#scroller [part~=row][dragstart]:not([dragstart=""]):after{display:block;position:absolute;left:var(--_grid-drag-start-x);top:var(--_grid-drag-start-y);z-index:100;content:attr(dragstart);align-items:center;justify-content:center;box-sizing:border-box;padding:calc(var(--lumo-space-xs) * .8);color:var(--lumo-error-contrast-color);background-color:var(--lumo-error-color);border-radius:var(--lumo-border-radius-m);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-xxs);line-height:1;font-weight:500;text-transform:initial;letter-spacing:initial;min-width:calc(var(--lumo-size-s) * .7);text-align:center}[part~=header-cell],[part~=footer-cell],[part~=reorder-ghost]{font-size:var(--lumo-font-size-s);font-weight:500}[part~=footer-cell]{font-weight:400}[part~=row]:only-child [part~=header-cell]{min-height:var(--lumo-size-xl)}:host(:not([theme~="no-row-borders"])) [part~=row]:first-child [part~=header-cell]{border-top:0}[part~=row][hidden]+[part~=row] [part~=header-cell]{border-top:0}[part~=row]:last-child [part~=header-cell]{border-bottom:var(--_lumo-grid-border-width) solid transparent}:host(:not([theme~="no-row-borders"])) [part~=row]:last-child [part~=header-cell]{border-bottom-color:var(--_lumo-grid-secondary-border-color)}:host([overflow~="top"]) [part~=row]:last-child [part~=header-cell]{border-bottom-color:var(--_lumo-grid-border-color)}[part~=row]:first-child [part~=footer-cell]{border-top:var(--_lumo-grid-border-width) solid transparent}:host(:not([theme~="no-row-borders"])) [part~=row]:first-child [part~=footer-cell]{border-top-color:var(--_lumo-grid-secondary-border-color)}:host([overflow~="bottom"]) [part~=row]:first-child [part~=footer-cell]{border-top-color:var(--_lumo-grid-border-color)}:host([reordering]) [part~=cell]{background:linear-gradient(var(--lumo-shade-20pct),var(--lumo-shade-20pct)) var(--lumo-base-color)}:host([reordering]) [part~=cell][reorder-status=allowed]{background:var(--lumo-base-color)}:host([reordering]) [part~=cell][reorder-status=dragging]{background:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct)) var(--lumo-base-color)}[part=resize-handle]{--_resize-handle-width: 3px;width:var(--_resize-handle-width);background-color:var(--lumo-primary-color-50pct);opacity:0;transition:opacity .2s}[part=resize-handle]:before{transform:translate(calc(-50% + var(--_resize-handle-width) / 2));width:var(--lumo-size-s)}:host(:not([reordering])) *:not([column-resizing]) [part~=cell]:hover [part=resize-handle],[part=resize-handle]:active{opacity:1;transition-delay:.15s}:host([theme~="column-borders"]) [part~=cell]:not([last-column]):not([part~=details-cell]){border-right:var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color)}[last-frozen]{border-right:var(--_lumo-grid-border-width) solid transparent;overflow:hidden}:host([overflow~="start"]) [part~=cell][last-frozen]:not([part~=details-cell]){border-right-color:var(--_lumo-grid-border-color)}:host([overflow~="end"]) [part~=cell][first-frozen-to-end]:not([part~=details-cell]){border-left-color:var(--_lumo-grid-border-color)}:host([theme~="row-stripes"]) [part~=even-row] [part~=body-cell],:host([theme~="row-stripes"]) [part~=even-row] [part~=details-cell]{background-image:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct));background-repeat:repeat-x}:host(:not([reordering])) [part~=row][selected]{z-index:1}:host(:not([reordering])) [part~=row][selected] [part~=body-cell]:not([part~=details-cell]){background-image:linear-gradient(var(--_lumo-grid-selected-row-color),var(--_lumo-grid-selected-row-color));background-repeat:repeat}:host(:not([theme~="no-row-borders"])) [part~=row][selected] [part~=cell]:not([part~=details-cell]){box-shadow:0 var(--_lumo-grid-border-width) 0 0 var(--_lumo-grid-selected-row-color)}:host([theme~="compact"]) [part~=row]:only-child [part~=header-cell]{min-height:var(--lumo-size-m)}:host([theme~="compact"]) [part~=cell]{min-height:var(--lumo-size-s);--_cell-default-padding: var(--lumo-space-xs) var(--lumo-space-s)}:host([theme~="compact"]) [part~=first-row] [part~=cell]:not([part~=details-cell]){min-height:calc(var(--lumo-size-s) - var(--_lumo-grid-border-width))}:host([theme~="compact"]) [part~=empty-state]{padding:var(--lumo-space-s)}:host([theme~="wrap-cell-content"]) [part~=cell] ::slotted(vaadin-grid-cell-content){white-space:normal}:host([dir="rtl"]) [part~=row][dragstart] [part~=cell][last-column]{border-radius:var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s)}:host([dir="rtl"]) [part~=row][dragstart] [part~=cell][first-column]{border-radius:0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0}:host([dir="rtl"][theme~="column-borders"]) [part~=cell]:not([last-column]):not([part~=details-cell]){border-right:none;border-left:var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color)}:host([dir="rtl"]) [last-frozen]{border-right:none;border-left:var(--_lumo-grid-border-width) solid transparent}:host([dir="rtl"]) [first-frozen-to-end]{border-left:none;border-right:var(--_lumo-grid-border-width) solid transparent}:host([dir="rtl"][overflow~="start"]) [part~=cell][last-frozen]:not([part~=details-cell]){border-left-color:var(--_lumo-grid-border-color)}:host([dir="rtl"][overflow~="end"]) [part~=cell][first-frozen-to-end]:not([part~=details-cell]){border-right-color:var(--_lumo-grid-border-color)}@media (forced-colors: active){[part~=selected-row] [part~=first-column-cell]:after{content:"";position:absolute;top:0;left:0;bottom:0;border:2px solid}[part~=focused-cell]:before{outline:2px solid!important;outline-offset:-1px}}}@media lumo_components_grid-filter{:host{display:inline-flex;max-width:100%}::slotted(*){width:100%;box-sizing:border-box}}:is(:root,:host):before{--vaadin-text-field-lumo-inject: 1;--vaadin-text-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base}:is(:root,:host):before{--vaadin-grid-filter-lumo-inject: 1;--vaadin-grid-filter-lumo-inject-modules: lumo_components_grid-filter}@media lumo_components_grid-sorter{:host{display:inline-flex;max-width:100%;justify-content:flex-start;align-items:baseline;-webkit-user-select:none;user-select:none;cursor:var(--lumo-clickable-cursor)}[part=content]{flex:1 1 auto;display:inline-block;overflow:hidden;text-overflow:ellipsis}[part=indicators]{position:relative;align-self:center;flex:none;margin-left:var(--lumo-space-s)}[part=order]{display:inline;vertical-align:super;font-size:var(--lumo-font-size-xxs);line-height:1}[part=indicators]:before{font-family:vaadin-grid-sorter-icons;display:inline-block;transform:scale(.8)}:host(:not([direction])) [part=indicators]:before{content:""}:host([direction="asc"]) [part=indicators]:before{content:""}:host([direction="desc"]) [part=indicators]:before{content:""}:host(:not([direction]):not(:hover)) [part=indicators]{color:var(--lumo-tertiary-text-color)}:host([direction]){color:var(--vaadin-selection-color-text, var(--lumo-primary-text-color))}:host([dir="rtl"]) [part=indicators]{margin-right:var(--lumo-space-s);margin-left:0}}@font-face{font-family:vaadin-grid-sorter-icons;src:url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQwAA0AAAAABuwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABGRlRNAAAEFAAAABkAAAAcfep+mUdERUYAAAP4AAAAHAAAAB4AJwAOT1MvMgAAAZgAAAA/AAAAYA8TBPpjbWFwAAAB7AAAAFUAAAFeF1fZ4mdhc3AAAAPwAAAACAAAAAgAAAAQZ2x5ZgAAAlgAAABcAAAAnMvguMloZWFkAAABMAAAAC8AAAA2C5Ap72hoZWEAAAFgAAAAHQAAACQGbQPHaG10eAAAAdgAAAAUAAAAHAoAAABsb2NhAAACRAAAABIAAAASAIwAYG1heHAAAAGAAAAAFgAAACAACwAKbmFtZQAAArQAAAECAAACZxWCgKhwb3N0AAADuAAAADUAAABZCrApUXicY2BkYGAA4rDECVrx/DZfGbhZGEDgyqNPOxH0/wNMq5kPALkcDEwgUQBWRA0dAHicY2BkYGA+8P8AAwMLAwgwrWZgZEAFbABY4QM8AAAAeJxjYGRgYOAAQiYGEICQSAAAAi8AFgAAeJxjYGY6yziBgZWBgWkm0xkGBoZ+CM34msGYkZMBFTAKoAkwODAwvmRiPvD/AIMDMxCD1CDJKjAwAgBktQsXAHicY2GAAMZQCM0EwqshbAALxAEKeJxjYGBgZoBgGQZGBhCIAPIYwXwWBhsgzcXAwcAEhIwMCi+Z/v/9/x+sSuElA4T9/4k4K1gHFwMMMILMY2QDYmaoABOQYGJABUA7WBiGNwAAJd4NIQAAAAAAAAAACAAIABAAGAAmAEAATgAAeJyNjLENgDAMBP9tIURJwQCMQccSZgk2i5fIYBDAidJjycXr7x5EPwE2wY8si7jmyBNXGo/bNBerxJNrpxhbO3/fEFpx8ZICpV+ghxJ74fAMe+h7Ox14AbrsHB14nK2QQWrDMBRER4mTkhQK3ZRQKOgCNk7oGQqhhEIX2WSlWEI1BAlkJ5CDdNsj5Ey9Rncdi38ES+jzNJo/HwTgATcoDEthhY3wBHc4CE+pfwsX5F/hGe7Vo/AcK/UhvMSz+mGXKhZU6pww8ISz3oWn1BvhgnwTnuEJf8Jz1OpFeIlX9YULDLdFi4ASHolkSR0iuYdjLak1vAequBhj21D61Nqyi6l3qWybGPjySbPHGScGJl6dP58MYcQRI0bts7mjebBqrFENH7t3qWtj0OuqHnXcW7b0HOTZFnKryRGW2hFX1m0O2vEM3opNMfTau+CS6Z3Vx6veNnEXY6jwDxhsc2gAAHicY2BiwA84GBgYmRiYGJkZmBlZGFkZ2djScyoLMgzZS/MyDQwMwLSrpYEBlIbxjQDrzgsuAAAAAAEAAf//AA94nGNgZGBg4AFiMSBmYmAEQnYgZgHzGAAD6wA2eJxjYGBgZACCKyoz1cD0o087YTQATOcIewAAAA==) format("woff");font-weight:400;font-style:normal}:is(:root,:host):before{--vaadin-grid-sorter-lumo-inject: 1;--vaadin-grid-sorter-lumo-inject-modules: lumo_components_grid-sorter}:is(:root,:host):before{--vaadin-crud-lumo-inject: 1;--vaadin-crud-lumo-inject-modules: lumo_components_crud;--vaadin-crud-edit-lumo-inject: 1;--vaadin-crud-edit-lumo-inject-modules: lumo_components_button, lumo_components_crud-edit;--vaadin-crud-grid-lumo-inject: 1;--vaadin-crud-grid-lumo-inject-modules: lumo_components_grid;--vaadin-crud-form-lumo-inject: 1;--vaadin-crud-form-lumo-inject-modules: lumo_components_form-layout;--vaadin-crud-dialog-overlay-lumo-inject: 1;--vaadin-crud-dialog-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_dialog-overlay, lumo_components_crud-dialog-overlay}@media lumo_components_custom-field{:host{display:inline-flex;--lumo-text-field-size: var(--lumo-size-m);color:var(--lumo-body-text-color);font-size:var(--lumo-font-size-m);line-height:calc(var(--lumo-text-field-size) + 2 * var(--lumo-space-xs));font-family:var(--lumo-font-family);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:transparent;padding:0}:host:before{content:" ";width:0;margin-top:var(--lumo-space-xs);height:var(--lumo-text-field-size);box-sizing:border-box;display:inline-flex;align-items:center}:host([hidden]){display:none!important}.vaadin-custom-field-container{width:100%;display:flex;flex-direction:column}.inputs-wrapper{flex:none}:host([has-label]) [part=label]{padding-bottom:calc(.5em - var(--lumo-space-xs))}:host(:not([has-label])) [part=label],:host(:not([has-label])):before{display:none}:host([has-error-message]) [part=error-message]:before{height:calc(.4em - var(--lumo-space-xs))}:host([focused]:not([readonly]):not([disabled])) [part=label]{color:var(--lumo-primary-text-color)}:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=label],:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=helper-text]{color:var(--lumo-body-text-color)}@media (pointer: coarse){:host(:hover:not([readonly]):not([disabled]):not([focused])) [part=label]{color:var(--lumo-secondary-text-color)}}:host([disabled]) [part=label]{color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color)}:host([theme~="small"]){font-size:var(--lumo-font-size-s);--lumo-text-field-size: var(--lumo-size-s)}:host([theme~="small"][has-label]) [part=label]{font-size:var(--lumo-font-size-xs)}:host([theme~="small"][has-label]) [part=error-message]{font-size:var(--lumo-font-size-xxs)}:host([theme~="whitespace"][has-label]) [part=label]{padding-bottom:.5em}}:is(:root,:host):before{--vaadin-custom-field-lumo-inject: 1;--vaadin-custom-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-helper, lumo_components_custom-field}@media lumo_mixins_dashboard-item{:host{box-sizing:border-box;--_widget-background: var(--vaadin-dashboard-widget-background, var(--lumo-base-color));--_widget-border-radius: var(--vaadin-dashboard-widget-border-radius, var(--lumo-border-radius-l));--_widget-border-width: var(--vaadin-dashboard-widget-border-width, 1px);--_widget-border-color: var(--vaadin-dashboard-widget-border-color, var(--lumo-contrast-20pct));--_widget-shadow: var(--vaadin-dashboard-widget-shadow, 0 0 0 0 transparent);--_widget-editable-shadow: var(--lumo-box-shadow-s);--_widget-selected-shadow: 0 2px 4px -1px var(--lumo-primary-color-10pct), 0 3px 12px -1px var(--lumo-primary-color-50pct);--_drop-target-background-color: var( --vaadin-dashboard-drop-target-background-color, var(--lumo-primary-color-10pct) );--_drop-target-border: var(--vaadin-dashboard-drop-target-border, 1px dashed var(--lumo-primary-color-50pct));color:var(--lumo-body-text-color);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_icon-color: var(--lumo-contrast-60pct);opacity:var(--_widget-opacity);filter:var(--_widget-filter)}:host([dragging]) *{visibility:hidden}:host(:not([editable])) [part~=move-button],:host(:not([editable])) [part~=remove-button],:host(:not([editable])) #focus-button,:host(:not([editable])) #focus-button-wrapper,:host(:not([editable])) .mode-controls{display:none}#focustrap{display:contents}#focus-button-wrapper,#focus-button{position:absolute;inset:0;opacity:0}#focus-button{pointer-events:none;padding:0;border:none}.mode-controls{position:absolute;inset:0;z-index:2}.mode-controls[hidden]{display:none}[part~=move-backward-button],[part~=move-forward-button],[part~=move-apply-button]{position:absolute;top:50%}[part~=move-backward-button]{inset-inline-start:0;transform:translateY(-50%)}[part~=move-forward-button]{inset-inline-end:0;transform:translateY(-50%)}[part~=move-apply-button]{left:50%;transform:translate(-50%,-50%);--icon: var(--lumo-icons-checkmark);font-size:var(--lumo-icon-size-m)}:host([first-child]) [part~=move-backward-button],:host([last-child]) [part~=move-forward-button]{display:none}[part~=resize-shrink-width-button],[part~=resize-shrink-height-button],[part~=resize-grow-width-button],[part~=resize-grow-height-button],[part~=resize-apply-button]{position:absolute}[part~=resize-shrink-width-button]{inset-inline-end:0;top:50%}:host(:not([dir="rtl"])) [part~=resize-shrink-width-button]{transform:translateY(-50%) translate(-100%)}:host([dir="rtl"]) [part~=resize-shrink-width-button]{transform:translateY(-50%) translate(100%)}.mode-controls:has([part~=resize-grow-width-button][hidden]) [part~=resize-shrink-width-button]{transform:translateY(-50%)}[part~=resize-grow-width-button]{inset-inline-start:100%;top:50%}:host(:not([dir="rtl"])) [part~=resize-grow-width-button]{transform:translateY(-50%) translate(-100%)}:host([dir="rtl"]) [part~=resize-grow-width-button]{transform:translateY(-50%) translate(100%)}[part~=resize-shrink-height-button]{bottom:0;left:50%;transform:translate(-50%) translateY(-100%)}[part~=resize-grow-height-button]{top:100%;left:50%;transform:translate(-50%) translateY(-100%)}[part~=resize-apply-button]{left:50%;top:50%;transform:translate(-50%,-50%)}:host([focused]){z-index:1}header{overflow:hidden;display:flex;align-items:start;box-sizing:border-box;justify-content:space-between}[part=title]{flex:1;color:var(--lumo-header-text-color);white-space:var(--vaadin-dashboard-widget-title-wrap, wrap);text-overflow:ellipsis;overflow:hidden;line-height:var(--lumo-line-height-s);margin:0 0 1px;align-self:safe center}vaadin-dashboard-button{font-family:lumo-icons;font-size:var(--lumo-icon-size-m);margin:0;z-index:1}vaadin-dashboard-button .icon:before{display:block;content:var(--icon)}[part=move-button],[part=resize-button],[part=remove-button]{color:var(--_icon-color);padding-inline:0}:where([part=move-button],[part=resize-button],[part=remove-button]):hover{--_icon-color: var(--lumo-primary-text-color)}:host([selected]){opacity:1;z-index:1;--_icon-color: var(--lumo-primary-text-color)}:host(:is([move-mode],[resize-mode])){--_icon-color: var(--lumo-disabled-text-color)}[part~=move-button]{cursor:move;--icon: var(--lumo-icons-drag-handle)}[part~=remove-button]{cursor:pointer;--icon: var(--lumo-icons-cross);margin-inline-start:var(--lumo-space-xs)}.mode-controls vaadin-dashboard-button[focused]{z-index:3}:host(:not([dir="rtl"])) [part~=move-backward-button],:host([dir="rtl"]) [part~=move-forward-button]{border-top-left-radius:0;border-bottom-left-radius:0;--icon: var(--lumo-icons-angle-left)}:host(:not([dir="rtl"])) [part~=move-forward-button],:host([dir="rtl"]) [part~=move-backward-button]{border-top-right-radius:0;border-bottom-right-radius:0;--icon: var(--lumo-icons-angle-right)}}@media lumo_components_dashboard-layout{:host{display:block;overflow:auto;box-sizing:border-box;width:100%}:host([hidden]){display:none!important}:host([dense-layout]) #grid{grid-auto-flow:dense}#grid{box-sizing:border-box;--_default-padding: var(--lumo-space-m);--_padding: max(0px, var(--vaadin-dashboard-padding, var(--_default-padding)));padding:var(--_padding);--_default-gap: var(--lumo-space-m);--_gap: max(0px, var(--vaadin-dashboard-gap, var(--_default-gap)));gap:var(--_gap);--_default-col-min-width: 25rem;--_default-col-max-width: 1fr;--_col-min-width: var(--vaadin-dashboard-col-min-width, var(--_default-col-min-width));--_col-max-width: var(--vaadin-dashboard-col-max-width, var(--_default-col-max-width));--_col-max-count: var(--vaadin-dashboard-col-max-count, var(--_col-count));--_effective-col-count: min(var(--_col-count), var(--_col-max-count));--_default-row-min-height: 12rem;--_row-min-height: var(--vaadin-dashboard-row-min-height, var(--_default-row-min-height));--_row-height: minmax(var(--_row-min-height, auto), auto);display:grid;overflow:hidden;min-width:calc(var(--_col-min-width) + var(--_padding) * 2);grid-template-columns:repeat(var(--_effective-col-count, auto-fill),minmax(var(--_col-min-width),var(--_col-max-width)));grid-auto-rows:var(--_row-height)}::slotted(*){--_item-column: span min(var(--vaadin-dashboard-widget-colspan, 1), var(--_effective-col-count, var(--_col-count)));grid-column:var(--_item-column);--_item-row: span var(--vaadin-dashboard-widget-rowspan, 1);grid-row:var(--_item-row)}:host([theme~="shaded-background"]){background:var(--lumo-shade-5pct)}:host([theme~="elevated-widgets"]){--vaadin-dashboard-widget-shadow: var(--lumo-box-shadow-xs);--vaadin-dashboard-widget-border-color: var(--lumo-contrast-10pct);--vaadin-dashboard-widget-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color)}:host([theme~="flat-widgets"]){--vaadin-dashboard-widget-background: var(--lumo-contrast-5pct);--vaadin-dashboard-widget-border-color: transparent}}@media lumo_components_dashboard-section{:host{display:grid;position:relative;grid-template-columns:subgrid;--_section-column: 1 / calc(var(--_effective-col-count) + 1);grid-column:var(--_section-column)!important;gap:var(--_gap, 1rem);--_section-header-height: minmax(0, auto);grid-template-rows:var(--_section-header-height) repeat(auto-fill,var(--_row-height));grid-auto-rows:var(--_row-height);--_section-outline-offset: calc(min(var(--_gap), var(--_padding)) / 3);--_focus-ring-offset: calc((var(--_section-outline-offset) - var(--_focus-ring-width)));border-radius:var(--lumo-border-radius-l)}:host([hidden]){display:none!important}::slotted(*){--_item-column: span min(var(--vaadin-dashboard-widget-colspan, 1), var(--_effective-col-count, var(--_col-count)));grid-column:var(--_item-column);--_item-row: span var(--vaadin-dashboard-widget-rowspan, 1);grid-row:var(--_item-row)}header{grid-column:var(--_section-column);margin-bottom:calc(-1 * var(--_section-outline-offset));line-height:var(--lumo-line-height-s);padding-inline:var(--lumo-space-s);min-height:var(--lumo-size-l);align-items:center}:host:before{z-index:2!important}::slotted(vaadin-dashboard-widget-wrapper){display:contents}[part=title]{font-size:var(--lumo-font-size-xl);font-weight:600;white-space:nowrap;line-height:var(--lumo-line-height-m)}:host([editable]){outline:1px solid var(--lumo-contrast-10pct);outline-offset:calc(var(--_section-outline-offset) - 1px);background:var(--lumo-contrast-5pct);box-shadow:0 0 0 var(--_section-outline-offset) var(--lumo-contrast-5pct)}:host([editable]) header{padding-inline:var(--lumo-space-xs)}:host([focused]):after{content:"";display:block;position:absolute;inset:0;border-radius:var(--lumo-border-radius-l);z-index:9;outline:var(--_focus-ring-width) solid var(--_focus-ring-color);outline-offset:var(--_focus-ring-offset)}:host([selected]){background:var(--lumo-primary-color-10pct);box-shadow:0 0 0 var(--_section-outline-offset) var(--lumo-primary-color-10pct)}:host([selected]:not([focused])){outline-color:var(--lumo-primary-color-50pct)}:host([move-mode]) ::slotted(*){--_widget-opacity: .3;--_widget-filter: blur(10px)}:host([dragging]){background:var(--_drop-target-background-color);outline:var(--_drop-target-border);box-shadow:0 0 0 var(--_section-outline-offset) var(--_drop-target-background-color)}[part~=move-backward-button]{inset-inline-start:calc(-1 * var(--_section-outline-offset))}[part~=move-forward-button]{inset-inline-end:calc(-1 * var(--_section-outline-offset));transform:translateY(-50%)}}@media lumo_components_dashboard-widget{:host{display:flex;flex-direction:column;grid-column:var(--_item-column);grid-row:var(--_item-row);background:var(--_widget-background);border-radius:var(--_widget-border-radius);box-shadow:var(--_widget-shadow);position:relative}:host:before{content:"";position:absolute;inset:calc(-1 * var(--_widget-border-width));border:var(--_widget-border-width) solid var(--_widget-border-color);border-radius:calc(var(--_widget-border-radius) + var(--_widget-border-width));pointer-events:none}:host([hidden]){display:none!important}:host(:not([editable])) [part~=resize-button]{display:none}[part~=content]{flex:1;overflow:hidden}:host([editable]){--vaadin-dashboard-widget-shadow: var(--_widget-editable-shadow);--_widget-border-color: var(--lumo-contrast-20pct);--_widget-border-width: 1px}:host([focused]):before{border-width:var(--_focus-ring-width);border-color:var(--_focus-ring-color)}:host([selected]){--vaadin-dashboard-widget-shadow: var(--_widget-selected-shadow);background:var(--lumo-primary-color-10pct)}:host([dragging]){box-shadow:none;background:var(--_drop-target-background-color);border:var(--_drop-target-border)}:host([resizing]):after{content:"";z-index:2;position:absolute;top:-1px;width:var(--_widget-resizer-width, 0);height:var(--_widget-resizer-height, 0);border-radius:inherit;background:var(--_drop-target-background-color);border:var(--_drop-target-border)}header{min-height:var(--lumo-size-l);padding:var(--lumo-space-xs) var(--lumo-space-m)}:host([editable]) header{padding-inline:var(--lumo-space-xs)}[part=title]{font-size:var(--lumo-font-size-l);font-weight:600}#content{min-height:var(--lumo-size-m);padding-inline:var(--vaadin-dashboard-widget-padding, 0);padding-bottom:var(--vaadin-dashboard-widget-padding, 0);padding-top:0;border-radius:inherit;border-top-left-radius:0;border-top-right-radius:0;overflow:hidden}::slotted([slot="header-content"]){align-self:center}:host([resize-mode]) #content,:host([move-mode]) #content{opacity:.75;filter:blur(10px)}[part~=resize-button]{z-index:1;overflow:hidden;--_resize-button-offset: min(var(--_gap), var(--_padding), var(--lumo-space-xs));position:absolute;bottom:calc(-1 * var(--_resize-button-offset));inset-inline-end:calc(-1 * var(--_resize-button-offset));cursor:nwse-resize;touch-action:none;--icon: var(--lumo-icons-resize-handle)}:host([dir="rtl"]) [part~=resize-button]{cursor:sw-resize}:host([dir="rtl"]) [part~=resize-button] .icon:before{transform:scaleX(-1)}[part~=resize-apply-button]{--icon: var(--lumo-icons-checkmark);font-size:var(--lumo-icon-size-m)}[part~=resize-grow-width-button],[part~=resize-shrink-width-button]{padding-right:0;padding-left:0;min-width:var(--lumo-size-s)}[part~=resize-shrink-width-button]+[part~=resize-grow-width-button]{margin-left:1px}[part~=resize-grow-height-button],[part~=resize-shrink-height-button]{height:var(--lumo-size-s);padding-right:0;padding-left:0;border-bottom-left-radius:0;border-bottom-right-radius:0}[part~=resize-shrink-height-button]:not([hidden])+[part~=resize-grow-height-button]{border-top-left-radius:0;border-top-right-radius:0}[part~=resize-shrink-height-button]+[part~=resize-grow-height-button]{margin-top:1px}:host(:not([dir="rtl"])) [part~=resize-grow-width-button],:host(:not([dir="rtl"])) [part~=resize-shrink-width-button]{border-top-right-radius:0;border-bottom-right-radius:0}:host([dir="rtl"]) [part~=resize-grow-width-button],:host([dir="rtl"]) [part~=resize-shrink-width-button]{border-top-left-radius:0;border-bottom-left-radius:0}:host(:not([dir="rtl"])) [part~=resize-shrink-width-button]:not([hidden])+[part~=resize-grow-width-button]{border-top-left-radius:0;border-bottom-left-radius:0}:host([dir="rtl"]) [part~=resize-shrink-width-button]:not([hidden])+[part~=resize-grow-width-button]{border-top-right-radius:0;border-bottom-right-radius:0}[part~=resize-grow-height-button],[part~=resize-grow-width-button]{--icon: var(--lumo-icons-plus)}[part~=resize-shrink-height-button],[part~=resize-shrink-width-button]{--icon: var(--lumo-icons-minus)}@media (forced-colors: active){:host{border:1px solid}:host([focused]){outline:2px solid;outline-offset:1px}:host([selected]){outline-width:1px;outline-offset:0;outline-color:Highlight}:host([selected][focused]){outline-width:3px;outline-offset:0}}}@media lumo_components_dashboard{#grid[item-resizing]{-webkit-user-select:none;user-select:none}::slotted(vaadin-dashboard-widget-wrapper){display:contents}:host{--_widget-opacity: 1}:host([item-selected]){--_widget-opacity: .7}}:is(:root,:host):before{--vaadin-dashboard-lumo-inject: 1;--vaadin-dashboard-lumo-inject-modules: lumo_components_dashboard-layout, lumo_components_dashboard;--vaadin-dashboard-widget-lumo-inject: 1;--vaadin-dashboard-widget-lumo-inject-modules: lumo_mixins_dashboard-item, lumo_components_dashboard-widget;--vaadin-dashboard-section-lumo-inject: 1;--vaadin-dashboard-section-lumo-inject-modules: lumo_mixins_dashboard-item, lumo_components_dashboard-section;--vaadin-dashboard-layout-lumo-inject: 1;--vaadin-dashboard-layout-lumo-inject-modules: lumo_components_dashboard-layout;--vaadin-dashboard-button-lumo-inject: 1;--vaadin-dashboard-button-lumo-inject-modules: lumo_components_button}@media lumo_components_date-picker-month-calendar{:host{display:block;-webkit-user-select:none;-webkit-tap-highlight-color:transparent;user-select:none;font-size:var(--lumo-font-size-m);color:var(--lumo-body-text-color);text-align:center;padding:0 var(--lumo-space-xs);--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));--_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color))}#monthGrid{width:100%;border-collapse:collapse}#days-container tr,#weekdays-container tr{display:flex}[part~=disabled]{pointer-events:none}[part=month-header]{color:var(--lumo-header-text-color);font-size:var(--lumo-font-size-l);line-height:1;font-weight:500;margin-bottom:var(--lumo-space-m)}[part=weekdays],[part=weekday],[part=week-number]{font-size:var(--lumo-font-size-xxs);line-height:1;color:var(--lumo-secondary-text-color)}[part=weekdays]{margin-bottom:var(--lumo-space-s)}[part=weekday]:empty,[part=week-number]{flex-shrink:0;padding:0;width:var(--lumo-size-xs)}[part=week-number][hidden],[part=weekday][hidden]{display:none}[part~=date],[part=week-number]{box-sizing:border-box;display:inline-flex;align-items:center;justify-content:center;height:var(--lumo-size-m);position:relative}[part~=date]{outline:none;transition:color .1s}[part~=date]:not(:empty){cursor:var(--lumo-clickable-cursor)}[part=weekday],[part~=date]{width:calc(100% / 7);padding:0;font-weight:400}:host([week-numbers]) [part=weekday]:not(:empty),:host([week-numbers]) [part~=date]{width:calc((100% - var(--lumo-size-xs)) / 7)}[part~=date][part~=today]{color:var(--_selection-color-text)}[part~=date]:before{content:"";position:absolute;z-index:-1;top:50%;left:50%;transform:translate(-50%,-50%);min-width:2em;min-height:2em;width:80%;height:80%;max-height:100%;max-width:100%;border-radius:var(--lumo-border-radius-m)}[part~=date][part~=focused]:before{box-shadow:0 0 0 1px var(--lumo-base-color),0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color)}:host(:not([focused])) [part~=date][part~=focused]:before{animation:vaadin-date-picker-month-calendar-focus-date 1.4s infinite}@keyframes vaadin-date-picker-month-calendar-focus-date{50%{box-shadow:0 0 0 1px var(--lumo-base-color),0 0 0 calc(var(--_focus-ring-width) + 1px) transparent}}[part~=date]:not(:empty):not([part~=disabled]):not([part~=selected]):hover:before{background-color:var(--lumo-primary-color-10pct)}[part~=date][part~=selected]{color:var(--lumo-primary-contrast-color)}[part~=date][part~=selected]:before{background-color:var(--_selection-color)}[part~=date][part~=disabled]{color:var(--lumo-disabled-text-color)}@media (pointer: coarse){[part~=date]:hover:not([part~=selected]):before,:host(:not([focus-ring])) [part~=focused]:not([part~=selected]):before{display:none}[part~=date]:not(:empty):not([part~=disabled]):active:before{display:block}:host(:not([focus-ring])) [part~=date][part~=selected]:before{box-shadow:none}}:host([disabled]) *{color:var(--lumo-disabled-text-color)!important}@media (forced-colors: active){[part~=date][part~=focused]{outline:1px solid}[part~=date][part~=selected]{outline:3px solid}}}@media lumo_components_date-picker-overlay-content{:host{display:grid;grid-template-areas:"header header" "months years" "toolbar years";grid-template-columns:minmax(0,1fr) 0;height:100%;outline:none;position:relative;background-image:linear-gradient(var(--lumo-shade-5pct),var(--lumo-shade-5pct));background-size:57px 100%;background-position:top right;background-repeat:no-repeat;cursor:default}:host([dir="rtl"]){background-position:top left}:host([desktop]){grid-template-columns:minmax(0,1fr) auto}:host([fullscreen][years-visible]){grid-template-columns:minmax(0,1fr) auto}[hidden]{display:none!important}::slotted([slot="months"]){--vaadin-infinite-scroller-item-height: calc( var(--lumo-font-size-l) + var(--lumo-space-m) + var(--lumo-font-size-xs) + var(--lumo-space-s) + var(--lumo-size-m) * 6 + var(--lumo-space-s) );--vaadin-infinite-scroller-buffer-offset: 10%;-webkit-mask-image:linear-gradient(transparent,#000 10%,#000 85%,transparent);mask-image:linear-gradient(transparent,#000 10%,#000 85%,transparent);position:relative}::slotted([slot="years"]){--vaadin-infinite-scroller-buffer-width: 57px;width:57px;height:auto;top:0;bottom:0;font-size:var(--lumo-font-size-s);box-shadow:inset 2px 0 4px 0 var(--lumo-shade-5pct);-webkit-mask-image:linear-gradient(transparent,#000 35%,#000 65%,transparent);mask-image:linear-gradient(transparent,#000 35%,#000 65%,transparent);cursor:var(--lumo-clickable-cursor)}:host([dir="rtl"]) ::slotted([slot="years"]){box-shadow:inset -2px 0 4px 0 var(--lumo-shade-5pct)}::slotted([slot="years"]:hover){--_lumo-date-picker-year-opacity: 1}:host([desktop]) ::slotted([slot="years"]),:host([years-visible]) ::slotted([slot="years"]){visibility:visible}::slotted([slot="years"]):before{border:none;width:1em;height:1em;background-color:var(--lumo-base-color);background-image:linear-gradient(var(--lumo-tint-5pct),var(--lumo-tint-5pct));transform:translate(-75%,-50%) rotate(45deg);border-top-right-radius:var(--lumo-border-radius-s);box-shadow:2px -2px 6px 0 var(--lumo-shade-5pct);z-index:1}:host([dir="rtl"]) ::slotted([slot="years"]):before{right:0;transform:translate(75%,-50%) rotate(45deg)}[part=toolbar]{display:flex;grid-area:toolbar;justify-content:space-between;padding:var(--lumo-space-s);border-bottom-left-radius:var(--lumo-border-radius-l)}:host([fullscreen]) [part=toolbar]{grid-area:header;margin-inline-end:57px;background-color:var(--lumo-base-color)}[part=toolbar] ::slotted(vaadin-button){margin:0}[part=years-toggle-button]{display:flex;align-items:center;height:var(--lumo-size-m);padding:0 .5em;border-radius:var(--lumo-border-radius-m);color:var(--lumo-primary-text-color);font-weight:500;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}:host([years-visible]) [part=years-toggle-button]{background-color:var(--lumo-primary-color);color:var(--lumo-primary-contrast-color)}@media screen and (max-width: 374px){:host{background-image:none}:host([fullscreen]) [part=toolbar]{margin-inline-end:0}::slotted([slot="years"]){--vaadin-infinite-scroller-buffer-width: 50px;width:50px;background-color:var(--lumo-shade-5pct)}}}@media lumo_components_date-picker-overlay{[part=overlay]{display:flex;flex:auto;width:calc(var(--lumo-size-m) * 7 + var(--lumo-space-xs) * 2 + 57px);height:100%;max-height:calc(var(--lumo-size-m) * 14);overflow:hidden;-webkit-tap-highlight-color:transparent;flex-direction:column}[part=content]{flex:auto;padding:0;height:100%;overflow:hidden;-webkit-mask-image:none;mask-image:none}:host([top-aligned]) [part=overlay]{margin-top:var(--lumo-space-xs)}:host([bottom-aligned]) [part=overlay]{margin-bottom:var(--lumo-space-xs)}@media (max-width: 450px),(max-height: 450px){[part=overlay]{width:100vw;height:70vh;max-height:70vh}}@media (forced-colors: active){[part=overlay]{outline:3px solid}}}@media lumo_components_date-picker-year{:host{display:block;height:100%}:host([current]) [part=year-number]{color:var(--lumo-primary-text-color)}:host(:not([current])) [part=year-number],[part=year-separator]{opacity:var(--_lumo-date-picker-year-opacity, .7);transition:.2s opacity}[part=year-number],[part=year-separator]{display:flex;align-items:center;justify-content:center;height:50%;transform:translateY(-50%)}[part=year-separator]:after{color:var(--lumo-disabled-text-color);content:"•"}}@media lumo_components_date-picker{:host([opened]){pointer-events:auto}:host([dir="rtl"]) [part=input-field]{direction:ltr}:host([dir="rtl"]) [part=input-field] ::slotted(input)::placeholder{direction:rtl;text-align:left}[part=toggle-button]:before{content:var(--lumo-icons-calendar)}[part=clear-button]:before{content:var(--lumo-icons-cross)}@media (max-width: 450px),(max-height: 450px){[part=overlay-content]{height:70vh}}:host([dir="rtl"]) [part=input-field] ::slotted(input){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em)}:host([dir="rtl"]) [part=input-field] ::slotted(input:placeholder-shown){--_lumo-text-field-overflow-mask-image: none}}:is(:root,:host):before{--vaadin-date-picker-lumo-inject: 1;--vaadin-date-picker-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_date-picker;--vaadin-date-picker-year-lumo-inject: 1;--vaadin-date-picker-year-lumo-inject-modules: lumo_components_date-picker-year;--vaadin-date-picker-overlay-lumo-inject: 1;--vaadin-date-picker-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_menu-overlay-ext, lumo_components_date-picker-overlay;--vaadin-date-picker-overlay-content-lumo-inject: 1;--vaadin-date-picker-overlay-content-lumo-inject-modules: lumo_components_date-picker-overlay-content;--vaadin-month-calendar-lumo-inject: 1;--vaadin-month-calendar-lumo-inject-modules: lumo_components_date-picker-month-calendar}@media lumo_components_date-time-picker{.vaadin-date-time-picker-container{--vaadin-field-default-width: auto}.slots{display:flex;--vaadin-field-default-width: 12em}.slots ::slotted([slot="date-picker"]){min-width:0;flex:1 1 auto}.slots ::slotted([slot="time-picker"]){min-width:0;flex:1 1.65 auto}::slotted([slot="date-picker"]){margin-inline-end:2px;--vaadin-input-field-top-end-radius: 0;--vaadin-input-field-bottom-end-radius: 0}::slotted([slot="time-picker"]){--vaadin-input-field-top-start-radius: 0;--vaadin-input-field-bottom-start-radius: 0}}@media lumo_components_time-picker-overlay{:host{--_vaadin-time-picker-items-container-border-width: var(--lumo-space-xs);--_vaadin-time-picker-items-container-border-style: solid}#overlay{width:var(--vaadin-time-picker-overlay-width, var(--_vaadin-time-picker-overlay-default-width, auto))}}@media lumo_components_time-picker{:host([opened]){pointer-events:auto}[part~=toggle-button]{cursor:pointer}[part=toggle-button]:before{content:var(--lumo-icons-clock)}:host([dir="rtl"]) [part=input-field]{direction:ltr}:host([dir="rtl"]) [part=input-field] ::slotted(input){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em)}:host([dir="rtl"]) [part=input-field] ::slotted(input:placeholder-shown){--_lumo-text-field-overflow-mask-image: none}:host([dir="rtl"]) [part=input-field] ::slotted(input)::placeholder{direction:rtl;text-align:left}}:is(:root,:host):before{--vaadin-time-picker-lumo-inject: 1;--vaadin-time-picker-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_time-picker;--vaadin-time-picker-item-lumo-inject: 1;--vaadin-time-picker-item-lumo-inject-modules: lumo_components_item, lumo_components_combo-box-item;--vaadin-time-picker-overlay-lumo-inject: 1;--vaadin-time-picker-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_combo-box-overlay, lumo_components_time-picker-overlay}:is(:root,:host):before{--vaadin-date-time-picker-lumo-inject: 1;--vaadin-date-time-picker-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_custom-field, lumo_components_date-time-picker}:is(:root,:host):before{--vaadin-details-summary-lumo-inject: 1;--vaadin-details-summary-lumo-inject-modules: lumo_components_details-summary}:is(:root,:host):before{--vaadin-details-lumo-inject: 1;--vaadin-details-lumo-inject-modules: lumo_components_details}@media lumo_mixins_resizable-overlay{[part=overlay]{position:relative;overflow:visible;max-height:100%;display:flex}[part=content]{box-sizing:border-box;height:100%}.resizer-container{display:flex;flex-direction:column;flex-grow:1;border-radius:inherit}[part=overlay][style] .resizer-container{min-height:100%;width:100%}:host(:not([resizable])) .resizer{display:none}:host([resizable]) [part=title]{cursor:move;-webkit-user-select:none;user-select:none}.resizer{position:absolute;height:16px;width:16px}.resizer.edge{height:8px;width:8px;inset:-4px}.resizer.edge.n{width:auto;bottom:auto;cursor:ns-resize}.resizer.ne{top:-4px;right:-4px;cursor:nesw-resize}.resizer.edge.e{height:auto;left:auto;cursor:ew-resize}.resizer.se{bottom:-4px;right:-4px;cursor:nwse-resize}.resizer.edge.s{width:auto;top:auto;cursor:ns-resize}.resizer.sw{bottom:-4px;left:-4px;cursor:nesw-resize}.resizer.edge.w{height:auto;right:auto;cursor:ew-resize}.resizer.nw{top:-4px;left:-4px;cursor:nwse-resize}}:is(:root,:host):before{--vaadin-dialog-overlay-lumo-inject: 1;--vaadin-dialog-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_resizable-overlay, lumo_components_dialog-overlay}@media lumo_components_drawer-toggle{:host{display:inline-flex;align-items:center;justify-content:center;cursor:default;position:relative;outline:none;width:var(--lumo-size-l);height:var(--lumo-size-l);min-width:auto;margin:0 var(--lumo-space-s);padding:0;background:transparent}[part=icon],[part=icon]:after,[part=icon]:before{position:inherit;height:auto;width:auto;background:transparent;top:auto}[part=icon]:after,[part=icon]:before{content:""}[part=icon]:after{top:6px}[part=icon]:before{top:12px;font-family:lumo-icons;font-size:var(--lumo-icon-size-m);content:var(--lumo-icons-menu)}:host([slot~="navbar"]){color:var(--lumo-secondary-text-color)}}:is(:root,:host):before{--vaadin-drawer-toggle-lumo-inject: 1;--vaadin-drawer-toggle-lumo-inject-modules: lumo_components_button, lumo_components_drawer-toggle}@media lumo_components_email-field{:host([dir="rtl"]) [part=input-field]{direction:ltr}:host([dir="rtl"]) [part=input-field] ::slotted(input){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em)}:host([dir="rtl"]) [part=input-field] ::slotted(input)::placeholder{direction:rtl;text-align:left}:host([dir="rtl"]) [part=input-field] ::slotted(input:placeholder-shown){--_lumo-text-field-overflow-mask-image: none}}:is(:root,:host):before{--vaadin-email-field-lumo-inject: 1;--vaadin-email-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_email-field}@media lumo_components_field-outline{:host{display:block;box-sizing:border-box;position:absolute;inset:0;width:100%;height:100%;pointer-events:none;-webkit-user-select:none;user-select:none;opacity:0;--_active-user-color: transparent;transition:opacity .3s;-webkit-mask-image:none!important;mask-image:none!important}:host([has-active-user]){opacity:1}:host:before{content:"";position:absolute;inset:0;box-shadow:0 0 0 2px var(--_active-user-color);border-radius:var(--lumo-border-radius-s);transition:box-shadow .3s}:host([context$="checkbox"]):before{box-shadow:0 0 0 2px var(--lumo-base-color),0 0 0 4px var(--_active-user-color)}:host([context$="radio-button"]):before{border-radius:50%;box-shadow:0 0 0 3px var(--lumo-base-color),0 0 0 5px var(--_active-user-color)}:host([context$="item"]):before{box-shadow:inset 0 0 0 2px var(--_active-user-color)}}@media lumo_components_user-tag{:host{display:block;box-sizing:border-box;margin:0 0 var(--vaadin-user-tag-offset);opacity:0;height:1.3rem;transition:opacity .2s ease-in-out;background-color:var(--vaadin-user-tag-color);color:#fff;cursor:default;-webkit-user-select:none;user-select:none;--vaadin-user-tag-offset: 4px;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-xxs);border-radius:var(--lumo-border-radius-s);box-shadow:var(--lumo-box-shadow-xs);--vaadin-user-tag-offset: var(--lumo-space-xs)}:host(.show){opacity:1}:host(:last-of-type){margin-bottom:0}[part=name]{overflow:hidden;white-space:nowrap;text-overflow:ellipsis;box-sizing:border-box;height:1.3rem;font-size:13px;color:var(--lumo-primary-contrast-color);padding:.3em calc(.3em + var(--lumo-border-radius-s) / 4);line-height:1;font-weight:500;min-width:calc(var(--lumo-line-height-xs) * 1em + .45em)}}@media lumo_components_user-tags-overlay{[part=overlay]{box-shadow:none;background:transparent;position:relative;left:-4px;padding:4px;outline:none;overflow:visible;will-change:opacity,transform}[part=content]{display:flex;flex-direction:column;align-items:flex-start;padding:0}:host([dir="rtl"]) [part=overlay]{left:auto;right:-4px}:host([opening]),:host([closing]){animation:.14s user-tags-overlay-dummy-animation}@keyframes user-tags-overlay-dummy-animation{0%{opacity:1}to{opacity:1}}:host([opening]) [part=overlay]{animation:.1s lumo-user-tags-enter ease-out both}@keyframes lumo-user-tags-enter{0%{opacity:0}}:host([closing]) [part=overlay]{animation:.1s lumo-user-tags-exit both}@keyframes lumo-user-tags-exit{to{opacity:0}}}:is(:root,:host):before{--vaadin-user-tags-overlay-lumo-inject: 1;--vaadin-user-tags-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_user-tags-overlay;--vaadin-user-tag-lumo-inject: 1;--vaadin-user-tag-lumo-inject-modules: lumo_components_user-tag;--vaadin-field-outline-lumo-inject: 1;--vaadin-field-outline-lumo-inject-modules: lumo_components_field-outline}@media lumo_components_form-item{[part=label]{color:var(--lumo-secondary-text-color);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-s);font-weight:500;margin-top:var(--lumo-space-m);margin-left:calc(var(--lumo-border-radius-m) / 4);margin-bottom:var(--lumo-space-xs);line-height:1.333}[part=required-indicator]:after{content:var(--lumo-required-field-indicator, "•");transition:opacity .2s;opacity:0;color:var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));position:relative;width:1em;text-align:center}:host([required]) [part=required-indicator]:after{opacity:1}:host([invalid]) [part=required-indicator]:after{color:var(--lumo-required-field-indicator-color, var(--lumo-error-text-color))}}:is(:root,:host):before{--vaadin-form-item-lumo-inject: 1;--vaadin-form-item-lumo-inject-modules: lumo_components_form-item}:is(:root,:host):before{--vaadin-form-layout-lumo-inject: 1;--vaadin-form-layout-lumo-inject-modules: lumo_components_form-layout}@media lumo_mixins_grid-pro-editor{:host([theme~="grid-pro-editor"]){position:absolute;inset:0;padding:0;will-change:transform;font-size:inherit;--lumo-text-field-size: 27px;box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host([theme~="grid-pro-editor"]) [part=input-field]{padding:0;border-radius:0;flex-grow:1;font-weight:400;--vaadin-input-field-border-color: transparent}:host([theme~="grid-pro-editor"][focus-ring]) [part=input-field]{box-shadow:none}:host([theme~="grid-pro-editor"]) ::slotted(input){padding:0 var(--lumo-space-m);font-size:inherit}}@media lumo_components_grid-pro-edit-select{:host([theme~="grid-pro-editor"]) [part=toggle-button]{margin-right:var(--lumo-space-xs)}:host([theme~="grid-pro-editor"]) [part=input-field] ::slotted([slot="value"]){box-sizing:border-box;padding:0 var(--lumo-space-m);font-size:var(--lumo-font-size-m);-webkit-user-select:none;user-select:none}}@media lumo_components_select{:host{position:relative;--lumo-input-field-pointer-focus-visible: 0}::slotted(div[slot="overlay"]){display:contents}:host(:not([theme*="align"])) ::slotted([slot="value"]){text-align:start}[part=input-field]{cursor:var(--lumo-clickable-cursor)}[part=input-field] ::slotted([slot="value"]){flex-grow:1;font-weight:var(--vaadin-input-field-value-font-weight, 500)}[part=input-field] ::slotted([slot="value"]:not([placeholder])){color:var(--vaadin-input-field-value-color, var(--lumo-body-text-color))}:host([readonly]) [part=input-field] ::slotted([slot="value"]:not([placeholder])){color:var(--lumo-secondary-text-color)}[part=input-field] ::slotted([slot="value"][placeholder]){color:var(--vaadin-input-field-placeholder-color, var(--lumo-secondary-text-color))}:host(:is([readonly],[disabled])) ::slotted([slot="value"][placeholder]){opacity:0}[part=toggle-button]:before{content:var(--lumo-icons-dropdown)}:host(:hover:not([readonly]):not([disabled])) [part=toggle-button]{color:var(--lumo-contrast-80pct)}:host([theme~="small"]) [part=input-field] ::slotted([slot="value"]){--_lumo-selected-item-height: var(--lumo-size-s);--_lumo-selected-item-padding: 0}}@media lumo_components_select-overlay{:host{align-items:flex-start;justify-content:flex-start;--_lumo-item-selected-icon-display: block}:host([phone]){top:0!important;right:0!important;bottom:var(--vaadin-overlay-viewport-bottom, 0)!important;left:0!important;align-items:stretch;justify-content:flex-end}:host(:not([phone])) [part=overlay]{min-width:var(--vaadin-select-overlay-width, var(--_vaadin-select-overlay-default-width))}:host([no-vertical-overlap][top-aligned]) [part=overlay]{margin-block-start:var(--lumo-space-xs)}:host([no-vertical-overlap][bottom-aligned]) [part=overlay]{margin-block-end:var(--lumo-space-xs)}:host([theme~="align-left"]){text-align:left}:host([theme~="align-right"]){text-align:right}:host([theme~="align-center"]){text-align:center}@media (forced-colors: active){[part=overlay]{outline:3px solid}}}@media lumo_components_select-value-button{:host{display:inline-block;position:relative;outline:none;white-space:nowrap;-webkit-user-select:none;user-select:none;min-width:0;width:0;font-family:var(--lumo-font-family);font-size:var(--vaadin-input-field-value-font-size, var(--lumo-font-size-m));padding:0 .25em;--_lumo-selected-item-height: var(--lumo-size-m);--_lumo-selected-item-padding: .5em}::slotted(*){padding:var(--_lumo-selected-item-padding) 0 var(--_lumo-selected-item-padding) 0;flex:auto;min-height:var(--_lumo-selected-item-height);font-size:inherit}::slotted(*:hover){background-color:transparent}::slotted(*:not([selected])){line-height:1}.vaadin-button-container{display:inline-flex;align-items:center;justify-content:center;text-align:inherit;width:100%;height:100%;min-height:inherit;text-shadow:inherit}[part=label]{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:100%;line-height:inherit}}:is(:root,:host):before{--vaadin-select-lumo-inject: 1;--vaadin-select-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_select;--vaadin-select-item-lumo-inject: 1;--vaadin-select-item-lumo-inject-modules: lumo_components_item;--vaadin-select-overlay-lumo-inject: 1;--vaadin-select-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_menu-overlay-ext, lumo_components_select-overlay;--vaadin-select-list-box-lumo-inject: 1;--vaadin-select-list-box-lumo-inject-modules: lumo_components_list-box;--vaadin-select-value-button-lumo-inject: 1;--vaadin-select-value-button-lumo-inject-modules: lumo_components_select-value-button}:is(:root,:host):before{--vaadin-grid-pro-edit-text-field-lumo-inject: 1;--vaadin-grid-pro-edit-text-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_mixins_grid-pro-editor;--vaadin-grid-pro-edit-select-lumo-inject: 1;--vaadin-grid-pro-edit-select-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_mixins_grid-pro-editor, lumo_components_select, lumo_components_grid-pro-edit-select;--vaadin-grid-pro-edit-checkbox-lumo-inject: 1;--vaadin-grid-pro-edit-checkbox-lumo-inject-modules: lumo_mixins_checkable-field, lumo_components_checkbox}@media lumo_components_grid-pro{:host([navigating]) [part~=cell]:active:before{content:"";position:absolute;inset:0;pointer-events:none;box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part~=editable-cell],[part~=editable-cell] ::slotted(vaadin-grid-cell-content){cursor:var(--lumo-clickable-cursor)}[part~=editable-cell]:hover,[part~=editable-cell]:focus{background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}:host([theme~="highlight-editable-cells"]) [part~=editable-cell]{background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}:host([theme~="highlight-editable-cells"]) [part~=editable-cell]:hover,:host([theme~="highlight-editable-cells"]) [part~=editable-cell]:focus{background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-10pct),var(--lumo-contrast-10pct))}:host([theme~="highlight-read-only-cells"]) [tabindex]:not([part~=editable-cell]):not([part~=header-cell]):not([part~=footer-cell]){background-image:repeating-linear-gradient(135deg,transparent,transparent 6px,var(--lumo-contrast-5pct) 6px,var(--lumo-contrast-5pct) 14px)}:host([loading-editor]) [part~=focused-cell]:before{content:"";position:absolute;inset:0;pointer-events:none;box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);animation:vaadin-grid-pro-loading-editor 1.4s infinite;opacity:0}@keyframes vaadin-grid-pro-loading-editor{50%{opacity:1}}[part~=updating-cell]:after{content:"";position:absolute;inset:var(--_cell-padding);margin:var(--_focus-ring-width);border-radius:4px;background-size:max(4em,50%);background-repeat:no-repeat;background-position:min(-200%,-4em) 0;background-image:linear-gradient(90deg,transparent,var(--lumo-contrast-10pct),transparent);animation:vaadin-grid-pro-updating-cell 1.3s ease-out infinite}@keyframes vaadin-grid-pro-updating-cell{to{background-position:max(300%,8em) 0}}:host([loading-editor]) [part~=focused-cell] ::slotted(vaadin-grid-cell-content),[part~=updating-cell] ::slotted(vaadin-grid-cell-content){opacity:0;pointer-events:none}}:is(:root,:host):before{--vaadin-grid-pro-lumo-inject: 1;--vaadin-grid-pro-lumo-inject-modules: lumo_components_grid, lumo_components_grid-pro}@media lumo_components_grid-tree-toggle{:host{--vaadin-grid-tree-toggle-level-offset: 2em;display:inline-flex;max-width:100%;align-items:center;vertical-align:middle;transform:translate(calc(var(--lumo-space-s) * -1));-webkit-tap-highlight-color:transparent}:host([hidden]){display:none!important}:host(:not([leaf])){cursor:default}#level-spacer,[part=toggle]{flex:none}#level-spacer{display:inline-block;width:calc(var(--_level, "0") * var(--vaadin-grid-tree-toggle-level-offset))}[part=toggle]:before{line-height:1em;font-family:lumo-icons;display:inline-block;height:100%}:host(:not([expanded])) [part=toggle]:before{content:var(--lumo-icons-angle-right)}:host([expanded]) [part=toggle]:before{content:var(--lumo-icons-angle-right);transform:rotate(90deg)}:host([leaf]) [part=toggle]{visibility:hidden}slot{display:block;overflow:hidden;text-overflow:ellipsis}[part=toggle]{display:inline-block;font-size:1.5em;line-height:1;width:1em;height:1em;text-align:center;color:var(--lumo-contrast-50pct);cursor:var(--lumo-clickable-cursor);padding:calc(1em / 3);margin:calc(1em / -3)}:host(:not([dir="rtl"])) [part=toggle]{margin-right:0}@media (hover: hover){:host(:hover) [part=toggle]{color:var(--lumo-contrast-80pct)}}:host([dir="rtl"]){margin-left:0;margin-right:calc(var(--lumo-space-s) * -1)}:host([dir="rtl"]) [part=toggle]{margin-left:0}:host([dir="rtl"][expanded]) [part=toggle]:before{transform:rotate(-90deg)}:host([dir="rtl"]:not([expanded])) [part=toggle]:before,:host([dir="rtl"][expanded]) [part=toggle]:before{content:var(--lumo-icons-angle-left)}}:is(:root,:host):before{--vaadin-grid-tree-toggle-lumo-inject: 1;--vaadin-grid-tree-toggle-lumo-inject-modules: lumo_components_grid-tree-toggle}:is(:root,:host):before{--vaadin-grid-lumo-inject: 1;--vaadin-grid-lumo-inject-modules: lumo_components_grid}@media lumo_components_horizontal-layout{:host([theme~="margin"]){margin:var(--lumo-space-m)}:host([theme~="padding"]){padding:var(--lumo-space-m)}:host([theme~="spacing-xs"]){gap:var(--lumo-space-xs)}:host([theme~="spacing-s"]){gap:var(--lumo-space-s)}:host([theme~="spacing"]){gap:var(--lumo-space-m)}:host([theme~="spacing-l"]){gap:var(--lumo-space-l)}:host([theme~="spacing-xl"]){gap:var(--lumo-space-xl)}}:is(:root,:host):before{--vaadin-horizontal-layout-lumo-inject: 1;--vaadin-horizontal-layout-lumo-inject-modules: lumo_components_horizontal-layout}@media lumo_components_icon{:host{width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}}:is(:root,:host):before{--vaadin-icon-lumo-inject: 1;--vaadin-icon-lumo-inject-modules: lumo_components_icon}@media lumo_components_number-field{:host([readonly]) [part$=button]{pointer-events:none}:host([step-buttons-visible]:not([theme~="align-right"])) ::slotted(input){text-align:center}:host(:not([disabled])) [part$=button][disabled]{opacity:.2}:host([step-buttons-visible]) [part=input-field]{padding:0}[part=decrease-button],[part=increase-button]{cursor:pointer;width:1.5em;height:1.5em;-webkit-user-select:none;user-select:none}[part=decrease-button]:before,[part=increase-button]:before{margin-top:.25em}[part=decrease-button]:before{content:var(--lumo-icons-minus)}[part=increase-button]:before{content:var(--lumo-icons-plus)}:host([dir="rtl"]) [part=input-field]{direction:ltr}:host([dir="rtl"]:not([theme~="align-right"])) ::slotted(input){--_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em)}}:is(:root,:host):before{--vaadin-integer-field-lumo-inject: 1;--vaadin-integer-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_number-field}:is(:root,:host):before{--vaadin-item-lumo-inject: 1;--vaadin-item-lumo-inject-modules: lumo_components_item}:is(:root,:host):before{--vaadin-list-box-lumo-inject: 1;--vaadin-list-box-lumo-inject-modules: lumo_components_list-box}@media lumo_components_login-overlay-wrapper{:host{inset:0;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}[part=overlay]{outline:none;background:none;border-radius:0;box-shadow:none;width:100%;height:100%}[part=card]{max-width:100%;box-sizing:border-box;overflow:hidden;display:flex;flex-direction:column;width:calc(var(--lumo-size-m) * 10);background:var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct),var(--lumo-tint-5pct));border-radius:var(--lumo-border-radius-l);box-shadow:var(--lumo-box-shadow-s);margin:var(--lumo-space-s);height:auto}[part=brand]{box-sizing:border-box;overflow:hidden;flex-grow:1;flex-shrink:0;display:flex;flex-direction:column;justify-content:flex-end;padding:var(--lumo-space-l) var(--lumo-space-xl) var(--lumo-space-l) var(--lumo-space-l);background-color:var(--lumo-primary-color);color:var(--lumo-primary-contrast-color);min-height:calc(var(--lumo-size-m) * 5)}::slotted([slot="title"]){color:inherit;margin:0;font-size:var(--lumo-font-size-xxxl);font-weight:600;line-height:var(--lumo-line-height-xs)}[part=backdrop]{background:var(--lumo-base-color) linear-gradient(var(--lumo-shade-5pct),var(--lumo-shade-5pct))}[part=description]{line-height:var(--lumo-line-height-s);color:var(--lumo-tint-70pct);margin:.5em 0 0}[part=content]{height:100%;display:flex;align-items:center;justify-content:center;padding:0}::slotted(vaadin-login-form-wrapper){min-height:100%;max-width:100%}@media only screen and (max-width: 500px){[part=overlay],[part=content]{height:100%}[part=content]{min-height:100%;background:var(--lumo-base-color);align-items:flex-start}[part=card],[part=overlay]{width:100%;border-radius:0;box-shadow:none;margin:0}:host([dir="rtl"]) [part=brand]{padding:var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-xl)}}@media only screen and (max-height: 600px) and (min-width: 600px) and (orientation: landscape){[part=card]{flex-direction:row;align-items:stretch;max-width:calc(var(--lumo-size-m) * 16);width:100%}[part=brand],[part=form-wrapper]{flex:auto;flex-basis:0;box-sizing:border-box}[part=brand]{justify-content:flex-start}[part=form-wrapper]{padding:var(--lumo-space-l);overflow:auto}::slotted(vaadin-login-form-wrapper){flex:1;padding:2px}}@media only screen and (max-height: 500px) and (min-width: 600px) and (orientation: landscape),only screen and (max-width: 600px) and (min-width: 600px) and (orientation: landscape){[part=content]{height:100vh}[part=card]{margin:0;width:100%;max-width:none;height:100%;flex:auto;border-radius:0;box-shadow:none}[part=form-wrapper]{height:100%;overflow:auto}}@media only screen and (device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3){[part=card]{padding-right:env(safe-area-inset-right);padding-left:env(safe-area-inset-left)}[part=brand]{margin-left:calc(env(safe-area-inset-left)*-1);padding-left:calc(var(--lumo-space-l) + env(safe-area-inset-left))}:host([dir="rtl"]) [part=card]{padding-left:env(safe-area-inset-right);padding-right:env(safe-area-inset-left)}:host([dir="rtl"]) [part=brand]{margin-right:calc(env(safe-area-inset-left)*-1);padding-right:calc(var(--lumo-space-l) + env(safe-area-inset-left))}}}@media lumo_components_login-form-wrapper{:host{display:flex;flex-direction:column;box-sizing:border-box;padding:var(--lumo-space-l);overflow:hidden;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;width:calc(var(--lumo-size-m) * 10);max-width:100%;background:var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct),var(--lumo-tint-5pct))}:host([hidden]){display:none!important}::slotted(form){display:flex;flex-direction:column}::slotted([slot="form-title"]){margin:0;margin-top:calc(var(--lumo-font-size-xxxl) - var(--lumo-font-size-xxl));color:var(--lumo-header-text-color);font-size:var(--lumo-font-size-xxl);font-weight:600;line-height:var(--lumo-line-height-xs)}[part=error-message]{position:relative;background-color:var(--lumo-error-color-10pct);padding:var(--lumo-space-m);border-radius:var(--lumo-border-radius-m);margin-top:var(--lumo-space-m);margin-bottom:var(--lumo-space-s);color:var(--lumo-error-text-color)}strong{font-weight:600}::slotted([slot="submit"]){margin-top:var(--lumo-space-l);margin-bottom:var(--lumo-space-s)}::slotted([slot="forgot-password"]){margin:var(--lumo-space-s) auto}:host(:not([dir="rtl"])) [part=error-message]{padding-left:var(--lumo-size-m)}:host([dir="rtl"]) [part=error-message]{padding-right:var(--lumo-size-m)}[part=error-message]:before{content:var(--lumo-icons-error);font-family:lumo-icons;font-size:var(--lumo-icon-size-m);position:absolute;width:var(--lumo-size-m);height:1em;line-height:1;text-align:center}:host(:not([dir="rtl"])) [part=error-message]:before{margin-left:calc(var(--lumo-size-m) * -.95)}:host([dir="rtl"]) [part=error-message]:before{margin-right:calc(var(--lumo-size-m) * -.95)}[part=error-message-title]{display:block;margin:0 0 .25em;color:inherit;line-height:var(--lumo-line-height-xs)}[part=error-message-description]{font-size:var(--lumo-font-size-s);line-height:var(--lumo-line-height-s);margin:0;opacity:.9}[part=footer]{font-size:var(--lumo-font-size-xs);line-height:var(--lumo-line-height-s);color:var(--lumo-secondary-text-color)}}@media lumo_components_password-field-button{:host{position:absolute;right:0;top:0;margin:0;padding:0;width:100%;height:100%;min-width:auto;background:transparent;outline:none}}@media lumo_components_password-field{[part=reveal-button]:before{content:var(--lumo-icons-eye)}:host([password-visible]) [part=reveal-button]:before{content:var(--lumo-icons-eye-disabled)}[part=reveal-button]{position:relative;display:var(--lumo-password-field-reveal-button-display, block)}[part=reveal-button][hidden]{display:none!important}}:is(:root,:host):before{--vaadin-password-field-lumo-inject: 1;--vaadin-password-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_password-field;--vaadin-password-field-button-lumo-inject: 1;--vaadin-password-field-button-lumo-inject-modules: lumo_components_button, lumo_components_password-field-button}:is(:root,:host):before{--vaadin-login-form-wrapper-lumo-inject: 1;--vaadin-login-form-wrapper-lumo-inject-modules: lumo_components_login-form-wrapper}:is(:root,:host):before{--vaadin-login-overlay-wrapper-lumo-inject: 1;--vaadin-login-overlay-wrapper-lumo-inject-modules: lumo_mixins_overlay, lumo_components_login-overlay-wrapper}@media lumo_components_map{:host{font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);--vaadin-map-controls-inset: var(--lumo-space-xs);--vaadin-map-icon-zoom-in: var(--lumo-icons-plus);--vaadin-map-icon-zoom-out: var(--lumo-icons-minus);--vaadin-map-icon-compass: var(--lumo-icons-arrow-up);--vaadin-map-icon-overview-map-collapse: var(--lumo-icons-angle-down);--vaadin-map-icon-overview-map-expand: var(--lumo-icons-angle-up);--vaadin-map-icon-close: var(--lumo-icons-cross);--vaadin-map-icon-attribution-collapse: var(--lumo-icons-angle-right);--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host(:not([theme~="no-border"])){border-radius:var(--lumo-border-radius-l)}:host(:not([theme~="no-border"])):before{border:1px solid var(--lumo-contrast-10pct)}:host([focus-ring]){outline:none;box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}.ol-overviewmap button span:empty:before,.ol-zoom-in:empty:before,.ol-zoom-out:empty:before,.ol-compass:empty:before,.ol-full-screen button:empty:before,.ol-full-screen-true:empty:before{background:transparent;-webkit-mask-image:none;mask-image:none;display:inline;width:auto;height:auto}.ol-control:not(.ol-uncollapsible):hover{box-shadow:var(--lumo-box-shadow-s);background-color:var(--lumo-shade-20pct)}.ol-scale-bar-inner{border-radius:var(--lumo-border-radius-s)}.ol-compass:empty:before{content:var(--vaadin-map-icon-compass)}.ol-full-screen{height:var(--lumo-size-s)}.ol-full-screen button:empty:before{content:var(--vaadin-map-icon-fullscreen, "⤢")}.ol-full-screen .ol-full-screen-true:empty:before{content:var(--vaadin-map-icon-close, "×")}.ol-overviewmap button span:empty:before{content:var(--vaadin-map-icon-overview-map-collapse)}.ol-overviewmap.ol-collapsed button span:empty:before{content:var(--vaadin-map-icon-overview-map-expand)}.ol-overviewmap-map{margin:var(--lumo-space-xs);border-radius:var(--lumo-border-radius-s)}.ol-overviewmap:not(.ol-collapsed),.ol-overviewmap:not(.ol-collapsed):hover{background-color:var(--lumo-base-color);box-shadow:var(--lumo-box-shadow-s);transition:.15s box-shadow}.ol-overviewmap.ol-collapsed button{rotate:none}.ol-zoomslider button{height:var(--lumo-space-m)}.ol-zoomslider:hover button{box-shadow:var(--lumo-box-shadow-s)}.ol-control,.ol-scale-bar,.ol-scale-line{margin:var(--lumo-space-xs)}.ol-control{border-radius:var(--lumo-border-radius-m);transition:.15s box-shadow,.15s background-color;-webkit-backdrop-filter:blur(8px)}.ol-control:hover{background-color:var(--lumo-base-color)}.ol-control button{width:var(--lumo-size-s);height:var(--lumo-size-s);border-radius:inherit;font-family:lumo-icons;font-size:var(--lumo-icon-size-s);font-weight:400}.ol-control button,.ol-attribution:not(.ol-uncollapsible) ul{display:block;background-color:var(--lumo-base-color);color:var(--lumo-body-text-color)}.ol-control button:hover{color:var(--lumo-primary-text-color)}.ol-control button:active{background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}.ol-control button:focus-visible{outline:none;box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}.ol-zoom-in:empty:before{content:var(--vaadin-map-icon-zoom-in)}.ol-zoom-out:empty:before{content:var(--vaadin-map-icon-zoom-out)}.ol-attribution.ol-uncollapsible{border-radius:var(--lumo-border-radius-m) 0 0 0}.ol-attribution button span:empty:before{content:var(--vaadin-map-icon-attribution-collapse, "\\\\25B8")}.ol-attribution.ol-collapsed button span:empty:before{content:var(--vaadin-map-icon-attribution-expand, "\\\\2139")}.ol-attribution ul{font-size:var(--lumo-font-size-xxs);color:var(--lumo-secondary-text-color);padding:var(--lumo-space-xs) var(--lumo-space-s);cursor:default}.ol-attribution:not(.ol-uncollapsible) ul{background-color:var(--lumo-base-color)}}:is(:root,:host):before{--vaadin-map-lumo-inject: 1;--vaadin-map-lumo-inject-modules: lumo_components_map}:where(:root,:host){--vaadin-master-detail-layout-backdrop: var( --lumo-shade-20pct );--vaadin-master-detail-layout-detail-background: var( --lumo-base-color );--vaadin-master-detail-layout-detail-shadow: 0 0 0 1px var(--lumo-shade-5pct), var(--lumo-box-shadow-m);--vaadin-master-detail-layout-border-color: var( --lumo-contrast-10pct )}@media lumo_components_menu-bar-button{:host{margin-block:calc(var(--lumo-space-xs) / 2);margin-right:calc(var(--lumo-space-xs) / 2);margin-left:0;border-radius:0}[part=label]{width:100%}[part=label] ::slotted(vaadin-menu-bar-item){justify-content:center;background-color:transparent;height:var(--lumo-button-size);margin:0 calc((var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2) * -1);padding-left:calc(var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2);padding-right:calc(var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2)}:host([theme~="small"]) [part=label] ::slotted(vaadin-menu-bar-item){min-height:var(--lumo-size-s);margin:0 calc((var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2) * -1);padding-left:calc(var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2);padding-right:calc(var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2)}:host([theme~="tertiary"]) [part=label] ::slotted(vaadin-menu-bar-item){margin:0 calc((var(--lumo-button-size) / 6) * -1);padding-left:calc(var(--lumo-button-size) / 6);padding-right:calc(var(--lumo-button-size) / 6)}:host([theme~="tertiary-inline"]){margin-top:calc(var(--lumo-space-xs) / 2);margin-bottom:calc(var(--lumo-space-xs) / 2);margin-right:calc(var(--lumo-space-xs) / 2)}:host([theme~="tertiary-inline"]) [part=label] ::slotted(vaadin-menu-bar-item){margin:0;padding:0}:host([first-visible]){border-radius:var(--lumo-border-radius-m) 0 0 var(--lumo-border-radius-m);margin-left:calc(var(--lumo-space-xs) / 2)}:host([last-visible]),:host([slot="overflow"]){border-radius:0 var(--lumo-border-radius-m) var(--lumo-border-radius-m) 0}:host([theme~="tertiary"]),:host([theme~="tertiary-inline"]){border-radius:var(--lumo-border-radius-m)}:host([slot="overflow"]){min-width:var(--lumo-button-size);margin-inline-end:0;padding-left:calc(var(--lumo-button-size) / 4);padding-right:calc(var(--lumo-button-size) / 4)}:host([slot="overflow"]) ::slotted(*){font-size:var(--lumo-font-size-xl)}:host([slot="overflow"]) [part=prefix],:host([slot="overflow"]) [part=suffix]{margin-left:0;margin-right:0}:host([theme~="dropdown-indicators"]:not([slot="overflow"]):not([theme~="icon"])[aria-haspopup]) [part=suffix]{margin-inline-start:0;width:1em;height:1em;line-height:1;font-size:var(--lumo-icon-size-s);position:relative;inset-inline-start:.15em}:host([theme~="dropdown-indicators"]:not([slot="overflow"]):not([theme~="icon"])[aria-haspopup]) [part=suffix]:after{font-family:lumo-icons;content:var(--lumo-icons-dropdown)}:host([theme~="dropdown-indicators"]:not([slot="overflow"]):not([theme~="icon"])[theme~="tertiary"][aria-haspopup]) [part=suffix]{inset-inline-start:.05em}:host([theme~="dropdown-indicators"]:not([slot="overflow"]):not([theme~="icon"])[theme~="tertiary-inline"][aria-haspopup]) [part=suffix]{inset-inline-start:0}:host([dir="rtl"]){margin-left:calc(var(--lumo-space-xs) / 2);margin-right:0;border-radius:0}:host([dir="rtl"][first-visible]){border-radius:0 var(--lumo-border-radius-m) var(--lumo-border-radius-m) 0;margin-right:calc(var(--lumo-space-xs) / 2)}:host([dir="rtl"][last-visible]),:host([dir="rtl"][slot="overflow"]){border-radius:var(--lumo-border-radius-m) 0 0 var(--lumo-border-radius-m)}}@media lumo_components_menu-bar-item{[part=content]{display:flex;align-items:inherit;justify-content:inherit}[part=content] ::slotted(vaadin-icon){width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}[part=content] ::slotted(vaadin-icon[icon^="vaadin:"]){padding:var(--lumo-space-xs);box-sizing:border-box!important}}@media lumo_components_menu-bar-overlay{:host(:first-of-type){padding-top:var(--lumo-space-xs)}}@media lumo_components_menu-bar{:host{display:block}:host([hidden]){display:none!important}[part=container]{position:relative;display:flex;width:100%;flex-wrap:nowrap;overflow:hidden}:host([has-single-button]) ::slotted(vaadin-menu-bar-button){border-radius:var(--lumo-border-radius-m)}:host([theme~="end-aligned"]) ::slotted(vaadin-menu-bar-button[first-visible]),:host([theme~="end-aligned"][has-single-button]) ::slotted(vaadin-menu-bar-button){margin-inline-start:auto}}:is(:root,:host):before{--vaadin-menu-bar-lumo-inject: 1;--vaadin-menu-bar-lumo-inject-modules: lumo_components_menu-bar;--vaadin-menu-bar-overlay-lumo-inject: 1;--vaadin-menu-bar-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_menu-overlay-ext, lumo_components_context-menu-overlay, lumo_components_menu-bar-overlay;--vaadin-menu-bar-list-box-lumo-inject: 1;--vaadin-menu-bar-list-box-lumo-inject-modules: lumo_components_list-box, lumo_components_context-menu-list-box;--vaadin-menu-bar-item-lumo-inject: 1;--vaadin-menu-bar-item-lumo-inject-modules: lumo_components_item, lumo_components_context-menu-item, lumo_components_menu-bar-item;--vaadin-menu-bar-button-lumo-inject: 1;--vaadin-menu-bar-button-lumo-inject-modules: lumo_components_button, lumo_components_menu-bar-button}@media lumo_components_message-input{:host{align-items:flex-start;box-sizing:border-box;display:flex;max-height:50vh;overflow:hidden;flex-shrink:0;padding:var(--lumo-space-s) var(--lumo-space-m)}:host([hidden]){display:none!important}::slotted([slot="button"]){flex-shrink:0}::slotted([slot="textarea"]){align-self:stretch;flex-grow:1;margin-inline-end:var(--lumo-space-s)}}@media lumo_components_text-area{.vaadin-text-area-container{flex:auto}[part=label],[part=helper-text],[part=error-message]{flex:none}::slotted(textarea){-webkit-appearance:none;appearance:none;flex:auto;overflow:hidden;width:100%;height:100%;outline:none;resize:none;margin:0;padding:0 .25em;border:0;border-radius:0;min-width:0;font:inherit;font-size:1em;line-height:normal;color:inherit;background-color:transparent;box-shadow:none}[part=input-field] ::slotted(textarea){align-self:stretch;white-space:pre-wrap;line-height:inherit;--_lumo-text-field-overflow-mask-image: none}[part=input-field] ::slotted(:not(textarea)){align-self:flex-start}:host([disabled]) ::slotted(textarea){-webkit-user-select:none;user-select:none}[part=input-field],[part=input-field] ::slotted(textarea){height:auto;box-sizing:border-box;min-height:0}[part=input-field]{flex:auto;overflow:auto;padding-top:calc((var(--lumo-text-field-size) - 1em * var(--lumo-line-height-s)) / 2);padding-bottom:calc((var(--lumo-text-field-size) - 1em * var(--lumo-line-height-s)) / 2);transition:background-color .1s;line-height:var(--lumo-line-height-s)}:host(:not([readonly])) [part=input-field]:after{display:none}:host([readonly]) [part=input-field]{border:var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-30pct))}:host([readonly]) [part=input-field]:after{border:none}:host(:hover:not([readonly]):not([focused]):not([invalid])) [part=input-field]{background-color:var(--lumo-contrast-20pct)}@media (pointer: coarse){:host(:hover:not([readonly]):not([focused]):not([invalid])) [part=input-field]{background-color:var(--lumo-contrast-10pct)}:host(:active:not([readonly]):not([focused])) [part=input-field]{background-color:var(--lumo-contrast-20pct)}}[part=input-field] ::slotted([slot$="fix"]),[part=clear-button]{position:sticky;top:0;align-self:flex-start}[part=input-field] ::slotted(vaadin-icon[slot$="fix"]),[part=clear-button]{top:calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2);margin-top:calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2);margin-bottom:calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2)}}:is(:root,:host):before{--vaadin-text-area-lumo-inject: 1;--vaadin-text-area-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_text-area}:is(:root,:host):before{--vaadin-message-input-lumo-inject: 1;--vaadin-message-input-lumo-inject-modules: lumo_components_message-input}@media lumo_components_message{:host{display:flex;flex-direction:row;outline:none;color:var(--lumo-body-text-color);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);padding:var(--lumo-space-s) var(--lumo-space-m);-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;-webkit-text-size-adjust:100%;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([hidden]){display:none!important}[part=content]{display:flex;flex-direction:column;flex-grow:1}[part=header]{align-items:baseline;display:flex;flex-flow:row wrap;min-height:calc(var(--lumo-font-size-m) * var(--lumo-line-height-m))}[part=name]{font-weight:500;margin-right:var(--lumo-space-s)}[part=name]:empty{margin-right:0}[part=message]{white-space:pre-wrap}[part=time]{color:var(--lumo-secondary-text-color);font-size:var(--lumo-font-size-s)}::slotted([slot="avatar"]){--vaadin-avatar-outline-width: 0;--vaadin-avatar-size: var(--lumo-size-m);flex-shrink:0;margin-top:calc(var(--lumo-space-s));margin-inline-end:calc(var(--lumo-space-m))}::slotted(vaadin-markdown){white-space:normal}:host([focus-ring]){box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host([dir="rtl"]) [part=name]{margin-left:var(--lumo-space-s);margin-right:0}:host([dir="rtl"]) [part=name]:empty{margin-left:0}}:is(:root,:host):before{--vaadin-message-lumo-inject: 1;--vaadin-message-lumo-inject-modules: lumo_components_message}@media lumo_components_multi-select-combo-box-chip{:host{display:inline-flex;align-items:center;align-self:center;white-space:nowrap;box-sizing:border-box;font-size:var(--lumo-font-size-xxs);line-height:1;color:var(--lumo-body-text-color);border-radius:var(--lumo-border-radius-s);background-color:var(--lumo-contrast-20pct);cursor:var(--lumo-clickable-cursor);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}:host([hidden]),:host(:is([readonly],[disabled],[slot="overflow"])) [part=remove-button]{display:none!important}:host([disabled]){background-color:var(--lumo-contrast-10pct)}:host([focused]) [part=remove-button]{color:inherit}:host([slot="overflow"]){position:relative;min-width:var(--lumo-size-xxs);margin-inline-start:var(--lumo-space-s)}:host([slot="overflow"]):before,:host([slot="overflow"]):after{position:absolute;content:"";width:100%;height:100%;border-left:calc(var(--lumo-space-s) / 4) solid var(--lumo-contrast-30pct);border-radius:var(--lumo-border-radius-s)}:host([slot="overflow"]):before{left:calc(-1 * var(--lumo-space-s) / 2)}:host([slot="overflow"]):after{left:calc(-1 * var(--lumo-space-s))}:host([count="2"]){margin-inline-start:calc(var(--lumo-space-s) / 2)}:host([count="2"]):after{display:none}:host([count="1"]){margin-inline-start:0}:host([count="1"]):before,:host([count="1"]):after{display:none}[part=label]{font-weight:500;line-height:1.25;overflow:hidden;text-overflow:ellipsis}[part=remove-button]{display:flex;align-items:center;justify-content:center;margin-top:-.3125em;margin-bottom:-.3125em;margin-inline-start:auto;width:1.25em;height:1.25em;font-size:1.5em;transition:none}[part=remove-button]:before{content:var(--lumo-icons-cross)}:host([disabled]) [part=label]{color:var(--lumo-disabled-text-color);-webkit-text-fill-color:var(--lumo-disabled-text-color);pointer-events:none}@media (forced-colors: active){:host{outline:1px solid;outline-offset:-1px}}}@media lumo_components_multi-select-combo-box-container{#wrapper{display:flex;width:100%;min-width:0}:host([auto-expand-vertically]){padding-block:var(--lumo-space-xs)}:host([auto-expand-vertically]) #wrapper{flex-wrap:wrap}}@media lumo_components_multi-select-combo-box-item{@media (any-hover: hover){:host(:hover[readonly]){background-color:transparent;cursor:default}}}@media lumo_components_multi-select-combo-box-overlay{:host{--_vaadin-multi-select-combo-box-items-container-border-width: var(--lumo-space-xs);--_vaadin-multi-select-combo-box-items-container-border-style: solid}#overlay{width:var( --vaadin-multi-select-combo-box-overlay-width, var(--_vaadin-multi-select-combo-box-overlay-default-width, auto) )}}@media lumo_components_multi-select-combo-box{:host{max-width:100%;--input-min-width: var(--vaadin-multi-select-combo-box-input-min-width, 4em);--_chip-min-width: var(--vaadin-multi-select-combo-box-chip-min-width, 50px);--_wrapper-gap: 0}:host([opened]){pointer-events:auto}#chips{display:flex;align-items:center}::slotted(input){box-sizing:border-box;flex:1 0 var(--input-min-width)}::slotted([slot="chip"]),::slotted([slot="overflow"]){flex:0 1 auto}::slotted([slot="chip"]){overflow:hidden}:host(:is([readonly],[disabled])) ::slotted(input){flex-grow:0;flex-basis:0;padding:0}:host([auto-expand-vertically]) #chips{display:contents}:host([auto-expand-horizontally]) [class$=container]{width:auto}:host([has-value]){padding-inline-start:0}:host([has-value]) ::slotted(input:placeholder-shown){caret-color:var(--lumo-body-text-color)!important}[part=label]{flex-shrink:0}[part=input-field] ::slotted([slot="chip"]),[part=input-field] ::slotted([slot="overflow"]){min-height:auto;padding:.3125em calc(.5em + var(--lumo-border-radius-s) / 4);color:var(--lumo-body-text-color);-webkit-mask-image:none;mask-image:none}:host([auto-expand-vertically]) ::slotted([slot="chip"]){margin-block:calc(var(--lumo-space-xs) / 2)}::slotted([slot="chip"]:not([readonly]):not([disabled])){padding-inline-end:0}:host([auto-expand-vertically]) ::slotted([slot="input"]){min-height:calc(var(--lumo-text-field-size, var(--lumo-size-m)) - 2 * var(--lumo-space-xs))}::slotted([slot="chip"]:not(:last-of-type)),::slotted([slot="overflow"]:not(:last-of-type)){margin-inline-end:var(--lumo-space-xs)}::slotted([slot="chip"][focused]){background-color:var(--vaadin-selection-color, var(--lumo-primary-color));color:var(--lumo-primary-contrast-color)}[part=toggle-button]:before{content:var(--lumo-icons-dropdown)}:host([readonly][has-value]) [part=toggle-button]{color:var(--lumo-contrast-60pct);cursor:var(--lumo-clickable-cursor)}}:is(:root,:host):before{--vaadin-multi-select-combo-box-container-lumo-inject: 1;--vaadin-multi-select-combo-box-container-lumo-inject-modules: lumo_components_input-container, lumo_components_multi-select-combo-box-container;--vaadin-multi-select-combo-box-overlay-lumo-inject: 1;--vaadin-multi-select-combo-box-overlay-lumo-inject-modules: lumo_mixins_loader, lumo_mixins_combo-box-loader, lumo_mixins_overlay, lumo_mixins_menu-overlay-core, lumo_mixins_combo-box-overlay, lumo_components_multi-select-combo-box-overlay;--vaadin-multi-select-combo-box-chip-lumo-inject: 1;--vaadin-multi-select-combo-box-chip-lumo-inject-modules: lumo_mixins_field-button, lumo_components_multi-select-combo-box-chip;--vaadin-multi-select-combo-box-item-lumo-inject: 1;--vaadin-multi-select-combo-box-item-lumo-inject-modules: lumo_components_item, lumo_components_combo-box-item, lumo_components_multi-select-combo-box-item;--vaadin-multi-select-combo-box-lumo-inject: 1;--vaadin-multi-select-combo-box-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_multi-select-combo-box}@media lumo_components_notification-card{:host{display:block;position:relative;margin:var(--lumo-space-s)}[part=overlay]{pointer-events:auto;background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct));border-radius:var(--lumo-border-radius-l);box-shadow:0 0 0 1px var(--lumo-contrast-10pct),var(--lumo-box-shadow-l);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);font-weight:400;line-height:var(--lumo-line-height-s);letter-spacing:0;text-transform:none;-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}[part=content]{padding:var(--lumo-space-wide-l);display:flex;align-items:center;justify-content:space-between}[part=content] ::slotted(vaadin-button){flex:none;margin:0 calc(var(--lumo-space-s) * -1) 0 var(--lumo-space-m)}:host([slot^="middle"]){max-width:80vw;margin:var(--lumo-space-s) auto}:host([slot$="stretch"]){margin:0}:host([slot$="stretch"]) [part=overlay]{border-radius:0}@media (min-width: 421px){:host(:not([slot$="stretch"])){display:flex}:host([slot$="end"]){justify-content:flex-end}:host([slot^="middle"]),:host([slot$="center"]){display:flex;justify-content:center}}@keyframes lumo-notification-exit-fade-out{to{opacity:0}}@keyframes lumo-notification-enter-fade-in{0%{opacity:0}}@keyframes lumo-notification-enter-slide-down{0%{transform:translateY(-200%);opacity:0}}@keyframes lumo-notification-exit-slide-up{to{transform:translateY(-200%);opacity:0}}@keyframes lumo-notification-enter-slide-up{0%{transform:translateY(200%);opacity:0}}@keyframes lumo-notification-exit-slide-down{to{transform:translateY(200%);opacity:0}}:host([slot="middle"][opening]){animation:lumo-notification-enter-fade-in .3s}:host([slot="middle"][closing]){animation:lumo-notification-exit-fade-out .3s}:host([slot^="top"][opening]){animation:lumo-notification-enter-slide-down .3s}:host([slot^="top"][closing]){animation:lumo-notification-exit-slide-up .3s}:host([slot^="bottom"][opening]){animation:lumo-notification-enter-slide-up .3s}:host([slot^="bottom"][closing]){animation:lumo-notification-exit-slide-down .3s}:host([theme="success"]){--_focus-ring-gap-color: var(--lumo-success-color);--vaadin-focus-ring-color: var(--lumo-success-contrast-color)}:host([theme="warning"]){--_focus-ring-gap-color: var(--lumo-warning-color);--vaadin-focus-ring-color: var(--lumo-warning-contrast-color)}:host([theme="error"]){--_focus-ring-gap-color: var(--lumo-error-color);--vaadin-focus-ring-color: var(--lumo-error-contrast-color)}:host([theme="primary"]){--_focus-ring-gap-color: var(--lumo-primary-color);--vaadin-focus-ring-color: var(--lumo-primary-contrast-color)}:host([theme~="primary"]) [part=overlay]{background:var(--lumo-primary-color);color:var(--lumo-primary-contrast-color);box-shadow:var(--lumo-box-shadow-l)}:host([theme~="primary"]){--vaadin-button-background: var(--lumo-shade-20pct);--vaadin-button-text-color: var(--lumo-primary-contrast-color);--vaadin-button-primary-background: var(--lumo-primary-contrast-color);--vaadin-button-primary-text-color: var(--lumo-primary-text-color)}:host([theme~="contrast"]) [part=overlay]{background:var(--lumo-contrast);color:var(--lumo-base-color);box-shadow:var(--lumo-box-shadow-l)}:host([theme~="contrast"]){--vaadin-button-background: var(--lumo-contrast-20pct);--vaadin-button-text-color: var(--lumo-base-color);--vaadin-button-primary-background: var(--lumo-base-color);--vaadin-button-primary-text-color: var(--lumo-contrast)}:host([theme~="success"]) [part=overlay]{background:var(--lumo-success-color);color:var(--lumo-success-contrast-color);box-shadow:var(--lumo-box-shadow-l)}:host([theme~="success"]){--vaadin-button-background: var(--lumo-shade-20pct);--vaadin-button-text-color: var(--lumo-success-contrast-color);--vaadin-button-primary-background: var(--lumo-success-contrast-color);--vaadin-button-primary-text-color: var(--lumo-success-text-color)}:host([theme~="error"]) [part=overlay]{background:var(--lumo-error-color);color:var(--lumo-error-contrast-color);box-shadow:var(--lumo-box-shadow-l)}:host([theme~="error"]){--vaadin-button-background: var(--lumo-shade-20pct);--vaadin-button-text-color: var(--lumo-error-contrast-color);--vaadin-button-primary-background: var(--lumo-error-contrast-color);--vaadin-button-primary-text-color: var(--lumo-error-text-color)}:host([theme~="warning"]) [part=overlay]{background:var(--lumo-warning-color);color:var(--lumo-warning-contrast-color);box-shadow:inset 0 0 0 1px var(--lumo-contrast-20pct),var(--lumo-box-shadow-l)}:host([theme~="warning"]){--vaadin-button-background: var(--lumo-shade-20pct);--vaadin-button-text-color: var(--lumo-warning-contrast-color);--vaadin-button-primary-background: var(--lumo-shade-50pct);--vaadin-button-primary-text-color: var(--lumo-primary-contrast-color)}@media (forced-colors: active){[part=overlay]{outline:3px solid}}}@media lumo_components_notification-container{:host{position:fixed;inset:0;box-sizing:border-box;display:flex;flex-direction:column;align-items:stretch;pointer-events:none;width:auto;height:auto;border:none;padding:0;background-color:transparent;overflow:visible}[region-group]{flex:1 1 0%;display:flex}[region-group=top]{align-items:flex-start}[region-group=bottom]{align-items:flex-end}[region-group]>[region]{flex:1 1 0%}@media (max-width: 420px){[region-group]{flex-direction:column;align-items:stretch}[region-group=top]{justify-content:flex-start}[region-group=bottom]{justify-content:flex-end}[region-group]>[region]{flex:initial}}}:is(:root,:host):before{--vaadin-notification-container-lumo-inject: 1;--vaadin-notification-container-lumo-inject-modules: lumo_components_notification-container;--vaadin-notification-card-lumo-inject: 1;--vaadin-notification-card-lumo-inject-modules: lumo_components_notification-card}:is(:root,:host):before{--vaadin-number-field-lumo-inject: 1;--vaadin-number-field-lumo-inject-modules: lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-button, lumo_mixins_field-helper, lumo_mixins_field-base, lumo_components_number-field}:is(:root,:host):before{--vaadin-overlay-lumo-inject: 1;--vaadin-overlay-lumo-inject-modules: lumo_mixins_overlay}@media lumo_components_popover-overlay{:host{--vaadin-popover-arrow-size: .5rem;--_default-offset: var(--lumo-space-xs)}[part=overlay]{position:relative;overflow:visible;max-height:100%;outline:none}[part=content]{overflow:auto;box-sizing:border-box;max-height:100%;padding:var(--lumo-space-xs) var(--lumo-space-s)}[part=overlay]:before{position:absolute;content:"";inset-block:calc(var(--vaadin-popover-offset-top, var(--_default-offset)) * -1) calc(var(--vaadin-popover-offset-bottom, var(--_default-offset)) * -1);inset-inline:calc(var(--vaadin-popover-offset-start, var(--_default-offset)) * -1) calc(var(--vaadin-popover-offset-end, var(--_default-offset)) * -1);z-index:-1;pointer-events:auto}:host([theme~="no-padding"]) [part=content]{padding:0!important}[part=arrow]{display:none;position:absolute;height:0;width:0}:host([theme~="arrow"]){--_default-offset: calc(var(--lumo-space-s) + var(--vaadin-popover-arrow-size) / 2)}:host([theme~="arrow"]) [part=arrow]{display:block}:host([modeless][with-backdrop]) [part=backdrop]{pointer-events:none}:host([position^="top"][top-aligned]) [part=overlay],:host([position^="bottom"][top-aligned]) [part=overlay]{margin-top:var(--vaadin-popover-offset-top, var(--_default-offset))}:host([position^="top"][bottom-aligned]) [part=overlay],:host([position^="bottom"][bottom-aligned]) [part=overlay]{margin-bottom:var(--vaadin-popover-offset-bottom, var(--_default-offset))}:host([position^="start"][start-aligned]) [part=overlay],:host([position^="end"][start-aligned]) [part=overlay]{margin-inline-start:var(--vaadin-popover-offset-start, var(--_default-offset))}:host([position^="start"][end-aligned]) [part=overlay],:host([position^="end"][end-aligned]) [part=overlay]{margin-inline-end:var(--vaadin-popover-offset-end, var(--_default-offset))}:host([theme~="arrow"][position^="top"]) [part=arrow],:host([theme~="arrow"][position^="bottom"]) [part=arrow]{border-left:var(--vaadin-popover-arrow-size) solid transparent;border-right:var(--vaadin-popover-arrow-size) solid transparent}:host([theme~="arrow"][position^="bottom"][bottom-aligned]) [part=arrow],:host([theme~="arrow"][position^="top"][bottom-aligned]) [part=arrow]{bottom:calc(var(--vaadin-popover-arrow-size) * -1);border-top:var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);filter:drop-shadow(0 2px 1px var(--lumo-shade-10pct))}:host([theme~="arrow"][position^="bottom"][top-aligned]) [part=arrow],:host([theme~="arrow"][position^="top"][top-aligned]) [part=arrow]{top:calc(var(--vaadin-popover-arrow-size) * -1);border-bottom:var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);filter:drop-shadow(0 -2px 1px var(--lumo-shade-10pct))}:host([theme~="arrow"][position^="bottom"][start-aligned]) [part=arrow],:host([theme~="arrow"][position^="top"][start-aligned]) [part=arrow]{transform:translate(-50%);inset-inline-start:1.5rem}:host([theme~="arrow"][position^="bottom"][end-aligned]) [part=arrow],:host([theme~="arrow"][position^="top"][end-aligned]) [part=arrow]{transform:translate(50%);inset-inline-end:1.5rem}:host([theme~="arrow"][position^="bottom"][arrow-centered]) [part=arrow],:host([theme~="arrow"][position^="top"][arrow-centered]) [part=arrow]{transform:translate(-50%);inset-inline-start:50%}:host([theme~="arrow"][position^="start"]) [part=arrow],:host([theme~="arrow"][position^="end"]) [part=arrow]{border-top:var(--vaadin-popover-arrow-size) solid transparent;border-bottom:var(--vaadin-popover-arrow-size) solid transparent}:host([theme~="arrow"][position^="start"][start-aligned]) [part=arrow],:host([theme~="arrow"][position^="end"][start-aligned]) [part=arrow]{inset-inline-start:calc(var(--vaadin-popover-arrow-size) * -1);border-right:var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);filter:drop-shadow(-2px 0 1px var(--lumo-shade-10pct))}:host([theme~="arrow"][position^="start"][end-aligned]) [part=arrow],:host([theme~="arrow"][position^="end"][end-aligned]) [part=arrow]{inset-inline-end:calc(var(--vaadin-popover-arrow-size) * -1);border-left:var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);filter:drop-shadow(2px 0 1px var(--lumo-shade-10pct))}:host([theme~="arrow"][position^="start"][top-aligned]) [part=arrow],:host([theme~="arrow"][position^="end"][top-aligned]) [part=arrow]{top:.5rem}:host([theme~="arrow"][position="start"][top-aligned]) [part=arrow],:host([theme~="arrow"][position="end"][top-aligned]) [part=arrow]{top:50%;transform:translateY(-50%)}:host([theme~="arrow"][position^="start"][bottom-aligned]) [part=arrow],:host([theme~="arrow"][position^="end"][bottom-aligned]) [part=arrow]{bottom:.5rem}}:is(:root,:host):before{--vaadin-popover-overlay-lumo-inject: 1;--vaadin-popover-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_popover-overlay}@media lumo_components_progress-bar{:host{display:block;width:100%;height:calc(var(--lumo-size-l) / 10);margin:var(--lumo-space-s) 0}:host([hidden]){display:none!important}[part=bar]{height:100%;border-radius:var(--lumo-border-radius-m);background-color:var(--lumo-contrast-10pct)}[part=value]{height:100%;transform-origin:0 50%;border-radius:var(--lumo-border-radius-m);background-color:var(--lumo-primary-color);transform:none;width:calc(var(--vaadin-progress-value) * 100%);will-change:width;transition:.1s width linear}:host([dir="rtl"]) [part=value]{transform-origin:100% 50%}@media (forced-colors: active){[part=bar]{outline:1px solid}[part=value]{background-color:AccentColor!important;forced-color-adjust:none}}:host([indeterminate]) [part=value]{--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to right, var(--lumo-primary-color-10pct) 10%, var(--lumo-primary-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to left, var(--lumo-primary-color-10pct) 10%, var(--lumo-primary-color) );width:100%;background-color:transparent!important;background-image:var(--lumo-progress-indeterminate-progress-bar-background);opacity:.75;will-change:transform;animation:vaadin-progress-indeterminate 1.6s infinite cubic-bezier(.645,.045,.355,1)}@keyframes vaadin-progress-indeterminate{0%{transform:scaleX(.015);transform-origin:0% 0%}25%{transform:scaleX(.4)}50%{transform:scaleX(.015);transform-origin:100% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background)}50.1%{transform:scaleX(.015);transform-origin:100% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background-reverse)}75%{transform:scaleX(.4)}to{transform:scaleX(.015);transform-origin:0% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background-reverse)}}:host(:not([aria-valuenow])) [part=value]:before,:host([indeterminate]) [part=value]:before{content:"";display:block;width:100%;height:100%;border-radius:inherit;background-color:var(--lumo-primary-color);will-change:opacity;animation:vaadin-progress-pulse3 1.6s infinite cubic-bezier(.645,.045,.355,1)}@keyframes vaadin-progress-pulse3{0%{opacity:1}10%{opacity:0}40%{opacity:0}50%{opacity:1}50.1%{opacity:1}60%{opacity:0}90%{opacity:0}to{opacity:1}}:host([theme~="contrast"]) [part=value],:host([theme~="contrast"]) [part=value]:before{background-color:var(--lumo-contrast-80pct);--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to right, var(--lumo-contrast-5pct) 10%, var(--lumo-contrast-80pct) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to left, var(--lumo-contrast-5pct) 10%, var(--lumo-contrast-60pct) )}:host([theme~="error"]) [part=value],:host([theme~="error"]) [part=value]:before{background-color:var(--lumo-error-color);--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to right, var(--lumo-error-color-10pct) 10%, var(--lumo-error-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to left, var(--lumo-error-color-10pct) 10%, var(--lumo-error-color) )}:host([theme~="success"]) [part=value],:host([theme~="success"]) [part=value]:before{background-color:var(--lumo-success-color);--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to right, var(--lumo-success-color-10pct) 10%, var(--lumo-success-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to left, var(--lumo-success-color-10pct) 10%, var(--lumo-success-color) )}:host([indeterminate][dir="rtl"]) [part=value]{--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to left, var(--lumo-primary-color-10pct) 10%, var(--lumo-primary-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to right, var(--lumo-primary-color-10pct) 10%, var(--lumo-primary-color) );animation:vaadin-progress-indeterminate-rtl 1.6s infinite cubic-bezier(.355,.045,.645,1)}:host(:not([aria-valuenow])[dir="rtl"]) [part=value]:before,:host([indeterminate][dir="rtl"]) [part=value]:before{animation:vaadin-progress-pulse3 1.6s infinite cubic-bezier(.355,.045,.645,1)}@keyframes vaadin-progress-indeterminate-rtl{0%{transform:scaleX(.015);transform-origin:100% 0%}25%{transform:scaleX(.4)}50%{transform:scaleX(.015);transform-origin:0% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background)}50.1%{transform:scaleX(.015);transform-origin:0% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background-reverse)}75%{transform:scaleX(.4)}to{transform:scaleX(.015);transform-origin:100% 0%;background-image:var(--lumo-progress-indeterminate-progress-bar-background-reverse)}}:host([theme~="contrast"][dir="rtl"]) [part=value],:host([theme~="contrast"][dir="rtl"]) [part=value]:before{--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to left, var(--lumo-contrast-5pct) 10%, var(--lumo-contrast-80pct) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to right, var(--lumo-contrast-5pct) 10%, var(--lumo-contrast-60pct) )}:host([theme~="error"][dir="rtl"]) [part=value],:host([theme~="error"][dir="rtl"]) [part=value]:before{--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to left, var(--lumo-error-color-10pct) 10%, var(--lumo-error-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to right, var(--lumo-error-color-10pct) 10%, var(--lumo-error-color) )}:host([theme~="success"][dir="rtl"]) [part=value],:host([theme~="success"][dir="rtl"]) [part=value]:before{--lumo-progress-indeterminate-progress-bar-background: linear-gradient( to left, var(--lumo-success-color-10pct) 10%, var(--lumo-success-color) );--lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient( to right, var(--lumo-success-color-10pct) 10%, var(--lumo-success-color) )}}:is(:root,:host):before{--vaadin-progress-bar-lumo-inject: 1;--vaadin-progress-bar-lumo-inject-modules: lumo_components_progress-bar}@media lumo_components_radio-button{:host{color:var(--vaadin-radio-button-label-color, var(--lumo-body-text-color));font-size:var(--vaadin-radio-button-label-font-size, var(--lumo-font-size-m));font-family:var(--lumo-font-family);line-height:var(--lumo-line-height-s);-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-tap-highlight-color:transparent;-webkit-user-select:none;user-select:none;cursor:default;outline:none;--_radio-button-size: var(--vaadin-radio-button-size, calc(var(--lumo-size-m) / 2));--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color))}:host([has-label]) ::slotted(label){padding:var( --vaadin-radio-button-label-padding, var(--lumo-space-xs) var(--lumo-space-s) var(--lumo-space-xs) var(--lumo-space-xs) )}[part=radio]{--_input-size: var(--_radio-button-size);margin:var(--lumo-space-xs);position:relative;border-radius:50%;background:var(--vaadin-radio-button-background, var(--lumo-contrast-20pct));transition:transform .2s cubic-bezier(.12,.32,.54,2),background-color .15s;will-change:transform;cursor:var(--lumo-clickable-cursor);--_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct))}[part=radio]:before{pointer-events:none;color:transparent;width:100%;height:100%;border-radius:inherit;background-color:inherit;transform:scale(1.4);opacity:0;transition:transform .1s,opacity .8s;will-change:transform,opacity}[part=radio]:after{content:"";pointer-events:none;width:0;height:0;border:var(--vaadin-radio-button-dot-size, 3px) solid var(--vaadin-radio-button-dot-color, var(--lumo-primary-contrast-color));border-radius:50%;position:absolute;top:50%;left:50%;transform:translate(-50%,-50%) scale(0);transition:.25s transform;will-change:transform;background-clip:content-box}:host([checked]){--vaadin-input-field-border-color: transparent}:host([checked]) [part=radio]{background-color:var(--_selection-color)}:host([checked]) [part=radio]:after{transform:translate(-50%,-50%) scale(1)}:host(:not([checked]):not([disabled]):hover) [part=radio]{background:var(--vaadin-radio-button-background-hover, var(--lumo-contrast-30pct))}:host([active]) [part=radio]{transform:scale(.9);transition-duration:.05s}:host([active][checked]) [part=radio]{transform:scale(1.1)}:host([active]:not([checked])) [part=radio]:before{transition-duration:.01s,.01s;transform:scale(0);opacity:.4}:host([focus-ring]) [part=radio]{box-shadow:0 0 0 1px var(--lumo-base-color),0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color),inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color)}:host([disabled]){pointer-events:none;color:var(--lumo-disabled-text-color);--vaadin-input-field-border-color: var(--lumo-contrast-20pct)}:host([disabled]) ::slotted(label){color:inherit}:host([disabled]) [part=radio]{background-color:var(--vaadin-radio-button-disabled-background, var(--lumo-contrast-10pct))}:host([disabled]) [part=radio]:after{border-color:var(--vaadin-radio-button-disabled-dot-color, var(--lumo-contrast-30pct))}:host([dir="rtl"][has-label]) ::slotted(label){padding:var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-s)}@media (forced-colors: active){[part=radio]{outline:1px solid;outline-offset:-1px}:host([focused]) [part=radio]{outline-width:2px}:host([disabled]) [part=radio]{outline-color:GrayText}}}:is(:root,:host):before{--vaadin-radio-button-lumo-inject: 1;--vaadin-radio-button-lumo-inject-modules: lumo_mixins_checkable-field, lumo_components_radio-button}@media lumo_components_radio-group{:host(:hover:not([readonly]):not([focused])) [part=label],:host(:hover:not([readonly])) [part=helper-text]{color:var(--lumo-body-text-color)}@media (pointer: coarse){:host(:hover:not([readonly]):not([focused])) [part=label]{color:var(--lumo-secondary-text-color)}}}:is(:root,:host):before{--vaadin-radio-group-lumo-inject: 1;--vaadin-radio-group-lumo-inject-modules: lumo_mixins_group-field, lumo_mixins_field-label, lumo_mixins_field-required, lumo_mixins_field-error-message, lumo_mixins_field-helper, lumo_components_radio-group}@media lumo_components_rich-text-editor-popup-overlay{[part=overlay]{margin:var(--lumo-space-xs) 0}[part=content]{padding:var(--lumo-space-xs);max-width:calc(7 * (var(--_button-size) + var(--_button-margin) * 2));display:flex;flex-wrap:wrap;justify-content:center;--_button-size: 1.25rem;--_button-margin: 3px}[part=content] ::slotted(button){border:none;width:var(--_button-size);height:var(--_button-size);margin:var(--_button-margin)}}@media lumo_components_rich-text-editor{:host{display:flex;flex-direction:column;box-sizing:border-box;min-height:calc(var(--lumo-size-m) * 8);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_item-indent: var(--lumo-space-m);--_marker-indent: var(--lumo-space-xs);--_list-indent: calc(var(--_item-indent) + var(--_marker-indent))}:host([hidden]){display:none!important}.announcer{position:fixed;clip:rect(0,0,0,0)}input[type=file]{display:none}.vaadin-rich-text-editor-container{display:flex;flex-direction:column;min-height:inherit;max-height:inherit;flex:auto}[part=content]{box-sizing:border-box;position:relative;flex:auto;display:flex;flex-direction:column;overflow:hidden;background-color:var(--lumo-base-color)}[part=toolbar]{display:flex;flex-wrap:wrap;flex-shrink:0;background-color:var(--lumo-contrast-5pct);padding:calc(var(--lumo-space-s) - 1px) var(--lumo-space-xs)}[part~=toolbar-button]{padding:0;font:inherit;line-height:1;text-transform:none;background:transparent;border:none;position:relative;width:var(--lumo-size-m);height:var(--lumo-size-m);border-radius:var(--lumo-border-radius-m);color:var(--lumo-contrast-60pct);margin:2px 1px;cursor:var(--lumo-clickable-cursor);transition:background-color .1s,color .1s}[part~=toolbar-button]:not([part~=toolbar-button-pressed]):hover{outline:none;background-color:var(--lumo-contrast-5pct);color:var(--lumo-contrast-80pct)}@media (forced-colors: active){[part~=toolbar-button]:focus,[part~=toolbar-button]:hover{outline:1px solid!important}[part~=toolbar-button-pressed]{outline:2px solid;outline-offset:-1px}}[part~=toolbar-button]:before{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);font-family:"lumo-icons",var(--lumo-font-family);font-size:var(--lumo-icon-size-m)}[part~=toolbar-group]{display:flex;margin:0 .5em;margin:0 calc(var(--lumo-space-l) / 2 - 1px)}[part~=toolbar-button-bold]:before{content:"B";font-weight:700}[part~=toolbar-button-italic]:before{content:"I";font-style:italic}[part~=toolbar-button-underline]:before{content:"U";text-decoration:underline}[part~=toolbar-button-strike]:before{content:"T";text-decoration:line-through}[part~=toolbar-button-h1]:before{content:"H1";font-size:1.25em;font-size:var(--lumo-font-size-m)}[part~=toolbar-button-h2]:before{content:"H2";font-size:1em;font-size:var(--lumo-font-size-s)}[part~=toolbar-button-h3]:before{content:"H3";font-size:.875em;font-size:var(--lumo-font-size-xs)}[part~=toolbar-button-h1]:before,[part~=toolbar-button-h2]:before,[part~=toolbar-button-h3]:before{letter-spacing:-.05em;font-weight:600}[part~=toolbar-button-subscript]:before,[part~=toolbar-button-superscript]:before{content:"X";font-weight:600;font-size:var(--lumo-font-size-s)}[part~=toolbar-button-subscript]:after,[part~=toolbar-button-superscript]:after{content:"2";position:absolute;top:50%;left:70%;font-size:.625em;font-weight:700}[part~=toolbar-button-superscript]:after{top:20%}[part~=toolbar-button-blockquote]:before{content:"”";height:.6em;font-size:var(--lumo-font-size-xxl)}[part~=toolbar-button-code-block]:before{content:var(--lumo-icons-angle-left) var(--lumo-icons-angle-right);font-size:var(--lumo-font-size-l);letter-spacing:-.5em;margin-left:-.25em;font-weight:600}[part~=toolbar-button-background]:before,[part~=toolbar-button-color]:before{content:"A";font-size:1em}[part~=toolbar-button-color]:after{content:"";position:absolute;bottom:4px;left:25%;right:25%;width:50%;height:4px;background-color:var(--_color-value, currentColor)}[part~=toolbar-button-background]:before{z-index:1;background-color:var(--lumo-base-color);background-image:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}[part~=toolbar-button-background]:after{content:"";position:absolute;inset:20%;background:repeating-linear-gradient(135deg,var(--_background-value, currentColor),var(--_background-value, currentColor) 1px,transparent 1px,transparent 2px)}:host([readonly]) [part=toolbar]{display:none}:host([disabled]){pointer-events:none;opacity:.5;-webkit-user-select:none;user-select:none}:host([disabled]) [part~=toolbar-button]{background-color:transparent}[part~=toolbar-button]:focus,[part~=toolbar-button][aria-expanded=true]{outline:none;box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}@media (hover: none){[part~=toolbar-button]:hover{background-color:transparent}}[part~=toolbar-button-pressed]{background-color:var(--vaadin-selection-color, var(--lumo-primary-color));color:var(--lumo-primary-contrast-color)}[part~=toolbar-button]:not([part~=toolbar-button-pressed]):active{background-color:var(--lumo-contrast-10pct);color:var(--lumo-contrast-90pct)}[part~=toolbar-button-undo]:before{content:var(--lumo-icons-undo)}[part~=toolbar-button-redo]:before{content:var(--lumo-icons-redo)}[part~=toolbar-button-bold]:before,[part~=toolbar-button-background]:before,[part~=toolbar-button-color]:before,[part~=toolbar-button-italic]:before,[part~=toolbar-button-underline]:before,[part~=toolbar-button-strike]:before{font-size:var(--lumo-font-size-m);font-weight:600}[part~=toolbar-button-background]:hover:before{background-image:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct)),linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct))}[part~=toolbar-button-background]:active:before{background-image:linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct)),linear-gradient(var(--lumo-contrast-10pct),var(--lumo-contrast-10pct))}[part~=toolbar-button-list-ordered]:before{content:var(--lumo-icons-ordered-list)}[part~=toolbar-button-list-bullet]:before{content:var(--lumo-icons-unordered-list)}[part~=toolbar-button-outdent]:before{content:var(--lumo-icons-outdent)}[part~=toolbar-button-indent]:before{content:var(--lumo-icons-indent)}[part~=toolbar-button-align-left]:before{content:var(--lumo-icons-align-left)}[part~=toolbar-button-align-center]:before{content:var(--lumo-icons-align-center)}[part~=toolbar-button-align-right]:before{content:var(--lumo-icons-align-right)}[part~=toolbar-button-image]:before{content:var(--lumo-icons-photo)}[part~=toolbar-button-link]:before{content:var(--lumo-icons-link)}[part~=toolbar-button-clean]:before{content:var(--lumo-icons-clean);font-size:var(--lumo-font-size-l)}[part=content]>.ql-editor{padding:0 var(--lumo-space-m);line-height:inherit}:host(:not([theme~="no-border"])){border:1px solid var(--lumo-contrast-20pct)}:host(:not([theme~="no-border"]):not([readonly])) [part=content]{border-top:1px solid var(--lumo-contrast-20pct)}:host([theme~="no-border"]) [part=toolbar]{padding-top:var(--lumo-space-s);padding-bottom:var(--lumo-space-s)}:host([theme~="compact"]){min-height:calc(var(--lumo-size-m) * 6)}:host([theme~="compact"]) [part=toolbar]{padding:var(--lumo-space-xs) 0}:host([theme~="compact"][theme~="no-border"]) [part=toolbar]{padding:calc(var(--lumo-space-xs) + 1px) 0}:host([theme~="compact"]) [part~=toolbar-button]{width:var(--lumo-size-s);height:var(--lumo-size-s)}:host([theme~="compact"]) [part~=toolbar-group]{margin:0 calc(var(--lumo-space-m) / 2 - 1px)}.ql-clipboard{left:-100000px;height:1px;overflow-y:hidden;position:absolute;top:50%}.ql-clipboard p{margin:0;padding:0}.ql-editor{box-sizing:border-box;line-height:1.42;height:100%;outline:none;overflow-y:auto;padding:.75em 1em;tab-size:calc(var(--_item-indent) * 2);text-align:left;white-space:pre-wrap;word-wrap:break-word;flex:1}.ql-editor>*{cursor:text}.ql-align-left{text-align:left}.ql-direction-rtl{direction:rtl;text-align:inherit}.ql-align-center{text-align:center}.ql-align-justify{text-align:justify}.ql-align-right{text-align:right}.ql-code-block-container{font-family:monospace;background-color:var(--lumo-contrast-10pct);border-radius:var(--lumo-border-radius-m);white-space:pre-wrap;margin-bottom:.3125em;margin-top:.3125em;padding:.3125em .625em}.ql-editor ol{padding-inline-start:var(--_list-indent)}.ql-editor li{list-style-type:none;position:relative;padding-inline-start:var(--_item-indent)}.ql-editor li>.ql-ui:before{display:inline-block;width:var(--vaadin-padding-l);margin-inline:calc(var(--_item-indent) * -1) var(--_marker-indent);text-align:end;white-space:nowrap}.ql-editor li[data-list=bullet]>.ql-ui:before{content:"•";font-size:1.5rem;line-height:1rem;align-self:baseline;vertical-align:text-top}.ql-editor p,.ql-editor h1,.ql-editor h2,.ql-editor h3,.ql-editor h4,.ql-editor h5,.ql-editor h6{counter-set:list-0 list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered]{counter-increment:list-0}.ql-editor li[data-list=ordered]>.ql-ui:before{content:counter(list-0,decimal) ". "}.ql-editor li[data-list=ordered].ql-indent-1{counter-increment:list-1}.ql-editor li[data-list=ordered].ql-indent-1>.ql-ui:before{content:counter(list-1,lower-alpha) ". "}.ql-editor li[data-list].ql-indent-1{counter-set:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-2{counter-increment:list-2}.ql-editor li[data-list=ordered].ql-indent-2>.ql-ui:before{content:counter(list-2,lower-roman) ". "}.ql-editor li[data-list].ql-indent-2{counter-set:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-3{counter-increment:list-3}.ql-editor li[data-list=ordered].ql-indent-3>.ql-ui:before{content:counter(list-3,decimal) ". "}.ql-editor li[data-list].ql-indent-3{counter-set:list-4 list-5 list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-4{counter-increment:list-4}.ql-editor li[data-list=ordered].ql-indent-4>.ql-ui:before{content:counter(list-4,lower-alpha) ". "}.ql-editor li[data-list].ql-indent-4{counter-set:list-5 list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-5{counter-increment:list-5}.ql-editor li[data-list=ordered].ql-indent-5>.ql-ui:before{content:counter(list-5,lower-roman) ". "}.ql-editor li[data-list].ql-indent-5{counter-set:list-6 list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-6{counter-increment:list-6}.ql-editor li[data-list=ordered].ql-indent-6>.ql-ui:before{content:counter(list-6,decimal) ". "}.ql-editor li[data-list].ql-indent-6{counter-set:list-7 list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-7{counter-increment:list-7}.ql-editor li[data-list=ordered].ql-indent-7>.ql-ui:before{content:counter(list-7,lower-alpha) ". "}.ql-editor li[data-list].ql-indent-7{counter-set:list-8 list-9}.ql-editor li[data-list=ordered].ql-indent-8{counter-increment:list-8}.ql-editor li[data-list=ordered].ql-indent-8>.ql-ui:before{content:counter(list-8,lower-roman) ". "}.ql-editor li[data-list].ql-indent-8{counter-set:list-9}.ql-editor .ql-indent-1{padding-inline-start:calc(var(--_item-indent) * 2)}.ql-editor li.ql-indent-1{padding-inline-start:calc(var(--_list-indent) + var(--_item-indent) * 2)}.ql-editor .ql-indent-2{padding-inline-start:calc(var(--_item-indent) * 4)}.ql-editor li.ql-indent-2{padding-inline-start:calc(var(--_list-indent) * 2 + var(--_item-indent) * 3)}.ql-editor .ql-indent-3{padding-inline-start:calc(var(--_item-indent) * 6)}.ql-editor li.ql-indent-3{padding-inline-start:calc(var(--_list-indent) * 3 + var(--_item-indent) * 4)}.ql-editor .ql-indent-4{padding-inline-start:calc(var(--_item-indent) * 8)}.ql-editor li.ql-indent-4{padding-inline-start:calc(var(--_list-indent) * 4 + var(--_item-indent) * 5)}.ql-editor .ql-indent-5{padding-inline-start:calc(var(--_item-indent) * 10)}.ql-editor li.ql-indent-5{padding-inline-start:calc(var(--_list-indent) * 5 + var(--_item-indent) * 6)}.ql-editor .ql-indent-6{padding-inline-start:calc(var(--_item-indent) * 12)}.ql-editor li.ql-indent-6{padding-inline-start:calc(var(--_list-indent) * 6 + var(--_item-indent) * 7)}.ql-editor .ql-indent-7{padding-inline-start:calc(var(--_item-indent) * 14)}.ql-editor li.ql-indent-7{padding-inline-start:calc(var(--_list-indent) * 7 + var(--_item-indent) * 8)}.ql-editor .ql-indent-8{padding-inline-start:calc(var(--_item-indent) * 16)}.ql-editor li.ql-indent-8{padding-inline-start:calc(var(--_list-indent) * 8 + var(--_item-indent) * 9)}blockquote{padding-left:1em}code{background-color:var(--lumo-contrast-10pct);font-size:85%;padding:.125em .25em}img{max-width:100%}:where(h1,h2,h3,h4,h5,h6){margin-top:1.25em}:where(h1){margin-bottom:.75em}:where(h2,h3,h4){margin-bottom:.5em}:where(h5){margin-bottom:.25em}:host([dir="rtl"]) .ql-editor{direction:rtl;text-align:right}:host([dir="rtl"]) [part~=toolbar-button-redo]:before{content:var(--lumo-icons-undo)}:host([dir="rtl"]) [part~=toolbar-button-undo]:before{content:var(--lumo-icons-redo)}}@media lumo_global_typography{/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */:where(body,:host){font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);-webkit-text-size-adjust:100%;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}small,[theme~=font-size-s]{font-size:var(--lumo-font-size-s);line-height:var(--lumo-line-height-s)}[theme~=font-size-xs]{font-size:var(--lumo-font-size-xs);line-height:var(--lumo-line-height-xs)}:where(h1,h2,h3,h4,h5,h6){font-weight:600;line-height:var(--lumo-line-height-xs);color:var(--lumo-header-text-color);margin-block:0}:where(h1){font-size:var(--lumo-font-size-xxxl)}:where(h2){font-size:var(--lumo-font-size-xxl)}:where(h3){font-size:var(--lumo-font-size-xl)}:where(h4){font-size:var(--lumo-font-size-l)}:where(h5){font-size:var(--lumo-font-size-m)}:where(h6){font-size:var(--lumo-font-size-xs);text-transform:uppercase;letter-spacing:.03em}p,blockquote{margin-top:.5em;margin-bottom:.75em}a{text-decoration:none}a:where(:any-link){color:var(--lumo-primary-text-color)}a:where(:any-link):hover{text-decoration:underline}a:not(:any-link){color:var(--lumo-disabled-text-color)}hr{display:block;align-self:stretch;height:1px;border:0;padding:0;margin:var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);background-color:var(--lumo-contrast-10pct)}b,strong{font-weight:600}code,pre{border-radius:var(--lumo-border-radius-m)}pre code{background:transparent}blockquote{border-left:2px solid var(--lumo-contrast-30pct);color:var(--lumo-secondary-text-color)}blockquote[dir=rtl]{border-left:none;border-right:2px solid var(--lumo-contrast-30pct)}}@media lumo_components_tooltip-overlay{:host{--_vaadin-tooltip-default-offset: var(--lumo-space-xs)}[part=overlay]{max-width:40ch;background:var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct),var(--lumo-contrast-5pct));color:var(--lumo-body-text-color);font-size:var(--lumo-font-size-xs);line-height:var(--lumo-line-height-s)}[part=content]{white-space:pre-wrap;padding:var(--lumo-space-xs) var(--lumo-space-s)}:host([position^="top"][top-aligned]) [part=overlay],:host([position^="bottom"][top-aligned]) [part=overlay]{margin-top:var(--vaadin-tooltip-offset-top, var(--_vaadin-tooltip-default-offset))}:host([position^="top"][bottom-aligned]) [part=overlay],:host([position^="bottom"][bottom-aligned]) [part=overlay]{margin-bottom:var(--vaadin-tooltip-offset-bottom, var(--_vaadin-tooltip-default-offset))}:host([position^="start"][start-aligned]) [part=overlay],:host([position^="end"][start-aligned]) [part=overlay]{margin-inline-start:var(--vaadin-tooltip-offset-start, var(--_vaadin-tooltip-default-offset))}:host([position^="start"][end-aligned]) [part=overlay],:host([position^="end"][end-aligned]) [part=overlay]{margin-inline-end:var(--vaadin-tooltip-offset-end, var(--_vaadin-tooltip-default-offset))}@media (forced-colors: active){[part=overlay]{outline:1px dashed}}}:is(:root,:host):before{--vaadin-tooltip-overlay-lumo-inject: 1;--vaadin-tooltip-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_tooltip-overlay}:is(:root,:host):before{--vaadin-rich-text-editor-lumo-inject: 1;--vaadin-rich-text-editor-lumo-inject-modules: lumo_global_typography, lumo_components_rich-text-editor;--vaadin-rich-text-editor-popup-overlay-lumo-inject: 1;--vaadin-rich-text-editor-popup-overlay-lumo-inject-modules: lumo_mixins_overlay, lumo_components_rich-text-editor-popup-overlay}@media lumo_components_scroller{:host{outline:none;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([focus-ring]){box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}:host([theme~="overflow-indicators"]):before,:host([theme~="overflow-indicators"]):after{content:"";display:none;position:sticky;inset:0;z-index:9999;height:1px;margin-bottom:-1px;background:var(--lumo-contrast-10pct)}:host([theme~="overflow-indicators"]):after{margin-bottom:0;margin-top:-1px}:host([theme~="overflow-indicators"][overflow~="top"]):before,:host([theme~="overflow-indicators"][overflow~="bottom"]):after{display:block}}:is(:root,:host):before{--vaadin-scroller-lumo-inject: 1;--vaadin-scroller-lumo-inject-modules: lumo_components_scroller}@media lumo_components_side-nav{:host{display:block;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);font-weight:500;line-height:var(--lumo-line-height-xs);color:var(--lumo-body-text-color);-webkit-tap-highlight-color:transparent;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([hidden]){display:none!important}button{display:flex;align-items:center;justify-content:inherit;width:100%;margin:0;padding:0;background-color:initial;color:inherit;border:initial;outline:none;font:inherit;text-align:inherit}[part=children]{padding:0;margin:0;list-style-type:none}[part=label]{display:flex;align-items:center;width:100%;outline:none;box-sizing:border-box;border-radius:var(--lumo-border-radius-m);font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-s);font-weight:500;line-height:var(--lumo-line-height-xs)}[part=label] ::slotted([slot="label"]){color:var(--lumo-secondary-text-color);margin:var(--lumo-space-s)}:host([focus-ring]) [part=label]{box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part=toggle-button]{display:inline-flex;align-items:center;justify-content:center;width:var(--lumo-size-s);height:var(--lumo-size-s);margin-inline:auto var(--lumo-space-xs);font-size:var(--lumo-icon-size-m);line-height:1;color:var(--lumo-contrast-60pct);font-family:lumo-icons;cursor:var(--lumo-clickable-cursor)}[part=toggle-button]:before{content:var(--lumo-icons-angle-right);transition:transform .14s}:host(:not([collapsible])) [part=toggle-button]{display:none!important}:host(:not([collapsed])) [part=toggle-button]:before{transform:rotate(90deg)}:host([collapsed][dir="rtl"]) [part=toggle-button]:before{transform:rotate(180deg)}@media (any-hover: hover){[part=label]:hover [part=toggle-button]{color:var(--lumo-body-text-color)}}}@media lumo_components_side-nav-item{:host{display:block;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}:host([hidden]),[hidden]{display:none!important}:host([disabled]){pointer-events:none}[part=content]{display:flex;align-items:center}[part=link]{flex:auto;min-width:0;display:flex;align-items:center;text-decoration:none;color:inherit;font:inherit;width:100%;gap:var(--lumo-space-xs);padding:var(--lumo-space-s);padding-inline-start:calc(var(--lumo-space-s) + var(--_child-indent, 0px));border-radius:var(--lumo-border-radius-m);transition:background-color .14s,color .14s;cursor:var(--lumo-clickable-cursor, default);min-height:var(--lumo-icon-size-m)}button{-webkit-appearance:none;appearance:none;flex:none;position:relative;margin:0;padding:0;border:0;background:transparent}[part=children]{padding:0;margin:0;list-style-type:none}:host(:not([has-children])) button{display:none!important}slot[name=prefix],slot[name=suffix]{flex:none}slot:not([name]){display:block;flex:auto;min-width:0;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;margin:0 var(--lumo-space-s)}[part=link][href]{cursor:pointer}:host([disabled]) [part=link]{color:var(--lumo-disabled-text-color)}[part=toggle-button]{margin-inline-end:calc(var(--lumo-space-xs) * -1);width:var(--lumo-size-s);height:var(--lumo-size-s)}:host([has-children]) [part=content]{padding-inline-end:var(--lumo-space-s)}@media (any-hover: hover){[part=link]:hover{color:var(--lumo-header-text-color)}[part=toggle-button]:hover{color:var(--lumo-body-text-color)}}[part=link]:active:focus{background-color:var(--lumo-contrast-5pct)}[part=toggle-button]:before{content:var(--lumo-icons-dropdown);transform:rotate(-90deg);transition:transform .14s}:host([dir="rtl"]) [part=toggle-button]:before{transform:rotate(90deg)}:host([expanded]) [part=toggle-button]:before{transform:none}[part=link],[part=toggle-button]{outline:none}[part=link]:focus-visible,[part=toggle-button]:focus-visible{border-radius:var(--lumo-border-radius-m);box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part=link]:active{color:var(--lumo-header-text-color)}slot[name=prefix]::slotted(:is(vaadin-icon,[class*="icon"])){padding:.1em;flex-shrink:0;color:var(--lumo-contrast-60pct)}:host([disabled]) slot[name=prefix]::slotted(:is(vaadin-icon,[class*="icon"])){color:var(--lumo-disabled-text-color)}:host([current]) slot[name=prefix]::slotted(:is(vaadin-icon,[class*="icon"])){color:inherit}slot[name=children]{--_child-indent: calc(var(--_child-indent-2, 0px) + var(--vaadin-side-nav-child-indent, var(--lumo-space-l)))}slot[name=children]::slotted(*){--_child-indent-2: var(--_child-indent)}:host([current]) [part=content]{background-color:var(--lumo-primary-color-10pct);color:var(--vaadin-selection-color-text, var(--lumo-primary-text-color));border-radius:var(--lumo-border-radius-m)}}:is(:root,:host):before{--vaadin-side-nav-item-lumo-inject: 1;--vaadin-side-nav-item-lumo-inject-modules: lumo_mixins_field-button, lumo_components_side-nav-item}:is(:root,:host):before{--vaadin-side-nav-lumo-inject: 1;--vaadin-side-nav-lumo-inject-modules: lumo_components_side-nav}@media lumo_components_split-layout{:host{display:flex;overflow:hidden!important}:host([hidden]){display:none!important}:host([orientation="vertical"]){flex-direction:column}:host ::slotted(*){flex:1 1 auto;overflow:auto}[part=splitter]{flex:none;position:relative;z-index:1;overflow:visible;min-width:var(--lumo-space-s);min-height:var(--lumo-space-s);background-color:var(--lumo-contrast-5pct);transition:.1s background-color}:host(:not([orientation="vertical"]))>[part=splitter]{cursor:ew-resize}:host([orientation="vertical"])>[part=splitter]{cursor:ns-resize}[part=handle]{position:absolute;top:50%;left:50%;transform:translate3d(-50%,-50%,0);display:flex;align-items:center;justify-content:center;width:var(--lumo-size-m);height:var(--lumo-size-m)}[part=handle]:after{content:"";display:block;--_handle-size: 4px;width:var(--_handle-size);height:100%;max-width:100%;max-height:100%;border-radius:var(--lumo-border-radius-s);background-color:var(--lumo-contrast-30pct);transition:.1s opacity,.1s background-color}:host([orientation="vertical"]) [part=handle]:after{width:100%;height:var(--_handle-size)}[part=splitter]:active [part=handle]:after{background-color:var(--lumo-contrast-50pct)}:host([theme~="small"])>[part=splitter]{border-left:1px solid var(--lumo-contrast-10pct);border-top:1px solid var(--lumo-contrast-10pct)}:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]{min-width:0;min-height:0;background-color:transparent}:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]:after{content:"";position:absolute;inset:-4px}:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]>[part=handle]{left:calc(50% - .5px);top:calc(50% - .5px)}:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]>[part=handle]:after{opacity:0;--_handle-size: 5px}:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]:hover>[part=handle]:after,:host(:is([theme~="small"],[theme~="minimal"]))>[part=splitter]:active>[part=handle]:after{opacity:1}@media (any-hover: hover){[part=splitter]:hover [part=handle]:after{background-color:var(--lumo-contrast-40pct)}}@media (forced-colors: active){[part~=splitter]{outline:1px solid}[part~=handle]:after{background-color:AccentColor!important;forced-color-adjust:none}}}:is(:root,:host):before{--vaadin-split-layout-lumo-inject: 1;--vaadin-split-layout-lumo-inject-modules: lumo_components_split-layout}@media lumo_components_tabs{:host{display:flex;align-items:center;-webkit-tap-highlight-color:transparent}:host([hidden]){display:none!important}:host([orientation="vertical"]){display:block;box-shadow:-1px 0 0 0 var(--lumo-contrast-10pct)}:host([orientation="vertical"]) [part=tabs]{height:100%;overflow-y:auto;width:100%;margin:.5rem 0}:host(:not([orientation="vertical"])){box-shadow:inset 0 -1px 0 0 var(--lumo-contrast-10pct);position:relative;min-height:var(--lumo-size-l)}:host([orientation="horizontal"]) [part=tabs]{flex-grow:1;display:flex;align-self:stretch;overflow-x:auto;margin:0 .75rem}:host([orientation="horizontal"]) [part=tabs] ::slotted(vaadin-tab:not([theme~="icon-on-top"])){justify-content:center}@-moz-document url-prefix(){:host([orientation="horizontal"]) [part=tabs]{overflow:hidden}}:host([orientation="horizontal"]) [part=tabs]::-webkit-scrollbar{display:none}[part=back-button],[part=forward-button]{pointer-events:none;opacity:0;cursor:default;position:absolute;z-index:1;font-family:lumo-icons;color:var(--lumo-tertiary-text-color);font-size:var(--lumo-icon-size-m);display:flex;align-items:center;justify-content:center;width:1.5em;height:100%;transition:.2s opacity;top:0}[part=forward-button]:hover,[part=back-button]:hover{color:inherit}:host([overflow~="start"]) [part=back-button],:host([overflow~="end"]) [part=forward-button]{pointer-events:auto;opacity:1}[part=back-button]:after{content:var(--lumo-icons-angle-left)}[part=forward-button]:after{content:var(--lumo-icons-angle-right)}:host([orientation="vertical"]) [part=back-button],:host([orientation="vertical"]) [part=forward-button]{display:none}[part=tabs]{--_lumo-tabs-overflow-mask-image: none;-webkit-mask-image:var(--_lumo-tabs-overflow-mask-image);mask-image:var(--_lumo-tabs-overflow-mask-image)}:host([overflow~="start"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient( 90deg, transparent 2em, #000 4em, #000 calc(100% - 4em) , transparent calc(100% - 2em) )}:host([overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(90deg, #000 calc(100% - 4em) , transparent calc(100% - 2em) )}:host([overflow~="start"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(90deg, transparent 2em, #000 4em)}:host([overflow~="start"][overflow~="end"][orientation="vertical"]) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(transparent, #000 2em, #000 calc(100% - 2em) , transparent)}:host([overflow~="end"][orientation="vertical"]) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(#000 calc(100% - 2em) , transparent)}:host([overflow~="start"][orientation="vertical"]) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(transparent, #000 2em)}:host [part=tabs] ::slotted(:not(vaadin-tab)){margin-left:var(--lumo-space-m)}:host([theme~="centered"][orientation="horizontal"]) ::slotted(vaadin-tab:first-of-type){margin-inline-start:auto}:host([theme~="centered"][orientation="horizontal"]) ::slotted(vaadin-tab:last-of-type){margin-inline-end:auto}:host([theme~="small"]),:host([theme~="small"]) [part=tabs]{min-height:var(--lumo-size-m)}:host([theme~="small"]) [part=tabs] ::slotted(vaadin-tab){font-size:var(--lumo-font-size-s)}:host([theme~="minimal"]){box-shadow:none;--_lumo-tab-marker-display: none}:host([theme~="hide-scroll-buttons"]) [part=back-button],:host([theme~="hide-scroll-buttons"]) [part=forward-button]{display:none}:host([theme~="hide-scroll-buttons"][overflow~="start"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient( 90deg, transparent, #000 2em, #000 calc(100% - 2em) , transparent 100% )}:host([theme~="hide-scroll-buttons"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(90deg, #000 calc(100% - 2em) , transparent 100%)}:host([theme~="hide-scroll-buttons"][overflow~="start"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(90deg, transparent, #000 2em)}:host([theme~="equal-width-tabs"]){flex:auto}:host([theme~="equal-width-tabs"]) [part=tabs] ::slotted(vaadin-tab){flex:1 0 0%}:host(:not([dir="rtl"])) [part=forward-button]{right:0}:host([dir="rtl"]) [part=back-button]:after{content:var(--lumo-icons-angle-right)}:host([dir="rtl"]) [part=forward-button]:after{content:var(--lumo-icons-angle-left)}:host([dir="rtl"][orientation="vertical"]){box-shadow:1px 0 0 0 var(--lumo-contrast-10pct)}:host([dir="rtl"]) [part=forward-button]{left:0}:host([dir="rtl"]) [part=tabs] ::slotted(:not(vaadin-tab)){margin-left:0;margin-right:var(--lumo-space-m)}:host([dir="rtl"][overflow~="start"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient( -90deg, transparent 2em, #000 4em, #000 calc(100% - 4em) , transparent calc(100% - 2em) )}:host([dir="rtl"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, #000 calc(100% - 4em) , transparent calc(100% - 2em) )}:host([dir="rtl"][overflow~="start"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, transparent 2em, #000 4em)}:host([dir="rtl"][theme~="hide-scroll-buttons"][overflow~="start"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient( -90deg, transparent, #000 2em, #000 calc(100% - 2em) , transparent 100% )}:host([dir="rtl"][theme~="hide-scroll-buttons"][overflow~="end"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, #000 calc(100% - 2em) , transparent 100%)}:host([dir="rtl"][theme~="hide-scroll-buttons"][overflow~="start"]:not([orientation="vertical"])) [part=tabs]{--_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, transparent, #000 2em)}}@media lumo_components_tab{:host{box-sizing:border-box;padding:.5rem .75rem;font-family:var(--lumo-font-family);font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-xs);font-weight:500;opacity:1;color:var(--lumo-secondary-text-color);transition:.15s color,.2s transform;flex-shrink:0;display:flex;align-items:center;position:relative;cursor:var(--lumo-clickable-cursor);transform-origin:50% 100%;outline:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;overflow:hidden;min-width:var(--lumo-size-m);-webkit-user-select:none;user-select:none;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px);--_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));--_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color))}:host([hidden]){display:none!important}:host(:not([orientation="vertical"])){text-align:center}:host([orientation="vertical"]){transform-origin:0% 50%;padding:.25rem 1rem;min-height:var(--lumo-size-m);min-width:0}:host(:hover),:host([focus-ring]){color:var(--lumo-body-text-color)}:host([selected]){color:var(--_selection-color-text);transition:.6s color}:host([active]:not([selected])){color:var(--_selection-color-text);transition-duration:.1s}:host:before,:host:after{content:"";position:absolute;display:var(--_lumo-tab-marker-display, block);bottom:0;left:50%;width:var(--lumo-size-s);height:2px;background-color:var(--lumo-contrast-60pct);border-radius:var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0 0;transform:translate(-50%) scale(0);transform-origin:50% 100%;transition:.14s transform cubic-bezier(.12,.32,.54,1);will-change:transform}:host([orientation="vertical"]):before,:host([orientation="vertical"]):after{left:0;bottom:50%;transform:translateY(50%) scale(0);width:2px;height:var(--lumo-size-xs);border-radius:0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;transform-origin:100% 50%}:host:after{box-shadow:0 0 0 4px var(--_selection-color);opacity:.15;transition:.15s .02s transform,.8s .17s opacity}:host([selected]):before,:host([selected]):after{background-color:var(--_selection-color);transform:translate(-50%) scale(1);transition-timing-function:cubic-bezier(.12,.32,.54,1.5)}:host([orientation="vertical"][selected]):before,:host([orientation="vertical"][selected]):after{transform:translateY(50%) scale(1)}:host([selected]:not([active])):after{opacity:0}:host(:not([orientation="vertical"])) ::slotted(a[href]){justify-content:center}:host ::slotted(a){display:flex;width:100%;align-items:center;height:100%;margin:-.5rem -.75rem;padding:.5rem .75rem;outline:none;text-decoration:none!important;color:inherit!important}:host ::slotted(vaadin-icon){margin:0 4px;width:var(--lumo-icon-size-m);height:var(--lumo-icon-size-m)}:host ::slotted(vaadin-icon[icon^="vaadin:"]){padding:.25rem;box-sizing:border-box!important}:host(:not([dir="rtl"])) ::slotted(vaadin-icon:first-child){margin-left:0}:host(:not([dir="rtl"])) ::slotted(vaadin-icon:last-child){margin-right:0}:host([theme~="icon-on-top"]){display:flex;flex-direction:column;align-items:center;justify-content:space-around;text-align:center;padding-bottom:.5rem;padding-top:.25rem}:host([theme~="icon-on-top"]) ::slotted(a){flex-direction:column;align-items:center;margin-top:-.25rem;padding-top:.25rem}:host([theme~="icon-on-top"]) ::slotted(vaadin-icon){margin:0}:host([disabled]){pointer-events:none;opacity:1;color:var(--lumo-disabled-text-color)}:host([focus-ring]){box-shadow:inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);border-radius:var(--lumo-border-radius-m)}:host([dir="rtl"]):before,:host([dir="rtl"]):after{left:auto;right:50%;transform:translate(50%) scale(0)}:host([dir="rtl"][selected]:not([orientation="vertical"])):before,:host([dir="rtl"][selected]:not([orientation="vertical"])):after{transform:translate(50%) scale(1)}:host([dir="rtl"]) ::slotted(vaadin-icon:first-child){margin-right:0}:host([dir="rtl"]) ::slotted(vaadin-icon:last-child){margin-left:0}:host([orientation="vertical"][dir="rtl"]){transform-origin:100% 50%}:host([dir="rtl"][orientation="vertical"]):before,:host([dir="rtl"][orientation="vertical"]):after{left:auto;right:0;border-radius:var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);transform-origin:0% 50%}@media (forced-colors: active){:host([focused]){outline:1px solid;outline-offset:-1px}:host([selected]){border-bottom:2px solid}:host([orientation="vertical"][selected]){border-bottom:none;border-left:2px solid}}}:is(:root,:host):before{--vaadin-tab-lumo-inject: 1;--vaadin-tab-lumo-inject-modules: lumo_components_tab}:is(:root,:host):before{--vaadin-tabs-lumo-inject: 1;--vaadin-tabs-lumo-inject-modules: lumo_components_tabs}@media lumo_components_tabsheet{:host{display:flex;flex-direction:column;font-size:var(--lumo-font-size-m);line-height:var(--lumo-line-height-m);font-family:var(--lumo-font-family)}:host([hidden]){display:none!important}[part=tabs-container]{position:relative;display:flex;align-items:center;box-shadow:inset 0 -1px 0 0 var(--lumo-contrast-10pct);padding:var(--lumo-space-xs) var(--lumo-space-s);gap:var(--lumo-space-s)}::slotted([slot="tabs"]){flex:1;align-self:stretch;min-width:8em;box-shadow:initial;margin:calc(var(--lumo-space-xs) * -1) calc(var(--lumo-space-s) * -1)}::slotted([hidden]){display:none!important}[part=content]{position:relative;flex:1;box-sizing:border-box;padding:var(--lumo-space-s) var(--lumo-space-m);border-bottom-left-radius:inherit;border-bottom-right-radius:inherit}:host([theme~="bordered"]){border:1px solid var(--lumo-contrast-20pct);border-radius:var(--lumo-border-radius-l)}:host([loading]) [part=content]{display:flex;align-items:center;justify-content:center}:host([theme~="no-padding"]) [part=content]{padding:0!important}}:is(:root,:host):before{--vaadin-tabsheet-lumo-inject: 1;--vaadin-tabsheet-lumo-inject-modules: lumo_mixins_loader, lumo_components_tabsheet;--vaadin-tabsheet-scroller-lumo-inject: 1;--vaadin-tabsheet-scroller-lumo-inject-modules: lumo_components_scroller}@media lumo_components_upload-file-list{:host{display:block}:host([hidden]){display:none!important}[part=list]{padding:0;margin:0;list-style-type:none}::slotted(li:not(:first-of-type)){border-top:1px solid var(--lumo-contrast-10pct)}}@media lumo_components_upload-file{:host{display:block;padding:var(--lumo-space-s) 0;outline:none;--_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));--_focus-ring-width: var(--vaadin-focus-ring-width, 2px)}[hidden]{display:none}[part=row]{list-style-type:none;display:flex;align-items:baseline;justify-content:space-between}button{background:transparent;padding:0;border:none;box-shadow:none}:host([complete]) ::slotted([slot="progress"]),:host([error]) ::slotted([slot="progress"]){display:none!important}:host([focus-ring]) [part=row]{border-radius:var(--lumo-border-radius-s);box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part=status],[part=error]{color:var(--lumo-secondary-text-color);font-size:var(--lumo-font-size-s)}[part=info]{display:flex;align-items:baseline;flex:auto}[part=meta]{width:.001px;flex:1 1 auto}[part=name]{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}[part=commands]{display:flex;align-items:baseline;flex:none}[part$=icon]{margin-right:var(--lumo-space-xs);font-size:var(--lumo-icon-size-m);font-family:lumo-icons;line-height:1}[part=done-icon][hidden]+[part=warning-icon][hidden]{display:block!important;visibility:hidden}[part$=button]{flex:none;margin-left:var(--lumo-space-xs);cursor:var(--lumo-clickable-cursor)}[part$=button]:focus{outline:none;border-radius:var(--lumo-border-radius-s);box-shadow:0 0 0 var(--_focus-ring-width) var(--_focus-ring-color)}[part$=icon]:before,[part$=button]:before{vertical-align:-.25em}[part=done-icon]:before{content:var(--lumo-icons-checkmark);color:var(--lumo-primary-text-color)}[part=warning-icon]:before{content:var(--lumo-icons-error);color:var(--lumo-error-text-color)}[part=start-button]:before{content:var(--lumo-icons-play)}[part=retry-button]:before{content:var(--lumo-icons-reload)}[part=remove-button]:before{content:var(--lumo-icons-cross)}[part=error]{color:var(--lumo-error-text-color)}::slotted([slot="progress"]){width:auto;margin-left:calc(var(--lumo-icon-size-m) + var(--lumo-space-xs));margin-right:calc(var(--lumo-icon-size-m) + var(--lumo-space-xs))}}@media lumo_components_upload-icon{:host{display:inline-block}:host:before{content:var(--lumo-icons-upload);font-family:lumo-icons;font-size:var(--lumo-icon-size-m);line-height:1;vertical-align:-.25em;background-color:transparent;-webkit-mask-image:none;mask-image:none}}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */@media lumo_components_upload{:host{display:block;position:relative;box-sizing:border-box;line-height:var(--lumo-line-height-m)}:host([hidden]){display:none!important}[hidden]{display:none!important}:host(:not([nodrop])){overflow:hidden;border:1px dashed var(--lumo-contrast-20pct);border-radius:var(--lumo-border-radius-l);padding:var(--lumo-space-m);transition:background-color .6s,border-color .6s}[part=drop-label]{display:inline-block;white-space:normal;padding:0 var(--lumo-space-s);color:var(--lumo-secondary-text-color);font-family:var(--lumo-font-family)}:host([dragover-valid]){border-color:var(--lumo-primary-color-50pct);background:var(--lumo-primary-color-10pct);transition:background-color .1s,border-color .1s}:host([dragover-valid]) [part=drop-label]{color:var(--lumo-primary-text-color)}:host([disabled]) [part=drop-label],:host([max-files-reached]) [part=drop-label]{color:var(--lumo-disabled-text-color)}}:is(:root,:host):before{--vaadin-upload-lumo-inject: 1;--vaadin-upload-lumo-inject-modules: lumo_components_upload;--vaadin-upload-icon-lumo-inject: 1;--vaadin-upload-icon-lumo-inject-modules: lumo_components_upload-icon;--vaadin-upload-file-lumo-inject: 1;--vaadin-upload-file-lumo-inject-modules: lumo_mixins_field-button, lumo_components_upload-file;--vaadin-upload-file-list-lumo-inject: 1;--vaadin-upload-file-list-lumo-inject-modules: lumo_components_upload-file-list}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */@media lumo_components_vertical-layout{:host([theme~="margin"]){margin:var(--lumo-space-m)}:host([theme~="padding"]){padding:var(--lumo-space-m)}:host([theme~="spacing-xs"]){gap:var(--lumo-space-xs)}:host([theme~="spacing-s"]){gap:var(--lumo-space-s)}:host([theme~="spacing"]){gap:var(--lumo-space-m)}:host([theme~="spacing-l"]){gap:var(--lumo-space-l)}:host([theme~="spacing-xl"]){gap:var(--lumo-space-xl)}}:is(:root,:host):before{--vaadin-vertical-layout-lumo-inject: 1;--vaadin-vertical-layout-lumo-inject-modules: lumo_components_vertical-layout}`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const directionSubscribers=[];function alignDirs(v,d,a=v.getAttribute("dir")){d?v.setAttribute("dir",d):a!=null&&v.removeAttribute("dir")}function getDocumentDir(){return document.documentElement.getAttribute("dir")}function directionUpdater(){const v=getDocumentDir();directionSubscribers.forEach(d=>{alignDirs(d,v)})}const directionObserver=new MutationObserver(directionUpdater);directionObserver.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]});const DirMixin=v=>class extends v{static get properties(){return{dir:{type:String,value:"",reflectToAttribute:!0,converter:{fromAttribute:a=>a||"",toAttribute:a=>a===""?null:a}}}}get __isRTL(){return this.getAttribute("dir")==="rtl"}connectedCallback(){super.connectedCallback(),(!this.hasAttribute("dir")||this.__restoreSubscription)&&(this.__subscribe(),alignDirs(this,getDocumentDir(),null))}attributeChangedCallback(a,p,y){if(super.attributeChangedCallback(a,p,y),a!=="dir")return;const C=getDocumentDir(),P=y===C&&directionSubscribers.indexOf(this)===-1,z=!y&&p&&directionSubscribers.indexOf(this)===-1;P||z?(this.__subscribe(),alignDirs(this,C,y)):y!==C&&p===C&&this.__unsubscribe()}disconnectedCallback(){super.disconnectedCallback(),this.__restoreSubscription=directionSubscribers.includes(this),this.__unsubscribe()}_valueToNodeAttribute(a,p,y){y==="dir"&&p===""&&!a.hasAttribute("dir")||super._valueToNodeAttribute(a,p,y)}_attributeToProperty(a,p,y){a==="dir"&&!p?this.dir="":super._attributeToProperty(a,p,y)}__subscribe(){directionSubscribers.includes(this)||directionSubscribers.push(this)}__unsubscribe(){directionSubscribers.includes(this)&&directionSubscribers.splice(directionSubscribers.indexOf(this),1)}},appliedClassMixins=new WeakMap;function wasMixinPreviouslyApplied(v,d){let a=d;for(;a;){if(appliedClassMixins.get(a)===v)return!0;a=Object.getPrototypeOf(a)}return!1}function dedupeMixin(v){return d=>{if(wasMixinPreviouslyApplied(v,d))return d;const a=v(d);return appliedClassMixins.set(a,v),a}}/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function get$6(v,d){return v.split(".").reduce((a,p)=>a?a[p]:void 0,d)}function set(v,d,a){const p=v.split("."),y=p.pop(),C=p.reduce((P,z)=>P[z],a);C[y]=d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const caseMap={},CAMEL_TO_DASH=/([A-Z])/gu;function camelToDash(v){return caseMap[v]||(caseMap[v]=v.replace(CAMEL_TO_DASH,"-$1").toLowerCase()),caseMap[v]}function upper(v){return v[0].toUpperCase()+v.substring(1)}function parseObserver(v){const[d,a]=v.split("("),p=a.replace(")","").split(",").map(y=>y.trim());return{method:d,observerProps:p}}function getOrCreateMap(v,d){return Object.prototype.hasOwnProperty.call(v,d)||(v[d]=new Map(v[d])),v[d]}const PolylitMixinImplementation=v=>{class d extends v{static enabledWarnings=[];static createProperty(p,y){[String,Boolean,Number,Array].includes(y)&&(y={type:y}),y&&y.reflectToAttribute&&(y.reflect=!0),super.createProperty(p,y)}static getOrCreateMap(p){return getOrCreateMap(this,p)}static finalize(){if(window.litIssuedWarnings&&(window.litIssuedWarnings.add("no-override-create-property"),window.litIssuedWarnings.add("no-override-get-property-descriptor")),super.finalize(),Array.isArray(this.observers)){const p=this.getOrCreateMap("__complexObservers");this.observers.forEach(y=>{const{method:C,observerProps:P}=parseObserver(y);p.set(C,P)})}}static addCheckedInitializer(p){super.addInitializer(y=>{y instanceof this&&p(y)})}static getPropertyDescriptor(p,y,C){const P=super.getPropertyDescriptor(p,y,C);let z=P;if(this.getOrCreateMap("__propKeys").set(p,y),C.sync&&(z={get:P.get,set(L){const $=this[p];f$2(L,$)&&(this[y]=L,this.requestUpdate(p,$,C),this.hasUpdated&&this.performUpdate())},configurable:!0,enumerable:!0}),C.readOnly){const L=z.set;this.addCheckedInitializer($=>{$[`_set${upper(p)}`]=function(N){L.call($,N)}}),z={get:z.get,set(){},configurable:!0,enumerable:!0}}if("value"in C&&this.addCheckedInitializer(L=>{const $=typeof C.value=="function"?C.value.call(L):C.value;C.readOnly?L[`_set${upper(p)}`]($):L[p]=$}),C.observer){const L=C.observer;this.getOrCreateMap("__observers").set(p,L),this.addCheckedInitializer($=>{$[L]||console.warn(`observer method ${L} not defined`)})}if(C.notify){if(!this.__notifyProps)this.__notifyProps=new Set;else if(!this.hasOwnProperty("__notifyProps")){const L=this.__notifyProps;this.__notifyProps=new Set(L)}this.__notifyProps.add(p)}if(C.computed){const L=`__assignComputed${p}`,$=parseObserver(C.computed);this.prototype[L]=function(...N){this[p]=this[$.method](...N)},this.getOrCreateMap("__computedObservers").set(L,$.observerProps)}return C.attribute||(C.attribute=camelToDash(p)),z}static get polylitConfig(){return{asyncFirstRender:!1}}constructor(){super(),this.__hasPolylitMixin=!0}connectedCallback(){super.connectedCallback();const p=this.getRootNode().host;p&&p.__hasPolylitMixin&&this.id&&(p.$||={},p.$[this.id]=this);const{polylitConfig:y}=this.constructor;!this.hasUpdated&&!y.asyncFirstRender&&this.performUpdate()}firstUpdated(){super.firstUpdated(),this.$||(this.$={}),this.renderRoot.querySelectorAll("[id]").forEach(p=>{this.$[p.id]=p})}ready(){}willUpdate(p){this.constructor.__computedObservers&&this.__runComplexObservers(p,this.constructor.__computedObservers)}updated(p){const y=this.__isReadyInvoked;this.__isReadyInvoked=!0,this.constructor.__observers&&this.__runObservers(p,this.constructor.__observers),this.constructor.__complexObservers&&this.__runComplexObservers(p,this.constructor.__complexObservers),this.__dynamicPropertyObservers&&this.__runDynamicObservers(p,this.__dynamicPropertyObservers),this.__dynamicMethodObservers&&this.__runComplexObservers(p,this.__dynamicMethodObservers),this.constructor.__notifyProps&&this.__runNotifyProps(p,this.constructor.__notifyProps),y||this.ready()}setProperties(p){Object.entries(p).forEach(([y,C])=>{const P=this.constructor.__propKeys.get(y),z=this[P];this[P]=C,this.requestUpdate(y,z)}),this.hasUpdated&&this.performUpdate()}_createMethodObserver(p){const y=getOrCreateMap(this,"__dynamicMethodObservers"),{method:C,observerProps:P}=parseObserver(p);y.set(C,P)}_createPropertyObserver(p,y){getOrCreateMap(this,"__dynamicPropertyObservers").set(y,p)}__runComplexObservers(p,y){y.forEach((C,P)=>{C.some(z=>p.has(z))&&(this[P]?this[P](...C.map(z=>this[z])):console.warn(`observer method ${P} not defined`))})}__runDynamicObservers(p,y){y.forEach((C,P)=>{p.has(C)&&this[P]&&this[P](this[C],p.get(C))})}__runObservers(p,y){p.forEach((C,P)=>{const z=y.get(P);z!==void 0&&this[z]&&this[z](this[P],C)})}__runNotifyProps(p,y){p.forEach((C,P)=>{y.has(P)&&this.dispatchEvent(new CustomEvent(`${camelToDash(P)}-changed`,{detail:{value:this[P]}}))})}_get(p,y){return get$6(p,y)}_set(p,y,C){set(p,y,C)}}return d},PolylitMixin=dedupeMixin(PolylitMixinImplementation);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CSSPropertyObserver{#e;#n;#i;#t=new Set;#r;#o=!1;constructor(d,a,p){this.#e=d,this.#n=a,this.#i=p}#a(d){const{propertyName:a}=d;this.#t.has(a)&&this.#i(a)}observe(d){this.connect(),this.#t.add(d),this.#s.style.setProperty(`--${this.#n}-props`,[...this.#t].join(", "))}connect(){this.#o||(this.#r=new CSSStyleSheet,this.#r.replaceSync(`
      :is(:root, :host)::before {
        content: '' !important;
        position: absolute !important;
        top: -9999px !important;
        left: -9999px !important;
        visibility: hidden !important;
        transition: 1ms allow-discrete step-end !important;
        transition-property: var(--${this.#n}-props) !important;
      }
    `),this.#e.adoptedStyleSheets.unshift(this.#r),this.#s.addEventListener("transitionstart",d=>this.#a(d)),this.#s.addEventListener("transitionend",d=>this.#a(d)),this.#o=!0)}disconnect(){this.#t.clear(),this.#e.adoptedStyleSheets=this.#e.adoptedStyleSheets.filter(d=>d!==this.#r),this.#s.removeEventListener("transitionstart",this.#a),this.#s.removeEventListener("transitionend",this.#a),this.#s.style.removeProperty(`--${this.#n}-props`),this.#o=!1}get#s(){return this.#e.documentElement??this.#e.host}}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const cache$2=new WeakMap;function parseStyleSheet(v,d={tags:new Map,modules:new Map}){let a;try{a=v.cssRules}catch{a=[]}for(const p of a){const{media:y}=p;if(p instanceof CSSImportRule){y?.mediaText.startsWith("lumo_")?d.modules.set(y.mediaText,[...p.styleSheet.cssRules]):parseStyleSheet(p.styleSheet,d);continue}if(p instanceof CSSMediaRule){y?.mediaText.startsWith("lumo_")&&d.modules.set(y.mediaText,[...p.cssRules]);continue}if(p instanceof CSSStyleRule&&p.cssText.includes("-lumo-inject")){for(const C of p.style){const P=C.match(/^--(.*)-lumo-inject-modules$/u)?.[1];if(!P)continue;const z=p.style.getPropertyValue(C);d.tags.set(P,z.split(",").map(L=>L.trim().replace(/'|"/gu,"")))}continue}}return d}function parseStyleSheets(v){let d=new Map,a=new Map;for(const p of v){let y=cache$2.get(p);y||(y=parseStyleSheet(p),cache$2.set(p,y)),d=new Map([...d,...y.tags]),a=new Map([...a,...y.modules])}return{tags:d,modules:a}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class LumoInjector{#e;#n;#i=new Map;#t=new Map;constructor(d=document){this.#e=d,this.#n=new CSSPropertyObserver(this.#e,"vaadin-lumo-injector",a=>{const p=a.slice(2).replace("-lumo-inject","");this.#o(p)})}disconnect(){this.#n.disconnect(),this.#i.clear(),this.#t.values().forEach(d=>d.forEach(removeLumoStyleSheet))}componentConnected(d){const{is:a,lumoInjectPropName:p}=d.constructor;this.#t.set(a,this.#t.get(a)??new Set),this.#t.get(a).add(d);const y=this.#i.get(a);if(y){y.cssRules.length>0&&injectLumoStyleSheet(d,y);return}this.#r(a),this.#n.observe(p)}componentDisconnected(d){const{is:a}=d.constructor;this.#t.get(a)?.delete(d),removeLumoStyleSheet(d)}#r(d){this.#i.set(d,new CSSStyleSheet),this.#o(d)}#o(d){const{tags:a,modules:p}=parseStyleSheets(this.#a),y=(a.get(d)??[]).flatMap(P=>p.get(P)??[]).map(P=>P.cssText).join(`
`),C=this.#i.get(d);C.replaceSync(y),this.#t.get(d)?.forEach(P=>{y?injectLumoStyleSheet(P,C):removeLumoStyleSheet(P)})}get#a(){let d=new Set;for(const a of[this.#e,document])d=d.union(new Set(a.styleSheets)),d=d.union(new Set(a.adoptedStyleSheets));return[...d]}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const registeredProperties=new Set;function findRoot(v){const d=v.getRootNode();return d.host&&d.host.constructor.version?findRoot(d.host):d}const LumoInjectionMixin=v=>class extends v{static finalize(){super.finalize();const a=this.lumoInjectPropName;this.is&&!registeredProperties.has(a)&&(registeredProperties.add(a),CSS.registerProperty({name:a,syntax:"<number>",inherits:!0,initialValue:"0"}))}static get lumoInjectPropName(){return`--${this.is}-lumo-inject`}static get lumoInjector(){return{includeBaseStyles:!1}}connectedCallback(){if(super.connectedCallback(),this.isConnected){const a=findRoot(this);a.__lumoInjector||=new LumoInjector(a),this.__lumoInjector=a.__lumoInjector,this.__lumoInjector.componentConnected(this)}}disconnectedCallback(){super.disconnectedCallback(),this.__lumoInjector&&(this.__lumoInjector.componentDisconnected(this),this.__lumoInjector=void 0)}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */addGlobalThemeStyles("vaadin-base-user-colors",i`
    @layer vaadin.base {
      :where(html) {
        --_color-count: 10;
        --_hue-step: calc(360 / var(--_color-count) - 1);
        --vaadin-user-color-0: var(--vaadin-user-color, #4172d5);
        --vaadin-user-color-1: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 1)
        );
        --vaadin-user-color-2: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 2)
        );
        --vaadin-user-color-3: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 3)
        );
        --vaadin-user-color-4: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 4)
        );
        --vaadin-user-color-5: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 5)
        );
        --vaadin-user-color-6: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 6)
        );
        --vaadin-user-color-7: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 7)
        );
        --vaadin-user-color-8: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 8)
        );
        --vaadin-user-color-9: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 9)
        );
      }
    }
  `);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fieldOutlineStyles=i`
  :host {
    display: block;
    position: absolute;
    inset: 0;
    pointer-events: none;
    opacity: 0;
    --_active-user-color: transparent;
    outline: 3px solid var(--_active-user-color);
    outline-offset: -1px;
    /* TODO doesn't inherit correctly from vaadin-input-container for some reason, so we use the internal _radius property */
    border-radius: var(--_radius, inherit);
  }

  :host([has-active-user]) {
    opacity: 1;
  }

  :host([context$='item']) {
    inset: 2px;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(i$1)))){static get is(){return"vaadin-field-outline"}static get styles(){return fieldOutlineStyles}static get properties(){return{user:{type:Object,value:null,observer:"_userChanged",sync:!0}}}render(){return x``}ready(){super.ready(),this.setAttribute("part","outline"),this._field=this.getRootNode().host}_userChanged(d){this.toggleAttribute("has-active-user",!!d);const a=d?`var(--vaadin-user-color-${d.colorIndex})`:"transparent",p="--_active-user-color";this.style.setProperty(p,a),this._field&&this._field.style.setProperty(p,a)}}defineCustomElement(FieldOutline);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */addGlobalThemeStyles("vaadin-base",i`
    @layer vaadin.base {
      :where(html) {
        /* Background color */
        --vaadin-background-color: light-dark(#fff, #222);

        /* Container colors */
        --vaadin-background-container: color-mix(in oklch, var(--vaadin-color) 5%, var(--vaadin-background-color));
        --vaadin-background-container-strong: color-mix(
          in oklch,
          var(--vaadin-color) 10%,
          var(--vaadin-background-color)
        );

        /* Border colors */
        --vaadin-border-color-subtle: color-mix(in oklch, var(--vaadin-color) 24%, transparent);
        --vaadin-border-color: color-mix(in oklch, var(--vaadin-color) 48%, transparent); /* Above 3:1 contrast */

        /* Text colors */
        --vaadin-color-disabled: color-mix(in oklch, var(--vaadin-color) 48%, transparent); /* Above 3:1 contrast */
        --vaadin-color-subtle: color-mix(in oklch, var(--vaadin-color) 68%, transparent); /* Above 4.5:1 contrast */
        --vaadin-color: light-dark(#1f1f1f, white); /* Above 7:1 contrast */

        /* Padding */
        --vaadin-padding-xs: 6px;
        --vaadin-padding-s: 8px;
        --vaadin-padding-m: 12px;
        --vaadin-padding-l: 16px;
        --vaadin-padding-xl: 24px;
        --vaadin-padding-container: var(--vaadin-padding-xs) var(--vaadin-padding-s);

        /* Gap/spacing */
        --vaadin-gap-s: 8px;
        --vaadin-gap-m: 12px;
        --vaadin-gap-l: 16px;

        /* Border radius */
        --vaadin-radius-s: 3px;
        --vaadin-radius-m: 6px;
        --vaadin-radius-l: 12px;

        /* Focus outline */
        --vaadin-focus-ring-width: 2px;
        --vaadin-focus-ring-color: var(--vaadin-color);

        /* Icons, used as mask-image */
        --_vaadin-icon-arrow-up: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M4.5 10.5 12 3m0 0 7.5 7.5M12 3v18" /></svg>');
        --_vaadin-icon-calendar: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5" /></svg>');
        --_vaadin-icon-checkmark: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5" /></svg>');
        --_vaadin-icon-chevron-down: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" /></svg>');
        --_vaadin-icon-clock: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" /></svg>');
        --_vaadin-icon-cross: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" /></svg>');
        --_vaadin-icon-drag: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"><path d="M11 7c0 .82843-.6716 1.5-1.5 1.5C8.67157 8.5 8 7.82843 8 7s.67157-1.5 1.5-1.5c.8284 0 1.5.67157 1.5 1.5Zm0 5c0 .8284-.6716 1.5-1.5 1.5-.82843 0-1.5-.6716-1.5-1.5s.67157-1.5 1.5-1.5c.8284 0 1.5.6716 1.5 1.5Zm0 5c0 .8284-.6716 1.5-1.5 1.5-.82843 0-1.5-.6716-1.5-1.5s.67157-1.5 1.5-1.5c.8284 0 1.5.6716 1.5 1.5Zm5-10c0 .82843-.6716 1.5-1.5 1.5S13 7.82843 13 7s.6716-1.5 1.5-1.5S16 6.17157 16 7Zm0 5c0 .8284-.6716 1.5-1.5 1.5S13 12.8284 13 12s.6716-1.5 1.5-1.5 1.5.6716 1.5 1.5Zm0 5c0 .8284-.6716 1.5-1.5 1.5S13 17.8284 13 17s.6716-1.5 1.5-1.5 1.5.6716 1.5 1.5Z" fill="currentColor"/></svg>');
        --_vaadin-icon-edit: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"><path d="M11 3.99998H6.8C5.11984 3.99998 4.27976 3.99998 3.63803 4.32696C3.07354 4.61458 2.6146 5.07353 2.32698 5.63801C2 6.27975 2 7.11983 2 8.79998V17.2C2 18.8801 2 19.7202 2.32698 20.362C2.6146 20.9264 3.07354 21.3854 3.63803 21.673C4.27976 22 5.11984 22 6.8 22H15.2C16.8802 22 17.7202 22 18.362 21.673C18.9265 21.3854 19.3854 20.9264 19.673 20.362C20 19.7202 20 18.8801 20 17.2V13M7.99997 16H9.67452C10.1637 16 10.4083 16 10.6385 15.9447C10.8425 15.8957 11.0376 15.8149 11.2166 15.7053C11.4184 15.5816 11.5914 15.4086 11.9373 15.0627L21.5 5.49998C22.3284 4.67156 22.3284 3.32841 21.5 2.49998C20.6716 1.67156 19.3284 1.67155 18.5 2.49998L8.93723 12.0627C8.59133 12.4086 8.41838 12.5816 8.29469 12.7834C8.18504 12.9624 8.10423 13.1574 8.05523 13.3615C7.99997 13.5917 7.99997 13.8363 7.99997 14.3255V16Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>');
        --_vaadin-icon-eye: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" /></svg>');
        --_vaadin-icon-eye-slash: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.98 8.223A10.477 10.477 0 0 0 1.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.451 10.451 0 0 1 12 4.5c4.756 0 8.773 3.162 10.065 7.498a10.522 10.522 0 0 1-4.293 5.774M6.228 6.228 3 3m3.228 3.228 3.65 3.65m7.894 7.894L21 21m-3.228-3.228-3.65-3.65m0 0a3 3 0 1 0-4.243-4.243m4.242 4.242L9.88 9.88" /></svg>');
        --_vaadin-icon-fullscreen: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15" /></svg>');
        --_vaadin-icon-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" /></svg>');
        --_vaadin-icon-link: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"><path d="M9 17H7C4.23858 17 2 14.7614 2 12C2 9.23858 4.23858 7 7 7H9M15 17H17C19.7614 17 22 14.7614 22 12C22 9.23858 19.7614 7 17 7H15M7 12L17 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>');
        --_vaadin-icon-menu: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>');
        --_vaadin-icon-minus: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M5 12h14" /></svg>');
        --_vaadin-icon-paper-airplane: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 12 3.269 3.125A59.769 59.769 0 0 1 21.485 12 59.768 59.768 0 0 1 3.27 20.875L5.999 12Zm0 0h7.5" /></svg>');
        --_vaadin-icon-play: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.347a1.125 1.125 0 0 1 0 1.972l-11.54 6.347a1.125 1.125 0 0 1-1.667-.986V5.653Z" /></svg>');
        --_vaadin-icon-plus: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5v15m7.5-7.5h-15" /></svg>');
        --_vaadin-icon-redo: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" /></svg>');
        --_vaadin-icon-refresh: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"><path d="M22 10C22 10 19.995 7.26822 18.3662 5.63824C16.7373 4.00827 14.4864 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21C16.1031 21 19.5649 18.2543 20.6482 14.5M22 10V4M22 10H16" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>');
        --_vaadin-icon-resize: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.5303 7.46967c.2929.29289.2929.76777 0 1.06066L8.53033 18.5304c-.29289.2929-.76777.2929-1.06066 0s-.29289-.7678 0-1.0607L17.4697 7.46967c.2929-.29289.7677-.29289 1.0606 0Zm0 4.50003c.2929.2929.2929.7678 0 1.0607l-5.5 5.5c-.2929.2928-.7677.2928-1.0606 0-.2929-.2929-.2929-.7678 0-1.0607l5.4999-5.5c.2929-.2929.7678-.2929 1.0607 0Zm0 4.5c.2929.2928.2929.7677 0 1.0606l-1 1.0001c-.2929.2928-.7677.2929-1.0606 0-.2929-.2929-.2929-.7678 0-1.0607l1-1c.2929-.2929.7677-.2929 1.0606 0Z" fill="currentColor"/></svg>');
        --_vaadin-icon-sort: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="8" height="12" viewBox="0 0 8 12" fill="none"><path d="M7.49854 6.99951C7.92795 6.99951 8.15791 7.50528 7.87549 7.82861L4.37646 11.8296C4.17728 12.0571 3.82272 12.0571 3.62354 11.8296L0.125488 7.82861C-0.157248 7.50531 0.0719873 6.99956 0.501465 6.99951H7.49854ZM3.62354 0.17041C3.82275 -0.0573875 4.17725 -0.0573848 4.37646 0.17041L7.87549 4.17041C8.15825 4.49373 7.92806 5.00049 7.49854 5.00049L0.501465 4.99951C0.0719873 4.99946 -0.157248 4.49371 0.125488 4.17041L3.62354 0.17041Z" fill="black"/></svg>');
        --_vaadin-icon-undo: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" /></svg>');
        --_vaadin-icon-upload: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" /></svg>');
        --_vaadin-icon-user: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"><path d="M3 20C5.33579 17.5226 8.50702 16 12 16C15.493 16 18.6642 17.5226 21 20M16.5 7.5C16.5 9.98528 14.4853 12 12 12C9.51472 12 7.5 9.98528 7.5 7.5C7.5 5.01472 9.51472 3 12 3C14.4853 3 16.5 5.01472 16.5 7.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>');
        --_vaadin-icon-warn: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126ZM12 15.75h.007v.008H12v-.008Z" /></svg>');

        /* Cursors for interactive elements */
        --vaadin-clickable-cursor: pointer;
        --vaadin-disabled-cursor: not-allowed;
      }

      @media (forced-colors: active) {
        html {
          --vaadin-background-color: Canvas;
          --vaadin-border-color: CanvasText;
          --vaadin-border-color-strong: CanvasText;
          --vaadin-color-disabled: CanvasText;
          --vaadin-color-subtle: CanvasText;
          --vaadin-color: CanvasText;
          --vaadin-icon-color: CanvasText;
          --vaadin-focus-ring-color: Highlight;
        }
      }
    }
  `);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userTagStyles=i`
  :host {
    display: inline-block;
    box-sizing: border-box;
    opacity: 0;
    padding: var(--vaadin-user-tag-padding, 0.3em);
    background-color: var(--vaadin-user-tag-color);
    color: oklch(from var(--vaadin-user-tag-color) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    font-size: var(--vaadin-user-tag-font-size, 0.75em);
    font-weight: var(--vaadin-user-tag-font-weight, 500);
    line-height: var(--vaadin-user-tag-line-height, 1);
    border: var(--vaadin-user-tag-border-width, 0) solid
      var(--vaadin-user-tag-border-color, var(--vaadin-border-color-subtle));
    border-radius: var(--vaadin-user-tag-border-radius, var(--vaadin-radius-m));
    cursor: default;
  }

  :host(.show) {
    opacity: 1;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTag extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(i$1)))){static get is(){return"vaadin-user-tag"}static get styles(){return userTagStyles}render(){return x`<div part="name">${this.name}</div>`}static get properties(){return{name:{type:String},uid:{type:String},colorIndex:{type:Number,observer:"_colorIndexChanged"}}}ready(){super.ready(),this.addEventListener("mousedown",this._onClick.bind(this),!0)}_colorIndexChanged(d){d!=null&&this.style.setProperty("--vaadin-user-tag-color",`var(--vaadin-user-color-${d})`)}_onClick(d){d.preventDefault(),this.dispatchEvent(new CustomEvent("user-tag-click",{bubbles:!0,composed:!0,detail:{name:this.name}}))}}defineCustomElement(UserTag);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const testUserAgent=v=>v.test(navigator.userAgent),testPlatform=v=>v.test(navigator.platform),testVendor=v=>v.test(navigator.vendor),isAndroid=testUserAgent(/Android/u),isChrome=testUserAgent(/Chrome/u)&&testVendor(/Google Inc/u),isFirefox$4=testUserAgent(/Firefox/u),isIPad=testPlatform(/^iPad/u)||testPlatform(/^Mac/u)&&navigator.maxTouchPoints>1,isIPhone=testPlatform(/^iPhone/u),isIOS=isIPhone||isIPad,isSafari=testUserAgent(/^((?!chrome|android).)*safari/iu),isTouch=(()=>{try{return document.createEvent("TouchEvent"),!0}catch{return!1}})();/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let keyboardActive=!1;window.addEventListener("keydown",()=>{keyboardActive=!0},{capture:!0});window.addEventListener("mousedown",()=>{keyboardActive=!1},{capture:!0});function getDeepActiveElement(){let v=document.activeElement||document.body;for(;v.shadowRoot&&v.shadowRoot.activeElement;)v=v.shadowRoot.activeElement;return v}function isKeyboardActive(){return keyboardActive}function isElementHiddenDirectly(v){const d=v.style;if(d.visibility==="hidden"||d.display==="none")return!0;const a=window.getComputedStyle(v);return a.visibility==="hidden"||a.display==="none"}function hasLowerTabOrder(v,d){const a=Math.max(v.tabIndex,0),p=Math.max(d.tabIndex,0);return a===0||p===0?p>a:a>p}function mergeSortByTabIndex(v,d){const a=[];for(;v.length>0&&d.length>0;)hasLowerTabOrder(v[0],d[0])?a.push(d.shift()):a.push(v.shift());return a.concat(v,d)}function sortElementsByTabIndex(v){const d=v.length;if(d<2)return v;const a=Math.ceil(d/2),p=sortElementsByTabIndex(v.slice(0,a)),y=sortElementsByTabIndex(v.slice(a));return mergeSortByTabIndex(p,y)}function isElementHidden(v){return v.checkVisibility?!v.checkVisibility({visibilityProperty:!0}):v.offsetParent===null&&v.clientWidth===0&&v.clientHeight===0?!0:isElementHiddenDirectly(v)}function isElementFocusable(v){return v.matches('[tabindex="-1"]')?!1:v.matches("input, select, textarea, button, object")?v.matches(":not([disabled])"):v.matches("a[href], area[href], iframe, [tabindex], [contentEditable]")}function isElementFocused(v){return v.getRootNode().activeElement===v}function normalizeTabIndex(v){if(!isElementFocusable(v))return-1;const d=v.getAttribute("tabindex")||0;return Number(d)}function collectFocusableNodes(v,d){if(v.nodeType!==Node.ELEMENT_NODE||isElementHiddenDirectly(v))return!1;const a=v,p=normalizeTabIndex(a);let y=p>0;p>=0&&d.push(a);let C=[];return a.localName==="slot"?C=a.assignedNodes({flatten:!0}):C=(a.shadowRoot||a).children,[...C].forEach(P=>{y=collectFocusableNodes(P,d)||y}),y}function getFocusableElements(v){const d=[];return collectFocusableNodes(v,d)?sortElementsByTabIndex(d):d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FocusRestorationController{saveFocus(d){this.focusNode=d||getDeepActiveElement()}restoreFocus(d){const a=this.focusNode;if(!a)return;const p=d?d.preventScroll:!1;getDeepActiveElement()===document.body?setTimeout(()=>a.focus({preventScroll:p})):a.focus({preventScroll:p}),this.focusNode=null}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const instances=[];class FocusTrapController{constructor(d){this.host=d,this.__trapNode=null,this.__onKeyDown=this.__onKeyDown.bind(this)}get __focusableElements(){return getFocusableElements(this.__trapNode)}get __focusedElementIndex(){const d=this.__focusableElements;return d.indexOf(d.filter(isElementFocused).pop())}hostConnected(){document.addEventListener("keydown",this.__onKeyDown)}hostDisconnected(){document.removeEventListener("keydown",this.__onKeyDown)}trapFocus(d){if(this.__trapNode=d,this.__focusableElements.length===0)throw this.__trapNode=null,new Error("The trap node should have at least one focusable descendant or be focusable itself.");instances.push(this),this.__focusedElementIndex===-1&&this.__focusableElements[0].focus({focusVisible:isKeyboardActive()})}releaseFocus(){this.__trapNode=null,instances.pop()}__onKeyDown(d){if(this.__trapNode&&this===Array.from(instances).pop()&&d.key==="Tab"){d.preventDefault();const a=d.shiftKey;this.__focusNextElement(a)}}__focusNextElement(d=!1){const a=this.__focusableElements,p=d?-1:1,y=this.__focusedElementIndex,C=(a.length+y+p)%a.length,P=a[C];P.focus({focusVisible:!0}),P.localName==="input"&&P.select()}}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayFocusMixin=v=>class extends v{static get properties(){return{focusTrap:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!1},restoreFocusNode:{type:HTMLElement}}}constructor(){super(),this.__focusTrapController=new FocusTrapController(this),this.__focusRestorationController=new FocusRestorationController}get _contentRoot(){return this}ready(){super.ready(),this.addController(this.__focusTrapController),this.addController(this.__focusRestorationController)}get _focusTrapRoot(){return this.$.overlay}_resetFocus(){if(this.focusTrap&&this.__focusTrapController.releaseFocus(),this.restoreFocusOnClose&&this._shouldRestoreFocus()){const a=!isKeyboardActive();this.__focusRestorationController.restoreFocus({preventScroll:a})}}_saveFocus(){this.restoreFocusOnClose&&this.__focusRestorationController.saveFocus(this.restoreFocusNode)}_trapFocus(){this.focusTrap&&this.__focusTrapController.trapFocus(this._focusTrapRoot)}_shouldRestoreFocus(){const a=getDeepActiveElement();return a===document.body||this._deepContains(a)}_deepContains(a){if(this._contentRoot.contains(a))return!0;let p=a;const y=a.ownerDocument;for(;p&&p!==y&&p!==this._contentRoot;)p=p.parentNode||p.host;return p===this._contentRoot}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const attachedInstances=new Set,getAttachedInstances=()=>[...attachedInstances].filter(v=>!v.hasAttribute("closing")),hasOnlyNestedOverlays=v=>{const d=getAttachedInstances(),a=d[d.indexOf(v)+1];return a?v._deepContains(a)?hasOnlyNestedOverlays(a):!1:!0},isLastOverlay$1=(v,d=a=>!0)=>{const a=getAttachedInstances().filter(d);return v===a.pop()},OverlayStackMixin=v=>class extends v{get _last(){return isLastOverlay$1(this)}get _isAttached(){return attachedInstances.has(this)}bringToFront(){isLastOverlay$1(this)||hasOnlyNestedOverlays(this)||(this.matches(":popover-open")&&(this.hidePopover(),this.showPopover()),this._removeAttachedInstance(),this._appendAttachedInstance())}_enterModalState(){document.body.style.pointerEvents!=="none"&&(this._previousDocumentPointerEvents=document.body.style.pointerEvents,document.body.style.pointerEvents="none"),getAttachedInstances().forEach(a=>{a!==this&&(a.$.overlay.style.pointerEvents="none")})}_exitModalState(){this._previousDocumentPointerEvents!==void 0&&(document.body.style.pointerEvents=this._previousDocumentPointerEvents,delete this._previousDocumentPointerEvents);const a=getAttachedInstances();let p;for(;(p=a.pop())&&!(p!==this&&(p.$.overlay.style.removeProperty("pointer-events"),!p.modeless)););}_appendAttachedInstance(){attachedInstances.add(this)}_removeAttachedInstance(){this._isAttached&&attachedInstances.delete(this)}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function observeMove(v,d){let a=null;const p=document.documentElement;function y(){a&&a.disconnect(),a=null}function C(P=!1,z=1){y();const{left:L,top:$,width:N,height:W}=v.getBoundingClientRect();if(P||d(),!N||!W)return;const U=Math.floor($),j=Math.floor(p.clientWidth-(L+N)),q=Math.floor(p.clientHeight-($+W)),X=Math.floor(L),Q={rootMargin:`${-U}px ${-j}px ${-q}px ${-X}px`,threshold:Math.max(0,Math.min(1,z))||1};let te=!0;function ne(ie){let ae=ie[0].intersectionRatio;if(ae!==z){if(!te)return C();ae===0&&(ae=1e-7),C(!1,ae)}te=!1}a=new IntersectionObserver(ne,Q),a.observe(v)}return C(!0),y}function setOverlayStateAttribute(v,d,a){const p=[v];v.owner&&p.push(v.owner),typeof a=="string"?p.forEach(y=>{y.setAttribute(d,a)}):a?p.forEach(y=>{y.setAttribute(d,"")}):p.forEach(y=>{y.removeAttribute(d)})}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayMixin=v=>class extends OverlayFocusMixin(OverlayStackMixin(v)){static get properties(){return{opened:{type:Boolean,notify:!0,observer:"_openedChanged",reflectToAttribute:!0,sync:!0},owner:{type:Object,sync:!0},model:{type:Object,sync:!0},renderer:{type:Object,sync:!0},modeless:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_modelessChanged",sync:!0},hidden:{type:Boolean,reflectToAttribute:!0,observer:"_hiddenChanged",sync:!0},withBackdrop:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_withBackdropChanged",sync:!0}}}static get observers(){return["_rendererOrDataChanged(renderer, owner, model, opened)"]}constructor(){super(),this._boundMouseDownListener=this._mouseDownListener.bind(this),this._boundMouseUpListener=this._mouseUpListener.bind(this),this._boundOutsideClickListener=this._outsideClickListener.bind(this),this._boundKeydownListener=this._keydownListener.bind(this),isIOS&&(this._boundIosResizeListener=()=>this._detectIosNavbar())}firstUpdated(){super.firstUpdated(),this.popover="manual",this.addEventListener("click",()=>{}),this.$.backdrop&&this.$.backdrop.addEventListener("click",()=>{}),this.addEventListener("mouseup",()=>{document.activeElement===document.body&&this.$.overlay.getAttribute("tabindex")==="0"&&this.$.overlay.focus()})}connectedCallback(){super.connectedCallback(),this._boundIosResizeListener&&(this._detectIosNavbar(),window.addEventListener("resize",this._boundIosResizeListener))}disconnectedCallback(){super.disconnectedCallback(),this.__scheduledOpen&&(cancelAnimationFrame(this.__scheduledOpen),this.__scheduledOpen=null),this._boundIosResizeListener&&window.removeEventListener("resize",this._boundIosResizeListener)}requestContentUpdate(){this.renderer&&this.renderer.call(this.owner,this._contentRoot,this.owner,this.model)}close(a){const p=new CustomEvent("vaadin-overlay-close",{bubbles:!0,cancelable:!0,detail:{overlay:this,sourceEvent:a}});this.dispatchEvent(p),document.body.dispatchEvent(p),p.defaultPrevented||(this.opened=!1)}setBounds(a,p=!0){const y=this.$.overlay,C={...a};p&&y.style.position!=="absolute"&&(y.style.position="absolute"),Object.keys(C).forEach(P=>{C[P]!==null&&!isNaN(C[P])&&(C[P]=`${C[P]}px`)}),Object.assign(y.style,C)}_detectIosNavbar(){if(!this.opened)return;const a=window.innerHeight,y=window.innerWidth>a,C=document.documentElement.clientHeight;y&&C>a?this.style.setProperty("--vaadin-overlay-viewport-bottom",`${C-a}px`):this.style.setProperty("--vaadin-overlay-viewport-bottom","0")}_shouldAddGlobalListeners(){return!this.modeless}_addGlobalListeners(){this.__hasGlobalListeners||(this.__hasGlobalListeners=!0,document.addEventListener("mousedown",this._boundMouseDownListener),document.addEventListener("mouseup",this._boundMouseUpListener),document.documentElement.addEventListener("click",this._boundOutsideClickListener,!0))}_removeGlobalListeners(){this.__hasGlobalListeners&&(this.__hasGlobalListeners=!1,document.removeEventListener("mousedown",this._boundMouseDownListener),document.removeEventListener("mouseup",this._boundMouseUpListener),document.documentElement.removeEventListener("click",this._boundOutsideClickListener,!0))}_rendererOrDataChanged(a,p,y,C){const P=this._oldOwner!==p||this._oldModel!==y;this._oldModel=y,this._oldOwner=p;const z=this._oldRenderer!==a,L=this._oldRenderer!==void 0;this._oldRenderer=a;const $=this._oldOpened!==C;this._oldOpened=C,z&&L&&(this._contentRoot.innerHTML="",delete this._contentRoot._$litPart$),C&&a&&(z||$||P)&&this.requestContentUpdate()}_modelessChanged(a){this.opened&&(this._shouldAddGlobalListeners()?this._addGlobalListeners():this._removeGlobalListeners()),a?this._exitModalState():this.opened&&this._enterModalState(),setOverlayStateAttribute(this,"modeless",a)}_withBackdropChanged(a){setOverlayStateAttribute(this,"with-backdrop",a)}_openedChanged(a,p){if(a){if(!this.isConnected){this.opened=!1;return}this._saveFocus(),this._animatedOpening(),this.__scheduledOpen=requestAnimationFrame(()=>{setTimeout(()=>{this._trapFocus();const y=new CustomEvent("vaadin-overlay-open",{detail:{overlay:this},bubbles:!0});this.dispatchEvent(y),document.body.dispatchEvent(y)})}),document.addEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._addGlobalListeners()}else p&&(this.__scheduledOpen&&(cancelAnimationFrame(this.__scheduledOpen),this.__scheduledOpen=null),this._resetFocus(),this._animatedClosing(),document.removeEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._removeGlobalListeners())}_hiddenChanged(a){a&&this.hasAttribute("closing")&&this._flushAnimation("closing")}_shouldAnimate(){const a=getComputedStyle(this),p=a.getPropertyValue("animation-name");return!(a.getPropertyValue("display")==="none")&&p&&p!=="none"}_enqueueAnimation(a,p){const y=`__${a}Handler`,C=P=>{P&&P.target!==this||(p(),this.removeEventListener("animationend",C),delete this[y])};this[y]=C,this.addEventListener("animationend",C)}_flushAnimation(a){const p=`__${a}Handler`;typeof this[p]=="function"&&this[p]()}_animatedOpening(){this._isAttached&&this.hasAttribute("closing")&&this._flushAnimation("closing"),this._attachOverlay(),this._appendAttachedInstance(),this.bringToFront(),this.modeless||this._enterModalState(),setOverlayStateAttribute(this,"opening",!0),this._shouldAnimate()?this._enqueueAnimation("opening",()=>{this._finishOpening()}):this._finishOpening()}_attachOverlay(){this.showPopover()}_finishOpening(){setOverlayStateAttribute(this,"opening",!1)}_finishClosing(){this._detachOverlay(),this._removeAttachedInstance(),this.$.overlay.style.removeProperty("pointer-events"),setOverlayStateAttribute(this,"closing",!1),this.dispatchEvent(new CustomEvent("vaadin-overlay-closed"))}_animatedClosing(){this.hasAttribute("opening")&&this._flushAnimation("opening"),this._isAttached&&(this._exitModalState(),setOverlayStateAttribute(this,"closing",!0),this.dispatchEvent(new CustomEvent("vaadin-overlay-closing")),this._shouldAnimate()?this._enqueueAnimation("closing",()=>{this._finishClosing()}):this._finishClosing())}_detachOverlay(){this.hidePopover()}_mouseDownListener(a){this._mouseDownInside=a.composedPath().indexOf(this.$.overlay)>=0}_mouseUpListener(a){this._mouseUpInside=a.composedPath().indexOf(this.$.overlay)>=0}_shouldCloseOnOutsideClick(a){return this._last}_outsideClickListener(a){if(a.composedPath().includes(this.$.overlay)||this._mouseDownInside||this._mouseUpInside){this._mouseDownInside=!1,this._mouseUpInside=!1;return}if(!this._shouldCloseOnOutsideClick(a))return;const p=new CustomEvent("vaadin-overlay-outside-click",{cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(p),this.opened&&!p.defaultPrevented&&this.close(a)}_keydownListener(a){if(this._last&&!(!this._shouldAddGlobalListeners()&&!a.composedPath().includes(this._focusTrapRoot))&&a.key==="Escape"){const p=new CustomEvent("vaadin-overlay-escape-press",{cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(p),this.opened&&!p.defaultPrevented&&this.close(a)}}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getAncestorRootNodes(v){const d=[];for(;v;){if(v.nodeType===Node.DOCUMENT_NODE){d.push(v);break}if(v.nodeType===Node.DOCUMENT_FRAGMENT_NODE){d.push(v),v=v.host;continue}if(v.assignedSlot){v=v.assignedSlot;continue}v=v.parentNode}return d}function getFlattenedElements(v){const d=[];let a;return v.localName==="slot"?a=v.assignedElements():(d.push(v),a=[...v.children]),a.forEach(p=>d.push(...getFlattenedElements(p))),d}function getClosestElement(v,d){return d?d.closest(v)||getClosestElement(v,d.getRootNode().host):null}function deserializeAttributeValue(v){return v?new Set(v.split(" ")):new Set}function serializeAttributeValue(v){return v?[...v].join(" "):""}function addValueToAttribute(v,d,a){const p=deserializeAttributeValue(v.getAttribute(d));p.add(a),v.setAttribute(d,serializeAttributeValue(p))}function removeValueFromAttribute(v,d,a){const p=deserializeAttributeValue(v.getAttribute(d));if(p.delete(a),p.size===0){v.removeAttribute(d);return}v.setAttribute(d,serializeAttributeValue(p))}function isEmptyTextNode(v){return v.nodeType===Node.TEXT_NODE&&v.textContent.trim()===""}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PROP_NAMES_VERTICAL={start:"top",end:"bottom"},PROP_NAMES_HORIZONTAL={start:"left",end:"right"},targetResizeObserver=new ResizeObserver(v=>{setTimeout(()=>{v.forEach(d=>{d.target.__overlay&&d.target.__overlay._updatePosition()})})}),PositionMixin=v=>class extends v{static get properties(){return{positionTarget:{type:Object,value:null,sync:!0},horizontalAlign:{type:String,value:"start",sync:!0},verticalAlign:{type:String,value:"top",sync:!0},noHorizontalOverlap:{type:Boolean,value:!1,sync:!0},noVerticalOverlap:{type:Boolean,value:!1,sync:!0},requiredVerticalSpace:{type:Number,value:0,sync:!0}}}static get observers(){return["__positionSettingsChanged(horizontalAlign, verticalAlign, noHorizontalOverlap, noVerticalOverlap, requiredVerticalSpace)","__overlayOpenedChanged(opened, positionTarget)"]}constructor(){super(),this.__onScroll=this.__onScroll.bind(this),this._updatePosition=this._updatePosition.bind(this)}connectedCallback(){super.connectedCallback(),this.opened&&this.__addUpdatePositionEventListeners()}disconnectedCallback(){super.disconnectedCallback(),this.__removeUpdatePositionEventListeners()}__addUpdatePositionEventListeners(){window.visualViewport.addEventListener("resize",this._updatePosition),window.visualViewport.addEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes=getAncestorRootNodes(this.positionTarget),this.__positionTargetAncestorRootNodes.forEach(a=>{a.addEventListener("scroll",this.__onScroll,!0)}),this.positionTarget&&(this.__observePositionTargetMove=observeMove(this.positionTarget,()=>{this._updatePosition()}))}__removeUpdatePositionEventListeners(){window.visualViewport.removeEventListener("resize",this._updatePosition),window.visualViewport.removeEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes&&(this.__positionTargetAncestorRootNodes.forEach(a=>{a.removeEventListener("scroll",this.__onScroll,!0)}),this.__positionTargetAncestorRootNodes=null),this.__observePositionTargetMove&&(this.__observePositionTargetMove(),this.__observePositionTargetMove=null)}__overlayOpenedChanged(a,p){if(this.__removeUpdatePositionEventListeners(),p&&(p.__overlay=null,targetResizeObserver.unobserve(p),a&&(this.__addUpdatePositionEventListeners(),p.__overlay=this,targetResizeObserver.observe(p))),a){const y=getComputedStyle(this);this.__margins||(this.__margins={},["top","bottom","left","right"].forEach(C=>{this.__margins[C]=parseInt(y[C],10)})),this._updatePosition(),requestAnimationFrame(()=>this._updatePosition())}}__positionSettingsChanged(){this._updatePosition()}__onScroll(a){a.target instanceof Node&&this.contains(a.target)||this._updatePosition()}_updatePosition(){if(!this.positionTarget||!this.opened||!this.__margins)return;const a=this.positionTarget.getBoundingClientRect();if(a.width===0&&a.height===0&&this.opened){this.opened=!1;return}const p=this.__shouldAlignStartVertically(a);this.style.justifyContent=p?"flex-start":"flex-end";const y=this.__isRTL,C=this.__shouldAlignStartHorizontally(a,y),P=!y&&C||y&&!C;this.style.alignItems=P?"flex-start":"flex-end";const z=this.getBoundingClientRect(),L=this.__calculatePositionInOneDimension(a,z,this.noVerticalOverlap,PROP_NAMES_VERTICAL,this,p),$=this.__calculatePositionInOneDimension(a,z,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL,this,C);Object.assign(this.style,L,$),setOverlayStateAttribute(this,"bottom-aligned",!p),setOverlayStateAttribute(this,"top-aligned",p),setOverlayStateAttribute(this,"end-aligned",!P),setOverlayStateAttribute(this,"start-aligned",P)}__shouldAlignStartHorizontally(a,p){const y=Math.max(this.__oldContentWidth||0,this.$.overlay.offsetWidth);this.__oldContentWidth=this.$.overlay.offsetWidth;const C=Math.min(window.innerWidth,document.documentElement.clientWidth),P=!p&&this.horizontalAlign==="start"||p&&this.horizontalAlign==="end";return this.__shouldAlignStart(a,y,C,this.__margins,P,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL)}__shouldAlignStartVertically(a){const p=this.requiredVerticalSpace||Math.max(this.__oldContentHeight||0,this.$.overlay.offsetHeight);this.__oldContentHeight=this.$.overlay.offsetHeight;const y=Math.min(window.innerHeight,document.documentElement.clientHeight),C=this.verticalAlign==="top";return this.__shouldAlignStart(a,p,y,this.__margins,C,this.noVerticalOverlap,PROP_NAMES_VERTICAL)}__shouldAlignStart(a,p,y,C,P,z,L){const $=y-a[z?L.end:L.start]-C[L.end],N=a[z?L.start:L.end]-C[L.start],W=P?$:N,j=W>(P?N:$)||W>p;return P===j}__adjustBottomProperty(a,p,y){let C;if(a===p.end){if(p.end===PROP_NAMES_VERTICAL.end){const P=Math.min(window.innerHeight,document.documentElement.clientHeight);if(y>P&&this.__oldViewportHeight){const z=this.__oldViewportHeight-P;C=y-z}this.__oldViewportHeight=P}if(p.end===PROP_NAMES_HORIZONTAL.end){const P=Math.min(window.innerWidth,document.documentElement.clientWidth);if(y>P&&this.__oldViewportWidth){const z=this.__oldViewportWidth-P;C=y-z}this.__oldViewportWidth=P}}return C}__calculatePositionInOneDimension(a,p,y,C,P,z){const L=z?C.start:C.end,$=z?C.end:C.start,N=parseFloat(P.style[L]||getComputedStyle(P)[L]),W=this.__adjustBottomProperty(L,C,N),U=p[z?C.start:C.end]-a[y===z?C.end:C.start],j=W?`${W}px`:`${N+U*(z?-1:1)}px`;return{[L]:j,[$]:""}}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlayStyles$1=i`
  :host {
    z-index: 200;
    position: fixed;

    /* Despite of what the names say, <vaadin-overlay> is just a container
          for position/sizing/alignment. The actual overlay is the overlay part. */

    /* Default position constraints. Themes can
          override this to adjust the gap between the overlay and the viewport. */
    inset: 8px;
    bottom: var(--vaadin-overlay-viewport-bottom);

    /* Override native [popover] user agent styles */
    width: auto;
    height: auto;
    border: none;
    padding: 0;
    background-color: transparent;
    overflow: visible;

    /* Use flexbox alignment for the overlay part. */
    display: flex;
    flex-direction: column; /* makes dropdowns sizing easier */
    /* Align to center by default. */
    align-items: center;
    justify-content: center;

    /* Allow centering when max-width/max-height applies. */
    margin: auto;

    /* The host is not clickable, only the overlay part is. */
    pointer-events: none;

    /* Remove tap highlight on touch devices. */
    -webkit-tap-highlight-color: transparent;

    /* CSS API for host */
    --vaadin-overlay-viewport-bottom: 8px;
  }

  :host([hidden]),
  :host(:not([opened]):not([closing])),
  :host(:not([opened]):not([closing])) [part='overlay'] {
    display: none !important;
  }

  [part='overlay'] {
    background: var(--vaadin-overlay-background, var(--vaadin-background-color));
    border: var(--vaadin-overlay-border-width, 1px) solid
      var(--vaadin-overlay-border-color, var(--vaadin-border-color-subtle));
    border-radius: var(--vaadin-overlay-border-radius, var(--vaadin-radius-m));
    box-shadow: var(--vaadin-overlay-box-shadow, 0 8px 24px -4px rgba(0, 0, 0, 0.3));
    box-sizing: border-box;
    max-width: 100%;
    overflow: auto;
    overscroll-behavior: contain;
    pointer-events: auto;
    -webkit-tap-highlight-color: initial;
  }

  [part='backdrop'] {
    background: var(--vaadin-overlay-backdrop-background, rgba(0, 0, 0, 0.5));
    content: '';
    inset: 0;
    pointer-events: auto;
    position: fixed;
    z-index: -1;
  }

  [part='overlay']:focus-visible {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      border: 3px solid !important;
    }
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userTagsOverlay=i`
  [part='overlay'] {
    all: initial;
    display: block;
    font: inherit;
    color: inherit;
  }

  [part='content'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--vaadin-user-tag-overlay-gap, 0.2em);
    padding: 0.5em 0;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`,userTagsOverlayStyles=[overlayStyles$1,userTagsOverlay];/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTagsOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1)))))){static get is(){return"vaadin-user-tags-overlay"}static get styles(){return userTagsOverlayStyles}render(){return x`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(UserTagsOverlay);/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */let microtaskCurrHandle=0,microtaskLastHandle=0;const microtaskCallbacks=[];let microtaskScheduled=!1;function microtaskFlush(){microtaskScheduled=!1;const v=microtaskCallbacks.length;for(let d=0;d<v;d++){const a=microtaskCallbacks[d];if(a)try{a()}catch(p){setTimeout(()=>{throw p})}}microtaskCallbacks.splice(0,v),microtaskLastHandle+=v}const timeOut={after(v){return{run(d){return window.setTimeout(d,v)},cancel(d){window.clearTimeout(d)}}},run(v,d){return window.setTimeout(v,d)},cancel(v){window.clearTimeout(v)}},animationFrame={run(v){return window.requestAnimationFrame(v)},cancel(v){window.cancelAnimationFrame(v)}},idlePeriod={run(v){return window.requestIdleCallback?window.requestIdleCallback(v):window.setTimeout(v,16)},cancel(v){window.cancelIdleCallback?window.cancelIdleCallback(v):window.clearTimeout(v)}},microTask={run(v){microtaskScheduled||(microtaskScheduled=!0,queueMicrotask(()=>microtaskFlush())),microtaskCallbacks.push(v);const d=microtaskCurrHandle;return microtaskCurrHandle+=1,d},cancel(v){const d=v-microtaskLastHandle;if(d>=0){if(!microtaskCallbacks[d])throw new Error(`invalid async handle: ${v}`);microtaskCallbacks[d]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const debouncerQueue=new Set;class Debouncer{static debounce(d,a,p){return d instanceof Debouncer?d._cancelAsync():d=new Debouncer,d.setConfig(a,p),d}constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(d,a){this._asyncModule=d,this._callback=a,this._timer=this._asyncModule.run(()=>{this._timer=null,debouncerQueue.delete(this),this._callback()})}cancel(){this.isActive()&&(this._cancelAsync(),debouncerQueue.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return this._timer!=null}}function enqueueDebouncer(v){debouncerQueue.add(v)}function flushDebouncers(){const v=!!debouncerQueue.size;return debouncerQueue.forEach(d=>{try{d.flush()}catch(a){setTimeout(()=>{throw a})}}),v}const flush=()=>{let v;do v=flushDebouncers();while(v)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const listenOnce$1=(v,d)=>new Promise(a=>{const p=()=>{v.removeEventListener(d,p),a()};v.addEventListener(d,p)});class UserTags extends PolylitMixin(i$1){static get is(){return"vaadin-user-tags"}static get styles(){return i`
      :host {
        position: absolute;
      }
    `}render(){return x`
      <vaadin-user-tags-overlay
        id="overlay"
        exportparts="overlay:user-tags-overlay, content:user-tags-content"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      >
        <slot></slot>
      </vaadin-user-tags-overlay>
    `}static get properties(){return{hasFocus:{type:Boolean,value:!1,observer:"_hasFocusChanged"},opened:{type:Boolean,value:!1,sync:!0},flashing:{type:Boolean,value:!1},target:{type:Object,observer:"__targetChanged"},users:{type:Array,value:()=>[]},duration:{type:Number,value:200},delay:{type:Number,value:2e3},__flashQueue:{type:Array,value:()=>[]},__isTargetVisible:{type:Boolean,value:!1}}}constructor(){super(),this.__targetVisibilityObserver=new IntersectionObserver(([d])=>{this.__onTargetVisibilityChange(d.isIntersecting)},{threshold:1})}get wrapper(){return this}connectedCallback(){super.connectedCallback(),this.target&&this.__targetVisibilityObserver.observe(this.target)}disconnectedCallback(){super.disconnectedCallback(),this.opened=!1,this.target&&this.__targetVisibilityObserver.unobserve(this.target)}ready(){super.ready(),this.setAttribute("exportparts","user-tags-overlay, user-tags-content")}__onTargetVisibilityChange(d){if(this.__isTargetVisible=d,d&&this.__flashQueue.length>0&&!this.flashing){this.flashTags(this.__flashQueue.shift());return}if(d&&this.hasFocus){this.opened=!0;return}!d&&this.opened&&(this.opened=!1)}__targetChanged(d,a){this.$.overlay.positionTarget=d,a&&this.__targetVisibilityObserver.unobserve(a),d&&this.__targetVisibilityObserver.observe(d)}_hasFocusChanged(d){d&&this.flashing&&this.stopFlash()}createUserTag(d){const a=document.createElement("vaadin-user-tag");return a.setAttribute("part","user-tag"),a.name=d.name,a.uid=d.id,a.colorIndex=d.colorIndex,a}getTagForUser(d){return Array.from(this.children).find(a=>a.uid===d.id)}getChangedTags(d,a){const p=a.map(C=>this.getTagForUser(C));return{added:d.map(C=>this.getTagForUser(C)||this.createUserTag(C)),removed:p}}applyTagsStart({added:d,removed:a}){a.forEach(p=>{p&&(p.classList.add("removing"),p.classList.remove("show"))}),d.forEach(p=>this.insertBefore(p,this.firstChild))}applyTagsEnd({added:d,removed:a}){a.forEach(p=>{p&&p.parentNode===this&&this.removeChild(p)}),d.forEach(p=>p&&p.classList.add("show"))}setUsers(d){this.requestContentUpdate();let a=[],p=[];const y=Array.isArray(d);if(Array.isArray(this.users)){const z=(d||[]).map(L=>L.id);p=this.users.filter(L=>!z.includes(L.id))}if(y){const z=(this.users||[]).map(L=>L.id);a=d.filter(L=>!z.includes(L.id)).reverse()}if(a.length===0&&p.length===0)return;const P=this.getChangedTags(a,p);if(this.__flashQueue.length>0&&p.forEach((z,L)=>{P.removed[L]!==null&&this.__flashQueue.forEach($=>{$.some(N=>N.uid===z.id)&&(this.__flashQueue=this.__flashQueue.filter((N,W)=>W!==L))})}),this.opened&&this.hasFocus)this.updateTags(d,P);else if(a.length>0&&document.visibilityState!=="hidden"){const z=P.added,L=P.removed;this.updateTagsSync(d,{added:[],removed:L}),this.flashing||!this.__isTargetVisible?this.__flashQueue=[...this.__flashQueue,z]:this.flashTags(z)}else this.updateTagsSync(d,P)}_onOverlayOpen(){Array.from(this.children).forEach(d=>{d.classList.contains("removing")||d.classList.add("show")})}flashTags(d){this.flashing=!0;const a=Array.from(this.children);a.forEach(p=>{p.style.display="none"}),d.forEach(p=>{this.insertBefore(p,this.firstChild)}),this.flashPromise=new Promise(p=>{listenOnce$1(this.$.overlay,"vaadin-overlay-open").then(()=>{this._debounceFlashStart=Debouncer.debounce(this._debounceFlashStart,timeOut.after(this.duration+this.delay),()=>{this.hasFocus||d.forEach(y=>y.classList.remove("show")),this._debounceFlashEnd=Debouncer.debounce(this._debounceFlashEnd,timeOut.after(this.duration),()=>{const y=()=>{a.forEach(C=>{C.style.display="block"}),this.flashing=!1,p()};this.hasFocus?y():(listenOnce$1(this.$.overlay,"animationend").then(()=>{y()}),this.opened=!1)})})})}).then(()=>{if(this.__flashQueue.length>0){const p=this.__flashQueue[0];this.__flashQueue=[...this.__flashQueue].slice(1),this.flashTags(p)}}),this.opened=!0}stopFlash(){this._debounceFlashStart&&this._debounceFlashStart.flush(),this._debounceFlashEnd&&this._debounceFlashEnd.flush(),this.$.overlay._flushAnimation("closing")}updateTags(d,a){this.applyTagsStart(a),this._debounceRender=Debouncer.debounce(this._debounceRender,timeOut.after(this.duration),()=>{this.users=d,this.applyTagsEnd(a),d.length===0&&this.opened&&(this.opened=!1)})}updateTagsSync(d,a){this.applyTagsStart(a),this.users=d,this.applyTagsEnd(a)}show(){this.hasFocus=!0,this.__isTargetVisible&&(this.opened=!0)}hide(){this.hasFocus=!1,this.opened=!1}requestContentUpdate(){this._debounceRender&&this._debounceRender.isActive()&&this._debounceRender.flush()}}defineCustomElement(UserTags);/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const region=document.createElement("div");region.style.position="fixed";region.style.clip="rect(0px, 0px, 0px, 0px)";region.setAttribute("aria-live","polite");document.body.appendChild(region);let alertDebouncer;function announce(v,d={}){const a=d.mode||"polite",p=d.timeout===void 0?150:d.timeout;a==="alert"?(region.removeAttribute("aria-live"),region.removeAttribute("role"),alertDebouncer=Debouncer.debounce(alertDebouncer,animationFrame,()=>{region.setAttribute("role","alert")})):(alertDebouncer&&alertDebouncer.cancel(),region.removeAttribute("role"),region.setAttribute("aria-live",a)),region.textContent="",setTimeout(()=>{region.textContent=v},p)}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getOutlineTarget=(v,d)=>{switch(d){case"vaadin-big-decimal-field":case"vaadin-combo-box":case"vaadin-date-picker":case"vaadin-email-field":case"vaadin-integer-field":case"vaadin-number-field":case"vaadin-password-field":case"vaadin-select":case"vaadin-text-area":case"vaadin-text-field":case"vaadin-time-picker":return v.shadowRoot.querySelector('[part="input-field"]');case"vaadin-checkbox":return v.shadowRoot.querySelector('[part="checkbox"]');case"vaadin-radio-button":return v.shadowRoot.querySelector('[part="radio"]');default:return v}},fields=new WeakMap,initOutline=v=>{if(!fields.has(v)){const d=v.tagName.toLowerCase(),a=getOutlineTarget(v,d);a.style.position="relative",d.endsWith("text-area")&&(a.style.overflow="visible");const p=document.createElement("style");p.textContent=`
      :host(:is([active], [focused])) [part="outline"] {
        display: none;
      }
    `,v.shadowRoot.appendChild(p);const y=document.createElement("vaadin-field-outline");(a===v?v.shadowRoot:a).appendChild(y),y.setAttribute("context",d),fields.set(v,{root:v,target:a,outline:y})}return fields.get(v)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ComponentObserver{constructor(d){this.component=d,this.initTags(d)}getFields(){return[this.component]}getFieldIndex(d){return this.getFields().indexOf(d)}getFocusTarget(d){return this.component}initTags(d){const a=document.createElement("vaadin-user-tags");d.shadowRoot.appendChild(a),a.target=d,this._tags=a,d.addEventListener("mouseenter",p=>{p.relatedTarget!==this._tags.$.overlay&&(this._mouse=!0,this._mouseDebouncer=Debouncer.debounce(this._mouseDebouncer,timeOut.after(200),()=>{this._mouse&&this._tags.show()}))}),d.addEventListener("mouseleave",p=>{p.relatedTarget!==this._tags.$.overlay&&(this._mouse=!1,this._hasFocus||this._tags.hide())}),d.addEventListener("vaadin-highlight-show",p=>{this._hasFocus=!0,this._debouncer&&this._debouncer.isActive()?this._debouncer.cancel():this._tags.show()}),d.addEventListener("vaadin-highlight-hide",p=>{this._hasFocus=!1,this._mouse||(this._debouncer=Debouncer.debounce(this._debouncer,timeOut.after(1),()=>{this._tags.hide()}))}),this._tags.$.overlay.addEventListener("mouseleave",p=>{p.relatedTarget!==d&&(this._mouse=!1,d.hasAttribute("focused")||this._tags.hide())})}setOutlines(d){const a=this.getFields();a.forEach((p,y)=>{const{outline:C}=initOutline(p),P=a.length===1?0:d.map(z=>z.fieldIndex).indexOf(y);C.user=d[P]})}showOutline(d){this.fire("show",d)}hideOutline(d){this.fire("hide",d)}fire(d,a){this.component.dispatchEvent(new CustomEvent(`vaadin-highlight-${d}`,{bubbles:!0,composed:!0,detail:{fieldIndex:this.getFieldIndex(a)}}))}redraw(d){this._tags.setUsers(d),this.setOutlines(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FieldObserver extends ComponentObserver{constructor(d){super(d),this.addListeners(d)}addListeners(d){d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}onFocusIn(d){const a=this.getFocusTarget(d);this.showOutline(a)}onFocusOut(d){const a=this.getFocusTarget(d);this.hideOutline(a)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CheckboxGroupObserver extends FieldObserver{getFields(){return this.component.__checkboxes}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DatePickerObserver extends ComponentObserver{constructor(d){super(d),this.datePicker=d,this.blurWhileOpened=!1,this.addListeners(d)}addListeners(d){this.overlay=d.$.overlay,d.addEventListener("opened-changed",a=>this.onOpenedChanged(a)),this.overlay.addEventListener("focusout",a=>this.onOverlayFocusOut(a)),d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}isEventInOverlay(d){return this.datePicker._overlayContent&&this.datePicker._overlayContent.contains(d)}isFullscreen(){return this.datePicker._noInput&&!isKeyboardActive()}onFocusIn(d){if(!this.isEventInOverlay(d.target)&&!this.isEventInOverlay(d.relatedTarget)){if(this.blurWhileOpened){this.blurWhileOpened=!1;return}this.showOutline(this.datePicker)}}onFocusOut(d){this.isEventInOverlay(d.target)&&this.component.contains(d.relatedTarget)||this.isEventInOverlay(d.relatedTarget)||(this.datePicker.opened?this.blurWhileOpened=!0:this.hideOutline(this.datePicker))}onOverlayFocusOut(d){this.datePicker.contains(d.relatedTarget)||(this.blurWhileOpened=!0)}onOpenedChanged(d){d.detail.value===!0&&this.isFullscreen()&&this.showOutline(this.datePicker),d.detail.value===!1&&this.blurWhileOpened&&(this.blurWhileOpened=!1,this.hideOutline(this.datePicker))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DateObserver extends DatePickerObserver{constructor(d,a){super(d),this.component=a}getFieldIndex(){return 0}}class TimeObserver extends FieldObserver{constructor(d,a){super(d),this.component=a,this.timePicker=d}getFocusTarget(d){return this.timePicker}getFieldIndex(){return 1}}class DateTimePickerObserver extends ComponentObserver{constructor(d){super(d);const[a,p]=this.getFields();this.dateObserver=new DateObserver(a,d),this.timeObserver=new TimeObserver(p,d)}getFields(){return[this.component.querySelector("[slot=date-picker]"),this.component.querySelector("[slot=time-picker]")]}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ListBoxObserver extends FieldObserver{getFields(){return this.component.items||[]}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class RadioGroupObserver extends FieldObserver{getFields(){return this.component.__radioButtons}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SelectObserver extends FieldObserver{constructor(d){super(d),this.overlay=d._overlayElement}onFocusIn(d){this.overlay._contentRoot.contains(d.target)||this.overlay._contentRoot.contains(d.relatedTarget)||super.onFocusIn(d)}onFocusOut(d){this.overlay._contentRoot.contains(d.relatedTarget)||this.overlay._contentRoot.contains(d.target)&&this.component.contains(d.relatedTarget)||super.onFocusOut(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const initFieldObserver=v=>{let d;switch(v.tagName.toLowerCase()){case"vaadin-date-picker":d=new DatePickerObserver(v);break;case"vaadin-date-time-picker":d=new DateTimePickerObserver(v);break;case"vaadin-select":d=new SelectObserver(v);break;case"vaadin-checkbox-group":d=new CheckboxGroupObserver(v);break;case"vaadin-radio-group":d=new RadioGroupObserver(v);break;case"vaadin-list-box":d=new ListBoxObserver(v);break;default:d=new FieldObserver(v)}return d};class FieldHighlighterController{constructor(d){this.host=d,this.user=null,this.users=[]}get user(){return this._user}set user(d){if(this._user=d,d){const a=`${d.name} started editing`,{label:p}=this.host;announce(p?`${a} ${p}`:a)}}hostConnected(){this.redraw()}addUser(d){d&&(this.users.push(d),this.redraw(),this.user=d)}setUsers(d){Array.isArray(d)&&(this.users=d,this.redraw(),this.user=d[d.length-1]||null)}removeUser(d){if(d&&d.id!==void 0){let a;for(let p=0;p<this.users.length;p++)if(this.users[p].id===d.id){a=p;break}a!==void 0&&(this.users.splice(a,1),this.redraw(),this.users.length>0?this.user=this.users[this.users.length-1]:this.user=null)}}redraw(){this.observer.redraw([...this.users].reverse())}}class FieldHighlighter extends HTMLElement{static get is(){return"vaadin-field-highlighter"}static init(d){if(!d._highlighterController){const a=new FieldHighlighterController(d);d.setAttribute("has-highlighter",""),a.observer=initFieldObserver(d),d.addController(a),d._highlighterController=a}return d._highlighterController}static addUser(d,a){this.init(d).addUser(a)}static removeUser(d,a){this.init(d).removeUser(a)}static setUsers(d,a){this.init(d).setUsers(a)}}defineCustomElement(FieldHighlighter);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$j=v=>v,HAS_NATIVE_TA=typeof document.head.style.touchAction=="string",GESTURE_KEY="__polymerGestures",HANDLED_OBJ="__polymerGesturesHandled",TOUCH_ACTION="__polymerGesturesTouchAction",TAP_DISTANCE=25,TRACK_DISTANCE=5,TRACK_LENGTH=2,MOUSE_EVENTS=["mousedown","mousemove","mouseup","click"],MOUSE_WHICH_TO_BUTTONS=[0,1,4,2],MOUSE_HAS_BUTTONS=(function(){try{return new MouseEvent("test",{buttons:1}).buttons===1}catch{return!1}})();function isMouseEvent(v){return MOUSE_EVENTS.indexOf(v)>-1}let supportsPassive=!1;(function(){try{const v=Object.defineProperty({},"passive",{get(){supportsPassive=!0}});window.addEventListener("test",null,v),window.removeEventListener("test",null,v)}catch{}})();function PASSIVE_TOUCH(v){isMouseEvent(v)}const IS_TOUCH_ONLY=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/u),canBeDisabled={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function hasLeftMouseButton(v){const d=v.type;if(!isMouseEvent(d))return!1;if(d==="mousemove"){let p=v.buttons===void 0?1:v.buttons;return v instanceof window.MouseEvent&&!MOUSE_HAS_BUTTONS&&(p=MOUSE_WHICH_TO_BUTTONS[v.which]||0),!!(p&1)}return(v.button===void 0?0:v.button)===0}function isSyntheticClick(v){if(v.type==="click"){if(v.detail===0)return!0;const d=_findOriginalTarget(v);if(!d.nodeType||d.nodeType!==Node.ELEMENT_NODE)return!0;const a=d.getBoundingClientRect(),p=v.pageX,y=v.pageY;return!(p>=a.left&&p<=a.right&&y>=a.top&&y<=a.bottom)}return!1}const POINTERSTATE={touch:{x:0,y:0,id:-1,scrollDecided:!1}};function firstTouchAction(v){let d="auto";const a=getComposedPath(v);for(let p=0,y;p<a.length;p++)if(y=a[p],y[TOUCH_ACTION]){d=y[TOUCH_ACTION];break}return d}function trackDocument(v,d,a){v.movefn=d,v.upfn=a,document.addEventListener("mousemove",d),document.addEventListener("mouseup",a)}function untrackDocument(v){document.removeEventListener("mousemove",v.movefn),document.removeEventListener("mouseup",v.upfn),v.movefn=null,v.upfn=null}const getComposedPath=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:v=>v.composedPath&&v.composedPath()||[],gestures={},recognizers=[];function deepTargetFind(v,d){let a=document.elementFromPoint(v,d),p=a;for(;p&&p.shadowRoot&&!window.ShadyDOM;){const y=p;if(p=p.shadowRoot.elementFromPoint(v,d),y===p)break;p&&(a=p)}return a}function _findOriginalTarget(v){const d=getComposedPath(v);return d.length>0?d[0]:v.target}function _handleNative(v){const d=v.type,p=v.currentTarget[GESTURE_KEY];if(!p)return;const y=p[d];if(!y)return;if(!v[HANDLED_OBJ]&&(v[HANDLED_OBJ]={},d.startsWith("touch"))){const P=v.changedTouches[0];if(d==="touchstart"&&v.touches.length===1&&(POINTERSTATE.touch.id=P.identifier),POINTERSTATE.touch.id!==P.identifier)return;HAS_NATIVE_TA||(d==="touchstart"||d==="touchmove")&&_handleTouchAction(v)}const C=v[HANDLED_OBJ];if(!C.skip){for(let P=0,z;P<recognizers.length;P++)z=recognizers[P],y[z.name]&&!C[z.name]&&z.flow&&z.flow.start.indexOf(v.type)>-1&&z.reset&&z.reset();for(let P=0,z;P<recognizers.length;P++)z=recognizers[P],y[z.name]&&!C[z.name]&&(C[z.name]=!0,z[d](v))}}function _handleTouchAction(v){const d=v.changedTouches[0],a=v.type;if(a==="touchstart")POINTERSTATE.touch.x=d.clientX,POINTERSTATE.touch.y=d.clientY,POINTERSTATE.touch.scrollDecided=!1;else if(a==="touchmove"){if(POINTERSTATE.touch.scrollDecided)return;POINTERSTATE.touch.scrollDecided=!0;const p=firstTouchAction(v);let y=!1;const C=Math.abs(POINTERSTATE.touch.x-d.clientX),P=Math.abs(POINTERSTATE.touch.y-d.clientY);v.cancelable&&(p==="none"?y=!0:p==="pan-x"?y=P>C:p==="pan-y"&&(y=C>P)),y?v.preventDefault():prevent("track")}}function addListener(v,d,a){return gestures[d]?(_add(v,d,a),!0):!1}function removeListener(v,d,a){return gestures[d]?(_remove(v,d,a),!0):!1}function _add(v,d,a){const p=gestures[d],y=p.deps,C=p.name;let P=v[GESTURE_KEY];P||(v[GESTURE_KEY]=P={});for(let z=0,L,$;z<y.length;z++)L=y[z],!(IS_TOUCH_ONLY&&isMouseEvent(L)&&L!=="click")&&($=P[L],$||(P[L]=$={_count:0}),$._count===0&&v.addEventListener(L,_handleNative,PASSIVE_TOUCH(L)),$[C]=($[C]||0)+1,$._count=($._count||0)+1);v.addEventListener(d,a),p.touchAction&&setTouchAction(v,p.touchAction)}function _remove(v,d,a){const p=gestures[d],y=p.deps,C=p.name,P=v[GESTURE_KEY];if(P)for(let z=0,L,$;z<y.length;z++)L=y[z],$=P[L],$&&$[C]&&($[C]=($[C]||1)-1,$._count=($._count||1)-1,$._count===0&&v.removeEventListener(L,_handleNative,PASSIVE_TOUCH(L)));v.removeEventListener(d,a)}function register$1(v){recognizers.push(v),v.emits.forEach(d=>{gestures[d]=v})}function _findRecognizerByEvent(v){for(let d=0,a;d<recognizers.length;d++){a=recognizers[d];for(let p=0,y;p<a.emits.length;p++)if(y=a.emits[p],y===v)return a}return null}function setTouchAction(v,d){HAS_NATIVE_TA&&v instanceof HTMLElement&&microTask.run(()=>{v.style.touchAction=d}),v[TOUCH_ACTION]=d}function _fire(v,d,a){const p=new Event(d,{bubbles:!0,cancelable:!0,composed:!0});if(p.detail=a,wrap$j(v).dispatchEvent(p),p.defaultPrevented){const y=a.preventer||a.sourceEvent;y&&y.preventDefault&&y.preventDefault()}}function prevent(v){const d=_findRecognizerByEvent(v);d.info&&(d.info.prevent=!0)}register$1({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset(){untrackDocument(this.info)},mousedown(v){if(!hasLeftMouseButton(v))return;const d=_findOriginalTarget(v),a=this,p=C=>{hasLeftMouseButton(C)||(downupFire("up",d,C),untrackDocument(a.info))},y=C=>{hasLeftMouseButton(C)&&downupFire("up",d,C),untrackDocument(a.info)};trackDocument(this.info,p,y),downupFire("down",d,v)},touchstart(v){downupFire("down",_findOriginalTarget(v),v.changedTouches[0],v)},touchend(v){downupFire("up",_findOriginalTarget(v),v.changedTouches[0],v)}});function downupFire(v,d,a,p){d&&_fire(d,v,{x:a.clientX,y:a.clientY,sourceEvent:a,preventer:p,prevent(y){return prevent(y)}})}register$1({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove(v){this.moves.length>TRACK_LENGTH&&this.moves.shift(),this.moves.push(v)},movefn:null,upfn:null,prevent:!1},reset(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,untrackDocument(this.info)},mousedown(v){if(!hasLeftMouseButton(v))return;const d=_findOriginalTarget(v),a=this,p=C=>{const P=C.clientX,z=C.clientY;trackHasMovedEnough(a.info,P,z)&&(a.info.state=a.info.started?C.type==="mouseup"?"end":"track":"start",a.info.state==="start"&&prevent("tap"),a.info.addMove({x:P,y:z}),hasLeftMouseButton(C)||(a.info.state="end",untrackDocument(a.info)),d&&trackFire(a.info,d,C),a.info.started=!0)},y=C=>{a.info.started&&p(C),untrackDocument(a.info)};trackDocument(this.info,p,y),this.info.x=v.clientX,this.info.y=v.clientY},touchstart(v){const d=v.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchmove(v){const d=_findOriginalTarget(v),a=v.changedTouches[0],p=a.clientX,y=a.clientY;trackHasMovedEnough(this.info,p,y)&&(this.info.state==="start"&&prevent("tap"),this.info.addMove({x:p,y}),trackFire(this.info,d,a),this.info.state="track",this.info.started=!0)},touchend(v){const d=_findOriginalTarget(v),a=v.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:a.clientX,y:a.clientY}),trackFire(this.info,d,a))}});function trackHasMovedEnough(v,d,a){if(v.prevent)return!1;if(v.started)return!0;const p=Math.abs(v.x-d),y=Math.abs(v.y-a);return p>=TRACK_DISTANCE||y>=TRACK_DISTANCE}function trackFire(v,d,a){if(!d)return;const p=v.moves[v.moves.length-2],y=v.moves[v.moves.length-1],C=y.x-v.x,P=y.y-v.y;let z,L=0;p&&(z=y.x-p.x,L=y.y-p.y),_fire(d,"track",{state:v.state,x:a.clientX,y:a.clientY,dx:C,dy:P,ddx:z,ddy:L,sourceEvent:a,hover(){return deepTargetFind(a.clientX,a.clientY)}})}register$1({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown(v){hasLeftMouseButton(v)&&(this.info.x=v.clientX,this.info.y=v.clientY)},click(v){hasLeftMouseButton(v)&&trackForward(this.info,v)},touchstart(v){const d=v.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchend(v){trackForward(this.info,v.changedTouches[0],v)}});function trackForward(v,d,a){const p=Math.abs(d.clientX-v.x),y=Math.abs(d.clientY-v.y),C=_findOriginalTarget(a||d);!C||canBeDisabled[C.localName]&&C.hasAttribute("disabled")||(isNaN(p)||isNaN(y)||p<=TAP_DISTANCE&&y<=TAP_DISTANCE||isSyntheticClick(d))&&(v.prevent||_fire(C,"tap",{x:d.clientX,y:d.clientY,sourceEvent:d,preventer:a}))}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DisabledMixin=dedupeMixin(v=>class extends v{static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0,sync:!0}}}_disabledChanged(a){this._setAriaDisabled(a)}_setAriaDisabled(a){a?this.setAttribute("aria-disabled","true"):this.removeAttribute("aria-disabled")}click(){this.disabled||super.click()}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardMixin=dedupeMixin(v=>class extends v{ready(){super.ready(),this.addEventListener("keydown",a=>{this._onKeyDown(a)}),this.addEventListener("keyup",a=>{this._onKeyUp(a)})}_onKeyDown(a){switch(a.key){case"Enter":this._onEnter(a);break;case"Escape":this._onEscape(a);break}}_onKeyUp(a){}_onEnter(a){}_onEscape(a){}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ActiveMixin=v=>class extends DisabledMixin(KeyboardMixin(v)){get _activeKeys(){return[" "]}ready(){super.ready(),addListener(this,"down",a=>{this._shouldSetActive(a)&&this._setActive(!0)}),addListener(this,"up",()=>{this._setActive(!1)})}disconnectedCallback(){super.disconnectedCallback(),this._setActive(!1)}_shouldSetActive(a){return!this.disabled}_onKeyDown(a){super._onKeyDown(a),this._shouldSetActive(a)&&this._activeKeys.includes(a.key)&&(this._setActive(!0),document.addEventListener("keyup",p=>{this._activeKeys.includes(p.key)&&this._setActive(!1)},{once:!0}))}_setActive(a){this.toggleAttribute("active",a)}};/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const detailsSummary=(v="vaadin-details-summary")=>i`
  :host {
    align-items: center;
    background: var(--${r$1(v)}-background, transparent);
    background-origin: border-box;
    border: var(--${r$1(v)}-border, none);
    border-radius: var(--${r$1(v)}-border-radius, var(--vaadin-radius-m));
    box-sizing: border-box;
    color: var(--${r$1(v)}-text-color, var(--vaadin-color));
    cursor: var(--vaadin-clickable-cursor);
    display: flex;
    font-size: var(--${r$1(v)}-font-size, inherit);
    font-weight: var(--${r$1(v)}-font-weight, 500);
    gap: var(--${r$1(v)}-gap, 0 var(--vaadin-gap-s));
    height: var(--${r$1(v)}-height, auto);
    outline: calc(var(--vaadin-focus-ring-width) * var(--_focus-ring, 0)) solid var(--vaadin-focus-ring-color);
    outline-offset: 1px;
    padding: var(--${r$1(v)}-padding, var(--vaadin-padding-container));
    -webkit-tap-highlight-color: transparent;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([focus-ring]) {
    --_focus-ring: 1;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='toggle'] {
    color: var(--vaadin-color-subtle);
  }

  @media (prefers-reduced-motion: no-preference) {
    [part='toggle'] {
      transition-property: rotate;
      transition-duration: 150ms;
      animation: delay-initial-transition 1ms;
    }

    @keyframes delay-initial-transition {
      0% {
        rotate: 0deg;
      }
    }
  }

  [part='toggle']::before {
    background: currentColor;
    content: '';
    display: block;
    height: var(--vaadin-icon-size, 1lh);
    mask-image: var(--_vaadin-icon-chevron-down);
    width: var(--vaadin-icon-size, 1lh);
    rotate: -90deg;
  }

  :host([disabled]) {
    opacity: 0.5;
    cursor: var(--vaadin-disabled-cursor);
  }

  :host([dir='rtl']) [part='toggle']::before {
    scale: -1;
  }

  :host([opened]) [part='toggle'] {
    rotate: 90deg;
  }

  :host([dir='rtl'][opened]) [part='toggle'] {
    rotate: -90deg;
  }

  @media (forced-colors: active) {
    [part='toggle']::before {
      background: CanvasText;
    }

    :host([disabled]) {
      color: GrayText;
      opacity: 1;
    }

    :host([disabled]) [part='toggle']::before {
      background: GrayText;
    }
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionHeading=[detailsSummary("vaadin-accordion-heading"),i`
    button {
      align-items: center;
      appearance: none;
      background: transparent;
      border: 0;
      color: inherit;
      cursor: inherit;
      display: flex;
      font: inherit;
      gap: inherit;
      outline: none;
      padding: 0;
      touch-action: manipulation;
    }
  `];/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-accordion-heading"}static get shadowRootOptions(){return{...i$1.shadowRootOptions,delegatesFocus:!0}}static get styles(){return accordionHeading}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0,sync:!0,value:!1}}}render(){return x`
      <button id="button" part="content" ?disabled="${this.disabled}" aria-expanded="${this.opened?"true":"false"}">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","heading")}}defineCustomElement(AccordionHeading);/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionPanel=i`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    box-sizing: border-box;
  }

  :host(:not([opened])) [part='content'] {
    display: none !important;
  }

  :host([focus-ring]) {
    --_focus-ring: 1;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FocusMixin=dedupeMixin(v=>class extends v{get _keyboardActive(){return isKeyboardActive()}ready(){this.addEventListener("focusin",a=>{this._shouldSetFocus(a)&&this._setFocused(!0)}),this.addEventListener("focusout",a=>{this._shouldRemoveFocus(a)&&this._setFocused(!1)}),super.ready()}disconnectedCallback(){super.disconnectedCallback(),this.hasAttribute("focused")&&this._setFocused(!1)}_setFocused(a){this.toggleAttribute("focused",a),this.toggleAttribute("focus-ring",a&&this._keyboardActive)}_shouldSetFocus(a){return!0}_shouldRemoveFocus(a){return!0}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const TabindexMixin=v=>class extends DisabledMixin(v){static get properties(){return{tabindex:{type:Number,reflectToAttribute:!0,observer:"_tabindexChanged",sync:!0},_lastTabIndex:{type:Number}}}_disabledChanged(a,p){super._disabledChanged(a,p),!this.__shouldAllowFocusWhenDisabled()&&(a?(this.tabindex!==void 0&&(this._lastTabIndex=this.tabindex),this.setAttribute("tabindex","-1")):p&&(this._lastTabIndex!==void 0?this.setAttribute("tabindex",this._lastTabIndex):this.tabindex=void 0))}_tabindexChanged(a){this.__shouldAllowFocusWhenDisabled()||this.disabled&&a!==-1&&(this._lastTabIndex=a,this.setAttribute("tabindex","-1"))}focus(){(!this.disabled||this.__shouldAllowFocusWhenDisabled())&&super.focus()}__shouldAllowFocusWhenDisabled(){return!1}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateFocusMixin=dedupeMixin(v=>class extends FocusMixin(TabindexMixin(v)){static get properties(){return{autofocus:{type:Boolean},focusElement:{type:Object,readOnly:!0,observer:"_focusElementChanged",sync:!0},_lastTabIndex:{value:0}}}constructor(){super(),this._boundOnBlur=this._onBlur.bind(this),this._boundOnFocus=this._onFocus.bind(this)}ready(){super.ready(),this.autofocus&&!this.disabled&&requestAnimationFrame(()=>{this.focus(),this.setAttribute("focus-ring","")})}focus(){this.focusElement&&!this.disabled&&this.focusElement.focus()}blur(){this.focusElement&&this.focusElement.blur()}click(){this.focusElement&&!this.disabled&&this.focusElement.click()}_focusElementChanged(a,p){a?(a.disabled=this.disabled,this._addFocusListeners(a),this.__forwardTabIndex(this.tabindex)):p&&this._removeFocusListeners(p)}_addFocusListeners(a){a.addEventListener("blur",this._boundOnBlur),a.addEventListener("focus",this._boundOnFocus)}_removeFocusListeners(a){a.removeEventListener("blur",this._boundOnBlur),a.removeEventListener("focus",this._boundOnFocus)}_onFocus(a){a.stopPropagation(),this.dispatchEvent(new Event("focus"))}_onBlur(a){a.stopPropagation(),this.dispatchEvent(new Event("blur"))}_shouldSetFocus(a){return a.target===this.focusElement}_shouldRemoveFocus(a){return a.target===this.focusElement}_disabledChanged(a,p){super._disabledChanged(a,p),this.focusElement&&(this.focusElement.disabled=a),a&&this.blur()}_tabindexChanged(a){this.__forwardTabIndex(a)}__forwardTabIndex(a){a!==void 0&&this.focusElement&&(this.focusElement.tabIndex=a,a!==-1&&(this.tabindex=void 0)),this.disabled&&a&&(a!==-1&&(this._lastTabIndex=a),this.tabindex=void 0),a===void 0&&this.hasAttribute("tabindex")&&this.removeAttribute("tabindex")}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateStateMixin=dedupeMixin(v=>class extends v{static get properties(){return{stateTarget:{type:Object,observer:"_stateTargetChanged"}}}static get delegateAttrs(){return[]}static get delegateProps(){return[]}ready(){super.ready(),this._createDelegateAttrsObserver(),this._createDelegatePropsObserver()}_stateTargetChanged(a){a&&(this._ensureAttrsDelegated(),this._ensurePropsDelegated())}_createDelegateAttrsObserver(){this._createMethodObserver(`_delegateAttrsChanged(${this.constructor.delegateAttrs.join(", ")})`)}_createDelegatePropsObserver(){this._createMethodObserver(`_delegatePropsChanged(${this.constructor.delegateProps.join(", ")})`)}_ensureAttrsDelegated(){this.constructor.delegateAttrs.forEach(a=>{this._delegateAttribute(a,this[a])})}_ensurePropsDelegated(){this.constructor.delegateProps.forEach(a=>{this._delegateProperty(a,this[a])})}_delegateAttrsChanged(...a){this.constructor.delegateAttrs.forEach((p,y)=>{this._delegateAttribute(p,a[y])})}_delegatePropsChanged(...a){this.constructor.delegateProps.forEach((p,y)=>{this._delegateProperty(p,a[y])})}_delegateAttribute(a,p){this.stateTarget&&(a==="invalid"&&this._delegateAttribute("aria-invalid",p?"true":!1),typeof p=="boolean"?this.stateTarget.toggleAttribute(a,p):p?this.stateTarget.setAttribute(a,p):this.stateTarget.removeAttribute(a))}_delegateProperty(a,p){this.stateTarget&&(this.stateTarget[a]=p)}});/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotObserver{constructor(d,a){this.slot=d,this.callback=a,this._storedNodes=[],this._connected=!1,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){this.slot.addEventListener("slotchange",this._boundSchedule),this._connected=!0}disconnect(){this.slot.removeEventListener("slotchange",this._boundSchedule),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,queueMicrotask(()=>{this.flush()}))}flush(){this._connected&&(this._scheduled=!1,this._processNodes())}_processNodes(){const d=this.slot.assignedNodes({flatten:!0});let a=[];const p=[],y=[];d.length&&(a=d.filter(C=>!this._storedNodes.includes(C))),this._storedNodes.length&&this._storedNodes.forEach((C,P)=>{const z=d.indexOf(C);z===-1?p.push(C):z!==P&&y.push(C)}),(a.length||p.length||y.length)&&this.callback({addedNodes:a,currentNodes:d,movedNodes:y,removedNodes:p}),this._storedNodes=d}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let uniqueId=0;function generateUniqueId(){return uniqueId++}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotController extends EventTarget{static generateId(d,a="default"){return`${a}-${d.localName}-${generateUniqueId()}`}constructor(d,a,p,y={}){super();const{initializer:C,multiple:P,observe:z,useUniqueId:L,uniqueIdPrefix:$}=y;this.host=d,this.slotName=a,this.tagName=p,this.observe=typeof z=="boolean"?z:!0,this.multiple=typeof P=="boolean"?P:!1,this.slotInitializer=C,P&&(this.nodes=[]),L&&(this.defaultId=this.constructor.generateId(d,$||a))}hostConnected(){this.initialized||(this.multiple?this.initMultiple():this.initSingle(),this.observe&&this.observeSlot(),this.initialized=!0)}initSingle(){let d=this.getSlotChild();d?(this.node=d,this.initAddedNode(d)):(d=this.attachDefaultNode(),this.initNode(d))}initMultiple(){const d=this.getSlotChildren();if(d.length===0){const a=this.attachDefaultNode();a&&(this.nodes=[a],this.initNode(a))}else this.nodes=d,d.forEach(a=>{this.initAddedNode(a)})}attachDefaultNode(){const{host:d,slotName:a,tagName:p}=this;let y=this.defaultNode;return!y&&p&&(y=document.createElement(p),y instanceof Element&&(a!==""&&y.setAttribute("slot",a),this.defaultNode=y)),y&&(this.node=y,d.appendChild(y)),y}getSlotChildren(){const{slotName:d}=this;return Array.from(this.host.childNodes).filter(a=>a.nodeType===Node.ELEMENT_NODE&&a.slot===d||a.nodeType===Node.TEXT_NODE&&a.textContent.trim()&&d==="")}getSlotChild(){return this.getSlotChildren()[0]}initNode(d){const{slotInitializer:a}=this;a&&a(d,this.host)}initCustomNode(d){}teardownNode(d){}initAddedNode(d){d!==this.defaultNode&&(this.initCustomNode(d),this.initNode(d))}observeSlot(){const{slotName:d}=this,a=d===""?"slot:not([name])":`slot[name=${d}]`,p=this.host.shadowRoot.querySelector(a);this.__slotObserver=new SlotObserver(p,({addedNodes:y,removedNodes:C})=>{const P=this.multiple?this.nodes:[this.node],z=y.filter(L=>!isEmptyTextNode(L)&&!P.includes(L));C.length&&(this.nodes=P.filter(L=>!C.includes(L)),C.forEach(L=>{this.teardownNode(L)})),z&&z.length>0&&(this.multiple?(this.defaultNode&&this.defaultNode.remove(),this.nodes=[...P,...z].filter(L=>L!==this.defaultNode),z.forEach(L=>{this.initAddedNode(L)})):(this.node&&this.node.remove(),this.node=z[0],this.initAddedNode(this.node)))})}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipController extends SlotController{constructor(d){super(d,"tooltip"),this.setTarget(d)}initCustomNode(d){d.target=this.target,this.ariaTarget!==void 0&&(d.ariaTarget=this.ariaTarget),this.context!==void 0&&(d.context=this.context),this.manual!==void 0&&(d.manual=this.manual),this.opened!==void 0&&(d.opened=this.opened),this.position!==void 0&&(d._position=this.position),this.shouldShow!==void 0&&(d.shouldShow=this.shouldShow),this.__notifyChange()}teardownNode(){this.__notifyChange()}setAriaTarget(d){this.ariaTarget=d;const a=this.node;a&&(a.ariaTarget=d)}setContext(d){this.context=d;const a=this.node;a&&(a.context=d)}setManual(d){this.manual=d;const a=this.node;a&&(a.manual=d)}setOpened(d){this.opened=d;const a=this.node;a&&(a.opened=d)}setPosition(d){this.position=d;const a=this.node;a&&(a._position=d)}setShouldShow(d){this.shouldShow=d;const a=this.node;a&&(a.shouldShow=d)}setTarget(d){this.target=d;const a=this.node;a&&(a.target=d)}__notifyChange(){this.dispatchEvent(new CustomEvent("tooltip-changed",{detail:{node:this.node}}))}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotChildObserveController extends SlotController{constructor(d,a,p,y={}){super(d,a,p,{...y,useUniqueId:!0})}initCustomNode(d){this.__updateNodeId(d),this.__notifyChange(d)}teardownNode(d){const a=this.getSlotChild();a&&a!==this.defaultNode?this.__notifyChange(a):(this.restoreDefaultNode(),this.updateDefaultNode(this.node))}attachDefaultNode(){const d=super.attachDefaultNode();return d&&this.__updateNodeId(d),d}restoreDefaultNode(){}updateDefaultNode(d){this.__notifyChange(d)}observeNode(d){this.__nodeObserver&&this.__nodeObserver.disconnect(),this.__nodeObserver=new MutationObserver(a=>{a.forEach(p=>{const y=p.target,C=y===this.node;p.type==="attributes"?C&&this.__updateNodeId(y):(C||y.parentElement===this.node)&&this.__notifyChange(this.node)})}),this.__nodeObserver.observe(d,{attributes:!0,attributeFilter:["id"],childList:!0,subtree:!0,characterData:!0})}__hasContent(d){return d?d.nodeType===Node.ELEMENT_NODE&&(customElements.get(d.localName)||d.children.length>0)||d.textContent&&d.textContent.trim()!=="":!1}__notifyChange(d){this.dispatchEvent(new CustomEvent("slot-content-changed",{detail:{hasContent:this.__hasContent(d),node:d}}))}__updateNodeId(d){const a=!this.nodes||d===this.nodes[0];d.nodeType===Node.ELEMENT_NODE&&(!this.multiple||a)&&!d.id&&(d.id=this.defaultId)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ContentController extends SlotChildObserveController{static generateId(d){return super.generateId(d,"content")}constructor(d){super(d,"",null,{multiple:!0})}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CollapsibleMixin=v=>class extends v{static get properties(){return{opened:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0},_contentElements:{type:Array}}}static get observers(){return["_openedOrContentChanged(opened, _contentElements)"]}constructor(){super(),this._contentController=new ContentController(this),this._contentController.addEventListener("slot-content-changed",a=>{const p=a.target.nodes||[];this._contentElements=p.filter(y=>y.parentNode===this)})}ready(){super.ready(),this.addController(this._contentController),this.addEventListener("click",({target:a})=>{if(this.disabled||a.localName==="a")return;const p=this.focusElement;p&&(a===p||p.contains(a))&&(this.opened=!this.opened)})}_openedOrContentChanged(a,p){p&&p.forEach(y=>{y.setAttribute("aria-hidden",a?"false":"true")})}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SummaryController extends SlotChildObserveController{constructor(d,a){super(d,"summary",a)}setSummary(d){this.summary=d,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{summary:d}=this;d&&d.trim()!==""&&this.attachDefaultNode()}updateDefaultNode(d){d&&(d.textContent=this.summary),super.updateDefaultNode(d)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionPanelMixin=v=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(v))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaAttributes(focusElement, _contentElements)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-accordion-heading"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:p}=a.target;this._setFocusElement(p),this.stateTarget=p,this._tooltipController.setTarget(p)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}__forwardTabIndex(a){super.__forwardTabIndex(a),a!==void 0&&this.focusElement&&(this.focusElement.$.button.tabIndex=a,this.focusElement.tabIndex=-1)}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,p){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",p);return}super._delegateProperty(a,p)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaAttributes(a,p){if(a&&p){const y=p[0];y&&(y.setAttribute("role","region"),y.setAttribute("aria-labelledby",a.id)),y&&y.id?a.setAttribute("aria-controls",y.id):a.removeAttribute("aria-controls")}}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AccordionPanel extends AccordionPanelMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1)))){static get is(){return"vaadin-accordion-panel"}static get styles(){return accordionPanel}render(){return x`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}}defineCustomElement(AccordionPanel);const DEV_MODE_CODE_REGEXP=/\/\*[\*!]\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,FlowClients=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function isMinified(){function v(){return!0}return uncommentAndRun(v)}function isDevelopmentMode(){try{return isForcedDevelopmentMode()?!0:isLocalhost()?FlowClients?!isFlowProductionMode():!isMinified():!1}catch{return!1}}function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}function isFlowProductionMode(){return!!(FlowClients&&Object.keys(FlowClients).map(d=>FlowClients[d]).filter(d=>d.productionMode).length>0)}function uncommentAndRun(v,d){if(typeof v!="function")return;const a=DEV_MODE_CODE_REGEXP.exec(v.toString());if(a)try{v=new Function(a[1])}catch(p){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",p)}return v(d)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(v,d){if(window.Vaadin.developmentMode)return uncommentAndRun(v,d)};window.Vaadin.developmentMode===void 0&&(window.Vaadin.developmentMode=isDevelopmentMode());function maybeGatherAndSendStats(){/*! vaadin-dev-mode:start
  (function () {
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

var getPolymerVersion = function getPolymerVersion() {
  return window.Polymer && window.Polymer.version;
};

var StatisticsGatherer = function () {
  function StatisticsGatherer(logger) {
    classCallCheck(this, StatisticsGatherer);

    this.now = new Date().getTime();
    this.logger = logger;
  }

  createClass(StatisticsGatherer, [{
    key: 'frameworkVersionDetectors',
    value: function frameworkVersionDetectors() {
      return {
        'Flow': function Flow() {
          if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {
            var flowVersions = Object.keys(window.Vaadin.Flow.clients).map(function (key) {
              return window.Vaadin.Flow.clients[key];
            }).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().flow;
            });
            if (flowVersions.length > 0) {
              return flowVersions[0];
            }
          }
        },
        'Vaadin Framework': function VaadinFramework() {
          if (window.vaadin && window.vaadin.clients) {
            var frameworkVersions = Object.values(window.vaadin.clients).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().vaadinVersion;
            });
            if (frameworkVersions.length > 0) {
              return frameworkVersions[0];
            }
          }
        },
        'AngularJs': function AngularJs() {
          if (window.angular && window.angular.version && window.angular.version) {
            return window.angular.version.full;
          }
        },
        'Angular': function Angular() {
          if (window.ng) {
            var tags = document.querySelectorAll("[ng-version]");
            if (tags.length > 0) {
              return tags[0].getAttribute("ng-version");
            }
            return "Unknown";
          }
        },
        'Backbone.js': function BackboneJs() {
          if (window.Backbone) {
            return window.Backbone.VERSION;
          }
        },
        'React': function React() {
          var reactSelector = '[data-reactroot], [data-reactid]';
          if (!!document.querySelector(reactSelector)) {
            // React does not publish the version by default
            return "unknown";
          }
        },
        'Ember': function Ember() {
          if (window.Em && window.Em.VERSION) {
            return window.Em.VERSION;
          } else if (window.Ember && window.Ember.VERSION) {
            return window.Ember.VERSION;
          }
        },
        'jQuery': function (_jQuery) {
          function jQuery() {
            return _jQuery.apply(this, arguments);
          }

          jQuery.toString = function () {
            return _jQuery.toString();
          };

          return jQuery;
        }(function () {
          if (typeof jQuery === 'function' && jQuery.prototype.jquery !== undefined) {
            return jQuery.prototype.jquery;
          }
        }),
        'Polymer': function Polymer() {
          var version = getPolymerVersion();
          if (version) {
            return version;
          }
        },
        'LitElement': function LitElement() {
          var version = window.litElementVersions && window.litElementVersions[0];
          if (version) {
            return version;
          }
        },
        'LitHtml': function LitHtml() {
          var version = window.litHtmlVersions && window.litHtmlVersions[0];
          if (version) {
            return version;
          }
        },
        'Vue.js': function VueJs() {
          if (window.Vue) {
            return window.Vue.version;
          }
        }
      };
    }
  }, {
    key: 'getUsedVaadinElements',
    value: function getUsedVaadinElements(elements) {
      var version = getPolymerVersion();
      var elementClasses = void 0;
      // NOTE: In case you edit the code here, YOU MUST UPDATE any statistics reporting code in Flow.
      // Check all locations calling the method getEntries() in
      // https://github.com/vaadin/flow/blob/master/flow-server/src/main/java/com/vaadin/flow/internal/UsageStatistics.java#L106
      // Currently it is only used by BootstrapHandler.
      if (version && version.indexOf('2') === 0) {
        // Polymer 2: components classes are stored in window.Vaadin
        elementClasses = Object.keys(window.Vaadin).map(function (c) {
          return window.Vaadin[c];
        }).filter(function (c) {
          return c.is;
        });
      } else {
        // Polymer 3: components classes are stored in window.Vaadin.registrations
        elementClasses = window.Vaadin.registrations || [];
      }
      elementClasses.forEach(function (klass) {
        var version = klass.version ? klass.version : "0.0.0";
        elements[klass.is] = { version: version };
      });
    }
  }, {
    key: 'getUsedVaadinThemes',
    value: function getUsedVaadinThemes(themes) {
      ['Lumo', 'Material'].forEach(function (themeName) {
        var theme;
        var version = getPolymerVersion();
        if (version && version.indexOf('2') === 0) {
          // Polymer 2: themes are stored in window.Vaadin
          theme = window.Vaadin[themeName];
        } else {
          // Polymer 3: themes are stored in custom element registry
          theme = customElements.get('vaadin-' + themeName.toLowerCase() + '-styles');
        }
        if (theme && theme.version) {
          themes[themeName] = { version: theme.version };
        }
      });
    }
  }, {
    key: 'getFrameworks',
    value: function getFrameworks(frameworks) {
      var detectors = this.frameworkVersionDetectors();
      Object.keys(detectors).forEach(function (framework) {
        var detector = detectors[framework];
        try {
          var version = detector();
          if (version) {
            frameworks[framework] = { version: version };
          }
        } catch (e) {}
      });
    }
  }, {
    key: 'gather',
    value: function gather(storage) {
      var storedStats = storage.read();
      var gatheredStats = {};
      var types = ["elements", "frameworks", "themes"];

      types.forEach(function (type) {
        gatheredStats[type] = {};
        if (!storedStats[type]) {
          storedStats[type] = {};
        }
      });

      var previousStats = JSON.stringify(storedStats);

      this.getUsedVaadinElements(gatheredStats.elements);
      this.getFrameworks(gatheredStats.frameworks);
      this.getUsedVaadinThemes(gatheredStats.themes);

      var now = this.now;
      types.forEach(function (type) {
        var keys = Object.keys(gatheredStats[type]);
        keys.forEach(function (key) {
          if (!storedStats[type][key] || _typeof(storedStats[type][key]) != _typeof({})) {
            storedStats[type][key] = { firstUsed: now };
          }
          // Discards any previously logged version number
          storedStats[type][key].version = gatheredStats[type][key].version;
          storedStats[type][key].lastUsed = now;
        });
      });

      var newStats = JSON.stringify(storedStats);
      storage.write(newStats);
      if (newStats != previousStats && Object.keys(storedStats).length > 0) {
        this.logger.debug("New stats: " + newStats);
      }
    }
  }]);
  return StatisticsGatherer;
}();

var StatisticsStorage = function () {
  function StatisticsStorage(key) {
    classCallCheck(this, StatisticsStorage);

    this.key = key;
  }

  createClass(StatisticsStorage, [{
    key: 'read',
    value: function read() {
      var localStorageStatsString = localStorage.getItem(this.key);
      try {
        return JSON.parse(localStorageStatsString ? localStorageStatsString : '{}');
      } catch (e) {
        return {};
      }
    }
  }, {
    key: 'write',
    value: function write(data) {
      localStorage.setItem(this.key, data);
    }
  }, {
    key: 'clear',
    value: function clear() {
      localStorage.removeItem(this.key);
    }
  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      var storedStats = this.read();
      var empty = true;
      Object.keys(storedStats).forEach(function (key) {
        if (Object.keys(storedStats[key]).length > 0) {
          empty = false;
        }
      });

      return empty;
    }
  }]);
  return StatisticsStorage;
}();

var StatisticsSender = function () {
  function StatisticsSender(url, logger) {
    classCallCheck(this, StatisticsSender);

    this.url = url;
    this.logger = logger;
  }

  createClass(StatisticsSender, [{
    key: 'send',
    value: function send(data, errorHandler) {
      var logger = this.logger;

      if (navigator.onLine === false) {
        logger.debug("Offline, can't send");
        errorHandler();
        return;
      }
      logger.debug("Sending data to " + this.url);

      var req = new XMLHttpRequest();
      req.withCredentials = true;
      req.addEventListener("load", function () {
        // Stats sent, nothing more to do
        logger.debug("Response: " + req.responseText);
      });
      req.addEventListener("error", function () {
        logger.debug("Send failed");
        errorHandler();
      });
      req.addEventListener("abort", function () {
        logger.debug("Send aborted");
        errorHandler();
      });
      req.open("POST", this.url);
      req.setRequestHeader("Content-Type", "application/json");
      req.send(data);
    }
  }]);
  return StatisticsSender;
}();

var StatisticsLogger = function () {
  function StatisticsLogger(id) {
    classCallCheck(this, StatisticsLogger);

    this.id = id;
  }

  createClass(StatisticsLogger, [{
    key: '_isDebug',
    value: function _isDebug() {
      return localStorage.getItem("vaadin." + this.id + ".debug");
    }
  }, {
    key: 'debug',
    value: function debug(msg) {
      if (this._isDebug()) {
        console.info(this.id + ": " + msg);
      }
    }
  }]);
  return StatisticsLogger;
}();

var UsageStatistics = function () {
  function UsageStatistics() {
    classCallCheck(this, UsageStatistics);

    this.now = new Date();
    this.timeNow = this.now.getTime();
    this.gatherDelay = 10; // Delay between loading this file and gathering stats
    this.initialDelay = 24 * 60 * 60;

    this.logger = new StatisticsLogger("statistics");
    this.storage = new StatisticsStorage("vaadin.statistics.basket");
    this.gatherer = new StatisticsGatherer(this.logger);
    this.sender = new StatisticsSender("https://tools.vaadin.com/usage-stats/submit", this.logger);
  }

  createClass(UsageStatistics, [{
    key: 'maybeGatherAndSend',
    value: function maybeGatherAndSend() {
      var _this = this;

      if (localStorage.getItem(UsageStatistics.optOutKey)) {
        return;
      }
      this.gatherer.gather(this.storage);
      setTimeout(function () {
        _this.maybeSend();
      }, this.gatherDelay * 1000);
    }
  }, {
    key: 'lottery',
    value: function lottery() {
      return true;
    }
  }, {
    key: 'currentMonth',
    value: function currentMonth() {
      return this.now.getYear() * 12 + this.now.getMonth();
    }
  }, {
    key: 'maybeSend',
    value: function maybeSend() {
      var firstUse = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      var monthProcessed = Number(localStorage.getItem(UsageStatistics.monthProcessedKey));

      if (!firstUse) {
        // Use a grace period to avoid interfering with tests, incognito mode etc
        firstUse = this.timeNow;
        localStorage.setItem(UsageStatistics.firstUseKey, firstUse);
      }

      if (this.timeNow < firstUse + this.initialDelay * 1000) {
        this.logger.debug("No statistics will be sent until the initial delay of " + this.initialDelay + "s has passed");
        return;
      }
      if (this.currentMonth() <= monthProcessed) {
        this.logger.debug("This month has already been processed");
        return;
      }
      localStorage.setItem(UsageStatistics.monthProcessedKey, this.currentMonth());
      // Use random sampling
      if (this.lottery()) {
        this.logger.debug("Congratulations, we have a winner!");
      } else {
        this.logger.debug("Sorry, no stats from you this time");
        return;
      }

      this.send();
    }
  }, {
    key: 'send',
    value: function send() {
      // Ensure we have the latest data
      this.gatherer.gather(this.storage);

      // Read, send and clean up
      var data = this.storage.read();
      data["firstUse"] = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      data["usageStatisticsVersion"] = UsageStatistics.version;
      var info = 'This request contains usage statistics gathered from the application running in development mode. \n\nStatistics gathering is automatically disabled and excluded from production builds.\n\nFor details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.\n\n\n\n';
      var self = this;
      this.sender.send(info + JSON.stringify(data), function () {
        // Revert the 'month processed' flag
        localStorage.setItem(UsageStatistics.monthProcessedKey, self.currentMonth() - 1);
      });
    }
  }], [{
    key: 'version',
    get: function get$1() {
      return '2.1.2';
    }
  }, {
    key: 'firstUseKey',
    get: function get$1() {
      return 'vaadin.statistics.firstuse';
    }
  }, {
    key: 'monthProcessedKey',
    get: function get$1() {
      return 'vaadin.statistics.monthProcessed';
    }
  }, {
    key: 'optOutKey',
    get: function get$1() {
      return 'vaadin.statistics.optout';
    }
  }]);
  return UsageStatistics;
}();

try {
  window.Vaadin = window.Vaadin || {};
  window.Vaadin.usageStatsChecker = window.Vaadin.usageStatsChecker || new UsageStatistics();
  window.Vaadin.usageStatsChecker.maybeGatherAndSend();
} catch (e) {
  // Intentionally ignored as this is not a problem in the app being developed
}

}());

  vaadin-dev-mode:end **/}const usageStatistics=function(){if(typeof runIfDevelopmentMode=="function")return runIfDevelopmentMode(maybeGatherAndSendStats)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */window.Vaadin||(window.Vaadin={});window.Vaadin.registrations||(window.Vaadin.registrations=[]);window.Vaadin.developmentModeCallback||(window.Vaadin.developmentModeCallback={});window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]=function(){usageStatistics()};let statsJob;const registered=new Set,ElementMixin=v=>class extends DirMixin(v){static finalize(){super.finalize();const{is:a}=this;if(a&&!registered.has(a)){window.Vaadin.registrations.push(this),registered.add(a);const p=window.Vaadin.developmentModeCallback;p&&(statsJob=Debouncer.debounce(statsJob,idlePeriod,()=>{p["vaadin-usage-statistics"]()}),enqueueDebouncer(statsJob))}}constructor(){super(),document.doctype===null&&console.warn('Vaadin components require the "standards mode" declaration. Please add <!DOCTYPE html> to the HTML document.')}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardDirectionMixin=v=>class extends KeyboardMixin(v){get focused(){return(this._getItems()||[]).find(isElementFocused)}get _vertical(){return!0}get _tabNavigation(){return!1}focus(){const a=this._getItems();if(Array.isArray(a)){const p=this._getAvailableIndex(a,0,null,y=>!isElementHidden(y));p>=0&&this._focus(p)}}_getItems(){return Array.from(this.children)}_onKeyDown(a){if(super._onKeyDown(a),a.metaKey||a.ctrlKey)return;const{key:p,shiftKey:y}=a,C=this._getItems()||[],P=C.indexOf(this.focused);let z,L;const N=!this._vertical&&this.getAttribute("dir")==="rtl"?-1:1;this.__isPrevKeyPressed(p,y)?(L=-N,z=P-N):this.__isNextKeyPressed(p,y)?(L=N,z=P+N):p==="Home"?(L=1,z=0):p==="End"&&(L=-1,z=C.length-1),z=this._getAvailableIndex(C,z,L,W=>!isElementHidden(W)),!(this._tabNavigation&&p==="Tab"&&(z>P&&a.shiftKey||z<P&&!a.shiftKey))&&z>=0&&(a.preventDefault(),this._focus(z,!0))}__isPrevKeyPressed(a,p){return this._vertical?a==="ArrowUp":a==="ArrowLeft"||this._tabNavigation&&a==="Tab"&&p}__isNextKeyPressed(a,p){return this._vertical?a==="ArrowDown":a==="ArrowRight"||this._tabNavigation&&a==="Tab"&&!p}_focus(a,p=!1){const y=this._getItems();this._focusItem(y[a],p)}_focusItem(a){a&&(a.focus(),a.setAttribute("focus-ring",""))}_getAvailableIndex(a,p,y,C){const P=a.length;let z=p;for(let L=0;typeof z=="number"&&L<P;L+=1,z+=y||1){z<0?z=P-1:z>=P&&(z=0);const $=a[z];if(this._isItemFocusable($)&&this.__isMatchingItem($,C))return z}return-1}__isMatchingItem(a,p){return typeof p=="function"?p(a):!0}_isItemFocusable(a){return!a.hasAttribute("disabled")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionMixin=v=>class extends KeyboardDirectionMixin(v){static get properties(){return{opened:{type:Number,value:0,notify:!0,reflectToAttribute:!0},items:{type:Array,readOnly:!0,notify:!0}}}static get observers(){return["_updateItems(items, opened)"]}constructor(){super(),this._boundUpdateOpened=this._updateOpened.bind(this)}get focused(){return(this._getItems()||[]).find(a=>isElementFocused(a.focusElement))}focus(){this._observer&&this._observer.flush(),super.focus()}ready(){super.ready();const a=this.shadowRoot.querySelector("slot");this._observer=new SlotObserver(a,p=>{this._setItems(this._filterItems(Array.from(this.children))),this._filterItems(p.addedNodes).forEach(y=>{y.addEventListener("opened-changed",this._boundUpdateOpened)})})}_getItems(){return this.items}_filterItems(a){return a.filter(p=>p instanceof customElements.get("vaadin-accordion-panel"))}_updateItems(a,p){if(a){this.__itemsSync=!0;const y=a[p];a.forEach(C=>{C.opened=C===y}),this.__itemsSync=!1}}_onKeyDown(a){this.items.some(p=>p.focusElement===a.target)&&super._onKeyDown(a)}_updateOpened(a){if(this.__itemsSync)return;const p=this._filterItems(a.composedPath())[0],y=this.items.indexOf(p);if(a.detail.value){if(p.disabled||y===-1)return;this.opened=y}else this.items.some(C=>C.opened)||(this.opened=null)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolylitMixin(i$1)))){static get is(){return"vaadin-accordion"}static get styles(){return i`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `}render(){return x`<slot></slot>`}}defineCustomElement(Accordion);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const INTERACTION_EVENTS=["mousedown","mouseup","click","dblclick","keypress","keydown","keyup"],ButtonMixin=v=>class extends ActiveMixin(TabindexMixin(FocusMixin(v))){constructor(){super(),this.__onInteractionEvent=this.__onInteractionEvent.bind(this),INTERACTION_EVENTS.forEach(a=>{this.addEventListener(a,this.__onInteractionEvent,!0)}),this.tabindex=0}get _activeKeys(){return["Enter"," "]}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","button"),this.__shouldAllowFocusWhenDisabled()&&this.style.setProperty("--_vaadin-button-disabled-pointer-events","auto")}_onKeyDown(a){super._onKeyDown(a),!(a.altKey||a.shiftKey||a.ctrlKey||a.metaKey)&&this._activeKeys.includes(a.key)&&(a.preventDefault(),this.click())}__onInteractionEvent(a){this.__shouldSuppressInteractionEvent(a)&&a.stopImmediatePropagation()}__shouldSuppressInteractionEvent(a){return this.disabled}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DetailsSummary extends ButtonMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-details-summary"}static get styles(){return detailsSummary()}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0}}}render(){return x`
      <span part="toggle" aria-hidden="true"></span>
      <div part="content"><slot></slot></div>
    `}}defineCustomElement(DetailsSummary);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DetailsBaseMixin=v=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(v))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaControls(focusElement, _contentElements)","__updateAriaExpanded(focusElement, opened)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-details-summary"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:p}=a.target;this._setFocusElement(p),this.stateTarget=p,this._tooltipController.setTarget(p)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,p){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",p);return}super._delegateProperty(a,p)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaControls(a,p){if(a&&p){const y=p[0];y&&y.id?a.setAttribute("aria-controls",y.id):a.removeAttribute("aria-controls")}}__updateAriaExpanded(a,p){a&&a.setAttribute("aria-expanded",p?"true":"false")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Details extends DetailsBaseMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-details"}static get styles(){return i`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }

      [part='content'] {
        display: none;
      }

      :host([opened]) [part='content'] {
        display: block;
      }
    `}static get lumoInjector(){return{includeBaseStyles:!0}}render(){return x`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}}defineCustomElement(Details);/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function _detectIosNavbar(){if(isIOS){const v=window.innerHeight,a=window.innerWidth>v,p=document.documentElement.clientHeight;a&&p>v?document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom",`${p-v}px`):document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom","")}}_detectIosNavbar();window.addEventListener("resize",_detectIosNavbar);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$4=document.createElement("template");template$4.innerHTML=`
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;document.head.appendChild(template$4.content);/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const appLayoutStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition-duration: 0s;
    transition: padding var(--vaadin-app-layout-transition-duration);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, auto);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  @media (prefers-reduced-motion: no-preference) {
    :host(:not([no-anim])) {
      --vaadin-app-layout-transition-duration: 200ms;
    }
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition-duration);
    padding-top: max(var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s)), var(--safe-area-inset-top));
    padding-bottom: var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s));
    padding-inline-start: max(
      var(--vaadin-app-layout-navbar-padding-inline-start, var(--vaadin-padding-s)),
      var(--safe-area-inset-left)
    );
    /* stylelint-disable-next-line declaration-block-no-redundant-longhand-properties */
    padding-inline-end: max(
      var(--vaadin-app-layout-navbar-padding-inline-end, var(--vaadin-padding-s)),
      var(--safe-area-inset-right)
    );
    z-index: 1;
    gap: var(--vaadin-app-layout-navbar-gap, var(--vaadin-gap-s));
    background: var(--vaadin-app-layout-navbar-background, var(--vaadin-background-container));
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-top: var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s));
    padding-bottom: max(
      var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s)),
      var(--safe-area-inset-bottom)
    );
  }

  [part='drawer'] {
    overflow: auto;
    overscroll-behavior: contain;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition-duration),
      visibility var(--vaadin-app-layout-transition-duration);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
    background: var(--vaadin-app-layout-drawer-background, transparent);
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background: var(--vaadin-overlay-backdrop-background, rgba(0, 0, 0, 0.5));
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0 !important;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition-duration);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
    box-shadow: var(--vaadin-overlay-box-shadow, 0 8px 24px -4px rgba(0, 0, 0, 0.3));
    background: var(--vaadin-app-layout-drawer-background, var(--vaadin-background-color));
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 320px);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }

  @media (forced-colors: active) {
    :host([overlay]) [part='drawer'] {
      border: 3px solid;
    }
  }
`;/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */let counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={},lockCount=0;const isElement=v=>v&&v.nodeType===Node.ELEMENT_NODE,logError=(...v)=>{console.error(`Error: ${v.join(" ")}. Skip setting aria-hidden.`)},correctTargets=(v,d)=>isElement(v)?d.map(a=>{if(!isElement(a))return logError(a,"is not a valid element"),null;let p=a;for(;p&&p!==v;){if(v.contains(p))return a;p=p.getRootNode().host}return logError(a,"is not contained inside",v),null}).filter(a=>!!a):(logError(v,"is not a valid element"),[]),applyAttributeToOthers=(v,d,a,p)=>{const y=correctTargets(d,Array.isArray(v)?v:[v]);markerMap[a]||(markerMap[a]=new WeakMap);const C=markerMap[a],P=[],z=new Set,L=new Set(y),$=W=>{if(!W||z.has(W))return;z.add(W);const U=W.assignedSlot;U&&$(U),$(W.parentNode||W.host)};y.forEach($);const N=W=>{if(!W||L.has(W))return;const U=W.shadowRoot;(U?[...W.children,...U.children]:[...W.children]).forEach(q=>{if(!["template","script","style"].includes(q.localName))if(z.has(q))N(q);else{const X=q.getAttribute(p),K=X!==null&&X!=="false",Q=(counterMap.get(q)||0)+1,te=(C.get(q)||0)+1;counterMap.set(q,Q),C.set(q,te),P.push(q),Q===1&&K&&uncontrolledNodes.set(q,!0),te===1&&q.setAttribute(a,"true"),K||q.setAttribute(p,"true")}})};return N(d),z.clear(),lockCount+=1,()=>{P.forEach(W=>{const U=counterMap.get(W)-1,j=C.get(W)-1;counterMap.set(W,U),C.set(W,j),U||(uncontrolledNodes.has(W)?uncontrolledNodes.delete(W):W.removeAttribute(p)),j||W.removeAttribute(a)}),lockCount-=1,lockCount||(counterMap=new WeakMap,counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={})}},hideOthers=(v,d=document.body,a="data-aria-hidden")=>{const p=Array.from(Array.isArray(v)?v:[v]);return d&&p.push(...Array.from(d.querySelectorAll("[aria-live]"))),applyAttributeToOthers(p,d,a,"aria-hidden")};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AriaModalController{constructor(d,a){this.host=d,this.callback=typeof a=="function"?a:()=>d}showModal(){const d=this.callback();this.__showOthers=hideOthers(d)}close(){this.__showOthers&&(this.__showOthers(),this.__showOthers=null)}}/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function deepMerge$1(v,...d){const a=C=>Array.isArray(C),p=C=>C&&typeof C=="object"&&!a(C),y=(C,P)=>{p(P)&&p(C)&&Object.keys(P).forEach(z=>{const L=P[z];p(L)?(C[z]||(C[z]={}),y(C[z],L)):a(L)?C[z]=[...L]:L!=null&&(C[z]=L)})};return d.forEach(C=>{y(v,C)}),v}const I18nMixin=(v,d)=>class extends d{static get properties(){return{i18n:{type:Object},__effectiveI18n:{type:Object,sync:!0}}}constructor(){super(),this.i18n=deepMerge$1({},v)}get i18n(){return this.__customI18n}set i18n(p){p!==this.__customI18n&&(this.__customI18n=p,this.__effectiveI18n=deepMerge$1({},v,this.__customI18n))}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$a={drawer:"Drawer"},AppLayoutMixin=v=>class extends I18nMixin(DEFAULT_I18N$a,v){static get properties(){return{primarySection:{type:String,value:"navbar",notify:!0,reflectToAttribute:!0,observer:"__primarySectionChanged",sync:!0},drawerOpened:{type:Boolean,notify:!0,value:!0,reflectToAttribute:!0,observer:"__drawerOpenedChanged",sync:!0},overlay:{type:Boolean,notify:!0,readOnly:!0,value:!1,reflectToAttribute:!0,observer:"__overlayChanged",sync:!0},closeDrawerOn:{type:String,value:"vaadin-router-location-changed",observer:"_closeDrawerOnChanged"}}}static get observers(){return["__i18nChanged(__effectiveI18n)"]}static dispatchCloseOverlayDrawerEvent(){window.dispatchEvent(new CustomEvent("close-overlay-drawer"))}get i18n(){return super.i18n}set i18n(a){super.i18n=a}constructor(){super(),this.__boundResizeListener=this._resize.bind(this),this.__drawerToggleClickListener=this._drawerToggleClick.bind(this),this.__onDrawerKeyDown=this.__onDrawerKeyDown.bind(this),this.__closeOverlayDrawerListener=this.__closeOverlayDrawer.bind(this),this.__trapFocusInDrawer=this.__trapFocusInDrawer.bind(this),this.__releaseFocusFromDrawer=this.__releaseFocusFromDrawer.bind(this),this.__ariaModalController=new AriaModalController(this,()=>[...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')]),this.__focusTrapController=new FocusTrapController(this)}connectedCallback(){super.connectedCallback(),this._blockAnimationUntilAfterNextRender(),window.addEventListener("resize",this.__boundResizeListener),this.addEventListener("drawer-toggle-click",this.__drawerToggleClickListener),requestAnimationFrame(()=>{this._updateOffsetSize()}),this._updateTouchOptimizedMode(),this._updateDrawerSize(),this._updateOverlayMode(),this._navbarSizeObserver=new ResizeObserver(()=>{requestAnimationFrame(()=>{this.__isDrawerAnimating?this.__updateOffsetSizePending=!0:this._updateOffsetSize()})}),this._navbarSizeObserver.observe(this.$.navbarTop),this._navbarSizeObserver.observe(this.$.navbarBottom),this._navbarSizeObserver.observe(this.$.drawer),window.addEventListener("close-overlay-drawer",this.__closeOverlayDrawerListener),window.addEventListener("keydown",this.__onDrawerKeyDown)}ready(){super.ready(),this.addController(this.__focusTrapController),this.__setAriaExpanded(),this.$.drawer.addEventListener("transitionstart",()=>{this.__isDrawerAnimating=!0}),this.$.drawer.addEventListener("transitionend",()=>{this.__updateOffsetSizePending&&(this.__updateOffsetSizePending=!1,this._updateOffsetSize()),requestAnimationFrame(()=>{this.__isDrawerAnimating=!1})})}disconnectedCallback(){super.disconnectedCallback(),window.removeEventListener("resize",this.__boundResizeListener),this.removeEventListener("drawer-toggle-click",this.__drawerToggleClickListener),window.removeEventListener("close-overlay-drawer",this.__drawerToggleClickListener),window.removeEventListener("keydown",this.__onDrawerKeyDown)}__primarySectionChanged(a){["navbar","drawer"].includes(a)||(this.primarySection="navbar")}__drawerOpenedChanged(a,p){this.overlay&&(a?this.__trapFocusInDrawer():p&&this.__releaseFocusFromDrawer()),this.__setAriaExpanded()}__overlayChanged(a,p){p&&this.__restoreFocus()}__i18nChanged(){this.__updateDrawerAriaAttributes()}_drawerToggleClick(a){a.stopPropagation(),this.drawerOpened=!this.drawerOpened}__closeOverlayDrawer(){this.overlay&&(this.drawerOpened=!1)}__setAriaExpanded(){const a=this.querySelector("vaadin-drawer-toggle");a&&a.setAttribute("aria-expanded",this.drawerOpened)}_updateDrawerSize(){const a=this.querySelectorAll("[slot=drawer]").length,p=this.$.drawer;a===0?(p.setAttribute("hidden",""),this.style.setProperty("--_vaadin-app-layout-drawer-width",0)):(p.removeAttribute("hidden"),this.style.removeProperty("--_vaadin-app-layout-drawer-width")),this._updateOffsetSize()}_resize(){this._blockAnimationUntilAfterNextRender(),this._updateTouchOptimizedMode(),this._updateOverlayMode()}_updateOffsetSize(){const p=this.$.navbarTop.getBoundingClientRect(),C=this.$.navbarBottom.getBoundingClientRect(),z=this.$.drawer.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-navbar-offset-size",`${p.height}px`),this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom",`${C.height}px`),this.style.setProperty("--_vaadin-app-layout-drawer-offset-size",`${z.width}px`)}_updateOverlayMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay")==="true";!this.overlay&&a&&(this._drawerStateSaved=this.drawerOpened,this.drawerOpened=!1),this._setOverlay(a),!this.overlay&&this._drawerStateSaved&&(this.drawerOpened=this._drawerStateSaved,this._drawerStateSaved=null),this.__updateDrawerAriaAttributes()}__updateDrawerAriaAttributes(){const a=this.$.drawer;this.overlay?(a.setAttribute("role","dialog"),a.setAttribute("aria-modal","true"),a.setAttribute("aria-label",this.__effectiveI18n.drawer)):(a.removeAttribute("role"),a.removeAttribute("aria-modal"),a.removeAttribute("aria-label"))}__drawerTransitionComplete(){return new Promise(a=>{if(this._getCustomPropertyValue("--vaadin-app-layout-transition-duration")==="0s"){a();return}this.$.drawer.addEventListener("transitionend",a,{once:!0})})}async __trapFocusInDrawer(){await this.__drawerTransitionComplete(),this.drawerOpened&&(this.$.drawer.setAttribute("tabindex","0"),this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.drawer))}async __releaseFocusFromDrawer(){if(await this.__drawerTransitionComplete(),this.drawerOpened)return;this.__restoreFocus();const a=this.querySelector("vaadin-drawer-toggle");a&&(a.focus(),a.setAttribute("focus-ring","focus"))}__restoreFocus(){this.__ariaModalController.close(),this.__focusTrapController.releaseFocus(),this.$.drawer.removeAttribute("tabindex")}__onDrawerKeyDown(a){a.key==="Escape"&&this.overlay&&(this.drawerOpened=!1)}_closeDrawerOnChanged(a,p){p&&window.removeEventListener(p,this.__closeOverlayDrawerListener),a&&window.addEventListener(a,this.__closeOverlayDrawerListener)}_onBackdropClick(){this._close()}_onBackdropTouchend(a){a.preventDefault(),this._close()}_close(){this.drawerOpened=!1}_getCustomPropertyValue(a){return(getComputedStyle(this).getPropertyValue(a)||"").trim().toLowerCase()}_updateTouchOptimizedMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized")==="true",p=this.querySelectorAll('[slot*="navbar"]');p.length>0&&Array.from(p).forEach(y=>{y.getAttribute("slot").indexOf("touch-optimized")>-1&&(y.__touchOptimized=!0),a&&y.__touchOptimized?y.setAttribute("slot","navbar-bottom"):y.setAttribute("slot","navbar")}),this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length===0?this.$.navbarTop.setAttribute("hidden",""):this.$.navbarTop.removeAttribute("hidden"),this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length===0?this.$.navbarBottom.setAttribute("hidden",""):this.$.navbarBottom.removeAttribute("hidden"),this._updateOffsetSize()}_blockAnimationUntilAfterNextRender(){this.setAttribute("no-anim",""),this.__debounceAnimation=Debouncer.debounce(this.__debounceAnimation,animationFrame,()=>{setTimeout(()=>{this.removeAttribute("no-anim")})})}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-app-layout"}static get styles(){return appLayoutStyles}render(){return x`
      <div part="navbar" id="navbarTop">
        <slot name="navbar" @slotchange="${this._updateTouchOptimizedMode}"></slot>
      </div>
      <div part="backdrop" @click="${this._onBackdropClick}" @touchend="${this._onBackdropTouchend}"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" @slotchange="${this._updateDrawerSize}"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" @slotchange="${this._updateTouchOptimizedMode}"></slot>
      </div>
    `}}defineCustomElement(AppLayout);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const buttonStyles=i`
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    gap: var(--vaadin-button-gap, 0 var(--vaadin-gap-s));
    white-space: nowrap;
    -webkit-tap-highlight-color: transparent;
    -webkit-user-select: none;
    user-select: none;
    cursor: var(--vaadin-clickable-cursor);
    box-sizing: border-box;
    vertical-align: middle;
    flex-shrink: 0;
    height: var(--vaadin-button-height, auto);
    margin: var(--vaadin-button-margin, 0);
    padding: var(--vaadin-button-padding, var(--vaadin-padding-container));
    font-family: var(--vaadin-button-font-family, inherit);
    font-size: var(--vaadin-button-font-size, inherit);
    line-height: var(--vaadin-button-line-height, inherit);
    font-weight: var(--vaadin-button-font-weight, 500);
    color: var(--vaadin-button-text-color, var(--vaadin-color));
    background: var(--vaadin-button-background, var(--vaadin-background-container));
    background-origin: border-box;
    border: var(
      --vaadin-button-border,
      var(--vaadin-button-border-width, 1px) solid var(--vaadin-button-border-color, var(--vaadin-border-color-subtle))
    );
    border-radius: var(--vaadin-button-border-radius, var(--vaadin-radius-m));
    touch-action: manipulation;
  }

  :host([hidden]) {
    display: none !important;
  }

  .vaadin-button-container,
  [part='prefix'],
  [part='suffix'],
  [part='label'] {
    display: contents;
  }

  :host(:is([focus-ring], :focus-visible)) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
    outline-offset: 1px;
  }

  :host([theme~='primary']) {
    --vaadin-button-background: var(--vaadin-color);
    --vaadin-button-text-color: var(--vaadin-background-color);
    --vaadin-button-border-color: transparent;
  }

  :host([theme~='tertiary']) {
    --vaadin-button-text-color: var(--_vaadin-button-text-color);
    --vaadin-button-background: transparent;
    --vaadin-button-border-color: transparent;
  }

  :host([disabled]) {
    pointer-events: var(--_vaadin-button-disabled-pointer-events, none);
    cursor: var(--vaadin-disabled-cursor);
    opacity: 0.5;
  }

  :host([disabled][theme~='primary']) {
    --vaadin-button-text-color: var(--vaadin-background-container-strong);
    --vaadin-button-background: var(--vaadin-color-disabled);
  }

  @media (forced-colors: active) {
    :host {
      --vaadin-button-border-width: 1px;
      --vaadin-button-background: ButtonFace;
      --vaadin-button-text-color: ButtonText;
    }

    :host([theme~='primary']) {
      forced-color-adjust: none;
      --vaadin-button-background: CanvasText;
      --vaadin-button-text-color: Canvas;
      --vaadin-icon-color: Canvas;
    }

    ::slotted(*) {
      forced-color-adjust: auto;
    }

    :host([disabled]) {
      --vaadin-button-background: transparent !important;
      --vaadin-button-border-color: GrayText !important;
      --vaadin-button-text-color: GrayText !important;
      opacity: 1;
    }
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Button extends ButtonMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-button"}static get styles(){return buttonStyles}static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0,sync:!0}}}render(){return x`
      <div class="vaadin-button-container">
        <span part="prefix" aria-hidden="true">
          <slot name="prefix"></slot>
        </span>
        <span part="label">
          <slot></slot>
        </span>
        <span part="suffix" aria-hidden="true">
          <slot name="suffix"></slot>
        </span>
      </div>
      <slot name="tooltip"></slot>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}__shouldAllowFocusWhenDisabled(){return window.Vaadin.featureFlags.accessibleDisabledButtons}}defineCustomElement(Button);/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const drawerToggle=i`
  [part='icon'] {
    background: currentColor;
    display: block;
    height: var(--vaadin-icon-size, 1lh);
    mask-image: var(--_vaadin-icon-menu);
    width: var(--vaadin-icon-size, 1lh);
  }

  [hidden] {
    display: none !important;
  }

  @media (forced-colors: active) {
    [part='icon'] {
      background: CanvasText;
    }
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-drawer-toggle"}static get styles(){return[buttonStyles,drawerToggle]}static get properties(){return{ariaLabel:{type:String,value:"Toggle navigation panel",reflectToAttribute:!0,sync:!0},_showFallbackIcon:{type:Boolean,value:!1}}}constructor(){super(),this.addEventListener("click",()=>{this.dispatchEvent(new CustomEvent("drawer-toggle-click",{bubbles:!0,composed:!0}))})}render(){return x`
      <slot id="slot" @slotchange="${this._toggleFallbackIcon}">
        <div part="icon"></div>
      </slot>
      <div part="icon" ?hidden="${!this._showFallbackIcon}"></div>
    `}ready(){super.ready(),this._toggleFallbackIcon()}_toggleFallbackIcon(){const d=this.$.slot.assignedNodes();this._showFallbackIcon=d.length>0&&d.every(a=>isEmptyTextNode(a))}}defineCustomElement(DrawerToggle);/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverOverlayMixin=v=>class extends PositionMixin(OverlayMixin(v)){static get properties(){return{position:{type:String,reflectToAttribute:!0}}}_updatePosition(){if(super._updatePosition(),!(!this.positionTarget||!this.opened)){if(this.removeAttribute("arrow-centered"),this.position==="bottom"||this.position==="top"){const a=this.positionTarget.getBoundingClientRect(),p=this.$.overlay.getBoundingClientRect(),y=a.width/2-p.width/2;if(this.style.left){const C=p.left+y;C>0&&(this.style.left=`${C}px`,this.setAttribute("arrow-centered",""))}if(this.style.right){const C=parseFloat(this.style.right)+y;C>0&&(this.style.right=`${C}px`,this.setAttribute("arrow-centered",""))}}if(this.position==="start"||this.position==="end"){const a=this.positionTarget.getBoundingClientRect(),p=this.$.overlay.getBoundingClientRect(),y=a.height/2-p.height/2;this.style.top=`${p.top+y}px`}}}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const tooltipOverlayStyles=i`
  :host {
    --_vaadin-tooltip-default-offset: 4px;
    line-height: normal;
  }

  [part='overlay'] {
    max-width: var(--vaadin-tooltip-max-width, 40ch);
    padding: var(--vaadin-tooltip-padding, var(--vaadin-padding-container));
    border-radius: var(--vaadin-tooltip-border-radius, var(--vaadin-radius-m));
    background: var(--vaadin-tooltip-background, var(--vaadin-background-color));
    color: var(--vaadin-tooltip-color, inherit);
    font-size: var(--vaadin-tooltip-font-size, 0.9em);
    font-weight: var(--vaadin-tooltip-font-weight, inherit);
    line-height: var(--vaadin-tooltip-line-height, inherit);
    border: 0;
    box-shadow:
      0 0 0 var(--vaadin-tooltip-border-width, 1px)
        var(--vaadin-tooltip-border-color, var(--vaadin-border-color-subtle)),
      var(--vaadin-tooltip-box-shadow, 0 3px 8px -1px rgba(0, 0, 0, 0.2));
  }

  [part='content'] {
    white-space: pre-wrap;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, var(--_vaadin-tooltip-default-offset));
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      border: 1px dashed !important;
    }
  }
`;/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipOverlay extends PopoverOverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-tooltip-overlay"}static get styles(){return[overlayStyles$1,tooltipOverlayStyles]}render(){return x`
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `}}defineCustomElement(TooltipOverlay);/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$2=v=>v??E$1;/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverPositionMixin=v=>class extends v{static get properties(){return{position:{type:String},_position:{type:String,value:"bottom"},__effectivePosition:{type:String,computed:"__computePosition(position, _position)"}}}__computeHorizontalAlign(a){return["top-end","bottom-end","start-top","start","start-bottom"].includes(a)?"end":"start"}__computeNoHorizontalOverlap(a){return["start-top","start","start-bottom","end-top","end","end-bottom"].includes(a)}__computeNoVerticalOverlap(a){return["top-start","top-end","top","bottom-start","bottom","bottom-end"].includes(a)}__computeVerticalAlign(a){return["top-start","top-end","top","start-bottom","end-bottom"].includes(a)?"bottom":"top"}__computePosition(a,p){return a||p}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverTargetMixin=v=>class extends v{static get properties(){return{for:{type:String,observer:"__forChanged"},target:{type:Object},__isConnected:{type:Boolean,sync:!0}}}static get observers(){return["__targetOrConnectedChanged(target, __isConnected)"]}connectedCallback(){super.connectedCallback(),this.__isConnected=!0}disconnectedCallback(){super.disconnectedCallback(),this.__isConnected=!1}__forChanged(a){a&&(this.__setTargetByIdDebouncer=Debouncer.debounce(this.__setTargetByIdDebouncer,microTask,()=>this.__setTargetById(a)))}__setTargetById(a){if(!this.isConnected)return;const p=this.getRootNode().getElementById(a);p?this.target=p:console.warn(`No element with id="${a}" set via "for" property found on the page.`)}__targetOrConnectedChanged(a,p){this.__previousTarget&&(this.__previousTarget!==a||!p)&&this._removeTargetListeners(this.__previousTarget),a&&p&&this._addTargetListeners(a),this.__previousTarget=a}_addTargetListeners(a){}_removeTargetListeners(a){}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_DELAY$1=500;let defaultFocusDelay$3=DEFAULT_DELAY$1,defaultHoverDelay$3=DEFAULT_DELAY$1,defaultHideDelay$3=DEFAULT_DELAY$1;const closing=new Set;let warmedUp=!1,warmUpTimeout=null,cooldownTimeout=null;class TooltipStateController{constructor(d){this.host=d}get focusDelay(){const d=this.host;return d.focusDelay!=null&&d.focusDelay>=0?d.focusDelay:defaultFocusDelay$3}get hoverDelay(){const d=this.host;return d.hoverDelay!=null&&d.hoverDelay>=0?d.hoverDelay:defaultHoverDelay$3}get hideDelay(){const d=this.host;return d.hideDelay!=null&&d.hideDelay>=0?d.hideDelay:defaultHideDelay$3}get isClosing(){return closing.has(this.host)}open(d={immediate:!1}){const{immediate:a,hover:p,focus:y}=d,C=p&&this.hoverDelay>0,P=y&&this.focusDelay>0;!a&&(C||P)&&!this.__closeTimeout?this.__warmupTooltip(P):this.__showTooltip()}close(d){!d&&this.hideDelay>0?this.__scheduleClose():(this.__abortClose(),this._setOpened(!1)),this.__abortWarmUp(),warmedUp&&(this.__abortCooldown(),this.__scheduleCooldown())}_isOpened(){return this.host.opened}_setOpened(d){this.host.opened=d}__flushClosingTooltips(){closing.forEach(d=>{d._stateController.close(!0),closing.delete(d)})}__showTooltip(){this.__abortClose(),this.__flushClosingTooltips(),this._setOpened(!0),warmedUp=!0,this.__abortWarmUp(),this.__abortCooldown()}__warmupTooltip(d){this._isOpened()||(warmedUp?this.__showTooltip():warmUpTimeout==null&&this.__scheduleWarmUp(d))}__abortClose(){this.__closeTimeout&&(clearTimeout(this.__closeTimeout),this.__closeTimeout=null),this.isClosing&&closing.delete(this.host)}__abortCooldown(){cooldownTimeout&&(clearTimeout(cooldownTimeout),cooldownTimeout=null)}__abortWarmUp(){warmUpTimeout&&(clearTimeout(warmUpTimeout),warmUpTimeout=null)}__scheduleClose(){this._isOpened()&&!this.isClosing&&(closing.add(this.host),this.__closeTimeout=setTimeout(()=>{closing.delete(this.host),this.__closeTimeout=null,this._setOpened(!1)},this.hideDelay))}__scheduleCooldown(){cooldownTimeout=setTimeout(()=>{cooldownTimeout=null,warmedUp=!1},this.hideDelay)}__scheduleWarmUp(d){const a=d?this.focusDelay:this.hoverDelay;warmUpTimeout=setTimeout(()=>{warmUpTimeout=null,warmedUp=!0,this.__showTooltip()},a)}}const TooltipMixin=v=>class extends PopoverPositionMixin(PopoverTargetMixin(v)){static get properties(){return{ariaTarget:{type:Object},context:{type:Object,value:()=>({})},focusDelay:{type:Number},generator:{type:Object},hideDelay:{type:Number},hoverDelay:{type:Number},manual:{type:Boolean,value:!1,sync:!0},opened:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"__openedChanged",sync:!0},shouldShow:{type:Object,value:()=>(a,p)=>!0},text:{type:String},_effectiveAriaTarget:{type:Object,computed:"__computeAriaTarget(ariaTarget, target)",observer:"__effectiveAriaTargetChanged"},__isTargetHidden:{type:Boolean,value:!1},_isConnected:{type:Boolean,sync:!0}}}static setDefaultFocusDelay(a){defaultFocusDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHideDelay(a){defaultHideDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHoverDelay(a){defaultHoverDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}constructor(){super(),this._uniqueId=`vaadin-tooltip-${generateUniqueId()}`,this.__onFocusin=this.__onFocusin.bind(this),this.__onFocusout=this.__onFocusout.bind(this),this.__onMouseDown=this.__onMouseDown.bind(this),this.__onMouseEnter=this.__onMouseEnter.bind(this),this.__onMouseLeave=this.__onMouseLeave.bind(this),this.__onKeyDown=this.__onKeyDown.bind(this),this.__onOverlayOpen=this.__onOverlayOpen.bind(this),this.__targetVisibilityObserver=new IntersectionObserver(a=>{a.forEach(p=>this.__onTargetVisibilityChange(p.isIntersecting))},{threshold:0}),this._stateController=new TooltipStateController(this)}connectedCallback(){super.connectedCallback(),this._isConnected=!0,document.body.addEventListener("vaadin-overlay-open",this.__onOverlayOpen)}disconnectedCallback(){super.disconnectedCallback(),this.opened&&!this.manual&&this._stateController.close(!0),this._isConnected=!1,document.body.removeEventListener("vaadin-overlay-open",this.__onOverlayOpen)}ready(){super.ready(),this._overlayElement=this.$.overlay,this.__contentController=new SlotController(this,"overlay","div",{initializer:a=>{a.id=this._uniqueId,a.setAttribute("role","tooltip"),this.__contentNode=a}}),this.addController(this.__contentController)}updated(a){super.updated(a),(a.has("text")||a.has("generator")||a.has("context"))&&(this.__updateContent(),this.$.overlay.toggleAttribute("hidden",this.__contentNode.textContent.trim()===""))}__openedChanged(a,p){a?document.addEventListener("keydown",this.__onKeyDown,!0):p&&document.removeEventListener("keydown",this.__onKeyDown,!0)}_addTargetListeners(a){a.addEventListener("mouseenter",this.__onMouseEnter),a.addEventListener("mouseleave",this.__onMouseLeave),a.addEventListener("focusin",this.__onFocusin),a.addEventListener("focusout",this.__onFocusout),a.addEventListener("mousedown",this.__onMouseDown),requestAnimationFrame(()=>{this.__targetVisibilityObserver.observe(a)})}_removeTargetListeners(a){a.removeEventListener("mouseenter",this.__onMouseEnter),a.removeEventListener("mouseleave",this.__onMouseLeave),a.removeEventListener("focusin",this.__onFocusin),a.removeEventListener("focusout",this.__onFocusout),a.removeEventListener("mousedown",this.__onMouseDown),this.__targetVisibilityObserver.unobserve(a)}__onFocusin(a){this.manual||isKeyboardActive()&&(this.target.contains(a.relatedTarget)||this.__isShouldShow()&&(this.__focusInside=!0,!this.__isTargetHidden&&(!this.__hoverInside||!this.opened)&&this._stateController.open({focus:!0})))}__onFocusout(a){this.manual||this.target.contains(a.relatedTarget)||(this.__focusInside=!1,this.__hoverInside||this._stateController.close(!0))}__onKeyDown(a){this.manual||a.key==="Escape"&&(a.stopPropagation(),this._stateController.close(!0))}__onMouseDown(){this.manual||this._stateController.close(!0)}__onMouseEnter(){this.manual||this.__isShouldShow()&&(this.__hoverInside||(this.__hoverInside=!0,!this.__isTargetHidden&&(!this.__focusInside||!this.opened)&&this._stateController.open({hover:!0})))}__onMouseLeave(a){a.relatedTarget!==this._overlayElement&&this.__handleMouseLeave()}__onOverlayMouseEnter(){this.manual||this._stateController.isClosing&&this._stateController.open({immediate:!0})}__onOverlayMouseLeave(a){a.relatedTarget!==this.target&&this.__handleMouseLeave()}__handleMouseLeave(){this.manual||(this.__hoverInside=!1,this.__focusInside||this._stateController.close())}__onOverlayOpen(){this.manual||this._overlayElement.opened&&!this._overlayElement._last&&this._stateController.close(!0)}__onTargetVisibilityChange(a){if(this.manual)return;const p=this.__isTargetHidden;if(this.__isTargetHidden=!a,p&&a&&(this.__focusInside||this.__hoverInside)){this._stateController.open({immediate:!0});return}!a&&this.opened&&this._stateController.close(!0)}__isShouldShow(){return!(typeof this.shouldShow=="function"&&this.shouldShow(this.target,this.context)!==!0)}__updateContent(){this.__contentNode.textContent=typeof this.generator=="function"?this.generator(this.context):this.text}__computeAriaTarget(a,p){const y=P=>P&&P.nodeType===Node.ELEMENT_NODE,C=Array.isArray(a)?a.some(y):a;return a===null||C?a:p}__effectiveAriaTargetChanged(a,p){p&&[p].flat().forEach(y=>{removeValueFromAttribute(y,"aria-describedby",this._uniqueId)}),a&&[a].flat().forEach(y=>{addValueToAttribute(y,"aria-describedby",this._uniqueId)})}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let Tooltip$1=class extends TooltipMixin(ThemePropertyMixin(ElementMixin(PolylitMixin(i$1)))){static get is(){return"vaadin-tooltip"}static get styles(){return i`
      :host {
        display: contents;
      }
    `}render(){const d=this.__effectivePosition;return x`
      <vaadin-tooltip-overlay
        id="overlay"
        .owner="${this}"
        theme="${o$2(this._theme)}"
        .opened="${this._isConnected&&this.opened}"
        .positionTarget="${this.target}"
        .position="${d}"
        ?no-horizontal-overlap="${this.__computeNoHorizontalOverlap(d)}"
        ?no-vertical-overlap="${this.__computeNoVerticalOverlap(d)}"
        .horizontalAlign="${this.__computeHorizontalAlign(d)}"
        .verticalAlign="${this.__computeVerticalAlign(d)}"
        @mouseenter="${this.__onOverlayMouseEnter}"
        @mouseleave="${this.__onOverlayMouseLeave}"
        modeless
        exportparts="overlay, content"
        ><slot name="overlay"></slot
      ></vaadin-tooltip-overlay>
    `}};defineCustomElement(Tooltip$1);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarStyles=i`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    cursor: default;
    color: var(--vaadin-avatar-color, var(--vaadin-color-subtle));
    line-height: 0;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 32px);
    width: var(--vaadin-avatar-size, 32px);
    border: var(--vaadin-focus-ring-width) solid transparent;
    margin: calc(var(--vaadin-focus-ring-width) * -1);
    background: var(--vaadin-avatar-background, var(--vaadin-background-container-strong));
    background-clip: content-box;
    vertical-align: middle;
    -webkit-user-select: none;
    user-select: none;
    -webkit-tap-highlight-color: transparent;
    position: relative;
  }

  :host([role='button']) {
    cursor: var(--vaadin-clickable-cursor);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    height: 100%;
    mask: var(--_vaadin-icon-user) no-repeat center / 74%;
    background: currentColor;
  }

  [part='abbr'] {
    font-size: 2.75em;
    fill: currentColor;
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    background-color: var(--vaadin-avatar-user-color);
    color: oklch(from var(--vaadin-avatar-user-color) clamp(0, (0.62 - l) * 1000, 1) 0 0);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    border: 2px solid var(--vaadin-avatar-user-color);
  }

  :host([focus-ring]) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
    outline-offset: calc((var(--vaadin-focus-ring-width)) * -1);
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$9={anonymous:"anonymous"},AvatarMixin=v=>class extends I18nMixin(DEFAULT_I18N$9,FocusMixin(v)){static get properties(){return{img:{type:String,reflectToAttribute:!0,observer:"__imgChanged"},abbr:{type:String,reflectToAttribute:!0},name:{type:String,reflectToAttribute:!0},colorIndex:{type:Number,observer:"__colorIndexChanged"},withTooltip:{type:Boolean,value:!1,observer:"__withTooltipChanged"},__imgVisible:Boolean,__iconVisible:Boolean,__abbrVisible:Boolean,__tooltipNode:Object}}static get observers(){return["__imgOrAbbrOrNameChanged(img, abbr, name)","__i18nChanged(__effectiveI18n)","__tooltipChanged(__tooltipNode, name, abbr)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this.__updateVisibility(),this.hasAttribute("role")||this.setAttribute("role","img"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),!this.name&&!this.abbr&&this.__setTooltip()}__colorIndexChanged(a){if(a!=null){const p=`--vaadin-user-color-${a}`;!!getComputedStyle(document.documentElement).getPropertyValue(p)?(this.setAttribute("has-color-index",""),this.style.setProperty("--vaadin-avatar-user-color",`var(${p})`)):(this.removeAttribute("has-color-index"),console.warn(`The CSS property --vaadin-user-color-${a} is not defined`))}else this.removeAttribute("has-color-index")}__imgChanged(){this.__imgFailedToLoad=!1}__imgOrAbbrOrNameChanged(a,p,y){this.__updateVisibility(),!(p&&p!==this.__generatedAbbr)&&(y?this.abbr=this.__generatedAbbr=y.split(" ").map(C=>C.charAt(0)).join(""):this.abbr=void 0)}__tooltipChanged(a,p,y){a&&(y&&y!==this.__generatedAbbr?this.__setTooltip(p?`${p} (${y})`:y):this.__setTooltip(p)),y?this.setAttribute("aria-label",!a&&p?`${p} (${y})`:y):this.removeAttribute("aria-label")}__withTooltipChanged(a,p){if(a){const y=document.createElement("vaadin-tooltip");y.setAttribute("slot","tooltip"),this.appendChild(y),this.__tooltipNode=y}else p&&(this.__tooltipNode.target=null,this.__tooltipNode.remove(),this.__tooltipNode=null)}__i18nChanged(a){a&&a.anonymous&&(this.__oldAnonymous&&this.__tooltipNode&&this.__tooltipNode.text===this.__oldAnonymous&&this.__setTooltip(),this.__oldAnonymous=a.anonymous)}__updateVisibility(){this.__imgVisible=!!this.img&&!this.__imgFailedToLoad,this.__abbrVisible=!this.__imgVisible&&!!this.abbr,this.__iconVisible=!this.__imgVisible&&!this.abbr}__setTooltip(a){const p=this.__tooltipNode;p&&(p.text=a||this.__effectiveI18n.anonymous)}__onImageLoadError(){this.img&&(console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`),this.__imgFailedToLoad=!0,this.__updateVisibility())}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-avatar"}static get styles(){return avatarStyles}static get lumoInjector(){return{includeBaseStyles:!0}}render(){return x`
      <img
        ?hidden="${!this.__imgVisible}"
        src="${o$2(this.img)}"
        aria-hidden="true"
        @error="${this.__onImageLoadError}"
        draggable="false"
      />
      <div part="icon" ?hidden="${!this.__iconVisible}" aria-hidden="true"></div>
      <svg
        part="abbr"
        ?hidden="${!this.__abbrVisible}"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">${this.abbr}</text>
      </svg>

      <slot name="tooltip"></slot>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}defineCustomElement(Avatar);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getNormalizedScrollLeft(v,d){const{scrollLeft:a}=v;return d!=="rtl"?a:v.scrollWidth-v.clientWidth+a}function setNormalizedScrollLeft(v,d,a){d!=="rtl"?v.scrollLeft=a:v.scrollLeft=v.clientWidth-v.scrollWidth+a}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ListMixin=v=>class extends KeyboardDirectionMixin(v){static get properties(){return{disabled:{type:Boolean,value:!1,reflectToAttribute:!0},selected:{type:Number,reflectToAttribute:!0,notify:!0,sync:!0},orientation:{type:String,reflectToAttribute:!0,value:""},items:{type:Array,readOnly:!0,notify:!0},_searchBuf:{type:String,value:""}}}static get observers(){return["_enhanceItems(items, orientation, selected, disabled)"]}get _isRTL(){return!this._vertical&&this.getAttribute("dir")==="rtl"}get _scrollerElement(){return console.warn(`Please implement the '_scrollerElement' property in <${this.localName}>`),this}get _vertical(){return this.orientation!=="horizontal"}focus(){this._observer&&this._observer.flush();const a=Array.isArray(this.items)?this.items:[],p=this._getAvailableIndex(a,0,null,y=>y.tabIndex===0&&!isElementHidden(y));p>=0?this._focus(p):super.focus()}ready(){super.ready(),this.addEventListener("click",p=>this._onClick(p));const a=this.shadowRoot.querySelector("slot:not([name])");this._observer=new SlotObserver(a,()=>{this._setItems(this._filterItems(getFlattenedElements(this)))})}_getItems(){return this.items}_enhanceItems(a,p,y,C){if(!C&&a){this.setAttribute("aria-orientation",p||"vertical"),a.forEach(z=>{p?z.setAttribute("orientation",p):z.removeAttribute("orientation")}),this._setFocusable(y<0||!y?0:y);const P=a[y];a.forEach(z=>{z.selected=z===P}),P&&!P.disabled&&this._scrollToItem(y)}}_filterItems(a){return a.filter(p=>p._hasVaadinItemMixin)}_onClick(a){if(a.metaKey||a.shiftKey||a.ctrlKey||a.defaultPrevented)return;const p=this._filterItems(a.composedPath())[0];let y;p&&!p.disabled&&(y=this.items.indexOf(p))>=0&&(this.selected=y)}_searchKey(a,p){this._searchReset=Debouncer.debounce(this._searchReset,timeOut.after(500),()=>{this._searchBuf=""}),this._searchBuf+=p.toLowerCase(),this.items.some(C=>this.__isMatchingKey(C))||(this._searchBuf=p.toLowerCase());const y=this._searchBuf.length===1?a+1:a;return this._getAvailableIndex(this.items,y,1,C=>this.__isMatchingKey(C)&&getComputedStyle(C).display!=="none")}__isMatchingKey(a){return a.textContent.replace(/[^\p{L}\p{Nd}]/gu,"").toLowerCase().startsWith(this._searchBuf)}_onKeyDown(a){if(a.metaKey||a.ctrlKey)return;const p=a.key,y=this.items.indexOf(this.focused);if(/[\p{L}\p{Nd}]/u.test(p)&&p.length===1){const C=this._searchKey(y,p);C>=0&&this._focus(C);return}super._onKeyDown(a)}_setFocusable(a){a=this._getAvailableIndex(this.items,a,1);const p=this.items[a];this.items.forEach(y=>{y.tabIndex=y===p?0:-1})}_focus(a){this.items.forEach((p,y)=>{p.focused=y===a}),this._setFocusable(a),this._scrollToItem(a),super._focus(a)}_scrollToItem(a){const p=this.items[a];if(!p)return;const y=this._vertical?["top","bottom"]:this._isRTL?["right","left"]:["left","right"],C=this._scrollerElement.getBoundingClientRect(),P=(this.items[a+1]||p).getBoundingClientRect(),z=(this.items[a-1]||p).getBoundingClientRect();let L=0;!this._isRTL&&P[y[1]]>=C[y[1]]||this._isRTL&&P[y[1]]<=C[y[1]]?L=P[y[1]]-C[y[1]]:(!this._isRTL&&z[y[0]]<=C[y[0]]||this._isRTL&&z[y[0]]>=C[y[0]])&&(L=z[y[0]]-C[y[0]]),this._scroll(L)}_scroll(a){if(this._vertical)this._scrollerElement.scrollTop+=a;else{const p=this.getAttribute("dir")||"ltr",y=getNormalizedScrollLeft(this._scrollerElement,p)+a;setNormalizedScrollLeft(this._scrollerElement,p,y)}}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarGroupMenuStyles=i`
  :host {
    display: block;
    padding: var(--vaadin-item-overlay-padding, 4px);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='items'] {
    display: contents;
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-avatar-group-menu"}static get styles(){return avatarGroupMenuStyles}static get properties(){return{orientation:{readOnly:!0}}}get _scrollerElement(){return this.shadowRoot.querySelector('[part="items"]')}render(){return x`
      <div part="items">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menu")}}defineCustomElement(AvatarGroupMenu);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemMixin=v=>class extends ActiveMixin(FocusMixin(v)){static get properties(){return{_hasVaadinItemMixin:{value:!0},selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged",sync:!0},_value:String}}get _activeKeys(){return["Enter"," "]}get value(){return this._value!==void 0?this._value:this.textContent.trim()}set value(a){this._value=a}ready(){super.ready();const a=this.getAttribute("value");a!==null&&(this.value=a)}focus(){this.disabled||(super.focus(),this._setFocused(!0))}_shouldSetActive(a){return!this.disabled&&!(a.type==="keydown"&&a.defaultPrevented)}_selectedChanged(a){this.setAttribute("aria-selected",a)}_disabledChanged(a){super._disabledChanged(a),a&&(this.selected=!1,this.blur())}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&!a.defaultPrevented&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const itemStyles=i`
  :host {
    align-items: center;
    border-radius: var(--vaadin-item-border-radius, var(--vaadin-radius-m));
    box-sizing: border-box;
    cursor: var(--vaadin-clickable-cursor);
    display: flex;
    gap: var(--vaadin-item-gap, 0 var(--vaadin-gap-s));
    height: var(--vaadin-item-height, auto);
    padding: var(--vaadin-item-padding, var(--vaadin-padding-container));
  }

  :host([focused]) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
    outline-offset: calc(var(--vaadin-focus-ring-width) / -1);
  }

  :host([disabled]) {
    cursor: var(--vaadin-disabled-cursor);
    opacity: 0.5;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='checkmark'] {
    color: var(--vaadin-item-checkmark-color, inherit);
    display: var(--vaadin-item-checkmark-display, none);
    visibility: hidden;
  }

  [part='checkmark']::before {
    content: '';
    display: block;
    background: currentColor;
    height: var(--vaadin-icon-size, 1lh);
    mask-image: var(--_vaadin-icon-checkmark);
    width: var(--vaadin-icon-size, 1lh);
  }

  :host([selected]) [part='checkmark'] {
    visibility: visible;
  }

  [part='content'] {
    flex: 1;
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const menuItemStyles$1=i`
  [part='content'] {
    display: flex;
    align-items: center;
    gap: inherit;
  }
`,avatarGroupMenuItemStyles=[itemStyles,menuItemStyles$1];/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-avatar-group-menu-item"}static get styles(){return avatarGroupMenuItemStyles}render(){return x`
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menuitem")}}defineCustomElement(AvatarGroupMenuItem);/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1)))))){static get is(){return"vaadin-avatar-group-overlay"}static get styles(){return overlayStyles$1}render(){return x`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(AvatarGroupOverlay);/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarGroupStyles=i`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    /* 1: last on top */
    /* -1: first on top */
    --_dir: 1;
  }

  :host([theme~='reverse']) {
    --_dir: -1;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar) {
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox="0 0 300 300" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z" fill="black"/></svg>');
    mask-size: calc(300% + var(--vaadin-avatar-group-gap, 2px) * 6 - var(--vaadin-focus-ring-width) * 6);
    mask-position: calc(
      50% +
        (
          var(--vaadin-avatar-size, 32px) - var(--vaadin-avatar-group-overlap, 8px) +
            var(--vaadin-avatar-group-gap, 2px)
        ) *
        var(--_d)
    );
    --_d: var(--_dir);
  }

  :host(:dir(rtl)) ::slotted(vaadin-avatar) {
    --_d: calc(var(--_dir) * -1);
  }

  ::slotted(vaadin-avatar:not(:first-of-type)) {
    margin-inline-start: calc(
      var(--vaadin-avatar-group-overlap, 8px) * -1 - var(--vaadin-focus-ring-width) +
        var(--vaadin-avatar-group-gap, 2px)
    );
  }

  :host(:not([theme~='reverse'])) ::slotted(vaadin-avatar:last-child),
  :host(:not([theme~='reverse']):not([has-overflow])) ::slotted(vaadin-avatar:nth-last-child(2)),
  :host([theme~='reverse']) ::slotted(vaadin-avatar:first-of-type) {
    mask-image: none;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const observer=new ResizeObserver(v=>{setTimeout(()=>{v.forEach(d=>{d.target.isConnected&&(d.target.resizables?d.target.resizables.forEach(a=>{a._onResize(d.contentRect)}):d.target._onResize(d.contentRect))})})}),ResizeMixin=dedupeMixin(v=>class extends v{get _observeParent(){return!1}connectedCallback(){if(super.connectedCallback(),observer.observe(this),this._observeParent){const a=this.parentNode instanceof ShadowRoot?this.parentNode.host:this.parentNode;a.resizables||(a.resizables=new Set,observer.observe(a)),a.resizables.add(this),this.__parent=a}}disconnectedCallback(){super.disconnectedCallback(),observer.unobserve(this);const a=this.__parent;if(this._observeParent&&a){const p=a.resizables;p&&(p.delete(this),p.size===0&&observer.unobserve(a)),this.__parent=null}}_onResize(a){}});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MINIMUM_DISPLAYED_AVATARS=2,DEFAULT_I18N$8={anonymous:"anonymous",activeUsers:{one:"Currently one active user",many:"Currently {count} active users"},joined:"{user} joined",left:"{user} left"},AvatarGroupMixin=v=>class extends I18nMixin(DEFAULT_I18N$8,ResizeMixin(v)){static get properties(){return{items:{type:Array,sync:!0},maxItemsVisible:{type:Number,sync:!0},__itemsInView:{type:Number,value:null,sync:!0},_overflowItems:{type:Array},_overflowLimit:{type:Number},_opened:{type:Boolean,sync:!0}}}get i18n(){return super.i18n}set i18n(a){super.i18n=a}get _avatars(){return[...this.children].filter(a=>a.localName==="vaadin-avatar")}ready(){super.ready(),this._menuController=new SlotController(this,"overlay","vaadin-avatar-group-menu",{initializer:a=>{a.addEventListener("keydown",this._onListKeyDown.bind(this)),this._menuElement=a}}),this._overflowController=new SlotController(this,"overflow","vaadin-avatar",{initializer:a=>{a.setAttribute("role","button"),a.setAttribute("aria-haspopup","menu"),a.setAttribute("aria-expanded","false"),a.addEventListener("click",y=>this._onOverflowClick(y)),a.addEventListener("keydown",y=>this._onOverflowKeyDown(y));const p=document.createElement("vaadin-tooltip");p.setAttribute("slot","tooltip"),a.appendChild(p),this._overflow=a,this._overflowTooltip=p}}),this.addController(this._menuController),this.addController(this._overflowController),this._overlayElement=this.$.overlay}disconnectedCallback(){super.disconnectedCallback(),this._opened=!1}willUpdate(a){if(super.willUpdate(a),a.has("items")||a.has("__itemsInView")||a.has("maxItemsVisible")){const p=Array.isArray(this.items)?this.items.length:0,y=this.__getLimit(p,this.__itemsInView,this.maxItemsVisible);this._overflowLimit=y,this._overflowItems=y?this.items.slice(y):[]}}updated(a){if(super.updated(a),a.has("items")&&this.__itemsChanged(this.items,a.get("items")),a.has("items")||a.has("_overflowLimit")||a.has("__effectiveI18n")||a.has("_theme")){const p=this._overflowLimit;this.__renderAvatars(p?this.items.slice(0,p):this.items||[])}(a.has("items")||a.has("_overflowLimit"))&&(this.__updateOverflowTooltip(this.items,this._overflowLimit),this.__updateOverflowAvatar(this.items,this._overflowLimit,this.__itemsInView)),(a.has("__effectiveI18n")||a.has("items"))&&this.__i18nItemsChanged(this.__effectiveI18n,this.items),a.has("_opened")&&this.__openedChanged(this._opened,a.get("_opened")),a.has("_theme")&&(this._theme?this._overflow.setAttribute("theme",this._theme):this._overflow.removeAttribute("theme")),(a.has("_overflowItems")||a.has("__effectiveI18n")||a.has("_theme"))&&this.__renderMenu()}__getMessage(a,p){return p.replace("{user}",a.name||a.abbr||this.__effectiveI18n.anonymous)}__renderMenu(){B(x`
          ${(this._overflowItems||[]).map(a=>x`
              <vaadin-avatar-group-menu-item>
                <vaadin-avatar
                  .name="${a.name}"
                  .abbr="${a.abbr}"
                  .img="${a.img}"
                  .colorIndex="${a.colorIndex}"
                  .i18n="${this.__effectiveI18n}"
                  class="${o$2(a.className)}"
                  theme="${o$2(this._theme)}"
                  aria-hidden="true"
                  tabindex="-1"
                ></vaadin-avatar>
                ${a.name||""}
              </vaadin-avatar-group-menu-item>
            `)}
        `,this._menuElement,{host:this})}_onOverflowClick(a){a.stopPropagation(),this._opened?this.$.overlay.close():a.defaultPrevented||(this._opened=!0)}_onOverflowKeyDown(a){this._opened||/^(Enter|SpaceBar|\s)$/u.test(a.key)&&(a.preventDefault(),this._opened=!0)}_onListKeyDown(a){(a.key==="Escape"||a.key==="Tab")&&(this._opened=!1)}_onResize(){this.__setItemsInView()}_onVaadinOverlayClose(a){a.detail.sourceEvent&&a.detail.sourceEvent.composedPath().includes(this)&&a.preventDefault()}_onVaadinOverlayOpen(){this._menuElement&&this._menuElement.focus()}__renderAvatars(a){B(x`
          ${a.map(p=>x`
              <vaadin-avatar
                .name="${p.name}"
                .abbr="${p.abbr}"
                .img="${p.img}"
                .colorIndex="${p.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                theme="${o$2(this._theme)}"
                class="${o$2(p.className)}"
                with-tooltip
              ></vaadin-avatar>
            `)}
        `,this,{renderBefore:this._overflow})}__updateOverflowAvatar(a,p,y){const C=this._overflow;if(C){const P=Array.isArray(a)?a.length:0,z=this.maxItemsVisible!=null&&P>this.__getMax(this.maxItemsVisible);C.abbr=`+${P-p}`;const L=z||y&&y<P;C.toggleAttribute("hidden",!L),this.toggleAttribute("has-overflow",L)}}__updateOverflowTooltip(a,p){if(!Array.isArray(a)||p==null)return;const y=[];for(let C=p;C<a.length;C++){const P=a[C];P&&y.push(P.name||P.abbr||"anonymous")}this._overflowTooltip.text=y.join(`
`)}__getLimit(a,p,y){let C=null;const P=this.__getMax(y);return y!=null&&P<a?C=P-1:p&&p<a&&(C=p),Math.min(C,this.__calculateAvatarsFitWidth())}__getMax(a){return Math.max(a,MINIMUM_DISPLAYED_AVATARS)}__itemsChanged(a,p){this.__setItemsInView();let y=[],C=[];const P=Array.isArray(a),z=Array.isArray(p);z&&(C=p.filter(L=>P&&!a.includes(L))),P&&(y=a.filter(L=>z&&!p.includes(L))),this.__announceItemsChange(y,C)}__announceItemsChange(a,p){let y=[],C=[];a&&(y=a.map(z=>this.__getMessage(z,this.__effectiveI18n.joined||"{user} joined"))),p&&(C=p.map(z=>this.__getMessage(z,this.__effectiveI18n.left||"{user} left")));const P=C.concat(y);P.length>0&&announce(P.join(", "))}__i18nItemsChanged(a,p){if(a&&a.activeUsers){const y=Array.isArray(p)?p.length:0,C=y===1?"one":"many";a.activeUsers[C]&&this.setAttribute("aria-label",a.activeUsers[C].replace("{count}",y||0))}}__openedChanged(a,p){a?this._openedWithFocusRing=this._overflow.hasAttribute("focus-ring"):p&&(this._overflow.focus(),this._openedWithFocusRing&&this._overflow.setAttribute("focus-ring","")),this._overflow.setAttribute("aria-expanded",a===!0)}__setItemsInView(){const a=this._avatars,p=this.items;if(!p||!a||a.length<3)return;let y=this.__calculateAvatarsFitWidth();y===p.length-1&&(y=p.length),y>=p.length&&this._opened&&(this.$.overlay.close(),this.$.overlay._flushAnimation("closing")),this.__itemsInView=y}__calculateAvatarsFitWidth(){if(!this.shadowRoot||this._avatars.length<MINIMUM_DISPLAYED_AVATARS)return MINIMUM_DISPLAYED_AVATARS;const a=this._avatars,p=a[0].clientWidth,{marginLeft:y,marginRight:C}=getComputedStyle(a[1]),P=this.__isRTL?parseInt(C,0)-parseInt(y,0):parseInt(y,0)-parseInt(C,0);return Math.floor((this.$.container.offsetWidth-p)/(p+P))}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1))))){static get is(){return"vaadin-avatar-group"}static get styles(){return avatarGroupStyles}render(){return x`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        .owner="${this}"
        .opened="${this._opened}"
        .positionTarget="${this._overflow}"
        no-vertical-overlap
        exportparts="overlay, content"
        @vaadin-overlay-close="${this._onVaadinOverlayClose}"
        @vaadin-overlay-open="${this._onVaadinOverlayOpen}"
        @opened-changed="${this._onOpenedChanged}"
      >
        <slot name="overlay"></slot>
      </vaadin-avatar-group-overlay>
    `}_onOpenedChanged(d){this._opened=d.detail.value}}defineCustomElement(AvatarGroup);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const CLASSES={SMALL:"small",MEDIUM:"medium",LARGE:"large"},BoardRowMixin=v=>class extends ResizeMixin(v){constructor(){super(),this._oldWidth=0,this._oldBreakpoints={smallSize:600,mediumSize:960},this._oldFlexBasis=[]}ready(){super.ready(),this.$.insertionPoint.addEventListener("slotchange",()=>this.redraw())}connectedCallback(){super.connectedCallback(),this._onResize()}_addStyleNames(a,p){a<p.smallSize?(this.classList.add(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):a<p.mediumSize?(this.classList.remove(CLASSES.SMALL),this.classList.add(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):(this.classList.remove(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.add(CLASSES.LARGE))}_calculateFlexBasis(a,p,y,C){p<C.smallSize?y=1:p<C.mediumSize&&y===4&&(y=2);let P=a/y*100;return P=P>100?100:P,`${P}%`}_reportError(){console.warn("The column configuration is not valid; column count should add up to 3 or 4.",`check: \r
${this.outerHTML}`)}_parseBoardCols(a){const p=a.map(P=>P.getAttribute("board-cols")?parseInt(P.getAttribute("board-cols")):1);let y=4,C=[];return a.forEach((P,z)=>{y-=p[z]}),y<0?(this._reportError(),p.forEach((P,z)=>{C[z]=1})):C=p.slice(0),C}_removeExtraNodesFromDOM(a,p){let y=!1,C=4;const P=[];return p.forEach((z,L)=>{C-=a[L],C<0?(y||(y=!0,this._reportError()),this.removeChild(z)):P[L]=z}),P}redraw(){this._recalculateFlexBasis(!0)}_onResize(){this._recalculateFlexBasis(!1)}_recalculateFlexBasis(a){const p=this.getBoundingClientRect().width,y=this._measureBreakpointsInPx();if(a||this._shouldRecalculate(p,y)){const P=this.$.insertionPoint.assignedNodes({flatten:!0}).filter($=>$.nodeType===Node.ELEMENT_NODE);this._addStyleNames(p,y);const z=this._parseBoardCols(P),L=z.reduce(($,N)=>$+N,0);this._removeExtraNodesFromDOM(z,P).forEach(($,N)=>{const W=this._calculateFlexBasis(z[N],p,L,y);(a||!this._oldFlexBasis[N]||this._oldFlexBasis[N]!==W)&&(this._oldFlexBasis[N]=W,$.style.flexBasis=W)}),this._oldWidth=p,this._oldBreakpoints=y}}_shouldRecalculate(a,p){return isElementHidden(this)?!1:a!==this._oldWidth||p.smallSize!==this._oldBreakpoints.smallSize||p.mediumSize!==this._oldBreakpoints.mediumSize}_measureBreakpointsInPx(){const a={},p="background-position",y=getComputedStyle(this).getPropertyValue("--small-size"),C=getComputedStyle(this).getPropertyValue("--medium-size");return this.style.setProperty(p,y),a.smallSize=parseFloat(getComputedStyle(this).getPropertyValue(p)),this.style.setProperty(p,C),a.mediumSize=parseFloat(getComputedStyle(this).getPropertyValue(p)),this.style.removeProperty(p),a}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class BoardRow extends BoardRowMixin(ElementMixin(PolylitMixin(i$1))){static get is(){return"vaadin-board-row"}static get styles(){return i`
      :host {
        display: flex;
        flex-flow: row wrap;
        align-items: stretch;
        --small-size: var(--vaadin-board-width-small, 600px);
        --medium-size: var(--vaadin-board-width-medium, 960px);
      }

      :host([hidden]) {
        display: none !important;
      }

      :host ::slotted(*) {
        box-sizing: border-box;
        flex-grow: 1;
        overflow: hidden;
      }
    `}render(){return x`<slot id="insertionPoint"></slot>`}}defineCustomElement(BoardRow);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const issuedWarnings=new Set;function issueWarning(v){issuedWarnings.has(v)||(issuedWarnings.add(v),console.warn(v))}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class Board extends ElementMixin(PolylitMixin(i$1)){static get is(){return"vaadin-board"}static get cvdlName(){return"vaadin-board"}static get styles(){return i`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `}firstUpdated(){super.firstUpdated(),issueWarning("`<vaadin-board>` is deprecated and will be removed in Vaadin 26. Consider using `<vaadin-dashboard>` or `<vaadin-dashboard-layout>` as an alternative.")}render(){return x`<slot></slot>`}redraw(){[...this.querySelectorAll("*")].filter(d=>d instanceof BoardRow).forEach(d=>d.redraw())}}defineCustomElement(Board);/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const cardStyles=i`
  :host {
    --_content: 0;
    --_footer: 0;
    --_gap: var(--vaadin-card-gap, var(--vaadin-gap-m));
    --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
    --_header-prefix: 0;
    --_header-suffix: 0;
    --_media: 0;
    --_padding: var(--vaadin-card-padding, var(--vaadin-padding-m));
    --_subtitle: 0;
    --_title: 0;
    background: var(--vaadin-card-background, var(--vaadin-background-container));
    border-radius: var(--vaadin-card-border-radius, var(--vaadin-radius-m));
    box-shadow: var(--vaadin-card-shadow, none);
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    gap: var(--_gap);
    padding: var(--_padding);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but let's reserve that for a potential focus outline */
  :host::before {
    border: var(--vaadin-card-border-width, 0) solid var(--vaadin-card-border-color, var(--vaadin-border-color-subtle));
    border-radius: inherit;
    content: '';
    inset: 0;
    pointer-events: none;
    position: absolute;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([theme~='horizontal'])) {
    justify-content: space-between;
  }

  :host([_m]) {
    --_media: 1;
  }

  :host([_t]) {
    --_title: 1;
  }

  :host([_st]) {
    --_subtitle: 1;
  }

  :host([_h]) {
    --_header: 1;
    --_title: 0;
    --_subtitle: 0;
  }

  :host([_hp]) {
    --_header-prefix: 1;
  }

  :host([_hs]) {
    --_header-suffix: 1;
  }

  :host([_c]) {
    --_content: 1;
  }

  :host([_f]) {
    --_footer: 1;
  }

  [part='media'],
  [part='header'],
  [part='content'],
  [part='footer'] {
    display: none;
  }

  :host([_m]) [part='media'] {
    display: block;
  }

  :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
    align-items: center;
    display: grid;
    gap: var(--_gap);
    row-gap: 0;
  }

  :host([_hs]) [part='header'] {
    grid-template-columns: 1fr auto;
  }

  :host([_hp]) [part='header'] {
    grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
  }

  :host([_c]) [part='content'] {
    display: block;
  }

  :host([_f]) [part='footer'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--_gap);
  }

  slot {
    border-radius: inherit;
  }

  ::slotted([slot='header-prefix']) {
    grid-column: 1;
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  ::slotted([slot='header']),
  ::slotted([slot='title']) {
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: 1;
  }

  ::slotted([slot='title']) {
    color: var(--vaadin-card-title-color, var(--vaadin-color)) !important;
    font-size: var(--vaadin-card-title-font-size, inherit) !important;
    font-weight: var(--vaadin-card-title-font-weight, 500) !important;
    line-height: var(--vaadin-card-title-line-height, inherit) !important;
    margin: 0 !important;
  }

  ::slotted([slot='subtitle']) {
    color: var(--vaadin-card-subtitle-color, var(--vaadin-color-subtle)) !important;
    font-size: var(--vaadin-card-subtitle-font-size, inherit) !important;
    font-weight: var(--vaadin-card-subtitle-font-weight, 400) !important;
    line-height: var(--vaadin-card-subtitle-line-height, inherit) !important;
    margin: 0 !important;
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: calc(1 + var(--_title));
  }

  ::slotted([slot='header-suffix']) {
    grid-column: calc(2 + var(--_header-prefix));
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  /* Horizontal */
  :host([theme~='horizontal']) {
    align-items: start;
    display: grid;
    grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
  }

  :host([theme~='horizontal'][_f]) {
    grid-template-rows: 1fr auto;
  }

  :host([theme~='horizontal'][_c]) {
    grid-template-rows: repeat(var(--_header), auto) 1fr;
  }

  [part='media'] {
    align-self: stretch;
    border-radius: inherit;
    grid-column: 1;
    grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
  }

  [part='header'] {
    margin-bottom: auto;
    grid-column: calc(1 + var(--_media));
    grid-row: 1;
  }

  [part='content'] {
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header));
    flex: auto;
    min-height: 0;
  }

  [part='footer'] {
    border-radius: inherit;
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header) + var(--_content));
  }

  :host([theme~='horizontal']) [part='footer'] {
    align-self: end;
  }

  :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
    max-width: 100%;
  }

  ::slotted([slot='media']) {
    vertical-align: middle;
  }

  :host(:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
    height: auto;
    object-fit: cover;
    /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
    overflow: hidden;
    width: 100%;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
    grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: auto;
    height: 100%;
  }

  :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-end-start-radius: 0;
    margin-inline: calc(var(--_padding) * -1);
    margin-top: calc(var(--_padding) * -1);
    max-width: none;
    width: calc(100% + var(--_padding) * 2);
  }

  :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-start-end-radius: 0;
    height: calc(100% + var(--_padding) * 2);
    margin-inline-end: 0;
    width: calc(100% + var(--_padding));
  }

  /* Scroller in content */
  [part='content'] ::slotted(vaadin-scroller) {
    margin-inline: calc(var(--_padding) * -1);
    padding-inline: var(--_padding);
  }

  [part='content'] ::slotted(vaadin-scroller)::before,
  [part='content'] ::slotted(vaadin-scroller)::after {
    margin-inline: calc(var(--_padding) * -1);
  }

  /* Outlined */
  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
  }

  /* Elevated */
  :host([theme~='elevated']) {
    --vaadin-card-background: var(--vaadin-background-color);
    box-shadow: var(--vaadin-card-shadow, 0 1px 4px -1px rgba(0, 0, 0, 0.3));
  }
`;/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Card extends ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(i$1)))){static get is(){return"vaadin-card"}static get styles(){return cardStyles}static get lumoInjector(){return{includeBaseStyles:!0}}static get properties(){return{cardTitle:{type:String,observer:"__cardTitleChanged"},titleHeadingLevel:{type:Number,reflectToAttribute:!0,observer:"__titleHeadingLevelChanged"}}}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","region")}render(){return x`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `}_onSlotChange(){this.toggleAttribute("_m",this.querySelector(':scope > [slot="media"]')),this.toggleAttribute("_h",this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_t",this.querySelector(':scope > [slot="title"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_st",this.querySelector(':scope > [slot="subtitle"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_hp",this.querySelector(':scope > [slot="header-prefix"]')),this.toggleAttribute("_hs",this.querySelector(':scope > [slot="header-suffix"]')),this.toggleAttribute("_c",this.querySelector(":scope > :not([slot])")),this.toggleAttribute("_f",this.querySelector(':scope > [slot="footer"]')),this.__getCustomTitleElement()&&this.__clearStringTitle()}__clearStringTitle(){const d=this.__getStringTitleElement();d&&this.removeChild(d);const a=this.getAttribute("aria-labelledby");a&&a.startsWith("card-title-")&&this.removeAttribute("aria-labelledby"),this.cardTitle&&(this.cardTitle="")}__getCustomTitleElement(){return Array.from(this.querySelectorAll('[slot="title"]')).find(d=>!d.hasAttribute("card-string-title"))}__cardTitleChanged(d){if(!d){this.__clearStringTitle();return}const a=this.__getCustomTitleElement();a&&this.removeChild(a);let p=this.__getStringTitleElement();p||(p=this.__createStringTitleElement(),this.appendChild(p),this.setAttribute("aria-labelledby",p.id)),p.textContent=d}__createStringTitleElement(){const d=document.createElement("div");return d.setAttribute("slot","title"),d.setAttribute("role","heading"),this.__setTitleHeadingLevel(d,this.titleHeadingLevel),d.setAttribute("card-string-title",""),d.id=`card-title-${generateUniqueId()}`,d}__titleHeadingLevelChanged(d){const a=this.__getStringTitleElement();a&&this.__setTitleHeadingLevel(a,d)}__setTitleHeadingLevel(d,a){d.setAttribute("aria-level",a||2)}__getStringTitleElement(){return this.querySelector('[slot="title"][card-string-title]')}createRenderRoot(){const d=super.createRenderRoot();return d.addEventListener("slotchange",()=>this._onSlotChange()),d}}defineCustomElement(Card);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}function deepMerge(v,d){const a=p=>p&&typeof p=="object"&&!Array.isArray(p);return a(d)&&a(v)&&Object.keys(d).forEach(p=>{a(d[p])?(v[p]||Object.assign(v,{[p]:{}}),deepMerge(v[p],d[p])):Object.assign(v,{[p]:d[p]})}),v}function prepareExport(v){if(!v.tempBodyStyle){let d="";v.shadowRoot.adoptedStyleSheets&&v.shadowRoot.adoptedStyleSheets.forEach(a=>{d+=`${[...a.cssRules].map(p=>p.cssText).join(`
`)}
`}),d=d.replace(/:host\(.+?\)/gu,a=>{const p=a.substr(6,a.length-7);return v.matches(p)?"":a}),d=`${d}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`,v.tempBodyStyle=document.createElement("style"),v.tempBodyStyle.textContent=d,document.body.appendChild(v.tempBodyStyle),v.options.chart.styledMode&&document.body.setAttribute("styled-mode","")}}function cleanupExport(v){v.tempBodyStyle&&(document.body.removeChild(v.tempBodyStyle),delete v.tempBodyStyle,v.options.chart.styledMode&&document.body.removeAttribute("styled-mode"))}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const ChartSeriesMixin=v=>class extends v{static get properties(){return{values:{type:Array,value:()=>[],sync:!0},valueMin:{type:Number,reflectToAttribute:!0,sync:!0},valueMax:{type:Number,reflectToAttribute:!0,sync:!0},type:{type:String,reflectToAttribute:!0,sync:!0},title:{type:String,reflectToAttribute:!0,sync:!0},markers:{type:String,reflectToAttribute:!0,sync:!0},unit:{type:String,reflectToAttribute:!0,sync:!0},stack:{type:String,reflectToAttribute:!0,sync:!0},neckPosition:{type:String,reflectToAttribute:!0,sync:!0},neckWidth:{type:String,reflectToAttribute:!0,sync:!0},options:{type:Object,sync:!0},additionalOptions:{type:Object,reflectToAttribute:!0,sync:!0},_series:{type:Object,sync:!0}}}static get observers(){return["__additionalOptionsObserver(additionalOptions, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values, _series)"]}get options(){const d=deepMerge({},this.additionalOptions);return this.type&&(d.type=this.type),this.title&&(d.name=this.title),this.values&&(d.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),d.marker=this.__markersConfiguration),this.unit&&(d.yAxis=this.unit),this.stack&&(d.stack=this.stack),isFinite(this.valueMin)&&(d.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(d.yAxisValueMax=this.valueMax),this.neckWidth&&(d.neckWidth=this.neckWidth),this.neckPosition&&(d.neckHeight=this.neckPosition),d}get __markersConfiguration(){const d={};switch(this.markers){case"shown":d.enabled=!0;break;case"hidden":d.enabled=!1;break;case"auto":default:d.enabled=null;break}return d}setSeries(d){this._series=d}__valuesObserver(d,a){a&&a.setData(d)}__additionalOptionsObserver(d,a){a&&d&&a.update(d)}__updateAxis(d,a,p){if(!isFinite(a)){this.__showWarn(`value-${p}`,"Numbers or null");return}d&&d.yAxis&&d.yAxis.update({[p]:a})}__valueMinObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"min")}__valueMaxObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"max")}__typeObserver(d,a){d&&a&&a.update({type:d})}__titleObserver(d,a){d===void 0||a==null||a.update({name:d})}__stackObserver(d,a){d===void 0||a==null||a.update({stack:d})}__neckPositionObserver(d,a){d===void 0||a==null||a.update({neckHeight:d})}__neckWidthObserver(d,a){d===void 0||a==null||a.update({neckWidth:d})}__unitObserver(d,a,p,y){if(y&&d!==this.__oldUnit){const C=customElements.get("vaadin-chart");this.__oldUnit=d;const P=this.parentNode instanceof C&&this.parentNode;if(P&&P instanceof C){if(d&&!P.__getAxis(d)){const z={title:{text:d}};P.__addAxis({id:d,axisGenerated:!0,...z})}y.update({yAxis:d||0}),a!==void 0&&this.__updateAxis(y,a,"min"),p!==void 0&&this.__updateAxis(y,p,"max"),P.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(d,a){if(!(d===void 0||a==null)){if(!this.__isMarkersValid()){this.markers="auto";return}a.update({marker:this.__markersConfiguration})}}__showWarn(d,a){console.warn(`<vaadin-chart-series> Acceptable values for "${d}" are ${a}`)}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends ChartSeriesMixin(PolylitMixin(i$1)){static get is(){return"vaadin-chart-series"}}defineCustomElement(ChartSeries);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const tooltipStyles=v=>i`
  ${r$1(v)} .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
    filter: drop-shadow(var(--vaadin-charts-tooltip-shadow, 0 4px 8px rgba(0, 0, 0, 0.2))) !important;
  }

  ${r$1(v)} .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, var(--vaadin-color));
  }

  ${r$1(v)} .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-color-subtle);
  }

  ${r$1(v)} .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, var(--vaadin-border-color-subtle));
    fill: var(--vaadin-charts-tooltip-background, var(--vaadin-background-color));
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  ${r$1(v)} .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, var(--vaadin-background-color));
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
    stroke: var(--vaadin-charts-tooltip-border, var(--vaadin-border-color-subtle));
  }

  ${r$1(v)} .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  ${r$1(v)} div.highcharts-tooltip {
    filter: none;
  }
`;addGlobalThemeStyles("vaadin-charts-tooltip",i`
    .highcharts-tooltip-container .highcharts-root {
      overflow: visible;
      font-size: var(--vaadin-charts-font-size, 0.75rem);
      line-height: normal;
    }
  `,tooltipStyles(".highcharts-tooltip-container"));const chartStyles=i`
  :host {
    display: block;
    width: 100%;
    overflow: hidden;
  }

  :host,
  :root {
    font-size: var(--vaadin-charts-font-size, 0.75rem);
    line-height: normal;

    /* Needs to be a color, not a background image */
    --_bg: var(--vaadin-charts-background, var(--vaadin-background-color));

    --_color-0: var(--vaadin-charts-color-0, var(--vaadin-user-color-0));
    --_color-1: var(--vaadin-charts-color-1, var(--vaadin-user-color-1));
    --_color-2: var(--vaadin-charts-color-2, var(--vaadin-user-color-2));
    --_color-3: var(--vaadin-charts-color-3, var(--vaadin-user-color-3));
    --_color-4: var(--vaadin-charts-color-4, var(--vaadin-user-color-4));
    --_color-5: var(--vaadin-charts-color-5, var(--vaadin-user-color-5));
    --_color-6: var(--vaadin-charts-color-6, var(--vaadin-user-color-6));
    --_color-7: var(--vaadin-charts-color-7, var(--vaadin-user-color-7));
    --_color-8: var(--vaadin-charts-color-8, var(--vaadin-user-color-8));
    --_color-9: var(--vaadin-charts-color-9, var(--vaadin-user-color-9));

    --_color-0-label: oklch(from var(--_color-0) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-1-label: oklch(from var(--_color-1) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-2-label: oklch(from var(--_color-2) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-3-label: oklch(from var(--_color-3) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-4-label: oklch(from var(--_color-4) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-5-label: oklch(from var(--_color-5) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-6-label: oklch(from var(--_color-6) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-7-label: oklch(from var(--_color-7) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-8-label: oklch(from var(--_color-8) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-9-label: oklch(from var(--_color-9) clamp(0, (0.62 - l) * 1000, 1) 0 0);

    --_color-positive: light-dark(#19b156, #1ccc62);
    --_color-negative: light-dark(#dc0611, #f7353f);

    --_label: var(--vaadin-charts-label, var(--vaadin-color));
    --_secondary-label: var(--vaadin-charts-secondary-label, var(--vaadin-color-subtle));
    --_disabled-label: var(--vaadin-charts-disabled-label, var(--vaadin-color-disabled));
    --_point-border: var(--vaadin-charts-point-border, var(--_bg));
    --_axis-line: var(--vaadin-charts-axis-line, var(--vaadin-border-color-subtle));
    --_axis-title: var(--vaadin-charts-axis-title, var(--_secondary-label));
    --_axis-label: var(--vaadin-charts-axis-label, var(--_secondary-label));
    --_grid-line: var(--vaadin-charts-grid-line, var(--vaadin-border-color-subtle));
    --_minor-grid-line: var(
      --vaadin-charts-minor-grid-line,
      color-mix(in srgb, var(--vaadin-border-color-subtle) 60%, transparent)
    );
    --_data-label: var(--vaadin-charts-data-label, var(--_label));
  }

  /* Safari 17 doesn't support relative colors from light-dark() */
  @supports not (color: oklch(from light-dark(red, red) l c h)) {
    :host {
      /* Safari 17 wants degrees instead of raw numbers */
      --_hue-scale: 180deg;
    }
  }

  :host([hidden]) {
    display: none !important;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, var(--_label));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--_secondary-label);
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--_axis-line);
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--_axis-title);
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--_axis-label);
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--_minor-grid-line);
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--_color-0);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--_disabled-label);
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  ${r$1(tooltipStyles(":where([styled-mode])"))};

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--_color-0);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: var(--vaadin-chart-graph-stroke-width, 2);
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: calc(var(--vaadin-chart-graph-stroke-width, 2) + 1);
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--_color-0);
    stroke: var(--_color-0);
    color: var(--_color-0-label);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--_color-1);
    stroke: var(--_color-1);
    color: var(--_color-1-label);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--_color-2);
    stroke: var(--_color-2);
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--_color-3);
    stroke: var(--_color-3);
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--_color-4);
    stroke: var(--_color-4);
    color: var(--_color-4-label);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--_color-5);
    stroke: var(--_color-5);
    color: var(--_color-5-label);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--_color-6);
    stroke: var(--_color-6);
    color: var(--_color-6-label);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--_color-7);
    stroke: var(--_color-7);
    color: var(--_color-7-label);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--_color-8);
    stroke: var(--_color-8);
    color: var(--_color-8-label);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--_color-9);
    stroke: var(--_color-9);
    color: var(--_color-9-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-0 {
    color: var(--_color-0-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-1 {
    color: var(--_color-1-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-2 {
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-3 {
    color: var(--_color-3-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-4 {
    color: var(--_color-4-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-5 {
    color: var(--_color-5-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-6 {
    color: var(--_color-6-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-7 {
    color: var(--_color-7-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-8 {
    color: var(--_color-8-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-9 {
    color: var(--_color-9-label);
  }

  :where([styled-mode]) [class*='highcharts-data-label-color-'] {
    fill: currentColor;
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--_bg);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--_data-label);
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    /* TODO where are these used? */
    fill: var(--_grid-line);
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--_point-border);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--_point-border);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0;
    stroke: var(--_point-border);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-treemap-series [class*='highcharts-data-label-color-'] text {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    /* TODO where is this used? */
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--_data-label);
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, var(--_label));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--_disabled-label) !important;
    stroke: var(--_disabled-label) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, var(--_label));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--_disabled-label);
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--_data-label);
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--_bg);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, var(--_label));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    /* TODO where is this used? */
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--_data-label);
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--_grid-line);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, var(--_label));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--_point-border);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--_point-border);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--_color-0);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--_grid-line);
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--_grid-line);
    fill: var(--_bg);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--_color-1);
    stroke: var(--_color-1);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--_data-label);
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--_data-label);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 5%, transparent);
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, var(--vaadin-background-container));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, var(--_label));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, var(--vaadin-background-container));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, var(--_label));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, var(--_label));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, var(--_bg));
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-disabled-label, var(--vaadin-color-disabled));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > :is(text, .highcharts-label) {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-range-input-background, var(--vaadin-background-container));
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-range-input-background-hover, var(--vaadin-background-container));
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--_data-label);
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--_bg);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-candlestick-line, var(--vaadin-border-color));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--_color-positive);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--_color-negative);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--_grid-line);
    fill: var(--_bg);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--_data-label);
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, var(--_label));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--_bg);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--_axis-label);
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: transparent;
    stroke: var(--vaadin-border-color-subtle);
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--_secondary-label);
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, var(--_label));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, var(--_label));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--_secondary-label);
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, var(--_label));
    fill: var(--vaadin-charts-contrast, var(--_label));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--_disabled-label);
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-organization-series .highcharts-link {
    stroke: var(--vaadin-charts-org-line, color-mix(in srgb, var(--_label) 50%, var(--_bg)));
    stroke-width: var(--vaadin-charts-org-line-width, 1);
  }

  /* Workaround for https://github.com/highcharts/highcharts/issues/22490 */
  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0;
  }
`;var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(v){v.SVG_NS="http://www.w3.org/2000/svg",v.product="Highcharts",v.version="9.2.2",v.win=w,v.doc=v.win.document,v.svg=v.doc&&v.doc.createElementNS&&!!v.doc.createElementNS(v.SVG_NS,"svg").createSVGRect,v.userAgent=v.win.navigator&&v.win.navigator.userAgent||"",v.isChrome=v.userAgent.indexOf("Chrome")!==-1,v.isFirefox=v.userAgent.indexOf("Firefox")!==-1,v.isMS=/(edge|msie|trident)/i.test(v.userAgent)&&!v.win.opera,v.isSafari=!v.isChrome&&v.userAgent.indexOf("Safari")!==-1,v.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(v.userAgent),v.isWebKit=v.userAgent.indexOf("AppleWebKit")!==-1,v.deg2rad=Math.PI*2/360,v.hasBidiBug=v.isFirefox&&parseInt(v.userAgent.split("Firefox/")[1],10)<4,v.hasTouch=!!v.win.TouchEvent,v.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],v.noop=function(){},v.supportsPassiveEvents=(function(){var d=!1;if(!v.isMS){var a=Object.defineProperty({},"passive",{get:function(){d=!0}});v.win.addEventListener&&v.win.removeEventListener&&(v.win.addEventListener("testPassive",v.noop,a),v.win.removeEventListener("testPassive",v.noop,a))}return d})(),v.charts=[],v.dateFormats={},v.seriesTypes={},v.symbolSizes={},v.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$c(v,d,a,p){var y=d?"Highcharts error":"Highcharts warning";v===32&&(v=y+": Deprecated member");var C=isNumber$X(v),P=C?y+" #"+v+": www.highcharts.com/errors/"+v+"/":v.toString(),z=function(){if(d)throw new Error(P);win$g.console&&error$c.messages.indexOf(P)===-1&&console.warn(P)};if(typeof p<"u"){var L="";C&&(P+="?"),objectEach$D(p,function($,N){L+=`
 - `+N+": "+$,C&&(P+=encodeURI(N)+"="+encodeURI($))}),P+=L}fireEvent$C(H,"displayError",{chart:a,code:v,message:P,params:p},z),error$c.messages.push(P)}(function(v){v.messages=[]})(error$c||(error$c={}));function merge$1x(){var v,d=arguments,a={},p=function(C,P){return typeof C!="object"&&(C={}),objectEach$D(P,function(z,L){L==="__proto__"||L==="constructor"||(isObject$i(z,!0)&&!isClass(z)&&!isDOMElement(z)?C[L]=p(C[L]||{},z):C[L]=P[L])}),C};d[0]===!0&&(a=d[1],d=Array.prototype.slice.call(d,2));var y=d.length;for(v=0;v<y;v++)a=p(a,d[v]);return a}function clamp$l(v,d,a){return v>d?v<a?v:a:d}function cleanRecursively$2(v,d){var a={};return objectEach$D(v,function(p,y){var C;isObject$i(v[y],!0)&&!v.nodeType&&d[y]?(C=cleanRecursively$2(v[y],d[y]),Object.keys(C).length&&(a[y]=C)):(isObject$i(v[y])||v[y]!==d[y])&&(a[y]=v[y])}),a}function pInt$a(v,d){return parseInt(v,d||10)}function isString$d(v){return typeof v=="string"}function isArray$q(v){var d=Object.prototype.toString.call(v);return d==="[object Array]"||d==="[object Array Iterator]"}function isObject$i(v,d){return!!v&&typeof v=="object"&&(!d||!isArray$q(v))}function isDOMElement(v){return isObject$i(v)&&typeof v.nodeType=="number"}function isClass(v){var d=v&&v.constructor;return!!(isObject$i(v,!0)&&!isDOMElement(v)&&d&&d.name&&d.name!=="Object")}function isNumber$X(v){return typeof v=="number"&&!isNaN(v)&&v<1/0&&v>-1/0}function erase$a(v,d){for(var a=v.length;a--;)if(v[a]===d){v.splice(a,1);break}}function defined$_(v){return typeof v<"u"&&v!==null}function attr$8(v,d,a){var p;return isString$d(d)?defined$_(a)?v.setAttribute(d,a):v&&v.getAttribute&&(p=v.getAttribute(d),!p&&d==="class"&&(p=v.getAttribute(d+"Name"))):objectEach$D(d,function(y,C){v.setAttribute(C,y)}),p}function splat$l(v){return isArray$q(v)?v:[v]}function syncTimeout$9(v,d,a){return d>0?setTimeout(v,d,a):(v.call(0,a),-1)}function internalClearTimeout(v){defined$_(v)&&clearTimeout(v)}function extend$1y(v,d){var a;v||(v={});for(a in d)v[a]=d[a];return v}function pick$1K(){for(var v=arguments,d=v.length,a=0;a<d;a++){var p=v[a];if(typeof p<"u"&&p!==null)return p}}function css$d(v,d){H.isMS&&!H.svg&&d&&typeof d.opacity<"u"&&(d.filter="alpha(opacity="+d.opacity*100+")"),extend$1y(v.style,d)}function createElement$b(v,d,a,p,y){var C=doc$m.createElement(v);return d&&extend$1y(C,d),y&&css$d(C,{padding:"0",border:"none",margin:"0"}),a&&css$d(C,a),p&&p.appendChild(C),C}function extendClass$2(v,d){var a=(function(){});return a.prototype=new v,extend$1y(a.prototype,d),a}function pad$2(v,d,a){return new Array((d||2)+1-String(v).replace("-","").length).join(a||"0")+v}function relativeLength$a(v,d,a){return/%$/.test(v)?d*parseFloat(v)/100+(a||0):parseFloat(v)}function wrap$i(v,d,a){var p=v[d];v[d]=function(){var y=Array.prototype.slice.call(arguments),C=arguments,P=this;P.proceed=function(){p.apply(P,arguments.length?arguments:C)},y.unshift(p);var z=a.apply(this,y);return P.proceed=null,z}}function getMagnitude$3(v){return Math.pow(10,Math.floor(Math.log(v)/Math.LN10))}function normalizeTickInterval$3(v,d,a,p,y){var C,P=v;a=pick$1K(a,1);var z=v/a;for(d||(d=y?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],p===!1&&(a===1?d=d.filter(function(L){return L%1===0}):a<=.1&&(d=[1/a]))),C=0;C<d.length&&(P=d[C],!(y&&P*a>=v||!y&&z<=(d[C]+(d[C+1]||d[C]))/2));C++);return P=correctFloat$d(P*a,-Math.round(Math.log(.001)/Math.LN10)),P}function stableSort$7(v,d){var a=v.length,p,y;for(y=0;y<a;y++)v[y].safeI=y;for(v.sort(function(C,P){return p=d(C,P),p===0?C.safeI-P.safeI:p}),y=0;y<a;y++)delete v[y].safeI}function arrayMin$9(v){for(var d=v.length,a=v[0];d--;)v[d]<a&&(a=v[d]);return a}function arrayMax$a(v){for(var d=v.length,a=v[0];d--;)v[d]>a&&(a=v[d]);return a}function destroyObjectProperties$a(v,d){objectEach$D(v,function(a,p){a&&a!==d&&a.destroy&&a.destroy(),delete v[p]})}function discardElement$7(v){garbageBin||(garbageBin=createElement$b("div")),v&&garbageBin.appendChild(v),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(v,d){return parseFloat(v.toPrecision(d||14))}var timeUnits$4={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:168*36e5,month:672*36e5,year:364*24*36e5};Math.easeInOutSine=function(v){return-.5*(Math.cos(Math.PI*v)-1)};function getNestedProperty$3(v,d){for(var a=v.split(".");a.length&&defined$_(d);){var p=a.shift();if(typeof p>"u"||p==="__proto__")return;var y=d[p];if(!defined$_(y)||typeof y=="function"||typeof y.nodeType=="number"||y===win$g)return;d=y}return d}function getStyle$2(v,d,a){var p=H.getStyle||getStyle$2,y;if(d==="width"){var C=Math.min(v.offsetWidth,v.scrollWidth),P=v.getBoundingClientRect&&v.getBoundingClientRect().width;return P<C&&P>=C-1&&(C=Math.floor(P)),Math.max(0,C-(p(v,"padding-left",!0)||0)-(p(v,"padding-right",!0)||0))}if(d==="height")return Math.max(0,Math.min(v.offsetHeight,v.scrollHeight)-(p(v,"padding-top",!0)||0)-(p(v,"padding-bottom",!0)||0));win$g.getComputedStyle||error$c(27,!0);var z=win$g.getComputedStyle(v,void 0);return z&&(y=z.getPropertyValue(d),pick$1K(a,d!=="opacity")&&(y=pInt$a(y))),y}function inArray(v,d,a){return error$c(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),d.indexOf(v,a)}var find$l=Array.prototype.find?function(v,d){return v.find(d)}:(function(v,d){var a,p=v.length;for(a=0;a<p;a++)if(d(v[a],a))return v[a]});function keys(v){return error$c(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(v)}function offset$1(v){var d=doc$m.documentElement,a=v.parentElement||v.parentNode?v.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:a.top+(win$g.pageYOffset||d.scrollTop)-(d.clientTop||0),left:a.left+(win$g.pageXOffset||d.scrollLeft)-(d.clientLeft||0),width:a.width,height:a.height}}function objectEach$D(v,d,a){for(var p in v)Object.hasOwnProperty.call(v,p)&&d.call(a||v[p],v[p],p,v)}objectEach$D({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(v,d){H[d]=function(a){var p;return error$c(32,!1,void 0,(p={},p["Highcharts."+d]="use Array."+v,p)),Array.prototype[v].apply(a,[].slice.call(arguments,1))}});function addEvent$19(v,d,a,p){p===void 0&&(p={});var y=typeof v=="function"&&v.prototype||v;Object.hasOwnProperty.call(y,"hcEvents")||(y.hcEvents={});var C=y.hcEvents;H.Point&&v instanceof H.Point&&v.series&&v.series.chart&&(v.series.chart.runTrackerClick=!0);var P=v.addEventListener||H.addEventListenerPolyfill;P&&P.call(v,d,a,H.supportsPassiveEvents?{passive:p.passive===void 0?d.indexOf("touch")!==-1:p.passive,capture:!1}:!1),C[d]||(C[d]=[]);var z={fn:a,order:typeof p.order=="number"?p.order:1/0};return C[d].push(z),C[d].sort(function(L,$){return L.order-$.order}),function(){removeEvent$c(v,d,a)}}function removeEvent$c(v,d,a){function p(L,$){var N=v.removeEventListener||H.removeEventListenerPolyfill;N&&N.call(v,L,$,!1)}function y(L){var $,N;v.nodeName&&(d?($={},$[d]=!0):$=L,objectEach$D($,function(W,U){if(L[U])for(N=L[U].length;N--;)p(U,L[U][N].fn)}))}var C=typeof v=="function"&&v.prototype||v;if(Object.hasOwnProperty.call(C,"hcEvents")){var P=C.hcEvents;if(d){var z=P[d]||[];a?(P[d]=z.filter(function(L){return a!==L.fn}),p(d,a)):(y(P),P[d]=[])}else y(P),delete C.hcEvents}}function fireEvent$C(v,d,a,p){var y;if(a=a||{},doc$m.createEvent&&(v.dispatchEvent||v.fireEvent&&v!==H))y=doc$m.createEvent("Events"),y.initEvent(d,!0,!0),a=extend$1y(y,a),v.dispatchEvent?v.dispatchEvent(a):v.fireEvent(d,a);else if(v.hcEvents){a.target||extend$1y(a,{preventDefault:function(){a.defaultPrevented=!0},target:v,type:d});for(var C=[],P=v,z=!1;P.hcEvents;)Object.hasOwnProperty.call(P,"hcEvents")&&P.hcEvents[d]&&(C.length&&(z=!0),C.unshift.apply(C,P.hcEvents[d])),P=Object.getPrototypeOf(P);z&&C.sort(function(L,$){return L.order-$.order}),C.forEach(function(L){L.fn.call(v,a)===!1&&a.preventDefault()})}p&&!a.defaultPrevented&&p.call(v,a)}var serialMode,uniqueKey$8=(function(){var v=Math.random().toString(36).substring(2,9)+"-",d=0;return function(){return"highcharts-"+(serialMode?"":v)+d++}})();function useSerialIds(v){return serialMode=pick$1K(v,serialMode)}function isFunction$5(v){return typeof v=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var v=[].slice.call(arguments);if(this[0])return v[0]?(new H[isString$d(v[0])?v.shift():"Chart"](this[0],v[0],v[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$19,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$l,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$_,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$a,error:error$c,extend:extend$1y,extendClass:extendClass$2,find:find$l,fireEvent:fireEvent$C,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$q,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$X,isObject:isObject$i,isString:isString$d,keys,merge:merge$1x,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$D,offset:offset$1,pad:pad$2,pick:pick$1K,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$l,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$4,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$i},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$W=Utilities.isNumber,merge$1w=Utilities.merge,pInt$9=Utilities.pInt,Color=(function(){function v(d){this.rgba=[NaN,NaN,NaN,NaN],this.input=d;var a=H.Color;if(a&&a!==v)return new a(d);if(!(this instanceof v))return new v(d);this.init(d)}return v.parse=function(d){return d?new v(d):v.None},v.prototype.init=function(d){var a,p,y,C;if(typeof d=="object"&&typeof d.stops<"u")this.stops=d.stops.map(function(L){return new v(L[1])});else if(typeof d=="string"){if(this.input=d=v.names[d.toLowerCase()]||d,d.charAt(0)==="#"){var P=d.length,z=parseInt(d.substr(1),16);P===7?p=[(z&16711680)>>16,(z&65280)>>8,z&255,1]:P===4&&(p=[(z&3840)>>4|(z&3840)>>8,(z&240)>>4|z&240,(z&15)<<4|z&15,1])}if(!p)for(y=v.parsers.length;y--&&!p;)C=v.parsers[y],a=C.regex.exec(d),a&&(p=C.parse(a))}p&&(this.rgba=p)},v.prototype.get=function(d){var a=this.input,p=this.rgba;if(typeof a=="object"&&typeof this.stops<"u"){var y=merge$1w(a);return y.stops=[].slice.call(y.stops),this.stops.forEach(function(C,P){y.stops[P]=[y.stops[P][0],C.get(d)]}),y}return p&&isNumber$W(p[0])?d==="rgb"||!d&&p[3]===1?"rgb("+p[0]+","+p[1]+","+p[2]+")":d==="a"?""+p[3]:"rgba("+p.join(",")+")":a},v.prototype.brighten=function(d){var a=this.rgba;if(this.stops)this.stops.forEach(function(y){y.brighten(d)});else if(isNumber$W(d)&&d!==0)for(var p=0;p<3;p++)a[p]+=pInt$9(d*255),a[p]<0&&(a[p]=0),a[p]>255&&(a[p]=255);return this},v.prototype.setOpacity=function(d){return this.rgba[3]=d,this},v.prototype.tweenTo=function(d,a){var p=this.rgba,y=d.rgba;if(!isNumber$W(p[0])||!isNumber$W(y[0]))return d.input||"none";var C=y[3]!==1||p[3]!==1;return(C?"rgba(":"rgb(")+Math.round(y[0]+(p[0]-y[0])*(1-a))+","+Math.round(y[1]+(p[1]-y[1])*(1-a))+","+Math.round(y[2]+(p[2]-y[2])*(1-a))+(C?","+(y[3]+(p[3]-y[3])*(1-a)):"")+")"},v.names={white:"#ffffff",black:"#000000"},v.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),parseFloat(d[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),1]}}],v.None=new v(""),v})(),win$f=H.win,defined$Z=Utilities.defined,error$b=Utilities.error,extend$1x=Utilities.extend,isObject$h=Utilities.isObject,merge$1v=Utilities.merge,objectEach$C=Utilities.objectEach,pad$1=Utilities.pad,pick$1J=Utilities.pick,splat$k=Utilities.splat,timeUnits$3=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=(function(){function v(d){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(d)}return v.prototype.get=function(d,a){if(this.variableTimezone||this.timezoneOffset){var p=a.getTime(),y=p-this.getTimezoneOffset(a);a.setTime(y);var C=a["getUTC"+d]();return a.setTime(p),C}return this.useUTC?a["getUTC"+d]():a["get"+d]()},v.prototype.set=function(d,a,p){if(this.variableTimezone||this.timezoneOffset){if(d==="Milliseconds"||d==="Seconds"||d==="Minutes"&&this.getTimezoneOffset(a)%36e5===0)return a["setUTC"+d](p);var y=this.getTimezoneOffset(a),C=a.getTime()-y;a.setTime(C),a["setUTC"+d](p);var P=this.getTimezoneOffset(a);return C=a.getTime()+P,a.setTime(C)}return this.useUTC||hasNewSafariBug&&d==="FullYear"?a["setUTC"+d](p):a["set"+d](p)},v.prototype.update=function(d){var a=pick$1J(d&&d.useUTC,!0);this.options=d=merge$1v(!0,this.options||{},d),this.Date=d.Date||win$f.Date||Date,this.useUTC=a,this.timezoneOffset=a&&d.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=a&&!!(d.getTimezoneOffset||d.timezone)},v.prototype.makeTime=function(d,a,p,y,C,P){var z,L,$;return this.useUTC?(z=this.Date.UTC.apply(0,arguments),L=this.getTimezoneOffset(z),z+=L,$=this.getTimezoneOffset(z),L!==$?z+=$-L:L-36e5===this.getTimezoneOffset(z-36e5)&&!hasOldSafariBug&&(z-=36e5)):z=new this.Date(d,a,pick$1J(p,1),pick$1J(y,0),pick$1J(C,0),pick$1J(P,0)).getTime(),z},v.prototype.timezoneOffsetFunction=function(){var d=this,a=this.options,p=a.moment||win$f.moment;if(!this.useUTC)return function(y){return new Date(y.toString()).getTimezoneOffset()*6e4};if(a.timezone)if(!p)error$b(25);else return function(y){return-p.tz(y,a.timezone).utcOffset()*6e4};return this.useUTC&&a.getTimezoneOffset?function(y){return a.getTimezoneOffset(y.valueOf())*6e4}:function(){return(d.timezoneOffset||0)*6e4}},v.prototype.dateFormat=function(d,a,p){if(!defined$Z(a)||isNaN(a))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";d=pick$1J(d,"%Y-%m-%d %H:%M:%S");var y=this,C=new this.Date(a),P=this.get("Hours",C),z=this.get("Day",C),L=this.get("Date",C),$=this.get("Month",C),N=this.get("FullYear",C),W=H.defaultOptions.lang,U=W&&W.weekdays,j=W&&W.shortWeekdays,q=extend$1x({a:j?j[z]:U[z].substr(0,3),A:U[z],d:pad$1(L),e:pad$1(L,2," "),w:z,b:W.shortMonths[$],B:W.months[$],m:pad$1($+1),o:$+1,y:N.toString().substr(2,2),Y:N,H:pad$1(P),k:P,I:pad$1(P%12||12),l:P%12||12,M:pad$1(this.get("Minutes",C)),p:P<12?"AM":"PM",P:P<12?"am":"pm",S:pad$1(C.getSeconds()),L:pad$1(Math.floor(a%1e3),3)},H.dateFormats);return objectEach$C(q,function(X,K){for(;d.indexOf("%"+K)!==-1;)d=d.replace("%"+K,typeof X=="function"?X.call(y,a):X)}),p?d.substr(0,1).toUpperCase()+d.substr(1):d},v.prototype.resolveDTLFormat=function(d){return isObject$h(d,!0)?d:(d=splat$k(d),{main:d[0],from:d[1],to:d[2]})},v.prototype.getTimeTicks=function(d,a,p,y){var C=this,P=C.Date,z=[],L={},$=new P(a),N=d.unitRange,W=d.count||1,U,j,q,X;if(y=pick$1J(y,1),defined$Z(a)){C.set("Milliseconds",$,N>=timeUnits$3.second?0:W*Math.floor(C.get("Milliseconds",$)/W)),N>=timeUnits$3.second&&C.set("Seconds",$,N>=timeUnits$3.minute?0:W*Math.floor(C.get("Seconds",$)/W)),N>=timeUnits$3.minute&&C.set("Minutes",$,N>=timeUnits$3.hour?0:W*Math.floor(C.get("Minutes",$)/W)),N>=timeUnits$3.hour&&C.set("Hours",$,N>=timeUnits$3.day?0:W*Math.floor(C.get("Hours",$)/W)),N>=timeUnits$3.day&&C.set("Date",$,N>=timeUnits$3.month?1:Math.max(1,W*Math.floor(C.get("Date",$)/W))),N>=timeUnits$3.month&&(C.set("Month",$,N>=timeUnits$3.year?0:W*Math.floor(C.get("Month",$)/W)),j=C.get("FullYear",$)),N>=timeUnits$3.year&&(j-=j%W,C.set("FullYear",$,j)),N===timeUnits$3.week&&(X=C.get("Day",$),C.set("Date",$,C.get("Date",$)-X+y+(X<y?-7:0))),j=C.get("FullYear",$);var K=C.get("Month",$),Q=C.get("Date",$),te=C.get("Hours",$);a=$.getTime(),(C.variableTimezone||!C.useUTC)&&defined$Z(p)&&(q=p-a>4*timeUnits$3.month||C.getTimezoneOffset(a)!==C.getTimezoneOffset(p));var ne=$.getTime();for(U=1;ne<p;)z.push(ne),N===timeUnits$3.year?ne=C.makeTime(j+U*W,0):N===timeUnits$3.month?ne=C.makeTime(j,K+U*W):q&&(N===timeUnits$3.day||N===timeUnits$3.week)?ne=C.makeTime(j,K,Q+U*W*(N===timeUnits$3.day?1:7)):q&&N===timeUnits$3.hour&&W>1?ne=C.makeTime(j,K,Q,te+U*W):ne+=N*W,U++;z.push(ne),N<=timeUnits$3.hour&&z.length<1e4&&z.forEach(function(ie){ie%18e5===0&&C.dateFormat("%H%M%S%L",ie)==="000000000"&&(L[ie]="day")})}return z.info=extend$1x(d,{higherRanks:L,totalRange:N*W}),z},v.prototype.getDateFormat=function(d,a,p,y){var C=this.dateFormat("%m-%d %H:%M:%S.%L",a),P="01-01 00:00:00.000",z={millisecond:15,second:12,minute:9,hour:6,day:3},L,$,N="millisecond";for($ in timeUnits$3){if(d===timeUnits$3.week&&+this.dateFormat("%w",a)===p&&C.substr(6)===P.substr(6)){$="week";break}if(timeUnits$3[$]>d){$=N;break}if(z[$]&&C.substr(z[$])!==P.substr(z[$]))break;$!=="week"&&(N=$)}return $&&(L=this.resolveDTLFormat(y[$]).main),L},v})(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$7=H.svg,merge$1u=Utilities.merge,defaultOptions$j={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$7,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$j.chart.styledMode=!1;var defaultTime$2=new Time(merge$1u(defaultOptions$j.global,defaultOptions$j.time));function getOptions$4(){return defaultOptions$j}function setOptions$2(v){return merge$1u(!0,defaultOptions$j,v),(v.time||v.global)&&(H.time?H.time.update(merge$1u(defaultOptions$j.global,defaultOptions$j.time,v.global,v.time)):H.time=defaultTime$2),defaultOptions$j}var DefaultOptions={defaultOptions:defaultOptions$j,defaultTime:defaultTime$2,getOptions:getOptions$4,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$V=Utilities.isNumber,objectEach$B=Utilities.objectEach,Fx=(function(){function v(d,a,p){this.pos=NaN,this.options=a,this.elem=d,this.prop=p}return v.prototype.dSetter=function(){var d=this.paths,a=d&&d[0],p=d&&d[1],y=this.now||0,C=[];if(y===1||!a||!p)C=this.toD||[];else if(a.length===p.length&&y<1)for(var P=0;P<p.length;P++){for(var z=a[P],L=p[P],$=[],N=0;N<L.length;N++){var W=z[N],U=L[N];isNumber$V(W)&&isNumber$V(U)&&!(L[0]==="A"&&(N===4||N===5))?$[N]=W+y*(U-W):$[N]=U}C.push($)}else C=p;this.elem.attr("d",C,void 0,!0)},v.prototype.update=function(){var d=this.elem,a=this.prop,p=this.now,y=this.options.step;this[a+"Setter"]?this[a+"Setter"]():d.attr?d.element&&d.attr(a,p,null,!0):d.style[a]=p+this.unit,y&&y.call(d,p,this)},v.prototype.run=function(d,a,p){var y=this,C=y.options,P=function($){return P.stopped?!1:y.step($)},z=win$e.requestAnimationFrame||function($){setTimeout($,13)},L=function(){for(var $=0;$<v.timers.length;$++)v.timers[$]()||v.timers.splice($--,1);v.timers.length&&z(L)};d===a&&!this.elem["forceAnimate:"+this.prop]?(delete C.curAnim[this.prop],C.complete&&Object.keys(C.curAnim).length===0&&C.complete.call(this.elem)):(this.startTime=+new Date,this.start=d,this.end=a,this.unit=p,this.now=this.start,this.pos=0,P.elem=this.elem,P.prop=this.prop,P()&&v.timers.push(P)===1&&z(L))},v.prototype.step=function(d){var a=+new Date,p=this.options,y=this.elem,C=p.complete,P=p.duration,z=p.curAnim,L,$;return y.attr&&!y.element?L=!1:d||a>=P+this.startTime?(this.now=this.end,this.pos=1,this.update(),z[this.prop]=!0,$=!0,objectEach$B(z,function(N){N!==!0&&($=!1)}),$&&C&&C.call(y),L=!1):(this.pos=p.easing((a-this.startTime)/P),this.now=this.start+(this.end-this.start)*this.pos,this.update(),L=!0),L},v.prototype.initPath=function(d,a,p){var y=d.startX,C=d.endX,P=p.slice(),z=d.isArea,L=z?2:1,$,N,W,U,j=a&&a.slice();if(!j)return[P,P];function q(K,Q){for(;K.length<N;){var te=K[0],ne=Q[N-K.length];if(ne&&te[0]==="M"&&(ne[0]==="C"?K[0]=["C",te[1],te[2],te[1],te[2],te[1],te[2]]:K[0]=["L",te[1],te[2]]),K.unshift(te),z){var ie=K.pop();K.push(K[K.length-1],ie)}}}function X(K,Q){for(;K.length<N;){var te=K[Math.floor(K.length/L)-1].slice();if(te[0]==="C"&&(te[1]=te[5],te[2]=te[6]),!z)K.push(te);else{var ne=K[Math.floor(K.length/L)].slice();K.splice(K.length/2,0,te,ne)}}}if(y&&C&&C.length){for(W=0;W<y.length;W++)if(y[W]===C[0]){$=W;break}else if(y[0]===C[C.length-y.length+W]){$=W,U=!0;break}else if(y[y.length-1]===C[C.length-y.length+W]){$=y.length-W;break}typeof $>"u"&&(j=[])}return j.length&&isNumber$V($)&&(N=P.length+$*L,U?(q(j,P),X(P)):(q(P,j),X(j))),[j,P]},v.prototype.fillSetter=function(){v.prototype.strokeSetter.apply(this,arguments)},v.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},v.timers=[],v})(),defined$Y=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$p=Utilities.isArray,isNumber$U=Utilities.isNumber,isObject$g=Utilities.isObject,merge$1t=Utilities.merge,objectEach$A=Utilities.objectEach,pick$1I=Utilities.pick;function setAnimation$5(v,d){d.renderer.globalAnimation=pick$1I(v,d.options.chart.animation,!0)}function animObject$d(v){return isObject$g(v)?merge$1t({duration:500,defer:0},v):{duration:v?500:0,defer:0}}function getDeferredAnimation$3(v,d,a){var p=animObject$d(d),y=a?[a]:v.series,C=0,P=0;y.forEach(function(L){var $=animObject$d(L.options.animation);C=d&&defined$Y(d.defer)?p.defer:Math.max(C,$.duration+$.defer),P=Math.min(p.duration,$.duration)}),v.renderer.forExport&&(C=0);var z={defer:Math.max(0,C-P),duration:Math.min(C,P)};return z}function animate$2(v,d,a){var p,y="",C,P,z;isObject$g(a)||(z=arguments,a={duration:z[2],easing:z[3],complete:z[4]}),isNumber$U(a.duration)||(a.duration=400),a.easing=typeof a.easing=="function"?a.easing:Math[a.easing]||Math.easeInOutSine,a.curAnim=merge$1t(d),objectEach$A(d,function(L,$){stop$2(v,$),P=new Fx(v,a,$),C=void 0,$==="d"&&isArray$p(d.d)?(P.paths=P.initPath(v,v.pathArray,d.d),P.toD=d.d,p=0,C=1):v.attr?p=v.attr($):(p=parseFloat(getStyle$1(v,$))||0,$!=="opacity"&&(y="px")),C||(C=L),typeof C=="string"&&C.match("px")&&(C=C.replace(/px/g,"")),P.run(p,C,y)})}function stop$2(v,d){for(var a=Fx.timers.length;a--;)Fx.timers[a].elem===v&&(!d||d===Fx.timers[a].prop)&&(Fx.timers[a].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$d,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$a=Utilities.error,isString$c=Utilities.isString,objectEach$z=Utilities.objectEach,splat$j=Utilities.splat,hasValidDOMParser=(function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}})(),AST=(function(){function v(d){this.nodes=typeof d=="string"?this.parseMarkup(d):d}return v.filterUserAttributes=function(d){return objectEach$z(d,function(a,p){var y=!0;v.allowedAttributes.indexOf(p)===-1&&(y=!1),["background","dynsrc","href","lowsrc","src"].indexOf(p)!==-1&&(y=isString$c(a)&&v.allowedReferences.some(function(C){return a.indexOf(C)===0})),y||(error$a("Highcharts warning: Invalid attribute '"+p+"' in config"),delete d[p])}),d},v.setElementHTML=function(d,a){if(d.innerHTML="",a){var p=new v(a);p.addToDOM(d)}},v.prototype.addToDOM=function(d){function a(p,y){var C;return splat$j(p).forEach(function(P){var z=P.tagName,L=P.textContent?H.doc.createTextNode(P.textContent):void 0,$;if(z)if(z==="#text")$=L;else if(v.allowedTags.indexOf(z)!==-1){var N=z==="svg"?SVG_NS$3:y.namespaceURI||SVG_NS$3,W=H.doc.createElementNS(N,z),U=P.attributes||{};objectEach$z(P,function(j,q){q!=="tagName"&&q!=="attributes"&&q!=="children"&&q!=="textContent"&&(U[q]=j)}),attr$7(W,v.filterUserAttributes(U)),L&&W.appendChild(L),a(P.children||[],W),$=W}else error$a("Highcharts warning: Invalid tagName '"+z+"' in config");$&&y.appendChild($),C=$}),C}return a(this.nodes,d)},v.prototype.parseMarkup=function(d){var a=[];d=d.trim();var p,y;hasValidDOMParser?p=new DOMParser().parseFromString(d,"text/html"):(y=createElement$a("div"),y.innerHTML=d,p={body:y});var C=function(P,z){var L=P.nodeName.toLowerCase(),$={tagName:L};L==="#text"&&($.textContent=P.textContent||"");var N=P.attributes;if(N){var W={};[].forEach.call(N,function(j){W[j.name]=j.value}),$.attributes=W}if(P.childNodes.length){var U=[];[].forEach.call(P.childNodes,function(j){C(j,U)}),U.length&&($.children=U)}z.push($)};return[].forEach.call(p.body.childNodes,function(P){return C(P,a)}),y&&discardElement$6(y),a},v.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],v.allowedReferences=["https://","http://","mailto:","/","../","./","#"],v.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],v})(),defaultOptions$i=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$T=Utilities.isNumber,pick$1H=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(v,d,a){return defaultTime$1.dateFormat(v,d,a)}function format$e(v,d,a){for(var p="{",y=!1,C,P,z,L,$=/f$/,N=/\.([0-9])/,W=defaultOptions$i.lang,U=a&&a.time||defaultTime$1,j=a&&a.numberFormatter||numberFormat$2,q=[];v&&(L=v.indexOf(p),L!==-1);){if(C=v.slice(0,L),y){if(P=C.split(":"),z=getNestedProperty$2(P.shift()||"",d),P.length&&typeof z=="number")if(C=P.join(":"),$.test(C)){var X=parseInt((C.match(N)||["","-1"])[1],10);z!==null&&(z=j(z,X,W.decimalPoint,C.indexOf(",")>-1?W.thousandsSep:""))}else z=U.dateFormat(C,z);q.push(z)}else q.push(C);v=v.slice(L+1),y=!y,p=y?"}":"{"}return q.push(v),q.join("")}function numberFormat$2(v,d,a,p){v=+v||0,d=+d;var y,C,P=defaultOptions$i.lang,z=(v.toString().split(".")[1]||"").split("e")[0].length,L=v.toString().split("e"),$=d;d===-1?d=Math.min(z,20):isNumber$T(d)?d&&L[1]&&L[1]<0&&(C=d+ +L[1],C>=0?(L[0]=(+L[0]).toExponential(C).split("e")[0],d=C):(L[0]=L[0].split(".")[0]||0,d<20?v=(L[0]*Math.pow(10,L[1])).toFixed(d):v=0,L[1]=0)):d=2;var N=(Math.abs(L[1]?L[0]:v)+Math.pow(10,-Math.max(d,z)-1)).toFixed(d),W=String(pInt$8(N)),U=W.length>3?W.length%3:0;return a=pick$1H(a,P.decimalPoint),p=pick$1H(p,P.thousandsSep),y=v<0?"-":"",y+=U?W.substr(0,U)+p:"",+L[1]<0&&!$?y="0":y+=W.substr(U).replace(/(\d{3})(?=\d)/g,"$1"+p),d&&(y+=a+N.slice(-d)),L[1]&&+y!=0&&(y+="e"+L[1]),y}var FormatUtilities={dateFormat,format:format$e,numberFormat:numberFormat$2},clamp$k=Utilities.clamp,pick$1G=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(v){function d(a,p,y){var C=a,P=C.reducedLen||p,z=function(X,K){return(K.rank||0)-(X.rank||0)},L=function(X,K){return X.target-K.target},$,N=!0,W=[],U,j,q=0;for($=a.length;$--;)q+=a[$].size;if(q>P){for(stableSort$6(a,z),$=0,q=0;q<=P;)q+=a[$].size,$++;W=a.splice($-1,a.length)}for(stableSort$6(a,L),a=a.map(function(X){return{size:X.size,targets:[X.target],align:pick$1G(X.align,.5)}});N;){for($=a.length;$--;)U=a[$],j=(Math.min.apply(0,U.targets)+Math.max.apply(0,U.targets))/2,U.pos=clamp$k(j-U.size*U.align,0,p-U.size);for($=a.length,N=!1;$--;)$>0&&a[$-1].pos+a[$-1].size>a[$].pos&&(a[$-1].size+=a[$].size,a[$-1].targets=a[$-1].targets.concat(a[$].targets),a[$-1].align=.5,a[$-1].pos+a[$-1].size>p&&(a[$-1].pos=p-a[$-1].size),a.splice($,1),N=!0)}return C.push.apply(C,W),$=0,a.some(function(X){var K=0;return(X.targets||[]).some(function(){return C[$].pos=X.pos+K,typeof y<"u"&&Math.abs(C[$].pos-C[$].target)>y?(C.slice(0,$+1).forEach(function(Q){return delete Q.pos}),C.reducedLen=(C.reducedLen||p)-p*.1,C.reducedLen>p*.1&&d(C,p,y),!0):(K+=C[$].size,$++,!1)})}),stableSort$6(C,L),C}v.distribute=d})(RendererUtilities||(RendererUtilities={}));const R$1=RendererUtilities;var animate$1=animationExports.animate,animObject$c=animationExports.animObject,stop$1=animationExports.stop,deg2rad$9=H.deg2rad,doc$l=H.doc,noop$k=H.noop,svg$6=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$18=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$X=Utilities.defined,erase$9=Utilities.erase,extend$1w=Utilities.extend,fireEvent$B=Utilities.fireEvent,isArray$o=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$S=Utilities.isNumber,isString$b=Utilities.isString,merge$1s=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1F=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=(function(){function v(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return v.prototype._defaultGetter=function(d){var a=pick$1F(this[d+"Value"],this[d],this.element?this.element.getAttribute(d):null,0);return/^[\-0-9\.]+$/.test(a)&&(a=parseFloat(a)),a},v.prototype._defaultSetter=function(d,a,p){p.setAttribute(a,d)},v.prototype.add=function(d){var a=this.renderer,p=this.element,y;return d&&(this.parentGroup=d),this.parentInverted=d&&d.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&a.buildText(this),this.added=!0,(!d||d.handleZ||this.zIndex)&&(y=this.zIndexSetter()),y||(d?d.element:a.box).appendChild(p),this.onAdd&&this.onAdd(),this},v.prototype.addClass=function(d,a){var p=a?"":this.attr("class")||"";return d=(d||"").split(/ /g).reduce(function(y,C){return p.indexOf(C)===-1&&y.push(C),y},p?[p]:[]).join(" "),d!==p&&this.attr("class",d),this},v.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},v.prototype.align=function(d,a,p){var y={},C=this.renderer,P=C.alignedObjects,z,L,$,N,W;d?(this.alignOptions=d,this.alignByTranslate=a,(!p||isString$b(p))&&(this.alignTo=$=p||"renderer",erase$9(P,this),P.push(this),p=void 0)):(d=this.alignOptions,a=this.alignByTranslate,$=this.alignTo),p=pick$1F(p,C[$],$==="scrollablePlotBox"?C.plotBox:void 0,C);var U=d.align,j=d.verticalAlign;return z=(p.x||0)+(d.x||0),L=(p.y||0)+(d.y||0),U==="right"?N=1:U==="center"&&(N=2),N&&(z+=(p.width-(d.width||0))/N),y[a?"translateX":"x"]=Math.round(z),j==="bottom"?W=1:j==="middle"&&(W=2),W&&(L+=(p.height-(d.height||0))/W),y[a?"translateY":"y"]=Math.round(L),this[this.placed?"animate":"attr"](y),this.placed=!0,this.alignAttr=y,this},v.prototype.alignSetter=function(d){var a={left:"start",center:"middle",right:"end"};a[d]&&(this.alignValue=d,this.element.setAttribute("text-anchor",a[d]))},v.prototype.animate=function(d,a,p){var y=this,C=animObject$c(pick$1F(a,this.renderer.globalAnimation,!0)),P=C.defer;return pick$1F(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(C.duration=0),C.duration!==0?(p&&(C.complete=p),syncTimeout$8(function(){y.element&&animate$1(y,d,C)},P)):(this.attr(d,void 0,p),objectEach$y(d,function(z,L){C.step&&C.step.call(this,z,{prop:L,pos:1,elem:this})},this)),this},v.prototype.applyTextOutline=function(d){var a=this.element,p=d.indexOf("contrast")!==-1;p&&(d=d.replace(/contrast/g,this.renderer.getContrast(a.style.fill)));var y=d.split(" "),C=y[y.length-1],P=y[0];if(P&&P!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,P=P.replace(/(^[\d\.]+)(.*?)$/g,function($,N,W){return 2*Number(N)+W}),this.removeTextOutline();var z=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(z,{class:"highcharts-text-outline",fill:C,stroke:C,"stroke-width":P,"stroke-linejoin":"round"}),[].forEach.call(a.childNodes,function($){var N=$.cloneNode(!0);N.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(W){return N.removeAttribute(W)}),z.appendChild(N)});var L=doc$l.createElementNS(SVG_NS$2,"tspan");L.textContent="​",["x","y"].forEach(function($){var N=a.getAttribute($);N&&L.setAttribute($,N)}),z.appendChild(L),a.insertBefore(z,a.firstChild)}},v.prototype.attr=function(d,a,p,y){var C=this.element,P=this.symbolCustomAttribs,z,L,$=this,N,W;return typeof d=="string"&&typeof a<"u"&&(z=d,d={},d[z]=a),typeof d=="string"?$=(this[d+"Getter"]||this._defaultGetter).call(this,d,C):(objectEach$y(d,function(j,q){N=!1,y||stop$1(this,q),this.symbolName&&P.indexOf(q)!==-1&&(L||(this.symbolAttr(d),L=!0),N=!0),this.rotation&&(q==="x"||q==="y")&&(this.doTransform=!0),N||(W=this[q+"Setter"]||this._defaultSetter,W.call(this,j,q,C),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(q)&&this.updateShadows(q,j,W))},this),this.afterSetters()),p&&p.call(this),$},v.prototype.clip=function(d){return this.attr("clip-path",d?"url("+this.renderer.url+"#"+d.id+")":"none")},v.prototype.crisp=function(d,a){var p=this;a=a||d.strokeWidth||0;var y=Math.round(a)%2/2;return d.x=Math.floor(d.x||p.x||0)+y,d.y=Math.floor(d.y||p.y||0)+y,d.width=Math.floor((d.width||p.width||0)-2*y),d.height=Math.floor((d.height||p.height||0)-2*y),defined$X(d.strokeWidth)&&(d.strokeWidth=a),d},v.prototype.complexColor=function(d,a,p){var y=this.renderer,C,P,z,L,$,N,W,U,j,q,X=[],K;fireEvent$B(this.renderer,"complexColor",{args:arguments},function(){if(d.radialGradient?P="radialGradient":d.linearGradient&&(P="linearGradient"),P){if(z=d[P],$=y.gradients,N=d.stops,j=p.radialReference,isArray$o(z)&&(d[P]=z={x1:z[0],y1:z[1],x2:z[2],y2:z[3],gradientUnits:"userSpaceOnUse"}),P==="radialGradient"&&j&&!defined$X(z.gradientUnits)&&(L=z,z=merge$1s(z,y.getRadialAttr(j,L),{gradientUnits:"userSpaceOnUse"})),objectEach$y(z,function(te,ne){ne!=="id"&&X.push(ne,te)}),objectEach$y(N,function(te){X.push(te)}),X=X.join(","),$[X])q=$[X].attr("id");else{z.id=q=uniqueKey$7();var Q=$[X]=y.createElement(P).attr(z).add(y.defs);Q.radAttr=L,Q.stops=[],N.forEach(function(te){te[1].indexOf("rgba")===0?(C=Color.parse(te[1]),W=C.get("rgb"),U=C.get("a")):(W=te[1],U=1);var ne=y.createElement("stop").attr({offset:te[0],"stop-color":W,"stop-opacity":U}).add(Q);Q.stops.push(ne)})}K="url("+y.url+"#"+q+")",p.setAttribute(a,K),p.gradient=X,d.toString=function(){return K}}})},v.prototype.css=function(d){var a=this.styles,p={},y=this.element,C=["textOutline","textOverflow","width"],P,z="",L,$=!a;return d&&d.color&&(d.fill=d.color),a&&objectEach$y(d,function(N,W){a&&a[W]!==N&&(p[W]=N,$=!0)}),$&&(a&&(d=extend$1w(a,p)),d&&(d.width===null||d.width==="auto"?delete this.textWidth:y.nodeName.toLowerCase()==="text"&&d.width&&(P=this.textWidth=pInt$7(d.width))),this.styles=d,P&&!svg$6&&this.renderer.forExport&&delete d.width,y.namespaceURI===this.SVG_NS?(L=function(N,W){return"-"+W.toLowerCase()},objectEach$y(d,function(N,W){C.indexOf(W)===-1&&(z+=W.replace(/([A-Z])/g,L)+":"+N+";")}),z&&attr$6(y,"style",z)):css$c(y,d),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),d&&d.textOutline&&this.applyTextOutline(d.textOutline))),this},v.prototype.dashstyleSetter=function(d){var a,p=this["stroke-width"];if(p==="inherit"&&(p=1),d=d&&d.toLowerCase(),d){var y=d.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(a=y.length;a--;)y[a]=""+pInt$7(y[a])*pick$1F(p,NaN);d=y.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",d)}},v.prototype.destroy=function(){var d=this,a=d.element||{},p=d.renderer,y=a.ownerSVGElement,C=p.isSVG&&a.nodeName==="SPAN"&&d.parentGroup||void 0,P,z;if(a.onclick=a.onmouseout=a.onmouseover=a.onmousemove=a.point=null,stop$1(d),d.clipPath&&y){var L=d.clipPath;[].forEach.call(y.querySelectorAll("[clip-path],[CLIP-PATH]"),function($){$.getAttribute("clip-path").indexOf(L.element.id)>-1&&$.removeAttribute("clip-path")}),d.clipPath=L.destroy()}if(d.stops){for(z=0;z<d.stops.length;z++)d.stops[z].destroy();d.stops.length=0,d.stops=void 0}for(d.safeRemoveChild(a),p.styledMode||d.destroyShadows();C&&C.div&&C.div.childNodes.length===0;)P=C.parentGroup,d.safeRemoveChild(C.div),delete C.div,C=P;d.alignTo&&erase$9(p.alignedObjects,d),objectEach$y(d,function($,N){d[N]&&d[N].parentGroup===d&&d[N].destroy&&d[N].destroy(),delete d[N]})},v.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(d){this.safeRemoveChild(d)},this),this.shadows=void 0},v.prototype.destroyTextPath=function(d,a){var p=d.getElementsByTagName("text")[0],y;if(p){if(p.removeAttribute("dx"),p.removeAttribute("dy"),a.element.setAttribute("id",""),this.textPathWrapper&&p.getElementsByTagName("textPath").length){for(y=this.textPathWrapper.element.childNodes;y.length;)p.appendChild(y[0]);p.removeChild(this.textPathWrapper.element)}}else(d.getAttribute("dx")||d.getAttribute("dy"))&&(d.removeAttribute("dx"),d.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},v.prototype.dSetter=function(d,a,p){isArray$o(d)&&(typeof d[0]=="string"&&(d=this.renderer.pathToSegments(d)),this.pathArray=d,d=d.reduce(function(y,C,P){return!C||!C.join?(C||"").toString():(P?y+" ":"")+C.join(" ")},"")),/(NaN| {2}|^$)/.test(d)&&(d="M 0 0"),this[a]!==d&&(p.setAttribute(a,d),this[a]=d)},v.prototype.fadeOut=function(d){var a=this;a.animate({opacity:0},{duration:pick$1F(d,150),complete:function(){a.attr({y:-9999}).hide()}})},v.prototype.fillSetter=function(d,a,p){typeof d=="string"?p.setAttribute(a,d):d&&this.complexColor(d,a,p)},v.prototype.getBBox=function(d,a){var p=this,y=p.renderer,C=p.element,P=p.styles,z=p.textStr,L=y.cache,$=y.cacheKeys,N=C.namespaceURI===p.SVG_NS,W=pick$1F(a,p.rotation,0),U=y.styledMode?C&&v.prototype.getStyle.call(C,"font-size"):P&&P.fontSize,j,q,X,K,Q;if(defined$X(z)&&(Q=z.toString(),Q.indexOf("<")===-1&&(Q=Q.replace(/[0-9]/g,"0")),Q+=["",W,U,p.textWidth,P&&P.textOverflow,P&&P.fontWeight].join(",")),Q&&!d&&(j=L[Q]),!j){if(N||y.forExport){try{K=this.fakeTS&&function(ne){var ie=C.querySelector(".highcharts-text-outline");ie&&css$c(ie,{display:ne})},isFunction$4(K)&&K("none"),j=C.getBBox?extend$1w({},C.getBBox()):{width:C.offsetWidth,height:C.offsetHeight},isFunction$4(K)&&K("")}catch{}(!j||j.width<0)&&(j={width:0,height:0})}else j=p.htmlGetBBox();if(y.isSVG&&(q=j.width,X=j.height,N&&(j.height=X={"11px,17":14,"13px,20":16}[P&&P.fontSize+","+Math.round(X)]||X),W)){var te=W*deg2rad$9;j.width=Math.abs(X*Math.sin(te))+Math.abs(q*Math.cos(te)),j.height=Math.abs(X*Math.cos(te))+Math.abs(q*Math.sin(te))}if(Q&&(z===""||j.height>0)){for(;$.length>250;)delete L[$.shift()];L[Q]||$.push(Q),L[Q]=j}}return j},v.prototype.getStyle=function(d){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(d)},v.prototype.hasClass=function(d){return(""+this.attr("class")).split(" ").indexOf(d)!==-1},v.prototype.hide=function(d){return d?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},v.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},v.prototype.init=function(d,a){this.element=a==="span"?createElement$9(a):doc$l.createElementNS(this.SVG_NS,a),this.renderer=d,fireEvent$B(this,"afterInit")},v.prototype.invert=function(d){return this.inverted=d,this.updateTransform(),this},v.prototype.on=function(d,a){var p=this.onEvents;return p[d]&&p[d](),p[d]=addEvent$18(this.element,d,a),this},v.prototype.opacitySetter=function(d,a,p){var y=Number(Number(d).toFixed(3));this.opacity=y,p.setAttribute(a,y)},v.prototype.removeClass=function(d){return this.attr("class",(""+this.attr("class")).replace(isString$b(d)?new RegExp("(^| )"+d+"( |$)"):d," ").replace(/ +/g," ").trim())},v.prototype.removeTextOutline=function(){var d=this.element.querySelector("tspan.highcharts-text-outline");d&&this.safeRemoveChild(d)},v.prototype.safeRemoveChild=function(d){var a=d.parentNode;a&&a.removeChild(d)},v.prototype.setRadialReference=function(d){var a=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=d,a&&a.radAttr&&a.animate(this.renderer.getRadialAttr(d,a.radAttr)),this},v.prototype.setTextPath=function(d,a){var p=this.element,y=this.text?this.text.element:p,C={textAnchor:"text-anchor"},P=!1,z,L,$=this.textPathWrapper,N=!$;a=merge$1s(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},a);var W=AST.filterUserAttributes(a.attributes);if(d&&a&&a.enabled){if($&&$.element.parentNode===null?(N=!0,$=$.destroy()):$&&this.removeTextOutline.call($.parentGroup),this.options&&this.options.padding&&(W.dx=-this.options.padding),$||(this.textPathWrapper=$=this.renderer.createElement("textPath"),P=!0),z=$.element,L=d.element.getAttribute("id"),L||d.element.setAttribute("id",L=uniqueKey$7()),N){y.setAttribute("y",0),isNumber$S(W.dx)&&y.setAttribute("x",-W.dx);for(var U=[].slice.call(y.childNodes),j=0;j<U.length;j++){var q=U[j];(q.nodeType===Node.TEXT_NODE||q.nodeName==="tspan")&&z.appendChild(q)}}P&&$&&$.add({element:y}),z.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+L),defined$X(W.dy)&&(z.parentNode.setAttribute("dy",W.dy),delete W.dy),defined$X(W.dx)&&(z.parentNode.setAttribute("dx",W.dx),delete W.dx),objectEach$y(W,function(X,K){z.setAttribute(C[K]||K,X)}),p.removeAttribute("transform"),this.removeTextOutline.call($),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$k,this.applyTextOutline=noop$k}else $&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(p,d),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},v.prototype.shadow=function(d,a,p){var y=[],C=this.element,P=this.oldShadowOptions,z={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},L,$,N,W,U=!1,j,q;if(d===!0?q=z:typeof d=="object"&&(q=extend$1w(z,d)),q&&(q&&P&&objectEach$y(q,function(X,K){X!==P[K]&&(U=!0)}),U&&this.destroyShadows(),this.oldShadowOptions=q),!q)this.destroyShadows();else if(!this.shadows){for(W=q.opacity/q.width,j=this.parentInverted?"translate("+q.offsetY+", "+q.offsetX+")":"translate("+q.offsetX+", "+q.offsetY+")",L=1;L<=q.width;L++)$=C.cloneNode(!1),N=q.width*2+1-2*L,attr$6($,{stroke:d.color||palette.neutralColor100,"stroke-opacity":W*L,"stroke-width":N,transform:j,fill:"none"}),$.setAttribute("class",($.getAttribute("class")||"")+" highcharts-shadow"),p&&(attr$6($,"height",Math.max(attr$6($,"height")-N,0)),$.cutHeight=N),a?a.element.appendChild($):C.parentNode&&C.parentNode.insertBefore($,C),y.push($);this.shadows=y}return this},v.prototype.show=function(d){return this.attr({visibility:d?"inherit":"visible"})},v.prototype.strokeSetter=function(d,a,p){this[a]=d,this.stroke&&this["stroke-width"]?(v.prototype.fillSetter.call(this,this.stroke,"stroke",p),p.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):a==="stroke-width"&&d===0&&this.hasStroke?(p.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(p.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},v.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var d=this.getStyle("stroke-width"),a=0,p;return d.indexOf("px")===d.length-2?a=pInt$7(d):d!==""&&(p=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(p,{width:d,"stroke-width":0}),this.element.parentNode.appendChild(p),a=p.getBBox().width,p.parentNode.removeChild(p)),a},v.prototype.symbolAttr=function(d){var a=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(p){a[p]=pick$1F(d[p],a[p])}),a.attr({d:a.renderer.symbols[a.symbolName](a.x,a.y,a.width,a.height,a)})},v.prototype.textSetter=function(d){d!==this.textStr&&(delete this.textPxLength,this.textStr=d,this.added&&this.renderer.buildText(this))},v.prototype.titleSetter=function(d){var a=this.element,p=a.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");a.insertBefore?a.insertBefore(p,a.firstChild):a.appendChild(p),p.textContent=String(pick$1F(d,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},v.prototype.toFront=function(){var d=this.element;return d.parentNode.appendChild(d),this},v.prototype.translate=function(d,a){return this.attr({translateX:d,translateY:a})},v.prototype.updateShadows=function(d,a,p){var y=this.shadows;if(y)for(var C=y.length;C--;)p.call(y[C],d==="height"?Math.max(a-(y[C].cutHeight||0),0):d==="d"?this.d:a,d,y[C])},v.prototype.updateTransform=function(){var d=this,a=d.scaleX,p=d.scaleY,y=d.inverted,C=d.rotation,P=d.matrix,z=d.element,L=d.translateX||0,$=d.translateY||0;y&&(L+=d.width,$+=d.height);var N=["translate("+L+","+$+")"];defined$X(P)&&N.push("matrix("+P.join(",")+")"),y?N.push("rotate(90) scale(-1,1)"):C&&N.push("rotate("+C+" "+pick$1F(this.rotationOriginX,z.getAttribute("x"),0)+" "+pick$1F(this.rotationOriginY,z.getAttribute("y")||0)+")"),(defined$X(a)||defined$X(p))&&N.push("scale("+pick$1F(a,1)+" "+pick$1F(p,1)+")"),N.length&&z.setAttribute("transform",N.join(" "))},v.prototype.visibilitySetter=function(d,a,p){d==="inherit"?p.removeAttribute(a):this[a]!==d&&p.setAttribute(a,d),this[a]=d},v.prototype.xGetter=function(d){return this.element.nodeName==="circle"&&(d==="x"?d="cx":d==="y"&&(d="cy")),this._defaultGetter(d)},v.prototype.zIndexSetter=function(d,a){var p=this.renderer,y=this.parentGroup,C=y||p,P=C.element||p.box,z=this.element,L=P===p.box,$,N,W,U=!1,j,q=this.added,X;if(defined$X(d)?(z.setAttribute("data-z-index",d),d=+d,this[a]===d&&(q=!1)):defined$X(this[a])&&z.removeAttribute("data-z-index"),this[a]=d,q){for(d=this.zIndex,d&&y&&(y.handleZ=!0),$=P.childNodes,X=$.length-1;X>=0&&!U;X--)N=$[X],W=N.getAttribute("data-z-index"),j=!defined$X(W),N!==z&&(d<0&&j&&!L&&!X?(P.insertBefore(z,$[X]),U=!0):(pInt$7(W)<=d||j&&(!defined$X(d)||d>=0))&&(P.insertBefore(z,$[X+1]||null),U=!0));U||(P.insertBefore(z,$[L?3:0]||null),U=!0)}return U},v})();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(v,d){this[d]=v,this.doTransform=!0};var RendererRegistry;(function(v){v.rendererTypes={};var d;function a(y){return y===void 0&&(y=d),v.rendererTypes[y]||v.rendererTypes[d]}v.getRendererType=a;function p(y,C,P){v.rendererTypes[y]=C,(!d||P)&&(d=y,H.Renderer=C)}v.registerRendererType=p})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$$=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defined$W=Utilities.defined,extend$1v=Utilities.extend,isNumber$R=Utilities.isNumber,merge$1r=Utilities.merge,pick$1E=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=(function(v){__extends$$(d,v);function d(a,p,y,C,P,z,L,$,N,W){var U=v.call(this)||this;U.paddingLeftSetter=U.paddingSetter,U.paddingRightSetter=U.paddingSetter,U.init(a,"g"),U.textStr=p,U.x=y,U.y=C,U.anchorX=z,U.anchorY=L,U.baseline=N,U.className=W,U.addClass(W==="button"?"highcharts-no-tooltip":"highcharts-label"),W&&U.addClass("highcharts-"+W),U.text=a.text(void 0,0,0,$).attr({zIndex:1});var j;return typeof P=="string"&&(j=/^url\((.*?)\)$/.test(P),(j||U.renderer.symbols[P])&&(U.symbolKey=P)),U.bBox=d.emptyBBox,U.padding=3,U.baselineOffset=0,U.needsBox=a.styledMode||j,U.deferredAttr={},U.alignFactor=0,U}return d.prototype.alignSetter=function(a){var p={left:0,center:.5,right:1}[a];p!==this.alignFactor&&(this.alignFactor=p,this.bBox&&isNumber$R(this.xSetting)&&this.attr({x:this.xSetting}))},d.prototype.anchorXSetter=function(a,p){this.anchorX=a,this.boxAttr(p,Math.round(a)-this.getCrispAdjust()-this.xSetting)},d.prototype.anchorYSetter=function(a,p){this.anchorY=a,this.boxAttr(p,a-this.ySetting)},d.prototype.boxAttr=function(a,p){this.box?this.box.attr(a,p):this.deferredAttr[a]=p},d.prototype.css=function(a){if(a){var p={};a=merge$1r(a),d.textProps.forEach(function(P){typeof a[P]<"u"&&(p[P]=a[P],delete a[P])}),this.text.css(p);var y="width"in p,C="fontSize"in p||"fontWeight"in p;C?this.updateTextPadding():y&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,a)},d.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},d.prototype.fillSetter=function(a,p){a&&(this.needsBox=!0),this.fill=a,this.boxAttr(p,a)},d.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var a=this.padding,p=pick$1E(this.paddingLeft,a);return{width:this.width,height:this.height,x:this.bBox.x-p,y:this.bBox.y-a}},d.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},d.prototype.heightSetter=function(a){this.heightSetting=a},d.prototype.onAdd=function(){var a=this.textStr;this.text.add(this),this.attr({text:defined$W(a)?a:"",x:this.x,y:this.y}),this.box&&defined$W(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},d.prototype.paddingSetter=function(a,p){isNumber$R(a)?a!==this[p]&&(this[p]=a,this.updateTextPadding()):this[p]=void 0},d.prototype.rSetter=function(a,p){this.boxAttr(p,a)},d.prototype.shadow=function(a){return a&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(a)),this},d.prototype.strokeSetter=function(a,p){this.stroke=a,this.boxAttr(p,a)},d.prototype["stroke-widthSetter"]=function(a,p){a&&(this.needsBox=!0),this["stroke-width"]=a,this.boxAttr(p,a)},d.prototype["text-alignSetter"]=function(a){this.textAlign=a},d.prototype.textSetter=function(a){typeof a<"u"&&this.text.attr({text:a}),this.updateTextPadding()},d.prototype.updateBoxSize=function(){var a=this.text.element.style,p={},y=this.padding,C=this.bBox=(!isNumber$R(this.widthSetting)||!isNumber$R(this.heightSetting)||this.textAlign)&&defined$W(this.text.textStr)?this.text.getBBox():d.emptyBBox,P;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||C.height||0)+2*y;var z=this.renderer.fontMetrics(a&&a.fontSize,this.text);if(this.baselineOffset=y+Math.min((this.text.firstLineMetrics||z).b,C.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-z.h)/2),this.needsBox){if(!this.box){var L=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();L.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),L.add(this)}P=this.getCrispAdjust(),p.x=P,p.y=(this.baseline?-this.baselineOffset:0)+P,p.width=Math.round(this.width),p.height=Math.round(this.height),this.box.attr(extend$1v(p,this.deferredAttr)),this.deferredAttr={}}},d.prototype.updateTextPadding=function(){var a=this.text;this.updateBoxSize();var p=this.baseline?0:this.baselineOffset,y=pick$1E(this.paddingLeft,this.padding);defined$W(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(y+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(y!==a.x||p!==a.y)&&(a.attr("x",y),a.hasBoxWidthChanged&&(this.bBox=a.getBBox(!0)),typeof p<"u"&&a.attr("y",p)),a.x=y,a.y=p},d.prototype.widthSetter=function(a){this.widthSetting=isNumber$R(a)?a:void 0},d.prototype.getPaddedWidth=function(){var a=this.padding,p=pick$1E(this.paddingLeft,a),y=pick$1E(this.paddingRight,a);return(this.widthSetting||this.bBox.width||0)+p+y},d.prototype.xSetter=function(a){this.x=a,this.alignFactor&&(a-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(a),this.attr("translateX",this.xSetting)},d.prototype.ySetter=function(a){this.ySetting=this.y=Math.round(a),this.attr("translateY",this.ySetting)},d.emptyBBox={width:0,height:0,x:0,y:0},d.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],d})(SVGElement),defined$V=Utilities.defined,isNumber$Q=Utilities.isNumber,pick$1D=Utilities.pick;function arc$1(v,d,a,p,y){var C=[];if(y){var P=y.start||0,z=pick$1D(y.r,a),L=pick$1D(y.r,p||a),$=.001,N=Math.abs((y.end||0)-P-2*Math.PI)<$,W=(y.end||0)-$,U=y.innerR,j=pick$1D(y.open,N),q=Math.cos(P),X=Math.sin(P),K=Math.cos(W),Q=Math.sin(W),te=pick$1D(y.longArc,W-P-Math.PI<$?0:1);C.push(["M",v+z*q,d+L*X],["A",z,L,0,te,pick$1D(y.clockwise,1),v+z*K,d+L*Q]),defined$V(U)&&C.push(j?["M",v+U*K,d+U*Q]:["L",v+U*K,d+U*Q],["A",U,U,0,te,defined$V(y.clockwise)?1-y.clockwise:0,v+U*q,d+U*X]),j||C.push(["Z"])}return C}function callout(v,d,a,p,y){var C=6,P=6,z=Math.min(y&&y.r||0,a,p),L=z+P,$=y&&y.anchorX,N=y&&y.anchorY||0,W=roundedRect(v,d,a,p,{r:z});return isNumber$Q($)&&(v+$>=a?N>d+L&&N<d+p-L?W.splice(3,1,["L",v+a,N-P],["L",v+a+C,N],["L",v+a,N+P],["L",v+a,d+p-z]):W.splice(3,1,["L",v+a,p/2],["L",$,N],["L",v+a,p/2],["L",v+a,d+p-z]):v+$<=0?N>d+L&&N<d+p-L?W.splice(7,1,["L",v,N+P],["L",v-C,N],["L",v,N-P],["L",v,d+z]):W.splice(7,1,["L",v,p/2],["L",$,N],["L",v,p/2],["L",v,d+z]):N&&N>p&&$>v+L&&$<v+a-L?W.splice(5,1,["L",$+P,d+p],["L",$,d+p+C],["L",$-P,d+p],["L",v+z,d+p]):N&&N<0&&$>v+L&&$<v+a-L&&W.splice(1,1,["L",$-P,d],["L",$,d-C],["L",$+P,d],["L",a-z,d])),W}function circle(v,d,a,p){return arc$1(v+a/2,d+p/2,a/2,p/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(v,d,a,p){return[["M",v+a/2,d],["L",v+a,d+p/2],["L",v+a/2,d+p],["L",v,d+p/2],["Z"]]}function rect(v,d,a,p,y){return y&&y.r?roundedRect(v,d,a,p,y):[["M",v,d],["L",v+a,d],["L",v+a,d+p],["L",v,d+p],["Z"]]}function roundedRect(v,d,a,p,y){var C=y&&y.r||0;return[["M",v+C,d],["L",v+a-C,d],["C",v+a,d,v+a,d,v+a,d+C],["L",v+a,d+p-C],["C",v+a,d+p,v+a,d+p,v+a-C,d+p],["L",v+C,d+p],["C",v,d+p,v,d+p,v,d+p-C],["L",v,d+C],["C",v,d,v,d,v+C,d]]}function triangle(v,d,a,p){return[["M",v+a/2,d],["L",v+a,d+p],["L",v,d+p],["Z"]]}function triangleDown(v,d,a,p){return[["M",v,d],["L",v+a,d],["L",v+a/2,d+p],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$a=Utilities.isString,objectEach$x=Utilities.objectEach,pick$1C=Utilities.pick,TextBuilder=(function(){function v(d){var a=d.styles;this.renderer=d.renderer,this.svgElement=d,this.width=d.textWidth,this.textLineHeight=a&&a.lineHeight,this.textOutline=a&&a.textOutline,this.ellipsis=!!(a&&a.textOverflow==="ellipsis"),this.noWrap=!!(a&&a.whiteSpace==="nowrap"),this.fontSize=a&&a.fontSize}return v.prototype.buildSVG=function(){var d=this.svgElement,a=d.element,p=d.renderer,y=pick$1C(d.textStr,"").toString(),C=y.indexOf("<")!==-1,P=a.childNodes,z=this.width&&!d.added&&p.box,L=/<br.*?>/g,$=[y,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if($!==d.textCache){d.textCache=$,delete d.actualWidth;for(var N=P.length;N--;)a.removeChild(P[N]);if(!C&&!this.ellipsis&&!this.width&&(y.indexOf(" ")===-1||this.noWrap&&!L.test(y)))a.appendChild(doc$k.createTextNode(this.unescapeEntities(y)));else if(y!==""){z&&z.appendChild(a);var W=new AST(y);this.modifyTree(W.nodes),W.addToDOM(d.element),this.modifyDOM(),this.ellipsis&&(a.textContent||"").indexOf("…")!==-1&&d.attr("title",this.unescapeEntities(d.textStr||"",["&lt;","&gt;"])),z&&z.removeChild(a)}isString$a(this.textOutline)&&d.applyTextOutline&&d.applyTextOutline(this.textOutline)}},v.prototype.modifyDOM=function(){var d=this,a=this.svgElement,p=attr$5(a.element,"x");a.firstLineMetrics=void 0;for(var y;(y=a.element.firstChild)&&/^[\s\u200B]*$/.test(y.textContent||" ");)a.element.removeChild(y);[].forEach.call(a.element.querySelectorAll("tspan.highcharts-br"),function(L,$){L.nextSibling&&L.previousSibling&&($===0&&L.previousSibling.nodeType===1&&(a.firstLineMetrics=a.renderer.fontMetrics(void 0,L.previousSibling)),attr$5(L,{dy:d.getLineHeight(L.nextSibling),x:p}))});var C=this.width||0;if(C){var P=function(L,$){var N=L.textContent||"",W=N.replace(/([^\^])-/g,"$1- ").split(" "),U=!d.noWrap&&(W.length>1||a.element.childNodes.length>1),j=d.getLineHeight($),q=0,X=a.actualWidth;if(d.ellipsis)N&&d.truncate(L,N,void 0,0,Math.max(0,C-parseInt(d.fontSize||12,10)),function(te,ne){return te.substring(0,ne)+"…"});else if(U){for(var K=[],Q=[];$.firstChild&&$.firstChild!==L;)Q.push($.firstChild),$.removeChild($.firstChild);for(;W.length;)W.length&&!d.noWrap&&q>0&&(K.push(L.textContent||""),L.textContent=W.join(" ").replace(/- /g,"-")),d.truncate(L,void 0,W,q===0&&X||0,C,function(te,ne){return W.slice(0,ne).join(" ").replace(/- /g,"-")}),X=a.actualWidth,q++;Q.forEach(function(te){$.insertBefore(te,L)}),K.forEach(function(te){$.insertBefore(doc$k.createTextNode(te),L);var ne=doc$k.createElementNS(SVG_NS$1,"tspan");ne.textContent="​",attr$5(ne,{dy:j,x:p}),$.insertBefore(ne,L)})}},z=(function(L){var $=[].slice.call(L.childNodes);$.forEach(function(N){N.nodeType===Node.TEXT_NODE?P(N,L):(N.className.baseVal.indexOf("highcharts-br")!==-1&&(a.actualWidth=0),z(N))})});z(a.element)}},v.prototype.getLineHeight=function(d){var a,p=d.nodeType===Node.TEXT_NODE?d.parentElement:d;return this.renderer.styledMode||(a=p&&/(px|em)$/.test(p.style.fontSize)?p.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(a,p||this.svgElement.element).h},v.prototype.modifyTree=function(d){var a=this,p=function(y,C){var P=y.tagName,z=a.renderer.styledMode,L=y.attributes||{};if(P==="b"||P==="strong"?z?L.class="highcharts-strong":L.style="font-weight:bold;"+(L.style||""):(P==="i"||P==="em")&&(z?L.class="highcharts-emphasized":L.style="font-style:italic;"+(L.style||"")),isString$a(L.style)&&(L.style=L.style.replace(/(;| |^)color([ :])/,"$1fill$2")),P==="br"){L.class="highcharts-br",y.textContent="​";var $=d[C+1];$&&$.textContent&&($.textContent=$.textContent.replace(/^ +/gm,""))}P!=="#text"&&P!=="a"&&(y.tagName="tspan"),y.attributes=L,y.children&&y.children.filter(function(N){return N.tagName!=="#text"}).forEach(p)};d.forEach(p)},v.prototype.truncate=function(d,a,p,y,C,P){var z=this.svgElement,L=z.renderer,$=z.rotation,N=[],W=p?1:0,U=(a||p||"").length,j=U,q,X,K=function(Q,te){var ne=te||Q,ie=d.parentNode;if(ie&&typeof N[ne]>"u")if(ie.getSubStringLength)try{N[ne]=y+ie.getSubStringLength(0,p?ne+1:ne)}catch{}else L.getSpanWidth&&(d.textContent=P(a||p,Q),N[ne]=y+L.getSpanWidth(z,d));return N[ne]};if(z.rotation=0,X=K(d.textContent.length),y+X>C){for(;W<=U;)j=Math.ceil((W+U)/2),p&&(q=P(p,j)),X=K(j,q&&q.length-1),W===U?W=U+1:X>C?U=j-1:W=j;U===0?d.textContent="":a&&U===a.length-1||(d.textContent=q||P(a||p,j))}p&&p.splice(0,j),z.actualWidth=X,z.rotation=$},v.prototype.unescapeEntities=function(d,a){return objectEach$x(this.renderer.escapes,function(p,y){(!a||a.indexOf(p)===-1)&&(d=d.toString().replace(new RegExp(p,"g"),y))}),d},v})(),charts$4=H.charts,deg2rad$8=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$j=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$17=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$U=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1u=Utilities.extend,isArray$n=Utilities.isArray,isNumber$P=Utilities.isNumber,isObject$f=Utilities.isObject,isString$9=Utilities.isString,merge$1q=Utilities.merge,pick$1B=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=(function(){function v(d,a,p,y,C,P,z){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(d,a,p,y,C,P,z)}return v.prototype.init=function(d,a,p,y,C,P,z){var L=this,$=L.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),N=$.element;z||$.css(this.getStyle(y)),d.appendChild(N),attr$4(d,"dir","ltr"),d.innerHTML.indexOf("xmlns")===-1&&attr$4(N,"xmlns",this.SVG_NS),L.isSVG=!0,this.box=N,this.boxWrapper=$,L.alignedObjects=[],this.url=this.getReferenceURL();var W=this.createElement("desc").add();W.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),L.defs=this.createElement("defs").add(),L.allowHTML=P,L.forExport=C,L.styledMode=z,L.gradients={},L.cache={},L.cacheKeys=[],L.imgCount=0,L.setSize(a,p,!1);var U,j;isFirefox$3&&d.getBoundingClientRect&&(U=function(){css$b(d,{left:0,top:0}),j=d.getBoundingClientRect(),css$b(d,{left:Math.ceil(j.left)-j.left+"px",top:Math.ceil(j.top)-j.top+"px"})},U(),L.unSubPixelFix=addEvent$17(win$c,"resize",U))},v.prototype.definition=function(d){var a=new AST([d]);return a.addToDOM(this.defs.element)},v.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$U(hasInternalReferenceBug)){var d=uniqueKey$6(),a=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:d},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+d+")",fill:"rgba(0,0,0,0.001)"}}]}]),p=a.addToDOM(doc$j.body);css$b(p,{position:"fixed",top:0,left:0,zIndex:9e5});var y=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(y&&y.id)==="hitme",doc$j.body.removeChild(p)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},v.prototype.getStyle=function(d){return this.style=extend$1u({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},d),this.style},v.prototype.setStyle=function(d){this.boxWrapper.css(this.getStyle(d))},v.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},v.prototype.destroy=function(){var d=this,a=d.defs;return d.box=null,d.boxWrapper=d.boxWrapper.destroy(),destroyObjectProperties$9(d.gradients||{}),d.gradients=null,a&&(d.defs=a.destroy()),d.unSubPixelFix&&d.unSubPixelFix(),d.alignedObjects=null,null},v.prototype.createElement=function(d){var a=new this.Element;return a.init(this,d),a},v.prototype.getRadialAttr=function(d,a){return{cx:d[0]-d[2]/2+(a.cx||0)*d[2],cy:d[1]-d[2]/2+(a.cy||0)*d[2],r:(a.r||0)*d[2]}},v.prototype.buildText=function(d){new TextBuilder(d).buildSVG()},v.prototype.getContrast=function(d){return d=Color.parse(d).rgba,d[0]*=1,d[1]*=1.2,d[2]*=.5,d[0]+d[1]+d[2]>1.8*255?"#000000":"#FFFFFF"},v.prototype.button=function(d,a,p,y,C,P,z,L,$,N){var W=this.label(d,a,p,$,void 0,void 0,N,void 0,"button"),U=this.styledMode,j=0,q=C?merge$1q(C):{},X=q&&q.style||{};q=AST.filterUserAttributes(q),W.attr(merge$1q({padding:8,r:2},q));var K,Q,te,ne;return U||(q=merge$1q({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:X},q),K=q.style,delete q.style,P=merge$1q(q,{fill:palette.neutralColor10},AST.filterUserAttributes(P||{})),Q=P.style,delete P.style,z=merge$1q(q,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(z||{})),te=z.style,delete z.style,L=merge$1q(q,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(L||{})),ne=L.style,delete L.style),addEvent$17(W.element,isMS$2?"mouseover":"mouseenter",function(){j!==3&&W.setState(1)}),addEvent$17(W.element,isMS$2?"mouseout":"mouseleave",function(){j!==3&&W.setState(j)}),W.setState=function(ie){ie!==1&&(W.state=j=ie),W.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][ie||0]),U||W.attr([q,P,z,L][ie||0]).css([K,Q,te,ne][ie||0])},U||W.attr(q).css(extend$1u({cursor:"default"},K)),W.on("touchstart",function(ie){return ie.stopPropagation()}).on("click",function(ie){j!==3&&y.call(W,ie)})},v.prototype.crispLine=function(d,a,p){p===void 0&&(p="round");var y=d[0],C=d[1];return defined$U(y[1])&&y[1]===C[1]&&(y[1]=C[1]=Math[p](y[1])-a%2/2),defined$U(y[2])&&y[2]===C[2]&&(y[2]=C[2]=Math[p](y[2])+a%2/2),d},v.prototype.path=function(d){var a=this.styledMode?{}:{fill:"none"};return isArray$n(d)?a.d=d:isObject$f(d)&&extend$1u(a,d),this.createElement("path").attr(a)},v.prototype.circle=function(d,a,p){var y=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,r:p},C=this.createElement("circle");return C.xSetter=C.ySetter=function(P,z,L){L.setAttribute("c"+z,P)},C.attr(y)},v.prototype.arc=function(d,a,p,y,C,P){var z;isObject$f(d)?(z=d,a=z.y,p=z.r,y=z.innerR,C=z.start,P=z.end,d=z.x):z={innerR:y,start:C,end:P};var L=this.symbol("arc",d,a,p,p,z);return L.r=p,L},v.prototype.rect=function(d,a,p,y,C,P){C=isObject$f(d)?d.r:C;var z=this.createElement("rect"),L=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,width:Math.max(p,0),height:Math.max(y,0)};return this.styledMode||(typeof P<"u"&&(L["stroke-width"]=P,L=z.crisp(L)),L.fill="none"),C&&(L.r=C),z.rSetter=function($,N,W){z.r=$,attr$4(W,{rx:$,ry:$})},z.rGetter=function(){return z.r||0},z.attr(L)},v.prototype.setSize=function(d,a,p){var y=this;y.width=d,y.height=a,y.boxWrapper.animate({width:d,height:a},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1B(p,!0)?void 0:0}),y.alignElements()},v.prototype.g=function(d){var a=this.createElement("g");return d?a.attr({class:"highcharts-"+d}):a},v.prototype.image=function(d,a,p,y,C,P){var z={preserveAspectRatio:"none"},L=function(U,j){U.setAttributeNS?U.setAttributeNS("http://www.w3.org/1999/xlink","href",j):U.setAttribute("hc-svg-href",j)};arguments.length>1&&extend$1u(z,{x:a,y:p,width:y,height:C});var $=this.createElement("image").attr(z),N=function(U){L($.element,d),P.call($,U)};if(P){L($.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var W=new win$c.Image;addEvent$17(W,"load",N),W.src=d,W.complete&&N({})}else L($.element,d);return $},v.prototype.symbol=function(d,a,p,y,C,P){var z=this,L=/^url\((.*?)\)$/,$=L.test(d),N=!$&&(this.symbols[d]?d:"circle"),W=N&&this.symbols[N],U,j,q,X;if(W)typeof a=="number"&&(j=W.call(this.symbols,Math.round(a||0),Math.round(p||0),y||0,C||0,P)),U=this.path(j),z.styledMode||U.attr("fill","none"),extend$1u(U,{symbolName:N||void 0,x:a,y:p,width:y,height:C}),P&&extend$1u(U,P);else if($){q=d.match(L)[1];var K=U=this.image(q);K.imgwidth=pick$1B(symbolSizes[q]&&symbolSizes[q].width,P&&P.width),K.imgheight=pick$1B(symbolSizes[q]&&symbolSizes[q].height,P&&P.height),X=function(Q){return Q.attr({width:Q.width,height:Q.height})},["width","height"].forEach(function(Q){K[Q+"Setter"]=function(te,ne){var ie=this["img"+ne];if(this[ne]=te,defined$U(ie)&&(P&&P.backgroundSize==="within"&&this.width&&this.height&&(ie=Math.round(ie*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(ne,ie),!this.alignByTranslate)){var ae=((this[ne]||0)-ie)/2,se=ne==="width"?{translateX:ae}:{translateY:ae};this.attr(se)}}}),defined$U(a)&&K.attr({x:a,y:p}),K.isImg=!0,defined$U(K.imgwidth)&&defined$U(K.imgheight)?X(K):(K.attr({width:0,height:0}),createElement$8("img",{onload:function(){var Q=charts$4[z.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[q]={width:this.width,height:this.height},K.imgwidth=this.width,K.imgheight=this.height,K.element&&X(K),this.parentNode&&this.parentNode.removeChild(this),z.imgCount--,!z.imgCount&&Q&&!Q.hasLoaded&&Q.onload()},src:q}),this.imgCount++)}return U},v.prototype.clipRect=function(d,a,p,y){var C=uniqueKey$6()+"-",P=this.createElement("clipPath").attr({id:C}).add(this.defs),z=this.rect(d,a,p,y,0).add(P);return z.id=C,z.clipPath=P,z.count=0,z},v.prototype.text=function(d,a,p,y){var C=this,P={};if(y&&(C.allowHTML||!C.forExport))return C.html(d,a,p);P.x=Math.round(a||0),p&&(P.y=Math.round(p)),defined$U(d)&&(P.text=d);var z=C.createElement("text").attr(P);return(!y||C.forExport&&!C.allowHTML)&&(z.xSetter=function(L,$,N){for(var W=N.getElementsByTagName("tspan"),U=N.getAttribute($),j=0,q=void 0;j<W.length;j++)q=W[j],q.getAttribute($)===U&&q.setAttribute($,L);N.setAttribute($,L)}),z},v.prototype.fontMetrics=function(d,a){(this.styledMode||!/px/.test(d))&&win$c.getComputedStyle?d=a&&SVGElement.prototype.getStyle.call(a,"font-size"):d=d||a&&a.style&&a.style.fontSize||this.style&&this.style.fontSize,/px/.test(d)?d=pInt$6(d):d=12;var p=d<24?d+3:Math.round(d*1.2),y=Math.round(p*.8);return{h:p,b:y,f:d}},v.prototype.rotCorr=function(d,a,p){var y=d;return a&&p&&(y=Math.max(y*Math.cos(a*deg2rad$8),4)),{x:-d/3*Math.sin(a*deg2rad$8),y}},v.prototype.pathToSegments=function(d){for(var a=[],p=[],y={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},C=0;C<d.length;C++)isString$9(p[0])&&isNumber$P(d[C])&&p.length===y[p[0].toUpperCase()]&&d.splice(C,0,p[0].replace("M","L").replace("m","l")),typeof d[C]=="string"&&(p.length&&a.push(p.slice(0)),p.length=0),p.push(d[C]);return a.push(p.slice(0)),a},v.prototype.label=function(d,a,p,y,C,P,z,L,$){return new SVGLabel(this,d,a,p,y,C,P,z,L,$)},v.prototype.alignElements=function(){this.alignedObjects.forEach(function(d){return d.align()})},v})();extend$1u(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$j});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$_=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$T=Utilities.defined,extend$1t=Utilities.extend,pick$1A=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement$1=(function(v){__extends$_(d,v);function d(){return v!==null&&v.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var p=d.prototype,y=a.prototype;y.getSpanCorrection=p.getSpanCorrection,y.htmlCss=p.htmlCss,y.htmlGetBBox=p.htmlGetBBox,y.htmlUpdateTransform=p.htmlUpdateTransform,y.setSpanRotation=p.setSpanRotation}return a},d.prototype.getSpanCorrection=function(a,p,y){this.xCorr=-a*y,this.yCorr=-p},d.prototype.htmlCss=function(a){var p=this,y=p.element,C=y.tagName==="SPAN"&&a&&"width"in a,P=pick$1A(C&&a.width,void 0),z;return C&&(delete a.width,p.textWidth=P,z=!0),a&&a.textOverflow==="ellipsis"&&(a.whiteSpace="nowrap",a.overflow="hidden"),p.styles=extend$1t(p.styles,a),css$a(p.element,a),z&&p.htmlUpdateTransform(),p},d.prototype.htmlGetBBox=function(){var a=this,p=a.element;return{x:p.offsetLeft,y:p.offsetTop,width:p.offsetWidth,height:p.offsetHeight}},d.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var a=this,p=a.renderer,y=a.element,C=a.translateX||0,P=a.translateY||0,z=a.x||0,L=a.y||0,$=a.textAlign||"left",N={left:0,center:.5,right:1}[$],W=a.styles,U=W&&W.whiteSpace;function j(){return css$a(y,{width:"",whiteSpace:U||"nowrap"}),y.offsetWidth}if(css$a(y,{marginLeft:C,marginTop:P}),!p.styledMode&&a.shadows&&a.shadows.forEach(function(te){css$a(te,{marginLeft:C+1,marginTop:P+1})}),a.inverted&&[].forEach.call(y.childNodes,function(te){p.invertChild(te,y)}),y.tagName==="SPAN"){var q=a.rotation,X=a.textWidth&&pInt$5(a.textWidth),K=[q,$,y.innerHTML,a.textWidth,a.textAlign].join(","),Q=void 0;X!==a.oldTextWidth&&(X>a.oldTextWidth||(a.textPxLength||j())>X)&&(/[ \-]/.test(y.textContent||y.innerText)||y.style.textOverflow==="ellipsis")?(css$a(y,{width:X+"px",display:"block",whiteSpace:U||"normal"}),a.oldTextWidth=X,a.hasBoxWidthChanged=!0):a.hasBoxWidthChanged=!1,K!==a.cTT&&(Q=p.fontMetrics(y.style.fontSize,y).b,defined$T(q)&&(q!==(a.oldRotation||0)||$!==a.oldAlign)&&a.setSpanRotation(q,N,Q),a.getSpanCorrection(!defined$T(q)&&a.textPxLength||y.offsetWidth,Q,N,q,$)),css$a(y,{left:z+(a.xCorr||0)+"px",top:L+(a.yCorr||0)+"px"}),a.cTT=K,a.oldRotation=q,a.oldAlign=$}},d.prototype.setSpanRotation=function(a,p,y){var C=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},P={},z=C();z&&(P[z]=P.transform="rotate("+a+"deg)",P[z+(isFirefox$2?"Origin":"-origin")]=P.transformOrigin=p*100+"% "+y+"px",css$a(this.element,P))},d.composedClasses=[],d})(SVGElement),__extends$Z=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1s=Utilities.extend,pick$1z=Utilities.pick,HTMLRenderer=(function(v){__extends$Z(d,v);function d(){return v!==null&&v.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var p=d.prototype,y=a.prototype;y.html=p.html}return a},d.prototype.html=function(a,p,y){var C=this.createElement("span"),P=C.element,z=C.renderer,L=z.isSVG,$=function(N,W){["opacity","visibility"].forEach(function(U){N[U+"Setter"]=function(j,q,X){var K=N.div?N.div.style:W;SVGElement.prototype[U+"Setter"].call(this,j,q,X),K&&(K[q]=j)}}),N.addedSetters=!0};return C.textSetter=function(N){N!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1z(N,"")),this.textStr=N,C.doTransform=!0)},L&&$(C,C.element.style),C.xSetter=C.ySetter=C.alignSetter=C.rotationSetter=function(N,W){W==="align"?C.alignValue=C.textAlign=N:C[W]=N,C.doTransform=!0},C.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},C.attr({text:a,x:Math.round(p),y:Math.round(y)}).css({position:"absolute"}),z.styledMode||C.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),P.style.whiteSpace="nowrap",C.css=C.htmlCss,L&&(C.add=function(N){var W=z.box.parentNode,U=[],j,q;if(this.parentGroup=N,N){if(j=N.div,!j){for(q=N;q;)U.push(q),q=q.parentGroup;U.reverse().forEach(function(X){var K=attr$3(X.element,"class");function Q(ie,ae){X[ae]=ie,ae==="translateX"?ne.left=ie+"px":ne.top=ie+"px",X.doTransform=!0}var te=X.styles||{};j=X.div=X.div||createElement$7("div",K?{className:K}:void 0,{position:"absolute",left:(X.translateX||0)+"px",top:(X.translateY||0)+"px",display:X.display,opacity:X.opacity,cursor:te.cursor,pointerEvents:te.pointerEvents,visibility:X.visibility},j||W);var ne=j.style;extend$1s(X,{classSetter:(function(ie){return function(ae){this.element.setAttribute("class",ae),ie.className=ae}})(j),on:function(){return U[0].div&&C.on.apply({element:U[0].div,onEvents:X.onEvents},arguments),X},translateXSetter:Q,translateYSetter:Q}),X.addedSetters||$(X)})}}else j=W;return j.appendChild(P),C.added=!0,C.alignOnAdd&&C.htmlUpdateTransform(),C}),C},d.composedClasses=[],d})(SVGRenderer),AxisDefaults;(function(v){v.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},v.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var d=this.axis.chart.numberFormatter;return d(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},v.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},v.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},v.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},v.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$16=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$w=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(v,d){v.eventOptions=v.eventOptions||{},objectEach$w(d.events,function(a,p){v.eventOptions[p]!==a&&(v.eventOptions[p]&&(removeEvent$a(v,p,v.eventOptions[p]),delete v.eventOptions[p]),isFunction$3(a)&&(v.eventOptions[p]=a,addEvent$16(v,p,a)))})},exports$4={registerEventOptions:registerEventOptions$3},deg2rad$7=H.deg2rad,clamp$j=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$S=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1r=Utilities.extend,fireEvent$A=Utilities.fireEvent,isNumber$O=Utilities.isNumber,merge$1p=Utilities.merge,objectEach$v=Utilities.objectEach,pick$1y=Utilities.pick,Tick=(function(){function v(d,a,p,y,C){this.isNew=!0,this.isNewLabel=!0,this.axis=d,this.pos=a,this.type=p||"",this.parameters=C||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$A(this,"init"),!p&&!y&&this.addLabel()}return v.prototype.addLabel=function(){var d=this,a=d.axis,p=a.options,y=a.chart,C=a.categories,P=a.logarithmic,z=a.names,L=d.pos,$=pick$1y(d.options&&d.options.labels,p.labels),N=a.tickPositions,W=L===N[0],U=L===N[N.length-1],j=(!$.step||$.step===1)&&a.tickInterval===1,q=N.info,X=d.label,K,Q,te,ne=this.parameters.category||(C?pick$1y(C[L],z[L],L):L);P&&isNumber$O(ne)&&(ne=correctFloat$c(P.lin2log(ne))),a.dateTime&&(q?(Q=y.time.resolveDTLFormat(p.dateTimeLabelFormats[!p.grid&&q.higherRanks[L]||q.unitName]),K=Q.main):isNumber$O(ne)&&(K=a.dateTime.getXDateFormat(ne,p.dateTimeLabelFormats||{}))),d.isFirst=W,d.isLast=U;var ie={axis:a,chart:y,dateTimeLabelFormat:K,isFirst:W,isLast:U,pos:L,tick:d,tickPositionInfo:q,value:ne};fireEvent$A(this,"labelFormat",ie);var ae=function(he){return $.formatter?$.formatter.call(he,he):$.format?(he.text=a.defaultLabelFormatter.call(he),FormatUtilities.format($.format,he,y)):a.defaultLabelFormatter.call(he,he)},se=ae.call(ie,ie),de=Q&&Q.list;de?d.shortenLabel=function(){for(te=0;te<de.length;te++)if(extend$1r(ie,{dateTimeLabelFormat:de[te]}),X.attr({text:ae.call(ie,ie)}),X.getBBox().width<a.getSlotWidth(d)-2*$.padding)return;X.attr({text:""})}:d.shortenLabel=void 0,j&&a._addedPlotLB&&d.moveLabel(se,$),!defined$S(X)&&!d.movedLabel?(d.label=X=d.createLabel({x:0,y:0},se,$),d.rotation=0):X&&X.textStr!==se&&!j&&(X.textWidth&&!$.style.width&&!X.styles.width&&X.css({width:null}),X.attr({text:se}),X.textPxLength=X.getBBox().width)},v.prototype.createLabel=function(d,a,p){var y=this.axis,C=y.chart,P=defined$S(a)&&p.enabled?C.renderer.text(a,d.x,d.y,p.useHTML).add(y.labelGroup):null;return P&&(C.styledMode||P.css(merge$1p(p.style)),P.textPxLength=P.getBBox().width),P},v.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},v.prototype.getPosition=function(d,a,p,y){var C=this.axis,P=C.chart,z=y&&P.oldChartHeight||P.chartHeight,L={x:d?correctFloat$c(C.translate(a+p,null,null,y)+C.transB):C.left+C.offset+(C.opposite?(y&&P.oldChartWidth||P.chartWidth)-C.right-C.left:0),y:d?z-C.bottom+C.offset-(C.opposite?C.height:0):correctFloat$c(z-C.translate(a+p,null,null,y)-C.transB)};return L.y=clamp$j(L.y,-1e5,1e5),fireEvent$A(this,"afterGetPosition",{pos:L}),L},v.prototype.getLabelPosition=function(d,a,p,y,C,P,z,L){var $=this.axis,N=$.transA,W=$.isLinked&&$.linkedParent?$.linkedParent.reversed:$.reversed,U=$.staggerLines,j=$.tickRotCorr||{x:0,y:0},q=!y&&!$.reserveSpaceDefault?-$.labelOffset*($.labelAlign==="center"?.5:1):0,X={},K=C.y,Q;return defined$S(K)||($.side===0?K=p.rotation?-8:-p.getBBox().height:$.side===2?K=j.y+8:K=Math.cos(p.rotation*deg2rad$7)*(j.y-p.getBBox(!1,0).height/2)),d=d+C.x+q+j.x-(P&&y?P*N*(W?-1:1):0),a=a+K-(P&&!y?P*N*(W?1:-1):0),U&&(Q=z/(L||1)%U,$.opposite&&(Q=U-Q-1),a+=Q*($.labelOffset/U)),X.x=d,X.y=Math.round(a),fireEvent$A(this,"afterGetLabelPosition",{pos:X,tickmarkOffset:P,index:z}),X},v.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},v.prototype.getMarkPath=function(d,a,p,y,C,P){return P.crispLine([["M",d,a],["L",d+(C?0:-p),a+(C?p:0)]],y)},v.prototype.handleOverflow=function(d){var a=this,p=this.axis,y=p.options.labels,C=d.x,P=p.chart.chartWidth,z=p.chart.spacing,L=pick$1y(p.labelLeft,Math.min(p.pos,z[3])),$=pick$1y(p.labelRight,Math.max(p.isRadial?0:p.pos+p.len,P-z[1])),N=this.label,W=this.rotation,U={left:0,center:.5,right:1}[p.labelAlign||N.attr("align")],j=N.getBBox().width,q=p.getSlotWidth(a),X=U,K={},Q=q,te=1,ne,ie,ae;!W&&y.overflow==="justify"?(ne=C-U*j,ie=C+(1-U)*j,ne<L?Q=d.x+Q*(1-U)-L:ie>$&&(Q=$-d.x+Q*U,te=-1),Q=Math.min(q,Q),Q<q&&p.labelAlign==="center"&&(d.x+=te*(q-Q-X*(q-Math.min(j,Q)))),(j>Q||p.autoRotation&&(N.styles||{}).width)&&(ae=Q)):W<0&&C-U*j<L?ae=Math.round(C/Math.cos(W*deg2rad$7)-L):W>0&&C+U*j>$&&(ae=Math.round((P-C)/Math.cos(W*deg2rad$7))),ae&&(a.shortenLabel?a.shortenLabel():(K.width=Math.floor(ae)+"px",(y.style||{}).textOverflow||(K.textOverflow="ellipsis"),N.css(K)))},v.prototype.moveLabel=function(d,a){var p=this,y=p.label,C=p.axis,P=C.reversed,z=!1,L,$,N;y&&y.textStr===d?(p.movedLabel=y,z=!0,delete p.label):objectEach$v(C.ticks,function(W){!z&&!W.isNew&&W!==p&&W.label&&W.label.textStr===d&&(p.movedLabel=W.label,z=!0,W.labelPos=p.movedLabel.xy,delete W.label)}),!z&&(p.labelPos||y)&&(L=p.labelPos||y.xy,$=C.horiz?P?0:C.width+C.left:L.x,N=C.horiz?L.y:P?C.width+C.left:0,p.movedLabel=p.createLabel({x:$,y:N},d,a),p.movedLabel&&p.movedLabel.attr({opacity:0}))},v.prototype.render=function(d,a,p){var y=this,C=y.axis,P=C.horiz,z=y.pos,L=pick$1y(y.tickmarkOffset,C.tickmarkOffset),$=y.getPosition(P,z,L,a),N=$.x,W=$.y,U=P&&N===C.pos+C.len||!P&&W===C.pos?-1:1,j=pick$1y(p,y.label&&y.label.newOpacity,1);p=pick$1y(p,1),this.isActive=!0,this.renderGridLine(a,p,U),this.renderMark($,p,U),this.renderLabel($,a,j,d),y.isNew=!1,fireEvent$A(this,"afterRender")},v.prototype.renderGridLine=function(d,a,p){var y=this,C=y.axis,P=C.options,z={},L=y.pos,$=y.type,N=pick$1y(y.tickmarkOffset,C.tickmarkOffset),W=C.chart.renderer,U=y.gridLine,j,q=P.gridLineWidth,X=P.gridLineColor,K=P.gridLineDashStyle;y.type==="minor"&&(q=P.minorGridLineWidth,X=P.minorGridLineColor,K=P.minorGridLineDashStyle),U||(C.chart.styledMode||(z.stroke=X,z["stroke-width"]=q||0,z.dashstyle=K),$||(z.zIndex=1),d&&(a=0),y.gridLine=U=W.path().attr(z).addClass("highcharts-"+($?$+"-":"")+"grid-line").add(C.gridGroup)),U&&(j=C.getPlotLinePath({value:L+N,lineWidth:U.strokeWidth()*p,force:"pass",old:d}),j&&U[d||y.isNew?"attr":"animate"]({d:j,opacity:a}))},v.prototype.renderMark=function(d,a,p){var y=this,C=y.axis,P=C.options,z=C.chart.renderer,L=y.type,$=C.tickSize(L?L+"Tick":"tick"),N=d.x,W=d.y,U=pick$1y(P[L!=="minor"?"tickWidth":"minorTickWidth"],!L&&C.isXAxis?1:0),j=P[L!=="minor"?"tickColor":"minorTickColor"],q=y.mark,X=!q;$&&(C.opposite&&($[0]=-$[0]),q||(y.mark=q=z.path().addClass("highcharts-"+(L?L+"-":"")+"tick").add(C.axisGroup),C.chart.styledMode||q.attr({stroke:j,"stroke-width":U})),q[X?"attr":"animate"]({d:y.getMarkPath(N,W,$[0],q.strokeWidth()*p,C.horiz,z),opacity:a}))},v.prototype.renderLabel=function(d,a,p,y){var C=this,P=C.axis,z=P.horiz,L=P.options,$=C.label,N=L.labels,W=N.step,U=pick$1y(C.tickmarkOffset,P.tickmarkOffset),j=d.x,q=d.y,X=!0;$&&isNumber$O(j)&&($.xy=d=C.getLabelPosition(j,q,$,z,N,U,y,W),C.isFirst&&!C.isLast&&!L.showFirstLabel||C.isLast&&!C.isFirst&&!L.showLastLabel?X=!1:z&&!N.step&&!N.rotation&&!a&&p!==0&&C.handleOverflow(d),W&&y%W&&(X=!1),X&&isNumber$O(d.y)?(d.opacity=p,$[C.isNewLabel?"attr":"animate"](d),C.isNewLabel=!1):($.attr("y",-9999),C.isNewLabel=!0))},v.prototype.replaceMovedLabel=function(){var d=this,a=d.label,p=d.axis,y=p.reversed,C,P;a&&!d.isNew&&(C=p.horiz?y?p.left:p.width+p.left:a.xy.x,P=p.horiz?a.xy.y:y?p.width+p.top:p.top,a.animate({x:C,y:P,opacity:0},void 0,a.destroy),delete d.label),p.isDirty=!0,d.label=d.movedLabel,delete d.movedLabel},v})(),animObject$b=animationExports.animObject,defaultOptions$h=DefaultOptions.defaultOptions,registerEventOptions$2=exports$4.registerEventOptions,deg2rad$6=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$i=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$R=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$8=Utilities.erase,error$9=Utilities.error,extend$1q=Utilities.extend,fireEvent$z=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$m=Utilities.isArray,isNumber$N=Utilities.isNumber,isString$8=Utilities.isString,merge$1o=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$u=Utilities.objectEach,pick$1x=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$i=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=(function(){function v(d,a){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(d,a)}return v.prototype.init=function(d,a){var p=a.isX,y=this;y.chart=d,y.horiz=d.inverted&&!y.isZAxis?!p:p,y.isXAxis=p,y.coll=y.coll||(p?"xAxis":"yAxis"),fireEvent$z(this,"init",{userOptions:a}),y.opposite=pick$1x(a.opposite,y.opposite),y.side=pick$1x(a.side,y.side,y.horiz?y.opposite?0:2:y.opposite?1:3),y.setOptions(a);var C=this.options,P=C.labels,z=C.type;y.userOptions=a,y.minPixelPadding=0,y.reversed=pick$1x(C.reversed,y.reversed),y.visible=C.visible,y.zoomEnabled=C.zoomEnabled,y.hasNames=z==="category"||C.categories===!0,y.categories=C.categories||y.hasNames,y.names||(y.names=[],y.names.keys={}),y.plotLinesAndBandsGroups={},y.positiveValuesOnly=!!y.logarithmic,y.isLinked=defined$R(C.linkedTo),y.ticks={},y.labelEdge=[],y.minorTicks={},y.plotLinesAndBands=[],y.alternateBands={},y.len=0,y.minRange=y.userMinRange=C.minRange||C.maxZoom,y.range=C.range,y.offset=C.offset||0,y.max=null,y.min=null;var L=pick$1x(C.crosshair,splat$i(d.options.tooltip.crosshairs)[p?0:1]);y.crosshair=L===!0?{}:L,d.axes.indexOf(y)===-1&&(p?d.axes.splice(d.xAxis.length,0,y):d.axes.push(y),d[y.coll].push(y)),y.series=y.series||[],d.inverted&&!y.isZAxis&&p&&typeof y.reversed>"u"&&(y.reversed=!0),y.labelRotation=isNumber$N(P.rotation)?P.rotation:void 0,registerEventOptions$2(y,C),fireEvent$z(this,"afterInit")},v.prototype.setOptions=function(d){this.options=merge$1o(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1o(defaultOptions$h[this.coll],d)),fireEvent$z(this,"afterSetOptions",{userOptions:d})},v.prototype.defaultLabelFormatter=function(d){var a=this.axis,p=this.chart,y=p.numberFormatter,C=isNumber$N(this.value)?this.value:NaN,P=a.chart.time,z=a.categories,L=this.dateTimeLabelFormat,$=defaultOptions$h.lang,N=$.numericSymbols,W=$.numericSymbolMagnitude||1e3,U=a.logarithmic?Math.abs(C):a.tickInterval,j=N&&N.length,q,X;if(z)X=""+this.value;else if(L)X=P.dateFormat(L,C);else if(j&&U>=1e3)for(;j--&&typeof X>"u";)q=Math.pow(W,j+1),U>=q&&C*10%q===0&&N[j]!==null&&C!==0&&(X=y(C/q,-1)+N[j]);return typeof X>"u"&&(Math.abs(C)>=1e4?X=y(C,-1):X=y(C,-1,void 0,"")),X},v.prototype.getSeriesExtremes=function(){var d=this,a=d.chart,p;fireEvent$z(this,"getSeriesExtremes",null,function(){d.hasVisibleSeries=!1,d.dataMin=d.dataMax=d.threshold=null,d.softThreshold=!d.isXAxis,d.stacking&&d.stacking.buildStacks(),d.series.forEach(function(y){if(y.visible||!a.options.chart.ignoreHiddenSeries){var C=y.options,P=void 0,z=C.threshold,L=void 0,$=void 0;if(d.hasVisibleSeries=!0,d.positiveValuesOnly&&z<=0&&(z=null),d.isXAxis)P=y.xData,P.length&&(P=d.logarithmic?P.filter(d.validatePositiveValue):P,p=y.getXExtremes(P),L=p.min,$=p.max,!isNumber$N(L)&&!(L instanceof Date)&&(P=P.filter(isNumber$N),p=y.getXExtremes(P),L=p.min,$=p.max),P.length&&(d.dataMin=Math.min(pick$1x(d.dataMin,L),L),d.dataMax=Math.max(pick$1x(d.dataMax,$),$)));else{var N=y.applyExtremes();isNumber$N(N.dataMin)&&(L=N.dataMin,d.dataMin=Math.min(pick$1x(d.dataMin,L),L)),isNumber$N(N.dataMax)&&($=N.dataMax,d.dataMax=Math.max(pick$1x(d.dataMax,$),$)),defined$R(z)&&(d.threshold=z),(!C.softThreshold||d.positiveValuesOnly)&&(d.softThreshold=!1)}}})}),fireEvent$z(this,"afterGetSeriesExtremes")},v.prototype.translate=function(d,a,p,y,C,P){var z=this.linkedParent||this,L=y&&z.old?z.old.min:z.min,$=z.minPixelPadding,N=(z.isOrdinal||z.brokenAxis&&z.brokenAxis.hasBreaks||z.logarithmic&&C)&&z.lin2val,W=1,U=0,j=y&&z.old?z.old.transA:z.transA,q=0;return j||(j=z.transA),p&&(W*=-1,U=z.len),z.reversed&&(W*=-1,U-=W*(z.sector||z.len)),a?(d=d*W+U,d-=$,q=d/j+L,N&&(q=z.lin2val(q))):(N&&(d=z.val2lin(d)),q=isNumber$N(L)?W*(d-L)*j+U+W*$+(isNumber$N(P)?j*P:0):void 0),q},v.prototype.toPixels=function(d,a){return this.translate(d,!1,!this.horiz,null,!0)+(a?0:this.pos)},v.prototype.toValue=function(d,a){return this.translate(d-(a?0:this.pos),!0,!this.horiz,null,!0)},v.prototype.getPlotLinePath=function(d){var a=this,p=a.chart,y=a.left,C=a.top,P=d.old,z=d.value,L=d.lineWidth,$=P&&p.oldChartHeight||p.chartHeight,N=P&&p.oldChartWidth||p.chartWidth,W=a.transB,U=d.translatedValue,j=d.force,q,X,K,Q,te;function ne(ae,se,de){return(j!=="pass"&&ae<se||ae>de)&&(j?ae=clamp$i(ae,se,de):te=!0),ae}var ie={value:z,lineWidth:L,old:P,force:j,acrossPanes:d.acrossPanes,translatedValue:U};return fireEvent$z(this,"getPlotLinePath",ie,function(ae){U=pick$1x(U,a.translate(z,null,null,P)),U=clamp$i(U,-1e5,1e5),q=K=Math.round(U+W),X=Q=Math.round($-U-W),isNumber$N(U)?a.horiz?(X=C,Q=$-a.bottom,q=K=ne(q,y,y+a.width)):(q=y,K=N-a.right,X=Q=ne(X,C,C+a.height)):(te=!0,j=!1),ae.path=te&&!j?null:p.renderer.crispLine([["M",q,X],["L",K,Q]],L||1)}),ie.path},v.prototype.getLinearTickPositions=function(d,a,p){var y=correctFloat$b(Math.floor(a/d)*d),C=correctFloat$b(Math.ceil(p/d)*d),P=[],z,L,$;if(correctFloat$b(y+d)===y&&($=20),this.single)return[a];for(z=y;z<=C&&(P.push(z),z=correctFloat$b(z+d,$),z!==L);)L=z;return P},v.prototype.getMinorTickInterval=function(){var d=this.options;return d.minorTicks===!0?pick$1x(d.minorTickInterval,"auto"):d.minorTicks===!1?null:d.minorTickInterval},v.prototype.getMinorTickPositions=function(){var d=this,a=d.options,p=d.tickPositions,y=d.minorTickInterval,C=d.pointRangePadding||0,P=d.min-C,z=d.max+C,L=z-P,$=[],N;if(L&&L/y<d.len/3){var W=d.logarithmic;if(W)this.paddedTicks.forEach(function(U,j,q){j&&$.push.apply($,W.getLogTickPositions(y,q[j-1],q[j],!0))});else if(d.dateTime&&this.getMinorTickInterval()==="auto")$=$.concat(d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(y),P,z,a.startOfWeek));else for(N=P+(p[0]-P)%y;N<=z&&N!==$[0];N+=y)$.push(N)}return $.length!==0&&d.trimTicks($),$},v.prototype.adjustForMinRange=function(){var d=this,a=d.options,p=d.logarithmic,y=d.min,C=d.max,P,z,L=0,$,N,W,U,j,q,X;d.isXAxis&&typeof d.minRange>"u"&&!p&&(defined$R(a.min)||defined$R(a.max)?d.minRange=null:(d.series.forEach(function(K){if(W=K.xData,U=K.xIncrement?1:W.length-1,W.length>1)for($=U;$>0;$--)N=W[$]-W[$-1],(!L||N<L)&&(L=N)}),d.minRange=Math.min(L*5,d.dataMax-d.dataMin))),C-y<d.minRange&&(z=d.dataMax-d.dataMin>=d.minRange,X=d.minRange,P=(X-C+y)/2,j=[y-P,pick$1x(a.min,y-P)],z&&(j[2]=d.logarithmic?d.logarithmic.log2lin(d.dataMin):d.dataMin),y=arrayMax$9(j),q=[y+X,pick$1x(a.max,y+X)],z&&(q[2]=p?p.log2lin(d.dataMax):d.dataMax),C=arrayMin$8(q),C-y<X&&(j[0]=C-X,j[1]=pick$1x(a.min,C-X),y=arrayMax$9(j))),d.min=y,d.max=C},v.prototype.getClosest=function(){var d;return this.categories?d=1:this.series.forEach(function(a){var p=a.closestPointRange,y=a.visible||!a.chart.options.chart.ignoreHiddenSeries;!a.noSharedTooltip&&defined$R(p)&&y&&(d=defined$R(d)?Math.min(d,p):p)}),d},v.prototype.nameToX=function(d){var a=isArray$m(this.categories),p=a?this.categories:this.names,y=d.options.x,C;return d.series.requireSorting=!1,defined$R(y)||(y=this.options.uniqueNames?a?p.indexOf(d.name):pick$1x(p.keys[d.name],-1):d.series.autoIncrement()),y===-1?a||(C=p.length):C=y,typeof C<"u"&&(this.names[C]=d.name,this.names.keys[d.name]=C),C},v.prototype.updateNames=function(){var d=this,a=this.names,p=a.length;p>0&&(Object.keys(a.keys).forEach(function(y){delete a.keys[y]}),a.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(y){y.xIncrement=null,(!y.points||y.isDirtyData)&&(d.max=Math.max(d.max,y.xData.length-1),y.processData(),y.generatePoints()),y.data.forEach(function(C,P){var z;C&&C.options&&typeof C.name<"u"&&(z=d.nameToX(C),typeof z<"u"&&z!==C.x&&(C.x=z,y.xData[P]=z))})}))},v.prototype.setAxisTranslation=function(){var d=this,a=d.max-d.min,p=d.linkedParent,y=!!d.categories,C=d.isXAxis,P=d.axisPointRange||0,z,L=0,$=0,N,W=d.transA;(C||y||P)&&(z=d.getClosest(),p?(L=p.minPointOffset,$=p.pointRangePadding):d.series.forEach(function(U){var j=y?1:C?pick$1x(U.options.pointRange,z,0):d.axisPointRange||0,q=U.options.pointPlacement;if(P=Math.max(P,j),!d.single||y){var X=U.is("xrange")?!C:C;L=Math.max(L,X&&isString$8(q)?0:j/2),$=Math.max($,X&&q==="on"?0:j)}}),N=d.ordinal&&d.ordinal.slope&&z?d.ordinal.slope/z:1,d.minPointOffset=L=L*N,d.pointRangePadding=$=$*N,d.pointRange=Math.min(P,d.single&&y?1:a),C&&(d.closestPointRange=z)),d.translationSlope=d.transA=W=d.staticScale||d.len/(a+$||1),d.transB=d.horiz?d.left:d.bottom,d.minPixelPadding=W*L,fireEvent$z(this,"afterSetAxisTranslation")},v.prototype.minFromRange=function(){var d=this;return d.max-d.range},v.prototype.setTickInterval=function(d){var a=this,p=a.chart,y=a.logarithmic,C=a.options,P=a.isXAxis,z=a.isLinked,L=C.tickPixelInterval,$=a.categories,N=a.softThreshold,W=C.maxPadding,U=C.minPadding,j,q,X=C.tickInterval,K=isNumber$N(a.threshold)?a.threshold:null,Q,te,ne,ie;!a.dateTime&&!$&&!z&&this.getTickAmount(),ne=pick$1x(a.userMin,C.min),ie=pick$1x(a.userMax,C.max),z?(a.linkedParent=p[a.coll][C.linkedTo],q=a.linkedParent.getExtremes(),a.min=pick$1x(q.min,q.dataMin),a.max=pick$1x(q.max,q.dataMax),C.type!==a.linkedParent.options.type&&error$9(11,1,p)):(N&&defined$R(K)&&(a.dataMin>=K?(Q=K,U=0):a.dataMax<=K&&(te=K,W=0)),a.min=pick$1x(ne,Q,a.dataMin),a.max=pick$1x(ie,te,a.dataMax)),y&&(a.positiveValuesOnly&&!d&&Math.min(a.min,pick$1x(a.dataMin,a.min))<=0&&error$9(10,1,p),a.min=correctFloat$b(y.log2lin(a.min),16),a.max=correctFloat$b(y.log2lin(a.max),16)),a.range&&defined$R(a.max)&&(a.userMin=a.min=ne=Math.max(a.dataMin,a.minFromRange()),a.userMax=ie=a.max,a.range=null),fireEvent$z(a,"foundExtremes"),a.beforePadding&&a.beforePadding(),a.adjustForMinRange(),!$&&!a.axisPointRange&&!(a.stacking&&a.stacking.usePercentage)&&!z&&defined$R(a.min)&&defined$R(a.max)&&(j=a.max-a.min,j&&(!defined$R(ne)&&U&&(a.min-=j*U),!defined$R(ie)&&W&&(a.max+=j*W))),isNumber$N(a.userMin)||(isNumber$N(C.softMin)&&C.softMin<a.min&&(a.min=ne=C.softMin),isNumber$N(C.floor)&&(a.min=Math.max(a.min,C.floor))),isNumber$N(a.userMax)||(isNumber$N(C.softMax)&&C.softMax>a.max&&(a.max=ie=C.softMax),isNumber$N(C.ceiling)&&(a.max=Math.min(a.max,C.ceiling))),N&&defined$R(a.dataMin)&&(K=K||0,!defined$R(ne)&&a.min<K&&a.dataMin>=K?a.min=a.options.minRange?Math.min(K,a.max-a.minRange):K:!defined$R(ie)&&a.max>K&&a.dataMax<=K&&(a.max=a.options.minRange?Math.max(K,a.min+a.minRange):K)),isNumber$N(a.min)&&isNumber$N(a.max)&&!this.chart.polar&&a.min>a.max&&(defined$R(a.options.min)?a.max=a.min:defined$R(a.options.max)&&(a.min=a.max)),a.min===a.max||typeof a.min>"u"||typeof a.max>"u"?a.tickInterval=1:z&&a.linkedParent&&!X&&L===a.linkedParent.options.tickPixelInterval?a.tickInterval=X=a.linkedParent.tickInterval:a.tickInterval=pick$1x(X,this.tickAmount?(a.max-a.min)/Math.max(this.tickAmount-1,1):void 0,$?1:(a.max-a.min)*L/Math.max(a.len,L)),P&&!d&&(a.series.forEach(function(se){se.forceCrop=se.forceCropping&&se.forceCropping(),se.processData(a.min!==(a.old&&a.old.min)||a.max!==(a.old&&a.old.max))}),fireEvent$z(this,"postProcessData")),a.setAxisTranslation(),fireEvent$z(this,"initialAxisTranslation"),a.pointRange&&!X&&(a.tickInterval=Math.max(a.pointRange,a.tickInterval));var ae=pick$1x(C.minTickInterval,a.dateTime&&!a.series.some(function(se){return se.noSharedTooltip})?a.closestPointRange:0);!X&&a.tickInterval<ae&&(a.tickInterval=ae),!a.dateTime&&!a.logarithmic&&!X&&(a.tickInterval=normalizeTickInterval$2(a.tickInterval,void 0,getMagnitude$2(a.tickInterval),pick$1x(C.allowDecimals,a.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(a.tickInterval=a.unsquish()),this.setTickPositions()},v.prototype.setTickPositions=function(){var d=this,a=this.options,p=a.tickPositions,y=this.getMinorTickInterval(),C=this.hasVerticalPanning(),P=this.coll==="colorAxis",z=(P||!C)&&a.startOnTick,L=(P||!C)&&a.endOnTick,$,N=a.tickPositioner;this.tickmarkOffset=this.categories&&a.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=y==="auto"&&this.tickInterval?this.tickInterval/5:y,this.single=this.min===this.max&&defined$R(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||a.allowDecimals!==!1),this.tickPositions=$=p&&p.slice(),$||((!d.ordinal||!d.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?($=[this.min,this.max],error$9(19,!1,this.chart)):d.dateTime?$=d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(this.tickInterval,a.units),this.min,this.max,a.startOfWeek,d.ordinal&&d.ordinal.positions,this.closestPointRange,!0):d.logarithmic?$=d.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):$=this.getLinearTickPositions(this.tickInterval,this.min,this.max),$.length>this.len&&($=[$[0],$.pop()],$[0]===$[1]&&($.length=1)),this.tickPositions=$,N&&(N=N.apply(d,[this.min,this.max]),N&&(this.tickPositions=$=N))),this.paddedTicks=$.slice(0),this.trimTicks($,z,L),this.isLinked||(this.single&&$.length<2&&!this.categories&&!this.series.some(function(W){return W.is("heatmap")&&W.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!p&&!N&&this.adjustTickAmount()),fireEvent$z(this,"afterSetTickPositions")},v.prototype.trimTicks=function(d,a,p){var y=d[0],C=d[d.length-1],P=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$z(this,"trimTicks"),!this.isLinked){if(a&&y!==-1/0)this.min=y;else for(;this.min-P>d[0];)d.shift();if(p)this.max=C;else for(;this.max+P<d[d.length-1];)d.pop();d.length===0&&defined$R(y)&&!this.options.tickPositions&&d.push((C+y)/2)}},v.prototype.alignToOthers=function(){var d=this,a={},p=d.options,y;return this.chart.options.chart.alignTicks!==!1&&p.alignTicks&&p.startOnTick!==!1&&p.endOnTick!==!1&&!d.logarithmic&&this.chart[this.coll].forEach(function(C){var P=C.options,z=C.horiz,L=[z?P.left:P.top,P.width,P.height,P.pane].join(",");C.series.length&&(a[L]?y=!0:a[L]=1)}),y},v.prototype.getTickAmount=function(){var d=this,a=this.options,p=a.tickPixelInterval,y=a.tickAmount;!defined$R(a.tickInterval)&&!y&&this.len<p&&!this.isRadial&&!d.logarithmic&&a.startOnTick&&a.endOnTick&&(y=2),!y&&this.alignToOthers()&&(y=Math.ceil(this.len/p)+1),y<4&&(this.finalTickAmt=y,y=5),this.tickAmount=y},v.prototype.adjustTickAmount=function(){var d=this,a=d.options,p=d.tickInterval,y=d.tickPositions,C=d.tickAmount,P=d.finalTickAmt,z=y&&y.length,L=pick$1x(d.threshold,d.softThreshold?0:null),$,N;if(d.hasData()&&isNumber$N(d.min)&&isNumber$N(d.max)){if(z<C){for(;y.length<C;)y.length%2||d.min===L?y.push(correctFloat$b(y[y.length-1]+p)):y.unshift(correctFloat$b(y[0]-p));d.transA*=(z-1)/(C-1),d.min=a.startOnTick?y[0]:Math.min(d.min,y[0]),d.max=a.endOnTick?y[y.length-1]:Math.max(d.max,y[y.length-1])}else z>C&&(d.tickInterval*=2,d.setTickPositions());if(defined$R(P)){for(N=$=y.length;N--;)(P===3&&N%2===1||P<=2&&N>0&&N<$-1)&&y.splice(N,1);d.finalTickAmt=void 0}}},v.prototype.setScale=function(){var d=this,a=!1,p=!1;d.series.forEach(function(C){a=a||C.isDirtyData||C.isDirty,p=p||C.xAxis&&C.xAxis.isDirty||!1}),d.setAxisSize();var y=d.len!==(d.old&&d.old.len);y||a||p||d.isLinked||d.forceRedraw||d.userMin!==(d.old&&d.old.userMin)||d.userMax!==(d.old&&d.old.userMax)||d.alignToOthers()?(d.stacking&&d.stacking.resetStacks(),d.forceRedraw=!1,d.getSeriesExtremes(),d.setTickInterval(),d.isDirty||(d.isDirty=y||d.min!==(d.old&&d.old.min)||d.max!==(d.old&&d.old.max))):d.stacking&&d.stacking.cleanStacks(),a&&d.panningState&&(d.panningState.isDirty=!0),fireEvent$z(this,"afterSetScale")},v.prototype.setExtremes=function(d,a,p,y,C){var P=this,z=P.chart;p=pick$1x(p,!0),P.series.forEach(function(L){delete L.kdTree}),C=extend$1q(C,{min:d,max:a}),fireEvent$z(P,"setExtremes",C,function(){P.userMin=d,P.userMax=a,P.eventArgs=C,p&&z.redraw(y)})},v.prototype.zoom=function(d,a){var p=this,y=this.dataMin,C=this.dataMax,P=this.options,z=Math.min(y,pick$1x(P.min,y)),L=Math.max(C,pick$1x(P.max,C)),$={newMin:d,newMax:a};return fireEvent$z(this,"zoom",$,function(N){var W=N.newMin,U=N.newMax;(W!==p.min||U!==p.max)&&(p.allowZoomOutside||(defined$R(y)&&(W<z&&(W=z),W>L&&(W=L)),defined$R(C)&&(U<z&&(U=z),U>L&&(U=L))),p.displayBtn=typeof W<"u"||typeof U<"u",p.setExtremes(W,U,!1,void 0,{trigger:"zoom"})),N.zoomed=!0}),$.zoomed},v.prototype.setAxisSize=function(){var d=this.chart,a=this.options,p=a.offsets||[0,0,0,0],y=this.horiz,C=this.width=Math.round(relativeLength$9(pick$1x(a.width,d.plotWidth-p[3]+p[1]),d.plotWidth)),P=this.height=Math.round(relativeLength$9(pick$1x(a.height,d.plotHeight-p[0]+p[2]),d.plotHeight)),z=this.top=Math.round(relativeLength$9(pick$1x(a.top,d.plotTop+p[0]),d.plotHeight,d.plotTop)),L=this.left=Math.round(relativeLength$9(pick$1x(a.left,d.plotLeft+p[3]),d.plotWidth,d.plotLeft));this.bottom=d.chartHeight-P-z,this.right=d.chartWidth-C-L,this.len=Math.max(y?C:P,0),this.pos=y?L:z},v.prototype.getExtremes=function(){var d=this,a=d.logarithmic;return{min:a?correctFloat$b(a.lin2log(d.min)):d.min,max:a?correctFloat$b(a.lin2log(d.max)):d.max,dataMin:d.dataMin,dataMax:d.dataMax,userMin:d.userMin,userMax:d.userMax}},v.prototype.getThreshold=function(d){var a=this,p=a.logarithmic,y=p?p.lin2log(a.min):a.min,C=p?p.lin2log(a.max):a.max;return d===null||d===-1/0?d=y:d===1/0?d=C:y>d?d=y:C<d&&(d=C),a.translate(d,0,1,0,1)},v.prototype.autoLabelAlign=function(d){var a=(pick$1x(d,0)-this.side*90+720)%360,p={align:"center"};return fireEvent$z(this,"autoLabelAlign",p,function(y){a>15&&a<165?y.align="right":a>195&&a<345&&(y.align="left")}),p.align},v.prototype.tickSize=function(d){var a=this.options,p=pick$1x(a[d==="tick"?"tickWidth":"minorTickWidth"],d==="tick"&&this.isXAxis&&!this.categories?1:0),y=a[d==="tick"?"tickLength":"minorTickLength"],C;p&&y&&(a[d+"Position"]==="inside"&&(y=-y),C=[y,p]);var P={tickSize:C};return fireEvent$z(this,"afterTickSize",P),P.tickSize},v.prototype.labelMetrics=function(){var d=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[d]&&this.ticks[d].label)},v.prototype.unsquish=function(){var d=this.options.labels,a=this.horiz,p=this.tickInterval,y=this.len/(((this.categories?1:0)+this.max-this.min)/p),C=d.rotation,P=this.labelMetrics(),z=Math.max(this.max-this.min,0),L=function(q){var X=q/(y||1);return X=X>1?Math.ceil(X):1,X*p>z&&q!==1/0&&y!==1/0&&z&&(X=Math.ceil(z/p)),correctFloat$b(X*p)},$=p,N,W,U=Number.MAX_VALUE,j;return a?(!d.staggerLines&&!d.step&&(isNumber$N(C)?j=[C]:y<d.autoRotationLimit&&(j=d.autoRotation)),j&&j.forEach(function(q){var X;(q===C||q&&q>=-90&&q<=90)&&(W=L(Math.abs(P.h/Math.sin(deg2rad$6*q))),X=W+Math.abs(q/360),X<U&&(U=X,N=q,$=W))})):d.step||($=L(P.h)),this.autoRotation=j,this.labelRotation=pick$1x(N,isNumber$N(C)?C:0),$},v.prototype.getSlotWidth=function(d){var a=this.chart,p=this.horiz,y=this.options.labels,C=Math.max(this.tickPositions.length-(this.categories?0:1),1),P=a.margin[3];if(d&&isNumber$N(d.slotWidth))return d.slotWidth;if(p&&y.step<2)return y.rotation?0:(this.staggerLines||1)*this.len/C;if(!p){var z=y.style.width;if(z!==void 0)return parseInt(String(z),10);if(P)return P-a.spacing[3]}return a.chartWidth*.33},v.prototype.renderUnsquish=function(){var d=this.chart,a=d.renderer,p=this.tickPositions,y=this.ticks,C=this.options.labels,P=C.style,z=this.horiz,L=this.getSlotWidth(),$=Math.max(1,Math.round(L-2*C.padding)),N={},W=this.labelMetrics(),U=P.textOverflow,j,q,X=0,K,Q,te;if(isString$8(C.rotation)||(N.rotation=C.rotation||0),p.forEach(function(ne){var ie=y[ne];ie.movedLabel&&ie.replaceMovedLabel(),ie&&ie.label&&ie.label.textPxLength>X&&(X=ie.label.textPxLength)}),this.maxLabelLength=X,this.autoRotation)X>$&&X>W.h?N.rotation=this.labelRotation:this.labelRotation=0;else if(L&&(j=$,!U))for(q="clip",Q=p.length;!z&&Q--;)te=p[Q],K=y[te].label,K&&(K.styles&&K.styles.textOverflow==="ellipsis"?K.css({textOverflow:"clip"}):K.textPxLength>L&&K.css({width:L+"px"}),K.getBBox().height>this.len/p.length-(W.h-W.f)&&(K.specificTextOverflow="ellipsis"));N.rotation&&(j=X>d.chartHeight*.5?d.chartHeight*.33:X,U||(q="ellipsis")),this.labelAlign=C.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(N.align=this.labelAlign),p.forEach(function(ne){var ie=y[ne],ae=ie&&ie.label,se=P.width,de={};ae&&(ae.attr(N),ie.shortenLabel?ie.shortenLabel():j&&!se&&P.whiteSpace!=="nowrap"&&(j<ae.textPxLength||ae.element.tagName==="SPAN")?(de.width=j+"px",U||(de.textOverflow=ae.specificTextOverflow||q),ae.css(de)):ae.styles&&ae.styles.width&&!de.width&&!se&&ae.css({width:null}),delete ae.specificTextOverflow,ie.rotation=N.rotation)},this),this.tickRotCorr=a.rotCorr(W.b,this.labelRotation||0,this.side!==0)},v.prototype.hasData=function(){return this.series.some(function(d){return d.hasData()})||this.options.showEmpty&&defined$R(this.min)&&defined$R(this.max)},v.prototype.addTitle=function(d){var a=this,p=a.chart.renderer,y=a.horiz,C=a.opposite,P=a.options,z=P.title,L=a.chart.styledMode,$;a.axisTitle||($=z.textAlign,$||($=(y?{low:"left",middle:"center",high:"right"}:{low:C?"right":"left",middle:"center",high:C?"left":"right"})[z.align]),a.axisTitle=p.text(z.text||"",0,0,z.useHTML).attr({zIndex:7,rotation:z.rotation,align:$}).addClass("highcharts-axis-title"),L||a.axisTitle.css(merge$1o(z.style)),a.axisTitle.add(a.axisGroup),a.axisTitle.isNew=!0),!L&&!z.style.width&&!a.isRadial&&a.axisTitle.css({width:a.len+"px"}),a.axisTitle[d?"show":"hide"](d)},v.prototype.generateTick=function(d){var a=this,p=a.ticks;p[d]?p[d].addLabel():p[d]=new Tick(a,d)},v.prototype.getOffset=function(){var d=this,a=this,p=a.chart,y=p.renderer,C=a.options,P=a.tickPositions,z=a.ticks,L=a.horiz,$=a.side,N=p.inverted&&!a.isZAxis?[1,0,3,2][$]:$,W=a.hasData(),U=C.title,j=C.labels,q=p.axisOffset,X=p.clipOffset,K=[-1,1,1,-1][$],Q=C.className,te=a.axisParent,ne,ie=0,ae,se=0,de=0,he,ue;if(a.showAxis=ne=W||C.showEmpty,a.staggerLines=a.horiz&&j.staggerLines||void 0,!a.axisGroup){var me=function(ye,Oe,be){return y.g(ye).attr({zIndex:be}).addClass("highcharts-"+d.coll.toLowerCase()+Oe+" "+(d.isRadial?"highcharts-radial-axis"+Oe+" ":"")+(Q||"")).add(te)};a.gridGroup=me("grid","-grid",C.gridZIndex),a.axisGroup=me("axis","",C.zIndex),a.labelGroup=me("axis-labels","-labels",j.zIndex)}W||a.isLinked?(P.forEach(function(ye){a.generateTick(ye)}),a.renderUnsquish(),a.reserveSpaceDefault=$===0||$===2||{1:"left",3:"right"}[$]===a.labelAlign,pick$1x(j.reserveSpace,a.labelAlign==="center"?!0:null,a.reserveSpaceDefault)&&P.forEach(function(ye){de=Math.max(z[ye].getLabelSize(),de)}),a.staggerLines&&(de*=a.staggerLines),a.labelOffset=de*(a.opposite?-1:1)):objectEach$u(z,function(ye,Oe){ye.destroy(),delete z[Oe]}),U&&U.text&&U.enabled!==!1&&(a.addTitle(ne),ne&&U.reserveSpace!==!1&&(a.titleOffset=ie=a.axisTitle.getBBox()[L?"height":"width"],ae=U.offset,se=defined$R(ae)?0:pick$1x(U.margin,L?5:10))),a.renderLine(),a.offset=K*pick$1x(C.offset,q[$]?q[$]+(C.margin||0):0),a.tickRotCorr=a.tickRotCorr||{x:0,y:0},$===0?ue=-a.labelMetrics().h:$===2?ue=a.tickRotCorr.y:ue=0,he=Math.abs(de)+se,de&&(he-=ue,he+=K*(L?pick$1x(j.y,a.tickRotCorr.y+K*8):j.x)),a.axisTitleMargin=pick$1x(ae,he),a.getMaxLabelDimensions&&(a.maxLabelDimensions=a.getMaxLabelDimensions(z,P));var xe=this.tickSize("tick");q[$]=Math.max(q[$],(a.axisTitleMargin||0)+ie+K*a.offset,he,P&&P.length&&xe?xe[0]+K*a.offset:0);var we=C.offset?0:Math.floor(a.axisLine.strokeWidth()/2)*2;X[N]=Math.max(X[N],we),fireEvent$z(this,"afterGetOffset")},v.prototype.getLinePath=function(d){var a=this.chart,p=this.opposite,y=this.offset,C=this.horiz,P=this.left+(p?this.width:0)+y,z=a.chartHeight-this.bottom-(p?this.height:0)+y;return p&&(d*=-1),a.renderer.crispLine([["M",C?this.left:P,C?z:this.top],["L",C?a.chartWidth-this.right:P,C?z:a.chartHeight-this.bottom]],d)},v.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},v.prototype.getTitlePosition=function(){var d=this.horiz,a=this.left,p=this.top,y=this.len,C=this.options.title,P=d?a:p,z=this.opposite,L=this.offset,$=C.x,N=C.y,W=this.axisTitle,U=this.chart.renderer.fontMetrics(C.style.fontSize,W),j=Math.max(W.getBBox(null,0).height-U.h-1,0),q={low:P+(d?0:y),middle:P+y/2,high:P+(d?y:0)}[C.align],X=(d?p+this.height:a)+(d?1:-1)*(z?-1:1)*this.axisTitleMargin+[-j,j,U.f,-j][this.side],K={x:d?q+$:X+(z?this.width:0)+L+$,y:d?X+N-(z?this.height:0)+L:q+N};return fireEvent$z(this,"afterGetTitlePosition",{titlePosition:K}),K},v.prototype.renderMinorTick=function(d,a){var p=this,y=p.minorTicks;y[d]||(y[d]=new Tick(p,d,"minor")),a&&y[d].isNew&&y[d].render(null,!0),y[d].render(null,!1,1)},v.prototype.renderTick=function(d,a,p){var y=this,C=y.isLinked,P=y.ticks;(!C||d>=y.min&&d<=y.max||y.grid&&y.grid.isColumn)&&(P[d]||(P[d]=new Tick(y,d)),p&&P[d].isNew&&P[d].render(a,!0,-1),P[d].render(a))},v.prototype.render=function(){var d=this,a=d.chart,p=d.logarithmic,y=a.renderer,C=d.options,P=d.isLinked,z=d.tickPositions,L=d.axisTitle,$=d.ticks,N=d.minorTicks,W=d.alternateBands,U=C.stackLabels,j=C.alternateGridColor,q=d.tickmarkOffset,X=d.axisLine,K=d.showAxis,Q=animObject$b(y.globalAnimation),te,ne;if(d.labelEdge.length=0,d.overlap=!1,[$,N,W].forEach(function(se){objectEach$u(se,function(de){de.isActive=!1})}),d.hasData()||P){var ie=d.chart.hasRendered&&d.old&&isNumber$N(d.old.min);d.minorTickInterval&&!d.categories&&d.getMinorTickPositions().forEach(function(se){d.renderMinorTick(se,ie)}),z.length&&(z.forEach(function(se,de){d.renderTick(se,de,ie)}),q&&(d.min===0||d.single)&&($[-1]||($[-1]=new Tick(d,-1,null,!0)),$[-1].render(-1))),j&&z.forEach(function(se,de){ne=typeof z[de+1]<"u"?z[de+1]+q:d.max-q,de%2===0&&se<d.max&&ne<=d.max+(a.polar?-q:q)&&(W[se]||(W[se]=new H.PlotLineOrBand(d)),te=se+q,W[se].options={from:p?p.lin2log(te):te,to:p?p.lin2log(ne):ne,color:j,className:"highcharts-alternate-grid"},W[se].render(),W[se].isActive=!0)}),d._addedPlotLB||(d._addedPlotLB=!0,(C.plotLines||[]).concat(C.plotBands||[]).forEach(function(se){d.addPlotBandOrLine(se)}))}if([$,N,W].forEach(function(se){var de=[],he=Q.duration,ue=function(){for(var me=de.length;me--;)se[de[me]]&&!se[de[me]].isActive&&(se[de[me]].destroy(),delete se[de[me]])};objectEach$u(se,function(me,xe){me.isActive||(me.render(xe,!1,0),me.isActive=!1,de.push(xe))}),syncTimeout$7(ue,se===W||!a.hasRendered||!he?0:he)}),X&&(X[X.isPlaced?"animate":"attr"]({d:this.getLinePath(X.strokeWidth())}),X.isPlaced=!0,X[K?"show":"hide"](K)),L&&K){var ae=d.getTitlePosition();isNumber$N(ae.y)?(L[L.isNew?"attr":"animate"](ae),L.isNew=!1):(L.attr("y",-9999),L.isNew=!0)}U&&U.enabled&&d.stacking&&d.stacking.renderStackTotals(),d.old={len:d.len,max:d.max,min:d.min,transA:d.transA,userMax:d.userMax,userMin:d.userMin},d.isDirty=!1,fireEvent$z(this,"afterRender")},v.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(d){d.render()})),this.series.forEach(function(d){d.isDirty=!0})},v.prototype.getKeepProps=function(){return this.keepProps||v.keepProps},v.prototype.destroy=function(d){var a=this,p=a.plotLinesAndBands,y=this.eventOptions;if(fireEvent$z(this,"destroy",{keepEvents:d}),d||removeEvent$9(a),[a.ticks,a.minorTicks,a.alternateBands].forEach(function(z){destroyObjectProperties$7(z)}),p)for(var C=p.length;C--;)p[C].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(z){a[z]&&(a[z]=a[z].destroy())});for(var P in a.plotLinesAndBandsGroups)a.plotLinesAndBandsGroups[P]=a.plotLinesAndBandsGroups[P].destroy();objectEach$u(a,function(z,L){a.getKeepProps().indexOf(L)===-1&&delete a[L]}),this.eventOptions=y},v.prototype.drawCrosshair=function(d,a){var p=this.crosshair,y=pick$1x(p&&p.snap,!0),C=this.chart,P,z,L,$=this.cross,N;if(fireEvent$z(this,"drawCrosshair",{e:d,point:a}),d||(d=this.cross&&this.cross.e),!p||(defined$R(a)||!y)===!1)this.hideCrosshair();else{if(y?defined$R(a)&&(z=pick$1x(this.coll!=="colorAxis"?a.crosshairPos:null,this.isXAxis?a.plotX:this.len-a.plotY)):z=d&&(this.horiz?d.chartX-this.pos:this.len-d.chartY+this.pos),defined$R(z)&&(N={value:a&&(this.isXAxis?a.x:pick$1x(a.stackY,a.y)),translatedValue:z},C.polar&&extend$1q(N,{isCrosshair:!0,chartX:d&&d.chartX,chartY:d&&d.chartY,point:a}),P=this.getPlotLinePath(N)||null),!defined$R(P)){this.hideCrosshair();return}L=this.categories&&!this.isRadial,$||(this.cross=$=C.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(L?"category ":"thin ")+(p.className||"")).attr({zIndex:pick$1x(p.zIndex,2)}).add(),C.styledMode||($.attr({stroke:p.color||(L?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1x(p.width,1)}).css({"pointer-events":"none"}),p.dashStyle&&$.attr({dashstyle:p.dashStyle}))),$.show().attr({d:P}),L&&!p.width&&$.attr({"stroke-width":this.transA}),this.cross.e=d}fireEvent$z(this,"afterDrawCrosshair",{e:d,point:a})},v.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$z(this,"afterHideCrosshair")},v.prototype.hasVerticalPanning=function(){var d=this.chart.options.chart.panning;return!!(d&&d.enabled&&/y/.test(d.type))},v.prototype.validatePositiveValue=function(d){return isNumber$N(d)&&d>0},v.prototype.update=function(d,a){var p=this.chart;d=merge$1o(this.userOptions,d),this.destroy(!0),this.init(p,d),p.isDirtyBox=!0,pick$1x(a,!0)&&p.redraw()},v.prototype.remove=function(d){for(var a=this.chart,p=this.coll,y=this.series,C=y.length;C--;)y[C]&&y[C].remove(!1);erase$8(a.axes,this),erase$8(a[p],this),a[p].forEach(function(P,z){P.options.index=P.userOptions.index=z}),this.destroy(),a.isDirtyBox=!0,pick$1x(d,!0)&&a.redraw()},v.prototype.setTitle=function(d,a){this.update({title:d},a)},v.prototype.setCategories=function(d,a){this.update({categories:d},a)},v.defaultOptions=AxisDefaults$1.defaultXAxisOptions,v.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],v})(),addEvent$15=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$2=Utilities.timeUnits,DateTimeAxis;(function(v){var d=[];function a(P){if(d.indexOf(P)===-1){d.push(P),P.keepProps.push("dateTime");var z=P.prototype;z.getTimeTicks=p,addEvent$15(P,"init",y)}return P}v.compose=a;function p(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function y(P){var z=this,L=P.userOptions;if(L.type!=="datetime"){z.dateTime=void 0;return}z.dateTime||(z.dateTime=new C(z))}var C=(function(){function P(z){this.axis=z}return P.prototype.normalizeTimeTickInterval=function(z,L){var $=L||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],N=$[$.length-1],W=timeUnits$2[N[0]],U=N[1],j;for(j=0;j<$.length;j++)if(N=$[j],W=timeUnits$2[N[0]],U=N[1],$[j+1]){var q=(W*U[U.length-1]+timeUnits$2[$[j+1][0]])/2;if(z<=q)break}W===timeUnits$2.year&&z<5*W&&(U=[1,2,5]);var X=normalizeTickInterval$1(z/W,U,N[0]==="year"?Math.max(getMagnitude$1(z/W),1):1);return{unitRange:W,count:X,unitName:N[0]}},P.prototype.getXDateFormat=function(z,L){var $=this.axis;return $.closestPointRange?$.chart.time.getDateFormat($.closestPointRange,z,$.options.startOfWeek,L)||L.year:L.day},P})();v.Additions=C})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$14=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1w=Utilities.pick,LogarithmicAxis;(function(v){var d=[];function a(P){return d.indexOf(P)===-1&&(d.push(P),P.keepProps.push("logarithmic"),addEvent$14(P,"init",p),addEvent$14(P,"afterInit",y)),P}v.compose=a;function p(P){var z=this,L=P.userOptions,$=z.logarithmic;L.type!=="logarithmic"?z.logarithmic=void 0:$||($=z.logarithmic=new C(z))}function y(){var P=this,z=P.logarithmic;z&&(P.lin2val=function(L){return z.lin2log(L)},P.val2lin=function(L){return z.log2lin(L)})}var C=(function(){function P(z){this.axis=z}return P.prototype.getLogTickPositions=function(z,L,$,N){var W=this,U=W.axis,j=U.len,q=U.options,X=[];if(N||(W.minorAutoInterval=void 0),z>=.5)z=Math.round(z),X=U.getLinearTickPositions(z,L,$);else if(z>=.08){var K=Math.floor(L),Q=void 0,te=void 0,ne=void 0,ie=void 0,ae=void 0,se=void 0,de=void 0;for(z>.3?Q=[1,2,4]:z>.15?Q=[1,2,4,6,8]:Q=[1,2,3,4,5,6,7,8,9],te=K;te<$+1&&!de;te++)for(ie=Q.length,ne=0;ne<ie&&!de;ne++)ae=W.log2lin(W.lin2log(te)*Q[ne]),ae>L&&(!N||se<=$)&&typeof se<"u"&&X.push(se),se>$&&(de=!0),se=ae}else{var he=W.lin2log(L),ue=W.lin2log($),me=N?U.getMinorTickInterval():q.tickInterval,xe=me==="auto"?null:me,we=q.tickPixelInterval/(N?5:1),ye=N?j/U.tickPositions.length:j;z=pick$1w(xe,W.minorAutoInterval,(ue-he)*we/(ye||1)),z=normalizeTickInterval(z,void 0,getMagnitude(z)),X=U.getLinearTickPositions(z,he,ue).map(W.log2lin),N||(W.minorAutoInterval=z/5)}return N||(U.tickInterval=z),X},P.prototype.lin2log=function(z){return Math.pow(10,z)},P.prototype.log2lin=function(z){return Math.log(z)/Math.LN10},P})();v.Additions=C})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$7=Utilities.erase,extend$1p=Utilities.extend,isNumber$M=Utilities.isNumber,PlotLineOrBandAxis;(function(v){var d=[],a;function p(C,P){return a||(a=C),d.indexOf(P)===-1&&(d.push(P),extend$1p(P.prototype,y.prototype)),P}v.compose=p;var y=(function(){function C(){}return C.prototype.getPlotBandPath=function(P,z,L){L===void 0&&(L=this.options);var $=this.getPlotLinePath({value:z,force:!0,acrossPanes:L.acrossPanes}),N=[],W=this.horiz,U=!isNumber$M(this.min)||!isNumber$M(this.max)||P<this.min&&z<this.min||P>this.max&&z>this.max,j=this.getPlotLinePath({value:P,force:!0,acrossPanes:L.acrossPanes}),q,X=1,K;if(j&&$)for(U&&(K=j.toString()===$.toString(),X=0),q=0;q<j.length;q+=2){var Q=j[q],te=j[q+1],ne=$[q],ie=$[q+1];(Q[0]==="M"||Q[0]==="L")&&(te[0]==="M"||te[0]==="L")&&(ne[0]==="M"||ne[0]==="L")&&(ie[0]==="M"||ie[0]==="L")&&(W&&ne[1]===Q[1]?(ne[1]+=X,ie[1]+=X):!W&&ne[2]===Q[2]&&(ne[2]+=X,ie[2]+=X),N.push(["M",Q[1],Q[2]],["L",te[1],te[2]],["L",ie[1],ie[2]],["L",ne[1],ne[2]],["Z"])),N.isFlat=K}else j=null;return N},C.prototype.addPlotBand=function(P){return this.addPlotBandOrLine(P,"plotBands")},C.prototype.addPlotLine=function(P){return this.addPlotBandOrLine(P,"plotLines")},C.prototype.addPlotBandOrLine=function(P,z){var L=this,$=this.userOptions,N=new a(this,P);if(this.visible&&(N=N.render()),N){if(this._addedPlotLB||(this._addedPlotLB=!0,($.plotLines||[]).concat($.plotBands||[]).forEach(function(U){L.addPlotBandOrLine(U)})),z){var W=$[z]||[];W.push(P),$[z]=W}this.plotLinesAndBands.push(N)}return N},C.prototype.removePlotBandOrLine=function(P){var z=this.plotLinesAndBands,L=this.options,$=this.userOptions;if(z){for(var N=z.length;N--;)z[N].id===P&&z[N].destroy();[L.plotLines||[],$.plotLines||[],L.plotBands||[],$.plotBands||[]].forEach(function(W){for(N=W.length;N--;)(W[N]||{}).id===P&&erase$7(W,W[N])})}},C.prototype.removePlotBand=function(P){this.removePlotBandOrLine(P)},C.prototype.removePlotLine=function(P){this.removePlotBandOrLine(P)},C})()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$Q=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$6=Utilities.erase,fireEvent$y=Utilities.fireEvent,merge$1n=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1v=Utilities.pick,PlotLineOrBand=(function(){function v(d,a){this.axis=d,a&&(this.options=a,this.id=a.id)}return v.compose=function(d){return PlotLineOrBandAxis$1.compose(v,d)},v.prototype.render=function(){fireEvent$y(this,"render");var d=this,a=d.axis,p=a.horiz,y=a.logarithmic,C=d.options,P=C.color,z=pick$1v(C.zIndex,0),L=C.events,$={},N=a.chart.renderer,W=C.label,U=d.label,j=C.to,q=C.from,X=C.value,K=d.svgElem,Q=[],te,ne=defined$Q(q)&&defined$Q(j),ie=defined$Q(X),ae=!K,se={class:"highcharts-plot-"+(ne?"band ":"line ")+(C.className||"")},de=ne?"bands":"lines";if(y&&(q=y.log2lin(q),j=y.log2lin(j),X=y.log2lin(X)),a.chart.styledMode||(ie?(se.stroke=P||palette.neutralColor40,se["stroke-width"]=pick$1v(C.width,1),C.dashStyle&&(se.dashstyle=C.dashStyle)):ne&&(se.fill=P||palette.highlightColor10,C.borderWidth&&(se.stroke=C.borderColor,se["stroke-width"]=C.borderWidth))),$.zIndex=z,de+="-"+z,te=a.plotLinesAndBandsGroups[de],te||(a.plotLinesAndBandsGroups[de]=te=N.g("plot-"+de).attr($).add()),ae&&(d.svgElem=K=N.path().attr(se).add(te)),ie)Q=a.getPlotLinePath({value:X,lineWidth:K.strokeWidth(),acrossPanes:C.acrossPanes});else if(ne)Q=a.getPlotBandPath(q,j,C);else return;return!d.eventsAdded&&L&&(objectEach$t(L,function(he,ue){K.on(ue,function(me){L[ue].apply(d,[me])})}),d.eventsAdded=!0),(ae||!K.d)&&Q&&Q.length?K.attr({d:Q}):K&&(Q?(K.show(!0),K.animate({d:Q})):K.d&&(K.hide(),U&&(d.label=U=U.destroy()))),W&&(defined$Q(W.text)||defined$Q(W.formatter))&&Q&&Q.length&&a.width>0&&a.height>0&&!Q.isFlat?(W=merge$1n({align:p&&ne&&"center",x:p?!ne&&4:10,verticalAlign:!p&&ne&&"middle",y:p?ne?16:10:ne?6:-4,rotation:p&&!ne&&90},W),this.renderLabel(W,Q,ne,z)):U&&U.hide(),d},v.prototype.renderLabel=function(d,a,p,y){var C=this,P=C.axis,z=P.chart.renderer,L=C.label;L||(C.label=L=z.text(this.getLabelText(d),0,0,d.useHTML).attr({align:d.textAlign||d.align,rotation:d.rotation,class:"highcharts-plot-"+(p?"band":"line")+"-label "+(d.className||""),zIndex:y}).add(),P.chart.styledMode||L.css(merge$1n({textOverflow:"ellipsis"},d.style)));var $=a.xBounds||[a[0][1],a[1][1],p?a[2][1]:a[0][1]],N=a.yBounds||[a[0][2],a[1][2],p?a[2][2]:a[0][2]],W=arrayMin$7($),U=arrayMin$7(N);L.align(d,!1,{x:W,y:U,width:arrayMax$8($)-W,height:arrayMax$8(N)-U}),(!L.alignValue||L.alignValue==="left")&&L.css({width:(L.rotation===90?P.height-(L.alignAttr.y-P.top):P.width-(L.alignAttr.x-P.left))+"px"}),L.show(!0)},v.prototype.getLabelText=function(d){return defined$Q(d.formatter)?d.formatter.call(this):d.text},v.prototype.destroy=function(){erase$6(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},v})(),format$d=FormatUtilities.format,doc$i=H.doc,distribute$3=R$1.distribute,addEvent$13=Utilities.addEvent,clamp$h=Utilities.clamp,css$9=Utilities.css,defined$P=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1o=Utilities.extend,fireEvent$x=Utilities.fireEvent,isArray$l=Utilities.isArray,isNumber$L=Utilities.isNumber,isString$7=Utilities.isString,merge$1m=Utilities.merge,pick$1u=Utilities.pick,splat$h=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=(function(){function v(d,a){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=d,this.init(d,a)}return v.prototype.applyFilter=function(){var d=this.chart;d.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+d.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},v.prototype.bodyFormatter=function(d){return d.map(function(a){var p=a.series.tooltipOptions;return(p[(a.point.formatPrefix||"point")+"Formatter"]||a.point.tooltipFormatter).call(a.point,p[(a.point.formatPrefix||"point")+"Format"]||"")})},v.prototype.cleanSplit=function(d){this.chart.series.forEach(function(a){var p=a&&a.tt;p&&(!p.isActive||d?a.tt=p.destroy():p.isActive=!1)})},v.prototype.defaultFormatter=function(d){var a=this.points||splat$h(this),p;return p=[d.tooltipFooterHeaderFormatter(a[0])],p=p.concat(d.bodyFormatter(a)),p.push(d.tooltipFooterHeaderFormatter(a[0],!0)),p},v.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},v.prototype.getAnchor=function(d,a){var p=this.chart,y=p.pointer,C=p.inverted,P=p.plotTop,z=p.plotLeft,L,$,N,W=0,U=0;return d=splat$h(d),this.followPointer&&a?(typeof a.chartX>"u"&&(a=y.normalize(a)),L=[a.chartX-z,a.chartY-P]):d[0].tooltipPos?L=d[0].tooltipPos:(d.forEach(function(j){$=j.series.yAxis,N=j.series.xAxis,W+=j.plotX||0,U+=j.plotLow?(j.plotLow+(j.plotHigh||0))/2:j.plotY||0,N&&$&&(C?(W+=P+p.plotHeight-N.len-N.pos,U+=z+p.plotWidth-$.len-$.pos):(W+=N.pos-z,U+=$.pos-P))}),W/=d.length,U/=d.length,L=[C?p.plotWidth-U:W,C?p.plotHeight-W:U],this.shared&&d.length>1&&a&&(C?L[0]=a.chartX-z:L[1]=a.chartY-P)),L.map(Math.round)},v.prototype.getLabel=function(){var d=this,a=this.chart.styledMode,p=this.options,y="tooltip"+(defined$P(p.className)?" "+p.className:""),C=p.style.pointerEvents||(!this.followPointer&&p.stickOnContact?"auto":"none"),P=function(){d.inContact=!0},z=function(X){var K=d.chart.hoverSeries;d.inContact=d.shouldStickOnContact()&&d.chart.pointer.inClass(X.relatedTarget,"highcharts-tooltip"),!d.inContact&&K&&K.onMouseOut&&K.onMouseOut()},L,$=this.chart.renderer;if(!this.label){if(this.outside){var N=this.chart.options.chart.style,W=RendererRegistry$1.getRendererType();this.container=L=H.doc.createElement("div"),L.className="highcharts-tooltip-container",css$9(L,{position:"absolute",top:"1px",pointerEvents:C,zIndex:Math.max(this.options.style.zIndex||0,(N&&N.zIndex||0)+3)}),addEvent$13(L,"mouseenter",P),addEvent$13(L,"mouseleave",z),H.doc.body.appendChild(L),this.renderer=$=new W(L,0,0,N,void 0,void 0,$.styledMode)}if(this.split?this.label=$.g(y):(this.label=$.label("",0,0,p.shape,void 0,void 0,p.useHTML,void 0,y).attr({padding:p.padding,r:p.borderRadius}),a||this.label.attr({fill:p.backgroundColor,"stroke-width":p.borderWidth}).css(p.style).css({pointerEvents:C}).shadow(p.shadow)),a&&p.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),d.outside&&!d.split){var U=this.label,j=U.xSetter,q=U.ySetter;U.xSetter=function(X){j.call(U,d.distance),L.style.left=X+"px"},U.ySetter=function(X){q.call(U,d.distance),L.style.top=X+"px"}}this.label.on("mouseenter",P).on("mouseleave",z).attr({zIndex:8}).add()}return this.label},v.prototype.getPosition=function(d,a,p){var y=this.chart,C=this.distance,P={},z=y.inverted&&p.h||0,L=this.outside,$=L?doc$i.documentElement.clientWidth-2*C:y.chartWidth,N=L?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):y.chartHeight,W=y.pointer.getChartPosition(),U=function(de){return de*W.scaleX},j=function(de){return de*W.scaleY},q=function(de){var he=de==="x";return[de,he?$:N,he?d:a].concat(L?[he?U(d):j(a),he?W.left-C+U(p.plotX+y.plotLeft):W.top-C+j(p.plotY+y.plotTop),0,he?$:N]:[he?d:a,he?p.plotX+y.plotLeft:p.plotY+y.plotTop,he?y.plotLeft:y.plotTop,he?y.plotLeft+y.plotWidth:y.plotTop+y.plotHeight])},X=q("y"),K=q("x"),Q,te=!this.followPointer&&pick$1u(p.ttBelow,!y.inverted==!!p.negative),ne=function(de,he,ue,me,xe,we,ye){var Oe=L?de==="y"?j(C):U(C):C,be=(ue-me)/2,ke=me<xe-C,ze=xe+C+me<he,Ae=xe-Oe-ue+be,Be=xe+Oe-be;if(te&&ze)P[de]=Be;else if(!te&&ke)P[de]=Ae;else if(ke)P[de]=Math.min(ye-me,Ae-z<0?Ae:Ae-z);else if(ze)P[de]=Math.max(we,Be+z+ue>he?Be:Be+z);else return!1},ie=function(de,he,ue,me,xe){var we;return xe<C||xe>he-C?we=!1:xe<ue/2?P[de]=1:xe>he-me/2?P[de]=he-me-2:P[de]=xe-ue/2,we},ae=function(de){var he=X;X=K,K=he,Q=de},se=function(){ne.apply(0,X)!==!1?ie.apply(0,K)===!1&&!Q&&(ae(!0),se()):Q?P.x=P.y=0:(ae(!0),se())};return(y.inverted||this.len>1)&&ae(),se(),P},v.prototype.hide=function(d){var a=this;Utilities.clearTimeout(this.hideTimer),d=pick$1u(d,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){a.getLabel().fadeOut(d&&void 0),a.isHidden=!0},d))},v.prototype.init=function(d,a){this.chart=d,this.options=a,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=a.split&&!d.inverted&&!d.polar,this.shared=a.shared||this.split,this.outside=pick$1u(a.outside,!!(d.scrollablePixelsX||d.scrollablePixelsY))},v.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},v.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},v.prototype.move=function(d,a,p,y){var C=this,P=C.now,z=C.options.animation!==!1&&!C.isHidden&&(Math.abs(d-P.x)>1||Math.abs(a-P.y)>1),L=C.followPointer||C.len>1;extend$1o(P,{x:z?(2*P.x+d)/3:d,y:z?(P.y+a)/2:a,anchorX:L?void 0:z?(2*P.anchorX+p)/3:p,anchorY:L?void 0:z?(P.anchorY+y)/2:y}),C.getLabel().attr(P),C.drawTracker(),z&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){C&&C.move(d,a,p,y)},32))},v.prototype.refresh=function(d,a){var p=this,y=this.chart,C=p.options,P=splat$h(d),z=P[0],L=[],$=C.formatter||p.defaultFormatter,N=p.shared,W=y.styledMode,U={};if(C.enabled){Utilities.clearTimeout(this.hideTimer),p.followPointer=!p.split&&z.series.tooltipOptions.followPointer;var j=p.getAnchor(d,a),q=j[0],X=j[1];N&&!(!isArray$l(d)&&d.series&&d.series.noSharedTooltip)?(y.pointer.applyInactiveState(P),P.forEach(function(ae){ae.setState("hover"),L.push(ae.getLabelConfig())}),U={x:z.category,y:z.y},U.points=L):U=z.getLabelConfig(),this.len=L.length;var K=$.call(U,p),Q=z.series;if(this.distance=pick$1u(Q.tooltipOptions.distance,16),K===!1)this.hide();else{if(p.split)this.renderSplit(K,P);else{var te=q,ne=X;if(a&&y.pointer.isDirectTouch&&(te=a.chartX-y.plotLeft,ne=a.chartY-y.plotTop),y.polar||Q.options.clip===!1||Q.shouldShowTooltip(te,ne)){var ie=p.getLabel();(!C.style.width||W)&&ie.css({width:this.chart.spacingBox.width+"px"}),ie.attr({text:K&&K.join?K.join(""):K}),ie.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1u(z.colorIndex,Q.colorIndex)),W||ie.attr({stroke:C.borderColor||z.color||Q.color||palette.neutralColor60}),p.updatePosition({plotX:q,plotY:X,negative:z.negative,ttBelow:z.ttBelow,h:j[2]||0})}else{p.hide();return}}p.isHidden&&p.label&&p.label.attr({opacity:1}).show(),p.isHidden=!1}fireEvent$x(this,"refresh")}},v.prototype.renderSplit=function(d,a){var p=this,y=p.chart,C=p.chart,P=C.chartWidth;C.chartHeight;var z=C.plotHeight,L=C.plotLeft,$=C.plotTop,N=C.pointer,W=C.scrollablePixelsY,U=W===void 0?0:W,j=C.scrollablePixelsX,q=C.scrollingContainer,X=q===void 0?{scrollLeft:0,scrollTop:0}:q,K=X.scrollLeft,Q=X.scrollTop,te=C.styledMode,ne=p.distance,ie=p.options,ae=p.options.positioner,se=p.outside&&typeof j!="number"?doc$i.documentElement.getBoundingClientRect():{left:K,right:K+P},de=p.getLabel(),he=this.renderer||y.renderer,ue=!!(y.xAxis[0]&&y.xAxis[0].opposite),me=N.getChartPosition(),xe=me.left,we=me.top,ye=$+Q,Oe=0,be=z-U;function ke(Ee){var Se=Ee.isHeader,Ie=Ee.plotX,Te=Ie===void 0?0:Ie,$e=Ee.plotY,De=$e===void 0?0:$e,Ge=Ee.series,je,Ue;if(Se)je=L+Te,Ue=$+z/2;else{var Je=Ge.xAxis,ot=Ge.yAxis;je=Je.pos+clamp$h(Te,-ne,Je.len+ne),Ge.shouldShowTooltip(0,ot.pos-$+De,{ignoreX:!0})&&(Ue=ot.pos+De)}return je=clamp$h(je,se.left-ne,se.right+ne),{anchorX:je,anchorY:Ue}}function ze(Ee,Se,Ie,Te,$e){$e===void 0&&($e=!0);var De,Ge;return Ie?(De=ue?0:be,Ge=clamp$h(Ee-Te/2,se.left,se.right-Te-(p.outside?xe:0))):(De=Se-ye,Ge=$e?Ee-Te-ne:Ee+ne,Ge=clamp$h(Ge,$e?Ge:se.left,se.right)),{x:Ge,y:De}}function Ae(Ee,Se,Ie){var Te=Ee,$e=Se.isHeader,De=Se.series,Ge="highcharts-color-"+pick$1u(Se.colorIndex,De.colorIndex,"none");if(!Te){var je={padding:ie.padding,r:ie.borderRadius};te||(je.fill=ie.backgroundColor,je["stroke-width"]=ie.borderWidth),Te=he.label("",0,0,ie[$e?"headerShape":"shape"],void 0,void 0,ie.useHTML).addClass(($e?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+Ge).attr(je).add(de)}return Te.isActive=!0,Te.attr({text:Ie}),te||Te.css(ie.style).shadow(ie.shadow).attr({stroke:ie.borderColor||Se.color||De.color||palette.neutralColor80}),Te}isString$7(d)&&(d=[!1,d]);var Be=d.slice(0,a.length+1).reduce(function(Ee,Se,Ie){if(Se!==!1&&Se!==""){var Te=a[Ie-1]||{isHeader:!0,plotX:a[0].plotX,plotY:z,series:{}},$e=Te.isHeader,De=$e?p:Te.series,Ge=De.tt=Ae(De.tt,Te,Se.toString()),je=Ge.getBBox(),Ue=je.width+Ge.strokeWidth();$e&&(Oe=je.height,be+=Oe,ue&&(ye-=Oe));var Je=ke(Te),ot=Je.anchorX,st=Je.anchorY;if(typeof st=="number"){var nt=je.height+1,ft=ae?ae.call(p,Ue,nt,Te):ze(ot,st,$e,Ue);Ee.push({align:ae?0:void 0,anchorX:ot,anchorY:st,boxWidth:Ue,point:Te,rank:pick$1u(ft.rank,$e?1:0),size:nt,target:ft.y,tt:Ge,x:ft.x})}else Ge.isActive=!1}return Ee},[]);!ae&&Be.some(function(Ee){var Se=p.outside,Ie=(Se?xe:0)+Ee.anchorX;return Ie<se.left&&Ie+Ee.boxWidth<se.right?!0:Ie<xe-se.left+Ee.boxWidth&&se.right-Ie>Ie})&&(Be=Be.map(function(Ee){var Se=ze(Ee.anchorX,Ee.anchorY,Ee.point.isHeader,Ee.boxWidth,!1),Ie=Se.x,Te=Se.y;return extend$1o(Ee,{target:Te,x:Ie})})),p.cleanSplit(),distribute$3(Be,be);var He={left:xe,right:xe};Be.forEach(function(Ee){var Se=Ee.x,Ie=Ee.boxWidth,Te=Ee.isHeader;Te||(p.outside&&xe+Se<He.left&&(He.left=xe+Se),!Te&&p.outside&&He.left+Ie>He.right&&(He.right=xe+Se))}),Be.forEach(function(Ee){var Se=Ee.x,Ie=Ee.anchorX,Te=Ee.anchorY,$e=Ee.pos,De=Ee.point.isHeader,Ge={visibility:typeof $e>"u"?"hidden":"inherit",x:Se,y:$e+ye,anchorX:Ie,anchorY:Te};if(p.outside&&Se<Ie){var je=xe-He.left;je>0&&(De||(Ge.x=Se+je,Ge.anchorX=Ie+je),De&&(Ge.x=(He.right-He.left)/2,Ge.anchorX=Ie+je))}Ee.tt.attr(Ge)});var Fe=p.container,_e=p.outside,pe=p.renderer;if(_e&&Fe&&pe){var ge=de.getBBox(),Me=ge.width,Pe=ge.height,Le=ge.x,Ne=ge.y;pe.setSize(Me+Le,Pe+Ne,!1),Fe.style.left=He.left+"px",Fe.style.top=we+"px"}},v.prototype.drawTracker=function(){var d=this;if(d.followPointer||!d.options.stickOnContact){d.tracker&&d.tracker.destroy();return}var a=d.chart,p=d.label,y=d.shared?a.hoverPoints:a.hoverPoint;if(!(!p||!y)){var C={x:0,y:0,width:0,height:0},P=this.getAnchor(y),z=p.getBBox();P[0]+=a.plotLeft-p.translateX,P[1]+=a.plotTop-p.translateY,C.x=Math.min(0,P[0]),C.y=Math.min(0,P[1]),C.width=P[0]<0?Math.max(Math.abs(P[0]),z.width-P[0]):Math.max(Math.abs(P[0]),z.width),C.height=P[1]<0?Math.max(Math.abs(P[1]),z.height-Math.abs(P[1])):Math.max(Math.abs(P[1]),z.height),d.tracker?d.tracker.attr(C):(d.tracker=p.renderer.rect(C).addClass("highcharts-tracker").add(p),a.styledMode||d.tracker.attr({fill:"rgba(0,0,0,0)"}))}},v.prototype.styledModeFormat=function(d){return d.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},v.prototype.tooltipFooterHeaderFormatter=function(d,a){var p=d.series,y=p.tooltipOptions,C=p.xAxis,P=C&&C.dateTime,z={isFooter:a,labelConfig:d},L=y.xDateFormat,$=y[a?"footerFormat":"headerFormat"];return fireEvent$x(this,"headerFormatter",z,function(N){P&&!L&&isNumber$L(d.key)&&(L=P.getXDateFormat(d.key,y.dateTimeLabelFormats)),P&&L&&(d.point&&d.point.tooltipDateKeys||["key"]).forEach(function(W){$=$.replace("{point."+W+"}","{point."+W+":"+L+"}")}),p.chart.styledMode&&($=this.styledModeFormat($)),N.text=format$d($,{point:d,series:p},this.chart)}),z.text},v.prototype.update=function(d){this.destroy(),merge$1m(!0,this.chart.options.tooltip.userOptions,d),this.init(this.chart,merge$1m(!0,this.options,d))},v.prototype.updatePosition=function(d){var a=this.chart,p=this.options,y=a.pointer,C=this.getLabel(),P=y.getChartPosition(),z=(p.positioner||this.getPosition).call(this,C.width,C.height,d),L=d.plotX+a.plotLeft,$=d.plotY+a.plotTop,N;this.outside&&(N=p.borderWidth+2*this.distance,this.renderer.setSize(C.width+N,C.height+N,!1),(P.scaleX!==1||P.scaleY!==1)&&(css$9(this.container,{transform:"scale("+P.scaleX+", "+P.scaleY+")"}),L*=P.scaleX,$*=P.scaleY),L+=P.left-z.x,$+=P.top-z.y),this.move(Math.round(z.x),Math.round(z.y||0),L,$)},v})(),animObject$a=animationExports.animObject,defaultOptions$g=DefaultOptions.defaultOptions,format$c=FormatUtilities.format,addEvent$12=Utilities.addEvent,defined$O=Utilities.defined,erase$5=Utilities.erase,extend$1n=Utilities.extend,fireEvent$w=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$k=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$K=Utilities.isNumber,isObject$e=Utilities.isObject,merge$1l=Utilities.merge,objectEach$s=Utilities.objectEach,pick$1t=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$4=(function(){function v(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return v.prototype.animateBeforeDestroy=function(){var d=this,a={x:d.startXPos,opacity:0},p=d.getGraphicalProps();p.singular.forEach(function(y){var C=y==="dataLabel";d[y]=d[y].animate(C?{x:d[y].startXPos,y:d[y].startYPos,opacity:0}:a)}),p.plural.forEach(function(y){d[y].forEach(function(C){C.element&&C.animate(extend$1n({x:d.startXPos},C.startYPos?{x:C.startXPos,y:C.startYPos}:{}))})})},v.prototype.applyOptions=function(d,a){var p=this,y=p.series,C=y.options.pointValKey||y.pointValKey;return d=v.prototype.optionsToObject.call(this,d),extend$1n(p,d),p.options=p.options?extend$1n(p.options,d):d,d.group&&delete p.group,d.dataLabels&&delete p.dataLabels,C&&(p.y=v.prototype.getNestedProperty.call(p,C)),p.isNull=pick$1t(p.isValid&&!p.isValid(),p.x===null||!isNumber$K(p.y)),p.formatPrefix=p.isNull?"null":"point",p.selected&&(p.state="select"),"name"in p&&typeof a>"u"&&y.xAxis&&y.xAxis.hasNames&&(p.x=y.xAxis.nameToX(p)),typeof p.x>"u"&&y?typeof a>"u"?p.x=y.autoIncrement():p.x=a:isNumber$K(d.x)&&y.options.relativeXValue&&(p.x=y.autoIncrement(d.x)),p},v.prototype.destroy=function(){var d=this,a=d.series,p=a.chart,y=a.options.dataSorting,C=p.hoverPoints,P=d.series.chart.renderer.globalAnimation,z=animObject$a(P),L;function $(){(d.graphic||d.dataLabel||d.dataLabels)&&(removeEvent$8(d),d.destroyElements());for(L in d)d[L]=null}d.legendItem&&p.legend.destroyItem(d),C&&(d.setState(),erase$5(C,d),C.length||(p.hoverPoints=null)),d===p.hoverPoint&&d.onMouseOut(),!y||!y.enabled?$():(this.animateBeforeDestroy(),syncTimeout$5($,z.duration)),p.pointCount--},v.prototype.destroyElements=function(d){var a=this,p=a.getGraphicalProps(d);p.singular.forEach(function(y){a[y]=a[y].destroy()}),p.plural.forEach(function(y){a[y].forEach(function(C){C.element&&C.destroy()}),delete a[y]})},v.prototype.firePointEvent=function(d,a,p){var y=this,C=this.series,P=C.options;(P.point.events[d]||y.options&&y.options.events&&y.options.events[d])&&y.importEvents(),d==="click"&&P.allowPointSelect&&(p=function(z){y.select&&y.select(null,z.ctrlKey||z.metaKey||z.shiftKey)}),fireEvent$w(y,d,a,p)},v.prototype.getClassName=function(){var d=this;return"highcharts-point"+(d.selected?" highcharts-point-select":"")+(d.negative?" highcharts-negative":"")+(d.isNull?" highcharts-null-point":"")+(typeof d.colorIndex<"u"?" highcharts-color-"+d.colorIndex:"")+(d.options.className?" "+d.options.className:"")+(d.zone&&d.zone.className?" "+d.zone.className.replace("highcharts-negative",""):"")},v.prototype.getGraphicalProps=function(d){var a=this,p=[],y={singular:[],plural:[]},C,P;for(d=d||{graphic:1,dataLabel:1},d.graphic&&p.push("graphic","upperGraphic","shadowGroup"),d.dataLabel&&p.push("dataLabel","dataLabelUpper","connector"),P=p.length;P--;)C=p[P],a[C]&&y.singular.push(C);return["dataLabel","connector"].forEach(function(z){var L=z+"s";d[z]&&a[L]&&y.plural.push(L)}),y},v.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},v.prototype.getNestedProperty=function(d){if(d)return d.indexOf("custom.")===0?getNestedProperty$1(d,this.options):this[d]},v.prototype.getZone=function(){var d=this.series,a=d.zones,p=d.zoneAxis||"y",y,C=0;for(y=a[C];this[p]>=y.value;)y=a[++C];return this.nonZonedColor||(this.nonZonedColor=this.color),y&&y.color&&!this.options.color?this.color=y.color:this.color=this.nonZonedColor,y},v.prototype.hasNewShapeType=function(){var d=this,a=d.graphic&&(d.graphic.symbolName||d.graphic.element.nodeName);return a!==this.shapeType},v.prototype.init=function(d,a,p){return this.series=d,this.applyOptions(a,p),this.id=defined$O(this.id)?this.id:uniqueKey$5(),this.resolveColor(),d.chart.pointCount++,fireEvent$w(this,"afterInit"),this},v.prototype.optionsToObject=function(d){var a=this.series,p=a.options.keys,y=p||a.pointArrayMap||["y"],C=y.length,P={},z,L=0,$=0;if(isNumber$K(d)||d===null)P[y[0]]=d;else if(isArray$k(d))for(!p&&d.length>C&&(z=typeof d[0],z==="string"?P.name=d[0]:z==="number"&&(P.x=d[0]),L++);$<C;)(!p||typeof d[L]<"u")&&(y[$].indexOf(".")>0?v.prototype.setNestedProperty(P,d[L],y[$]):P[y[$]]=d[L]),L++,$++;else typeof d=="object"&&(P=d,d.dataLabels&&(a._hasPointLabels=!0),d.marker&&(a._hasPointMarkers=!0));return P},v.prototype.resolveColor=function(){var d=this.series,a=d.chart.options.chart,p=d.chart.styledMode,y,C,P=a.colorCount,z;delete this.nonZonedColor,d.options.colorByPoint?(p||(C=d.options.colors||d.chart.options.colors,y=C[d.colorCounter],P=C.length),z=d.colorCounter,d.colorCounter++,d.colorCounter===P&&(d.colorCounter=0)):(p||(y=d.color),z=d.colorIndex),this.colorIndex=pick$1t(this.options.colorIndex,z),this.color=pick$1t(this.options.color,y)},v.prototype.setNestedProperty=function(d,a,p){var y=p.split(".");return y.reduce(function(C,P,z,L){var $=L.length-1===z;return C[P]=$?a:isObject$e(C[P],!0)?C[P]:{},C[P]},d),d},v.prototype.tooltipFormatter=function(d){var a=this.series,p=a.tooltipOptions,y=pick$1t(p.valueDecimals,""),C=p.valuePrefix||"",P=p.valueSuffix||"";return a.chart.styledMode&&(d=a.chart.tooltip.styledModeFormat(d)),(a.pointArrayMap||["y"]).forEach(function(z){z="{point."+z,(C||P)&&(d=d.replace(RegExp(z+"}","g"),C+z+"}"+P)),d=d.replace(RegExp(z+"}","g"),z+":,."+y+"f}")}),format$c(d,{point:this,series:this.series},a.chart)},v.prototype.update=function(d,a,p,y){var C=this,P=C.series,z=C.graphic,L=P.chart,$=P.options,N;a=pick$1t(a,!0);function W(){C.applyOptions(d);var U=z&&C.hasDummyGraphic,j=C.y===null?!U:U;z&&j&&(C.graphic=z.destroy(),delete C.hasDummyGraphic),isObject$e(d,!0)&&(z&&z.element&&d&&d.marker&&typeof d.marker.symbol<"u"&&(C.graphic=z.destroy()),d&&d.dataLabels&&C.dataLabel&&(C.dataLabel=C.dataLabel.destroy()),C.connector&&(C.connector=C.connector.destroy())),N=C.index,P.updateParallelArrays(C,N),$.data[N]=isObject$e($.data[N],!0)||isObject$e(d,!0)?C.options:pick$1t(d,$.data[N]),P.isDirty=P.isDirtyData=!0,!P.fixedBox&&P.hasCartesianSeries&&(L.isDirtyBox=!0),$.legendType==="point"&&(L.isDirtyLegend=!0),a&&L.redraw(p)}y===!1?W():C.firePointEvent("update",{options:d},W)},v.prototype.remove=function(d,a){this.series.removePoint(this.series.data.indexOf(this),d,a)},v.prototype.select=function(d,a){var p=this,y=p.series,C=y.chart;d=pick$1t(d,!p.selected),this.selectedStaging=d,p.firePointEvent(d?"select":"unselect",{accumulate:a},function(){p.selected=p.options.selected=d,y.options.data[y.data.indexOf(p)]=p.options,p.setState(d&&"select"),a||C.getSelectedPoints().forEach(function(P){var z=P.series;P.selected&&P!==p&&(P.selected=P.options.selected=!1,z.options.data[z.data.indexOf(P)]=P.options,P.setState(C.hoverPoints&&z.options.inactiveOtherPoints?"inactive":""),P.firePointEvent("unselect"))})}),delete this.selectedStaging},v.prototype.onMouseOver=function(d){var a=this,p=a.series,y=p.chart,C=y.pointer;d=d?C.normalize(d):C.getChartCoordinatesFromPoint(a,y.inverted),C.runPointActions(d,a)},v.prototype.onMouseOut=function(){var d=this,a=d.series.chart;d.firePointEvent("mouseOut"),d.series.options.inactiveOtherPoints||(a.hoverPoints||[]).forEach(function(p){p.setState()}),a.hoverPoints=a.hoverPoint=null},v.prototype.importEvents=function(){if(!this.hasImportedEvents){var d=this,a=merge$1l(d.series.options.point,d.options),p=a.events;d.events=p,objectEach$s(p,function(y,C){isFunction$2(y)&&addEvent$12(d,C,y)}),this.hasImportedEvents=!0}},v.prototype.setState=function(d,a){var p=this,y=p.series,C=p.state,P=y.options.states[d||"normal"]||{},z=defaultOptions$g.plotOptions[y.type].marker&&y.options.marker,L=z&&z.enabled===!1,$=z&&z.states&&z.states[d||"normal"]||{},N=$.enabled===!1,W=p.marker||{},U=y.chart,j=z&&y.markerAttribs,q=y.halo,X,K,Q,te=y.stateMarkerGraphic,ne;if(d=d||"",!(d===p.state&&!a||p.selected&&d!=="select"||P.enabled===!1||d&&(N||L&&$.enabled===!1)||d&&W.states&&W.states[d]&&W.states[d].enabled===!1)){p.state=d,j&&(X=y.markerAttribs(p,d)),p.graphic&&!p.hasDummyGraphic?(C&&p.graphic.removeClass("highcharts-point-"+C),d&&p.graphic.addClass("highcharts-point-"+d),U.styledMode||(K=y.pointAttribs(p,d),Q=pick$1t(U.options.chart.animation,P.animation),y.options.inactiveOtherPoints&&isNumber$K(K.opacity)&&((p.dataLabels||[]).forEach(function(de){de&&de.animate({opacity:K.opacity},Q)}),p.connector&&p.connector.animate({opacity:K.opacity},Q)),p.graphic.animate(K,Q)),X&&p.graphic.animate(X,pick$1t(U.options.chart.animation,$.animation,z.animation)),te&&te.hide()):(d&&$&&(ne=W.symbol||y.symbol,te&&te.currentSymbol!==ne&&(te=te.destroy()),X&&(te?te[a?"animate":"attr"]({x:X.x,y:X.y}):ne&&(y.stateMarkerGraphic=te=U.renderer.symbol(ne,X.x,X.y,X.width,X.height).add(y.markerGroup),te.currentSymbol=ne)),!U.styledMode&&te&&te.attr(y.pointAttribs(p,d))),te&&(te[d&&p.isInside?"show":"hide"](),te.element.point=p,te.addClass(p.getClassName(),!0)));var ie=P.halo,ae=p.graphic||te,se=ae&&ae.visibility||"inherit";ie&&ie.size&&ae&&se!=="hidden"&&!p.isCluster?(q||(y.halo=q=U.renderer.path().add(ae.parentGroup)),q.show()[a?"animate":"attr"]({d:p.haloPath(ie.size)}),q.attr({class:"highcharts-halo highcharts-color-"+pick$1t(p.colorIndex,y.colorIndex)+(p.className?" "+p.className:""),visibility:se,zIndex:-1}),q.point=p,U.styledMode||q.attr(extend$1n({fill:p.color||y.color,"fill-opacity":ie.opacity},AST.filterUserAttributes(ie.attributes||{})))):q&&q.point&&q.point.haloPath&&q.animate({d:q.point.haloPath(0)},null,q.hide),fireEvent$w(p,"afterSetState",{state:d})}},v.prototype.haloPath=function(d){var a=this.series,p=a.chart;return p.renderer.symbols.circle(Math.floor(this.plotX)-d,this.plotY-d,d*2,d*2)},v})(),color$e=Color.parse,charts$3=H.charts,noop$i=H.noop,addEvent$11=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$N=Utilities.defined,extend$1m=Utilities.extend,find$k=Utilities.find,fireEvent$v=Utilities.fireEvent,isNumber$J=Utilities.isNumber,isObject$d=Utilities.isObject,objectEach$r=Utilities.objectEach,offset=Utilities.offset,pick$1s=Utilities.pick,splat$g=Utilities.splat,Pointer=(function(){function v(d,a){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=d,this.hasDragged=!1,this.options=a,this.init(d,a)}return v.prototype.applyInactiveState=function(d){var a=[],p;(d||[]).forEach(function(y){p=y.series,a.push(p),p.linkedParent&&a.push(p.linkedParent),p.linkedSeries&&(a=a.concat(p.linkedSeries)),p.navigatorSeries&&a.push(p.navigatorSeries)}),this.chart.series.forEach(function(y){a.indexOf(y)===-1?y.setState("inactive",!0):y.options.inactiveOtherPoints&&y.setAllPointsToState("inactive")})},v.prototype.destroy=function(){var d=this;this.eventsToUnbind.forEach(function(a){return a()}),this.eventsToUnbind=[],H.chartCount||(v.unbindDocumentMouseUp&&(v.unbindDocumentMouseUp=v.unbindDocumentMouseUp()),v.unbindDocumentTouchEnd&&(v.unbindDocumentTouchEnd=v.unbindDocumentTouchEnd())),clearInterval(d.tooltipTimeout),objectEach$r(d,function(a,p){d[p]=void 0})},v.prototype.drag=function(d){var a=this.chart,p=a.options.chart,y=this.zoomHor,C=this.zoomVert,P=a.plotLeft,z=a.plotTop,L=a.plotWidth,$=a.plotHeight,N=this.mouseDownX||0,W=this.mouseDownY||0,U=isObject$d(p.panning)?p.panning&&p.panning.enabled:p.panning,j=p.panKey&&d[p.panKey+"Key"],q=d.chartX,X=d.chartY,K,Q,te=this.selectionMarker;te&&te.touch||(q<P?q=P:q>P+L&&(q=P+L),X<z?X=z:X>z+$&&(X=z+$),this.hasDragged=Math.sqrt(Math.pow(N-q,2)+Math.pow(W-X,2)),this.hasDragged>10&&(K=a.isInsidePlot(N-P,W-z,{visiblePlotOnly:!0}),a.hasCartesianSeries&&(this.zoomX||this.zoomY)&&K&&!j&&(te||(this.selectionMarker=te=a.renderer.rect(P,z,y?1:L,C?1:$,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),a.styledMode||te.attr({fill:p.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),te&&y&&(Q=q-N,te.attr({width:Math.abs(Q),x:(Q>0?0:Q)+N})),te&&C&&(Q=X-W,te.attr({height:Math.abs(Q),y:(Q>0?0:Q)+W})),K&&!te&&U&&a.pan(d,p.panning)))},v.prototype.dragStart=function(d){var a=this.chart;a.mouseIsDown=d.type,a.cancelClick=!1,a.mouseDownX=this.mouseDownX=d.chartX,a.mouseDownY=this.mouseDownY=d.chartY},v.prototype.drop=function(d){var a=this,p=this.chart,y=this.hasPinched;if(this.selectionMarker){var C={originalEvent:d,xAxis:[],yAxis:[]},P=this.selectionMarker,z=P.attr?P.attr("x"):P.x,L=P.attr?P.attr("y"):P.y,$=P.attr?P.attr("width"):P.width,N=P.attr?P.attr("height"):P.height,W;(this.hasDragged||y)&&(p.axes.forEach(function(U){if(U.zoomEnabled&&defined$N(U.min)&&(y||a[{xAxis:"zoomX",yAxis:"zoomY"}[U.coll]])&&isNumber$J(z)&&isNumber$J(L)){var j=U.horiz,q=d.type==="touchend"?U.minPixelPadding:0,X=U.toValue((j?z:L)+q),K=U.toValue((j?z+$:L+N)-q);C[U.coll].push({axis:U,min:Math.min(X,K),max:Math.max(X,K)}),W=!0}}),W&&fireEvent$v(p,"selection",C,function(U){p.zoom(extend$1m(U,y?{animation:!1}:null))})),isNumber$J(p.index)&&(this.selectionMarker=this.selectionMarker.destroy()),y&&this.scaleGroups()}p&&isNumber$J(p.index)&&(css$8(p.container,{cursor:p._cursor}),p.cancelClick=this.hasDragged>10,p.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},v.prototype.findNearestKDPoint=function(d,a,p){var y=this.chart,C=y.hoverPoint,P=y.tooltip;if(C&&P&&P.isStickyOnContact())return C;var z;function L($,N){var W=$.distX-N.distX,U=$.dist-N.dist,j=(N.series.group&&N.series.group.zIndex)-($.series.group&&$.series.group.zIndex),q;return W!==0&&a?q=W:U!==0?q=U:j!==0?q=j:q=$.series.index>N.series.index?-1:1,q}return d.forEach(function($){var N=$.noSharedTooltip&&a,W=!N&&$.options.findNearestPointBy.indexOf("y")<0,U=$.searchPoint(p,W);isObject$d(U,!0)&&U.series&&(!isObject$d(z,!0)||L(z,U)>0)&&(z=U)}),z},v.prototype.getChartCoordinatesFromPoint=function(d,a){var p=d.series,y=p.xAxis,C=p.yAxis,P=d.shapeArgs;if(y&&C){var z=pick$1s(d.clientX,d.plotX),L=d.plotY||0;return d.isNode&&P&&isNumber$J(P.x)&&isNumber$J(P.y)&&(z=P.x,L=P.y),a?{chartX:C.len+C.pos-L,chartY:y.len+y.pos-z}:{chartX:z+y.pos,chartY:L+C.pos}}if(P&&P.x&&P.y)return{chartX:P.x,chartY:P.y}},v.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var d=this.chart.container,a=offset(d);this.chartPosition={left:a.left,top:a.top,scaleX:1,scaleY:1};var p=d.offsetWidth,y=d.offsetHeight;return p>2&&y>2&&(this.chartPosition.scaleX=a.width/p,this.chartPosition.scaleY=a.height/y),this.chartPosition},v.prototype.getCoordinates=function(d){var a={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(p){a[p.isXAxis?"xAxis":"yAxis"].push({axis:p,value:p.toValue(d[p.horiz?"chartX":"chartY"])})}),a},v.prototype.getHoverData=function(d,a,p,y,C,P){var z=[],L=!!(y&&d),$=function(X){return X.visible&&!(!C&&X.directTouch)&&pick$1s(X.options.enableMouseTracking,!0)},N=a,W,U={chartX:P?P.chartX:void 0,chartY:P?P.chartY:void 0,shared:C};fireEvent$v(this,"beforeGetHoverData",U);var j=N&&!N.stickyTracking;W=j?[N]:p.filter(function(X){return U.filter?U.filter(X):$(X)&&X.stickyTracking});var q=L||!P?d:this.findNearestKDPoint(W,C,P);return N=q&&q.series,q&&(C&&!N.noSharedTooltip?(W=p.filter(function(X){return U.filter?U.filter(X):$(X)&&!X.noSharedTooltip}),W.forEach(function(X){var K=find$k(X.points,function(Q){return Q.x===q.x&&!Q.isNull});isObject$d(K)&&(X.chart.isBoosting&&(K=X.getPoint(K)),z.push(K))})):z.push(q)),U={hoverPoint:q},fireEvent$v(this,"afterGetHoverData",U),{hoverPoint:U.hoverPoint,hoverSeries:N,hoverPoints:z}},v.prototype.getPointFromEvent=function(d){for(var a=d.target,p;a&&!p;)p=a.point,a=a.parentNode;return p},v.prototype.onTrackerMouseOut=function(d){var a=this.chart,p=d.relatedTarget||d.toElement,y=a.hoverSeries;this.isDirectTouch=!1,y&&p&&!y.stickyTracking&&!this.inClass(p,"highcharts-tooltip")&&(!this.inClass(p,"highcharts-series-"+y.index)||!this.inClass(p,"highcharts-tracker"))&&y.onMouseOut()},v.prototype.inClass=function(d,a){for(var p;d;){if(p=attr$2(d,"class"),p){if(p.indexOf(a)!==-1)return!0;if(p.indexOf("highcharts-container")!==-1)return!1}d=d.parentNode}},v.prototype.init=function(d,a){this.options=a,this.chart=d,this.runChartClick=!!(a.chart.events&&a.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(d.tooltip=new Tooltip(d,a.tooltip),this.followTouchMove=pick$1s(a.tooltip.followTouchMove,!0)),this.setDOMEvents()},v.prototype.normalize=function(d,a){var p=d.touches,y=p?p.length?p.item(0):pick$1s(p.changedTouches,d.changedTouches)[0]:d;a||(a=this.getChartPosition());var C=y.pageX-a.left,P=y.pageY-a.top;return C/=a.scaleX,P/=a.scaleY,extend$1m(d,{chartX:Math.round(C),chartY:Math.round(P)})},v.prototype.onContainerClick=function(d){var a=this.chart,p=a.hoverPoint,y=this.normalize(d),C=a.plotLeft,P=a.plotTop;a.cancelClick||(p&&this.inClass(y.target,"highcharts-tracker")?(fireEvent$v(p.series,"click",extend$1m(y,{point:p})),a.hoverPoint&&p.firePointEvent("click",y)):(extend$1m(y,this.getCoordinates(y)),a.isInsidePlot(y.chartX-C,y.chartY-P,{visiblePlotOnly:!0})&&fireEvent$v(a,"click",y)))},v.prototype.onContainerMouseDown=function(d){var a=((d.buttons||d.button)&1)===1;d=this.normalize(d),H.isFirefox&&d.button!==0&&this.onContainerMouseMove(d),(typeof d.button>"u"||a)&&(this.zoomOption(d),a&&d.preventDefault&&d.preventDefault(),this.dragStart(d))},v.prototype.onContainerMouseLeave=function(d){var a=charts$3[pick$1s(v.hoverChartIndex,-1)],p=this.chart.tooltip;p&&p.shouldStickOnContact()&&this.inClass(d.relatedTarget,"highcharts-tooltip-container")||(d=this.normalize(d),a&&(d.relatedTarget||d.toElement)&&(a.pointer.reset(),a.pointer.chartPosition=void 0),p&&!p.isHidden&&this.reset())},v.prototype.onContainerMouseEnter=function(d){delete this.chartPosition},v.prototype.onContainerMouseMove=function(d){var a=this.chart,p=this.normalize(d);this.setHoverChartIndex(),p.preventDefault||(p.returnValue=!1),(a.mouseIsDown==="mousedown"||this.touchSelect(p))&&this.drag(p),!a.openMenu&&(this.inClass(p.target,"highcharts-tracker")||a.isInsidePlot(p.chartX-a.plotLeft,p.chartY-a.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(p.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(p))},v.prototype.onDocumentTouchEnd=function(d){var a=charts$3[pick$1s(v.hoverChartIndex,-1)];a&&a.pointer.drop(d)},v.prototype.onContainerTouchMove=function(d){this.touchSelect(d)?this.onContainerMouseMove(d):this.touch(d)},v.prototype.onContainerTouchStart=function(d){this.touchSelect(d)?this.onContainerMouseDown(d):(this.zoomOption(d),this.touch(d,!0))},v.prototype.onDocumentMouseMove=function(d){var a=this.chart,p=this.chartPosition,y=this.normalize(d,p),C=a.tooltip;p&&(!C||!C.isStickyOnContact())&&!a.isInsidePlot(y.chartX-a.plotLeft,y.chartY-a.plotTop,{visiblePlotOnly:!0})&&!this.inClass(y.target,"highcharts-tracker")&&this.reset()},v.prototype.onDocumentMouseUp=function(d){var a=charts$3[pick$1s(v.hoverChartIndex,-1)];a&&a.pointer.drop(d)},v.prototype.pinch=function(d){var a=this,p=a.chart,y=a.pinchDown,C=d.touches||[],P=C.length,z=a.lastValidTouch,L=a.hasZoom,$={},N=P===1&&(a.inClass(d.target,"highcharts-tracker")&&p.runTrackerClick||a.runChartClick),W={},U=a.selectionMarker;P>1?a.initiated=!0:P===1&&this.followTouchMove&&(a.initiated=!1),L&&a.initiated&&!N&&d.cancelable!==!1&&d.preventDefault(),[].map.call(C,function(j){return a.normalize(j)}),d.type==="touchstart"?([].forEach.call(C,function(j,q){y[q]={chartX:j.chartX,chartY:j.chartY}}),z.x=[y[0].chartX,y[1]&&y[1].chartX],z.y=[y[0].chartY,y[1]&&y[1].chartY],p.axes.forEach(function(j){if(j.zoomEnabled){var q=p.bounds[j.horiz?"h":"v"],X=j.minPixelPadding,K=j.toPixels(Math.min(pick$1s(j.options.min,j.dataMin),j.dataMin)),Q=j.toPixels(Math.max(pick$1s(j.options.max,j.dataMax),j.dataMax)),te=Math.min(K,Q),ne=Math.max(K,Q);q.min=Math.min(j.pos,te-X),q.max=Math.max(j.pos+j.len,ne+X)}}),a.res=!0):a.followTouchMove&&P===1?this.runPointActions(a.normalize(d)):y.length&&(U||(a.selectionMarker=U=extend$1m({destroy:noop$i,touch:!0},p.plotBox)),a.pinchTranslate(y,C,$,U,W,z),a.hasPinched=L,a.scaleGroups($,W),a.res&&(a.res=!1,this.reset(!1,0)))},v.prototype.pinchTranslate=function(d,a,p,y,C,P){this.zoomHor&&this.pinchTranslateDirection(!0,d,a,p,y,C,P),this.zoomVert&&this.pinchTranslateDirection(!1,d,a,p,y,C,P)},v.prototype.pinchTranslateDirection=function(d,a,p,y,C,P,z,L){var $=this.chart,N=d?"x":"y",W=d?"X":"Y",U="chart"+W,j=d?"width":"height",q=$["plot"+(d?"Left":"Top")],X=$.inverted,K=$.bounds[d?"h":"v"],Q=a.length===1,te=a[0][U],ne=!Q&&a[1][U],ie=function(){typeof me=="number"&&Math.abs(te-ne)>20&&(he=L||Math.abs(ue-me)/Math.abs(te-ne)),de=(q-ue)/he+te,ae=$["plot"+(d?"Width":"Height")]/he},ae,se,de,he=L||1,ue=p[0][U],me=!Q&&p[1][U],xe;ie(),se=de,se<K.min?(se=K.min,xe=!0):se+ae>K.max&&(se=K.max-ae,xe=!0),xe?(ue-=.8*(ue-z[N][0]),typeof me=="number"&&(me-=.8*(me-z[N][1])),ie()):z[N]=[ue,me],X||(P[N]=de-q,P[j]=ae);var we=X?d?"scaleY":"scaleX":"scale"+W,ye=X?1/he:he;C[j]=ae,C[N]=se,y[we]=he,y["translate"+W]=ye*q+(ue-ye*te)},v.prototype.reset=function(d,a){var p=this,y=p.chart,C=y.hoverSeries,P=y.hoverPoint,z=y.hoverPoints,L=y.tooltip,$=L&&L.shared?z:P;d&&$&&splat$g($).forEach(function(N){N.series.isCartesian&&typeof N.plotX>"u"&&(d=!1)}),d?L&&$&&splat$g($).length&&(L.refresh($),L.shared&&z?z.forEach(function(N){N.setState(N.state,!0),N.series.isCartesian&&(N.series.xAxis.crosshair&&N.series.xAxis.drawCrosshair(null,N),N.series.yAxis.crosshair&&N.series.yAxis.drawCrosshair(null,N))}):P&&(P.setState(P.state,!0),y.axes.forEach(function(N){N.crosshair&&P.series[N.coll]===N&&N.drawCrosshair(null,P)}))):(P&&P.onMouseOut(),z&&z.forEach(function(N){N.setState()}),C&&C.onMouseOut(),L&&L.hide(a),p.unDocMouseMove&&(p.unDocMouseMove=p.unDocMouseMove()),y.axes.forEach(function(N){N.hideCrosshair()}),p.hoverX=y.hoverPoints=y.hoverPoint=null)},v.prototype.runPointActions=function(d,a){var p=this,y=p.chart,C=y.series,P=y.tooltip&&y.tooltip.options.enabled?y.tooltip:void 0,z=P?P.shared:!1,L=a||y.hoverPoint,$=L&&L.series||y.hoverSeries,N=(!d||d.type!=="touchmove")&&(!!a||$&&$.directTouch&&p.isDirectTouch),W=this.getHoverData(L,$,C,N,z,d);L=W.hoverPoint,$=W.hoverSeries;var U=W.hoverPoints,j=$&&$.tooltipOptions.followPointer&&!$.tooltipOptions.split,q=z&&$&&!$.noSharedTooltip;if(L&&(L!==y.hoverPoint||P&&P.isHidden)){if((y.hoverPoints||[]).forEach(function(K){U.indexOf(K)===-1&&K.setState()}),y.hoverSeries!==$&&$.onMouseOver(),p.applyInactiveState(U),(U||[]).forEach(function(K){K.setState("hover")}),y.hoverPoint&&y.hoverPoint.firePointEvent("mouseOut"),!L.series)return;y.hoverPoints=U,y.hoverPoint=L,L.firePointEvent("mouseOver"),P&&P.refresh(q?U:L,d)}else if(j&&P&&!P.isHidden){var X=P.getAnchor([{}],d);y.isInsidePlot(X[0],X[1],{visiblePlotOnly:!0})&&P.updatePosition({plotX:X[0],plotY:X[1]})}p.unDocMouseMove||(p.unDocMouseMove=addEvent$11(y.container.ownerDocument,"mousemove",function(K){var Q=charts$3[v.hoverChartIndex];Q&&Q.pointer.onDocumentMouseMove(K)}),p.eventsToUnbind.push(p.unDocMouseMove)),y.axes.forEach(function(Q){var te=pick$1s((Q.crosshair||{}).snap,!0),ne;te&&(ne=y.hoverPoint,(!ne||ne.series[Q.coll]!==Q)&&(ne=find$k(U,function(ie){return ie.series[Q.coll]===Q}))),ne||!te?Q.drawCrosshair(d,ne):Q.hideCrosshair()})},v.prototype.scaleGroups=function(d,a){var p=this.chart;p.series.forEach(function(y){var C=d||y.getPlotBox();y.xAxis&&y.xAxis.zoomEnabled&&y.group&&(y.group.attr(C),y.markerGroup&&(y.markerGroup.attr(C),y.markerGroup.clip(a?p.clipRect:null)),y.dataLabelsGroup&&y.dataLabelsGroup.attr(C))}),p.clipRect.attr(a||p.clipBox)},v.prototype.setDOMEvents=function(){var d=this,a=this.chart.container,p=a.ownerDocument;a.onmousedown=this.onContainerMouseDown.bind(this),a.onmousemove=this.onContainerMouseMove.bind(this),a.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$11(a,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$11(a,"mouseleave",this.onContainerMouseLeave.bind(this))),v.unbindDocumentMouseUp||(v.unbindDocumentMouseUp=addEvent$11(p,"mouseup",this.onDocumentMouseUp.bind(this)));for(var y=this.chart.renderTo.parentElement;y&&y.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$11(y,"scroll",function(){delete d.chartPosition})),y=y.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$11(a,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$11(a,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),v.unbindDocumentTouchEnd||(v.unbindDocumentTouchEnd=addEvent$11(p,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},v.prototype.setHoverChartIndex=function(){var d=this.chart,a=H.charts[pick$1s(v.hoverChartIndex,-1)];a&&a!==d&&a.pointer.onContainerMouseLeave({relatedTarget:!0}),(!a||!a.mouseIsDown)&&(v.hoverChartIndex=d.index)},v.prototype.touch=function(d,a){var p=this.chart,y,C,P;this.setHoverChartIndex(),d.touches.length===1?(d=this.normalize(d),P=p.isInsidePlot(d.chartX-p.plotLeft,d.chartY-p.plotTop,{visiblePlotOnly:!0}),P&&!p.openMenu?(a&&this.runPointActions(d),d.type==="touchmove"&&(C=this.pinchDown,y=C[0]?Math.sqrt(Math.pow(C[0].chartX-d.chartX,2)+Math.pow(C[0].chartY-d.chartY,2))>=4:!1),pick$1s(y,!0)&&this.pinch(d)):a&&this.reset()):d.touches.length===2&&this.pinch(d)},v.prototype.touchSelect=function(d){return!!(this.chart.options.chart.zoomBySingleTouch&&d.touches&&d.touches.length===1)},v.prototype.zoomOption=function(d){var a=this.chart,p=a.options.chart,y=a.inverted,C=p.zoomType||"",P,z;/touch/.test(d.type)&&(C=pick$1s(p.pinchType,C)),this.zoomX=P=/x/.test(C),this.zoomY=z=/y/.test(C),this.zoomHor=P&&!y||z&&y,this.zoomVert=z&&!y||P&&y,this.hasZoom=P||z},v})(),__extends$Y=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),charts$2=H.charts,doc$h=H.doc,noop$h=H.noop,win$a=H.win,addEvent$10=Utilities.addEvent,css$7=Utilities.css,objectEach$q=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var v=[];return v.item=function(d){return this[d]},objectEach$q(touches,function(d){v.push({pageX:d.pageX,pageY:d.pageY,target:d.target})}),v}function translateMSPointer(v,d,a,p){var y=charts$2[Pointer.hoverChartIndex||NaN];if((v.pointerType==="touch"||v.pointerType===v.MSPOINTER_TYPE_TOUCH)&&y){var C=y.pointer;p(v),C[d]({type:a,target:v.currentTarget,preventDefault:noop$h,touches:getWebkitTouches()})}}var MSPointer=(function(v){__extends$Y(d,v);function d(){return v!==null&&v.apply(this,arguments)||this}return d.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},d.prototype.batchMSEvents=function(a){a(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),a(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),a(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},d.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),v.prototype.destroy.call(this)},d.prototype.init=function(a,p){v.prototype.init.call(this,a,p),this.hasZoom&&css$7(a.container,{"-ms-touch-action":"none","touch-action":"none"})},d.prototype.onContainerPointerDown=function(a){translateMSPointer(a,"onContainerTouchStart","touchstart",function(p){touches[p.pointerId]={pageX:p.pageX,pageY:p.pageY,target:p.currentTarget}})},d.prototype.onContainerPointerMove=function(a){translateMSPointer(a,"onContainerTouchMove","touchmove",function(p){touches[p.pointerId]={pageX:p.pageX,pageY:p.pageY},touches[p.pointerId].target||(touches[p.pointerId].target=p.currentTarget)})},d.prototype.onDocumentPointerUp=function(a){translateMSPointer(a,"onDocumentTouchEnd","touchend",function(p){delete touches[p.pointerId]})},d.prototype.setDOMEvents=function(){v.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$10)},d})(Pointer),animObject$9=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$b=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R$1.distribute,addEvent$$=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$M=Utilities.defined,discardElement$4=Utilities.discardElement,find$j=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1k=Utilities.merge,pick$1r=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$h=Utilities.wrap,Legend=(function(){function v(d,a){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=d,this.init(d,a)}return v.prototype.init=function(d,a){this.chart=d,this.setOptions(a),a.enabled&&(this.render(),addEvent$$(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$$(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},v.prototype.setOptions=function(d){var a=pick$1r(d.padding,8);this.options=d,this.chart.styledMode||(this.itemStyle=d.itemStyle,this.itemHiddenStyle=merge$1k(this.itemStyle,d.itemHiddenStyle)),this.itemMarginTop=d.itemMarginTop||0,this.itemMarginBottom=d.itemMarginBottom||0,this.padding=a,this.initialItemY=a-5,this.symbolWidth=pick$1r(d.symbolWidth,16),this.pages=[],this.proximate=d.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},v.prototype.update=function(d,a){var p=this.chart;this.setOptions(merge$1k(!0,this.options,d)),this.destroy(),p.isDirtyLegend=p.isDirtyBox=!0,pick$1r(a,!0)&&p.redraw(),fireEvent$u(this,"afterUpdate")},v.prototype.colorizeItem=function(d,a){if(d.legendGroup[a?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var p=this,y=p.options,C=d.legendItem,P=d.legendLine,z=d.legendSymbol,L=p.itemHiddenStyle.color,$=a?y.itemStyle.color:L,N=a&&d.color||L,W=d.options&&d.options.marker,U={fill:N};C&&C.css({fill:$,color:$}),P&&P.attr({stroke:N}),z&&(W&&z.isMarker&&(U=d.pointAttribs(),a||(U.stroke=U.fill=L)),z.attr(U))}fireEvent$u(this,"afterColorizeItem",{item:d,visible:a})},v.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},v.prototype.positionItem=function(d){var a=this,p=this,y=p.options,C=y.symbolPadding,P=!y.rtl,z=d._legendItemPos,L=z[0],$=z[1],N=d.checkbox,W=d.legendGroup;if(W&&W.element){var U={translateX:P?L:p.legendWidth-L-2*C-4,translateY:$},j=function(){fireEvent$u(a,"afterPositionItem",{item:d})};defined$M(W.translateY)?W.animate(U,void 0,j):(W.attr(U),j())}N&&(N.x=L,N.y=$)},v.prototype.destroyItem=function(d){var a=d.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(p){d[p]&&(d[p]=d[p].destroy())}),a&&discardElement$4(d.checkbox)},v.prototype.destroy=function(){function d(a){this[a]&&(this[a]=this[a].destroy())}this.getAllItems().forEach(function(a){["legendItem","legendGroup"].forEach(d,a)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(d,this),this.display=null},v.prototype.positionCheckboxes=function(){var d=this.group&&this.group.alignAttr,a=this.clipHeight||this.legendHeight,p=this.titleHeight,y;d&&(y=d.translateY,this.allItems.forEach(function(C){var P=C.checkbox,z;P&&(z=y+p+P.y+(this.scrollOffset||0)+3,css$6(P,{left:d.translateX+C.checkboxOffset+P.x-20+"px",top:z+"px",display:this.proximate||z>y-6&&z<y+a-6?"":"none"}))},this))},v.prototype.renderTitle=function(){var d=this.options,a=this.padding,p=d.title,y,C=0;p.text&&(this.title||(this.title=this.chart.renderer.label(p.text,a-3,a-4,null,null,null,d.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(p.style),this.title.add(this.group)),p.width||this.title.css({width:this.maxLegendWidth+"px"}),y=this.title.getBBox(),C=y.height,this.offsetWidth=y.width,this.contentGroup.attr({translateY:C})),this.titleHeight=C},v.prototype.setText=function(d){var a=this.options;d.legendItem.attr({text:a.labelFormat?format$b(a.labelFormat,d,this.chart):a.labelFormatter.call(d)})},v.prototype.renderItem=function(d){var a=this,p=a.chart,y=p.renderer,C=a.options,P=C.layout==="horizontal",z=a.symbolWidth,L=C.symbolPadding||0,$=a.itemStyle,N=a.itemHiddenStyle,W=P?pick$1r(C.itemDistance,20):0,U=!C.rtl,j=!d.series,q=!j&&d.series.drawLegendSymbol?d.series:d,X=q.options,K=a.createCheckboxForItem&&X&&X.showCheckbox,Q=C.useHTML,te=d.options.className,ne=d.legendItem,ie=z+L+W+(K?20:0);ne||(d.legendGroup=y.g("legend-item").addClass("highcharts-"+q.type+"-series highcharts-color-"+d.colorIndex+(te?" "+te:"")+(j?" highcharts-series-"+d.index:"")).attr({zIndex:1}).add(a.scrollGroup),d.legendItem=ne=y.text("",U?z+L:-L,a.baseline||0,Q),p.styledMode||ne.css(merge$1k(d.visible?$:N)),ne.attr({align:U?"left":"right",zIndex:2}).add(d.legendGroup),a.baseline||(a.fontMetrics=y.fontMetrics(p.styledMode?12:$.fontSize,ne),a.baseline=a.fontMetrics.f+3+a.itemMarginTop,ne.attr("y",a.baseline),a.symbolHeight=C.symbolHeight||a.fontMetrics.f,C.squareSymbol&&(a.symbolWidth=pick$1r(C.symbolWidth,Math.max(a.symbolHeight,16)),ie=a.symbolWidth+L+W+(K?20:0),U&&ne.attr("x",a.symbolWidth+L))),q.drawLegendSymbol(a,d),a.setItemEvents&&a.setItemEvents(d,ne,Q)),K&&!d.checkbox&&a.createCheckboxForItem&&a.createCheckboxForItem(d),a.colorizeItem(d,d.visible),(p.styledMode||!$.width)&&ne.css({width:(C.itemWidth||a.widthOption||p.spacingBox.width)-ie+"px"}),a.setText(d);var ae=ne.getBBox();d.itemWidth=d.checkboxOffset=C.itemWidth||d.legendItemWidth||ae.width+ie,a.maxItemWidth=Math.max(a.maxItemWidth,d.itemWidth),a.totalItemWidth+=d.itemWidth,a.itemHeight=d.itemHeight=Math.round(d.legendItemHeight||ae.height||a.symbolHeight)},v.prototype.layoutItem=function(d){var a=this.options,p=this.padding,y=a.layout==="horizontal",C=d.itemHeight,P=this.itemMarginBottom,z=this.itemMarginTop,L=y?pick$1r(a.itemDistance,20):0,$=this.maxLegendWidth,N=a.alignColumns&&this.totalItemWidth>$?this.maxItemWidth:d.itemWidth;y&&this.itemX-p+N>$&&(this.itemX=p,this.lastLineHeight&&(this.itemY+=z+this.lastLineHeight+P),this.lastLineHeight=0),this.lastItemY=z+this.itemY+P,this.lastLineHeight=Math.max(C,this.lastLineHeight),d._legendItemPos=[this.itemX,this.itemY],y?this.itemX+=N:(this.itemY+=z+C+P,this.lastLineHeight=C),this.offsetWidth=this.widthOption||Math.max((y?this.itemX-p-(d.checkbox?0:L):N)+p,this.offsetWidth)},v.prototype.getAllItems=function(){var d=[];return this.chart.series.forEach(function(a){var p=a&&a.options;a&&pick$1r(p.showInLegend,defined$M(p.linkedTo)?!1:void 0,!0)&&(d=d.concat(a.legendItems||(p.legendType==="point"?a.data:a)))}),fireEvent$u(this,"afterGetAllItems",{allItems:d}),d},v.prototype.getAlignment=function(){var d=this.options;return this.proximate?d.align.charAt(0)+"tv":d.floating?"":d.align.charAt(0)+d.verticalAlign.charAt(0)+d.layout.charAt(0)},v.prototype.adjustMargins=function(d,a){var p=this.chart,y=this.options,C=this.getAlignment();C&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(P,z){P.test(C)&&!defined$M(d[z])&&(p[marginNames$1[z]]=Math.max(p[marginNames$1[z]],p.legend[(z+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][z]*y[z%2?"x":"y"]+pick$1r(y.margin,12)+a[z]+(p.titleOffset[z]||0)))})},v.prototype.proximatePositions=function(){var d=this.chart,a=[],p=this.options.align==="left";this.allItems.forEach(function(y){var C,P,z=p,L,$;y.yAxis&&(y.xAxis.options.reversed&&(z=!z),y.points&&(C=find$j(z?y.points:y.points.slice(0).reverse(),function(N){return isNumber$I(N.plotY)})),P=this.itemMarginTop+y.legendItem.getBBox().height+this.itemMarginBottom,$=y.yAxis.top-d.plotTop,y.visible?(L=C?C.plotY:y.yAxis.height,L+=$-.3*P):L=$+y.yAxis.height,a.push({target:L,size:P,item:y}))},this),distribute$2(a,d.plotHeight).forEach(function(y){y.item._legendItemPos&&(y.item._legendItemPos[1]=d.plotTop-d.spacing[0]+y.pos)})},v.prototype.render=function(){var d=this,a=d.chart,p=a.renderer,y=d.options,C=d.padding,P=d.getAllItems(),z,L,$,N=d.group,W,U=d.box;d.itemX=C,d.itemY=d.initialItemY,d.offsetWidth=0,d.lastItemY=0,d.widthOption=relativeLength$8(y.width,a.spacingBox.width-C),W=a.spacingBox.width-2*C-y.x,["rm","lm"].indexOf(d.getAlignment().substring(0,2))>-1&&(W/=2),d.maxLegendWidth=d.widthOption||W,N||(d.group=N=p.g("legend").addClass(y.className||"").attr({zIndex:7}).add(),d.contentGroup=p.g().attr({zIndex:1}).add(N),d.scrollGroup=p.g().add(d.contentGroup)),d.renderTitle(),stableSort$5(P,function(j,q){return(j.options&&j.options.legendIndex||0)-(q.options&&q.options.legendIndex||0)}),y.reversed&&P.reverse(),d.allItems=P,d.display=z=!!P.length,d.lastLineHeight=0,d.maxItemWidth=0,d.totalItemWidth=0,d.itemHeight=0,P.forEach(d.renderItem,d),P.forEach(d.layoutItem,d),L=(d.widthOption||d.offsetWidth)+C,$=d.lastItemY+d.lastLineHeight+d.titleHeight,$=d.handleOverflow($),$+=C,U||(d.box=U=p.rect().addClass("highcharts-legend-box").attr({r:y.borderRadius}).add(N),U.isNew=!0),a.styledMode||U.attr({stroke:y.borderColor,"stroke-width":y.borderWidth||0,fill:y.backgroundColor||"none"}).shadow(y.shadow),L>0&&$>0&&(U[U.isNew?"attr":"animate"](U.crisp.call({},{x:0,y:0,width:L,height:$},U.strokeWidth())),U.isNew=!1),U[z?"show":"hide"](),a.styledMode&&N.getStyle("display")==="none"&&(L=$=0),d.legendWidth=L,d.legendHeight=$,z&&d.align(),this.proximate||this.positionItems(),fireEvent$u(this,"afterRender")},v.prototype.align=function(d){d===void 0&&(d=this.chart.spacingBox);var a=this.chart,p=this.options,y=d.y;/(lth|ct|rth)/.test(this.getAlignment())&&a.titleOffset[0]>0?y+=a.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&a.titleOffset[2]>0&&(y-=a.titleOffset[2]),y!==d.y&&(d=merge$1k(d,{y})),this.group.align(merge$1k(p,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":p.verticalAlign}),!0,d)},v.prototype.handleOverflow=function(d){var a=this,p=this.chart,y=p.renderer,C=this.options,P=C.y,z=C.verticalAlign==="top",L=this.padding,$=C.maxHeight,N=C.navigation,W=pick$1r(N.animation,!0),U=N.arrowSize||12,j=this.pages,q=this.allItems,X=function(se){typeof se=="number"?ae.attr({height:se}):ae&&(a.clipRect=ae.destroy(),a.contentGroup.clip()),a.contentGroup.div&&(a.contentGroup.div.style.clip=se?"rect("+L+"px,9999px,"+(L+se)+"px,0)":"auto")},K=function(se){return a[se]=y.circle(0,0,U*1.3).translate(U/2,U/2).add(ie),p.styledMode||a[se].attr("fill","rgba(0,0,0,0.0001)"),a[se]},Q,te,ne=p.spacingBox.height+(z?-P:P)-L,ie=this.nav,ae=this.clipRect;return C.layout==="horizontal"&&C.verticalAlign!=="middle"&&!C.floating&&(ne/=2),$&&(ne=Math.min(ne,$)),j.length=0,d&&ne>0&&d>ne&&N.enabled!==!1?(this.clipHeight=Q=Math.max(ne-20-this.titleHeight-L,0),this.currentPage=pick$1r(this.currentPage,1),this.fullHeight=d,q.forEach(function(se,de){var he=se._legendItemPos[1],ue=Math.round(se.legendItem.getBBox().height),me=j.length;(!me||he-j[me-1]>Q&&(te||he)!==j[me-1])&&(j.push(te||he),me++),se.pageIx=me-1,te&&(q[de-1].pageIx=me-1),de===q.length-1&&he+ue-j[me-1]>Q&&he!==te&&(j.push(he),se.pageIx=me),he!==te&&(te=he)}),ae||(ae=a.clipRect=y.clipRect(0,L,9999,0),a.contentGroup.clip(ae)),X(Q),ie||(this.nav=ie=y.g().attr({zIndex:1}).add(this.group),this.up=y.symbol("triangle",0,0,U,U).add(ie),K("upTracker").on("click",function(){a.scroll(-1,W)}),this.pager=y.text("",15,10).addClass("highcharts-legend-navigation"),p.styledMode||this.pager.css(N.style),this.pager.add(ie),this.down=y.symbol("triangle-down",0,0,U,U).add(ie),K("downTracker").on("click",function(){a.scroll(1,W)})),a.scroll(0),d=ne):ie&&(X(),this.nav=ie.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),d},v.prototype.scroll=function(d,a){var p=this,y=this.chart,C=this.pages,P=C.length,z=this.clipHeight,L=this.options.navigation,$=this.pager,N=this.padding,W=this.currentPage+d;if(W>P&&(W=P),W>0){typeof a<"u"&&setAnimation$4(a,y),this.nav.attr({translateX:N,translateY:z+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(j){j.attr({class:W===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),$.attr({text:W+"/"+P}),[this.down,this.downTracker].forEach(function(j){j.attr({x:18+this.pager.getBBox().width,class:W===P?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),y.styledMode||(this.up.attr({fill:W===1?L.inactiveColor:L.activeColor}),this.upTracker.css({cursor:W===1?"default":"pointer"}),this.down.attr({fill:W===P?L.inactiveColor:L.activeColor}),this.downTracker.css({cursor:W===P?"default":"pointer"})),this.scrollOffset=-C[W-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=W,this.positionCheckboxes();var U=animObject$9(pick$1r(a,y.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$u(p,"afterScroll",{currentPage:W})},U.duration)}},v.prototype.setItemEvents=function(d,a,p){var y=this,C=y.chart.renderer.boxWrapper,P=d instanceof Point$4,z="highcharts-legend-"+(P?"point":"series")+"-active",L=y.chart.styledMode,$=p?[a,d.legendSymbol]:[d.legendGroup],N=function(W){y.allItems.forEach(function(U){d!==U&&[U].concat(U.linkedSeries||[]).forEach(function(j){j.setState(W,!P)})})};$.forEach(function(W){W&&W.on("mouseover",function(){d.visible&&N("inactive"),d.setState("hover"),d.visible&&C.addClass(z),L||a.css(y.options.itemHoverStyle)}).on("mouseout",function(){y.chart.styledMode||a.css(merge$1k(d.visible?y.itemStyle:y.itemHiddenStyle)),N(""),C.removeClass(z),d.setState()}).on("click",function(U){var j="legendItemClick",q=function(){d.setVisible&&d.setVisible(),N(d.visible?"inactive":"")};C.removeClass(z),U={browserEvent:U},d.firePointEvent?d.firePointEvent(j,U,q):fireEvent$u(d,j,U,q)})})},v.prototype.createCheckboxForItem=function(d){var a=this;d.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:d.selected,defaultChecked:d.selected},a.options.itemCheckboxStyle,a.chart.container),addEvent$$(d.checkbox,"click",function(p){var y=p.target;fireEvent$u(d.series||d,"checkboxClick",{checked:y.checked,item:d},function(){d.select()})})},v})();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$h(Legend.prototype,"positionItem",function(v,d){var a=this,p=function(){d._legendItemPos&&v.call(a,d)};p(),a.bubbleLegend||setTimeout(p)});var defaultOptions$f=DefaultOptions.defaultOptions,error$8=Utilities.error,extendClass$1=Utilities.extendClass,merge$1j=Utilities.merge,SeriesRegistry;(function(v){v.seriesTypes=H.seriesTypes;function d(y,C){C===void 0&&(C={});var P=y.options.chart,z=C.type||P.type||P.defaultSeriesType||"",L=v.seriesTypes[z];v||error$8(17,!0,y,{missingModuleFor:z});var $=new L;return typeof $.init=="function"&&$.init(y,C),$}v.getSeries=d;function a(y,C){var P=defaultOptions$f.plotOptions||{},z=C.defaultOptions;C.prototype.pointClass||(C.prototype.pointClass=Point$4),C.prototype.type=y,z&&(P[y]=z),v.seriesTypes[y]=C}v.registerSeriesType=a;function p(y,C,P,z,L){var $=defaultOptions$f.plotOptions||{};return C=C||"",$[y]=merge$1j($[C],P),a(y,extendClass$1(v.seriesTypes[C]||function(){},z)),v.seriesTypes[y].prototype.type=y,L&&(v.seriesTypes[y].prototype.pointClass=extendClass$1(Point$4,L)),v.seriesTypes[y]}v.seriesType=p})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$8=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$4.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$5=H.svg,win$8=H.win,defaultOptions$e=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$8=SeriesRegistry$1.seriesTypes,addEvent$_=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$L=Utilities.defined,discardElement$3=Utilities.discardElement,erase$4=Utilities.erase,error$7=Utilities.error,extend$1l=Utilities.extend,find$i=Utilities.find,fireEvent$t=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isObject$c=Utilities.isObject,isString$6=Utilities.isString,merge$1i=Utilities.merge,objectEach$p=Utilities.objectEach,pick$1q=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$f=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=(function(){function v(d,a,p){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(d,a,p)}return v.chart=function(d,a,p){return new v(d,a,p)},v.prototype.getArgs=function(d,a,p){isString$6(d)||d.nodeName?(this.renderTo=d,this.init(a,p)):this.init(d,a)},v.prototype.init=function(d,a){var p=d.plotOptions||{};fireEvent$t(this,"init",{args:arguments},function(){var y=merge$1i(defaultOptions$e,d),C=y.chart;objectEach$p(y.plotOptions,function(z,L){isObject$c(z)&&(z.tooltip=p[L]&&merge$1i(p[L].tooltip)||void 0)}),y.tooltip.userOptions=d.chart&&d.chart.forExport&&d.tooltip.userOptions||d.tooltip,this.userOptions=d,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=a,this.isResizing=0,this.options=y,this.axes=[],this.series=[],this.time=d.time&&Object.keys(d.time).length?new Time(d.time):H.time,this.numberFormatter=C.numberFormatter||numberFormat$1,this.styledMode=C.styledMode,this.hasCartesianSeries=C.showAxes;var P=this;P.index=charts$1.length,charts$1.push(P),H.chartCount++,registerEventOptions$1(this,C),P.xAxis=[],P.yAxis=[],P.pointCount=P.colorCounter=P.symbolCounter=0,fireEvent$t(P,"afterInit"),P.firstRender()})},v.prototype.initSeries=function(d){var a=this,p=a.options.chart,y=d.type||p.type||p.defaultSeriesType,C=seriesTypes$8[y];C||error$7(17,!0,a,{missingModuleFor:y});var P=new C;return typeof P.init=="function"&&P.init(a,d),P},v.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(d){!d.points&&!d.data&&d.enabledDataSorting&&d.setData(d.options.data,!1)})},v.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(d,a){return d.linkedSeries.length||a.linkedSeries.length?a.linkedSeries.length-d.linkedSeries.length:0})},v.prototype.orderSeries=function(d){for(var a=this.series,p=d||0,y=a.length;p<y;++p)a[p]&&(a[p].index=p,a[p].name=a[p].getName())},v.prototype.isInsidePlot=function(d,a,p){var y;p===void 0&&(p={});var C=this,P=C.inverted,z=C.plotBox,L=C.plotLeft,$=C.plotTop,N=C.scrollablePlotBox,W=0,U=0;p.visiblePlotOnly&&this.scrollingContainer&&(y=this.scrollingContainer,W=y.scrollLeft,U=y.scrollTop);var j=p.series,q=p.visiblePlotOnly&&N||z,X=p.inverted?a:d,K=p.inverted?d:a,Q={x:X,y:K,isInsidePlot:!0};if(!p.ignoreX){var te=j&&(P?j.yAxis:j.xAxis)||{pos:L,len:1/0},ne=p.paneCoordinates?te.pos+X:L+X;ne>=Math.max(W+L,te.pos)&&ne<=Math.min(W+L+q.width,te.pos+te.len)||(Q.isInsidePlot=!1)}if(!p.ignoreY&&Q.isInsidePlot){var ie=j&&(P?j.xAxis:j.yAxis)||{pos:$,len:1/0},ae=p.paneCoordinates?ie.pos+K:$+K;ae>=Math.max(U+$,ie.pos)&&ae<=Math.min(U+$+q.height,ie.pos+ie.len)||(Q.isInsidePlot=!1)}return fireEvent$t(this,"afterIsInsidePlot",Q),Q.isInsidePlot},v.prototype.redraw=function(d){fireEvent$t(this,"beforeRedraw");var a=this,p=a.hasCartesianSeries?a.axes:a.colorAxis||[],y=a.series,C=a.pointer,P=a.legend,z=a.userOptions.legend,L=a.renderer,$=L.isHidden(),N=[],W,U,j,q=a.isDirtyBox,X=a.isDirtyLegend,K;for(a.setResponsive&&a.setResponsive(!1),setAnimation$3(a.hasRendered?d:!1,a),$&&a.temporaryDisplay(),a.layOutTitles(),j=y.length;j--;)if(K=y[j],(K.options.stacking||K.options.centerInCategory)&&(U=!0,K.isDirty)){W=!0;break}if(W)for(j=y.length;j--;)K=y[j],K.options.stacking&&(K.isDirty=!0);y.forEach(function(Q){Q.isDirty&&(Q.options.legendType==="point"?(typeof Q.updateTotals=="function"&&Q.updateTotals(),X=!0):z&&(z.labelFormatter||z.labelFormat)&&(X=!0)),Q.isDirtyData&&fireEvent$t(Q,"updatedData")}),X&&P&&P.options.enabled&&(P.render(),a.isDirtyLegend=!1),U&&a.getStacks(),p.forEach(function(Q){Q.updateNames(),Q.setScale()}),a.getMargins(),p.forEach(function(Q){Q.isDirty&&(q=!0)}),p.forEach(function(Q){var te=Q.min+","+Q.max;Q.extKey!==te&&(Q.extKey=te,N.push(function(){fireEvent$t(Q,"afterSetExtremes",extend$1l(Q.eventArgs,Q.getExtremes())),delete Q.eventArgs})),(q||U)&&Q.redraw()}),q&&a.drawChartBox(),fireEvent$t(a,"predraw"),y.forEach(function(Q){(q||Q.isDirty)&&Q.visible&&Q.redraw(),Q.isDirtyData=!1}),C&&C.reset(!0),L.draw(),fireEvent$t(a,"redraw"),fireEvent$t(a,"render"),$&&a.temporaryDisplay(!0),N.forEach(function(Q){Q.call()})},v.prototype.get=function(d){var a=this.series;function p(P){return P.id===d||P.options&&P.options.id===d}for(var y=find$i(this.axes,p)||find$i(this.series,p),C=0;!y&&C<a.length;C++)y=find$i(a[C].points||[],p);return y},v.prototype.getAxes=function(){var d=this,a=this.options,p=a.xAxis=splat$f(a.xAxis||{}),y=a.yAxis=splat$f(a.yAxis||{});fireEvent$t(this,"getAxes"),p.forEach(function(P,z){P.index=z,P.isX=!0}),y.forEach(function(P,z){P.index=z});var C=p.concat(y);C.forEach(function(P){new Axis(d,P)}),fireEvent$t(this,"afterGetAxes")},v.prototype.getSelectedPoints=function(){return this.series.reduce(function(d,a){return a.getPointsCollection().forEach(function(p){pick$1q(p.selectedStaging,p.selected)&&d.push(p)}),d},[])},v.prototype.getSelectedSeries=function(){return this.series.filter(function(d){return d.selected})},v.prototype.setTitle=function(d,a,p){this.applyDescription("title",d),this.applyDescription("subtitle",a),this.applyDescription("caption",void 0),this.layOutTitles(p)},v.prototype.applyDescription=function(d,a){var p=this,y=d==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},C=this.options[d]=merge$1i(!this.styledMode&&{style:y},this.options[d],a),P=this[d];P&&a&&(this[d]=P=P.destroy()),C&&!P&&(P=this.renderer.text(C.text,0,0,C.useHTML).attr({align:C.align,class:"highcharts-"+d,zIndex:C.zIndex||4}).add(),P.update=function(z){var L={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[d];p[L](z)},this.styledMode||P.css(C.style),this[d]=P)},v.prototype.layOutTitles=function(d){var a=[0,0,0],p=this.renderer,y=this.spacingBox;["title","subtitle","caption"].forEach(function(P){var z=this[P],L=this.options[P],$=L.verticalAlign||"top",N=P==="title"?$==="top"?-3:0:$==="top"?a[0]+2:0,W,U;z&&(this.styledMode||(W=L.style&&L.style.fontSize),W=p.fontMetrics(W,z).b,z.css({width:(L.width||y.width+(L.widthAdjust||0))+"px"}),U=Math.round(z.getBBox(L.useHTML).height),z.align(extend$1l({y:$==="bottom"?W:N+W,height:U},L),!1,"spacingBox"),L.floating||($==="top"?a[0]=Math.ceil(a[0]+U):$==="bottom"&&(a[2]=Math.ceil(a[2]+U))))},this),a[0]&&(this.options.title.verticalAlign||"top")==="top"&&(a[0]+=this.options.title.margin),a[2]&&this.options.caption.verticalAlign==="bottom"&&(a[2]+=this.options.caption.margin);var C=!this.titleOffset||this.titleOffset.join(",")!==a.join(",");this.titleOffset=a,fireEvent$t(this,"afterLayOutTitles"),!this.isDirtyBox&&C&&(this.isDirtyBox=this.isDirtyLegend=C,this.hasRendered&&pick$1q(d,!0)&&this.isDirtyBox&&this.redraw())},v.prototype.getChartSize=function(){var d=this,a=d.options.chart,p=a.width,y=a.height,C=d.renderTo;defined$L(p)||(d.containerWidth=getStyle(C,"width")),defined$L(y)||(d.containerHeight=getStyle(C,"height")),d.chartWidth=Math.max(0,p||d.containerWidth||600),d.chartHeight=Math.max(0,relativeLength$7(y,d.chartWidth)||(d.containerHeight>1?d.containerHeight:400))},v.prototype.temporaryDisplay=function(d){var a=this.renderTo,p;if(d)for(;a&&a.style;)a.hcOrigStyle&&(css$5(a,a.hcOrigStyle),delete a.hcOrigStyle),a.hcOrigDetached&&(doc$g.body.removeChild(a),a.hcOrigDetached=!1),a=a.parentNode;else for(;a&&a.style&&(!doc$g.body.contains(a)&&!a.parentNode&&(a.hcOrigDetached=!0,doc$g.body.appendChild(a)),(getStyle(a,"display",!1)==="none"||a.hcOricDetached)&&(a.hcOrigStyle={display:a.style.display,height:a.style.height,overflow:a.style.overflow},p={display:"block",overflow:"hidden"},a!==this.renderTo&&(p.height=0),css$5(a,p),a.offsetWidth||a.style.setProperty("display","block","important")),a=a.parentNode,a!==doc$g.body););},v.prototype.setClassName=function(d){this.container.className="highcharts-container "+(d||"")},v.prototype.getContainer=function(){var d=this,a=d.options,p=a.chart,y="data-highcharts-chart",C=uniqueKey$4(),P,z=d.renderTo;z||(d.renderTo=z=p.renderTo),isString$6(z)&&(d.renderTo=z=doc$g.getElementById(z)),z||error$7(13,!0,d);var L=pInt$4(attr$1(z,y));isNumber$H(L)&&charts$1[L]&&charts$1[L].hasRendered&&charts$1[L].destroy(),attr$1(z,y,d.index),z.innerHTML="",!p.skipClone&&!z.offsetWidth&&d.temporaryDisplay(),d.getChartSize();var $=d.chartWidth,N=d.chartHeight;css$5(z,{overflow:"hidden"}),d.styledMode||(P=extend$1l({position:"relative",overflow:"hidden",width:$+"px",height:N+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},p.style||{}));var W=createElement$5("div",{id:C},P,z);d.container=W,d._cursor=W.style.cursor;var U=p.renderer||!svg$5?RendererRegistry$1.getRendererType(p.renderer):SVGRenderer;if(d.renderer=new U(W,$,N,void 0,p.forExport,a.exporting&&a.exporting.allowHTML,d.styledMode),setAnimation$3(void 0,d),d.setClassName(p.className),!d.styledMode)d.renderer.setStyle(p.style);else for(var j in a.defs)this.renderer.definition(a.defs[j]);d.renderer.chartIndex=d.index,fireEvent$t(this,"afterGetContainer")},v.prototype.getMargins=function(d){var a=this,p=a.spacing,y=a.margin,C=a.titleOffset;this.resetMargins(),C[0]&&!defined$L(y[0])&&(this.plotTop=Math.max(this.plotTop,C[0]+p[0])),C[2]&&!defined$L(y[2])&&(this.marginBottom=Math.max(this.marginBottom,C[2]+p[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(y,p),fireEvent$t(this,"getMargins"),d||this.getAxisMargins()},v.prototype.getAxisMargins=function(){var d=this,a=d.axisOffset=[0,0,0,0],p=d.colorAxis,y=d.margin,C=function(P){P.forEach(function(z){z.visible&&z.getOffset()})};d.hasCartesianSeries?C(d.axes):p&&p.length&&C(p),marginNames.forEach(function(P,z){defined$L(y[z])||(d[P]+=a[z])}),d.setChartSize()},v.prototype.reflow=function(d){var a=this,p=a.options.chart,y=a.renderTo,C=defined$L(p.width)&&defined$L(p.height),P=p.width||getStyle(y,"width"),z=p.height||getStyle(y,"height"),L=d?d.target:win$8;delete a.pointer.chartPosition,!C&&!a.isPrinting&&P&&z&&(L===win$8||L===doc$g)&&((P!==a.containerWidth||z!==a.containerHeight)&&(Utilities.clearTimeout(a.reflowTimeout),a.reflowTimeout=syncTimeout$3(function(){a.container&&a.setSize(void 0,void 0,!1)},d?100:0)),a.containerWidth=P,a.containerHeight=z)},v.prototype.setReflow=function(d){var a=this;d!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$_(win$8,"resize",function(p){a.options&&a.reflow(p)}),addEvent$_(this,"destroy",this.unbindReflow)):d===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},v.prototype.setSize=function(d,a,p){var y=this,C=y.renderer;y.isResizing+=1,setAnimation$3(p,y);var P=C.globalAnimation;y.oldChartHeight=y.chartHeight,y.oldChartWidth=y.chartWidth,typeof d<"u"&&(y.options.chart.width=d),typeof a<"u"&&(y.options.chart.height=a),y.getChartSize(),y.styledMode||(P?animate:css$5)(y.container,{width:y.chartWidth+"px",height:y.chartHeight+"px"},P),y.setChartSize(!0),C.setSize(y.chartWidth,y.chartHeight,P),y.axes.forEach(function(z){z.isDirty=!0,z.setScale()}),y.isDirtyLegend=!0,y.isDirtyBox=!0,y.layOutTitles(),y.getMargins(),y.redraw(P),y.oldChartHeight=null,fireEvent$t(y,"resize"),syncTimeout$3(function(){y&&fireEvent$t(y,"endResize",null,function(){y.isResizing-=1})},animObject$8(P).duration)},v.prototype.setChartSize=function(d){var a=this,p=a.inverted,y=a.renderer,C=a.chartWidth,P=a.chartHeight,z=a.options.chart,L=a.spacing,$=a.clipOffset,N,W,U,j;a.plotLeft=N=Math.round(a.plotLeft),a.plotTop=W=Math.round(a.plotTop),a.plotWidth=U=Math.max(0,Math.round(C-N-a.marginRight)),a.plotHeight=j=Math.max(0,Math.round(P-W-a.marginBottom)),a.plotSizeX=p?j:U,a.plotSizeY=p?U:j,a.plotBorderWidth=z.plotBorderWidth||0,a.spacingBox=y.spacingBox={x:L[3],y:L[0],width:C-L[3]-L[1],height:P-L[0]-L[2]},a.plotBox=y.plotBox={x:N,y:W,width:U,height:j};var q=2*Math.floor(a.plotBorderWidth/2),X=Math.ceil(Math.max(q,$[3])/2),K=Math.ceil(Math.max(q,$[0])/2);a.clipBox={x:X,y:K,width:Math.floor(a.plotSizeX-Math.max(q,$[1])/2-X),height:Math.max(0,Math.floor(a.plotSizeY-Math.max(q,$[2])/2-K))},d||(a.axes.forEach(function(Q){Q.setAxisSize(),Q.setAxisTranslation()}),y.alignElements()),fireEvent$t(a,"afterSetChartSize",{skipAxes:d})},v.prototype.resetMargins=function(){fireEvent$t(this,"resetMargins");var d=this,a=d.options.chart;["margin","spacing"].forEach(function(y){var C=a[y],P=isObject$c(C)?C:[C,C,C,C];["Top","Right","Bottom","Left"].forEach(function(z,L){d[y][L]=pick$1q(a[y+z],P[L])})}),marginNames.forEach(function(p,y){d[p]=pick$1q(d.margin[y],d.spacing[y])}),d.axisOffset=[0,0,0,0],d.clipOffset=[0,0,0,0]},v.prototype.drawChartBox=function(){var d=this,a=d.options.chart,p=d.renderer,y=d.chartWidth,C=d.chartHeight,P=d.styledMode,z=d.plotBGImage,L=a.backgroundColor,$=a.plotBackgroundColor,N=a.plotBackgroundImage,W=d.plotLeft,U=d.plotTop,j=d.plotWidth,q=d.plotHeight,X=d.plotBox,K=d.clipRect,Q=d.clipBox,te=d.chartBackground,ne=d.plotBackground,ie=d.plotBorder,ae,se,de,he="animate";te||(d.chartBackground=te=p.rect().addClass("highcharts-background").add(),he="attr"),P?ae=se=te.strokeWidth():(ae=a.borderWidth||0,se=ae+(a.shadow?8:0),de={fill:L||"none"},(ae||te["stroke-width"])&&(de.stroke=a.borderColor,de["stroke-width"]=ae),te.attr(de).shadow(a.shadow)),te[he]({x:se/2,y:se/2,width:y-se-ae%2,height:C-se-ae%2,r:a.borderRadius}),he="animate",ne||(he="attr",d.plotBackground=ne=p.rect().addClass("highcharts-plot-background").add()),ne[he](X),P||(ne.attr({fill:$||"none"}).shadow(a.plotShadow),N&&(z?(N!==z.attr("href")&&z.attr("href",N),z.animate(X)):d.plotBGImage=p.image(N,W,U,j,q).add())),K?K.animate({width:Q.width,height:Q.height}):d.clipRect=p.clipRect(Q),he="animate",ie||(he="attr",d.plotBorder=ie=p.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),P||ie.attr({stroke:a.plotBorderColor,"stroke-width":a.plotBorderWidth||0,fill:"none"}),ie[he](ie.crisp({x:W,y:U,width:j,height:q},-ie.strokeWidth())),d.isDirtyBox=!1,fireEvent$t(this,"afterDrawChartBox")},v.prototype.propFromSeries=function(){var d=this,a=d.options.chart,p=d.options.series,y,C,P;["inverted","angular","polar"].forEach(function(z){for(C=seriesTypes$8[a.type||a.defaultSeriesType],P=a[z]||C&&C.prototype[z],y=p&&p.length;!P&&y--;)C=seriesTypes$8[p[y].type],C&&C.prototype[z]&&(P=!0);d[z]=P})},v.prototype.linkSeries=function(){var d=this,a=d.series;a.forEach(function(p){p.linkedSeries.length=0}),a.forEach(function(p){var y=p.options.linkedTo;isString$6(y)&&(y===":previous"?y=d.series[p.index-1]:y=d.get(y),y&&y.linkedParent!==p&&(y.linkedSeries.push(p),p.linkedParent=y,y.enabledDataSorting&&p.setDataSortingOptions(),p.visible=pick$1q(p.options.visible,y.options.visible,p.visible)))}),fireEvent$t(this,"afterLinkSeries")},v.prototype.renderSeries=function(){this.series.forEach(function(d){d.translate(),d.render()})},v.prototype.renderLabels=function(){var d=this,a=d.options.labels;a.items&&a.items.forEach(function(p){var y=extend$1l(a.style,p.style),C=pInt$4(y.left)+d.plotLeft,P=pInt$4(y.top)+d.plotTop+12;delete y.left,delete y.top,d.renderer.text(p.html,C,P).attr({zIndex:2}).css(y).add()})},v.prototype.render=function(){var d=this,a=d.axes,p=d.colorAxis,y=d.renderer,C=d.options,P=function(U){U.forEach(function(j){j.visible&&j.render()})},z=0;d.setTitle(),d.legend=new Legend(d,C.legend),d.getStacks&&d.getStacks(),d.getMargins(!0),d.setChartSize();var L=d.plotWidth;a.some(function(U){if(U.horiz&&U.visible&&U.options.labels.enabled&&U.series.length)return z=21,!0}),d.plotHeight=Math.max(d.plotHeight-z,0);var $=d.plotHeight;a.forEach(function(U){U.setScale()}),d.getAxisMargins();var N=L/d.plotWidth>1.1,W=$/d.plotHeight>1.05;(N||W)&&(a.forEach(function(U){(U.horiz&&N||!U.horiz&&W)&&U.setTickInterval(!0)}),d.getMargins()),d.drawChartBox(),d.hasCartesianSeries?P(a):p&&p.length&&P(p),d.seriesGroup||(d.seriesGroup=y.g("series-group").attr({zIndex:3}).add()),d.renderSeries(),d.renderLabels(),d.addCredits(),d.setResponsive&&d.setResponsive(),d.hasRendered=!0},v.prototype.addCredits=function(d){var a=this,p=merge$1i(!0,this.options.credits,d);p.enabled&&!this.credits&&(this.credits=this.renderer.text(p.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){p.href&&(win$8.location.href=p.href)}).attr({align:p.position.align,zIndex:8}),a.styledMode||this.credits.css(p.style),this.credits.add().align(p.position),this.credits.update=function(y){a.credits=a.credits.destroy(),a.addCredits(y)})},v.prototype.destroy=function(){var d=this,a=d.axes,p=d.series,y=d.container,C=y&&y.parentNode,P;for(fireEvent$t(d,"destroy"),d.renderer.forExport?erase$4(charts$1,d):charts$1[d.index]=void 0,H.chartCount--,d.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(d),P=a.length;P--;)a[P]=a[P].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),P=p.length;P--;)p[P]=p[P].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(z){var L=d[z];L&&L.destroy&&(d[z]=L.destroy())}),y&&(y.innerHTML="",removeEvent$6(y),C&&discardElement$3(y)),objectEach$p(d,function(z,L){delete d[L]})},v.prototype.firstRender=function(){var d=this,a=d.options;d.isReadyToRender&&!d.isReadyToRender()||(d.getContainer(),d.resetMargins(),d.setChartSize(),d.propFromSeries(),d.getAxes(),(isArray$j(a.series)?a.series:[]).forEach(function(p){d.initSeries(p)}),d.linkSeries(),d.setSeriesData(),fireEvent$t(d,"beforeRender"),Pointer&&(MSPointer.isRequired()?d.pointer=new MSPointer(d,a):d.pointer=new Pointer(d,a)),d.render(),d.pointer.getChartPosition(),!d.renderer.imgCount&&!d.hasLoaded&&d.onload(),d.temporaryDisplay(!0))},v.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(d){d&&typeof this.index<"u"&&d.apply(this,[this])},this),fireEvent$t(this,"load"),fireEvent$t(this,"render"),defined$L(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},v.prototype.addSeries=function(d,a,p){var y=this,C;return d&&(a=pick$1q(a,!0),fireEvent$t(y,"addSeries",{options:d},function(){C=y.initSeries(d),y.isDirtyLegend=!0,y.linkSeries(),C.enabledDataSorting&&C.setData(d.data,!1),fireEvent$t(y,"afterAddSeries",{series:C}),a&&y.redraw(p)})),C},v.prototype.addAxis=function(d,a,p,y){return this.createAxis(a?"xAxis":"yAxis",{axis:d,redraw:p,animation:y})},v.prototype.addColorAxis=function(d,a,p){return this.createAxis("colorAxis",{axis:d,redraw:a,animation:p})},v.prototype.createAxis=function(d,a){var p=new Axis(this,merge$1i(a.axis,{index:this[d].length,isX:d==="xAxis"}));return pick$1q(a.redraw,!0)&&this.redraw(a.animation),p},v.prototype.showLoading=function(d){var a=this,p=a.options,y=p.loading,C=function(){P&&css$5(P,{left:a.plotLeft+"px",top:a.plotTop+"px",width:a.plotWidth+"px",height:a.plotHeight+"px"})},P=a.loadingDiv,z=a.loadingSpan;P||(a.loadingDiv=P=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,a.container)),z||(a.loadingSpan=z=createElement$5("span",{className:"highcharts-loading-inner"},null,P),addEvent$_(a,"redraw",C)),P.className="highcharts-loading",AST.setElementHTML(z,pick$1q(d,p.lang.loading,"")),a.styledMode||(css$5(P,extend$1l(y.style,{zIndex:10})),css$5(z,y.labelStyle),a.loadingShown||(css$5(P,{opacity:0,display:""}),animate(P,{opacity:y.style.opacity||.5},{duration:y.showDuration||0}))),a.loadingShown=!0,C()},v.prototype.hideLoading=function(){var d=this.options,a=this.loadingDiv;a&&(a.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(a,{opacity:0},{duration:d.loading.hideDuration||100,complete:function(){css$5(a,{display:"none"})}})),this.loadingShown=!1},v.prototype.update=function(d,a,p,y){var C=this,P={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},z=d.isResponsiveOptions,L=[],$,N,W;fireEvent$t(C,"update",{options:d}),z||C.setResponsive(!1,!0),d=cleanRecursively$1(d,C.options),C.userOptions=merge$1i(C.userOptions,d);var U=d.chart;U&&(merge$1i(!0,C.options.chart,U),"className"in U&&C.setClassName(U.className),"reflow"in U&&C.setReflow(U.reflow),("inverted"in U||"polar"in U||"type"in U)&&(C.propFromSeries(),$=!0),"alignTicks"in U&&($=!0),"events"in U&&registerEventOptions$1(this,U),objectEach$p(U,function(X,K){C.propsRequireUpdateSeries.indexOf("chart."+K)!==-1&&(N=!0),C.propsRequireDirtyBox.indexOf(K)!==-1&&(C.isDirtyBox=!0),C.propsRequireReflow.indexOf(K)!==-1&&(z?C.isDirtyBox=!0:W=!0)}),!C.styledMode&&U.style&&C.renderer.setStyle(C.options.chart.style||{})),!C.styledMode&&d.colors&&(this.options.colors=d.colors),d.time&&(this.time===defaultTime&&(this.time=new Time(d.time)),merge$1i(!0,C.options.time,d.time)),objectEach$p(d,function(X,K){C[K]&&typeof C[K].update=="function"?C[K].update(X,!1):typeof C[P[K]]=="function"?C[P[K]](X):K!=="colors"&&C.collectionsWithUpdate.indexOf(K)===-1&&merge$1i(!0,C.options[K],d[K]),K!=="chart"&&C.propsRequireUpdateSeries.indexOf(K)!==-1&&(N=!0)}),this.collectionsWithUpdate.forEach(function(X){var K;d[X]&&(K=[],C[X].forEach(function(Q,te){Q.options.isInternal||K.push(pick$1q(Q.options.index,te))}),splat$f(d[X]).forEach(function(Q,te){var ne=defined$L(Q.id),ie;ne&&(ie=C.get(Q.id)),!ie&&C[X]&&(ie=C[X][K?K[te]:te],ie&&ne&&defined$L(ie.options.id)&&(ie=void 0)),ie&&ie.coll===X&&(ie.update(Q,!1),p&&(ie.touched=!0)),!ie&&p&&C.collectionsWithInit[X]&&(C.collectionsWithInit[X][0].apply(C,[Q].concat(C.collectionsWithInit[X][1]||[]).concat([!1])).touched=!0)}),p&&C[X].forEach(function(Q){!Q.touched&&!Q.options.isInternal?L.push(Q):delete Q.touched}))}),L.forEach(function(X){X.chart&&X.remove&&X.remove(!1)}),$&&C.axes.forEach(function(X){X.update({},!1)}),N&&C.getSeriesOrderByLinks().forEach(function(X){X.chart&&X.update({},!1)},this);var j=U&&U.width,q=U&&(isString$6(U.height)?relativeLength$7(U.height,j||C.chartWidth):U.height);W||isNumber$H(j)&&j!==C.chartWidth||isNumber$H(q)&&q!==C.chartHeight?C.setSize(j,q,y):pick$1q(a,!0)&&C.redraw(y),fireEvent$t(C,"afterUpdate",{options:d,redraw:a,animation:y})},v.prototype.setSubtitle=function(d,a){this.applyDescription("subtitle",d),this.layOutTitles(a)},v.prototype.setCaption=function(d,a){this.applyDescription("caption",d),this.layOutTitles(a)},v.prototype.showResetZoom=function(){var d=this,a=defaultOptions$e.lang,p=d.options.chart.resetZoomButton,y=p.theme,C=y.states,P=p.relativeTo==="chart"||p.relativeTo==="spacingBox"?null:"scrollablePlotBox";function z(){d.zoomOut()}fireEvent$t(this,"beforeShowResetZoom",null,function(){d.resetZoomButton=d.renderer.button(a.resetZoom,null,null,z,y,C&&C.hover).attr({align:p.position.align,title:a.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(p.position,!1,P)}),fireEvent$t(this,"afterShowResetZoom")},v.prototype.zoomOut=function(){fireEvent$t(this,"selection",{resetSelection:!0},this.zoom)},v.prototype.zoom=function(d){var a=this,p=a.pointer,y=a.inverted?p.mouseDownX:p.mouseDownY,C=!1,P;!d||d.resetSelection?(a.axes.forEach(function(L){P=L.zoom()}),p.initiated=!1):d.xAxis.concat(d.yAxis).forEach(function(L){var $=L.axis,N=a.inverted?$.left:$.top,W=a.inverted?N+$.width:N+$.height,U=$.isXAxis,j=!1;(!U&&y>=N&&y<=W||U||!defined$L(y))&&(j=!0),p[U?"zoomX":"zoomY"]&&j&&(P=$.zoom(L.min,L.max),$.displayBtn&&(C=!0))});var z=a.resetZoomButton;C&&!z?a.showResetZoom():!C&&isObject$c(z)&&(a.resetZoomButton=z.destroy()),P&&a.redraw(pick$1q(a.options.chart.animation,d&&d.animation,a.pointCount<100))},v.prototype.pan=function(d,a){var p=this,y=p.hoverPoints,C=typeof a=="object"?a:{enabled:a,type:"x"},P=p.options.chart,z=p.options.mapNavigation&&p.options.mapNavigation.enabled;P&&P.panning&&(P.panning=C);var L=C.type,$;fireEvent$t(this,"pan",{originalEvent:d},function(){y&&y.forEach(function(U){U.setState()});var N=p.xAxis;L==="xy"?N=N.concat(p.yAxis):L==="y"&&(N=p.yAxis);var W={};N.forEach(function(U){if(!(!U.options.panningEnabled||U.options.isInternal)){var j=U.horiz,q=d[j?"chartX":"chartY"],X=j?"mouseDownX":"mouseDownY",K=p[X],Q=U.minPointOffset||0,te=U.reversed&&!p.inverted||!U.reversed&&p.inverted?-1:1,ne=U.getExtremes(),ie=U.toValue(K-q,!0)+Q*te,ae=U.toValue(K+U.len-q,!0)-(Q*te||U.isXAxis&&U.pointRangePadding||0),se=ae<ie,de=U.hasVerticalPanning(),he=se?ae:ie,ue=se?ie:ae,me=U.panningState,xe;de&&!U.isXAxis&&(!me||me.isDirty)&&U.series.forEach(function(Oe){var be=Oe.getProcessedData(!0),ke=Oe.getExtremes(be.yData,!0);me||(me={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$H(ke.dataMin)&&isNumber$H(ke.dataMax)&&(me.startMin=Math.min(pick$1q(Oe.options.threshold,1/0),ke.dataMin,me.startMin),me.startMax=Math.max(pick$1q(Oe.options.threshold,-1/0),ke.dataMax,me.startMax))});var we=Math.min(pick$1q(me&&me.startMin,ne.dataMin),Q?ne.min:U.toValue(U.toPixels(ne.min)-U.minPixelPadding)),ye=Math.max(pick$1q(me&&me.startMax,ne.dataMax),Q?ne.max:U.toValue(U.toPixels(ne.max)+U.minPixelPadding));U.panningState=me,U.isOrdinal||(xe=we-he,xe>0&&(ue+=xe,he=we),xe=ue-ye,xe>0&&(ue=ye,he-=xe),U.series.length&&he!==ne.min&&ue!==ne.max&&he>=we&&ue<=ye&&(U.setExtremes(he,ue,!1,!1,{trigger:"pan"}),!p.resetZoomButton&&!z&&he!==we&&ue!==ye&&L.match("y")&&(p.showResetZoom(),U.displayBtn=!1),$=!0),W[X]=q)}}),objectEach$p(W,function(U,j){p[j]=U}),$&&p.redraw(!1),css$5(p.container,{cursor:"move"})})},v})();extend$1l(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$1h=Utilities.merge,pick$1p=Utilities.pick,LegendSymbol;(function(v){function d(p){var y=this.options,C=p.symbolWidth,P=p.symbolHeight,z=P/2,L=this.chart.renderer,$=this.legendGroup,N=p.baseline-Math.round(p.fontMetrics.b*.3),W={},U,j=y.marker;if(this.chart.styledMode||(W={"stroke-width":y.lineWidth||0},y.dashStyle&&(W.dashstyle=y.dashStyle)),this.legendLine=L.path([["M",0,N],["L",C,N]]).addClass("highcharts-graph").attr(W).add($),j&&j.enabled!==!1&&C){var q=Math.min(pick$1p(j.radius,z),z);this.symbol.indexOf("url")===0&&(j=merge$1h(j,{width:P,height:P}),q=0),this.legendSymbol=U=L.symbol(this.symbol,C/2-q,N-q,2*q,2*q,j).addClass("highcharts-point").add($),U.isMarker=!0}}v.drawLineMarker=d;function a(p,y){var C=p.options,P=p.symbolHeight,z=C.squareSymbol,L=z?P:p.symbolWidth;y.legendSymbol=this.chart.renderer.rect(z?(p.symbolWidth-P)/2:0,p.baseline-P+1,L,P,pick$1p(p.options.symbolRadius,P/2)).addClass("highcharts-point").attr({zIndex:3}).add(y.legendGroup)}v.drawRectangle=a})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var v=this.series.chart.numberFormatter;return typeof this.y!="number"?"":v(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$7=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions=exports$4.registerEventOptions,hasTouch$2=H.hasTouch,svg$4=H.svg,win$7=H.win,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$Z=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$g=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$K=Utilities.defined,erase$3=Utilities.erase,error$6=Utilities.error,extend$1k=Utilities.extend,find$h=Utilities.find,fireEvent$s=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$i=Utilities.isArray,isNumber$G=Utilities.isNumber,isString$5=Utilities.isString,merge$1g=Utilities.merge,objectEach$o=Utilities.objectEach,pick$1o=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$e=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$f=(function(){function v(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return v.prototype.init=function(d,a){fireEvent$s(this,"init",{options:a});var p=this,y=d.series;this.eventsToUnbind=[],p.chart=d,p.options=p.setOptions(a);var C=p.options;p.linkedSeries=[],p.bindAxes(),extend$1k(p,{name:C.name,state:"",visible:C.visible!==!1,selected:C.selected===!0}),registerEventOptions(this,C);var P=C.events;(P&&P.click||C.point&&C.point.events&&C.point.events.click||C.allowPointSelect)&&(d.runTrackerClick=!0),p.getColor(),p.getSymbol(),p.parallelArrays.forEach(function(L){p[L+"Data"]||(p[L+"Data"]=[])}),p.isCartesian&&(d.hasCartesianSeries=!0);var z;y.length&&(z=y[y.length-1]),p._i=pick$1o(z&&z._i,-1)+1,p.opacity=p.options.opacity,d.orderSeries(this.insert(y)),C.dataSorting&&C.dataSorting.enabled?p.setDataSortingOptions():!p.points&&!p.data&&p.setData(C.data,!1),fireEvent$s(this,"afterInit")},v.prototype.is=function(d){return seriesTypes$7[d]&&this instanceof seriesTypes$7[d]},v.prototype.insert=function(d){var a=this.options.index,p;if(isNumber$G(a)){for(p=d.length;p--;)if(a>=pick$1o(d[p].options.index,d[p]._i)){d.splice(p+1,0,this);break}p===-1&&d.unshift(this),p=p+1}else d.push(this);return pick$1o(p,d.length-1)},v.prototype.bindAxes=function(){var d=this,a=d.options,p=d.chart,y;fireEvent$s(this,"bindAxes",null,function(){(d.axisTypes||[]).forEach(function(C){var P=0;p[C].forEach(function(z){y=z.options,(a[C]===P&&!y.isInternal||typeof a[C]<"u"&&a[C]===y.id||typeof a[C]>"u"&&y.index===0)&&(d.insert(z.series),d[C]=z,z.isDirty=!0),y.isInternal||P++}),!d[C]&&d.optionalAxis!==C&&error$6(18,!0,p)})}),fireEvent$s(this,"afterBindAxes")},v.prototype.updateParallelArrays=function(d,a){var p=d.series,y=arguments,C=isNumber$G(a)?function(P){var z=P==="y"&&p.toYData?p.toYData(d):d[P];p[P+"Data"][a]=z}:function(P){Array.prototype[a].apply(p[P+"Data"],Array.prototype.slice.call(y,2))};p.parallelArrays.forEach(C)},v.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},v.prototype.autoIncrement=function(d){var a=this.options,p=a.pointIntervalUnit,y=a.relativeXValue,C=this.chart.time,P=this.xIncrement,z,L;return P=pick$1o(P,a.pointStart,0),this.pointInterval=L=pick$1o(this.pointInterval,a.pointInterval,1),y&&isNumber$G(d)&&(L*=d),p&&(z=new C.Date(P),p==="day"?C.set("Date",z,C.get("Date",z)+L):p==="month"?C.set("Month",z,C.get("Month",z)+L):p==="year"&&C.set("FullYear",z,C.get("FullYear",z)+L),L=z.getTime()-P),y&&isNumber$G(d)?P+L:(this.xIncrement=P+L,P)},v.prototype.setDataSortingOptions=function(){var d=this.options;extend$1k(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$K(d.pointRange)||(d.pointRange=1)},v.prototype.setOptions=function(d){var a=this.chart,p=a.options,y=p.plotOptions,C=a.userOptions||{},P=merge$1g(d),z=a.styledMode,L={plotOptions:y,userOptions:P},$;fireEvent$s(this,"setOptions",L);var N=L.plotOptions[this.type],W=C.plotOptions||{};this.userOptions=L.userOptions;var U=merge$1g(N,y.series,C.plotOptions&&C.plotOptions[this.type],P);this.tooltipOptions=merge$1g(defaultOptions$d.tooltip,defaultOptions$d.plotOptions.series&&defaultOptions$d.plotOptions.series.tooltip,defaultOptions$d.plotOptions[this.type].tooltip,p.tooltip.userOptions,y.series&&y.series.tooltip,y[this.type].tooltip,P.tooltip),this.stickyTracking=pick$1o(P.stickyTracking,W[this.type]&&W[this.type].stickyTracking,W.series&&W.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:U.stickyTracking),N.marker===null&&delete U.marker,this.zoneAxis=U.zoneAxis;var j=this.zones=(U.zones||[]).slice();return(U.negativeColor||U.negativeFillColor)&&!U.zones&&($={value:U[this.zoneAxis+"Threshold"]||U.threshold||0,className:"highcharts-negative"},z||($.color=U.negativeColor,$.fillColor=U.negativeFillColor),j.push($)),j.length&&defined$K(j[j.length-1].value)&&j.push(z?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$s(this,"afterSetOptions",{options:U}),U},v.prototype.getName=function(){return pick$1o(this.options.name,"Series "+(this.index+1))},v.prototype.getCyclic=function(d,a,p){var y=this.chart,C=this.userOptions,P=d+"Index",z=d+"Counter",L=p?p.length:pick$1o(y.options.chart[d+"Count"],y[d+"Count"]),$,N;a||(N=pick$1o(C[P],C["_"+P]),defined$K(N)?$=N:(y.series.length||(y[z]=0),C["_"+P]=$=y[z]%L,y[z]+=1),p&&(a=p[$])),typeof $<"u"&&(this[P]=$),this[d]=a},v.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$d.plotOptions[this.type].color,this.chart.options.colors)},v.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},v.prototype.getSymbol=function(){var d=this.options.marker;this.getCyclic("symbol",d.symbol,this.chart.options.symbols)},v.prototype.findPointIndex=function(d,a){var p=d.id,y=d.x,C=this.points,P=this.options.dataSorting,z,L,$;if(p){var N=this.chart.get(p);N instanceof Point$4&&(z=N)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var W=function(U){return!U.touched&&U.index===d.index};if(P&&P.matchByName?W=function(U){return!U.touched&&U.name===d.name}:this.options.relativeXValue&&(W=function(U){return!U.touched&&U.options.x===d.x}),z=find$h(C,W),!z)return}return z&&($=z&&z.index,typeof $<"u"&&(L=!0)),typeof $>"u"&&isNumber$G(y)&&($=this.xData.indexOf(y,a)),$!==-1&&typeof $<"u"&&this.cropped&&($=$>=this.cropStart?$-this.cropStart:$),!L&&isNumber$G($)&&C[$]&&C[$].touched&&($=void 0),$},v.prototype.updateData=function(d,a){var p=this.options,y=p.dataSorting,C=this.points,P=[],z=this.requireSorting,L=d.length===C.length,$,N,W,U,j=!0;if(this.xIncrement=null,d.forEach(function(q,X){var K=defined$K(q)&&this.pointClass.prototype.optionsToObject.call({series:this},q)||{},Q,te=K.x,ne=K.id;ne||isNumber$G(te)?(Q=this.findPointIndex(K,U),Q===-1||typeof Q>"u"?P.push(q):C[Q]&&q!==p.data[Q]?(C[Q].update(q,!1,null,!1),C[Q].touched=!0,z&&(U=Q+1)):C[Q]&&(C[Q].touched=!0),(!L||X!==Q||y&&y.enabled||this.hasDerivedData)&&($=!0)):P.push(q)},this),$)for(N=C.length;N--;)W=C[N],W&&!W.touched&&W.remove&&W.remove(!1,a);else L&&(!y||!y.enabled)?(d.forEach(function(q,X){q!==C[X].y&&C[X].update&&C[X].update(q,!1,null,!1)}),P.length=0):j=!1;return C.forEach(function(q){q&&(q.touched=!1)}),j?(P.forEach(function(q){this.addPoint(q,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},v.prototype.setData=function(d,a,p,y){var C=this,P=C.points,z=P&&P.length||0,L=C.options,$=C.chart,N=L.dataSorting,W=C.xAxis,U=L.turboThreshold,j=this.xData,q=this.yData,X=C.pointArrayMap,K=X&&X.length,Q=L.keys,te,ne,ie,ae=0,se=1,de=null;d=d||[];var he=d.length;if(a=pick$1o(a,!0),N&&N.enabled&&(d=this.sortData(d)),y!==!1&&he&&z&&!C.cropped&&!C.hasGroupedData&&C.visible&&!C.isSeriesBoosting&&(ie=this.updateData(d,p)),!ie){if(C.xIncrement=null,C.colorCounter=0,this.parallelArrays.forEach(function(ue){C[ue+"Data"].length=0}),U&&he>U)if(de=C.getFirstValidPoint(d),isNumber$G(de))for(te=0;te<he;te++)j[te]=this.autoIncrement(),q[te]=d[te];else if(isArray$i(de))if(K)for(te=0;te<he;te++)ne=d[te],j[te]=ne[0],q[te]=ne.slice(1,K+1);else for(Q&&(ae=Q.indexOf("x"),se=Q.indexOf("y"),ae=ae>=0?ae:0,se=se>=0?se:1),te=0;te<he;te++)ne=d[te],j[te]=ne[ae],q[te]=ne[se];else error$6(12,!1,$);else for(te=0;te<he;te++)typeof d[te]<"u"&&(ne={series:C},C.pointClass.prototype.applyOptions.apply(ne,[d[te]]),C.updateParallelArrays(ne,te));for(q&&isString$5(q[0])&&error$6(14,!0,$),C.data=[],C.options.data=C.userOptions.data=d,te=z;te--;)P[te]&&P[te].destroy&&P[te].destroy();W&&(W.minRange=W.userMinRange),C.isDirty=$.isDirtyBox=!0,C.isDirtyData=!!P,p=!1}L.legendType==="point"&&(this.processData(),this.generatePoints()),a&&$.redraw(p)},v.prototype.sortData=function(d){var a=this,p=a.options,y=p.dataSorting,C=y.sortKey||"y",P=function(L,$){return defined$K($)&&L.pointClass.prototype.optionsToObject.call({series:L},$)||{}};d.forEach(function(L,$){d[$]=P(a,L),d[$].index=$},this);var z=d.concat().sort(function(L,$){var N=getNestedProperty(C,L),W=getNestedProperty(C,$);return W<N?-1:W>N?1:0});return z.forEach(function(L,$){L.x=$},this),a.linkedSeries&&a.linkedSeries.forEach(function(L){var $=L.options,N=$.data;(!$.dataSorting||!$.dataSorting.enabled)&&N&&(N.forEach(function(W,U){N[U]=P(L,W),d[U]&&(N[U].x=d[U].x,N[U].index=U)}),L.setData(N,!1))}),d},v.prototype.getProcessedData=function(d){var a=this,p=a.xAxis,y=a.options,C=y.cropThreshold,P=d||a.getExtremesFromAll||y.getExtremesFromAll,z=a.isCartesian,L=p&&p.val2lin,$=!!(p&&p.logarithmic),N,W,U=0,j,q,X,K,Q,te,ne=a.xData,ie=a.yData,ae=a.requireSorting,se=!1,de=ne.length;for(p&&(K=p.getExtremes(),Q=K.min,te=K.max,se=p.categories&&!p.names.length),z&&a.sorted&&!P&&(!C||de>C||a.forceCrop)&&(ne[de-1]<Q||ne[0]>te?(ne=[],ie=[]):a.yData&&(ne[0]<Q||ne[de-1]>te)&&(N=this.cropData(a.xData,a.yData,Q,te),ne=N.xData,ie=N.yData,U=N.start,W=!0)),X=ne.length||1;--X;)j=$?L(ne[X])-L(ne[X-1]):ne[X]-ne[X-1],j>0&&(typeof q>"u"||j<q)?q=j:j<0&&ae&&!se&&(error$6(15,!1,a.chart),ae=!1);return{xData:ne,yData:ie,cropped:W,cropStart:U,closestPointRange:q}},v.prototype.processData=function(d){var a=this,p=a.xAxis;if(a.isCartesian&&!a.isDirty&&!p.isDirty&&!a.yAxis.isDirty&&!d)return!1;var y=a.getProcessedData();a.cropped=y.cropped,a.cropStart=y.cropStart,a.processedXData=y.xData,a.processedYData=y.yData,a.closestPointRange=a.basePointRange=y.closestPointRange},v.prototype.cropData=function(d,a,p,y,C){var P=d.length,z,L,$=0,N=P;for(C=pick$1o(C,this.cropShoulder),z=0;z<P;z++)if(d[z]>=p){$=Math.max(0,z-C);break}for(L=z;L<P;L++)if(d[L]>y){N=L+C;break}return{xData:d.slice($,N),yData:a.slice($,N),start:$,end:N}},v.prototype.generatePoints=function(){var d=this,a=d.options,p=a.data,y=d.processedXData,C=d.processedYData,P=d.pointClass,z=y.length,L=d.cropStart||0,$=d.hasGroupedData,N=a.keys,W=[],U=a.dataGrouping&&a.dataGrouping.groupAll?L:0,j,q,X,K,Q=d.data;if(!Q&&!$){var te=[];te.length=p.length,Q=d.data=te}for(N&&$&&(d.options.keys=!1),K=0;K<z;K++)q=L+K,$?(X=new P().init(d,[y[K]].concat(splat$e(C[K]))),X.dataGroup=d.groupMap[U+K],X.dataGroup.options&&(X.options=X.dataGroup.options,extend$1k(X,X.dataGroup.options),delete X.dataLabels)):(X=Q[q],!X&&typeof p[q]<"u"&&(Q[q]=X=new P().init(d,p[q],y[K]))),X&&(X.index=$?U+K:q,W[K]=X);if(d.options.keys=N,Q&&(z!==(j=Q.length)||$))for(K=0;K<j;K++)K===L&&!$&&(K+=z),Q[K]&&(Q[K].destroyElements(),Q[K].plotX=void 0);d.data=Q,d.points=W,fireEvent$s(this,"afterGeneratePoints")},v.prototype.getXExtremes=function(d){return{min:arrayMin$6(d),max:arrayMax$7(d)}},v.prototype.getExtremes=function(d,a){var p=this.xAxis,y=this.yAxis,C=this.processedXData||this.xData,P=[],z=this.requireSorting?this.cropShoulder:0,L=y?y.positiveValuesOnly:!1,$,N,W,U,j,q,X,K=0,Q=0,te=0;d=d||this.stackedYData||this.processedYData||[];var ne=d.length;for(p&&($=p.getExtremes(),K=$.min,Q=$.max),q=0;q<ne;q++)if(U=C[q],j=d[q],N=(isNumber$G(j)||isArray$i(j))&&(j.length||j>0||!L),W=a||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!p||(C[q+z]||U)>=K&&(C[q-z]||U)<=Q,N&&W)if(X=j.length,X)for(;X--;)isNumber$G(j[X])&&(P[te++]=j[X]);else P[te++]=j;var ie={dataMin:arrayMin$6(P),dataMax:arrayMax$7(P)};return fireEvent$s(this,"afterGetExtremes",{dataExtremes:ie}),ie},v.prototype.applyExtremes=function(){var d=this.getExtremes();return this.dataMin=d.dataMin,this.dataMax=d.dataMax,d},v.prototype.getFirstValidPoint=function(d){for(var a=d.length,p=0,y=null;y===null&&p<a;)y=d[p],p++;return y},v.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var d=this,a=d.options,p=a.stacking,y=d.xAxis,C=y.categories,P=d.enabledDataSorting,z=d.yAxis,L=d.points,$=L.length,N=!!d.modifyValue,W=d.pointPlacementToXValue(),U=!!W,j=a.threshold,q=a.startFromThreshold?j:0,X=this.zoneAxis||"y",K,Q,te,ne,ie=Number.MAX_VALUE;function ae(Oe){return clamp$g(Oe,-1e5,1e5)}for(K=0;K<$;K++){var se=L[K],de=se.x,he=void 0,ue=void 0,me=se.y,xe=se.low,we=p&&z.stacking&&z.stacking.stacks[(d.negStacks&&me<(q?0:j)?"-":"")+d.stackKey];if((z.positiveValuesOnly&&!z.validatePositiveValue(me)||y.positiveValuesOnly&&!y.validatePositiveValue(de))&&(se.isNull=!0),se.plotX=Q=correctFloat$a(ae(y.translate(de,0,0,0,1,W,this.type==="flags"))),p&&d.visible&&we&&we[de]&&(ne=d.getStackIndicator(ne,de,d.index),se.isNull||(he=we[de],ue=he.points[ne.key])),isArray$i(ue)&&(xe=ue[0],me=ue[1],xe===q&&ne.key===we[de].base&&(xe=pick$1o(isNumber$G(j)&&j,z.min)),z.positiveValuesOnly&&xe<=0&&(xe=null),se.total=se.stackTotal=he.total,se.percentage=he.total&&se.y/he.total*100,se.stackY=me,d.irregularWidths||he.setOffset(d.pointXOffset||0,d.barW||0)),se.yBottom=defined$K(xe)?ae(z.translate(xe,0,1,0,1)):null,N&&(me=d.modifyValue(me,se)),se.plotY=void 0,isNumber$G(me)){var ye=z.translate(me,!1,!0,!1,!0);typeof ye<"u"&&(se.plotY=ae(ye))}se.isInside=this.isPointInside(se),se.clientX=U?correctFloat$a(y.translate(de,0,0,0,1,W)):Q,se.negative=se[X]<(a[X+"Threshold"]||j||0),se.category=C&&typeof C[se.x]<"u"?C[se.x]:se.x,!se.isNull&&se.visible!==!1&&(typeof te<"u"&&(ie=Math.min(ie,Math.abs(Q-te))),te=Q),se.zone=this.zones.length&&se.getZone(),!se.graphic&&d.group&&P&&(se.isNew=!0)}d.closestPointRangePx=ie,fireEvent$s(this,"afterTranslate")},v.prototype.getValidPoints=function(d,a,p){var y=this.chart;return(d||this.points||[]).filter(function(C){return a&&!y.isInsidePlot(C.plotX,C.plotY,{inverted:y.inverted})?!1:C.visible!==!1&&(p||!C.isNull)})},v.prototype.getClipBox=function(d,a){var p=this,y=p.options,C=p.chart,P=C.inverted,z=p.xAxis,L=z&&p.yAxis,$=C.options.chart.scrollablePlotArea||{},N;return d&&y.clip===!1&&L?N=P?{y:-C.chartWidth+L.len+L.pos,height:C.chartWidth,width:C.chartHeight,x:-C.chartHeight+z.len+z.pos}:{y:-L.pos,height:C.chartHeight,width:C.chartWidth,x:-z.pos}:(N=p.clipBox||C.clipBox,a&&(N.width=C.plotSizeX,N.x=(C.scrollablePixelsX||0)*($.scrollPositionX||0))),a?{width:N.width,x:N.x}:N},v.prototype.getSharedClipKey=function(d){if(this.sharedClipKey)return this.sharedClipKey;var a=[d&&d.duration,d&&d.easing,d&&d.defer,this.getClipBox(d).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||d)&&(this.sharedClipKey=a),a},v.prototype.setClip=function(d){var a=this.chart,p=this.options,y=a.renderer,C=a.inverted,P=this.clipBox,z=this.getClipBox(d),L=this.getSharedClipKey(d),$=a.sharedClips[L],N=a.sharedClips[L+"m"];d&&(z.width=0,C&&(z.x=a.plotHeight+(p.clip!==!1?0:a.plotTop))),$?a.hasLoaded||$.attr(z):(d&&(a.sharedClips[L+"m"]=N=y.clipRect(C?(a.plotSizeX||0)+99:-99,C?-a.plotLeft:-a.plotTop,99,C?a.chartWidth:a.chartHeight)),a.sharedClips[L]=$=y.clipRect(z),$.count={length:0}),d&&($.count[this.index]||($.count[this.index]=!0,$.count.length+=1)),(p.clip!==!1||d)&&(this.group.clip(d||P?$:a.clipRect),this.markerGroup.clip(N)),d||($.count[this.index]&&(delete $.count[this.index],$.count.length-=1),$.count.length===0&&(P||(a.sharedClips[L]=$.destroy()),N&&(a.sharedClips[L+"m"]=N.destroy())))},v.prototype.animate=function(d){var a=this,p=a.chart,y=animObject$7(a.options.animation),C=this.sharedClipKey;if(d)a.setClip(y);else if(C){var P=p.sharedClips[C],z=p.sharedClips[C+"m"],L=a.getClipBox(y,!0);P&&P.animate(L,y),z&&z.animate({width:L.width+99,x:L.x-(p.inverted?0:99)},y)}},v.prototype.afterAnimate=function(){this.setClip(),fireEvent$s(this,"afterAnimate"),this.finishedAnimating=!0},v.prototype.drawPoints=function(){var d=this,a=d.points,p=d.chart,y=d.options,C=y.marker,P=d[d.specialGroup]||d.markerGroup,z=d.xAxis,L=pick$1o(C.enabled,!z||z.isRadial?!0:null,d.closestPointRangePx>=C.enabledThreshold*C.radius),$,N,W,U,j,q,X;if(C.enabled!==!1||d._hasPointMarkers)for($=0;$<a.length;$++){N=a[$],W=N.graphic,U=W?"animate":"attr",j=N.marker||{},q=!!N.marker;var K=(L&&typeof j.enabled>"u"||j.enabled)&&!N.isNull&&N.visible!==!1;if(K){var Q=pick$1o(j.symbol,d.symbol,"rect");X=d.markerAttribs(N,N.selected&&"select"),d.enabledDataSorting&&(N.startXPos=z.reversed?-(X.width||0):z.width);var te=N.isInside!==!1;W?W[te?"show":"hide"](te).animate(X):te&&((X.width||0)>0||N.hasImage)&&(N.graphic=W=p.renderer.symbol(Q,X.x,X.y,X.width,X.height,q?j:C).add(P),d.enabledDataSorting&&p.hasRendered&&(W.attr({x:N.startXPos}),U="animate")),W&&U==="animate"&&W[te?"show":"hide"](te).animate(X),W&&!p.styledMode&&W[U](d.pointAttribs(N,N.selected&&"select")),W&&W.addClass(N.getClassName(),!0)}else W&&(N.graphic=W.destroy())}},v.prototype.markerAttribs=function(d,a){var p=this.options,y=p.marker,C=d.marker||{},P=C.symbol||y.symbol,z,L,$=pick$1o(C.radius,y.radius);a&&(z=y.states[a],L=C.states&&C.states[a],$=pick$1o(L&&L.radius,z&&z.radius,$+(z&&z.radiusPlus||0))),d.hasImage=P&&P.indexOf("url")===0,d.hasImage&&($=0);var N={x:p.crisp?Math.floor(d.plotX-$):d.plotX-$,y:d.plotY-$};return $&&(N.width=N.height=2*$),N},v.prototype.pointAttribs=function(d,a){var p=this.options.marker,y=d&&d.options,C=y&&y.marker||{},P=y&&y.color,z=d&&d.color,L=d&&d.zone&&d.zone.color,$,N,W=this.color,U,j,q=pick$1o(C.lineWidth,p.lineWidth),X=1;return W=P||L||z||W,U=C.fillColor||p.fillColor||W,j=C.lineColor||p.lineColor||W,a=a||"normal",a&&($=p.states[a],N=C.states&&C.states[a]||{},q=pick$1o(N.lineWidth,$.lineWidth,q+pick$1o(N.lineWidthPlus,$.lineWidthPlus,0)),U=N.fillColor||$.fillColor||U,j=N.lineColor||$.lineColor||j,X=pick$1o(N.opacity,$.opacity,X)),{stroke:j,"stroke-width":q,fill:U,opacity:X}},v.prototype.destroy=function(d){var a=this,p=a.chart,y=/AppleWebKit\/533/.test(win$7.navigator.userAgent),C=a.data||[],P,z,L,$;for(fireEvent$s(a,"destroy"),this.removeEvents(d),(a.axisTypes||[]).forEach(function(N){$=a[N],$&&$.series&&(erase$3($.series,a),$.isDirty=$.forceRedraw=!0)}),a.legendItem&&a.chart.legend.destroyItem(a),z=C.length;z--;)L=C[z],L&&L.destroy&&L.destroy();a.clips&&a.clips.forEach(function(N){return N.destroy()}),Utilities.clearTimeout(a.animationTimeout),objectEach$o(a,function(N,W){N instanceof SVGElement&&!N.survive&&(P=y&&W==="group"?"hide":"destroy",N[P]())}),p.hoverSeries===a&&(p.hoverSeries=void 0),erase$3(p.series,a),p.orderSeries(),objectEach$o(a,function(N,W){(!d||W!=="hcEvents")&&delete a[W]})},v.prototype.applyZones=function(){var d=this,a=this.chart,p=a.renderer,y=this.zones,C=this.clips||[],P=this.graph,z=this.area,L=Math.max(a.chartWidth,a.chartHeight),$=this[(this.zoneAxis||"y")+"Axis"],N=a.inverted,W,U,j,q,X,K,Q,te,ne,ie,ae,se=!1;y.length&&(P||z)&&$&&typeof $.min<"u"?(X=$.reversed,K=$.horiz,P&&!this.showLine&&P.hide(),z&&z.hide(),q=$.getExtremes(),y.forEach(function(de,he){W=X?K?a.plotWidth:0:K?0:$.toPixels(q.min)||0,W=clamp$g(pick$1o(U,W),0,L),U=clamp$g(Math.round($.toPixels(pick$1o(de.value,q.max),!0)||0),0,L),se&&(W=U=$.toPixels(q.max)),Q=Math.abs(W-U),te=Math.min(W,U),ne=Math.max(W,U),$.isXAxis?(j={x:N?ne:te,y:0,width:Q,height:L},K||(j.x=a.plotHeight-j.x)):(j={x:0,y:N?ne:te,width:L,height:Q},K&&(j.y=a.plotWidth-j.y)),N&&p.isVML&&($.isXAxis?j={x:0,y:X?te:ne,height:j.width,width:a.chartWidth}:j={x:j.y-a.plotLeft-a.spacingBox.x,y:0,width:j.height,height:a.chartHeight}),C[he]?C[he].animate(j):C[he]=p.clipRect(j),ie=d["zone-area-"+he],ae=d["zone-graph-"+he],P&&ae&&ae.clip(C[he]),z&&ie&&ie.clip(C[he]),se=de.value>q.max,d.resetZones&&U===0&&(U=void 0)}),this.clips=C):d.visible&&(P&&P.show(!0),z&&z.show(!0))},v.prototype.invertGroups=function(d){var a=this,p=a.chart;function y(){["group","markerGroup"].forEach(function(C){a[C]&&(p.renderer.isVML&&a[C].attr({width:a.yAxis.len,height:a.xAxis.len}),a[C].width=a.yAxis.len,a[C].height=a.xAxis.len,a[C].invert(a.isRadialSeries?!1:d))})}a.xAxis&&(a.eventsToUnbind.push(addEvent$Z(p,"resize",y)),y(),a.invertGroups=y)},v.prototype.plotGroup=function(d,a,p,y,C){var P=this[d],z=!P,L={visibility:p,zIndex:y||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(L.opacity=this.opacity),z&&(this[d]=P=this.chart.renderer.g().add(C)),P.addClass("highcharts-"+a+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$K(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(P.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),P.attr(L)[z?"attr":"animate"](this.getPlotBox()),P},v.prototype.getPlotBox=function(){var d=this.chart,a=this.xAxis,p=this.yAxis;return d.inverted&&(a=p,p=this.xAxis),{translateX:a?a.left:d.plotLeft,translateY:p?p.top:d.plotTop,scaleX:1,scaleY:1}},v.prototype.removeEvents=function(d){var a=this;d||removeEvent$5(a),a.eventsToUnbind.length&&(a.eventsToUnbind.forEach(function(p){p()}),a.eventsToUnbind.length=0)},v.prototype.render=function(){var d=this,a=d.chart,p=d.options,y=animObject$7(p.animation),C=d.visible?"inherit":"hidden",P=p.zIndex,z=d.hasRendered,L=a.seriesGroup,$=a.inverted,N=!d.finishedAnimating&&a.renderer.isSVG&&y.duration;fireEvent$s(this,"render");var W=d.plotGroup("group","series",C,P,L);d.markerGroup=d.plotGroup("markerGroup","markers",C,P,L),N&&d.animate&&d.animate(!0),W.inverted=pick$1o(d.invertible,d.isCartesian)?$:!1,d.drawGraph&&(d.drawGraph(),d.applyZones()),d.visible&&d.drawPoints(),d.drawDataLabels&&d.drawDataLabels(),d.redrawPoints&&d.redrawPoints(),d.drawTracker&&d.options.enableMouseTracking!==!1&&d.drawTracker(),d.invertGroups($),p.clip!==!1&&!d.sharedClipKey&&!z&&W.clip(a.clipRect),N&&d.animate&&d.animate(),z||(N&&y.defer&&(N+=y.defer),d.animationTimeout=syncTimeout$2(function(){d.afterAnimate()},N||0)),d.isDirty=!1,d.hasRendered=!0,fireEvent$s(d,"afterRender")},v.prototype.redraw=function(){var d=this,a=d.chart,p=d.isDirty||d.isDirtyData,y=d.group,C=d.xAxis,P=d.yAxis;y&&(a.inverted&&y.attr({width:a.plotWidth,height:a.plotHeight}),y.animate({translateX:pick$1o(C&&C.left,a.plotLeft),translateY:pick$1o(P&&P.top,a.plotTop)})),d.translate(),d.render(),p&&delete this.kdTree},v.prototype.searchPoint=function(d,a){var p=this,y=p.xAxis,C=p.yAxis,P=p.chart.inverted;return this.searchKDTree({clientX:P?y.len-d.chartY+y.pos:d.chartX-y.pos,plotY:P?C.len-d.chartX+C.pos:d.chartY-C.pos},a,d)},v.prototype.buildKDTree=function(d){this.buildingKdTree=!0;var a=this,p=a.options.findNearestPointBy.indexOf("y")>-1?2:1;function y(P,z,L){var $=P&&P.length,N,W;if($)return N=a.kdAxisArray[z%L],P.sort(function(U,j){return U[N]-j[N]}),W=Math.floor($/2),{point:P[W],left:y(P.slice(0,W),z+1,L),right:y(P.slice(W+1),z+1,L)}}function C(){a.kdTree=y(a.getValidPoints(null,!a.directTouch),p,p),a.buildingKdTree=!1}delete a.kdTree,syncTimeout$2(C,a.options.kdNow||d&&d.type==="touchstart"?0:1)},v.prototype.searchKDTree=function(d,a,p){var y=this,C=this.kdAxisArray[0],P=this.kdAxisArray[1],z=a?"distX":"dist",L=y.options.findNearestPointBy.indexOf("y")>-1?2:1;function $(W,U){var j=defined$K(W[C])&&defined$K(U[C])?Math.pow(W[C]-U[C],2):null,q=defined$K(W[P])&&defined$K(U[P])?Math.pow(W[P]-U[P],2):null,X=(j||0)+(q||0);U.dist=defined$K(X)?Math.sqrt(X):Number.MAX_VALUE,U.distX=defined$K(j)?Math.sqrt(j):Number.MAX_VALUE}function N(W,U,j,q){var X=U.point,K=y.kdAxisArray[j%q],Q,te,ne=X;$(W,X);var ie=W[K]-X[K],ae=ie<0?"left":"right",se=ie<0?"right":"left";return U[ae]&&(Q=N(W,U[ae],j+1,q),ne=Q[z]<ne[z]?Q:X),U[se]&&Math.sqrt(ie*ie)<ne[z]&&(te=N(W,U[se],j+1,q),ne=te[z]<ne[z]?te:ne),ne}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(p),this.kdTree)return N(d,this.kdTree,L,L)},v.prototype.pointPlacementToXValue=function(){var d=this,a=d.options,p=a.pointPlacement,y=a.pointRange,C=d.xAxis,P=p;return P==="between"&&(P=C.reversed?-.5:.5),isNumber$G(P)?P*(y||C.pointRange):0},v.prototype.isPointInside=function(d){var a=typeof d.plotY<"u"&&typeof d.plotX<"u"&&d.plotY>=0&&d.plotY<=this.yAxis.len&&d.plotX>=0&&d.plotX<=this.xAxis.len;return a},v.prototype.drawTracker=function(){var d=this,a=d.options,p=a.trackByArea,y=[].concat(p?d.areaPath:d.graphPath),C=d.chart,P=C.pointer,z=C.renderer,L=C.options.tooltip.snap,$=d.tracker,N=function(U){C.hoverSeries!==d&&d.onMouseOver()},W="rgba(192,192,192,"+(svg$4?1e-4:.002)+")";$?$.attr({d:y}):d.graph&&(d.tracker=z.path(y).attr({visibility:d.visible?"visible":"hidden",zIndex:2}).addClass(p?"highcharts-tracker-area":"highcharts-tracker-line").add(d.group),C.styledMode||d.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:W,fill:p?W:"none","stroke-width":d.graph.strokeWidth()+(p?0:2*L)}),[d.tracker,d.markerGroup,d.dataLabelsGroup].forEach(function(U){U&&(U.addClass("highcharts-tracker").on("mouseover",N).on("mouseout",function(j){P.onTrackerMouseOut(j)}),a.cursor&&!C.styledMode&&U.css({cursor:a.cursor}),hasTouch$2&&U.on("touchstart",N))})),fireEvent$s(this,"afterDrawTracker")},v.prototype.addPoint=function(d,a,p,y,C){var P=this,z=P.options,L=P.data,$=P.chart,N=P.xAxis,W=N&&N.hasNames&&N.names,U=z.data,j=P.xData,q,X;a=pick$1o(a,!0);var K={series:P};P.pointClass.prototype.applyOptions.apply(K,[d]);var Q=K.x;if(X=j.length,P.requireSorting&&Q<j[X-1])for(q=!0;X&&j[X-1]>Q;)X--;P.updateParallelArrays(K,"splice",X,0,0),P.updateParallelArrays(K,X),W&&K.name&&(W[Q]=K.name),U.splice(X,0,d),q&&(P.data.splice(X,0,null),P.processData()),z.legendType==="point"&&P.generatePoints(),p&&(L[0]&&L[0].remove?L[0].remove(!1):(L.shift(),P.updateParallelArrays(K,"shift"),U.shift())),C!==!1&&fireEvent$s(P,"addPoint",{point:K}),P.isDirty=!0,P.isDirtyData=!0,a&&$.redraw(y)},v.prototype.removePoint=function(d,a,p){var y=this,C=y.data,P=C[d],z=y.points,L=y.chart,$=function(){z&&z.length===C.length&&z.splice(d,1),C.splice(d,1),y.options.data.splice(d,1),y.updateParallelArrays(P||{series:y},"splice",d,1),P&&P.destroy(),y.isDirty=!0,y.isDirtyData=!0,a&&L.redraw()};setAnimation$2(p,L),a=pick$1o(a,!0),P?P.firePointEvent("remove",null,$):$()},v.prototype.remove=function(d,a,p,y){var C=this,P=C.chart;function z(){C.destroy(y),P.isDirtyLegend=P.isDirtyBox=!0,P.linkSeries(),pick$1o(d,!0)&&P.redraw(a)}p!==!1?fireEvent$s(C,"remove",null,z):z()},v.prototype.update=function(d,a){d=cleanRecursively(d,this.userOptions),fireEvent$s(this,"update",{options:d});var p=this,y=p.chart,C=p.userOptions,P=p.initialType||p.type,z=y.options.plotOptions,L=seriesTypes$7[P].prototype,$=["group","markerGroup","dataLabelsGroup","transformGroup"],N=p.finishedAnimating&&{animation:!1},W={},U,j,q=["eventOptions","navigatorSeries","baseSeries"],X=d.type||C.type||y.options.chart.type,K=!(this.hasDerivedData||X&&X!==this.type||typeof d.pointStart<"u"||typeof d.pointInterval<"u"||typeof d.relativeXValue<"u"||p.hasOptionChanged("dataGrouping")||p.hasOptionChanged("pointStart")||p.hasOptionChanged("pointInterval")||p.hasOptionChanged("pointIntervalUnit")||p.hasOptionChanged("keys"));X=X||P,K&&(q.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),d.visible!==!1&&q.push("area","graph"),p.parallelArrays.forEach(function(ae){q.push(ae+"Data")}),d.data&&(d.dataSorting&&extend$1k(p.options.dataSorting,d.dataSorting),this.setData(d.data,!1))),d=merge$1g(C,N,{index:typeof C.index>"u"?p.index:C.index,pointStart:pick$1o(z&&z.series&&z.series.pointStart,C.pointStart,p.xData[0])},!K&&{data:p.options.data},d),K&&d.data&&(d.data=p.options.data),q=$.concat(q),q.forEach(function(ae){q[ae]=p[ae],delete p[ae]});var Q=!1;if(seriesTypes$7[X]){if(Q=X!==p.type,p.remove(!1,!1,!1,!0),Q)if(Object.setPrototypeOf)Object.setPrototypeOf(p,seriesTypes$7[X].prototype);else{var te=Object.hasOwnProperty.call(p,"hcEvents")&&p.hcEvents;for(j in L)p[j]=void 0;extend$1k(p,seriesTypes$7[X].prototype),te?p.hcEvents=te:delete p.hcEvents}}else error$6(17,!0,y,{missingModuleFor:X});if(q.forEach(function(ae){p[ae]=q[ae]}),p.init(y,d),K&&this.points){if(U=p.options,U.visible===!1)W.graphic=1,W.dataLabel=1;else if(!p._hasPointLabels){var ne=U.marker,ie=U.dataLabels;ne&&(ne.enabled===!1||(C.marker&&C.marker.symbol)!==ne.symbol)&&(W.graphic=1),ie&&ie.enabled===!1&&(W.dataLabel=1)}this.points.forEach(function(ae){ae&&ae.series&&(ae.resolveColor(),Object.keys(W).length&&ae.destroyElements(W),U.showInLegend===!1&&ae.legendItem&&y.legend.destroyItem(ae))},this)}p.initialType=P,y.linkSeries(),Q&&p.linkedSeries.length&&(p.isDirtyData=!0),fireEvent$s(this,"afterUpdate"),pick$1o(a,!0)&&y.redraw(K?void 0:!1)},v.prototype.setName=function(d){this.name=this.options.name=this.userOptions.name=d,this.chart.isDirtyLegend=!0},v.prototype.hasOptionChanged=function(d){var a=this.chart,p=this.options[d],y=a.options.plotOptions,C=this.userOptions[d];return C?p!==C:p!==pick$1o(y&&y[this.type]&&y[this.type][d],y&&y.series&&y.series[d],p)},v.prototype.onMouseOver=function(){var d=this,a=d.chart,p=a.hoverSeries,y=a.pointer;y.setHoverChartIndex(),p&&p!==d&&p.onMouseOut(),d.options.events.mouseOver&&fireEvent$s(d,"mouseOver"),d.setState("hover"),a.hoverSeries=d},v.prototype.onMouseOut=function(){var d=this,a=d.options,p=d.chart,y=p.tooltip,C=p.hoverPoint;p.hoverSeries=null,C&&C.onMouseOut(),d&&a.events.mouseOut&&fireEvent$s(d,"mouseOut"),y&&!d.stickyTracking&&(!y.shared||d.noSharedTooltip)&&y.hide(),p.series.forEach(function(P){P.setState("",!0)})},v.prototype.setState=function(d,a){var p=this,y=p.options,C=p.graph,P=y.inactiveOtherPoints,z=y.states,L=pick$1o(z[d||"normal"]&&z[d||"normal"].animation,p.chart.options.chart.animation),$,N=y.lineWidth,W=0,U=y.opacity;if(d=d||"",p.state!==d&&([p.group,p.markerGroup,p.dataLabelsGroup].forEach(function(j){j&&(p.state&&j.removeClass("highcharts-series-"+p.state),d&&j.addClass("highcharts-series-"+d))}),p.state=d,!p.chart.styledMode)){if(z[d]&&z[d].enabled===!1)return;if(d&&(N=z[d].lineWidth||N+(z[d].lineWidthPlus||0),U=pick$1o(z[d].opacity,U)),C&&!C.dashstyle)for($={"stroke-width":N},C.animate($,L);p["zone-graph-"+W];)p["zone-graph-"+W].animate($,L),W=W+1;P||[p.group,p.markerGroup,p.dataLabelsGroup,p.labelBySeries].forEach(function(j){j&&j.animate({opacity:U},L)})}a&&P&&p.points&&p.setAllPointsToState(d||void 0)},v.prototype.setAllPointsToState=function(d){this.points.forEach(function(a){a.setState&&a.setState(d)})},v.prototype.setVisible=function(d,a){var p=this,y=p.chart,C=p.legendItem,P=y.options.chart.ignoreHiddenSeries,z=p.visible;p.visible=d=p.options.visible=p.userOptions.visible=typeof d>"u"?!z:d;var L=d?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function($){p[$]&&p[$][L]()}),(y.hoverSeries===p||(y.hoverPoint&&y.hoverPoint.series)===p)&&p.onMouseOut(),C&&y.legend.colorizeItem(p,d),p.isDirty=!0,p.options.stacking&&y.series.forEach(function($){$.options.stacking&&$.visible&&($.isDirty=!0)}),p.linkedSeries.forEach(function($){$.setVisible(d,!1)}),P&&(y.isDirtyBox=!0),fireEvent$s(p,L),a!==!1&&y.redraw()},v.prototype.show=function(){this.setVisible(!0)},v.prototype.hide=function(){this.setVisible(!1)},v.prototype.select=function(d){var a=this;a.selected=d=this.options.selected=typeof d>"u"?!a.selected:d,a.checkbox&&(a.checkbox.checked=d),fireEvent$s(a,d?"select":"unselect")},v.prototype.shouldShowTooltip=function(d,a,p){return p===void 0&&(p={}),p.series=this,p.visiblePlotOnly=!0,this.chart.isInsidePlot(d,a,p)},v.defaultOptions=seriesDefaults,v})();extend$1k(Series$f.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$4,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$f;var stop=animationExports.stop,addEvent$Y=Utilities.addEvent,createElement$4=Utilities.createElement,merge$1f=Utilities.merge,pick$1n=Utilities.pick;addEvent$Y(Chart$1,"afterSetChartSize",function(v){var d=this.options.chart.scrollablePlotArea,a=d&&d.minWidth,p=d&&d.minHeight,y,C,P;this.renderer.forExport||(a?(this.scrollablePixelsX=y=Math.max(0,a-this.chartWidth),y&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.width=this.plotWidth+=y,this.inverted?this.clipBox.height+=y:this.clipBox.width+=y,P={1:{name:"right",value:y}})):p&&(this.scrollablePixelsY=C=Math.max(0,p-this.chartHeight),C&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.height=this.plotHeight+=C,this.inverted?this.clipBox.width+=C:this.clipBox.height+=C,P={2:{name:"bottom",value:C}})),P&&!v.skipAxes&&this.axes.forEach(function(z){P[z.side]?z.getPlotLinePath=function(){var L=P[z.side].name,$=P[z.side].value,N=this[L],W;return this[L]=N-$,W=Axis.prototype.getPlotLinePath.apply(this,arguments),this[L]=N,W}:(z.setAxisSize(),z.setAxisTranslation())}))});addEvent$Y(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var v=this,d={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(d.overflowX="auto"),this.scrollablePixelsY&&(d.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},d,this.scrollingParent),addEvent$Y(this.scrollingContainer,"scroll",function(){v.pointer&&delete v.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var v=this.container,d=this.fixedRenderer,a=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],p;this.scrollablePixelsX&&!this.inverted?p=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?p=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(p=".highcharts-yaxis"),p&&a.push(p+":not(.highcharts-radial-axis)",p+"-labels:not(.highcharts-radial-axis-labels)"),a.forEach(function(y){[].forEach.call(v.querySelectorAll(y),function(C){(C.namespaceURI===d.SVG_NS?d.box:d.box.parentNode).appendChild(C),C.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var v=!this.fixedDiv,d=this.options.chart,a=d.scrollablePlotArea,p=RendererRegistry$1.getRendererType(),y,C,P;v?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(d.style&&d.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=y=new p(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=y.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1n(a.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$Y(this,"afterShowResetZoom",this.moveFixedElements),addEvent$Y(this,"afterDrilldown",this.moveFixedElements),addEvent$Y(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||v)&&(this.scrollableDirty=!1,this.moveFixedElements()),C=this.chartWidth+(this.scrollablePixelsX||0),P=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=C+"px",this.container.style.height=P+"px",this.renderer.boxWrapper.attr({width:C,height:P,viewBox:[0,0,C,P].join(" ")}),this.chartBackground.attr({width:C,height:P}),this.scrollingContainer.style.height=this.chartHeight+"px",v&&(a.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*a.scrollPositionX),a.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*a.scrollPositionY));var z=this.axisOffset,L=this.plotTop-z[0]-1,$=this.plotLeft-z[3]-1,N=this.plotTop+this.plotHeight+z[2]+1,W=this.plotLeft+this.plotWidth+z[1]+1,U=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),j=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),q;this.scrollablePixelsX?q=[["M",0,L],["L",this.plotLeft-1,L],["L",this.plotLeft-1,N],["L",0,N],["Z"],["M",U,L],["L",this.chartWidth,L],["L",this.chartWidth,N],["L",U,N],["Z"]]:this.scrollablePixelsY?q=[["M",$,0],["L",$,this.plotTop-1],["L",W,this.plotTop-1],["L",W,0],["Z"],["M",$,j],["L",$,this.chartHeight],["L",W,this.chartHeight],["L",W,j],["Z"]]:q=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:q})};addEvent$Y(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$Y(Series$f,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$X=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$r=Utilities.fireEvent,isNumber$F=Utilities.isNumber,objectEach$n=Utilities.objectEach,StackingAxis;(function(v){var d=[];function a(P){return d.indexOf(P)===-1&&(d.push(P),addEvent$X(P,"init",y),addEvent$X(P,"destroy",p)),P}v.compose=a;function p(){var P=this.stacking;if(P){var z=P.stacks;objectEach$n(z,function(L,$){destroyObjectProperties$5(L),z[$]=null}),P&&P.stackTotalGroup&&P.stackTotalGroup.destroy()}}function y(){var P=this;P.stacking||(P.stacking=new C(P))}var C=(function(){function P(z){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=z}return P.prototype.buildStacks=function(){var z=this,L=z.axis,$=L.series,N=L.options.reversedStacks,W=$.length,U,j;if(!L.isXAxis){for(z.usePercentage=!1,j=W;j--;)U=$[N?j:W-j-1],U.setStackedPoints(),U.setGroupedPoints();for(j=0;j<W;j++)$[j].modifyStacks();fireEvent$r(L,"afterBuildStacks")}},P.prototype.cleanStacks=function(){var z=this,L=z.axis,$;L.isXAxis||(z.oldStacks&&($=z.stacks=z.oldStacks),objectEach$n($,function(N){objectEach$n(N,function(W){W.cumulative=W.total})}))},P.prototype.resetStacks=function(){var z=this,L=z.axis,$=z.stacks;L.isXAxis||objectEach$n($,function(N){objectEach$n(N,function(W,U){isNumber$F(W.touched)&&W.touched<z.stacksTouched?(W.destroy(),delete N[U]):(W.total=null,W.cumulative=null)})})},P.prototype.renderStackTotals=function(){var z=this,L=z.axis,$=L.chart,N=$.renderer,W=z.stacks,U=L.options.stackLabels&&L.options.stackLabels.animation,j=getDeferredAnimation$2($,U||!1),q=z.stackTotalGroup=z.stackTotalGroup||N.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();q.translate($.plotLeft,$.plotTop),objectEach$n(W,function(X){objectEach$n(X,function(K){K.render(q)})}),q.animate({opacity:1},j)},P})();v.Additions=C})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$a=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$J=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$h=Utilities.isArray,isNumber$E=Utilities.isNumber,objectEach$m=Utilities.objectEach,pick$1m=Utilities.pick,StackItem=(function(){function v(d,a,p,y,C){var P=d.chart.inverted;this.axis=d,this.isNegative=p,this.options=a=a||{},this.x=y,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=C,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:a.align||(P?p?"left":"right":"center"),verticalAlign:a.verticalAlign||(P?"middle":p?"bottom":"top"),y:a.y,x:a.x},this.textAlign=a.textAlign||(P?p?"right":"left":"center")}return v.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},v.prototype.render=function(d){var a=this.axis.chart,p=this.options,y=p.format,C={},P=y?format$a(y,this,a):p.formatter.call(this);this.label?this.label.attr({text:P,visibility:"hidden"}):(this.label=a.renderer.label(P,null,null,p.shape,null,null,p.useHTML,!1,"stack-labels"),C={r:p.borderRadius||0,text:P,rotation:p.rotation,padding:pick$1m(p.padding,5),visibility:"hidden"},a.styledMode||(C.fill=p.backgroundColor,C.stroke=p.borderColor,C["stroke-width"]=p.borderWidth,this.label.css(p.style)),this.label.attr(C),this.label.added||this.label.add(d)),this.label.labelrank=a.plotSizeY},v.prototype.setOffset=function(d,a,p,y,C){var P=this,z=P.axis,L=z.chart,$=z.translate(z.stacking.usePercentage?100:y||P.total,0,0,0,1),N=z.translate(p||0),W=defined$J($)&&Math.abs($-N),U=pick$1m(C,L.xAxis[0].translate(P.x))+d,j=defined$J($)&&P.getStackBox(L,P,U,$,a,W,z),q=P.label,X=P.isNegative,K=pick$1m(P.options.overflow,"justify")==="justify",Q=P.textAlign,te;if(q&&j){var ne=q.getBBox(),ie=q.padding,ae=void 0,se=void 0;Q==="left"?ae=L.inverted?-ie:ie:Q==="right"?ae=ne.width:L.inverted&&Q==="center"?ae=ne.width/2:ae=L.inverted?X?ne.width+ie:-ie:ne.width/2,se=L.inverted?ne.height/2:X?-ie:ne.height,P.alignOptions.x=pick$1m(P.options.x,0),P.alignOptions.y=pick$1m(P.options.y,0),j.x-=ae,j.y-=se,q.align(P.alignOptions,null,j),L.isInsidePlot(q.alignAttr.x+ae-P.alignOptions.x,q.alignAttr.y+se-P.alignOptions.y)?q.show():(q.alignAttr.y=-9999,K=!1),K&&Series$f.prototype.justifyDataLabel.call(this.axis,q,P.alignOptions,q.alignAttr,ne,j),q.attr({x:q.alignAttr.x,y:q.alignAttr.y}),pick$1m(!K&&P.options.crop,!0)&&(te=isNumber$E(q.x)&&isNumber$E(q.y)&&L.isInsidePlot(q.x-ie+q.width,q.y)&&L.isInsidePlot(q.x+ie,q.y),te||q.hide())}},v.prototype.getStackBox=function(d,a,p,y,C,P,z){var L=a.axis.reversed,$=d.inverted,N=z.height+z.pos-($?d.plotLeft:d.plotTop),W=a.isNegative&&!L||!a.isNegative&&L;return{x:$?W?y-z.right:y-P+z.pos-d.plotLeft:p+d.xAxis[0].transB-d.plotLeft,y:$?z.height-p-C:W?N-y-P:N-y,width:$?P:C,height:$?C:P}},v})();Chart$1.prototype.getStacks=function(){var v=this,d=v.inverted;v.yAxis.forEach(function(a){a.stacking&&a.stacking.stacks&&a.hasVisibleSeries&&(a.stacking.oldStacks=a.stacking.stacks)}),v.series.forEach(function(a){var p=a.xAxis&&a.xAxis.options||{};a.options.stacking&&(a.visible===!0||v.options.chart.ignoreHiddenSeries===!1)&&(a.stackKey=[a.type,pick$1m(a.options.stack,""),d?p.top:p.left,d?p.height:p.width].join(","))})};StackingAxis$1.compose(Axis);Series$f.prototype.setGroupedPoints=function(){var v=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$f.prototype.setStackedPoints.call(this,"group"):v&&objectEach$m(v.stacks,function(d,a){a.slice(-5)==="group"&&(objectEach$m(d,function(p){return p.destroy()}),delete v.stacks[a])})};Series$f.prototype.setStackedPoints=function(v){var d=v||this.options.stacking;if(!(!d||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var a=this,p=a.processedXData,y=a.processedYData,C=[],P=y.length,z=a.options,L=z.threshold,$=pick$1m(z.startFromThreshold&&L,0),N=z.stack,W=v?a.type+","+d:a.stackKey,U="-"+W,j=a.negStacks,q=a.yAxis,X=q.stacking.stacks,K=q.stacking.oldStacks,Q,te,ne,ie,ae,se,de,he,ue;for(q.stacking.stacksTouched+=1,de=0;de<P;de++)he=p[de],ue=y[de],Q=a.getStackIndicator(Q,he,a.index),se=Q.key,te=j&&ue<($?0:L),ae=te?U:W,X[ae]||(X[ae]={}),X[ae][he]||(K[ae]&&K[ae][he]?(X[ae][he]=K[ae][he],X[ae][he].total=null):X[ae][he]=new StackItem(q,q.options.stackLabels,te,he,N)),ne=X[ae][he],ue!==null?(ne.points[se]=ne.points[a.index]=[pick$1m(ne.cumulative,$)],defined$J(ne.cumulative)||(ne.base=se),ne.touched=q.stacking.stacksTouched,Q.index>0&&a.singleStacks===!1&&(ne.points[se][0]=ne.points[a.index+","+he+",0"][0])):ne.points[se]=ne.points[a.index]=null,d==="percent"?(ie=te?W:U,j&&X[ie]&&X[ie][he]?(ie=X[ie][he],ne.total=ie.total=Math.max(ie.total,ne.total)+Math.abs(ue)||0):ne.total=correctFloat$9(ne.total+(Math.abs(ue)||0))):d==="group"?(isArray$h(ue)&&(ue=ue[0]),ue!==null&&(ne.total=(ne.total||0)+1)):ne.total=correctFloat$9(ne.total+(ue||0)),d==="group"?ne.cumulative=(ne.total||1)-1:ne.cumulative=pick$1m(ne.cumulative,$)+(ue||0),ue!==null&&(ne.points[se].push(ne.cumulative),C[de]=ne.cumulative,ne.hasValidPoints=!0);d==="percent"&&(q.stacking.usePercentage=!0),d!=="group"&&(this.stackedYData=C),q.stacking.oldStacks={}}};Series$f.prototype.modifyStacks=function(){var v=this,d=v.yAxis,a=v.stackKey,p=d.stacking.stacks,y=v.processedXData,C,P=v.options.stacking;v[P+"Stacker"]&&[a,"-"+a].forEach(function(z){for(var L=y.length,$,N,W;L--;)$=y[L],C=v.getStackIndicator(C,$,v.index,z),N=p[z]&&p[z][$],W=N&&N.points[C.key],W&&v[P+"Stacker"](W,N,L)})};Series$f.prototype.percentStacker=function(v,d,a){var p=d.total?100/d.total:0;v[0]=correctFloat$9(v[0]*p),v[1]=correctFloat$9(v[1]*p),this.stackedYData[a]=v[1]};Series$f.prototype.getStackIndicator=function(v,d,a,p){return!defined$J(v)||v.x!==d||p&&v.key!==p?v={x:d,index:0,key:p}:v.index++,v.key=[a,d,v.index].join(","),v};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$X=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defined$I=Utilities.defined,merge$1e=Utilities.merge,LineSeries$5=(function(v){__extends$X(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){var a=this,p=this.options,y=(this.gappedPath||this.getGraphPath).call(this),C=this.chart.styledMode,P=[["graph","highcharts-graph"]];C||P[0].push(p.lineColor||this.color||palette.neutralColor20,p.dashStyle),P=a.getZonesGraphs(P),P.forEach(function(z,L){var $=z[0],N,W=a[$],U=W?"animate":"attr";W?(W.endX=a.preventGraphAnimation?null:y.xMap,W.animate({d:y})):y.length&&(a[$]=W=a.chart.renderer.path(y).addClass(z[1]).attr({zIndex:1}).add(a.group)),W&&!C&&(N={stroke:z[2],"stroke-width":p.lineWidth,fill:a.fillGraph&&a.color||"none"},z[3]?N.dashstyle=z[3]:p.linecap!=="square"&&(N["stroke-linecap"]=N["stroke-linejoin"]="round"),W[U](N).shadow(L<2&&p.shadow)),W&&(W.startX=y.xMap,W.isArea=y.isArea)})},d.prototype.getGraphPath=function(a,p,y){var C=this,P=C.options,z=[],L=[],$,N=P.step;a=a||C.points;var W=a.reversed;return W&&a.reverse(),N={right:1,center:2}[N]||N&&3,N&&W&&(N=4-N),a=this.getValidPoints(a,!1,!(P.connectNulls&&!p&&!y)),a.forEach(function(U,j){var q=U.plotX,X=U.plotY,K=a[j-1],Q;(U.leftCliff||K&&K.rightCliff)&&!y&&($=!0),U.isNull&&!defined$I(p)&&j>0?$=!P.connectNulls:U.isNull&&!p?$=!0:(j===0||$?Q=[["M",U.plotX,U.plotY]]:C.getPointSpline?Q=[C.getPointSpline(a,U,j)]:N?(N===1?Q=[["L",K.plotX,X]]:N===2?Q=[["L",(K.plotX+q)/2,K.plotY],["L",(K.plotX+q)/2,X]]:Q=[["L",q,K.plotY]],Q.push(["L",q,X])):Q=[["L",q,X]],L.push(U.x),N&&(L.push(U.x),N===2&&L.push(U.x)),z.push.apply(z,Q),$=!1)}),z.xMap=L,C.graphPath=z,z},d.prototype.getZonesGraphs=function(a){return this.zones.forEach(function(p,y){var C=["zone-graph-"+y,"highcharts-graph highcharts-zone-graph-"+y+" "+(p.className||"")];this.chart.styledMode||C.push(p.color||this.color,p.dashStyle||this.options.dashStyle),a.push(C)},this),a},d.defaultOptions=merge$1e(Series$f.defaultOptions,{}),d})(Series$f);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$W=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1j=Utilities.extend,merge$1d=Utilities.merge,objectEach$l=Utilities.objectEach,pick$1l=Utilities.pick,AreaSeries$1=(function(v){__extends$W(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){this.areaPath=[],v.prototype.drawGraph.apply(this);var a=this,p=this.areaPath,y=this.options,C=this.zones,P=[["area","highcharts-area",this.color,y.fillColor]];C.forEach(function(z,L){P.push(["zone-area-"+L,"highcharts-area highcharts-zone-area-"+L+" "+z.className,z.color||a.color,z.fillColor||y.fillColor])}),P.forEach(function(z){var L=z[0],$=a[L],N=$?"animate":"attr",W={};$?($.endX=a.preventGraphAnimation?null:p.xMap,$.animate({d:p})):(W.zIndex=0,$=a[L]=a.chart.renderer.path(p).addClass(z[1]).add(a.group),$.isArea=!0),a.chart.styledMode||(W.fill=pick$1l(z[3],color$d(z[2]).setOpacity(pick$1l(y.fillOpacity,.75)).get())),$[N](W),$.startX=p.xMap,$.shiftUnit=y.step?2:1})},d.prototype.getGraphPath=function(a){var p=LineSeries$4.prototype.getGraphPath,y,C=this.options,P=C.stacking,z=this.yAxis,L,$,N=[],W=[],U=this.index,j,q,X,K=z.stacking.stacks[this.stackKey],Q=C.threshold,te=Math.round(z.getThreshold(C.threshold)),ne,ie,ae=pick$1l(C.connectNulls,P==="percent"),se=function(he,ue,me){var xe=a[he],we=P&&K[xe.x].points[U],ye=xe[me+"Null"]||0,Oe=xe[me+"Cliff"]||0,be,ke,ze=!0;Oe||ye?(be=(ye?we[0]:we[1])+Oe,ke=we[0]+Oe,ze=!!ye):!P&&a[ue]&&a[ue].isNull&&(be=ke=Q),typeof be<"u"&&(W.push({plotX:X,plotY:be===null?te:z.getThreshold(be),isNull:ze,isCliff:!0}),N.push({plotX:X,plotY:ke===null?te:z.getThreshold(ke),doCurve:!1}))};for(a=a||this.points,P&&(a=this.getStackPoints(a)),j=0;j<a.length;j++)P||(a[j].leftCliff=a[j].rightCliff=a[j].leftNull=a[j].rightNull=void 0),ne=a[j].isNull,X=pick$1l(a[j].rectPlotX,a[j].plotX),ie=P?pick$1l(a[j].yBottom,te):te,(!ne||ae)&&(ae||se(j,j-1,"left"),ne&&!P&&ae||(W.push(a[j]),N.push({x:j,plotX:X,plotY:ie})),ae||se(j,j+1,"right"));L=p.call(this,W,!0,!0),N.reversed=!0,$=p.call(this,N,!0,!0);var de=$[0];return de&&de[0]==="M"&&($[0]=["L",de[1],de[2]]),q=L.concat($),q.length&&q.push(["Z"]),y=p.call(this,W,!1,ae),q.xMap=L.xMap,this.areaPath=q,y},d.prototype.getStackPoints=function(a){var p=this,y=[],C=[],P=this.xAxis,z=this.yAxis,L=z.stacking.stacks[this.stackKey],$={},N=z.series,W=N.length,U=z.options.reversedStacks?1:-1,j=N.indexOf(p);if(a=a||this.points,this.options.stacking){for(var q=0;q<a.length;q++)a[q].leftNull=a[q].rightNull=void 0,$[a[q].x]=a[q];objectEach$l(L,function(K,Q){K.total!==null&&C.push(Q)}),C.sort(function(K,Q){return K-Q});var X=N.map(function(K){return K.visible});C.forEach(function(K,Q){var te=0,ne,ie;if($[K]&&!$[K].isNull)y.push($[K]),[-1,1].forEach(function(de){var he=de===1?"rightNull":"leftNull",ue=de===1?"rightCliff":"leftCliff",me=0,xe=L[C[Q+de]];if(xe)for(var we=j;we>=0&&we<W;){var ye=N[we].index;ne=xe.points[ye],ne||(ye===p.index?$[K][he]=!0:X[we]&&(ie=L[K].points[ye],ie&&(me-=ie[1]-ie[0]))),we+=U}$[K][ue]=me});else{for(var ae=j;ae>=0&&ae<W;){var se=N[ae].index;if(ne=L[K].points[se],ne){te=ne[1];break}ae+=U}te=pick$1l(te,0),te=z.translate(te,0,1,0,1),y.push({isNull:!0,plotX:P.translate(K,0,0,0,1),x:K,plotY:te,yBottom:te})}})}return y},d.defaultOptions=merge$1d(LineSeries$4.defaultOptions,{threshold:0}),d})(LineSeries$4);extend$1j(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$V=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$1c=Utilities.merge,pick$1k=Utilities.pick,SplineSeries$1=(function(v){__extends$V(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getPointSpline=function(a,p,y){var C=1.5,P=C+1,z=p.plotX||0,L=p.plotY||0,$=a[y-1],N=a[y+1],W,U,j,q,X;function K(se){return se&&!se.isNull&&se.doCurve!==!1&&!p.isCliff}if(K($)&&K(N)){var Q=$.plotX||0,te=$.plotY||0,ne=N.plotX||0,ie=N.plotY||0,ae=0;W=(C*z+Q)/P,U=(C*L+te)/P,j=(C*z+ne)/P,q=(C*L+ie)/P,j!==W&&(ae=(q-U)*(j-z)/(j-W)+L-q),U+=ae,q+=ae,U>te&&U>L?(U=Math.max(te,L),q=2*L-U):U<te&&U<L&&(U=Math.min(te,L),q=2*L-U),q>ie&&q>L?(q=Math.max(ie,L),U=2*L-q):q<ie&&q<L&&(q=Math.min(ie,L),U=2*L-q),p.rightContX=j,p.rightContY=q}return X=["C",pick$1k($.rightContX,$.plotX,0),pick$1k($.rightContY,$.plotY,0),pick$1k(W,z,0),pick$1k(U,L,0),z,L],$.rightContX=$.rightContY=void 0,X},d.defaultOptions=merge$1c(LineSeries$3.defaultOptions),d})(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$U=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),areaProto$1=AreaSeries$1.prototype,extend$1i=Utilities.extend,merge$1b=Utilities.merge,AreaSplineSeries=(function(v){__extends$U(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return d.defaultOptions=merge$1b(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),d})(SplineSeries$1);extend$1i(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$T=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),animObject$6=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$g=H.noop,clamp$f=Utilities.clamp,css$4=Utilities.css,defined$H=Utilities.defined,extend$1h=Utilities.extend,fireEvent$q=Utilities.fireEvent,isArray$g=Utilities.isArray,isNumber$D=Utilities.isNumber,merge$1a=Utilities.merge,pick$1j=Utilities.pick,objectEach$k=Utilities.objectEach,ColumnSeries$h=(function(v){__extends$T(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.borderWidth=void 0,a.data=void 0,a.group=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var p=this,y=this.yAxis,C=p.options,P=this.chart.inverted,z={},L=P?"translateX":"translateY",$,N;a?(z.scaleY=.001,N=clamp$f(y.toPixels(C.threshold),y.pos,y.pos+y.len),P?z.translateX=N-y.len:z.translateY=N,p.clipBox&&p.setClip(),p.group.attr(z)):($=Number(p.group.attr(L)),p.group.animate({scaleY:1},extend$1h(animObject$6(p.options.animation),{step:function(W,U){p.group&&(z[L]=$+U.pos*(y.pos-$),p.group.attr(z))}})))},d.prototype.init=function(a,p){v.prototype.init.apply(this,arguments);var y=this;a=y.chart,a.hasRendered&&a.series.forEach(function(C){C.type===y.type&&(C.isDirty=!0)})},d.prototype.getColumnMetrics=function(){var a=this,p=a.options,y=a.xAxis,C=a.yAxis,P=y.options.reversedStacks,z=y.reversed&&!P||!y.reversed&&P,L={},$,N=0;p.grouping===!1?N=1:a.chart.series.forEach(function(ne){var ie=ne.yAxis,ae=ne.options,se;ne.type===a.type&&(ne.visible||!a.chart.options.chart.ignoreHiddenSeries)&&C.len===ie.len&&C.pos===ie.pos&&(ae.stacking&&ae.stacking!=="group"?($=ne.stackKey,typeof L[$]>"u"&&(L[$]=N++),se=L[$]):ae.grouping!==!1&&(se=N++),ne.columnIndex=se)});var W=Math.min(Math.abs(y.transA)*(y.ordinal&&y.ordinal.slope||p.pointRange||y.closestPointRange||y.tickInterval||1),y.len),U=W*p.groupPadding,j=W-2*U,q=j/(N||1),X=Math.min(p.maxPointWidth||y.len,pick$1j(p.pointWidth,q*(1-2*p.pointPadding))),K=(q-X)/2,Q=(a.columnIndex||0)+(z?1:0),te=K+(U+Q*q-W/2)*(z?-1:1);return a.columnMetrics={width:X,offset:te,paddedWidth:q,columnCount:N},a.columnMetrics},d.prototype.crispCol=function(a,p,y,C){var P=this.chart,z=this.borderWidth,L=-(z%2?.5:0),$,N=z%2?.5:1;P.inverted&&P.renderer.isVML&&(N+=1),this.options.crisp&&($=Math.round(a+y)+L,a=Math.round(a)+L,y=$-a);var W=Math.round(p+C)+N,U=Math.abs(p)<=.5&&W>.5;return p=Math.round(p)+N,C=W-p,U&&C&&(p-=1,C+=1),{x:a,y:p,width:y,height:C}},d.prototype.adjustForMissingColumns=function(a,p,y,C){var P=this,z=this.options.stacking;if(!y.isNull&&C.columnCount>1){var L=0,$=0;objectEach$k(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(W){if(typeof y.x=="number"){var U=W[y.x.toString()];if(U){var j=U.points[P.index],q=U.total;z?(j&&(L=$),U.hasValidPoints&&$++):isArray$g(j)&&(L=j[1],$=q||0)}}});var N=($-1)*C.paddedWidth+p;a=(y.plotX||0)+N/2-p-L*C.paddedWidth}return a},d.prototype.translate=function(){var a=this,p=a.chart,y=a.options,C=a.dense=a.closestPointRange*a.xAxis.transA<2,P=a.borderWidth=pick$1j(y.borderWidth,C?0:1),z=a.xAxis,L=a.yAxis,$=y.threshold,N=a.translatedThreshold=L.getThreshold($),W=pick$1j(y.minPointLength,5),U=a.getColumnMetrics(),j=U.width,q=a.pointXOffset=U.offset,X=a.dataMin,K=a.dataMax,Q=a.barW=Math.max(j,1+2*P);p.inverted&&(N-=.5),y.pointPadding&&(Q=Math.ceil(Q)),Series$f.prototype.translate.apply(a),a.points.forEach(function(te){var ne=pick$1j(te.yBottom,N),ie=999+Math.abs(ne),ae=te.plotX||0,se=clamp$f(te.plotY,-ie,L.len+ie),de,he=Math.min(se,ne),ue=Math.max(se,ne)-he,me=j,xe=ae+q,we=Q;W&&Math.abs(ue)<W&&(ue=W,de=!L.reversed&&!te.negative||L.reversed&&te.negative,isNumber$D($)&&isNumber$D(K)&&te.y===$&&K<=$&&(L.min||0)<$&&(X!==K||(L.max||0)<=$)&&(de=!de),he=Math.abs(he-N)>W?ne-W:N-(de?W:0)),defined$H(te.options.pointWidth)&&(me=we=Math.ceil(te.options.pointWidth),xe-=Math.round((me-j)/2)),y.centerInCategory&&(xe=a.adjustForMissingColumns(xe,me,te,U)),te.barX=xe,te.pointWidth=me,te.tooltipPos=p.inverted?[clamp$f(L.len+L.pos-p.plotLeft-se,L.pos-p.plotLeft,L.len+L.pos-p.plotLeft),z.len+z.pos-p.plotTop-xe-we/2,ue]:[z.left-p.plotLeft+xe+we/2,clamp$f(se+L.pos-p.plotTop,L.pos-p.plotTop,L.len+L.pos-p.plotTop),ue],te.shapeType=a.pointClass.prototype.shapeType||"rect",te.shapeArgs=a.crispCol.apply(a,te.isNull?[xe,N,we,0]:[xe,he,we,ue])})},d.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},d.prototype.pointAttribs=function(a,p){var y=this.options,C=this.pointAttrToOptions||{},P=C.stroke||"borderColor",z=C["stroke-width"]||"borderWidth",L,$,N,W=a&&a.color||this.color,U=a&&a[P]||y[P]||W,j=a&&a.options.dashStyle||y.dashStyle,q=a&&a[z]||y[z]||this[z]||0,X=pick$1j(a&&a.opacity,y.opacity,1);a&&this.zones.length&&($=a.getZone(),W=a.options.color||$&&($.color||a.nonZonedColor)||this.color,$&&(U=$.borderColor||U,j=$.dashStyle||j,q=$.borderWidth||q)),p&&a&&(L=merge$1a(y.states[p],a.options.states&&a.options.states[p]||{}),N=L.brightness,W=L.color||typeof N<"u"&&color$c(W).brighten(L.brightness).get()||W,U=L[P]||U,q=L[z]||q,j=L.dashStyle||j,X=pick$1j(L.opacity,X));var K={fill:W,stroke:U,"stroke-width":q,opacity:X};return j&&(K.dashstyle=j),K},d.prototype.drawPoints=function(){var a=this,p=this.chart,y=a.options,C=p.renderer,P=y.animationLimit||250,z;a.points.forEach(function(L){var $=L.plotY,N=L.graphic,W=!!N,U=N&&p.pointCount<P?"animate":"attr";isNumber$D($)&&L.y!==null?(z=L.shapeArgs,N&&L.hasNewShapeType()&&(N=N.destroy()),a.enabledDataSorting&&(L.startXPos=a.xAxis.reversed?-(z&&z.width||0):a.xAxis.width),N||(L.graphic=N=C[L.shapeType](z).add(L.group||a.group),N&&a.enabledDataSorting&&p.hasRendered&&p.pointCount<P&&(N.attr({x:L.startXPos}),W=!0,U="animate")),N&&W&&N[U](merge$1a(z)),y.borderRadius&&N[U]({r:y.borderRadius}),p.styledMode||N[U](a.pointAttribs(L,L.selected&&"select")).shadow(L.allowShadow!==!1&&y.shadow,null,y.stacking&&!y.borderRadius),N&&(N.addClass(L.getClassName(),!0),N.attr({visibility:L.visible?"inherit":"hidden"}))):N&&(L.graphic=N.destroy())})},d.prototype.drawTracker=function(){var a=this,p=a.chart,y=p.pointer,C=function(z){var L=y.getPointFromEvent(z);typeof L<"u"&&(y.isDirectTouch=!0,L.onMouseOver(z))},P;a.points.forEach(function(z){P=isArray$g(z.dataLabels)?z.dataLabels:z.dataLabel?[z.dataLabel]:[],z.graphic&&(z.graphic.element.point=z),P.forEach(function(L){L.div?L.div.point=z:L.element.point=z})}),a._hasTracking||(a.trackerGroups.forEach(function(z){a[z]&&(a[z].addClass("highcharts-tracker").on("mouseover",C).on("mouseout",function(L){y.onTrackerMouseOut(L)}),hasTouch$1&&a[z].on("touchstart",C),!p.styledMode&&a.options.cursor&&a[z].css(css$4).css({cursor:a.options.cursor}))}),a._hasTracking=!0),fireEvent$q(this,"afterDrawTracker")},d.prototype.remove=function(){var a=this,p=a.chart;p.hasRendered&&p.series.forEach(function(y){y.type===a.type&&(y.isDirty=!0)}),Series$f.prototype.remove.apply(a,arguments)},d.defaultOptions=merge$1a(Series$f.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),d})(Series$f);extend$1h(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$g,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$9=FormatUtilities.format,defined$G=Utilities.defined,extend$1g=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$f=Utilities.isArray,merge$19=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1i=Utilities.pick,splat$d=Utilities.splat,DataLabel;(function(v){var d=[];function a($,N,W,U,j){var q=this,X=this.chart,K=this.isCartesian&&X.inverted,Q=this.enabledDataSorting,te=pick$1i($.dlBox&&$.dlBox.centerX,$.plotX,-9999),ne=pick$1i($.plotY,-9999),ie=N.getBBox(),ae=W.rotation,se=W.align,de=X.isInsidePlot(te,Math.round(ne),{inverted:K,paneCoordinates:!0,series:q}),he=function(ke){Q&&q.xAxis&&!Oe&&q.setDataLabelStartPos($,N,j,de,ke)},ue,me,xe,we,ye,Oe=pick$1i(W.overflow,Q?"none":"justify")==="justify",be=this.visible&&$.visible!==!1&&($.series.forceDL||Q&&!Oe||de||pick$1i(W.inside,!!this.options.stacking)&&U&&X.isInsidePlot(te,K?U.x+1:U.y+U.height-1,{inverted:K,paneCoordinates:!0,series:q}));be&&(ue=X.renderer.fontMetrics(X.styledMode?void 0:W.style.fontSize,N).b,U=extend$1g({x:K?this.yAxis.len-ne:te,y:Math.round(K?this.xAxis.len-te:ne),width:0,height:0},U),extend$1g(W,{width:ie.width,height:ie.height}),ae?(Oe=!1,we=X.renderer.rotCorr(ue,ae),ye={x:U.x+(W.x||0)+U.width/2+we.x,y:U.y+(W.y||0)+{top:0,middle:.5,bottom:1}[W.verticalAlign]*U.height},he(ye),N[j?"attr":"animate"](ye).attr({align:se}),me=(ae+720)%360,xe=me>180&&me<360,se==="left"?ye.y-=xe?ie.height:0:se==="center"?(ye.x-=ie.width/2,ye.y-=ie.height/2):se==="right"&&(ye.x-=ie.width,ye.y-=xe?0:ie.height),N.placed=!0,N.alignAttr=ye):(he(U),N.align(W,void 0,U),ye=N.alignAttr),Oe&&U.height>=0?this.justifyDataLabel(N,W,ye,ie,U,j):pick$1i(W.crop,!0)&&(be=X.isInsidePlot(ye.x,ye.y,{paneCoordinates:!0,series:q})&&X.isInsidePlot(ye.x+ie.width,ye.y+ie.height,{paneCoordinates:!0,series:q})),W.shape&&!ae&&N[j?"attr":"animate"]({anchorX:K?X.plotWidth-$.plotY:$.plotX,anchorY:K?X.plotHeight-$.plotX:$.plotY})),j&&Q&&(N.placed=!1),!be&&(!Q||Oe)&&(N.hide(!0),N.placed=!1)}function p($,N){var W=N.filter;if(W){var U=W.operator,j=$[W.property],q=W.value;return U===">"&&j>q||U==="<"&&j<q||U===">="&&j>=q||U==="<="&&j<=q||U==="=="&&j==q||U==="==="&&j===q}return!0}function y($){if(d.indexOf($)===-1){var N=$.prototype;d.push($),N.alignDataLabel=a,N.drawDataLabels=C,N.justifyDataLabel=P,N.setDataLabelStartPos=L}}v.compose=y;function C(){var $=this,N=$.chart,W=$.options,U=$.points,j=$.hasRendered||0,q=N.renderer,X=W.dataLabels,K,Q,te=X.animation,ne=X.defer?getDeferredAnimation$1(N,te,$):{defer:0,duration:0};if(X=z(z(N.options.plotOptions&&N.options.plotOptions.series&&N.options.plotOptions.series.dataLabels,N.options.plotOptions&&N.options.plotOptions[$.type]&&N.options.plotOptions[$.type].dataLabels),X),fireEvent$p(this,"drawDataLabels"),isArray$f(X)||X.enabled||$._hasPointLabels){if(Q=$.plotGroup("dataLabelsGroup","data-labels",j?"inherit":"hidden",X.zIndex||6),Q.attr({opacity:+j}),!j){var ie=$.dataLabelsGroup;ie&&($.visible&&Q.show(!0),ie[W.animation?"animate":"attr"]({opacity:1},ne))}U.forEach(function(ae){K=splat$d(z(X,ae.dlOptions||ae.options&&ae.options.dataLabels)),K.forEach(function(se,de){var he=se.enabled&&(!ae.isNull||ae.dataLabelOnNull)&&p(ae,se),ue=ae.connectors?ae.connectors[de]:ae.connector,me,xe,we,ye,Oe,be,ke=ae.dataLabels?ae.dataLabels[de]:ae.dataLabel,ze=pick$1i(se.distance,ae.labelDistance),Ae=!ke;he&&(me=ae.getLabelConfig(),xe=pick$1i(se[ae.formatPrefix+"Format"],se.format),we=defined$G(xe)?format$9(xe,me,N):(se[ae.formatPrefix+"Formatter"]||se.formatter).call(me,se),ye=se.style,Oe=se.rotation,N.styledMode||(ye.color=pick$1i(se.color,ye.color,$.color,palette.neutralColor100),ye.color==="contrast"?(ae.contrastColor=q.getContrast(ae.color||$.color),ye.color=!defined$G(ze)&&se.inside||ze<0||W.stacking?ae.contrastColor:palette.neutralColor100):delete ae.contrastColor,W.cursor&&(ye.cursor=W.cursor)),be={r:se.borderRadius||0,rotation:Oe,padding:se.padding,zIndex:1},N.styledMode||(be.fill=se.backgroundColor,be.stroke=se.borderColor,be["stroke-width"]=se.borderWidth),objectEach$j(be,function(Be,He){typeof Be>"u"&&delete be[He]})),ke&&(!he||!defined$G(we))?(ae.dataLabel=ae.dataLabel&&ae.dataLabel.destroy(),ae.dataLabels&&(ae.dataLabels.length===1?delete ae.dataLabels:delete ae.dataLabels[de]),de||delete ae.dataLabel,ue&&(ae.connector=ae.connector.destroy(),ae.connectors&&(ae.connectors.length===1?delete ae.connectors:delete ae.connectors[de]))):he&&defined$G(we)&&(ke?be.text=we:(ae.dataLabels=ae.dataLabels||[],ke=ae.dataLabels[de]=Oe?q.text(we,0,-9999,se.useHTML).addClass("highcharts-data-label"):q.label(we,0,-9999,se.shape,null,null,se.useHTML,null,"data-label"),de||(ae.dataLabel=ke),ke.addClass(" highcharts-data-label-color-"+ae.colorIndex+" "+(se.className||"")+(se.useHTML?" highcharts-tracker":""))),ke.options=se,ke.attr(be),N.styledMode||ke.css(ye).shadow(se.shadow),ke.added||ke.add(Q),se.textPath&&!se.useHTML&&(ke.setTextPath(ae.getDataLabelPath&&ae.getDataLabelPath(ke)||ae.graphic,se.textPath),ae.dataLabelPath&&!se.textPath.enabled&&(ae.dataLabelPath=ae.dataLabelPath.destroy())),$.alignDataLabel(ae,ke,se,null,Ae))})})}fireEvent$p(this,"afterDrawDataLabels")}function P($,N,W,U,j,q){var X=this.chart,K=N.align,Q=N.verticalAlign,te=$.box?0:$.padding||0,ne=N.x,ie=ne===void 0?0:ne,ae=N.y,se=ae===void 0?0:ae,de,he;return de=(W.x||0)+te,de<0&&(K==="right"&&ie>=0?(N.align="left",N.inside=!0):ie-=de,he=!0),de=(W.x||0)+U.width-te,de>X.plotWidth&&(K==="left"&&ie<=0?(N.align="right",N.inside=!0):ie+=X.plotWidth-de,he=!0),de=W.y+te,de<0&&(Q==="bottom"&&se>=0?(N.verticalAlign="top",N.inside=!0):se-=de,he=!0),de=(W.y||0)+U.height-te,de>X.plotHeight&&(Q==="top"&&se<=0?(N.verticalAlign="bottom",N.inside=!0):se+=X.plotHeight-de,he=!0),he&&(N.x=ie,N.y=se,$.placed=!q,$.align(N,void 0,j)),he}function z($,N){var W=[],U;if(isArray$f($)&&!isArray$f(N))W=$.map(function(j){return merge$19(j,N)});else if(isArray$f(N)&&!isArray$f($))W=N.map(function(j){return merge$19($,j)});else if(!isArray$f($)&&!isArray$f(N))W=merge$19($,N);else for(U=Math.max($.length,N.length);U--;)W[U]=merge$19($[U],N[U]);return W}function L($,N,W,U,j){var q=this.chart,X=q.inverted,K=this.xAxis,Q=K.reversed,te=X?N.height/2:N.width/2,ne=$.pointWidth,ie=ne?ne/2:0;N.startXPos=X?j.x:Q?-te-ie:K.width-te+ie,N.startYPos=X?Q?this.yAxis.height-te+ie:-te-ie:j.y,U?N.visibility==="hidden"&&(N.show(),N.attr({opacity:0}).animate({opacity:1})):N.attr({opacity:1}).animate({opacity:0},void 0,N.hide),q.hasRendered&&(W&&N.attr({x:N.startXPos,y:N.startYPos}),N.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$e=SeriesRegistry$1.series,merge$18=Utilities.merge,pick$1h=Utilities.pick,ColumnDataLabel$1;(function(v){var d=[];function a(y,C,P,z,L){var $=this.chart.inverted,N=y.series,W=y.dlBox||y.shapeArgs,U=pick$1h(y.below,y.plotY>pick$1h(this.translatedThreshold,N.yAxis.len)),j=pick$1h(P.inside,!!this.options.stacking),q;W&&(z=merge$18(W),z.y<0&&(z.height+=z.y,z.y=0),q=z.y+z.height-N.yAxis.len,q>0&&q<z.height&&(z.height-=q),$&&(z={x:N.yAxis.len-z.y-z.height,y:N.xAxis.len-z.x-z.width,width:z.height,height:z.width}),j||($?(z.x+=U?0:z.width,z.width=0):(z.y+=U?z.height:0,z.height=0))),P.align=pick$1h(P.align,!$||j?"center":U?"right":"left"),P.verticalAlign=pick$1h(P.verticalAlign,$||j?"middle":U?"top":"bottom"),Series$e.prototype.alignDataLabel.call(this,y,C,P,z,L),P.inside&&y.contrastColor&&C.css({color:y.contrastColor})}function p(y){DataLabel$1.compose(Series$e),d.indexOf(y)===-1&&(d.push(y),y.prototype.alignDataLabel=a)}v.compose=p})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$S=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),extend$1f=Utilities.extend,merge$17=Utilities.merge,BarSeries=(function(v){__extends$S(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.defaultOptions=merge$17(ColumnSeries$h.defaultOptions,{}),d})(ColumnSeries$h);extend$1f(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$R=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),addEvent$W=Utilities.addEvent,extend$1e=Utilities.extend,merge$16=Utilities.merge,ScatterSeries$4=(function(v){__extends$R(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.applyJitter=function(){var a=this,p=this.options.jitter,y=this.points.length;function C(P){var z=Math.sin(P)*1e4;return z-Math.floor(z)}p&&this.points.forEach(function(P,z){["x","y"].forEach(function(L,$){var N,W="plot"+L.toUpperCase(),U,j,q;p[L]&&!P.isNull&&(N=a[L+"Axis"],q=p[L]*N.transA,N&&!N.isLog&&(U=Math.max(0,P[W]-q),j=Math.min(N.len,P[W]+q),P[W]=U+(j-U)*C(z+$*y),L==="x"&&(P.clientX=P.plotX)))})})},d.prototype.drawGraph=function(){this.options.lineWidth?v.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},d.defaultOptions=merge$16(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),d})(LineSeries$5);extend$1e(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$W(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$C=Utilities.isNumber,pick$1g=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$5=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var v=this.options,d=this.chart,a=2*(v.slicedOffset||0),p,y=d.plotWidth-2*a,C=d.plotHeight-2*a,P=v.center,z=Math.min(y,C),L=v.size,$=v.innerSize||0,N,W,U;for(typeof L=="string"&&(L=parseFloat(L)),typeof $=="string"&&($=parseFloat($)),N=[pick$1g(P[0],"50%"),pick$1g(P[1],"50%"),pick$1g(L&&L<0?void 0:v.size,"100%"),pick$1g($&&$<0?void 0:v.innerSize||0,"0%")],d.angular&&!(this instanceof Series$f)&&(N[3]=0),W=0;W<4;++W)U=N[W],p=W<2||W===2&&/%$/.test(U),N[W]=relativeLength$6(U,[y,C,z,N[2]][W])+(p?a:0);return N[3]>N[2]&&(N[3]=N[2]),N},getStartAndEndRadians:function(v,d){var a=isNumber$C(v)?v:0,p=isNumber$C(d)&&d>a&&d-a<360?d:a+360,y=-90;return{start:deg2rad$5*(a+y),end:deg2rad$5*(p+y)}}},__extends$Q=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),setAnimation$1=animationExports.setAnimation,addEvent$V=Utilities.addEvent,defined$F=Utilities.defined,extend$1d=Utilities.extend,isNumber$B=Utilities.isNumber,pick$1f=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=(function(v){__extends$Q(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.labelDistance=void 0,a.options=void 0,a.series=void 0,a}return d.prototype.getConnectorPath=function(){var a=this.labelPosition,p=this.series.options.dataLabels,y=this.connectorShapes,C=p.connectorShape;return y[C]&&(C=y[C]),C.call(this,{x:a.final.x,y:a.final.y,alignment:a.alignment},a.connectorPosition,p)},d.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},d.prototype.haloPath=function(a){var p=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(p.x,p.y,p.r+a,p.r+a,{innerR:p.r-1,start:p.start,end:p.end})},d.prototype.init=function(){var a=this;v.prototype.init.apply(this,arguments),this.name=pick$1f(this.name,"Slice");var p=function(y){a.slice(y.type==="select")};return addEvent$V(this,"select",p),addEvent$V(this,"unselect",p),this},d.prototype.isValid=function(){return isNumber$B(this.y)&&this.y>=0},d.prototype.setVisible=function(a,p){var y=this,C=this.series,P=C.chart,z=C.options.ignoreHiddenPoint;p=pick$1f(p,z),a!==this.visible&&(this.visible=this.options.visible=a=typeof a>"u"?!this.visible:a,C.options.data[C.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(L){y[L]&&y[L][a?"show":"hide"](a)}),this.legendItem&&P.legend.colorizeItem(this,a),!a&&this.state==="hover"&&this.setState(""),z&&(C.isDirty=!0),p&&P.redraw())},d.prototype.slice=function(a,p,y){var C=this.series,P=C.chart;setAnimation$1(y,P),p=pick$1f(p,!0),this.sliced=this.options.sliced=a=defined$F(a)?a:!this.sliced,C.options.data[C.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},d})(Point$4);extend$1d(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(v,d,a){var p=d.breakAt,y=d.touchingSliceAt,C=a.softConnector?["C",v.x+(v.alignment==="left"?-5:5),v.y,2*p.x-y.x,2*p.y-y.y,p.x,p.y]:["L",p.x,p.y];return[["M",v.x,v.y],C,["L",y.x,y.y]]},straight:function(v,d){var a=d.touchingSliceAt;return[["M",v.x,v.y],["L",a.x,a.y]]},crookedLine:function(v,d,a){var p=d.touchingSliceAt,y=this.series,C=y.center[0],P=y.chart.plotWidth,z=y.chart.plotLeft,L=v.alignment,$=this.shapeArgs.r,N=relativeLength$5(a.crookDistance,1),W=L==="left"?C+$+(P+z-C-$)*(1-N):z+(C-$)*N,U=["L",W,v.y],j=!0;(L==="left"?W>v.x||W<p.x:W<v.x||W>p.x)&&(j=!1);var q=[["M",v.x,v.y]];return j&&q.push(U),q.push(["L",p.x,p.y]),q}}});var __extends$P=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$f=H.noop,clamp$e=Utilities.clamp,extend$1c=Utilities.extend,fireEvent$o=Utilities.fireEvent,merge$15=Utilities.merge,pick$1e=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=(function(v){__extends$P(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.center=void 0,a.data=void 0,a.maxLabelDistance=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var p=this,y=p.points,C=p.startAngleRad;a||y.forEach(function(P){var z=P.graphic,L=P.shapeArgs;z&&L&&(z.attr({r:pick$1e(P.startR,p.center&&p.center[3]/2),start:C,end:C}),z.animate({r:L.r,start:L.start,end:L.end},p.options.animation))})},d.prototype.drawEmpty=function(){var a=this.startAngleRad,p=this.endAngleRad,y=this.options,C,P;this.total===0&&this.center?(C=this.center[0],P=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(C,P,this.center[1]/2,0,a,p).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(C,P,this.center[2]/2,0,{start:a,end:p,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":y.borderWidth,fill:y.fillColor||"none",stroke:y.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},d.prototype.drawPoints=function(){var a=this.chart.renderer;this.points.forEach(function(p){p.graphic&&p.hasNewShapeType()&&(p.graphic=p.graphic.destroy()),p.graphic||(p.graphic=a[p.shapeType](p.shapeArgs).add(p.series.group),p.delayedRendering=!0)})},d.prototype.generatePoints=function(){v.prototype.generatePoints.call(this),this.updateTotals()},d.prototype.getX=function(a,p,y){var C=this.center,P=this.radii?this.radii[y.index]||0:C[2]/2,z=Math.asin(clamp$e((a-C[1])/(P+y.labelDistance),-1,1)),L=C[0]+(p?-1:1)*(Math.cos(z)*(P+y.labelDistance))+(y.labelDistance>0?(p?-1:1)*this.options.dataLabels.padding:0);return L},d.prototype.hasData=function(){return!!this.processedXData.length},d.prototype.redrawPoints=function(){var a=this,p=a.chart,y=p.renderer,C=a.options.shadow,P,z,L,$;this.drawEmpty(),C&&!a.shadowGroup&&!p.styledMode&&(a.shadowGroup=y.g("shadow").attr({zIndex:-1}).add(a.group)),a.points.forEach(function(N){var W={};if(z=N.graphic,!N.isNull&&z){var U=void 0;$=N.shapeArgs,P=N.getTranslate(),p.styledMode||(U=N.shadowGroup,C&&!U&&(U=N.shadowGroup=y.g("shadow").add(a.shadowGroup)),U&&U.attr(P),L=a.pointAttribs(N,N.selected&&"select")),N.delayedRendering?(z.setRadialReference(a.center).attr($).attr(P),p.styledMode||z.attr(L).attr({"stroke-linejoin":"round"}).shadow(C,U),N.delayedRendering=!1):(z.setRadialReference(a.center),p.styledMode||merge$15(!0,W,L),merge$15(!0,W,$,P),z.animate(W)),z.attr({visibility:N.visible?"inherit":"hidden"}),z.addClass(N.getClassName(),!0)}else z&&(N.graphic=z.destroy())})},d.prototype.sortByAngle=function(a,p){a.sort(function(y,C){return typeof y.angle<"u"&&(C.angle-y.angle)*p})},d.prototype.translate=function(a){this.generatePoints();var p=this,y=1e3,C=p.options,P=C.slicedOffset,z=P+(C.borderWidth||0),L=getStartAndEndRadians(C.startAngle,C.endAngle),$=p.startAngleRad=L.start,N=p.endAngleRad=L.end,W=N-$,U=p.points,j=C.dataLabels.distance,q=C.ignoreHiddenPoint,X=U.length,K,Q,te,ne,ie,ae,se,de,he=0;for(a||(p.center=a=p.getCenter()),se=0;se<X;se++){de=U[se],Q=$+he*W,de.isValid()&&(!q||de.visible)&&(he+=de.percentage/100),te=$+he*W;var ue={x:a[0],y:a[1],r:a[2]/2,innerR:a[3]/2,start:Math.round(Q*y)/y,end:Math.round(te*y)/y};de.shapeType="arc",de.shapeArgs=ue,de.labelDistance=pick$1e(de.options.dataLabels&&de.options.dataLabels.distance,j),de.labelDistance=relativeLength$4(de.labelDistance,ue.r),p.maxLabelDistance=Math.max(p.maxLabelDistance||0,de.labelDistance),ne=(te+Q)/2,ne>1.5*Math.PI?ne-=2*Math.PI:ne<-Math.PI/2&&(ne+=2*Math.PI),de.slicedTranslation={translateX:Math.round(Math.cos(ne)*P),translateY:Math.round(Math.sin(ne)*P)},ie=Math.cos(ne)*a[2]/2,ae=Math.sin(ne)*a[2]/2,de.tooltipPos=[a[0]+ie*.7,a[1]+ae*.7],de.half=ne<-Math.PI/2||ne>Math.PI/2?1:0,de.angle=ne,K=Math.min(z,de.labelDistance/5),de.labelPosition={natural:{x:a[0]+ie+Math.cos(ne)*de.labelDistance,y:a[1]+ae+Math.sin(ne)*de.labelDistance},final:{},alignment:de.labelDistance<0?"center":de.half?"right":"left",connectorPosition:{breakAt:{x:a[0]+ie+Math.cos(ne)*K,y:a[1]+ae+Math.sin(ne)*K},touchingSliceAt:{x:a[0]+ie,y:a[1]+ae}}}}fireEvent$o(p,"afterTranslate")},d.prototype.updateTotals=function(){var a=this.points,p=a.length,y=this.options.ignoreHiddenPoint,C,P,z=0;for(C=0;C<p;C++)P=a[C],P.isValid()&&(!y||P.visible)&&(z+=P.y);for(this.total=z,C=0;C<p;C++)P=a[C],P.percentage=z>0&&(P.visible||!y)?P.y/z*100:0,P.total=z},d.defaultOptions=merge$15(Series$f.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),d})(Series$f);extend$1c(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$f,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$f,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$e=H.noop,distribute$1=R$1.distribute,Series$d=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$d=Utilities.clamp,defined$E=Utilities.defined,merge$14=Utilities.merge,pick$1d=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(v){var d=[],a={radialDistributionY:function(z){return z.top+z.distributeBox.pos},radialDistributionX:function(z,L,$,N){return z.getX($<L.top+2||$>L.bottom-2?N:$,L.half,L)},justify:function(z,L,$){return $[0]+(z.half?-1:1)*(L+z.labelDistance)},alignToPlotEdges:function(z,L,$,N){var W=z.getBBox().width;return L?W+N:$-W-N},alignToConnectors:function(z,L,$,N){var W=0,U;return z.forEach(function(j){U=j.dataLabel.getBBox().width,U>W&&(W=U)}),L?W+N:$-W-N}};function p(z){if(DataLabel$1.compose(Series$d),d.indexOf(z)===-1){d.push(z);var L=z.prototype;L.dataLabelPositioners=a,L.alignDataLabel=noop$e,L.drawDataLabels=y,L.placeDataLabels=C,L.verifyDataLabelOverflow=P}}v.compose=p;function y(){var z=this,L=z.data,$=z.chart,N=z.options.dataLabels||{},W=N.connectorPadding,U=$.plotWidth,j=$.plotHeight,q=$.plotLeft,X=Math.round($.chartWidth/3),K=z.center,Q=K[2]/2,te=K[1],ne=[[],[]],ie=[0,0,0,0],ae=z.dataLabelPositioners,se,de,he,ue,me,xe,we,ye,Oe,be,ke,ze;!z.visible||!N.enabled&&!z._hasPointLabels||(L.forEach(function(Ae){Ae.dataLabel&&Ae.visible&&Ae.dataLabel.shortened&&(Ae.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),Ae.dataLabel.shortened=!1)}),Series$d.prototype.drawDataLabels.apply(z),L.forEach(function(Ae){Ae.dataLabel&&(Ae.visible?(ne[Ae.half].push(Ae),Ae.dataLabel._pos=null,!defined$E(N.style.width)&&!defined$E(Ae.options.dataLabels&&Ae.options.dataLabels.style&&Ae.options.dataLabels.style.width)&&Ae.dataLabel.getBBox().width>X&&(Ae.dataLabel.css({width:Math.round(X*.7)+"px"}),Ae.dataLabel.shortened=!0)):(Ae.dataLabel=Ae.dataLabel.destroy(),Ae.dataLabels&&Ae.dataLabels.length===1&&delete Ae.dataLabels))}),ne.forEach(function(Ae,Be){var He=Ae.length,Fe=[],_e,pe,ge,Me,Pe,Le;if(He)for(z.sortByAngle(Ae,Be-.5),z.maxLabelDistance>0&&(_e=Math.max(0,te-Q-z.maxLabelDistance),pe=Math.min(te+Q+z.maxLabelDistance,$.plotHeight),Ae.forEach(function(Ne){Ne.labelDistance>0&&Ne.dataLabel&&(Ne.top=Math.max(0,te-Q-Ne.labelDistance),Ne.bottom=Math.min(te+Q+Ne.labelDistance,$.plotHeight),Pe=Ne.dataLabel.getBBox().height||21,Ne.distributeBox={target:Ne.labelPosition.natural.y-Ne.top+Pe/2,size:Pe,rank:Ne.y},Fe.push(Ne.distributeBox))}),Le=pe+Pe-_e,distribute$1(Fe,Le,Le/5)),ke=0;ke<He;ke++){if(se=Ae[ke],xe=se.labelPosition,ue=se.dataLabel,be=se.visible===!1?"hidden":"inherit",ge=xe.natural.y,Oe=ge,Fe&&defined$E(se.distributeBox)&&(typeof se.distributeBox.pos>"u"?be="hidden":(we=se.distributeBox.size,Oe=ae.radialDistributionY(se))),delete se.positionIndex,N.justify)ye=ae.justify(se,Q,K);else switch(N.alignTo){case"connectors":ye=ae.alignToConnectors(Ae,Be,U,q);break;case"plotEdges":ye=ae.alignToPlotEdges(ue,Be,U,q);break;default:ye=ae.radialDistributionX(z,se,Oe,ge)}ue._attr={visibility:be,align:xe.alignment},ze=se.options.dataLabels||{},ue._pos={x:ye+pick$1d(ze.x,N.x)+({left:W,right:-W}[xe.alignment]||0),y:Oe+pick$1d(ze.y,N.y)-10},xe.final.x=ye,xe.final.y=Oe,pick$1d(N.crop,!0)&&(me=ue.getBBox().width,Me=null,ye-me<W&&Be===1?(Me=Math.round(me-ye+W),ie[3]=Math.max(Me,ie[3])):ye+me>U-W&&Be===0&&(Me=Math.round(ye+me-U+W),ie[1]=Math.max(Me,ie[1])),Oe-we/2<0?ie[0]=Math.max(Math.round(-Oe+we/2),ie[0]):Oe+we/2>j&&(ie[2]=Math.max(Math.round(Oe+we/2-j),ie[2])),ue.sideOverflow=Me)}}),(arrayMax$6(ie)===0||this.verifyDataLabelOverflow(ie))&&(this.placeDataLabels(),this.points.forEach(function(Ae){if(ze=merge$14(N,Ae.options.dataLabels),de=pick$1d(ze.connectorWidth,1),de){var Be=void 0;he=Ae.connector,ue=Ae.dataLabel,ue&&ue._pos&&Ae.visible&&Ae.labelDistance>0?(be=ue._attr.visibility,Be=!he,Be&&(Ae.connector=he=$.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+Ae.colorIndex+(Ae.className?" "+Ae.className:"")).add(z.dataLabelsGroup),$.styledMode||he.attr({"stroke-width":de,stroke:ze.connectorColor||Ae.color||palette.neutralColor60})),he[Be?"attr":"animate"]({d:Ae.getConnectorPath()}),he.attr("visibility",be)):he&&(Ae.connector=he.destroy())}})))}function C(){this.points.forEach(function(z){var L=z.dataLabel,$;L&&z.visible&&($=L._pos,$?(L.sideOverflow&&(L._attr.width=Math.max(L.getBBox().width-L.sideOverflow,0),L.css({width:L._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),L.shortened=!0),L.attr(L._attr),L[L.moved?"animate":"attr"]($),L.moved=!0):L&&L.attr({y:-9999})),delete z.distributeBox},this)}function P(z){var L=this.center,$=this.options,N=$.center,W=$.minSize||80,U=W,j=$.size!==null;return j||(N[0]!==null?U=Math.max(L[2]-Math.max(z[1],z[3]),W):(U=Math.max(L[2]-z[1]-z[3],W),L[0]+=(z[3]-z[1])/2),N[1]!==null?U=clamp$d(U,W,L[2]-Math.max(z[0],z[2])):(U=clamp$d(U,W,L[2]-z[0]-z[2]),L[1]+=(z[0]-z[2])/2),U<L[2]?(L[2]=U,L[3]=Math.min(relativeLength$3($.innerSize||0,U),U),this.translate(L),this.drawDataLabels&&this.drawDataLabels()):j=!0),j}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$U=Utilities.addEvent,fireEvent$n=Utilities.fireEvent,isArray$e=Utilities.isArray,isNumber$A=Utilities.isNumber,objectEach$i=Utilities.objectEach,pick$1c=Utilities.pick;addEvent$U(Chart$1,"render",function v(){var d=this,a=[];(this.labelCollectors||[]).forEach(function(p){a=a.concat(p())}),(this.yAxis||[]).forEach(function(p){p.stacking&&p.options.stackLabels&&!p.options.stackLabels.allowOverlap&&objectEach$i(p.stacking.stacks,function(y){objectEach$i(y,function(C){C.label&&C.label.visibility!=="hidden"&&a.push(C.label)})})}),(this.series||[]).forEach(function(p){var y=p.options.dataLabels;if(p.visible&&!(y.enabled===!1&&!p._hasPointLabels)){var C=function(P){return P.forEach(function(z){if(z.visible){var L=isArray$e(z.dataLabels)?z.dataLabels:z.dataLabel?[z.dataLabel]:[];L.forEach(function($){var N=$.options;$.labelrank=pick$1c(N.labelrank,z.labelrank,z.shapeArgs&&z.shapeArgs.height),N.allowOverlap?($.oldOpacity=$.opacity,$.newOpacity=1,hideOrShow($,d)):a.push($)})}})};C(p.nodes||[]),C(p.points)}}),this.hideOverlappingLabels(a)});Chart$1.prototype.hideOverlappingLabels=function(v){var d=this,a=v.length,p=d.renderer,y,C,P,z,L,$,N,W=!1,U=function(q,X){return!(X.x>=q.x+q.width||X.x+X.width<=q.x||X.y>=q.y+q.height||X.y+X.height<=q.y)},j=function(q){var X,K,Q,te=q.box?0:q.padding||0,ne=0,ie=0,ae,se;if(q&&(!q.alignAttr||q.placed))return X=q.alignAttr||{x:q.attr("x"),y:q.attr("y")},K=q.parentGroup,q.width||(Q=q.getBBox(),q.width=Q.width,q.height=Q.height,ne=p.fontMetrics(null,q.element).h),ae=q.width-2*te,se={left:"0",center:"0.5",right:"1"}[q.alignValue],se?ie=+se*ae:isNumber$A(q.x)&&Math.round(q.x)!==q.translateX&&(ie=q.x-q.translateX),{x:X.x+(K.translateX||0)+te-(ie||0),y:X.y+(K.translateY||0)+te-ne,width:q.width-2*te,height:q.height-2*te}};for(C=0;C<a;C++)y=v[C],y&&(y.oldOpacity=y.opacity,y.newOpacity=1,y.absoluteBox=j(y));for(v.sort(function(q,X){return(X.labelrank||0)-(q.labelrank||0)}),C=0;C<a;C++)for(z=v[C],$=z&&z.absoluteBox,P=C+1;P<a;++P)L=v[P],N=L&&L.absoluteBox,$&&N&&z!==L&&z.newOpacity!==0&&L.newOpacity!==0&&U($,N)&&((z.labelrank<L.labelrank?z:L).newOpacity=0);v.forEach(function(q){hideOrShow(q,d)&&(W=!0)}),W&&fireEvent$n(d,"afterHideAllOverlappingLabels")};function hideOrShow(v,d){var a,p,y=!1;return v&&(p=v.newOpacity,v.oldOpacity!==p&&(v.alignAttr&&v.placed?(v[p?"removeClass":"addClass"]("highcharts-data-label-hidden"),a=function(){d.styledMode||v.css({pointerEvents:p?"auto":"none"})},y=!0,v.alignAttr.opacity=p,v[v.isOld?"animate":"attr"](v.alignAttr,null,a),fireEvent$n(d,"afterHideOverlappingLabel")):v.attr({opacity:p})),v.isOld=!0),y}var extend$1b=Utilities.extend,find$g=Utilities.find,isArray$d=Utilities.isArray,isObject$b=Utilities.isObject,merge$13=Utilities.merge,objectEach$h=Utilities.objectEach,pick$1b=Utilities.pick,splat$c=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(v){var d=[];function a(y){return d.indexOf(y)===-1&&(d.push(y),extend$1b(y.prototype,p.prototype)),y}v.compose=a;var p=(function(){function y(){}return y.prototype.currentOptions=function(C){var P=this,z={};function L($,N,W,U){var j;objectEach$h($,function(q,X){if(!U&&P.collectionsWithUpdate.indexOf(X)>-1&&N[X])for(q=splat$c(q),W[X]=[],j=0;j<Math.max(q.length,N[X].length);j++)N[X][j]&&(q[j]===void 0?W[X][j]=N[X][j]:(W[X][j]={},L(q[j],N[X][j],W[X][j],U+1)));else isObject$b(q)?(W[X]=isArray$d(q)?[]:{},L(q,N[X]||{},W[X],U+1)):typeof N[X]>"u"?W[X]=null:W[X]=N[X]})}return L(C,this.options,z,0),z},y.prototype.matchResponsiveRule=function(C,P){var z=C.condition,L=z.callback||function(){return this.chartWidth<=pick$1b(z.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$1b(z.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$1b(z.minWidth,0)&&this.chartHeight>=pick$1b(z.minHeight,0)};L.call(this)&&P.push(C._id)},y.prototype.setResponsive=function(C,P){var z=this,L=this.options.responsive,$=this.currentResponsive,N=[],W;!P&&L&&L.rules&&L.rules.forEach(function(q){typeof q._id>"u"&&(q._id=uniqueKey$3()),z.matchResponsiveRule(q,N)},this);var U=merge$13.apply(void 0,N.map(function(q){return find$g((L||{}).rules||[],function(X){return X._id===q})}).map(function(q){return q&&q.chartOptions}));U.isResponsiveOptions=!0,N=N.toString()||void 0;var j=$&&$.ruleIds;N!==j&&($&&this.update($.undoOptions,C,!0),N?(W=this.currentOptions(U),W.isResponsiveOptions=!0,this.currentResponsive={ruleIds:N,mergedOptions:U,undoOptions:W},this.update(U,C,!0)):this.currentResponsive=void 0)},y})()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$8=H;G$8.animate=animationExports.animate;G$8.animObject=animationExports.animObject;G$8.getDeferredAnimation=animationExports.getDeferredAnimation;G$8.setAnimation=animationExports.setAnimation;G$8.stop=animationExports.stop;G$8.timers=Fx.timers;G$8.AST=AST;G$8.Axis=Axis;G$8.Chart=Chart$1;G$8.chart=Chart$1.chart;G$8.Fx=Fx;G$8.Legend=Legend;G$8.PlotLineOrBand=PlotLineOrBand;G$8.Point=Point$4;G$8.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$8.Series=Series$f;G$8.SVGElement=SVGElement;G$8.SVGRenderer=SVGRenderer;G$8.Tick=Tick;G$8.Time=Time;G$8.Tooltip=Tooltip;G$8.Color=Color;G$8.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement$1.compose(SVGElement);G$8.defaultOptions=DefaultOptions.defaultOptions;G$8.getOptions=DefaultOptions.getOptions;G$8.time=DefaultOptions.defaultTime;G$8.setOptions=DefaultOptions.setOptions;G$8.dateFormat=FormatUtilities.dateFormat;G$8.format=FormatUtilities.format;G$8.numberFormat=FormatUtilities.numberFormat;G$8.addEvent=Utilities.addEvent;G$8.arrayMax=Utilities.arrayMax;G$8.arrayMin=Utilities.arrayMin;G$8.attr=Utilities.attr;G$8.clearTimeout=Utilities.clearTimeout;G$8.correctFloat=Utilities.correctFloat;G$8.createElement=Utilities.createElement;G$8.css=Utilities.css;G$8.defined=Utilities.defined;G$8.destroyObjectProperties=Utilities.destroyObjectProperties;G$8.discardElement=Utilities.discardElement;G$8.distribute=R$1.distribute;G$8.erase=Utilities.erase;G$8.error=Utilities.error;G$8.extend=Utilities.extend;G$8.extendClass=Utilities.extendClass;G$8.find=Utilities.find;G$8.fireEvent=Utilities.fireEvent;G$8.getMagnitude=Utilities.getMagnitude;G$8.getStyle=Utilities.getStyle;G$8.inArray=Utilities.inArray;G$8.isArray=Utilities.isArray;G$8.isClass=Utilities.isClass;G$8.isDOMElement=Utilities.isDOMElement;G$8.isFunction=Utilities.isFunction;G$8.isNumber=Utilities.isNumber;G$8.isObject=Utilities.isObject;G$8.isString=Utilities.isString;G$8.keys=Utilities.keys;G$8.merge=Utilities.merge;G$8.normalizeTickInterval=Utilities.normalizeTickInterval;G$8.objectEach=Utilities.objectEach;G$8.offset=Utilities.offset;G$8.pad=Utilities.pad;G$8.pick=Utilities.pick;G$8.pInt=Utilities.pInt;G$8.relativeLength=Utilities.relativeLength;G$8.removeEvent=Utilities.removeEvent;G$8.seriesType=SeriesRegistry$1.seriesType;G$8.splat=Utilities.splat;G$8.stableSort=Utilities.stableSort;G$8.syncTimeout=Utilities.syncTimeout;G$8.timeUnits=Utilities.timeUnits;G$8.uniqueKey=Utilities.uniqueKey;G$8.useSerialIds=Utilities.useSerialIds;G$8.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$f);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$T=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$D=Utilities.defined,error$5=Utilities.error,pick$1a=Utilities.pick,timeUnits$1=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(v){function d(q,X,K){if(composedClasses.indexOf(q)===-1){composedClasses.push(q);var Q=q.prototype;Q.getTimeTicks=a,Q.index2val=p,Q.lin2val=y,Q.val2lin=U,Q.ordinal2lin=Q.val2lin,addEvent$T(q,"afterInit",P),addEvent$T(q,"foundExtremes",z),addEvent$T(q,"afterSetScale",L),addEvent$T(q,"initialAxisTranslation",$)}return composedClasses.indexOf(K)===-1&&(composedClasses.push(K),addEvent$T(K,"pan",N)),composedClasses.indexOf(X)===-1&&(composedClasses.push(X),addEvent$T(X,"updatedData",W)),q}v.compose=d;function a(q,X,K,Q,te,ne,ie){te===void 0&&(te=[]),ne===void 0&&(ne=0);var ae={},se=this.options.tickPixelInterval,de=this.chart.time,he=[],ue,me,xe,we,ye,Oe=0,be=[],ke=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!te||te.length<3||typeof X>"u")return de.getTimeTicks.apply(de,arguments);var ze=te.length;for(ue=0;ue<ze;ue++){if(ye=ue&&te[ue-1]>K,te[ue]<X&&(Oe=ue),ue===ze-1||te[ue+1]-te[ue]>ne*5||ye){if(te[ue]>ke){for(me=de.getTimeTicks(q,te[Oe],te[ue],Q);me.length&&me[0]<=ke;)me.shift();me.length&&(ke=me[me.length-1]),he.push(be.length),be=be.concat(me)}Oe=ue+1}if(ye)break}if(me){if(we=me.info,ie&&we.unitRange<=timeUnits$1.hour){for(ue=be.length-1,Oe=1;Oe<ue;Oe++)de.dateFormat("%d",be[Oe])!==de.dateFormat("%d",be[Oe-1])&&(ae[be[Oe]]="day",xe=!0);xe&&(ae[be[0]]="day"),we.higherRanks=ae}we.segmentStarts=he,be.info=we}else error$5(12,!1,this.chart);if(ie&&defined$D(se)){for(var Ae=be.length,Be=[],He=[],Fe=void 0,_e=void 0,pe=void 0,ge=void 0,Me=void 0,Pe=Ae;Pe--;)_e=this.translate(be[Pe]),pe&&(He[Pe]=pe-_e),Be[Pe]=pe=_e;for(He.sort(),ge=He[Math.floor(He.length/2)],ge<se*.6&&(ge=null),Pe=be[Ae-1]>K?Ae-1:Ae,pe=void 0;Pe--;)_e=Be[Pe],Me=Math.abs(pe-_e),pe&&Me<se*.8&&(ge===null||Me<ge*.8)?(ae[be[Pe]]&&!ae[be[Pe+1]]?(Fe=Pe+1,pe=_e):Fe=Pe,be.splice(Fe,1)):pe=_e}return be}function p(q){var X=this,K=X.ordinal,Q=K.positions;if(!Q)return q;var te=Q.length-1,ne;return q<0?q=Q[0]:q>te?q=Q[te]:(te=Math.floor(q),ne=q-te),typeof ne<"u"&&typeof Q[te]<"u"?Q[te]+(ne?ne*(Q[te+1]-Q[te]):0):q}function y(q){var X=this,K=X.ordinal,Q=X.old?X.old.min:X.min,te=X.old?X.old.transA:X.transA,ne=K.positions;if(!ne)return q;var ie=(q-Q)*te+X.minPixelPadding,ae=ie>0&&ie<X.left+X.len;if(ae||(K.extendedOrdinalPositions||(K.extendedOrdinalPositions=K.getExtendedPositions()),ne=K.extendedOrdinalPositions),ne&&ne.length){var se=K.getIndexOfPoint(ie,ne),de=correctFloat$8(se%1);if(se>=0&&se<ne.length){var he=ne[Math.floor(se)],ue=ne[Math.ceil(se)],me=ue-he;return ne[Math.floor(se)]+de*me}var xe=ne.length,we=ne[0],ye=ne[xe-1],Oe=(ye-we)/(xe-1);return se<0?we+Oe*se:ye+Oe*(se-xe)}return q}function C(q,X){var K=v.Additions.findIndexOf(q,X,!0);if(q[K]===X)return K;var Q=(X-q[K])/(q[K+1]-q[K]);return K+Q}function P(){var q=this;q.ordinal||(q.ordinal=new v.Additions(q))}function z(){var q=this;q.isXAxis&&defined$D(q.options.overscroll)&&q.max===q.dataMax&&(!q.chart.mouseIsDown||q.isInternal)&&(!q.eventArgs||q.eventArgs&&q.eventArgs.trigger!=="navigator")&&(q.max+=q.options.overscroll,!q.isInternal&&defined$D(q.userMin)&&(q.min+=q.options.overscroll))}function L(){var q=this;q.horiz&&!q.isDirty&&(q.isDirty=q.isOrdinal&&q.chart.navigator&&!q.chart.navigator.adaptToUpdatedData)}function $(){var q=this;q.ordinal&&(q.ordinal.beforeSetTickPositions(),q.tickInterval=q.ordinal.postProcessTickInterval(q.tickInterval))}function N(q){var X=this,K=X.xAxis[0],Q=K.options.overscroll,te=q.originalEvent.chartX,ne=X.options.chart.panning,ie=!1;if(ne&&ne.type!=="y"&&K.options.ordinal&&K.series.length){var ae=X.mouseDownX,se=K.getExtremes(),de=se.dataMax,he=se.min,ue=se.max,me=X.hoverPoints,xe=K.closestPointRange||K.ordinal&&K.ordinal.overscrollPointsRange,we=K.translationSlope*(K.ordinal.slope||xe),ye=(ae-te)/we,Oe={ordinal:{positions:K.ordinal.getExtendedPositions()}},be=K.index2val,ke=K.val2lin,ze=void 0,Ae=void 0,Be=void 0,He=void 0;Oe.ordinal.positions?Math.abs(ye)>1&&(me&&me.forEach(function(Fe){Fe.setState()}),ye<0?(Be=Oe,He=K.ordinal.positions?K:Oe):(Be=K.ordinal.positions?K:Oe,He=Oe),Ae=He.ordinal.positions,de>Ae[Ae.length-1]&&Ae.push(de),X.fixedRange=ue-he,ze=K.navigatorAxis.toFixedRange(null,null,be.apply(Be,[ke.apply(Be,[he,!0])+ye]),be.apply(He,[ke.apply(He,[ue,!0])+ye])),ze.min>=Math.min(se.dataMin,he)&&ze.max<=Math.max(de,ue)+Q&&K.setExtremes(ze.min,ze.max,!0,!1,{trigger:"pan"}),X.mouseDownX=te,css$3(X.container,{cursor:"move"})):ie=!0}else ie=!0;ie||ne&&/y/.test(ne.type)?Q&&(K.max=K.dataMax+Q):q.preventDefault()}function W(){var q=this.xAxis;q&&q.options.ordinal&&(delete q.ordinal.index,delete q.ordinal.extendedOrdinalPositions)}function U(q,X){var K=this,Q=K.ordinal,te=Q.positions,ne=Q.slope,ie=Q.extendedOrdinalPositions;if(!te)return q;var ae=te.length,se;if(te[0]<=q&&te[ae-1]>=q)se=C(te,q);else{if(ie||(ie=Q.getExtendedPositions&&Q.getExtendedPositions(),Q.extendedOrdinalPositions=ie),!(ie&&ie.length))return q;var de=ie.length;ne||(ne=(ie[de-1]-ie[0])/de);var he=C(ie,te[0]);if(q>=ie[0]&&q<=ie[de-1])se=C(ie,q)-he;else if(q<ie[0]){var ue=ie[0]-q,me=ue/ne;se=-he-me}else{var ue=q-ie[de-1],me=ue/ne;se=me+de-he}}return X?se:ne*(se||0)+Q.offset}var j=(function(){function q(X){this.index={},this.axis=X}return q.prototype.beforeSetTickPositions=function(){var X=this.axis,K=X.ordinal,Q=X.getExtremes(),te=Q.min,ne=Q.max,ie=X.isXAxis&&!!X.options.breaks,ae=X.options.ordinal,se=X.chart.options.chart.ignoreHiddenSeries,de,he,ue,me,xe,we,ye,Oe,be=[],ke=Number.MAX_VALUE,ze=!1;if(ae||ie){if(X.series.forEach(function(Ae,Be){if(he=[],(!se||Ae.visible!==!1)&&(Ae.takeOrdinalPosition!==!1||ie)&&(be=be.concat(Ae.processedXData),de=be.length,be.sort(function(He,Fe){return He-Fe}),ke=Math.min(ke,pick$1a(Ae.closestPointRange,ke)),de)){for(Be=0;Be<de-1;)be[Be]!==be[Be+1]&&he.push(be[Be+1]),Be++;he[0]!==be[0]&&he.unshift(be[0]),be=he}Ae.isSeriesBoosting&&(Oe=!0)}),Oe&&(be.length=0),de=be.length,de>2){for(ue=be[1]-be[0],ye=de-1;ye--&&!ze;)be[ye+1]-be[ye]!==ue&&(ze=!0);!X.options.keepOrdinalPadding&&(be[0]-te>ue||ne-be[be.length-1]>ue)&&(ze=!0)}else X.options.overscroll&&(de===2?ke=be[1]-be[0]:de===1?(ke=X.options.overscroll,be=[be[0],be[0]+ke]):ke=K.overscrollPointsRange);ze||X.forceOrdinal?(X.options.overscroll&&(K.overscrollPointsRange=ke,be=be.concat(K.getOverscrollPositions())),K.positions=be,me=X.ordinal2lin(Math.max(te,be[0]),!0),xe=Math.max(X.ordinal2lin(Math.min(ne,be[be.length-1]),!0),1),K.slope=we=(ne-te)/(xe-me),K.offset=te-me*we):(K.overscrollPointsRange=pick$1a(X.closestPointRange,K.overscrollPointsRange),K.positions=X.ordinal.slope=K.offset=void 0)}X.isOrdinal=ae&&ze,K.groupIntervalFactor=null},q.findIndexOf=function(X,K,Q){for(var te=0,ne=X.length-1,ie;te<ne;)ie=Math.ceil((te+ne)/2),X[ie]<=K?te=ie:ne=ie-1;return X[te]===K||Q?te:-1},q.prototype.getExtendedPositions=function(){var X=this,K=X.axis,Q=K.constructor.prototype,te=K.chart,ne=K.series[0].currentDataGrouping,ie=ne?ne.count+ne.unitName:"raw",ae=K.options.overscroll,se=K.getExtremes(),de,he=void 0,ue=X.index;return ue||(ue=X.index={}),ue[ie]||(de={series:[],chart:te,forceOrdinal:!1,getExtremes:function(){return{min:se.dataMin,max:se.dataMax+ae}},getGroupPixelWidth:Q.getGroupPixelWidth,getTimeTicks:Q.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:Q.ordinal2lin,getIndexOfPoint:Q.getIndexOfPoint,val2lin:Q.val2lin},de.ordinal.axis=de,K.series.forEach(function(me){he={xAxis:de,xData:me.xData.slice(),chart:te,destroyGroupedData:H.noop,getProcessedData:Series$f.prototype.getProcessedData,applyGrouping:Series$f.prototype.applyGrouping},he.xData=he.xData.concat(X.getOverscrollPositions()),he.options={dataGrouping:ne?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[ne.unitName,[ne.count]]]}:{enabled:!1}},de.series.push(he),me.processData.apply(he)}),K.applyGrouping.call(de),he.closestPointRange!==he.basePointRange&&he.currentDataGrouping&&(de.forceOrdinal=!0),K.ordinal.beforeSetTickPositions.apply({axis:de}),ue[ie]=de.ordinal.positions),ue[ie]},q.prototype.getGroupIntervalFactor=function(X,K,Q){var te=this;te.axis;var ne=Q.processedXData,ie=ne.length,ae=[],se,de,he=te.groupIntervalFactor;if(!he){for(de=0;de<ie-1;de++)ae[de]=ne[de+1]-ne[de];ae.sort(function(ue,me){return ue-me}),se=ae[Math.floor(ie/2)],X=Math.max(X,ne[0]),K=Math.min(K,ne[ie-1]),te.groupIntervalFactor=he=ie*se/(K-X)}return he},q.prototype.getIndexOfPoint=function(X,K){var Q=this,te=Q.axis,ne=Q.positions?Q.positions[0]:0,ie=te.series[0].points&&te.series[0].points[0]&&te.series[0].points[0].plotX||te.minPixelPadding;te.series.length>1&&te.series.forEach(function(de){defined$D(de.points[0])&&defined$D(de.points[0].plotX)&&de.points[0].plotX<ie&&(ie=de.points[0].plotX)});var ae=te.translationSlope*(Q.slope||te.closestPointRange||Q.overscrollPointsRange),se=(X-ie)/ae;return q.findIndexOf(K,ne)+se},q.prototype.getOverscrollPositions=function(){var X=this,K=X.axis,Q=K.options.overscroll,te=X.overscrollPointsRange,ne=[],ie=K.dataMax;if(defined$D(te))for(;ie<=K.dataMax+Q;)ie+=te,ne.push(ie);return ne},q.prototype.postProcessTickInterval=function(X){var K=this,Q=K.axis,te=K.slope,ne;return te?Q.options.breaks?ne=Q.closestPointRange||X:ne=X/(te/Q.closestPointRange):ne=X,ne},q})();v.Additions=j})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$S=Utilities.addEvent,find$f=Utilities.find,fireEvent$m=Utilities.fireEvent,isArray$c=Utilities.isArray,isNumber$z=Utilities.isNumber,pick$19=Utilities.pick,BrokenAxis;(function(v){var d=[];function a(U,j){if(d.indexOf(U)===-1&&(d.push(U),U.keepProps.push("brokenAxis"),addEvent$S(U,"init",P),addEvent$S(U,"afterInit",p),addEvent$S(U,"afterSetTickPositions",C),addEvent$S(U,"afterSetOptions",y)),d.indexOf(j)===-1){d.push(j);var q=j.prototype;q.drawBreaks=$,q.gappedPath=N,addEvent$S(j,"afterGeneratePoints",z),addEvent$S(j,"afterRender",L)}return U}v.compose=a;function p(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function y(){var U=this;U.brokenAxis&&U.brokenAxis.hasBreaks&&(U.options.ordinal=!1)}function C(){var U=this,j=U.brokenAxis;if(j&&j.hasBreaks){for(var q=U.tickPositions,X=U.tickPositions.info,K=[],Q=0;Q<q.length;Q++)j.isInAnyBreak(q[Q])||K.push(q[Q]);U.tickPositions=K,U.tickPositions.info=X}}function P(){var U=this;U.brokenAxis||(U.brokenAxis=new W(U))}function z(){var U=this,j=U.isDirty,q=U.options.connectNulls,X=U.points,K=U.xAxis,Q=U.yAxis;if(j)for(var te=X.length;te--;){var ne=X[te],ie=ne.y===null&&q===!1,ae=!ie&&(K&&K.brokenAxis&&K.brokenAxis.isInAnyBreak(ne.x,!0)||Q&&Q.brokenAxis&&Q.brokenAxis.isInAnyBreak(ne.y,!0));ne.visible=ae?!1:ne.options.visible!==!1}}function L(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$19(this.pointArrayMap,["y"]))}function $(U,j){var q=this,X=q.points,K,Q,te,ne;if(U&&U.brokenAxis&&U.brokenAxis.hasBreaks){var ie=U.brokenAxis;j.forEach(function(ae){K=ie&&ie.breakArray||[],Q=U.isXAxis?U.min:pick$19(q.options.threshold,U.min),X.forEach(function(se){ne=pick$19(se["stack"+ae.toUpperCase()],se[ae]),K.forEach(function(de){isNumber$z(Q)&&isNumber$z(ne)&&(te=!1,Q<de.from&&ne>de.to||Q>de.from&&ne<de.from?te="pointBreak":(Q<de.from&&ne>de.from&&ne<de.to||Q>de.from&&ne>de.to&&ne<de.from)&&(te="pointInBreak"),te&&fireEvent$m(U,te,{point:se,brk:de}))})})})}}function N(){var U=this.currentDataGrouping,j=U&&U.gapSize,q=this.points.slice(),X=this.yAxis,K=this.options.gapSize,Q=q.length-1,te;if(K&&Q>0){this.options.gapUnit!=="value"&&(K*=this.basePointRange),j&&j>K&&j>=this.basePointRange&&(K=j);for(var ne=void 0,ie=void 0;Q--;)if(ie&&ie.visible!==!1||(ie=q[Q+1]),ne=q[Q],!(ie.visible===!1||ne.visible===!1)){if(ie.x-ne.x>K){var ae=(ne.x+ie.x)/2;q.splice(Q+1,0,{isNull:!0,x:ae}),X.stacking&&this.options.stacking&&(te=X.stacking.stacks[this.stackKey][ae]=new StackItem$1(X,X.options.stackLabels,!1,ae,this.stack),te.total=0)}ie=ne}}return this.getGraphPath(q)}var W=(function(){function U(j){this.hasBreaks=!1,this.axis=j}return U.isInBreak=function(j,q){var X=j.repeat||1/0,K=j.from,Q=j.to-j.from,te=q>=K?(q-K)%X:X-(K-q)%X,ne;return j.inclusive?ne=te<=Q:ne=te<Q&&te!==0,ne},U.lin2Val=function(j){var q=this,X=q.brokenAxis,K=X&&X.breakArray;if(!K||!isNumber$z(j))return j;var Q=j,te,ne;for(ne=0;ne<K.length&&(te=K[ne],!(te.from>=Q));ne++)(te.to<Q||U.isInBreak(te,Q))&&(Q+=te.len);return Q},U.val2Lin=function(j){var q=this,X=q.brokenAxis,K=X&&X.breakArray;if(!K||!isNumber$z(j))return j;var Q=j,te,ne;for(ne=0;ne<K.length;ne++)if(te=K[ne],te.to<=j)Q-=te.len;else{if(te.from>=j)break;if(U.isInBreak(te,j)){Q-=j-te.from;break}}return Q},U.prototype.findBreakAt=function(j,q){return find$f(q,function(X){return X.from<j&&j<X.to})},U.prototype.isInAnyBreak=function(j,q){var X=this,K=X.axis,Q=K.options.breaks||[],te=Q.length,ne,ie,ae;if(te&&isNumber$z(j)){for(;te--;)U.isInBreak(Q[te],j)&&(ne=!0,ie||(ie=pick$19(Q[te].showPoints,!K.isXAxis)));ne&&q?ae=ne&&!ie:ae=ne}return ae},U.prototype.setBreaks=function(j,q){var X=this,K=X.axis,Q=isArray$c(j)&&!!j.length;K.isDirty=X.hasBreaks!==Q,X.hasBreaks=Q,K.options.breaks=K.userOptions.breaks=j,K.forceRedraw=!0,K.series.forEach(function(te){te.isDirty=!0}),!Q&&K.val2lin===U.val2Lin&&(delete K.val2lin,delete K.lin2val),Q&&(K.userOptions.ordinal=!1,K.lin2val=U.lin2Val,K.val2lin=U.val2Lin,K.setExtremes=function(te,ne,ie,ae,se){if(X.hasBreaks){for(var de=this.options.breaks||[],he=void 0;he=X.findBreakAt(te,de);)te=he.to;for(;he=X.findBreakAt(ne,de);)ne=he.from;ne<te&&(ne=te)}K.constructor.prototype.setExtremes.call(this,te,ne,ie,ae,se)},K.setAxisTranslation=function(){if(K.constructor.prototype.setAxisTranslation.call(this),X.unitLength=void 0,X.hasBreaks){var te=K.options.breaks||[],ne=[],ie=[],ae=pick$19(K.pointRangePadding,0),se=0,de,he,ue=K.userMin||K.min,me=K.userMax||K.max,xe,we;te.forEach(function(ye){he=ye.repeat||1/0,isNumber$z(ue)&&isNumber$z(me)&&(U.isInBreak(ye,ue)&&(ue+=ye.to%he-ue%he),U.isInBreak(ye,me)&&(me-=me%he-ye.from%he))}),te.forEach(function(ye){if(xe=ye.from,he=ye.repeat||1/0,isNumber$z(ue)&&isNumber$z(me)){for(;xe-he>ue;)xe-=he;for(;xe<ue;)xe+=he;for(we=xe;we<me;we+=he)ne.push({value:we,move:"in"}),ne.push({value:we+ye.to-ye.from,move:"out",size:ye.breakSize})}}),ne.sort(function(ye,Oe){return ye.value===Oe.value?(ye.move==="in"?0:1)-(Oe.move==="in"?0:1):ye.value-Oe.value}),de=0,xe=ue,ne.forEach(function(ye){de+=ye.move==="in"?1:-1,de===1&&ye.move==="in"&&(xe=ye.value),de===0&&isNumber$z(xe)&&(ie.push({from:xe,to:ye.value,len:ye.value-xe-(ye.size||0)}),se+=ye.value-xe-(ye.size||0))}),X.breakArray=ie,isNumber$z(ue)&&isNumber$z(me)&&isNumber$z(K.min)&&(X.unitLength=me-ue-se+ae,fireEvent$m(K,"afterBreaks"),K.staticScale?K.transA=K.staticScale:X.unitLength&&(K.transA*=(me-K.min+ae)/X.unitLength),ae&&(K.minPixelPadding=K.transA*(K.minPointOffset||0)),K.min=ue,K.max=me)}}),pick$19(q,!0)&&K.chart.redraw()},U})();v.Additions=W})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;BrokenAxis$1.compose(G$7.Axis,G$7.Series);var format$8=FormatUtilities.format,seriesProto$3=Series$f.prototype,addEvent$R=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$C=Utilities.defined,error$4=Utilities.error,extend$1a=Utilities.extend,isNumber$y=Utilities.isNumber,merge$12=Utilities.merge,pick$18=Utilities.pick,approximations=H.approximations={sum:function(v){var d=v.length,a;if(!d&&v.hasNulls)a=null;else if(d)for(a=0;d--;)a+=v[d];return a},average:function(v){var d=v.length,a=approximations.sum(v);return isNumber$y(a)&&d&&(a=correctFloat$7(a/d)),a},averages:function(){var v=[];return[].forEach.call(arguments,function(d){v.push(approximations.average(d))}),typeof v[0]>"u"?void 0:v},open:function(v){return v.length?v[0]:v.hasNulls?null:void 0},high:function(v){return v.length?arrayMax$5(v):v.hasNulls?null:void 0},low:function(v){return v.length?arrayMin$5(v):v.hasNulls?null:void 0},close:function(v){return v.length?v[v.length-1]:v.hasNulls?null:void 0},ohlc:function(v,d,a,p){if(v=approximations.open(v),d=approximations.high(d),a=approximations.low(a),p=approximations.close(p),isNumber$y(v)||isNumber$y(d)||isNumber$y(a)||isNumber$y(p))return[v,d,a,p]},range:function(v,d){if(v=approximations.low(v),d=approximations.high(d),isNumber$y(v)||isNumber$y(d))return[v,d];if(v===null&&d===null)return null}},applyGrouping=function(){var v=this,d=v.chart,a=v.options,p=a.dataGrouping,y=v.allowDG!==!1&&p&&pick$18(p.enabled,d.options.isStock),C=v.visible||!d.options.chart.ignoreHiddenSeries,P,z,L=this.currentDataGrouping,$,N,W=!1;if(y&&!v.requireSorting&&(v.requireSorting=W=!0),z=skipDataGrouping(v)||!y,W&&(v.requireSorting=!1),!z){v.destroyGroupedData();var U=void 0,j=p.groupAll?v.xData:v.processedXData,q=p.groupAll?v.yData:v.processedYData,X=d.plotSizeX,K=v.xAxis,Q=K.options.ordinal,te=v.groupPixelWidth;if(te&&j&&j.length){P=!0,v.isDirty=!0,v.points=null;var ne=K.getExtremes(),ie=ne.min,ae=ne.max,se=Q&&K.ordinal&&K.ordinal.getGroupIntervalFactor(ie,ae,v)||1,de=te*(ae-ie)/X*se,he=K.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(de,p.units||defaultDataGroupingUnits),Math.min(ie,j[0]),Math.max(ae,j[j.length-1]),K.options.startOfWeek,j,v.closestPointRange),ue=seriesProto$3.groupData.apply(v,[j,q,he,p.approximation]),me=ue.groupedXData,xe=ue.groupedYData,we=0;for(p&&p.smoothed&&me.length&&(p.firstAnchor="firstPoint",p.anchor="middle",p.lastAnchor="lastPoint",error$4(32,!1,d,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(v,me,ae),U=1;U<he.length;U++)(!he.info.segmentStarts||he.info.segmentStarts.indexOf(U)===-1)&&(we=Math.max(he[U]-he[U-1],we));$=he.info,$.gapSize=we,v.closestPointRange=he.info.totalRange,v.groupMap=ue.groupMap,C&&adjustExtremes(K,me),p.groupAll&&(v.allGroupedData=xe,N=v.cropData(me,xe,K.min,K.max,1),me=N.xData,xe=N.yData,v.cropStart=N.start),v.processedXData=me,v.processedYData=xe}else v.groupMap=null;v.hasGroupedData=P,v.currentDataGrouping=$,v.preventGraphAnimation=(L&&L.totalRange)!==($&&$.totalRange)}},skipDataGrouping=function(v){if(v.isCartesian&&!v.isDirty&&!v.xAxis.isDirty&&!v.yAxis.isDirty)return!1},groupData=function(v,d,a,p){var y=this,C=y.data,P=y.options&&y.options.data,z=[],L=[],$=[],N=v.length,W,U,j,q=!!d,X=[],K,Q=y.pointArrayMap,te=Q&&Q.length,ne=["x"].concat(Q||["y"]),ie=this.options.dataGrouping&&this.options.dataGrouping.groupAll,ae=0,se=0,de,he,ue;function me(Oe){return typeof Oe=="function"?Oe:approximations[Oe]?approximations[Oe]:approximations[y.getDGApproximation&&y.getDGApproximation()||"average"]}for(K=me(p),te?Q.forEach(function(){X.push([])}):X.push([]),de=te||1,he=0;he<=N&&!(v[he]>=a[0]);he++);for(he;he<=N;he++){for(;typeof a[ae+1]<"u"&&v[he]>=a[ae+1]||he===N;){for(W=a[ae],y.dataGroupInfo={start:ie?se:y.cropStart+se,length:X[0].length},j=K.apply(y,X),y.pointClass&&!defined$C(y.dataGroupInfo.options)&&(y.dataGroupInfo.options=merge$12(y.pointClass.prototype.optionsToObject.call({series:y},y.options.data[y.cropStart+se])),ne.forEach(function(Oe){delete y.dataGroupInfo.options[Oe]})),typeof j<"u"&&(z.push(W),L.push(j),$.push(y.dataGroupInfo)),se=he,ue=0;ue<de;ue++)X[ue].length=0,X[ue].hasNulls=!1;if(ae+=1,he===N)break}if(he===N)break;if(Q){var xe=y.options.dataGrouping&&y.options.dataGrouping.groupAll?he:y.cropStart+he,we=C&&C[xe]||y.pointClass.prototype.applyOptions.apply({series:y},[P[xe]]),ye=void 0;for(ue=0;ue<te;ue++)ye=we[Q[ue]],isNumber$y(ye)?X[ue].push(ye):ye===null&&(X[ue].hasNulls=!0)}else U=q?d[he]:null,isNumber$y(U)?X[0].push(U):U===null&&(X[0].hasNulls=!0)}return{groupedXData:z,groupedYData:L,groupMap:$}},anchorPoints=function(v,d,a){var p=v.options,y=p.dataGrouping,C=v.currentDataGrouping&&v.currentDataGrouping.gapSize,P;if(y&&v.xData&&C&&v.groupMap){var z=d.length-1,L=y.anchor,$=pick$18(y.firstAnchor,L),N=pick$18(y.lastAnchor,L);if(L&&L!=="start"){var W=C*{middle:.5,end:1}[L];for(P=d.length-1;P--&&P>0;)d[P]+=W}if($&&$!=="start"&&v.xData[0]>=d[0]){var U=v.groupMap[0].start,j=v.groupMap[0].length,q=void 0;isNumber$y(U)&&isNumber$y(j)&&(q=U+(j-1)),d[0]={middle:d[0]+.5*C,end:d[0]+C,firstPoint:v.xData[0],lastPoint:q&&v.xData[q]}[$]}if(N&&N!=="start"&&C&&d[z]>=a-C){var X=v.groupMap[v.groupMap.length-1].start;d[z]={middle:d[z]+.5*C,end:d[z]+C,firstPoint:X&&v.xData[X],lastPoint:v.xData[v.xData.length-1]}[N]}}},adjustExtremes=function(v,d){defined$C(d[0])&&isNumber$y(v.min)&&isNumber$y(v.dataMin)&&d[0]<v.min&&((!defined$C(v.options.min)&&v.min<=v.dataMin||v.min===v.dataMin)&&(v.min=Math.min(d[0],v.min)),v.dataMin=Math.min(d[0],v.dataMin)),defined$C(d[d.length-1])&&isNumber$y(v.max)&&isNumber$y(v.dataMax)&&d[d.length-1]>v.max&&((!defined$C(v.options.max)&&isNumber$y(v.dataMax)&&v.max>=v.dataMax||v.max===v.dataMax)&&(v.max=Math.max(d[d.length-1],v.max)),v.dataMax=Math.max(d[d.length-1],v.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(v,d){v&&(this.groupedData[d]=v.destroy?v.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var v=this,d=v.series;d.forEach(function(a){a.groupPixelWidth=void 0,a.groupPixelWidth=v.getGroupPixelWidth&&v.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var v=this.series,d=v.length,a,p=0,y=!1,C,P;for(a=d;a--;)P=v[a].options.dataGrouping,P&&(p=Math.max(p,pick$18(P.groupPixelWidth,commonOptions.groupPixelWidth)));for(a=d;a--;)P=v[a].options.dataGrouping,P&&(C=(v[a].processedXData||v[a].data).length,(v[a].groupPixelWidth||C>this.chart.plotSizeX/p||C&&P.forced)&&(y=!0));return y?p:0};Axis.prototype.setDataGrouping=function(v,d){var a=this,p;if(d=pick$18(d,!0),v||(v={forced:!1,units:null}),this instanceof Axis)for(p=this.series.length;p--;)this.series[p].update({dataGrouping:v},!1);else this.chart.options.series.forEach(function(y){y.dataGrouping=v},!1);a.ordinal&&(a.ordinal.slope=void 0),d&&this.chart.redraw()};addEvent$R(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$R(Point$4,"update",function(){if(this.dataGroup)return error$4(24,!1,this.series.chart),!1});addEvent$R(Tooltip,"headerFormatter",function(v){var d=this.chart,a=d.time,p=v.labelConfig,y=p.series,C=y.options,P=y.tooltipOptions,z=C.dataGrouping,L=P.xDateFormat,$,N=y.xAxis,W,U,j,q,X=P[v.isFooter?"footerFormat":"headerFormat"];N&&N.options.type==="datetime"&&z&&isNumber$y(p.key)&&(W=y.currentDataGrouping,U=z.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,W?(j=U[W.unitName],W.count===1?L=j[0]:(L=j[1],$=j[2])):!L&&U&&N.dateTime&&(L=N.dateTime.getXDateFormat(p.x,P.dateTimeLabelFormats)),q=a.dateFormat(L,p.key),$&&(q+=a.dateFormat($,p.key+W.totalRange-1)),y.chart.styledMode&&(X=this.styledModeFormat(X)),v.text=format$8(X,{point:extend$1a(p.point,{key:q}),series:y},d),v.preventDefault())});addEvent$R(Series$f,"destroy",seriesProto$3.destroyGroupedData);addEvent$R(Series$f,"afterSetOptions",function(v){var d=v.options,a=this.type,p=this.chart.options.plotOptions,y=DefaultOptions.defaultOptions.plotOptions[a].dataGrouping,C=this.useCommonDataGrouping&&commonOptions;if(specificOptions[a]||C){y||(y=merge$12(commonOptions,specificOptions[a]));var P=this.chart.rangeSelector;d.dataGrouping=merge$12(C,y,p.series&&p.series.dataGrouping,p[a].dataGrouping,this.userOptions.dataGrouping,!d.isInternal&&P&&isNumber$y(P.selected)&&P.buttonOptions[P.selected].dataGrouping)}});addEvent$R(Axis,"afterSetScale",function(){this.series.forEach(function(v){v.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$O=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=(function(v){__extends$O(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.close=void 0,a.high=void 0,a.low=void 0,a.open=void 0,a.options=void 0,a.plotClose=void 0,a.plotOpen=void 0,a.series=void 0,a}return d.prototype.getClassName=function(){return v.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},d.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},d.prototype.resolveColor=function(){v.prototype.resolveColor.call(this),this.resolveUpColor()},d.prototype.getZone=function(){var a=v.prototype.getZone.call(this);return this.resolveUpColor(),a},d.prototype.applyOptions=function(){return v.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},d})(ColumnSeries$g.prototype.pointClass),__extends$N=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$19=Utilities.extend,merge$11=Utilities.merge,OHLCSeries$1=(function(v){__extends$N(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.yData=void 0,a}return d.prototype.drawPoints=function(){var a=this,p=a.points,y=a.chart,C=function(P,z,L){var $=P[0],N=P[1];typeof $[2]=="number"&&($[2]=Math.max(L+z,$[2])),typeof N[2]=="number"&&(N[2]=Math.min(L-z,N[2]))};p.forEach(function(P){var z,L,$,N,W,U=P.graphic,j,q=!U,X;typeof P.plotY<"u"&&(U||(P.graphic=U=y.renderer.path().add(a.group)),y.styledMode||U.attr(a.pointAttribs(P,P.selected&&"select")),X=U.strokeWidth(),$=X%2/2,j=Math.round(P.plotX)-$,N=Math.round(P.shapeArgs.width/2),W=[["M",j,Math.round(P.yBottom)],["L",j,Math.round(P.plotHigh)]],P.open!==null&&(z=Math.round(P.plotOpen)+$,W.push(["M",j,z],["L",j-N,z]),C(W,X/2,z)),P.close!==null&&(L=Math.round(P.plotClose)+$,W.push(["M",j,L],["L",j+N,L]),C(W,X/2,L)),U[q?"attr":"animate"]({d:W}).addClass(P.getClassName(),!0))})},d.prototype.init=function(){v.prototype.init.apply(this,arguments),this.options.stacking=void 0},d.prototype.pointAttribs=function(a,p){var y=v.prototype.pointAttribs.call(this,a,p),C=this.options;return delete y.fill,!a.options.color&&C.upColor&&a.open<a.close&&(y.stroke=C.upColor),y},d.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]},d.prototype.translate=function(){var a=this,p=a.yAxis,y=!!a.modifyValue,C=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];v.prototype.translate.apply(a),a.points.forEach(function(P){[P.open,P.high,P.low,P.close,P.low].forEach(function(z,L){z!==null&&(y&&(z=a.modifyValue(z)),P[C[L]]=p.toPixels(z,!0))}),P.tooltipPos[1]=P.plotHigh+p.pos-a.chart.plotTop})},d.defaultOptions=merge$11(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),d})(ColumnSeries$f);extend$19(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$M=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defaultOptions$c=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$10=Utilities.merge,CandlestickSeries=(function(v){__extends$M(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.pointAttribs=function(a,p){var y=ColumnSeries$e.prototype.pointAttribs.call(this,a,p),C=this.options,P=a.open<a.close,z=C.lineColor||this.color,L=a.color||this.color,$;return y["stroke-width"]=C.lineWidth,y.fill=a.options.color||P&&C.upColor||L,y.stroke=a.options.lineColor||P&&C.upLineColor||z,p&&($=C.states[p],y.fill=$.color||y.fill,y.stroke=$.lineColor||y.stroke,y["stroke-width"]=$.lineWidth||y["stroke-width"]),y},d.prototype.drawPoints=function(){var a=this,p=a.points,y=a.chart,C=a.yAxis.reversed;p.forEach(function(P){var z=P.graphic,L,$,N,W,U,j,q,X,K,Q,te=!z;typeof P.plotY<"u"&&(z||(P.graphic=z=y.renderer.path().add(a.group)),a.chart.styledMode||z.attr(a.pointAttribs(P,P.selected&&"select")).shadow(a.options.shadow),q=z.strokeWidth()%2/2,X=Math.round(P.plotX)-q,L=P.plotOpen,$=P.plotClose,N=Math.min(L,$),W=Math.max(L,$),Q=Math.round(P.shapeArgs.width/2),U=C?W!==P.yBottom:Math.round(N)!==Math.round(P.plotHigh),j=C?Math.round(N)!==Math.round(P.plotHigh):W!==P.yBottom,N=Math.round(N)+q,W=Math.round(W)+q,K=[],K.push(["M",X-Q,W],["L",X-Q,N],["L",X+Q,N],["L",X+Q,W],["Z"],["M",X,N],["L",X,U?Math.round(C?P.yBottom:P.plotHigh):N],["M",X,W],["L",X,j?Math.round(C?P.plotHigh:P.yBottom):W]),z[te?"attr":"animate"]({d:K}).addClass(P.getClassName(),!0))})},d.defaultOptions=merge$10(OHLCSeries.defaultOptions,defaultOptions$c.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$c.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),d})(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$L=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$x=Utilities.isNumber,FlagsPoint=(function(v){__extends$L(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.isValid=function(){return isNumber$x(this.y)||typeof this.y>"u"},d.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey},d})(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$f.prototype,defined$B=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var v=this,d=v.options,a=v.chart,p=v.points,y=p.length-1,C,P,z=d.onSeries,L=z&&a.get(z),$=d.onKey||"y",N=L&&L.options.step,W=L&&L.points,U=W&&W.length,j=a.inverted,q=v.xAxis,X=v.yAxis,K=0,Q,te,ne,ie,ae;if(L&&L.visible&&U)for(K=(L.pointXOffset||0)+(L.barW||0)/2,ie=L.currentDataGrouping,te=W[U-1].x+(ie?ie.totalRange:0),stableSort$4(p,function(se,de){return se.x-de.x}),$="plot"+$[0].toUpperCase()+$.substr(1);U--&&p[y]&&(Q=W[U],C=p[y],C.y=Q.y,!(Q.x<=C.x&&typeof Q[$]<"u"&&(C.x<=te&&(C.plotY=Q[$],Q.x<C.x&&!N&&(ne=W[U+1],ne&&typeof ne[$]<"u"&&(ae=(C.x-Q.x)/(ne.x-Q.x),C.plotY+=ae*(ne[$]-Q[$]),C.y+=ae*(ne.y-Q.y)))),y--,U++,y<0))););p.forEach(function(se,de){var he;se.plotX+=K,(typeof se.plotY>"u"||j)&&(se.plotX>=0&&se.plotX<=q.len?j?(se.plotY=q.translate(se.x,0,1,0,1),se.plotX=defined$B(se.y)?X.translate(se.y,0,0,0,1):0):se.plotY=(q.opposite?0:v.yAxis.len)+q.offset:se.shapeArgs={}),P=p[de-1],P&&P.plotX===se.plotX&&(typeof P.stackIndex>"u"&&(P.stackIndex=0),he=P.stackIndex+1),se.stackIndex=he}),this.onSeries=L}},symbols$4=SVGRenderer.prototype.symbols;symbols$4.flag=function(v,d,a,p,y){var C=y&&y.anchorX||v,P=y&&y.anchorY||d,z=symbols$4.circle(C-1,P-1,2,2);return z.push(["M",C,P],["L",v,d+p],["L",v,d],["L",v+a,d],["L",v+a,d+p],["L",v,d+p],["Z"]),z};function createPinSymbol(v){symbols$4[v+"pin"]=function(d,a,p,y,C){var P=C&&C.anchorX,z=C&&C.anchorY,L;if(v==="circle"&&y>p&&(d-=Math.round((y-p)/2),p=y),L=symbols$4[v](d,a,p,y),P&&z){var $=P;if(v==="circle")$=d+p/2;else{var N=L[0],W=L[1];N[0]==="M"&&W[0]==="L"&&($=(N[1]+W[1])/2)}var U=a>z?a:a+y;L.push(["M",$,U],["L",P,z]),L=L.concat(symbols$4.circle(P-1,z-1,2,2))}return L}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$4.circlepin,Renderer.prototype.symbols.flag=symbols$4.flag,Renderer.prototype.symbols.squarepin=symbols$4.squarepin);var __extends$K=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$d=H.noop,distribute=R$1.distribute,Series$c=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$Q=Utilities.addEvent,defined$A=Utilities.defined,extend$18=Utilities.extend,merge$$=Utilities.merge,objectEach$g=Utilities.objectEach,wrap$g=Utilities.wrap,FlagsSeries=(function(v){__extends$K(d,v);function d(){var a=v!==null&&v.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){a&&this.setClip()},d.prototype.drawPoints=function(){var a=this,p=a.points,y=a.chart,C=y.renderer,P,z,L=y.inverted,$=a.options,N=$.y,W,U,j,q,X,K,Q,te,ne=a.yAxis,ie={},ae=[],se;for(U=p.length;U--;)j=p[U],te=(L?j.plotY:j.plotX)>a.xAxis.len,P=j.plotX,X=j.stackIndex,W=j.options.shape||$.shape,z=j.plotY,typeof z<"u"&&(z=j.plotY+N-(typeof X<"u"&&X*$.stackDistance)),j.anchorX=X?void 0:j.plotX,K=X?void 0:j.plotY,se=W!=="flag",q=j.graphic,typeof z<"u"&&P>=0&&!te?(q&&j.hasNewShapeType()&&(q=q.destroy()),q||(q=j.graphic=C.label("",null,null,W,null,null,$.useHTML).addClass("highcharts-point").add(a.markerGroup),j.graphic.div&&(j.graphic.div.point=j),q.isNew=!0),q.attr({align:se?"center":"left",width:$.width,height:$.height,"text-align":$.textAlign}),y.styledMode||q.attr(a.pointAttribs(j)).css(merge$$($.style,j.style)).shadow($.shadow),P>0&&(P-=q.strokeWidth()%2),Q={y:z,anchorY:K},$.allowOverlapX&&(Q.x=P,Q.anchorX=j.anchorX),q.attr({text:j.options.title||$.title||"A"})[q.isNew?"attr":"animate"](Q),$.allowOverlapX||(ie[j.plotX]?ie[j.plotX].size=Math.max(ie[j.plotX].size,q.width):ie[j.plotX]={align:se?.5:0,size:q.width,target:P,anchorX:P}),j.tooltipPos=[P,z+ne.pos-y.plotTop]):q&&(j.graphic=q.destroy());$.allowOverlapX||(objectEach$g(ie,function(de){de.plotX=de.anchorX,ae.push(de)}),distribute(ae,L?ne.len:this.xAxis.len,100),p.forEach(function(de){var he=de.graphic&&ie[de.plotX];he&&(de.graphic[de.graphic.isNew?"attr":"animate"]({x:he.pos+he.align*he.size,anchorX:de.anchorX}),defined$A(he.pos)?de.graphic.isNew=!1:(de.graphic.attr({x:-9999,anchorX:-9999}),de.graphic.isNew=!0))})),$.useHTML&&wrap$g(a.markerGroup,"on",function(de){return SVGElement.prototype.on.apply(de.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},d.prototype.drawTracker=function(){var a=this,p=a.points;v.prototype.drawTracker.call(this),p.forEach(function(y){var C=y.graphic;C&&(y.unbindMouseOver&&y.unbindMouseOver(),y.unbindMouseOver=addEvent$Q(C.element,"mouseover",function(){y.stackIndex>0&&!y.raised&&(y._y=C.y,C.attr({y:y._y-8}),y.raised=!0),p.forEach(function(P){P!==y&&P.raised&&P.graphic&&(P.graphic.attr({y:P._y}),P.raised=!1)})}))})},d.prototype.pointAttribs=function(a,p){var y=this.options,C=a&&a.color||this.color,P=y.lineColor,z=a&&a.lineWidth,L=a&&a.fillColor||y.fillColor;return p&&(L=y.states[p].fillColor,P=y.states[p].lineColor,z=y.states[p].lineWidth),{fill:L||C,stroke:P||C,"stroke-width":z||y.lineWidth||0}},d.prototype.setClip=function(){Series$c.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},d.defaultOptions=merge$$(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),d})(ColumnSeries$c);extend$18(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$d,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$c.prototype.init,invertGroups:noop$d,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$P=Utilities.addEvent,defined$z=Utilities.defined,pick$17=Utilities.pick,ScrollbarAxis=(function(){function v(){}return v.compose=function(d,a){if(v.composed.indexOf(d)===-1)v.composed.push(d);else return d;var p=function(y){var C=pick$17(y.options&&y.options.min,y.min),P=pick$17(y.options&&y.options.max,y.max);return{axisMin:C,axisMax:P,scrollMin:defined$z(y.dataMin)?Math.min(C,y.min,y.dataMin,pick$17(y.threshold,1/0)):C,scrollMax:defined$z(y.dataMax)?Math.max(P,y.max,y.dataMax,pick$17(y.threshold,-1/0)):P}};return addEvent$P(d,"afterInit",function(){var y=this;y.options&&y.options.scrollbar&&y.options.scrollbar.enabled&&(y.options.scrollbar.vertical=!y.horiz,y.options.startOnTick=y.options.endOnTick=!1,y.scrollbar=new a(y.chart.renderer,y.options.scrollbar,y.chart),addEvent$P(y.scrollbar,"changed",function(C){var P=p(y),z=P.axisMin,L=P.axisMax,$=P.scrollMin,N=P.scrollMax,W=N-$,U,j;!defined$z(z)||!defined$z(L)||(y.horiz&&!y.reversed||!y.horiz&&y.reversed?(U=$+W*this.to,j=$+W*this.from):(U=$+W*(1-this.from),j=$+W*(1-this.to)),this.shouldUpdateExtremes(C.DOMType)?y.setExtremes(j,U,!0,C.DOMType!=="mousemove"&&C.DOMType!=="touchmove",C):this.setRange(this.from,this.to))}))}),addEvent$P(d,"afterRender",function(){var y=this,C=p(y),P=C.scrollMin,z=C.scrollMax,L=y.scrollbar,$=y.axisTitleMargin+(y.titleOffset||0),N=y.chart.scrollbarsOffsets,W=y.options.margin||0,U,j,q;L&&(y.horiz?(y.opposite||(N[1]+=$),L.position(y.left,y.top+y.height+2+N[1]-(y.opposite?W:0),y.width,y.height),y.opposite||(N[1]+=W),U=1):(y.opposite&&(N[0]+=$),L.position(y.left+y.width+2+N[0]-(y.opposite?0:W),y.top,y.width,y.height),y.opposite&&(N[0]+=W),U=0),N[U]+=L.size+L.options.margin,isNaN(P)||isNaN(z)||!defined$z(y.min)||!defined$z(y.max)||y.min===y.max?L.setRange(0,1):(j=(y.min-P)/(z-P),q=(y.max-P)/(z-P),y.horiz&&!y.reversed||!y.horiz&&y.reversed?L.setRange(j,q):L.setRange(1-q,1-j)))}),addEvent$P(d,"afterGetOffset",function(){var y=this,C=y.horiz?2:1,P=y.scrollbar;P&&(y.chart.scrollbarsOffsets=[0,0],y.chart.axisOffset[C]+=P.size+P.options.margin)}),d},v.composed=[],v})(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$b=DefaultOptions.defaultOptions,addEvent$O=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$y=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$l=Utilities.fireEvent,merge$_=Utilities.merge,pick$16=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=(function(){function v(d,a,p){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(d,a,p)}return v.compose=function(d){ScrollbarAxis.compose(d,v)},v.swapXY=function(d,a){return a&&d.forEach(function(p){for(var y=p.length,C,P=0;P<y;P+=2)C=p[P+1],typeof C=="number"&&(p[P+1]=p[P+2],p[P+2]=C)}),d},v.prototype.addEvents=function(){var d=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,p=this.scrollbarGroup.element,y=this.track.element,C=this.mouseDownHandler.bind(this),P=this.mouseMoveHandler.bind(this),z=this.mouseUpHandler.bind(this),L=[[a[d[0]].element,"click",this.buttonToMinClick.bind(this)],[a[d[1]].element,"click",this.buttonToMaxClick.bind(this)],[y,"click",this.trackClick.bind(this)],[p,"mousedown",C],[p.ownerDocument,"mousemove",P],[p.ownerDocument,"mouseup",z]];H.hasTouch&&L.push([p,"touchstart",C],[p.ownerDocument,"touchmove",P],[p.ownerDocument,"touchend",z]),L.forEach(function($){addEvent$O.apply(null,$)}),this._events=L},v.prototype.buttonToMaxClick=function(d){var a=this,p=(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(a.from+p,a.to+p),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},v.prototype.buttonToMinClick=function(d){var a=this,p=correctFloat$6(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(correctFloat$6(a.from-p),correctFloat$6(a.to-p)),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},v.prototype.cursorToScrollbarPosition=function(d){var a=this,p=a.options,y=p.minWidth>a.calculatedWidth?p.minWidth:0;return{chartX:(d.chartX-a.x-a.xOffset)/(a.barWidth-y),chartY:(d.chartY-a.y-a.yOffset)/(a.barWidth-y)}},v.prototype.destroy=function(){var d=this,a=d.chart.scroller;d.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(p){d[p]&&d[p].destroy&&(d[p]=d[p].destroy())}),a&&d===a.scrollbar&&(a.scrollbar=null,destroyObjectProperties$3(a.scrollbarButtons))},v.prototype.drawScrollbarButton=function(d){var a=this,p=a.renderer,y=a.scrollbarButtons,C=a.options,P=a.size,z=p.g().add(a.group),L;y.push(z),L=p.rect().addClass("highcharts-scrollbar-button").add(z),a.chart.styledMode||L.attr({stroke:C.buttonBorderColor,"stroke-width":C.buttonBorderWidth,fill:C.buttonBackgroundColor}),L.attr(L.crisp({x:-.5,y:-.5,width:P+1,height:P+1,r:C.buttonBorderRadius},L.strokeWidth())),L=p.path(v.swapXY([["M",P/2+(d?-1:1),P/2-3],["L",P/2+(d?-1:1),P/2+3],["L",P/2+(d?2:-2),P/2]],C.vertical)).addClass("highcharts-scrollbar-arrow").add(y[d]),a.chart.styledMode||L.attr({fill:C.buttonArrowColor})},v.prototype.init=function(d,a,p){var y=this;y.scrollbarButtons=[],y.renderer=d,y.userOptions=a,y.options=merge$_(ScrollbarDefaults,defaultOptions$b.scrollbar,a),y.chart=p,y.size=pick$16(y.options.size,y.options.height),a.enabled&&(y.render(),y.addEvents())},v.prototype.mouseDownHandler=function(d){var a=this,p=a.chart.pointer.normalize(d),y=a.cursorToScrollbarPosition(p);a.chartX=y.chartX,a.chartY=y.chartY,a.initPositions=[a.from,a.to],a.grabbedCenter=!0},v.prototype.mouseMoveHandler=function(d){var a=this,p=a.chart.pointer.normalize(d),y=a.options,C=y.vertical?"chartY":"chartX",P=a.initPositions||[],z,L,$;a.grabbedCenter&&(!d.touches||d.touches[0][C]!==0)&&(L=a.cursorToScrollbarPosition(p)[C],z=a[C],$=L-z,a.hasDragged=!0,a.updatePosition(P[0]+$,P[1]+$),a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}))},v.prototype.mouseUpHandler=function(d){var a=this;a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}),a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null},v.prototype.position=function(d,a,p,y){var C=this,P=C.options,z=P.vertical,L=C.rendered?"animate":"attr",$=y,N=0;C.x=d,C.y=a+this.trackBorderWidth,C.width=p,C.height=y,C.xOffset=$,C.yOffset=N,z?(C.width=C.yOffset=p=N=C.size,C.xOffset=$=0,C.barWidth=y-p*2,C.x=d=d+C.options.margin):(C.height=C.xOffset=y=$=C.size,C.barWidth=p-y*2,C.y=C.y+C.options.margin),C.group[L]({translateX:d,translateY:C.y}),C.track[L]({width:p,height:y}),C.scrollbarButtons[1][L]({translateX:z?0:p-$,translateY:z?y-N:0})},v.prototype.removeEvents=function(){this._events.forEach(function(d){removeEvent$4.apply(null,d)}),this._events.length=0},v.prototype.render=function(){var d=this,a=d.renderer,p=d.options,y=d.size,C=d.chart.styledMode,P=a.g("scrollbar").attr({zIndex:p.zIndex,translateY:-99999}).add();d.group=P,d.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:p.trackBorderRadius||0,height:y,width:y}).add(P),C||d.track.attr({fill:p.trackBackgroundColor,stroke:p.trackBorderColor,"stroke-width":p.trackBorderWidth}),d.trackBorderWidth=d.track.strokeWidth(),d.track.attr({y:-this.trackBorderWidth%2/2}),d.scrollbarGroup=a.g().add(P),d.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:y,width:y,r:p.barBorderRadius||0}).add(d.scrollbarGroup),d.scrollbarRifles=a.path(v.swapXY([["M",-3,y/4],["L",-3,2*y/3],["M",0,y/4],["L",0,2*y/3],["M",3,y/4],["L",3,2*y/3]],p.vertical)).addClass("highcharts-scrollbar-rifles").add(d.scrollbarGroup),C||(d.scrollbar.attr({fill:p.barBackgroundColor,stroke:p.barBorderColor,"stroke-width":p.barBorderWidth}),d.scrollbarRifles.attr({stroke:p.rifleColor,"stroke-width":1})),d.scrollbarStrokeWidth=d.scrollbar.strokeWidth(),d.scrollbarGroup.translate(-d.scrollbarStrokeWidth%2/2,-d.scrollbarStrokeWidth%2/2),d.drawScrollbarButton(0),d.drawScrollbarButton(1)},v.prototype.setRange=function(d,a){var p=this,y=p.options,C=y.vertical,P=y.minWidth,z=p.barWidth,L=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$y(z)){var $=z*Math.min(a,1),N,W;d=Math.max(d,0),N=Math.ceil(z*d),p.calculatedWidth=W=correctFloat$6($-N),W<P&&(N=(z-P+W)*d,W=P);var U=Math.floor(N+p.xOffset+p.yOffset),j=W/2-.5;p.from=d,p.to=a,C?(p.scrollbarGroup[L]({translateY:U}),p.scrollbar[L]({height:W}),p.scrollbarRifles[L]({translateY:j}),p.scrollbarTop=U,p.scrollbarLeft=0):(p.scrollbarGroup[L]({translateX:U}),p.scrollbar[L]({width:W}),p.scrollbarRifles[L]({translateX:j}),p.scrollbarLeft=U,p.scrollbarTop=0),W<=12?p.scrollbarRifles.hide():p.scrollbarRifles.show(!0),y.showFull===!1&&(d<=0&&a>=1?p.group.hide():p.group.show()),p.rendered=!0}},v.prototype.shouldUpdateExtremes=function(d){return pick$16(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||d==="mouseup"||d==="touchend"||!defined$y(d)},v.prototype.trackClick=function(d){var a=this,p=a.chart.pointer.normalize(d),y=a.to-a.from,C=a.y+a.scrollbarTop,P=a.x+a.scrollbarLeft;a.options.vertical&&p.chartY>C||!a.options.vertical&&p.chartX>P?a.updatePosition(a.from+y,a.to+y):a.updatePosition(a.from-y,a.to-y),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},v.prototype.update=function(d){this.destroy(),this.init(this.chart.renderer,merge$_(!0,this.options,d),this.chart)},v.prototype.updatePosition=function(d,a){a>1&&(d=correctFloat$6(1-correctFloat$6(a-d)),a=1),d<0&&(a=correctFloat$6(a-d),d=0),this.from=d,this.to=a},v.defaultOptions=ScrollbarDefaults,v})();defaultOptions$b.scrollbar=merge$_(!0,Scrollbar.defaultOptions,defaultOptions$b.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$N=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$x=Utilities.defined,isNumber$w=Utilities.isNumber,pick$15=Utilities.pick,NavigatorAxisAdditions=(function(){function v(d){this.axis=d}return v.prototype.destroy=function(){this.axis=void 0},v.prototype.toFixedRange=function(d,a,p,y){var C=this,P=C.axis,z=P.chart,L=z&&z.fixedRange,$=(P.pointRange||0)/2,N=pick$15(p,P.translate(d,!0,!P.horiz)),W=pick$15(y,P.translate(a,!0,!P.horiz)),U=L&&(W-N)/L;return defined$x(p)||(N=correctFloat$5(N+$)),defined$x(y)||(W=correctFloat$5(W-$)),U>.7&&U<1.3&&(y?N=W-L:W=N+L),(!isNumber$w(N)||!isNumber$w(W))&&(N=W=void 0),{min:N,max:W}},v})(),NavigatorAxis=(function(){function v(){}return v.compose=function(d){d.keepProps.push("navigatorAxis"),addEvent$N(d,"init",function(){var a=this;a.navigatorAxis||(a.navigatorAxis=new NavigatorAxisAdditions(a))}),addEvent$N(d,"zoom",function(a){var p=this,y=p.chart,C=y.options,P=C.navigator,z=p.navigatorAxis,L=C.chart.pinchType,$=C.rangeSelector,N=C.chart.zoomType,W;p.isXAxis&&(P&&P.enabled||$&&$.enabled)&&(N==="y"?a.zoomed=!1:(!isTouchDevice$2&&N==="xy"||isTouchDevice$2&&L==="xy")&&p.options.range&&(W=z.previousZoom,defined$x(a.newMin)?z.previousZoom=[p.min,p.max]:W&&(a.newMin=W[0],a.newMax=W[1],z.previousZoom=void 0))),typeof a.zoomed<"u"&&a.preventDefault()})},v.AdditionsClass=NavigatorAxisAdditions,v})(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$a=DefaultOptions.defaultOptions,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$M=Utilities.addEvent,clamp$c=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$w=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$2=Utilities.erase,extend$17=Utilities.extend,find$e=Utilities.find,isArray$b=Utilities.isArray,isNumber$v=Utilities.isNumber,merge$Z=Utilities.merge,pick$14=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$b=Utilities.splat,defaultSeriesType,numExt=function(v){for(var d=[],a=1;a<arguments.length;a++)d[a-1]=arguments[a];var p=[].filter.call(d,isNumber$v);if(p.length)return Math[v].apply(0,p)};defaultSeriesType=typeof seriesTypes$6.areaspline>"u"?"line":"areaspline";extend$17(defaultOptions$a,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(v,d,a,p,y){var C=(y&&y.width||0)/2,P=Math.round(C/3)+.5,z=y&&y.height||0;return[["M",-C-1,.5],["L",C,.5],["L",C,z+.5],["L",-C-1,z+.5],["L",-C-1,.5],["M",-P,4],["L",-P,z-3],["M",P-1,4],["L",P-1,z-3]]};var Navigator=(function(){function v(d){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(d)}return v.prototype.drawHandle=function(d,a,p,y){var C=this,P=C.navigatorOptions.handles.height;C.handles[a][y](p?{translateX:Math.round(C.left+C.height/2),translateY:Math.round(C.top+parseInt(d,10)+.5-P)}:{translateX:Math.round(C.left+parseInt(d,10)),translateY:Math.round(C.top+C.height/2-P/2-1)})},v.prototype.drawOutline=function(d,a,p,y){var C=this,P=C.navigatorOptions.maskInside,z=C.outline.strokeWidth(),L=z/2,$=z%2/2,N=C.outlineHeight,W=C.scrollbarHeight||0,U=C.size,j=C.left-W,q=C.top,X,K;p?(j-=L,X=q+a+$,a=q+d+$,K=[["M",j+N,q-W-$],["L",j+N,X],["L",j,X],["L",j,a],["L",j+N,a],["L",j+N,q+U+W]],P&&K.push(["M",j+N,X-L],["L",j+N,a+L])):(d+=j+W-$,a+=j+W-$,q+=L,K=[["M",j,q],["L",d,q],["L",d,q+N],["L",a,q+N],["L",a,q],["L",j+U+W*2,q]],P&&K.push(["M",d-L,q],["L",a+L,q])),C.outline[y]({d:K})},v.prototype.drawMasks=function(d,a,p,y){var C=this,P=C.left,z=C.top,L=C.height,$,N,W,U;p?(W=[P,P,P],U=[z,z+d,z+a],N=[L,L,L],$=[d,a-d,C.size-a]):(W=[P,P+d,P+a],U=[z,z,z],N=[d,a-d,C.size-a],$=[L,L,L]),C.shades.forEach(function(j,q){j[y]({x:W[q],y:U[q],width:N[q],height:$[q]})})},v.prototype.renderElements=function(){var d=this,a=d.navigatorOptions,p=a.maskInside,y=d.chart,C=y.inverted,P=y.renderer,z,L={cursor:C?"ns-resize":"ew-resize"};d.navigatorGroup=z=P.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!p,p,!p].forEach(function($,N){d.shades[N]=P.rect().addClass("highcharts-navigator-mask"+(N===1?"-inside":"-outside")).add(z),y.styledMode||d.shades[N].attr({fill:$?a.maskFill:"rgba(0,0,0,0)"}).css(N===1&&L)}),d.outline=P.path().addClass("highcharts-navigator-outline").add(z),y.styledMode||d.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor}),a.handles.enabled&&[0,1].forEach(function($){if(a.handles.inverted=y.inverted,d.handles[$]=P.symbol(a.handles.symbols[$],-a.handles.width/2-1,0,a.handles.width,a.handles.height,a.handles),d.handles[$].attr({zIndex:7-$}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][$]).add(z),!y.styledMode){var N=a.handles;d.handles[$].attr({fill:N.backgroundColor,stroke:N.borderColor,"stroke-width":N.lineWidth}).css(L)}})},v.prototype.update=function(d){(this.series||[]).forEach(function(p){p.baseSeries&&delete p.baseSeries.navigatorSeries}),this.destroy();var a=this.chart.options;merge$Z(!0,a.navigator,this.options,d),this.init(this.chart)},v.prototype.render=function(d,a,p,y){var C=this,P=C.chart,z,L,$,N=C.scrollbarHeight,W,U=C.xAxis,j=U.pointRange||0,q=U.navigatorAxis.fake?P.xAxis[0]:U,X=C.navigatorEnabled,K,Q,te=C.rendered,ne=P.inverted,ie,ae,se,de,he=P.xAxis[0].minRange,ue=P.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$w(p))){if(d=correctFloat$4(d-j/2),a=correctFloat$4(a+j/2),!isNumber$v(d)||!isNumber$v(a))if(te)p=0,y=pick$14(U.width,q.width);else return;C.left=pick$14(U.left,P.plotLeft+N+(ne?P.plotWidth:0)),C.size=Q=W=pick$14(U.len,(ne?P.plotHeight:P.plotWidth)-2*N),ne?z=N:z=W+2*N,p=pick$14(p,U.toPixels(d,!0)),y=pick$14(y,U.toPixels(a,!0)),(!isNumber$v(p)||Math.abs(p)===1/0)&&(p=0,y=z),ae=U.toValue(p,!0),se=U.toValue(y,!0),de=Math.abs(correctFloat$4(se-ae)),de<he?this.grabbedLeft?p=U.toPixels(se-he-j,!0):this.grabbedRight&&(y=U.toPixels(ae+he+j,!0)):defined$w(ue)&&correctFloat$4(de-j)>ue&&(this.grabbedLeft?p=U.toPixels(se-ue-j,!0):this.grabbedRight&&(y=U.toPixels(ae+ue+j,!0))),C.zoomedMax=clamp$c(Math.max(p,y),0,Q),C.zoomedMin=clamp$c(C.fixedWidth?C.zoomedMax-C.fixedWidth:Math.min(p,y),0,Q),C.range=C.zoomedMax-C.zoomedMin,Q=Math.round(C.zoomedMax),K=Math.round(C.zoomedMin),X&&(C.navigatorGroup.attr({visibility:"visible"}),ie=te&&!C.hasDragged?"animate":"attr",C.drawMasks(K,Q,ne,ie),C.drawOutline(K,Q,ne,ie),C.navigatorOptions.handles.enabled&&(C.drawHandle(K,0,ne,ie),C.drawHandle(Q,1,ne,ie))),C.scrollbar&&(ne?($=C.top-N,L=C.left-N+(X||!q.opposite?0:(q.titleOffset||0)+q.axisTitleMargin),N=W+2*N):($=C.top+(X?C.height:-N),L=C.left-N),C.scrollbar.position(L,$,z,N),C.scrollbar.setRange(C.zoomedMin/(W||1),C.zoomedMax/(W||1))),C.rendered=!0}},v.prototype.addMouseEvents=function(){var d=this,a=d.chart,p=a.container,y=[],C,P;d.mouseMoveHandler=C=function(z){d.onMouseMove(z)},d.mouseUpHandler=P=function(z){d.onMouseUp(z)},y=d.getPartsEvents("mousedown"),y.push(addEvent$M(a.renderTo,"mousemove",C),addEvent$M(p.ownerDocument,"mouseup",P)),hasTouch&&(y.push(addEvent$M(a.renderTo,"touchmove",C),addEvent$M(p.ownerDocument,"touchend",P)),y.concat(d.getPartsEvents("touchstart"))),d.eventsToUnbind=y,d.series&&d.series[0]&&y.push(addEvent$M(d.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},v.prototype.getPartsEvents=function(d){var a=this,p=[];return["shades","handles"].forEach(function(y){a[y].forEach(function(C,P){p.push(addEvent$M(C.element,d,function(z){a[y+"Mousedown"](z,P)}))})}),p},v.prototype.shadesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var p=this,y=p.chart,C=p.xAxis,P=p.zoomedMin,z=p.left,L=p.size,$=p.range,N=d.chartX,W,U,j,q;y.inverted&&(N=d.chartY,z=p.top),a===1?(p.grabbedCenter=N,p.fixedWidth=$,p.dragOffset=N-P):(q=N-z-$/2,a===0?q=Math.max(0,q):a===2&&q+$>=L&&(q=L-$,p.reversedExtremes?(q-=$,U=p.getUnionExtremes().dataMin):W=p.getUnionExtremes().dataMax),q!==P&&(p.fixedWidth=$,j=C.navigatorAxis.toFixedRange(q,q+$,U,W),defined$w(j.min)&&y.xAxis[0].setExtremes(Math.min(j.min,j.max),Math.max(j.min,j.max),!0,null,{trigger:"navigator"})))},v.prototype.handlesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var p=this,y=p.chart,C=y.xAxis[0],P=p.reversedExtremes;a===0?(p.grabbedLeft=!0,p.otherHandlePos=p.zoomedMax,p.fixedExtreme=P?C.min:C.max):(p.grabbedRight=!0,p.otherHandlePos=p.zoomedMin,p.fixedExtreme=P?C.max:C.min),y.fixedRange=null},v.prototype.onMouseMove=function(d){var a=this,p=a.chart,y=a.left,C=a.navigatorSize,P=a.range,z=a.dragOffset,L=p.inverted,$;(!d.touches||d.touches[0].pageX!==0)&&(d=p.pointer.normalize(d),$=d.chartX,L&&(y=a.top,$=d.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,$-y,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,$-y)):a.grabbedCenter&&(a.hasDragged=!0,$<z?$=z:$>C+z-P&&($=C+z-P),a.render(0,0,$-z,$-z+P)),a.hasDragged&&a.scrollbar&&pick$14(a.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(d.DOMType=d.type,setTimeout(function(){a.onMouseUp(d)},0)))},v.prototype.onMouseUp=function(d){var a=this,p=a.chart,y=a.xAxis,C=a.scrollbar,P=d.DOMEvent||d,z=p.inverted,L=a.rendered&&!a.hasDragged?"animate":"attr",$,N,W,U,j,q;(a.hasDragged&&(!C||!C.hasDragged)||d.trigger==="scrollbar")&&(W=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?U=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(j=a.fixedExtreme),a.zoomedMax===a.size&&(j=a.reversedExtremes?W.dataMin:W.dataMax),a.zoomedMin===0&&(U=a.reversedExtremes?W.dataMax:W.dataMin),q=y.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,U,j),defined$w(q.min)&&p.xAxis[0].setExtremes(Math.min(q.min,q.max),Math.max(q.min,q.max),!0,a.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:P})),d.DOMType!=="mousemove"&&d.DOMType!=="touchmove"&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber$v(a.zoomedMin)&&isNumber$v(a.zoomedMax)&&(N=Math.round(a.zoomedMin),$=Math.round(a.zoomedMax),a.shades&&a.drawMasks(N,$,z,L),a.outline&&a.drawOutline(N,$,z,L),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(N,0,z,L),a.drawHandle($,1,z,L)))},v.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(d){d()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},v.prototype.removeBaseSeriesEvents=function(){var d=this.baseSeries||[];this.navigatorEnabled&&d[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&d.forEach(function(a){removeEvent$3(a,"updatedData",this.updatedDataHandler)},this),d[0].xAxis&&removeEvent$3(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},v.prototype.init=function(d){var a=d.options,p=a.navigator,y=p.enabled,C=a.scrollbar,P=C.enabled,z=y?p.height:0,L=P?C.height:0;this.handles=[],this.shades=[],this.chart=d,this.setBaseSeries(),this.height=z,this.scrollbarHeight=L,this.scrollbarEnabled=P,this.navigatorEnabled=y,this.navigatorOptions=p,this.scrollbarOptions=C,this.outlineHeight=z+L,this.opposite=pick$14(p.opposite,!!(!y&&d.inverted));var $=this,N=$.baseSeries,W=d.xAxis.length,U=d.yAxis.length,j=N&&N[0]&&N[0].xAxis||d.xAxis[0]||{options:{}};d.isDirtyBox=!0,$.navigatorEnabled?($.xAxis=new Axis(d,merge$Z({breaks:j.options.breaks,ordinal:j.options.ordinal},p.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:W,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},d.inverted?{offsets:[L,0,-L,0],width:z}:{offsets:[0,-L,0,L],height:z})),$.yAxis=new Axis(d,merge$Z(p.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:U,isInternal:!0,reversed:pick$14(p.yAxis&&p.yAxis.reversed,d.yAxis[0]&&d.yAxis[0].reversed,!1),zoomEnabled:!1},d.inverted?{width:z}:{height:z})),N||p.series.data?$.updateNavigatorSeries(!1):d.series.length===0&&($.unbindRedraw=addEvent$M(d,"beforeRedraw",function(){d.series.length>0&&!$.series&&($.setBaseSeries(),$.unbindRedraw())})),$.reversedExtremes=d.inverted&&!$.xAxis.reversed||!d.inverted&&$.xAxis.reversed,$.renderElements(),$.addMouseEvents()):($.xAxis={chart:d,navigatorAxis:{fake:!0},translate:function(q,X){var K=d.xAxis[0],Q=K.getExtremes(),te=K.len-2*L,ne=numExt("min",K.options.min,Q.dataMin),ie=numExt("max",K.options.max,Q.dataMax)-ne;return X?q*ie/te+ne:te*(q-ne)/ie},toPixels:function(q){return this.translate(q)},toValue:function(q){return this.translate(q,!0)}},$.xAxis.navigatorAxis.axis=$.xAxis,$.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind($.xAxis.navigatorAxis)),d.options.scrollbar.enabled&&(d.scrollbar=$.scrollbar=new Scrollbar(d.renderer,merge$Z(d.options.scrollbar,{margin:$.navigatorEnabled?0:10,vertical:d.inverted}),d),addEvent$M($.scrollbar,"changed",function(q){var X=$.size,K=X*this.to,Q=X*this.from;$.hasDragged=$.scrollbar.hasDragged,$.render(0,0,Q,K),this.shouldUpdateExtremes(q.DOMType)&&setTimeout(function(){$.onMouseUp(q)})})),$.addBaseSeriesEvents(),$.addChartEvents()},v.prototype.getUnionExtremes=function(d){var a=this.chart.xAxis[0],p=this.xAxis,y=p.options,C=a.options,P;return(!d||a.dataMin!==null)&&(P={dataMin:pick$14(y&&y.min,numExt("min",C.min,a.dataMin,p.dataMin,p.min)),dataMax:pick$14(y&&y.max,numExt("max",C.max,a.dataMax,p.dataMax,p.max))}),P},v.prototype.setBaseSeries=function(d,a){var p=this.chart,y=this.baseSeries=[];d=d||p.options&&p.options.navigator.baseSeries||(p.series.length?find$e(p.series,function(C){return!C.options.isInternal}).index:0),(p.series||[]).forEach(function(C,P){!C.options.isInternal&&(C.options.showInNavigator||(P===d||C.options.id===d)&&C.options.showInNavigator!==!1)&&y.push(C)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)},v.prototype.updateNavigatorSeries=function(d,a){var p=this,y=p.chart,C=p.baseSeries,P,z,L=p.navigatorOptions.series,$,N={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},W=p.series=(p.series||[]).filter(function(U){var j=U.baseSeries;return C.indexOf(j)<0?(j&&(removeEvent$3(j,"updatedData",p.updatedDataHandler),delete j.navigatorSeries),U.chart&&U.destroy(),!1):!0});C&&C.length&&C.forEach(function(j){var q=j.navigatorSeries,X=extend$17({color:j.color,visible:j.visible},isArray$b(L)?defaultOptions$a.navigator.series:L);if(!(q&&p.navigatorOptions.adaptToUpdatedData===!1)){N.name="Navigator "+C.length,P=j.options||{},$=P.navigatorOptions||{},X.dataLabels=splat$b(X.dataLabels),z=merge$Z(P,N,X,$),z.pointRange=pick$14(X.pointRange,$.pointRange,defaultOptions$a.plotOptions[z.type||"line"].pointRange);var K=$.data||X.data;p.hasNavigatorData=p.hasNavigatorData||!!K,z.data=K||P.data&&P.data.slice(0),q&&q.options?q.update(z,a):(j.navigatorSeries=y.initSeries(z),j.navigatorSeries.baseSeries=j,W.push(j.navigatorSeries))}}),(L.data&&!(C&&C.length)||isArray$b(L))&&(p.hasNavigatorData=!1,L=splat$b(L),L.forEach(function(U,j){N.name="Navigator "+(W.length+1),z=merge$Z(defaultOptions$a.navigator.series,{color:y.series[j]&&!y.series[j].options.isInternal&&y.series[j].color||y.options.colors[j]||y.options.colors[0]},N,U),z.data=U.data,z.data&&(p.hasNavigatorData=!0,W.push(y.initSeries(z)))})),d&&this.addBaseSeriesEvents()},v.prototype.addBaseSeriesEvents=function(){var d=this,a=d.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(addEvent$M(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),a.forEach(function(p){p.eventsToUnbind.push(addEvent$M(p,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),p.eventsToUnbind.push(addEvent$M(p,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&p.xAxis&&p.eventsToUnbind.push(addEvent$M(p,"updatedData",this.updatedDataHandler)),p.eventsToUnbind.push(addEvent$M(p,"remove",function(){this.navigatorSeries&&(erase$2(d.series,this.navigatorSeries),defined$w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},v.prototype.getBaseSeriesMin=function(d){return this.baseSeries.reduce(function(a,p){return Math.min(a,p.xData?p.xData[0]:a)},d)},v.prototype.modifyNavigatorAxisExtremes=function(){var d=this.xAxis,a;typeof d.getExtremes<"u"&&(a=this.getUnionExtremes(!0),a&&(a.dataMin!==d.min||a.dataMax!==d.max)&&(d.min=a.dataMin,d.max=a.dataMax))},v.prototype.modifyBaseAxisExtremes=function(){var d=this,a=d.chart.navigator,p=d.getExtremes(),y=p.min,C=p.max,P=p.dataMin,z=p.dataMax,L=C-y,$=a.stickToMin,N=a.stickToMax,W=pick$14(d.options.overscroll,0),U,j,q=a.series&&a.series[0],X=!!d.setExtremes,K=d.eventArgs&&d.eventArgs.trigger==="rangeSelectorButton";K||($&&(j=P,U=j+L),N&&(U=z+W,$||(j=Math.max(P,U-L,a.getBaseSeriesMin(q&&q.xData?q.xData[0]:-Number.MAX_VALUE)))),X&&($||N)&&isNumber$v(j)&&(d.min=d.userMin=j,d.max=d.userMax=U)),a.stickToMin=a.stickToMax=null},v.prototype.updatedDataHandler=function(){var d=this.chart.navigator,a=this,p=this.navigatorSeries;d.stickToMax=d.reversedExtremes?Math.round(d.zoomedMin)===0:Math.round(d.zoomedMax)>=Math.round(d.size),d.stickToMin=d.shouldStickToMin(a,d),p&&!d.hasNavigatorData&&(p.options.pointStart=a.xData[0],p.setData(a.options.data,!1,null,!1))},v.prototype.shouldStickToMin=function(d,a){var p=a.getBaseSeriesMin(d.xData[0]),y=d.xAxis,C=y.max,P=y.min,z=y.options.range,L=!0;return isNumber$v(C)&&isNumber$v(P)?z&&C-p>0?L=C-p<z&&!this.chart.fixedRange:L=P<=p:L=!1,L},v.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$M(this.chart,"redraw",function(){var d=this.navigator,a=d&&(d.baseSeries&&d.baseSeries[0]&&d.baseSeries[0].xAxis||this.xAxis[0]);a&&d.render(a.min,a.max)}),addEvent$M(this.chart,"getMargins",function(){var d=this,a=d.navigator,p=a.opposite?"plotTop":"marginBottom";d.inverted&&(p=a.opposite?"marginRight":"plotLeft"),d[p]=(d[p]||0)+(a.navigatorEnabled||!d.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},v.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$2(this.chart.xAxis,this.xAxis),erase$2(this.chart.axes,this.xAxis)),this.yAxis&&(erase$2(this.chart.yAxis,this.yAxis),erase$2(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(d){d.destroy&&d.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(d){this[d]&&this[d].destroy&&this[d].destroy(),this[d]=null},this),[this.handles].forEach(function(d){destroyObjectProperties$2(d)},this)},v})();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$M(Chart$1,"beforeShowResetZoom",function(){var v=this.options,d=v.navigator,a=v.rangeSelector;if((d&&d.enabled||a&&a.enabled)&&(!isTouchDevice$1&&v.chart.zoomType==="x"||isTouchDevice$1&&v.chart.pinchType==="x"))return!1}),addEvent$M(Chart$1,"beforeRender",function(){var v=this.options;(v.navigator.enabled||v.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$M(Chart$1,"afterSetChartSize",function(){var v=this.legend,d=this.navigator,a,p,y,C;d&&(p=v&&v.options,y=d.xAxis,C=d.yAxis,a=d.scrollbarHeight,this.inverted?(d.left=d.opposite?this.chartWidth-a-d.height:this.spacing[3]+a,d.top=this.plotTop+a):(d.left=pick$14(y.left,this.plotLeft+a),d.top=d.navigatorOptions.top||this.chartHeight-d.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(p&&p.verticalAlign==="bottom"&&p.layout!=="proximate"&&p.enabled&&!p.floating?v.legendHeight+pick$14(p.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),y&&C&&(this.inverted?y.options.left=C.options.left=d.left:y.options.top=C.options.top=d.top,y.setAxisSize(),C.setAxisSize()))}),addEvent$M(Chart$1,"update",function(v){var d=v.options.navigator||{},a=v.options.scrollbar||{};!this.navigator&&!this.scroller&&(d.enabled||a.enabled)&&(merge$Z(!0,this.options.navigator,d),merge$Z(!0,this.options.scrollbar,a),delete v.options.navigator,delete v.options.scrollbar)}),addEvent$M(Chart$1,"afterUpdate",function(v){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$14(v.redraw,!0)&&this.redraw(v.animation))}),addEvent$M(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$M(Series$f,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(v){var d,a=v.navigator;a&&v.xAxis[0]&&(d=v.xAxis[0].getExtremes(),a.render(d.min,d.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$9=DefaultOptions.defaultOptions,addEvent$L=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$v=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$16=Utilities.extend,find$d=Utilities.find,fireEvent$k=Utilities.fireEvent,isNumber$u=Utilities.isNumber,merge$Y=Utilities.merge,objectEach$f=Utilities.objectEach,pad=Utilities.pad,pick$13=Utilities.pick,pInt$3=Utilities.pInt,splat$a=Utilities.splat;extend$16(defaultOptions$9,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$16(defaultOptions$9.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=(function(){function v(d){this.buttons=void 0,this.buttonOptions=v.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=d,this.init(d)}return v.prototype.clickButton=function(d,a){var p=this,y=p.chart,C=p.buttonOptions[d],P=y.xAxis[0],z=y.scroller&&y.scroller.getUnionExtremes()||P||{},L=z.dataMin,$=z.dataMax,N,W=P&&Math.round(Math.min(P.max,pick$13($,P.max))),U=C.type,j,q=C._range,X,K,Q,te,ne,ie=C.dataGrouping;if(!(L===null||$===null)){if(y.fixedRange=q,p.setSelected(d),ie&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(P||{chart:this.chart},ie,!1),this.frozenStates=C.preserveDataGrouping),U==="month"||U==="year")P?(te={range:C,max:W,chart:y,dataMin:L,dataMax:$},N=P.minFromRange.call(te),isNumber$u(te.newMax)&&(W=te.newMax)):q=C;else if(q)N=Math.max(W-q,L),W=Math.min(N+q,$);else if(U==="ytd")if(P)typeof $>"u"&&(L=Number.MAX_VALUE,$=Number.MIN_VALUE,y.series.forEach(function(ae){var se=ae.xData;L=Math.min(se[0],L),$=Math.max(se[se.length-1],$)}),a=!1),ne=p.getYTDExtremes($,L,y.time.useUTC),N=X=ne.min,W=ne.max;else{p.deferredYTDClick=d;return}else U==="all"&&P&&(y.navigator&&y.navigator.baseSeries[0]&&(y.navigator.baseSeries[0].xAxis.options.range=void 0),N=L,W=$);defined$v(N)&&(N+=C._offsetMin),defined$v(W)&&(W+=C._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=d+1),P?P.setExtremes(N,W,pick$13(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:C}):(j=splat$a(y.options.xAxis)[0],Q=j.range,j.range=q,K=j.min,j.min=X,addEvent$L(y,"load",function(){j.range=Q,j.min=K})),fireEvent$k(this,"afterBtnClick")}},v.prototype.setSelected=function(d){this.selected=this.options.selected=d},v.prototype.init=function(d){var a=this,p=d.options.rangeSelector,y=p.buttons||a.defaultButtons.slice(),C=p.selected,P=function(){var z=a.minInput,L=a.maxInput;z&&z.blur&&fireEvent$k(z,"blur"),L&&L.blur&&fireEvent$k(L,"blur")};a.chart=d,a.options=p,a.buttons=[],a.buttonOptions=y,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$L(d.container,"mousedown",P)),this.eventsToUnbind.push(addEvent$L(d,"resize",P)),y.forEach(a.computeButtonRange),typeof C<"u"&&y[C]&&this.clickButton(C,!1),this.eventsToUnbind.push(addEvent$L(d,"load",function(){d.xAxis&&d.xAxis[0]&&addEvent$L(d.xAxis[0],"setExtremes",function(z){this.max-this.min!==d.fixedRange&&z.trigger!=="rangeSelectorButton"&&z.trigger!=="updatedData"&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))},v.prototype.updateButtonStates=function(){var d=this,a=this.chart,p=this.dropdown,y=a.xAxis[0],C=Math.round(y.max-y.min),P=!y.hasVisibleSeries,z=24*36e5,L=a.scroller&&a.scroller.getUnionExtremes()||y,$=L.dataMin,N=L.dataMax,W=d.getYTDExtremes(N,$,a.time.useUTC),U=W.min,j=W.max,q=d.selected,X=isNumber$u(q),K=d.options.allButtonsEnabled,Q=d.buttons;d.buttonOptions.forEach(function(te,ne){var ie=te._range,ae=te.type,se=te.count||1,de=Q[ne],he=0,ue,me,xe=te._offsetMax-te._offsetMin,we=ne===q,ye=ie>N-$,Oe=ie<y.minRange,be=!1,ke=!1,ze=ie===C;(ae==="month"||ae==="year")&&C+36e5>={month:28,year:365}[ae]*z*se-xe&&C-36e5<={month:31,year:366}[ae]*z*se+xe?ze=!0:ae==="ytd"?(ze=j-U+xe===C,be=!we):ae==="all"&&(ze=y.max-y.min>=N-$,ke=!we&&X&&ze),ue=!K&&(ye||Oe||ke||P),me=we&&ze||ze&&!X&&!be||we&&d.frozenStates,ue?he=3:me&&(X=!0,he=2),de.state!==he&&(de.setState(he),p&&(p.options[ne+1].disabled=ue,he===2&&(p.selectedIndex=ne+1)),he===0&&q===ne&&d.setSelected())})},v.prototype.computeButtonRange=function(d){var a=d.type,p=d.count||1,y={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:168*3600*1e3};y[a]?d._range=y[a]*p:(a==="month"||a==="year")&&(d._range={month:30,year:365}[a]*24*36e5*p),d._offsetMin=pick$13(d.offsetMin,0),d._offsetMax=pick$13(d.offsetMax,0),d._range+=d._offsetMax-d._offsetMin},v.prototype.getInputValue=function(d){var a=d==="min"?this.minInput:this.maxInput,p=this.chart.options.rangeSelector,y=this.chart.time;return a?(a.type==="text"&&p.inputDateParser||this.defaultInputDateParser)(a.value,y.useUTC,y):0},v.prototype.setInputValue=function(d,a){var p=this.options,y=this.chart.time,C=d==="min"?this.minInput:this.maxInput,P=d==="min"?this.minDateBox:this.maxDateBox;if(C){var z=C.getAttribute("data-hc-time"),L=defined$v(z)?Number(z):void 0;if(defined$v(a)){var $=L;defined$v($)&&C.setAttribute("data-hc-time-previous",$),C.setAttribute("data-hc-time",a),L=a}C.value=y.dateFormat(this.inputTypeFormats[C.type]||p.inputEditDateFormat,L),P&&P.attr({text:y.dateFormat(p.inputDateFormat,L)})}},v.prototype.setInputExtremes=function(d,a,p){var y=d==="min"?this.minInput:this.maxInput;if(y){var C=this.inputTypeFormats[y.type],P=this.chart.time;if(C){var z=P.dateFormat(C,a);y.min!==z&&(y.min=z);var L=P.dateFormat(C,p);y.max!==L&&(y.max=L)}}},v.prototype.showInput=function(d){var a=d==="min"?this.minDateBox:this.maxDateBox,p=d==="min"?this.minInput:this.maxInput;if(p&&a&&this.inputGroup){var y=p.type==="text",C=this.inputGroup,P=C.translateX,z=C.translateY,L=this.options.inputBoxWidth;css$2(p,{width:y?a.width+(L?-2:20)+"px":"auto",height:y?a.height-2+"px":"auto",border:"2px solid silver"}),y&&L?css$2(p,{left:P+a.x+"px",top:z+"px"}):css$2(p,{left:Math.min(Math.round(a.x+P-(p.offsetWidth-a.width)/2),this.chart.chartWidth-p.offsetWidth)+"px",top:z-(p.offsetHeight-a.height)/2+"px"})}},v.prototype.hideInput=function(d){var a=d==="min"?this.minInput:this.maxInput;a&&css$2(a,{top:"-9999em",border:0,width:"1px",height:"1px"})},v.prototype.defaultInputDateParser=function(d,a,p){var y=function($){return $.length>6&&($.lastIndexOf("-")===$.length-6||$.lastIndexOf("+")===$.length-6)},C=d.split("/").join("-").split(" ").join("T");if(C.indexOf("T")===-1&&(C+="T00:00"),a)C+="Z";else if(H.isSafari&&!y(C)){var P=new Date(C).getTimezoneOffset()/60;C+=P<=0?"+"+pad(-P)+":00":"-"+pad(P)+":00"}var z=Date.parse(C);if(!isNumber$u(z)){var L=d.split("-");z=Date.UTC(pInt$3(L[0]),pInt$3(L[1])-1,pInt$3(L[2]))}return p&&a&&isNumber$u(z)&&(z+=p.getTimezoneOffset(z)),z},v.prototype.drawInput=function(d){var a=this,p=a.chart,y=a.div,C=a.inputGroup,P=this,z=p.renderer.style||{},L=p.renderer,$=p.options.rangeSelector,N=defaultOptions$9.lang,W=d==="min";function U(){var te=P.getInputValue(d),ne=p.xAxis[0],ie=p.scroller&&p.scroller.xAxis?p.scroller.xAxis:ne,ae=ie.dataMin,se=ie.dataMax,de=P.maxInput,he=P.minInput;te!==Number(K.getAttribute("data-hc-time-previous"))&&isNumber$u(te)&&(K.setAttribute("data-hc-time-previous",te),W&&de&&isNumber$u(ae)?te>Number(de.getAttribute("data-hc-time"))?te=void 0:te<ae&&(te=ae):he&&isNumber$u(se)&&(te<Number(he.getAttribute("data-hc-time"))?te=void 0:te>se&&(te=se)),typeof te<"u"&&ne.setExtremes(W?te:ne.min,W?ne.max:te,void 0,void 0,{trigger:"rangeSelectorInput"}))}var j=N[W?"rangeSelectorFrom":"rangeSelectorTo"]||"",q=L.label(j,0).addClass("highcharts-range-label").attr({padding:j?2:0,height:j?$.inputBoxHeight:0}).add(C),X=L.label("",0).addClass("highcharts-range-input").attr({padding:2,width:$.inputBoxWidth,height:$.inputBoxHeight,"text-align":"center"}).on("click",function(){P.showInput(d),P[d+"Input"].focus()});p.styledMode||X.attr({stroke:$.inputBoxBorderColor,"stroke-width":1}),X.add(C);var K=createElement$3("input",{name:d,className:"highcharts-range-selector"},void 0,y);K.setAttribute("type",preferredInputType($.inputDateFormat||"%b %e, %Y")),p.styledMode||(q.css(merge$Y(z,$.labelStyle)),X.css(merge$Y({color:palette.neutralColor80},z,$.inputStyle)),css$2(K,extend$16({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:z.fontSize,fontFamily:z.fontFamily,top:"-9999em"},$.inputStyle))),K.onfocus=function(){P.showInput(d)},K.onblur=function(){K===H.doc.activeElement&&U(),P.hideInput(d),P.setInputValue(d),K.blur()};var Q=!1;return K.onchange=function(){Q||(U(),P.hideInput(d),K.blur())},K.onkeypress=function(te){te.keyCode===13&&U()},K.onkeydown=function(te){Q=!0,(te.keyCode===38||te.keyCode===40)&&U()},K.onkeyup=function(){Q=!1},{dateBox:X,input:K,label:q}},v.prototype.getPosition=function(){var d=this.chart,a=d.options.rangeSelector,p=a.verticalAlign==="top"?d.plotTop-d.axisOffset[0]:0;return{buttonTop:p+a.buttonPosition.y,inputTop:p+a.inputPosition.y-10}},v.prototype.getYTDExtremes=function(d,a,p){var y=this.chart.time,C,P=new y.Date(d),z=y.get("FullYear",P),L=p?y.Date.UTC(z,0,1):+new y.Date(z,0,1);C=Math.max(a,L);var $=P.getTime();return{max:Math.min(d||$,$),min:C}},v.prototype.render=function(d,a){var p=this.chart,y=p.renderer,C=p.container,P=p.options,z=P.rangeSelector,L=pick$13(P.chart.style&&P.chart.style.zIndex,0)+1,$=z.inputEnabled,N=this.rendered;if(z.enabled!==!1){if(!N&&(this.group=y.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:L}),this.buttonOptions.length&&this.renderButtons(),C.parentNode&&C.parentNode.insertBefore(this.div,C),$)){this.inputGroup=y.g("input-group").add(this.group);var W=this.drawInput("min");this.minDateBox=W.dateBox,this.minLabel=W.label,this.minInput=W.input;var U=this.drawInput("max");this.maxDateBox=U.dateBox,this.maxLabel=U.label,this.maxInput=U.input}if($){this.setInputValue("min",d),this.setInputValue("max",a);var j=p.scroller&&p.scroller.getUnionExtremes()||p.xAxis[0]||{};if(defined$v(j.dataMin)&&defined$v(j.dataMax)){var q=p.xAxis[0].minRange||0;this.setInputExtremes("min",j.dataMin,Math.min(j.dataMax,this.getInputValue("max"))-q),this.setInputExtremes("max",Math.max(j.dataMin,this.getInputValue("min"))+q,j.dataMax)}if(this.inputGroup){var X=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(K){if(K){var Q=K.getBBox().width;Q&&(K.attr({x:X}),X+=Q+z.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},v.prototype.renderButtons=function(){var d=this,a=this,p=a.buttons,y=a.chart,C=a.options,P=defaultOptions$9.lang,z=y.renderer,L=merge$Y(C.buttonTheme),$=L&&L.states,N=L.width||28;delete L.width,delete L.states,this.buttonGroup=z.g("range-selector-buttons").add(this.group);var W=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$L(W,"touchstart",function(){W.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(U){var j=U[0],q=U[1];addEvent$L(W,j,function(){var X=p[d.currentButtonIndex()];X&&fireEvent$k(X.element,q||j)})}),this.zoomText=z.label(P&&P.rangeSelectorZoom||"",0).attr({padding:C.buttonTheme.padding,height:C.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(C.labelStyle),L["stroke-width"]=pick$13(L["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,W),this.buttonOptions.forEach(function(U,j){createElement$3("option",{textContent:U.title||U.text},void 0,W),p[j]=z.button(U.text,0,0,function(q){var X=U.events&&U.events.click,K;X&&(K=X.call(U,q)),K!==!1&&d.clickButton(j),d.isActive=!0},L,$&&$.hover,$&&$.select,$&&$.disabled).attr({"text-align":"center",width:N}).add(d.buttonGroup),U.title&&p[j].attr("title",U.title)})},v.prototype.alignElements=function(){var d=this,a=this,p=a.buttonGroup,y=a.buttons,C=a.chart,P=a.group,z=a.inputGroup,L=a.options,$=a.zoomText,N=C.options,W=N.exporting&&N.exporting.enabled!==!1&&N.navigation&&N.navigation.buttonOptions,U=L.buttonPosition,j=L.inputPosition,q=L.verticalAlign,X=function(Oe,be){return W&&d.titleCollision(C)&&q==="top"&&be.align==="right"&&be.y-Oe.getBBox().height-12<(W.y||0)+(W.height||0)+C.spacing[0]?-40:0},K=C.plotLeft;if(P&&U&&j){var Q=U.x-C.spacing[3];if(p){if(this.positionButtons(),!this.initialButtonGroupWidth){var te=0;$&&(te+=$.getBBox().width+5),y.forEach(function(Oe,be){te+=Oe.width,be!==y.length-1&&(te+=L.buttonSpacing)}),this.initialButtonGroupWidth=te}K-=C.spacing[3],this.updateButtonStates();var ne=X(p,U);this.alignButtonGroup(ne),P.placed=p.placed=C.hasLoaded}var ie=0;z&&(ie=X(z,j),j.align==="left"?Q=K:j.align==="right"&&(Q=-Math.max(C.axisOffset[1],-ie)),z.align({y:j.y,width:z.getBBox().width,align:j.align,x:j.x+Q-2},!0,C.spacingBox),z.placed=C.hasLoaded),this.handleCollision(ie),P.align({verticalAlign:q},!0,C.spacingBox);var ae=P.alignAttr.translateY,se=P.getBBox().height+20,de=0;if(q==="bottom"){var he=C.legend&&C.legend.options,ue=he&&he.verticalAlign==="bottom"&&he.enabled&&!he.floating?C.legend.legendHeight+pick$13(he.margin,10):0;se=se+ue-20,de=ae-se-(L.floating?0:L.y)-(C.titleOffset?C.titleOffset[2]:0)-10}q==="top"?(L.floating&&(de=0),C.titleOffset&&C.titleOffset[0]&&(de=C.titleOffset[0]),de+=C.margin[0]-C.spacing[0]||0):q==="middle"&&(j.y===U.y?de=ae:(j.y||U.y)&&(j.y<0||U.y<0?de-=Math.min(j.y,U.y):de=ae-se)),P.translate(L.x,L.y+Math.floor(de));var me=this,xe=me.minInput,we=me.maxInput,ye=me.dropdown;L.inputEnabled&&xe&&we&&(xe.style.marginTop=P.translateY+"px",we.style.marginTop=P.translateY+"px"),ye&&(ye.style.marginTop=P.translateY+"px")}},v.prototype.alignButtonGroup=function(d,a){var p=this,y=p.chart,C=p.options,P=p.buttonGroup;p.buttons;var z=C.buttonPosition,L=y.plotLeft-y.spacing[3],$=z.x-y.spacing[3];z.align==="right"?$+=d-L:z.align==="center"&&($-=L/2),P&&P.align({y:z.y,width:pick$13(a,this.initialButtonGroupWidth),align:z.align,x:$},!0,y.spacingBox)},v.prototype.positionButtons=function(){var d=this,a=d.buttons,p=d.chart,y=d.options,C=d.zoomText,P=p.hasLoaded?"animate":"attr",z=y.buttonPosition,L=p.plotLeft,$=L;C&&C.visibility!=="hidden"&&(C[P]({x:pick$13(L+z.x,L)}),$+=z.x+C.getBBox().width+5),this.buttonOptions.forEach(function(N,W){a[W].visibility!=="hidden"?(a[W][P]({x:$}),$+=a[W].width+y.buttonSpacing):a[W][P]({x:L})})},v.prototype.handleCollision=function(d){var a=this,p=this,y=p.chart,C=p.buttonGroup,P=p.inputGroup,z=this.options,L=z.buttonPosition,$=z.dropdown,N=z.inputPosition,W=function(){var q=0;return a.buttons.forEach(function(X){var K=X.getBBox();K.width>q&&(q=K.width)}),q},U=function(q){if(P&&C){var X=P.alignAttr.translateX+P.alignOptions.x-d+P.getBBox().x+2,K=P.alignOptions.width,Q=C.alignAttr.translateX+C.getBBox().x;return Q+q>X&&X+K>Q&&L.y<N.y+P.getBBox().height}return!1},j=function(){P&&C&&P.attr({translateX:P.alignAttr.translateX+(y.axisOffset[1]>=-d?0:-d),translateY:P.alignAttr.translateY+C.getBBox().height+10})};if(C){if($==="always"){this.collapseButtons(d),U(W())&&j();return}$==="never"&&this.expandButtons()}P&&C?N.align===L.align||U(this.initialButtonGroupWidth+20)?$==="responsive"?(this.collapseButtons(d),U(W())&&j()):j():$==="responsive"&&this.expandButtons():C&&$==="responsive"&&(this.initialButtonGroupWidth>y.plotWidth?this.collapseButtons(d):this.expandButtons())},v.prototype.collapseButtons=function(d){var a=this,p=a.buttons,y=a.buttonOptions,C=a.chart,P=a.dropdown,z=a.options,L=a.zoomText,$=C.userOptions.rangeSelector&&C.userOptions.rangeSelector.buttonTheme||{},N=function(j){return{text:j?j+" ▾":"▾",width:"auto",paddingLeft:pick$13(z.buttonTheme.paddingLeft,$.padding,8),paddingRight:pick$13(z.buttonTheme.paddingRight,$.padding,8)}};L&&L.hide();var W=!1;y.forEach(function(j,q){var X=p[q];X.state!==2?X.hide():(X.show(),X.attr(N(j.text)),W=!0)}),W||(P&&(P.selectedIndex=0),p[0].show(),p[0].attr(N(this.zoomText&&this.zoomText.textStr)));var U=z.buttonPosition.align;this.positionButtons(),(U==="right"||U==="center")&&this.alignButtonGroup(d,p[this.currentButtonIndex()].getBBox().width),this.showDropdown()},v.prototype.expandButtons=function(){var d=this,a=d.buttons,p=d.buttonOptions,y=d.options,C=d.zoomText;this.hideDropdown(),C&&C.show(),p.forEach(function(P,z){var L=a[z];L.show(),L.attr({text:P.text,width:y.buttonTheme.width||28,paddingLeft:pick$13(y.buttonTheme.paddingLeft,"unset"),paddingRight:pick$13(y.buttonTheme.paddingRight,"unset")}),L.state<2&&L.setState(0)}),this.positionButtons()},v.prototype.currentButtonIndex=function(){var d=this.dropdown;return d&&d.selectedIndex>0?d.selectedIndex-1:0},v.prototype.showDropdown=function(){var d=this,a=d.buttonGroup,p=d.buttons,y=d.chart,C=d.dropdown;if(a&&C){var P=a.translateX,z=a.translateY,L=p[this.currentButtonIndex()].getBBox();css$2(C,{left:y.plotLeft+P+"px",top:z+.5+"px",width:L.width+"px",height:L.height+"px"}),this.hasVisibleDropdown=!0}},v.prototype.hideDropdown=function(){var d=this.dropdown;d&&(css$2(d,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},v.prototype.getHeight=function(){var d=this,a=d.options,p=d.group,y=a.inputPosition,C=a.buttonPosition,P=a.y,z=C.y,L=y.y,$=0,N;return a.height?a.height:(this.alignElements(),$=p?p.getBBox(!0).height+13+P:0,N=Math.min(L,z),(L<0&&z<0||L>0&&z>0)&&($+=Math.abs(N)),$)},v.prototype.titleCollision=function(d){return!(d.options.title.text||d.options.subtitle.text)},v.prototype.update=function(d){var a=this.chart;merge$Y(!0,a.options.rangeSelector,d),this.destroy(),this.init(a),this.render()},v.prototype.destroy=function(){var d=this,a=d.minInput,p=d.maxInput;d.eventsToUnbind&&(d.eventsToUnbind.forEach(function(y){return y()}),d.eventsToUnbind=void 0),destroyObjectProperties$1(d.buttons),a&&(a.onfocus=a.onblur=a.onchange=null),p&&(p.onfocus=p.onblur=p.onchange=null),objectEach$f(d,function(y,C){y&&C!=="chart"&&(y instanceof SVGElement?y.destroy():y instanceof window.HTMLElement&&discardElement$2(y)),y!==v.prototype[C]&&(d[C]=null)},this)},v})();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(v){var d=v.indexOf("%L")!==-1;if(d)return"text";var a=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(y){return v.indexOf("%"+y)!==-1}),p=["H","k","I","l","M","S"].some(function(y){return v.indexOf("%"+y)!==-1});return a&&p?"datetime-local":a?"date":p?"time":"text"}Axis.prototype.minFromRange=function(){var v=this.range,d=v.type,a,p=this.max,y,C,P=this.chart.time,z=function(L,$){var N=d==="year"?"FullYear":"Month",W=new P.Date(L),U=P.get(N,W);return P.set(N,W,U+$),U===P.get(N,W)&&P.set("Date",W,0),W.getTime()-L};return isNumber$u(v)?(a=p-v,C=v):(a=p+z(p,-v.count),this.chart&&(this.chart.fixedRange=p-a)),y=pick$13(this.dataMin,Number.MIN_VALUE),isNumber$u(a)||(a=y),a<=y&&(a=y,typeof C>"u"&&(C=z(a,v.count)),this.newMax=Math.min(a+C,this.dataMax)),isNumber$u(p)||(a=void 0),a};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(v){var d,a=v.rangeSelector,p,y,C;function P(){a&&(d=v.xAxis[0].getExtremes(),p=v.legend,C=a&&a.options.verticalAlign,isNumber$u(d.min)&&a.render(d.min,d.max),p.display&&C==="top"&&C===p.options.verticalAlign&&(y=merge$Y(v.spacingBox),p.options.layout==="vertical"?y.y=v.plotTop:y.y+=a.getHeight(),p.group.placed=!1,p.align(y)))}if(a){var z=find$d(chartDestroyEvents_1,function(L){return L[0]===v});z||chartDestroyEvents_1.push([v,[addEvent$L(v.xAxis[0],"afterSetExtremes",function(L){a&&a.render(L.min,L.max)}),addEvent$L(v,"redraw",P)]]),P()}};addEvent$L(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$L(Chart$1,"beforeRender",function(){var v=this,d=v.axes,a=v.rangeSelector,p;a&&(isNumber$u(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),d.forEach(function(y){y.updateNames(),y.setScale()}),v.getAxisMargins(),a.render(),p=a.options.verticalAlign,a.options.floating||(p==="bottom"?this.extraBottomMargin=!0:p!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$L(Chart$1,"update",function(v){var d=this,a=v.options,p=a.rangeSelector,y=d.rangeSelector,C,P=this.extraBottomMargin,z=this.extraTopMargin;p&&p.enabled&&!defined$v(y)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=y=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,y&&(initRangeSelector_1(this),C=p&&p.verticalAlign||y.options&&y.options.verticalAlign,y.options.floating||(C==="bottom"?this.extraBottomMargin=!0:C!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==P||this.extraTopMargin!==z)&&(this.isDirtyBox=!0))}),addEvent$L(Chart$1,"render",function(){var v=this,d=v.rangeSelector,a;d&&!d.options.floating&&(d.render(),a=d.options.verticalAlign,a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0))}),addEvent$L(Chart$1,"getMargins",function(){var v=this.rangeSelector,d;v&&(d=v.getHeight(),this.extraTopMargin&&(this.plotTop+=d),this.extraBottomMargin&&(this.marginBottom+=d))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$L(Chart$1,"destroy",function(){for(var d=0;d<chartDestroyEvents_1.length;d++){var a=chartDestroyEvents_1[d];if(a[0]===this){a[1].forEach(function(p){return p()}),chartDestroyEvents_1.splice(d,1);return}}}),H.RangeSelector=RangeSelector}var __extends$J=(function(){var v=function(d,a){return v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,y){p.__proto__=y}||function(p,y){for(var C in y)y.hasOwnProperty(C)&&(p[C]=y[C])},v(d,a)};return function(d,a){v(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),animObject$5=animationExports.animObject,format$7=FormatUtilities.format,getOptions$3=DefaultOptions.getOptions,pointTooltipFormatter=Point$4.prototype.tooltipFormatter,_a$c=Series$f.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$K=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$b=Utilities.clamp,defined$u=Utilities.defined,extend$15=Utilities.extend,find$c=Utilities.find,isNumber$t=Utilities.isNumber,isString$4=Utilities.isString,merge$X=Utilities.merge,pick$12=Utilities.pick,splat$9=Utilities.splat,StockChart=(function(v){__extends$J(d,v);function d(){return v!==null&&v.apply(this,arguments)||this}return d.prototype.init=function(a,p){var y=getOptions$3(),C=a.xAxis,P=a.yAxis,z=pick$12(a.navigator&&a.navigator.enabled,y.navigator.enabled,!0);a.xAxis=a.yAxis=void 0;var L=merge$X({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:z},scrollbar:{enabled:pick$12(y.scrollbar&&y.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$12(y.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$12(y.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=C,a.yAxis=P,L.xAxis=splat$9(a.xAxis||{}).map(function($,N){return merge$X(getDefaultAxisOptions("xAxis",$),y.xAxis,y.xAxis&&y.xAxis[N],$,getForcedAxisOptions("xAxis",a))}),L.yAxis=splat$9(a.yAxis||{}).map(function($,N){return merge$X(getDefaultAxisOptions("yAxis",$),y.yAxis,y.yAxis&&y.yAxis[N],$)}),v.prototype.init.call(this,L,p)},d.prototype.createAxis=function(a,p){return p.axis=merge$X(getDefaultAxisOptions(a,p.axis),p.axis,getForcedAxisOptions(a,this.userOptions)),v.prototype.createAxis.call(this,a,p)},d})(Chart$1);(function(v){function d(a,p,y){return new v(a,p,y)}v.stockChart=d})(StockChart||(StockChart={}));function getDefaultAxisOptions(v,d){return v==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:v==="yAxis"?{labels:{y:-2},opposite:pick$12(d.opposite,!0),showLastLabel:!!(d.categories||d.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(v,d){if(v==="xAxis"){var a=getOptions$3(),p=pick$12(d.navigator&&d.navigator.enabled,a.navigator.enabled,!0),y={type:"datetime",categories:void 0};return p&&(y.startOnTick=!1,y.endOnTick=!1),y}return{}}addEvent$K(Series$f,"setOptions",function(v){var d;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?d={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(d={marker:{enabled:!1,radius:2}}),d&&(v.plotOptions[this.type]=merge$X(v.plotOptions[this.type],d)))});addEvent$K(Axis,"autoLabelAlign",function(v){var d=this.chart,a=this.options,p=d._labelPanes=d._labelPanes||{},y,C=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(y=a.top+","+a.height,!p[y]&&C.enabled&&(C.x===15&&(C.x=0),typeof C.align>"u"&&(C.align="right"),p[y]=this,v.align="right",v.preventDefault()))});addEvent$K(Axis,"destroy",function(){var v=this.chart,d=this.options&&this.options.top+","+this.options.height;d&&v._labelPanes&&v._labelPanes[d]===this&&delete v._labelPanes[d]});addEvent$K(Axis,"getPlotLinePath",function(v){var d=this,a=this.isLinked&&!this.series?this.linkedParent.series:this.series,p=d.chart,y=p.renderer,C=d.left,P=d.top,z,L,$,N,W=[],U=[],j,q,X=v.translatedValue,K=v.value,Q=v.force,te;function ne(ie){var ae=ie==="xAxis"?"yAxis":"xAxis",se=d.options[ae];return isNumber$t(se)?[p[ae][se]]:isString$4(se)?[p.get(se)]:a.map(function(de){return de[ae]})}(p.options.isStock&&v.acrossPanes!==!1&&d.coll==="xAxis"||d.coll==="yAxis")&&(v.preventDefault(),U=ne(d.coll),j=d.isXAxis?p.yAxis:p.xAxis,j.forEach(function(ie){if(!defined$u(ie.options.id)||ie.options.id.indexOf("navigator")===-1){var ae=ie.isXAxis?"yAxis":"xAxis",se=defined$u(ie.options[ae])?p[ae][ie.options[ae]]:p[ae][0];d===se&&U.push(ie)}}),q=U.length?[]:[d.isXAxis?p.yAxis[0]:p.xAxis[0]],U.forEach(function(ie){q.indexOf(ie)===-1&&!find$c(q,function(ae){return ae.pos===ie.pos&&ae.len===ie.len})&&q.push(ie)}),te=pick$12(X,d.translate(K,null,null,v.old)),isNumber$t(te)&&(d.horiz?q.forEach(function(ie){var ae;L=ie.pos,N=L+ie.len,z=$=Math.round(te+d.transB),Q!=="pass"&&(z<C||z>C+d.width)&&(Q?z=$=clamp$b(z,C,C+d.width):ae=!0),ae||W.push(["M",z,L],["L",$,N])}):q.forEach(function(ie){var ae;z=ie.pos,$=z+ie.len,L=N=Math.round(P+d.height-te),Q!=="pass"&&(L<P||L>P+d.height)&&(Q?L=N=clamp$b(L,P,P+d.height):ae=!0),ae||W.push(["M",z,L],["L",$,N])})),v.path=W.length>0?y.crispPolyLine(W,v.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(v,d){for(var a=0;a<v.length;a=a+2){var p=v[a],y=v[a+1];p[1]===y[1]&&(p[1]=y[1]=Math.round(p[1])-d%2/2),p[2]===y[2]&&(p[2]=y[2]=Math.round(p[2])+d%2/2)}return v};addEvent$K(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$K(Axis,"afterDrawCrosshair",function(v){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$t(this.min)||!isNumber$t(this.max))){var d=this.chart,a=this.logarithmic,p=this.crosshair.label,y=this.horiz,C=this.opposite,P=this.left,z=this.top,L=this.crossLabel,$,N,W,U=p.format,j="",q,X,K=this.options.tickPosition==="inside",Q=this.crosshair.snap!==!1,te=0,ne=v.e||this.cross&&this.cross.e,ie=v.point,ae=this.min,se=this.max;a&&(ae=a.lin2log(ae),se=a.lin2log(se)),X=y?"center":C?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",L||(L=this.crossLabel=d.renderer.label("",0,void 0,p.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(ie?ie.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:p.align||X,padding:pick$12(p.padding,8),r:pick$12(p.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||L.attr({fill:p.backgroundColor||ie&&ie.series&&ie.series.color||palette.neutralColor60,stroke:p.borderColor||"","stroke-width":p.borderWidth||0}).css(extend$15({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},p.style||{}))),y?($=Q?(ie.plotX||0)+P:ne.chartX,N=z+(C?0:this.height)):($=C?this.width+P:0,N=Q?(ie.plotY||0)+z:ne.chartY),!U&&!p.formatter&&(this.dateTime&&(j="%b %d, %Y"),U="{value"+(j?":"+j:"")+"}");var de=Q?this.isXAxis?ie.x:ie.y:this.toValue(y?ne.chartX:ne.chartY),he=ie?ie.series.isPointInside(ie):isNumber$t(de)&&de>ae&&de<se,ue="";U?ue=format$7(U,{value:de},d):p.formatter&&isNumber$t(de)&&(ue=p.formatter.call(this,de)),L.attr({text:ue,x:$,y:N,visibility:he?"visible":"hidden"}),W=L.getBBox(),isNumber$t(L.y)&&(y?(K&&!C||!K&&C)&&(N=L.y-W.height):N=L.y-W.height/2),y?q={left:P-W.x,right:P+this.width-W.x}:q={left:this.labelAlign==="left"?P:0,right:this.labelAlign==="right"?P+this.width:d.chartWidth},L.translateX<q.left&&(te=q.left-L.translateX),L.translateX+W.width>=q.right&&(te=-(L.translateX+W.width-q.right)),L.attr({x:$+te,y:N,anchorX:y?$:this.opposite?0:d.chartWidth,anchorY:y?this.opposite?d.chartHeight:0:N+W.height/2})}});Series$f.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$f.prototype.setCompare=function(v){this.initCompare(v),this.userOptions.compare=v};Series$f.prototype.initCompare=function(v){this.modifyValue=v==="value"||v==="percent"?function(d,a){var p=this.compareValue;return typeof d<"u"&&typeof p<"u"?(v==="value"?d-=p:d=100*(d/p)-(this.options.compareBase===100?0:100),a&&(a.change=d),d):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$f.prototype.forceCropping=function(){var v=this.chart,d=this.options,a=d.dataGrouping,p=this.allowDG!==!1&&a&&pick$12(a.enabled,v.options.isStock);return p};Series$f.prototype.processData=function(v){var d=this,a,p=-1,y,C,P=d.options.compareStart===!0?0:1,z,L;if(seriesProcessData.apply(this,arguments),d.xAxis&&d.processedYData){for(y=d.processedXData,C=d.processedYData,z=C.length,d.pointArrayMap&&(p=d.pointArrayMap.indexOf(d.options.pointValKey||d.pointValKey||"y")),a=0;a<z-P;a++)if(L=C[a]&&p>-1?C[a][p]:C[a],isNumber$t(L)&&y[a+P]>=d.xAxis.min&&L!==0){d.compareValue=L;break}}};addEvent$K(Series$f,"afterGetExtremes",function(v){var d=v.dataExtremes;if(this.modifyValue&&d){var a=[this.modifyValue(d.dataMin),this.modifyValue(d.dataMax)];d.dataMin=arrayMin$4(a),d.dataMax=arrayMax$4(a)}});Axis.prototype.setCompare=function(v,d){this.isXAxis||(this.series.forEach(function(a){a.setCompare(v)}),pick$12(d,!0)&&this.chart.redraw())};Point$4.prototype.tooltipFormatter=function(v){var d=this,a=d.series.chart.numberFormatter;return v=v.replace("{point.change}",(d.change>0?"+":"")+a(d.change,pick$12(d.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[v])};addEvent$K(Series$f,"render",function(){var v=this.chart,d;if(!(v.is3d&&v.is3d())&&!v.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(d=this.yAxis.len,this.xAxis.axisLine){var a=v.plotTop+v.plotHeight-this.yAxis.pos-this.yAxis.len,p=Math.floor(this.xAxis.axisLine.strokeWidth()/2);a>=0&&(d-=Math.max(p-a,0))}if((!v.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$X(v.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=d),v.hasRendered){var y=animObject$5(this.options.animation),C=this.getSharedClipKey(y),P=v.sharedClips[C];if(P){P.animate({width:this.xAxis.len,height:d});var z=v.sharedClips[C+"m"];z&&z.animate({width:this.xAxis.len})}}}});addEvent$K(Chart$1,"update",function(v){var d=v.options;"scrollbar"in d&&this.navigator&&(merge$X(!0,this.options.scrollbar,d.scrollbar),this.navigator.update({},!1),delete d.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;G$6.Scrollbar=Scrollbar;G$6.StockChart=G$6.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$6.Axis);OrdinalAxis$1.compose(G$6.Axis,G$6.Series,G$6.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$8.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$W=Utilities.merge;function addClass$1(v,d){v.classList?v.classList.add(d):v.className.indexOf(d)<0&&(v.className+=d)}function escapeStringForHTML$1(v){return v.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(v){return doc$f.getElementById(v)}function getFakeMouseEvent$2(v){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(v);if(doc$f.createEvent){var d=doc$f.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(v,!0,!0,win$6,v==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),d}return{type:v}}function getHeadingTagNameForElement$1(v){var d=function(C){var P=parseInt(C.slice(1),10),z=Math.min(6,P+1);return"h"+z},a=function(C){return/H[1-6]/.test(C)},p=function(C){for(var P=C;P=P.previousSibling;){var z=P.tagName||"";if(a(z))return z}return""},y=function(C){var P=p(C);if(P)return d(P);var z=C.parentElement;if(!z)return"p";var L=z.tagName;return a(L)?d(L):y(z)};return y(v)}function removeElement$5(v){v&&v.parentNode&&v.parentNode.removeChild(v)}function reverseChildNodes$1(v){for(var d=v.childNodes.length;d--;)v.appendChild(v.childNodes[d])}function setElAttrs$4(v,d){Object.keys(d).forEach(function(a){var p=d[a];p===null?v.removeAttribute(a):v.setAttribute(a,p)})}function stripHTMLTagsFromString$2(v){return typeof v=="string"?v.replace(/<\/?[^>]+(>|$)/g,""):v}function visuallyHideElement$2(v){var d={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$W(!0,v.style,d)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$t=Utilities.defined,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent;function getChartTitle$5(v){return stripHTMLTags$3(v.options.title.text||v.langFormat("accessibility.defaultChartTitle",{chart:v}))}function getAxisDescription$2(v){return v&&(v.userOptions&&v.userOptions.accessibility&&v.userOptions.accessibility.description||v.axisTitle&&v.axisTitle.textStr||v.options.id||v.categories&&"categories"||v.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(v){var d=v.options||{};return d.accessibility&&typeof d.accessibility.rangeDescription<"u"?d.accessibility.rangeDescription:v.categories?getCategoryAxisRangeDesc(v):v.dateTime&&(v.min===0||v.dataMin===0)?getAxisTimeLengthDesc(v):getAxisFromToDescription(v)}function getCategoryAxisRangeDesc(v){var d=v.chart;return v.dataMax&&v.dataMin?d.langFormat("accessibility.axis.rangeCategories",{chart:d,axis:v,numCategories:v.dataMax-v.dataMin+1}):""}function getAxisTimeLengthDesc(v){var d=v.chart,a={},p="Seconds";a.Seconds=((v.max||0)-(v.min||0))/1e3,a.Minutes=a.Seconds/60,a.Hours=a.Minutes/60,a.Days=a.Hours/24,["Minutes","Hours","Days"].forEach(function(C){a[C]>2&&(p=C)});var y=a[p].toFixed(p!=="Seconds"&&p!=="Minutes"?1:0);return d.langFormat("accessibility.axis.timeRange"+p,{chart:d,axis:v,range:y.replace(".0","")})}function getAxisFromToDescription(v){var d=v.chart,a=d.options&&d.options.accessibility&&d.options.accessibility.screenReaderSection.axisRangeDateFormat||"",p=function(y){return v.dateTime?d.time.dateFormat(a,v[y]):v[y]};return d.langFormat("accessibility.axis.rangeFromTo",{chart:d,axis:v,rangeFrom:p("min"),rangeTo:p("max")})}function getSeriesFirstPointElement$1(v){if(v.points&&v.points.length){var d=find$b(v.points,function(a){return!!a.graphic});return d&&d.graphic&&d.graphic.element}}function getSeriesA11yElement$1(v){var d=getSeriesFirstPointElement$1(v);return d&&d.parentNode||v.graph&&v.graph.element||v.group&&v.group.element}function unhideChartElementFromAT$7(v,d){d.setAttribute("aria-hidden",!1),!(d===v.renderTo||!d.parentNode||d.parentNode===doc$e.body)&&(Array.prototype.forEach.call(d.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(v,d.parentNode))}function hideSeriesFromAT$1(v){var d=getSeriesA11yElement$1(v);d&&d.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(v,d){return d?(v.series||[]).filter(function(a){return a.name===d}):v.series}function getPointFromXY$1(v,d,a){for(var p=v.length,y;p--;)if(y=find$b(v[p].points||[],function(C){return C.x===d&&C.y===a}),y)return y}function getRelativePointAxisPosition(v,d){if(!defined$t(v.dataMin)||!defined$t(v.dataMax))return 0;var a=v.toPixels(v.dataMin),p=v.toPixels(v.dataMax),y=v.coll==="xAxis"?"x":"y",C=v.toPixels(d[y]||0);return(C-a)/(p-a)}function scrollToPoint$1(v){var d=v.series.xAxis,a=v.series.yAxis,p=d&&d.scrollbar?d:a,y=p&&p.scrollbar;if(y&&defined$t(y.to)&&defined$t(y.from)){var C=y.to-y.from,P=getRelativePointAxisPosition(p,v);y.updatePosition(P-C/2,P+C/2),fireEvent$j(y,"changed",{from:y.from,to:y.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$a=Utilities.find;function KeyboardNavigationHandler(v,d){this.chart=v,this.keyCodeMap=d.keyCodeMap||[],this.validate=d.validate,this.init=d.init,this.terminate=d.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(v){var d=v.which||v.keyCode,a=this.response.noHandler,p=find$a(this.keyCodeMap,function(y){return y[0].indexOf(d)>-1});return p?a=p[1].call(this,d,v):d===9&&(a=this.response[v.shiftKey?"prev":"next"]),a}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$14=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$14(DOMElementProvider.prototype,{createElement:function(){var v=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(v),v},destroyCreatedElements:function(){this.elements.forEach(function(v){removeElement$4(v)}),this.elements=[]}});var addEvent$J=Utilities.addEvent,extend$13=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$13(EventProvider.prototype,{addEvent:function(){var v=addEvent$J.apply(H,arguments);return this.eventRemovers.push(v),v},removeAddedEvents:function(){this.eventRemovers.forEach(function(v){v()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$12=Utilities.extend,fireEvent$i=Utilities.fireEvent,merge$V=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(v){this.chart=v,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(v,d){var a=d.type;doc$c.createEvent&&(v.dispatchEvent||v.fireEvent)?v.dispatchEvent?v.dispatchEvent(d):v.fireEvent(a,d):fireEvent$i(v,a,d)},fakeClickEvent:function(v){if(v){var d=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(v,d)}},addProxyGroup:function(v){this.createOrUpdateProxyContainer();var d=this.createElement("div");return Object.keys(v||{}).forEach(function(a){v[a]!==null&&d.setAttribute(a,v[a])}),this.chart.a11yProxyContainer.appendChild(d),d},createOrUpdateProxyContainer:function(){var v=this.chart,d=v.renderer.box;v.a11yProxyContainer=v.a11yProxyContainer||this.createProxyContainerElement(),d.nextSibling!==v.a11yProxyContainer&&v.container.insertBefore(v.a11yProxyContainer,d.nextSibling)},createProxyContainerElement:function(){var v=doc$c.createElement("div");return v.className="highcharts-a11y-proxy-container",v},createProxyButton:function(v,d,a,p,y){var C=v.element,P=this.createElement("button"),z=merge$V({"aria-label":C.getAttribute("aria-label")},a);return Object.keys(z).forEach(function(L){z[L]!==null&&P.setAttribute(L,z[L])}),P.className="highcharts-a11y-proxy-button",v.hasClass("highcharts-no-tooltip")&&(P.className+=" highcharts-no-tooltip"),y&&this.addEvent(P,"click",y),this.setProxyButtonStyle(P),this.updateProxyButtonPosition(P,p||v),this.proxyMouseEventsForButton(C,P),d.appendChild(P),z["aria-hidden"]||unhideChartElementFromAT$6(this.chart,P),P},getElementPosition:function(v){var d=v.element,a=this.chart.renderTo;if(a&&d&&d.getBoundingClientRect){var p=d.getBoundingClientRect(),y=a.getBoundingClientRect();return{x:p.left-y.left,y:p.top-y.top,width:p.right-p.left,height:p.bottom-p.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(v){merge$V(!0,v.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),v.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(v,d){var a=this.getElementPosition(d);merge$V(!0,v.style,{width:(a.width||1)+"px",height:(a.height||1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})},proxyMouseEventsForButton:function(v,d){var a=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(p){var y=p.indexOf("touch")===0;a.addEvent(d,p,function(C){var P=y?a.cloneTouchEvent(C):a.cloneMouseEvent(C);v&&a.fireEventOnWrappedOrUnwrappedElement(v,P),C.stopPropagation(),p!=="touchstart"&&p!=="touchmove"&&p!=="touchend"&&C.preventDefault()},{passive:!1})})},cloneMouseEvent:function(v){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(v.type,v);if(doc$c.createEvent){var d=doc$c.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(v.type,v.bubbles,v.cancelable,v.view||win$5,v.detail,v.screenX,v.screenY,v.clientX,v.clientY,v.ctrlKey,v.altKey,v.shiftKey,v.metaKey,v.button,v.relatedTarget),d}return getFakeMouseEvent$1(v.type)},cloneTouchEvent:function(v){var d=function(y){for(var C=[],P=0;P<y.length;++P){var z=y.item(P);z&&C.push(z)}return C};if(typeof win$5.TouchEvent=="function"){var a=new win$5.TouchEvent(v.type,{touches:d(v.touches),targetTouches:d(v.targetTouches),changedTouches:d(v.changedTouches),ctrlKey:v.ctrlKey,shiftKey:v.shiftKey,altKey:v.altKey,metaKey:v.metaKey,bubbles:v.bubbles,cancelable:v.cancelable,composed:v.composed,detail:v.detail,view:v.view});return v.defaultPrevented&&a.preventDefault(),a}var p=this.cloneMouseEvent(v);return p.touches=v.touches,p.changedTouches=v.changedTouches,p.targetTouches=v.targetTouches,p},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$12(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$I=Utilities.addEvent,fireEvent$h=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$I(doc$b,"keydown",function(v){var d=v.which||v.keyCode,a=27;d===a&&H.charts&&H.charts.forEach(function(p){p&&p.dismissPopupContent&&p.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var v=this;fireEvent$h(this,"dismissPopupContent",{},function(){v.tooltip&&v.tooltip.hide(0),v.hideExportMenu()})};function KeyboardNavigation(v,d){this.init(v,d)}KeyboardNavigation.prototype={init:function(v,d){var a=this,p=this.eventProvider=new EventProvider;this.chart=v,this.components=d,this.modules=[],this.currentModuleIx=0,this.update(),p.addEvent(this.tabindexContainer,"keydown",function(y){return a.onKeydown(y)}),p.addEvent(this.tabindexContainer,"focus",function(y){return a.onFocus(y)}),["mouseup","touchend"].forEach(function(y){return p.addEvent(doc$b,y,function(){return a.onMouseUp()})}),["mousedown","touchstart"].forEach(function(y){return p.addEvent(v.renderTo,y,function(){a.isClickingChart=!0})}),p.addEvent(v.renderTo,"mouseover",function(){a.pointerIsOverChart=!0}),p.addEvent(v.renderTo,"mouseout",function(){a.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(v){var d=this.chart.options.accessibility,a=d&&d.keyboardNavigation,p=this.components;this.updateContainerTabindex(),a&&a.enabled&&v&&v.length?(this.modules=v.reduce(function(y,C){var P=p[C].getKeyboardNavigation();return y.concat(P)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(v){var d=this.chart,a=v.relatedTarget&&d.container.contains(v.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!a&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var v=this.chart,d=this.modules&&this.modules[this.currentModuleIx||0];d&&d.terminate&&d.terminate(),v.focusElement&&v.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(v){var d=v||win$4.event,a,p=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,p){var y=p.run(d);y===p.response.success?a=!0:y===p.response.prev?a=this.prev():y===p.response.next&&(a=this.next()),a&&(d.preventDefault(),d.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(v){var d=this.modules&&this.modules[this.currentModuleIx];d&&d.terminate&&d.terminate(v),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=v;var a=this.modules&&this.modules[this.currentModuleIx];if(a){if(a.validate&&!a.validate())return this.move(v);if(a.init)return a.init(v),!0}return this.currentModuleIx=0,this.exiting=!0,v>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var v="highcharts-end-of-chart-marker-"+this.chart.index,d=getElement$1(v);this.removeExitAnchor(),d?(this.makeElementAnExitAnchor(d),this.exitAnchor=d):this.createExitAnchor()},updateContainerTabindex:function(){var v=this.chart.options.accessibility,d=v&&v.keyboardNavigation,a=!(d&&d.enabled===!1),p=this.chart,y=p.container,C;p.renderTo.hasAttribute("tabindex")?(y.removeAttribute("tabindex"),C=p.renderTo):C=y,this.tabindexContainer=C;var P=C.getAttribute("tabindex");a&&!P?C.setAttribute("tabindex","0"):a||p.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(v){var d=this.tabindexContainer.getAttribute("tabindex")||0;v.setAttribute("class","highcharts-exit-anchor"),v.setAttribute("tabindex",d),v.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(v)},createExitAnchor:function(){var v=this.chart,d=this.exitAnchor=doc$b.createElement("div");v.renderTo.appendChild(d),this.makeElementAnExitAnchor(d)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(v){var d=this.chart,a=this;this.eventProvider.addEvent(v,"focus",function(p){var y=p||win$4.event,C,P=y.relatedTarget&&d.container.contains(y.relatedTarget),z=!(P||a.exiting);z?(a.tabbingInBackwards=!0,a.tabindexContainer.focus(),delete a.tabbingInBackwards,y.preventDefault(),a.modules&&a.modules.length&&(a.currentModuleIx=a.modules.length-1,C=a.modules[a.currentModuleIx],C&&C.validate&&!C.validate()?a.prev():C&&C.init(-1))):a.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$4=animationExports.animObject,addEvent$H=Utilities.addEvent,extend$11=Utilities.extend,find$9=Utilities.find,fireEvent$g=Utilities.fireEvent,isNumber$s=Utilities.isNumber,pick$11=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(v,d){var a=v.allItems[d].pageIx,p=v.currentPage;typeof a<"u"&&a+1!==p&&v.scroll(1+a-p)}function shouldDoLegendA11y(v){var d=v.legend&&v.legend.allItems,a=v.options.legend.accessibility||{};return!!(d&&d.length&&!(v.colorAxis&&v.colorAxis.length)&&a.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(v){var d=this.legend.allItems,a=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return d[v]?(isNumber$s(a)&&d[a]&&fireEvent$g(d[a].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,v),this.setFocusToElement(d[v].legendItem,d[v].a11yProxyElement),fireEvent$g(d[v].legendGroup.element,"mouseover"),!0):!1};addEvent$H(Legend,"afterColorizeItem",function(v){var d=this.chart,a=d.options.accessibility,p=v.item;a.enabled&&p&&p.a11yProxyElement&&p.a11yProxyElement.setAttribute("aria-pressed",v.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$11(LegendComponent.prototype,{init:function(){var v=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===v.chart&&(v.updateProxiesPositions(),v.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(v.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(d){this.chart===v.chart&&this.chart.renderer&&v.updateProxyPositionForItem(d.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===v.chart&&this.chart.renderer&&v.recreateProxies()&&syncTimeout$1(function(){return v.updateProxiesPositions()},animObject$4(pick$11(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var v=this.chart.legend,d=v.allItems||[],a=v.currentPage||1,p=v.clipHeight||0;d.forEach(function(y){var C=y.pageIx||0,P=y._legendItemPos?y._legendItemPos[1]:0,z=y.legendItem?Math.round(y.legendItem.getBBox().height):0,L=P+z-v.pages[C]>p||C!==a-1;y.a11yProxyElement&&(y.a11yProxyElement.style.visibility=L?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var v=0,d=this.proxyElementsList;v<d.length;v++){var a=d[v],p=a.element,y=a.posElement;this.updateProxyButtonPosition(p,y)}},updateProxyPositionForItem:function(v){var d=find$9(this.proxyElementsList,function(a){return a.item===v});d&&this.updateProxyButtonPosition(d.element,d.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var v=this.chart,d=stripHTMLTags$2((v.legend&&v.legend.options.title&&v.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),a=v.langFormat("accessibility.legend.legendLabel"+(d?"":"NoTitle"),{chart:v,legendTitle:d,chartTitle:getChartTitle$4(v)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",a)},addLegendProxyGroup:function(){var v=this.chart.options.accessibility,d=v.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:d})},addLegendListContainer:function(){if(this.legendProxyGroup){var v=this.legendListContainer=this.createElement("ul");v.style.listStyle="none",this.legendProxyGroup.appendChild(v)}},proxyLegendItems:function(){var v=this,d=this.chart.legend&&this.chart.legend.allItems||[];d.forEach(function(a){a.legendItem&&a.legendItem.element&&v.proxyLegendItem(a)})},proxyLegendItem:function(v){if(!(!v.legendItem||!v.legendGroup||!this.legendListContainer)){var d=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(v.name),item:v}),a={tabindex:-1,"aria-pressed":v.visible,"aria-label":d},p=v.legendGroup.div?v.legendItem:v.legendGroup,y=this.createElement("li");this.legendListContainer.appendChild(y),v.a11yProxyElement=this.createProxyButton(v.legendItem,y,a,p),this.proxyElementsList.push({item:v,element:v.a11yProxyElement,posElement:p})}},getKeyboardNavigation:function(){var v=this.keyCodes,d=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[v.left,v.right,v.up,v.down],function(p){return d.onKbdArrowKey(this,p)}],[[v.enter,v.space],function(p){return H.isFirefox&&p===v.space?this.response.success:d.onKbdClick(this)}]],validate:function(){return d.shouldHaveLegendNavigation()},init:function(p){return d.onKbdNavigationInit(p)},terminate:function(){a.legend.allItems.forEach(function(p){return p.setState("",!0)})}})},onKbdArrowKey:function(v,d){var a=this.keyCodes,p=v.response,y=this.chart,C=y.options.accessibility,P=y.legend.allItems.length,z=d===a.left||d===a.up?-1:1,L=y.highlightLegendItem(this.highlightedLegendItemIx+z);return L?(this.highlightedLegendItemIx+=z,p.success):P>1&&C.keyboardNavigation.wrapAround?(v.init(z),p.success):p[z>0?"next":"prev"]},onKbdClick:function(v){var d=this.chart.legend.allItems[this.highlightedLegendItemIx];return d&&d.a11yProxyElement&&fireEvent$g(d.a11yProxyElement,"click"),v.response.success},shouldHaveLegendNavigation:function(){var v=this.chart,d=v.options.legend||{},a=v.legend&&v.legend.allItems,p=v.colorAxis&&v.colorAxis.length,y=d.accessibility||{};return!!(a&&v.legend.display&&!p&&y.enabled&&y.keyboardNavigation&&y.keyboardNavigation.enabled)},onKbdNavigationInit:function(v){var d=this.chart,a=d.legend.allItems.length-1,p=v>0?0:a;d.highlightLegendItem(p),this.highlightedLegendItemIx=p}});var extend$10=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(v){return v.exportSVGElements&&v.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var v=getExportMenuButtonElement(this);if(v){var d=v.element;d.onclick&&d.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var v=this,d=v.exportDivElements;d&&v.exportContextMenu&&(d.forEach(function(a){a&&a.className==="highcharts-menu-item"&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout"))}),v.highlightedExportItemIx=0,v.exportContextMenu.hideMenu(),v.container.focus())};Chart$1.prototype.highlightExportItem=function(v){var d=this.exportDivElements&&this.exportDivElements[v],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],p;return d&&d.tagName==="LI"&&!(d.children&&d.children.length)?(p=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,d.focus&&p&&d.focus(),a&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout")),d.onmouseover&&d.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=v,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var v=this,d;if(v.exportDivElements){for(d=v.exportDivElements.length;d--;)if(v.highlightExportItem(d))return!0}return!1};function exportingShouldHaveA11y(v){var d=v.options.exporting,a=getExportMenuButtonElement(v);return!!(d&&d.enabled!==!1&&d.accessibility&&d.accessibility.enabled&&a&&a.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$10(MenuComponent.prototype,{init:function(){var v=this.chart,d=this;this.addEvent(v,"exportMenuShown",function(){d.onMenuShown()}),this.addEvent(v,"exportMenuHidden",function(){d.onMenuHidden()})},onMenuHidden:function(){var v=this.chart.exportContextMenu;v&&v.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var v=this.chart,d=v.exportContextMenu;d&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(v,d)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(v){var d=this.exportButtonProxy;d&&d.setAttribute("aria-expanded",v)},onChartRender:function(){var v=this.chart,d=v.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(v)){this.exportProxyGroup=this.addProxyGroup(d.landmarkVerbosity==="all"?{"aria-label":v.langFormat("accessibility.exporting.exportRegionLabel",{chart:v,chartTitle:getChartTitle$3(v)}),role:"region"}:{});var a=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(a,this.exportProxyGroup,{"aria-label":v.langFormat("accessibility.exporting.menuButtonLabel",{chart:v}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var v=this.chart,d=v.exportDivElements;if(d&&d.length){d.forEach(function(p){p&&(p.tagName==="LI"&&!(p.children&&p.children.length)?p.setAttribute("tabindex",-1):p.setAttribute("aria-hidden","true"))});var a=d[0]&&d[0].parentNode;a&&(a.removeAttribute("aria-hidden"),a.setAttribute("aria-label",v.langFormat("accessibility.exporting.chartMenuLabel",{chart:v})))}},getKeyboardNavigation:function(){var v=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[v.left,v.up],function(){return a.onKbdPrevious(this)}],[[v.right,v.down],function(){return a.onKbdNext(this)}],[[v.enter,v.space],function(){return a.onKbdClick(this)}]],validate:function(){return!!d.exporting&&d.options.exporting.enabled!==!1&&d.options.exporting.accessibility.enabled!==!1},init:function(){var p=a.exportButtonProxy,y=d.exportingGroup;y&&p&&d.setFocusToElement(y,p)},terminate:function(){d.hideExportMenu()}})},onKbdPrevious:function(v){for(var d=this.chart,a=d.options.accessibility,p=v.response,y=d.highlightedExportItemIx||0;y--;)if(d.highlightExportItem(y))return p.success;return a.keyboardNavigation.wrapAround?(d.highlightLastExportItem(),p.success):p.prev},onKbdNext:function(v){for(var d=this.chart,a=d.options.accessibility,p=v.response,y=(d.highlightedExportItemIx||0)+1;y<d.exportDivElements.length;++y)if(d.highlightExportItem(y))return p.success;return a.keyboardNavigation.wrapAround?(d.highlightExportItem(0),p.success):p.next},onKbdClick:function(v){var d=this.chart,a=d.exportDivElements[d.highlightedExportItemIx],p=getExportMenuButtonElement(d).element;return this.isExportMenuShown?this.fakeClickEvent(a):(this.fakeClickEvent(p),d.highlightExportItem(0)),v.response.success}});var seriesTypes$5=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$s=Utilities.defined,extend$$=Utilities.extend,fireEvent$f=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$f.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(v){seriesTypes$5[v]&&(seriesTypes$5[v].prototype.keyboardMoveVertical=!1)});function getPointIndex(v){var d=v.index,a=v.series.points,p=a.length;if(a[d]!==v){for(;p--;)if(a[p]===v)return p}else return d}function isSkipSeries(v){var d=v.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation,p=v.options.accessibility||{},y=p.keyboardNavigation;return y&&y.enabled===!1||p.enabled===!1||v.options.enableMouseTracking===!1||!v.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=v.points.length}function isSkipPoint(v){var d=v.series.chart.options.accessibility,a=v.options.accessibility&&v.options.accessibility.enabled===!1;return v.isNull&&d.keyboardNavigation.seriesNavigation.skipNullPoints||v.visible===!1||v.isInside===!1||a||isSkipSeries(v.series)}function getClosestPoint(v,d,a,p){var y=1/0,C,P,z,L=d.points.length,$=function(N){return!(defined$s(N.plotX)&&defined$s(N.plotY))};if(!$(v)){for(;L--;)C=d.points[L],!$(C)&&(z=(v.plotX-C.plotX)*(v.plotX-C.plotX)*a+(v.plotY-C.plotY)*(v.plotY-C.plotY)*1,z<y&&(y=z,P=L));return defined$s(P)?d.points[P]:void 0}}Point$4.prototype.highlight=function(){var v=this.series.chart;return this.isNull?v.tooltip&&v.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&v.setFocusToElement(this.graphic),v.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(v){var d=this,a=d.series,p=d.highlightedPoint,y=p&&getPointIndex(p)||0,C=p&&p.series.points,P=d.series&&d.series[d.series.length-1],z=P&&P.points&&P.points[P.points.length-1],L,$;if(!a[0]||!a[0].points)return!1;if(!p)$=v?a[0].points[0]:z;else if(L=a[p.series.index+(v?1:-1)],$=C[y+(v?1:-1)],!$&&L&&($=L.points[v?0:L.points.length-1]),!$)return!1;return isSkipPoint($)?(L=$.series,isSkipSeries(L)?d.highlightedPoint=v?L.points[L.points.length-1]:L.points[0]:d.highlightedPoint=$,d.highlightAdjacentPoint(v)):$.highlight()};Series$f.prototype.highlightFirstValidPoint=function(){var v=this.chart.highlightedPoint,d=(v&&v.series)===this?getPointIndex(v):0,a=this.points,p=a.length;if(a&&p){for(var y=d;y<p;++y)if(!isSkipPoint(a[y]))return a[y].highlight();for(var C=d;C>=0;--C)if(!isSkipPoint(a[C]))return a[C].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(v){var d=this,a=d.highlightedPoint,p=d.series&&d.series[d.series.length-1],y=p&&p.points&&p.points[p.points.length-1],C,P,z;return d.highlightedPoint?(C=d.series[a.series.index+(v?-1:1)],!C||(P=getClosestPoint(a,C,4),!P)?!1:isSkipSeries(C)?(P.highlight(),z=d.highlightAdjacentSeries(v),z||(a.highlight(),!1)):(P.highlight(),P.series.highlightFirstValidPoint())):(C=v?d.series&&d.series[0]:p,P=v?C&&C.points&&C.points[0]:y,P?P.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(v){var d=this.highlightedPoint,a=1/0,p;return!defined$s(d.plotX)||!defined$s(d.plotY)?!1:(this.series.forEach(function(y){isSkipSeries(y)||y.points.forEach(function(C){if(!(!defined$s(C.plotY)||!defined$s(C.plotX)||C===d)){var P=C.plotY-d.plotY,z=Math.abs(C.plotX-d.plotX),L=Math.abs(P)*Math.abs(P)+z*z*4;y.yAxis&&y.yAxis.reversed&&(P*=-1),!(P<=0&&v||P>=0&&!v||L<5||isSkipPoint(C))&&L<a&&(a=L,p=C)}})}),p?p.highlight():!1)};function highlightFirstValidPointInChart(v){var d=!1;return delete v.highlightedPoint,d=v.series.reduce(function(a,p){return a||p.highlightFirstValidPoint()},!1),d}function highlightLastValidPointInChart(v){for(var d=v.series.length,a=d,p=!1;a--&&(v.highlightedPoint=v.series[a].points[v.series[a].points.length-1],p=v.series[a].highlightFirstValidPoint(),!p););return p}function updateChartFocusAfterDrilling(v){highlightFirstValidPointInChart(v),v.focusElement&&v.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(v,d){this.keyCodes=d,this.chart=v}extend$$(SeriesKeyboardNavigation.prototype,{init:function(){var v=this,d=this.chart,a=this.eventProvider=new EventProvider;a.addEvent(Series$f,"destroy",function(){return v.onSeriesDestroy(this)}),a.addEvent(d,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),a.addEvent(d,"drilldown",function(p){var y=p.point,C=y.series;v.lastDrilledDownPoint={x:y.x,y:y.y,seriesName:C?C.name:""}}),a.addEvent(d,"drillupall",function(){setTimeout(function(){v.onDrillupAll()},10)}),a.addEvent(Point$4,"afterSetState",function(){var p=this,y=p.graphic&&p.graphic.element;d.highlightedPoint===p&&doc$a.activeElement!==y&&y&&y.focus&&y.focus()})},onDrillupAll:function(){var v=this.lastDrilledDownPoint,d=this.chart,a=v&&getSeriesFromName(d,v.seriesName),p;v&&a&&defined$s(v.x)&&defined$s(v.y)&&(p=getPointFromXY(a,v.x,v.y)),d.container&&d.container.focus(),p&&p.highlight&&p.highlight(),d.focusElement&&d.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var v=this,d=this.keyCodes,a=this.chart,p=a.inverted;return new KeyboardNavigationHandler(a,{keyCodeMap:[[p?[d.up,d.down]:[d.left,d.right],function(y){return v.onKbdSideways(this,y)}],[p?[d.left,d.right]:[d.up,d.down],function(y){return v.onKbdVertical(this,y)}],[[d.enter,d.space],function(y,C){var P=a.highlightedPoint;return P&&(C.point=P,fireEvent$f(P.series,"click",C),P.firePointEvent("click")),this.response.success}]],init:function(y){return v.onHandlerInit(this,y)},terminate:function(){return v.onHandlerTerminate()}})},onKbdSideways:function(v,d){var a=this.keyCodes,p=d===a.right||d===a.down;return this.attemptHighlightAdjacentPoint(v,p)},onKbdVertical:function(v,d){var a=this.chart,p=this.keyCodes,y=d===p.down||d===p.right,C=a.options.accessibility.keyboardNavigation.seriesNavigation;if(C.mode&&C.mode==="serialize")return this.attemptHighlightAdjacentPoint(v,y);var P=a.highlightedPoint&&a.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return a[P](y),v.response.success},onHandlerInit:function(v,d){var a=this.chart;return d>0?highlightFirstValidPointInChart(a):highlightLastValidPointInChart(a),v.response.success},onHandlerTerminate:function(){var v=this.chart;v.tooltip&&v.tooltip.hide(0);var d=v.highlightedPoint&&v.highlightedPoint.series;d&&d.onMouseOut&&d.onMouseOut(),v.highlightedPoint&&v.highlightedPoint.onMouseOut&&v.highlightedPoint.onMouseOut(),delete v.highlightedPoint},attemptHighlightAdjacentPoint:function(v,d){var a=this.chart,p=a.options.accessibility.keyboardNavigation.wrapAround,y=a.highlightAdjacentPoint(d);return y?v.response.success:p?v.init(d?1:-1):v.response[d?"next":"prev"]},onSeriesDestroy:function(v){var d=this.chart,a=d.highlightedPoint&&d.highlightedPoint.series===v;a&&(delete d.highlightedPoint,d.focusElement&&d.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(v){var d=v.annotations||[];return d.reduce(function(a,p){return p.options&&p.options.visible!==!1&&(a=a.concat(p.labels)),a},[])}function getLabelText(v){return v.options&&v.options.accessibility&&v.options.accessibility.description||v.graphic&&v.graphic.text&&v.graphic.text.textStr||""}function getAnnotationLabelDescription(v){var d=v.options&&v.options.accessibility&&v.options.accessibility.description;if(d)return d;var a=v.chart,p=getLabelText(v),y=v.points,C=function(U){return U.graphic&&U.graphic.element&&U.graphic.element.getAttribute("aria-label")||""},P=function(U){var j=U.accessibility&&U.accessibility.valueDescription||C(U),q=U&&U.series.name||"";return(q?q+", ":"")+"data point "+j},z=y.filter(function(U){return!!U.graphic}).map(P).filter(function(U){return!!U}),L=z.length,$=L>1?"MultiplePoints":L?"SinglePoint":"NoPoints",N="accessibility.screenReaderSection.annotations.description"+$,W={annotationText:p,annotation:v,numPoints:L,annotationPoint:z[0],additionalAnnotationPoints:z.slice(1)};return a.langFormat(N,W)}function getAnnotationListItems(v){var d=getChartAnnotationLabels(v);return d.map(function(a){var p=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(a)));return p?"<li>"+p+"</li>":""})}function getAnnotationsInfoHTML$1(v){var d=v.annotations;if(!(d&&d.length))return"";var a=getAnnotationListItems(v);return'<ul style="list-style-type: none">'+a.join(" ")+"</ul>"}function getPointAnnotationTexts$1(v){var d=getChartAnnotationLabels(v.series.chart),a=d.filter(function(p){return p.points.indexOf(v)>-1});return a.length?a.map(function(p){return""+getLabelText(p)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$6=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$8=Utilities.find,isNumber$r=Utilities.isNumber,pick$10=Utilities.pick,defined$r=Utilities.defined;function findFirstPointWithGraphic(v){var d=v.index;return!v.series||!v.series.data||!defined$r(d)?null:find$8(v.series.data,function(a){return!!(a&&typeof a.index<"u"&&a.index>d&&a.graphic&&a.graphic.element)})||null}function shouldAddDummyPoint(v){var d=v.series&&v.series.is("sunburst"),a=v.isNull;return a&&!d}function makeDummyElement(v,d){var a=v.series.chart.renderer,p=a.rect(d.x,d.y,1,1);return p.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),p}function addDummyPointElement(v){var d=v.series,a=findFirstPointWithGraphic(v),p=a&&a.graphic,y=p?p.parentGroup:d.graph||d.group,C=a?{x:pick$10(v.plotX,a.plotX,0),y:pick$10(v.plotY,a.plotY,0)}:{x:pick$10(v.plotX,0),y:pick$10(v.plotY,0)},P=makeDummyElement(v,C);if(y&&y.element)return v.graphic=P,v.hasDummyGraphic=!0,P.add(y),y.element.insertBefore(P.element,p?p.element:null),P.element}function hasMorePointsThanDescriptionThreshold(v){var d=v.chart.options.accessibility,a=d.series.pointDescriptionEnabledThreshold;return!!(a!==!1&&v.points&&v.points.length>=a)}function shouldSetScreenReaderPropsOnPoints(v){var d=v.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(v)&&!d.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(v){var d=v.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation;return!!(v.points&&(v.points.length<a.pointNavigationEnabledThreshold||a.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(v){var d=v.chart,a=d.options.chart,p=a.options3d&&a.options3d.enabled,y=d.series.length>1,C=d.options.accessibility.series.describeSingleSeries,P=(v.options.accessibility||{}).exposeAsGroupOnly,z=p&&y;return!z&&(y||C||P||hasMorePointsThanDescriptionThreshold(v))}function pointNumberToString(v,d){var a=v.series.chart,p=a.options.accessibility.point||{},y=v.series.tooltipOptions||{},C=a.options.lang;return isNumber$r(d)?numberFormat(d,p.valueDecimals||y.valueDecimals||-1,C.decimalPoint,C.accessibility.thousandsSep||C.thousandsSep):d}function getSeriesDescriptionText(v){var d=v.options.accessibility||{},a=d.description;return a&&v.chart.langFormat("accessibility.series.description",{description:a,series:v})||""}function getSeriesAxisDescriptionText(v,d){var a=v[d];return v.chart.langFormat("accessibility.series."+d+"Description",{name:getAxisDescription$1(a),series:v})}function getPointA11yTimeDescription(v){var d=v.series,a=d.chart,p=a.options.accessibility.point||{},y=d.xAxis&&d.xAxis.dateTime;if(y){var C=y.getXDateFormat(v.x||0,a.options.tooltip.dateTimeLabelFormats),P=p.dateFormatter&&p.dateFormatter(v)||p.dateFormat||C;return a.time.dateFormat(P,v.x||0,void 0)}}function getPointXDescription(v){var d=getPointA11yTimeDescription(v),a=v.series.xAxis||{},p=a.categories&&defined$r(v.category)&&(""+v.category).replace("<br/>"," "),y=v.id&&v.id.indexOf("highcharts-")<0,C="x, "+v.x;return v.name||d||p||(y?v.id:C)}function getPointArrayMapValueDescription(v,d,a){var p=d||"",y=a||"",C=function(z){var L=pointNumberToString(v,pick$10(v[z],v.options[z]));return z+": "+p+L+y},P=v.series.pointArrayMap;return P.reduce(function(z,L){return z+(z.length?", ":"")+C(L)},"")}function getPointValue(v){var d=v.series,a=d.chart.options.accessibility.point||{},p=d.tooltipOptions||{},y=a.valuePrefix||p.valuePrefix||"",C=a.valueSuffix||p.valueSuffix||"",P=typeof v.value<"u"?"value":"y",z=pointNumberToString(v,v[P]);return v.isNull?d.chart.langFormat("accessibility.series.nullPointValue",{point:v}):d.pointArrayMap?getPointArrayMapValueDescription(v,y,C):y+z+C}function getPointAnnotationDescription(v){var d=v.series.chart,a="accessibility.series.pointAnnotationsDescription",p=getPointAnnotationTexts(v),y={point:v,annotations:p};return p.length?d.langFormat(a,y):""}function getPointValueDescription(v){var d=v.series,a=d.chart,p=a.options.accessibility.point.valueDescriptionFormat,y=pick$10(d.xAxis&&d.xAxis.options.accessibility&&d.xAxis.options.accessibility.enabled,!a.angular),C=y?getPointXDescription(v):"",P={point:v,index:defined$r(v.index)?v.index+1:"",xDescription:C,value:getPointValue(v),separator:y?", ":""};return format$6(p,P,a)}function defaultPointDescriptionFormatter$1(v){var d=v.series,a=d.chart,p=getPointValueDescription(v),y=v.options&&v.options.accessibility&&v.options.accessibility.description,C=y?" "+y:"",P=a.series.length>1&&d.name?" "+d.name+".":"",z=getPointAnnotationDescription(v),L=z?" "+z:"";return v.accessibility=v.accessibility||{},v.accessibility.valueDescription=p,p+C+P+L}function setPointScreenReaderAttribs(v,d){var a=v.series,p=a.chart.options.accessibility.point||{},y=a.options.accessibility||{},C=stripHTMLTags$1(y.pointDescriptionFormatter&&y.pointDescriptionFormatter(v)||p.descriptionFormatter&&p.descriptionFormatter(v)||defaultPointDescriptionFormatter$1(v));d.setAttribute("role","img"),d.setAttribute("aria-label",C)}function describePointsInSeries(v){var d=shouldSetScreenReaderPropsOnPoints(v),a=shouldSetKeyboardNavPropsOnPoints(v);(d||a)&&v.points.forEach(function(p){var y=p.graphic&&p.graphic.element||shouldAddDummyPoint(p)&&addDummyPointElement(p),C=p.options&&p.options.accessibility&&p.options.accessibility.enabled===!1;y&&(y.setAttribute("tabindex","-1"),y.style.outline="0",d&&!C?setPointScreenReaderAttribs(p,y):y.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(v){var d=v.chart,a=d.types||[],p=getSeriesDescriptionText(v),y=function(N){return d[N]&&d[N].length>1&&v[N]},C=getSeriesAxisDescriptionText(v,"xAxis"),P=getSeriesAxisDescriptionText(v,"yAxis"),z={name:v.name||"",ix:v.index+1,numSeries:d.series&&d.series.length,numPoints:v.points&&v.points.length,series:v},L=a.length>1?"Combination":"",$=d.langFormat("accessibility.series.summary."+v.type+L,z)||d.langFormat("accessibility.series.summary.default"+L,z);return $+(p?" "+p:"")+(y("yAxis")?" "+P:"")+(y("xAxis")?" "+C:"")}function describeSeriesElement(v,d){var a=v.options.accessibility||{},p=v.chart.options.accessibility,y=p.landmarkVerbosity;a.exposeAsGroupOnly?d.setAttribute("role","img"):y==="all"&&d.setAttribute("role","region"),d.setAttribute("tabindex","-1"),d.style.outline="0",d.setAttribute("aria-label",stripHTMLTags$1(p.series.descriptionFormatter&&p.series.descriptionFormatter(v)||defaultSeriesDescriptionFormatter$1(v)))}function describeSeries$1(v){var d=v.chart,a=getSeriesFirstPointElement(v),p=getSeriesA11yElement(v),y=d.is3d&&d.is3d();p&&(p.lastChild===a&&!y&&reverseChildNodes(p),describePointsInSeries(v),unhideChartElementFromAT$4(d,p),shouldDescribeSeriesElement(v)?describeSeriesElement(v,p):p.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=(function(){function v(d,a){this.chart=d,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(a)}return v.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},v.prototype.announce=function(d){var a=this;AST.setElementHTML(this.announceRegion,d),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){a.announceRegion.innerHTML="",delete a.clearAnnouncementRegionTimer},1e3)},v.prototype.addAnnounceRegion=function(d){var a=this.chart.announcerContainer||this.createAnnouncerContainer(),p=this.domElementProvider.createElement("div");return setElAttrs$3(p,{"aria-hidden":!1,"aria-live":d}),visuallyHideElement$1(p),a.appendChild(p),p},v.prototype.createAnnouncerContainer=function(){var d=this.chart,a=doc$9.createElement("div");return setElAttrs$3(a,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),d.renderTo.insertBefore(a,d.renderTo.firstChild),d.announcerContainer=a,a},v})(),extend$_=Utilities.extend,defined$q=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(v){return!!v.options.accessibility.announceNewData.enabled}function findPointInDataArray(v){var d=v.series.data.filter(function(a){return v.x===a.x&&v.y===a.y});return d.length===1?d[0]:v}function getUniqueSeries(v,d){var a=(v||[]).concat(d||[]).reduce(function(p,y){return p[y.name+y.index]=y,p},{});return Object.keys(a).map(function(p){return a[p]})}var NewDataAnnouncer=function(v){this.chart=v};extend$_(NewDataAnnouncer.prototype,{init:function(){var v=this.chart,d=v.options.accessibility.announceNewData,a=d.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(v,a),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var v=this,d=this.chart,a=this.eventProvider;a.addEvent(d,"afterDrilldown",function(){v.lastAnnouncementTime=0}),a.addEvent(Series$f,"updatedData",function(){v.onSeriesUpdatedData(this)}),a.addEvent(d,"afterAddSeries",function(p){v.onSeriesAdded(p.series)}),a.addEvent(Series$f,"addPoint",function(p){v.onPointAdded(p.point)}),a.addEvent(d,"redraw",function(){v.announceDirtyData()})},onSeriesUpdatedData:function(v){var d=this.chart;v.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[v.name+v.index]=v)},onSeriesAdded:function(v){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[v.name+v.index]=v,this.dirty.newSeries=defined$q(this.dirty.newSeries)?void 0:v)},onPointAdded:function(v){var d=v.series.chart;this.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.newPoint=defined$q(this.dirty.newPoint)?void 0:v)},announceDirtyData:function(){var v=this.chart,d=this;if(v.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=findPointInDataArray(a)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(p){return d.dirty.allSeries[p]}),this.dirty.newSeries,a),this.dirty={allSeries:{}}}},queueAnnouncement:function(v,d,a){var p=this,y=this.chart,C=y.options.accessibility.announceNewData;if(C.enabled){var P=+new Date,z=P-this.lastAnnouncementTime,L=Math.max(0,C.minAnnounceInterval-z),$=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,v),N=this.buildAnnouncementMessage($,d,a);N&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:P,message:N,series:$},this.queuedAnnouncementTimer=setTimeout(function(){p&&p.announcer&&(p.lastAnnouncementTime=+new Date,p.announcer.announce(p.queuedAnnouncement.message),delete p.queuedAnnouncement,delete p.queuedAnnouncementTimer)},L))}},buildAnnouncementMessage:function(v,d,a){var p=this.chart,y=p.options.accessibility.announceNewData;if(y.announcementFormatter){var C=y.announcementFormatter(v,d,a);if(C!==!1)return C.length?C:null}var P=H.charts&&H.charts.length>1?"Multiple":"Single",z=d?"newSeriesAnnounce"+P:a?"newPointAnnounce"+P:"newDataAnnounce",L=getChartTitle$2(p);return p.langFormat("accessibility.announceNewData."+z,{chartTitle:L,seriesDesc:d?defaultSeriesDescriptionFormatter(d):null,pointDesc:a?defaultPointDescriptionFormatter(a):null,point:a,series:d})}});var addEvent$G=Utilities.addEvent,merge$U=Utilities.merge;function isWithinDescriptionThreshold(v){var d=v.chart.options.accessibility;return v.points.length<d.series.pointDescriptionEnabledThreshold||d.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(v){var d=v.chart,a=d.options.accessibility.enabled,p=(v.options.accessibility&&v.options.accessibility.enabled)!==!1;return a&&p&&isWithinDescriptionThreshold(v)}function hasIndividualPointMarkerOptions(v){return!!(v._hasPointMarkers&&v.points&&v.points.length)}function unforceSeriesMarkerOptions(v){var d=v.resetA11yMarkerOptions;d&&merge$U(!0,v.options,{marker:{enabled:d.enabled,states:{normal:{opacity:d.states&&d.states.normal&&d.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(v){merge$U(!0,v,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(v){return v.marker.states&&v.marker.states.normal&&v.marker.states.normal.opacity||1}function unforcePointMarkerOptions(v){merge$U(!0,v.marker,{states:{normal:{opacity:getPointMarkerOpacity(v)}}})}function handleForcePointMarkers(v){for(var d=v.points.length;d--;){var a=v.points[d],p=a.options;delete a.hasForcedA11yMarker,p.marker&&(p.marker.enabled?(unforcePointMarkerOptions(p),a.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(p),a.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$G(Series$f,"render",function(){var v=this,d=v.options;shouldForceMarkers(v)?(d.marker&&d.marker.enabled===!1&&(v.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(v.options)),hasIndividualPointMarkerOptions(v)&&handleForcePointMarkers(v)):v.a11yMarkersForced&&(delete v.a11yMarkersForced,unforceSeriesMarkerOptions(v))}),addEvent$G(Series$f,"afterSetOptions",function(v){this.resetA11yMarkerOptions=merge$U(v.options.marker||{},this.userOptions.marker||{})}),addEvent$G(Series$f,"afterRender",function(){var v=this;v.chart.styledMode&&(v.markerGroup&&v.markerGroup[v.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(v)&&v.points.forEach(function(d){d.graphic&&(d.graphic[d.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),d.graphic[d.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$Z=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$Z(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var v=this;this.addEvent(Tooltip,"refresh",function(){this.chart===v.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(v){v.labelBySeries&&v.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var v=this.chart;v.series.forEach(function(d){var a=(d.options.accessibility&&d.options.accessibility.enabled)!==!1&&d.visible;a?describeSeries(d):hideSeriesFromAT(d)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$c=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Y=Utilities.extend,pick$$=Utilities.pick;function chartHasMapZoom(v){return!!(v.mapZoom&&v.mapNavButtons&&v.mapNavButtons.length)}H.Axis.prototype.panStep=function(v,d){var a=d||3,p=this.getExtremes(),y=(p.max-p.min)/a*v,C=p.max+y,P=p.min+y,z=C-P;v<0&&P<p.dataMin?(P=p.dataMin,C=P+z):v>0&&C>p.dataMax&&(C=p.dataMax,P=C-z),this.setExtremes(P,C)};var ZoomComponent=noop$c;ZoomComponent.prototype=new AccessibilityComponent;extend$Y(ZoomComponent.prototype,{init:function(){var v=this,d=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){v.addEvent(d,a,function(){v.updateProxyOverlays()})})},onChartUpdate:function(){var v=this.chart,d=this;v.mapNavButtons&&v.mapNavButtons.forEach(function(a,p){unhideChartElementFromAT$3(v,a.element),d.setMapNavButtonAttrs(a.element,"accessibility.zoom.mapZoom"+(p?"Out":"In"))})},setMapNavButtonAttrs:function(v,d){var a=this.chart,p=a.langFormat(d,{chart:a});setElAttrs$2(v,{tabindex:-1,role:"button","aria-label":p})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var v=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),v.resetZoomButton&&this.recreateProxyButtonAndGroup(v.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",v.langFormat("accessibility.zoom.resetZoomButton",{chart:v})),v.drillUpButton&&this.recreateProxyButtonAndGroup(v.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",v.langFormat("accessibility.drillUpButton",{chart:v,buttonText:v.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(v,d,a,p){removeElement(this[a]),this[a]=this.addProxyGroup(),this[d]=this.createProxyButton(v,this[a],{"aria-label":p,tabindex:-1})},getMapZoomNavigation:function(){var v=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[v.up,v.down,v.left,v.right],function(p){return a.onMapKbdArrow(this,p)}],[[v.tab],function(p,y){return a.onMapKbdTab(this,y)}],[[v.space,v.enter],function(){return a.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(d)},init:function(p){return a.onMapNavInit(p)}})},onMapKbdArrow:function(v,d){var a=this.keyCodes,p=d===a.up||d===a.down?"yAxis":"xAxis",y=d===a.left||d===a.up?-1:1;return this.chart[p][0].panStep(y),v.response.success},onMapKbdTab:function(v,d){var a,p=this.chart,y=v.response,C=d.shiftKey,P=C&&!this.focusedMapNavButtonIx||!C&&this.focusedMapNavButtonIx;return p.mapNavButtons[this.focusedMapNavButtonIx].setState(0),P?(p.mapZoom(),y[C?"prev":"next"]):(this.focusedMapNavButtonIx+=C?-1:1,a=p.mapNavButtons[this.focusedMapNavButtonIx],p.setFocusToElement(a.box,a.element),a.setState(2),y.success)},onMapKbdClick:function(v){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),v.response.success},onMapNavInit:function(v){var d=this.chart,a=d.mapNavButtons[0],p=d.mapNavButtons[1],y=v>0?a:p;d.setFocusToElement(y.box,y.element),y.setState(2),this.focusedMapNavButtonIx=v>0?0:1},simpleButtonNavigation:function(v,d,a){var p=this.keyCodes,y=this,C=this.chart;return new KeyboardNavigationHandler(C,{keyCodeMap:[[[p.tab,p.up,p.down,p.left,p.right],function(P,z){var L=P===p.tab&&z.shiftKey||P===p.left||P===p.up;return this.response[L?"prev":"next"]}],[[p.space,p.enter],function(){var P=a(this,C);return pick$$(P,this.response.success)}]],validate:function(){var P=C[v]&&C[v].box&&y[d];return P},init:function(){C.setFocusToElement(C[v].box,y[d])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(v,d){d.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(v,d){return d.drillUp(),v.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$F=Utilities.addEvent,extend$X=Utilities.extend;function shouldRunInputNavigation(v){return!!(v.rangeSelector&&v.rangeSelector.inputGroup&&v.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&v.options.rangeSelector.inputEnabled!==!1&&v.rangeSelector.minInput&&v.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(v){var d=this.rangeSelector&&this.rangeSelector.buttons||[],a=this.highlightedRangeSelectorItemIx,p=this.rangeSelector&&this.rangeSelector.selected;return typeof a<"u"&&d[a]&&a!==p&&d[a].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=v,d[v]?(this.setFocusToElement(d[v].box,d[v].element),v!==p&&(this.oldRangeSelectorItemState=d[v].state,d[v].setState(1)),!0):!1};addEvent$F(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$X(RangeSelectorComponent.prototype,{init:function(){var v=this.chart;this.announcer=new Announcer(v,"polite")},onChartUpdate:function(){var v=this.chart,d=this,a=v.rangeSelector;a&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),a.buttons&&a.buttons.length&&a.buttons.forEach(function(p){d.setRangeButtonAttrs(p)}),a.maxInput&&a.minInput&&["minInput","maxInput"].forEach(function(p,y){var C=a[p];C&&(unhideChartElementFromAT$2(v,C),d.setRangeInputAttrs(C,"accessibility.rangeSelector."+(y?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var v=this.chart,d=v.rangeSelector,a=d&&d.dropdown,p=d&&d.buttons||[],y=function(C){return C.setAttribute("aria-hidden",!0)};d&&d.hasVisibleDropdown&&a?(unhideChartElementFromAT$2(v,a),p.forEach(function(C){return y(C.element)})):(a&&y(a),p.forEach(function(C){return unhideChartElementFromAT$2(v,C.element)}))},setDropdownAttrs:function(){var v=this.chart,d=v.rangeSelector&&v.rangeSelector.dropdown;if(d){var a=v.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:v.options.lang.rangeSelectorZoom});d.setAttribute("aria-label",a),d.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(v){setElAttrs$1(v.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(v,d){var a=this.chart;setElAttrs$1(v,{tabindex:-1,"aria-label":a.langFormat(d,{chart:a})})},onButtonNavKbdArrowKey:function(v,d){var a=v.response,p=this.keyCodes,y=this.chart,C=y.options.accessibility.keyboardNavigation.wrapAround,P=d===p.left||d===p.up?-1:1,z=y.highlightRangeSelectorButton(y.highlightedRangeSelectorItemIx+P);return z?a.success:C?(v.init(P),a.success):a[P>0?"next":"prev"]},onButtonNavKbdClick:function(v){var d=v.response,a=this.chart,p=a.oldRangeSelectorItemState===3;return p||this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element),d.success},onAfterBtnClick:function(){var v=this.chart,d=getAxisRangeDescription$1(v.xAxis[0]),a=v.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:v,axisRangeDescription:d});a&&this.announcer.announce(a)},onInputKbdMove:function(v){var d=this.chart,a=d.rangeSelector,p=d.highlightedInputRangeIx=(d.highlightedInputRangeIx||0)+v,y=p>1||p<0;if(y)d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[v<0?"prev":"next"]());else if(a){var C=a[p?"maxDateBox":"minDateBox"],P=a[p?"maxInput":"minInput"];C&&P&&d.setFocusToElement(C,P)}},onInputNavInit:function(v){var d=this,a=this,p=this.chart,y=v>0?0:1,C=p.rangeSelector,P=C&&C[y?"maxDateBox":"minDateBox"],z=C&&C.minInput,L=C&&C.maxInput,$=y?L:z;if(p.highlightedInputRangeIx=y,P&&z&&L){p.setFocusToElement(P,$),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var N=function(j){var q=(j.which||j.keyCode)===d.keyCodes.tab;q&&(j.preventDefault(),j.stopPropagation(),a.onInputKbdMove(j.shiftKey?-1:1))},W=addEvent$F(z,"keydown",N),U=addEvent$F(L,"keydown",N);this.removeInputKeydownHandler=function(){W(),U()}}},onInputNavTerminate:function(){var v=this.chart.rangeSelector||{};v.maxInput&&v.hideInput("max"),v.minInput&&v.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var v=this,d=this.chart,a=d.rangeSelector,p=a&&a.dropdown;a&&p&&(d.setFocusToElement(a.buttonGroup,p),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$F(p,"keydown",function(y){var C=(y.which||y.keyCode)===v.keyCodes.tab;C&&(y.preventDefault(),y.stopPropagation(),d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[y.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var v=this.chart,d=this.keyCodes,a=this;return new KeyboardNavigationHandler(v,{keyCodeMap:[[[d.left,d.right,d.up,d.down],function(p){return a.onButtonNavKbdArrowKey(this,p)}],[[d.enter,d.space],function(){return a.onButtonNavKbdClick(this)}]],validate:function(){return!!(v.rangeSelector&&v.rangeSelector.buttons&&v.rangeSelector.buttons.length)},init:function(p){var y=v.rangeSelector;if(y&&y.hasVisibleDropdown)a.initDropdownNav();else if(y){var C=y.buttons.length-1;v.highlightRangeSelectorButton(p>0?0:C)}},terminate:function(){a.removeDropdownKeydownHandler&&(a.removeDropdownKeydownHandler(),delete a.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var v=this.chart,d=this;return new KeyboardNavigationHandler(v,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(v)},init:function(a){d.onInputNavInit(a)},terminate:function(){d.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$5=FormatUtilities.format,doc$8=H.doc,extend$W=Utilities.extend,pick$_=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(v){return v.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(v,d){return d.mapTitle?v.langFormat("accessibility.chartTypes.mapTypeDescription",d):v.langFormat("accessibility.chartTypes.unknownMap",d)}function getTypeDescForCombinationChart(v,d){return v.langFormat("accessibility.chartTypes.combinationChart",d)}function getTypeDescForEmptyChart(v,d){return v.langFormat("accessibility.chartTypes.emptyChart",d)}function buildTypeDescriptionFromSeries(v,d,a){var p=d[0],y=v.langFormat("accessibility.seriesTypeDescriptions."+p,a),C=v.series&&v.series.length<2?"Single":"Multiple";return(v.langFormat("accessibility.chartTypes."+p+C,a)||v.langFormat("accessibility.chartTypes.default"+C,a))+(y?" "+y:"")}function getTableSummary(v){return v.langFormat("accessibility.table.tableSummary",{chart:v})}Chart$1.prototype.getTypeDescription=function(v){var d=v[0],a=this.series&&this.series[0]||{},p={numSeries:this.series.length,numPoints:a.points&&a.points.length,chart:this,mapTitle:a.mapTitle};return d?d==="map"?getTypeDescForMapChart(this,p):this.types.length>1?getTypeDescForCombinationChart(this,p):buildTypeDescriptionFromSeries(this,v,p):getTypeDescForEmptyChart(this,p)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$W(InfoRegionsComponent.prototype,{init:function(){var v=this.chart,d=this;this.initRegionsDefinitions(),this.addEvent(v,"aftergetTableAST",function(a){d.onDataTableCreated(a)}),this.addEvent(v,"afterViewData",function(a){d.dataTableDiv=a,setTimeout(function(){d.focusDataTable()},300)}),this.announcer=new Announcer(v,"assertive")},initRegionsDefinitions:function(){var v=this;this.screenReaderSections={before:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.beforeChartFormatter;return a?a(d):v.defaultBeforeChartFormatter(d)},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.renderTo.firstChild)},afterInserted:function(){typeof v.sonifyButtonId<"u"&&v.initSonifyButton(v.sonifyButtonId),typeof v.dataTableButtonId<"u"&&v.initDataTableButton(v.dataTableButtonId)}},after:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.afterChartFormatter;return a?a(d):v.defaultAfterChartFormatter()},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.container.nextSibling)},afterInserted:function(){v.chart.accessibility&&v.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var v=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(d){v.updateScreenReaderSection(d)})},getLinkedDescriptionElement:function(){var v=this.chart.options,d=v.accessibility.linkedDescription;if(d){if(typeof d!="string")return d;var a=format$5(d,this.chart),p=doc$8.querySelectorAll(a);if(p.length===1)return p[0]}},setLinkedDescriptionAttrs:function(){var v=this.linkedDescriptionElement;v&&(v.setAttribute("aria-hidden","true"),addClass(v,"highcharts-linked-description"))},updateScreenReaderSection:function(v){var d=this.chart,a=this.screenReaderSections[v],p=a.buildContent(d),y=a.element=a.element||this.createElement("div"),C=y.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(y,v),AST.setElementHTML(C,p),y.appendChild(C),a.insertIntoDOM(y,d),visuallyHideElement(C),unhideChartElementFromAT$1(d,C),a.afterInserted&&a.afterInserted()},setScreenReaderSectionAttribs:function(v,d){var a="accessibility.screenReaderSection."+d+"RegionLabel",p=this.chart,y=p.langFormat(a,{chart:p,chartTitle:getChartTitle$1(p)}),C="highcharts-screen-reader-region-"+d+"-"+p.index;setElAttrs(v,{id:C,"aria-label":y}),v.style.position="relative",p.options.accessibility.landmarkVerbosity==="all"&&y&&v.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var v=this.chart,d=v.options.accessibility.screenReaderSection.beforeChartFormat,a=this.getAxesDescription(),p=v.sonify&&v.options.sonification&&v.options.sonification.enabled,y="highcharts-a11y-sonify-data-btn-"+v.index,C="hc-linkto-highcharts-data-table-"+v.index,P=getAnnotationsInfoHTML(v),z=v.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:v}),L={headingTagName:getHeadingTagNameForElement(v.renderTo),chartTitle:getChartTitle$1(v),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:a.xAxis,yAxisDescription:a.yAxis,playAsSoundButton:p?this.getSonifyButtonText(y):"",viewTableButton:v.getCSV?this.getDataTableButtonText(C):"",annotationsTitle:P?z:"",annotationsList:P},$=H.i18nFormat(d,L,v);return this.dataTableButtonId=C,this.sonifyButtonId=y,stripEmptyHTMLTags($)},defaultAfterChartFormatter:function(){var v=this.chart,d=v.options.accessibility.screenReaderSection.afterChartFormat,a={endOfChartMarker:this.getEndOfChartMarkerText()},p=H.i18nFormat(d,a,v);return stripEmptyHTMLTags(p)},getLinkedDescription:function(){var v=this.linkedDescriptionElement,d=v&&v.innerHTML||"";return stripHTMLTagsFromString(d)},getLongdescText:function(){var v=this.chart.options,d=v.caption,a=d&&d.text,p=this.getLinkedDescription();return v.accessibility.description||p||a||""},getTypeDescriptionText:function(){var v=this.chart;return v.types?v.options.accessibility.typeDescription||v.getTypeDescription(v.types):""},getDataTableButtonText:function(v){var d=this.chart,a=d.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+v+'">'+a+"</button>"},getSonifyButtonText:function(v){var d=this.chart;if(d.options.sonification&&d.options.sonification.enabled===!1)return"";var a=d.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+v+'">'+a+"</button>"},getSubtitleText:function(){var v=this.chart.options.subtitle;return stripHTMLTagsFromString(v&&v.text||"")},getEndOfChartMarkerText:function(){var v=this.chart,d=v.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:v}),a="highcharts-end-of-chart-marker-"+v.index;return'<div id="'+a+'">'+d+"</div>"},onDataTableCreated:function(v){var d=this.chart;if(d.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var a=v.tree.attributes||{};a.tabindex=-1,a.summary=getTableSummary(d),v.tree.attributes=a}},focusDataTable:function(){var v=this.dataTableDiv,d=v&&v.getElementsByTagName("table")[0];d&&d.focus&&d.focus()},initSonifyButton:function(v){var d=this,a=this.sonifyButton=getElement(v),p=this.chart,y=function(C){a&&(a.setAttribute("aria-hidden","true"),a.setAttribute("aria-label","")),C.preventDefault(),C.stopPropagation();var P=p.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:p});d.announcer.announce(P),setTimeout(function(){a&&(a.removeAttribute("aria-hidden"),a.removeAttribute("aria-label")),p.sonify&&p.sonify()},1e3)};a&&p&&(setElAttrs(a,{tabindex:-1}),a.onclick=function(C){var P=p.options.accessibility&&p.options.accessibility.screenReaderSection.onPlayAsSoundClick;(P||y).call(this,C,p)})},initDataTableButton:function(v){var d=this.viewDataTableButton=getElement(v),a=this.chart,p=v.replace("hc-linkto-","");d&&(setElAttrs(d,{tabindex:-1,"aria-expanded":!!getElement(p)}),d.onclick=a.options.accessibility.screenReaderSection.onViewDataTableClick||function(){a.viewData()})},getAxesDescription:function(){var v=this.chart,d=function(z,L){var $=v[z];return $.length>1||$[0]&&pick$_($[0].options.accessibility&&$[0].options.accessibility.enabled,L)},a=!!v.types&&v.types.indexOf("map")<0,p=!!v.hasCartesianSeries,y=d("xAxis",!v.angular&&p&&a),C=d("yAxis",p&&a),P={};return y&&(P.xAxis=this.getAxisDescriptionText("xAxis")),C&&(P.yAxis=this.getAxisDescriptionText("yAxis")),P},getAxisDescriptionText:function(v){var d=this.chart,a=d[v];return d.langFormat("accessibility.axis."+v+"Description"+(a.length>1?"Plural":"Singular"),{chart:d,names:a.map(function(p){return getAxisDescription(p)}),ranges:a.map(function(p){return getAxisRangeDescription(p)}),numAxes:a.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$V=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$V(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var v=this.chart,d="highcharts-title-"+v.index,a=stripHTMLTags(v.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(v)}));if(a.length){var p=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");p.textContent=a,p.id=d,v.renderTo.insertBefore(p,v.renderTo.firstChild)}},setSVGContainerLabel:function(){var v=this.chart,d=v.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(v)});v.renderer.box&&d.length&&v.renderer.box.setAttribute("aria-label",d)},setGraphicContainerAttrs:function(){var v=this.chart,d=v.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(v)});d.length&&v.container.setAttribute("aria-label",d)},setRenderToAttrs:function(){var v=this.chart;v.options.accessibility.landmarkVerbosity!=="disabled"?v.renderTo.setAttribute("role","region"):v.renderTo.removeAttribute("role"),v.renderTo.setAttribute("aria-label",v.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(v),chart:v}))},makeCreditsAccessible:function(){var v=this.chart,d=v.credits;d&&(d.textStr&&d.element.setAttribute("aria-label",v.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(d.textStr)})),unhideChartElementFromAT(v,d.element))},getKeyboardNavigation:function(){var v=this.chart;return new KeyboardNavigationHandler(v,{keyCodeMap:[],validate:function(){return!0},init:function(){var d=v.accessibility;d&&d.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var v=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&v)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var d=doc$6.createElement("div"),a="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";d.style.backgroundImage="url("+a+")",doc$6.body.appendChild(d);var p=(d.currentStyle||win$3.getComputedStyle(d)).backgroundImage;return doc$6.body.removeChild(d),p==="none"}return!1},setHighContrastTheme:function(v){v.highContrastModeActive=!0;var d=v.options.accessibility.highContrastTheme;v.update(d,!1),v.series.forEach(function(a){var p=d.plotOptions[a.type]||{};a.update({color:p.color||"windowText",colors:[p.color||"windowText"],borderColor:p.borderColor||"window"}),a.points.forEach(function(y){y.options&&y.options.color&&y.update({color:p.color||"windowText",borderColor:p.borderColor||"window"},!1)})}),v.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name},