import{i,a as addLumoGlobalStyles,r as registerStyles$1,f as f$2,T as ThemableMixin,b as i$1,x,d as defineCustomElement,t as themeRegistry,c as r$1,e as ThemePropertyMixin,E,B,g as addGlobalThemeStyles,h as i$2,j as t$1,k as e$2,l as T,m as b,n as color$h,o as typography,_ as __vitePreload,p as reactExports,q as clientExports,s as jsxRuntimeExports,O as Outlet}from"./indexhtml-BddW9kNQ.js";/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userColors=i`
  :host {
    --vaadin-user-color-0: #df0b92;
    --vaadin-user-color-1: #650acc;
    --vaadin-user-color-2: #097faa;
    --vaadin-user-color-3: #ad6200;
    --vaadin-user-color-4: #bf16f3;
    --vaadin-user-color-5: #084391;
    --vaadin-user-color-6: #078836;
  }

  [theme~='dark'] {
    --vaadin-user-color-0: #ff66c7;
    --vaadin-user-color-1: #9d8aff;
    --vaadin-user-color-2: #8aff66;
    --vaadin-user-color-3: #ffbd66;
    --vaadin-user-color-4: #dc6bff;
    --vaadin-user-color-5: #66fffa;
    --vaadin-user-color-6: #e6ff66;
  }
`;addLumoGlobalStyles("user-color-props",userColors);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",i`
    :host {
      transition: opacity 0.3s;
      -webkit-mask-image: none !important;
      mask-image: none !important;
    }

    :host::before {
      content: '';
      position: absolute;
      inset: 0;
      box-shadow: 0 0 0 2px var(--_active-user-color);
      border-radius: var(--lumo-border-radius-s);
      transition: box-shadow 0.3s;
    }

    :host([context$='checkbox'])::before {
      box-shadow:
        0 0 0 2px var(--lumo-base-color),
        0 0 0 4px var(--_active-user-color);
    }

    :host([context$='radio-button'])::before {
      border-radius: 50%;
      box-shadow:
        0 0 0 3px var(--lumo-base-color),
        0 0 0 5px var(--_active-user-color);
    }

    :host([context$='item'])::before {
      box-shadow: inset 0 0 0 2px var(--_active-user-color);
    }
  `,{moduleId:"lumo-field-outline"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlay=i`
  :host {
    top: var(--lumo-space-m);
    right: var(--lumo-space-m);
    bottom: var(--lumo-space-m);
    left: var(--lumo-space-m);
    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */
    /* stylelint-disable-next-line */
    outline: 0px solid transparent;
  }

  [part='overlay'] {
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-m);
    box-shadow:
      0 0 0 1px var(--lumo-shade-5pct),
      var(--lumo-box-shadow-m);
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-m);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
  }

  [part='backdrop'] {
    background-color: var(--lumo-shade-20pct);
    animation: 0.2s lumo-overlay-backdrop-enter both;
    will-change: opacity;
  }

  @keyframes lumo-overlay-backdrop-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='backdrop'] {
    animation: 0.2s lumo-overlay-backdrop-exit both;
  }

  @keyframes lumo-overlay-backdrop-exit {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;registerStyles$1("",overlay,{moduleId:"lumo-overlay"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-user-tags-overlay",[overlay,i`
      [part='overlay'] {
        box-shadow: none;
        background: transparent;
        will-change: opacity, transform;
      }

      [part='content'] {
        padding: 0;
      }

      :host([opening]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-enter ease-out both;
      }

      @keyframes lumo-user-tags-enter {
        0% {
          opacity: 0;
        }
      }

      :host([closing]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-exit both;
      }

      @keyframes lumo-user-tags-exit {
        100% {
          opacity: 0;
        }
      }
    `],{moduleId:"lumo-user-tags-overlay"});registerStyles$1("vaadin-user-tag",i`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-xxs);
      border-radius: var(--lumo-border-radius-s);
      box-shadow: var(--lumo-box-shadow-xs);
      --vaadin-user-tag-offset: var(--lumo-space-xs);
    }

    [part='name'] {
      color: var(--lumo-primary-contrast-color);
      padding: 0.3em calc(0.3em + var(--lumo-border-radius-s) / 4);
      line-height: 1;
      font-weight: 500;
      min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
    }
  `,{moduleId:"lumo-user-tag"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const directionSubscribers=[];function alignDirs(g,d,a=g.getAttribute("dir")){d?g.setAttribute("dir",d):a!=null&&g.removeAttribute("dir")}function getDocumentDir(){return document.documentElement.getAttribute("dir")}function directionUpdater(){const g=getDocumentDir();directionSubscribers.forEach(d=>{alignDirs(d,g)})}const directionObserver=new MutationObserver(directionUpdater);directionObserver.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]});const DirMixin=g=>class extends g{static get properties(){return{dir:{type:String,value:"",reflectToAttribute:!0,converter:{fromAttribute:a=>a||"",toAttribute:a=>a===""?null:a}}}}get __isRTL(){return this.getAttribute("dir")==="rtl"}connectedCallback(){super.connectedCallback(),(!this.hasAttribute("dir")||this.__restoreSubscription)&&(this.__subscribe(),alignDirs(this,getDocumentDir(),null))}attributeChangedCallback(a,p,v){if(super.attributeChangedCallback(a,p,v),a!=="dir")return;const C=getDocumentDir(),P=v===C&&directionSubscribers.indexOf(this)===-1,k=!v&&p&&directionSubscribers.indexOf(this)===-1;P||k?(this.__subscribe(),alignDirs(this,C,v)):v!==C&&p===C&&this.__unsubscribe()}disconnectedCallback(){super.disconnectedCallback(),this.__restoreSubscription=directionSubscribers.includes(this),this.__unsubscribe()}_valueToNodeAttribute(a,p,v){v==="dir"&&p===""&&!a.hasAttribute("dir")||super._valueToNodeAttribute(a,p,v)}_attributeToProperty(a,p,v){a==="dir"&&!p?this.dir="":super._attributeToProperty(a,p,v)}__subscribe(){directionSubscribers.includes(this)||directionSubscribers.push(this)}__unsubscribe(){directionSubscribers.includes(this)&&directionSubscribers.splice(directionSubscribers.indexOf(this),1)}},appliedClassMixins=new WeakMap;function wasMixinPreviouslyApplied(g,d){let a=d;for(;a;){if(appliedClassMixins.get(a)===g)return!0;a=Object.getPrototypeOf(a)}return!1}function dedupeMixin(g){return d=>{if(wasMixinPreviouslyApplied(g,d))return d;const a=g(d);return appliedClassMixins.set(a,g),a}}/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function get$7(g,d){return g.split(".").reduce((a,p)=>a?a[p]:void 0,d)}function set$2(g,d,a){const p=g.split("."),v=p.pop(),C=p.reduce((P,k)=>P[k],a);C[v]=d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const caseMap$1={},CAMEL_TO_DASH$1=/([A-Z])/gu;function camelToDash(g){return caseMap$1[g]||(caseMap$1[g]=g.replace(CAMEL_TO_DASH$1,"-$1").toLowerCase()),caseMap$1[g]}function upper$1(g){return g[0].toUpperCase()+g.substring(1)}function parseObserver(g){const[d,a]=g.split("("),p=a.replace(")","").split(",").map(v=>v.trim());return{method:d,observerProps:p}}function getOrCreateMap(g,d){return Object.prototype.hasOwnProperty.call(g,d)||(g[d]=new Map(g[d])),g[d]}const PolylitMixinImplementation=g=>{class d extends g{static enabledWarnings=[];static createProperty(p,v){[String,Boolean,Number,Array].includes(v)&&(v={type:v}),v&&v.reflectToAttribute&&(v.reflect=!0),super.createProperty(p,v)}static getOrCreateMap(p){return getOrCreateMap(this,p)}static finalize(){if(window.litIssuedWarnings&&(window.litIssuedWarnings.add("no-override-create-property"),window.litIssuedWarnings.add("no-override-get-property-descriptor")),super.finalize(),Array.isArray(this.observers)){const p=this.getOrCreateMap("__complexObservers");this.observers.forEach(v=>{const{method:C,observerProps:P}=parseObserver(v);p.set(C,P)})}}static addCheckedInitializer(p){super.addInitializer(v=>{v instanceof this&&p(v)})}static getPropertyDescriptor(p,v,C){const P=super.getPropertyDescriptor(p,v,C);let k=P;if(this.getOrCreateMap("__propKeys").set(p,v),C.sync&&(k={get:P.get,set(z){const $=this[p];f$2(z,$)&&(this[v]=z,this.requestUpdate(p,$,C),this.hasUpdated&&this.performUpdate())},configurable:!0,enumerable:!0}),C.readOnly){const z=k.set;this.addCheckedInitializer($=>{$[`_set${upper$1(p)}`]=function(D){z.call($,D)}}),k={get:k.get,set(){},configurable:!0,enumerable:!0}}if("value"in C&&this.addCheckedInitializer(z=>{const $=typeof C.value=="function"?C.value.call(z):C.value;C.readOnly?z[`_set${upper$1(p)}`]($):z[p]=$}),C.observer){const z=C.observer;this.getOrCreateMap("__observers").set(p,z),this.addCheckedInitializer($=>{$[z]||console.warn(`observer method ${z} not defined`)})}if(C.notify){if(!this.__notifyProps)this.__notifyProps=new Set;else if(!this.hasOwnProperty("__notifyProps")){const z=this.__notifyProps;this.__notifyProps=new Set(z)}this.__notifyProps.add(p)}if(C.computed){const z=`__assignComputed${p}`,$=parseObserver(C.computed);this.prototype[z]=function(...D){this[p]=this[$.method](...D)},this.getOrCreateMap("__computedObservers").set(z,$.observerProps)}return C.attribute||(C.attribute=camelToDash(p)),k}static get polylitConfig(){return{asyncFirstRender:!1}}constructor(){super(),this.__hasPolylitMixin=!0}connectedCallback(){super.connectedCallback();const p=this.getRootNode().host;p&&p.__hasPolylitMixin&&this.id&&(p.$||={},p.$[this.id]=this);const{polylitConfig:v}=this.constructor;!this.hasUpdated&&!v.asyncFirstRender&&this.performUpdate()}firstUpdated(){super.firstUpdated(),this.$||(this.$={}),[...Object.values(this.$),this.renderRoot].forEach(p=>{p.querySelectorAll("[id]").forEach(v=>{this.$[v.id]=v})})}ready(){}willUpdate(p){this.constructor.__computedObservers&&this.__runComplexObservers(p,this.constructor.__computedObservers)}updated(p){const v=this.__isReadyInvoked;this.__isReadyInvoked=!0,this.constructor.__observers&&this.__runObservers(p,this.constructor.__observers),this.constructor.__complexObservers&&this.__runComplexObservers(p,this.constructor.__complexObservers),this.__dynamicPropertyObservers&&this.__runDynamicObservers(p,this.__dynamicPropertyObservers),this.__dynamicMethodObservers&&this.__runComplexObservers(p,this.__dynamicMethodObservers),this.constructor.__notifyProps&&this.__runNotifyProps(p,this.constructor.__notifyProps),v||this.ready()}setProperties(p){Object.entries(p).forEach(([v,C])=>{const P=this.constructor.__propKeys.get(v),k=this[P];this[P]=C,this.requestUpdate(v,k)}),this.hasUpdated&&this.performUpdate()}_createMethodObserver(p){const v=getOrCreateMap(this,"__dynamicMethodObservers"),{method:C,observerProps:P}=parseObserver(p);v.set(C,P)}_createPropertyObserver(p,v){getOrCreateMap(this,"__dynamicPropertyObservers").set(v,p)}__runComplexObservers(p,v){v.forEach((C,P)=>{C.some(k=>p.has(k))&&(this[P]?this[P](...C.map(k=>this[k])):console.warn(`observer method ${P} not defined`))})}__runDynamicObservers(p,v){v.forEach((C,P)=>{p.has(C)&&this[P]&&this[P](this[C],p.get(C))})}__runObservers(p,v){p.forEach((C,P)=>{const k=v.get(P);k!==void 0&&this[k]&&this[k](this[P],C)})}__runNotifyProps(p,v){p.forEach((C,P)=>{v.has(P)&&this.dispatchEvent(new CustomEvent(`${camelToDash(P)}-changed`,{detail:{value:this[P]}}))})}_get(p,v){return get$7(p,v)}_set(p,v,C){set$2(p,v,C)}}return d},PolylitMixin=dedupeMixin(PolylitMixinImplementation);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fieldOutlineStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    user-select: none;
    opacity: 0;
    --_active-user-color: transparent;
  }

  :host([has-active-user]) {
    opacity: 1;
  }
`,userTagStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    margin: 0 0 var(--vaadin-user-tag-offset);
    opacity: 0;
    height: 1.3rem;
    transition: opacity 0.2s ease-in-out;
    background-color: var(--vaadin-user-tag-color);
    color: #fff;
    cursor: default;
    -webkit-user-select: none;
    user-select: none;
    --vaadin-user-tag-offset: 4px;
  }

  :host(.show) {
    opacity: 1;
  }

  :host(:last-of-type) {
    margin-bottom: 0;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    box-sizing: border-box;
    padding: 2px 4px;
    height: 1.3rem;
    font-size: 13px;
  }
`,userTagsOverlayStyles=i`
  [part='overlay'] {
    position: relative;
    left: -4px;
    padding: 4px;
    outline: none;
    overflow: visible;
  }

  ::slotted([part='tags']) {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
  }

  :host([dir='rtl']) [part='overlay'] {
    left: auto;
    right: -4px;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTag extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-user-tag"}static get styles(){return userTagStyles}render(){return x`<div part="name">${this.name}</div>`}static get properties(){return{name:{type:String},uid:{type:String},colorIndex:{type:Number,observer:"_colorIndexChanged"}}}ready(){super.ready(),this.addEventListener("mousedown",this._onClick.bind(this),!0)}_colorIndexChanged(d){d!=null&&this.style.setProperty("--vaadin-user-tag-color",`var(--vaadin-user-color-${d})`)}_onClick(d){d.preventDefault(),this.dispatchEvent(new CustomEvent("user-tag-click",{bubbles:!0,composed:!0,detail:{name:this.name}}))}}defineCustomElement(UserTag);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const testUserAgent=g=>g.test(navigator.userAgent),testPlatform=g=>g.test(navigator.platform),testVendor=g=>g.test(navigator.vendor),isAndroid=testUserAgent(/Android/u),isChrome=testUserAgent(/Chrome/u)&&testVendor(/Google Inc/u),isFirefox$4=testUserAgent(/Firefox/u),isIPad=testPlatform(/^iPad/u)||testPlatform(/^Mac/u)&&navigator.maxTouchPoints>1,isIPhone=testPlatform(/^iPhone/u),isIOS=isIPhone||isIPad,isSafari=testUserAgent(/^((?!chrome|android).)*safari/iu),isTouch=(()=>{try{return document.createEvent("TouchEvent"),!0}catch{return!1}})(),supportsAdoptingStyleSheets$1=window.ShadowRoot&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype;/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */let counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={},lockCount=0;const isElement=g=>g&&g.nodeType===Node.ELEMENT_NODE,logError=(...g)=>{console.error(`Error: ${g.join(" ")}. Skip setting aria-hidden.`)},correctTargets=(g,d)=>isElement(g)?d.map(a=>{if(!isElement(a))return logError(a,"is not a valid element"),null;let p=a;for(;p&&p!==g;){if(g.contains(p))return a;p=p.getRootNode().host}return logError(a,"is not contained inside",g),null}).filter(a=>!!a):(logError(g,"is not a valid element"),[]),applyAttributeToOthers=(g,d,a,p)=>{const v=correctTargets(d,Array.isArray(g)?g:[g]);markerMap[a]||(markerMap[a]=new WeakMap);const C=markerMap[a],P=[],k=new Set,z=new Set(v),$=F=>{if(!F||k.has(F))return;k.add(F);const N=F.assignedSlot;N&&$(N),$(F.parentNode||F.host)};v.forEach($);const D=F=>{if(!F||z.has(F))return;const N=F.shadowRoot;(N?[...F.children,...N.children]:[...F.children]).forEach(j=>{if(!["template","script","style"].includes(j.localName))if(k.has(j))D(j);else{const q=j.getAttribute(p),X=q!==null&&q!=="false",K=(counterMap.get(j)||0)+1,ee=(C.get(j)||0)+1;counterMap.set(j,K),C.set(j,ee),P.push(j),K===1&&X&&uncontrolledNodes.set(j,!0),ee===1&&j.setAttribute(a,"true"),X||j.setAttribute(p,"true")}})};return D(d),k.clear(),lockCount+=1,()=>{P.forEach(F=>{const N=counterMap.get(F)-1,W=C.get(F)-1;counterMap.set(F,N),C.set(F,W),N||(uncontrolledNodes.has(F)?uncontrolledNodes.delete(F):F.removeAttribute(p)),W||F.removeAttribute(a)}),lockCount-=1,lockCount||(counterMap=new WeakMap,counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={})}},hideOthers=(g,d=document.body,a="data-aria-hidden")=>{const p=Array.from(Array.isArray(g)?g:[g]);return d&&p.push(...Array.from(d.querySelectorAll("[aria-live]"))),applyAttributeToOthers(p,d,a,"aria-hidden")};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AriaModalController{constructor(d,a){this.host=d,this.callback=typeof a=="function"?a:()=>d}showModal(){const d=this.callback();this.__showOthers=hideOthers(d)}close(){this.__showOthers&&(this.__showOthers(),this.__showOthers=null)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let keyboardActive=!1;window.addEventListener("keydown",()=>{keyboardActive=!0},{capture:!0});window.addEventListener("mousedown",()=>{keyboardActive=!1},{capture:!0});function getDeepActiveElement(){let g=document.activeElement||document.body;for(;g.shadowRoot&&g.shadowRoot.activeElement;)g=g.shadowRoot.activeElement;return g}function isKeyboardActive(){return keyboardActive}function isElementHiddenDirectly(g){const d=g.style;if(d.visibility==="hidden"||d.display==="none")return!0;const a=window.getComputedStyle(g);return a.visibility==="hidden"||a.display==="none"}function hasLowerTabOrder(g,d){const a=Math.max(g.tabIndex,0),p=Math.max(d.tabIndex,0);return a===0||p===0?p>a:a>p}function mergeSortByTabIndex(g,d){const a=[];for(;g.length>0&&d.length>0;)hasLowerTabOrder(g[0],d[0])?a.push(d.shift()):a.push(g.shift());return a.concat(g,d)}function sortElementsByTabIndex(g){const d=g.length;if(d<2)return g;const a=Math.ceil(d/2),p=sortElementsByTabIndex(g.slice(0,a)),v=sortElementsByTabIndex(g.slice(a));return mergeSortByTabIndex(p,v)}function isElementHidden(g){return g.checkVisibility?!g.checkVisibility({visibilityProperty:!0}):g.offsetParent===null&&g.clientWidth===0&&g.clientHeight===0?!0:isElementHiddenDirectly(g)}function isElementFocusable(g){return g.matches('[tabindex="-1"]')?!1:g.matches("input, select, textarea, button, object")?g.matches(":not([disabled])"):g.matches("a[href], area[href], iframe, [tabindex], [contentEditable]")}function isElementFocused(g){return g.getRootNode().activeElement===g}function normalizeTabIndex(g){if(!isElementFocusable(g))return-1;const d=g.getAttribute("tabindex")||0;return Number(d)}function collectFocusableNodes(g,d){if(g.nodeType!==Node.ELEMENT_NODE||isElementHiddenDirectly(g))return!1;const a=g,p=normalizeTabIndex(a);let v=p>0;p>=0&&d.push(a);let C=[];return a.localName==="slot"?C=a.assignedNodes({flatten:!0}):C=(a.shadowRoot||a).children,[...C].forEach(P=>{v=collectFocusableNodes(P,d)||v}),v}function getFocusableElements(g){const d=[];return collectFocusableNodes(g,d)?sortElementsByTabIndex(d):d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FocusRestorationController{saveFocus(d){this.focusNode=d||getDeepActiveElement()}restoreFocus(d){const a=this.focusNode;if(!a)return;const p={preventScroll:d?d.preventScroll:!1,focusVisible:d?d.focusVisible:!1};getDeepActiveElement()===document.body?setTimeout(()=>a.focus(p)):a.focus(p),this.focusNode=null}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const instances=[];class FocusTrapController{constructor(d){this.host=d,this.__trapNode=null,this.__onKeyDown=this.__onKeyDown.bind(this)}get __focusableElements(){return getFocusableElements(this.__trapNode)}get __focusedElementIndex(){const d=this.__focusableElements;return d.indexOf(d.filter(isElementFocused).pop())}hostConnected(){document.addEventListener("keydown",this.__onKeyDown)}hostDisconnected(){document.removeEventListener("keydown",this.__onKeyDown)}trapFocus(d){if(this.__trapNode=d,this.__focusableElements.length===0)throw this.__trapNode=null,new Error("The trap node should have at least one focusable descendant or be focusable itself.");instances.push(this),this.__focusedElementIndex===-1&&this.__focusableElements[0].focus({focusVisible:isKeyboardActive()})}releaseFocus(){this.__trapNode=null,instances.pop()}__onKeyDown(d){if(this.__trapNode&&this===Array.from(instances).pop()&&d.key==="Tab"){d.preventDefault();const a=d.shiftKey;this.__focusNextElement(a)}}__focusNextElement(d=!1){const a=this.__focusableElements,p=d?-1:1,v=this.__focusedElementIndex,C=(a.length+v+p)%a.length,P=a[C];P.focus({focusVisible:!0}),P.localName==="input"&&P.select()}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ControllerMixin=dedupeMixin(g=>typeof g.prototype.addController=="function"?g:class extends g{constructor(){super(),this.__controllers=new Set}connectedCallback(){super.connectedCallback(),this.__controllers.forEach(a=>{a.hostConnected&&a.hostConnected()})}disconnectedCallback(){super.disconnectedCallback(),this.__controllers.forEach(a=>{a.hostDisconnected&&a.hostDisconnected()})}addController(a){this.__controllers.add(a),this.$!==void 0&&this.isConnected&&a.hostConnected&&a.hostConnected()}removeController(a){this.__controllers.delete(a)}});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayFocusMixin=g=>class extends ControllerMixin(g){static get properties(){return{focusTrap:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!1},restoreFocusNode:{type:HTMLElement}}}constructor(){super(),this.__ariaModalController=new AriaModalController(this),this.__focusTrapController=new FocusTrapController(this),this.__focusRestorationController=new FocusRestorationController}ready(){super.ready(),this.addController(this.__ariaModalController),this.addController(this.__focusTrapController),this.addController(this.__focusRestorationController)}_resetFocus(){if(this.focusTrap&&(this.__ariaModalController.close(),this.__focusTrapController.releaseFocus()),this.restoreFocusOnClose&&this._shouldRestoreFocus()){const a=isKeyboardActive(),p=!a;this.__focusRestorationController.restoreFocus({preventScroll:p,focusVisible:a})}}_saveFocus(){this.restoreFocusOnClose&&this.__focusRestorationController.saveFocus(this.restoreFocusNode)}_trapFocus(){this.focusTrap&&(this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.overlay))}_shouldRestoreFocus(){const a=getDeepActiveElement();return a===document.body||this._deepContains(a)}_deepContains(a){if(this.contains(a))return!0;let p=a;const v=a.ownerDocument;for(;p&&p!==v&&p!==this;)p=p.parentNode||p.host;return p===this}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getAttachedInstances=()=>Array.from(document.body.children).filter(g=>g instanceof HTMLElement&&g._hasOverlayStackMixin&&!g.hasAttribute("closing")).sort((g,d)=>g.__zIndex-d.__zIndex||0),getOverlayInstances=()=>getAttachedInstances().filter(g=>g.$.overlay),isLastOverlay$1=(g,d=a=>!0)=>{const a=getOverlayInstances().filter(d);return g===a.pop()},overlayMap=new WeakMap,setNestedOverlay=(g,d)=>{d!=null?overlayMap.set(g,d):overlayMap.delete(g)},OverlayStackMixin=g=>class extends g{constructor(){super(),this._hasOverlayStackMixin=!0}get _last(){return isLastOverlay$1(this)}bringToFront(){let a="";const p=getAttachedInstances().filter(v=>v!==this).pop();p&&(a=p.__zIndex+1),this.style.zIndex=a,this.__zIndex=a||parseFloat(getComputedStyle(this).zIndex),overlayMap.has(this)&&overlayMap.get(this).bringToFront()}_enterModalState(){document.body.style.pointerEvents!=="none"&&(this._previousDocumentPointerEvents=document.body.style.pointerEvents,document.body.style.pointerEvents="none"),getOverlayInstances().forEach(a=>{a!==this&&(a.$.overlay.style.pointerEvents="none")})}_exitModalState(){this._previousDocumentPointerEvents!==void 0&&(document.body.style.pointerEvents=this._previousDocumentPointerEvents,delete this._previousDocumentPointerEvents);const a=getOverlayInstances();let p;for(;(p=a.pop())&&!(p!==this&&(p.$.overlay.style.removeProperty("pointer-events"),!p.modeless)););}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayMixin=g=>class extends OverlayFocusMixin(OverlayStackMixin(g)){static get properties(){return{opened:{type:Boolean,notify:!0,observer:"_openedChanged",reflectToAttribute:!0,sync:!0},owner:{type:Object,sync:!0},model:{type:Object,sync:!0},renderer:{type:Object,sync:!0},modeless:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_modelessChanged",sync:!0},hidden:{type:Boolean,reflectToAttribute:!0,observer:"_hiddenChanged",sync:!0},withBackdrop:{type:Boolean,value:!1,reflectToAttribute:!0,sync:!0}}}static get observers(){return["_rendererOrDataChanged(renderer, owner, model, opened)"]}constructor(){super(),this._boundMouseDownListener=this._mouseDownListener.bind(this),this._boundMouseUpListener=this._mouseUpListener.bind(this),this._boundOutsideClickListener=this._outsideClickListener.bind(this),this._boundKeydownListener=this._keydownListener.bind(this),isIOS&&(this._boundIosResizeListener=()=>this._detectIosNavbar())}ready(){super.ready(),this.addEventListener("click",()=>{}),this.$.backdrop.addEventListener("click",()=>{}),this.addEventListener("mouseup",()=>{document.activeElement===document.body&&this.$.overlay.getAttribute("tabindex")==="0"&&this.$.overlay.focus()})}connectedCallback(){super.connectedCallback(),this._boundIosResizeListener&&(this._detectIosNavbar(),window.addEventListener("resize",this._boundIosResizeListener))}disconnectedCallback(){super.disconnectedCallback(),this._boundIosResizeListener&&window.removeEventListener("resize",this._boundIosResizeListener)}requestContentUpdate(){this.renderer&&this.renderer.call(this.owner,this,this.owner,this.model)}close(a){const p=new CustomEvent("vaadin-overlay-close",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(p),p.defaultPrevented||(this.opened=!1)}_detectIosNavbar(){if(!this.opened)return;const a=window.innerHeight,v=window.innerWidth>a,C=document.documentElement.clientHeight;v&&C>a?this.style.setProperty("--vaadin-overlay-viewport-bottom",`${C-a}px`):this.style.setProperty("--vaadin-overlay-viewport-bottom","0")}_shouldAddGlobalListeners(){return!this.modeless}_addGlobalListeners(){this.__hasGlobalListeners||(this.__hasGlobalListeners=!0,document.addEventListener("mousedown",this._boundMouseDownListener),document.addEventListener("mouseup",this._boundMouseUpListener),document.documentElement.addEventListener("click",this._boundOutsideClickListener,!0))}_removeGlobalListeners(){this.__hasGlobalListeners&&(this.__hasGlobalListeners=!1,document.removeEventListener("mousedown",this._boundMouseDownListener),document.removeEventListener("mouseup",this._boundMouseUpListener),document.documentElement.removeEventListener("click",this._boundOutsideClickListener,!0))}_rendererOrDataChanged(a,p,v,C){const P=this._oldOwner!==p||this._oldModel!==v;this._oldModel=v,this._oldOwner=p;const k=this._oldRenderer!==a,z=this._oldRenderer!==void 0;this._oldRenderer=a;const $=this._oldOpened!==C;this._oldOpened=C,k&&z&&(this.innerHTML="",delete this._$litPart$),C&&a&&(k||$||P)&&this.requestContentUpdate()}_modelessChanged(a){this.opened&&(this._shouldAddGlobalListeners()?this._addGlobalListeners():this._removeGlobalListeners()),a?this._exitModalState():this.opened&&this._enterModalState()}_openedChanged(a,p){a?(this._saveFocus(),this._animatedOpening(),this.__scheduledOpen=requestAnimationFrame(()=>{setTimeout(()=>{this._trapFocus(),this.dispatchEvent(new CustomEvent("vaadin-overlay-open",{bubbles:!0}))})}),document.addEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._addGlobalListeners()):p&&(this.__scheduledOpen&&(cancelAnimationFrame(this.__scheduledOpen),this.__scheduledOpen=null),this._resetFocus(),this._animatedClosing(),document.removeEventListener("keydown",this._boundKeydownListener),this._shouldAddGlobalListeners()&&this._removeGlobalListeners())}_hiddenChanged(a){a&&this.hasAttribute("closing")&&this._flushAnimation("closing")}_shouldAnimate(){const a=getComputedStyle(this),p=a.getPropertyValue("animation-name");return!(a.getPropertyValue("display")==="none")&&p&&p!=="none"}_enqueueAnimation(a,p){const v=`__${a}Handler`,C=P=>{P&&P.target!==this||(p(),this.removeEventListener("animationend",C),delete this[v])};this[v]=C,this.addEventListener("animationend",C)}_flushAnimation(a){const p=`__${a}Handler`;typeof this[p]=="function"&&this[p]()}_animatedOpening(){this.parentNode===document.body&&this.hasAttribute("closing")&&this._flushAnimation("closing"),this._attachOverlay(),this.modeless||this._enterModalState(),this.setAttribute("opening",""),this._shouldAnimate()?this._enqueueAnimation("opening",()=>{this._finishOpening()}):this._finishOpening()}_attachOverlay(){this._placeholder=document.createComment("vaadin-overlay-placeholder"),this.parentNode.insertBefore(this._placeholder,this),document.body.appendChild(this),this.bringToFront()}_finishOpening(){this.removeAttribute("opening")}_finishClosing(){this._detachOverlay(),this.$.overlay.style.removeProperty("pointer-events"),this.removeAttribute("closing"),this.dispatchEvent(new CustomEvent("vaadin-overlay-closed"))}_animatedClosing(){this.hasAttribute("opening")&&this._flushAnimation("opening"),this._placeholder&&(this._exitModalState(),this.setAttribute("closing",""),this.dispatchEvent(new CustomEvent("vaadin-overlay-closing")),this._shouldAnimate()?this._enqueueAnimation("closing",()=>{this._finishClosing()}):this._finishClosing())}_detachOverlay(){this._placeholder.parentNode.insertBefore(this,this._placeholder),this._placeholder.parentNode.removeChild(this._placeholder)}_mouseDownListener(a){this._mouseDownInside=a.composedPath().indexOf(this.$.overlay)>=0}_mouseUpListener(a){this._mouseUpInside=a.composedPath().indexOf(this.$.overlay)>=0}_shouldCloseOnOutsideClick(a){return this._last}_outsideClickListener(a){if(a.composedPath().includes(this.$.overlay)||this._mouseDownInside||this._mouseUpInside){this._mouseDownInside=!1,this._mouseUpInside=!1;return}if(!this._shouldCloseOnOutsideClick(a))return;const p=new CustomEvent("vaadin-overlay-outside-click",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(p),this.opened&&!p.defaultPrevented&&this.close(a)}_keydownListener(a){if(!(!this._last||a.defaultPrevented)&&!(!this._shouldAddGlobalListeners()&&!a.composedPath().includes(this.$.overlay))&&a.key==="Escape"){const p=new CustomEvent("vaadin-overlay-escape-press",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(p),this.opened&&!p.defaultPrevented&&this.close(a)}}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getAncestorRootNodes(g){const d=[];for(;g;){if(g.nodeType===Node.DOCUMENT_NODE){d.push(g);break}if(g.nodeType===Node.DOCUMENT_FRAGMENT_NODE){d.push(g),g=g.host;continue}if(g.assignedSlot){g=g.assignedSlot;continue}g=g.parentNode}return d}function getFlattenedElements(g){const d=[];let a;return g.localName==="slot"?a=g.assignedElements():(d.push(g),a=[...g.children]),a.forEach(p=>d.push(...getFlattenedElements(p))),d}function getClosestElement(g,d){return d?d.closest(g)||getClosestElement(g,d.getRootNode().host):null}function deserializeAttributeValue(g){return g?new Set(g.split(" ")):new Set}function serializeAttributeValue(g){return g?[...g].join(" "):""}function addValueToAttribute(g,d,a){const p=deserializeAttributeValue(g.getAttribute(d));p.add(a),g.setAttribute(d,serializeAttributeValue(p))}function removeValueFromAttribute(g,d,a){const p=deserializeAttributeValue(g.getAttribute(d));if(p.delete(a),p.size===0){g.removeAttribute(d);return}g.setAttribute(d,serializeAttributeValue(p))}function isEmptyTextNode(g){return g.nodeType===Node.TEXT_NODE&&g.textContent.trim()===""}/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function observeMove(g,d){let a=null,p;const v=document.documentElement;function C(){p&&clearTimeout(p),a&&a.disconnect(),a=null}function P(k=!1,z=1){C();const{left:$,top:D,width:F,height:N}=g.getBoundingClientRect();if(k||d(),!F||!N)return;const W=Math.floor(D),j=Math.floor(v.clientWidth-($+F)),q=Math.floor(v.clientHeight-(D+N)),X=Math.floor($),ee={rootMargin:`${-W}px ${-j}px ${-q}px ${-X}px`,threshold:Math.max(0,Math.min(1,z))||1};let te=!0;function ie(oe){const ae=oe[0].intersectionRatio;if(ae!==z){if(!te)return P();ae?P(!1,ae):p=setTimeout(()=>{P(!1,1e-7)},1e3)}te=!1}a=new IntersectionObserver(ie,ee),a.observe(g)}return P(!0),C}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PROP_NAMES_VERTICAL={start:"top",end:"bottom"},PROP_NAMES_HORIZONTAL={start:"left",end:"right"},targetResizeObserver=new ResizeObserver(g=>{setTimeout(()=>{g.forEach(d=>{d.target.__overlay&&d.target.__overlay._updatePosition()})})}),PositionMixin=g=>class extends g{static get properties(){return{positionTarget:{type:Object,value:null,sync:!0},horizontalAlign:{type:String,value:"start",sync:!0},verticalAlign:{type:String,value:"top",sync:!0},noHorizontalOverlap:{type:Boolean,value:!1,sync:!0},noVerticalOverlap:{type:Boolean,value:!1,sync:!0},requiredVerticalSpace:{type:Number,value:0,sync:!0}}}static get observers(){return["__positionSettingsChanged(horizontalAlign, verticalAlign, noHorizontalOverlap, noVerticalOverlap, requiredVerticalSpace)","__overlayOpenedChanged(opened, positionTarget)"]}constructor(){super(),this.__onScroll=this.__onScroll.bind(this),this._updatePosition=this._updatePosition.bind(this)}connectedCallback(){super.connectedCallback(),this.opened&&this.__addUpdatePositionEventListeners()}disconnectedCallback(){super.disconnectedCallback(),this.__removeUpdatePositionEventListeners()}__addUpdatePositionEventListeners(){window.visualViewport.addEventListener("resize",this._updatePosition),window.visualViewport.addEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes=getAncestorRootNodes(this.positionTarget),this.__positionTargetAncestorRootNodes.forEach(a=>{a.addEventListener("scroll",this.__onScroll,!0)}),this.positionTarget&&(this.__observePositionTargetMove=observeMove(this.positionTarget,()=>{this._updatePosition()}))}__removeUpdatePositionEventListeners(){window.visualViewport.removeEventListener("resize",this._updatePosition),window.visualViewport.removeEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes&&(this.__positionTargetAncestorRootNodes.forEach(a=>{a.removeEventListener("scroll",this.__onScroll,!0)}),this.__positionTargetAncestorRootNodes=null),this.__observePositionTargetMove&&(this.__observePositionTargetMove(),this.__observePositionTargetMove=null)}__overlayOpenedChanged(a,p){if(this.__removeUpdatePositionEventListeners(),p&&(p.__overlay=null,targetResizeObserver.unobserve(p),a&&(this.__addUpdatePositionEventListeners(),p.__overlay=this,targetResizeObserver.observe(p))),a){const v=getComputedStyle(this);this.__margins||(this.__margins={},["top","bottom","left","right"].forEach(C=>{this.__margins[C]=parseInt(v[C],10)})),this._updatePosition(),requestAnimationFrame(()=>this._updatePosition())}}__positionSettingsChanged(){this._updatePosition()}__onScroll(a){a.target instanceof Node&&this.contains(a.target)||this._updatePosition()}_updatePosition(){if(!this.positionTarget||!this.opened||!this.__margins)return;const a=this.positionTarget.getBoundingClientRect();if(a.width===0&&a.height===0&&this.opened){this.opened=!1;return}const p=this.__shouldAlignStartVertically(a);this.style.justifyContent=p?"flex-start":"flex-end";const v=this.__isRTL,C=this.__shouldAlignStartHorizontally(a,v),P=!v&&C||v&&!C;this.style.alignItems=P?"flex-start":"flex-end";const k=this.getBoundingClientRect(),z=this.__calculatePositionInOneDimension(a,k,this.noVerticalOverlap,PROP_NAMES_VERTICAL,this,p),$=this.__calculatePositionInOneDimension(a,k,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL,this,C);Object.assign(this.style,z,$),this.toggleAttribute("bottom-aligned",!p),this.toggleAttribute("top-aligned",p),this.toggleAttribute("end-aligned",!P),this.toggleAttribute("start-aligned",P)}__shouldAlignStartHorizontally(a,p){const v=Math.max(this.__oldContentWidth||0,this.$.overlay.offsetWidth);this.__oldContentWidth=this.$.overlay.offsetWidth;const C=Math.min(window.innerWidth,document.documentElement.clientWidth),P=!p&&this.horizontalAlign==="start"||p&&this.horizontalAlign==="end";return this.__shouldAlignStart(a,v,C,this.__margins,P,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL)}__shouldAlignStartVertically(a){const p=this.requiredVerticalSpace||Math.max(this.__oldContentHeight||0,this.$.overlay.offsetHeight);this.__oldContentHeight=this.$.overlay.offsetHeight;const v=Math.min(window.innerHeight,document.documentElement.clientHeight),C=this.verticalAlign==="top";return this.__shouldAlignStart(a,p,v,this.__margins,C,this.noVerticalOverlap,PROP_NAMES_VERTICAL)}__shouldAlignStart(a,p,v,C,P,k,z){const $=v-a[k?z.end:z.start]-C[z.end],D=a[k?z.start:z.end]-C[z.start],F=P?$:D,W=F>(P?D:$)||F>p;return P===W}__adjustBottomProperty(a,p,v){let C;if(a===p.end){if(p.end===PROP_NAMES_VERTICAL.end){const P=Math.min(window.innerHeight,document.documentElement.clientHeight);if(v>P&&this.__oldViewportHeight){const k=this.__oldViewportHeight-P;C=v-k}this.__oldViewportHeight=P}if(p.end===PROP_NAMES_HORIZONTAL.end){const P=Math.min(window.innerWidth,document.documentElement.clientWidth);if(v>P&&this.__oldViewportWidth){const k=this.__oldViewportWidth-P;C=v-k}this.__oldViewportWidth=P}}return C}__calculatePositionInOneDimension(a,p,v,C,P,k){const z=k?C.start:C.end,$=k?C.end:C.start,D=parseFloat(P.style[z]||getComputedStyle(P)[z]),F=this.__adjustBottomProperty(z,C,D),N=p[k?C.start:C.end]-a[v===k?C.end:C.start],W=F?`${F}px`:`${D+N*(k?-1:1)}px`;return{[z]:W,[$]:""}}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlayStyles$1=i`
  :host {
    z-index: 200;
    position: fixed;

    /* Despite of what the names say, <vaadin-overlay> is just a container
          for position/sizing/alignment. The actual overlay is the overlay part. */

    /* Default position constraints: the entire viewport. Note: themes can
          override this to introduce gaps between the overlay and the viewport. */
    inset: 0;
    bottom: var(--vaadin-overlay-viewport-bottom);

    /* Use flexbox alignment for the overlay part. */
    display: flex;
    flex-direction: column; /* makes dropdowns sizing easier */
    /* Align to center by default. */
    align-items: center;
    justify-content: center;

    /* Allow centering when max-width/max-height applies. */
    margin: auto;

    /* The host is not clickable, only the overlay part is. */
    pointer-events: none;

    /* Remove tap highlight on touch devices. */
    -webkit-tap-highlight-color: transparent;

    /* CSS API for host */
    --vaadin-overlay-viewport-bottom: 0;
  }

  :host([hidden]),
  :host(:not([opened]):not([closing])),
  :host(:not([opened]):not([closing])) [part='overlay'] {
    display: none !important;
  }

  [part='overlay'] {
    -webkit-overflow-scrolling: touch;
    overflow: auto;
    pointer-events: auto;

    /* Prevent overflowing the host */
    max-width: 100%;
    box-sizing: border-box;

    -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */
  }

  [part='backdrop'] {
    z-index: -1;
    content: '';
    background: rgba(0, 0, 0, 0.5);
    position: fixed;
    inset: 0;
    pointer-events: auto;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTagsOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(i$1))))){static get is(){return"vaadin-user-tags-overlay"}static get styles(){return[overlayStyles$1,userTagsOverlayStyles]}render(){return x`
      <div id="backdrop" part="backdrop" ?hidden="${!this.withBackdrop}"></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(UserTagsOverlay);/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */let microtaskCurrHandle$1=0,microtaskLastHandle$1=0;const microtaskCallbacks$1=[];let microtaskScheduled$1=!1;function microtaskFlush$1(){microtaskScheduled$1=!1;const g=microtaskCallbacks$1.length;for(let d=0;d<g;d++){const a=microtaskCallbacks$1[d];if(a)try{a()}catch(p){setTimeout(()=>{throw p})}}microtaskCallbacks$1.splice(0,g),microtaskLastHandle$1+=g}const timeOut$1={after(g){return{run(d){return window.setTimeout(d,g)},cancel(d){window.clearTimeout(d)}}},run(g,d){return window.setTimeout(g,d)},cancel(g){window.clearTimeout(g)}},animationFrame={run(g){return window.requestAnimationFrame(g)},cancel(g){window.cancelAnimationFrame(g)}},idlePeriod$1={run(g){return window.requestIdleCallback?window.requestIdleCallback(g):window.setTimeout(g,16)},cancel(g){window.cancelIdleCallback?window.cancelIdleCallback(g):window.clearTimeout(g)}},microTask$1={run(g){microtaskScheduled$1||(microtaskScheduled$1=!0,queueMicrotask(()=>microtaskFlush$1())),microtaskCallbacks$1.push(g);const d=microtaskCurrHandle$1;return microtaskCurrHandle$1+=1,d},cancel(g){const d=g-microtaskLastHandle$1;if(d>=0){if(!microtaskCallbacks$1[d])throw new Error(`invalid async handle: ${g}`);microtaskCallbacks$1[d]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const debouncerQueue$1=new Set;let Debouncer$1=class K_{static debounce(d,a,p){return d instanceof K_?d._cancelAsync():d=new K_,d.setConfig(a,p),d}constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(d,a){this._asyncModule=d,this._callback=a,this._timer=this._asyncModule.run(()=>{this._timer=null,debouncerQueue$1.delete(this),this._callback()})}cancel(){this.isActive()&&(this._cancelAsync(),debouncerQueue$1.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return this._timer!=null}};function enqueueDebouncer$1(g){debouncerQueue$1.add(g)}function flushDebouncers$1(){const g=!!debouncerQueue$1.size;return debouncerQueue$1.forEach(d=>{try{d.flush()}catch(a){setTimeout(()=>{throw a})}}),g}const flush$1=()=>{let g;do g=flushDebouncers$1();while(g)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const listenOnce$1=(g,d)=>new Promise(a=>{const p=()=>{g.removeEventListener(d,p),a()};g.addEventListener(d,p)});class UserTags extends PolylitMixin(i$1){static get is(){return"vaadin-user-tags"}static get styles(){return i`
      :host {
        position: absolute;
      }
    `}render(){return x`
      <vaadin-user-tags-overlay
        id="overlay"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      ></vaadin-user-tags-overlay>
    `}static get properties(){return{hasFocus:{type:Boolean,value:!1,observer:"_hasFocusChanged"},opened:{type:Boolean,value:!1,sync:!0},flashing:{type:Boolean,value:!1},target:{type:Object,observer:"__targetChanged"},users:{type:Array,value:()=>[]},duration:{type:Number,value:200},delay:{type:Number,value:2e3},__flashQueue:{type:Array,value:()=>[]},__isTargetVisible:{type:Boolean,value:!1}}}constructor(){super(),this.__targetVisibilityObserver=new IntersectionObserver(([d])=>{this.__onTargetVisibilityChange(d.isIntersecting)},{threshold:1})}get wrapper(){return this.$.overlay.querySelector('[part="tags"]')}connectedCallback(){super.connectedCallback(),this.target&&this.__targetVisibilityObserver.observe(this.target)}disconnectedCallback(){super.disconnectedCallback(),this.opened=!1,this.target&&this.__targetVisibilityObserver.unobserve(this.target)}ready(){super.ready(),this.$.overlay.renderer=d=>{if(!d.firstChild){const a=document.createElement("div");a.setAttribute("part","tags"),d.appendChild(a)}},this.$.overlay.requestContentUpdate()}__onTargetVisibilityChange(d){if(this.__isTargetVisible=d,d&&this.__flashQueue.length>0&&!this.flashing){this.flashTags(this.__flashQueue.shift());return}if(d&&this.hasFocus){this.opened=!0;return}!d&&this.opened&&(this.opened=!1)}__targetChanged(d,a){this.$.overlay.positionTarget=d,a&&this.__targetVisibilityObserver.unobserve(a),d&&this.__targetVisibilityObserver.observe(d)}_hasFocusChanged(d){d&&this.flashing&&this.stopFlash()}createUserTag(d){const a=document.createElement("vaadin-user-tag");return a.name=d.name,a.uid=d.id,a.colorIndex=d.colorIndex,a}getTagForUser(d){return Array.from(this.wrapper.children).find(a=>a.uid===d.id)}getChangedTags(d,a){const p=a.map(C=>this.getTagForUser(C));return{added:d.map(C=>this.getTagForUser(C)||this.createUserTag(C)),removed:p}}applyTagsStart({added:d,removed:a}){const p=this.wrapper;a.forEach(v=>{v&&(v.classList.add("removing"),v.classList.remove("show"))}),d.forEach(v=>p.insertBefore(v,p.firstChild))}applyTagsEnd({added:d,removed:a}){const p=this.wrapper;a.forEach(v=>{v&&v.parentNode===p&&p.removeChild(v)}),d.forEach(v=>v&&v.classList.add("show"))}setUsers(d){this.requestContentUpdate();let a=[],p=[];const v=Array.isArray(d);if(Array.isArray(this.users)){const k=(d||[]).map(z=>z.id);p=this.users.filter(z=>!k.includes(z.id))}if(v){const k=(this.users||[]).map(z=>z.id);a=d.filter(z=>!k.includes(z.id)).reverse()}if(a.length===0&&p.length===0)return;const P=this.getChangedTags(a,p);if(this.__flashQueue.length>0&&p.forEach((k,z)=>{P.removed[z]!==null&&this.__flashQueue.forEach($=>{$.some(D=>D.uid===k.id)&&(this.__flashQueue=this.__flashQueue.filter((D,F)=>F!==z))})}),this.opened&&this.hasFocus)this.updateTags(d,P);else if(a.length>0&&document.visibilityState!=="hidden"){const k=P.added,z=P.removed;this.updateTagsSync(d,{added:[],removed:z}),this.flashing||!this.__isTargetVisible?this.__flashQueue=[...this.__flashQueue,k]:this.flashTags(k)}else this.updateTagsSync(d,P)}_onOverlayOpen(){Array.from(this.wrapper.children).forEach(d=>{d.classList.contains("removing")||d.classList.add("show")})}flashTags(d){this.flashing=!0;const a=this.wrapper,p=Array.from(a.children);p.forEach(v=>{v.style.display="none"}),d.forEach(v=>{a.insertBefore(v,a.firstChild)}),this.flashPromise=new Promise(v=>{listenOnce$1(this.$.overlay,"vaadin-overlay-open").then(()=>{this._debounceFlashStart=Debouncer$1.debounce(this._debounceFlashStart,timeOut$1.after(this.duration+this.delay),()=>{this.hasFocus||d.forEach(C=>C.classList.remove("show")),this._debounceFlashEnd=Debouncer$1.debounce(this._debounceFlashEnd,timeOut$1.after(this.duration),()=>{const C=()=>{p.forEach(P=>{P.style.display="block"}),this.flashing=!1,v()};this.hasFocus?C():(listenOnce$1(this.$.overlay,"animationend").then(()=>{C()}),this.opened=!1)})})})}).then(()=>{if(this.__flashQueue.length>0){const v=this.__flashQueue[0];this.__flashQueue=[...this.__flashQueue].slice(1),this.flashTags(v)}}),this.opened=!0}stopFlash(){this._debounceFlashStart&&this._debounceFlashStart.flush(),this._debounceFlashEnd&&this._debounceFlashEnd.flush(),this.$.overlay._flushAnimation("closing")}updateTags(d,a){this.applyTagsStart(a),this._debounceRender=Debouncer$1.debounce(this._debounceRender,timeOut$1.after(this.duration),()=>{this.users=d,this.applyTagsEnd(a),d.length===0&&this.opened&&(this.opened=!1)})}updateTagsSync(d,a){this.applyTagsStart(a),this.users=d,this.applyTagsEnd(a)}show(){this.hasFocus=!0,this.__isTargetVisible&&(this.opened=!0)}hide(){this.hasFocus=!1,this.opened=!1}requestContentUpdate(){this._debounceRender&&this._debounceRender.isActive()&&this._debounceRender.flush()}}defineCustomElement(UserTags);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",fieldOutlineStyles,{moduleId:"vaadin-field-outline-styles"});class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-field-outline"}static get properties(){return{user:{type:Object,value:null,observer:"_userChanged",sync:!0}}}render(){return x``}ready(){super.ready(),this.setAttribute("part","outline"),this._field=this.getRootNode().host}_userChanged(d){this.toggleAttribute("has-active-user",!!d);const a=d?`var(--vaadin-user-color-${d.colorIndex})`:"transparent",p="--_active-user-color";this.style.setProperty(p,a),this._field&&this._field.style.setProperty(p,a)}}defineCustomElement(FieldOutline);/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const region=document.createElement("div");region.style.position="fixed";region.style.clip="rect(0px, 0px, 0px, 0px)";region.setAttribute("aria-live","polite");document.body.appendChild(region);let alertDebouncer;function announce(g,d={}){const a=d.mode||"polite",p=d.timeout===void 0?150:d.timeout;a==="alert"?(region.removeAttribute("aria-live"),region.removeAttribute("role"),alertDebouncer=Debouncer$1.debounce(alertDebouncer,animationFrame,()=>{region.setAttribute("role","alert")})):(alertDebouncer&&alertDebouncer.cancel(),region.removeAttribute("role"),region.setAttribute("aria-live",a)),region.textContent="",setTimeout(()=>{region.textContent=g},p)}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getOutlineTarget=(g,d)=>{switch(d){case"vaadin-big-decimal-field":case"vaadin-combo-box":case"vaadin-date-picker":case"vaadin-email-field":case"vaadin-integer-field":case"vaadin-number-field":case"vaadin-password-field":case"vaadin-select":case"vaadin-text-area":case"vaadin-text-field":case"vaadin-time-picker":return g.shadowRoot.querySelector('[part="input-field"]');case"vaadin-checkbox":return g.shadowRoot.querySelector('[part="checkbox"]');case"vaadin-radio-button":return g.shadowRoot.querySelector('[part="radio"]');default:return g}},fields=new WeakMap,initOutline=g=>{if(!fields.has(g)){const d=g.tagName.toLowerCase(),a=getOutlineTarget(g,d);a.style.position="relative",d.endsWith("text-area")&&(a.style.overflow="visible");const p=document.createElement("style");p.textContent=`
      :host([focused]) [part="outline"] {
        opacity: calc(1 - var(--lumo-input-field-pointer-focus-visible, 0));
      }

      :host([active]) [part="outline"],
      :host([focus-ring]) [part="outline"] {
        display: none;
      }
    `,g.shadowRoot.appendChild(p);const v=document.createElement("vaadin-field-outline");(a===g?g.shadowRoot:a).appendChild(v),v.setAttribute("context",d),fields.set(g,{root:g,target:a,outline:v})}return fields.get(g)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ComponentObserver{constructor(d){this.component=d,this.initTags(d)}getFields(){return[this.component]}getFieldIndex(d){return this.getFields().indexOf(d)}getFocusTarget(d){return this.component}initTags(d){const a=document.createElement("vaadin-user-tags");d.shadowRoot.appendChild(a),a.target=d,this._tags=a,d.addEventListener("mouseenter",p=>{p.relatedTarget!==this._tags.$.overlay&&(this._mouse=!0,this._mouseDebouncer=Debouncer$1.debounce(this._mouseDebouncer,timeOut$1.after(200),()=>{this._mouse&&this._tags.show()}))}),d.addEventListener("mouseleave",p=>{p.relatedTarget!==this._tags.$.overlay&&(this._mouse=!1,this._hasFocus||this._tags.hide())}),d.addEventListener("vaadin-highlight-show",p=>{this._hasFocus=!0,this._debouncer&&this._debouncer.isActive()?this._debouncer.cancel():this._tags.show()}),d.addEventListener("vaadin-highlight-hide",p=>{this._hasFocus=!1,this._mouse||(this._debouncer=Debouncer$1.debounce(this._debouncer,timeOut$1.after(1),()=>{this._tags.hide()}))}),this._tags.$.overlay.addEventListener("mouseleave",p=>{p.relatedTarget!==d&&(this._mouse=!1,d.hasAttribute("focused")||this._tags.hide())})}setOutlines(d){const a=this.getFields();a.forEach((p,v)=>{const{outline:C}=initOutline(p),P=a.length===1?0:d.map(k=>k.fieldIndex).indexOf(v);C.user=d[P]})}showOutline(d){this.fire("show",d)}hideOutline(d){this.fire("hide",d)}fire(d,a){this.component.dispatchEvent(new CustomEvent(`vaadin-highlight-${d}`,{bubbles:!0,composed:!0,detail:{fieldIndex:this.getFieldIndex(a)}}))}redraw(d){this._tags.setUsers(d),this.setOutlines(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FieldObserver extends ComponentObserver{constructor(d){super(d),this.addListeners(d)}addListeners(d){d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}onFocusIn(d){const a=this.getFocusTarget(d);this.showOutline(a)}onFocusOut(d){const a=this.getFocusTarget(d);this.hideOutline(a)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CheckboxGroupObserver extends FieldObserver{getFields(){return this.component.__checkboxes}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DatePickerObserver extends ComponentObserver{constructor(d){super(d),this.datePicker=d,this.blurWhileOpened=!1,this.addListeners(d)}addListeners(d){this.overlay=d.$.overlay,d.addEventListener("opened-changed",a=>this.onOpenedChanged(a)),this.overlay.addEventListener("focusout",a=>this.onOverlayFocusOut(a)),d.addEventListener("focusin",a=>this.onFocusIn(a)),d.addEventListener("focusout",a=>this.onFocusOut(a))}isEventInOverlay(d){return this.datePicker._overlayContent&&this.datePicker._overlayContent.contains(d)}isFullscreen(){return this.datePicker._noInput&&!isKeyboardActive()}onFocusIn(d){if(!this.isEventInOverlay(d.relatedTarget)){if(this.blurWhileOpened){this.blurWhileOpened=!1;return}this.showOutline(this.datePicker)}}onFocusOut(d){this.isEventInOverlay(d.relatedTarget)||(this.datePicker.opened?this.blurWhileOpened=!0:this.hideOutline(this.datePicker))}onOverlayFocusOut(d){this.datePicker.contains(d.relatedTarget)||(this.blurWhileOpened=!0)}onOpenedChanged(d){d.detail.value===!0&&this.isFullscreen()&&this.showOutline(this.datePicker),d.detail.value===!1&&this.blurWhileOpened&&(this.blurWhileOpened=!1,this.hideOutline(this.datePicker))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DateObserver extends DatePickerObserver{constructor(d,a){super(d),this.component=a}getFieldIndex(){return 0}}class TimeObserver extends FieldObserver{constructor(d,a){super(d),this.component=a,this.timePicker=d}getFocusTarget(d){return this.timePicker}getFieldIndex(){return 1}}class DateTimePickerObserver extends ComponentObserver{constructor(d){super(d);const[a,p]=this.getFields();this.dateObserver=new DateObserver(a,d),this.timeObserver=new TimeObserver(p,d)}getFields(){return[this.component.querySelector("[slot=date-picker]"),this.component.querySelector("[slot=time-picker]")]}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ListBoxObserver extends FieldObserver{getFields(){return this.component.items||[]}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class RadioGroupObserver extends FieldObserver{getFields(){return this.component.__radioButtons}getFocusTarget(d){const a=this.getFields();return Array.from(d.composedPath()).find(p=>a.includes(p))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SelectObserver extends FieldObserver{constructor(d){super(d),this.blurWhileOpened=!1,this.overlay=d._overlayElement}addListeners(d){super.addListeners(d),d.addEventListener("opened-changed",a=>{d._phone&&a.detail.value===!1&&this.hideOutline(d)})}onFocusIn(d){this.overlay.contains(d.relatedTarget)||!this.component._phone&&this.overlay.hasAttribute("closing")||super.onFocusIn(d)}onFocusOut(d){this.overlay.contains(d.relatedTarget)||super.onFocusOut(d)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const initFieldObserver=g=>{let d;switch(g.tagName.toLowerCase()){case"vaadin-date-picker":d=new DatePickerObserver(g);break;case"vaadin-date-time-picker":d=new DateTimePickerObserver(g);break;case"vaadin-select":d=new SelectObserver(g);break;case"vaadin-checkbox-group":d=new CheckboxGroupObserver(g);break;case"vaadin-radio-group":d=new RadioGroupObserver(g);break;case"vaadin-list-box":d=new ListBoxObserver(g);break;default:d=new FieldObserver(g)}return d};class FieldHighlighterController{constructor(d){this.host=d,this.user=null,this.users=[]}get user(){return this._user}set user(d){if(this._user=d,d){const a=`${d.name} started editing`,{label:p}=this.host;announce(p?`${a} ${p}`:a)}}hostConnected(){this.redraw()}addUser(d){d&&(this.users.push(d),this.redraw(),this.user=d)}setUsers(d){Array.isArray(d)&&(this.users=d,this.redraw(),this.user=d[d.length-1]||null)}removeUser(d){if(d&&d.id!==void 0){let a;for(let p=0;p<this.users.length;p++)if(this.users[p].id===d.id){a=p;break}a!==void 0&&(this.users.splice(a,1),this.redraw(),this.users.length>0?this.user=this.users[this.users.length-1]:this.user=null)}}redraw(){this.observer.redraw([...this.users].reverse())}}class FieldHighlighter extends HTMLElement{static get is(){return"vaadin-field-highlighter"}static init(d){if(!d._highlighterController){const a=new FieldHighlighterController(d);d.setAttribute("has-highlighter",""),a.observer=initFieldObserver(d),d.addController(a),d._highlighterController=a}return d._highlighterController}static addUser(d,a){this.init(d).addUser(a)}static removeUser(d,a){this.init(d).removeUser(a)}static setUsers(d,a){this.init(d).setUsers(a)}}defineCustomElement(FieldHighlighter);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/window.JSCompiler_renameProperty=function(g,d){return g};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let CSS_URL_RX=/(url\()([^)]*)(\))/g,ABS_URL=/(^\/[^\/])|(^#)|(^[\w-\d]*:)/,workingURL,resolveDoc;function resolveUrl(g,d){if(g&&ABS_URL.test(g)||g==="//")return g;if(workingURL===void 0){workingURL=!1;try{const a=new URL("b","http://a");a.pathname="c%20d",workingURL=a.href==="http://a/c%20d"}catch{}}if(d||(d=document.baseURI||window.location.href),workingURL)try{return new URL(g,d).href}catch{return g}return resolveDoc||(resolveDoc=document.implementation.createHTMLDocument("temp"),resolveDoc.base=resolveDoc.createElement("base"),resolveDoc.head.appendChild(resolveDoc.base),resolveDoc.anchor=resolveDoc.createElement("a"),resolveDoc.body.appendChild(resolveDoc.anchor)),resolveDoc.base.href=d,resolveDoc.anchor.href=g,resolveDoc.anchor.href||g}function resolveCss(g,d){return g.replace(CSS_URL_RX,function(a,p,v,C){return p+"'"+resolveUrl(v.replace(/["']/g,""),d)+"'"+C})}function pathFromUrl(g){return g.substring(0,g.lastIndexOf("/")+1)}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const useShadow=!window.ShadyDOM||!window.ShadyDOM.inUse;!window.ShadyCSS||window.ShadyCSS.nativeCss;const supportsAdoptingStyleSheets=useShadow&&"adoptedStyleSheets"in Document.prototype&&"replaceSync"in CSSStyleSheet.prototype&&(()=>{try{const g=new CSSStyleSheet;g.replaceSync("");const d=document.createElement("div");return d.attachShadow({mode:"open"}),d.shadowRoot.adoptedStyleSheets=[g],d.shadowRoot.adoptedStyleSheets[0]===g}catch{return!1}})();let rootPath=window.Polymer&&window.Polymer.rootPath||pathFromUrl(document.baseURI||window.location.href),sanitizeDOMValue=window.Polymer&&window.Polymer.sanitizeDOMValue||void 0;window.Polymer&&window.Polymer.setPassiveTouchGestures;let strictTemplatePolicy=window.Polymer&&window.Polymer.strictTemplatePolicy||!1,allowTemplateFromDomModule=window.Polymer&&window.Polymer.allowTemplateFromDomModule||!1,legacyOptimizations=window.Polymer&&window.Polymer.legacyOptimizations||!1,legacyWarnings=window.Polymer&&window.Polymer.legacyWarnings||!1,syncInitialRender=window.Polymer&&window.Polymer.syncInitialRender||!1,legacyUndefined=window.Polymer&&window.Polymer.legacyUndefined||!1,orderedComputed=window.Polymer&&window.Polymer.orderedComputed||!1,removeNestedTemplates=window.Polymer&&window.Polymer.removeNestedTemplates||!1,fastDomIf=window.Polymer&&window.Polymer.fastDomIf||!1,suppressTemplateNotifications=window.Polymer&&window.Polymer.suppressTemplateNotifications||!1;window.Polymer&&window.Polymer.legacyNoObservedAttributes;let useAdoptedStyleSheetsWithBuiltCSS=window.Polymer&&window.Polymer.useAdoptedStyleSheetsWithBuiltCSS||!1;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let modules={},lcModules={};function setModule(g,d){modules[g]=lcModules[g.toLowerCase()]=d}function findModule(g){return modules[g]||lcModules[g.toLowerCase()]}function styleOutsideTemplateCheck(g){g.querySelector("style")&&console.warn("dom-module %s has style outside template",g.id)}class DomModule extends HTMLElement{static get observedAttributes(){return["id"]}static import(d,a){if(d){let p=findModule(d);return p&&a?p.querySelector(a):p}return null}attributeChangedCallback(d,a,p,v){a!==p&&this.register()}get assetpath(){if(!this.__assetpath){const d=window.HTMLImports&&HTMLImports.importForElement?HTMLImports.importForElement(this)||document:this.ownerDocument,a=resolveUrl(this.getAttribute("assetpath")||"",d.baseURI);this.__assetpath=pathFromUrl(a)}return this.__assetpath}register(d){if(d=d||this.id,d){if(strictTemplatePolicy&&findModule(d)!==void 0)throw setModule(d,null),new Error(`strictTemplatePolicy: dom-module ${d} re-registered`);this.id=d,setModule(d,this),styleOutsideTemplateCheck(this)}}}DomModule.prototype.modules=modules;customElements.define("dom-module",DomModule);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const MODULE_STYLE_LINK_SELECTOR="link[rel=import][type~=css]",INCLUDE_ATTR="include",SHADY_UNSCOPED_ATTR="shady-unscoped";function importModule(g){return DomModule.import(g)}function styleForImport(g){let d=g.body?g.body:g;const a=resolveCss(d.textContent,g.baseURI),p=document.createElement("style");return p.textContent=a,p}function stylesFromModules(g){const d=g.trim().split(/\s+/),a=[];for(let p=0;p<d.length;p++)a.push(...stylesFromModule(d[p]));return a}function stylesFromModule(g){const d=importModule(g);if(!d)return console.warn("Could not find style data in module named",g),[];if(d._styles===void 0){const a=[];a.push(..._stylesFromModuleImports(d));const p=d.querySelector("template");p&&a.push(...stylesFromTemplate(p,d.assetpath)),d._styles=a}return d._styles}function stylesFromTemplate(g,d){if(!g._styles){const a=[],p=g.content.querySelectorAll("style");for(let v=0;v<p.length;v++){let C=p[v],P=C.getAttribute(INCLUDE_ATTR);P&&a.push(...stylesFromModules(P).filter(function(k,z,$){return $.indexOf(k)===z})),d&&(C.textContent=resolveCss(C.textContent,d)),a.push(C)}g._styles=a}return g._styles}function stylesFromModuleImports(g){let d=importModule(g);return d?_stylesFromModuleImports(d):[]}function _stylesFromModuleImports(g){const d=[],a=g.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);for(let p=0;p<a.length;p++){let v=a[p];if(v.import){const C=v.import,P=v.hasAttribute(SHADY_UNSCOPED_ATTR);if(P&&!C._unscopedStyle){const k=styleForImport(C);k.setAttribute(SHADY_UNSCOPED_ATTR,""),C._unscopedStyle=k}else C._style||(C._style=styleForImport(C));d.push(P?C._unscopedStyle:C._style)}}return d}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let moduleIdIndex=0;function registerStyles(g,d=[],a={}){const p=a.moduleId||`custom-style-module-${moduleIdIndex}`;moduleIdIndex+=1;const v=document.createElement("dom-module");g&&v.setAttribute("theme-for",g);const C=!!(d.length&&a.moduleId),P=[].concat(a.include||[]);P.length===0?v.__allStyles=d:C||(v.__partialStyles=d),v.innerHTML=`
    <template>
      ${P.map(k=>`<style include=${k}></style>`)}
      ${C?`<style>${d.map(k=>k.cssText).join(`
`)}</style>`:""}
    </template>
  `,v.register(p)}function getModuleStyles(g){return stylesFromTemplate(g.querySelector("template")).map(d=>r$1(d.textContent))}function getAllThemes(){const d=DomModule.prototype.modules;return Object.keys(d).map(a=>{const p=d[a],v=p.getAttribute("theme-for");return p.__allStyles||(p.__allStyles=getModuleStyles(p).concat(p.__partialStyles||[])),{themeFor:v,moduleId:a,styles:p.__allStyles}})}window.Vaadin||(window.Vaadin={});window.Vaadin.styleModules={getAllThemes,registerStyles};themeRegistry&&themeRegistry.length>0&&(themeRegistry.forEach(g=>{registerStyles(g.themeFor,g.styles,{moduleId:g.moduleId,include:g.include})}),themeRegistry.length=0);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fontIcons=i`
  @font-face {
    font-family: 'lumo-icons';
    src: url(data:application/font-woff;charset=utf-8;base64,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)
      format('woff');
    font-weight: normal;
    font-style: normal;
  }

  html {
    --lumo-icons-align-center: '\\ea01';
    --lumo-icons-align-left: '\\ea02';
    --lumo-icons-align-right: '\\ea03';
    --lumo-icons-angle-down: '\\ea04';
    --lumo-icons-angle-left: '\\ea05';
    --lumo-icons-angle-right: '\\ea06';
    --lumo-icons-angle-up: '\\ea07';
    --lumo-icons-arrow-down: '\\ea08';
    --lumo-icons-arrow-left: '\\ea09';
    --lumo-icons-arrow-right: '\\ea0a';
    --lumo-icons-arrow-up: '\\ea0b';
    --lumo-icons-bar-chart: '\\ea0c';
    --lumo-icons-bell: '\\ea0d';
    --lumo-icons-calendar: '\\ea0e';
    --lumo-icons-checkmark: '\\ea0f';
    --lumo-icons-chevron-down: '\\ea10';
    --lumo-icons-chevron-left: '\\ea11';
    --lumo-icons-chevron-right: '\\ea12';
    --lumo-icons-chevron-up: '\\ea13';
    --lumo-icons-clock: '\\ea14';
    --lumo-icons-cog: '\\ea15';
    --lumo-icons-cross: '\\ea16';
    --lumo-icons-download: '\\ea17';
    --lumo-icons-drag-handle: '\\ea18';
    --lumo-icons-dropdown: '\\ea19';
    --lumo-icons-edit: '\\ea1a';
    --lumo-icons-error: '\\ea1b';
    --lumo-icons-eye: '\\ea1c';
    --lumo-icons-eye-disabled: '\\ea1d';
    --lumo-icons-menu: '\\ea1e';
    --lumo-icons-minus: '\\ea1f';
    --lumo-icons-ordered-list: '\\ea20';
    --lumo-icons-phone: '\\ea21';
    --lumo-icons-photo: '\\ea22';
    --lumo-icons-play: '\\ea23';
    --lumo-icons-plus: '\\ea24';
    --lumo-icons-redo: '\\ea25';
    --lumo-icons-reload: '\\ea26';
    --lumo-icons-resize-handle: '\\ea27';
    --lumo-icons-search: '\\ea28';
    --lumo-icons-undo: '\\ea29';
    --lumo-icons-unordered-list: '\\ea2a';
    --lumo-icons-upload: '\\ea2b';
    --lumo-icons-user: '\\ea2c';
  }
`;addLumoGlobalStyles("font-icons",fontIcons);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const sizing=i`
  :host {
    --lumo-size-xs: 1.625rem;
    --lumo-size-s: 1.875rem;
    --lumo-size-m: 2.25rem;
    --lumo-size-l: 2.75rem;
    --lumo-size-xl: 3.5rem;

    /* Icons */
    --lumo-icon-size-s: 1.25em;
    --lumo-icon-size-m: 1.5em;
    --lumo-icon-size-l: 2.25em;
    /* For backwards compatibility */
    --lumo-icon-size: var(--lumo-icon-size-m);
  }
`;addLumoGlobalStyles("sizing-props",sizing);const detailsSummary$1=i`
  :host {
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    padding: var(--lumo-space-s) 0;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
    background-color: inherit;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([disabled]),
  :host([disabled]) [part='toggle'] {
    color: var(--lumo-disabled-text-color);
    cursor: default;
  }

  @media (hover: hover) {
    :host(:hover:not([disabled])),
    :host(:hover:not([disabled])) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  [part='toggle'] {
    display: block;
    width: 1em;
    height: 1em;
    margin-left: calc(var(--lumo-space-xs) * -1);
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-s);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([opened]) [part='toggle'] {
    transform: rotate(90deg);
  }

  [part='content'] {
    flex-grow: 1;
  }

  /* RTL styles */
  :host([dir='rtl']) [part='toggle'] {
    margin-left: var(--lumo-space-xs);
    margin-right: calc(var(--lumo-space-xs) * -1);
  }

  :host([dir='rtl']) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }

  :host([opened][dir='rtl']) [part='toggle'] {
    transform: rotate(-90deg);
  }

  /* Small */
  :host([theme~='small']) {
    padding-top: var(--lumo-space-xs);
    padding-bottom: var(--lumo-space-xs);
  }

  :host([theme~='small']) [part='toggle'] {
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='small'][dir='rtl']) [part='toggle'] {
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  /* Filled */
  :host([theme~='filled']) {
    padding: var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2);
  }

  /* Reverse */
  :host([theme~='reverse']) {
    justify-content: space-between;
  }

  :host([theme~='reverse']) [part='toggle'] {
    order: 1;
    margin-right: 0;
  }

  :host([theme~='reverse'][dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  /* Filled reverse */
  :host([theme~='reverse'][theme~='filled']) {
    padding-left: var(--lumo-space-m);
  }

  :host([theme~='reverse'][theme~='filled'][dir='rtl']) {
    padding-right: var(--lumo-space-m);
  }
`;registerStyles$1("vaadin-details-summary",detailsSummary$1,{moduleId:"lumo-details-summary"});const accordionHeading$1=i`
  :host {
    padding: 0;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }

  :host([theme~='filled']) {
    padding-top: 0;
    padding-bottom: 0;
  }
`;registerStyles$1("vaadin-accordion-heading",[detailsSummary$1,accordionHeading$1],{moduleId:"lumo-accordion-heading"});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let dedupeId$1=0;const dedupingMixin=function(g){let d=g.__mixinApplications;d||(d=new WeakMap,g.__mixinApplications=d);let a=dedupeId$1++;function p(v){let C=v.__mixinSet;if(C&&C[a])return v;let P=d,k=P.get(v);if(!k){k=g(v),P.set(v,k);let z=Object.create(k.__mixinSet||C||null);z[a]=!0,k.__mixinSet=z}return k}return p};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$j=window.ShadyDOM&&window.ShadyDOM.noPatch&&window.ShadyDOM.wrap?window.ShadyDOM.wrap:window.ShadyDOM?g=>ShadyDOM.patch(g):g=>g;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isPath(g){return g.indexOf(".")>=0}function root(g){let d=g.indexOf(".");return d===-1?g:g.slice(0,d)}function isAncestor(g,d){return g.indexOf(d+".")===0}function isDescendant(g,d){return d.indexOf(g+".")===0}function translate$1(g,d,a){return d+a.slice(g.length)}function matches(g,d){return g===d||isAncestor(g,d)||isDescendant(g,d)}function normalize$1(g){if(Array.isArray(g)){let d=[];for(let a=0;a<g.length;a++){let p=g[a].toString().split(".");for(let v=0;v<p.length;v++)d.push(p[v])}return d.join(".")}else return g}function split(g){return Array.isArray(g)?normalize$1(g).split("."):g.toString().split(".")}function get$6(g,d,a){let p=g,v=split(d);for(let C=0;C<v.length;C++){if(!p)return;let P=v[C];p=p[P]}return a&&(a.path=v.join(".")),p}function set$1(g,d,a){let p=g,v=split(d),C=v[v.length-1];if(v.length>1){for(let P=0;P<v.length-1;P++){let k=v[P];if(p=p[k],!p)return}p[C]=a}else p[d]=a;return v.join(".")}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const caseMap={},DASH_TO_CAMEL=/-[a-z]/g,CAMEL_TO_DASH=/([A-Z])/g;function dashToCamelCase(g){return caseMap[g]||(caseMap[g]=g.indexOf("-")<0?g:g.replace(DASH_TO_CAMEL,d=>d[1].toUpperCase()))}function camelToDashCase(g){return caseMap[g]||(caseMap[g]=g.replace(CAMEL_TO_DASH,"-$1").toLowerCase())}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let microtaskCurrHandle=0,microtaskLastHandle=0,microtaskCallbacks=[],microtaskNodeContent=0,microtaskScheduled=!1,microtaskNode=document.createTextNode("");new window.MutationObserver(microtaskFlush).observe(microtaskNode,{characterData:!0});function microtaskFlush(){microtaskScheduled=!1;const g=microtaskCallbacks.length;for(let d=0;d<g;d++){let a=microtaskCallbacks[d];if(a)try{a()}catch(p){setTimeout(()=>{throw p})}}microtaskCallbacks.splice(0,g),microtaskLastHandle+=g}const timeOut={after(g){return{run(d){return window.setTimeout(d,g)},cancel(d){window.clearTimeout(d)}}},run(g,d){return window.setTimeout(g,d)},cancel(g){window.clearTimeout(g)}},idlePeriod={run(g){return window.requestIdleCallback?window.requestIdleCallback(g):window.setTimeout(g,16)},cancel(g){window.cancelIdleCallback?window.cancelIdleCallback(g):window.clearTimeout(g)}},microTask={run(g){return microtaskScheduled||(microtaskScheduled=!0,microtaskNode.textContent=microtaskNodeContent++),microtaskCallbacks.push(g),microtaskCurrHandle++},cancel(g){const d=g-microtaskLastHandle;if(d>=0){if(!microtaskCallbacks[d])throw new Error("invalid async handle: "+g);microtaskCallbacks[d]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const microtask=microTask,PropertiesChanged=dedupingMixin(g=>{class d extends g{static createProperties(p){const v=this.prototype;for(let C in p)C in v||v._createPropertyAccessor(C)}static attributeNameForProperty(p){return p.toLowerCase()}static typeForProperty(p){}_createPropertyAccessor(p,v){this._addPropertyToAttributeMap(p),this.hasOwnProperty(JSCompiler_renameProperty("__dataHasAccessor",this))||(this.__dataHasAccessor=Object.assign({},this.__dataHasAccessor)),this.__dataHasAccessor[p]||(this.__dataHasAccessor[p]=!0,this._definePropertyAccessor(p,v))}_addPropertyToAttributeMap(p){this.hasOwnProperty(JSCompiler_renameProperty("__dataAttributes",this))||(this.__dataAttributes=Object.assign({},this.__dataAttributes));let v=this.__dataAttributes[p];return v||(v=this.constructor.attributeNameForProperty(p),this.__dataAttributes[v]=p),v}_definePropertyAccessor(p,v){Object.defineProperty(this,p,{get(){return this.__data[p]},set:v?function(){}:function(C){this._setPendingProperty(p,C,!0)&&this._invalidateProperties()}})}constructor(){super(),this.__dataEnabled=!1,this.__dataReady=!1,this.__dataInvalid=!1,this.__data={},this.__dataPending=null,this.__dataOld=null,this.__dataInstanceProps=null,this.__dataCounter=0,this.__serializing=!1,this._initializeProperties()}ready(){this.__dataReady=!0,this._flushProperties()}_initializeProperties(){for(let p in this.__dataHasAccessor)this.hasOwnProperty(p)&&(this.__dataInstanceProps=this.__dataInstanceProps||{},this.__dataInstanceProps[p]=this[p],delete this[p])}_initializeInstanceProperties(p){Object.assign(this,p)}_setProperty(p,v){this._setPendingProperty(p,v)&&this._invalidateProperties()}_getProperty(p){return this.__data[p]}_setPendingProperty(p,v,C){let P=this.__data[p],k=this._shouldPropertyChange(p,v,P);return k&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),this.__dataOld&&!(p in this.__dataOld)&&(this.__dataOld[p]=P),this.__data[p]=v,this.__dataPending[p]=v),k}_isPropertyPending(p){return!!(this.__dataPending&&this.__dataPending.hasOwnProperty(p))}_invalidateProperties(){!this.__dataInvalid&&this.__dataReady&&(this.__dataInvalid=!0,microtask.run(()=>{this.__dataInvalid&&(this.__dataInvalid=!1,this._flushProperties())}))}_enableProperties(){this.__dataEnabled||(this.__dataEnabled=!0,this.__dataInstanceProps&&(this._initializeInstanceProperties(this.__dataInstanceProps),this.__dataInstanceProps=null),this.ready())}_flushProperties(){this.__dataCounter++;const p=this.__data,v=this.__dataPending,C=this.__dataOld;this._shouldPropertiesChange(p,v,C)&&(this.__dataPending=null,this.__dataOld=null,this._propertiesChanged(p,v,C)),this.__dataCounter--}_shouldPropertiesChange(p,v,C){return!!v}_propertiesChanged(p,v,C){}_shouldPropertyChange(p,v,C){return C!==v&&(C===C||v===v)}attributeChangedCallback(p,v,C,P){v!==C&&this._attributeToProperty(p,C),super.attributeChangedCallback&&super.attributeChangedCallback(p,v,C,P)}_attributeToProperty(p,v,C){if(!this.__serializing){const P=this.__dataAttributes,k=P&&P[p]||p;this[k]=this._deserializeValue(v,C||this.constructor.typeForProperty(k))}}_propertyToAttribute(p,v,C){this.__serializing=!0,C=arguments.length<3?this[p]:C,this._valueToNodeAttribute(this,C,v||this.constructor.attributeNameForProperty(p)),this.__serializing=!1}_valueToNodeAttribute(p,v,C){const P=this._serializeValue(v);(C==="class"||C==="name"||C==="slot")&&(p=wrap$j(p)),P===void 0?p.removeAttribute(C):p.setAttribute(C,P===""&&window.trustedTypes?window.trustedTypes.emptyScript:P)}_serializeValue(p){switch(typeof p){case"boolean":return p?"":void 0;default:return p?.toString()}}_deserializeValue(p,v){switch(v){case Boolean:return p!==null;case Number:return Number(p);default:return p}}}return d});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const nativeProperties={};let proto=HTMLElement.prototype;for(;proto;){let g=Object.getOwnPropertyNames(proto);for(let d=0;d<g.length;d++)nativeProperties[g[d]]=!0;proto=Object.getPrototypeOf(proto)}const isTrustedType=window.trustedTypes?g=>trustedTypes.isHTML(g)||trustedTypes.isScript(g)||trustedTypes.isScriptURL(g):()=>!1;function saveAccessorValue(g,d){if(!nativeProperties[d]){let a=g[d];a!==void 0&&(g.__data?g._setPendingProperty(d,a):(g.__dataProto?g.hasOwnProperty(JSCompiler_renameProperty("__dataProto",g))||(g.__dataProto=Object.create(g.__dataProto)):g.__dataProto={},g.__dataProto[d]=a))}}const PropertyAccessors=dedupingMixin(g=>{const d=PropertiesChanged(g);class a extends d{static createPropertiesForAttributes(){let v=this.observedAttributes;for(let C=0;C<v.length;C++)this.prototype._createPropertyAccessor(dashToCamelCase(v[C]))}static attributeNameForProperty(v){return camelToDashCase(v)}_initializeProperties(){this.__dataProto&&(this._initializeProtoProperties(this.__dataProto),this.__dataProto=null),super._initializeProperties()}_initializeProtoProperties(v){for(let C in v)this._setProperty(C,v[C])}_ensureAttribute(v,C){const P=this;P.hasAttribute(v)||this._valueToNodeAttribute(P,C,v)}_serializeValue(v){switch(typeof v){case"object":if(v instanceof Date)return v.toString();if(v){if(isTrustedType(v))return v;try{return JSON.stringify(v)}catch{return""}}default:return super._serializeValue(v)}}_deserializeValue(v,C){let P;switch(C){case Object:try{P=JSON.parse(v)}catch{P=v}break;case Array:try{P=JSON.parse(v)}catch{P=null,console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${v}`)}break;case Date:P=isNaN(v)?String(v):Number(v),P=new Date(P);break;default:P=super._deserializeValue(v,C);break}return P}_definePropertyAccessor(v,C){saveAccessorValue(this,v),super._definePropertyAccessor(v,C)}_hasAccessor(v){return this.__dataHasAccessor&&this.__dataHasAccessor[v]}_isPropertyPending(v){return!!(this.__dataPending&&v in this.__dataPending)}}return a});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const templateExtensions={"dom-if":!0,"dom-repeat":!0};let placeholderBugDetect=!1,placeholderBug=!1;function hasPlaceholderBug(){if(!placeholderBugDetect){placeholderBugDetect=!0;const g=document.createElement("textarea");g.placeholder="a",placeholderBug=g.placeholder===g.textContent}return placeholderBug}function fixPlaceholder(g){hasPlaceholderBug()&&g.localName==="textarea"&&g.placeholder&&g.placeholder===g.textContent&&(g.textContent=null)}const copyAttributeWithTemplateEventPolicy=(()=>{const g=window.trustedTypes&&window.trustedTypes.createPolicy("polymer-template-event-attribute-policy",{createScript:d=>d});return(d,a,p)=>{const v=a.getAttribute(p);if(g&&p.startsWith("on-")){d.setAttribute(p,g.createScript(v,p));return}d.setAttribute(p,v)}})();function wrapTemplateExtension(g){let d=g.getAttribute("is");if(d&&templateExtensions[d]){let a=g;for(a.removeAttribute("is"),g=a.ownerDocument.createElement(d),a.parentNode.replaceChild(g,a),g.appendChild(a);a.attributes.length;){const{name:p}=a.attributes[0];copyAttributeWithTemplateEventPolicy(g,a,p),a.removeAttribute(p)}}return g}function findTemplateNode(g,d){let a=d.parentInfo&&findTemplateNode(g,d.parentInfo);if(a){for(let p=a.firstChild,v=0;p;p=p.nextSibling)if(d.parentIndex===v++)return p}else return g}function applyIdToMap(g,d,a,p){p.id&&(d[p.id]=a)}function applyEventListener(g,d,a){if(a.events&&a.events.length)for(let p=0,v=a.events,C;p<v.length&&(C=v[p]);p++)g._addMethodEventListenerToNode(d,C.name,C.value,g)}function applyTemplateInfo(g,d,a,p){a.templateInfo&&(d._templateInfo=a.templateInfo,d._parentTemplateInfo=p)}function createNodeEventHandler(g,d,a){return g=g._methodHost||g,function(v){g[a]?g[a](v,v.detail):console.warn("listener method `"+a+"` not defined")}}const TemplateStamp=dedupingMixin(g=>{class d extends g{static _parseTemplate(p,v){if(!p._templateInfo){let C=p._templateInfo={};C.nodeInfoList=[],C.nestedTemplate=!!v,C.stripWhiteSpace=v&&v.stripWhiteSpace||p.hasAttribute&&p.hasAttribute("strip-whitespace"),this._parseTemplateContent(p,C,{parent:null})}return p._templateInfo}static _parseTemplateContent(p,v,C){return this._parseTemplateNode(p.content,v,C)}static _parseTemplateNode(p,v,C){let P=!1,k=p;return k.localName=="template"&&!k.hasAttribute("preserve-content")?P=this._parseTemplateNestedTemplate(k,v,C)||P:k.localName==="slot"&&(v.hasInsertionPoint=!0),fixPlaceholder(k),k.firstChild&&this._parseTemplateChildNodes(k,v,C),k.hasAttributes&&k.hasAttributes()&&(P=this._parseTemplateNodeAttributes(k,v,C)||P),P||C.noted}static _parseTemplateChildNodes(p,v,C){if(!(p.localName==="script"||p.localName==="style"))for(let P=p.firstChild,k=0,z;P;P=z){if(P.localName=="template"&&(P=wrapTemplateExtension(P)),z=P.nextSibling,P.nodeType===Node.TEXT_NODE){let D=z;for(;D&&D.nodeType===Node.TEXT_NODE;)P.textContent+=D.textContent,z=D.nextSibling,p.removeChild(D),D=z;if(v.stripWhiteSpace&&!P.textContent.trim()){p.removeChild(P);continue}}let $={parentIndex:k,parentInfo:C};this._parseTemplateNode(P,v,$)&&($.infoIndex=v.nodeInfoList.push($)-1),P.parentNode&&k++}}static _parseTemplateNestedTemplate(p,v,C){let P=p,k=this._parseTemplate(P,v);return(k.content=P.content.ownerDocument.createDocumentFragment()).appendChild(P.content),C.templateInfo=k,!0}static _parseTemplateNodeAttributes(p,v,C){let P=!1,k=Array.from(p.attributes);for(let z=k.length-1,$;$=k[z];z--)P=this._parseTemplateNodeAttribute(p,v,C,$.name,$.value)||P;return P}static _parseTemplateNodeAttribute(p,v,C,P,k){return P.slice(0,3)==="on-"?(p.removeAttribute(P),C.events=C.events||[],C.events.push({name:P.slice(3),value:k}),!0):P==="id"?(C.id=k,!0):!1}static _contentForTemplate(p){let v=p._templateInfo;return v&&v.content||p.content}_stampTemplate(p,v){p&&!p.content&&window.HTMLTemplateElement&&HTMLTemplateElement.decorate&&HTMLTemplateElement.decorate(p),v=v||this.constructor._parseTemplate(p);let C=v.nodeInfoList,P=v.content||p.content,k=document.importNode(P,!0);k.__noInsertionPoint=!v.hasInsertionPoint;let z=k.nodeList=new Array(C.length);k.$={};for(let $=0,D=C.length,F;$<D&&(F=C[$]);$++){let N=z[$]=findTemplateNode(k,F);applyIdToMap(this,k.$,N,F),applyTemplateInfo(this,N,F,v),applyEventListener(this,N,F)}return k=k,k}_addMethodEventListenerToNode(p,v,C,P){P=P||p;let k=createNodeEventHandler(P,v,C);return this._addEventListenerToNode(p,v,k),k}_addEventListenerToNode(p,v,C){p.addEventListener(v,C)}_removeEventListenerFromNode(p,v,C){p.removeEventListener(v,C)}}return d});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */let dedupeId=0;const NOOP=[],TYPES={COMPUTE:"__computeEffects",REFLECT:"__reflectEffects",NOTIFY:"__notifyEffects",PROPAGATE:"__propagateEffects",OBSERVE:"__observeEffects",READ_ONLY:"__readOnly"},COMPUTE_INFO="__computeInfo",capitalAttributeRegex=/[A-Z]/;function ensureOwnEffectMap(g,d,a){let p=g[d];if(!p)p=g[d]={};else if(!g.hasOwnProperty(d)&&(p=g[d]=Object.create(g[d]),a))for(let v in p){let C=p[v],P=p[v]=Array(C.length);for(let k=0;k<C.length;k++)P[k]=C[k]}return p}function runEffects(g,d,a,p,v,C){if(d){let P=!1;const k=dedupeId++;for(let z in a){let $=v?root(z):z,D=d[$];if(D)for(let F=0,N=D.length,W;F<N&&(W=D[F]);F++)(!W.info||W.info.lastRun!==k)&&(!v||pathMatchesTrigger(z,W.trigger))&&(W.info&&(W.info.lastRun=k),W.fn(g,z,a,p,W.info,v,C),P=!0)}return P}return!1}function runEffectsForProperty(g,d,a,p,v,C,P,k){let z=!1,$=P?root(p):p,D=d[$];if(D)for(let F=0,N=D.length,W;F<N&&(W=D[F]);F++)(!W.info||W.info.lastRun!==a)&&(!P||pathMatchesTrigger(p,W.trigger))&&(W.info&&(W.info.lastRun=a),W.fn(g,p,v,C,W.info,P,k),z=!0);return z}function pathMatchesTrigger(g,d){if(d){let a=d.name;return a==g||!!(d.structured&&isAncestor(a,g))||!!(d.wildcard&&isDescendant(a,g))}else return!0}function runObserverEffect(g,d,a,p,v){let C=typeof v.method=="string"?g[v.method]:v.method,P=v.property;C?C.call(g,g.__data[P],p[P]):v.dynamicFn||console.warn("observer method `"+v.method+"` not defined")}function runNotifyEffects(g,d,a,p,v){let C=g[TYPES.NOTIFY],P,k=dedupeId++;for(let $ in d)d[$]&&(C&&runEffectsForProperty(g,C,k,$,a,p,v)||v&&notifyPath(g,$,a))&&(P=!0);let z;P&&(z=g.__dataHost)&&z._invalidateProperties&&z._invalidateProperties()}function notifyPath(g,d,a){let p=root(d);if(p!==d){let v=camelToDashCase(p)+"-changed";return dispatchNotifyEvent(g,v,a[d],d),!0}return!1}function dispatchNotifyEvent(g,d,a,p){let v={value:a,queueProperty:!0};p&&(v.path=p),wrap$j(g).dispatchEvent(new CustomEvent(d,{detail:v}))}function runNotifyEffect(g,d,a,p,v,C){let k=(C?root(d):d)!=d?d:null,z=k?get$6(g,k):g.__data[d];k&&z===void 0&&(z=a[d]),dispatchNotifyEvent(g,v.eventName,z,k)}function handleNotification(g,d,a,p,v){let C,P=g.detail,k=P&&P.path;k?(p=translate$1(a,p,k),C=P&&P.value):C=g.currentTarget[a],C=v?!C:C,(!d[TYPES.READ_ONLY]||!d[TYPES.READ_ONLY][p])&&d._setPendingPropertyOrPath(p,C,!0,!!k)&&(!P||!P.queueProperty)&&d._invalidateProperties()}function runReflectEffect(g,d,a,p,v){let C=g.__data[d];sanitizeDOMValue&&(C=sanitizeDOMValue(C,v.attrName,"attribute",g)),g._propertyToAttribute(d,v.attrName,C)}function runComputedEffects(g,d,a,p){let v=g[TYPES.COMPUTE];if(v)if(orderedComputed){dedupeId++;const C=getComputedOrder(g),P=[];for(let z in d)enqueueEffectsFor(z,v,P,C,p);let k;for(;k=P.shift();)runComputedEffect(g,"",d,a,k)&&enqueueEffectsFor(k.methodInfo,v,P,C,p);Object.assign(a,g.__dataOld),Object.assign(d,g.__dataPending),g.__dataPending=null}else{let C=d;for(;runEffects(g,v,C,a,p);)Object.assign(a,g.__dataOld),Object.assign(d,g.__dataPending),C=g.__dataPending,g.__dataPending=null}}const insertEffect=(g,d,a)=>{let p=0,v=d.length-1,C=-1;for(;p<=v;){const P=p+v>>1,k=a.get(d[P].methodInfo)-a.get(g.methodInfo);if(k<0)p=P+1;else if(k>0)v=P-1;else{C=P;break}}C<0&&(C=v+1),d.splice(C,0,g)},enqueueEffectsFor=(g,d,a,p,v)=>{const C=v?root(g):g,P=d[C];if(P)for(let k=0;k<P.length;k++){const z=P[k];z.info.lastRun!==dedupeId&&(!v||pathMatchesTrigger(g,z.trigger))&&(z.info.lastRun=dedupeId,insertEffect(z.info,a,p))}};function getComputedOrder(g){let d=g.constructor.__orderedComputedDeps;if(!d){d=new Map;const a=g[TYPES.COMPUTE];let{counts:p,ready:v,total:C}=dependencyCounts(g),P;for(;P=v.shift();){d.set(P,d.size);const k=a[P];k&&k.forEach(z=>{const $=z.info.methodInfo;--C,--p[$]===0&&v.push($)})}C!==0&&console.warn(`Computed graph for ${g.localName} incomplete; circular?`),g.constructor.__orderedComputedDeps=d}return d}function dependencyCounts(g){const d=g[COMPUTE_INFO],a={},p=g[TYPES.COMPUTE],v=[];let C=0;for(let P in d){const k=d[P];C+=a[P]=k.args.filter(z=>!z.literal).length+(k.dynamicFn?1:0)}for(let P in p)d[P]||v.push(P);return{counts:a,ready:v,total:C}}function runComputedEffect(g,d,a,p,v){let C=runMethodEffect(g,d,a,p,v);if(C===NOOP)return!1;let P=v.methodInfo;return g.__dataHasAccessor&&g.__dataHasAccessor[P]?g._setPendingProperty(P,C,!0):(g[P]=C,!1)}function computeLinkedPaths(g,d,a){let p=g.__dataLinkedPaths;if(p){let v;for(let C in p){let P=p[C];isDescendant(C,d)?(v=translate$1(C,P,d),g._setPendingPropertyOrPath(v,a,!0,!0)):isDescendant(P,d)&&(v=translate$1(P,C,d),g._setPendingPropertyOrPath(v,a,!0,!0))}}}function addBinding(g,d,a,p,v,C,P){a.bindings=a.bindings||[];let k={kind:p,target:v,parts:C,literal:P,isCompound:C.length!==1};if(a.bindings.push(k),shouldAddListener(k)){let{event:$,negate:D}=k.parts[0];k.listenerEvent=$||camelToDashCase(v)+"-changed",k.listenerNegate=D}let z=d.nodeInfoList.length;for(let $=0;$<k.parts.length;$++){let D=k.parts[$];D.compoundIndex=$,addEffectForBindingPart(g,d,k,D,z)}}function addEffectForBindingPart(g,d,a,p,v){if(!p.literal)if(a.kind==="attribute"&&a.target[0]==="-")console.warn("Cannot set attribute "+a.target+' because "-" is not a valid attribute starting character');else{let C=p.dependencies,P={index:v,binding:a,part:p,evaluator:g};for(let k=0;k<C.length;k++){let z=C[k];typeof z=="string"&&(z=parseArg(z),z.wildcard=!0),g._addTemplatePropertyEffect(d,z.rootProperty,{fn:runBindingEffect,info:P,trigger:z})}}}function runBindingEffect(g,d,a,p,v,C,P){let k=P[v.index],z=v.binding,$=v.part;if(C&&$.source&&d.length>$.source.length&&z.kind=="property"&&!z.isCompound&&k.__isPropertyEffectsClient&&k.__dataHasAccessor&&k.__dataHasAccessor[z.target]){let D=a[d];d=translate$1($.source,z.target,d),k._setPendingPropertyOrPath(d,D,!1,!0)&&g._enqueueClient(k)}else{let D=v.evaluator._evaluateBinding(g,$,d,a,p,C);D!==NOOP&&applyBindingValue(g,k,z,$,D)}}function applyBindingValue(g,d,a,p,v){if(v=computeBindingValue(d,v,a,p),sanitizeDOMValue&&(v=sanitizeDOMValue(v,a.target,a.kind,d)),a.kind=="attribute")g._valueToNodeAttribute(d,v,a.target);else{let C=a.target;d.__isPropertyEffectsClient&&d.__dataHasAccessor&&d.__dataHasAccessor[C]?(!d[TYPES.READ_ONLY]||!d[TYPES.READ_ONLY][C])&&d._setPendingProperty(C,v)&&g._enqueueClient(d):g._setUnmanagedPropertyToNode(d,C,v)}}function computeBindingValue(g,d,a,p){if(a.isCompound){let v=g.__dataCompoundStorage[a.target];v[p.compoundIndex]=d,d=v.join("")}return a.kind!=="attribute"&&(a.target==="textContent"||a.target==="value"&&(g.localName==="input"||g.localName==="textarea"))&&(d=d??""),d}function shouldAddListener(g){return!!g.target&&g.kind!="attribute"&&g.kind!="text"&&!g.isCompound&&g.parts[0].mode==="{"}function setupBindings(g,d){let{nodeList:a,nodeInfoList:p}=d;if(p.length)for(let v=0;v<p.length;v++){let C=p[v],P=a[v],k=C.bindings;if(k)for(let z=0;z<k.length;z++){let $=k[z];setupCompoundStorage(P,$),addNotifyListener(P,g,$)}P.__dataHost=g}}function setupCompoundStorage(g,d){if(d.isCompound){let a=g.__dataCompoundStorage||(g.__dataCompoundStorage={}),p=d.parts,v=new Array(p.length);for(let P=0;P<p.length;P++)v[P]=p[P].literal;let C=d.target;a[C]=v,d.literal&&d.kind=="property"&&(C==="className"&&(g=wrap$j(g)),g[C]=d.literal)}}function addNotifyListener(g,d,a){if(a.listenerEvent){let p=a.parts[0];g.addEventListener(a.listenerEvent,function(v){handleNotification(v,d,a.target,p.source,p.negate)})}}function createMethodEffect(g,d,a,p,v,C){C=d.static||C&&(typeof C!="object"||C[d.methodName]);let P={methodName:d.methodName,args:d.args,methodInfo:v,dynamicFn:C};for(let k=0,z;k<d.args.length&&(z=d.args[k]);k++)z.literal||g._addPropertyEffect(z.rootProperty,a,{fn:p,info:P,trigger:z});return C&&g._addPropertyEffect(d.methodName,a,{fn:p,info:P}),P}function runMethodEffect(g,d,a,p,v){let C=g._methodHost||g,P=C[v.methodName];if(P){let k=g._marshalArgs(v.args,d,a);return k===NOOP?NOOP:P.apply(C,k)}else v.dynamicFn||console.warn("method `"+v.methodName+"` not defined")}const emptyArray=[],IDENT="(?:[a-zA-Z_$][\\w.:$\\-*]*)",NUMBER$1="(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)",SQUOTE_STRING="(?:'(?:[^'\\\\]|\\\\.)*')",DQUOTE_STRING='(?:"(?:[^"\\\\]|\\\\.)*")',STRING="(?:"+SQUOTE_STRING+"|"+DQUOTE_STRING+")",ARGUMENT="(?:("+IDENT+"|"+NUMBER$1+"|"+STRING+")\\s*)",ARGUMENTS="(?:"+ARGUMENT+"(?:,\\s*"+ARGUMENT+")*)",ARGUMENT_LIST="(?:\\(\\s*(?:"+ARGUMENTS+"?)\\)\\s*)",BINDING="("+IDENT+"\\s*"+ARGUMENT_LIST+"?)",OPEN_BRACKET="(\\[\\[|{{)\\s*",CLOSE_BRACKET="(?:]]|}})",NEGATE="(?:(!)\\s*)?",EXPRESSION=OPEN_BRACKET+NEGATE+BINDING+CLOSE_BRACKET,bindingRegex=new RegExp(EXPRESSION,"g");function literalFromParts(g){let d="";for(let a=0;a<g.length;a++){let p=g[a].literal;d+=p||""}return d}function parseMethod(g){let d=g.match(/([^\s]+?)\(([\s\S]*)\)/);if(d){let p={methodName:d[1],static:!0,args:emptyArray};if(d[2].trim()){let v=d[2].replace(/\\,/g,"&comma;").split(",");return parseArgs(v,p)}else return p}return null}function parseArgs(g,d){return d.args=g.map(function(a){let p=parseArg(a);return p.literal||(d.static=!1),p},this),d}function parseArg(g){let d=g.trim().replace(/&comma;/g,",").replace(/\\(.)/g,"$1"),a={name:d,value:"",literal:!1},p=d[0];switch(p==="-"&&(p=d[1]),p>="0"&&p<="9"&&(p="#"),p){case"'":case'"':a.value=d.slice(1,-1),a.literal=!0;break;case"#":a.value=Number(d),a.literal=!0;break}return a.literal||(a.rootProperty=root(d),a.structured=isPath(d),a.structured&&(a.wildcard=d.slice(-2)==".*",a.wildcard&&(a.name=d.slice(0,-2)))),a}function getArgValue(g,d,a){let p=get$6(g,a);return p===void 0&&(p=d[a]),p}function notifySplices(g,d,a,p){const v={indexSplices:p};legacyUndefined&&!g._overrideLegacyUndefined&&(d.splices=v),g.notifyPath(a+".splices",v),g.notifyPath(a+".length",d.length),legacyUndefined&&!g._overrideLegacyUndefined&&(v.indexSplices=[])}function notifySplice(g,d,a,p,v,C){notifySplices(g,d,a,[{index:p,addedCount:v,removed:C,object:d,type:"splice"}])}function upper(g){return g[0].toUpperCase()+g.substring(1)}const PropertyEffects=dedupingMixin(g=>{const d=TemplateStamp(PropertyAccessors(g));class a extends d{constructor(){super(),this.__isPropertyEffectsClient=!0,this.__dataClientsReady,this.__dataPendingClients,this.__dataToNotify,this.__dataLinkedPaths,this.__dataHasPaths,this.__dataCompoundStorage,this.__dataHost,this.__dataTemp,this.__dataClientsInitialized,this.__data,this.__dataPending,this.__dataOld,this.__computeEffects,this.__computeInfo,this.__reflectEffects,this.__notifyEffects,this.__propagateEffects,this.__observeEffects,this.__readOnly,this.__templateInfo,this._overrideLegacyUndefined}get PROPERTY_EFFECT_TYPES(){return TYPES}_initializeProperties(){super._initializeProperties(),this._registerHost(),this.__dataClientsReady=!1,this.__dataPendingClients=null,this.__dataToNotify=null,this.__dataLinkedPaths=null,this.__dataHasPaths=!1,this.__dataCompoundStorage=this.__dataCompoundStorage||null,this.__dataHost=this.__dataHost||null,this.__dataTemp={},this.__dataClientsInitialized=!1}_registerHost(){if(hostStack.length){let v=hostStack[hostStack.length-1];v._enqueueClient(this),this.__dataHost=v}}_initializeProtoProperties(v){this.__data=Object.create(v),this.__dataPending=Object.create(v),this.__dataOld={}}_initializeInstanceProperties(v){let C=this[TYPES.READ_ONLY];for(let P in v)(!C||!C[P])&&(this.__dataPending=this.__dataPending||{},this.__dataOld=this.__dataOld||{},this.__data[P]=this.__dataPending[P]=v[P])}_addPropertyEffect(v,C,P){this._createPropertyAccessor(v,C==TYPES.READ_ONLY);let k=ensureOwnEffectMap(this,C,!0)[v];k||(k=this[C][v]=[]),k.push(P)}_removePropertyEffect(v,C,P){let k=ensureOwnEffectMap(this,C,!0)[v],z=k.indexOf(P);z>=0&&k.splice(z,1)}_hasPropertyEffect(v,C){let P=this[C];return!!(P&&P[v])}_hasReadOnlyEffect(v){return this._hasPropertyEffect(v,TYPES.READ_ONLY)}_hasNotifyEffect(v){return this._hasPropertyEffect(v,TYPES.NOTIFY)}_hasReflectEffect(v){return this._hasPropertyEffect(v,TYPES.REFLECT)}_hasComputedEffect(v){return this._hasPropertyEffect(v,TYPES.COMPUTE)}_setPendingPropertyOrPath(v,C,P,k){if(k||root(Array.isArray(v)?v[0]:v)!==v){if(!k){let z=get$6(this,v);if(v=set$1(this,v,C),!v||!super._shouldPropertyChange(v,C,z))return!1}if(this.__dataHasPaths=!0,this._setPendingProperty(v,C,P))return computeLinkedPaths(this,v,C),!0}else{if(this.__dataHasAccessor&&this.__dataHasAccessor[v])return this._setPendingProperty(v,C,P);this[v]=C}return!1}_setUnmanagedPropertyToNode(v,C,P){(P!==v[C]||typeof P=="object")&&(C==="className"&&(v=wrap$j(v)),v[C]=P)}_setPendingProperty(v,C,P){let k=this.__dataHasPaths&&isPath(v),z=k?this.__dataTemp:this.__data;return this._shouldPropertyChange(v,C,z[v])?(this.__dataPending||(this.__dataPending={},this.__dataOld={}),v in this.__dataOld||(this.__dataOld[v]=this.__data[v]),k?this.__dataTemp[v]=C:this.__data[v]=C,this.__dataPending[v]=C,(k||this[TYPES.NOTIFY]&&this[TYPES.NOTIFY][v])&&(this.__dataToNotify=this.__dataToNotify||{},this.__dataToNotify[v]=P),!0):!1}_setProperty(v,C){this._setPendingProperty(v,C,!0)&&this._invalidateProperties()}_invalidateProperties(){this.__dataReady&&this._flushProperties()}_enqueueClient(v){this.__dataPendingClients=this.__dataPendingClients||[],v!==this&&this.__dataPendingClients.push(v)}_flushClients(){this.__dataClientsReady?this.__enableOrFlushClients():(this.__dataClientsReady=!0,this._readyClients(),this.__dataReady=!0)}__enableOrFlushClients(){let v=this.__dataPendingClients;if(v){this.__dataPendingClients=null;for(let C=0;C<v.length;C++){let P=v[C];P.__dataEnabled?P.__dataPending&&P._flushProperties():P._enableProperties()}}}_readyClients(){this.__enableOrFlushClients()}setProperties(v,C){for(let P in v)(C||!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][P])&&this._setPendingPropertyOrPath(P,v[P],!0);this._invalidateProperties()}ready(){this._flushProperties(),this.__dataClientsReady||this._flushClients(),this.__dataPending&&this._flushProperties()}_propertiesChanged(v,C,P){let k=this.__dataHasPaths;this.__dataHasPaths=!1;let z;runComputedEffects(this,C,P,k),z=this.__dataToNotify,this.__dataToNotify=null,this._propagatePropertyChanges(C,P,k),this._flushClients(),runEffects(this,this[TYPES.REFLECT],C,P,k),runEffects(this,this[TYPES.OBSERVE],C,P,k),z&&runNotifyEffects(this,z,C,P,k),this.__dataCounter==1&&(this.__dataTemp={})}_propagatePropertyChanges(v,C,P){this[TYPES.PROPAGATE]&&runEffects(this,this[TYPES.PROPAGATE],v,C,P),this.__templateInfo&&this._runEffectsForTemplate(this.__templateInfo,v,C,P)}_runEffectsForTemplate(v,C,P,k){const z=($,D)=>{runEffects(this,v.propertyEffects,$,P,D,v.nodeList);for(let F=v.firstChild;F;F=F.nextSibling)this._runEffectsForTemplate(F,$,P,D)};v.runEffects?v.runEffects(z,C,k):z(C,k)}linkPaths(v,C){v=normalize$1(v),C=normalize$1(C),this.__dataLinkedPaths=this.__dataLinkedPaths||{},this.__dataLinkedPaths[v]=C}unlinkPaths(v){v=normalize$1(v),this.__dataLinkedPaths&&delete this.__dataLinkedPaths[v]}notifySplices(v,C){let P={path:""},k=get$6(this,v,P);notifySplices(this,k,P.path,C)}get(v,C){return get$6(C||this,v)}set(v,C,P){P?set$1(P,v,C):(!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][v])&&this._setPendingPropertyOrPath(v,C,!0)&&this._invalidateProperties()}push(v,...C){let P={path:""},k=get$6(this,v,P),z=k.length,$=k.push(...C);return C.length&&notifySplice(this,k,P.path,z,C.length,[]),$}pop(v){let C={path:""},P=get$6(this,v,C),k=!!P.length,z=P.pop();return k&&notifySplice(this,P,C.path,P.length,0,[z]),z}splice(v,C,P,...k){let z={path:""},$=get$6(this,v,z);C<0?C=$.length-Math.floor(-C):C&&(C=Math.floor(C));let D;return arguments.length===2?D=$.splice(C):D=$.splice(C,P,...k),(k.length||D.length)&&notifySplice(this,$,z.path,C,k.length,D),D}shift(v){let C={path:""},P=get$6(this,v,C),k=!!P.length,z=P.shift();return k&&notifySplice(this,P,C.path,0,0,[z]),z}unshift(v,...C){let P={path:""},k=get$6(this,v,P),z=k.unshift(...C);return C.length&&notifySplice(this,k,P.path,0,C.length,[]),z}notifyPath(v,C){let P;if(arguments.length==1){let k={path:""};C=get$6(this,v,k),P=k.path}else Array.isArray(v)?P=normalize$1(v):P=v;this._setPendingPropertyOrPath(P,C,!0,!0)&&this._invalidateProperties()}_createReadOnlyProperty(v,C){this._addPropertyEffect(v,TYPES.READ_ONLY),C&&(this["_set"+upper(v)]=function(P){this._setProperty(v,P)})}_createPropertyObserver(v,C,P){let k={property:v,method:C,dynamicFn:!!P};this._addPropertyEffect(v,TYPES.OBSERVE,{fn:runObserverEffect,info:k,trigger:{name:v}}),P&&this._addPropertyEffect(C,TYPES.OBSERVE,{fn:runObserverEffect,info:k,trigger:{name:C}})}_createMethodObserver(v,C){let P=parseMethod(v);if(!P)throw new Error("Malformed observer expression '"+v+"'");createMethodEffect(this,P,TYPES.OBSERVE,runMethodEffect,null,C)}_createNotifyingProperty(v){this._addPropertyEffect(v,TYPES.NOTIFY,{fn:runNotifyEffect,info:{eventName:camelToDashCase(v)+"-changed",property:v}})}_createReflectedProperty(v){let C=this.constructor.attributeNameForProperty(v);C[0]==="-"?console.warn("Property "+v+" cannot be reflected to attribute "+C+' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.'):this._addPropertyEffect(v,TYPES.REFLECT,{fn:runReflectEffect,info:{attrName:C}})}_createComputedProperty(v,C,P){let k=parseMethod(C);if(!k)throw new Error("Malformed computed expression '"+C+"'");const z=createMethodEffect(this,k,TYPES.COMPUTE,runComputedEffect,v,P);ensureOwnEffectMap(this,COMPUTE_INFO)[v]=z}_marshalArgs(v,C,P){const k=this.__data,z=[];for(let $=0,D=v.length;$<D;$++){let{name:F,structured:N,wildcard:W,value:j,literal:q}=v[$];if(!q)if(W){const X=isDescendant(F,C),K=getArgValue(k,P,X?C:F);j={path:X?C:F,value:K,base:X?get$6(k,F):K}}else j=N?getArgValue(k,P,F):k[F];if(legacyUndefined&&!this._overrideLegacyUndefined&&j===void 0&&v.length>1)return NOOP;z[$]=j}return z}static addPropertyEffect(v,C,P){this.prototype._addPropertyEffect(v,C,P)}static createPropertyObserver(v,C,P){this.prototype._createPropertyObserver(v,C,P)}static createMethodObserver(v,C){this.prototype._createMethodObserver(v,C)}static createNotifyingProperty(v){this.prototype._createNotifyingProperty(v)}static createReadOnlyProperty(v,C){this.prototype._createReadOnlyProperty(v,C)}static createReflectedProperty(v){this.prototype._createReflectedProperty(v)}static createComputedProperty(v,C,P){this.prototype._createComputedProperty(v,C,P)}static bindTemplate(v){return this.prototype._bindTemplate(v)}_bindTemplate(v,C){let P=this.constructor._parseTemplate(v),k=this.__preBoundTemplateInfo==P;if(!k)for(let z in P.propertyEffects)this._createPropertyAccessor(z);if(C)if(P=Object.create(P),P.wasPreBound=k,!this.__templateInfo)this.__templateInfo=P;else{const z=v._parentTemplateInfo||this.__templateInfo,$=z.lastChild;P.parent=z,z.lastChild=P,P.previousSibling=$,$?$.nextSibling=P:z.firstChild=P}else this.__preBoundTemplateInfo=P;return P}static _addTemplatePropertyEffect(v,C,P){let k=v.hostProps=v.hostProps||{};k[C]=!0;let z=v.propertyEffects=v.propertyEffects||{};(z[C]=z[C]||[]).push(P)}_stampTemplate(v,C){C=C||this._bindTemplate(v,!0),hostStack.push(this);let P=super._stampTemplate(v,C);if(hostStack.pop(),C.nodeList=P.nodeList,!C.wasPreBound){let k=C.childNodes=[];for(let z=P.firstChild;z;z=z.nextSibling)k.push(z)}return P.templateInfo=C,setupBindings(this,C),this.__dataClientsReady&&(this._runEffectsForTemplate(C,this.__data,null,!1),this._flushClients()),P}_removeBoundDom(v){const C=v.templateInfo,{previousSibling:P,nextSibling:k,parent:z}=C;P?P.nextSibling=k:z&&(z.firstChild=k),k?k.previousSibling=P:z&&(z.lastChild=P),C.nextSibling=C.previousSibling=null;let $=C.childNodes;for(let D=0;D<$.length;D++){let F=$[D];wrap$j(wrap$j(F).parentNode).removeChild(F)}}static _parseTemplateNode(v,C,P){let k=d._parseTemplateNode.call(this,v,C,P);if(v.nodeType===Node.TEXT_NODE){let z=this._parseBindings(v.textContent,C);z&&(v.textContent=literalFromParts(z)||" ",addBinding(this,C,P,"text","textContent",z),k=!0)}return k}static _parseTemplateNodeAttribute(v,C,P,k,z){let $=this._parseBindings(z,C);if($){let D=k,F="property";capitalAttributeRegex.test(k)?F="attribute":k[k.length-1]=="$"&&(k=k.slice(0,-1),F="attribute");let N=literalFromParts($);return N&&F=="attribute"&&(k=="class"&&v.hasAttribute("class")&&(N+=" "+v.getAttribute(k)),v.setAttribute(k,N)),F=="attribute"&&D=="disable-upgrade$"&&v.setAttribute(k,""),v.localName==="input"&&D==="value"&&v.setAttribute(D,""),v.removeAttribute(D),F==="property"&&(k=dashToCamelCase(k)),addBinding(this,C,P,F,k,$,N),!0}else return d._parseTemplateNodeAttribute.call(this,v,C,P,k,z)}static _parseTemplateNestedTemplate(v,C,P){let k=d._parseTemplateNestedTemplate.call(this,v,C,P);const z=v.parentNode,$=P.templateInfo,D=z.localName==="dom-if",F=z.localName==="dom-repeat";removeNestedTemplates&&(D||F)&&(z.removeChild(v),P=P.parentInfo,P.templateInfo=$,P.noted=!0,k=!1);let N=$.hostProps;if(fastDomIf&&D)N&&(C.hostProps=Object.assign(C.hostProps||{},N),removeNestedTemplates||(P.parentInfo.noted=!0));else{let W="{";for(let j in N){let q=[{mode:W,source:j,dependencies:[j],hostProp:!0}];addBinding(this,C,P,"property","_host_"+j,q)}}return k}static _parseBindings(v,C){let P=[],k=0,z;for(;(z=bindingRegex.exec(v))!==null;){z.index>k&&P.push({literal:v.slice(k,z.index)});let $=z[1][0],D=!!z[2],F=z[3].trim(),N=!1,W="",j=-1;$=="{"&&(j=F.indexOf("::"))>0&&(W=F.substring(j+2),F=F.substring(0,j),N=!0);let q=parseMethod(F),X=[];if(q){let{args:K,methodName:ee}=q;for(let ie=0;ie<K.length;ie++){let oe=K[ie];oe.literal||X.push(oe)}let te=C.dynamicFns;(te&&te[ee]||q.static)&&(X.push(ee),q.dynamicFn=!0)}else X.push(F);P.push({source:F,mode:$,negate:D,customEvent:N,signature:q,dependencies:X,event:W}),k=bindingRegex.lastIndex}if(k&&k<v.length){let $=v.substring(k);$&&P.push({literal:$})}return P.length?P:null}static _evaluateBinding(v,C,P,k,z,$){let D;return C.signature?D=runMethodEffect(v,P,k,z,C.signature):P!=C.source?D=get$6(v,C.source):$&&isPath(P)?D=get$6(v,P):D=v.__data[P],C.negate&&(D=!D),D}}return a}),hostStack=[];/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function register$2(g){}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function normalizeProperties(g){const d={};for(let a in g){const p=g[a];d[a]=typeof p=="function"?{type:p}:p}return d}const PropertiesMixin=dedupingMixin(g=>{const d=PropertiesChanged(g);function a(C){const P=Object.getPrototypeOf(C);return P.prototype instanceof v?P:null}function p(C){if(!C.hasOwnProperty(JSCompiler_renameProperty("__ownProperties",C))){let P=null;if(C.hasOwnProperty(JSCompiler_renameProperty("properties",C))){const k=C.properties;k&&(P=normalizeProperties(k))}C.__ownProperties=P}return C.__ownProperties}class v extends d{static get observedAttributes(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))){this.prototype;const P=this._properties;this.__observedAttributes=P?Object.keys(P).map(k=>this.prototype._addPropertyToAttributeMap(k)):[]}return this.__observedAttributes}static finalize(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__finalized",this))){const P=a(this);P&&P.finalize(),this.__finalized=!0,this._finalizeClass()}}static _finalizeClass(){const P=p(this);P&&this.createProperties(P)}static get _properties(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__properties",this))){const P=a(this);this.__properties=Object.assign({},P&&P._properties,p(this))}return this.__properties}static typeForProperty(P){const k=this._properties[P];return k&&k.type}_initializeProperties(){this.constructor.finalize(),super._initializeProperties()}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this._enableProperties()}disconnectedCallback(){super.disconnectedCallback&&super.disconnectedCallback()}}return v});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */const version="3.5.2",builtCSS=window.ShadyCSS&&window.ShadyCSS.cssBuild,ElementMixin$1=dedupingMixin(g=>{const d=PropertiesMixin(PropertyEffects(g));function a(z){if(!z.hasOwnProperty(JSCompiler_renameProperty("__propertyDefaults",z))){z.__propertyDefaults=null;let $=z._properties;for(let D in $){let F=$[D];"value"in F&&(z.__propertyDefaults=z.__propertyDefaults||{},z.__propertyDefaults[D]=F)}}return z.__propertyDefaults}function p(z){return z.hasOwnProperty(JSCompiler_renameProperty("__ownObservers",z))||(z.__ownObservers=z.hasOwnProperty(JSCompiler_renameProperty("observers",z))?z.observers:null),z.__ownObservers}function v(z,$,D,F){D.computed&&(D.readOnly=!0),D.computed&&(z._hasReadOnlyEffect($)?console.warn(`Cannot redefine computed property '${$}'.`):z._createComputedProperty($,D.computed,F)),D.readOnly&&!z._hasReadOnlyEffect($)?z._createReadOnlyProperty($,!D.computed):D.readOnly===!1&&z._hasReadOnlyEffect($)&&console.warn(`Cannot make readOnly property '${$}' non-readOnly.`),D.reflectToAttribute&&!z._hasReflectEffect($)?z._createReflectedProperty($):D.reflectToAttribute===!1&&z._hasReflectEffect($)&&console.warn(`Cannot make reflected property '${$}' non-reflected.`),D.notify&&!z._hasNotifyEffect($)?z._createNotifyingProperty($):D.notify===!1&&z._hasNotifyEffect($)&&console.warn(`Cannot make notify property '${$}' non-notify.`),D.observer&&z._createPropertyObserver($,D.observer,F[D.observer]),z._addPropertyToAttributeMap($)}function C(z,$,D,F){if(!builtCSS){const N=$.content.querySelectorAll("style"),W=stylesFromTemplate($),j=stylesFromModuleImports(D),q=$.content.firstElementChild;for(let K=0;K<j.length;K++){let ee=j[K];ee.textContent=z._processStyleText(ee.textContent,F),$.content.insertBefore(ee,q)}let X=0;for(let K=0;K<W.length;K++){let ee=W[K],te=N[X];te!==ee?(ee=ee.cloneNode(!0),te.parentNode.insertBefore(ee,te)):X++,ee.textContent=z._processStyleText(ee.textContent,F)}}if(window.ShadyCSS&&window.ShadyCSS.prepareTemplate($,D),useAdoptedStyleSheetsWithBuiltCSS&&builtCSS&&supportsAdoptingStyleSheets){const N=$.content.querySelectorAll("style");if(N){let W="";Array.from(N).forEach(j=>{W+=j.textContent,j.parentNode.removeChild(j)}),z._styleSheet=new CSSStyleSheet,z._styleSheet.replaceSync(W)}}}function P(z){let $=null;if(z&&(!strictTemplatePolicy||allowTemplateFromDomModule)&&($=DomModule.import(z,"template"),strictTemplatePolicy&&!$))throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${z}`);return $}class k extends d{static get polymerElementVersion(){return version}static _finalizeClass(){d._finalizeClass.call(this);const $=p(this);$&&this.createObservers($,this._properties),this._prepareTemplate()}static _prepareTemplate(){let $=this.template;$&&(typeof $=="string"?(console.error("template getter must return HTMLTemplateElement"),$=null):legacyOptimizations||($=$.cloneNode(!0))),this.prototype._template=$}static createProperties($){for(let D in $)v(this.prototype,D,$[D],$)}static createObservers($,D){const F=this.prototype;for(let N=0;N<$.length;N++)F._createMethodObserver($[N],D)}static get template(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_template",this))){let $=this.prototype.hasOwnProperty(JSCompiler_renameProperty("_template",this.prototype))?this.prototype._template:void 0;typeof $=="function"&&($=$()),this._template=$!==void 0?$:this.hasOwnProperty(JSCompiler_renameProperty("is",this))&&P(this.is)||Object.getPrototypeOf(this.prototype).constructor.template}return this._template}static set template($){this._template=$}static get importPath(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_importPath",this))){const $=this.importMeta;if($)this._importPath=pathFromUrl($.url);else{const D=DomModule.import(this.is);this._importPath=D&&D.assetpath||Object.getPrototypeOf(this.prototype).constructor.importPath}}return this._importPath}constructor(){super(),this._template,this._importPath,this.rootPath,this.importPath,this.root,this.$}_initializeProperties(){this.constructor.finalize(),this.constructor._finalizeTemplate(this.localName),super._initializeProperties(),this.rootPath=rootPath,this.importPath=this.constructor.importPath;let $=a(this.constructor);if($)for(let D in $){let F=$[D];if(this._canApplyPropertyDefault(D)){let N=typeof F.value=="function"?F.value.call(this):F.value;this._hasAccessor(D)?this._setPendingProperty(D,N,!0):this[D]=N}}}_canApplyPropertyDefault($){return!this.hasOwnProperty($)}static _processStyleText($,D){return resolveCss($,D)}static _finalizeTemplate($){const D=this.prototype._template;if(D&&!D.__polymerFinalized){D.__polymerFinalized=!0;const F=this.importPath,N=F?resolveUrl(F):"";C(this,D,$,N),this.prototype._bindTemplate(D)}}connectedCallback(){window.ShadyCSS&&this._template&&window.ShadyCSS.styleElement(this),super.connectedCallback()}ready(){this._template&&(this.root=this._stampTemplate(this._template),this.$=this.root.$),super.ready()}_readyClients(){this._template&&(this.root=this._attachDom(this.root)),super._readyClients()}_attachDom($){const D=wrap$j(this);if(D.attachShadow)return $?(D.shadowRoot||(D.attachShadow({mode:"open",shadyUpgradeFragment:$}),D.shadowRoot.appendChild($),this.constructor._styleSheet&&(D.shadowRoot.adoptedStyleSheets=[this.constructor._styleSheet])),syncInitialRender&&window.ShadyDOM&&window.ShadyDOM.flushInitial(D.shadowRoot),D.shadowRoot):null;throw new Error("ShadowDOM not available. PolymerElement can create dom as children instead of in ShadowDOM by setting `this.root = this;` before `ready`.")}updateStyles($){window.ShadyCSS&&window.ShadyCSS.styleSubtree(this,$)}resolveUrl($,D){return!D&&this.importPath&&(D=resolveUrl(this.importPath)),resolveUrl($,D)}static _parseTemplateContent($,D,F){return D.dynamicFns=D.dynamicFns||this._properties,d._parseTemplateContent.call(this,$,D,F)}static _addTemplatePropertyEffect($,D,F){return legacyWarnings&&!(D in this._properties)&&!(F.info.part.signature&&F.info.part.signature.static)&&!F.info.part.hostProp&&!$.nestedTemplate&&console.warn(`Property '${D}' used in template but not declared in 'properties'; attribute will not be observed.`),d._addTemplatePropertyEffect.call(this,$,D,F)}}return k});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const policy=window.trustedTypes&&trustedTypes.createPolicy("polymer-html-literal",{createHTML:g=>g});class LiteralString{constructor(d,a){assertValidTemplateStringParameters(d,a);const p=a.reduce((v,C,P)=>v+literalValue(C)+d[P+1],d[0]);this.value=p.toString()}toString(){return this.value}}function literalValue(g){if(g instanceof LiteralString)return g.value;throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${g}`)}function htmlValue(g){if(g instanceof HTMLTemplateElement)return g.innerHTML;if(g instanceof LiteralString)return literalValue(g);throw new Error(`non-template value passed to Polymer's html function: ${g}`)}const html$3=function(d,...a){assertValidTemplateStringParameters(d,a);const p=document.createElement("template");let v=a.reduce((C,P,k)=>C+htmlValue(P)+d[k+1],d[0]);return policy&&(v=policy.createHTML(v)),p.innerHTML=v,p},assertValidTemplateStringParameters=(g,d)=>{if(!Array.isArray(g)||!Array.isArray(g.raw)||d.length!==g.length-1)throw new TypeError("Invalid call to the html template tag")};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const PolymerElement=ElementMixin$1(HTMLElement);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$i=g=>g,HAS_NATIVE_TA=typeof document.head.style.touchAction=="string",GESTURE_KEY="__polymerGestures",HANDLED_OBJ="__polymerGesturesHandled",TOUCH_ACTION="__polymerGesturesTouchAction",TAP_DISTANCE=25,TRACK_DISTANCE=5,TRACK_LENGTH=2,MOUSE_EVENTS=["mousedown","mousemove","mouseup","click"],MOUSE_WHICH_TO_BUTTONS=[0,1,4,2],MOUSE_HAS_BUTTONS=(function(){try{return new MouseEvent("test",{buttons:1}).buttons===1}catch{return!1}})();function isMouseEvent(g){return MOUSE_EVENTS.indexOf(g)>-1}let supportsPassive=!1;(function(){try{const g=Object.defineProperty({},"passive",{get(){supportsPassive=!0}});window.addEventListener("test",null,g),window.removeEventListener("test",null,g)}catch{}})();function PASSIVE_TOUCH(g){isMouseEvent(g)}const IS_TOUCH_ONLY=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/u),canBeDisabled={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function hasLeftMouseButton(g){const d=g.type;if(!isMouseEvent(d))return!1;if(d==="mousemove"){let p=g.buttons===void 0?1:g.buttons;return g instanceof window.MouseEvent&&!MOUSE_HAS_BUTTONS&&(p=MOUSE_WHICH_TO_BUTTONS[g.which]||0),!!(p&1)}return(g.button===void 0?0:g.button)===0}function isSyntheticClick(g){if(g.type==="click"){if(g.detail===0)return!0;const d=_findOriginalTarget(g);if(!d.nodeType||d.nodeType!==Node.ELEMENT_NODE)return!0;const a=d.getBoundingClientRect(),p=g.pageX,v=g.pageY;return!(p>=a.left&&p<=a.right&&v>=a.top&&v<=a.bottom)}return!1}const POINTERSTATE={touch:{x:0,y:0,id:-1,scrollDecided:!1}};function firstTouchAction(g){let d="auto";const a=getComposedPath(g);for(let p=0,v;p<a.length;p++)if(v=a[p],v[TOUCH_ACTION]){d=v[TOUCH_ACTION];break}return d}function trackDocument(g,d,a){g.movefn=d,g.upfn=a,document.addEventListener("mousemove",d),document.addEventListener("mouseup",a)}function untrackDocument(g){document.removeEventListener("mousemove",g.movefn),document.removeEventListener("mouseup",g.upfn),g.movefn=null,g.upfn=null}const getComposedPath=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:g=>g.composedPath&&g.composedPath()||[],gestures={},recognizers=[];function deepTargetFind(g,d){let a=document.elementFromPoint(g,d),p=a;for(;p&&p.shadowRoot&&!window.ShadyDOM;){const v=p;if(p=p.shadowRoot.elementFromPoint(g,d),v===p)break;p&&(a=p)}return a}function _findOriginalTarget(g){const d=getComposedPath(g);return d.length>0?d[0]:g.target}function _handleNative(g){const d=g.type,p=g.currentTarget[GESTURE_KEY];if(!p)return;const v=p[d];if(!v)return;if(!g[HANDLED_OBJ]&&(g[HANDLED_OBJ]={},d.startsWith("touch"))){const P=g.changedTouches[0];if(d==="touchstart"&&g.touches.length===1&&(POINTERSTATE.touch.id=P.identifier),POINTERSTATE.touch.id!==P.identifier)return;HAS_NATIVE_TA||(d==="touchstart"||d==="touchmove")&&_handleTouchAction(g)}const C=g[HANDLED_OBJ];if(!C.skip){for(let P=0,k;P<recognizers.length;P++)k=recognizers[P],v[k.name]&&!C[k.name]&&k.flow&&k.flow.start.indexOf(g.type)>-1&&k.reset&&k.reset();for(let P=0,k;P<recognizers.length;P++)k=recognizers[P],v[k.name]&&!C[k.name]&&(C[k.name]=!0,k[d](g))}}function _handleTouchAction(g){const d=g.changedTouches[0],a=g.type;if(a==="touchstart")POINTERSTATE.touch.x=d.clientX,POINTERSTATE.touch.y=d.clientY,POINTERSTATE.touch.scrollDecided=!1;else if(a==="touchmove"){if(POINTERSTATE.touch.scrollDecided)return;POINTERSTATE.touch.scrollDecided=!0;const p=firstTouchAction(g);let v=!1;const C=Math.abs(POINTERSTATE.touch.x-d.clientX),P=Math.abs(POINTERSTATE.touch.y-d.clientY);g.cancelable&&(p==="none"?v=!0:p==="pan-x"?v=P>C:p==="pan-y"&&(v=C>P)),v?g.preventDefault():prevent("track")}}function addListener(g,d,a){return gestures[d]?(_add(g,d,a),!0):!1}function removeListener(g,d,a){return gestures[d]?(_remove(g,d,a),!0):!1}function _add(g,d,a){const p=gestures[d],v=p.deps,C=p.name;let P=g[GESTURE_KEY];P||(g[GESTURE_KEY]=P={});for(let k=0,z,$;k<v.length;k++)z=v[k],!(IS_TOUCH_ONLY&&isMouseEvent(z)&&z!=="click")&&($=P[z],$||(P[z]=$={_count:0}),$._count===0&&g.addEventListener(z,_handleNative,PASSIVE_TOUCH(z)),$[C]=($[C]||0)+1,$._count=($._count||0)+1);g.addEventListener(d,a),p.touchAction&&setTouchAction(g,p.touchAction)}function _remove(g,d,a){const p=gestures[d],v=p.deps,C=p.name,P=g[GESTURE_KEY];if(P)for(let k=0,z,$;k<v.length;k++)z=v[k],$=P[z],$&&$[C]&&($[C]=($[C]||1)-1,$._count=($._count||1)-1,$._count===0&&g.removeEventListener(z,_handleNative,PASSIVE_TOUCH(z)));g.removeEventListener(d,a)}function register$1(g){recognizers.push(g),g.emits.forEach(d=>{gestures[d]=g})}function _findRecognizerByEvent(g){for(let d=0,a;d<recognizers.length;d++){a=recognizers[d];for(let p=0,v;p<a.emits.length;p++)if(v=a.emits[p],v===g)return a}return null}function setTouchAction(g,d){HAS_NATIVE_TA&&g instanceof HTMLElement&&microTask$1.run(()=>{g.style.touchAction=d}),g[TOUCH_ACTION]=d}function _fire(g,d,a){const p=new Event(d,{bubbles:!0,cancelable:!0,composed:!0});if(p.detail=a,wrap$i(g).dispatchEvent(p),p.defaultPrevented){const v=a.preventer||a.sourceEvent;v&&v.preventDefault&&v.preventDefault()}}function prevent(g){const d=_findRecognizerByEvent(g);d.info&&(d.info.prevent=!0)}register$1({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset(){untrackDocument(this.info)},mousedown(g){if(!hasLeftMouseButton(g))return;const d=_findOriginalTarget(g),a=this,p=C=>{hasLeftMouseButton(C)||(downupFire("up",d,C),untrackDocument(a.info))},v=C=>{hasLeftMouseButton(C)&&downupFire("up",d,C),untrackDocument(a.info)};trackDocument(this.info,p,v),downupFire("down",d,g)},touchstart(g){downupFire("down",_findOriginalTarget(g),g.changedTouches[0],g)},touchend(g){downupFire("up",_findOriginalTarget(g),g.changedTouches[0],g)}});function downupFire(g,d,a,p){d&&_fire(d,g,{x:a.clientX,y:a.clientY,sourceEvent:a,preventer:p,prevent(v){return prevent(v)}})}register$1({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove(g){this.moves.length>TRACK_LENGTH&&this.moves.shift(),this.moves.push(g)},movefn:null,upfn:null,prevent:!1},reset(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,untrackDocument(this.info)},mousedown(g){if(!hasLeftMouseButton(g))return;const d=_findOriginalTarget(g),a=this,p=C=>{const P=C.clientX,k=C.clientY;trackHasMovedEnough(a.info,P,k)&&(a.info.state=a.info.started?C.type==="mouseup"?"end":"track":"start",a.info.state==="start"&&prevent("tap"),a.info.addMove({x:P,y:k}),hasLeftMouseButton(C)||(a.info.state="end",untrackDocument(a.info)),d&&trackFire(a.info,d,C),a.info.started=!0)},v=C=>{a.info.started&&p(C),untrackDocument(a.info)};trackDocument(this.info,p,v),this.info.x=g.clientX,this.info.y=g.clientY},touchstart(g){const d=g.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchmove(g){const d=_findOriginalTarget(g),a=g.changedTouches[0],p=a.clientX,v=a.clientY;trackHasMovedEnough(this.info,p,v)&&(this.info.state==="start"&&prevent("tap"),this.info.addMove({x:p,y:v}),trackFire(this.info,d,a),this.info.state="track",this.info.started=!0)},touchend(g){const d=_findOriginalTarget(g),a=g.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:a.clientX,y:a.clientY}),trackFire(this.info,d,a))}});function trackHasMovedEnough(g,d,a){if(g.prevent)return!1;if(g.started)return!0;const p=Math.abs(g.x-d),v=Math.abs(g.y-a);return p>=TRACK_DISTANCE||v>=TRACK_DISTANCE}function trackFire(g,d,a){if(!d)return;const p=g.moves[g.moves.length-2],v=g.moves[g.moves.length-1],C=v.x-g.x,P=v.y-g.y;let k,z=0;p&&(k=v.x-p.x,z=v.y-p.y),_fire(d,"track",{state:g.state,x:a.clientX,y:a.clientY,dx:C,dy:P,ddx:k,ddy:z,sourceEvent:a,hover(){return deepTargetFind(a.clientX,a.clientY)}})}register$1({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown(g){hasLeftMouseButton(g)&&(this.info.x=g.clientX,this.info.y=g.clientY)},click(g){hasLeftMouseButton(g)&&trackForward(this.info,g)},touchstart(g){const d=g.changedTouches[0];this.info.x=d.clientX,this.info.y=d.clientY},touchend(g){trackForward(this.info,g.changedTouches[0],g)}});function trackForward(g,d,a){const p=Math.abs(d.clientX-g.x),v=Math.abs(d.clientY-g.y),C=_findOriginalTarget(a||d);!C||canBeDisabled[C.localName]&&C.hasAttribute("disabled")||(isNaN(p)||isNaN(v)||p<=TAP_DISTANCE&&v<=TAP_DISTANCE||isSyntheticClick(d))&&(g.prevent||_fire(C,"tap",{x:d.clientX,y:d.clientY,sourceEvent:d,preventer:a}))}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DisabledMixin=dedupeMixin(g=>class extends g{static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0,sync:!0}}}_disabledChanged(a){this._setAriaDisabled(a)}_setAriaDisabled(a){a?this.setAttribute("aria-disabled","true"):this.removeAttribute("aria-disabled")}click(){this.disabled||super.click()}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardMixin=dedupeMixin(g=>class extends g{ready(){super.ready(),this.addEventListener("keydown",a=>{this._onKeyDown(a)}),this.addEventListener("keyup",a=>{this._onKeyUp(a)})}_onKeyDown(a){switch(a.key){case"Enter":this._onEnter(a);break;case"Escape":this._onEscape(a);break}}_onKeyUp(a){}_onEnter(a){}_onEscape(a){}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ActiveMixin=g=>class extends DisabledMixin(KeyboardMixin(g)){get _activeKeys(){return[" "]}ready(){super.ready(),addListener(this,"down",a=>{this._shouldSetActive(a)&&this._setActive(!0)}),addListener(this,"up",()=>{this._setActive(!1)})}disconnectedCallback(){super.disconnectedCallback(),this._setActive(!1)}_shouldSetActive(a){return!this.disabled}_onKeyDown(a){super._onKeyDown(a),this._shouldSetActive(a)&&this._activeKeys.includes(a.key)&&(this._setActive(!0),document.addEventListener("keyup",p=>{this._activeKeys.includes(p.key)&&this._setActive(!1)},{once:!0}))}_setActive(a){this.toggleAttribute("active",a)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionHeading=i`
  :host {
    display: block;
    outline: none;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-heading",accordionHeading,{moduleId:"vaadin-accordion-heading-styles"});class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-accordion-heading"}static get template(){return html$3`
      <button id="button" part="content" disabled$="[[disabled]]" aria-expanded$="[[__updateAriaExpanded(opened)]]">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0,value:!1}}}_attachDom(d){const a=this.attachShadow({mode:"open",delegatesFocus:!0});return a.appendChild(d),a}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","heading")}__updateAriaExpanded(d){return d?"true":"false"}}defineCustomElement(AccordionHeading);const details=i`
  :host {
    margin: var(--lumo-space-xs) 0;
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focus-ring]) ::slotted([slot='summary']) {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) 0 var(--lumo-space-s);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
  }

  :host([theme~='filled']) {
    background-color: var(--lumo-contrast-5pct);
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='filled']) [part='content'] {
    padding-left: var(--lumo-space-m);
    padding-right: var(--lumo-space-m);
  }

  :host([theme~='small']) [part$='content'] {
    font-size: var(--lumo-font-size-s);
  }
`;registerStyles$1("vaadin-details",details,{moduleId:"lumo-details"});const accordionPanel$1=i`
  :host {
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
`;registerStyles$1("vaadin-accordion-panel",[details,accordionPanel$1],{moduleId:"lumo-accordion-panel"});/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionPanel=i`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: none;
    overflow: hidden;
  }

  :host([opened]) [part='content'] {
    display: block;
    overflow: visible;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FocusMixin=dedupeMixin(g=>class extends g{get _keyboardActive(){return isKeyboardActive()}ready(){this.addEventListener("focusin",a=>{this._shouldSetFocus(a)&&this._setFocused(!0)}),this.addEventListener("focusout",a=>{this._shouldRemoveFocus(a)&&this._setFocused(!1)}),super.ready()}disconnectedCallback(){super.disconnectedCallback(),this.hasAttribute("focused")&&this._setFocused(!1)}focus(a){super.focus(a),a&&a.focusVisible===!1||this.setAttribute("focus-ring","")}_setFocused(a){this.toggleAttribute("focused",a),this.toggleAttribute("focus-ring",a&&this._keyboardActive)}_shouldSetFocus(a){return!0}_shouldRemoveFocus(a){return!0}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const TabindexMixin=g=>class extends DisabledMixin(g){static get properties(){return{tabindex:{type:Number,reflectToAttribute:!0,observer:"_tabindexChanged",sync:!0},_lastTabIndex:{type:Number}}}_disabledChanged(a,p){super._disabledChanged(a,p),!this.__shouldAllowFocusWhenDisabled()&&(a?(this.tabindex!==void 0&&(this._lastTabIndex=this.tabindex),this.setAttribute("tabindex","-1")):p&&(this._lastTabIndex!==void 0?this.setAttribute("tabindex",this._lastTabIndex):this.tabindex=void 0))}_tabindexChanged(a){this.__shouldAllowFocusWhenDisabled()||this.disabled&&a!==-1&&(this._lastTabIndex=a,this.setAttribute("tabindex","-1"))}focus(a){(!this.disabled||this.__shouldAllowFocusWhenDisabled())&&super.focus(a)}__shouldAllowFocusWhenDisabled(){return!1}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateFocusMixin=dedupeMixin(g=>class extends FocusMixin(TabindexMixin(g)){static get properties(){return{autofocus:{type:Boolean},focusElement:{type:Object,readOnly:!0,observer:"_focusElementChanged",sync:!0},_lastTabIndex:{value:0}}}constructor(){super(),this._boundOnBlur=this._onBlur.bind(this),this._boundOnFocus=this._onFocus.bind(this)}ready(){super.ready(),this.autofocus&&!this.disabled&&requestAnimationFrame(()=>{this.focus()})}focus(a){this.focusElement&&!this.disabled&&(this.focusElement.focus(),a&&a.focusVisible===!1||this.setAttribute("focus-ring",""))}blur(){this.focusElement&&this.focusElement.blur()}click(){this.focusElement&&!this.disabled&&this.focusElement.click()}_focusElementChanged(a,p){a?(a.disabled=this.disabled,this._addFocusListeners(a),this.__forwardTabIndex(this.tabindex)):p&&this._removeFocusListeners(p)}_addFocusListeners(a){a.addEventListener("blur",this._boundOnBlur),a.addEventListener("focus",this._boundOnFocus)}_removeFocusListeners(a){a.removeEventListener("blur",this._boundOnBlur),a.removeEventListener("focus",this._boundOnFocus)}_onFocus(a){a.stopPropagation(),this.dispatchEvent(new Event("focus"))}_onBlur(a){a.stopPropagation(),this.dispatchEvent(new Event("blur"))}_shouldSetFocus(a){return a.target===this.focusElement}_shouldRemoveFocus(a){return a.target===this.focusElement}_disabledChanged(a,p){super._disabledChanged(a,p),this.focusElement&&(this.focusElement.disabled=a),a&&this.blur()}_tabindexChanged(a){this.__forwardTabIndex(a)}__forwardTabIndex(a){a!==void 0&&this.focusElement&&(this.focusElement.tabIndex=a,a!==-1&&(this.tabindex=void 0)),this.disabled&&a&&(a!==-1&&(this._lastTabIndex=a),this.tabindex=void 0),a===void 0&&this.hasAttribute("tabindex")&&this.removeAttribute("tabindex")}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateStateMixin=dedupeMixin(g=>class extends g{static get properties(){return{stateTarget:{type:Object,observer:"_stateTargetChanged"}}}static get delegateAttrs(){return[]}static get delegateProps(){return[]}ready(){super.ready(),this._createDelegateAttrsObserver(),this._createDelegatePropsObserver()}_stateTargetChanged(a){a&&(this._ensureAttrsDelegated(),this._ensurePropsDelegated())}_createDelegateAttrsObserver(){this._createMethodObserver(`_delegateAttrsChanged(${this.constructor.delegateAttrs.join(", ")})`)}_createDelegatePropsObserver(){this._createMethodObserver(`_delegatePropsChanged(${this.constructor.delegateProps.join(", ")})`)}_ensureAttrsDelegated(){this.constructor.delegateAttrs.forEach(a=>{this._delegateAttribute(a,this[a])})}_ensurePropsDelegated(){this.constructor.delegateProps.forEach(a=>{this._delegateProperty(a,this[a])})}_delegateAttrsChanged(...a){this.constructor.delegateAttrs.forEach((p,v)=>{this._delegateAttribute(p,a[v])})}_delegatePropsChanged(...a){this.constructor.delegateProps.forEach((p,v)=>{this._delegateProperty(p,a[v])})}_delegateAttribute(a,p){this.stateTarget&&(a==="invalid"&&this._delegateAttribute("aria-invalid",p?"true":!1),typeof p=="boolean"?this.stateTarget.toggleAttribute(a,p):p?this.stateTarget.setAttribute(a,p):this.stateTarget.removeAttribute(a))}_delegateProperty(a,p){this.stateTarget&&(this.stateTarget[a]=p)}});/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotObserver{constructor(d,a){this.slot=d,this.callback=a,this._storedNodes=[],this._connected=!1,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){this.slot.addEventListener("slotchange",this._boundSchedule),this._connected=!0}disconnect(){this.slot.removeEventListener("slotchange",this._boundSchedule),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,queueMicrotask(()=>{this.flush()}))}flush(){this._connected&&(this._scheduled=!1,this._processNodes())}_processNodes(){const d=this.slot.assignedNodes({flatten:!0});let a=[];const p=[],v=[];d.length&&(a=d.filter(C=>!this._storedNodes.includes(C))),this._storedNodes.length&&this._storedNodes.forEach((C,P)=>{const k=d.indexOf(C);k===-1?p.push(C):k!==P&&v.push(C)}),(a.length||p.length||v.length)&&this.callback({addedNodes:a,currentNodes:d,movedNodes:v,removedNodes:p}),this._storedNodes=d}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let uniqueId=0;function generateUniqueId(){return uniqueId++}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotController extends EventTarget{static generateId(d,a="default"){return`${a}-${d.localName}-${generateUniqueId()}`}constructor(d,a,p,v={}){super();const{initializer:C,multiple:P,observe:k,useUniqueId:z,uniqueIdPrefix:$}=v;this.host=d,this.slotName=a,this.tagName=p,this.observe=typeof k=="boolean"?k:!0,this.multiple=typeof P=="boolean"?P:!1,this.slotInitializer=C,P&&(this.nodes=[]),z&&(this.defaultId=this.constructor.generateId(d,$||a))}hostConnected(){this.initialized||(this.multiple?this.initMultiple():this.initSingle(),this.observe&&this.observeSlot(),this.initialized=!0)}initSingle(){let d=this.getSlotChild();d?(this.node=d,this.initAddedNode(d)):(d=this.attachDefaultNode(),this.initNode(d))}initMultiple(){const d=this.getSlotChildren();if(d.length===0){const a=this.attachDefaultNode();a&&(this.nodes=[a],this.initNode(a))}else this.nodes=d,d.forEach(a=>{this.initAddedNode(a)})}attachDefaultNode(){const{host:d,slotName:a,tagName:p}=this;let v=this.defaultNode;return!v&&p&&(v=document.createElement(p),v instanceof Element&&(a!==""&&v.setAttribute("slot",a),this.defaultNode=v)),v&&(this.node=v,d.appendChild(v)),v}getSlotChildren(){const{slotName:d}=this;return Array.from(this.host.childNodes).filter(a=>a.nodeType===Node.ELEMENT_NODE&&a.hasAttribute("data-slot-ignore")?!1:a.nodeType===Node.ELEMENT_NODE&&a.slot===d||a.nodeType===Node.TEXT_NODE&&a.textContent.trim()&&d==="")}getSlotChild(){return this.getSlotChildren()[0]}initNode(d){const{slotInitializer:a}=this;a&&a(d,this.host)}initCustomNode(d){}teardownNode(d){}initAddedNode(d){d!==this.defaultNode&&(this.initCustomNode(d),this.initNode(d))}observeSlot(){const{slotName:d}=this,a=d===""?"slot:not([name])":`slot[name=${d}]`,p=this.host.shadowRoot.querySelector(a);this.__slotObserver=new SlotObserver(p,({addedNodes:v,removedNodes:C})=>{const P=this.multiple?this.nodes:[this.node],k=v.filter(z=>!isEmptyTextNode(z)&&!P.includes(z)&&!(z.nodeType===Node.ELEMENT_NODE&&z.hasAttribute("data-slot-ignore")));C.length&&(this.nodes=P.filter(z=>!C.includes(z)),C.forEach(z=>{this.teardownNode(z)})),k&&k.length>0&&(this.multiple?(this.defaultNode&&this.defaultNode.remove(),this.nodes=[...P,...k].filter(z=>z!==this.defaultNode),k.forEach(z=>{this.initAddedNode(z)})):(this.node&&this.node.remove(),this.node=k[0],this.initAddedNode(this.node)))})}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipController extends SlotController{constructor(d){super(d,"tooltip"),this.setTarget(d),this.__onContentChange=this.__onContentChange.bind(this)}initCustomNode(d){d.target=this.target,this.ariaTarget!==void 0&&(d.ariaTarget=this.ariaTarget),this.context!==void 0&&(d.context=this.context),this.manual!==void 0&&(d.manual=this.manual),this.opened!==void 0&&(d.opened=this.opened),this.position!==void 0&&(d._position=this.position),this.shouldShow!==void 0&&(d.shouldShow=this.shouldShow),this.manual||this.host.setAttribute("has-tooltip",""),this.__notifyChange(d),d.addEventListener("content-changed",this.__onContentChange)}teardownNode(d){this.manual||this.host.removeAttribute("has-tooltip"),d.removeEventListener("content-changed",this.__onContentChange),this.__notifyChange(null)}setAriaTarget(d){this.ariaTarget=d;const a=this.node;a&&(a.ariaTarget=d)}setContext(d){this.context=d;const a=this.node;a&&(a.context=d)}setManual(d){this.manual=d;const a=this.node;a&&(a.manual=d)}setOpened(d){this.opened=d;const a=this.node;a&&(a.opened=d)}setPosition(d){this.position=d;const a=this.node;a&&(a._position=d)}setShouldShow(d){this.shouldShow=d;const a=this.node;a&&(a.shouldShow=d)}setTarget(d){this.target=d;const a=this.node;a&&(a.target=d)}__onContentChange(d){this.__notifyChange(d.target)}__notifyChange(d){this.dispatchEvent(new CustomEvent("tooltip-changed",{detail:{node:d}}))}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotChildObserveController extends SlotController{constructor(d,a,p,v={}){super(d,a,p,{...v,useUniqueId:!0})}initCustomNode(d){this.__updateNodeId(d),this.__notifyChange(d)}teardownNode(d){const a=this.getSlotChild();a&&a!==this.defaultNode?this.__notifyChange(a):(this.restoreDefaultNode(),this.updateDefaultNode(this.node))}attachDefaultNode(){const d=super.attachDefaultNode();return d&&this.__updateNodeId(d),d}restoreDefaultNode(){}updateDefaultNode(d){this.__notifyChange(d)}observeNode(d){this.__nodeObserver&&this.__nodeObserver.disconnect(),this.__nodeObserver=new MutationObserver(a=>{a.forEach(p=>{const v=p.target,C=v===this.node;p.type==="attributes"?C&&this.__updateNodeId(v):(C||v.parentElement===this.node)&&this.__notifyChange(this.node)})}),this.__nodeObserver.observe(d,{attributes:!0,attributeFilter:["id"],childList:!0,subtree:!0,characterData:!0})}__hasContent(d){return d?d.nodeType===Node.ELEMENT_NODE&&(customElements.get(d.localName)||d.children.length>0)||d.textContent&&d.textContent.trim()!=="":!1}__notifyChange(d){this.dispatchEvent(new CustomEvent("slot-content-changed",{detail:{hasContent:this.__hasContent(d),node:d}}))}__updateNodeId(d){const a=!this.nodes||d===this.nodes[0];d.nodeType===Node.ELEMENT_NODE&&(!this.multiple||a)&&!d.id&&(d.id=this.defaultId)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ContentController extends SlotChildObserveController{static generateId(d){return super.generateId(d,"content")}constructor(d){super(d,"",null,{multiple:!0})}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CollapsibleMixin=g=>class extends g{static get properties(){return{opened:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0},_contentElements:{type:Array}}}static get observers(){return["_openedOrContentChanged(opened, _contentElements)"]}constructor(){super(),this._contentController=new ContentController(this),this._contentController.addEventListener("slot-content-changed",a=>{const p=a.target.nodes||[];this._contentElements=p.filter(v=>v.parentNode===this)})}ready(){super.ready(),this.addController(this._contentController),this.addEventListener("click",({target:a})=>{if(this.disabled||a.localName==="a")return;const p=this.focusElement;p&&(a===p||p.contains(a))&&(this.opened=!this.opened)})}_openedOrContentChanged(a,p){p&&p.forEach(v=>{v.setAttribute("aria-hidden",a?"false":"true")})}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SummaryController extends SlotChildObserveController{constructor(d,a){super(d,"summary",a)}setSummary(d){this.summary=d,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{summary:d}=this;d&&d.trim()!==""&&this.attachDefaultNode()}updateDefaultNode(d){d&&(d.textContent=this.summary),super.updateDefaultNode(d)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionPanelMixin=g=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(g))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaAttributes(focusElement, _contentElements)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-accordion-heading"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:p}=a.target;this._setFocusElement(p),this.stateTarget=p,this._tooltipController.setTarget(p)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}__forwardTabIndex(a){super.__forwardTabIndex(a),a!==void 0&&this.focusElement&&(this.focusElement.$.button.tabIndex=a,this.focusElement.tabIndex=-1)}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,p){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",p);return}super._delegateProperty(a,p)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaAttributes(a,p){if(a&&p){const v=p[0];v&&(v.setAttribute("role","region"),v.setAttribute("aria-labelledby",a.id)),v&&v.id?a.setAttribute("aria-controls",v.id):a.removeAttribute("aria-controls")}}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-panel",accordionPanel,{moduleId:"vaadin-accordion-panel-styles"});class AccordionPanel extends AccordionPanelMixin(ThemableMixin(ControllerMixin(PolymerElement))){static get is(){return"vaadin-accordion-panel"}static get template(){return html$3`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}}defineCustomElement(AccordionPanel);const DEV_MODE_CODE_REGEXP=/\/\*[\*!]\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,FlowClients=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function isMinified(){function g(){return!0}return uncommentAndRun(g)}function isDevelopmentMode(){try{return isForcedDevelopmentMode()?!0:isLocalhost()?FlowClients?!isFlowProductionMode():!isMinified():!1}catch{return!1}}function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}function isFlowProductionMode(){return!!(FlowClients&&Object.keys(FlowClients).map(d=>FlowClients[d]).filter(d=>d.productionMode).length>0)}function uncommentAndRun(g,d){if(typeof g!="function")return;const a=DEV_MODE_CODE_REGEXP.exec(g.toString());if(a)try{g=new Function(a[1])}catch(p){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",p)}return g(d)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(g,d){if(window.Vaadin.developmentMode)return uncommentAndRun(g,d)};window.Vaadin.developmentMode===void 0&&(window.Vaadin.developmentMode=isDevelopmentMode());function maybeGatherAndSendStats(){/*! vaadin-dev-mode:start
  (function () {
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

var getPolymerVersion = function getPolymerVersion() {
  return window.Polymer && window.Polymer.version;
};

var StatisticsGatherer = function () {
  function StatisticsGatherer(logger) {
    classCallCheck(this, StatisticsGatherer);

    this.now = new Date().getTime();
    this.logger = logger;
  }

  createClass(StatisticsGatherer, [{
    key: 'frameworkVersionDetectors',
    value: function frameworkVersionDetectors() {
      return {
        'Flow': function Flow() {
          if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {
            var flowVersions = Object.keys(window.Vaadin.Flow.clients).map(function (key) {
              return window.Vaadin.Flow.clients[key];
            }).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().flow;
            });
            if (flowVersions.length > 0) {
              return flowVersions[0];
            }
          }
        },
        'Vaadin Framework': function VaadinFramework() {
          if (window.vaadin && window.vaadin.clients) {
            var frameworkVersions = Object.values(window.vaadin.clients).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().vaadinVersion;
            });
            if (frameworkVersions.length > 0) {
              return frameworkVersions[0];
            }
          }
        },
        'AngularJs': function AngularJs() {
          if (window.angular && window.angular.version && window.angular.version) {
            return window.angular.version.full;
          }
        },
        'Angular': function Angular() {
          if (window.ng) {
            var tags = document.querySelectorAll("[ng-version]");
            if (tags.length > 0) {
              return tags[0].getAttribute("ng-version");
            }
            return "Unknown";
          }
        },
        'Backbone.js': function BackboneJs() {
          if (window.Backbone) {
            return window.Backbone.VERSION;
          }
        },
        'React': function React() {
          var reactSelector = '[data-reactroot], [data-reactid]';
          if (!!document.querySelector(reactSelector)) {
            // React does not publish the version by default
            return "unknown";
          }
        },
        'Ember': function Ember() {
          if (window.Em && window.Em.VERSION) {
            return window.Em.VERSION;
          } else if (window.Ember && window.Ember.VERSION) {
            return window.Ember.VERSION;
          }
        },
        'jQuery': function (_jQuery) {
          function jQuery() {
            return _jQuery.apply(this, arguments);
          }

          jQuery.toString = function () {
            return _jQuery.toString();
          };

          return jQuery;
        }(function () {
          if (typeof jQuery === 'function' && jQuery.prototype.jquery !== undefined) {
            return jQuery.prototype.jquery;
          }
        }),
        'Polymer': function Polymer() {
          var version = getPolymerVersion();
          if (version) {
            return version;
          }
        },
        'LitElement': function LitElement() {
          var version = window.litElementVersions && window.litElementVersions[0];
          if (version) {
            return version;
          }
        },
        'LitHtml': function LitHtml() {
          var version = window.litHtmlVersions && window.litHtmlVersions[0];
          if (version) {
            return version;
          }
        },
        'Vue.js': function VueJs() {
          if (window.Vue) {
            return window.Vue.version;
          }
        }
      };
    }
  }, {
    key: 'getUsedVaadinElements',
    value: function getUsedVaadinElements(elements) {
      var version = getPolymerVersion();
      var elementClasses = void 0;
      // NOTE: In case you edit the code here, YOU MUST UPDATE any statistics reporting code in Flow.
      // Check all locations calling the method getEntries() in
      // https://github.com/vaadin/flow/blob/master/flow-server/src/main/java/com/vaadin/flow/internal/UsageStatistics.java#L106
      // Currently it is only used by BootstrapHandler.
      if (version && version.indexOf('2') === 0) {
        // Polymer 2: components classes are stored in window.Vaadin
        elementClasses = Object.keys(window.Vaadin).map(function (c) {
          return window.Vaadin[c];
        }).filter(function (c) {
          return c.is;
        });
      } else {
        // Polymer 3: components classes are stored in window.Vaadin.registrations
        elementClasses = window.Vaadin.registrations || [];
      }
      elementClasses.forEach(function (klass) {
        var version = klass.version ? klass.version : "0.0.0";
        elements[klass.is] = { version: version };
      });
    }
  }, {
    key: 'getUsedVaadinThemes',
    value: function getUsedVaadinThemes(themes) {
      ['Lumo', 'Material'].forEach(function (themeName) {
        var theme;
        var version = getPolymerVersion();
        if (version && version.indexOf('2') === 0) {
          // Polymer 2: themes are stored in window.Vaadin
          theme = window.Vaadin[themeName];
        } else {
          // Polymer 3: themes are stored in custom element registry
          theme = customElements.get('vaadin-' + themeName.toLowerCase() + '-styles');
        }
        if (theme && theme.version) {
          themes[themeName] = { version: theme.version };
        }
      });
    }
  }, {
    key: 'getFrameworks',
    value: function getFrameworks(frameworks) {
      var detectors = this.frameworkVersionDetectors();
      Object.keys(detectors).forEach(function (framework) {
        var detector = detectors[framework];
        try {
          var version = detector();
          if (version) {
            frameworks[framework] = { version: version };
          }
        } catch (e) {}
      });
    }
  }, {
    key: 'gather',
    value: function gather(storage) {
      var storedStats = storage.read();
      var gatheredStats = {};
      var types = ["elements", "frameworks", "themes"];

      types.forEach(function (type) {
        gatheredStats[type] = {};
        if (!storedStats[type]) {
          storedStats[type] = {};
        }
      });

      var previousStats = JSON.stringify(storedStats);

      this.getUsedVaadinElements(gatheredStats.elements);
      this.getFrameworks(gatheredStats.frameworks);
      this.getUsedVaadinThemes(gatheredStats.themes);

      var now = this.now;
      types.forEach(function (type) {
        var keys = Object.keys(gatheredStats[type]);
        keys.forEach(function (key) {
          if (!storedStats[type][key] || _typeof(storedStats[type][key]) != _typeof({})) {
            storedStats[type][key] = { firstUsed: now };
          }
          // Discards any previously logged version number
          storedStats[type][key].version = gatheredStats[type][key].version;
          storedStats[type][key].lastUsed = now;
        });
      });

      var newStats = JSON.stringify(storedStats);
      storage.write(newStats);
      if (newStats != previousStats && Object.keys(storedStats).length > 0) {
        this.logger.debug("New stats: " + newStats);
      }
    }
  }]);
  return StatisticsGatherer;
}();

var StatisticsStorage = function () {
  function StatisticsStorage(key) {
    classCallCheck(this, StatisticsStorage);

    this.key = key;
  }

  createClass(StatisticsStorage, [{
    key: 'read',
    value: function read() {
      var localStorageStatsString = localStorage.getItem(this.key);
      try {
        return JSON.parse(localStorageStatsString ? localStorageStatsString : '{}');
      } catch (e) {
        return {};
      }
    }
  }, {
    key: 'write',
    value: function write(data) {
      localStorage.setItem(this.key, data);
    }
  }, {
    key: 'clear',
    value: function clear() {
      localStorage.removeItem(this.key);
    }
  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      var storedStats = this.read();
      var empty = true;
      Object.keys(storedStats).forEach(function (key) {
        if (Object.keys(storedStats[key]).length > 0) {
          empty = false;
        }
      });

      return empty;
    }
  }]);
  return StatisticsStorage;
}();

var StatisticsSender = function () {
  function StatisticsSender(url, logger) {
    classCallCheck(this, StatisticsSender);

    this.url = url;
    this.logger = logger;
  }

  createClass(StatisticsSender, [{
    key: 'send',
    value: function send(data, errorHandler) {
      var logger = this.logger;

      if (navigator.onLine === false) {
        logger.debug("Offline, can't send");
        errorHandler();
        return;
      }
      logger.debug("Sending data to " + this.url);

      var req = new XMLHttpRequest();
      req.withCredentials = true;
      req.addEventListener("load", function () {
        // Stats sent, nothing more to do
        logger.debug("Response: " + req.responseText);
      });
      req.addEventListener("error", function () {
        logger.debug("Send failed");
        errorHandler();
      });
      req.addEventListener("abort", function () {
        logger.debug("Send aborted");
        errorHandler();
      });
      req.open("POST", this.url);
      req.setRequestHeader("Content-Type", "application/json");
      req.send(data);
    }
  }]);
  return StatisticsSender;
}();

var StatisticsLogger = function () {
  function StatisticsLogger(id) {
    classCallCheck(this, StatisticsLogger);

    this.id = id;
  }

  createClass(StatisticsLogger, [{
    key: '_isDebug',
    value: function _isDebug() {
      return localStorage.getItem("vaadin." + this.id + ".debug");
    }
  }, {
    key: 'debug',
    value: function debug(msg) {
      if (this._isDebug()) {
        console.info(this.id + ": " + msg);
      }
    }
  }]);
  return StatisticsLogger;
}();

var UsageStatistics = function () {
  function UsageStatistics() {
    classCallCheck(this, UsageStatistics);

    this.now = new Date();
    this.timeNow = this.now.getTime();
    this.gatherDelay = 10; // Delay between loading this file and gathering stats
    this.initialDelay = 24 * 60 * 60;

    this.logger = new StatisticsLogger("statistics");
    this.storage = new StatisticsStorage("vaadin.statistics.basket");
    this.gatherer = new StatisticsGatherer(this.logger);
    this.sender = new StatisticsSender("https://tools.vaadin.com/usage-stats/submit", this.logger);
  }

  createClass(UsageStatistics, [{
    key: 'maybeGatherAndSend',
    value: function maybeGatherAndSend() {
      var _this = this;

      if (localStorage.getItem(UsageStatistics.optOutKey)) {
        return;
      }
      this.gatherer.gather(this.storage);
      setTimeout(function () {
        _this.maybeSend();
      }, this.gatherDelay * 1000);
    }
  }, {
    key: 'lottery',
    value: function lottery() {
      return true;
    }
  }, {
    key: 'currentMonth',
    value: function currentMonth() {
      return this.now.getYear() * 12 + this.now.getMonth();
    }
  }, {
    key: 'maybeSend',
    value: function maybeSend() {
      var firstUse = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      var monthProcessed = Number(localStorage.getItem(UsageStatistics.monthProcessedKey));

      if (!firstUse) {
        // Use a grace period to avoid interfering with tests, incognito mode etc
        firstUse = this.timeNow;
        localStorage.setItem(UsageStatistics.firstUseKey, firstUse);
      }

      if (this.timeNow < firstUse + this.initialDelay * 1000) {
        this.logger.debug("No statistics will be sent until the initial delay of " + this.initialDelay + "s has passed");
        return;
      }
      if (this.currentMonth() <= monthProcessed) {
        this.logger.debug("This month has already been processed");
        return;
      }
      localStorage.setItem(UsageStatistics.monthProcessedKey, this.currentMonth());
      // Use random sampling
      if (this.lottery()) {
        this.logger.debug("Congratulations, we have a winner!");
      } else {
        this.logger.debug("Sorry, no stats from you this time");
        return;
      }

      this.send();
    }
  }, {
    key: 'send',
    value: function send() {
      // Ensure we have the latest data
      this.gatherer.gather(this.storage);

      // Read, send and clean up
      var data = this.storage.read();
      data["firstUse"] = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      data["usageStatisticsVersion"] = UsageStatistics.version;
      var info = 'This request contains usage statistics gathered from the application running in development mode. \n\nStatistics gathering is automatically disabled and excluded from production builds.\n\nFor details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.\n\n\n\n';
      var self = this;
      this.sender.send(info + JSON.stringify(data), function () {
        // Revert the 'month processed' flag
        localStorage.setItem(UsageStatistics.monthProcessedKey, self.currentMonth() - 1);
      });
    }
  }], [{
    key: 'version',
    get: function get$1() {
      return '2.1.2';
    }
  }, {
    key: 'firstUseKey',
    get: function get$1() {
      return 'vaadin.statistics.firstuse';
    }
  }, {
    key: 'monthProcessedKey',
    get: function get$1() {
      return 'vaadin.statistics.monthProcessed';
    }
  }, {
    key: 'optOutKey',
    get: function get$1() {
      return 'vaadin.statistics.optout';
    }
  }]);
  return UsageStatistics;
}();

try {
  window.Vaadin = window.Vaadin || {};
  window.Vaadin.usageStatsChecker = window.Vaadin.usageStatsChecker || new UsageStatistics();
  window.Vaadin.usageStatsChecker.maybeGatherAndSend();
} catch (e) {
  // Intentionally ignored as this is not a problem in the app being developed
}

}());

  vaadin-dev-mode:end **/}const usageStatistics=function(){if(typeof runIfDevelopmentMode=="function")return runIfDevelopmentMode(maybeGatherAndSendStats)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */window.Vaadin||(window.Vaadin={});window.Vaadin.registrations||(window.Vaadin.registrations=[]);window.Vaadin.developmentModeCallback||(window.Vaadin.developmentModeCallback={});window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]=function(){usageStatistics()};let statsJob;const registered=new Set,ElementMixin=g=>class extends DirMixin(g){static finalize(){super.finalize();const{is:a}=this;a&&!registered.has(a)&&(window.Vaadin.registrations.push(this),registered.add(a),window.Vaadin.developmentModeCallback&&(statsJob=Debouncer$1.debounce(statsJob,idlePeriod$1,()=>{window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]()}),enqueueDebouncer$1(statsJob)))}constructor(){super(),document.doctype===null&&console.warn('Vaadin components require the "standards mode" declaration. Please add <!DOCTYPE html> to the HTML document.')}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardDirectionMixin=g=>class extends KeyboardMixin(g){get focused(){return(this._getItems()||[]).find(isElementFocused)}get _vertical(){return!0}get _tabNavigation(){return!1}focus(a){const p=this._getFocusableIndex();p>=0&&this._focus(p,a)}_getFocusableIndex(){const a=this._getItems();return Array.isArray(a)?this._getAvailableIndex(a,0,null,p=>!isElementHidden(p)):-1}_getItems(){return Array.from(this.children)}_onKeyDown(a){if(super._onKeyDown(a),a.metaKey||a.ctrlKey)return;const{key:p,shiftKey:v}=a,C=this._getItems()||[],P=C.indexOf(this.focused);let k,z;const D=!this._vertical&&this.getAttribute("dir")==="rtl"?-1:1;this.__isPrevKeyPressed(p,v)?(z=-D,k=P-D):this.__isNextKeyPressed(p,v)?(z=D,k=P+D):p==="Home"?(z=1,k=0):p==="End"&&(z=-1,k=C.length-1),k=this._getAvailableIndex(C,k,z,F=>!isElementHidden(F)),!(this._tabNavigation&&p==="Tab"&&(k>P&&a.shiftKey||k<P&&!a.shiftKey||k===P))&&k>=0&&(a.preventDefault(),this._focus(k,{focusVisible:!0},!0))}__isPrevKeyPressed(a,p){return this._vertical?a==="ArrowUp":a==="ArrowLeft"||this._tabNavigation&&a==="Tab"&&p}__isNextKeyPressed(a,p){return this._vertical?a==="ArrowDown":a==="ArrowRight"||this._tabNavigation&&a==="Tab"&&!p}_focus(a,p,v=!1){const C=this._getItems();this._focusItem(C[a],p,v)}_focusItem(a,p){a&&a.focus(p)}_getAvailableIndex(a,p,v,C){const P=a.length;let k=p;for(let z=0;typeof k=="number"&&z<P;z+=1,k+=v||1){k<0?k=P-1:k>=P&&(k=0);const $=a[k];if(this._isItemFocusable($)&&this.__isMatchingItem($,C))return k}return-1}__isMatchingItem(a,p){return typeof p=="function"?p(a):!0}_isItemFocusable(a){return!a.hasAttribute("disabled")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionMixin=g=>class extends KeyboardDirectionMixin(g){static get properties(){return{opened:{type:Number,value:0,notify:!0,reflectToAttribute:!0},items:{type:Array,readOnly:!0,notify:!0}}}static get observers(){return["_updateItems(items, opened)"]}constructor(){super(),this._boundUpdateOpened=this._updateOpened.bind(this)}get focused(){return(this._getItems()||[]).find(a=>isElementFocused(a.focusElement))}focus(a){this._observer&&this._observer.flush(),super.focus(a)}ready(){super.ready();const a=this.shadowRoot.querySelector("slot");this._observer=new SlotObserver(a,p=>{this._setItems(this._filterItems(Array.from(this.children))),this._filterItems(p.addedNodes).forEach(v=>{v.addEventListener("opened-changed",this._boundUpdateOpened)})})}_getItems(){return this.items}_filterItems(a){return a.filter(p=>p instanceof customElements.get("vaadin-accordion-panel"))}_updateItems(a,p){if(a){this.__itemsSync=!0;const v=a[p];a.forEach(C=>{C.opened=C===v}),this.__itemsSync=!1}}_onKeyDown(a){this.items.some(p=>p.focusElement===a.target)&&super._onKeyDown(a)}_updateOpened(a){if(this.__itemsSync)return;const p=this._filterItems(a.composedPath())[0],v=this.items.indexOf(p);if(a.detail.value){if(p.disabled||v===-1)return;this.opened=v}else this.items.some(C=>C.opened)||(this.opened=null)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolymerElement))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-accordion"}}defineCustomElement(Accordion);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const INTERACTION_EVENTS=["mousedown","mouseup","click","dblclick","keypress","keydown","keyup"],ButtonMixin=g=>class extends ActiveMixin(TabindexMixin(FocusMixin(g))){constructor(){super(),this.__onInteractionEvent=this.__onInteractionEvent.bind(this),INTERACTION_EVENTS.forEach(a=>{this.addEventListener(a,this.__onInteractionEvent,!0)}),this.tabindex=0}get _activeKeys(){return["Enter"," "]}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","button"),this.__shouldAllowFocusWhenDisabled()&&this.style.setProperty("--_vaadin-button-disabled-pointer-events","auto")}_onKeyDown(a){super._onKeyDown(a),!(a.altKey||a.shiftKey||a.ctrlKey||a.metaKey)&&this._activeKeys.includes(a.key)&&(a.preventDefault(),this.click())}__onInteractionEvent(a){this.__shouldSuppressInteractionEvent(a)&&a.stopImmediatePropagation()}__shouldSuppressInteractionEvent(a){return this.disabled}};/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const detailsSummary=()=>i`
  :host {
    display: block;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-details-summary",detailsSummary(),{moduleId:"vaadin-details-summary-styles"});class DetailsSummary extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-details-summary"}static get template(){return html$3`
      <span part="toggle" aria-hidden="true"></span>
      <div part="content"><slot></slot></div>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0}}}}defineCustomElement(DetailsSummary);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DetailsBaseMixin=g=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(g))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaControls(focusElement, _contentElements)","__updateAriaExpanded(focusElement, opened)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-details-summary"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:p}=a.target;this._setFocusElement(p),this.stateTarget=p,this._tooltipController.setTarget(p)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,p){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",p);return}super._delegateProperty(a,p)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaControls(a,p){if(a&&p){const v=p[0];v&&v.id?a.setAttribute("aria-controls",v.id):a.removeAttribute("aria-controls")}}__updateAriaExpanded(a,p){a&&a.setAttribute("aria-expanded",p?"true":"false")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Details extends DetailsBaseMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='content'] {
          display: none;
        }

        :host([opened]) [part='content'] {
          display: block;
        }
      </style>

      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-details"}}defineCustomElement(Details);registerStyles$1("vaadin-app-layout",i`
    [part='navbar'],
    [part='drawer'] {
      background-color: var(--lumo-base-color);
      background-clip: padding-box;
    }

    [part='navbar'] {
      min-height: var(--lumo-size-xl);
      border-bottom: 1px solid var(--lumo-contrast-10pct);
    }

    [part='navbar'][bottom] {
      border-bottom: none;
      border-top: 1px solid var(--lumo-contrast-10pct);
    }

    [part='drawer'] {
      border-inline-end: 1px solid var(--lumo-contrast-10pct);
    }

    :host([overlay]) [part='drawer'] {
      border-inline-end: none;
      box-shadow: var(--lumo-box-shadow-s);
    }

    :host([primary-section='navbar']) [part='navbar'] {
      border: none;
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
      background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    }

    [part='backdrop'] {
      background-color: var(--lumo-shade-20pct);
      opacity: 1;
    }

    [part] ::slotted(h2),
    [part] ::slotted(h3),
    [part] ::slotted(h4) {
      margin-top: var(--lumo-space-xs) !important;
      margin-bottom: var(--lumo-space-xs) !important;
    }
  `,{moduleId:"lumo-app-layout"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function _detectIosNavbar(){if(isIOS){const g=window.innerHeight,a=window.innerWidth>g,p=document.documentElement.clientHeight;a&&p>g?document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom",`${p-g}px`):document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom","")}}_detectIosNavbar();window.addEventListener("resize",_detectIosNavbar);const template$8=document.createElement("template");template$8.innerHTML=`
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;document.head.appendChild(template$8.content);/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function deepMerge$1(g,...d){const a=C=>Array.isArray(C),p=C=>C&&typeof C=="object"&&!a(C),v=(C,P)=>{p(P)&&p(C)&&Object.keys(P).forEach(k=>{const z=P[k];p(z)?(C[k]||(C[k]={}),v(C[k],z)):a(z)?C[k]=[...z]:z!=null&&(C[k]=z)})};return d.forEach(C=>{v(g,C)}),g}const I18nMixin=(g,d)=>class extends d{static get properties(){return{i18n:{type:Object},__effectiveI18n:{type:Object,sync:!0}}}constructor(){super(),this.i18n=deepMerge$1({},g)}get i18n(){return this.__customI18n}set i18n(p){p!==this.__customI18n&&(this.__customI18n=p,this.__effectiveI18n=deepMerge$1({},g,this.__customI18n))}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$a={drawer:"Drawer"},AppLayoutMixin=g=>class extends I18nMixin(DEFAULT_I18N$a,g){static get properties(){return{primarySection:{type:String,value:"navbar",notify:!0,reflectToAttribute:!0,observer:"__primarySectionChanged",sync:!0},drawerOpened:{type:Boolean,notify:!0,value:!0,reflectToAttribute:!0,observer:"__drawerOpenedChanged",sync:!0},overlay:{type:Boolean,notify:!0,readOnly:!0,value:!1,reflectToAttribute:!0,observer:"__overlayChanged",sync:!0},closeDrawerOn:{type:String,value:"vaadin-router-location-changed",observer:"_closeDrawerOnChanged"}}}static get observers(){return["__i18nChanged(__effectiveI18n)"]}static dispatchCloseOverlayDrawerEvent(){window.dispatchEvent(new CustomEvent("close-overlay-drawer"))}get i18n(){return super.i18n}set i18n(a){super.i18n=a}constructor(){super(),this.__boundResizeListener=this._resize.bind(this),this.__drawerToggleClickListener=this._drawerToggleClick.bind(this),this.__onDrawerKeyDown=this.__onDrawerKeyDown.bind(this),this.__closeOverlayDrawerListener=this.__closeOverlayDrawer.bind(this),this.__trapFocusInDrawer=this.__trapFocusInDrawer.bind(this),this.__releaseFocusFromDrawer=this.__releaseFocusFromDrawer.bind(this),this.__ariaModalController=new AriaModalController(this,()=>[...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')]),this.__focusTrapController=new FocusTrapController(this)}connectedCallback(){super.connectedCallback(),this._blockAnimationUntilAfterNextRender(),window.addEventListener("resize",this.__boundResizeListener),this.addEventListener("drawer-toggle-click",this.__drawerToggleClickListener),requestAnimationFrame(()=>{this._updateOffsetSize()}),this._updateTouchOptimizedMode(),this._updateDrawerSize(),this._updateOverlayMode(),this._navbarSizeObserver=new ResizeObserver(()=>{requestAnimationFrame(()=>{this.__isDrawerAnimating?this.__updateOffsetSizePending=!0:this._updateOffsetSize()})}),this._navbarSizeObserver.observe(this.$.navbarTop),this._navbarSizeObserver.observe(this.$.navbarBottom),this._navbarSizeObserver.observe(this.$.drawer),window.addEventListener("close-overlay-drawer",this.__closeOverlayDrawerListener),window.addEventListener("keydown",this.__onDrawerKeyDown)}ready(){super.ready(),this.addController(this.__focusTrapController),this.__setAriaExpanded(),this.$.drawer.addEventListener("transitionstart",()=>{this.__isDrawerAnimating=!0}),this.$.drawer.addEventListener("transitionend",()=>{this.__updateOffsetSizePending&&(this.__updateOffsetSizePending=!1,this._updateOffsetSize()),requestAnimationFrame(()=>{this.__isDrawerAnimating=!1})})}disconnectedCallback(){super.disconnectedCallback(),window.removeEventListener("resize",this.__boundResizeListener),this.removeEventListener("drawer-toggle-click",this.__drawerToggleClickListener),window.removeEventListener("close-overlay-drawer",this.__drawerToggleClickListener),window.removeEventListener("keydown",this.__onDrawerKeyDown)}__primarySectionChanged(a){["navbar","drawer"].includes(a)||(this.primarySection="navbar")}__drawerOpenedChanged(a,p){this.overlay&&(a?this.__trapFocusInDrawer():p&&this.__releaseFocusFromDrawer()),this.__setAriaExpanded()}__overlayChanged(a,p){p&&this.__restoreFocus()}__i18nChanged(){this.__updateDrawerAriaAttributes()}_drawerToggleClick(a){a.stopPropagation(),this.drawerOpened=!this.drawerOpened}__closeOverlayDrawer(){this.overlay&&(this.drawerOpened=!1)}__setAriaExpanded(){const a=this.querySelector("vaadin-drawer-toggle");a&&a.setAttribute("aria-expanded",this.drawerOpened)}_updateDrawerSize(){const a=this.querySelectorAll("[slot=drawer]").length,p=this.$.drawer;a===0?(p.setAttribute("hidden",""),this.style.setProperty("--_vaadin-app-layout-drawer-width",0)):(p.removeAttribute("hidden"),this.style.removeProperty("--_vaadin-app-layout-drawer-width")),this._updateOffsetSize()}_resize(){this._blockAnimationUntilAfterNextRender(),this._updateTouchOptimizedMode(),this._updateOverlayMode()}_updateOffsetSize(){const p=this.$.navbarTop.getBoundingClientRect(),C=this.$.navbarBottom.getBoundingClientRect(),k=this.$.drawer.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-navbar-offset-size",`${p.height}px`),this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom",`${C.height}px`),this.style.setProperty("--_vaadin-app-layout-drawer-offset-size",`${k.width}px`)}_updateOverlayMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay")==="true";!this.overlay&&a&&(this._drawerStateSaved=this.drawerOpened,this.drawerOpened=!1),this._setOverlay(a),!this.overlay&&this._drawerStateSaved&&(this.drawerOpened=this._drawerStateSaved,this._drawerStateSaved=null),this.__updateDrawerAriaAttributes()}__updateDrawerAriaAttributes(){const a=this.$.drawer;this.overlay?(a.setAttribute("role","dialog"),a.setAttribute("aria-modal","true"),a.setAttribute("aria-label",this.__effectiveI18n.drawer)):(a.removeAttribute("role"),a.removeAttribute("aria-modal"),a.removeAttribute("aria-label"))}__drawerTransitionComplete(){return new Promise(a=>{if(this._getCustomPropertyValue("--vaadin-app-layout-transition")==="none"){a();return}this.$.drawer.addEventListener("transitionend",a,{once:!0})})}async __trapFocusInDrawer(){await this.__drawerTransitionComplete(),this.drawerOpened&&(this.$.drawer.setAttribute("tabindex","0"),this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.drawer))}async __releaseFocusFromDrawer(){if(await this.__drawerTransitionComplete(),this.drawerOpened)return;this.__restoreFocus();const a=this.querySelector("vaadin-drawer-toggle");a&&a.focus()}__restoreFocus(){this.__ariaModalController.close(),this.__focusTrapController.releaseFocus(),this.$.drawer.removeAttribute("tabindex")}__onDrawerKeyDown(a){a.key==="Escape"&&this.overlay&&(this.drawerOpened=!1)}_closeDrawerOnChanged(a,p){p&&window.removeEventListener(p,this.__closeOverlayDrawerListener),a&&window.addEventListener(a,this.__closeOverlayDrawerListener)}_onBackdropClick(){this._close()}_onBackdropTouchend(a){a.preventDefault(),this._close()}_close(){this.drawerOpened=!1}_getCustomPropertyValue(a){return(getComputedStyle(this).getPropertyValue(a)||"").trim().toLowerCase()}_updateTouchOptimizedMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized")==="true",p=this.querySelectorAll('[slot*="navbar"]');p.length>0&&Array.from(p).forEach(v=>{v.getAttribute("slot").indexOf("touch-optimized")>-1&&(v.__touchOptimized=!0),a&&v.__touchOptimized?v.setAttribute("slot","navbar-bottom"):v.setAttribute("slot","navbar")}),this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length===0?this.$.navbarTop.setAttribute("hidden",""):this.$.navbarTop.removeAttribute("hidden"),this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length===0?this.$.navbarBottom.setAttribute("hidden",""):this.$.navbarBottom.removeAttribute("hidden"),this._updateOffsetSize()}_blockAnimationUntilAfterNextRender(){this.setAttribute("no-anim",""),this.__debounceAnimation=Debouncer$1.debounce(this.__debounceAnimation,animationFrame,()=>{setTimeout(()=>{this.removeAttribute("no-anim")})})}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const appLayoutStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition: 200ms;
    transition: padding var(--vaadin-app-layout-transition);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([no-anim]) {
    --vaadin-app-layout-transition: none !important;
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition);
    padding-top: var(--safe-area-inset-top);
    padding-left: var(--safe-area-inset-left);
    padding-right: var(--safe-area-inset-right);
    z-index: 1;
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-bottom: var(--safe-area-inset-bottom);
  }

  [part='drawer'] {
    overflow: auto;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition),
      visibility var(--vaadin-app-layout-transition);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background-color: #000;
    opacity: 0.3;
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-app-layout",appLayoutStyles,{moduleId:"vaadin-app-layout-styles"});class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div part="navbar" id="navbarTop">
        <slot name="navbar" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
      <div part="backdrop" on-click="_onBackdropClick" on-touchend="_onBackdropTouchend"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" on-slotchange="_updateDrawerSize"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
    `}static get is(){return"vaadin-app-layout"}}defineCustomElement(AppLayout);const button$1=i`
  :host {
    /* Sizing */
    --lumo-button-size: var(--lumo-size-m);
    min-width: var(--vaadin-button-min-width, calc(var(--_button-size) * 2));
    height: var(--_button-size);
    padding: var(--vaadin-button-padding, 0 calc(var(--_button-size) / 3 + var(--lumo-border-radius-m) / 2));
    margin: var(--vaadin-button-margin, var(--lumo-space-xs) 0);
    box-sizing: border-box;
    /* Style */
    font-family: var(--lumo-font-family);
    font-size: var(--vaadin-button-font-size, var(--lumo-font-size-m));
    font-weight: var(--vaadin-button-font-weight, 500);
    color: var(--_lumo-button-text-color);
    background: var(--_lumo-button-background);
    border: var(--vaadin-button-border, none);
    border-radius: var(--vaadin-button-border-radius, var(--lumo-border-radius-m));
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    flex-shrink: 0;
    --_button-size: var(--vaadin-button-height, var(--lumo-button-size));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    /* Used by notification */
    --_lumo-button-background: var(--vaadin-button-background, var(--lumo-contrast-5pct));
    --_lumo-button-text-color: var(--vaadin-button-text-color, var(--lumo-primary-text-color));
    --_lumo-button-primary-background: var(--vaadin-button-primary-background, var(--lumo-primary-color));
    --_lumo-button-primary-text-color: var(--vaadin-button-primary-text-color, var(--lumo-primary-contrast-color));
  }

  /* Set only for the internal parts so we don't affect the host vertical alignment */
  [part='label'],
  [part='prefix'],
  [part='suffix'] {
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] {
    padding: calc(var(--lumo-button-size) / 6) 0;
  }

  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-button-size: var(--lumo-size-s);
  }

  :host([theme~='large']) {
    font-size: var(--lumo-font-size-l);
    --lumo-button-size: var(--lumo-size-l);
  }

  /* For interaction states */
  :host::before,
  :host::after {
    content: '';
    /* We rely on the host always being relative */
    position: absolute;
    z-index: 1;
    inset: 0;
    background-color: currentColor;
    border-radius: inherit;
    opacity: 0;
    pointer-events: none;
  }

  /* Hover */

  @media (any-hover: hover) {
    :host(:not([disabled]):hover)::before {
      opacity: 0.02;
    }
  }

  /* Active */

  :host::after {
    transition:
      opacity 1.4s,
      transform 0.1s;
    filter: blur(8px);
  }

  :host([active])::before {
    opacity: 0.05;
    transition-duration: 0s;
  }

  :host([active])::after {
    opacity: 0.1;
    transition-duration: 0s, 0s;
    transform: scale(0);
  }

  /* Keyboard focus */

  :host([focus-ring]) {
    box-shadow:
      0 0 0 calc(1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-gap-color, var(--lumo-base-color)),
      0 0 0 calc(var(--_focus-ring-width) + 1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-color);
  }

  :host([theme~='primary'][focus-ring]) {
    --_focus-ring-gap-on: 1;
  }

  /* Types (primary, tertiary, tertiary-inline */

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    --_background: transparent !important;
    background: var(--vaadin-button-tertiary-background, var(--_background));
    min-width: 0;
  }

  :host([theme~='tertiary']) {
    border: var(--vaadin-button-tertiary-border, none);
    color: var(--vaadin-button-tertiary-text-color, var(--lumo-primary-text-color));
    font-weight: var(--vaadin-button-tertiary-font-weight, 500);
    padding: var(--vaadin-button-tertiary-padding, 0 calc(var(--_button-size) / 6));
  }

  :host([theme~='tertiary-inline'])::before {
    display: none;
  }

  :host([theme~='tertiary-inline']) {
    margin: 0;
    height: auto;
    padding: 0;
    line-height: inherit;
    font-size: inherit;
  }

  :host([theme~='tertiary-inline']) [part='label'] {
    padding: 0;
    overflow: visible;
    line-height: inherit;
  }

  :host([theme~='primary']) {
    background: var(--_lumo-button-primary-background);
    border: var(--vaadin-button-primary-border, none);
    color: var(--_lumo-button-primary-text-color);
    font-weight: var(--vaadin-button-primary-font-weight, 600);
    min-width: calc(var(--lumo-button-size) * 2.5);
  }

  :host([theme~='primary'])::before {
    background-color: black;
  }

  @media (any-hover: hover) {
    :host([theme~='primary']:not([disabled]):hover)::before {
      opacity: 0.05;
    }
  }

  :host([theme~='primary'][active])::before {
    opacity: 0.1;
  }

  :host([theme~='primary'][active])::after {
    opacity: 0.2;
  }

  /* Colors (success, warning, error, contrast) */

  :host([theme~='success']) {
    color: var(--lumo-success-text-color);
  }

  :host([theme~='success'][theme~='primary']) {
    background-color: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
  }

  :host([theme~='warning']) {
    color: var(--lumo-warning-text-color);
  }

  :host([theme~='warning'][theme~='primary']) {
    background-color: var(--lumo-warning-color);
    color: var(--lumo-warning-contrast-color);
  }

  :host([theme~='error']) {
    color: var(--lumo-error-text-color);
  }

  :host([theme~='error'][theme~='primary']) {
    background-color: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
  }

  :host([theme~='contrast']) {
    color: var(--lumo-contrast);
  }

  :host([theme~='contrast'][theme~='primary']) {
    background-color: var(--lumo-contrast);
    color: var(--lumo-base-color);
  }

  /* Disabled state. Keep selectors after other color variants. */

  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
  }

  :host([theme~='primary'][disabled]) {
    background-color: var(--lumo-contrast-30pct);
    color: var(--lumo-base-color);
  }

  :host([theme~='primary'][disabled]) [part] {
    opacity: 0.7;
  }

  /* Icons */

  [part] ::slotted(vaadin-icon) {
    display: inline-block;
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  [part] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  [part='prefix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  [part='suffix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  /* Icon-only */

  :host([theme~='icon']:not([theme~='tertiary-inline'])) {
    min-width: var(--lumo-button-size);
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([theme~='icon']) [part='prefix'],
  :host([theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='prefix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  :host([dir='rtl']) [part='suffix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  :host([dir='rtl'][theme~='icon']) [part='prefix'],
  :host([dir='rtl'][theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }
`;registerStyles$1("vaadin-button",button$1,{moduleId:"lumo-button"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const buttonStyles=i`
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: var(--_vaadin-button-disabled-pointer-events, none);
    cursor: not-allowed;
  }

  /* Aligns the button with form fields when placed on the same line.
  Note, to make it work, the form fields should have the same "::before" pseudo-element. */
  .vaadin-button-container::before {
    content: '\\2003';
    display: inline-block;
    width: 0;
    max-height: 100%;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  [part='prefix'],
  [part='suffix'] {
    flex: none;
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  @media (forced-colors: active) {
    :host {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) {
      outline-width: 2px;
    }

    :host([disabled]) {
      outline-color: GrayText;
    }
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-button",buttonStyles,{moduleId:"vaadin-button-styles"});class Button extends ButtonMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get properties(){return{disabled:{type:Boolean,value:!1}}}static get is(){return"vaadin-button"}static get template(){return html$3`
      <div class="vaadin-button-container">
        <span part="prefix" aria-hidden="true">
          <slot name="prefix"></slot>
        </span>
        <span part="label">
          <slot></slot>
        </span>
        <span part="suffix" aria-hidden="true">
          <slot name="suffix"></slot>
        </span>

        <slot name="tooltip"></slot>
      </div>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}__shouldAllowFocusWhenDisabled(){return window.Vaadin.featureFlags.accessibleDisabledButtons}}defineCustomElement(Button);const drawerToggle$1=i`
  :host {
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::before {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-drawer-toggle",[button$1,drawerToggle$1],{moduleId:"lumo-drawer-toggle"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const drawerToggle=i`
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: default;
    position: relative;
    outline: none;
    height: 24px;
    width: 24px;
    padding: 4px;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: absolute;
    top: 8px;
    height: 3px;
    width: 24px;
    background-color: #000;
  }

  [part='icon']::after,
  [part='icon']::before {
    content: '';
  }

  [part='icon']::after {
    top: 6px;
  }

  [part='icon']::before {
    top: 12px;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-drawer-toggle",[buttonStyles,drawerToggle],{moduleId:"vaadin-drawer-toggle-styles"});class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get template(){return html$3`
      <slot id="slot">
        <div part="icon"></div>
      </slot>
      <div part="icon" hidden$="[[!_showFallbackIcon]]"></div>
    `}static get is(){return"vaadin-drawer-toggle"}static get properties(){return{ariaLabel:{type:String,value:"Toggle navigation panel",reflectToAttribute:!0},_showFallbackIcon:{type:Boolean,value:!1}}}constructor(){super(),this.addEventListener("click",()=>{this.dispatchEvent(new CustomEvent("drawer-toggle-click",{bubbles:!0,composed:!0}))})}ready(){super.ready(),this._toggleFallbackIcon(),this.$.slot.addEventListener("slotchange",()=>{this._toggleFallbackIcon()})}_toggleFallbackIcon(){const d=this.$.slot.assignedNodes();this._showFallbackIcon=d.length>0&&d.every(a=>isEmptyTextNode(a))}}defineCustomElement(DrawerToggle);const tooltipOverlay=i`
  :host {
    --vaadin-tooltip-offset-top: var(--lumo-space-xs);
    --vaadin-tooltip-offset-bottom: var(--lumo-space-xs);
    --vaadin-tooltip-offset-start: var(--lumo-space-xs);
    --vaadin-tooltip-offset-end: var(--lumo-space-xs);
  }

  [part='overlay'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }
`;registerStyles$1("vaadin-tooltip-overlay",[overlay,tooltipOverlay],{moduleId:"lumo-tooltip-overlay"});/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getClosestOverlay=g=>{let d=g;for(;d&&d!==g.ownerDocument;)if(d=d.parentNode||d.host,d&&d._hasOverlayStackMixin)return d;return null},PopoverOverlayMixin=g=>class extends PositionMixin(OverlayMixin(g)){static get properties(){return{position:{type:String,reflectToAttribute:!0}}}static get observers(){return["__openedOrTargetChanged(opened, positionTarget)"]}get _tagNamePrefix(){return"vaadin-popover"}_updatePosition(){if(super._updatePosition(),!(!this.positionTarget||!this.opened)){if(this.owner){const a=getComputedStyle(this.owner);["top","bottom","start","end"].forEach(p=>{const v=`--${this._tagNamePrefix}-offset-${p}`;this.style.setProperty(v,a.getPropertyValue(v))})}if(this.removeAttribute("arrow-centered"),this.position==="bottom"||this.position==="top"){const a=this.positionTarget.getBoundingClientRect(),p=this.$.overlay.getBoundingClientRect(),v=a.width/2-p.width/2;if(this.style.left){const C=p.left+v;C>0&&(this.style.left=`${C}px`,this.setAttribute("arrow-centered",""))}if(this.style.right){const C=parseFloat(this.style.right)+v;C>0&&(this.style.right=`${C}px`,this.setAttribute("arrow-centered",""))}}if(this.position==="start"||this.position==="end"){const a=this.positionTarget.getBoundingClientRect(),p=this.$.overlay.getBoundingClientRect(),v=a.height/2-p.height/2;this.style.top=`${p.top+v}px`}}}__openedOrTargetChanged(a,p){if(p){const v=getClosestOverlay(p);v&&setNestedOverlay(v,a?this:null)}}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const tooltipOverlayStyles=i`
  [part='overlay'] {
    max-width: 40ch;
  }

  [part='content'] {
    white-space: pre-wrap;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, 0);
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, 0);
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, 0);
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, 0);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 1px dashed;
    }
  }
`;/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-tooltip-overlay",[overlayStyles$1,tooltipOverlayStyles],{moduleId:"vaadin-tooltip-overlay-styles"});class TooltipOverlay extends PopoverOverlayMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-tooltip-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `}get _tagNamePrefix(){return"vaadin-tooltip"}requestContentUpdate(){super.requestContentUpdate(),this.toggleAttribute("hidden",this.textContent.trim()==="")}}defineCustomElement(TooltipOverlay);/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayClassMixin=g=>class extends g{static get properties(){return{overlayClass:{type:String},_overlayElement:{type:Object}}}static get observers(){return["__updateOverlayClassNames(overlayClass, _overlayElement)"]}__updateOverlayClassNames(a,p){if(!p||a===void 0)return;const{classList:v}=p;if(this.__initialClasses||(this.__initialClasses=new Set(v)),Array.isArray(this.__previousClasses)){const P=this.__previousClasses.filter(k=>!this.__initialClasses.has(k));P.length>0&&v.remove(...P)}const C=typeof a=="string"?a.split(" ").filter(Boolean):[];C.length>0&&v.add(...C),this.__previousClasses=C}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverPositionMixin=g=>class extends g{static get properties(){return{position:{type:String},_position:{type:String,value:"bottom"},__effectivePosition:{type:String,computed:"__computePosition(position, _position)"}}}__computeHorizontalAlign(a){return["top-end","bottom-end","start-top","start","start-bottom"].includes(a)?"end":"start"}__computeNoHorizontalOverlap(a){return["start-top","start","start-bottom","end-top","end","end-bottom"].includes(a)}__computeNoVerticalOverlap(a){return["top-start","top-end","top","bottom-start","bottom","bottom-end"].includes(a)}__computeVerticalAlign(a){return["top-start","top-end","top","start-bottom","end-bottom"].includes(a)?"bottom":"top"}__computePosition(a,p){return a||p}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverTargetMixin=g=>class extends g{static get properties(){return{for:{type:String,observer:"__forChanged"},target:{type:Object},__isConnected:{type:Boolean,sync:!0}}}static get observers(){return["__targetOrConnectedChanged(target, __isConnected)"]}connectedCallback(){super.connectedCallback(),this.__isConnected=!0}disconnectedCallback(){super.disconnectedCallback(),this.__isConnected=!1}__forChanged(a){a&&(this.__setTargetByIdDebouncer=Debouncer$1.debounce(this.__setTargetByIdDebouncer,microTask$1,()=>this.__setTargetById(a)))}__setTargetById(a){if(!this.isConnected)return;const p=this.getRootNode().getElementById(a);p?this.target=p:console.warn(`No element with id="${a}" set via "for" property found on the page.`)}__targetOrConnectedChanged(a,p){this.__previousTarget&&(this.__previousTarget!==a||!p)&&this._removeTargetListeners(this.__previousTarget),a&&p&&this._addTargetListeners(a),this.__previousTarget=a}_addTargetListeners(a){}_removeTargetListeners(a){}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_DELAY$1=500;let defaultFocusDelay$3=DEFAULT_DELAY$1,defaultHoverDelay$3=DEFAULT_DELAY$1,defaultHideDelay$3=DEFAULT_DELAY$1;const closing=new Set;let warmedUp=!1,warmUpTimeout=null,cooldownTimeout=null;class TooltipStateController{constructor(d){this.host=d}get openedProp(){return this.host.manual?"opened":"_autoOpened"}get focusDelay(){const d=this.host;return d.focusDelay!=null&&d.focusDelay>=0?d.focusDelay:defaultFocusDelay$3}get hoverDelay(){const d=this.host;return d.hoverDelay!=null&&d.hoverDelay>=0?d.hoverDelay:defaultHoverDelay$3}get hideDelay(){const d=this.host;return d.hideDelay!=null&&d.hideDelay>=0?d.hideDelay:defaultHideDelay$3}get isClosing(){return closing.has(this.host)}open(d={immediate:!1}){const{immediate:a,hover:p,focus:v}=d,C=p&&this.hoverDelay>0,P=v&&this.focusDelay>0;!a&&(C||P)&&!this.__closeTimeout?this.__warmupTooltip(P):this.__showTooltip()}close(d){!d&&this.hideDelay>0?this.__scheduleClose():(this.__abortClose(),this._setOpened(!1)),this.__abortWarmUp(),warmedUp&&(this.__abortCooldown(),this.__scheduleCooldown())}_isOpened(){return this.host[this.openedProp]}_setOpened(d){this.host[this.openedProp]=d}__flushClosingTooltips(){closing.forEach(d=>{d._stateController.close(!0),closing.delete(d)})}__showTooltip(){this.__abortClose(),this.__flushClosingTooltips(),this._setOpened(!0),warmedUp=!0,this.__abortWarmUp(),this.__abortCooldown()}__warmupTooltip(d){this._isOpened()||(warmedUp?this.__showTooltip():warmUpTimeout==null&&this.__scheduleWarmUp(d))}__abortClose(){this.__closeTimeout&&(clearTimeout(this.__closeTimeout),this.__closeTimeout=null),this.isClosing&&closing.delete(this.host)}__abortCooldown(){cooldownTimeout&&(clearTimeout(cooldownTimeout),cooldownTimeout=null)}__abortWarmUp(){warmUpTimeout&&(clearTimeout(warmUpTimeout),warmUpTimeout=null)}__scheduleClose(){this._isOpened()&&!this.isClosing&&(closing.add(this.host),this.__closeTimeout=setTimeout(()=>{closing.delete(this.host),this.__closeTimeout=null,this._setOpened(!1)},this.hideDelay))}__scheduleCooldown(){cooldownTimeout=setTimeout(()=>{cooldownTimeout=null,warmedUp=!1},this.hideDelay)}__scheduleWarmUp(d){const a=d?this.focusDelay:this.hoverDelay;warmUpTimeout=setTimeout(()=>{warmUpTimeout=null,warmedUp=!0,this.__showTooltip()},a)}}const TooltipMixin=g=>class extends PopoverPositionMixin(PopoverTargetMixin(OverlayClassMixin(g))){static get properties(){return{ariaTarget:{type:Object},context:{type:Object,value:()=>({})},focusDelay:{type:Number},generator:{type:Object},hideDelay:{type:Number},hoverDelay:{type:Number},manual:{type:Boolean,value:!1,sync:!0},opened:{type:Boolean,value:!1,sync:!0},shouldShow:{type:Object,value:()=>(a,p)=>!0},text:{type:String,observer:"__textChanged"},_autoOpened:{type:Boolean,observer:"__autoOpenedChanged",sync:!0},_effectiveAriaTarget:{type:Object,computed:"__computeAriaTarget(ariaTarget, target)",observer:"__effectiveAriaTargetChanged"},__isTargetHidden:{type:Boolean,value:!1},_isConnected:{type:Boolean,sync:!0},_srLabel:{type:Object},_overlayContent:{type:String}}}static get observers(){return["__generatorChanged(_overlayElement, generator, context)","__updateSrLabelText(_srLabel, _overlayContent)"]}static setDefaultFocusDelay(a){defaultFocusDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHideDelay(a){defaultHideDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHoverDelay(a){defaultHoverDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}constructor(){super(),this._uniqueId=`vaadin-tooltip-${generateUniqueId()}`,this._renderer=this.__tooltipRenderer.bind(this),this.__onFocusin=this.__onFocusin.bind(this),this.__onFocusout=this.__onFocusout.bind(this),this.__onMouseDown=this.__onMouseDown.bind(this),this.__onMouseEnter=this.__onMouseEnter.bind(this),this.__onMouseLeave=this.__onMouseLeave.bind(this),this.__onKeyDown=this.__onKeyDown.bind(this),this.__onOverlayOpen=this.__onOverlayOpen.bind(this),this.__targetVisibilityObserver=new IntersectionObserver(a=>{a.forEach(p=>this.__onTargetVisibilityChange(p.isIntersecting))},{threshold:0}),this._stateController=new TooltipStateController(this)}connectedCallback(){super.connectedCallback(),this._isConnected=!0,document.body.addEventListener("vaadin-overlay-open",this.__onOverlayOpen)}disconnectedCallback(){super.disconnectedCallback(),this._autoOpened&&this._stateController.close(!0),this._isConnected=!1,document.body.removeEventListener("vaadin-overlay-open",this.__onOverlayOpen)}ready(){super.ready(),this._overlayElement=this.$.overlay,this._srLabelController=new SlotController(this,"sr-label","div",{initializer:a=>{a.id=this._uniqueId,a.setAttribute("role","tooltip"),this._srLabel=a}}),this.addController(this._srLabelController)}__computeOpened(a,p,v,C){return C&&(a?p:v)}__autoOpenedChanged(a,p){a?document.addEventListener("keydown",this.__onKeyDown,!0):p&&document.removeEventListener("keydown",this.__onKeyDown,!0)}_addTargetListeners(a){a.addEventListener("mouseenter",this.__onMouseEnter),a.addEventListener("mouseleave",this.__onMouseLeave),a.addEventListener("focusin",this.__onFocusin),a.addEventListener("focusout",this.__onFocusout),a.addEventListener("mousedown",this.__onMouseDown),requestAnimationFrame(()=>{this.__targetVisibilityObserver.observe(a)})}_removeTargetListeners(a){a.removeEventListener("mouseenter",this.__onMouseEnter),a.removeEventListener("mouseleave",this.__onMouseLeave),a.removeEventListener("focusin",this.__onFocusin),a.removeEventListener("focusout",this.__onFocusout),a.removeEventListener("mousedown",this.__onMouseDown),this.__targetVisibilityObserver.unobserve(a)}__onFocusin(a){this.manual||isKeyboardActive()&&(this.target.contains(a.relatedTarget)||this.__isShouldShow()&&(this.__focusInside=!0,!this.__isTargetHidden&&(!this.__hoverInside||!this._autoOpened)&&this._stateController.open({focus:!0})))}__onFocusout(a){this.manual||this.target.contains(a.relatedTarget)||(this.__focusInside=!1,this.__hoverInside||this._stateController.close(!0))}__onKeyDown(a){a.key==="Escape"&&(a.stopPropagation(),this._stateController.close(!0))}__onMouseDown(){this.manual||this._stateController.close(!0)}__onMouseEnter(){this.manual||this.__isShouldShow()&&(this.__hoverInside||(this.__hoverInside=!0,!this.__isTargetHidden&&(!this.__focusInside||!this._autoOpened)&&this._stateController.open({hover:!0})))}__onMouseLeave(a){a.relatedTarget!==this._overlayElement&&this.__handleMouseLeave()}__onOverlayMouseEnter(){this.manual||this._stateController.isClosing&&this._stateController.open({immediate:!0})}__onOverlayMouseLeave(a){a.relatedTarget!==this.target&&this.__handleMouseLeave()}__handleMouseLeave(){this.manual||(this.__hoverInside=!1,this.__focusInside||this._stateController.close())}__onOverlayOpen(){this.manual||this._overlayElement.opened&&!this._overlayElement._last&&this._stateController.close(!0)}__onTargetVisibilityChange(a){const p=this.__isTargetHidden;if(this.__isTargetHidden=!a,p&&a&&(this.__focusInside||this.__hoverInside)){this._stateController.open({immediate:!0});return}!a&&this._autoOpened&&this._stateController.close(!0)}__isShouldShow(){return!(typeof this.shouldShow=="function"&&this.shouldShow(this.target,this.context)!==!0)}__textChanged(a,p){this._overlayElement&&(a||p)&&this._overlayElement.requestContentUpdate()}__tooltipRenderer(a){a.textContent=typeof this.generator=="function"?this.generator(this.context):this.text,this._overlayContent=a.textContent,this.dispatchEvent(new CustomEvent("content-changed",{detail:{content:a.textContent}}))}__computeAriaTarget(a,p){const v=P=>P&&P.nodeType===Node.ELEMENT_NODE;return(Array.isArray(a)?a.some(v):a)?a:p}__effectiveAriaTargetChanged(a,p){p&&[p].flat().forEach(v=>{removeValueFromAttribute(v,"aria-describedby",this._uniqueId)}),a&&[a].flat().forEach(v=>{addValueToAttribute(v,"aria-describedby",this._uniqueId)})}__generatorChanged(a,p,v){a&&((p!==this.__oldTextGenerator||v!==this.__oldContext)&&a.requestContentUpdate(),this.__oldTextGenerator=p,this.__oldContext=v)}__updateSrLabelText(a,p){a&&(a.textContent=p)}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let Tooltip$1=class extends TooltipMixin(ThemePropertyMixin(ElementMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-tooltip"}static get template(){return html$3`
      <style>
        :host {
          display: none;
        }
      </style>
      <vaadin-tooltip-overlay
        id="overlay"
        owner="[[__overlayOwner]]"
        renderer="[[_renderer]]"
        theme$="[[_theme]]"
        opened="[[__computeOpened(manual, opened, _autoOpened, _isConnected)]]"
        position-target="[[target]]"
        position="[[__effectivePosition]]"
        no-horizontal-overlap$="[[__computeNoHorizontalOverlap(__effectivePosition)]]"
        no-vertical-overlap$="[[__computeNoVerticalOverlap(__effectivePosition)]]"
        horizontal-align="[[__computeHorizontalAlign(__effectivePosition)]]"
        vertical-align="[[__computeVerticalAlign(__effectivePosition)]]"
        on-mouseenter="__onOverlayMouseEnter"
        on-mouseleave="__onOverlayMouseLeave"
        modeless
      ></vaadin-tooltip-overlay>

      <slot name="sr-label"></slot>
    `}static get properties(){return{__overlayOwner:{value(){return this}}}}};defineCustomElement(Tooltip$1);const globalStyle=document.createElement("style");globalStyle.textContent="html { --vaadin-avatar-size: var(--lumo-size-m); }";document.head.appendChild(globalStyle);registerStyles$1("vaadin-avatar",i`
    :host {
      color: var(--lumo-secondary-text-color);
      background-color: var(--lumo-contrast-10pct);
      border-radius: 50%;
      outline: none;
      cursor: default;
      user-select: none;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }

    :host([has-color-index]) {
      color: var(--lumo-base-color);
    }

    :host([focus-ring]) {
      border-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    }

    [part='icon'],
    [part='abbr'] {
      fill: currentColor;
    }

    [part='abbr'] {
      font-family: var(--lumo-font-family);
      font-size: 2.4375em;
      font-weight: 500;
    }

    :host([theme~='xlarge']) [part='abbr'] {
      font-size: 2.5em;
    }

    :host([theme~='large']) [part='abbr'] {
      font-size: 2.375em;
    }

    :host([theme~='small']) [part='abbr'] {
      font-size: 2.75em;
    }

    :host([theme~='xsmall']) [part='abbr'] {
      font-size: 3em;
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar"});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$7=document.createElement("template");template$7.innerHTML=`
  <style>
    @font-face {
      font-family: 'vaadin-avatar-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQAAAsAAAAABnwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABHU1VCAAABCAAAADsAAABUIIslek9TLzIAAAFEAAAAQwAAAFZAIUmEY21hcAAAAYgAAABLAAABcOspwa1nbHlmAAAB1AAAAEUAAABMYO4o1WhlYWQAAAIcAAAALgAAADYYaAmGaGhlYQAAAkwAAAAdAAAAJAZsA1VobXR4AAACbAAAAAgAAAAIA+gAAGxvY2EAAAJ0AAAABgAAAAYAJgAAbWF4cAAAAnwAAAAeAAAAIAEOACFuYW1lAAACnAAAAUIAAAKavFDYrHBvc3QAAAPgAAAAHQAAAC52hGZ4eJxjYGRgYOBiMGCwY2BycfMJYeDLSSzJY5BiYGGAAJA8MpsxJzM9kYEDxgPKsYBpDiBmg4gCACY7BUgAeJxjYGT8wjiBgZWBgamKaQ8DA0MPhGZ8wGDIyAQUZWBlZsAKAtJcUxgcXjG+YmQO+p/FEMUcxDANKMwIkgMADiUMJQB4nGNgYGBlYGBgBmIdIGZhYGAMYWBkAAE/oCgjWJyZgQsszsKgBFbDAhJ/xfj/P4wE8lnAJAMjG8Mo4AGTMlAeOKwgmIERADU0CX0AeJxjYGIAAmYJpkgGHgYRBgZGJT1GEztGIzlGET5GKEuU8YuSpZKSpQuI+LfLv21emz9jHJQPJP7dsUywsEiwBACG8g9CAAAAeJxjYGRgYADicIOnh+P5bb4ycDO/AIow3JZ4rIJMM0swRQIpDgYmEA8AKwgJOwAAeJxjYGRgYA76nwUkXzAAAbMEAyMDKmACAE2GAskAAAAAAAAAA+gAAAAAAAAAJgAAeJxjYGRgYGBiEAViBjCLgYELCBkY/oP5DAAKuwEwAAB4nI2Qu07DMBSG//SGaCWEhMSAGDx1QU0vYyemdmDrUDEhuamTpkriyHEj9RF4B56Bh2Bg5mmY+8d4Qh3qo9jf+c45thQAt/hGgGYFuHN7s1q4YvbHbdKD5w555LmLAZ499+hfPPfxhDfPA/p33hB0rmmG+PDcwg2+PLfpfzx3yL+eu7gPHj33MAxmnvtYB6+eB/SftZTbtBjJWlppRmmki2qlkkMmzZnKGbVWpkp1Iabh5Ex1qQplpFVbsTmKqk5m1sYiNjoXC11YlWValEbvVWTDnbXlfDyOvQ8jnaOGZGyRouCfky63/AyzFBE0fYUVFBIckLnKZTOXda15s+GZulxgihCTC2eXnC3cfFNV7BfY4Mi9eT3BjNYiZh6zRyMnLdxs050xNE3panuaiD7Ezk2VmGPMiP/1h+71/ATcWYAhAAB4nGNgYoAALgbsgImRiZGZgaW0OLWIgQEACl4B2QAAAA==) format('woff');
      font-weight: normal;
      font-style: normal;
    }
  </style>
`;document.head.appendChild(template$7.content);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$9={anonymous:"anonymous"},AvatarMixin=g=>class extends I18nMixin(DEFAULT_I18N$9,FocusMixin(g)){static get properties(){return{img:{type:String,reflectToAttribute:!0,observer:"__imgChanged"},abbr:{type:String,reflectToAttribute:!0},name:{type:String,reflectToAttribute:!0},colorIndex:{type:Number,observer:"__colorIndexChanged"},withTooltip:{type:Boolean,value:!1,observer:"__withTooltipChanged"},__imgVisible:Boolean,__iconVisible:Boolean,__abbrVisible:Boolean,__tooltipNode:Object}}static get observers(){return["__imgOrAbbrOrNameChanged(img, abbr, name)","__i18nChanged(__effectiveI18n)","__tooltipChanged(__tooltipNode, name, abbr)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this.__updateVisibility(),this.hasAttribute("role")||this.setAttribute("role","img"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),!this.name&&!this.abbr&&this.__setTooltip()}__colorIndexChanged(a){if(a!=null){const p=`--vaadin-user-color-${a}`;!!getComputedStyle(document.documentElement).getPropertyValue(p)?(this.setAttribute("has-color-index",""),this.style.setProperty("--vaadin-avatar-user-color",`var(${p})`)):(this.removeAttribute("has-color-index"),console.warn(`The CSS property --vaadin-user-color-${a} is not defined`))}else this.removeAttribute("has-color-index")}__imgChanged(){this.__imgFailedToLoad=!1}__imgOrAbbrOrNameChanged(a,p,v){this.__updateVisibility(),!(p&&p!==this.__generatedAbbr)&&(v?this.abbr=this.__generatedAbbr=v.split(" ").map(C=>C.charAt(0)).join(""):this.abbr=void 0)}__tooltipChanged(a,p,v){a&&(v&&v!==this.__generatedAbbr?this.__setTooltip(p?`${p} (${v})`:v):this.__setTooltip(p)),v?this.setAttribute("aria-label",!a&&p?`${p} (${v})`:v):this.removeAttribute("aria-label")}__withTooltipChanged(a,p){if(this.toggleAttribute("has-tooltip",a),a){const v=document.createElement("vaadin-tooltip");v.setAttribute("slot","tooltip"),this.appendChild(v),this.__tooltipNode=v}else p&&(this.__tooltipNode.target=null,this.__tooltipNode.remove(),this.__tooltipNode=null)}__i18nChanged(a){a&&a.anonymous&&(this.__oldAnonymous&&this.__tooltipNode&&this.__tooltipNode.text===this.__oldAnonymous&&this.__setTooltip(),this.__oldAnonymous=a.anonymous)}__updateVisibility(){this.__imgVisible=!!this.img&&!this.__imgFailedToLoad,this.__abbrVisible=!this.__imgVisible&&!!this.abbr,this.__iconVisible=!this.__imgVisible&&!this.abbr}__setTooltip(a){const p=this.__tooltipNode;p&&(p.text=a||this.__effectiveI18n.anonymous)}__onImageLoadError(){this.img&&(console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`),this.__imgFailedToLoad=!0,this.__updateVisibility())}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarStyles=i`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 64px);
    width: var(--vaadin-avatar-size, 64px);
    border: var(--vaadin-avatar-outline-width) solid transparent;
    margin: calc(var(--vaadin-avatar-outline-width) * -1);
    background-clip: content-box;
    --vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    font-size: 5.6em;
  }

  [part='abbr'] {
    font-size: 2.2em;
  }

  [part='icon'] > text {
    font-family: 'vaadin-avatar-icons';
  }

  :host([hidden]) {
    display: none !important;
  }

  svg[hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    position: relative;
    background-color: var(--vaadin-avatar-user-color);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar",avatarStyles,{moduleId:"vaadin-avatar-styles"});class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <img
        hidden$="[[!__imgVisible]]"
        src$="[[img]]"
        aria-hidden="true"
        on-error="__onImageLoadError"
        draggable="false"
      />
      <svg
        part="icon"
        hidden$="[[!__iconVisible]]"
        id="avatar-icon"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">&#xea01;</text>
      </svg>
      <svg
        part="abbr"
        hidden$="[[!__abbrVisible]]"
        id="avatar-abbr"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">[[abbr]]</text>
      </svg>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-avatar"}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}defineCustomElement(Avatar);const item=i`
  :host {
    display: flex;
    align-items: center;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    padding: 0.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) 0.5em
      var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
    min-height: var(--lumo-size-m);
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  /* Checkmark */
  [part='checkmark']::before {
    display: var(--_lumo-item-selected-icon-display, none);
    content: var(--lumo-icons-checkmark);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    font-weight: normal;
    width: 1em;
    height: 1em;
    margin: calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;
    color: var(--_selection-color-text);
    flex: none;
    opacity: 0;
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      opacity 0.1s;
  }

  :host([selected]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([active]:not([selected])) [part='checkmark']::before {
    transform: scale(0.8);
    opacity: 0;
    transition-duration: 0s;
  }

  [part='content'] {
    flex: auto;
  }

  /* Disabled */
  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    cursor: default;
    pointer-events: none;
  }

  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  @media (any-hover: hover) {
    :host(:hover:not([disabled])) {
      background-color: var(--lumo-primary-color-10pct);
    }
  }

  :host([focus-ring]:not([disabled])) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* RTL specific styles */
  :host([dir='rtl']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
  }

  /* Slotted icons */
  :host ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
`;registerStyles$1("vaadin-item",item,{moduleId:"lumo-item"});const listBox=i`
  :host {
    -webkit-tap-highlight-color: transparent;
    --_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block);
  }

  /* Dividers */
  [part='items'] ::slotted(hr) {
    height: 1px;
    border: 0;
    padding: 0;
    margin: var(--lumo-space-s) var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }
`;registerStyles$1("vaadin-list-box",listBox,{moduleId:"lumo-list-box"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const menuOverlayCore=i`
  :host([opening]),
  :host([closing]) {
    animation: 0.14s lumo-overlay-dummy-animation;
  }

  [part='overlay'] {
    will-change: opacity, transform;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-enter ease-out both;
  }

  @keyframes lumo-menu-overlay-enter {
    0% {
      opacity: 0;
      transform: translateY(-4px);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-exit both;
  }

  @keyframes lumo-menu-overlay-exit {
    100% {
      opacity: 0;
    }
  }
`;registerStyles$1("",menuOverlayCore,{moduleId:"lumo-menu-overlay-core"});const menuOverlayExt=i`
  /* Small viewport (bottom sheet) styles */
  /* Use direct media queries instead of the state attributes ([phone] and [fullscreen]) provided by the elements */
  @media (max-width: 450px), (max-height: 450px) {
    :host {
      top: 0 !important;
      right: 0 !important;
      bottom: var(--vaadin-overlay-viewport-bottom, 0) !important;
      left: 0 !important;
      align-items: stretch !important;
      justify-content: flex-end !important;
    }

    [part='overlay'] {
      max-height: 50vh;
      width: 100vw;
      border-radius: 0;
      box-shadow: var(--lumo-box-shadow-xl);
    }

    /* The content part scrolls instead of the overlay part, because of the gradient fade-out */
    [part='content'] {
      padding: 30px var(--lumo-space-m);
      max-height: inherit;
      box-sizing: border-box;
      -webkit-overflow-scrolling: touch;
      overflow: auto;
      -webkit-mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
      mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
    }

    [part='backdrop'] {
      display: block;
    }

    /* Animations */

    :host([opening]) [part='overlay'] {
      animation: 0.2s lumo-mobile-menu-overlay-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
    }

    :host([closing]),
    :host([closing]) [part='backdrop'] {
      animation-delay: 0.14s;
    }

    :host([closing]) [part='overlay'] {
      animation: 0.14s 0.14s lumo-mobile-menu-overlay-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
    }
  }

  @keyframes lumo-mobile-menu-overlay-enter {
    0% {
      transform: translateY(150%);
    }
  }

  @keyframes lumo-mobile-menu-overlay-exit {
    100% {
      transform: translateY(150%);
    }
  }
`,menuOverlay=[overlay,menuOverlayCore,menuOverlayExt];registerStyles$1("",menuOverlay,{moduleId:"lumo-menu-overlay"});registerStyles$1("vaadin-avatar-group",i`
    :host {
      --vaadin-avatar-size: var(--lumo-size-m);
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-group-overlap: 12px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-group-overlap: 10px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-group-overlap: 6px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-group-overlap: 4px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar-group"});const avatarGroupOverlay=i`
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  [part='overlay'] {
    outline: none;
  }
`;registerStyles$1("vaadin-avatar-group-overlay",[overlay,menuOverlayCore,avatarGroupOverlay],{moduleId:"lumo-avatar-group-overlay"});registerStyles$1("vaadin-avatar-group-menu",listBox,{moduleId:"lumo-avatar-group-menu"});registerStyles$1("vaadin-avatar-group-menu-item",[item,i`
      :host {
        padding: var(--lumo-space-xs);
        padding-inline-end: var(--lumo-space-m);
      }

      [part='content'] {
        display: flex;
        align-items: center;
      }

      [part='content'] ::slotted(vaadin-avatar) {
        width: var(--lumo-size-xs);
        height: var(--lumo-size-xs);
        margin-inline-end: var(--lumo-space-s);
      }
    `],{moduleId:"lumo-avatar-group-menu-item"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getNormalizedScrollLeft(g,d){const{scrollLeft:a}=g;return d!=="rtl"?a:g.scrollWidth-g.clientWidth+a}function setNormalizedScrollLeft(g,d,a){d!=="rtl"?g.scrollLeft=a:g.scrollLeft=g.clientWidth-g.scrollWidth+a}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ListMixin=g=>class extends KeyboardDirectionMixin(g){static get properties(){return{disabled:{type:Boolean,value:!1,reflectToAttribute:!0},selected:{type:Number,reflectToAttribute:!0,notify:!0,sync:!0},orientation:{type:String,reflectToAttribute:!0,value:""},items:{type:Array,readOnly:!0,notify:!0},_searchBuf:{type:String,value:""}}}static get observers(){return["_enhanceItems(items, orientation, selected, disabled)"]}get _isRTL(){return!this._vertical&&this.getAttribute("dir")==="rtl"}get _scrollerElement(){return console.warn(`Please implement the '_scrollerElement' property in <${this.localName}>`),this}get _vertical(){return this.orientation!=="horizontal"}focus(a){this._observer&&this._observer.flush();const p=Array.isArray(this.items)?this.items:[],v=this._getAvailableIndex(p,0,null,C=>C.tabIndex===0&&!isElementHidden(C));v>=0?this._focus(v,a):super.focus(a)}ready(){super.ready(),this.addEventListener("click",p=>this._onClick(p));const a=this.shadowRoot.querySelector("slot:not([name])");this._observer=new SlotObserver(a,()=>{this._setItems(this._filterItems([...this.children]))})}_getItems(){return this.items}_enhanceItems(a,p,v,C){if(!C&&a){this.setAttribute("aria-orientation",p||"vertical"),a.forEach(k=>{p?k.setAttribute("orientation",p):k.removeAttribute("orientation")}),this._setFocusable(v<0||!v?0:v);const P=a[v];a.forEach(k=>{k.selected=k===P}),P&&!P.disabled&&this._scrollToItem(v)}}_filterItems(a){return a.filter(p=>p._hasVaadinItemMixin)}_onClick(a){if(a.metaKey||a.shiftKey||a.ctrlKey||a.defaultPrevented)return;const p=this._filterItems(a.composedPath())[0];let v;p&&!p.disabled&&(v=this.items.indexOf(p))>=0&&(this.selected=v)}_searchKey(a,p){this._searchReset=Debouncer$1.debounce(this._searchReset,timeOut$1.after(500),()=>{this._searchBuf=""}),this._searchBuf+=p.toLowerCase(),this.items.some(C=>this.__isMatchingKey(C))||(this._searchBuf=p.toLowerCase());const v=this._searchBuf.length===1?a+1:a;return this._getAvailableIndex(this.items,v,1,C=>this.__isMatchingKey(C)&&getComputedStyle(C).display!=="none")}__isMatchingKey(a){return a.textContent.replace(/[^\p{L}\p{Nd}]/gu,"").toLowerCase().startsWith(this._searchBuf)}_onKeyDown(a){if(a.metaKey||a.ctrlKey)return;const p=a.key,v=this.items.indexOf(this.focused);if(/[\p{L}\p{Nd}]/u.test(p)&&p.length===1){const C=this._searchKey(v,p);C>=0&&this._focus(C);return}super._onKeyDown(a)}_setFocusable(a){a=this._getAvailableIndex(this.items,a,1);const p=this.items[a];this.items.forEach(v=>{v.tabIndex=v===p?0:-1})}_focus(a,p){this.items.forEach((v,C)=>{v.focused=C===a}),this._setFocusable(a),this._scrollToItem(a),super._focus(a,p)}_scrollToItem(a){const p=this.items[a];if(!p)return;const v=this._vertical?["top","bottom"]:this._isRTL?["right","left"]:["left","right"],C=this._scrollerElement.getBoundingClientRect(),P=(this.items[a+1]||p).getBoundingClientRect(),k=(this.items[a-1]||p).getBoundingClientRect();let z=0;!this._isRTL&&P[v[1]]>=C[v[1]]||this._isRTL&&P[v[1]]<=C[v[1]]?z=P[v[1]]-C[v[1]]:(!this._isRTL&&k[v[0]]<=C[v[0]]||this._isRTL&&k[v[0]]>=C[v[0]])&&(z=k[v[0]]-C[v[0]]),this._scroll(z)}_scroll(a){if(this._vertical)this._scrollerElement.scrollTop+=a;else{const p=this.getAttribute("dir")||"ltr",v=getNormalizedScrollLeft(this._scrollerElement,p)+a;setNormalizedScrollLeft(this._scrollerElement,p,v)}}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-menu"}static get template(){return html$3`
      <style>
        :host {
          display: flex;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='items'] {
          height: 100%;
          width: 100%;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }
      </style>
      <div part="items">
        <slot></slot>
      </div>
    `}static get properties(){return{orientation:{readOnly:!0}}}get _scrollerElement(){return this.shadowRoot.querySelector('[part="items"]')}ready(){super.ready(),this.setAttribute("role","menu")}}defineCustomElement(AvatarGroupMenu);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemMixin=g=>class extends ActiveMixin(FocusMixin(g)){static get properties(){return{_hasVaadinItemMixin:{value:!0},selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged",sync:!0},_value:String}}get _activeKeys(){return["Enter"," "]}get value(){return this._value!==void 0?this._value:this.textContent.trim()}set value(a){this._value=a}ready(){super.ready();const a=this.getAttribute("value");a!==null&&(this.value=a)}focus(a){this.disabled||super.focus(a)}_shouldSetActive(a){return!this.disabled&&!(a.type==="keydown"&&a.defaultPrevented)}_selectedChanged(a){this.setAttribute("aria-selected",a)}_disabledChanged(a){super._disabledChanged(a),a&&(this.selected=!1,this.blur())}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&!a.defaultPrevented&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolymerElement))){static get is(){return"vaadin-avatar-group-menu-item"}static get template(){return html$3`
      <style>
        :host {
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menuitem")}}defineCustomElement(AvatarGroupMenuItem);/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group-overlay",[overlayStyles$1],{moduleId:"vaadin-avatar-group-overlay-styles"});class AvatarGroupOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay" tabindex="0">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(AvatarGroupOverlay);/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$2=g=>g??E;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const observer$1=new ResizeObserver(g=>{setTimeout(()=>{g.forEach(d=>{d.target.isConnected&&(d.target.resizables?d.target.resizables.forEach(a=>{a._onResize(d.contentRect)}):d.target._onResize(d.contentRect))})})}),ResizeMixin=dedupeMixin(g=>class extends g{get _observeParent(){return!1}connectedCallback(){if(super.connectedCallback(),observer$1.observe(this),this._observeParent){const a=this.parentNode instanceof ShadowRoot?this.parentNode.host:this.parentNode;a.resizables||(a.resizables=new Set,observer$1.observe(a)),a.resizables.add(this),this.__parent=a}}disconnectedCallback(){super.disconnectedCallback(),observer$1.unobserve(this);const a=this.__parent;if(this._observeParent&&a){const p=a.resizables;p&&(p.delete(this),p.size===0&&observer$1.unobserve(a)),this.__parent=null}}_onResize(a){}});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MINIMUM_DISPLAYED_AVATARS=2,DEFAULT_I18N$8={anonymous:"anonymous",activeUsers:{one:"Currently one active user",many:"Currently {count} active users"},joined:"{user} joined",left:"{user} left"},AvatarGroupMixin=g=>class extends I18nMixin(DEFAULT_I18N$8,ResizeMixin(OverlayClassMixin(g))){static get properties(){return{items:{type:Array,observer:"__itemsChanged",sync:!0},maxItemsVisible:{type:Number,sync:!0},_avatars:{type:Array,value:()=>[],sync:!0},__itemsInView:{type:Number,value:null,sync:!0},_overflow:{type:Object,sync:!0},_overflowItems:{type:Array,observer:"__overflowItemsChanged",computed:"__computeOverflowItems(items, __itemsInView, maxItemsVisible)"},_overflowTooltip:{type:Object,sync:!0},_opened:{type:Boolean,sync:!0}}}static get observers(){return["__i18nItemsChanged(__effectiveI18n, items)","__openedChanged(_opened, _overflow)","__updateAvatarsTheme(_overflow, _avatars, _theme)","__updateAvatars(items, __itemsInView, maxItemsVisible, _overflow, __effectiveI18n)","__updateOverflowAvatar(_overflow, items, __itemsInView, maxItemsVisible)","__updateOverflowTooltip(_overflowTooltip, items, __itemsInView, maxItemsVisible)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this._overflowController=new SlotController(this,"overflow","vaadin-avatar",{initializer:p=>{p.setAttribute("role","button"),p.setAttribute("aria-haspopup","menu"),p.setAttribute("aria-expanded","false"),p.addEventListener("click",C=>this._onOverflowClick(C)),p.addEventListener("keydown",C=>this._onOverflowKeyDown(C));const v=document.createElement("vaadin-tooltip");v.setAttribute("slot","tooltip"),p.appendChild(v),this._overflow=p,this._overflowTooltip=v}}),this.addController(this._overflowController);const a=this.$.overlay;a.renderer=this.__overlayRenderer.bind(this),this._overlayElement=a}disconnectedCallback(){super.disconnectedCallback(),this._opened=!1}__getMessage(a,p){return p.replace("{user}",a.name||a.abbr||this.__effectiveI18n.anonymous)}__overlayRenderer(a){let p=a.firstElementChild;p||(p=document.createElement("vaadin-avatar-group-menu"),p.addEventListener("keydown",v=>this._onListKeyDown(v)),a.appendChild(p)),p.textContent="",this._overflowItems&&this._overflowItems.forEach(v=>{p.appendChild(this.__createItemElement(v))})}__createItemElement(a){const p=document.createElement("vaadin-avatar-group-menu-item"),v=document.createElement("vaadin-avatar");if(p.appendChild(v),v.setAttribute("aria-hidden","true"),v.setAttribute("tabindex","-1"),v.i18n=this.__effectiveI18n,this._theme&&v.setAttribute("theme",this._theme),v.name=a.name,v.abbr=a.abbr,v.img=a.img,v.colorIndex=a.colorIndex,a.className&&(v.className=a.className),a.name){const C=document.createTextNode(a.name);p.appendChild(C)}return p}_onOverflowClick(a){a.stopPropagation(),this._opened?this.$.overlay.close():a.defaultPrevented||(this._opened=!0)}_onOverflowKeyDown(a){this._opened||/^(Enter|SpaceBar|\s)$/u.test(a.key)&&(a.preventDefault(),this._opened=!0)}_onListKeyDown(a){(a.key==="Escape"||a.key==="Tab")&&(this._opened=!1)}_onResize(){this.__setItemsInView()}_onVaadinOverlayClose(a){a.detail.sourceEvent&&a.detail.sourceEvent.composedPath().includes(this)&&a.preventDefault()}_onVaadinOverlayOpen(){this._menuElement&&this._menuElement.focus()}__renderAvatars(a){B(x`
          ${a.map(p=>x`
              <vaadin-avatar
                .name="${p.name}"
                .abbr="${p.abbr}"
                .img="${p.img}"
                .colorIndex="${p.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                class="${o$2(p.className)}"
                with-tooltip
              ></vaadin-avatar>
            `)}
        `,this,{renderBefore:this._overflow})}__updateAvatars(a,p,v,C){if(!C||!Array.isArray(a))return;const P=this.__getLimit(a.length,p,v);this.__renderAvatars(P?a.slice(0,P):a),this._avatars=[...this.querySelectorAll("vaadin-avatar")]}__computeOverflowItems(a,p,v){const C=Array.isArray(a)?a.length:0,P=this.__getLimit(C,p,v);return P?a.slice(P):[]}__updateOverflowAvatar(a,p,v,C){if(a){const P=Array.isArray(p)?p.length:0,k=C!=null&&P>this.__getMax(C);a.abbr=`+${P-this.__getLimit(P,v,C)}`,a.toggleAttribute("hidden",!k&&!(v&&v<P))}}__updateAvatarsTheme(a,p,v){a&&[a,...p].forEach(C=>{v?C.setAttribute("theme",v):C.removeAttribute("theme")})}__updateOverflowTooltip(a,p,v,C){if(!a||!Array.isArray(p))return;const P=this.__getLimit(p.length,v,C);if(P==null)return;const k=[];for(let z=P;z<p.length;z++){const $=p[z];$&&k.push($.name||$.abbr||"anonymous")}a.text=k.join(`
`)}__getLimit(a,p,v){let C=null;const P=this.__getMax(v);return v!=null&&P<a?C=P-1:p&&p<a&&(C=p),Math.min(C,this.__calculateAvatarsFitWidth())}__getMax(a){return Math.max(a,MINIMUM_DISPLAYED_AVATARS)}__itemsChanged(a,p){this.__setItemsInView();let v=[],C=[];const P=Array.isArray(a),k=Array.isArray(p);k&&(C=p.filter(z=>P&&!a.includes(z))),P&&(v=a.filter(z=>k&&!p.includes(z))),this.__announceItemsChange(v,C)}__announceItemsChange(a,p){let v=[],C=[];a&&(v=a.map(k=>this.__getMessage(k,this.__effectiveI18n.joined||"{user} joined"))),p&&(C=p.map(k=>this.__getMessage(k,this.__effectiveI18n.left||"{user} left")));const P=C.concat(v);P.length>0&&announce(P.join(", "))}__i18nItemsChanged(a,p){if(a&&a.activeUsers){const v=Array.isArray(p)?p.length:0,C=v===1?"one":"many";a.activeUsers[C]&&this.setAttribute("aria-label",a.activeUsers[C].replace("{count}",v||0)),this._avatars.forEach(P=>{P.i18n=a})}}__openedChanged(a,p){p&&(a?(this._menuElement||(this._menuElement=this.$.overlay.querySelector("vaadin-avatar-group-menu")),this._openedWithFocusRing=p.hasAttribute("focus-ring")):this.__oldOpened&&p.focus({focusVisible:this._openedWithFocusRing}),p.setAttribute("aria-expanded",a===!0),this.__oldOpened=a)}__overflowItemsChanged(a,p){(a||p)&&this.$.overlay.requestContentUpdate()}__setItemsInView(){const a=this._avatars,p=this.items;if(!p||!a||a.length<3)return;let v=this.__calculateAvatarsFitWidth();v===p.length-1&&(v=p.length),v>=p.length&&this._opened&&(this.$.overlay.close(),this.$.overlay._flushAnimation("closing")),this.__itemsInView=v}__calculateAvatarsFitWidth(){if(!this.shadowRoot||this._avatars.length<MINIMUM_DISPLAYED_AVATARS)return MINIMUM_DISPLAYED_AVATARS;const a=this._avatars,p=a[0].clientWidth,{marginLeft:v,marginRight:C}=getComputedStyle(a[1]),P=this.__isRTL?parseInt(C,0)-parseInt(v,0):parseInt(v,0)-parseInt(C,0);return Math.floor((this.$.container.offsetWidth-p)/(p+P))}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarGroupStyles=i`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    --vaadin-avatar-group-overlap: 8px;
    --vaadin-avatar-group-overlap-border: 2px;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar:not(:first-child)) {
    -webkit-mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    -webkit-mask-size: calc(
      300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
    );
    mask-size: calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6);
  }

  ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-child)) {
    margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
    -webkit-mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
    mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
  }

  ::slotted(vaadin-avatar[dir='rtl']:not(:first-child)) {
    margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
    -webkit-mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
    mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group",avatarGroupStyles,{moduleId:"vaadin-avatar-group-styles"});class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        opened="{{_opened}}"
        position-target="[[_overflow]]"
        no-vertical-overlap
        on-vaadin-overlay-close="_onVaadinOverlayClose"
        on-vaadin-overlay-open="_onVaadinOverlayOpen"
      ></vaadin-avatar-group-overlay>
    `}static get is(){return"vaadin-avatar-group"}}defineCustomElement(AvatarGroup);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const CLASSES={SMALL:"small",MEDIUM:"medium",LARGE:"large"},BoardRowMixin=g=>class extends ResizeMixin(g){constructor(){super(),this._oldWidth=0,this._oldBreakpoints={smallSize:600,mediumSize:960},this._oldFlexBasis=[]}ready(){super.ready(),this.$.insertionPoint.addEventListener("slotchange",()=>this.redraw())}connectedCallback(){super.connectedCallback(),this._onResize()}_addStyleNames(a,p){a<p.smallSize?(this.classList.add(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):a<p.mediumSize?(this.classList.remove(CLASSES.SMALL),this.classList.add(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):(this.classList.remove(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.add(CLASSES.LARGE))}_calculateFlexBasis(a,p,v,C){p<C.smallSize?v=1:p<C.mediumSize&&v===4&&(v=2);let P=a/v*100;return P=P>100?100:P,`${P}%`}_reportError(){console.warn("The column configuration is not valid; column count should add up to 3 or 4.",`check: \r
${this.outerHTML}`)}_parseBoardCols(a){const p=a.map(P=>P.getAttribute("board-cols")?parseInt(P.getAttribute("board-cols")):1);let v=4,C=[];return a.forEach((P,k)=>{v-=p[k]}),v<0?(this._reportError(),p.forEach((P,k)=>{C[k]=1})):C=p.slice(0),C}_removeExtraNodesFromDOM(a,p){let v=!1,C=4;const P=[];return p.forEach((k,z)=>{C-=a[z],C<0?(v||(v=!0,this._reportError()),this.removeChild(k)):P[z]=k}),P}redraw(){this._recalculateFlexBasis(!0)}_onResize(){this._recalculateFlexBasis(!1)}_recalculateFlexBasis(a){const p=this.getBoundingClientRect().width,v=this._measureBreakpointsInPx();if(a||this._shouldRecalculate(p,v)){const P=this.$.insertionPoint.assignedNodes({flatten:!0}).filter($=>$.nodeType===Node.ELEMENT_NODE);this._addStyleNames(p,v);const k=this._parseBoardCols(P),z=k.reduce(($,D)=>$+D,0);this._removeExtraNodesFromDOM(k,P).forEach(($,D)=>{const F=this._calculateFlexBasis(k[D],p,z,v);(a||!this._oldFlexBasis[D]||this._oldFlexBasis[D]!==F)&&(this._oldFlexBasis[D]=F,$.style.flexBasis=F)}),this._oldWidth=p,this._oldBreakpoints=v}}_shouldRecalculate(a,p){return isElementHidden(this)?!1:a!==this._oldWidth||p.smallSize!==this._oldBreakpoints.smallSize||p.mediumSize!==this._oldBreakpoints.mediumSize}_measureBreakpointsInPx(){const a={},p="background-position",v=getComputedStyle(this).getPropertyValue("--small-size"),C=getComputedStyle(this).getPropertyValue("--medium-size");return this.style.setProperty(p,v),a.smallSize=parseFloat(getComputedStyle(this).getPropertyValue(p)),this.style.setProperty(p,C),a.mediumSize=parseFloat(getComputedStyle(this).getPropertyValue(p)),this.style.removeProperty(p),a}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class BoardRow extends BoardRowMixin(ElementMixin(PolymerElement)){static get template(){return html$3`
      <style>
        :host {
          display: flex;
          flex-flow: row wrap;
          align-items: stretch;
          --small-size: var(--vaadin-board-width-small, 600px);
          --medium-size: var(--vaadin-board-width-medium, 960px);
        }

        :host([hidden]) {
          display: none !important;
        }

        :host ::slotted(*) {
          box-sizing: border-box;
          flex-grow: 1;
          overflow: hidden;
        }
      </style>
      <slot id="insertionPoint"></slot>
    `}static get is(){return"vaadin-board-row"}}defineCustomElement(BoardRow);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class Board extends ElementMixin(PolymerElement){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-board"}static get cvdlName(){return"vaadin-board"}redraw(){[...this.querySelectorAll("*")].filter(d=>d instanceof BoardRow).forEach(d=>d.redraw())}}defineCustomElement(Board);const cardProps=i`
  html {
    --vaadin-card-background: var(--lumo-contrast-5pct);
    --vaadin-card-border-radius: var(--lumo-border-radius-l);
    --vaadin-card-border-width: 0;
    --vaadin-card-border-color: var(--lumo-contrast-20pct);
    --vaadin-card-padding: var(--lumo-space-m);
    --vaadin-card-gap: var(--lumo-space-m);
    --vaadin-card-shadow: none;
  }
`;addGlobalThemeStyles("card-props",cardProps);const card=i`
  :host {
    background: var(--vaadin-card-background);
    border-radius: var(--vaadin-card-border-radius);
    box-shadow: var(--vaadin-card-shadow);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but rounded outlines only work since Safari 16.4 */
  :host::before {
    content: '';
    position: absolute;
    inset: var(--_card-border-inset, 0);
    border-radius: var(--_card-border-pseudo-radius, inherit);
    border: var(--vaadin-card-border, var(--vaadin-card-border-width) solid var(--vaadin-card-border-color));
    pointer-events: none;
  }

  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
    --vaadin-card-background: var(--lumo-base-color);
  }

  :host([theme~='elevated']) {
    --vaadin-card-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color);
    --vaadin-card-shadow: var(--lumo-box-shadow-xs);
    --vaadin-card-border-width: 1px;
    --_card-border-inset: calc(-1 * var(--vaadin-card-border-width));
    --_card-border-pseudo-radius: calc(var(--vaadin-card-border-radius) + var(--vaadin-card-border-width));
  }

  :host([theme~='elevated']:not([theme~='outlined'])) {
    --vaadin-card-border-color: var(--lumo-contrast-10pct);
  }

  :host(:where([theme~='stretch-media'])) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: var(--lumo-border-radius-m);
  }

  ::slotted([slot='title']) {
    font-size: var(--lumo-font-size-l);
    line-height: var(--lumo-line-height-xs);
    font-weight: 600;
    color: var(--lumo-header-text-color);
  }

  ::slotted([slot='subtitle']) {
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-card",card,{moduleId:"lumo-card"});/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Card extends ElementMixin(ThemableMixin(PolylitMixin(i$1))){static get is(){return"vaadin-card"}static get styles(){return i`
      :host {
        display: flex;
        flex-direction: column;
        box-sizing: border-box;
        padding: var(--_padding);
        gap: var(--_gap);
        --_padding: var(--vaadin-card-padding, 1em);
        --_gap: var(--vaadin-card-gap, 1em);
        --_media: 0;
        --_title: 0;
        --_subtitle: 0;
        --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
        --_header-prefix: 0;
        --_header-suffix: 0;
        --_content: 0;
        --_footer: 0;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host(:not([theme~='horizontal'])) {
        justify-content: space-between;
      }

      :host([_m]) {
        --_media: 1;
      }

      :host([_t]) {
        --_title: 1;
      }

      :host([_st]) {
        --_subtitle: 1;
      }

      :host([_h]) {
        --_header: 1;
        --_title: 0;
        --_subtitle: 0;
      }

      :host([_hp]) {
        --_header-prefix: 1;
      }

      :host([_hs]) {
        --_header-suffix: 1;
      }

      :host([_c]) {
        --_content: 1;
      }

      :host([_f]) {
        --_footer: 1;
      }

      [part='media'],
      [part='header'],
      [part='content'],
      [part='footer'] {
        display: none;
      }

      :host([_m]) [part='media'],
      :host([_c]) [part='content'] {
        display: block;
      }

      :host([_f]) [part='footer'] {
        display: flex;
        gap: var(--_gap);
      }

      :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
        display: grid;
        align-items: center;
        gap: var(--_gap);
        row-gap: 0;
      }

      [part='header'] {
        margin-bottom: auto;
      }

      :host([_hs]) [part='header'] {
        grid-template-columns: 1fr auto;
      }

      :host([_hp]) [part='header'] {
        grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
      }

      slot {
        border-radius: inherit;
      }

      ::slotted([slot='header-prefix']) {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      ::slotted([slot='header']),
      ::slotted([slot='title']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: 1;
      }

      ::slotted([slot='subtitle']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: calc(1 + var(--_title));
      }

      ::slotted([slot='header-suffix']) {
        grid-column: calc(2 + var(--_header-prefix));
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      /* Horizontal */
      :host([theme~='horizontal']) {
        display: grid;
        grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
        align-items: start;
      }

      :host([theme~='horizontal'][_f]) {
        grid-template-rows: 1fr auto;
      }

      :host([theme~='horizontal'][_c]) {
        grid-template-rows: repeat(var(--_header), auto) 1fr;
      }

      [part='media'] {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
        align-self: stretch;
        border-radius: inherit;
      }

      [part='header'] {
        grid-column: calc(1 + var(--_media));
        grid-row: 1;
      }

      [part='content'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header));
        flex: auto;
        min-height: 0;
      }

      [part='footer'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header) + var(--_content));
        border-radius: inherit;
      }

      :host([theme~='horizontal']) [part='footer'] {
        align-self: end;
      }

      :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
        max-width: 100%;
      }

      ::slotted([slot='media']) {
        vertical-align: middle;
      }

      :host(:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        width: 100%;
        height: auto;
        aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
        object-fit: cover;
        /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
        overflow: hidden;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
        grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        height: 100%;
        aspect-ratio: auto;
      }

      :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-top: calc(var(--_padding) * -1);
        margin-inline: calc(var(--_padding) * -1);
        width: calc(100% + var(--_padding) * 2);
        max-width: none;
        border-radius: inherit;
        border-end-end-radius: 0;
        border-end-start-radius: 0;
      }

      :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-inline-end: 0;
        width: calc(100% + var(--_padding));
        height: calc(100% + var(--_padding) * 2);
        border-radius: inherit;
        border-start-end-radius: 0;
        border-end-end-radius: 0;
      }

      /* Scroller in content */
      [part='content'] ::slotted(vaadin-scroller) {
        margin-inline: calc(var(--_padding) * -1);
        padding-inline: var(--_padding);
      }

      [part='content'] ::slotted(vaadin-scroller)::before,
      [part='content'] ::slotted(vaadin-scroller)::after {
        margin-inline: calc(var(--_padding) * -1);
      }
    `}static get properties(){return{cardTitle:{type:String,observer:"__cardTitleChanged"},titleHeadingLevel:{type:Number,reflectToAttribute:!0,observer:"__titleHeadingLevelChanged"}}}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","region")}render(){return x`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `}firstUpdated(){super.firstUpdated(),this._onSlotChange()}_onSlotChange(){this.toggleAttribute("_m",this.querySelector(':scope > [slot="media"]')),this.toggleAttribute("_h",this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_t",this.querySelector(':scope > [slot="title"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_st",this.querySelector(':scope > [slot="subtitle"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_hp",this.querySelector(':scope > [slot="header-prefix"]')),this.toggleAttribute("_hs",this.querySelector(':scope > [slot="header-suffix"]')),this.toggleAttribute("_c",this.querySelector(":scope > :not([slot])")),this.toggleAttribute("_f",this.querySelector(':scope > [slot="footer"]')),this.__getCustomTitleElement()&&this.__clearStringTitle()}__clearStringTitle(){const d=this.__getStringTitleElement();d&&this.removeChild(d);const a=this.getAttribute("aria-labelledby");a&&a.startsWith("card-title-")&&this.removeAttribute("aria-labelledby"),this.cardTitle&&(this.cardTitle="")}__getCustomTitleElement(){return Array.from(this.querySelectorAll('[slot="title"]')).find(d=>!d.hasAttribute("card-string-title"))}__cardTitleChanged(d){if(!d){this.__clearStringTitle();return}const a=this.__getCustomTitleElement();a&&this.removeChild(a);let p=this.__getStringTitleElement();p||(p=this.__createStringTitleElement(),this.appendChild(p),this.setAttribute("aria-labelledby",p.id)),p.textContent=d}__createStringTitleElement(){const d=document.createElement("div");return d.setAttribute("slot","title"),d.setAttribute("role","heading"),this.__setTitleHeadingLevel(d,this.titleHeadingLevel),d.setAttribute("card-string-title",""),d.id=`card-title-${generateUniqueId()}`,d}__titleHeadingLevelChanged(d){const a=this.__getStringTitleElement();a&&this.__setTitleHeadingLevel(a,d)}__setTitleHeadingLevel(d,a){d.setAttribute("aria-level",a||2)}__getStringTitleElement(){return this.querySelector('[slot="title"][card-string-title]')}createRenderRoot(){const d=super.createRenderRoot();return d.addEventListener("slotchange",()=>this._onSlotChange()),d}}defineCustomElement(Card);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* Workaround for https://github.com/highcharts/highcharts/issues/22490 */
  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles$1("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles$1("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}function deepMerge(g,d){const a=p=>p&&typeof p=="object"&&!Array.isArray(p);return a(d)&&a(g)&&Object.keys(d).forEach(p=>{a(d[p])?(g[p]||Object.assign(g,{[p]:{}}),deepMerge(g[p],d[p])):Object.assign(g,{[p]:d[p]})}),g}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const ChartSeriesMixin=g=>class extends g{static get properties(){return{values:{type:Array,value:()=>[],sync:!0},valueMin:{type:Number,reflectToAttribute:!0,sync:!0},valueMax:{type:Number,reflectToAttribute:!0,sync:!0},type:{type:String,reflectToAttribute:!0,sync:!0},title:{type:String,reflectToAttribute:!0,sync:!0},markers:{type:String,reflectToAttribute:!0,sync:!0},unit:{type:String,reflectToAttribute:!0,sync:!0},stack:{type:String,reflectToAttribute:!0,sync:!0},neckPosition:{type:String,reflectToAttribute:!0,sync:!0},neckWidth:{type:String,reflectToAttribute:!0,sync:!0},options:{type:Object,sync:!0},additionalOptions:{type:Object,reflectToAttribute:!0,sync:!0},_series:{type:Object,sync:!0}}}static get observers(){return["__additionalOptionsObserver(additionalOptions, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values, _series)"]}get options(){const d=deepMerge({},this.additionalOptions);return this.type&&(d.type=this.type),this.title&&(d.name=this.title),this.values&&(d.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),d.marker=this.__markersConfiguration),this.unit&&(d.yAxis=this.unit),this.stack&&(d.stack=this.stack),isFinite(this.valueMin)&&(d.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(d.yAxisValueMax=this.valueMax),this.neckWidth&&(d.neckWidth=this.neckWidth),this.neckPosition&&(d.neckHeight=this.neckPosition),d}get __markersConfiguration(){const d={};switch(this.markers){case"shown":d.enabled=!0;break;case"hidden":d.enabled=!1;break;case"auto":default:d.enabled=null;break}return d}setSeries(d){this._series=d}__valuesObserver(d,a){a&&a.setData(d)}__additionalOptionsObserver(d,a){a&&d&&a.update(d)}__updateAxis(d,a,p){if(!isFinite(a)){this.__showWarn(`value-${p}`,"Numbers or null");return}d&&d.yAxis&&d.yAxis.update({[p]:a})}__valueMinObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"min")}__valueMaxObserver(d,a){d===void 0||a==null||this.__updateAxis(a,d,"max")}__typeObserver(d,a){d&&a&&a.update({type:d})}__titleObserver(d,a){d===void 0||a==null||a.update({name:d})}__stackObserver(d,a){d===void 0||a==null||a.update({stack:d})}__neckPositionObserver(d,a){d===void 0||a==null||a.update({neckHeight:d})}__neckWidthObserver(d,a){d===void 0||a==null||a.update({neckWidth:d})}__unitObserver(d,a,p,v){if(v&&d!==this.__oldUnit){const C=customElements.get("vaadin-chart");this.__oldUnit=d;const P=this.parentNode instanceof C&&this.parentNode;if(P&&P instanceof C){if(d&&!P.__getAxis(d)){const k={title:{text:d}};P.__addAxis({id:d,axisGenerated:!0,...k})}v.update({yAxis:d||0}),a!==void 0&&this.__updateAxis(v,a,"min"),p!==void 0&&this.__updateAxis(v,p,"max"),P.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(d,a){if(!(d===void 0||a==null)){if(!this.__isMarkersValid()){this.markers="auto";return}a.update({marker:this.__markersConfiguration})}}__showWarn(d,a){console.warn(`<vaadin-chart-series> Acceptable values for "${d}" are ${a}`)}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends ChartSeriesMixin(PolymerElement){static get is(){return"vaadin-chart-series"}}defineCustomElement(ChartSeries);var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(g){g.SVG_NS="http://www.w3.org/2000/svg",g.product="Highcharts",g.version="9.2.2",g.win=w,g.doc=g.win.document,g.svg=g.doc&&g.doc.createElementNS&&!!g.doc.createElementNS(g.SVG_NS,"svg").createSVGRect,g.userAgent=g.win.navigator&&g.win.navigator.userAgent||"",g.isChrome=g.userAgent.indexOf("Chrome")!==-1,g.isFirefox=g.userAgent.indexOf("Firefox")!==-1,g.isMS=/(edge|msie|trident)/i.test(g.userAgent)&&!g.win.opera,g.isSafari=!g.isChrome&&g.userAgent.indexOf("Safari")!==-1,g.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(g.userAgent),g.isWebKit=g.userAgent.indexOf("AppleWebKit")!==-1,g.deg2rad=Math.PI*2/360,g.hasBidiBug=g.isFirefox&&parseInt(g.userAgent.split("Firefox/")[1],10)<4,g.hasTouch=!!g.win.TouchEvent,g.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],g.noop=function(){},g.supportsPassiveEvents=(function(){var d=!1;if(!g.isMS){var a=Object.defineProperty({},"passive",{get:function(){d=!0}});g.win.addEventListener&&g.win.removeEventListener&&(g.win.addEventListener("testPassive",g.noop,a),g.win.removeEventListener("testPassive",g.noop,a))}return d})(),g.charts=[],g.dateFormats={},g.seriesTypes={},g.symbolSizes={},g.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$c(g,d,a,p){var v=d?"Highcharts error":"Highcharts warning";g===32&&(g=v+": Deprecated member");var C=isNumber$X(g),P=C?v+" #"+g+": www.highcharts.com/errors/"+g+"/":g.toString(),k=function(){if(d)throw new Error(P);win$g.console&&error$c.messages.indexOf(P)===-1&&console.warn(P)};if(typeof p<"u"){var z="";C&&(P+="?"),objectEach$D(p,function($,D){z+=`
 - `+D+": "+$,C&&(P+=encodeURI(D)+"="+encodeURI($))}),P+=z}fireEvent$C(H,"displayError",{chart:a,code:g,message:P,params:p},k),error$c.messages.push(P)}(function(g){g.messages=[]})(error$c||(error$c={}));function merge$1x(){var g,d=arguments,a={},p=function(C,P){return typeof C!="object"&&(C={}),objectEach$D(P,function(k,z){z==="__proto__"||z==="constructor"||(isObject$i(k,!0)&&!isClass(k)&&!isDOMElement(k)?C[z]=p(C[z]||{},k):C[z]=P[z])}),C};d[0]===!0&&(a=d[1],d=Array.prototype.slice.call(d,2));var v=d.length;for(g=0;g<v;g++)a=p(a,d[g]);return a}function clamp$l(g,d,a){return g>d?g<a?g:a:d}function cleanRecursively$2(g,d){var a={};return objectEach$D(g,function(p,v){var C;isObject$i(g[v],!0)&&!g.nodeType&&d[v]?(C=cleanRecursively$2(g[v],d[v]),Object.keys(C).length&&(a[v]=C)):(isObject$i(g[v])||g[v]!==d[v])&&(a[v]=g[v])}),a}function pInt$a(g,d){return parseInt(g,d||10)}function isString$d(g){return typeof g=="string"}function isArray$q(g){var d=Object.prototype.toString.call(g);return d==="[object Array]"||d==="[object Array Iterator]"}function isObject$i(g,d){return!!g&&typeof g=="object"&&(!d||!isArray$q(g))}function isDOMElement(g){return isObject$i(g)&&typeof g.nodeType=="number"}function isClass(g){var d=g&&g.constructor;return!!(isObject$i(g,!0)&&!isDOMElement(g)&&d&&d.name&&d.name!=="Object")}function isNumber$X(g){return typeof g=="number"&&!isNaN(g)&&g<1/0&&g>-1/0}function erase$a(g,d){for(var a=g.length;a--;)if(g[a]===d){g.splice(a,1);break}}function defined$_(g){return typeof g<"u"&&g!==null}function attr$8(g,d,a){var p;return isString$d(d)?defined$_(a)?g.setAttribute(d,a):g&&g.getAttribute&&(p=g.getAttribute(d),!p&&d==="class"&&(p=g.getAttribute(d+"Name"))):objectEach$D(d,function(v,C){g.setAttribute(C,v)}),p}function splat$l(g){return isArray$q(g)?g:[g]}function syncTimeout$9(g,d,a){return d>0?setTimeout(g,d,a):(g.call(0,a),-1)}function internalClearTimeout(g){defined$_(g)&&clearTimeout(g)}function extend$1y(g,d){var a;g||(g={});for(a in d)g[a]=d[a];return g}function pick$1K(){for(var g=arguments,d=g.length,a=0;a<d;a++){var p=g[a];if(typeof p<"u"&&p!==null)return p}}function css$d(g,d){H.isMS&&!H.svg&&d&&typeof d.opacity<"u"&&(d.filter="alpha(opacity="+d.opacity*100+")"),extend$1y(g.style,d)}function createElement$b(g,d,a,p,v){var C=doc$m.createElement(g);return d&&extend$1y(C,d),v&&css$d(C,{padding:"0",border:"none",margin:"0"}),a&&css$d(C,a),p&&p.appendChild(C),C}function extendClass$2(g,d){var a=(function(){});return a.prototype=new g,extend$1y(a.prototype,d),a}function pad$2(g,d,a){return new Array((d||2)+1-String(g).replace("-","").length).join(a||"0")+g}function relativeLength$a(g,d,a){return/%$/.test(g)?d*parseFloat(g)/100+(a||0):parseFloat(g)}function wrap$h(g,d,a){var p=g[d];g[d]=function(){var v=Array.prototype.slice.call(arguments),C=arguments,P=this;P.proceed=function(){p.apply(P,arguments.length?arguments:C)},v.unshift(p);var k=a.apply(this,v);return P.proceed=null,k}}function getMagnitude$3(g){return Math.pow(10,Math.floor(Math.log(g)/Math.LN10))}function normalizeTickInterval$3(g,d,a,p,v){var C,P=g;a=pick$1K(a,1);var k=g/a;for(d||(d=v?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],p===!1&&(a===1?d=d.filter(function(z){return z%1===0}):a<=.1&&(d=[1/a]))),C=0;C<d.length&&(P=d[C],!(v&&P*a>=g||!v&&k<=(d[C]+(d[C+1]||d[C]))/2));C++);return P=correctFloat$d(P*a,-Math.round(Math.log(.001)/Math.LN10)),P}function stableSort$7(g,d){var a=g.length,p,v;for(v=0;v<a;v++)g[v].safeI=v;for(g.sort(function(C,P){return p=d(C,P),p===0?C.safeI-P.safeI:p}),v=0;v<a;v++)delete g[v].safeI}function arrayMin$9(g){for(var d=g.length,a=g[0];d--;)g[d]<a&&(a=g[d]);return a}function arrayMax$a(g){for(var d=g.length,a=g[0];d--;)g[d]>a&&(a=g[d]);return a}function destroyObjectProperties$a(g,d){objectEach$D(g,function(a,p){a&&a!==d&&a.destroy&&a.destroy(),delete g[p]})}function discardElement$7(g){garbageBin||(garbageBin=createElement$b("div")),g&&garbageBin.appendChild(g),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(g,d){return parseFloat(g.toPrecision(d||14))}var timeUnits$4={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:168*36e5,month:672*36e5,year:364*24*36e5};Math.easeInOutSine=function(g){return-.5*(Math.cos(Math.PI*g)-1)};function getNestedProperty$3(g,d){for(var a=g.split(".");a.length&&defined$_(d);){var p=a.shift();if(typeof p>"u"||p==="__proto__")return;var v=d[p];if(!defined$_(v)||typeof v=="function"||typeof v.nodeType=="number"||v===win$g)return;d=v}return d}function getStyle$2(g,d,a){var p=H.getStyle||getStyle$2,v;if(d==="width"){var C=Math.min(g.offsetWidth,g.scrollWidth),P=g.getBoundingClientRect&&g.getBoundingClientRect().width;return P<C&&P>=C-1&&(C=Math.floor(P)),Math.max(0,C-(p(g,"padding-left",!0)||0)-(p(g,"padding-right",!0)||0))}if(d==="height")return Math.max(0,Math.min(g.offsetHeight,g.scrollHeight)-(p(g,"padding-top",!0)||0)-(p(g,"padding-bottom",!0)||0));win$g.getComputedStyle||error$c(27,!0);var k=win$g.getComputedStyle(g,void 0);return k&&(v=k.getPropertyValue(d),pick$1K(a,d!=="opacity")&&(v=pInt$a(v))),v}function inArray(g,d,a){return error$c(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),d.indexOf(g,a)}var find$l=Array.prototype.find?function(g,d){return g.find(d)}:(function(g,d){var a,p=g.length;for(a=0;a<p;a++)if(d(g[a],a))return g[a]});function keys(g){return error$c(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(g)}function offset$1(g){var d=doc$m.documentElement,a=g.parentElement||g.parentNode?g.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:a.top+(win$g.pageYOffset||d.scrollTop)-(d.clientTop||0),left:a.left+(win$g.pageXOffset||d.scrollLeft)-(d.clientLeft||0),width:a.width,height:a.height}}function objectEach$D(g,d,a){for(var p in g)Object.hasOwnProperty.call(g,p)&&d.call(a||g[p],g[p],p,g)}objectEach$D({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(g,d){H[d]=function(a){var p;return error$c(32,!1,void 0,(p={},p["Highcharts."+d]="use Array."+g,p)),Array.prototype[g].apply(a,[].slice.call(arguments,1))}});function addEvent$19(g,d,a,p){p===void 0&&(p={});var v=typeof g=="function"&&g.prototype||g;Object.hasOwnProperty.call(v,"hcEvents")||(v.hcEvents={});var C=v.hcEvents;H.Point&&g instanceof H.Point&&g.series&&g.series.chart&&(g.series.chart.runTrackerClick=!0);var P=g.addEventListener||H.addEventListenerPolyfill;P&&P.call(g,d,a,H.supportsPassiveEvents?{passive:p.passive===void 0?d.indexOf("touch")!==-1:p.passive,capture:!1}:!1),C[d]||(C[d]=[]);var k={fn:a,order:typeof p.order=="number"?p.order:1/0};return C[d].push(k),C[d].sort(function(z,$){return z.order-$.order}),function(){removeEvent$c(g,d,a)}}function removeEvent$c(g,d,a){function p(z,$){var D=g.removeEventListener||H.removeEventListenerPolyfill;D&&D.call(g,z,$,!1)}function v(z){var $,D;g.nodeName&&(d?($={},$[d]=!0):$=z,objectEach$D($,function(F,N){if(z[N])for(D=z[N].length;D--;)p(N,z[N][D].fn)}))}var C=typeof g=="function"&&g.prototype||g;if(Object.hasOwnProperty.call(C,"hcEvents")){var P=C.hcEvents;if(d){var k=P[d]||[];a?(P[d]=k.filter(function(z){return a!==z.fn}),p(d,a)):(v(P),P[d]=[])}else v(P),delete C.hcEvents}}function fireEvent$C(g,d,a,p){var v;if(a=a||{},doc$m.createEvent&&(g.dispatchEvent||g.fireEvent&&g!==H))v=doc$m.createEvent("Events"),v.initEvent(d,!0,!0),a=extend$1y(v,a),g.dispatchEvent?g.dispatchEvent(a):g.fireEvent(d,a);else if(g.hcEvents){a.target||extend$1y(a,{preventDefault:function(){a.defaultPrevented=!0},target:g,type:d});for(var C=[],P=g,k=!1;P.hcEvents;)Object.hasOwnProperty.call(P,"hcEvents")&&P.hcEvents[d]&&(C.length&&(k=!0),C.unshift.apply(C,P.hcEvents[d])),P=Object.getPrototypeOf(P);k&&C.sort(function(z,$){return z.order-$.order}),C.forEach(function(z){z.fn.call(g,a)===!1&&a.preventDefault()})}p&&!a.defaultPrevented&&p.call(g,a)}var serialMode,uniqueKey$8=(function(){var g=Math.random().toString(36).substring(2,9)+"-",d=0;return function(){return"highcharts-"+(serialMode?"":g)+d++}})();function useSerialIds(g){return serialMode=pick$1K(g,serialMode)}function isFunction$5(g){return typeof g=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var g=[].slice.call(arguments);if(this[0])return g[0]?(new H[isString$d(g[0])?g.shift():"Chart"](this[0],g[0],g[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$19,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$l,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$_,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$a,error:error$c,extend:extend$1y,extendClass:extendClass$2,find:find$l,fireEvent:fireEvent$C,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$q,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$X,isObject:isObject$i,isString:isString$d,keys,merge:merge$1x,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$D,offset:offset$1,pad:pad$2,pick:pick$1K,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$l,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$4,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$h},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$W=Utilities.isNumber,merge$1w=Utilities.merge,pInt$9=Utilities.pInt,Color=(function(){function g(d){this.rgba=[NaN,NaN,NaN,NaN],this.input=d;var a=H.Color;if(a&&a!==g)return new a(d);if(!(this instanceof g))return new g(d);this.init(d)}return g.parse=function(d){return d?new g(d):g.None},g.prototype.init=function(d){var a,p,v,C;if(typeof d=="object"&&typeof d.stops<"u")this.stops=d.stops.map(function(z){return new g(z[1])});else if(typeof d=="string"){if(this.input=d=g.names[d.toLowerCase()]||d,d.charAt(0)==="#"){var P=d.length,k=parseInt(d.substr(1),16);P===7?p=[(k&16711680)>>16,(k&65280)>>8,k&255,1]:P===4&&(p=[(k&3840)>>4|(k&3840)>>8,(k&240)>>4|k&240,(k&15)<<4|k&15,1])}if(!p)for(v=g.parsers.length;v--&&!p;)C=g.parsers[v],a=C.regex.exec(d),a&&(p=C.parse(a))}p&&(this.rgba=p)},g.prototype.get=function(d){var a=this.input,p=this.rgba;if(typeof a=="object"&&typeof this.stops<"u"){var v=merge$1w(a);return v.stops=[].slice.call(v.stops),this.stops.forEach(function(C,P){v.stops[P]=[v.stops[P][0],C.get(d)]}),v}return p&&isNumber$W(p[0])?d==="rgb"||!d&&p[3]===1?"rgb("+p[0]+","+p[1]+","+p[2]+")":d==="a"?""+p[3]:"rgba("+p.join(",")+")":a},g.prototype.brighten=function(d){var a=this.rgba;if(this.stops)this.stops.forEach(function(v){v.brighten(d)});else if(isNumber$W(d)&&d!==0)for(var p=0;p<3;p++)a[p]+=pInt$9(d*255),a[p]<0&&(a[p]=0),a[p]>255&&(a[p]=255);return this},g.prototype.setOpacity=function(d){return this.rgba[3]=d,this},g.prototype.tweenTo=function(d,a){var p=this.rgba,v=d.rgba;if(!isNumber$W(p[0])||!isNumber$W(v[0]))return d.input||"none";var C=v[3]!==1||p[3]!==1;return(C?"rgba(":"rgb(")+Math.round(v[0]+(p[0]-v[0])*(1-a))+","+Math.round(v[1]+(p[1]-v[1])*(1-a))+","+Math.round(v[2]+(p[2]-v[2])*(1-a))+(C?","+(v[3]+(p[3]-v[3])*(1-a)):"")+")"},g.names={white:"#ffffff",black:"#000000"},g.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),parseFloat(d[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(d){return[pInt$9(d[1]),pInt$9(d[2]),pInt$9(d[3]),1]}}],g.None=new g(""),g})(),win$f=H.win,defined$Z=Utilities.defined,error$b=Utilities.error,extend$1x=Utilities.extend,isObject$h=Utilities.isObject,merge$1v=Utilities.merge,objectEach$C=Utilities.objectEach,pad$1=Utilities.pad,pick$1J=Utilities.pick,splat$k=Utilities.splat,timeUnits$3=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=(function(){function g(d){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(d)}return g.prototype.get=function(d,a){if(this.variableTimezone||this.timezoneOffset){var p=a.getTime(),v=p-this.getTimezoneOffset(a);a.setTime(v);var C=a["getUTC"+d]();return a.setTime(p),C}return this.useUTC?a["getUTC"+d]():a["get"+d]()},g.prototype.set=function(d,a,p){if(this.variableTimezone||this.timezoneOffset){if(d==="Milliseconds"||d==="Seconds"||d==="Minutes"&&this.getTimezoneOffset(a)%36e5===0)return a["setUTC"+d](p);var v=this.getTimezoneOffset(a),C=a.getTime()-v;a.setTime(C),a["setUTC"+d](p);var P=this.getTimezoneOffset(a);return C=a.getTime()+P,a.setTime(C)}return this.useUTC||hasNewSafariBug&&d==="FullYear"?a["setUTC"+d](p):a["set"+d](p)},g.prototype.update=function(d){var a=pick$1J(d&&d.useUTC,!0);this.options=d=merge$1v(!0,this.options||{},d),this.Date=d.Date||win$f.Date||Date,this.useUTC=a,this.timezoneOffset=a&&d.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=a&&!!(d.getTimezoneOffset||d.timezone)},g.prototype.makeTime=function(d,a,p,v,C,P){var k,z,$;return this.useUTC?(k=this.Date.UTC.apply(0,arguments),z=this.getTimezoneOffset(k),k+=z,$=this.getTimezoneOffset(k),z!==$?k+=$-z:z-36e5===this.getTimezoneOffset(k-36e5)&&!hasOldSafariBug&&(k-=36e5)):k=new this.Date(d,a,pick$1J(p,1),pick$1J(v,0),pick$1J(C,0),pick$1J(P,0)).getTime(),k},g.prototype.timezoneOffsetFunction=function(){var d=this,a=this.options,p=a.moment||win$f.moment;if(!this.useUTC)return function(v){return new Date(v.toString()).getTimezoneOffset()*6e4};if(a.timezone)if(!p)error$b(25);else return function(v){return-p.tz(v,a.timezone).utcOffset()*6e4};return this.useUTC&&a.getTimezoneOffset?function(v){return a.getTimezoneOffset(v.valueOf())*6e4}:function(){return(d.timezoneOffset||0)*6e4}},g.prototype.dateFormat=function(d,a,p){if(!defined$Z(a)||isNaN(a))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";d=pick$1J(d,"%Y-%m-%d %H:%M:%S");var v=this,C=new this.Date(a),P=this.get("Hours",C),k=this.get("Day",C),z=this.get("Date",C),$=this.get("Month",C),D=this.get("FullYear",C),F=H.defaultOptions.lang,N=F&&F.weekdays,W=F&&F.shortWeekdays,j=extend$1x({a:W?W[k]:N[k].substr(0,3),A:N[k],d:pad$1(z),e:pad$1(z,2," "),w:k,b:F.shortMonths[$],B:F.months[$],m:pad$1($+1),o:$+1,y:D.toString().substr(2,2),Y:D,H:pad$1(P),k:P,I:pad$1(P%12||12),l:P%12||12,M:pad$1(this.get("Minutes",C)),p:P<12?"AM":"PM",P:P<12?"am":"pm",S:pad$1(C.getSeconds()),L:pad$1(Math.floor(a%1e3),3)},H.dateFormats);return objectEach$C(j,function(q,X){for(;d.indexOf("%"+X)!==-1;)d=d.replace("%"+X,typeof q=="function"?q.call(v,a):q)}),p?d.substr(0,1).toUpperCase()+d.substr(1):d},g.prototype.resolveDTLFormat=function(d){return isObject$h(d,!0)?d:(d=splat$k(d),{main:d[0],from:d[1],to:d[2]})},g.prototype.getTimeTicks=function(d,a,p,v){var C=this,P=C.Date,k=[],z={},$=new P(a),D=d.unitRange,F=d.count||1,N,W,j,q;if(v=pick$1J(v,1),defined$Z(a)){C.set("Milliseconds",$,D>=timeUnits$3.second?0:F*Math.floor(C.get("Milliseconds",$)/F)),D>=timeUnits$3.second&&C.set("Seconds",$,D>=timeUnits$3.minute?0:F*Math.floor(C.get("Seconds",$)/F)),D>=timeUnits$3.minute&&C.set("Minutes",$,D>=timeUnits$3.hour?0:F*Math.floor(C.get("Minutes",$)/F)),D>=timeUnits$3.hour&&C.set("Hours",$,D>=timeUnits$3.day?0:F*Math.floor(C.get("Hours",$)/F)),D>=timeUnits$3.day&&C.set("Date",$,D>=timeUnits$3.month?1:Math.max(1,F*Math.floor(C.get("Date",$)/F))),D>=timeUnits$3.month&&(C.set("Month",$,D>=timeUnits$3.year?0:F*Math.floor(C.get("Month",$)/F)),W=C.get("FullYear",$)),D>=timeUnits$3.year&&(W-=W%F,C.set("FullYear",$,W)),D===timeUnits$3.week&&(q=C.get("Day",$),C.set("Date",$,C.get("Date",$)-q+v+(q<v?-7:0))),W=C.get("FullYear",$);var X=C.get("Month",$),K=C.get("Date",$),ee=C.get("Hours",$);a=$.getTime(),(C.variableTimezone||!C.useUTC)&&defined$Z(p)&&(j=p-a>4*timeUnits$3.month||C.getTimezoneOffset(a)!==C.getTimezoneOffset(p));var te=$.getTime();for(N=1;te<p;)k.push(te),D===timeUnits$3.year?te=C.makeTime(W+N*F,0):D===timeUnits$3.month?te=C.makeTime(W,X+N*F):j&&(D===timeUnits$3.day||D===timeUnits$3.week)?te=C.makeTime(W,X,K+N*F*(D===timeUnits$3.day?1:7)):j&&D===timeUnits$3.hour&&F>1?te=C.makeTime(W,X,K,ee+N*F):te+=D*F,N++;k.push(te),D<=timeUnits$3.hour&&k.length<1e4&&k.forEach(function(ie){ie%18e5===0&&C.dateFormat("%H%M%S%L",ie)==="000000000"&&(z[ie]="day")})}return k.info=extend$1x(d,{higherRanks:z,totalRange:D*F}),k},g.prototype.getDateFormat=function(d,a,p,v){var C=this.dateFormat("%m-%d %H:%M:%S.%L",a),P="01-01 00:00:00.000",k={millisecond:15,second:12,minute:9,hour:6,day:3},z,$,D="millisecond";for($ in timeUnits$3){if(d===timeUnits$3.week&&+this.dateFormat("%w",a)===p&&C.substr(6)===P.substr(6)){$="week";break}if(timeUnits$3[$]>d){$=D;break}if(k[$]&&C.substr(k[$])!==P.substr(k[$]))break;$!=="week"&&(D=$)}return $&&(z=this.resolveDTLFormat(v[$]).main),z},g})(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$7=H.svg,merge$1u=Utilities.merge,defaultOptions$j={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$7,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$j.chart.styledMode=!1;var defaultTime$2=new Time(merge$1u(defaultOptions$j.global,defaultOptions$j.time));function getOptions$4(){return defaultOptions$j}function setOptions$2(g){return merge$1u(!0,defaultOptions$j,g),(g.time||g.global)&&(H.time?H.time.update(merge$1u(defaultOptions$j.global,defaultOptions$j.time,g.global,g.time)):H.time=defaultTime$2),defaultOptions$j}var DefaultOptions={defaultOptions:defaultOptions$j,defaultTime:defaultTime$2,getOptions:getOptions$4,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$V=Utilities.isNumber,objectEach$B=Utilities.objectEach,Fx=(function(){function g(d,a,p){this.pos=NaN,this.options=a,this.elem=d,this.prop=p}return g.prototype.dSetter=function(){var d=this.paths,a=d&&d[0],p=d&&d[1],v=this.now||0,C=[];if(v===1||!a||!p)C=this.toD||[];else if(a.length===p.length&&v<1)for(var P=0;P<p.length;P++){for(var k=a[P],z=p[P],$=[],D=0;D<z.length;D++){var F=k[D],N=z[D];isNumber$V(F)&&isNumber$V(N)&&!(z[0]==="A"&&(D===4||D===5))?$[D]=F+v*(N-F):$[D]=N}C.push($)}else C=p;this.elem.attr("d",C,void 0,!0)},g.prototype.update=function(){var d=this.elem,a=this.prop,p=this.now,v=this.options.step;this[a+"Setter"]?this[a+"Setter"]():d.attr?d.element&&d.attr(a,p,null,!0):d.style[a]=p+this.unit,v&&v.call(d,p,this)},g.prototype.run=function(d,a,p){var v=this,C=v.options,P=function($){return P.stopped?!1:v.step($)},k=win$e.requestAnimationFrame||function($){setTimeout($,13)},z=function(){for(var $=0;$<g.timers.length;$++)g.timers[$]()||g.timers.splice($--,1);g.timers.length&&k(z)};d===a&&!this.elem["forceAnimate:"+this.prop]?(delete C.curAnim[this.prop],C.complete&&Object.keys(C.curAnim).length===0&&C.complete.call(this.elem)):(this.startTime=+new Date,this.start=d,this.end=a,this.unit=p,this.now=this.start,this.pos=0,P.elem=this.elem,P.prop=this.prop,P()&&g.timers.push(P)===1&&k(z))},g.prototype.step=function(d){var a=+new Date,p=this.options,v=this.elem,C=p.complete,P=p.duration,k=p.curAnim,z,$;return v.attr&&!v.element?z=!1:d||a>=P+this.startTime?(this.now=this.end,this.pos=1,this.update(),k[this.prop]=!0,$=!0,objectEach$B(k,function(D){D!==!0&&($=!1)}),$&&C&&C.call(v),z=!1):(this.pos=p.easing((a-this.startTime)/P),this.now=this.start+(this.end-this.start)*this.pos,this.update(),z=!0),z},g.prototype.initPath=function(d,a,p){var v=d.startX,C=d.endX,P=p.slice(),k=d.isArea,z=k?2:1,$,D,F,N,W=a&&a.slice();if(!W)return[P,P];function j(X,K){for(;X.length<D;){var ee=X[0],te=K[D-X.length];if(te&&ee[0]==="M"&&(te[0]==="C"?X[0]=["C",ee[1],ee[2],ee[1],ee[2],ee[1],ee[2]]:X[0]=["L",ee[1],ee[2]]),X.unshift(ee),k){var ie=X.pop();X.push(X[X.length-1],ie)}}}function q(X,K){for(;X.length<D;){var ee=X[Math.floor(X.length/z)-1].slice();if(ee[0]==="C"&&(ee[1]=ee[5],ee[2]=ee[6]),!k)X.push(ee);else{var te=X[Math.floor(X.length/z)].slice();X.splice(X.length/2,0,ee,te)}}}if(v&&C&&C.length){for(F=0;F<v.length;F++)if(v[F]===C[0]){$=F;break}else if(v[0]===C[C.length-v.length+F]){$=F,N=!0;break}else if(v[v.length-1]===C[C.length-v.length+F]){$=v.length-F;break}typeof $>"u"&&(W=[])}return W.length&&isNumber$V($)&&(D=P.length+$*z,N?(j(W,P),q(P)):(j(P,W),q(W))),[W,P]},g.prototype.fillSetter=function(){g.prototype.strokeSetter.apply(this,arguments)},g.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},g.timers=[],g})(),defined$Y=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$p=Utilities.isArray,isNumber$U=Utilities.isNumber,isObject$g=Utilities.isObject,merge$1t=Utilities.merge,objectEach$A=Utilities.objectEach,pick$1I=Utilities.pick;function setAnimation$5(g,d){d.renderer.globalAnimation=pick$1I(g,d.options.chart.animation,!0)}function animObject$d(g){return isObject$g(g)?merge$1t({duration:500,defer:0},g):{duration:g?500:0,defer:0}}function getDeferredAnimation$3(g,d,a){var p=animObject$d(d),v=a?[a]:g.series,C=0,P=0;v.forEach(function(z){var $=animObject$d(z.options.animation);C=d&&defined$Y(d.defer)?p.defer:Math.max(C,$.duration+$.defer),P=Math.min(p.duration,$.duration)}),g.renderer.forExport&&(C=0);var k={defer:Math.max(0,C-P),duration:Math.min(C,P)};return k}function animate$2(g,d,a){var p,v="",C,P,k;isObject$g(a)||(k=arguments,a={duration:k[2],easing:k[3],complete:k[4]}),isNumber$U(a.duration)||(a.duration=400),a.easing=typeof a.easing=="function"?a.easing:Math[a.easing]||Math.easeInOutSine,a.curAnim=merge$1t(d),objectEach$A(d,function(z,$){stop$2(g,$),P=new Fx(g,a,$),C=void 0,$==="d"&&isArray$p(d.d)?(P.paths=P.initPath(g,g.pathArray,d.d),P.toD=d.d,p=0,C=1):g.attr?p=g.attr($):(p=parseFloat(getStyle$1(g,$))||0,$!=="opacity"&&(v="px")),C||(C=z),typeof C=="string"&&C.match("px")&&(C=C.replace(/px/g,"")),P.run(p,C,v)})}function stop$2(g,d){for(var a=Fx.timers.length;a--;)Fx.timers[a].elem===g&&(!d||d===Fx.timers[a].prop)&&(Fx.timers[a].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$d,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$a=Utilities.error,isString$c=Utilities.isString,objectEach$z=Utilities.objectEach,splat$j=Utilities.splat,hasValidDOMParser=(function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}})(),AST=(function(){function g(d){this.nodes=typeof d=="string"?this.parseMarkup(d):d}return g.filterUserAttributes=function(d){return objectEach$z(d,function(a,p){var v=!0;g.allowedAttributes.indexOf(p)===-1&&(v=!1),["background","dynsrc","href","lowsrc","src"].indexOf(p)!==-1&&(v=isString$c(a)&&g.allowedReferences.some(function(C){return a.indexOf(C)===0})),v||(error$a("Highcharts warning: Invalid attribute '"+p+"' in config"),delete d[p])}),d},g.setElementHTML=function(d,a){if(d.innerHTML="",a){var p=new g(a);p.addToDOM(d)}},g.prototype.addToDOM=function(d){function a(p,v){var C;return splat$j(p).forEach(function(P){var k=P.tagName,z=P.textContent?H.doc.createTextNode(P.textContent):void 0,$;if(k)if(k==="#text")$=z;else if(g.allowedTags.indexOf(k)!==-1){var D=k==="svg"?SVG_NS$3:v.namespaceURI||SVG_NS$3,F=H.doc.createElementNS(D,k),N=P.attributes||{};objectEach$z(P,function(W,j){j!=="tagName"&&j!=="attributes"&&j!=="children"&&j!=="textContent"&&(N[j]=W)}),attr$7(F,g.filterUserAttributes(N)),z&&F.appendChild(z),a(P.children||[],F),$=F}else error$a("Highcharts warning: Invalid tagName '"+k+"' in config");$&&v.appendChild($),C=$}),C}return a(this.nodes,d)},g.prototype.parseMarkup=function(d){var a=[];d=d.trim();var p,v;hasValidDOMParser?p=new DOMParser().parseFromString(d,"text/html"):(v=createElement$a("div"),v.innerHTML=d,p={body:v});var C=function(P,k){var z=P.nodeName.toLowerCase(),$={tagName:z};z==="#text"&&($.textContent=P.textContent||"");var D=P.attributes;if(D){var F={};[].forEach.call(D,function(W){F[W.name]=W.value}),$.attributes=F}if(P.childNodes.length){var N=[];[].forEach.call(P.childNodes,function(W){C(W,N)}),N.length&&($.children=N)}k.push($)};return[].forEach.call(p.body.childNodes,function(P){return C(P,a)}),v&&discardElement$6(v),a},g.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],g.allowedReferences=["https://","http://","mailto:","/","../","./","#"],g.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],g})(),defaultOptions$i=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$T=Utilities.isNumber,pick$1H=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(g,d,a){return defaultTime$1.dateFormat(g,d,a)}function format$e(g,d,a){for(var p="{",v=!1,C,P,k,z,$=/f$/,D=/\.([0-9])/,F=defaultOptions$i.lang,N=a&&a.time||defaultTime$1,W=a&&a.numberFormatter||numberFormat$2,j=[];g&&(z=g.indexOf(p),z!==-1);){if(C=g.slice(0,z),v){if(P=C.split(":"),k=getNestedProperty$2(P.shift()||"",d),P.length&&typeof k=="number")if(C=P.join(":"),$.test(C)){var q=parseInt((C.match(D)||["","-1"])[1],10);k!==null&&(k=W(k,q,F.decimalPoint,C.indexOf(",")>-1?F.thousandsSep:""))}else k=N.dateFormat(C,k);j.push(k)}else j.push(C);g=g.slice(z+1),v=!v,p=v?"}":"{"}return j.push(g),j.join("")}function numberFormat$2(g,d,a,p){g=+g||0,d=+d;var v,C,P=defaultOptions$i.lang,k=(g.toString().split(".")[1]||"").split("e")[0].length,z=g.toString().split("e"),$=d;d===-1?d=Math.min(k,20):isNumber$T(d)?d&&z[1]&&z[1]<0&&(C=d+ +z[1],C>=0?(z[0]=(+z[0]).toExponential(C).split("e")[0],d=C):(z[0]=z[0].split(".")[0]||0,d<20?g=(z[0]*Math.pow(10,z[1])).toFixed(d):g=0,z[1]=0)):d=2;var D=(Math.abs(z[1]?z[0]:g)+Math.pow(10,-Math.max(d,k)-1)).toFixed(d),F=String(pInt$8(D)),N=F.length>3?F.length%3:0;return a=pick$1H(a,P.decimalPoint),p=pick$1H(p,P.thousandsSep),v=g<0?"-":"",v+=N?F.substr(0,N)+p:"",+z[1]<0&&!$?v="0":v+=F.substr(N).replace(/(\d{3})(?=\d)/g,"$1"+p),d&&(v+=a+D.slice(-d)),z[1]&&+v!=0&&(v+="e"+z[1]),v}var FormatUtilities={dateFormat,format:format$e,numberFormat:numberFormat$2},clamp$k=Utilities.clamp,pick$1G=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(g){function d(a,p,v){var C=a,P=C.reducedLen||p,k=function(q,X){return(X.rank||0)-(q.rank||0)},z=function(q,X){return q.target-X.target},$,D=!0,F=[],N,W,j=0;for($=a.length;$--;)j+=a[$].size;if(j>P){for(stableSort$6(a,k),$=0,j=0;j<=P;)j+=a[$].size,$++;F=a.splice($-1,a.length)}for(stableSort$6(a,z),a=a.map(function(q){return{size:q.size,targets:[q.target],align:pick$1G(q.align,.5)}});D;){for($=a.length;$--;)N=a[$],W=(Math.min.apply(0,N.targets)+Math.max.apply(0,N.targets))/2,N.pos=clamp$k(W-N.size*N.align,0,p-N.size);for($=a.length,D=!1;$--;)$>0&&a[$-1].pos+a[$-1].size>a[$].pos&&(a[$-1].size+=a[$].size,a[$-1].targets=a[$-1].targets.concat(a[$].targets),a[$-1].align=.5,a[$-1].pos+a[$-1].size>p&&(a[$-1].pos=p-a[$-1].size),a.splice($,1),D=!0)}return C.push.apply(C,F),$=0,a.some(function(q){var X=0;return(q.targets||[]).some(function(){return C[$].pos=q.pos+X,typeof v<"u"&&Math.abs(C[$].pos-C[$].target)>v?(C.slice(0,$+1).forEach(function(K){return delete K.pos}),C.reducedLen=(C.reducedLen||p)-p*.1,C.reducedLen>p*.1&&d(C,p,v),!0):(X+=C[$].size,$++,!1)})}),stableSort$6(C,z),C}g.distribute=d})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$c=animationExports.animObject,stop$1=animationExports.stop,deg2rad$9=H.deg2rad,doc$l=H.doc,noop$k=H.noop,svg$6=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$18=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$X=Utilities.defined,erase$9=Utilities.erase,extend$1w=Utilities.extend,fireEvent$B=Utilities.fireEvent,isArray$o=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$S=Utilities.isNumber,isString$b=Utilities.isString,merge$1s=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1F=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=(function(){function g(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return g.prototype._defaultGetter=function(d){var a=pick$1F(this[d+"Value"],this[d],this.element?this.element.getAttribute(d):null,0);return/^[\-0-9\.]+$/.test(a)&&(a=parseFloat(a)),a},g.prototype._defaultSetter=function(d,a,p){p.setAttribute(a,d)},g.prototype.add=function(d){var a=this.renderer,p=this.element,v;return d&&(this.parentGroup=d),this.parentInverted=d&&d.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&a.buildText(this),this.added=!0,(!d||d.handleZ||this.zIndex)&&(v=this.zIndexSetter()),v||(d?d.element:a.box).appendChild(p),this.onAdd&&this.onAdd(),this},g.prototype.addClass=function(d,a){var p=a?"":this.attr("class")||"";return d=(d||"").split(/ /g).reduce(function(v,C){return p.indexOf(C)===-1&&v.push(C),v},p?[p]:[]).join(" "),d!==p&&this.attr("class",d),this},g.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},g.prototype.align=function(d,a,p){var v={},C=this.renderer,P=C.alignedObjects,k,z,$,D,F;d?(this.alignOptions=d,this.alignByTranslate=a,(!p||isString$b(p))&&(this.alignTo=$=p||"renderer",erase$9(P,this),P.push(this),p=void 0)):(d=this.alignOptions,a=this.alignByTranslate,$=this.alignTo),p=pick$1F(p,C[$],$==="scrollablePlotBox"?C.plotBox:void 0,C);var N=d.align,W=d.verticalAlign;return k=(p.x||0)+(d.x||0),z=(p.y||0)+(d.y||0),N==="right"?D=1:N==="center"&&(D=2),D&&(k+=(p.width-(d.width||0))/D),v[a?"translateX":"x"]=Math.round(k),W==="bottom"?F=1:W==="middle"&&(F=2),F&&(z+=(p.height-(d.height||0))/F),v[a?"translateY":"y"]=Math.round(z),this[this.placed?"animate":"attr"](v),this.placed=!0,this.alignAttr=v,this},g.prototype.alignSetter=function(d){var a={left:"start",center:"middle",right:"end"};a[d]&&(this.alignValue=d,this.element.setAttribute("text-anchor",a[d]))},g.prototype.animate=function(d,a,p){var v=this,C=animObject$c(pick$1F(a,this.renderer.globalAnimation,!0)),P=C.defer;return pick$1F(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(C.duration=0),C.duration!==0?(p&&(C.complete=p),syncTimeout$8(function(){v.element&&animate$1(v,d,C)},P)):(this.attr(d,void 0,p),objectEach$y(d,function(k,z){C.step&&C.step.call(this,k,{prop:z,pos:1,elem:this})},this)),this},g.prototype.applyTextOutline=function(d){var a=this.element,p=d.indexOf("contrast")!==-1;p&&(d=d.replace(/contrast/g,this.renderer.getContrast(a.style.fill)));var v=d.split(" "),C=v[v.length-1],P=v[0];if(P&&P!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,P=P.replace(/(^[\d\.]+)(.*?)$/g,function($,D,F){return 2*Number(D)+F}),this.removeTextOutline();var k=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(k,{class:"highcharts-text-outline",fill:C,stroke:C,"stroke-width":P,"stroke-linejoin":"round"}),[].forEach.call(a.childNodes,function($){var D=$.cloneNode(!0);D.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(F){return D.removeAttribute(F)}),k.appendChild(D)});var z=doc$l.createElementNS(SVG_NS$2,"tspan");z.textContent="​",["x","y"].forEach(function($){var D=a.getAttribute($);D&&z.setAttribute($,D)}),k.appendChild(z),a.insertBefore(k,a.firstChild)}},g.prototype.attr=function(d,a,p,v){var C=this.element,P=this.symbolCustomAttribs,k,z,$=this,D,F;return typeof d=="string"&&typeof a<"u"&&(k=d,d={},d[k]=a),typeof d=="string"?$=(this[d+"Getter"]||this._defaultGetter).call(this,d,C):(objectEach$y(d,function(W,j){D=!1,v||stop$1(this,j),this.symbolName&&P.indexOf(j)!==-1&&(z||(this.symbolAttr(d),z=!0),D=!0),this.rotation&&(j==="x"||j==="y")&&(this.doTransform=!0),D||(F=this[j+"Setter"]||this._defaultSetter,F.call(this,W,j,C),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(j)&&this.updateShadows(j,W,F))},this),this.afterSetters()),p&&p.call(this),$},g.prototype.clip=function(d){return this.attr("clip-path",d?"url("+this.renderer.url+"#"+d.id+")":"none")},g.prototype.crisp=function(d,a){var p=this;a=a||d.strokeWidth||0;var v=Math.round(a)%2/2;return d.x=Math.floor(d.x||p.x||0)+v,d.y=Math.floor(d.y||p.y||0)+v,d.width=Math.floor((d.width||p.width||0)-2*v),d.height=Math.floor((d.height||p.height||0)-2*v),defined$X(d.strokeWidth)&&(d.strokeWidth=a),d},g.prototype.complexColor=function(d,a,p){var v=this.renderer,C,P,k,z,$,D,F,N,W,j,q=[],X;fireEvent$B(this.renderer,"complexColor",{args:arguments},function(){if(d.radialGradient?P="radialGradient":d.linearGradient&&(P="linearGradient"),P){if(k=d[P],$=v.gradients,D=d.stops,W=p.radialReference,isArray$o(k)&&(d[P]=k={x1:k[0],y1:k[1],x2:k[2],y2:k[3],gradientUnits:"userSpaceOnUse"}),P==="radialGradient"&&W&&!defined$X(k.gradientUnits)&&(z=k,k=merge$1s(k,v.getRadialAttr(W,z),{gradientUnits:"userSpaceOnUse"})),objectEach$y(k,function(ee,te){te!=="id"&&q.push(te,ee)}),objectEach$y(D,function(ee){q.push(ee)}),q=q.join(","),$[q])j=$[q].attr("id");else{k.id=j=uniqueKey$7();var K=$[q]=v.createElement(P).attr(k).add(v.defs);K.radAttr=z,K.stops=[],D.forEach(function(ee){ee[1].indexOf("rgba")===0?(C=Color.parse(ee[1]),F=C.get("rgb"),N=C.get("a")):(F=ee[1],N=1);var te=v.createElement("stop").attr({offset:ee[0],"stop-color":F,"stop-opacity":N}).add(K);K.stops.push(te)})}X="url("+v.url+"#"+j+")",p.setAttribute(a,X),p.gradient=q,d.toString=function(){return X}}})},g.prototype.css=function(d){var a=this.styles,p={},v=this.element,C=["textOutline","textOverflow","width"],P,k="",z,$=!a;return d&&d.color&&(d.fill=d.color),a&&objectEach$y(d,function(D,F){a&&a[F]!==D&&(p[F]=D,$=!0)}),$&&(a&&(d=extend$1w(a,p)),d&&(d.width===null||d.width==="auto"?delete this.textWidth:v.nodeName.toLowerCase()==="text"&&d.width&&(P=this.textWidth=pInt$7(d.width))),this.styles=d,P&&!svg$6&&this.renderer.forExport&&delete d.width,v.namespaceURI===this.SVG_NS?(z=function(D,F){return"-"+F.toLowerCase()},objectEach$y(d,function(D,F){C.indexOf(F)===-1&&(k+=F.replace(/([A-Z])/g,z)+":"+D+";")}),k&&attr$6(v,"style",k)):css$c(v,d),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),d&&d.textOutline&&this.applyTextOutline(d.textOutline))),this},g.prototype.dashstyleSetter=function(d){var a,p=this["stroke-width"];if(p==="inherit"&&(p=1),d=d&&d.toLowerCase(),d){var v=d.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(a=v.length;a--;)v[a]=""+pInt$7(v[a])*pick$1F(p,NaN);d=v.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",d)}},g.prototype.destroy=function(){var d=this,a=d.element||{},p=d.renderer,v=a.ownerSVGElement,C=p.isSVG&&a.nodeName==="SPAN"&&d.parentGroup||void 0,P,k;if(a.onclick=a.onmouseout=a.onmouseover=a.onmousemove=a.point=null,stop$1(d),d.clipPath&&v){var z=d.clipPath;[].forEach.call(v.querySelectorAll("[clip-path],[CLIP-PATH]"),function($){$.getAttribute("clip-path").indexOf(z.element.id)>-1&&$.removeAttribute("clip-path")}),d.clipPath=z.destroy()}if(d.stops){for(k=0;k<d.stops.length;k++)d.stops[k].destroy();d.stops.length=0,d.stops=void 0}for(d.safeRemoveChild(a),p.styledMode||d.destroyShadows();C&&C.div&&C.div.childNodes.length===0;)P=C.parentGroup,d.safeRemoveChild(C.div),delete C.div,C=P;d.alignTo&&erase$9(p.alignedObjects,d),objectEach$y(d,function($,D){d[D]&&d[D].parentGroup===d&&d[D].destroy&&d[D].destroy(),delete d[D]})},g.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(d){this.safeRemoveChild(d)},this),this.shadows=void 0},g.prototype.destroyTextPath=function(d,a){var p=d.getElementsByTagName("text")[0],v;if(p){if(p.removeAttribute("dx"),p.removeAttribute("dy"),a.element.setAttribute("id",""),this.textPathWrapper&&p.getElementsByTagName("textPath").length){for(v=this.textPathWrapper.element.childNodes;v.length;)p.appendChild(v[0]);p.removeChild(this.textPathWrapper.element)}}else(d.getAttribute("dx")||d.getAttribute("dy"))&&(d.removeAttribute("dx"),d.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},g.prototype.dSetter=function(d,a,p){isArray$o(d)&&(typeof d[0]=="string"&&(d=this.renderer.pathToSegments(d)),this.pathArray=d,d=d.reduce(function(v,C,P){return!C||!C.join?(C||"").toString():(P?v+" ":"")+C.join(" ")},"")),/(NaN| {2}|^$)/.test(d)&&(d="M 0 0"),this[a]!==d&&(p.setAttribute(a,d),this[a]=d)},g.prototype.fadeOut=function(d){var a=this;a.animate({opacity:0},{duration:pick$1F(d,150),complete:function(){a.attr({y:-9999}).hide()}})},g.prototype.fillSetter=function(d,a,p){typeof d=="string"?p.setAttribute(a,d):d&&this.complexColor(d,a,p)},g.prototype.getBBox=function(d,a){var p=this,v=p.renderer,C=p.element,P=p.styles,k=p.textStr,z=v.cache,$=v.cacheKeys,D=C.namespaceURI===p.SVG_NS,F=pick$1F(a,p.rotation,0),N=v.styledMode?C&&g.prototype.getStyle.call(C,"font-size"):P&&P.fontSize,W,j,q,X,K;if(defined$X(k)&&(K=k.toString(),K.indexOf("<")===-1&&(K=K.replace(/[0-9]/g,"0")),K+=["",F,N,p.textWidth,P&&P.textOverflow,P&&P.fontWeight].join(",")),K&&!d&&(W=z[K]),!W){if(D||v.forExport){try{X=this.fakeTS&&function(te){var ie=C.querySelector(".highcharts-text-outline");ie&&css$c(ie,{display:te})},isFunction$4(X)&&X("none"),W=C.getBBox?extend$1w({},C.getBBox()):{width:C.offsetWidth,height:C.offsetHeight},isFunction$4(X)&&X("")}catch{}(!W||W.width<0)&&(W={width:0,height:0})}else W=p.htmlGetBBox();if(v.isSVG&&(j=W.width,q=W.height,D&&(W.height=q={"11px,17":14,"13px,20":16}[P&&P.fontSize+","+Math.round(q)]||q),F)){var ee=F*deg2rad$9;W.width=Math.abs(q*Math.sin(ee))+Math.abs(j*Math.cos(ee)),W.height=Math.abs(q*Math.cos(ee))+Math.abs(j*Math.sin(ee))}if(K&&(k===""||W.height>0)){for(;$.length>250;)delete z[$.shift()];z[K]||$.push(K),z[K]=W}}return W},g.prototype.getStyle=function(d){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(d)},g.prototype.hasClass=function(d){return(""+this.attr("class")).split(" ").indexOf(d)!==-1},g.prototype.hide=function(d){return d?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},g.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},g.prototype.init=function(d,a){this.element=a==="span"?createElement$9(a):doc$l.createElementNS(this.SVG_NS,a),this.renderer=d,fireEvent$B(this,"afterInit")},g.prototype.invert=function(d){return this.inverted=d,this.updateTransform(),this},g.prototype.on=function(d,a){var p=this.onEvents;return p[d]&&p[d](),p[d]=addEvent$18(this.element,d,a),this},g.prototype.opacitySetter=function(d,a,p){var v=Number(Number(d).toFixed(3));this.opacity=v,p.setAttribute(a,v)},g.prototype.removeClass=function(d){return this.attr("class",(""+this.attr("class")).replace(isString$b(d)?new RegExp("(^| )"+d+"( |$)"):d," ").replace(/ +/g," ").trim())},g.prototype.removeTextOutline=function(){var d=this.element.querySelector("tspan.highcharts-text-outline");d&&this.safeRemoveChild(d)},g.prototype.safeRemoveChild=function(d){var a=d.parentNode;a&&a.removeChild(d)},g.prototype.setRadialReference=function(d){var a=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=d,a&&a.radAttr&&a.animate(this.renderer.getRadialAttr(d,a.radAttr)),this},g.prototype.setTextPath=function(d,a){var p=this.element,v=this.text?this.text.element:p,C={textAnchor:"text-anchor"},P=!1,k,z,$=this.textPathWrapper,D=!$;a=merge$1s(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},a);var F=AST.filterUserAttributes(a.attributes);if(d&&a&&a.enabled){if($&&$.element.parentNode===null?(D=!0,$=$.destroy()):$&&this.removeTextOutline.call($.parentGroup),this.options&&this.options.padding&&(F.dx=-this.options.padding),$||(this.textPathWrapper=$=this.renderer.createElement("textPath"),P=!0),k=$.element,z=d.element.getAttribute("id"),z||d.element.setAttribute("id",z=uniqueKey$7()),D){v.setAttribute("y",0),isNumber$S(F.dx)&&v.setAttribute("x",-F.dx);for(var N=[].slice.call(v.childNodes),W=0;W<N.length;W++){var j=N[W];(j.nodeType===Node.TEXT_NODE||j.nodeName==="tspan")&&k.appendChild(j)}}P&&$&&$.add({element:v}),k.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+z),defined$X(F.dy)&&(k.parentNode.setAttribute("dy",F.dy),delete F.dy),defined$X(F.dx)&&(k.parentNode.setAttribute("dx",F.dx),delete F.dx),objectEach$y(F,function(q,X){k.setAttribute(C[X]||X,q)}),p.removeAttribute("transform"),this.removeTextOutline.call($),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$k,this.applyTextOutline=noop$k}else $&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(p,d),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},g.prototype.shadow=function(d,a,p){var v=[],C=this.element,P=this.oldShadowOptions,k={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},z,$,D,F,N=!1,W,j;if(d===!0?j=k:typeof d=="object"&&(j=extend$1w(k,d)),j&&(j&&P&&objectEach$y(j,function(q,X){q!==P[X]&&(N=!0)}),N&&this.destroyShadows(),this.oldShadowOptions=j),!j)this.destroyShadows();else if(!this.shadows){for(F=j.opacity/j.width,W=this.parentInverted?"translate("+j.offsetY+", "+j.offsetX+")":"translate("+j.offsetX+", "+j.offsetY+")",z=1;z<=j.width;z++)$=C.cloneNode(!1),D=j.width*2+1-2*z,attr$6($,{stroke:d.color||palette.neutralColor100,"stroke-opacity":F*z,"stroke-width":D,transform:W,fill:"none"}),$.setAttribute("class",($.getAttribute("class")||"")+" highcharts-shadow"),p&&(attr$6($,"height",Math.max(attr$6($,"height")-D,0)),$.cutHeight=D),a?a.element.appendChild($):C.parentNode&&C.parentNode.insertBefore($,C),v.push($);this.shadows=v}return this},g.prototype.show=function(d){return this.attr({visibility:d?"inherit":"visible"})},g.prototype.strokeSetter=function(d,a,p){this[a]=d,this.stroke&&this["stroke-width"]?(g.prototype.fillSetter.call(this,this.stroke,"stroke",p),p.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):a==="stroke-width"&&d===0&&this.hasStroke?(p.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(p.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},g.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var d=this.getStyle("stroke-width"),a=0,p;return d.indexOf("px")===d.length-2?a=pInt$7(d):d!==""&&(p=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(p,{width:d,"stroke-width":0}),this.element.parentNode.appendChild(p),a=p.getBBox().width,p.parentNode.removeChild(p)),a},g.prototype.symbolAttr=function(d){var a=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(p){a[p]=pick$1F(d[p],a[p])}),a.attr({d:a.renderer.symbols[a.symbolName](a.x,a.y,a.width,a.height,a)})},g.prototype.textSetter=function(d){d!==this.textStr&&(delete this.textPxLength,this.textStr=d,this.added&&this.renderer.buildText(this))},g.prototype.titleSetter=function(d){var a=this.element,p=a.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");a.insertBefore?a.insertBefore(p,a.firstChild):a.appendChild(p),p.textContent=String(pick$1F(d,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},g.prototype.toFront=function(){var d=this.element;return d.parentNode.appendChild(d),this},g.prototype.translate=function(d,a){return this.attr({translateX:d,translateY:a})},g.prototype.updateShadows=function(d,a,p){var v=this.shadows;if(v)for(var C=v.length;C--;)p.call(v[C],d==="height"?Math.max(a-(v[C].cutHeight||0),0):d==="d"?this.d:a,d,v[C])},g.prototype.updateTransform=function(){var d=this,a=d.scaleX,p=d.scaleY,v=d.inverted,C=d.rotation,P=d.matrix,k=d.element,z=d.translateX||0,$=d.translateY||0;v&&(z+=d.width,$+=d.height);var D=["translate("+z+","+$+")"];defined$X(P)&&D.push("matrix("+P.join(",")+")"),v?D.push("rotate(90) scale(-1,1)"):C&&D.push("rotate("+C+" "+pick$1F(this.rotationOriginX,k.getAttribute("x"),0)+" "+pick$1F(this.rotationOriginY,k.getAttribute("y")||0)+")"),(defined$X(a)||defined$X(p))&&D.push("scale("+pick$1F(a,1)+" "+pick$1F(p,1)+")"),D.length&&k.setAttribute("transform",D.join(" "))},g.prototype.visibilitySetter=function(d,a,p){d==="inherit"?p.removeAttribute(a):this[a]!==d&&p.setAttribute(a,d),this[a]=d},g.prototype.xGetter=function(d){return this.element.nodeName==="circle"&&(d==="x"?d="cx":d==="y"&&(d="cy")),this._defaultGetter(d)},g.prototype.zIndexSetter=function(d,a){var p=this.renderer,v=this.parentGroup,C=v||p,P=C.element||p.box,k=this.element,z=P===p.box,$,D,F,N=!1,W,j=this.added,q;if(defined$X(d)?(k.setAttribute("data-z-index",d),d=+d,this[a]===d&&(j=!1)):defined$X(this[a])&&k.removeAttribute("data-z-index"),this[a]=d,j){for(d=this.zIndex,d&&v&&(v.handleZ=!0),$=P.childNodes,q=$.length-1;q>=0&&!N;q--)D=$[q],F=D.getAttribute("data-z-index"),W=!defined$X(F),D!==k&&(d<0&&W&&!z&&!q?(P.insertBefore(k,$[q]),N=!0):(pInt$7(F)<=d||W&&(!defined$X(d)||d>=0))&&(P.insertBefore(k,$[q+1]||null),N=!0));N||(P.insertBefore(k,$[z?3:0]||null),N=!0)}return N},g})();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(g,d){this[d]=g,this.doTransform=!0};var RendererRegistry;(function(g){g.rendererTypes={};var d;function a(v){return v===void 0&&(v=d),g.rendererTypes[v]||g.rendererTypes[d]}g.getRendererType=a;function p(v,C,P){g.rendererTypes[v]=C,(!d||P)&&(d=v,H.Renderer=C)}g.registerRendererType=p})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$2h=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defined$W=Utilities.defined,extend$1v=Utilities.extend,isNumber$R=Utilities.isNumber,merge$1r=Utilities.merge,pick$1E=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=(function(g){__extends$2h(d,g);function d(a,p,v,C,P,k,z,$,D,F){var N=g.call(this)||this;N.paddingLeftSetter=N.paddingSetter,N.paddingRightSetter=N.paddingSetter,N.init(a,"g"),N.textStr=p,N.x=v,N.y=C,N.anchorX=k,N.anchorY=z,N.baseline=D,N.className=F,N.addClass(F==="button"?"highcharts-no-tooltip":"highcharts-label"),F&&N.addClass("highcharts-"+F),N.text=a.text(void 0,0,0,$).attr({zIndex:1});var W;return typeof P=="string"&&(W=/^url\((.*?)\)$/.test(P),(W||N.renderer.symbols[P])&&(N.symbolKey=P)),N.bBox=d.emptyBBox,N.padding=3,N.baselineOffset=0,N.needsBox=a.styledMode||W,N.deferredAttr={},N.alignFactor=0,N}return d.prototype.alignSetter=function(a){var p={left:0,center:.5,right:1}[a];p!==this.alignFactor&&(this.alignFactor=p,this.bBox&&isNumber$R(this.xSetting)&&this.attr({x:this.xSetting}))},d.prototype.anchorXSetter=function(a,p){this.anchorX=a,this.boxAttr(p,Math.round(a)-this.getCrispAdjust()-this.xSetting)},d.prototype.anchorYSetter=function(a,p){this.anchorY=a,this.boxAttr(p,a-this.ySetting)},d.prototype.boxAttr=function(a,p){this.box?this.box.attr(a,p):this.deferredAttr[a]=p},d.prototype.css=function(a){if(a){var p={};a=merge$1r(a),d.textProps.forEach(function(P){typeof a[P]<"u"&&(p[P]=a[P],delete a[P])}),this.text.css(p);var v="width"in p,C="fontSize"in p||"fontWeight"in p;C?this.updateTextPadding():v&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,a)},d.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},d.prototype.fillSetter=function(a,p){a&&(this.needsBox=!0),this.fill=a,this.boxAttr(p,a)},d.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var a=this.padding,p=pick$1E(this.paddingLeft,a);return{width:this.width,height:this.height,x:this.bBox.x-p,y:this.bBox.y-a}},d.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},d.prototype.heightSetter=function(a){this.heightSetting=a},d.prototype.onAdd=function(){var a=this.textStr;this.text.add(this),this.attr({text:defined$W(a)?a:"",x:this.x,y:this.y}),this.box&&defined$W(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},d.prototype.paddingSetter=function(a,p){isNumber$R(a)?a!==this[p]&&(this[p]=a,this.updateTextPadding()):this[p]=void 0},d.prototype.rSetter=function(a,p){this.boxAttr(p,a)},d.prototype.shadow=function(a){return a&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(a)),this},d.prototype.strokeSetter=function(a,p){this.stroke=a,this.boxAttr(p,a)},d.prototype["stroke-widthSetter"]=function(a,p){a&&(this.needsBox=!0),this["stroke-width"]=a,this.boxAttr(p,a)},d.prototype["text-alignSetter"]=function(a){this.textAlign=a},d.prototype.textSetter=function(a){typeof a<"u"&&this.text.attr({text:a}),this.updateTextPadding()},d.prototype.updateBoxSize=function(){var a=this.text.element.style,p={},v=this.padding,C=this.bBox=(!isNumber$R(this.widthSetting)||!isNumber$R(this.heightSetting)||this.textAlign)&&defined$W(this.text.textStr)?this.text.getBBox():d.emptyBBox,P;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||C.height||0)+2*v;var k=this.renderer.fontMetrics(a&&a.fontSize,this.text);if(this.baselineOffset=v+Math.min((this.text.firstLineMetrics||k).b,C.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-k.h)/2),this.needsBox){if(!this.box){var z=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();z.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),z.add(this)}P=this.getCrispAdjust(),p.x=P,p.y=(this.baseline?-this.baselineOffset:0)+P,p.width=Math.round(this.width),p.height=Math.round(this.height),this.box.attr(extend$1v(p,this.deferredAttr)),this.deferredAttr={}}},d.prototype.updateTextPadding=function(){var a=this.text;this.updateBoxSize();var p=this.baseline?0:this.baselineOffset,v=pick$1E(this.paddingLeft,this.padding);defined$W(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(v+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(v!==a.x||p!==a.y)&&(a.attr("x",v),a.hasBoxWidthChanged&&(this.bBox=a.getBBox(!0)),typeof p<"u"&&a.attr("y",p)),a.x=v,a.y=p},d.prototype.widthSetter=function(a){this.widthSetting=isNumber$R(a)?a:void 0},d.prototype.getPaddedWidth=function(){var a=this.padding,p=pick$1E(this.paddingLeft,a),v=pick$1E(this.paddingRight,a);return(this.widthSetting||this.bBox.width||0)+p+v},d.prototype.xSetter=function(a){this.x=a,this.alignFactor&&(a-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(a),this.attr("translateX",this.xSetting)},d.prototype.ySetter=function(a){this.ySetting=this.y=Math.round(a),this.attr("translateY",this.ySetting)},d.emptyBBox={width:0,height:0,x:0,y:0},d.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],d})(SVGElement),defined$V=Utilities.defined,isNumber$Q=Utilities.isNumber,pick$1D=Utilities.pick;function arc$1(g,d,a,p,v){var C=[];if(v){var P=v.start||0,k=pick$1D(v.r,a),z=pick$1D(v.r,p||a),$=.001,D=Math.abs((v.end||0)-P-2*Math.PI)<$,F=(v.end||0)-$,N=v.innerR,W=pick$1D(v.open,D),j=Math.cos(P),q=Math.sin(P),X=Math.cos(F),K=Math.sin(F),ee=pick$1D(v.longArc,F-P-Math.PI<$?0:1);C.push(["M",g+k*j,d+z*q],["A",k,z,0,ee,pick$1D(v.clockwise,1),g+k*X,d+z*K]),defined$V(N)&&C.push(W?["M",g+N*X,d+N*K]:["L",g+N*X,d+N*K],["A",N,N,0,ee,defined$V(v.clockwise)?1-v.clockwise:0,g+N*j,d+N*q]),W||C.push(["Z"])}return C}function callout(g,d,a,p,v){var C=6,P=6,k=Math.min(v&&v.r||0,a,p),z=k+P,$=v&&v.anchorX,D=v&&v.anchorY||0,F=roundedRect(g,d,a,p,{r:k});return isNumber$Q($)&&(g+$>=a?D>d+z&&D<d+p-z?F.splice(3,1,["L",g+a,D-P],["L",g+a+C,D],["L",g+a,D+P],["L",g+a,d+p-k]):F.splice(3,1,["L",g+a,p/2],["L",$,D],["L",g+a,p/2],["L",g+a,d+p-k]):g+$<=0?D>d+z&&D<d+p-z?F.splice(7,1,["L",g,D+P],["L",g-C,D],["L",g,D-P],["L",g,d+k]):F.splice(7,1,["L",g,p/2],["L",$,D],["L",g,p/2],["L",g,d+k]):D&&D>p&&$>g+z&&$<g+a-z?F.splice(5,1,["L",$+P,d+p],["L",$,d+p+C],["L",$-P,d+p],["L",g+k,d+p]):D&&D<0&&$>g+z&&$<g+a-z&&F.splice(1,1,["L",$-P,d],["L",$,d-C],["L",$+P,d],["L",a-k,d])),F}function circle(g,d,a,p){return arc$1(g+a/2,d+p/2,a/2,p/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(g,d,a,p){return[["M",g+a/2,d],["L",g+a,d+p/2],["L",g+a/2,d+p],["L",g,d+p/2],["Z"]]}function rect(g,d,a,p,v){return v&&v.r?roundedRect(g,d,a,p,v):[["M",g,d],["L",g+a,d],["L",g+a,d+p],["L",g,d+p],["Z"]]}function roundedRect(g,d,a,p,v){var C=v&&v.r||0;return[["M",g+C,d],["L",g+a-C,d],["C",g+a,d,g+a,d,g+a,d+C],["L",g+a,d+p-C],["C",g+a,d+p,g+a,d+p,g+a-C,d+p],["L",g+C,d+p],["C",g,d+p,g,d+p,g,d+p-C],["L",g,d+C],["C",g,d,g,d,g+C,d]]}function triangle(g,d,a,p){return[["M",g+a/2,d],["L",g+a,d+p],["L",g,d+p],["Z"]]}function triangleDown(g,d,a,p){return[["M",g,d],["L",g+a,d],["L",g+a/2,d+p],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$a=Utilities.isString,objectEach$x=Utilities.objectEach,pick$1C=Utilities.pick,TextBuilder=(function(){function g(d){var a=d.styles;this.renderer=d.renderer,this.svgElement=d,this.width=d.textWidth,this.textLineHeight=a&&a.lineHeight,this.textOutline=a&&a.textOutline,this.ellipsis=!!(a&&a.textOverflow==="ellipsis"),this.noWrap=!!(a&&a.whiteSpace==="nowrap"),this.fontSize=a&&a.fontSize}return g.prototype.buildSVG=function(){var d=this.svgElement,a=d.element,p=d.renderer,v=pick$1C(d.textStr,"").toString(),C=v.indexOf("<")!==-1,P=a.childNodes,k=this.width&&!d.added&&p.box,z=/<br.*?>/g,$=[v,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if($!==d.textCache){d.textCache=$,delete d.actualWidth;for(var D=P.length;D--;)a.removeChild(P[D]);if(!C&&!this.ellipsis&&!this.width&&(v.indexOf(" ")===-1||this.noWrap&&!z.test(v)))a.appendChild(doc$k.createTextNode(this.unescapeEntities(v)));else if(v!==""){k&&k.appendChild(a);var F=new AST(v);this.modifyTree(F.nodes),F.addToDOM(d.element),this.modifyDOM(),this.ellipsis&&(a.textContent||"").indexOf("…")!==-1&&d.attr("title",this.unescapeEntities(d.textStr||"",["&lt;","&gt;"])),k&&k.removeChild(a)}isString$a(this.textOutline)&&d.applyTextOutline&&d.applyTextOutline(this.textOutline)}},g.prototype.modifyDOM=function(){var d=this,a=this.svgElement,p=attr$5(a.element,"x");a.firstLineMetrics=void 0;for(var v;(v=a.element.firstChild)&&/^[\s\u200B]*$/.test(v.textContent||" ");)a.element.removeChild(v);[].forEach.call(a.element.querySelectorAll("tspan.highcharts-br"),function(z,$){z.nextSibling&&z.previousSibling&&($===0&&z.previousSibling.nodeType===1&&(a.firstLineMetrics=a.renderer.fontMetrics(void 0,z.previousSibling)),attr$5(z,{dy:d.getLineHeight(z.nextSibling),x:p}))});var C=this.width||0;if(C){var P=function(z,$){var D=z.textContent||"",F=D.replace(/([^\^])-/g,"$1- ").split(" "),N=!d.noWrap&&(F.length>1||a.element.childNodes.length>1),W=d.getLineHeight($),j=0,q=a.actualWidth;if(d.ellipsis)D&&d.truncate(z,D,void 0,0,Math.max(0,C-parseInt(d.fontSize||12,10)),function(ee,te){return ee.substring(0,te)+"…"});else if(N){for(var X=[],K=[];$.firstChild&&$.firstChild!==z;)K.push($.firstChild),$.removeChild($.firstChild);for(;F.length;)F.length&&!d.noWrap&&j>0&&(X.push(z.textContent||""),z.textContent=F.join(" ").replace(/- /g,"-")),d.truncate(z,void 0,F,j===0&&q||0,C,function(ee,te){return F.slice(0,te).join(" ").replace(/- /g,"-")}),q=a.actualWidth,j++;K.forEach(function(ee){$.insertBefore(ee,z)}),X.forEach(function(ee){$.insertBefore(doc$k.createTextNode(ee),z);var te=doc$k.createElementNS(SVG_NS$1,"tspan");te.textContent="​",attr$5(te,{dy:W,x:p}),$.insertBefore(te,z)})}},k=(function(z){var $=[].slice.call(z.childNodes);$.forEach(function(D){D.nodeType===Node.TEXT_NODE?P(D,z):(D.className.baseVal.indexOf("highcharts-br")!==-1&&(a.actualWidth=0),k(D))})});k(a.element)}},g.prototype.getLineHeight=function(d){var a,p=d.nodeType===Node.TEXT_NODE?d.parentElement:d;return this.renderer.styledMode||(a=p&&/(px|em)$/.test(p.style.fontSize)?p.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(a,p||this.svgElement.element).h},g.prototype.modifyTree=function(d){var a=this,p=function(v,C){var P=v.tagName,k=a.renderer.styledMode,z=v.attributes||{};if(P==="b"||P==="strong"?k?z.class="highcharts-strong":z.style="font-weight:bold;"+(z.style||""):(P==="i"||P==="em")&&(k?z.class="highcharts-emphasized":z.style="font-style:italic;"+(z.style||"")),isString$a(z.style)&&(z.style=z.style.replace(/(;| |^)color([ :])/,"$1fill$2")),P==="br"){z.class="highcharts-br",v.textContent="​";var $=d[C+1];$&&$.textContent&&($.textContent=$.textContent.replace(/^ +/gm,""))}P!=="#text"&&P!=="a"&&(v.tagName="tspan"),v.attributes=z,v.children&&v.children.filter(function(D){return D.tagName!=="#text"}).forEach(p)};d.forEach(p)},g.prototype.truncate=function(d,a,p,v,C,P){var k=this.svgElement,z=k.renderer,$=k.rotation,D=[],F=p?1:0,N=(a||p||"").length,W=N,j,q,X=function(K,ee){var te=ee||K,ie=d.parentNode;if(ie&&typeof D[te]>"u")if(ie.getSubStringLength)try{D[te]=v+ie.getSubStringLength(0,p?te+1:te)}catch{}else z.getSpanWidth&&(d.textContent=P(a||p,K),D[te]=v+z.getSpanWidth(k,d));return D[te]};if(k.rotation=0,q=X(d.textContent.length),v+q>C){for(;F<=N;)W=Math.ceil((F+N)/2),p&&(j=P(p,W)),q=X(W,j&&j.length-1),F===N?F=N+1:q>C?N=W-1:F=W;N===0?d.textContent="":a&&N===a.length-1||(d.textContent=j||P(a||p,W))}p&&p.splice(0,W),k.actualWidth=q,k.rotation=$},g.prototype.unescapeEntities=function(d,a){return objectEach$x(this.renderer.escapes,function(p,v){(!a||a.indexOf(p)===-1)&&(d=d.toString().replace(new RegExp(p,"g"),v))}),d},g})(),charts$4=H.charts,deg2rad$8=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$j=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$17=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$U=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1u=Utilities.extend,isArray$n=Utilities.isArray,isNumber$P=Utilities.isNumber,isObject$f=Utilities.isObject,isString$9=Utilities.isString,merge$1q=Utilities.merge,pick$1B=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=(function(){function g(d,a,p,v,C,P,k){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(d,a,p,v,C,P,k)}return g.prototype.init=function(d,a,p,v,C,P,k){var z=this,$=z.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),D=$.element;k||$.css(this.getStyle(v)),d.appendChild(D),attr$4(d,"dir","ltr"),d.innerHTML.indexOf("xmlns")===-1&&attr$4(D,"xmlns",this.SVG_NS),z.isSVG=!0,this.box=D,this.boxWrapper=$,z.alignedObjects=[],this.url=this.getReferenceURL();var F=this.createElement("desc").add();F.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),z.defs=this.createElement("defs").add(),z.allowHTML=P,z.forExport=C,z.styledMode=k,z.gradients={},z.cache={},z.cacheKeys=[],z.imgCount=0,z.setSize(a,p,!1);var N,W;isFirefox$3&&d.getBoundingClientRect&&(N=function(){css$b(d,{left:0,top:0}),W=d.getBoundingClientRect(),css$b(d,{left:Math.ceil(W.left)-W.left+"px",top:Math.ceil(W.top)-W.top+"px"})},N(),z.unSubPixelFix=addEvent$17(win$c,"resize",N))},g.prototype.definition=function(d){var a=new AST([d]);return a.addToDOM(this.defs.element)},g.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$U(hasInternalReferenceBug)){var d=uniqueKey$6(),a=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:d},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+d+")",fill:"rgba(0,0,0,0.001)"}}]}]),p=a.addToDOM(doc$j.body);css$b(p,{position:"fixed",top:0,left:0,zIndex:9e5});var v=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(v&&v.id)==="hitme",doc$j.body.removeChild(p)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},g.prototype.getStyle=function(d){return this.style=extend$1u({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},d),this.style},g.prototype.setStyle=function(d){this.boxWrapper.css(this.getStyle(d))},g.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},g.prototype.destroy=function(){var d=this,a=d.defs;return d.box=null,d.boxWrapper=d.boxWrapper.destroy(),destroyObjectProperties$9(d.gradients||{}),d.gradients=null,a&&(d.defs=a.destroy()),d.unSubPixelFix&&d.unSubPixelFix(),d.alignedObjects=null,null},g.prototype.createElement=function(d){var a=new this.Element;return a.init(this,d),a},g.prototype.getRadialAttr=function(d,a){return{cx:d[0]-d[2]/2+(a.cx||0)*d[2],cy:d[1]-d[2]/2+(a.cy||0)*d[2],r:(a.r||0)*d[2]}},g.prototype.buildText=function(d){new TextBuilder(d).buildSVG()},g.prototype.getContrast=function(d){return d=Color.parse(d).rgba,d[0]*=1,d[1]*=1.2,d[2]*=.5,d[0]+d[1]+d[2]>1.8*255?"#000000":"#FFFFFF"},g.prototype.button=function(d,a,p,v,C,P,k,z,$,D){var F=this.label(d,a,p,$,void 0,void 0,D,void 0,"button"),N=this.styledMode,W=0,j=C?merge$1q(C):{},q=j&&j.style||{};j=AST.filterUserAttributes(j),F.attr(merge$1q({padding:8,r:2},j));var X,K,ee,te;return N||(j=merge$1q({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:q},j),X=j.style,delete j.style,P=merge$1q(j,{fill:palette.neutralColor10},AST.filterUserAttributes(P||{})),K=P.style,delete P.style,k=merge$1q(j,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(k||{})),ee=k.style,delete k.style,z=merge$1q(j,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(z||{})),te=z.style,delete z.style),addEvent$17(F.element,isMS$2?"mouseover":"mouseenter",function(){W!==3&&F.setState(1)}),addEvent$17(F.element,isMS$2?"mouseout":"mouseleave",function(){W!==3&&F.setState(W)}),F.setState=function(ie){ie!==1&&(F.state=W=ie),F.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][ie||0]),N||F.attr([j,P,k,z][ie||0]).css([X,K,ee,te][ie||0])},N||F.attr(j).css(extend$1u({cursor:"default"},X)),F.on("touchstart",function(ie){return ie.stopPropagation()}).on("click",function(ie){W!==3&&v.call(F,ie)})},g.prototype.crispLine=function(d,a,p){p===void 0&&(p="round");var v=d[0],C=d[1];return defined$U(v[1])&&v[1]===C[1]&&(v[1]=C[1]=Math[p](v[1])-a%2/2),defined$U(v[2])&&v[2]===C[2]&&(v[2]=C[2]=Math[p](v[2])+a%2/2),d},g.prototype.path=function(d){var a=this.styledMode?{}:{fill:"none"};return isArray$n(d)?a.d=d:isObject$f(d)&&extend$1u(a,d),this.createElement("path").attr(a)},g.prototype.circle=function(d,a,p){var v=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,r:p},C=this.createElement("circle");return C.xSetter=C.ySetter=function(P,k,z){z.setAttribute("c"+k,P)},C.attr(v)},g.prototype.arc=function(d,a,p,v,C,P){var k;isObject$f(d)?(k=d,a=k.y,p=k.r,v=k.innerR,C=k.start,P=k.end,d=k.x):k={innerR:v,start:C,end:P};var z=this.symbol("arc",d,a,p,p,k);return z.r=p,z},g.prototype.rect=function(d,a,p,v,C,P){C=isObject$f(d)?d.r:C;var k=this.createElement("rect"),z=isObject$f(d)?d:typeof d>"u"?{}:{x:d,y:a,width:Math.max(p,0),height:Math.max(v,0)};return this.styledMode||(typeof P<"u"&&(z["stroke-width"]=P,z=k.crisp(z)),z.fill="none"),C&&(z.r=C),k.rSetter=function($,D,F){k.r=$,attr$4(F,{rx:$,ry:$})},k.rGetter=function(){return k.r||0},k.attr(z)},g.prototype.setSize=function(d,a,p){var v=this;v.width=d,v.height=a,v.boxWrapper.animate({width:d,height:a},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1B(p,!0)?void 0:0}),v.alignElements()},g.prototype.g=function(d){var a=this.createElement("g");return d?a.attr({class:"highcharts-"+d}):a},g.prototype.image=function(d,a,p,v,C,P){var k={preserveAspectRatio:"none"},z=function(N,W){N.setAttributeNS?N.setAttributeNS("http://www.w3.org/1999/xlink","href",W):N.setAttribute("hc-svg-href",W)};arguments.length>1&&extend$1u(k,{x:a,y:p,width:v,height:C});var $=this.createElement("image").attr(k),D=function(N){z($.element,d),P.call($,N)};if(P){z($.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var F=new win$c.Image;addEvent$17(F,"load",D),F.src=d,F.complete&&D({})}else z($.element,d);return $},g.prototype.symbol=function(d,a,p,v,C,P){var k=this,z=/^url\((.*?)\)$/,$=z.test(d),D=!$&&(this.symbols[d]?d:"circle"),F=D&&this.symbols[D],N,W,j,q;if(F)typeof a=="number"&&(W=F.call(this.symbols,Math.round(a||0),Math.round(p||0),v||0,C||0,P)),N=this.path(W),k.styledMode||N.attr("fill","none"),extend$1u(N,{symbolName:D||void 0,x:a,y:p,width:v,height:C}),P&&extend$1u(N,P);else if($){j=d.match(z)[1];var X=N=this.image(j);X.imgwidth=pick$1B(symbolSizes[j]&&symbolSizes[j].width,P&&P.width),X.imgheight=pick$1B(symbolSizes[j]&&symbolSizes[j].height,P&&P.height),q=function(K){return K.attr({width:K.width,height:K.height})},["width","height"].forEach(function(K){X[K+"Setter"]=function(ee,te){var ie=this["img"+te];if(this[te]=ee,defined$U(ie)&&(P&&P.backgroundSize==="within"&&this.width&&this.height&&(ie=Math.round(ie*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(te,ie),!this.alignByTranslate)){var oe=((this[te]||0)-ie)/2,ae=te==="width"?{translateX:oe}:{translateY:oe};this.attr(ae)}}}),defined$U(a)&&X.attr({x:a,y:p}),X.isImg=!0,defined$U(X.imgwidth)&&defined$U(X.imgheight)?q(X):(X.attr({width:0,height:0}),createElement$8("img",{onload:function(){var K=charts$4[k.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[j]={width:this.width,height:this.height},X.imgwidth=this.width,X.imgheight=this.height,X.element&&q(X),this.parentNode&&this.parentNode.removeChild(this),k.imgCount--,!k.imgCount&&K&&!K.hasLoaded&&K.onload()},src:j}),this.imgCount++)}return N},g.prototype.clipRect=function(d,a,p,v){var C=uniqueKey$6()+"-",P=this.createElement("clipPath").attr({id:C}).add(this.defs),k=this.rect(d,a,p,v,0).add(P);return k.id=C,k.clipPath=P,k.count=0,k},g.prototype.text=function(d,a,p,v){var C=this,P={};if(v&&(C.allowHTML||!C.forExport))return C.html(d,a,p);P.x=Math.round(a||0),p&&(P.y=Math.round(p)),defined$U(d)&&(P.text=d);var k=C.createElement("text").attr(P);return(!v||C.forExport&&!C.allowHTML)&&(k.xSetter=function(z,$,D){for(var F=D.getElementsByTagName("tspan"),N=D.getAttribute($),W=0,j=void 0;W<F.length;W++)j=F[W],j.getAttribute($)===N&&j.setAttribute($,z);D.setAttribute($,z)}),k},g.prototype.fontMetrics=function(d,a){(this.styledMode||!/px/.test(d))&&win$c.getComputedStyle?d=a&&SVGElement.prototype.getStyle.call(a,"font-size"):d=d||a&&a.style&&a.style.fontSize||this.style&&this.style.fontSize,/px/.test(d)?d=pInt$6(d):d=12;var p=d<24?d+3:Math.round(d*1.2),v=Math.round(p*.8);return{h:p,b:v,f:d}},g.prototype.rotCorr=function(d,a,p){var v=d;return a&&p&&(v=Math.max(v*Math.cos(a*deg2rad$8),4)),{x:-d/3*Math.sin(a*deg2rad$8),y:v}},g.prototype.pathToSegments=function(d){for(var a=[],p=[],v={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},C=0;C<d.length;C++)isString$9(p[0])&&isNumber$P(d[C])&&p.length===v[p[0].toUpperCase()]&&d.splice(C,0,p[0].replace("M","L").replace("m","l")),typeof d[C]=="string"&&(p.length&&a.push(p.slice(0)),p.length=0),p.push(d[C]);return a.push(p.slice(0)),a},g.prototype.label=function(d,a,p,v,C,P,k,z,$){return new SVGLabel(this,d,a,p,v,C,P,k,z,$)},g.prototype.alignElements=function(){this.alignedObjects.forEach(function(d){return d.align()})},g})();extend$1u(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$j});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$2g=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$T=Utilities.defined,extend$1t=Utilities.extend,pick$1A=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement$1=(function(g){__extends$2g(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var p=d.prototype,v=a.prototype;v.getSpanCorrection=p.getSpanCorrection,v.htmlCss=p.htmlCss,v.htmlGetBBox=p.htmlGetBBox,v.htmlUpdateTransform=p.htmlUpdateTransform,v.setSpanRotation=p.setSpanRotation}return a},d.prototype.getSpanCorrection=function(a,p,v){this.xCorr=-a*v,this.yCorr=-p},d.prototype.htmlCss=function(a){var p=this,v=p.element,C=v.tagName==="SPAN"&&a&&"width"in a,P=pick$1A(C&&a.width,void 0),k;return C&&(delete a.width,p.textWidth=P,k=!0),a&&a.textOverflow==="ellipsis"&&(a.whiteSpace="nowrap",a.overflow="hidden"),p.styles=extend$1t(p.styles,a),css$a(p.element,a),k&&p.htmlUpdateTransform(),p},d.prototype.htmlGetBBox=function(){var a=this,p=a.element;return{x:p.offsetLeft,y:p.offsetTop,width:p.offsetWidth,height:p.offsetHeight}},d.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var a=this,p=a.renderer,v=a.element,C=a.translateX||0,P=a.translateY||0,k=a.x||0,z=a.y||0,$=a.textAlign||"left",D={left:0,center:.5,right:1}[$],F=a.styles,N=F&&F.whiteSpace;function W(){return css$a(v,{width:"",whiteSpace:N||"nowrap"}),v.offsetWidth}if(css$a(v,{marginLeft:C,marginTop:P}),!p.styledMode&&a.shadows&&a.shadows.forEach(function(ee){css$a(ee,{marginLeft:C+1,marginTop:P+1})}),a.inverted&&[].forEach.call(v.childNodes,function(ee){p.invertChild(ee,v)}),v.tagName==="SPAN"){var j=a.rotation,q=a.textWidth&&pInt$5(a.textWidth),X=[j,$,v.innerHTML,a.textWidth,a.textAlign].join(","),K=void 0;q!==a.oldTextWidth&&(q>a.oldTextWidth||(a.textPxLength||W())>q)&&(/[ \-]/.test(v.textContent||v.innerText)||v.style.textOverflow==="ellipsis")?(css$a(v,{width:q+"px",display:"block",whiteSpace:N||"normal"}),a.oldTextWidth=q,a.hasBoxWidthChanged=!0):a.hasBoxWidthChanged=!1,X!==a.cTT&&(K=p.fontMetrics(v.style.fontSize,v).b,defined$T(j)&&(j!==(a.oldRotation||0)||$!==a.oldAlign)&&a.setSpanRotation(j,D,K),a.getSpanCorrection(!defined$T(j)&&a.textPxLength||v.offsetWidth,K,D,j,$)),css$a(v,{left:k+(a.xCorr||0)+"px",top:z+(a.yCorr||0)+"px"}),a.cTT=X,a.oldRotation=j,a.oldAlign=$}},d.prototype.setSpanRotation=function(a,p,v){var C=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},P={},k=C();k&&(P[k]=P.transform="rotate("+a+"deg)",P[k+(isFirefox$2?"Origin":"-origin")]=P.transformOrigin=p*100+"% "+v+"px",css$a(this.element,P))},d.composedClasses=[],d})(SVGElement),__extends$2f=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1s=Utilities.extend,pick$1z=Utilities.pick,HTMLRenderer=(function(g){__extends$2f(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.compose=function(a){if(d.composedClasses.indexOf(a)===-1){d.composedClasses.push(a);var p=d.prototype,v=a.prototype;v.html=p.html}return a},d.prototype.html=function(a,p,v){var C=this.createElement("span"),P=C.element,k=C.renderer,z=k.isSVG,$=function(D,F){["opacity","visibility"].forEach(function(N){D[N+"Setter"]=function(W,j,q){var X=D.div?D.div.style:F;SVGElement.prototype[N+"Setter"].call(this,W,j,q),X&&(X[j]=W)}}),D.addedSetters=!0};return C.textSetter=function(D){D!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1z(D,"")),this.textStr=D,C.doTransform=!0)},z&&$(C,C.element.style),C.xSetter=C.ySetter=C.alignSetter=C.rotationSetter=function(D,F){F==="align"?C.alignValue=C.textAlign=D:C[F]=D,C.doTransform=!0},C.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},C.attr({text:a,x:Math.round(p),y:Math.round(v)}).css({position:"absolute"}),k.styledMode||C.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),P.style.whiteSpace="nowrap",C.css=C.htmlCss,z&&(C.add=function(D){var F=k.box.parentNode,N=[],W,j;if(this.parentGroup=D,D){if(W=D.div,!W){for(j=D;j;)N.push(j),j=j.parentGroup;N.reverse().forEach(function(q){var X=attr$3(q.element,"class");function K(ie,oe){q[oe]=ie,oe==="translateX"?te.left=ie+"px":te.top=ie+"px",q.doTransform=!0}var ee=q.styles||{};W=q.div=q.div||createElement$7("div",X?{className:X}:void 0,{position:"absolute",left:(q.translateX||0)+"px",top:(q.translateY||0)+"px",display:q.display,opacity:q.opacity,cursor:ee.cursor,pointerEvents:ee.pointerEvents,visibility:q.visibility},W||F);var te=W.style;extend$1s(q,{classSetter:(function(ie){return function(oe){this.element.setAttribute("class",oe),ie.className=oe}})(W),on:function(){return N[0].div&&C.on.apply({element:N[0].div,onEvents:q.onEvents},arguments),q},translateXSetter:K,translateYSetter:K}),q.addedSetters||$(q)})}}else W=F;return W.appendChild(P),C.added=!0,C.alignOnAdd&&C.htmlUpdateTransform(),C}),C},d.composedClasses=[],d})(SVGRenderer),AxisDefaults;(function(g){g.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},g.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var d=this.axis.chart.numberFormatter;return d(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},g.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},g.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},g.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},g.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$16=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$w=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(g,d){g.eventOptions=g.eventOptions||{},objectEach$w(d.events,function(a,p){g.eventOptions[p]!==a&&(g.eventOptions[p]&&(removeEvent$a(g,p,g.eventOptions[p]),delete g.eventOptions[p]),isFunction$3(a)&&(g.eventOptions[p]=a,addEvent$16(g,p,a)))})},exports$6={registerEventOptions:registerEventOptions$3},deg2rad$7=H.deg2rad,clamp$j=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$S=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1r=Utilities.extend,fireEvent$A=Utilities.fireEvent,isNumber$O=Utilities.isNumber,merge$1p=Utilities.merge,objectEach$v=Utilities.objectEach,pick$1y=Utilities.pick,Tick=(function(){function g(d,a,p,v,C){this.isNew=!0,this.isNewLabel=!0,this.axis=d,this.pos=a,this.type=p||"",this.parameters=C||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$A(this,"init"),!p&&!v&&this.addLabel()}return g.prototype.addLabel=function(){var d=this,a=d.axis,p=a.options,v=a.chart,C=a.categories,P=a.logarithmic,k=a.names,z=d.pos,$=pick$1y(d.options&&d.options.labels,p.labels),D=a.tickPositions,F=z===D[0],N=z===D[D.length-1],W=(!$.step||$.step===1)&&a.tickInterval===1,j=D.info,q=d.label,X,K,ee,te=this.parameters.category||(C?pick$1y(C[z],k[z],z):z);P&&isNumber$O(te)&&(te=correctFloat$c(P.lin2log(te))),a.dateTime&&(j?(K=v.time.resolveDTLFormat(p.dateTimeLabelFormats[!p.grid&&j.higherRanks[z]||j.unitName]),X=K.main):isNumber$O(te)&&(X=a.dateTime.getXDateFormat(te,p.dateTimeLabelFormats||{}))),d.isFirst=F,d.isLast=N;var ie={axis:a,chart:v,dateTimeLabelFormat:X,isFirst:F,isLast:N,pos:z,tick:d,tickPositionInfo:j,value:te};fireEvent$A(this,"labelFormat",ie);var oe=function(ce){return $.formatter?$.formatter.call(ce,ce):$.format?(ce.text=a.defaultLabelFormatter.call(ce),FormatUtilities.format($.format,ce,v)):a.defaultLabelFormatter.call(ce,ce)},ae=oe.call(ie,ie),le=K&&K.list;le?d.shortenLabel=function(){for(ee=0;ee<le.length;ee++)if(extend$1r(ie,{dateTimeLabelFormat:le[ee]}),q.attr({text:oe.call(ie,ie)}),q.getBBox().width<a.getSlotWidth(d)-2*$.padding)return;q.attr({text:""})}:d.shortenLabel=void 0,W&&a._addedPlotLB&&d.moveLabel(ae,$),!defined$S(q)&&!d.movedLabel?(d.label=q=d.createLabel({x:0,y:0},ae,$),d.rotation=0):q&&q.textStr!==ae&&!W&&(q.textWidth&&!$.style.width&&!q.styles.width&&q.css({width:null}),q.attr({text:ae}),q.textPxLength=q.getBBox().width)},g.prototype.createLabel=function(d,a,p){var v=this.axis,C=v.chart,P=defined$S(a)&&p.enabled?C.renderer.text(a,d.x,d.y,p.useHTML).add(v.labelGroup):null;return P&&(C.styledMode||P.css(merge$1p(p.style)),P.textPxLength=P.getBBox().width),P},g.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},g.prototype.getPosition=function(d,a,p,v){var C=this.axis,P=C.chart,k=v&&P.oldChartHeight||P.chartHeight,z={x:d?correctFloat$c(C.translate(a+p,null,null,v)+C.transB):C.left+C.offset+(C.opposite?(v&&P.oldChartWidth||P.chartWidth)-C.right-C.left:0),y:d?k-C.bottom+C.offset-(C.opposite?C.height:0):correctFloat$c(k-C.translate(a+p,null,null,v)-C.transB)};return z.y=clamp$j(z.y,-1e5,1e5),fireEvent$A(this,"afterGetPosition",{pos:z}),z},g.prototype.getLabelPosition=function(d,a,p,v,C,P,k,z){var $=this.axis,D=$.transA,F=$.isLinked&&$.linkedParent?$.linkedParent.reversed:$.reversed,N=$.staggerLines,W=$.tickRotCorr||{x:0,y:0},j=!v&&!$.reserveSpaceDefault?-$.labelOffset*($.labelAlign==="center"?.5:1):0,q={},X=C.y,K;return defined$S(X)||($.side===0?X=p.rotation?-8:-p.getBBox().height:$.side===2?X=W.y+8:X=Math.cos(p.rotation*deg2rad$7)*(W.y-p.getBBox(!1,0).height/2)),d=d+C.x+j+W.x-(P&&v?P*D*(F?-1:1):0),a=a+X-(P&&!v?P*D*(F?1:-1):0),N&&(K=k/(z||1)%N,$.opposite&&(K=N-K-1),a+=K*($.labelOffset/N)),q.x=d,q.y=Math.round(a),fireEvent$A(this,"afterGetLabelPosition",{pos:q,tickmarkOffset:P,index:k}),q},g.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},g.prototype.getMarkPath=function(d,a,p,v,C,P){return P.crispLine([["M",d,a],["L",d+(C?0:-p),a+(C?p:0)]],v)},g.prototype.handleOverflow=function(d){var a=this,p=this.axis,v=p.options.labels,C=d.x,P=p.chart.chartWidth,k=p.chart.spacing,z=pick$1y(p.labelLeft,Math.min(p.pos,k[3])),$=pick$1y(p.labelRight,Math.max(p.isRadial?0:p.pos+p.len,P-k[1])),D=this.label,F=this.rotation,N={left:0,center:.5,right:1}[p.labelAlign||D.attr("align")],W=D.getBBox().width,j=p.getSlotWidth(a),q=N,X={},K=j,ee=1,te,ie,oe;!F&&v.overflow==="justify"?(te=C-N*W,ie=C+(1-N)*W,te<z?K=d.x+K*(1-N)-z:ie>$&&(K=$-d.x+K*N,ee=-1),K=Math.min(j,K),K<j&&p.labelAlign==="center"&&(d.x+=ee*(j-K-q*(j-Math.min(W,K)))),(W>K||p.autoRotation&&(D.styles||{}).width)&&(oe=K)):F<0&&C-N*W<z?oe=Math.round(C/Math.cos(F*deg2rad$7)-z):F>0&&C+N*W>$&&(oe=Math.round((P-C)/Math.cos(F*deg2rad$7))),oe&&(a.shortenLabel?a.shortenLabel():(X.width=Math.floor(oe)+"px",(v.style||{}).textOverflow||(X.textOverflow="ellipsis"),D.css(X)))},g.prototype.moveLabel=function(d,a){var p=this,v=p.label,C=p.axis,P=C.reversed,k=!1,z,$,D;v&&v.textStr===d?(p.movedLabel=v,k=!0,delete p.label):objectEach$v(C.ticks,function(F){!k&&!F.isNew&&F!==p&&F.label&&F.label.textStr===d&&(p.movedLabel=F.label,k=!0,F.labelPos=p.movedLabel.xy,delete F.label)}),!k&&(p.labelPos||v)&&(z=p.labelPos||v.xy,$=C.horiz?P?0:C.width+C.left:z.x,D=C.horiz?z.y:P?C.width+C.left:0,p.movedLabel=p.createLabel({x:$,y:D},d,a),p.movedLabel&&p.movedLabel.attr({opacity:0}))},g.prototype.render=function(d,a,p){var v=this,C=v.axis,P=C.horiz,k=v.pos,z=pick$1y(v.tickmarkOffset,C.tickmarkOffset),$=v.getPosition(P,k,z,a),D=$.x,F=$.y,N=P&&D===C.pos+C.len||!P&&F===C.pos?-1:1,W=pick$1y(p,v.label&&v.label.newOpacity,1);p=pick$1y(p,1),this.isActive=!0,this.renderGridLine(a,p,N),this.renderMark($,p,N),this.renderLabel($,a,W,d),v.isNew=!1,fireEvent$A(this,"afterRender")},g.prototype.renderGridLine=function(d,a,p){var v=this,C=v.axis,P=C.options,k={},z=v.pos,$=v.type,D=pick$1y(v.tickmarkOffset,C.tickmarkOffset),F=C.chart.renderer,N=v.gridLine,W,j=P.gridLineWidth,q=P.gridLineColor,X=P.gridLineDashStyle;v.type==="minor"&&(j=P.minorGridLineWidth,q=P.minorGridLineColor,X=P.minorGridLineDashStyle),N||(C.chart.styledMode||(k.stroke=q,k["stroke-width"]=j||0,k.dashstyle=X),$||(k.zIndex=1),d&&(a=0),v.gridLine=N=F.path().attr(k).addClass("highcharts-"+($?$+"-":"")+"grid-line").add(C.gridGroup)),N&&(W=C.getPlotLinePath({value:z+D,lineWidth:N.strokeWidth()*p,force:"pass",old:d}),W&&N[d||v.isNew?"attr":"animate"]({d:W,opacity:a}))},g.prototype.renderMark=function(d,a,p){var v=this,C=v.axis,P=C.options,k=C.chart.renderer,z=v.type,$=C.tickSize(z?z+"Tick":"tick"),D=d.x,F=d.y,N=pick$1y(P[z!=="minor"?"tickWidth":"minorTickWidth"],!z&&C.isXAxis?1:0),W=P[z!=="minor"?"tickColor":"minorTickColor"],j=v.mark,q=!j;$&&(C.opposite&&($[0]=-$[0]),j||(v.mark=j=k.path().addClass("highcharts-"+(z?z+"-":"")+"tick").add(C.axisGroup),C.chart.styledMode||j.attr({stroke:W,"stroke-width":N})),j[q?"attr":"animate"]({d:v.getMarkPath(D,F,$[0],j.strokeWidth()*p,C.horiz,k),opacity:a}))},g.prototype.renderLabel=function(d,a,p,v){var C=this,P=C.axis,k=P.horiz,z=P.options,$=C.label,D=z.labels,F=D.step,N=pick$1y(C.tickmarkOffset,P.tickmarkOffset),W=d.x,j=d.y,q=!0;$&&isNumber$O(W)&&($.xy=d=C.getLabelPosition(W,j,$,k,D,N,v,F),C.isFirst&&!C.isLast&&!z.showFirstLabel||C.isLast&&!C.isFirst&&!z.showLastLabel?q=!1:k&&!D.step&&!D.rotation&&!a&&p!==0&&C.handleOverflow(d),F&&v%F&&(q=!1),q&&isNumber$O(d.y)?(d.opacity=p,$[C.isNewLabel?"attr":"animate"](d),C.isNewLabel=!1):($.attr("y",-9999),C.isNewLabel=!0))},g.prototype.replaceMovedLabel=function(){var d=this,a=d.label,p=d.axis,v=p.reversed,C,P;a&&!d.isNew&&(C=p.horiz?v?p.left:p.width+p.left:a.xy.x,P=p.horiz?a.xy.y:v?p.width+p.top:p.top,a.animate({x:C,y:P,opacity:0},void 0,a.destroy),delete d.label),p.isDirty=!0,d.label=d.movedLabel,delete d.movedLabel},g})(),animObject$b=animationExports.animObject,defaultOptions$h=DefaultOptions.defaultOptions,registerEventOptions$2=exports$6.registerEventOptions,deg2rad$6=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$i=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$R=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$8=Utilities.erase,error$9=Utilities.error,extend$1q=Utilities.extend,fireEvent$z=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$m=Utilities.isArray,isNumber$N=Utilities.isNumber,isString$8=Utilities.isString,merge$1o=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$u=Utilities.objectEach,pick$1x=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$i=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=(function(){function g(d,a){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(d,a)}return g.prototype.init=function(d,a){var p=a.isX,v=this;v.chart=d,v.horiz=d.inverted&&!v.isZAxis?!p:p,v.isXAxis=p,v.coll=v.coll||(p?"xAxis":"yAxis"),fireEvent$z(this,"init",{userOptions:a}),v.opposite=pick$1x(a.opposite,v.opposite),v.side=pick$1x(a.side,v.side,v.horiz?v.opposite?0:2:v.opposite?1:3),v.setOptions(a);var C=this.options,P=C.labels,k=C.type;v.userOptions=a,v.minPixelPadding=0,v.reversed=pick$1x(C.reversed,v.reversed),v.visible=C.visible,v.zoomEnabled=C.zoomEnabled,v.hasNames=k==="category"||C.categories===!0,v.categories=C.categories||v.hasNames,v.names||(v.names=[],v.names.keys={}),v.plotLinesAndBandsGroups={},v.positiveValuesOnly=!!v.logarithmic,v.isLinked=defined$R(C.linkedTo),v.ticks={},v.labelEdge=[],v.minorTicks={},v.plotLinesAndBands=[],v.alternateBands={},v.len=0,v.minRange=v.userMinRange=C.minRange||C.maxZoom,v.range=C.range,v.offset=C.offset||0,v.max=null,v.min=null;var z=pick$1x(C.crosshair,splat$i(d.options.tooltip.crosshairs)[p?0:1]);v.crosshair=z===!0?{}:z,d.axes.indexOf(v)===-1&&(p?d.axes.splice(d.xAxis.length,0,v):d.axes.push(v),d[v.coll].push(v)),v.series=v.series||[],d.inverted&&!v.isZAxis&&p&&typeof v.reversed>"u"&&(v.reversed=!0),v.labelRotation=isNumber$N(P.rotation)?P.rotation:void 0,registerEventOptions$2(v,C),fireEvent$z(this,"afterInit")},g.prototype.setOptions=function(d){this.options=merge$1o(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1o(defaultOptions$h[this.coll],d)),fireEvent$z(this,"afterSetOptions",{userOptions:d})},g.prototype.defaultLabelFormatter=function(d){var a=this.axis,p=this.chart,v=p.numberFormatter,C=isNumber$N(this.value)?this.value:NaN,P=a.chart.time,k=a.categories,z=this.dateTimeLabelFormat,$=defaultOptions$h.lang,D=$.numericSymbols,F=$.numericSymbolMagnitude||1e3,N=a.logarithmic?Math.abs(C):a.tickInterval,W=D&&D.length,j,q;if(k)q=""+this.value;else if(z)q=P.dateFormat(z,C);else if(W&&N>=1e3)for(;W--&&typeof q>"u";)j=Math.pow(F,W+1),N>=j&&C*10%j===0&&D[W]!==null&&C!==0&&(q=v(C/j,-1)+D[W]);return typeof q>"u"&&(Math.abs(C)>=1e4?q=v(C,-1):q=v(C,-1,void 0,"")),q},g.prototype.getSeriesExtremes=function(){var d=this,a=d.chart,p;fireEvent$z(this,"getSeriesExtremes",null,function(){d.hasVisibleSeries=!1,d.dataMin=d.dataMax=d.threshold=null,d.softThreshold=!d.isXAxis,d.stacking&&d.stacking.buildStacks(),d.series.forEach(function(v){if(v.visible||!a.options.chart.ignoreHiddenSeries){var C=v.options,P=void 0,k=C.threshold,z=void 0,$=void 0;if(d.hasVisibleSeries=!0,d.positiveValuesOnly&&k<=0&&(k=null),d.isXAxis)P=v.xData,P.length&&(P=d.logarithmic?P.filter(d.validatePositiveValue):P,p=v.getXExtremes(P),z=p.min,$=p.max,!isNumber$N(z)&&!(z instanceof Date)&&(P=P.filter(isNumber$N),p=v.getXExtremes(P),z=p.min,$=p.max),P.length&&(d.dataMin=Math.min(pick$1x(d.dataMin,z),z),d.dataMax=Math.max(pick$1x(d.dataMax,$),$)));else{var D=v.applyExtremes();isNumber$N(D.dataMin)&&(z=D.dataMin,d.dataMin=Math.min(pick$1x(d.dataMin,z),z)),isNumber$N(D.dataMax)&&($=D.dataMax,d.dataMax=Math.max(pick$1x(d.dataMax,$),$)),defined$R(k)&&(d.threshold=k),(!C.softThreshold||d.positiveValuesOnly)&&(d.softThreshold=!1)}}})}),fireEvent$z(this,"afterGetSeriesExtremes")},g.prototype.translate=function(d,a,p,v,C,P){var k=this.linkedParent||this,z=v&&k.old?k.old.min:k.min,$=k.minPixelPadding,D=(k.isOrdinal||k.brokenAxis&&k.brokenAxis.hasBreaks||k.logarithmic&&C)&&k.lin2val,F=1,N=0,W=v&&k.old?k.old.transA:k.transA,j=0;return W||(W=k.transA),p&&(F*=-1,N=k.len),k.reversed&&(F*=-1,N-=F*(k.sector||k.len)),a?(d=d*F+N,d-=$,j=d/W+z,D&&(j=k.lin2val(j))):(D&&(d=k.val2lin(d)),j=isNumber$N(z)?F*(d-z)*W+N+F*$+(isNumber$N(P)?W*P:0):void 0),j},g.prototype.toPixels=function(d,a){return this.translate(d,!1,!this.horiz,null,!0)+(a?0:this.pos)},g.prototype.toValue=function(d,a){return this.translate(d-(a?0:this.pos),!0,!this.horiz,null,!0)},g.prototype.getPlotLinePath=function(d){var a=this,p=a.chart,v=a.left,C=a.top,P=d.old,k=d.value,z=d.lineWidth,$=P&&p.oldChartHeight||p.chartHeight,D=P&&p.oldChartWidth||p.chartWidth,F=a.transB,N=d.translatedValue,W=d.force,j,q,X,K,ee;function te(oe,ae,le){return(W!=="pass"&&oe<ae||oe>le)&&(W?oe=clamp$i(oe,ae,le):ee=!0),oe}var ie={value:k,lineWidth:z,old:P,force:W,acrossPanes:d.acrossPanes,translatedValue:N};return fireEvent$z(this,"getPlotLinePath",ie,function(oe){N=pick$1x(N,a.translate(k,null,null,P)),N=clamp$i(N,-1e5,1e5),j=X=Math.round(N+F),q=K=Math.round($-N-F),isNumber$N(N)?a.horiz?(q=C,K=$-a.bottom,j=X=te(j,v,v+a.width)):(j=v,X=D-a.right,q=K=te(q,C,C+a.height)):(ee=!0,W=!1),oe.path=ee&&!W?null:p.renderer.crispLine([["M",j,q],["L",X,K]],z||1)}),ie.path},g.prototype.getLinearTickPositions=function(d,a,p){var v=correctFloat$b(Math.floor(a/d)*d),C=correctFloat$b(Math.ceil(p/d)*d),P=[],k,z,$;if(correctFloat$b(v+d)===v&&($=20),this.single)return[a];for(k=v;k<=C&&(P.push(k),k=correctFloat$b(k+d,$),k!==z);)z=k;return P},g.prototype.getMinorTickInterval=function(){var d=this.options;return d.minorTicks===!0?pick$1x(d.minorTickInterval,"auto"):d.minorTicks===!1?null:d.minorTickInterval},g.prototype.getMinorTickPositions=function(){var d=this,a=d.options,p=d.tickPositions,v=d.minorTickInterval,C=d.pointRangePadding||0,P=d.min-C,k=d.max+C,z=k-P,$=[],D;if(z&&z/v<d.len/3){var F=d.logarithmic;if(F)this.paddedTicks.forEach(function(N,W,j){W&&$.push.apply($,F.getLogTickPositions(v,j[W-1],j[W],!0))});else if(d.dateTime&&this.getMinorTickInterval()==="auto")$=$.concat(d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(v),P,k,a.startOfWeek));else for(D=P+(p[0]-P)%v;D<=k&&D!==$[0];D+=v)$.push(D)}return $.length!==0&&d.trimTicks($),$},g.prototype.adjustForMinRange=function(){var d=this,a=d.options,p=d.logarithmic,v=d.min,C=d.max,P,k,z=0,$,D,F,N,W,j,q;d.isXAxis&&typeof d.minRange>"u"&&!p&&(defined$R(a.min)||defined$R(a.max)?d.minRange=null:(d.series.forEach(function(X){if(F=X.xData,N=X.xIncrement?1:F.length-1,F.length>1)for($=N;$>0;$--)D=F[$]-F[$-1],(!z||D<z)&&(z=D)}),d.minRange=Math.min(z*5,d.dataMax-d.dataMin))),C-v<d.minRange&&(k=d.dataMax-d.dataMin>=d.minRange,q=d.minRange,P=(q-C+v)/2,W=[v-P,pick$1x(a.min,v-P)],k&&(W[2]=d.logarithmic?d.logarithmic.log2lin(d.dataMin):d.dataMin),v=arrayMax$9(W),j=[v+q,pick$1x(a.max,v+q)],k&&(j[2]=p?p.log2lin(d.dataMax):d.dataMax),C=arrayMin$8(j),C-v<q&&(W[0]=C-q,W[1]=pick$1x(a.min,C-q),v=arrayMax$9(W))),d.min=v,d.max=C},g.prototype.getClosest=function(){var d;return this.categories?d=1:this.series.forEach(function(a){var p=a.closestPointRange,v=a.visible||!a.chart.options.chart.ignoreHiddenSeries;!a.noSharedTooltip&&defined$R(p)&&v&&(d=defined$R(d)?Math.min(d,p):p)}),d},g.prototype.nameToX=function(d){var a=isArray$m(this.categories),p=a?this.categories:this.names,v=d.options.x,C;return d.series.requireSorting=!1,defined$R(v)||(v=this.options.uniqueNames?a?p.indexOf(d.name):pick$1x(p.keys[d.name],-1):d.series.autoIncrement()),v===-1?a||(C=p.length):C=v,typeof C<"u"&&(this.names[C]=d.name,this.names.keys[d.name]=C),C},g.prototype.updateNames=function(){var d=this,a=this.names,p=a.length;p>0&&(Object.keys(a.keys).forEach(function(v){delete a.keys[v]}),a.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(v){v.xIncrement=null,(!v.points||v.isDirtyData)&&(d.max=Math.max(d.max,v.xData.length-1),v.processData(),v.generatePoints()),v.data.forEach(function(C,P){var k;C&&C.options&&typeof C.name<"u"&&(k=d.nameToX(C),typeof k<"u"&&k!==C.x&&(C.x=k,v.xData[P]=k))})}))},g.prototype.setAxisTranslation=function(){var d=this,a=d.max-d.min,p=d.linkedParent,v=!!d.categories,C=d.isXAxis,P=d.axisPointRange||0,k,z=0,$=0,D,F=d.transA;(C||v||P)&&(k=d.getClosest(),p?(z=p.minPointOffset,$=p.pointRangePadding):d.series.forEach(function(N){var W=v?1:C?pick$1x(N.options.pointRange,k,0):d.axisPointRange||0,j=N.options.pointPlacement;if(P=Math.max(P,W),!d.single||v){var q=N.is("xrange")?!C:C;z=Math.max(z,q&&isString$8(j)?0:W/2),$=Math.max($,q&&j==="on"?0:W)}}),D=d.ordinal&&d.ordinal.slope&&k?d.ordinal.slope/k:1,d.minPointOffset=z=z*D,d.pointRangePadding=$=$*D,d.pointRange=Math.min(P,d.single&&v?1:a),C&&(d.closestPointRange=k)),d.translationSlope=d.transA=F=d.staticScale||d.len/(a+$||1),d.transB=d.horiz?d.left:d.bottom,d.minPixelPadding=F*z,fireEvent$z(this,"afterSetAxisTranslation")},g.prototype.minFromRange=function(){var d=this;return d.max-d.range},g.prototype.setTickInterval=function(d){var a=this,p=a.chart,v=a.logarithmic,C=a.options,P=a.isXAxis,k=a.isLinked,z=C.tickPixelInterval,$=a.categories,D=a.softThreshold,F=C.maxPadding,N=C.minPadding,W,j,q=C.tickInterval,X=isNumber$N(a.threshold)?a.threshold:null,K,ee,te,ie;!a.dateTime&&!$&&!k&&this.getTickAmount(),te=pick$1x(a.userMin,C.min),ie=pick$1x(a.userMax,C.max),k?(a.linkedParent=p[a.coll][C.linkedTo],j=a.linkedParent.getExtremes(),a.min=pick$1x(j.min,j.dataMin),a.max=pick$1x(j.max,j.dataMax),C.type!==a.linkedParent.options.type&&error$9(11,1,p)):(D&&defined$R(X)&&(a.dataMin>=X?(K=X,N=0):a.dataMax<=X&&(ee=X,F=0)),a.min=pick$1x(te,K,a.dataMin),a.max=pick$1x(ie,ee,a.dataMax)),v&&(a.positiveValuesOnly&&!d&&Math.min(a.min,pick$1x(a.dataMin,a.min))<=0&&error$9(10,1,p),a.min=correctFloat$b(v.log2lin(a.min),16),a.max=correctFloat$b(v.log2lin(a.max),16)),a.range&&defined$R(a.max)&&(a.userMin=a.min=te=Math.max(a.dataMin,a.minFromRange()),a.userMax=ie=a.max,a.range=null),fireEvent$z(a,"foundExtremes"),a.beforePadding&&a.beforePadding(),a.adjustForMinRange(),!$&&!a.axisPointRange&&!(a.stacking&&a.stacking.usePercentage)&&!k&&defined$R(a.min)&&defined$R(a.max)&&(W=a.max-a.min,W&&(!defined$R(te)&&N&&(a.min-=W*N),!defined$R(ie)&&F&&(a.max+=W*F))),isNumber$N(a.userMin)||(isNumber$N(C.softMin)&&C.softMin<a.min&&(a.min=te=C.softMin),isNumber$N(C.floor)&&(a.min=Math.max(a.min,C.floor))),isNumber$N(a.userMax)||(isNumber$N(C.softMax)&&C.softMax>a.max&&(a.max=ie=C.softMax),isNumber$N(C.ceiling)&&(a.max=Math.min(a.max,C.ceiling))),D&&defined$R(a.dataMin)&&(X=X||0,!defined$R(te)&&a.min<X&&a.dataMin>=X?a.min=a.options.minRange?Math.min(X,a.max-a.minRange):X:!defined$R(ie)&&a.max>X&&a.dataMax<=X&&(a.max=a.options.minRange?Math.max(X,a.min+a.minRange):X)),isNumber$N(a.min)&&isNumber$N(a.max)&&!this.chart.polar&&a.min>a.max&&(defined$R(a.options.min)?a.max=a.min:defined$R(a.options.max)&&(a.min=a.max)),a.min===a.max||typeof a.min>"u"||typeof a.max>"u"?a.tickInterval=1:k&&a.linkedParent&&!q&&z===a.linkedParent.options.tickPixelInterval?a.tickInterval=q=a.linkedParent.tickInterval:a.tickInterval=pick$1x(q,this.tickAmount?(a.max-a.min)/Math.max(this.tickAmount-1,1):void 0,$?1:(a.max-a.min)*z/Math.max(a.len,z)),P&&!d&&(a.series.forEach(function(ae){ae.forceCrop=ae.forceCropping&&ae.forceCropping(),ae.processData(a.min!==(a.old&&a.old.min)||a.max!==(a.old&&a.old.max))}),fireEvent$z(this,"postProcessData")),a.setAxisTranslation(),fireEvent$z(this,"initialAxisTranslation"),a.pointRange&&!q&&(a.tickInterval=Math.max(a.pointRange,a.tickInterval));var oe=pick$1x(C.minTickInterval,a.dateTime&&!a.series.some(function(ae){return ae.noSharedTooltip})?a.closestPointRange:0);!q&&a.tickInterval<oe&&(a.tickInterval=oe),!a.dateTime&&!a.logarithmic&&!q&&(a.tickInterval=normalizeTickInterval$2(a.tickInterval,void 0,getMagnitude$2(a.tickInterval),pick$1x(C.allowDecimals,a.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(a.tickInterval=a.unsquish()),this.setTickPositions()},g.prototype.setTickPositions=function(){var d=this,a=this.options,p=a.tickPositions,v=this.getMinorTickInterval(),C=this.hasVerticalPanning(),P=this.coll==="colorAxis",k=(P||!C)&&a.startOnTick,z=(P||!C)&&a.endOnTick,$,D=a.tickPositioner;this.tickmarkOffset=this.categories&&a.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=v==="auto"&&this.tickInterval?this.tickInterval/5:v,this.single=this.min===this.max&&defined$R(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||a.allowDecimals!==!1),this.tickPositions=$=p&&p.slice(),$||((!d.ordinal||!d.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?($=[this.min,this.max],error$9(19,!1,this.chart)):d.dateTime?$=d.getTimeTicks(d.dateTime.normalizeTimeTickInterval(this.tickInterval,a.units),this.min,this.max,a.startOfWeek,d.ordinal&&d.ordinal.positions,this.closestPointRange,!0):d.logarithmic?$=d.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):$=this.getLinearTickPositions(this.tickInterval,this.min,this.max),$.length>this.len&&($=[$[0],$.pop()],$[0]===$[1]&&($.length=1)),this.tickPositions=$,D&&(D=D.apply(d,[this.min,this.max]),D&&(this.tickPositions=$=D))),this.paddedTicks=$.slice(0),this.trimTicks($,k,z),this.isLinked||(this.single&&$.length<2&&!this.categories&&!this.series.some(function(F){return F.is("heatmap")&&F.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!p&&!D&&this.adjustTickAmount()),fireEvent$z(this,"afterSetTickPositions")},g.prototype.trimTicks=function(d,a,p){var v=d[0],C=d[d.length-1],P=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$z(this,"trimTicks"),!this.isLinked){if(a&&v!==-1/0)this.min=v;else for(;this.min-P>d[0];)d.shift();if(p)this.max=C;else for(;this.max+P<d[d.length-1];)d.pop();d.length===0&&defined$R(v)&&!this.options.tickPositions&&d.push((C+v)/2)}},g.prototype.alignToOthers=function(){var d=this,a={},p=d.options,v;return this.chart.options.chart.alignTicks!==!1&&p.alignTicks&&p.startOnTick!==!1&&p.endOnTick!==!1&&!d.logarithmic&&this.chart[this.coll].forEach(function(C){var P=C.options,k=C.horiz,z=[k?P.left:P.top,P.width,P.height,P.pane].join(",");C.series.length&&(a[z]?v=!0:a[z]=1)}),v},g.prototype.getTickAmount=function(){var d=this,a=this.options,p=a.tickPixelInterval,v=a.tickAmount;!defined$R(a.tickInterval)&&!v&&this.len<p&&!this.isRadial&&!d.logarithmic&&a.startOnTick&&a.endOnTick&&(v=2),!v&&this.alignToOthers()&&(v=Math.ceil(this.len/p)+1),v<4&&(this.finalTickAmt=v,v=5),this.tickAmount=v},g.prototype.adjustTickAmount=function(){var d=this,a=d.options,p=d.tickInterval,v=d.tickPositions,C=d.tickAmount,P=d.finalTickAmt,k=v&&v.length,z=pick$1x(d.threshold,d.softThreshold?0:null),$,D;if(d.hasData()&&isNumber$N(d.min)&&isNumber$N(d.max)){if(k<C){for(;v.length<C;)v.length%2||d.min===z?v.push(correctFloat$b(v[v.length-1]+p)):v.unshift(correctFloat$b(v[0]-p));d.transA*=(k-1)/(C-1),d.min=a.startOnTick?v[0]:Math.min(d.min,v[0]),d.max=a.endOnTick?v[v.length-1]:Math.max(d.max,v[v.length-1])}else k>C&&(d.tickInterval*=2,d.setTickPositions());if(defined$R(P)){for(D=$=v.length;D--;)(P===3&&D%2===1||P<=2&&D>0&&D<$-1)&&v.splice(D,1);d.finalTickAmt=void 0}}},g.prototype.setScale=function(){var d=this,a=!1,p=!1;d.series.forEach(function(C){a=a||C.isDirtyData||C.isDirty,p=p||C.xAxis&&C.xAxis.isDirty||!1}),d.setAxisSize();var v=d.len!==(d.old&&d.old.len);v||a||p||d.isLinked||d.forceRedraw||d.userMin!==(d.old&&d.old.userMin)||d.userMax!==(d.old&&d.old.userMax)||d.alignToOthers()?(d.stacking&&d.stacking.resetStacks(),d.forceRedraw=!1,d.getSeriesExtremes(),d.setTickInterval(),d.isDirty||(d.isDirty=v||d.min!==(d.old&&d.old.min)||d.max!==(d.old&&d.old.max))):d.stacking&&d.stacking.cleanStacks(),a&&d.panningState&&(d.panningState.isDirty=!0),fireEvent$z(this,"afterSetScale")},g.prototype.setExtremes=function(d,a,p,v,C){var P=this,k=P.chart;p=pick$1x(p,!0),P.series.forEach(function(z){delete z.kdTree}),C=extend$1q(C,{min:d,max:a}),fireEvent$z(P,"setExtremes",C,function(){P.userMin=d,P.userMax=a,P.eventArgs=C,p&&k.redraw(v)})},g.prototype.zoom=function(d,a){var p=this,v=this.dataMin,C=this.dataMax,P=this.options,k=Math.min(v,pick$1x(P.min,v)),z=Math.max(C,pick$1x(P.max,C)),$={newMin:d,newMax:a};return fireEvent$z(this,"zoom",$,function(D){var F=D.newMin,N=D.newMax;(F!==p.min||N!==p.max)&&(p.allowZoomOutside||(defined$R(v)&&(F<k&&(F=k),F>z&&(F=z)),defined$R(C)&&(N<k&&(N=k),N>z&&(N=z))),p.displayBtn=typeof F<"u"||typeof N<"u",p.setExtremes(F,N,!1,void 0,{trigger:"zoom"})),D.zoomed=!0}),$.zoomed},g.prototype.setAxisSize=function(){var d=this.chart,a=this.options,p=a.offsets||[0,0,0,0],v=this.horiz,C=this.width=Math.round(relativeLength$9(pick$1x(a.width,d.plotWidth-p[3]+p[1]),d.plotWidth)),P=this.height=Math.round(relativeLength$9(pick$1x(a.height,d.plotHeight-p[0]+p[2]),d.plotHeight)),k=this.top=Math.round(relativeLength$9(pick$1x(a.top,d.plotTop+p[0]),d.plotHeight,d.plotTop)),z=this.left=Math.round(relativeLength$9(pick$1x(a.left,d.plotLeft+p[3]),d.plotWidth,d.plotLeft));this.bottom=d.chartHeight-P-k,this.right=d.chartWidth-C-z,this.len=Math.max(v?C:P,0),this.pos=v?z:k},g.prototype.getExtremes=function(){var d=this,a=d.logarithmic;return{min:a?correctFloat$b(a.lin2log(d.min)):d.min,max:a?correctFloat$b(a.lin2log(d.max)):d.max,dataMin:d.dataMin,dataMax:d.dataMax,userMin:d.userMin,userMax:d.userMax}},g.prototype.getThreshold=function(d){var a=this,p=a.logarithmic,v=p?p.lin2log(a.min):a.min,C=p?p.lin2log(a.max):a.max;return d===null||d===-1/0?d=v:d===1/0?d=C:v>d?d=v:C<d&&(d=C),a.translate(d,0,1,0,1)},g.prototype.autoLabelAlign=function(d){var a=(pick$1x(d,0)-this.side*90+720)%360,p={align:"center"};return fireEvent$z(this,"autoLabelAlign",p,function(v){a>15&&a<165?v.align="right":a>195&&a<345&&(v.align="left")}),p.align},g.prototype.tickSize=function(d){var a=this.options,p=pick$1x(a[d==="tick"?"tickWidth":"minorTickWidth"],d==="tick"&&this.isXAxis&&!this.categories?1:0),v=a[d==="tick"?"tickLength":"minorTickLength"],C;p&&v&&(a[d+"Position"]==="inside"&&(v=-v),C=[v,p]);var P={tickSize:C};return fireEvent$z(this,"afterTickSize",P),P.tickSize},g.prototype.labelMetrics=function(){var d=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[d]&&this.ticks[d].label)},g.prototype.unsquish=function(){var d=this.options.labels,a=this.horiz,p=this.tickInterval,v=this.len/(((this.categories?1:0)+this.max-this.min)/p),C=d.rotation,P=this.labelMetrics(),k=Math.max(this.max-this.min,0),z=function(j){var q=j/(v||1);return q=q>1?Math.ceil(q):1,q*p>k&&j!==1/0&&v!==1/0&&k&&(q=Math.ceil(k/p)),correctFloat$b(q*p)},$=p,D,F,N=Number.MAX_VALUE,W;return a?(!d.staggerLines&&!d.step&&(isNumber$N(C)?W=[C]:v<d.autoRotationLimit&&(W=d.autoRotation)),W&&W.forEach(function(j){var q;(j===C||j&&j>=-90&&j<=90)&&(F=z(Math.abs(P.h/Math.sin(deg2rad$6*j))),q=F+Math.abs(j/360),q<N&&(N=q,D=j,$=F))})):d.step||($=z(P.h)),this.autoRotation=W,this.labelRotation=pick$1x(D,isNumber$N(C)?C:0),$},g.prototype.getSlotWidth=function(d){var a=this.chart,p=this.horiz,v=this.options.labels,C=Math.max(this.tickPositions.length-(this.categories?0:1),1),P=a.margin[3];if(d&&isNumber$N(d.slotWidth))return d.slotWidth;if(p&&v.step<2)return v.rotation?0:(this.staggerLines||1)*this.len/C;if(!p){var k=v.style.width;if(k!==void 0)return parseInt(String(k),10);if(P)return P-a.spacing[3]}return a.chartWidth*.33},g.prototype.renderUnsquish=function(){var d=this.chart,a=d.renderer,p=this.tickPositions,v=this.ticks,C=this.options.labels,P=C.style,k=this.horiz,z=this.getSlotWidth(),$=Math.max(1,Math.round(z-2*C.padding)),D={},F=this.labelMetrics(),N=P.textOverflow,W,j,q=0,X,K,ee;if(isString$8(C.rotation)||(D.rotation=C.rotation||0),p.forEach(function(te){var ie=v[te];ie.movedLabel&&ie.replaceMovedLabel(),ie&&ie.label&&ie.label.textPxLength>q&&(q=ie.label.textPxLength)}),this.maxLabelLength=q,this.autoRotation)q>$&&q>F.h?D.rotation=this.labelRotation:this.labelRotation=0;else if(z&&(W=$,!N))for(j="clip",K=p.length;!k&&K--;)ee=p[K],X=v[ee].label,X&&(X.styles&&X.styles.textOverflow==="ellipsis"?X.css({textOverflow:"clip"}):X.textPxLength>z&&X.css({width:z+"px"}),X.getBBox().height>this.len/p.length-(F.h-F.f)&&(X.specificTextOverflow="ellipsis"));D.rotation&&(W=q>d.chartHeight*.5?d.chartHeight*.33:q,N||(j="ellipsis")),this.labelAlign=C.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(D.align=this.labelAlign),p.forEach(function(te){var ie=v[te],oe=ie&&ie.label,ae=P.width,le={};oe&&(oe.attr(D),ie.shortenLabel?ie.shortenLabel():W&&!ae&&P.whiteSpace!=="nowrap"&&(W<oe.textPxLength||oe.element.tagName==="SPAN")?(le.width=W+"px",N||(le.textOverflow=oe.specificTextOverflow||j),oe.css(le)):oe.styles&&oe.styles.width&&!le.width&&!ae&&oe.css({width:null}),delete oe.specificTextOverflow,ie.rotation=D.rotation)},this),this.tickRotCorr=a.rotCorr(F.b,this.labelRotation||0,this.side!==0)},g.prototype.hasData=function(){return this.series.some(function(d){return d.hasData()})||this.options.showEmpty&&defined$R(this.min)&&defined$R(this.max)},g.prototype.addTitle=function(d){var a=this,p=a.chart.renderer,v=a.horiz,C=a.opposite,P=a.options,k=P.title,z=a.chart.styledMode,$;a.axisTitle||($=k.textAlign,$||($=(v?{low:"left",middle:"center",high:"right"}:{low:C?"right":"left",middle:"center",high:C?"left":"right"})[k.align]),a.axisTitle=p.text(k.text||"",0,0,k.useHTML).attr({zIndex:7,rotation:k.rotation,align:$}).addClass("highcharts-axis-title"),z||a.axisTitle.css(merge$1o(k.style)),a.axisTitle.add(a.axisGroup),a.axisTitle.isNew=!0),!z&&!k.style.width&&!a.isRadial&&a.axisTitle.css({width:a.len+"px"}),a.axisTitle[d?"show":"hide"](d)},g.prototype.generateTick=function(d){var a=this,p=a.ticks;p[d]?p[d].addLabel():p[d]=new Tick(a,d)},g.prototype.getOffset=function(){var d=this,a=this,p=a.chart,v=p.renderer,C=a.options,P=a.tickPositions,k=a.ticks,z=a.horiz,$=a.side,D=p.inverted&&!a.isZAxis?[1,0,3,2][$]:$,F=a.hasData(),N=C.title,W=C.labels,j=p.axisOffset,q=p.clipOffset,X=[-1,1,1,-1][$],K=C.className,ee=a.axisParent,te,ie=0,oe,ae=0,le=0,ce,ue;if(a.showAxis=te=F||C.showEmpty,a.staggerLines=a.horiz&&W.staggerLines||void 0,!a.axisGroup){var ge=function(ve,be,_e){return v.g(ve).attr({zIndex:_e}).addClass("highcharts-"+d.coll.toLowerCase()+be+" "+(d.isRadial?"highcharts-radial-axis"+be+" ":"")+(K||"")).add(ee)};a.gridGroup=ge("grid","-grid",C.gridZIndex),a.axisGroup=ge("axis","",C.zIndex),a.labelGroup=ge("axis-labels","-labels",W.zIndex)}F||a.isLinked?(P.forEach(function(ve){a.generateTick(ve)}),a.renderUnsquish(),a.reserveSpaceDefault=$===0||$===2||{1:"left",3:"right"}[$]===a.labelAlign,pick$1x(W.reserveSpace,a.labelAlign==="center"?!0:null,a.reserveSpaceDefault)&&P.forEach(function(ve){le=Math.max(k[ve].getLabelSize(),le)}),a.staggerLines&&(le*=a.staggerLines),a.labelOffset=le*(a.opposite?-1:1)):objectEach$u(k,function(ve,be){ve.destroy(),delete k[be]}),N&&N.text&&N.enabled!==!1&&(a.addTitle(te),te&&N.reserveSpace!==!1&&(a.titleOffset=ie=a.axisTitle.getBBox()[z?"height":"width"],oe=N.offset,ae=defined$R(oe)?0:pick$1x(N.margin,z?5:10))),a.renderLine(),a.offset=X*pick$1x(C.offset,j[$]?j[$]+(C.margin||0):0),a.tickRotCorr=a.tickRotCorr||{x:0,y:0},$===0?ue=-a.labelMetrics().h:$===2?ue=a.tickRotCorr.y:ue=0,ce=Math.abs(le)+ae,le&&(ce-=ue,ce+=X*(z?pick$1x(W.y,a.tickRotCorr.y+X*8):W.x)),a.axisTitleMargin=pick$1x(oe,ce),a.getMaxLabelDimensions&&(a.maxLabelDimensions=a.getMaxLabelDimensions(k,P));var ye=this.tickSize("tick");j[$]=Math.max(j[$],(a.axisTitleMargin||0)+ie+X*a.offset,ce,P&&P.length&&ye?ye[0]+X*a.offset:0);var we=C.offset?0:Math.floor(a.axisLine.strokeWidth()/2)*2;q[D]=Math.max(q[D],we),fireEvent$z(this,"afterGetOffset")},g.prototype.getLinePath=function(d){var a=this.chart,p=this.opposite,v=this.offset,C=this.horiz,P=this.left+(p?this.width:0)+v,k=a.chartHeight-this.bottom-(p?this.height:0)+v;return p&&(d*=-1),a.renderer.crispLine([["M",C?this.left:P,C?k:this.top],["L",C?a.chartWidth-this.right:P,C?k:a.chartHeight-this.bottom]],d)},g.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},g.prototype.getTitlePosition=function(){var d=this.horiz,a=this.left,p=this.top,v=this.len,C=this.options.title,P=d?a:p,k=this.opposite,z=this.offset,$=C.x,D=C.y,F=this.axisTitle,N=this.chart.renderer.fontMetrics(C.style.fontSize,F),W=Math.max(F.getBBox(null,0).height-N.h-1,0),j={low:P+(d?0:v),middle:P+v/2,high:P+(d?v:0)}[C.align],q=(d?p+this.height:a)+(d?1:-1)*(k?-1:1)*this.axisTitleMargin+[-W,W,N.f,-W][this.side],X={x:d?j+$:q+(k?this.width:0)+z+$,y:d?q+D-(k?this.height:0)+z:j+D};return fireEvent$z(this,"afterGetTitlePosition",{titlePosition:X}),X},g.prototype.renderMinorTick=function(d,a){var p=this,v=p.minorTicks;v[d]||(v[d]=new Tick(p,d,"minor")),a&&v[d].isNew&&v[d].render(null,!0),v[d].render(null,!1,1)},g.prototype.renderTick=function(d,a,p){var v=this,C=v.isLinked,P=v.ticks;(!C||d>=v.min&&d<=v.max||v.grid&&v.grid.isColumn)&&(P[d]||(P[d]=new Tick(v,d)),p&&P[d].isNew&&P[d].render(a,!0,-1),P[d].render(a))},g.prototype.render=function(){var d=this,a=d.chart,p=d.logarithmic,v=a.renderer,C=d.options,P=d.isLinked,k=d.tickPositions,z=d.axisTitle,$=d.ticks,D=d.minorTicks,F=d.alternateBands,N=C.stackLabels,W=C.alternateGridColor,j=d.tickmarkOffset,q=d.axisLine,X=d.showAxis,K=animObject$b(v.globalAnimation),ee,te;if(d.labelEdge.length=0,d.overlap=!1,[$,D,F].forEach(function(ae){objectEach$u(ae,function(le){le.isActive=!1})}),d.hasData()||P){var ie=d.chart.hasRendered&&d.old&&isNumber$N(d.old.min);d.minorTickInterval&&!d.categories&&d.getMinorTickPositions().forEach(function(ae){d.renderMinorTick(ae,ie)}),k.length&&(k.forEach(function(ae,le){d.renderTick(ae,le,ie)}),j&&(d.min===0||d.single)&&($[-1]||($[-1]=new Tick(d,-1,null,!0)),$[-1].render(-1))),W&&k.forEach(function(ae,le){te=typeof k[le+1]<"u"?k[le+1]+j:d.max-j,le%2===0&&ae<d.max&&te<=d.max+(a.polar?-j:j)&&(F[ae]||(F[ae]=new H.PlotLineOrBand(d)),ee=ae+j,F[ae].options={from:p?p.lin2log(ee):ee,to:p?p.lin2log(te):te,color:W,className:"highcharts-alternate-grid"},F[ae].render(),F[ae].isActive=!0)}),d._addedPlotLB||(d._addedPlotLB=!0,(C.plotLines||[]).concat(C.plotBands||[]).forEach(function(ae){d.addPlotBandOrLine(ae)}))}if([$,D,F].forEach(function(ae){var le=[],ce=K.duration,ue=function(){for(var ge=le.length;ge--;)ae[le[ge]]&&!ae[le[ge]].isActive&&(ae[le[ge]].destroy(),delete ae[le[ge]])};objectEach$u(ae,function(ge,ye){ge.isActive||(ge.render(ye,!1,0),ge.isActive=!1,le.push(ye))}),syncTimeout$7(ue,ae===F||!a.hasRendered||!ce?0:ce)}),q&&(q[q.isPlaced?"animate":"attr"]({d:this.getLinePath(q.strokeWidth())}),q.isPlaced=!0,q[X?"show":"hide"](X)),z&&X){var oe=d.getTitlePosition();isNumber$N(oe.y)?(z[z.isNew?"attr":"animate"](oe),z.isNew=!1):(z.attr("y",-9999),z.isNew=!0)}N&&N.enabled&&d.stacking&&d.stacking.renderStackTotals(),d.old={len:d.len,max:d.max,min:d.min,transA:d.transA,userMax:d.userMax,userMin:d.userMin},d.isDirty=!1,fireEvent$z(this,"afterRender")},g.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(d){d.render()})),this.series.forEach(function(d){d.isDirty=!0})},g.prototype.getKeepProps=function(){return this.keepProps||g.keepProps},g.prototype.destroy=function(d){var a=this,p=a.plotLinesAndBands,v=this.eventOptions;if(fireEvent$z(this,"destroy",{keepEvents:d}),d||removeEvent$9(a),[a.ticks,a.minorTicks,a.alternateBands].forEach(function(k){destroyObjectProperties$7(k)}),p)for(var C=p.length;C--;)p[C].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(k){a[k]&&(a[k]=a[k].destroy())});for(var P in a.plotLinesAndBandsGroups)a.plotLinesAndBandsGroups[P]=a.plotLinesAndBandsGroups[P].destroy();objectEach$u(a,function(k,z){a.getKeepProps().indexOf(z)===-1&&delete a[z]}),this.eventOptions=v},g.prototype.drawCrosshair=function(d,a){var p=this.crosshair,v=pick$1x(p&&p.snap,!0),C=this.chart,P,k,z,$=this.cross,D;if(fireEvent$z(this,"drawCrosshair",{e:d,point:a}),d||(d=this.cross&&this.cross.e),!p||(defined$R(a)||!v)===!1)this.hideCrosshair();else{if(v?defined$R(a)&&(k=pick$1x(this.coll!=="colorAxis"?a.crosshairPos:null,this.isXAxis?a.plotX:this.len-a.plotY)):k=d&&(this.horiz?d.chartX-this.pos:this.len-d.chartY+this.pos),defined$R(k)&&(D={value:a&&(this.isXAxis?a.x:pick$1x(a.stackY,a.y)),translatedValue:k},C.polar&&extend$1q(D,{isCrosshair:!0,chartX:d&&d.chartX,chartY:d&&d.chartY,point:a}),P=this.getPlotLinePath(D)||null),!defined$R(P)){this.hideCrosshair();return}z=this.categories&&!this.isRadial,$||(this.cross=$=C.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(z?"category ":"thin ")+(p.className||"")).attr({zIndex:pick$1x(p.zIndex,2)}).add(),C.styledMode||($.attr({stroke:p.color||(z?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1x(p.width,1)}).css({"pointer-events":"none"}),p.dashStyle&&$.attr({dashstyle:p.dashStyle}))),$.show().attr({d:P}),z&&!p.width&&$.attr({"stroke-width":this.transA}),this.cross.e=d}fireEvent$z(this,"afterDrawCrosshair",{e:d,point:a})},g.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$z(this,"afterHideCrosshair")},g.prototype.hasVerticalPanning=function(){var d=this.chart.options.chart.panning;return!!(d&&d.enabled&&/y/.test(d.type))},g.prototype.validatePositiveValue=function(d){return isNumber$N(d)&&d>0},g.prototype.update=function(d,a){var p=this.chart;d=merge$1o(this.userOptions,d),this.destroy(!0),this.init(p,d),p.isDirtyBox=!0,pick$1x(a,!0)&&p.redraw()},g.prototype.remove=function(d){for(var a=this.chart,p=this.coll,v=this.series,C=v.length;C--;)v[C]&&v[C].remove(!1);erase$8(a.axes,this),erase$8(a[p],this),a[p].forEach(function(P,k){P.options.index=P.userOptions.index=k}),this.destroy(),a.isDirtyBox=!0,pick$1x(d,!0)&&a.redraw()},g.prototype.setTitle=function(d,a){this.update({title:d},a)},g.prototype.setCategories=function(d,a){this.update({categories:d},a)},g.defaultOptions=AxisDefaults$1.defaultXAxisOptions,g.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],g})(),addEvent$15=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$2=Utilities.timeUnits,DateTimeAxis;(function(g){var d=[];function a(P){if(d.indexOf(P)===-1){d.push(P),P.keepProps.push("dateTime");var k=P.prototype;k.getTimeTicks=p,addEvent$15(P,"init",v)}return P}g.compose=a;function p(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function v(P){var k=this,z=P.userOptions;if(z.type!=="datetime"){k.dateTime=void 0;return}k.dateTime||(k.dateTime=new C(k))}var C=(function(){function P(k){this.axis=k}return P.prototype.normalizeTimeTickInterval=function(k,z){var $=z||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],D=$[$.length-1],F=timeUnits$2[D[0]],N=D[1],W;for(W=0;W<$.length;W++)if(D=$[W],F=timeUnits$2[D[0]],N=D[1],$[W+1]){var j=(F*N[N.length-1]+timeUnits$2[$[W+1][0]])/2;if(k<=j)break}F===timeUnits$2.year&&k<5*F&&(N=[1,2,5]);var q=normalizeTickInterval$1(k/F,N,D[0]==="year"?Math.max(getMagnitude$1(k/F),1):1);return{unitRange:F,count:q,unitName:D[0]}},P.prototype.getXDateFormat=function(k,z){var $=this.axis;return $.closestPointRange?$.chart.time.getDateFormat($.closestPointRange,k,$.options.startOfWeek,z)||z.year:z.day},P})();g.Additions=C})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$14=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1w=Utilities.pick,LogarithmicAxis;(function(g){var d=[];function a(P){return d.indexOf(P)===-1&&(d.push(P),P.keepProps.push("logarithmic"),addEvent$14(P,"init",p),addEvent$14(P,"afterInit",v)),P}g.compose=a;function p(P){var k=this,z=P.userOptions,$=k.logarithmic;z.type!=="logarithmic"?k.logarithmic=void 0:$||($=k.logarithmic=new C(k))}function v(){var P=this,k=P.logarithmic;k&&(P.lin2val=function(z){return k.lin2log(z)},P.val2lin=function(z){return k.log2lin(z)})}var C=(function(){function P(k){this.axis=k}return P.prototype.getLogTickPositions=function(k,z,$,D){var F=this,N=F.axis,W=N.len,j=N.options,q=[];if(D||(F.minorAutoInterval=void 0),k>=.5)k=Math.round(k),q=N.getLinearTickPositions(k,z,$);else if(k>=.08){var X=Math.floor(z),K=void 0,ee=void 0,te=void 0,ie=void 0,oe=void 0,ae=void 0,le=void 0;for(k>.3?K=[1,2,4]:k>.15?K=[1,2,4,6,8]:K=[1,2,3,4,5,6,7,8,9],ee=X;ee<$+1&&!le;ee++)for(ie=K.length,te=0;te<ie&&!le;te++)oe=F.log2lin(F.lin2log(ee)*K[te]),oe>z&&(!D||ae<=$)&&typeof ae<"u"&&q.push(ae),ae>$&&(le=!0),ae=oe}else{var ce=F.lin2log(z),ue=F.lin2log($),ge=D?N.getMinorTickInterval():j.tickInterval,ye=ge==="auto"?null:ge,we=j.tickPixelInterval/(D?5:1),ve=D?W/N.tickPositions.length:W;k=pick$1w(ye,F.minorAutoInterval,(ue-ce)*we/(ve||1)),k=normalizeTickInterval(k,void 0,getMagnitude(k)),q=N.getLinearTickPositions(k,ce,ue).map(F.log2lin),D||(F.minorAutoInterval=k/5)}return D||(N.tickInterval=k),q},P.prototype.lin2log=function(k){return Math.pow(10,k)},P.prototype.log2lin=function(k){return Math.log(k)/Math.LN10},P})();g.Additions=C})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$7=Utilities.erase,extend$1p=Utilities.extend,isNumber$M=Utilities.isNumber,PlotLineOrBandAxis;(function(g){var d=[],a;function p(C,P){return a||(a=C),d.indexOf(P)===-1&&(d.push(P),extend$1p(P.prototype,v.prototype)),P}g.compose=p;var v=(function(){function C(){}return C.prototype.getPlotBandPath=function(P,k,z){z===void 0&&(z=this.options);var $=this.getPlotLinePath({value:k,force:!0,acrossPanes:z.acrossPanes}),D=[],F=this.horiz,N=!isNumber$M(this.min)||!isNumber$M(this.max)||P<this.min&&k<this.min||P>this.max&&k>this.max,W=this.getPlotLinePath({value:P,force:!0,acrossPanes:z.acrossPanes}),j,q=1,X;if(W&&$)for(N&&(X=W.toString()===$.toString(),q=0),j=0;j<W.length;j+=2){var K=W[j],ee=W[j+1],te=$[j],ie=$[j+1];(K[0]==="M"||K[0]==="L")&&(ee[0]==="M"||ee[0]==="L")&&(te[0]==="M"||te[0]==="L")&&(ie[0]==="M"||ie[0]==="L")&&(F&&te[1]===K[1]?(te[1]+=q,ie[1]+=q):!F&&te[2]===K[2]&&(te[2]+=q,ie[2]+=q),D.push(["M",K[1],K[2]],["L",ee[1],ee[2]],["L",ie[1],ie[2]],["L",te[1],te[2]],["Z"])),D.isFlat=X}else W=null;return D},C.prototype.addPlotBand=function(P){return this.addPlotBandOrLine(P,"plotBands")},C.prototype.addPlotLine=function(P){return this.addPlotBandOrLine(P,"plotLines")},C.prototype.addPlotBandOrLine=function(P,k){var z=this,$=this.userOptions,D=new a(this,P);if(this.visible&&(D=D.render()),D){if(this._addedPlotLB||(this._addedPlotLB=!0,($.plotLines||[]).concat($.plotBands||[]).forEach(function(N){z.addPlotBandOrLine(N)})),k){var F=$[k]||[];F.push(P),$[k]=F}this.plotLinesAndBands.push(D)}return D},C.prototype.removePlotBandOrLine=function(P){var k=this.plotLinesAndBands,z=this.options,$=this.userOptions;if(k){for(var D=k.length;D--;)k[D].id===P&&k[D].destroy();[z.plotLines||[],$.plotLines||[],z.plotBands||[],$.plotBands||[]].forEach(function(F){for(D=F.length;D--;)(F[D]||{}).id===P&&erase$7(F,F[D])})}},C.prototype.removePlotBand=function(P){this.removePlotBandOrLine(P)},C.prototype.removePlotLine=function(P){this.removePlotBandOrLine(P)},C})()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$Q=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$6=Utilities.erase,fireEvent$y=Utilities.fireEvent,merge$1n=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1v=Utilities.pick,PlotLineOrBand=(function(){function g(d,a){this.axis=d,a&&(this.options=a,this.id=a.id)}return g.compose=function(d){return PlotLineOrBandAxis$1.compose(g,d)},g.prototype.render=function(){fireEvent$y(this,"render");var d=this,a=d.axis,p=a.horiz,v=a.logarithmic,C=d.options,P=C.color,k=pick$1v(C.zIndex,0),z=C.events,$={},D=a.chart.renderer,F=C.label,N=d.label,W=C.to,j=C.from,q=C.value,X=d.svgElem,K=[],ee,te=defined$Q(j)&&defined$Q(W),ie=defined$Q(q),oe=!X,ae={class:"highcharts-plot-"+(te?"band ":"line ")+(C.className||"")},le=te?"bands":"lines";if(v&&(j=v.log2lin(j),W=v.log2lin(W),q=v.log2lin(q)),a.chart.styledMode||(ie?(ae.stroke=P||palette.neutralColor40,ae["stroke-width"]=pick$1v(C.width,1),C.dashStyle&&(ae.dashstyle=C.dashStyle)):te&&(ae.fill=P||palette.highlightColor10,C.borderWidth&&(ae.stroke=C.borderColor,ae["stroke-width"]=C.borderWidth))),$.zIndex=k,le+="-"+k,ee=a.plotLinesAndBandsGroups[le],ee||(a.plotLinesAndBandsGroups[le]=ee=D.g("plot-"+le).attr($).add()),oe&&(d.svgElem=X=D.path().attr(ae).add(ee)),ie)K=a.getPlotLinePath({value:q,lineWidth:X.strokeWidth(),acrossPanes:C.acrossPanes});else if(te)K=a.getPlotBandPath(j,W,C);else return;return!d.eventsAdded&&z&&(objectEach$t(z,function(ce,ue){X.on(ue,function(ge){z[ue].apply(d,[ge])})}),d.eventsAdded=!0),(oe||!X.d)&&K&&K.length?X.attr({d:K}):X&&(K?(X.show(!0),X.animate({d:K})):X.d&&(X.hide(),N&&(d.label=N=N.destroy()))),F&&(defined$Q(F.text)||defined$Q(F.formatter))&&K&&K.length&&a.width>0&&a.height>0&&!K.isFlat?(F=merge$1n({align:p&&te&&"center",x:p?!te&&4:10,verticalAlign:!p&&te&&"middle",y:p?te?16:10:te?6:-4,rotation:p&&!te&&90},F),this.renderLabel(F,K,te,k)):N&&N.hide(),d},g.prototype.renderLabel=function(d,a,p,v){var C=this,P=C.axis,k=P.chart.renderer,z=C.label;z||(C.label=z=k.text(this.getLabelText(d),0,0,d.useHTML).attr({align:d.textAlign||d.align,rotation:d.rotation,class:"highcharts-plot-"+(p?"band":"line")+"-label "+(d.className||""),zIndex:v}).add(),P.chart.styledMode||z.css(merge$1n({textOverflow:"ellipsis"},d.style)));var $=a.xBounds||[a[0][1],a[1][1],p?a[2][1]:a[0][1]],D=a.yBounds||[a[0][2],a[1][2],p?a[2][2]:a[0][2]],F=arrayMin$7($),N=arrayMin$7(D);z.align(d,!1,{x:F,y:N,width:arrayMax$8($)-F,height:arrayMax$8(D)-N}),(!z.alignValue||z.alignValue==="left")&&z.css({width:(z.rotation===90?P.height-(z.alignAttr.y-P.top):P.width-(z.alignAttr.x-P.left))+"px"}),z.show(!0)},g.prototype.getLabelText=function(d){return defined$Q(d.formatter)?d.formatter.call(this):d.text},g.prototype.destroy=function(){erase$6(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},g})(),format$d=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$13=Utilities.addEvent,clamp$h=Utilities.clamp,css$9=Utilities.css,defined$P=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1o=Utilities.extend,fireEvent$x=Utilities.fireEvent,isArray$l=Utilities.isArray,isNumber$L=Utilities.isNumber,isString$7=Utilities.isString,merge$1m=Utilities.merge,pick$1u=Utilities.pick,splat$h=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=(function(){function g(d,a){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=d,this.init(d,a)}return g.prototype.applyFilter=function(){var d=this.chart;d.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+d.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},g.prototype.bodyFormatter=function(d){return d.map(function(a){var p=a.series.tooltipOptions;return(p[(a.point.formatPrefix||"point")+"Formatter"]||a.point.tooltipFormatter).call(a.point,p[(a.point.formatPrefix||"point")+"Format"]||"")})},g.prototype.cleanSplit=function(d){this.chart.series.forEach(function(a){var p=a&&a.tt;p&&(!p.isActive||d?a.tt=p.destroy():p.isActive=!1)})},g.prototype.defaultFormatter=function(d){var a=this.points||splat$h(this),p;return p=[d.tooltipFooterHeaderFormatter(a[0])],p=p.concat(d.bodyFormatter(a)),p.push(d.tooltipFooterHeaderFormatter(a[0],!0)),p},g.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},g.prototype.getAnchor=function(d,a){var p=this.chart,v=p.pointer,C=p.inverted,P=p.plotTop,k=p.plotLeft,z,$,D,F=0,N=0;return d=splat$h(d),this.followPointer&&a?(typeof a.chartX>"u"&&(a=v.normalize(a)),z=[a.chartX-k,a.chartY-P]):d[0].tooltipPos?z=d[0].tooltipPos:(d.forEach(function(W){$=W.series.yAxis,D=W.series.xAxis,F+=W.plotX||0,N+=W.plotLow?(W.plotLow+(W.plotHigh||0))/2:W.plotY||0,D&&$&&(C?(F+=P+p.plotHeight-D.len-D.pos,N+=k+p.plotWidth-$.len-$.pos):(F+=D.pos-k,N+=$.pos-P))}),F/=d.length,N/=d.length,z=[C?p.plotWidth-N:F,C?p.plotHeight-F:N],this.shared&&d.length>1&&a&&(C?z[0]=a.chartX-k:z[1]=a.chartY-P)),z.map(Math.round)},g.prototype.getLabel=function(){var d=this,a=this.chart.styledMode,p=this.options,v="tooltip"+(defined$P(p.className)?" "+p.className:""),C=p.style.pointerEvents||(!this.followPointer&&p.stickOnContact?"auto":"none"),P=function(){d.inContact=!0},k=function(q){var X=d.chart.hoverSeries;d.inContact=d.shouldStickOnContact()&&d.chart.pointer.inClass(q.relatedTarget,"highcharts-tooltip"),!d.inContact&&X&&X.onMouseOut&&X.onMouseOut()},z,$=this.chart.renderer;if(!this.label){if(this.outside){var D=this.chart.options.chart.style,F=RendererRegistry$1.getRendererType();this.container=z=H.doc.createElement("div"),z.className="highcharts-tooltip-container",css$9(z,{position:"absolute",top:"1px",pointerEvents:C,zIndex:Math.max(this.options.style.zIndex||0,(D&&D.zIndex||0)+3)}),addEvent$13(z,"mouseenter",P),addEvent$13(z,"mouseleave",k),H.doc.body.appendChild(z),this.renderer=$=new F(z,0,0,D,void 0,void 0,$.styledMode)}if(this.split?this.label=$.g(v):(this.label=$.label("",0,0,p.shape,void 0,void 0,p.useHTML,void 0,v).attr({padding:p.padding,r:p.borderRadius}),a||this.label.attr({fill:p.backgroundColor,"stroke-width":p.borderWidth}).css(p.style).css({pointerEvents:C}).shadow(p.shadow)),a&&p.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),d.outside&&!d.split){var N=this.label,W=N.xSetter,j=N.ySetter;N.xSetter=function(q){W.call(N,d.distance),z.style.left=q+"px"},N.ySetter=function(q){j.call(N,d.distance),z.style.top=q+"px"}}this.label.on("mouseenter",P).on("mouseleave",k).attr({zIndex:8}).add()}return this.label},g.prototype.getPosition=function(d,a,p){var v=this.chart,C=this.distance,P={},k=v.inverted&&p.h||0,z=this.outside,$=z?doc$i.documentElement.clientWidth-2*C:v.chartWidth,D=z?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):v.chartHeight,F=v.pointer.getChartPosition(),N=function(le){return le*F.scaleX},W=function(le){return le*F.scaleY},j=function(le){var ce=le==="x";return[le,ce?$:D,ce?d:a].concat(z?[ce?N(d):W(a),ce?F.left-C+N(p.plotX+v.plotLeft):F.top-C+W(p.plotY+v.plotTop),0,ce?$:D]:[ce?d:a,ce?p.plotX+v.plotLeft:p.plotY+v.plotTop,ce?v.plotLeft:v.plotTop,ce?v.plotLeft+v.plotWidth:v.plotTop+v.plotHeight])},q=j("y"),X=j("x"),K,ee=!this.followPointer&&pick$1u(p.ttBelow,!v.inverted==!!p.negative),te=function(le,ce,ue,ge,ye,we,ve){var be=z?le==="y"?W(C):N(C):C,_e=(ue-ge)/2,Ce=ge<ye-C,Ee=ye+C+ge<ce,Te=ye-be-ue+_e,$e=ye+be-_e;if(ee&&Ee)P[le]=$e;else if(!ee&&Ce)P[le]=Te;else if(Ce)P[le]=Math.min(ve-ge,Te-k<0?Te:Te-k);else if(Ee)P[le]=Math.max(we,$e+k+ue>ce?$e:$e+k);else return!1},ie=function(le,ce,ue,ge,ye){var we;return ye<C||ye>ce-C?we=!1:ye<ue/2?P[le]=1:ye>ce-ge/2?P[le]=ce-ge-2:P[le]=ye-ue/2,we},oe=function(le){var ce=q;q=X,X=ce,K=le},ae=function(){te.apply(0,q)!==!1?ie.apply(0,X)===!1&&!K&&(oe(!0),ae()):K?P.x=P.y=0:(oe(!0),ae())};return(v.inverted||this.len>1)&&oe(),ae(),P},g.prototype.hide=function(d){var a=this;Utilities.clearTimeout(this.hideTimer),d=pick$1u(d,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){a.getLabel().fadeOut(d&&void 0),a.isHidden=!0},d))},g.prototype.init=function(d,a){this.chart=d,this.options=a,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=a.split&&!d.inverted&&!d.polar,this.shared=a.shared||this.split,this.outside=pick$1u(a.outside,!!(d.scrollablePixelsX||d.scrollablePixelsY))},g.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},g.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},g.prototype.move=function(d,a,p,v){var C=this,P=C.now,k=C.options.animation!==!1&&!C.isHidden&&(Math.abs(d-P.x)>1||Math.abs(a-P.y)>1),z=C.followPointer||C.len>1;extend$1o(P,{x:k?(2*P.x+d)/3:d,y:k?(P.y+a)/2:a,anchorX:z?void 0:k?(2*P.anchorX+p)/3:p,anchorY:z?void 0:k?(P.anchorY+v)/2:v}),C.getLabel().attr(P),C.drawTracker(),k&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){C&&C.move(d,a,p,v)},32))},g.prototype.refresh=function(d,a){var p=this,v=this.chart,C=p.options,P=splat$h(d),k=P[0],z=[],$=C.formatter||p.defaultFormatter,D=p.shared,F=v.styledMode,N={};if(C.enabled){Utilities.clearTimeout(this.hideTimer),p.followPointer=!p.split&&k.series.tooltipOptions.followPointer;var W=p.getAnchor(d,a),j=W[0],q=W[1];D&&!(!isArray$l(d)&&d.series&&d.series.noSharedTooltip)?(v.pointer.applyInactiveState(P),P.forEach(function(oe){oe.setState("hover"),z.push(oe.getLabelConfig())}),N={x:k.category,y:k.y},N.points=z):N=k.getLabelConfig(),this.len=z.length;var X=$.call(N,p),K=k.series;if(this.distance=pick$1u(K.tooltipOptions.distance,16),X===!1)this.hide();else{if(p.split)this.renderSplit(X,P);else{var ee=j,te=q;if(a&&v.pointer.isDirectTouch&&(ee=a.chartX-v.plotLeft,te=a.chartY-v.plotTop),v.polar||K.options.clip===!1||K.shouldShowTooltip(ee,te)){var ie=p.getLabel();(!C.style.width||F)&&ie.css({width:this.chart.spacingBox.width+"px"}),ie.attr({text:X&&X.join?X.join(""):X}),ie.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1u(k.colorIndex,K.colorIndex)),F||ie.attr({stroke:C.borderColor||k.color||K.color||palette.neutralColor60}),p.updatePosition({plotX:j,plotY:q,negative:k.negative,ttBelow:k.ttBelow,h:W[2]||0})}else{p.hide();return}}p.isHidden&&p.label&&p.label.attr({opacity:1}).show(),p.isHidden=!1}fireEvent$x(this,"refresh")}},g.prototype.renderSplit=function(d,a){var p=this,v=p.chart,C=p.chart,P=C.chartWidth;C.chartHeight;var k=C.plotHeight,z=C.plotLeft,$=C.plotTop,D=C.pointer,F=C.scrollablePixelsY,N=F===void 0?0:F,W=C.scrollablePixelsX,j=C.scrollingContainer,q=j===void 0?{scrollLeft:0,scrollTop:0}:j,X=q.scrollLeft,K=q.scrollTop,ee=C.styledMode,te=p.distance,ie=p.options,oe=p.options.positioner,ae=p.outside&&typeof W!="number"?doc$i.documentElement.getBoundingClientRect():{left:X,right:X+P},le=p.getLabel(),ce=this.renderer||v.renderer,ue=!!(v.xAxis[0]&&v.xAxis[0].opposite),ge=D.getChartPosition(),ye=ge.left,we=ge.top,ve=$+K,be=0,_e=k-N;function Ce(lt){var pt=lt.isHeader,mt=lt.plotX,Dt=mt===void 0?0:mt,Ct=lt.plotY,Mt=Ct===void 0?0:Ct,St=lt.series,Gt,At;if(pt)Gt=z+Dt,At=$+k/2;else{var ai=St.xAxis,Kt=St.yAxis;Gt=ai.pos+clamp$h(Dt,-te,ai.len+te),St.shouldShowTooltip(0,Kt.pos-$+Mt,{ignoreX:!0})&&(At=Kt.pos+Mt)}return Gt=clamp$h(Gt,ae.left-te,ae.right+te),{anchorX:Gt,anchorY:At}}function Ee(lt,pt,mt,Dt,Ct){Ct===void 0&&(Ct=!0);var Mt,St;return mt?(Mt=ue?0:_e,St=clamp$h(lt-Dt/2,ae.left,ae.right-Dt-(p.outside?ye:0))):(Mt=pt-ve,St=Ct?lt-Dt-te:lt+te,St=clamp$h(St,Ct?St:ae.left,ae.right)),{x:St,y:Mt}}function Te(lt,pt,mt){var Dt=lt,Ct=pt.isHeader,Mt=pt.series,St="highcharts-color-"+pick$1u(pt.colorIndex,Mt.colorIndex,"none");if(!Dt){var Gt={padding:ie.padding,r:ie.borderRadius};ee||(Gt.fill=ie.backgroundColor,Gt["stroke-width"]=ie.borderWidth),Dt=ce.label("",0,0,ie[Ct?"headerShape":"shape"],void 0,void 0,ie.useHTML).addClass((Ct?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+St).attr(Gt).add(le)}return Dt.isActive=!0,Dt.attr({text:mt}),ee||Dt.css(ie.style).shadow(ie.shadow).attr({stroke:ie.borderColor||pt.color||Mt.color||palette.neutralColor80}),Dt}isString$7(d)&&(d=[!1,d]);var $e=d.slice(0,a.length+1).reduce(function(lt,pt,mt){if(pt!==!1&&pt!==""){var Dt=a[mt-1]||{isHeader:!0,plotX:a[0].plotX,plotY:k,series:{}},Ct=Dt.isHeader,Mt=Ct?p:Dt.series,St=Mt.tt=Te(Mt.tt,Dt,pt.toString()),Gt=St.getBBox(),At=Gt.width+St.strokeWidth();Ct&&(be=Gt.height,_e+=be,ue&&(ve-=be));var ai=Ce(Dt),Kt=ai.anchorX,oi=ai.anchorY;if(typeof oi=="number"){var ci=Gt.height+1,dt=oe?oe.call(p,At,ci,Dt):Ee(Kt,oi,Ct,At);lt.push({align:oe?0:void 0,anchorX:Kt,anchorY:oi,boxWidth:At,point:Dt,rank:pick$1u(dt.rank,Ct?1:0),size:ci,target:dt.y,tt:St,x:dt.x})}else St.isActive=!1}return lt},[]);!oe&&$e.some(function(lt){var pt=p.outside,mt=(pt?ye:0)+lt.anchorX;return mt<ae.left&&mt+lt.boxWidth<ae.right?!0:mt<ye-ae.left+lt.boxWidth&&ae.right-mt>mt})&&($e=$e.map(function(lt){var pt=Ee(lt.anchorX,lt.anchorY,lt.point.isHeader,lt.boxWidth,!1),mt=pt.x,Dt=pt.y;return extend$1o(lt,{target:Dt,x:mt})})),p.cleanSplit(),distribute$3($e,_e);var Ge={left:ye,right:ye};$e.forEach(function(lt){var pt=lt.x,mt=lt.boxWidth,Dt=lt.isHeader;Dt||(p.outside&&ye+pt<Ge.left&&(Ge.left=ye+pt),!Dt&&p.outside&&Ge.left+mt>Ge.right&&(Ge.right=ye+pt))}),$e.forEach(function(lt){var pt=lt.x,mt=lt.anchorX,Dt=lt.anchorY,Ct=lt.pos,Mt=lt.point.isHeader,St={visibility:typeof Ct>"u"?"hidden":"inherit",x:pt,y:Ct+ve,anchorX:mt,anchorY:Dt};if(p.outside&&pt<mt){var Gt=ye-Ge.left;Gt>0&&(Mt||(St.x=pt+Gt,St.anchorX=mt+Gt),Mt&&(St.x=(Ge.right-Ge.left)/2,St.anchorX=mt+Gt))}lt.tt.attr(St)});var Ne=p.container,ke=p.outside,Fe=p.renderer;if(ke&&Ne&&Fe){var We=le.getBBox(),De=We.width,nt=We.height,gt=We.x,at=We.y;Fe.setSize(De+gt,nt+at,!1),Ne.style.left=Ge.left+"px",Ne.style.top=we+"px"}},g.prototype.drawTracker=function(){var d=this;if(d.followPointer||!d.options.stickOnContact){d.tracker&&d.tracker.destroy();return}var a=d.chart,p=d.label,v=d.shared?a.hoverPoints:a.hoverPoint;if(!(!p||!v)){var C={x:0,y:0,width:0,height:0},P=this.getAnchor(v),k=p.getBBox();P[0]+=a.plotLeft-p.translateX,P[1]+=a.plotTop-p.translateY,C.x=Math.min(0,P[0]),C.y=Math.min(0,P[1]),C.width=P[0]<0?Math.max(Math.abs(P[0]),k.width-P[0]):Math.max(Math.abs(P[0]),k.width),C.height=P[1]<0?Math.max(Math.abs(P[1]),k.height-Math.abs(P[1])):Math.max(Math.abs(P[1]),k.height),d.tracker?d.tracker.attr(C):(d.tracker=p.renderer.rect(C).addClass("highcharts-tracker").add(p),a.styledMode||d.tracker.attr({fill:"rgba(0,0,0,0)"}))}},g.prototype.styledModeFormat=function(d){return d.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},g.prototype.tooltipFooterHeaderFormatter=function(d,a){var p=d.series,v=p.tooltipOptions,C=p.xAxis,P=C&&C.dateTime,k={isFooter:a,labelConfig:d},z=v.xDateFormat,$=v[a?"footerFormat":"headerFormat"];return fireEvent$x(this,"headerFormatter",k,function(D){P&&!z&&isNumber$L(d.key)&&(z=P.getXDateFormat(d.key,v.dateTimeLabelFormats)),P&&z&&(d.point&&d.point.tooltipDateKeys||["key"]).forEach(function(F){$=$.replace("{point."+F+"}","{point."+F+":"+z+"}")}),p.chart.styledMode&&($=this.styledModeFormat($)),D.text=format$d($,{point:d,series:p},this.chart)}),k.text},g.prototype.update=function(d){this.destroy(),merge$1m(!0,this.chart.options.tooltip.userOptions,d),this.init(this.chart,merge$1m(!0,this.options,d))},g.prototype.updatePosition=function(d){var a=this.chart,p=this.options,v=a.pointer,C=this.getLabel(),P=v.getChartPosition(),k=(p.positioner||this.getPosition).call(this,C.width,C.height,d),z=d.plotX+a.plotLeft,$=d.plotY+a.plotTop,D;this.outside&&(D=p.borderWidth+2*this.distance,this.renderer.setSize(C.width+D,C.height+D,!1),(P.scaleX!==1||P.scaleY!==1)&&(css$9(this.container,{transform:"scale("+P.scaleX+", "+P.scaleY+")"}),z*=P.scaleX,$*=P.scaleY),z+=P.left-k.x,$+=P.top-k.y),this.move(Math.round(k.x),Math.round(k.y||0),z,$)},g})(),animObject$a=animationExports.animObject,defaultOptions$g=DefaultOptions.defaultOptions,format$c=FormatUtilities.format,addEvent$12=Utilities.addEvent,defined$O=Utilities.defined,erase$5=Utilities.erase,extend$1n=Utilities.extend,fireEvent$w=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$k=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$K=Utilities.isNumber,isObject$e=Utilities.isObject,merge$1l=Utilities.merge,objectEach$s=Utilities.objectEach,pick$1t=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$4=(function(){function g(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return g.prototype.animateBeforeDestroy=function(){var d=this,a={x:d.startXPos,opacity:0},p=d.getGraphicalProps();p.singular.forEach(function(v){var C=v==="dataLabel";d[v]=d[v].animate(C?{x:d[v].startXPos,y:d[v].startYPos,opacity:0}:a)}),p.plural.forEach(function(v){d[v].forEach(function(C){C.element&&C.animate(extend$1n({x:d.startXPos},C.startYPos?{x:C.startXPos,y:C.startYPos}:{}))})})},g.prototype.applyOptions=function(d,a){var p=this,v=p.series,C=v.options.pointValKey||v.pointValKey;return d=g.prototype.optionsToObject.call(this,d),extend$1n(p,d),p.options=p.options?extend$1n(p.options,d):d,d.group&&delete p.group,d.dataLabels&&delete p.dataLabels,C&&(p.y=g.prototype.getNestedProperty.call(p,C)),p.isNull=pick$1t(p.isValid&&!p.isValid(),p.x===null||!isNumber$K(p.y)),p.formatPrefix=p.isNull?"null":"point",p.selected&&(p.state="select"),"name"in p&&typeof a>"u"&&v.xAxis&&v.xAxis.hasNames&&(p.x=v.xAxis.nameToX(p)),typeof p.x>"u"&&v?typeof a>"u"?p.x=v.autoIncrement():p.x=a:isNumber$K(d.x)&&v.options.relativeXValue&&(p.x=v.autoIncrement(d.x)),p},g.prototype.destroy=function(){var d=this,a=d.series,p=a.chart,v=a.options.dataSorting,C=p.hoverPoints,P=d.series.chart.renderer.globalAnimation,k=animObject$a(P),z;function $(){(d.graphic||d.dataLabel||d.dataLabels)&&(removeEvent$8(d),d.destroyElements());for(z in d)d[z]=null}d.legendItem&&p.legend.destroyItem(d),C&&(d.setState(),erase$5(C,d),C.length||(p.hoverPoints=null)),d===p.hoverPoint&&d.onMouseOut(),!v||!v.enabled?$():(this.animateBeforeDestroy(),syncTimeout$5($,k.duration)),p.pointCount--},g.prototype.destroyElements=function(d){var a=this,p=a.getGraphicalProps(d);p.singular.forEach(function(v){a[v]=a[v].destroy()}),p.plural.forEach(function(v){a[v].forEach(function(C){C.element&&C.destroy()}),delete a[v]})},g.prototype.firePointEvent=function(d,a,p){var v=this,C=this.series,P=C.options;(P.point.events[d]||v.options&&v.options.events&&v.options.events[d])&&v.importEvents(),d==="click"&&P.allowPointSelect&&(p=function(k){v.select&&v.select(null,k.ctrlKey||k.metaKey||k.shiftKey)}),fireEvent$w(v,d,a,p)},g.prototype.getClassName=function(){var d=this;return"highcharts-point"+(d.selected?" highcharts-point-select":"")+(d.negative?" highcharts-negative":"")+(d.isNull?" highcharts-null-point":"")+(typeof d.colorIndex<"u"?" highcharts-color-"+d.colorIndex:"")+(d.options.className?" "+d.options.className:"")+(d.zone&&d.zone.className?" "+d.zone.className.replace("highcharts-negative",""):"")},g.prototype.getGraphicalProps=function(d){var a=this,p=[],v={singular:[],plural:[]},C,P;for(d=d||{graphic:1,dataLabel:1},d.graphic&&p.push("graphic","upperGraphic","shadowGroup"),d.dataLabel&&p.push("dataLabel","dataLabelUpper","connector"),P=p.length;P--;)C=p[P],a[C]&&v.singular.push(C);return["dataLabel","connector"].forEach(function(k){var z=k+"s";d[k]&&a[z]&&v.plural.push(z)}),v},g.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},g.prototype.getNestedProperty=function(d){if(d)return d.indexOf("custom.")===0?getNestedProperty$1(d,this.options):this[d]},g.prototype.getZone=function(){var d=this.series,a=d.zones,p=d.zoneAxis||"y",v,C=0;for(v=a[C];this[p]>=v.value;)v=a[++C];return this.nonZonedColor||(this.nonZonedColor=this.color),v&&v.color&&!this.options.color?this.color=v.color:this.color=this.nonZonedColor,v},g.prototype.hasNewShapeType=function(){var d=this,a=d.graphic&&(d.graphic.symbolName||d.graphic.element.nodeName);return a!==this.shapeType},g.prototype.init=function(d,a,p){return this.series=d,this.applyOptions(a,p),this.id=defined$O(this.id)?this.id:uniqueKey$5(),this.resolveColor(),d.chart.pointCount++,fireEvent$w(this,"afterInit"),this},g.prototype.optionsToObject=function(d){var a=this.series,p=a.options.keys,v=p||a.pointArrayMap||["y"],C=v.length,P={},k,z=0,$=0;if(isNumber$K(d)||d===null)P[v[0]]=d;else if(isArray$k(d))for(!p&&d.length>C&&(k=typeof d[0],k==="string"?P.name=d[0]:k==="number"&&(P.x=d[0]),z++);$<C;)(!p||typeof d[z]<"u")&&(v[$].indexOf(".")>0?g.prototype.setNestedProperty(P,d[z],v[$]):P[v[$]]=d[z]),z++,$++;else typeof d=="object"&&(P=d,d.dataLabels&&(a._hasPointLabels=!0),d.marker&&(a._hasPointMarkers=!0));return P},g.prototype.resolveColor=function(){var d=this.series,a=d.chart.options.chart,p=d.chart.styledMode,v,C,P=a.colorCount,k;delete this.nonZonedColor,d.options.colorByPoint?(p||(C=d.options.colors||d.chart.options.colors,v=C[d.colorCounter],P=C.length),k=d.colorCounter,d.colorCounter++,d.colorCounter===P&&(d.colorCounter=0)):(p||(v=d.color),k=d.colorIndex),this.colorIndex=pick$1t(this.options.colorIndex,k),this.color=pick$1t(this.options.color,v)},g.prototype.setNestedProperty=function(d,a,p){var v=p.split(".");return v.reduce(function(C,P,k,z){var $=z.length-1===k;return C[P]=$?a:isObject$e(C[P],!0)?C[P]:{},C[P]},d),d},g.prototype.tooltipFormatter=function(d){var a=this.series,p=a.tooltipOptions,v=pick$1t(p.valueDecimals,""),C=p.valuePrefix||"",P=p.valueSuffix||"";return a.chart.styledMode&&(d=a.chart.tooltip.styledModeFormat(d)),(a.pointArrayMap||["y"]).forEach(function(k){k="{point."+k,(C||P)&&(d=d.replace(RegExp(k+"}","g"),C+k+"}"+P)),d=d.replace(RegExp(k+"}","g"),k+":,."+v+"f}")}),format$c(d,{point:this,series:this.series},a.chart)},g.prototype.update=function(d,a,p,v){var C=this,P=C.series,k=C.graphic,z=P.chart,$=P.options,D;a=pick$1t(a,!0);function F(){C.applyOptions(d);var N=k&&C.hasDummyGraphic,W=C.y===null?!N:N;k&&W&&(C.graphic=k.destroy(),delete C.hasDummyGraphic),isObject$e(d,!0)&&(k&&k.element&&d&&d.marker&&typeof d.marker.symbol<"u"&&(C.graphic=k.destroy()),d&&d.dataLabels&&C.dataLabel&&(C.dataLabel=C.dataLabel.destroy()),C.connector&&(C.connector=C.connector.destroy())),D=C.index,P.updateParallelArrays(C,D),$.data[D]=isObject$e($.data[D],!0)||isObject$e(d,!0)?C.options:pick$1t(d,$.data[D]),P.isDirty=P.isDirtyData=!0,!P.fixedBox&&P.hasCartesianSeries&&(z.isDirtyBox=!0),$.legendType==="point"&&(z.isDirtyLegend=!0),a&&z.redraw(p)}v===!1?F():C.firePointEvent("update",{options:d},F)},g.prototype.remove=function(d,a){this.series.removePoint(this.series.data.indexOf(this),d,a)},g.prototype.select=function(d,a){var p=this,v=p.series,C=v.chart;d=pick$1t(d,!p.selected),this.selectedStaging=d,p.firePointEvent(d?"select":"unselect",{accumulate:a},function(){p.selected=p.options.selected=d,v.options.data[v.data.indexOf(p)]=p.options,p.setState(d&&"select"),a||C.getSelectedPoints().forEach(function(P){var k=P.series;P.selected&&P!==p&&(P.selected=P.options.selected=!1,k.options.data[k.data.indexOf(P)]=P.options,P.setState(C.hoverPoints&&k.options.inactiveOtherPoints?"inactive":""),P.firePointEvent("unselect"))})}),delete this.selectedStaging},g.prototype.onMouseOver=function(d){var a=this,p=a.series,v=p.chart,C=v.pointer;d=d?C.normalize(d):C.getChartCoordinatesFromPoint(a,v.inverted),C.runPointActions(d,a)},g.prototype.onMouseOut=function(){var d=this,a=d.series.chart;d.firePointEvent("mouseOut"),d.series.options.inactiveOtherPoints||(a.hoverPoints||[]).forEach(function(p){p.setState()}),a.hoverPoints=a.hoverPoint=null},g.prototype.importEvents=function(){if(!this.hasImportedEvents){var d=this,a=merge$1l(d.series.options.point,d.options),p=a.events;d.events=p,objectEach$s(p,function(v,C){isFunction$2(v)&&addEvent$12(d,C,v)}),this.hasImportedEvents=!0}},g.prototype.setState=function(d,a){var p=this,v=p.series,C=p.state,P=v.options.states[d||"normal"]||{},k=defaultOptions$g.plotOptions[v.type].marker&&v.options.marker,z=k&&k.enabled===!1,$=k&&k.states&&k.states[d||"normal"]||{},D=$.enabled===!1,F=p.marker||{},N=v.chart,W=k&&v.markerAttribs,j=v.halo,q,X,K,ee=v.stateMarkerGraphic,te;if(d=d||"",!(d===p.state&&!a||p.selected&&d!=="select"||P.enabled===!1||d&&(D||z&&$.enabled===!1)||d&&F.states&&F.states[d]&&F.states[d].enabled===!1)){p.state=d,W&&(q=v.markerAttribs(p,d)),p.graphic&&!p.hasDummyGraphic?(C&&p.graphic.removeClass("highcharts-point-"+C),d&&p.graphic.addClass("highcharts-point-"+d),N.styledMode||(X=v.pointAttribs(p,d),K=pick$1t(N.options.chart.animation,P.animation),v.options.inactiveOtherPoints&&isNumber$K(X.opacity)&&((p.dataLabels||[]).forEach(function(le){le&&le.animate({opacity:X.opacity},K)}),p.connector&&p.connector.animate({opacity:X.opacity},K)),p.graphic.animate(X,K)),q&&p.graphic.animate(q,pick$1t(N.options.chart.animation,$.animation,k.animation)),ee&&ee.hide()):(d&&$&&(te=F.symbol||v.symbol,ee&&ee.currentSymbol!==te&&(ee=ee.destroy()),q&&(ee?ee[a?"animate":"attr"]({x:q.x,y:q.y}):te&&(v.stateMarkerGraphic=ee=N.renderer.symbol(te,q.x,q.y,q.width,q.height).add(v.markerGroup),ee.currentSymbol=te)),!N.styledMode&&ee&&ee.attr(v.pointAttribs(p,d))),ee&&(ee[d&&p.isInside?"show":"hide"](),ee.element.point=p,ee.addClass(p.getClassName(),!0)));var ie=P.halo,oe=p.graphic||ee,ae=oe&&oe.visibility||"inherit";ie&&ie.size&&oe&&ae!=="hidden"&&!p.isCluster?(j||(v.halo=j=N.renderer.path().add(oe.parentGroup)),j.show()[a?"animate":"attr"]({d:p.haloPath(ie.size)}),j.attr({class:"highcharts-halo highcharts-color-"+pick$1t(p.colorIndex,v.colorIndex)+(p.className?" "+p.className:""),visibility:ae,zIndex:-1}),j.point=p,N.styledMode||j.attr(extend$1n({fill:p.color||v.color,"fill-opacity":ie.opacity},AST.filterUserAttributes(ie.attributes||{})))):j&&j.point&&j.point.haloPath&&j.animate({d:j.point.haloPath(0)},null,j.hide),fireEvent$w(p,"afterSetState",{state:d})}},g.prototype.haloPath=function(d){var a=this.series,p=a.chart;return p.renderer.symbols.circle(Math.floor(this.plotX)-d,this.plotY-d,d*2,d*2)},g})(),color$e=Color.parse,charts$3=H.charts,noop$i=H.noop,addEvent$11=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$N=Utilities.defined,extend$1m=Utilities.extend,find$k=Utilities.find,fireEvent$v=Utilities.fireEvent,isNumber$J=Utilities.isNumber,isObject$d=Utilities.isObject,objectEach$r=Utilities.objectEach,offset=Utilities.offset,pick$1s=Utilities.pick,splat$g=Utilities.splat,Pointer=(function(){function g(d,a){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=d,this.hasDragged=!1,this.options=a,this.init(d,a)}return g.prototype.applyInactiveState=function(d){var a=[],p;(d||[]).forEach(function(v){p=v.series,a.push(p),p.linkedParent&&a.push(p.linkedParent),p.linkedSeries&&(a=a.concat(p.linkedSeries)),p.navigatorSeries&&a.push(p.navigatorSeries)}),this.chart.series.forEach(function(v){a.indexOf(v)===-1?v.setState("inactive",!0):v.options.inactiveOtherPoints&&v.setAllPointsToState("inactive")})},g.prototype.destroy=function(){var d=this;this.eventsToUnbind.forEach(function(a){return a()}),this.eventsToUnbind=[],H.chartCount||(g.unbindDocumentMouseUp&&(g.unbindDocumentMouseUp=g.unbindDocumentMouseUp()),g.unbindDocumentTouchEnd&&(g.unbindDocumentTouchEnd=g.unbindDocumentTouchEnd())),clearInterval(d.tooltipTimeout),objectEach$r(d,function(a,p){d[p]=void 0})},g.prototype.drag=function(d){var a=this.chart,p=a.options.chart,v=this.zoomHor,C=this.zoomVert,P=a.plotLeft,k=a.plotTop,z=a.plotWidth,$=a.plotHeight,D=this.mouseDownX||0,F=this.mouseDownY||0,N=isObject$d(p.panning)?p.panning&&p.panning.enabled:p.panning,W=p.panKey&&d[p.panKey+"Key"],j=d.chartX,q=d.chartY,X,K,ee=this.selectionMarker;ee&&ee.touch||(j<P?j=P:j>P+z&&(j=P+z),q<k?q=k:q>k+$&&(q=k+$),this.hasDragged=Math.sqrt(Math.pow(D-j,2)+Math.pow(F-q,2)),this.hasDragged>10&&(X=a.isInsidePlot(D-P,F-k,{visiblePlotOnly:!0}),a.hasCartesianSeries&&(this.zoomX||this.zoomY)&&X&&!W&&(ee||(this.selectionMarker=ee=a.renderer.rect(P,k,v?1:z,C?1:$,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),a.styledMode||ee.attr({fill:p.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),ee&&v&&(K=j-D,ee.attr({width:Math.abs(K),x:(K>0?0:K)+D})),ee&&C&&(K=q-F,ee.attr({height:Math.abs(K),y:(K>0?0:K)+F})),X&&!ee&&N&&a.pan(d,p.panning)))},g.prototype.dragStart=function(d){var a=this.chart;a.mouseIsDown=d.type,a.cancelClick=!1,a.mouseDownX=this.mouseDownX=d.chartX,a.mouseDownY=this.mouseDownY=d.chartY},g.prototype.drop=function(d){var a=this,p=this.chart,v=this.hasPinched;if(this.selectionMarker){var C={originalEvent:d,xAxis:[],yAxis:[]},P=this.selectionMarker,k=P.attr?P.attr("x"):P.x,z=P.attr?P.attr("y"):P.y,$=P.attr?P.attr("width"):P.width,D=P.attr?P.attr("height"):P.height,F;(this.hasDragged||v)&&(p.axes.forEach(function(N){if(N.zoomEnabled&&defined$N(N.min)&&(v||a[{xAxis:"zoomX",yAxis:"zoomY"}[N.coll]])&&isNumber$J(k)&&isNumber$J(z)){var W=N.horiz,j=d.type==="touchend"?N.minPixelPadding:0,q=N.toValue((W?k:z)+j),X=N.toValue((W?k+$:z+D)-j);C[N.coll].push({axis:N,min:Math.min(q,X),max:Math.max(q,X)}),F=!0}}),F&&fireEvent$v(p,"selection",C,function(N){p.zoom(extend$1m(N,v?{animation:!1}:null))})),isNumber$J(p.index)&&(this.selectionMarker=this.selectionMarker.destroy()),v&&this.scaleGroups()}p&&isNumber$J(p.index)&&(css$8(p.container,{cursor:p._cursor}),p.cancelClick=this.hasDragged>10,p.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},g.prototype.findNearestKDPoint=function(d,a,p){var v=this.chart,C=v.hoverPoint,P=v.tooltip;if(C&&P&&P.isStickyOnContact())return C;var k;function z($,D){var F=$.distX-D.distX,N=$.dist-D.dist,W=(D.series.group&&D.series.group.zIndex)-($.series.group&&$.series.group.zIndex),j;return F!==0&&a?j=F:N!==0?j=N:W!==0?j=W:j=$.series.index>D.series.index?-1:1,j}return d.forEach(function($){var D=$.noSharedTooltip&&a,F=!D&&$.options.findNearestPointBy.indexOf("y")<0,N=$.searchPoint(p,F);isObject$d(N,!0)&&N.series&&(!isObject$d(k,!0)||z(k,N)>0)&&(k=N)}),k},g.prototype.getChartCoordinatesFromPoint=function(d,a){var p=d.series,v=p.xAxis,C=p.yAxis,P=d.shapeArgs;if(v&&C){var k=pick$1s(d.clientX,d.plotX),z=d.plotY||0;return d.isNode&&P&&isNumber$J(P.x)&&isNumber$J(P.y)&&(k=P.x,z=P.y),a?{chartX:C.len+C.pos-z,chartY:v.len+v.pos-k}:{chartX:k+v.pos,chartY:z+C.pos}}if(P&&P.x&&P.y)return{chartX:P.x,chartY:P.y}},g.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var d=this.chart.container,a=offset(d);this.chartPosition={left:a.left,top:a.top,scaleX:1,scaleY:1};var p=d.offsetWidth,v=d.offsetHeight;return p>2&&v>2&&(this.chartPosition.scaleX=a.width/p,this.chartPosition.scaleY=a.height/v),this.chartPosition},g.prototype.getCoordinates=function(d){var a={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(p){a[p.isXAxis?"xAxis":"yAxis"].push({axis:p,value:p.toValue(d[p.horiz?"chartX":"chartY"])})}),a},g.prototype.getHoverData=function(d,a,p,v,C,P){var k=[],z=!!(v&&d),$=function(q){return q.visible&&!(!C&&q.directTouch)&&pick$1s(q.options.enableMouseTracking,!0)},D=a,F,N={chartX:P?P.chartX:void 0,chartY:P?P.chartY:void 0,shared:C};fireEvent$v(this,"beforeGetHoverData",N);var W=D&&!D.stickyTracking;F=W?[D]:p.filter(function(q){return N.filter?N.filter(q):$(q)&&q.stickyTracking});var j=z||!P?d:this.findNearestKDPoint(F,C,P);return D=j&&j.series,j&&(C&&!D.noSharedTooltip?(F=p.filter(function(q){return N.filter?N.filter(q):$(q)&&!q.noSharedTooltip}),F.forEach(function(q){var X=find$k(q.points,function(K){return K.x===j.x&&!K.isNull});isObject$d(X)&&(q.chart.isBoosting&&(X=q.getPoint(X)),k.push(X))})):k.push(j)),N={hoverPoint:j},fireEvent$v(this,"afterGetHoverData",N),{hoverPoint:N.hoverPoint,hoverSeries:D,hoverPoints:k}},g.prototype.getPointFromEvent=function(d){for(var a=d.target,p;a&&!p;)p=a.point,a=a.parentNode;return p},g.prototype.onTrackerMouseOut=function(d){var a=this.chart,p=d.relatedTarget||d.toElement,v=a.hoverSeries;this.isDirectTouch=!1,v&&p&&!v.stickyTracking&&!this.inClass(p,"highcharts-tooltip")&&(!this.inClass(p,"highcharts-series-"+v.index)||!this.inClass(p,"highcharts-tracker"))&&v.onMouseOut()},g.prototype.inClass=function(d,a){for(var p;d;){if(p=attr$2(d,"class"),p){if(p.indexOf(a)!==-1)return!0;if(p.indexOf("highcharts-container")!==-1)return!1}d=d.parentNode}},g.prototype.init=function(d,a){this.options=a,this.chart=d,this.runChartClick=!!(a.chart.events&&a.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(d.tooltip=new Tooltip(d,a.tooltip),this.followTouchMove=pick$1s(a.tooltip.followTouchMove,!0)),this.setDOMEvents()},g.prototype.normalize=function(d,a){var p=d.touches,v=p?p.length?p.item(0):pick$1s(p.changedTouches,d.changedTouches)[0]:d;a||(a=this.getChartPosition());var C=v.pageX-a.left,P=v.pageY-a.top;return C/=a.scaleX,P/=a.scaleY,extend$1m(d,{chartX:Math.round(C),chartY:Math.round(P)})},g.prototype.onContainerClick=function(d){var a=this.chart,p=a.hoverPoint,v=this.normalize(d),C=a.plotLeft,P=a.plotTop;a.cancelClick||(p&&this.inClass(v.target,"highcharts-tracker")?(fireEvent$v(p.series,"click",extend$1m(v,{point:p})),a.hoverPoint&&p.firePointEvent("click",v)):(extend$1m(v,this.getCoordinates(v)),a.isInsidePlot(v.chartX-C,v.chartY-P,{visiblePlotOnly:!0})&&fireEvent$v(a,"click",v)))},g.prototype.onContainerMouseDown=function(d){var a=((d.buttons||d.button)&1)===1;d=this.normalize(d),H.isFirefox&&d.button!==0&&this.onContainerMouseMove(d),(typeof d.button>"u"||a)&&(this.zoomOption(d),a&&d.preventDefault&&d.preventDefault(),this.dragStart(d))},g.prototype.onContainerMouseLeave=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)],p=this.chart.tooltip;p&&p.shouldStickOnContact()&&this.inClass(d.relatedTarget,"highcharts-tooltip-container")||(d=this.normalize(d),a&&(d.relatedTarget||d.toElement)&&(a.pointer.reset(),a.pointer.chartPosition=void 0),p&&!p.isHidden&&this.reset())},g.prototype.onContainerMouseEnter=function(d){delete this.chartPosition},g.prototype.onContainerMouseMove=function(d){var a=this.chart,p=this.normalize(d);this.setHoverChartIndex(),p.preventDefault||(p.returnValue=!1),(a.mouseIsDown==="mousedown"||this.touchSelect(p))&&this.drag(p),!a.openMenu&&(this.inClass(p.target,"highcharts-tracker")||a.isInsidePlot(p.chartX-a.plotLeft,p.chartY-a.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(p.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(p))},g.prototype.onDocumentTouchEnd=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)];a&&a.pointer.drop(d)},g.prototype.onContainerTouchMove=function(d){this.touchSelect(d)?this.onContainerMouseMove(d):this.touch(d)},g.prototype.onContainerTouchStart=function(d){this.touchSelect(d)?this.onContainerMouseDown(d):(this.zoomOption(d),this.touch(d,!0))},g.prototype.onDocumentMouseMove=function(d){var a=this.chart,p=this.chartPosition,v=this.normalize(d,p),C=a.tooltip;p&&(!C||!C.isStickyOnContact())&&!a.isInsidePlot(v.chartX-a.plotLeft,v.chartY-a.plotTop,{visiblePlotOnly:!0})&&!this.inClass(v.target,"highcharts-tracker")&&this.reset()},g.prototype.onDocumentMouseUp=function(d){var a=charts$3[pick$1s(g.hoverChartIndex,-1)];a&&a.pointer.drop(d)},g.prototype.pinch=function(d){var a=this,p=a.chart,v=a.pinchDown,C=d.touches||[],P=C.length,k=a.lastValidTouch,z=a.hasZoom,$={},D=P===1&&(a.inClass(d.target,"highcharts-tracker")&&p.runTrackerClick||a.runChartClick),F={},N=a.selectionMarker;P>1?a.initiated=!0:P===1&&this.followTouchMove&&(a.initiated=!1),z&&a.initiated&&!D&&d.cancelable!==!1&&d.preventDefault(),[].map.call(C,function(W){return a.normalize(W)}),d.type==="touchstart"?([].forEach.call(C,function(W,j){v[j]={chartX:W.chartX,chartY:W.chartY}}),k.x=[v[0].chartX,v[1]&&v[1].chartX],k.y=[v[0].chartY,v[1]&&v[1].chartY],p.axes.forEach(function(W){if(W.zoomEnabled){var j=p.bounds[W.horiz?"h":"v"],q=W.minPixelPadding,X=W.toPixels(Math.min(pick$1s(W.options.min,W.dataMin),W.dataMin)),K=W.toPixels(Math.max(pick$1s(W.options.max,W.dataMax),W.dataMax)),ee=Math.min(X,K),te=Math.max(X,K);j.min=Math.min(W.pos,ee-q),j.max=Math.max(W.pos+W.len,te+q)}}),a.res=!0):a.followTouchMove&&P===1?this.runPointActions(a.normalize(d)):v.length&&(N||(a.selectionMarker=N=extend$1m({destroy:noop$i,touch:!0},p.plotBox)),a.pinchTranslate(v,C,$,N,F,k),a.hasPinched=z,a.scaleGroups($,F),a.res&&(a.res=!1,this.reset(!1,0)))},g.prototype.pinchTranslate=function(d,a,p,v,C,P){this.zoomHor&&this.pinchTranslateDirection(!0,d,a,p,v,C,P),this.zoomVert&&this.pinchTranslateDirection(!1,d,a,p,v,C,P)},g.prototype.pinchTranslateDirection=function(d,a,p,v,C,P,k,z){var $=this.chart,D=d?"x":"y",F=d?"X":"Y",N="chart"+F,W=d?"width":"height",j=$["plot"+(d?"Left":"Top")],q=$.inverted,X=$.bounds[d?"h":"v"],K=a.length===1,ee=a[0][N],te=!K&&a[1][N],ie=function(){typeof ge=="number"&&Math.abs(ee-te)>20&&(ce=z||Math.abs(ue-ge)/Math.abs(ee-te)),le=(j-ue)/ce+ee,oe=$["plot"+(d?"Width":"Height")]/ce},oe,ae,le,ce=z||1,ue=p[0][N],ge=!K&&p[1][N],ye;ie(),ae=le,ae<X.min?(ae=X.min,ye=!0):ae+oe>X.max&&(ae=X.max-oe,ye=!0),ye?(ue-=.8*(ue-k[D][0]),typeof ge=="number"&&(ge-=.8*(ge-k[D][1])),ie()):k[D]=[ue,ge],q||(P[D]=le-j,P[W]=oe);var we=q?d?"scaleY":"scaleX":"scale"+F,ve=q?1/ce:ce;C[W]=oe,C[D]=ae,v[we]=ce,v["translate"+F]=ve*j+(ue-ve*ee)},g.prototype.reset=function(d,a){var p=this,v=p.chart,C=v.hoverSeries,P=v.hoverPoint,k=v.hoverPoints,z=v.tooltip,$=z&&z.shared?k:P;d&&$&&splat$g($).forEach(function(D){D.series.isCartesian&&typeof D.plotX>"u"&&(d=!1)}),d?z&&$&&splat$g($).length&&(z.refresh($),z.shared&&k?k.forEach(function(D){D.setState(D.state,!0),D.series.isCartesian&&(D.series.xAxis.crosshair&&D.series.xAxis.drawCrosshair(null,D),D.series.yAxis.crosshair&&D.series.yAxis.drawCrosshair(null,D))}):P&&(P.setState(P.state,!0),v.axes.forEach(function(D){D.crosshair&&P.series[D.coll]===D&&D.drawCrosshair(null,P)}))):(P&&P.onMouseOut(),k&&k.forEach(function(D){D.setState()}),C&&C.onMouseOut(),z&&z.hide(a),p.unDocMouseMove&&(p.unDocMouseMove=p.unDocMouseMove()),v.axes.forEach(function(D){D.hideCrosshair()}),p.hoverX=v.hoverPoints=v.hoverPoint=null)},g.prototype.runPointActions=function(d,a){var p=this,v=p.chart,C=v.series,P=v.tooltip&&v.tooltip.options.enabled?v.tooltip:void 0,k=P?P.shared:!1,z=a||v.hoverPoint,$=z&&z.series||v.hoverSeries,D=(!d||d.type!=="touchmove")&&(!!a||$&&$.directTouch&&p.isDirectTouch),F=this.getHoverData(z,$,C,D,k,d);z=F.hoverPoint,$=F.hoverSeries;var N=F.hoverPoints,W=$&&$.tooltipOptions.followPointer&&!$.tooltipOptions.split,j=k&&$&&!$.noSharedTooltip;if(z&&(z!==v.hoverPoint||P&&P.isHidden)){if((v.hoverPoints||[]).forEach(function(X){N.indexOf(X)===-1&&X.setState()}),v.hoverSeries!==$&&$.onMouseOver(),p.applyInactiveState(N),(N||[]).forEach(function(X){X.setState("hover")}),v.hoverPoint&&v.hoverPoint.firePointEvent("mouseOut"),!z.series)return;v.hoverPoints=N,v.hoverPoint=z,z.firePointEvent("mouseOver"),P&&P.refresh(j?N:z,d)}else if(W&&P&&!P.isHidden){var q=P.getAnchor([{}],d);v.isInsidePlot(q[0],q[1],{visiblePlotOnly:!0})&&P.updatePosition({plotX:q[0],plotY:q[1]})}p.unDocMouseMove||(p.unDocMouseMove=addEvent$11(v.container.ownerDocument,"mousemove",function(X){var K=charts$3[g.hoverChartIndex];K&&K.pointer.onDocumentMouseMove(X)}),p.eventsToUnbind.push(p.unDocMouseMove)),v.axes.forEach(function(K){var ee=pick$1s((K.crosshair||{}).snap,!0),te;ee&&(te=v.hoverPoint,(!te||te.series[K.coll]!==K)&&(te=find$k(N,function(ie){return ie.series[K.coll]===K}))),te||!ee?K.drawCrosshair(d,te):K.hideCrosshair()})},g.prototype.scaleGroups=function(d,a){var p=this.chart;p.series.forEach(function(v){var C=d||v.getPlotBox();v.xAxis&&v.xAxis.zoomEnabled&&v.group&&(v.group.attr(C),v.markerGroup&&(v.markerGroup.attr(C),v.markerGroup.clip(a?p.clipRect:null)),v.dataLabelsGroup&&v.dataLabelsGroup.attr(C))}),p.clipRect.attr(a||p.clipBox)},g.prototype.setDOMEvents=function(){var d=this,a=this.chart.container,p=a.ownerDocument;a.onmousedown=this.onContainerMouseDown.bind(this),a.onmousemove=this.onContainerMouseMove.bind(this),a.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$11(a,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$11(a,"mouseleave",this.onContainerMouseLeave.bind(this))),g.unbindDocumentMouseUp||(g.unbindDocumentMouseUp=addEvent$11(p,"mouseup",this.onDocumentMouseUp.bind(this)));for(var v=this.chart.renderTo.parentElement;v&&v.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$11(v,"scroll",function(){delete d.chartPosition})),v=v.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$11(a,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$11(a,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),g.unbindDocumentTouchEnd||(g.unbindDocumentTouchEnd=addEvent$11(p,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},g.prototype.setHoverChartIndex=function(){var d=this.chart,a=H.charts[pick$1s(g.hoverChartIndex,-1)];a&&a!==d&&a.pointer.onContainerMouseLeave({relatedTarget:!0}),(!a||!a.mouseIsDown)&&(g.hoverChartIndex=d.index)},g.prototype.touch=function(d,a){var p=this.chart,v,C,P;this.setHoverChartIndex(),d.touches.length===1?(d=this.normalize(d),P=p.isInsidePlot(d.chartX-p.plotLeft,d.chartY-p.plotTop,{visiblePlotOnly:!0}),P&&!p.openMenu?(a&&this.runPointActions(d),d.type==="touchmove"&&(C=this.pinchDown,v=C[0]?Math.sqrt(Math.pow(C[0].chartX-d.chartX,2)+Math.pow(C[0].chartY-d.chartY,2))>=4:!1),pick$1s(v,!0)&&this.pinch(d)):a&&this.reset()):d.touches.length===2&&this.pinch(d)},g.prototype.touchSelect=function(d){return!!(this.chart.options.chart.zoomBySingleTouch&&d.touches&&d.touches.length===1)},g.prototype.zoomOption=function(d){var a=this.chart,p=a.options.chart,v=a.inverted,C=p.zoomType||"",P,k;/touch/.test(d.type)&&(C=pick$1s(p.pinchType,C)),this.zoomX=P=/x/.test(C),this.zoomY=k=/y/.test(C),this.zoomHor=P&&!v||k&&v,this.zoomVert=k&&!v||P&&v,this.hasZoom=P||k},g})(),__extends$2e=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),charts$2=H.charts,doc$h=H.doc,noop$h=H.noop,win$a=H.win,addEvent$10=Utilities.addEvent,css$7=Utilities.css,objectEach$q=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var g=[];return g.item=function(d){return this[d]},objectEach$q(touches,function(d){g.push({pageX:d.pageX,pageY:d.pageY,target:d.target})}),g}function translateMSPointer(g,d,a,p){var v=charts$2[Pointer.hoverChartIndex||NaN];if((g.pointerType==="touch"||g.pointerType===g.MSPOINTER_TYPE_TOUCH)&&v){var C=v.pointer;p(g),C[d]({type:a,target:g.currentTarget,preventDefault:noop$h,touches:getWebkitTouches()})}}var MSPointer=(function(g){__extends$2e(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},d.prototype.batchMSEvents=function(a){a(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),a(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),a(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},d.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),g.prototype.destroy.call(this)},d.prototype.init=function(a,p){g.prototype.init.call(this,a,p),this.hasZoom&&css$7(a.container,{"-ms-touch-action":"none","touch-action":"none"})},d.prototype.onContainerPointerDown=function(a){translateMSPointer(a,"onContainerTouchStart","touchstart",function(p){touches[p.pointerId]={pageX:p.pageX,pageY:p.pageY,target:p.currentTarget}})},d.prototype.onContainerPointerMove=function(a){translateMSPointer(a,"onContainerTouchMove","touchmove",function(p){touches[p.pointerId]={pageX:p.pageX,pageY:p.pageY},touches[p.pointerId].target||(touches[p.pointerId].target=p.currentTarget)})},d.prototype.onDocumentPointerUp=function(a){translateMSPointer(a,"onDocumentTouchEnd","touchend",function(p){delete touches[p.pointerId]})},d.prototype.setDOMEvents=function(){g.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$10)},d})(Pointer),animObject$9=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$b=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$$=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$M=Utilities.defined,discardElement$4=Utilities.discardElement,find$j=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1k=Utilities.merge,pick$1r=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$g=Utilities.wrap,Legend=(function(){function g(d,a){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=d,this.init(d,a)}return g.prototype.init=function(d,a){this.chart=d,this.setOptions(a),a.enabled&&(this.render(),addEvent$$(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$$(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},g.prototype.setOptions=function(d){var a=pick$1r(d.padding,8);this.options=d,this.chart.styledMode||(this.itemStyle=d.itemStyle,this.itemHiddenStyle=merge$1k(this.itemStyle,d.itemHiddenStyle)),this.itemMarginTop=d.itemMarginTop||0,this.itemMarginBottom=d.itemMarginBottom||0,this.padding=a,this.initialItemY=a-5,this.symbolWidth=pick$1r(d.symbolWidth,16),this.pages=[],this.proximate=d.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},g.prototype.update=function(d,a){var p=this.chart;this.setOptions(merge$1k(!0,this.options,d)),this.destroy(),p.isDirtyLegend=p.isDirtyBox=!0,pick$1r(a,!0)&&p.redraw(),fireEvent$u(this,"afterUpdate")},g.prototype.colorizeItem=function(d,a){if(d.legendGroup[a?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var p=this,v=p.options,C=d.legendItem,P=d.legendLine,k=d.legendSymbol,z=p.itemHiddenStyle.color,$=a?v.itemStyle.color:z,D=a&&d.color||z,F=d.options&&d.options.marker,N={fill:D};C&&C.css({fill:$,color:$}),P&&P.attr({stroke:D}),k&&(F&&k.isMarker&&(N=d.pointAttribs(),a||(N.stroke=N.fill=z)),k.attr(N))}fireEvent$u(this,"afterColorizeItem",{item:d,visible:a})},g.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},g.prototype.positionItem=function(d){var a=this,p=this,v=p.options,C=v.symbolPadding,P=!v.rtl,k=d._legendItemPos,z=k[0],$=k[1],D=d.checkbox,F=d.legendGroup;if(F&&F.element){var N={translateX:P?z:p.legendWidth-z-2*C-4,translateY:$},W=function(){fireEvent$u(a,"afterPositionItem",{item:d})};defined$M(F.translateY)?F.animate(N,void 0,W):(F.attr(N),W())}D&&(D.x=z,D.y=$)},g.prototype.destroyItem=function(d){var a=d.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(p){d[p]&&(d[p]=d[p].destroy())}),a&&discardElement$4(d.checkbox)},g.prototype.destroy=function(){function d(a){this[a]&&(this[a]=this[a].destroy())}this.getAllItems().forEach(function(a){["legendItem","legendGroup"].forEach(d,a)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(d,this),this.display=null},g.prototype.positionCheckboxes=function(){var d=this.group&&this.group.alignAttr,a=this.clipHeight||this.legendHeight,p=this.titleHeight,v;d&&(v=d.translateY,this.allItems.forEach(function(C){var P=C.checkbox,k;P&&(k=v+p+P.y+(this.scrollOffset||0)+3,css$6(P,{left:d.translateX+C.checkboxOffset+P.x-20+"px",top:k+"px",display:this.proximate||k>v-6&&k<v+a-6?"":"none"}))},this))},g.prototype.renderTitle=function(){var d=this.options,a=this.padding,p=d.title,v,C=0;p.text&&(this.title||(this.title=this.chart.renderer.label(p.text,a-3,a-4,null,null,null,d.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(p.style),this.title.add(this.group)),p.width||this.title.css({width:this.maxLegendWidth+"px"}),v=this.title.getBBox(),C=v.height,this.offsetWidth=v.width,this.contentGroup.attr({translateY:C})),this.titleHeight=C},g.prototype.setText=function(d){var a=this.options;d.legendItem.attr({text:a.labelFormat?format$b(a.labelFormat,d,this.chart):a.labelFormatter.call(d)})},g.prototype.renderItem=function(d){var a=this,p=a.chart,v=p.renderer,C=a.options,P=C.layout==="horizontal",k=a.symbolWidth,z=C.symbolPadding||0,$=a.itemStyle,D=a.itemHiddenStyle,F=P?pick$1r(C.itemDistance,20):0,N=!C.rtl,W=!d.series,j=!W&&d.series.drawLegendSymbol?d.series:d,q=j.options,X=a.createCheckboxForItem&&q&&q.showCheckbox,K=C.useHTML,ee=d.options.className,te=d.legendItem,ie=k+z+F+(X?20:0);te||(d.legendGroup=v.g("legend-item").addClass("highcharts-"+j.type+"-series highcharts-color-"+d.colorIndex+(ee?" "+ee:"")+(W?" highcharts-series-"+d.index:"")).attr({zIndex:1}).add(a.scrollGroup),d.legendItem=te=v.text("",N?k+z:-z,a.baseline||0,K),p.styledMode||te.css(merge$1k(d.visible?$:D)),te.attr({align:N?"left":"right",zIndex:2}).add(d.legendGroup),a.baseline||(a.fontMetrics=v.fontMetrics(p.styledMode?12:$.fontSize,te),a.baseline=a.fontMetrics.f+3+a.itemMarginTop,te.attr("y",a.baseline),a.symbolHeight=C.symbolHeight||a.fontMetrics.f,C.squareSymbol&&(a.symbolWidth=pick$1r(C.symbolWidth,Math.max(a.symbolHeight,16)),ie=a.symbolWidth+z+F+(X?20:0),N&&te.attr("x",a.symbolWidth+z))),j.drawLegendSymbol(a,d),a.setItemEvents&&a.setItemEvents(d,te,K)),X&&!d.checkbox&&a.createCheckboxForItem&&a.createCheckboxForItem(d),a.colorizeItem(d,d.visible),(p.styledMode||!$.width)&&te.css({width:(C.itemWidth||a.widthOption||p.spacingBox.width)-ie+"px"}),a.setText(d);var oe=te.getBBox();d.itemWidth=d.checkboxOffset=C.itemWidth||d.legendItemWidth||oe.width+ie,a.maxItemWidth=Math.max(a.maxItemWidth,d.itemWidth),a.totalItemWidth+=d.itemWidth,a.itemHeight=d.itemHeight=Math.round(d.legendItemHeight||oe.height||a.symbolHeight)},g.prototype.layoutItem=function(d){var a=this.options,p=this.padding,v=a.layout==="horizontal",C=d.itemHeight,P=this.itemMarginBottom,k=this.itemMarginTop,z=v?pick$1r(a.itemDistance,20):0,$=this.maxLegendWidth,D=a.alignColumns&&this.totalItemWidth>$?this.maxItemWidth:d.itemWidth;v&&this.itemX-p+D>$&&(this.itemX=p,this.lastLineHeight&&(this.itemY+=k+this.lastLineHeight+P),this.lastLineHeight=0),this.lastItemY=k+this.itemY+P,this.lastLineHeight=Math.max(C,this.lastLineHeight),d._legendItemPos=[this.itemX,this.itemY],v?this.itemX+=D:(this.itemY+=k+C+P,this.lastLineHeight=C),this.offsetWidth=this.widthOption||Math.max((v?this.itemX-p-(d.checkbox?0:z):D)+p,this.offsetWidth)},g.prototype.getAllItems=function(){var d=[];return this.chart.series.forEach(function(a){var p=a&&a.options;a&&pick$1r(p.showInLegend,defined$M(p.linkedTo)?!1:void 0,!0)&&(d=d.concat(a.legendItems||(p.legendType==="point"?a.data:a)))}),fireEvent$u(this,"afterGetAllItems",{allItems:d}),d},g.prototype.getAlignment=function(){var d=this.options;return this.proximate?d.align.charAt(0)+"tv":d.floating?"":d.align.charAt(0)+d.verticalAlign.charAt(0)+d.layout.charAt(0)},g.prototype.adjustMargins=function(d,a){var p=this.chart,v=this.options,C=this.getAlignment();C&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(P,k){P.test(C)&&!defined$M(d[k])&&(p[marginNames$1[k]]=Math.max(p[marginNames$1[k]],p.legend[(k+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][k]*v[k%2?"x":"y"]+pick$1r(v.margin,12)+a[k]+(p.titleOffset[k]||0)))})},g.prototype.proximatePositions=function(){var d=this.chart,a=[],p=this.options.align==="left";this.allItems.forEach(function(v){var C,P,k=p,z,$;v.yAxis&&(v.xAxis.options.reversed&&(k=!k),v.points&&(C=find$j(k?v.points:v.points.slice(0).reverse(),function(D){return isNumber$I(D.plotY)})),P=this.itemMarginTop+v.legendItem.getBBox().height+this.itemMarginBottom,$=v.yAxis.top-d.plotTop,v.visible?(z=C?C.plotY:v.yAxis.height,z+=$-.3*P):z=$+v.yAxis.height,a.push({target:z,size:P,item:v}))},this),distribute$2(a,d.plotHeight).forEach(function(v){v.item._legendItemPos&&(v.item._legendItemPos[1]=d.plotTop-d.spacing[0]+v.pos)})},g.prototype.render=function(){var d=this,a=d.chart,p=a.renderer,v=d.options,C=d.padding,P=d.getAllItems(),k,z,$,D=d.group,F,N=d.box;d.itemX=C,d.itemY=d.initialItemY,d.offsetWidth=0,d.lastItemY=0,d.widthOption=relativeLength$8(v.width,a.spacingBox.width-C),F=a.spacingBox.width-2*C-v.x,["rm","lm"].indexOf(d.getAlignment().substring(0,2))>-1&&(F/=2),d.maxLegendWidth=d.widthOption||F,D||(d.group=D=p.g("legend").addClass(v.className||"").attr({zIndex:7}).add(),d.contentGroup=p.g().attr({zIndex:1}).add(D),d.scrollGroup=p.g().add(d.contentGroup)),d.renderTitle(),stableSort$5(P,function(W,j){return(W.options&&W.options.legendIndex||0)-(j.options&&j.options.legendIndex||0)}),v.reversed&&P.reverse(),d.allItems=P,d.display=k=!!P.length,d.lastLineHeight=0,d.maxItemWidth=0,d.totalItemWidth=0,d.itemHeight=0,P.forEach(d.renderItem,d),P.forEach(d.layoutItem,d),z=(d.widthOption||d.offsetWidth)+C,$=d.lastItemY+d.lastLineHeight+d.titleHeight,$=d.handleOverflow($),$+=C,N||(d.box=N=p.rect().addClass("highcharts-legend-box").attr({r:v.borderRadius}).add(D),N.isNew=!0),a.styledMode||N.attr({stroke:v.borderColor,"stroke-width":v.borderWidth||0,fill:v.backgroundColor||"none"}).shadow(v.shadow),z>0&&$>0&&(N[N.isNew?"attr":"animate"](N.crisp.call({},{x:0,y:0,width:z,height:$},N.strokeWidth())),N.isNew=!1),N[k?"show":"hide"](),a.styledMode&&D.getStyle("display")==="none"&&(z=$=0),d.legendWidth=z,d.legendHeight=$,k&&d.align(),this.proximate||this.positionItems(),fireEvent$u(this,"afterRender")},g.prototype.align=function(d){d===void 0&&(d=this.chart.spacingBox);var a=this.chart,p=this.options,v=d.y;/(lth|ct|rth)/.test(this.getAlignment())&&a.titleOffset[0]>0?v+=a.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&a.titleOffset[2]>0&&(v-=a.titleOffset[2]),v!==d.y&&(d=merge$1k(d,{y:v})),this.group.align(merge$1k(p,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":p.verticalAlign}),!0,d)},g.prototype.handleOverflow=function(d){var a=this,p=this.chart,v=p.renderer,C=this.options,P=C.y,k=C.verticalAlign==="top",z=this.padding,$=C.maxHeight,D=C.navigation,F=pick$1r(D.animation,!0),N=D.arrowSize||12,W=this.pages,j=this.allItems,q=function(ae){typeof ae=="number"?oe.attr({height:ae}):oe&&(a.clipRect=oe.destroy(),a.contentGroup.clip()),a.contentGroup.div&&(a.contentGroup.div.style.clip=ae?"rect("+z+"px,9999px,"+(z+ae)+"px,0)":"auto")},X=function(ae){return a[ae]=v.circle(0,0,N*1.3).translate(N/2,N/2).add(ie),p.styledMode||a[ae].attr("fill","rgba(0,0,0,0.0001)"),a[ae]},K,ee,te=p.spacingBox.height+(k?-P:P)-z,ie=this.nav,oe=this.clipRect;return C.layout==="horizontal"&&C.verticalAlign!=="middle"&&!C.floating&&(te/=2),$&&(te=Math.min(te,$)),W.length=0,d&&te>0&&d>te&&D.enabled!==!1?(this.clipHeight=K=Math.max(te-20-this.titleHeight-z,0),this.currentPage=pick$1r(this.currentPage,1),this.fullHeight=d,j.forEach(function(ae,le){var ce=ae._legendItemPos[1],ue=Math.round(ae.legendItem.getBBox().height),ge=W.length;(!ge||ce-W[ge-1]>K&&(ee||ce)!==W[ge-1])&&(W.push(ee||ce),ge++),ae.pageIx=ge-1,ee&&(j[le-1].pageIx=ge-1),le===j.length-1&&ce+ue-W[ge-1]>K&&ce!==ee&&(W.push(ce),ae.pageIx=ge),ce!==ee&&(ee=ce)}),oe||(oe=a.clipRect=v.clipRect(0,z,9999,0),a.contentGroup.clip(oe)),q(K),ie||(this.nav=ie=v.g().attr({zIndex:1}).add(this.group),this.up=v.symbol("triangle",0,0,N,N).add(ie),X("upTracker").on("click",function(){a.scroll(-1,F)}),this.pager=v.text("",15,10).addClass("highcharts-legend-navigation"),p.styledMode||this.pager.css(D.style),this.pager.add(ie),this.down=v.symbol("triangle-down",0,0,N,N).add(ie),X("downTracker").on("click",function(){a.scroll(1,F)})),a.scroll(0),d=te):ie&&(q(),this.nav=ie.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),d},g.prototype.scroll=function(d,a){var p=this,v=this.chart,C=this.pages,P=C.length,k=this.clipHeight,z=this.options.navigation,$=this.pager,D=this.padding,F=this.currentPage+d;if(F>P&&(F=P),F>0){typeof a<"u"&&setAnimation$4(a,v),this.nav.attr({translateX:D,translateY:k+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(W){W.attr({class:F===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),$.attr({text:F+"/"+P}),[this.down,this.downTracker].forEach(function(W){W.attr({x:18+this.pager.getBBox().width,class:F===P?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),v.styledMode||(this.up.attr({fill:F===1?z.inactiveColor:z.activeColor}),this.upTracker.css({cursor:F===1?"default":"pointer"}),this.down.attr({fill:F===P?z.inactiveColor:z.activeColor}),this.downTracker.css({cursor:F===P?"default":"pointer"})),this.scrollOffset=-C[F-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=F,this.positionCheckboxes();var N=animObject$9(pick$1r(a,v.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$u(p,"afterScroll",{currentPage:F})},N.duration)}},g.prototype.setItemEvents=function(d,a,p){var v=this,C=v.chart.renderer.boxWrapper,P=d instanceof Point$4,k="highcharts-legend-"+(P?"point":"series")+"-active",z=v.chart.styledMode,$=p?[a,d.legendSymbol]:[d.legendGroup],D=function(F){v.allItems.forEach(function(N){d!==N&&[N].concat(N.linkedSeries||[]).forEach(function(W){W.setState(F,!P)})})};$.forEach(function(F){F&&F.on("mouseover",function(){d.visible&&D("inactive"),d.setState("hover"),d.visible&&C.addClass(k),z||a.css(v.options.itemHoverStyle)}).on("mouseout",function(){v.chart.styledMode||a.css(merge$1k(d.visible?v.itemStyle:v.itemHiddenStyle)),D(""),C.removeClass(k),d.setState()}).on("click",function(N){var W="legendItemClick",j=function(){d.setVisible&&d.setVisible(),D(d.visible?"inactive":"")};C.removeClass(k),N={browserEvent:N},d.firePointEvent?d.firePointEvent(W,N,j):fireEvent$u(d,W,N,j)})})},g.prototype.createCheckboxForItem=function(d){var a=this;d.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:d.selected,defaultChecked:d.selected},a.options.itemCheckboxStyle,a.chart.container),addEvent$$(d.checkbox,"click",function(p){var v=p.target;fireEvent$u(d.series||d,"checkboxClick",{checked:v.checked,item:d},function(){d.select()})})},g})();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$g(Legend.prototype,"positionItem",function(g,d){var a=this,p=function(){d._legendItemPos&&g.call(a,d)};p(),a.bubbleLegend||setTimeout(p)});var defaultOptions$f=DefaultOptions.defaultOptions,error$8=Utilities.error,extendClass$1=Utilities.extendClass,merge$1j=Utilities.merge,SeriesRegistry;(function(g){g.seriesTypes=H.seriesTypes;function d(v,C){C===void 0&&(C={});var P=v.options.chart,k=C.type||P.type||P.defaultSeriesType||"",z=g.seriesTypes[k];g||error$8(17,!0,v,{missingModuleFor:k});var $=new z;return typeof $.init=="function"&&$.init(v,C),$}g.getSeries=d;function a(v,C){var P=defaultOptions$f.plotOptions||{},k=C.defaultOptions;C.prototype.pointClass||(C.prototype.pointClass=Point$4),C.prototype.type=v,k&&(P[v]=k),g.seriesTypes[v]=C}g.registerSeriesType=a;function p(v,C,P,k,z){var $=defaultOptions$f.plotOptions||{};return C=C||"",$[v]=merge$1j($[C],P),a(v,extendClass$1(g.seriesTypes[C]||function(){},k)),g.seriesTypes[v].prototype.type=v,z&&(g.seriesTypes[v].prototype.pointClass=extendClass$1(Point$4,z)),g.seriesTypes[v]}g.seriesType=p})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$8=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$6.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$5=H.svg,win$8=H.win,defaultOptions$e=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$8=SeriesRegistry$1.seriesTypes,addEvent$_=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$L=Utilities.defined,discardElement$3=Utilities.discardElement,erase$4=Utilities.erase,error$7=Utilities.error,extend$1l=Utilities.extend,find$i=Utilities.find,fireEvent$t=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isObject$c=Utilities.isObject,isString$6=Utilities.isString,merge$1i=Utilities.merge,objectEach$p=Utilities.objectEach,pick$1q=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$f=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=(function(){function g(d,a,p){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(d,a,p)}return g.chart=function(d,a,p){return new g(d,a,p)},g.prototype.getArgs=function(d,a,p){isString$6(d)||d.nodeName?(this.renderTo=d,this.init(a,p)):this.init(d,a)},g.prototype.init=function(d,a){var p=d.plotOptions||{};fireEvent$t(this,"init",{args:arguments},function(){var v=merge$1i(defaultOptions$e,d),C=v.chart;objectEach$p(v.plotOptions,function(k,z){isObject$c(k)&&(k.tooltip=p[z]&&merge$1i(p[z].tooltip)||void 0)}),v.tooltip.userOptions=d.chart&&d.chart.forExport&&d.tooltip.userOptions||d.tooltip,this.userOptions=d,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=a,this.isResizing=0,this.options=v,this.axes=[],this.series=[],this.time=d.time&&Object.keys(d.time).length?new Time(d.time):H.time,this.numberFormatter=C.numberFormatter||numberFormat$1,this.styledMode=C.styledMode,this.hasCartesianSeries=C.showAxes;var P=this;P.index=charts$1.length,charts$1.push(P),H.chartCount++,registerEventOptions$1(this,C),P.xAxis=[],P.yAxis=[],P.pointCount=P.colorCounter=P.symbolCounter=0,fireEvent$t(P,"afterInit"),P.firstRender()})},g.prototype.initSeries=function(d){var a=this,p=a.options.chart,v=d.type||p.type||p.defaultSeriesType,C=seriesTypes$8[v];C||error$7(17,!0,a,{missingModuleFor:v});var P=new C;return typeof P.init=="function"&&P.init(a,d),P},g.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(d){!d.points&&!d.data&&d.enabledDataSorting&&d.setData(d.options.data,!1)})},g.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(d,a){return d.linkedSeries.length||a.linkedSeries.length?a.linkedSeries.length-d.linkedSeries.length:0})},g.prototype.orderSeries=function(d){for(var a=this.series,p=d||0,v=a.length;p<v;++p)a[p]&&(a[p].index=p,a[p].name=a[p].getName())},g.prototype.isInsidePlot=function(d,a,p){var v;p===void 0&&(p={});var C=this,P=C.inverted,k=C.plotBox,z=C.plotLeft,$=C.plotTop,D=C.scrollablePlotBox,F=0,N=0;p.visiblePlotOnly&&this.scrollingContainer&&(v=this.scrollingContainer,F=v.scrollLeft,N=v.scrollTop);var W=p.series,j=p.visiblePlotOnly&&D||k,q=p.inverted?a:d,X=p.inverted?d:a,K={x:q,y:X,isInsidePlot:!0};if(!p.ignoreX){var ee=W&&(P?W.yAxis:W.xAxis)||{pos:z,len:1/0},te=p.paneCoordinates?ee.pos+q:z+q;te>=Math.max(F+z,ee.pos)&&te<=Math.min(F+z+j.width,ee.pos+ee.len)||(K.isInsidePlot=!1)}if(!p.ignoreY&&K.isInsidePlot){var ie=W&&(P?W.xAxis:W.yAxis)||{pos:$,len:1/0},oe=p.paneCoordinates?ie.pos+X:$+X;oe>=Math.max(N+$,ie.pos)&&oe<=Math.min(N+$+j.height,ie.pos+ie.len)||(K.isInsidePlot=!1)}return fireEvent$t(this,"afterIsInsidePlot",K),K.isInsidePlot},g.prototype.redraw=function(d){fireEvent$t(this,"beforeRedraw");var a=this,p=a.hasCartesianSeries?a.axes:a.colorAxis||[],v=a.series,C=a.pointer,P=a.legend,k=a.userOptions.legend,z=a.renderer,$=z.isHidden(),D=[],F,N,W,j=a.isDirtyBox,q=a.isDirtyLegend,X;for(a.setResponsive&&a.setResponsive(!1),setAnimation$3(a.hasRendered?d:!1,a),$&&a.temporaryDisplay(),a.layOutTitles(),W=v.length;W--;)if(X=v[W],(X.options.stacking||X.options.centerInCategory)&&(N=!0,X.isDirty)){F=!0;break}if(F)for(W=v.length;W--;)X=v[W],X.options.stacking&&(X.isDirty=!0);v.forEach(function(K){K.isDirty&&(K.options.legendType==="point"?(typeof K.updateTotals=="function"&&K.updateTotals(),q=!0):k&&(k.labelFormatter||k.labelFormat)&&(q=!0)),K.isDirtyData&&fireEvent$t(K,"updatedData")}),q&&P&&P.options.enabled&&(P.render(),a.isDirtyLegend=!1),N&&a.getStacks(),p.forEach(function(K){K.updateNames(),K.setScale()}),a.getMargins(),p.forEach(function(K){K.isDirty&&(j=!0)}),p.forEach(function(K){var ee=K.min+","+K.max;K.extKey!==ee&&(K.extKey=ee,D.push(function(){fireEvent$t(K,"afterSetExtremes",extend$1l(K.eventArgs,K.getExtremes())),delete K.eventArgs})),(j||N)&&K.redraw()}),j&&a.drawChartBox(),fireEvent$t(a,"predraw"),v.forEach(function(K){(j||K.isDirty)&&K.visible&&K.redraw(),K.isDirtyData=!1}),C&&C.reset(!0),z.draw(),fireEvent$t(a,"redraw"),fireEvent$t(a,"render"),$&&a.temporaryDisplay(!0),D.forEach(function(K){K.call()})},g.prototype.get=function(d){var a=this.series;function p(P){return P.id===d||P.options&&P.options.id===d}for(var v=find$i(this.axes,p)||find$i(this.series,p),C=0;!v&&C<a.length;C++)v=find$i(a[C].points||[],p);return v},g.prototype.getAxes=function(){var d=this,a=this.options,p=a.xAxis=splat$f(a.xAxis||{}),v=a.yAxis=splat$f(a.yAxis||{});fireEvent$t(this,"getAxes"),p.forEach(function(P,k){P.index=k,P.isX=!0}),v.forEach(function(P,k){P.index=k});var C=p.concat(v);C.forEach(function(P){new Axis(d,P)}),fireEvent$t(this,"afterGetAxes")},g.prototype.getSelectedPoints=function(){return this.series.reduce(function(d,a){return a.getPointsCollection().forEach(function(p){pick$1q(p.selectedStaging,p.selected)&&d.push(p)}),d},[])},g.prototype.getSelectedSeries=function(){return this.series.filter(function(d){return d.selected})},g.prototype.setTitle=function(d,a,p){this.applyDescription("title",d),this.applyDescription("subtitle",a),this.applyDescription("caption",void 0),this.layOutTitles(p)},g.prototype.applyDescription=function(d,a){var p=this,v=d==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},C=this.options[d]=merge$1i(!this.styledMode&&{style:v},this.options[d],a),P=this[d];P&&a&&(this[d]=P=P.destroy()),C&&!P&&(P=this.renderer.text(C.text,0,0,C.useHTML).attr({align:C.align,class:"highcharts-"+d,zIndex:C.zIndex||4}).add(),P.update=function(k){var z={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[d];p[z](k)},this.styledMode||P.css(C.style),this[d]=P)},g.prototype.layOutTitles=function(d){var a=[0,0,0],p=this.renderer,v=this.spacingBox;["title","subtitle","caption"].forEach(function(P){var k=this[P],z=this.options[P],$=z.verticalAlign||"top",D=P==="title"?$==="top"?-3:0:$==="top"?a[0]+2:0,F,N;k&&(this.styledMode||(F=z.style&&z.style.fontSize),F=p.fontMetrics(F,k).b,k.css({width:(z.width||v.width+(z.widthAdjust||0))+"px"}),N=Math.round(k.getBBox(z.useHTML).height),k.align(extend$1l({y:$==="bottom"?F:D+F,height:N},z),!1,"spacingBox"),z.floating||($==="top"?a[0]=Math.ceil(a[0]+N):$==="bottom"&&(a[2]=Math.ceil(a[2]+N))))},this),a[0]&&(this.options.title.verticalAlign||"top")==="top"&&(a[0]+=this.options.title.margin),a[2]&&this.options.caption.verticalAlign==="bottom"&&(a[2]+=this.options.caption.margin);var C=!this.titleOffset||this.titleOffset.join(",")!==a.join(",");this.titleOffset=a,fireEvent$t(this,"afterLayOutTitles"),!this.isDirtyBox&&C&&(this.isDirtyBox=this.isDirtyLegend=C,this.hasRendered&&pick$1q(d,!0)&&this.isDirtyBox&&this.redraw())},g.prototype.getChartSize=function(){var d=this,a=d.options.chart,p=a.width,v=a.height,C=d.renderTo;defined$L(p)||(d.containerWidth=getStyle(C,"width")),defined$L(v)||(d.containerHeight=getStyle(C,"height")),d.chartWidth=Math.max(0,p||d.containerWidth||600),d.chartHeight=Math.max(0,relativeLength$7(v,d.chartWidth)||(d.containerHeight>1?d.containerHeight:400))},g.prototype.temporaryDisplay=function(d){var a=this.renderTo,p;if(d)for(;a&&a.style;)a.hcOrigStyle&&(css$5(a,a.hcOrigStyle),delete a.hcOrigStyle),a.hcOrigDetached&&(doc$g.body.removeChild(a),a.hcOrigDetached=!1),a=a.parentNode;else for(;a&&a.style&&(!doc$g.body.contains(a)&&!a.parentNode&&(a.hcOrigDetached=!0,doc$g.body.appendChild(a)),(getStyle(a,"display",!1)==="none"||a.hcOricDetached)&&(a.hcOrigStyle={display:a.style.display,height:a.style.height,overflow:a.style.overflow},p={display:"block",overflow:"hidden"},a!==this.renderTo&&(p.height=0),css$5(a,p),a.offsetWidth||a.style.setProperty("display","block","important")),a=a.parentNode,a!==doc$g.body););},g.prototype.setClassName=function(d){this.container.className="highcharts-container "+(d||"")},g.prototype.getContainer=function(){var d=this,a=d.options,p=a.chart,v="data-highcharts-chart",C=uniqueKey$4(),P,k=d.renderTo;k||(d.renderTo=k=p.renderTo),isString$6(k)&&(d.renderTo=k=doc$g.getElementById(k)),k||error$7(13,!0,d);var z=pInt$4(attr$1(k,v));isNumber$H(z)&&charts$1[z]&&charts$1[z].hasRendered&&charts$1[z].destroy(),attr$1(k,v,d.index),k.innerHTML="",!p.skipClone&&!k.offsetWidth&&d.temporaryDisplay(),d.getChartSize();var $=d.chartWidth,D=d.chartHeight;css$5(k,{overflow:"hidden"}),d.styledMode||(P=extend$1l({position:"relative",overflow:"hidden",width:$+"px",height:D+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},p.style||{}));var F=createElement$5("div",{id:C},P,k);d.container=F,d._cursor=F.style.cursor;var N=p.renderer||!svg$5?RendererRegistry$1.getRendererType(p.renderer):SVGRenderer;if(d.renderer=new N(F,$,D,void 0,p.forExport,a.exporting&&a.exporting.allowHTML,d.styledMode),setAnimation$3(void 0,d),d.setClassName(p.className),!d.styledMode)d.renderer.setStyle(p.style);else for(var W in a.defs)this.renderer.definition(a.defs[W]);d.renderer.chartIndex=d.index,fireEvent$t(this,"afterGetContainer")},g.prototype.getMargins=function(d){var a=this,p=a.spacing,v=a.margin,C=a.titleOffset;this.resetMargins(),C[0]&&!defined$L(v[0])&&(this.plotTop=Math.max(this.plotTop,C[0]+p[0])),C[2]&&!defined$L(v[2])&&(this.marginBottom=Math.max(this.marginBottom,C[2]+p[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(v,p),fireEvent$t(this,"getMargins"),d||this.getAxisMargins()},g.prototype.getAxisMargins=function(){var d=this,a=d.axisOffset=[0,0,0,0],p=d.colorAxis,v=d.margin,C=function(P){P.forEach(function(k){k.visible&&k.getOffset()})};d.hasCartesianSeries?C(d.axes):p&&p.length&&C(p),marginNames.forEach(function(P,k){defined$L(v[k])||(d[P]+=a[k])}),d.setChartSize()},g.prototype.reflow=function(d){var a=this,p=a.options.chart,v=a.renderTo,C=defined$L(p.width)&&defined$L(p.height),P=p.width||getStyle(v,"width"),k=p.height||getStyle(v,"height"),z=d?d.target:win$8;delete a.pointer.chartPosition,!C&&!a.isPrinting&&P&&k&&(z===win$8||z===doc$g)&&((P!==a.containerWidth||k!==a.containerHeight)&&(Utilities.clearTimeout(a.reflowTimeout),a.reflowTimeout=syncTimeout$3(function(){a.container&&a.setSize(void 0,void 0,!1)},d?100:0)),a.containerWidth=P,a.containerHeight=k)},g.prototype.setReflow=function(d){var a=this;d!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$_(win$8,"resize",function(p){a.options&&a.reflow(p)}),addEvent$_(this,"destroy",this.unbindReflow)):d===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},g.prototype.setSize=function(d,a,p){var v=this,C=v.renderer;v.isResizing+=1,setAnimation$3(p,v);var P=C.globalAnimation;v.oldChartHeight=v.chartHeight,v.oldChartWidth=v.chartWidth,typeof d<"u"&&(v.options.chart.width=d),typeof a<"u"&&(v.options.chart.height=a),v.getChartSize(),v.styledMode||(P?animate:css$5)(v.container,{width:v.chartWidth+"px",height:v.chartHeight+"px"},P),v.setChartSize(!0),C.setSize(v.chartWidth,v.chartHeight,P),v.axes.forEach(function(k){k.isDirty=!0,k.setScale()}),v.isDirtyLegend=!0,v.isDirtyBox=!0,v.layOutTitles(),v.getMargins(),v.redraw(P),v.oldChartHeight=null,fireEvent$t(v,"resize"),syncTimeout$3(function(){v&&fireEvent$t(v,"endResize",null,function(){v.isResizing-=1})},animObject$8(P).duration)},g.prototype.setChartSize=function(d){var a=this,p=a.inverted,v=a.renderer,C=a.chartWidth,P=a.chartHeight,k=a.options.chart,z=a.spacing,$=a.clipOffset,D,F,N,W;a.plotLeft=D=Math.round(a.plotLeft),a.plotTop=F=Math.round(a.plotTop),a.plotWidth=N=Math.max(0,Math.round(C-D-a.marginRight)),a.plotHeight=W=Math.max(0,Math.round(P-F-a.marginBottom)),a.plotSizeX=p?W:N,a.plotSizeY=p?N:W,a.plotBorderWidth=k.plotBorderWidth||0,a.spacingBox=v.spacingBox={x:z[3],y:z[0],width:C-z[3]-z[1],height:P-z[0]-z[2]},a.plotBox=v.plotBox={x:D,y:F,width:N,height:W};var j=2*Math.floor(a.plotBorderWidth/2),q=Math.ceil(Math.max(j,$[3])/2),X=Math.ceil(Math.max(j,$[0])/2);a.clipBox={x:q,y:X,width:Math.floor(a.plotSizeX-Math.max(j,$[1])/2-q),height:Math.max(0,Math.floor(a.plotSizeY-Math.max(j,$[2])/2-X))},d||(a.axes.forEach(function(K){K.setAxisSize(),K.setAxisTranslation()}),v.alignElements()),fireEvent$t(a,"afterSetChartSize",{skipAxes:d})},g.prototype.resetMargins=function(){fireEvent$t(this,"resetMargins");var d=this,a=d.options.chart;["margin","spacing"].forEach(function(v){var C=a[v],P=isObject$c(C)?C:[C,C,C,C];["Top","Right","Bottom","Left"].forEach(function(k,z){d[v][z]=pick$1q(a[v+k],P[z])})}),marginNames.forEach(function(p,v){d[p]=pick$1q(d.margin[v],d.spacing[v])}),d.axisOffset=[0,0,0,0],d.clipOffset=[0,0,0,0]},g.prototype.drawChartBox=function(){var d=this,a=d.options.chart,p=d.renderer,v=d.chartWidth,C=d.chartHeight,P=d.styledMode,k=d.plotBGImage,z=a.backgroundColor,$=a.plotBackgroundColor,D=a.plotBackgroundImage,F=d.plotLeft,N=d.plotTop,W=d.plotWidth,j=d.plotHeight,q=d.plotBox,X=d.clipRect,K=d.clipBox,ee=d.chartBackground,te=d.plotBackground,ie=d.plotBorder,oe,ae,le,ce="animate";ee||(d.chartBackground=ee=p.rect().addClass("highcharts-background").add(),ce="attr"),P?oe=ae=ee.strokeWidth():(oe=a.borderWidth||0,ae=oe+(a.shadow?8:0),le={fill:z||"none"},(oe||ee["stroke-width"])&&(le.stroke=a.borderColor,le["stroke-width"]=oe),ee.attr(le).shadow(a.shadow)),ee[ce]({x:ae/2,y:ae/2,width:v-ae-oe%2,height:C-ae-oe%2,r:a.borderRadius}),ce="animate",te||(ce="attr",d.plotBackground=te=p.rect().addClass("highcharts-plot-background").add()),te[ce](q),P||(te.attr({fill:$||"none"}).shadow(a.plotShadow),D&&(k?(D!==k.attr("href")&&k.attr("href",D),k.animate(q)):d.plotBGImage=p.image(D,F,N,W,j).add())),X?X.animate({width:K.width,height:K.height}):d.clipRect=p.clipRect(K),ce="animate",ie||(ce="attr",d.plotBorder=ie=p.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),P||ie.attr({stroke:a.plotBorderColor,"stroke-width":a.plotBorderWidth||0,fill:"none"}),ie[ce](ie.crisp({x:F,y:N,width:W,height:j},-ie.strokeWidth())),d.isDirtyBox=!1,fireEvent$t(this,"afterDrawChartBox")},g.prototype.propFromSeries=function(){var d=this,a=d.options.chart,p=d.options.series,v,C,P;["inverted","angular","polar"].forEach(function(k){for(C=seriesTypes$8[a.type||a.defaultSeriesType],P=a[k]||C&&C.prototype[k],v=p&&p.length;!P&&v--;)C=seriesTypes$8[p[v].type],C&&C.prototype[k]&&(P=!0);d[k]=P})},g.prototype.linkSeries=function(){var d=this,a=d.series;a.forEach(function(p){p.linkedSeries.length=0}),a.forEach(function(p){var v=p.options.linkedTo;isString$6(v)&&(v===":previous"?v=d.series[p.index-1]:v=d.get(v),v&&v.linkedParent!==p&&(v.linkedSeries.push(p),p.linkedParent=v,v.enabledDataSorting&&p.setDataSortingOptions(),p.visible=pick$1q(p.options.visible,v.options.visible,p.visible)))}),fireEvent$t(this,"afterLinkSeries")},g.prototype.renderSeries=function(){this.series.forEach(function(d){d.translate(),d.render()})},g.prototype.renderLabels=function(){var d=this,a=d.options.labels;a.items&&a.items.forEach(function(p){var v=extend$1l(a.style,p.style),C=pInt$4(v.left)+d.plotLeft,P=pInt$4(v.top)+d.plotTop+12;delete v.left,delete v.top,d.renderer.text(p.html,C,P).attr({zIndex:2}).css(v).add()})},g.prototype.render=function(){var d=this,a=d.axes,p=d.colorAxis,v=d.renderer,C=d.options,P=function(N){N.forEach(function(W){W.visible&&W.render()})},k=0;d.setTitle(),d.legend=new Legend(d,C.legend),d.getStacks&&d.getStacks(),d.getMargins(!0),d.setChartSize();var z=d.plotWidth;a.some(function(N){if(N.horiz&&N.visible&&N.options.labels.enabled&&N.series.length)return k=21,!0}),d.plotHeight=Math.max(d.plotHeight-k,0);var $=d.plotHeight;a.forEach(function(N){N.setScale()}),d.getAxisMargins();var D=z/d.plotWidth>1.1,F=$/d.plotHeight>1.05;(D||F)&&(a.forEach(function(N){(N.horiz&&D||!N.horiz&&F)&&N.setTickInterval(!0)}),d.getMargins()),d.drawChartBox(),d.hasCartesianSeries?P(a):p&&p.length&&P(p),d.seriesGroup||(d.seriesGroup=v.g("series-group").attr({zIndex:3}).add()),d.renderSeries(),d.renderLabels(),d.addCredits(),d.setResponsive&&d.setResponsive(),d.hasRendered=!0},g.prototype.addCredits=function(d){var a=this,p=merge$1i(!0,this.options.credits,d);p.enabled&&!this.credits&&(this.credits=this.renderer.text(p.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){p.href&&(win$8.location.href=p.href)}).attr({align:p.position.align,zIndex:8}),a.styledMode||this.credits.css(p.style),this.credits.add().align(p.position),this.credits.update=function(v){a.credits=a.credits.destroy(),a.addCredits(v)})},g.prototype.destroy=function(){var d=this,a=d.axes,p=d.series,v=d.container,C=v&&v.parentNode,P;for(fireEvent$t(d,"destroy"),d.renderer.forExport?erase$4(charts$1,d):charts$1[d.index]=void 0,H.chartCount--,d.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(d),P=a.length;P--;)a[P]=a[P].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),P=p.length;P--;)p[P]=p[P].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(k){var z=d[k];z&&z.destroy&&(d[k]=z.destroy())}),v&&(v.innerHTML="",removeEvent$6(v),C&&discardElement$3(v)),objectEach$p(d,function(k,z){delete d[z]})},g.prototype.firstRender=function(){var d=this,a=d.options;d.isReadyToRender&&!d.isReadyToRender()||(d.getContainer(),d.resetMargins(),d.setChartSize(),d.propFromSeries(),d.getAxes(),(isArray$j(a.series)?a.series:[]).forEach(function(p){d.initSeries(p)}),d.linkSeries(),d.setSeriesData(),fireEvent$t(d,"beforeRender"),Pointer&&(MSPointer.isRequired()?d.pointer=new MSPointer(d,a):d.pointer=new Pointer(d,a)),d.render(),d.pointer.getChartPosition(),!d.renderer.imgCount&&!d.hasLoaded&&d.onload(),d.temporaryDisplay(!0))},g.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(d){d&&typeof this.index<"u"&&d.apply(this,[this])},this),fireEvent$t(this,"load"),fireEvent$t(this,"render"),defined$L(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},g.prototype.addSeries=function(d,a,p){var v=this,C;return d&&(a=pick$1q(a,!0),fireEvent$t(v,"addSeries",{options:d},function(){C=v.initSeries(d),v.isDirtyLegend=!0,v.linkSeries(),C.enabledDataSorting&&C.setData(d.data,!1),fireEvent$t(v,"afterAddSeries",{series:C}),a&&v.redraw(p)})),C},g.prototype.addAxis=function(d,a,p,v){return this.createAxis(a?"xAxis":"yAxis",{axis:d,redraw:p,animation:v})},g.prototype.addColorAxis=function(d,a,p){return this.createAxis("colorAxis",{axis:d,redraw:a,animation:p})},g.prototype.createAxis=function(d,a){var p=new Axis(this,merge$1i(a.axis,{index:this[d].length,isX:d==="xAxis"}));return pick$1q(a.redraw,!0)&&this.redraw(a.animation),p},g.prototype.showLoading=function(d){var a=this,p=a.options,v=p.loading,C=function(){P&&css$5(P,{left:a.plotLeft+"px",top:a.plotTop+"px",width:a.plotWidth+"px",height:a.plotHeight+"px"})},P=a.loadingDiv,k=a.loadingSpan;P||(a.loadingDiv=P=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,a.container)),k||(a.loadingSpan=k=createElement$5("span",{className:"highcharts-loading-inner"},null,P),addEvent$_(a,"redraw",C)),P.className="highcharts-loading",AST.setElementHTML(k,pick$1q(d,p.lang.loading,"")),a.styledMode||(css$5(P,extend$1l(v.style,{zIndex:10})),css$5(k,v.labelStyle),a.loadingShown||(css$5(P,{opacity:0,display:""}),animate(P,{opacity:v.style.opacity||.5},{duration:v.showDuration||0}))),a.loadingShown=!0,C()},g.prototype.hideLoading=function(){var d=this.options,a=this.loadingDiv;a&&(a.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(a,{opacity:0},{duration:d.loading.hideDuration||100,complete:function(){css$5(a,{display:"none"})}})),this.loadingShown=!1},g.prototype.update=function(d,a,p,v){var C=this,P={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},k=d.isResponsiveOptions,z=[],$,D,F;fireEvent$t(C,"update",{options:d}),k||C.setResponsive(!1,!0),d=cleanRecursively$1(d,C.options),C.userOptions=merge$1i(C.userOptions,d);var N=d.chart;N&&(merge$1i(!0,C.options.chart,N),"className"in N&&C.setClassName(N.className),"reflow"in N&&C.setReflow(N.reflow),("inverted"in N||"polar"in N||"type"in N)&&(C.propFromSeries(),$=!0),"alignTicks"in N&&($=!0),"events"in N&&registerEventOptions$1(this,N),objectEach$p(N,function(q,X){C.propsRequireUpdateSeries.indexOf("chart."+X)!==-1&&(D=!0),C.propsRequireDirtyBox.indexOf(X)!==-1&&(C.isDirtyBox=!0),C.propsRequireReflow.indexOf(X)!==-1&&(k?C.isDirtyBox=!0:F=!0)}),!C.styledMode&&N.style&&C.renderer.setStyle(C.options.chart.style||{})),!C.styledMode&&d.colors&&(this.options.colors=d.colors),d.time&&(this.time===defaultTime&&(this.time=new Time(d.time)),merge$1i(!0,C.options.time,d.time)),objectEach$p(d,function(q,X){C[X]&&typeof C[X].update=="function"?C[X].update(q,!1):typeof C[P[X]]=="function"?C[P[X]](q):X!=="colors"&&C.collectionsWithUpdate.indexOf(X)===-1&&merge$1i(!0,C.options[X],d[X]),X!=="chart"&&C.propsRequireUpdateSeries.indexOf(X)!==-1&&(D=!0)}),this.collectionsWithUpdate.forEach(function(q){var X;d[q]&&(X=[],C[q].forEach(function(K,ee){K.options.isInternal||X.push(pick$1q(K.options.index,ee))}),splat$f(d[q]).forEach(function(K,ee){var te=defined$L(K.id),ie;te&&(ie=C.get(K.id)),!ie&&C[q]&&(ie=C[q][X?X[ee]:ee],ie&&te&&defined$L(ie.options.id)&&(ie=void 0)),ie&&ie.coll===q&&(ie.update(K,!1),p&&(ie.touched=!0)),!ie&&p&&C.collectionsWithInit[q]&&(C.collectionsWithInit[q][0].apply(C,[K].concat(C.collectionsWithInit[q][1]||[]).concat([!1])).touched=!0)}),p&&C[q].forEach(function(K){!K.touched&&!K.options.isInternal?z.push(K):delete K.touched}))}),z.forEach(function(q){q.chart&&q.remove&&q.remove(!1)}),$&&C.axes.forEach(function(q){q.update({},!1)}),D&&C.getSeriesOrderByLinks().forEach(function(q){q.chart&&q.update({},!1)},this);var W=N&&N.width,j=N&&(isString$6(N.height)?relativeLength$7(N.height,W||C.chartWidth):N.height);F||isNumber$H(W)&&W!==C.chartWidth||isNumber$H(j)&&j!==C.chartHeight?C.setSize(W,j,v):pick$1q(a,!0)&&C.redraw(v),fireEvent$t(C,"afterUpdate",{options:d,redraw:a,animation:v})},g.prototype.setSubtitle=function(d,a){this.applyDescription("subtitle",d),this.layOutTitles(a)},g.prototype.setCaption=function(d,a){this.applyDescription("caption",d),this.layOutTitles(a)},g.prototype.showResetZoom=function(){var d=this,a=defaultOptions$e.lang,p=d.options.chart.resetZoomButton,v=p.theme,C=v.states,P=p.relativeTo==="chart"||p.relativeTo==="spacingBox"?null:"scrollablePlotBox";function k(){d.zoomOut()}fireEvent$t(this,"beforeShowResetZoom",null,function(){d.resetZoomButton=d.renderer.button(a.resetZoom,null,null,k,v,C&&C.hover).attr({align:p.position.align,title:a.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(p.position,!1,P)}),fireEvent$t(this,"afterShowResetZoom")},g.prototype.zoomOut=function(){fireEvent$t(this,"selection",{resetSelection:!0},this.zoom)},g.prototype.zoom=function(d){var a=this,p=a.pointer,v=a.inverted?p.mouseDownX:p.mouseDownY,C=!1,P;!d||d.resetSelection?(a.axes.forEach(function(z){P=z.zoom()}),p.initiated=!1):d.xAxis.concat(d.yAxis).forEach(function(z){var $=z.axis,D=a.inverted?$.left:$.top,F=a.inverted?D+$.width:D+$.height,N=$.isXAxis,W=!1;(!N&&v>=D&&v<=F||N||!defined$L(v))&&(W=!0),p[N?"zoomX":"zoomY"]&&W&&(P=$.zoom(z.min,z.max),$.displayBtn&&(C=!0))});var k=a.resetZoomButton;C&&!k?a.showResetZoom():!C&&isObject$c(k)&&(a.resetZoomButton=k.destroy()),P&&a.redraw(pick$1q(a.options.chart.animation,d&&d.animation,a.pointCount<100))},g.prototype.pan=function(d,a){var p=this,v=p.hoverPoints,C=typeof a=="object"?a:{enabled:a,type:"x"},P=p.options.chart,k=p.options.mapNavigation&&p.options.mapNavigation.enabled;P&&P.panning&&(P.panning=C);var z=C.type,$;fireEvent$t(this,"pan",{originalEvent:d},function(){v&&v.forEach(function(N){N.setState()});var D=p.xAxis;z==="xy"?D=D.concat(p.yAxis):z==="y"&&(D=p.yAxis);var F={};D.forEach(function(N){if(!(!N.options.panningEnabled||N.options.isInternal)){var W=N.horiz,j=d[W?"chartX":"chartY"],q=W?"mouseDownX":"mouseDownY",X=p[q],K=N.minPointOffset||0,ee=N.reversed&&!p.inverted||!N.reversed&&p.inverted?-1:1,te=N.getExtremes(),ie=N.toValue(X-j,!0)+K*ee,oe=N.toValue(X+N.len-j,!0)-(K*ee||N.isXAxis&&N.pointRangePadding||0),ae=oe<ie,le=N.hasVerticalPanning(),ce=ae?oe:ie,ue=ae?ie:oe,ge=N.panningState,ye;le&&!N.isXAxis&&(!ge||ge.isDirty)&&N.series.forEach(function(be){var _e=be.getProcessedData(!0),Ce=be.getExtremes(_e.yData,!0);ge||(ge={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$H(Ce.dataMin)&&isNumber$H(Ce.dataMax)&&(ge.startMin=Math.min(pick$1q(be.options.threshold,1/0),Ce.dataMin,ge.startMin),ge.startMax=Math.max(pick$1q(be.options.threshold,-1/0),Ce.dataMax,ge.startMax))});var we=Math.min(pick$1q(ge&&ge.startMin,te.dataMin),K?te.min:N.toValue(N.toPixels(te.min)-N.minPixelPadding)),ve=Math.max(pick$1q(ge&&ge.startMax,te.dataMax),K?te.max:N.toValue(N.toPixels(te.max)+N.minPixelPadding));N.panningState=ge,N.isOrdinal||(ye=we-ce,ye>0&&(ue+=ye,ce=we),ye=ue-ve,ye>0&&(ue=ve,ce-=ye),N.series.length&&ce!==te.min&&ue!==te.max&&ce>=we&&ue<=ve&&(N.setExtremes(ce,ue,!1,!1,{trigger:"pan"}),!p.resetZoomButton&&!k&&ce!==we&&ue!==ve&&z.match("y")&&(p.showResetZoom(),N.displayBtn=!1),$=!0),F[q]=j)}}),objectEach$p(F,function(N,W){p[W]=N}),$&&p.redraw(!1),css$5(p.container,{cursor:"move"})})},g})();extend$1l(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$1h=Utilities.merge,pick$1p=Utilities.pick,LegendSymbol;(function(g){function d(p){var v=this.options,C=p.symbolWidth,P=p.symbolHeight,k=P/2,z=this.chart.renderer,$=this.legendGroup,D=p.baseline-Math.round(p.fontMetrics.b*.3),F={},N,W=v.marker;if(this.chart.styledMode||(F={"stroke-width":v.lineWidth||0},v.dashStyle&&(F.dashstyle=v.dashStyle)),this.legendLine=z.path([["M",0,D],["L",C,D]]).addClass("highcharts-graph").attr(F).add($),W&&W.enabled!==!1&&C){var j=Math.min(pick$1p(W.radius,k),k);this.symbol.indexOf("url")===0&&(W=merge$1h(W,{width:P,height:P}),j=0),this.legendSymbol=N=z.symbol(this.symbol,C/2-j,D-j,2*j,2*j,W).addClass("highcharts-point").add($),N.isMarker=!0}}g.drawLineMarker=d;function a(p,v){var C=p.options,P=p.symbolHeight,k=C.squareSymbol,z=k?P:p.symbolWidth;v.legendSymbol=this.chart.renderer.rect(k?(p.symbolWidth-P)/2:0,p.baseline-P+1,z,P,pick$1p(p.options.symbolRadius,P/2)).addClass("highcharts-point").attr({zIndex:3}).add(v.legendGroup)}g.drawRectangle=a})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var g=this.series.chart.numberFormatter;return typeof this.y!="number"?"":g(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$7=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions=exports$6.registerEventOptions,hasTouch$2=H.hasTouch,svg$4=H.svg,win$7=H.win,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$Z=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$g=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$K=Utilities.defined,erase$3=Utilities.erase,error$6=Utilities.error,extend$1k=Utilities.extend,find$h=Utilities.find,fireEvent$s=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$i=Utilities.isArray,isNumber$G=Utilities.isNumber,isString$5=Utilities.isString,merge$1g=Utilities.merge,objectEach$o=Utilities.objectEach,pick$1o=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$e=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$f=(function(){function g(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return g.prototype.init=function(d,a){fireEvent$s(this,"init",{options:a});var p=this,v=d.series;this.eventsToUnbind=[],p.chart=d,p.options=p.setOptions(a);var C=p.options;p.linkedSeries=[],p.bindAxes(),extend$1k(p,{name:C.name,state:"",visible:C.visible!==!1,selected:C.selected===!0}),registerEventOptions(this,C);var P=C.events;(P&&P.click||C.point&&C.point.events&&C.point.events.click||C.allowPointSelect)&&(d.runTrackerClick=!0),p.getColor(),p.getSymbol(),p.parallelArrays.forEach(function(z){p[z+"Data"]||(p[z+"Data"]=[])}),p.isCartesian&&(d.hasCartesianSeries=!0);var k;v.length&&(k=v[v.length-1]),p._i=pick$1o(k&&k._i,-1)+1,p.opacity=p.options.opacity,d.orderSeries(this.insert(v)),C.dataSorting&&C.dataSorting.enabled?p.setDataSortingOptions():!p.points&&!p.data&&p.setData(C.data,!1),fireEvent$s(this,"afterInit")},g.prototype.is=function(d){return seriesTypes$7[d]&&this instanceof seriesTypes$7[d]},g.prototype.insert=function(d){var a=this.options.index,p;if(isNumber$G(a)){for(p=d.length;p--;)if(a>=pick$1o(d[p].options.index,d[p]._i)){d.splice(p+1,0,this);break}p===-1&&d.unshift(this),p=p+1}else d.push(this);return pick$1o(p,d.length-1)},g.prototype.bindAxes=function(){var d=this,a=d.options,p=d.chart,v;fireEvent$s(this,"bindAxes",null,function(){(d.axisTypes||[]).forEach(function(C){var P=0;p[C].forEach(function(k){v=k.options,(a[C]===P&&!v.isInternal||typeof a[C]<"u"&&a[C]===v.id||typeof a[C]>"u"&&v.index===0)&&(d.insert(k.series),d[C]=k,k.isDirty=!0),v.isInternal||P++}),!d[C]&&d.optionalAxis!==C&&error$6(18,!0,p)})}),fireEvent$s(this,"afterBindAxes")},g.prototype.updateParallelArrays=function(d,a){var p=d.series,v=arguments,C=isNumber$G(a)?function(P){var k=P==="y"&&p.toYData?p.toYData(d):d[P];p[P+"Data"][a]=k}:function(P){Array.prototype[a].apply(p[P+"Data"],Array.prototype.slice.call(v,2))};p.parallelArrays.forEach(C)},g.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},g.prototype.autoIncrement=function(d){var a=this.options,p=a.pointIntervalUnit,v=a.relativeXValue,C=this.chart.time,P=this.xIncrement,k,z;return P=pick$1o(P,a.pointStart,0),this.pointInterval=z=pick$1o(this.pointInterval,a.pointInterval,1),v&&isNumber$G(d)&&(z*=d),p&&(k=new C.Date(P),p==="day"?C.set("Date",k,C.get("Date",k)+z):p==="month"?C.set("Month",k,C.get("Month",k)+z):p==="year"&&C.set("FullYear",k,C.get("FullYear",k)+z),z=k.getTime()-P),v&&isNumber$G(d)?P+z:(this.xIncrement=P+z,P)},g.prototype.setDataSortingOptions=function(){var d=this.options;extend$1k(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$K(d.pointRange)||(d.pointRange=1)},g.prototype.setOptions=function(d){var a=this.chart,p=a.options,v=p.plotOptions,C=a.userOptions||{},P=merge$1g(d),k=a.styledMode,z={plotOptions:v,userOptions:P},$;fireEvent$s(this,"setOptions",z);var D=z.plotOptions[this.type],F=C.plotOptions||{};this.userOptions=z.userOptions;var N=merge$1g(D,v.series,C.plotOptions&&C.plotOptions[this.type],P);this.tooltipOptions=merge$1g(defaultOptions$d.tooltip,defaultOptions$d.plotOptions.series&&defaultOptions$d.plotOptions.series.tooltip,defaultOptions$d.plotOptions[this.type].tooltip,p.tooltip.userOptions,v.series&&v.series.tooltip,v[this.type].tooltip,P.tooltip),this.stickyTracking=pick$1o(P.stickyTracking,F[this.type]&&F[this.type].stickyTracking,F.series&&F.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:N.stickyTracking),D.marker===null&&delete N.marker,this.zoneAxis=N.zoneAxis;var W=this.zones=(N.zones||[]).slice();return(N.negativeColor||N.negativeFillColor)&&!N.zones&&($={value:N[this.zoneAxis+"Threshold"]||N.threshold||0,className:"highcharts-negative"},k||($.color=N.negativeColor,$.fillColor=N.negativeFillColor),W.push($)),W.length&&defined$K(W[W.length-1].value)&&W.push(k?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$s(this,"afterSetOptions",{options:N}),N},g.prototype.getName=function(){return pick$1o(this.options.name,"Series "+(this.index+1))},g.prototype.getCyclic=function(d,a,p){var v=this.chart,C=this.userOptions,P=d+"Index",k=d+"Counter",z=p?p.length:pick$1o(v.options.chart[d+"Count"],v[d+"Count"]),$,D;a||(D=pick$1o(C[P],C["_"+P]),defined$K(D)?$=D:(v.series.length||(v[k]=0),C["_"+P]=$=v[k]%z,v[k]+=1),p&&(a=p[$])),typeof $<"u"&&(this[P]=$),this[d]=a},g.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$d.plotOptions[this.type].color,this.chart.options.colors)},g.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},g.prototype.getSymbol=function(){var d=this.options.marker;this.getCyclic("symbol",d.symbol,this.chart.options.symbols)},g.prototype.findPointIndex=function(d,a){var p=d.id,v=d.x,C=this.points,P=this.options.dataSorting,k,z,$;if(p){var D=this.chart.get(p);D instanceof Point$4&&(k=D)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var F=function(N){return!N.touched&&N.index===d.index};if(P&&P.matchByName?F=function(N){return!N.touched&&N.name===d.name}:this.options.relativeXValue&&(F=function(N){return!N.touched&&N.options.x===d.x}),k=find$h(C,F),!k)return}return k&&($=k&&k.index,typeof $<"u"&&(z=!0)),typeof $>"u"&&isNumber$G(v)&&($=this.xData.indexOf(v,a)),$!==-1&&typeof $<"u"&&this.cropped&&($=$>=this.cropStart?$-this.cropStart:$),!z&&isNumber$G($)&&C[$]&&C[$].touched&&($=void 0),$},g.prototype.updateData=function(d,a){var p=this.options,v=p.dataSorting,C=this.points,P=[],k=this.requireSorting,z=d.length===C.length,$,D,F,N,W=!0;if(this.xIncrement=null,d.forEach(function(j,q){var X=defined$K(j)&&this.pointClass.prototype.optionsToObject.call({series:this},j)||{},K,ee=X.x,te=X.id;te||isNumber$G(ee)?(K=this.findPointIndex(X,N),K===-1||typeof K>"u"?P.push(j):C[K]&&j!==p.data[K]?(C[K].update(j,!1,null,!1),C[K].touched=!0,k&&(N=K+1)):C[K]&&(C[K].touched=!0),(!z||q!==K||v&&v.enabled||this.hasDerivedData)&&($=!0)):P.push(j)},this),$)for(D=C.length;D--;)F=C[D],F&&!F.touched&&F.remove&&F.remove(!1,a);else z&&(!v||!v.enabled)?(d.forEach(function(j,q){j!==C[q].y&&C[q].update&&C[q].update(j,!1,null,!1)}),P.length=0):W=!1;return C.forEach(function(j){j&&(j.touched=!1)}),W?(P.forEach(function(j){this.addPoint(j,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},g.prototype.setData=function(d,a,p,v){var C=this,P=C.points,k=P&&P.length||0,z=C.options,$=C.chart,D=z.dataSorting,F=C.xAxis,N=z.turboThreshold,W=this.xData,j=this.yData,q=C.pointArrayMap,X=q&&q.length,K=z.keys,ee,te,ie,oe=0,ae=1,le=null;d=d||[];var ce=d.length;if(a=pick$1o(a,!0),D&&D.enabled&&(d=this.sortData(d)),v!==!1&&ce&&k&&!C.cropped&&!C.hasGroupedData&&C.visible&&!C.isSeriesBoosting&&(ie=this.updateData(d,p)),!ie){if(C.xIncrement=null,C.colorCounter=0,this.parallelArrays.forEach(function(ue){C[ue+"Data"].length=0}),N&&ce>N)if(le=C.getFirstValidPoint(d),isNumber$G(le))for(ee=0;ee<ce;ee++)W[ee]=this.autoIncrement(),j[ee]=d[ee];else if(isArray$i(le))if(X)for(ee=0;ee<ce;ee++)te=d[ee],W[ee]=te[0],j[ee]=te.slice(1,X+1);else for(K&&(oe=K.indexOf("x"),ae=K.indexOf("y"),oe=oe>=0?oe:0,ae=ae>=0?ae:1),ee=0;ee<ce;ee++)te=d[ee],W[ee]=te[oe],j[ee]=te[ae];else error$6(12,!1,$);else for(ee=0;ee<ce;ee++)typeof d[ee]<"u"&&(te={series:C},C.pointClass.prototype.applyOptions.apply(te,[d[ee]]),C.updateParallelArrays(te,ee));for(j&&isString$5(j[0])&&error$6(14,!0,$),C.data=[],C.options.data=C.userOptions.data=d,ee=k;ee--;)P[ee]&&P[ee].destroy&&P[ee].destroy();F&&(F.minRange=F.userMinRange),C.isDirty=$.isDirtyBox=!0,C.isDirtyData=!!P,p=!1}z.legendType==="point"&&(this.processData(),this.generatePoints()),a&&$.redraw(p)},g.prototype.sortData=function(d){var a=this,p=a.options,v=p.dataSorting,C=v.sortKey||"y",P=function(z,$){return defined$K($)&&z.pointClass.prototype.optionsToObject.call({series:z},$)||{}};d.forEach(function(z,$){d[$]=P(a,z),d[$].index=$},this);var k=d.concat().sort(function(z,$){var D=getNestedProperty(C,z),F=getNestedProperty(C,$);return F<D?-1:F>D?1:0});return k.forEach(function(z,$){z.x=$},this),a.linkedSeries&&a.linkedSeries.forEach(function(z){var $=z.options,D=$.data;(!$.dataSorting||!$.dataSorting.enabled)&&D&&(D.forEach(function(F,N){D[N]=P(z,F),d[N]&&(D[N].x=d[N].x,D[N].index=N)}),z.setData(D,!1))}),d},g.prototype.getProcessedData=function(d){var a=this,p=a.xAxis,v=a.options,C=v.cropThreshold,P=d||a.getExtremesFromAll||v.getExtremesFromAll,k=a.isCartesian,z=p&&p.val2lin,$=!!(p&&p.logarithmic),D,F,N=0,W,j,q,X,K,ee,te=a.xData,ie=a.yData,oe=a.requireSorting,ae=!1,le=te.length;for(p&&(X=p.getExtremes(),K=X.min,ee=X.max,ae=p.categories&&!p.names.length),k&&a.sorted&&!P&&(!C||le>C||a.forceCrop)&&(te[le-1]<K||te[0]>ee?(te=[],ie=[]):a.yData&&(te[0]<K||te[le-1]>ee)&&(D=this.cropData(a.xData,a.yData,K,ee),te=D.xData,ie=D.yData,N=D.start,F=!0)),q=te.length||1;--q;)W=$?z(te[q])-z(te[q-1]):te[q]-te[q-1],W>0&&(typeof j>"u"||W<j)?j=W:W<0&&oe&&!ae&&(error$6(15,!1,a.chart),oe=!1);return{xData:te,yData:ie,cropped:F,cropStart:N,closestPointRange:j}},g.prototype.processData=function(d){var a=this,p=a.xAxis;if(a.isCartesian&&!a.isDirty&&!p.isDirty&&!a.yAxis.isDirty&&!d)return!1;var v=a.getProcessedData();a.cropped=v.cropped,a.cropStart=v.cropStart,a.processedXData=v.xData,a.processedYData=v.yData,a.closestPointRange=a.basePointRange=v.closestPointRange},g.prototype.cropData=function(d,a,p,v,C){var P=d.length,k,z,$=0,D=P;for(C=pick$1o(C,this.cropShoulder),k=0;k<P;k++)if(d[k]>=p){$=Math.max(0,k-C);break}for(z=k;z<P;z++)if(d[z]>v){D=z+C;break}return{xData:d.slice($,D),yData:a.slice($,D),start:$,end:D}},g.prototype.generatePoints=function(){var d=this,a=d.options,p=a.data,v=d.processedXData,C=d.processedYData,P=d.pointClass,k=v.length,z=d.cropStart||0,$=d.hasGroupedData,D=a.keys,F=[],N=a.dataGrouping&&a.dataGrouping.groupAll?z:0,W,j,q,X,K=d.data;if(!K&&!$){var ee=[];ee.length=p.length,K=d.data=ee}for(D&&$&&(d.options.keys=!1),X=0;X<k;X++)j=z+X,$?(q=new P().init(d,[v[X]].concat(splat$e(C[X]))),q.dataGroup=d.groupMap[N+X],q.dataGroup.options&&(q.options=q.dataGroup.options,extend$1k(q,q.dataGroup.options),delete q.dataLabels)):(q=K[j],!q&&typeof p[j]<"u"&&(K[j]=q=new P().init(d,p[j],v[X]))),q&&(q.index=$?N+X:j,F[X]=q);if(d.options.keys=D,K&&(k!==(W=K.length)||$))for(X=0;X<W;X++)X===z&&!$&&(X+=k),K[X]&&(K[X].destroyElements(),K[X].plotX=void 0);d.data=K,d.points=F,fireEvent$s(this,"afterGeneratePoints")},g.prototype.getXExtremes=function(d){return{min:arrayMin$6(d),max:arrayMax$7(d)}},g.prototype.getExtremes=function(d,a){var p=this.xAxis,v=this.yAxis,C=this.processedXData||this.xData,P=[],k=this.requireSorting?this.cropShoulder:0,z=v?v.positiveValuesOnly:!1,$,D,F,N,W,j,q,X=0,K=0,ee=0;d=d||this.stackedYData||this.processedYData||[];var te=d.length;for(p&&($=p.getExtremes(),X=$.min,K=$.max),j=0;j<te;j++)if(N=C[j],W=d[j],D=(isNumber$G(W)||isArray$i(W))&&(W.length||W>0||!z),F=a||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!p||(C[j+k]||N)>=X&&(C[j-k]||N)<=K,D&&F)if(q=W.length,q)for(;q--;)isNumber$G(W[q])&&(P[ee++]=W[q]);else P[ee++]=W;var ie={dataMin:arrayMin$6(P),dataMax:arrayMax$7(P)};return fireEvent$s(this,"afterGetExtremes",{dataExtremes:ie}),ie},g.prototype.applyExtremes=function(){var d=this.getExtremes();return this.dataMin=d.dataMin,this.dataMax=d.dataMax,d},g.prototype.getFirstValidPoint=function(d){for(var a=d.length,p=0,v=null;v===null&&p<a;)v=d[p],p++;return v},g.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var d=this,a=d.options,p=a.stacking,v=d.xAxis,C=v.categories,P=d.enabledDataSorting,k=d.yAxis,z=d.points,$=z.length,D=!!d.modifyValue,F=d.pointPlacementToXValue(),N=!!F,W=a.threshold,j=a.startFromThreshold?W:0,q=this.zoneAxis||"y",X,K,ee,te,ie=Number.MAX_VALUE;function oe(be){return clamp$g(be,-1e5,1e5)}for(X=0;X<$;X++){var ae=z[X],le=ae.x,ce=void 0,ue=void 0,ge=ae.y,ye=ae.low,we=p&&k.stacking&&k.stacking.stacks[(d.negStacks&&ge<(j?0:W)?"-":"")+d.stackKey];if((k.positiveValuesOnly&&!k.validatePositiveValue(ge)||v.positiveValuesOnly&&!v.validatePositiveValue(le))&&(ae.isNull=!0),ae.plotX=K=correctFloat$a(oe(v.translate(le,0,0,0,1,F,this.type==="flags"))),p&&d.visible&&we&&we[le]&&(te=d.getStackIndicator(te,le,d.index),ae.isNull||(ce=we[le],ue=ce.points[te.key])),isArray$i(ue)&&(ye=ue[0],ge=ue[1],ye===j&&te.key===we[le].base&&(ye=pick$1o(isNumber$G(W)&&W,k.min)),k.positiveValuesOnly&&ye<=0&&(ye=null),ae.total=ae.stackTotal=ce.total,ae.percentage=ce.total&&ae.y/ce.total*100,ae.stackY=ge,d.irregularWidths||ce.setOffset(d.pointXOffset||0,d.barW||0)),ae.yBottom=defined$K(ye)?oe(k.translate(ye,0,1,0,1)):null,D&&(ge=d.modifyValue(ge,ae)),ae.plotY=void 0,isNumber$G(ge)){var ve=k.translate(ge,!1,!0,!1,!0);typeof ve<"u"&&(ae.plotY=oe(ve))}ae.isInside=this.isPointInside(ae),ae.clientX=N?correctFloat$a(v.translate(le,0,0,0,1,F)):K,ae.negative=ae[q]<(a[q+"Threshold"]||W||0),ae.category=C&&typeof C[ae.x]<"u"?C[ae.x]:ae.x,!ae.isNull&&ae.visible!==!1&&(typeof ee<"u"&&(ie=Math.min(ie,Math.abs(K-ee))),ee=K),ae.zone=this.zones.length&&ae.getZone(),!ae.graphic&&d.group&&P&&(ae.isNew=!0)}d.closestPointRangePx=ie,fireEvent$s(this,"afterTranslate")},g.prototype.getValidPoints=function(d,a,p){var v=this.chart;return(d||this.points||[]).filter(function(C){return a&&!v.isInsidePlot(C.plotX,C.plotY,{inverted:v.inverted})?!1:C.visible!==!1&&(p||!C.isNull)})},g.prototype.getClipBox=function(d,a){var p=this,v=p.options,C=p.chart,P=C.inverted,k=p.xAxis,z=k&&p.yAxis,$=C.options.chart.scrollablePlotArea||{},D;return d&&v.clip===!1&&z?D=P?{y:-C.chartWidth+z.len+z.pos,height:C.chartWidth,width:C.chartHeight,x:-C.chartHeight+k.len+k.pos}:{y:-z.pos,height:C.chartHeight,width:C.chartWidth,x:-k.pos}:(D=p.clipBox||C.clipBox,a&&(D.width=C.plotSizeX,D.x=(C.scrollablePixelsX||0)*($.scrollPositionX||0))),a?{width:D.width,x:D.x}:D},g.prototype.getSharedClipKey=function(d){if(this.sharedClipKey)return this.sharedClipKey;var a=[d&&d.duration,d&&d.easing,d&&d.defer,this.getClipBox(d).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||d)&&(this.sharedClipKey=a),a},g.prototype.setClip=function(d){var a=this.chart,p=this.options,v=a.renderer,C=a.inverted,P=this.clipBox,k=this.getClipBox(d),z=this.getSharedClipKey(d),$=a.sharedClips[z],D=a.sharedClips[z+"m"];d&&(k.width=0,C&&(k.x=a.plotHeight+(p.clip!==!1?0:a.plotTop))),$?a.hasLoaded||$.attr(k):(d&&(a.sharedClips[z+"m"]=D=v.clipRect(C?(a.plotSizeX||0)+99:-99,C?-a.plotLeft:-a.plotTop,99,C?a.chartWidth:a.chartHeight)),a.sharedClips[z]=$=v.clipRect(k),$.count={length:0}),d&&($.count[this.index]||($.count[this.index]=!0,$.count.length+=1)),(p.clip!==!1||d)&&(this.group.clip(d||P?$:a.clipRect),this.markerGroup.clip(D)),d||($.count[this.index]&&(delete $.count[this.index],$.count.length-=1),$.count.length===0&&(P||(a.sharedClips[z]=$.destroy()),D&&(a.sharedClips[z+"m"]=D.destroy())))},g.prototype.animate=function(d){var a=this,p=a.chart,v=animObject$7(a.options.animation),C=this.sharedClipKey;if(d)a.setClip(v);else if(C){var P=p.sharedClips[C],k=p.sharedClips[C+"m"],z=a.getClipBox(v,!0);P&&P.animate(z,v),k&&k.animate({width:z.width+99,x:z.x-(p.inverted?0:99)},v)}},g.prototype.afterAnimate=function(){this.setClip(),fireEvent$s(this,"afterAnimate"),this.finishedAnimating=!0},g.prototype.drawPoints=function(){var d=this,a=d.points,p=d.chart,v=d.options,C=v.marker,P=d[d.specialGroup]||d.markerGroup,k=d.xAxis,z=pick$1o(C.enabled,!k||k.isRadial?!0:null,d.closestPointRangePx>=C.enabledThreshold*C.radius),$,D,F,N,W,j,q;if(C.enabled!==!1||d._hasPointMarkers)for($=0;$<a.length;$++){D=a[$],F=D.graphic,N=F?"animate":"attr",W=D.marker||{},j=!!D.marker;var X=(z&&typeof W.enabled>"u"||W.enabled)&&!D.isNull&&D.visible!==!1;if(X){var K=pick$1o(W.symbol,d.symbol,"rect");q=d.markerAttribs(D,D.selected&&"select"),d.enabledDataSorting&&(D.startXPos=k.reversed?-(q.width||0):k.width);var ee=D.isInside!==!1;F?F[ee?"show":"hide"](ee).animate(q):ee&&((q.width||0)>0||D.hasImage)&&(D.graphic=F=p.renderer.symbol(K,q.x,q.y,q.width,q.height,j?W:C).add(P),d.enabledDataSorting&&p.hasRendered&&(F.attr({x:D.startXPos}),N="animate")),F&&N==="animate"&&F[ee?"show":"hide"](ee).animate(q),F&&!p.styledMode&&F[N](d.pointAttribs(D,D.selected&&"select")),F&&F.addClass(D.getClassName(),!0)}else F&&(D.graphic=F.destroy())}},g.prototype.markerAttribs=function(d,a){var p=this.options,v=p.marker,C=d.marker||{},P=C.symbol||v.symbol,k,z,$=pick$1o(C.radius,v.radius);a&&(k=v.states[a],z=C.states&&C.states[a],$=pick$1o(z&&z.radius,k&&k.radius,$+(k&&k.radiusPlus||0))),d.hasImage=P&&P.indexOf("url")===0,d.hasImage&&($=0);var D={x:p.crisp?Math.floor(d.plotX-$):d.plotX-$,y:d.plotY-$};return $&&(D.width=D.height=2*$),D},g.prototype.pointAttribs=function(d,a){var p=this.options.marker,v=d&&d.options,C=v&&v.marker||{},P=v&&v.color,k=d&&d.color,z=d&&d.zone&&d.zone.color,$,D,F=this.color,N,W,j=pick$1o(C.lineWidth,p.lineWidth),q=1;return F=P||z||k||F,N=C.fillColor||p.fillColor||F,W=C.lineColor||p.lineColor||F,a=a||"normal",a&&($=p.states[a],D=C.states&&C.states[a]||{},j=pick$1o(D.lineWidth,$.lineWidth,j+pick$1o(D.lineWidthPlus,$.lineWidthPlus,0)),N=D.fillColor||$.fillColor||N,W=D.lineColor||$.lineColor||W,q=pick$1o(D.opacity,$.opacity,q)),{stroke:W,"stroke-width":j,fill:N,opacity:q}},g.prototype.destroy=function(d){var a=this,p=a.chart,v=/AppleWebKit\/533/.test(win$7.navigator.userAgent),C=a.data||[],P,k,z,$;for(fireEvent$s(a,"destroy"),this.removeEvents(d),(a.axisTypes||[]).forEach(function(D){$=a[D],$&&$.series&&(erase$3($.series,a),$.isDirty=$.forceRedraw=!0)}),a.legendItem&&a.chart.legend.destroyItem(a),k=C.length;k--;)z=C[k],z&&z.destroy&&z.destroy();a.clips&&a.clips.forEach(function(D){return D.destroy()}),Utilities.clearTimeout(a.animationTimeout),objectEach$o(a,function(D,F){D instanceof SVGElement&&!D.survive&&(P=v&&F==="group"?"hide":"destroy",D[P]())}),p.hoverSeries===a&&(p.hoverSeries=void 0),erase$3(p.series,a),p.orderSeries(),objectEach$o(a,function(D,F){(!d||F!=="hcEvents")&&delete a[F]})},g.prototype.applyZones=function(){var d=this,a=this.chart,p=a.renderer,v=this.zones,C=this.clips||[],P=this.graph,k=this.area,z=Math.max(a.chartWidth,a.chartHeight),$=this[(this.zoneAxis||"y")+"Axis"],D=a.inverted,F,N,W,j,q,X,K,ee,te,ie,oe,ae=!1;v.length&&(P||k)&&$&&typeof $.min<"u"?(q=$.reversed,X=$.horiz,P&&!this.showLine&&P.hide(),k&&k.hide(),j=$.getExtremes(),v.forEach(function(le,ce){F=q?X?a.plotWidth:0:X?0:$.toPixels(j.min)||0,F=clamp$g(pick$1o(N,F),0,z),N=clamp$g(Math.round($.toPixels(pick$1o(le.value,j.max),!0)||0),0,z),ae&&(F=N=$.toPixels(j.max)),K=Math.abs(F-N),ee=Math.min(F,N),te=Math.max(F,N),$.isXAxis?(W={x:D?te:ee,y:0,width:K,height:z},X||(W.x=a.plotHeight-W.x)):(W={x:0,y:D?te:ee,width:z,height:K},X&&(W.y=a.plotWidth-W.y)),D&&p.isVML&&($.isXAxis?W={x:0,y:q?ee:te,height:W.width,width:a.chartWidth}:W={x:W.y-a.plotLeft-a.spacingBox.x,y:0,width:W.height,height:a.chartHeight}),C[ce]?C[ce].animate(W):C[ce]=p.clipRect(W),ie=d["zone-area-"+ce],oe=d["zone-graph-"+ce],P&&oe&&oe.clip(C[ce]),k&&ie&&ie.clip(C[ce]),ae=le.value>j.max,d.resetZones&&N===0&&(N=void 0)}),this.clips=C):d.visible&&(P&&P.show(!0),k&&k.show(!0))},g.prototype.invertGroups=function(d){var a=this,p=a.chart;function v(){["group","markerGroup"].forEach(function(C){a[C]&&(p.renderer.isVML&&a[C].attr({width:a.yAxis.len,height:a.xAxis.len}),a[C].width=a.yAxis.len,a[C].height=a.xAxis.len,a[C].invert(a.isRadialSeries?!1:d))})}a.xAxis&&(a.eventsToUnbind.push(addEvent$Z(p,"resize",v)),v(),a.invertGroups=v)},g.prototype.plotGroup=function(d,a,p,v,C){var P=this[d],k=!P,z={visibility:p,zIndex:v||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(z.opacity=this.opacity),k&&(this[d]=P=this.chart.renderer.g().add(C)),P.addClass("highcharts-"+a+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$K(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(P.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),P.attr(z)[k?"attr":"animate"](this.getPlotBox()),P},g.prototype.getPlotBox=function(){var d=this.chart,a=this.xAxis,p=this.yAxis;return d.inverted&&(a=p,p=this.xAxis),{translateX:a?a.left:d.plotLeft,translateY:p?p.top:d.plotTop,scaleX:1,scaleY:1}},g.prototype.removeEvents=function(d){var a=this;d||removeEvent$5(a),a.eventsToUnbind.length&&(a.eventsToUnbind.forEach(function(p){p()}),a.eventsToUnbind.length=0)},g.prototype.render=function(){var d=this,a=d.chart,p=d.options,v=animObject$7(p.animation),C=d.visible?"inherit":"hidden",P=p.zIndex,k=d.hasRendered,z=a.seriesGroup,$=a.inverted,D=!d.finishedAnimating&&a.renderer.isSVG&&v.duration;fireEvent$s(this,"render");var F=d.plotGroup("group","series",C,P,z);d.markerGroup=d.plotGroup("markerGroup","markers",C,P,z),D&&d.animate&&d.animate(!0),F.inverted=pick$1o(d.invertible,d.isCartesian)?$:!1,d.drawGraph&&(d.drawGraph(),d.applyZones()),d.visible&&d.drawPoints(),d.drawDataLabels&&d.drawDataLabels(),d.redrawPoints&&d.redrawPoints(),d.drawTracker&&d.options.enableMouseTracking!==!1&&d.drawTracker(),d.invertGroups($),p.clip!==!1&&!d.sharedClipKey&&!k&&F.clip(a.clipRect),D&&d.animate&&d.animate(),k||(D&&v.defer&&(D+=v.defer),d.animationTimeout=syncTimeout$2(function(){d.afterAnimate()},D||0)),d.isDirty=!1,d.hasRendered=!0,fireEvent$s(d,"afterRender")},g.prototype.redraw=function(){var d=this,a=d.chart,p=d.isDirty||d.isDirtyData,v=d.group,C=d.xAxis,P=d.yAxis;v&&(a.inverted&&v.attr({width:a.plotWidth,height:a.plotHeight}),v.animate({translateX:pick$1o(C&&C.left,a.plotLeft),translateY:pick$1o(P&&P.top,a.plotTop)})),d.translate(),d.render(),p&&delete this.kdTree},g.prototype.searchPoint=function(d,a){var p=this,v=p.xAxis,C=p.yAxis,P=p.chart.inverted;return this.searchKDTree({clientX:P?v.len-d.chartY+v.pos:d.chartX-v.pos,plotY:P?C.len-d.chartX+C.pos:d.chartY-C.pos},a,d)},g.prototype.buildKDTree=function(d){this.buildingKdTree=!0;var a=this,p=a.options.findNearestPointBy.indexOf("y")>-1?2:1;function v(P,k,z){var $=P&&P.length,D,F;if($)return D=a.kdAxisArray[k%z],P.sort(function(N,W){return N[D]-W[D]}),F=Math.floor($/2),{point:P[F],left:v(P.slice(0,F),k+1,z),right:v(P.slice(F+1),k+1,z)}}function C(){a.kdTree=v(a.getValidPoints(null,!a.directTouch),p,p),a.buildingKdTree=!1}delete a.kdTree,syncTimeout$2(C,a.options.kdNow||d&&d.type==="touchstart"?0:1)},g.prototype.searchKDTree=function(d,a,p){var v=this,C=this.kdAxisArray[0],P=this.kdAxisArray[1],k=a?"distX":"dist",z=v.options.findNearestPointBy.indexOf("y")>-1?2:1;function $(F,N){var W=defined$K(F[C])&&defined$K(N[C])?Math.pow(F[C]-N[C],2):null,j=defined$K(F[P])&&defined$K(N[P])?Math.pow(F[P]-N[P],2):null,q=(W||0)+(j||0);N.dist=defined$K(q)?Math.sqrt(q):Number.MAX_VALUE,N.distX=defined$K(W)?Math.sqrt(W):Number.MAX_VALUE}function D(F,N,W,j){var q=N.point,X=v.kdAxisArray[W%j],K,ee,te=q;$(F,q);var ie=F[X]-q[X],oe=ie<0?"left":"right",ae=ie<0?"right":"left";return N[oe]&&(K=D(F,N[oe],W+1,j),te=K[k]<te[k]?K:q),N[ae]&&Math.sqrt(ie*ie)<te[k]&&(ee=D(F,N[ae],W+1,j),te=ee[k]<te[k]?ee:te),te}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(p),this.kdTree)return D(d,this.kdTree,z,z)},g.prototype.pointPlacementToXValue=function(){var d=this,a=d.options,p=a.pointPlacement,v=a.pointRange,C=d.xAxis,P=p;return P==="between"&&(P=C.reversed?-.5:.5),isNumber$G(P)?P*(v||C.pointRange):0},g.prototype.isPointInside=function(d){var a=typeof d.plotY<"u"&&typeof d.plotX<"u"&&d.plotY>=0&&d.plotY<=this.yAxis.len&&d.plotX>=0&&d.plotX<=this.xAxis.len;return a},g.prototype.drawTracker=function(){var d=this,a=d.options,p=a.trackByArea,v=[].concat(p?d.areaPath:d.graphPath),C=d.chart,P=C.pointer,k=C.renderer,z=C.options.tooltip.snap,$=d.tracker,D=function(N){C.hoverSeries!==d&&d.onMouseOver()},F="rgba(192,192,192,"+(svg$4?1e-4:.002)+")";$?$.attr({d:v}):d.graph&&(d.tracker=k.path(v).attr({visibility:d.visible?"visible":"hidden",zIndex:2}).addClass(p?"highcharts-tracker-area":"highcharts-tracker-line").add(d.group),C.styledMode||d.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:F,fill:p?F:"none","stroke-width":d.graph.strokeWidth()+(p?0:2*z)}),[d.tracker,d.markerGroup,d.dataLabelsGroup].forEach(function(N){N&&(N.addClass("highcharts-tracker").on("mouseover",D).on("mouseout",function(W){P.onTrackerMouseOut(W)}),a.cursor&&!C.styledMode&&N.css({cursor:a.cursor}),hasTouch$2&&N.on("touchstart",D))})),fireEvent$s(this,"afterDrawTracker")},g.prototype.addPoint=function(d,a,p,v,C){var P=this,k=P.options,z=P.data,$=P.chart,D=P.xAxis,F=D&&D.hasNames&&D.names,N=k.data,W=P.xData,j,q;a=pick$1o(a,!0);var X={series:P};P.pointClass.prototype.applyOptions.apply(X,[d]);var K=X.x;if(q=W.length,P.requireSorting&&K<W[q-1])for(j=!0;q&&W[q-1]>K;)q--;P.updateParallelArrays(X,"splice",q,0,0),P.updateParallelArrays(X,q),F&&X.name&&(F[K]=X.name),N.splice(q,0,d),j&&(P.data.splice(q,0,null),P.processData()),k.legendType==="point"&&P.generatePoints(),p&&(z[0]&&z[0].remove?z[0].remove(!1):(z.shift(),P.updateParallelArrays(X,"shift"),N.shift())),C!==!1&&fireEvent$s(P,"addPoint",{point:X}),P.isDirty=!0,P.isDirtyData=!0,a&&$.redraw(v)},g.prototype.removePoint=function(d,a,p){var v=this,C=v.data,P=C[d],k=v.points,z=v.chart,$=function(){k&&k.length===C.length&&k.splice(d,1),C.splice(d,1),v.options.data.splice(d,1),v.updateParallelArrays(P||{series:v},"splice",d,1),P&&P.destroy(),v.isDirty=!0,v.isDirtyData=!0,a&&z.redraw()};setAnimation$2(p,z),a=pick$1o(a,!0),P?P.firePointEvent("remove",null,$):$()},g.prototype.remove=function(d,a,p,v){var C=this,P=C.chart;function k(){C.destroy(v),P.isDirtyLegend=P.isDirtyBox=!0,P.linkSeries(),pick$1o(d,!0)&&P.redraw(a)}p!==!1?fireEvent$s(C,"remove",null,k):k()},g.prototype.update=function(d,a){d=cleanRecursively(d,this.userOptions),fireEvent$s(this,"update",{options:d});var p=this,v=p.chart,C=p.userOptions,P=p.initialType||p.type,k=v.options.plotOptions,z=seriesTypes$7[P].prototype,$=["group","markerGroup","dataLabelsGroup","transformGroup"],D=p.finishedAnimating&&{animation:!1},F={},N,W,j=["eventOptions","navigatorSeries","baseSeries"],q=d.type||C.type||v.options.chart.type,X=!(this.hasDerivedData||q&&q!==this.type||typeof d.pointStart<"u"||typeof d.pointInterval<"u"||typeof d.relativeXValue<"u"||p.hasOptionChanged("dataGrouping")||p.hasOptionChanged("pointStart")||p.hasOptionChanged("pointInterval")||p.hasOptionChanged("pointIntervalUnit")||p.hasOptionChanged("keys"));q=q||P,X&&(j.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),d.visible!==!1&&j.push("area","graph"),p.parallelArrays.forEach(function(oe){j.push(oe+"Data")}),d.data&&(d.dataSorting&&extend$1k(p.options.dataSorting,d.dataSorting),this.setData(d.data,!1))),d=merge$1g(C,D,{index:typeof C.index>"u"?p.index:C.index,pointStart:pick$1o(k&&k.series&&k.series.pointStart,C.pointStart,p.xData[0])},!X&&{data:p.options.data},d),X&&d.data&&(d.data=p.options.data),j=$.concat(j),j.forEach(function(oe){j[oe]=p[oe],delete p[oe]});var K=!1;if(seriesTypes$7[q]){if(K=q!==p.type,p.remove(!1,!1,!1,!0),K)if(Object.setPrototypeOf)Object.setPrototypeOf(p,seriesTypes$7[q].prototype);else{var ee=Object.hasOwnProperty.call(p,"hcEvents")&&p.hcEvents;for(W in z)p[W]=void 0;extend$1k(p,seriesTypes$7[q].prototype),ee?p.hcEvents=ee:delete p.hcEvents}}else error$6(17,!0,v,{missingModuleFor:q});if(j.forEach(function(oe){p[oe]=j[oe]}),p.init(v,d),X&&this.points){if(N=p.options,N.visible===!1)F.graphic=1,F.dataLabel=1;else if(!p._hasPointLabels){var te=N.marker,ie=N.dataLabels;te&&(te.enabled===!1||(C.marker&&C.marker.symbol)!==te.symbol)&&(F.graphic=1),ie&&ie.enabled===!1&&(F.dataLabel=1)}this.points.forEach(function(oe){oe&&oe.series&&(oe.resolveColor(),Object.keys(F).length&&oe.destroyElements(F),N.showInLegend===!1&&oe.legendItem&&v.legend.destroyItem(oe))},this)}p.initialType=P,v.linkSeries(),K&&p.linkedSeries.length&&(p.isDirtyData=!0),fireEvent$s(this,"afterUpdate"),pick$1o(a,!0)&&v.redraw(X?void 0:!1)},g.prototype.setName=function(d){this.name=this.options.name=this.userOptions.name=d,this.chart.isDirtyLegend=!0},g.prototype.hasOptionChanged=function(d){var a=this.chart,p=this.options[d],v=a.options.plotOptions,C=this.userOptions[d];return C?p!==C:p!==pick$1o(v&&v[this.type]&&v[this.type][d],v&&v.series&&v.series[d],p)},g.prototype.onMouseOver=function(){var d=this,a=d.chart,p=a.hoverSeries,v=a.pointer;v.setHoverChartIndex(),p&&p!==d&&p.onMouseOut(),d.options.events.mouseOver&&fireEvent$s(d,"mouseOver"),d.setState("hover"),a.hoverSeries=d},g.prototype.onMouseOut=function(){var d=this,a=d.options,p=d.chart,v=p.tooltip,C=p.hoverPoint;p.hoverSeries=null,C&&C.onMouseOut(),d&&a.events.mouseOut&&fireEvent$s(d,"mouseOut"),v&&!d.stickyTracking&&(!v.shared||d.noSharedTooltip)&&v.hide(),p.series.forEach(function(P){P.setState("",!0)})},g.prototype.setState=function(d,a){var p=this,v=p.options,C=p.graph,P=v.inactiveOtherPoints,k=v.states,z=pick$1o(k[d||"normal"]&&k[d||"normal"].animation,p.chart.options.chart.animation),$,D=v.lineWidth,F=0,N=v.opacity;if(d=d||"",p.state!==d&&([p.group,p.markerGroup,p.dataLabelsGroup].forEach(function(W){W&&(p.state&&W.removeClass("highcharts-series-"+p.state),d&&W.addClass("highcharts-series-"+d))}),p.state=d,!p.chart.styledMode)){if(k[d]&&k[d].enabled===!1)return;if(d&&(D=k[d].lineWidth||D+(k[d].lineWidthPlus||0),N=pick$1o(k[d].opacity,N)),C&&!C.dashstyle)for($={"stroke-width":D},C.animate($,z);p["zone-graph-"+F];)p["zone-graph-"+F].animate($,z),F=F+1;P||[p.group,p.markerGroup,p.dataLabelsGroup,p.labelBySeries].forEach(function(W){W&&W.animate({opacity:N},z)})}a&&P&&p.points&&p.setAllPointsToState(d||void 0)},g.prototype.setAllPointsToState=function(d){this.points.forEach(function(a){a.setState&&a.setState(d)})},g.prototype.setVisible=function(d,a){var p=this,v=p.chart,C=p.legendItem,P=v.options.chart.ignoreHiddenSeries,k=p.visible;p.visible=d=p.options.visible=p.userOptions.visible=typeof d>"u"?!k:d;var z=d?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function($){p[$]&&p[$][z]()}),(v.hoverSeries===p||(v.hoverPoint&&v.hoverPoint.series)===p)&&p.onMouseOut(),C&&v.legend.colorizeItem(p,d),p.isDirty=!0,p.options.stacking&&v.series.forEach(function($){$.options.stacking&&$.visible&&($.isDirty=!0)}),p.linkedSeries.forEach(function($){$.setVisible(d,!1)}),P&&(v.isDirtyBox=!0),fireEvent$s(p,z),a!==!1&&v.redraw()},g.prototype.show=function(){this.setVisible(!0)},g.prototype.hide=function(){this.setVisible(!1)},g.prototype.select=function(d){var a=this;a.selected=d=this.options.selected=typeof d>"u"?!a.selected:d,a.checkbox&&(a.checkbox.checked=d),fireEvent$s(a,d?"select":"unselect")},g.prototype.shouldShowTooltip=function(d,a,p){return p===void 0&&(p={}),p.series=this,p.visiblePlotOnly=!0,this.chart.isInsidePlot(d,a,p)},g.defaultOptions=seriesDefaults,g})();extend$1k(Series$f.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$4,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$f;var stop=animationExports.stop,addEvent$Y=Utilities.addEvent,createElement$4=Utilities.createElement,merge$1f=Utilities.merge,pick$1n=Utilities.pick;addEvent$Y(Chart$1,"afterSetChartSize",function(g){var d=this.options.chart.scrollablePlotArea,a=d&&d.minWidth,p=d&&d.minHeight,v,C,P;this.renderer.forExport||(a?(this.scrollablePixelsX=v=Math.max(0,a-this.chartWidth),v&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.width=this.plotWidth+=v,this.inverted?this.clipBox.height+=v:this.clipBox.width+=v,P={1:{name:"right",value:v}})):p&&(this.scrollablePixelsY=C=Math.max(0,p-this.chartHeight),C&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.height=this.plotHeight+=C,this.inverted?this.clipBox.width+=C:this.clipBox.height+=C,P={2:{name:"bottom",value:C}})),P&&!g.skipAxes&&this.axes.forEach(function(k){P[k.side]?k.getPlotLinePath=function(){var z=P[k.side].name,$=P[k.side].value,D=this[z],F;return this[z]=D-$,F=Axis.prototype.getPlotLinePath.apply(this,arguments),this[z]=D,F}:(k.setAxisSize(),k.setAxisTranslation())}))});addEvent$Y(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var g=this,d={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(d.overflowX="auto"),this.scrollablePixelsY&&(d.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},d,this.scrollingParent),addEvent$Y(this.scrollingContainer,"scroll",function(){g.pointer&&delete g.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var g=this.container,d=this.fixedRenderer,a=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],p;this.scrollablePixelsX&&!this.inverted?p=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?p=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(p=".highcharts-yaxis"),p&&a.push(p+":not(.highcharts-radial-axis)",p+"-labels:not(.highcharts-radial-axis-labels)"),a.forEach(function(v){[].forEach.call(g.querySelectorAll(v),function(C){(C.namespaceURI===d.SVG_NS?d.box:d.box.parentNode).appendChild(C),C.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var g=!this.fixedDiv,d=this.options.chart,a=d.scrollablePlotArea,p=RendererRegistry$1.getRendererType(),v,C,P;g?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(d.style&&d.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=v=new p(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=v.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1n(a.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$Y(this,"afterShowResetZoom",this.moveFixedElements),addEvent$Y(this,"afterDrilldown",this.moveFixedElements),addEvent$Y(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||g)&&(this.scrollableDirty=!1,this.moveFixedElements()),C=this.chartWidth+(this.scrollablePixelsX||0),P=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=C+"px",this.container.style.height=P+"px",this.renderer.boxWrapper.attr({width:C,height:P,viewBox:[0,0,C,P].join(" ")}),this.chartBackground.attr({width:C,height:P}),this.scrollingContainer.style.height=this.chartHeight+"px",g&&(a.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*a.scrollPositionX),a.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*a.scrollPositionY));var k=this.axisOffset,z=this.plotTop-k[0]-1,$=this.plotLeft-k[3]-1,D=this.plotTop+this.plotHeight+k[2]+1,F=this.plotLeft+this.plotWidth+k[1]+1,N=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),W=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),j;this.scrollablePixelsX?j=[["M",0,z],["L",this.plotLeft-1,z],["L",this.plotLeft-1,D],["L",0,D],["Z"],["M",N,z],["L",this.chartWidth,z],["L",this.chartWidth,D],["L",N,D],["Z"]]:this.scrollablePixelsY?j=[["M",$,0],["L",$,this.plotTop-1],["L",F,this.plotTop-1],["L",F,0],["Z"],["M",$,W],["L",$,this.chartHeight],["L",F,this.chartHeight],["L",F,W],["Z"]]:j=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:j})};addEvent$Y(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$Y(Series$f,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$X=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$r=Utilities.fireEvent,isNumber$F=Utilities.isNumber,objectEach$n=Utilities.objectEach,StackingAxis;(function(g){var d=[];function a(P){return d.indexOf(P)===-1&&(d.push(P),addEvent$X(P,"init",v),addEvent$X(P,"destroy",p)),P}g.compose=a;function p(){var P=this.stacking;if(P){var k=P.stacks;objectEach$n(k,function(z,$){destroyObjectProperties$5(z),k[$]=null}),P&&P.stackTotalGroup&&P.stackTotalGroup.destroy()}}function v(){var P=this;P.stacking||(P.stacking=new C(P))}var C=(function(){function P(k){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=k}return P.prototype.buildStacks=function(){var k=this,z=k.axis,$=z.series,D=z.options.reversedStacks,F=$.length,N,W;if(!z.isXAxis){for(k.usePercentage=!1,W=F;W--;)N=$[D?W:F-W-1],N.setStackedPoints(),N.setGroupedPoints();for(W=0;W<F;W++)$[W].modifyStacks();fireEvent$r(z,"afterBuildStacks")}},P.prototype.cleanStacks=function(){var k=this,z=k.axis,$;z.isXAxis||(k.oldStacks&&($=k.stacks=k.oldStacks),objectEach$n($,function(D){objectEach$n(D,function(F){F.cumulative=F.total})}))},P.prototype.resetStacks=function(){var k=this,z=k.axis,$=k.stacks;z.isXAxis||objectEach$n($,function(D){objectEach$n(D,function(F,N){isNumber$F(F.touched)&&F.touched<k.stacksTouched?(F.destroy(),delete D[N]):(F.total=null,F.cumulative=null)})})},P.prototype.renderStackTotals=function(){var k=this,z=k.axis,$=z.chart,D=$.renderer,F=k.stacks,N=z.options.stackLabels&&z.options.stackLabels.animation,W=getDeferredAnimation$2($,N||!1),j=k.stackTotalGroup=k.stackTotalGroup||D.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();j.translate($.plotLeft,$.plotTop),objectEach$n(F,function(q){objectEach$n(q,function(X){X.render(j)})}),j.animate({opacity:1},W)},P})();g.Additions=C})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$a=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$J=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$h=Utilities.isArray,isNumber$E=Utilities.isNumber,objectEach$m=Utilities.objectEach,pick$1m=Utilities.pick,StackItem=(function(){function g(d,a,p,v,C){var P=d.chart.inverted;this.axis=d,this.isNegative=p,this.options=a=a||{},this.x=v,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=C,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:a.align||(P?p?"left":"right":"center"),verticalAlign:a.verticalAlign||(P?"middle":p?"bottom":"top"),y:a.y,x:a.x},this.textAlign=a.textAlign||(P?p?"right":"left":"center")}return g.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},g.prototype.render=function(d){var a=this.axis.chart,p=this.options,v=p.format,C={},P=v?format$a(v,this,a):p.formatter.call(this);this.label?this.label.attr({text:P,visibility:"hidden"}):(this.label=a.renderer.label(P,null,null,p.shape,null,null,p.useHTML,!1,"stack-labels"),C={r:p.borderRadius||0,text:P,rotation:p.rotation,padding:pick$1m(p.padding,5),visibility:"hidden"},a.styledMode||(C.fill=p.backgroundColor,C.stroke=p.borderColor,C["stroke-width"]=p.borderWidth,this.label.css(p.style)),this.label.attr(C),this.label.added||this.label.add(d)),this.label.labelrank=a.plotSizeY},g.prototype.setOffset=function(d,a,p,v,C){var P=this,k=P.axis,z=k.chart,$=k.translate(k.stacking.usePercentage?100:v||P.total,0,0,0,1),D=k.translate(p||0),F=defined$J($)&&Math.abs($-D),N=pick$1m(C,z.xAxis[0].translate(P.x))+d,W=defined$J($)&&P.getStackBox(z,P,N,$,a,F,k),j=P.label,q=P.isNegative,X=pick$1m(P.options.overflow,"justify")==="justify",K=P.textAlign,ee;if(j&&W){var te=j.getBBox(),ie=j.padding,oe=void 0,ae=void 0;K==="left"?oe=z.inverted?-ie:ie:K==="right"?oe=te.width:z.inverted&&K==="center"?oe=te.width/2:oe=z.inverted?q?te.width+ie:-ie:te.width/2,ae=z.inverted?te.height/2:q?-ie:te.height,P.alignOptions.x=pick$1m(P.options.x,0),P.alignOptions.y=pick$1m(P.options.y,0),W.x-=oe,W.y-=ae,j.align(P.alignOptions,null,W),z.isInsidePlot(j.alignAttr.x+oe-P.alignOptions.x,j.alignAttr.y+ae-P.alignOptions.y)?j.show():(j.alignAttr.y=-9999,X=!1),X&&Series$f.prototype.justifyDataLabel.call(this.axis,j,P.alignOptions,j.alignAttr,te,W),j.attr({x:j.alignAttr.x,y:j.alignAttr.y}),pick$1m(!X&&P.options.crop,!0)&&(ee=isNumber$E(j.x)&&isNumber$E(j.y)&&z.isInsidePlot(j.x-ie+j.width,j.y)&&z.isInsidePlot(j.x+ie,j.y),ee||j.hide())}},g.prototype.getStackBox=function(d,a,p,v,C,P,k){var z=a.axis.reversed,$=d.inverted,D=k.height+k.pos-($?d.plotLeft:d.plotTop),F=a.isNegative&&!z||!a.isNegative&&z;return{x:$?F?v-k.right:v-P+k.pos-d.plotLeft:p+d.xAxis[0].transB-d.plotLeft,y:$?k.height-p-C:F?D-v-P:D-v,width:$?P:C,height:$?C:P}},g})();Chart$1.prototype.getStacks=function(){var g=this,d=g.inverted;g.yAxis.forEach(function(a){a.stacking&&a.stacking.stacks&&a.hasVisibleSeries&&(a.stacking.oldStacks=a.stacking.stacks)}),g.series.forEach(function(a){var p=a.xAxis&&a.xAxis.options||{};a.options.stacking&&(a.visible===!0||g.options.chart.ignoreHiddenSeries===!1)&&(a.stackKey=[a.type,pick$1m(a.options.stack,""),d?p.top:p.left,d?p.height:p.width].join(","))})};StackingAxis$1.compose(Axis);Series$f.prototype.setGroupedPoints=function(){var g=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$f.prototype.setStackedPoints.call(this,"group"):g&&objectEach$m(g.stacks,function(d,a){a.slice(-5)==="group"&&(objectEach$m(d,function(p){return p.destroy()}),delete g.stacks[a])})};Series$f.prototype.setStackedPoints=function(g){var d=g||this.options.stacking;if(!(!d||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var a=this,p=a.processedXData,v=a.processedYData,C=[],P=v.length,k=a.options,z=k.threshold,$=pick$1m(k.startFromThreshold&&z,0),D=k.stack,F=g?a.type+","+d:a.stackKey,N="-"+F,W=a.negStacks,j=a.yAxis,q=j.stacking.stacks,X=j.stacking.oldStacks,K,ee,te,ie,oe,ae,le,ce,ue;for(j.stacking.stacksTouched+=1,le=0;le<P;le++)ce=p[le],ue=v[le],K=a.getStackIndicator(K,ce,a.index),ae=K.key,ee=W&&ue<($?0:z),oe=ee?N:F,q[oe]||(q[oe]={}),q[oe][ce]||(X[oe]&&X[oe][ce]?(q[oe][ce]=X[oe][ce],q[oe][ce].total=null):q[oe][ce]=new StackItem(j,j.options.stackLabels,ee,ce,D)),te=q[oe][ce],ue!==null?(te.points[ae]=te.points[a.index]=[pick$1m(te.cumulative,$)],defined$J(te.cumulative)||(te.base=ae),te.touched=j.stacking.stacksTouched,K.index>0&&a.singleStacks===!1&&(te.points[ae][0]=te.points[a.index+","+ce+",0"][0])):te.points[ae]=te.points[a.index]=null,d==="percent"?(ie=ee?F:N,W&&q[ie]&&q[ie][ce]?(ie=q[ie][ce],te.total=ie.total=Math.max(ie.total,te.total)+Math.abs(ue)||0):te.total=correctFloat$9(te.total+(Math.abs(ue)||0))):d==="group"?(isArray$h(ue)&&(ue=ue[0]),ue!==null&&(te.total=(te.total||0)+1)):te.total=correctFloat$9(te.total+(ue||0)),d==="group"?te.cumulative=(te.total||1)-1:te.cumulative=pick$1m(te.cumulative,$)+(ue||0),ue!==null&&(te.points[ae].push(te.cumulative),C[le]=te.cumulative,te.hasValidPoints=!0);d==="percent"&&(j.stacking.usePercentage=!0),d!=="group"&&(this.stackedYData=C),j.stacking.oldStacks={}}};Series$f.prototype.modifyStacks=function(){var g=this,d=g.yAxis,a=g.stackKey,p=d.stacking.stacks,v=g.processedXData,C,P=g.options.stacking;g[P+"Stacker"]&&[a,"-"+a].forEach(function(k){for(var z=v.length,$,D,F;z--;)$=v[z],C=g.getStackIndicator(C,$,g.index,k),D=p[k]&&p[k][$],F=D&&D.points[C.key],F&&g[P+"Stacker"](F,D,z)})};Series$f.prototype.percentStacker=function(g,d,a){var p=d.total?100/d.total:0;g[0]=correctFloat$9(g[0]*p),g[1]=correctFloat$9(g[1]*p),this.stackedYData[a]=g[1]};Series$f.prototype.getStackIndicator=function(g,d,a,p){return!defined$J(g)||g.x!==d||p&&g.key!==p?g={x:d,index:0,key:p}:g.index++,g.key=[a,d,g.index].join(","),g};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$2d=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defined$I=Utilities.defined,merge$1e=Utilities.merge,LineSeries$5=(function(g){__extends$2d(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){var a=this,p=this.options,v=(this.gappedPath||this.getGraphPath).call(this),C=this.chart.styledMode,P=[["graph","highcharts-graph"]];C||P[0].push(p.lineColor||this.color||palette.neutralColor20,p.dashStyle),P=a.getZonesGraphs(P),P.forEach(function(k,z){var $=k[0],D,F=a[$],N=F?"animate":"attr";F?(F.endX=a.preventGraphAnimation?null:v.xMap,F.animate({d:v})):v.length&&(a[$]=F=a.chart.renderer.path(v).addClass(k[1]).attr({zIndex:1}).add(a.group)),F&&!C&&(D={stroke:k[2],"stroke-width":p.lineWidth,fill:a.fillGraph&&a.color||"none"},k[3]?D.dashstyle=k[3]:p.linecap!=="square"&&(D["stroke-linecap"]=D["stroke-linejoin"]="round"),F[N](D).shadow(z<2&&p.shadow)),F&&(F.startX=v.xMap,F.isArea=v.isArea)})},d.prototype.getGraphPath=function(a,p,v){var C=this,P=C.options,k=[],z=[],$,D=P.step;a=a||C.points;var F=a.reversed;return F&&a.reverse(),D={right:1,center:2}[D]||D&&3,D&&F&&(D=4-D),a=this.getValidPoints(a,!1,!(P.connectNulls&&!p&&!v)),a.forEach(function(N,W){var j=N.plotX,q=N.plotY,X=a[W-1],K;(N.leftCliff||X&&X.rightCliff)&&!v&&($=!0),N.isNull&&!defined$I(p)&&W>0?$=!P.connectNulls:N.isNull&&!p?$=!0:(W===0||$?K=[["M",N.plotX,N.plotY]]:C.getPointSpline?K=[C.getPointSpline(a,N,W)]:D?(D===1?K=[["L",X.plotX,q]]:D===2?K=[["L",(X.plotX+j)/2,X.plotY],["L",(X.plotX+j)/2,q]]:K=[["L",j,X.plotY]],K.push(["L",j,q])):K=[["L",j,q]],z.push(N.x),D&&(z.push(N.x),D===2&&z.push(N.x)),k.push.apply(k,K),$=!1)}),k.xMap=z,C.graphPath=k,k},d.prototype.getZonesGraphs=function(a){return this.zones.forEach(function(p,v){var C=["zone-graph-"+v,"highcharts-graph highcharts-zone-graph-"+v+" "+(p.className||"")];this.chart.styledMode||C.push(p.color||this.color,p.dashStyle||this.options.dashStyle),a.push(C)},this),a},d.defaultOptions=merge$1e(Series$f.defaultOptions,{}),d})(Series$f);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$2c=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1j=Utilities.extend,merge$1d=Utilities.merge,objectEach$l=Utilities.objectEach,pick$1l=Utilities.pick,AreaSeries$1=(function(g){__extends$2c(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.drawGraph=function(){this.areaPath=[],g.prototype.drawGraph.apply(this);var a=this,p=this.areaPath,v=this.options,C=this.zones,P=[["area","highcharts-area",this.color,v.fillColor]];C.forEach(function(k,z){P.push(["zone-area-"+z,"highcharts-area highcharts-zone-area-"+z+" "+k.className,k.color||a.color,k.fillColor||v.fillColor])}),P.forEach(function(k){var z=k[0],$=a[z],D=$?"animate":"attr",F={};$?($.endX=a.preventGraphAnimation?null:p.xMap,$.animate({d:p})):(F.zIndex=0,$=a[z]=a.chart.renderer.path(p).addClass(k[1]).add(a.group),$.isArea=!0),a.chart.styledMode||(F.fill=pick$1l(k[3],color$d(k[2]).setOpacity(pick$1l(v.fillOpacity,.75)).get())),$[D](F),$.startX=p.xMap,$.shiftUnit=v.step?2:1})},d.prototype.getGraphPath=function(a){var p=LineSeries$4.prototype.getGraphPath,v,C=this.options,P=C.stacking,k=this.yAxis,z,$,D=[],F=[],N=this.index,W,j,q,X=k.stacking.stacks[this.stackKey],K=C.threshold,ee=Math.round(k.getThreshold(C.threshold)),te,ie,oe=pick$1l(C.connectNulls,P==="percent"),ae=function(ce,ue,ge){var ye=a[ce],we=P&&X[ye.x].points[N],ve=ye[ge+"Null"]||0,be=ye[ge+"Cliff"]||0,_e,Ce,Ee=!0;be||ve?(_e=(ve?we[0]:we[1])+be,Ce=we[0]+be,Ee=!!ve):!P&&a[ue]&&a[ue].isNull&&(_e=Ce=K),typeof _e<"u"&&(F.push({plotX:q,plotY:_e===null?ee:k.getThreshold(_e),isNull:Ee,isCliff:!0}),D.push({plotX:q,plotY:Ce===null?ee:k.getThreshold(Ce),doCurve:!1}))};for(a=a||this.points,P&&(a=this.getStackPoints(a)),W=0;W<a.length;W++)P||(a[W].leftCliff=a[W].rightCliff=a[W].leftNull=a[W].rightNull=void 0),te=a[W].isNull,q=pick$1l(a[W].rectPlotX,a[W].plotX),ie=P?pick$1l(a[W].yBottom,ee):ee,(!te||oe)&&(oe||ae(W,W-1,"left"),te&&!P&&oe||(F.push(a[W]),D.push({x:W,plotX:q,plotY:ie})),oe||ae(W,W+1,"right"));z=p.call(this,F,!0,!0),D.reversed=!0,$=p.call(this,D,!0,!0);var le=$[0];return le&&le[0]==="M"&&($[0]=["L",le[1],le[2]]),j=z.concat($),j.length&&j.push(["Z"]),v=p.call(this,F,!1,oe),j.xMap=z.xMap,this.areaPath=j,v},d.prototype.getStackPoints=function(a){var p=this,v=[],C=[],P=this.xAxis,k=this.yAxis,z=k.stacking.stacks[this.stackKey],$={},D=k.series,F=D.length,N=k.options.reversedStacks?1:-1,W=D.indexOf(p);if(a=a||this.points,this.options.stacking){for(var j=0;j<a.length;j++)a[j].leftNull=a[j].rightNull=void 0,$[a[j].x]=a[j];objectEach$l(z,function(X,K){X.total!==null&&C.push(K)}),C.sort(function(X,K){return X-K});var q=D.map(function(X){return X.visible});C.forEach(function(X,K){var ee=0,te,ie;if($[X]&&!$[X].isNull)v.push($[X]),[-1,1].forEach(function(le){var ce=le===1?"rightNull":"leftNull",ue=le===1?"rightCliff":"leftCliff",ge=0,ye=z[C[K+le]];if(ye)for(var we=W;we>=0&&we<F;){var ve=D[we].index;te=ye.points[ve],te||(ve===p.index?$[X][ce]=!0:q[we]&&(ie=z[X].points[ve],ie&&(ge-=ie[1]-ie[0]))),we+=N}$[X][ue]=ge});else{for(var oe=W;oe>=0&&oe<F;){var ae=D[oe].index;if(te=z[X].points[ae],te){ee=te[1];break}oe+=N}ee=pick$1l(ee,0),ee=k.translate(ee,0,1,0,1),v.push({isNull:!0,plotX:P.translate(X,0,0,0,1),x:X,plotY:ee,yBottom:ee})}})}return v},d.defaultOptions=merge$1d(LineSeries$4.defaultOptions,{threshold:0}),d})(LineSeries$4);extend$1j(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$2b=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$1c=Utilities.merge,pick$1k=Utilities.pick,SplineSeries$1=(function(g){__extends$2b(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getPointSpline=function(a,p,v){var C=1.5,P=C+1,k=p.plotX||0,z=p.plotY||0,$=a[v-1],D=a[v+1],F,N,W,j,q;function X(ae){return ae&&!ae.isNull&&ae.doCurve!==!1&&!p.isCliff}if(X($)&&X(D)){var K=$.plotX||0,ee=$.plotY||0,te=D.plotX||0,ie=D.plotY||0,oe=0;F=(C*k+K)/P,N=(C*z+ee)/P,W=(C*k+te)/P,j=(C*z+ie)/P,W!==F&&(oe=(j-N)*(W-k)/(W-F)+z-j),N+=oe,j+=oe,N>ee&&N>z?(N=Math.max(ee,z),j=2*z-N):N<ee&&N<z&&(N=Math.min(ee,z),j=2*z-N),j>ie&&j>z?(j=Math.max(ie,z),N=2*z-j):j<ie&&j<z&&(j=Math.min(ie,z),N=2*z-j),p.rightContX=W,p.rightContY=j}return q=["C",pick$1k($.rightContX,$.plotX,0),pick$1k($.rightContY,$.plotY,0),pick$1k(F,k,0),pick$1k(N,z,0),k,z],$.rightContX=$.rightContY=void 0,q},d.defaultOptions=merge$1c(LineSeries$3.defaultOptions),d})(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$2a=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),areaProto$1=AreaSeries$1.prototype,extend$1i=Utilities.extend,merge$1b=Utilities.merge,AreaSplineSeries=(function(g){__extends$2a(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return d.defaultOptions=merge$1b(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),d})(SplineSeries$1);extend$1i(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$29=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),animObject$6=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$g=H.noop,clamp$f=Utilities.clamp,css$4=Utilities.css,defined$H=Utilities.defined,extend$1h=Utilities.extend,fireEvent$q=Utilities.fireEvent,isArray$g=Utilities.isArray,isNumber$D=Utilities.isNumber,merge$1a=Utilities.merge,pick$1j=Utilities.pick,objectEach$k=Utilities.objectEach,ColumnSeries$h=(function(g){__extends$29(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.borderWidth=void 0,a.data=void 0,a.group=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var p=this,v=this.yAxis,C=p.options,P=this.chart.inverted,k={},z=P?"translateX":"translateY",$,D;a?(k.scaleY=.001,D=clamp$f(v.toPixels(C.threshold),v.pos,v.pos+v.len),P?k.translateX=D-v.len:k.translateY=D,p.clipBox&&p.setClip(),p.group.attr(k)):($=Number(p.group.attr(z)),p.group.animate({scaleY:1},extend$1h(animObject$6(p.options.animation),{step:function(F,N){p.group&&(k[z]=$+N.pos*(v.pos-$),p.group.attr(k))}})))},d.prototype.init=function(a,p){g.prototype.init.apply(this,arguments);var v=this;a=v.chart,a.hasRendered&&a.series.forEach(function(C){C.type===v.type&&(C.isDirty=!0)})},d.prototype.getColumnMetrics=function(){var a=this,p=a.options,v=a.xAxis,C=a.yAxis,P=v.options.reversedStacks,k=v.reversed&&!P||!v.reversed&&P,z={},$,D=0;p.grouping===!1?D=1:a.chart.series.forEach(function(te){var ie=te.yAxis,oe=te.options,ae;te.type===a.type&&(te.visible||!a.chart.options.chart.ignoreHiddenSeries)&&C.len===ie.len&&C.pos===ie.pos&&(oe.stacking&&oe.stacking!=="group"?($=te.stackKey,typeof z[$]>"u"&&(z[$]=D++),ae=z[$]):oe.grouping!==!1&&(ae=D++),te.columnIndex=ae)});var F=Math.min(Math.abs(v.transA)*(v.ordinal&&v.ordinal.slope||p.pointRange||v.closestPointRange||v.tickInterval||1),v.len),N=F*p.groupPadding,W=F-2*N,j=W/(D||1),q=Math.min(p.maxPointWidth||v.len,pick$1j(p.pointWidth,j*(1-2*p.pointPadding))),X=(j-q)/2,K=(a.columnIndex||0)+(k?1:0),ee=X+(N+K*j-F/2)*(k?-1:1);return a.columnMetrics={width:q,offset:ee,paddedWidth:j,columnCount:D},a.columnMetrics},d.prototype.crispCol=function(a,p,v,C){var P=this.chart,k=this.borderWidth,z=-(k%2?.5:0),$,D=k%2?.5:1;P.inverted&&P.renderer.isVML&&(D+=1),this.options.crisp&&($=Math.round(a+v)+z,a=Math.round(a)+z,v=$-a);var F=Math.round(p+C)+D,N=Math.abs(p)<=.5&&F>.5;return p=Math.round(p)+D,C=F-p,N&&C&&(p-=1,C+=1),{x:a,y:p,width:v,height:C}},d.prototype.adjustForMissingColumns=function(a,p,v,C){var P=this,k=this.options.stacking;if(!v.isNull&&C.columnCount>1){var z=0,$=0;objectEach$k(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(F){if(typeof v.x=="number"){var N=F[v.x.toString()];if(N){var W=N.points[P.index],j=N.total;k?(W&&(z=$),N.hasValidPoints&&$++):isArray$g(W)&&(z=W[1],$=j||0)}}});var D=($-1)*C.paddedWidth+p;a=(v.plotX||0)+D/2-p-z*C.paddedWidth}return a},d.prototype.translate=function(){var a=this,p=a.chart,v=a.options,C=a.dense=a.closestPointRange*a.xAxis.transA<2,P=a.borderWidth=pick$1j(v.borderWidth,C?0:1),k=a.xAxis,z=a.yAxis,$=v.threshold,D=a.translatedThreshold=z.getThreshold($),F=pick$1j(v.minPointLength,5),N=a.getColumnMetrics(),W=N.width,j=a.pointXOffset=N.offset,q=a.dataMin,X=a.dataMax,K=a.barW=Math.max(W,1+2*P);p.inverted&&(D-=.5),v.pointPadding&&(K=Math.ceil(K)),Series$f.prototype.translate.apply(a),a.points.forEach(function(ee){var te=pick$1j(ee.yBottom,D),ie=999+Math.abs(te),oe=ee.plotX||0,ae=clamp$f(ee.plotY,-ie,z.len+ie),le,ce=Math.min(ae,te),ue=Math.max(ae,te)-ce,ge=W,ye=oe+j,we=K;F&&Math.abs(ue)<F&&(ue=F,le=!z.reversed&&!ee.negative||z.reversed&&ee.negative,isNumber$D($)&&isNumber$D(X)&&ee.y===$&&X<=$&&(z.min||0)<$&&(q!==X||(z.max||0)<=$)&&(le=!le),ce=Math.abs(ce-D)>F?te-F:D-(le?F:0)),defined$H(ee.options.pointWidth)&&(ge=we=Math.ceil(ee.options.pointWidth),ye-=Math.round((ge-W)/2)),v.centerInCategory&&(ye=a.adjustForMissingColumns(ye,ge,ee,N)),ee.barX=ye,ee.pointWidth=ge,ee.tooltipPos=p.inverted?[clamp$f(z.len+z.pos-p.plotLeft-ae,z.pos-p.plotLeft,z.len+z.pos-p.plotLeft),k.len+k.pos-p.plotTop-ye-we/2,ue]:[k.left-p.plotLeft+ye+we/2,clamp$f(ae+z.pos-p.plotTop,z.pos-p.plotTop,z.len+z.pos-p.plotTop),ue],ee.shapeType=a.pointClass.prototype.shapeType||"rect",ee.shapeArgs=a.crispCol.apply(a,ee.isNull?[ye,D,we,0]:[ye,ce,we,ue])})},d.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},d.prototype.pointAttribs=function(a,p){var v=this.options,C=this.pointAttrToOptions||{},P=C.stroke||"borderColor",k=C["stroke-width"]||"borderWidth",z,$,D,F=a&&a.color||this.color,N=a&&a[P]||v[P]||F,W=a&&a.options.dashStyle||v.dashStyle,j=a&&a[k]||v[k]||this[k]||0,q=pick$1j(a&&a.opacity,v.opacity,1);a&&this.zones.length&&($=a.getZone(),F=a.options.color||$&&($.color||a.nonZonedColor)||this.color,$&&(N=$.borderColor||N,W=$.dashStyle||W,j=$.borderWidth||j)),p&&a&&(z=merge$1a(v.states[p],a.options.states&&a.options.states[p]||{}),D=z.brightness,F=z.color||typeof D<"u"&&color$c(F).brighten(z.brightness).get()||F,N=z[P]||N,j=z[k]||j,W=z.dashStyle||W,q=pick$1j(z.opacity,q));var X={fill:F,stroke:N,"stroke-width":j,opacity:q};return W&&(X.dashstyle=W),X},d.prototype.drawPoints=function(){var a=this,p=this.chart,v=a.options,C=p.renderer,P=v.animationLimit||250,k;a.points.forEach(function(z){var $=z.plotY,D=z.graphic,F=!!D,N=D&&p.pointCount<P?"animate":"attr";isNumber$D($)&&z.y!==null?(k=z.shapeArgs,D&&z.hasNewShapeType()&&(D=D.destroy()),a.enabledDataSorting&&(z.startXPos=a.xAxis.reversed?-(k&&k.width||0):a.xAxis.width),D||(z.graphic=D=C[z.shapeType](k).add(z.group||a.group),D&&a.enabledDataSorting&&p.hasRendered&&p.pointCount<P&&(D.attr({x:z.startXPos}),F=!0,N="animate")),D&&F&&D[N](merge$1a(k)),v.borderRadius&&D[N]({r:v.borderRadius}),p.styledMode||D[N](a.pointAttribs(z,z.selected&&"select")).shadow(z.allowShadow!==!1&&v.shadow,null,v.stacking&&!v.borderRadius),D&&(D.addClass(z.getClassName(),!0),D.attr({visibility:z.visible?"inherit":"hidden"}))):D&&(z.graphic=D.destroy())})},d.prototype.drawTracker=function(){var a=this,p=a.chart,v=p.pointer,C=function(k){var z=v.getPointFromEvent(k);typeof z<"u"&&(v.isDirectTouch=!0,z.onMouseOver(k))},P;a.points.forEach(function(k){P=isArray$g(k.dataLabels)?k.dataLabels:k.dataLabel?[k.dataLabel]:[],k.graphic&&(k.graphic.element.point=k),P.forEach(function(z){z.div?z.div.point=k:z.element.point=k})}),a._hasTracking||(a.trackerGroups.forEach(function(k){a[k]&&(a[k].addClass("highcharts-tracker").on("mouseover",C).on("mouseout",function(z){v.onTrackerMouseOut(z)}),hasTouch$1&&a[k].on("touchstart",C),!p.styledMode&&a.options.cursor&&a[k].css(css$4).css({cursor:a.options.cursor}))}),a._hasTracking=!0),fireEvent$q(this,"afterDrawTracker")},d.prototype.remove=function(){var a=this,p=a.chart;p.hasRendered&&p.series.forEach(function(v){v.type===a.type&&(v.isDirty=!0)}),Series$f.prototype.remove.apply(a,arguments)},d.defaultOptions=merge$1a(Series$f.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),d})(Series$f);extend$1h(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$g,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$9=FormatUtilities.format,defined$G=Utilities.defined,extend$1g=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$f=Utilities.isArray,merge$19=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1i=Utilities.pick,splat$d=Utilities.splat,DataLabel;(function(g){var d=[];function a($,D,F,N,W){var j=this,q=this.chart,X=this.isCartesian&&q.inverted,K=this.enabledDataSorting,ee=pick$1i($.dlBox&&$.dlBox.centerX,$.plotX,-9999),te=pick$1i($.plotY,-9999),ie=D.getBBox(),oe=F.rotation,ae=F.align,le=q.isInsidePlot(ee,Math.round(te),{inverted:X,paneCoordinates:!0,series:j}),ce=function(Ce){K&&j.xAxis&&!be&&j.setDataLabelStartPos($,D,W,le,Ce)},ue,ge,ye,we,ve,be=pick$1i(F.overflow,K?"none":"justify")==="justify",_e=this.visible&&$.visible!==!1&&($.series.forceDL||K&&!be||le||pick$1i(F.inside,!!this.options.stacking)&&N&&q.isInsidePlot(ee,X?N.x+1:N.y+N.height-1,{inverted:X,paneCoordinates:!0,series:j}));_e&&(ue=q.renderer.fontMetrics(q.styledMode?void 0:F.style.fontSize,D).b,N=extend$1g({x:X?this.yAxis.len-te:ee,y:Math.round(X?this.xAxis.len-ee:te),width:0,height:0},N),extend$1g(F,{width:ie.width,height:ie.height}),oe?(be=!1,we=q.renderer.rotCorr(ue,oe),ve={x:N.x+(F.x||0)+N.width/2+we.x,y:N.y+(F.y||0)+{top:0,middle:.5,bottom:1}[F.verticalAlign]*N.height},ce(ve),D[W?"attr":"animate"](ve).attr({align:ae}),ge=(oe+720)%360,ye=ge>180&&ge<360,ae==="left"?ve.y-=ye?ie.height:0:ae==="center"?(ve.x-=ie.width/2,ve.y-=ie.height/2):ae==="right"&&(ve.x-=ie.width,ve.y-=ye?0:ie.height),D.placed=!0,D.alignAttr=ve):(ce(N),D.align(F,void 0,N),ve=D.alignAttr),be&&N.height>=0?this.justifyDataLabel(D,F,ve,ie,N,W):pick$1i(F.crop,!0)&&(_e=q.isInsidePlot(ve.x,ve.y,{paneCoordinates:!0,series:j})&&q.isInsidePlot(ve.x+ie.width,ve.y+ie.height,{paneCoordinates:!0,series:j})),F.shape&&!oe&&D[W?"attr":"animate"]({anchorX:X?q.plotWidth-$.plotY:$.plotX,anchorY:X?q.plotHeight-$.plotX:$.plotY})),W&&K&&(D.placed=!1),!_e&&(!K||be)&&(D.hide(!0),D.placed=!1)}function p($,D){var F=D.filter;if(F){var N=F.operator,W=$[F.property],j=F.value;return N===">"&&W>j||N==="<"&&W<j||N===">="&&W>=j||N==="<="&&W<=j||N==="=="&&W==j||N==="==="&&W===j}return!0}function v($){if(d.indexOf($)===-1){var D=$.prototype;d.push($),D.alignDataLabel=a,D.drawDataLabels=C,D.justifyDataLabel=P,D.setDataLabelStartPos=z}}g.compose=v;function C(){var $=this,D=$.chart,F=$.options,N=$.points,W=$.hasRendered||0,j=D.renderer,q=F.dataLabels,X,K,ee=q.animation,te=q.defer?getDeferredAnimation$1(D,ee,$):{defer:0,duration:0};if(q=k(k(D.options.plotOptions&&D.options.plotOptions.series&&D.options.plotOptions.series.dataLabels,D.options.plotOptions&&D.options.plotOptions[$.type]&&D.options.plotOptions[$.type].dataLabels),q),fireEvent$p(this,"drawDataLabels"),isArray$f(q)||q.enabled||$._hasPointLabels){if(K=$.plotGroup("dataLabelsGroup","data-labels",W?"inherit":"hidden",q.zIndex||6),K.attr({opacity:+W}),!W){var ie=$.dataLabelsGroup;ie&&($.visible&&K.show(!0),ie[F.animation?"animate":"attr"]({opacity:1},te))}N.forEach(function(oe){X=splat$d(k(q,oe.dlOptions||oe.options&&oe.options.dataLabels)),X.forEach(function(ae,le){var ce=ae.enabled&&(!oe.isNull||oe.dataLabelOnNull)&&p(oe,ae),ue=oe.connectors?oe.connectors[le]:oe.connector,ge,ye,we,ve,be,_e,Ce=oe.dataLabels?oe.dataLabels[le]:oe.dataLabel,Ee=pick$1i(ae.distance,oe.labelDistance),Te=!Ce;ce&&(ge=oe.getLabelConfig(),ye=pick$1i(ae[oe.formatPrefix+"Format"],ae.format),we=defined$G(ye)?format$9(ye,ge,D):(ae[oe.formatPrefix+"Formatter"]||ae.formatter).call(ge,ae),ve=ae.style,be=ae.rotation,D.styledMode||(ve.color=pick$1i(ae.color,ve.color,$.color,palette.neutralColor100),ve.color==="contrast"?(oe.contrastColor=j.getContrast(oe.color||$.color),ve.color=!defined$G(Ee)&&ae.inside||Ee<0||F.stacking?oe.contrastColor:palette.neutralColor100):delete oe.contrastColor,F.cursor&&(ve.cursor=F.cursor)),_e={r:ae.borderRadius||0,rotation:be,padding:ae.padding,zIndex:1},D.styledMode||(_e.fill=ae.backgroundColor,_e.stroke=ae.borderColor,_e["stroke-width"]=ae.borderWidth),objectEach$j(_e,function($e,Ge){typeof $e>"u"&&delete _e[Ge]})),Ce&&(!ce||!defined$G(we))?(oe.dataLabel=oe.dataLabel&&oe.dataLabel.destroy(),oe.dataLabels&&(oe.dataLabels.length===1?delete oe.dataLabels:delete oe.dataLabels[le]),le||delete oe.dataLabel,ue&&(oe.connector=oe.connector.destroy(),oe.connectors&&(oe.connectors.length===1?delete oe.connectors:delete oe.connectors[le]))):ce&&defined$G(we)&&(Ce?_e.text=we:(oe.dataLabels=oe.dataLabels||[],Ce=oe.dataLabels[le]=be?j.text(we,0,-9999,ae.useHTML).addClass("highcharts-data-label"):j.label(we,0,-9999,ae.shape,null,null,ae.useHTML,null,"data-label"),le||(oe.dataLabel=Ce),Ce.addClass(" highcharts-data-label-color-"+oe.colorIndex+" "+(ae.className||"")+(ae.useHTML?" highcharts-tracker":""))),Ce.options=ae,Ce.attr(_e),D.styledMode||Ce.css(ve).shadow(ae.shadow),Ce.added||Ce.add(K),ae.textPath&&!ae.useHTML&&(Ce.setTextPath(oe.getDataLabelPath&&oe.getDataLabelPath(Ce)||oe.graphic,ae.textPath),oe.dataLabelPath&&!ae.textPath.enabled&&(oe.dataLabelPath=oe.dataLabelPath.destroy())),$.alignDataLabel(oe,Ce,ae,null,Te))})})}fireEvent$p(this,"afterDrawDataLabels")}function P($,D,F,N,W,j){var q=this.chart,X=D.align,K=D.verticalAlign,ee=$.box?0:$.padding||0,te=D.x,ie=te===void 0?0:te,oe=D.y,ae=oe===void 0?0:oe,le,ce;return le=(F.x||0)+ee,le<0&&(X==="right"&&ie>=0?(D.align="left",D.inside=!0):ie-=le,ce=!0),le=(F.x||0)+N.width-ee,le>q.plotWidth&&(X==="left"&&ie<=0?(D.align="right",D.inside=!0):ie+=q.plotWidth-le,ce=!0),le=F.y+ee,le<0&&(K==="bottom"&&ae>=0?(D.verticalAlign="top",D.inside=!0):ae-=le,ce=!0),le=(F.y||0)+N.height-ee,le>q.plotHeight&&(K==="top"&&ae<=0?(D.verticalAlign="bottom",D.inside=!0):ae+=q.plotHeight-le,ce=!0),ce&&(D.x=ie,D.y=ae,$.placed=!j,$.align(D,void 0,W)),ce}function k($,D){var F=[],N;if(isArray$f($)&&!isArray$f(D))F=$.map(function(W){return merge$19(W,D)});else if(isArray$f(D)&&!isArray$f($))F=D.map(function(W){return merge$19($,W)});else if(!isArray$f($)&&!isArray$f(D))F=merge$19($,D);else for(N=Math.max($.length,D.length);N--;)F[N]=merge$19($[N],D[N]);return F}function z($,D,F,N,W){var j=this.chart,q=j.inverted,X=this.xAxis,K=X.reversed,ee=q?D.height/2:D.width/2,te=$.pointWidth,ie=te?te/2:0;D.startXPos=q?W.x:K?-ee-ie:X.width-ee+ie,D.startYPos=q?K?this.yAxis.height-ee+ie:-ee-ie:W.y,N?D.visibility==="hidden"&&(D.show(),D.attr({opacity:0}).animate({opacity:1})):D.attr({opacity:1}).animate({opacity:0},void 0,D.hide),j.hasRendered&&(F&&D.attr({x:D.startXPos,y:D.startYPos}),D.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$e=SeriesRegistry$1.series,merge$18=Utilities.merge,pick$1h=Utilities.pick,ColumnDataLabel$1;(function(g){var d=[];function a(v,C,P,k,z){var $=this.chart.inverted,D=v.series,F=v.dlBox||v.shapeArgs,N=pick$1h(v.below,v.plotY>pick$1h(this.translatedThreshold,D.yAxis.len)),W=pick$1h(P.inside,!!this.options.stacking),j;F&&(k=merge$18(F),k.y<0&&(k.height+=k.y,k.y=0),j=k.y+k.height-D.yAxis.len,j>0&&j<k.height&&(k.height-=j),$&&(k={x:D.yAxis.len-k.y-k.height,y:D.xAxis.len-k.x-k.width,width:k.height,height:k.width}),W||($?(k.x+=N?0:k.width,k.width=0):(k.y+=N?k.height:0,k.height=0))),P.align=pick$1h(P.align,!$||W?"center":N?"right":"left"),P.verticalAlign=pick$1h(P.verticalAlign,$||W?"middle":N?"top":"bottom"),Series$e.prototype.alignDataLabel.call(this,v,C,P,k,z),P.inside&&v.contrastColor&&C.css({color:v.contrastColor})}function p(v){DataLabel$1.compose(Series$e),d.indexOf(v)===-1&&(d.push(v),v.prototype.alignDataLabel=a)}g.compose=p})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$28=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),extend$1f=Utilities.extend,merge$17=Utilities.merge,BarSeries=(function(g){__extends$28(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.defaultOptions=merge$17(ColumnSeries$h.defaultOptions,{}),d})(ColumnSeries$h);extend$1f(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$27=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),addEvent$W=Utilities.addEvent,extend$1e=Utilities.extend,merge$16=Utilities.merge,ScatterSeries$4=(function(g){__extends$27(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.applyJitter=function(){var a=this,p=this.options.jitter,v=this.points.length;function C(P){var k=Math.sin(P)*1e4;return k-Math.floor(k)}p&&this.points.forEach(function(P,k){["x","y"].forEach(function(z,$){var D,F="plot"+z.toUpperCase(),N,W,j;p[z]&&!P.isNull&&(D=a[z+"Axis"],j=p[z]*D.transA,D&&!D.isLog&&(N=Math.max(0,P[F]-j),W=Math.min(D.len,P[F]+j),P[F]=N+(W-N)*C(k+$*v),z==="x"&&(P.clientX=P.plotX)))})})},d.prototype.drawGraph=function(){this.options.lineWidth?g.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},d.defaultOptions=merge$16(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),d})(LineSeries$5);extend$1e(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$W(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$C=Utilities.isNumber,pick$1g=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$5=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var g=this.options,d=this.chart,a=2*(g.slicedOffset||0),p,v=d.plotWidth-2*a,C=d.plotHeight-2*a,P=g.center,k=Math.min(v,C),z=g.size,$=g.innerSize||0,D,F,N;for(typeof z=="string"&&(z=parseFloat(z)),typeof $=="string"&&($=parseFloat($)),D=[pick$1g(P[0],"50%"),pick$1g(P[1],"50%"),pick$1g(z&&z<0?void 0:g.size,"100%"),pick$1g($&&$<0?void 0:g.innerSize||0,"0%")],d.angular&&!(this instanceof Series$f)&&(D[3]=0),F=0;F<4;++F)N=D[F],p=F<2||F===2&&/%$/.test(N),D[F]=relativeLength$6(N,[v,C,k,D[2]][F])+(p?a:0);return D[3]>D[2]&&(D[3]=D[2]),D},getStartAndEndRadians:function(g,d){var a=isNumber$C(g)?g:0,p=isNumber$C(d)&&d>a&&d-a<360?d:a+360,v=-90;return{start:deg2rad$5*(a+v),end:deg2rad$5*(p+v)}}},__extends$26=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),setAnimation$1=animationExports.setAnimation,addEvent$V=Utilities.addEvent,defined$F=Utilities.defined,extend$1d=Utilities.extend,isNumber$B=Utilities.isNumber,pick$1f=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=(function(g){__extends$26(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.labelDistance=void 0,a.options=void 0,a.series=void 0,a}return d.prototype.getConnectorPath=function(){var a=this.labelPosition,p=this.series.options.dataLabels,v=this.connectorShapes,C=p.connectorShape;return v[C]&&(C=v[C]),C.call(this,{x:a.final.x,y:a.final.y,alignment:a.alignment},a.connectorPosition,p)},d.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},d.prototype.haloPath=function(a){var p=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(p.x,p.y,p.r+a,p.r+a,{innerR:p.r-1,start:p.start,end:p.end})},d.prototype.init=function(){var a=this;g.prototype.init.apply(this,arguments),this.name=pick$1f(this.name,"Slice");var p=function(v){a.slice(v.type==="select")};return addEvent$V(this,"select",p),addEvent$V(this,"unselect",p),this},d.prototype.isValid=function(){return isNumber$B(this.y)&&this.y>=0},d.prototype.setVisible=function(a,p){var v=this,C=this.series,P=C.chart,k=C.options.ignoreHiddenPoint;p=pick$1f(p,k),a!==this.visible&&(this.visible=this.options.visible=a=typeof a>"u"?!this.visible:a,C.options.data[C.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(z){v[z]&&v[z][a?"show":"hide"](a)}),this.legendItem&&P.legend.colorizeItem(this,a),!a&&this.state==="hover"&&this.setState(""),k&&(C.isDirty=!0),p&&P.redraw())},d.prototype.slice=function(a,p,v){var C=this.series,P=C.chart;setAnimation$1(v,P),p=pick$1f(p,!0),this.sliced=this.options.sliced=a=defined$F(a)?a:!this.sliced,C.options.data[C.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},d})(Point$4);extend$1d(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(g,d,a){var p=d.breakAt,v=d.touchingSliceAt,C=a.softConnector?["C",g.x+(g.alignment==="left"?-5:5),g.y,2*p.x-v.x,2*p.y-v.y,p.x,p.y]:["L",p.x,p.y];return[["M",g.x,g.y],C,["L",v.x,v.y]]},straight:function(g,d){var a=d.touchingSliceAt;return[["M",g.x,g.y],["L",a.x,a.y]]},crookedLine:function(g,d,a){var p=d.touchingSliceAt,v=this.series,C=v.center[0],P=v.chart.plotWidth,k=v.chart.plotLeft,z=g.alignment,$=this.shapeArgs.r,D=relativeLength$5(a.crookDistance,1),F=z==="left"?C+$+(P+k-C-$)*(1-D):k+(C-$)*D,N=["L",F,g.y],W=!0;(z==="left"?F>g.x||F<p.x:F<g.x||F>p.x)&&(W=!1);var j=[["M",g.x,g.y]];return W&&j.push(N),j.push(["L",p.x,p.y]),j}}});var __extends$25=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$f=H.noop,clamp$e=Utilities.clamp,extend$1c=Utilities.extend,fireEvent$o=Utilities.fireEvent,merge$15=Utilities.merge,pick$1e=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=(function(g){__extends$25(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.center=void 0,a.data=void 0,a.maxLabelDistance=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){var p=this,v=p.points,C=p.startAngleRad;a||v.forEach(function(P){var k=P.graphic,z=P.shapeArgs;k&&z&&(k.attr({r:pick$1e(P.startR,p.center&&p.center[3]/2),start:C,end:C}),k.animate({r:z.r,start:z.start,end:z.end},p.options.animation))})},d.prototype.drawEmpty=function(){var a=this.startAngleRad,p=this.endAngleRad,v=this.options,C,P;this.total===0&&this.center?(C=this.center[0],P=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(C,P,this.center[1]/2,0,a,p).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(C,P,this.center[2]/2,0,{start:a,end:p,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":v.borderWidth,fill:v.fillColor||"none",stroke:v.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},d.prototype.drawPoints=function(){var a=this.chart.renderer;this.points.forEach(function(p){p.graphic&&p.hasNewShapeType()&&(p.graphic=p.graphic.destroy()),p.graphic||(p.graphic=a[p.shapeType](p.shapeArgs).add(p.series.group),p.delayedRendering=!0)})},d.prototype.generatePoints=function(){g.prototype.generatePoints.call(this),this.updateTotals()},d.prototype.getX=function(a,p,v){var C=this.center,P=this.radii?this.radii[v.index]||0:C[2]/2,k=Math.asin(clamp$e((a-C[1])/(P+v.labelDistance),-1,1)),z=C[0]+(p?-1:1)*(Math.cos(k)*(P+v.labelDistance))+(v.labelDistance>0?(p?-1:1)*this.options.dataLabels.padding:0);return z},d.prototype.hasData=function(){return!!this.processedXData.length},d.prototype.redrawPoints=function(){var a=this,p=a.chart,v=p.renderer,C=a.options.shadow,P,k,z,$;this.drawEmpty(),C&&!a.shadowGroup&&!p.styledMode&&(a.shadowGroup=v.g("shadow").attr({zIndex:-1}).add(a.group)),a.points.forEach(function(D){var F={};if(k=D.graphic,!D.isNull&&k){var N=void 0;$=D.shapeArgs,P=D.getTranslate(),p.styledMode||(N=D.shadowGroup,C&&!N&&(N=D.shadowGroup=v.g("shadow").add(a.shadowGroup)),N&&N.attr(P),z=a.pointAttribs(D,D.selected&&"select")),D.delayedRendering?(k.setRadialReference(a.center).attr($).attr(P),p.styledMode||k.attr(z).attr({"stroke-linejoin":"round"}).shadow(C,N),D.delayedRendering=!1):(k.setRadialReference(a.center),p.styledMode||merge$15(!0,F,z),merge$15(!0,F,$,P),k.animate(F)),k.attr({visibility:D.visible?"inherit":"hidden"}),k.addClass(D.getClassName(),!0)}else k&&(D.graphic=k.destroy())})},d.prototype.sortByAngle=function(a,p){a.sort(function(v,C){return typeof v.angle<"u"&&(C.angle-v.angle)*p})},d.prototype.translate=function(a){this.generatePoints();var p=this,v=1e3,C=p.options,P=C.slicedOffset,k=P+(C.borderWidth||0),z=getStartAndEndRadians(C.startAngle,C.endAngle),$=p.startAngleRad=z.start,D=p.endAngleRad=z.end,F=D-$,N=p.points,W=C.dataLabels.distance,j=C.ignoreHiddenPoint,q=N.length,X,K,ee,te,ie,oe,ae,le,ce=0;for(a||(p.center=a=p.getCenter()),ae=0;ae<q;ae++){le=N[ae],K=$+ce*F,le.isValid()&&(!j||le.visible)&&(ce+=le.percentage/100),ee=$+ce*F;var ue={x:a[0],y:a[1],r:a[2]/2,innerR:a[3]/2,start:Math.round(K*v)/v,end:Math.round(ee*v)/v};le.shapeType="arc",le.shapeArgs=ue,le.labelDistance=pick$1e(le.options.dataLabels&&le.options.dataLabels.distance,W),le.labelDistance=relativeLength$4(le.labelDistance,ue.r),p.maxLabelDistance=Math.max(p.maxLabelDistance||0,le.labelDistance),te=(ee+K)/2,te>1.5*Math.PI?te-=2*Math.PI:te<-Math.PI/2&&(te+=2*Math.PI),le.slicedTranslation={translateX:Math.round(Math.cos(te)*P),translateY:Math.round(Math.sin(te)*P)},ie=Math.cos(te)*a[2]/2,oe=Math.sin(te)*a[2]/2,le.tooltipPos=[a[0]+ie*.7,a[1]+oe*.7],le.half=te<-Math.PI/2||te>Math.PI/2?1:0,le.angle=te,X=Math.min(k,le.labelDistance/5),le.labelPosition={natural:{x:a[0]+ie+Math.cos(te)*le.labelDistance,y:a[1]+oe+Math.sin(te)*le.labelDistance},final:{},alignment:le.labelDistance<0?"center":le.half?"right":"left",connectorPosition:{breakAt:{x:a[0]+ie+Math.cos(te)*X,y:a[1]+oe+Math.sin(te)*X},touchingSliceAt:{x:a[0]+ie,y:a[1]+oe}}}}fireEvent$o(p,"afterTranslate")},d.prototype.updateTotals=function(){var a=this.points,p=a.length,v=this.options.ignoreHiddenPoint,C,P,k=0;for(C=0;C<p;C++)P=a[C],P.isValid()&&(!v||P.visible)&&(k+=P.y);for(this.total=k,C=0;C<p;C++)P=a[C],P.percentage=k>0&&(P.visible||!v)?P.y/k*100:0,P.total=k},d.defaultOptions=merge$15(Series$f.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),d})(Series$f);extend$1c(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$f,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$f,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$e=H.noop,distribute$1=R.distribute,Series$d=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$d=Utilities.clamp,defined$E=Utilities.defined,merge$14=Utilities.merge,pick$1d=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(g){var d=[],a={radialDistributionY:function(k){return k.top+k.distributeBox.pos},radialDistributionX:function(k,z,$,D){return k.getX($<z.top+2||$>z.bottom-2?D:$,z.half,z)},justify:function(k,z,$){return $[0]+(k.half?-1:1)*(z+k.labelDistance)},alignToPlotEdges:function(k,z,$,D){var F=k.getBBox().width;return z?F+D:$-F-D},alignToConnectors:function(k,z,$,D){var F=0,N;return k.forEach(function(W){N=W.dataLabel.getBBox().width,N>F&&(F=N)}),z?F+D:$-F-D}};function p(k){if(DataLabel$1.compose(Series$d),d.indexOf(k)===-1){d.push(k);var z=k.prototype;z.dataLabelPositioners=a,z.alignDataLabel=noop$e,z.drawDataLabels=v,z.placeDataLabels=C,z.verifyDataLabelOverflow=P}}g.compose=p;function v(){var k=this,z=k.data,$=k.chart,D=k.options.dataLabels||{},F=D.connectorPadding,N=$.plotWidth,W=$.plotHeight,j=$.plotLeft,q=Math.round($.chartWidth/3),X=k.center,K=X[2]/2,ee=X[1],te=[[],[]],ie=[0,0,0,0],oe=k.dataLabelPositioners,ae,le,ce,ue,ge,ye,we,ve,be,_e,Ce,Ee;!k.visible||!D.enabled&&!k._hasPointLabels||(z.forEach(function(Te){Te.dataLabel&&Te.visible&&Te.dataLabel.shortened&&(Te.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),Te.dataLabel.shortened=!1)}),Series$d.prototype.drawDataLabels.apply(k),z.forEach(function(Te){Te.dataLabel&&(Te.visible?(te[Te.half].push(Te),Te.dataLabel._pos=null,!defined$E(D.style.width)&&!defined$E(Te.options.dataLabels&&Te.options.dataLabels.style&&Te.options.dataLabels.style.width)&&Te.dataLabel.getBBox().width>q&&(Te.dataLabel.css({width:Math.round(q*.7)+"px"}),Te.dataLabel.shortened=!0)):(Te.dataLabel=Te.dataLabel.destroy(),Te.dataLabels&&Te.dataLabels.length===1&&delete Te.dataLabels))}),te.forEach(function(Te,$e){var Ge=Te.length,Ne=[],ke,Fe,We,De,nt,gt;if(Ge)for(k.sortByAngle(Te,$e-.5),k.maxLabelDistance>0&&(ke=Math.max(0,ee-K-k.maxLabelDistance),Fe=Math.min(ee+K+k.maxLabelDistance,$.plotHeight),Te.forEach(function(at){at.labelDistance>0&&at.dataLabel&&(at.top=Math.max(0,ee-K-at.labelDistance),at.bottom=Math.min(ee+K+at.labelDistance,$.plotHeight),nt=at.dataLabel.getBBox().height||21,at.distributeBox={target:at.labelPosition.natural.y-at.top+nt/2,size:nt,rank:at.y},Ne.push(at.distributeBox))}),gt=Fe+nt-ke,distribute$1(Ne,gt,gt/5)),Ce=0;Ce<Ge;Ce++){if(ae=Te[Ce],ye=ae.labelPosition,ue=ae.dataLabel,_e=ae.visible===!1?"hidden":"inherit",We=ye.natural.y,be=We,Ne&&defined$E(ae.distributeBox)&&(typeof ae.distributeBox.pos>"u"?_e="hidden":(we=ae.distributeBox.size,be=oe.radialDistributionY(ae))),delete ae.positionIndex,D.justify)ve=oe.justify(ae,K,X);else switch(D.alignTo){case"connectors":ve=oe.alignToConnectors(Te,$e,N,j);break;case"plotEdges":ve=oe.alignToPlotEdges(ue,$e,N,j);break;default:ve=oe.radialDistributionX(k,ae,be,We)}ue._attr={visibility:_e,align:ye.alignment},Ee=ae.options.dataLabels||{},ue._pos={x:ve+pick$1d(Ee.x,D.x)+({left:F,right:-F}[ye.alignment]||0),y:be+pick$1d(Ee.y,D.y)-10},ye.final.x=ve,ye.final.y=be,pick$1d(D.crop,!0)&&(ge=ue.getBBox().width,De=null,ve-ge<F&&$e===1?(De=Math.round(ge-ve+F),ie[3]=Math.max(De,ie[3])):ve+ge>N-F&&$e===0&&(De=Math.round(ve+ge-N+F),ie[1]=Math.max(De,ie[1])),be-we/2<0?ie[0]=Math.max(Math.round(-be+we/2),ie[0]):be+we/2>W&&(ie[2]=Math.max(Math.round(be+we/2-W),ie[2])),ue.sideOverflow=De)}}),(arrayMax$6(ie)===0||this.verifyDataLabelOverflow(ie))&&(this.placeDataLabels(),this.points.forEach(function(Te){if(Ee=merge$14(D,Te.options.dataLabels),le=pick$1d(Ee.connectorWidth,1),le){var $e=void 0;ce=Te.connector,ue=Te.dataLabel,ue&&ue._pos&&Te.visible&&Te.labelDistance>0?(_e=ue._attr.visibility,$e=!ce,$e&&(Te.connector=ce=$.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+Te.colorIndex+(Te.className?" "+Te.className:"")).add(k.dataLabelsGroup),$.styledMode||ce.attr({"stroke-width":le,stroke:Ee.connectorColor||Te.color||palette.neutralColor60})),ce[$e?"attr":"animate"]({d:Te.getConnectorPath()}),ce.attr("visibility",_e)):ce&&(Te.connector=ce.destroy())}})))}function C(){this.points.forEach(function(k){var z=k.dataLabel,$;z&&k.visible&&($=z._pos,$?(z.sideOverflow&&(z._attr.width=Math.max(z.getBBox().width-z.sideOverflow,0),z.css({width:z._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),z.shortened=!0),z.attr(z._attr),z[z.moved?"animate":"attr"]($),z.moved=!0):z&&z.attr({y:-9999})),delete k.distributeBox},this)}function P(k){var z=this.center,$=this.options,D=$.center,F=$.minSize||80,N=F,W=$.size!==null;return W||(D[0]!==null?N=Math.max(z[2]-Math.max(k[1],k[3]),F):(N=Math.max(z[2]-k[1]-k[3],F),z[0]+=(k[3]-k[1])/2),D[1]!==null?N=clamp$d(N,F,z[2]-Math.max(k[0],k[2])):(N=clamp$d(N,F,z[2]-k[0]-k[2]),z[1]+=(k[0]-k[2])/2),N<z[2]?(z[2]=N,z[3]=Math.min(relativeLength$3($.innerSize||0,N),N),this.translate(z),this.drawDataLabels&&this.drawDataLabels()):W=!0),W}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$U=Utilities.addEvent,fireEvent$n=Utilities.fireEvent,isArray$e=Utilities.isArray,isNumber$A=Utilities.isNumber,objectEach$i=Utilities.objectEach,pick$1c=Utilities.pick;addEvent$U(Chart$1,"render",function g(){var d=this,a=[];(this.labelCollectors||[]).forEach(function(p){a=a.concat(p())}),(this.yAxis||[]).forEach(function(p){p.stacking&&p.options.stackLabels&&!p.options.stackLabels.allowOverlap&&objectEach$i(p.stacking.stacks,function(v){objectEach$i(v,function(C){C.label&&C.label.visibility!=="hidden"&&a.push(C.label)})})}),(this.series||[]).forEach(function(p){var v=p.options.dataLabels;if(p.visible&&!(v.enabled===!1&&!p._hasPointLabels)){var C=function(P){return P.forEach(function(k){if(k.visible){var z=isArray$e(k.dataLabels)?k.dataLabels:k.dataLabel?[k.dataLabel]:[];z.forEach(function($){var D=$.options;$.labelrank=pick$1c(D.labelrank,k.labelrank,k.shapeArgs&&k.shapeArgs.height),D.allowOverlap?($.oldOpacity=$.opacity,$.newOpacity=1,hideOrShow($,d)):a.push($)})}})};C(p.nodes||[]),C(p.points)}}),this.hideOverlappingLabels(a)});Chart$1.prototype.hideOverlappingLabels=function(g){var d=this,a=g.length,p=d.renderer,v,C,P,k,z,$,D,F=!1,N=function(j,q){return!(q.x>=j.x+j.width||q.x+q.width<=j.x||q.y>=j.y+j.height||q.y+q.height<=j.y)},W=function(j){var q,X,K,ee=j.box?0:j.padding||0,te=0,ie=0,oe,ae;if(j&&(!j.alignAttr||j.placed))return q=j.alignAttr||{x:j.attr("x"),y:j.attr("y")},X=j.parentGroup,j.width||(K=j.getBBox(),j.width=K.width,j.height=K.height,te=p.fontMetrics(null,j.element).h),oe=j.width-2*ee,ae={left:"0",center:"0.5",right:"1"}[j.alignValue],ae?ie=+ae*oe:isNumber$A(j.x)&&Math.round(j.x)!==j.translateX&&(ie=j.x-j.translateX),{x:q.x+(X.translateX||0)+ee-(ie||0),y:q.y+(X.translateY||0)+ee-te,width:j.width-2*ee,height:j.height-2*ee}};for(C=0;C<a;C++)v=g[C],v&&(v.oldOpacity=v.opacity,v.newOpacity=1,v.absoluteBox=W(v));for(g.sort(function(j,q){return(q.labelrank||0)-(j.labelrank||0)}),C=0;C<a;C++)for(k=g[C],$=k&&k.absoluteBox,P=C+1;P<a;++P)z=g[P],D=z&&z.absoluteBox,$&&D&&k!==z&&k.newOpacity!==0&&z.newOpacity!==0&&N($,D)&&((k.labelrank<z.labelrank?k:z).newOpacity=0);g.forEach(function(j){hideOrShow(j,d)&&(F=!0)}),F&&fireEvent$n(d,"afterHideAllOverlappingLabels")};function hideOrShow(g,d){var a,p,v=!1;return g&&(p=g.newOpacity,g.oldOpacity!==p&&(g.alignAttr&&g.placed?(g[p?"removeClass":"addClass"]("highcharts-data-label-hidden"),a=function(){d.styledMode||g.css({pointerEvents:p?"auto":"none"})},v=!0,g.alignAttr.opacity=p,g[g.isOld?"animate":"attr"](g.alignAttr,null,a),fireEvent$n(d,"afterHideOverlappingLabel")):g.attr({opacity:p})),g.isOld=!0),v}var extend$1b=Utilities.extend,find$g=Utilities.find,isArray$d=Utilities.isArray,isObject$b=Utilities.isObject,merge$13=Utilities.merge,objectEach$h=Utilities.objectEach,pick$1b=Utilities.pick,splat$c=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(g){var d=[];function a(v){return d.indexOf(v)===-1&&(d.push(v),extend$1b(v.prototype,p.prototype)),v}g.compose=a;var p=(function(){function v(){}return v.prototype.currentOptions=function(C){var P=this,k={};function z($,D,F,N){var W;objectEach$h($,function(j,q){if(!N&&P.collectionsWithUpdate.indexOf(q)>-1&&D[q])for(j=splat$c(j),F[q]=[],W=0;W<Math.max(j.length,D[q].length);W++)D[q][W]&&(j[W]===void 0?F[q][W]=D[q][W]:(F[q][W]={},z(j[W],D[q][W],F[q][W],N+1)));else isObject$b(j)?(F[q]=isArray$d(j)?[]:{},z(j,D[q]||{},F[q],N+1)):typeof D[q]>"u"?F[q]=null:F[q]=D[q]})}return z(C,this.options,k,0),k},v.prototype.matchResponsiveRule=function(C,P){var k=C.condition,z=k.callback||function(){return this.chartWidth<=pick$1b(k.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$1b(k.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$1b(k.minWidth,0)&&this.chartHeight>=pick$1b(k.minHeight,0)};z.call(this)&&P.push(C._id)},v.prototype.setResponsive=function(C,P){var k=this,z=this.options.responsive,$=this.currentResponsive,D=[],F;!P&&z&&z.rules&&z.rules.forEach(function(j){typeof j._id>"u"&&(j._id=uniqueKey$3()),k.matchResponsiveRule(j,D)},this);var N=merge$13.apply(void 0,D.map(function(j){return find$g((z||{}).rules||[],function(q){return q._id===j})}).map(function(j){return j&&j.chartOptions}));N.isResponsiveOptions=!0,D=D.toString()||void 0;var W=$&&$.ruleIds;D!==W&&($&&this.update($.undoOptions,C,!0),D?(F=this.currentOptions(N),F.isResponsiveOptions=!0,this.currentResponsive={ruleIds:D,mergedOptions:N,undoOptions:F},this.update(N,C,!0)):this.currentResponsive=void 0)},v})()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$8=H;G$8.animate=animationExports.animate;G$8.animObject=animationExports.animObject;G$8.getDeferredAnimation=animationExports.getDeferredAnimation;G$8.setAnimation=animationExports.setAnimation;G$8.stop=animationExports.stop;G$8.timers=Fx.timers;G$8.AST=AST;G$8.Axis=Axis;G$8.Chart=Chart$1;G$8.chart=Chart$1.chart;G$8.Fx=Fx;G$8.Legend=Legend;G$8.PlotLineOrBand=PlotLineOrBand;G$8.Point=Point$4;G$8.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$8.Series=Series$f;G$8.SVGElement=SVGElement;G$8.SVGRenderer=SVGRenderer;G$8.Tick=Tick;G$8.Time=Time;G$8.Tooltip=Tooltip;G$8.Color=Color;G$8.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement$1.compose(SVGElement);G$8.defaultOptions=DefaultOptions.defaultOptions;G$8.getOptions=DefaultOptions.getOptions;G$8.time=DefaultOptions.defaultTime;G$8.setOptions=DefaultOptions.setOptions;G$8.dateFormat=FormatUtilities.dateFormat;G$8.format=FormatUtilities.format;G$8.numberFormat=FormatUtilities.numberFormat;G$8.addEvent=Utilities.addEvent;G$8.arrayMax=Utilities.arrayMax;G$8.arrayMin=Utilities.arrayMin;G$8.attr=Utilities.attr;G$8.clearTimeout=Utilities.clearTimeout;G$8.correctFloat=Utilities.correctFloat;G$8.createElement=Utilities.createElement;G$8.css=Utilities.css;G$8.defined=Utilities.defined;G$8.destroyObjectProperties=Utilities.destroyObjectProperties;G$8.discardElement=Utilities.discardElement;G$8.distribute=R.distribute;G$8.erase=Utilities.erase;G$8.error=Utilities.error;G$8.extend=Utilities.extend;G$8.extendClass=Utilities.extendClass;G$8.find=Utilities.find;G$8.fireEvent=Utilities.fireEvent;G$8.getMagnitude=Utilities.getMagnitude;G$8.getStyle=Utilities.getStyle;G$8.inArray=Utilities.inArray;G$8.isArray=Utilities.isArray;G$8.isClass=Utilities.isClass;G$8.isDOMElement=Utilities.isDOMElement;G$8.isFunction=Utilities.isFunction;G$8.isNumber=Utilities.isNumber;G$8.isObject=Utilities.isObject;G$8.isString=Utilities.isString;G$8.keys=Utilities.keys;G$8.merge=Utilities.merge;G$8.normalizeTickInterval=Utilities.normalizeTickInterval;G$8.objectEach=Utilities.objectEach;G$8.offset=Utilities.offset;G$8.pad=Utilities.pad;G$8.pick=Utilities.pick;G$8.pInt=Utilities.pInt;G$8.relativeLength=Utilities.relativeLength;G$8.removeEvent=Utilities.removeEvent;G$8.seriesType=SeriesRegistry$1.seriesType;G$8.splat=Utilities.splat;G$8.stableSort=Utilities.stableSort;G$8.syncTimeout=Utilities.syncTimeout;G$8.timeUnits=Utilities.timeUnits;G$8.uniqueKey=Utilities.uniqueKey;G$8.useSerialIds=Utilities.useSerialIds;G$8.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$f);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$T=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$D=Utilities.defined,error$5=Utilities.error,pick$1a=Utilities.pick,timeUnits$1=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(g){function d(j,q,X){if(composedClasses.indexOf(j)===-1){composedClasses.push(j);var K=j.prototype;K.getTimeTicks=a,K.index2val=p,K.lin2val=v,K.val2lin=N,K.ordinal2lin=K.val2lin,addEvent$T(j,"afterInit",P),addEvent$T(j,"foundExtremes",k),addEvent$T(j,"afterSetScale",z),addEvent$T(j,"initialAxisTranslation",$)}return composedClasses.indexOf(X)===-1&&(composedClasses.push(X),addEvent$T(X,"pan",D)),composedClasses.indexOf(q)===-1&&(composedClasses.push(q),addEvent$T(q,"updatedData",F)),j}g.compose=d;function a(j,q,X,K,ee,te,ie){ee===void 0&&(ee=[]),te===void 0&&(te=0);var oe={},ae=this.options.tickPixelInterval,le=this.chart.time,ce=[],ue,ge,ye,we,ve,be=0,_e=[],Ce=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!ee||ee.length<3||typeof q>"u")return le.getTimeTicks.apply(le,arguments);var Ee=ee.length;for(ue=0;ue<Ee;ue++){if(ve=ue&&ee[ue-1]>X,ee[ue]<q&&(be=ue),ue===Ee-1||ee[ue+1]-ee[ue]>te*5||ve){if(ee[ue]>Ce){for(ge=le.getTimeTicks(j,ee[be],ee[ue],K);ge.length&&ge[0]<=Ce;)ge.shift();ge.length&&(Ce=ge[ge.length-1]),ce.push(_e.length),_e=_e.concat(ge)}be=ue+1}if(ve)break}if(ge){if(we=ge.info,ie&&we.unitRange<=timeUnits$1.hour){for(ue=_e.length-1,be=1;be<ue;be++)le.dateFormat("%d",_e[be])!==le.dateFormat("%d",_e[be-1])&&(oe[_e[be]]="day",ye=!0);ye&&(oe[_e[0]]="day"),we.higherRanks=oe}we.segmentStarts=ce,_e.info=we}else error$5(12,!1,this.chart);if(ie&&defined$D(ae)){for(var Te=_e.length,$e=[],Ge=[],Ne=void 0,ke=void 0,Fe=void 0,We=void 0,De=void 0,nt=Te;nt--;)ke=this.translate(_e[nt]),Fe&&(Ge[nt]=Fe-ke),$e[nt]=Fe=ke;for(Ge.sort(),We=Ge[Math.floor(Ge.length/2)],We<ae*.6&&(We=null),nt=_e[Te-1]>X?Te-1:Te,Fe=void 0;nt--;)ke=$e[nt],De=Math.abs(Fe-ke),Fe&&De<ae*.8&&(We===null||De<We*.8)?(oe[_e[nt]]&&!oe[_e[nt+1]]?(Ne=nt+1,Fe=ke):Ne=nt,_e.splice(Ne,1)):Fe=ke}return _e}function p(j){var q=this,X=q.ordinal,K=X.positions;if(!K)return j;var ee=K.length-1,te;return j<0?j=K[0]:j>ee?j=K[ee]:(ee=Math.floor(j),te=j-ee),typeof te<"u"&&typeof K[ee]<"u"?K[ee]+(te?te*(K[ee+1]-K[ee]):0):j}function v(j){var q=this,X=q.ordinal,K=q.old?q.old.min:q.min,ee=q.old?q.old.transA:q.transA,te=X.positions;if(!te)return j;var ie=(j-K)*ee+q.minPixelPadding,oe=ie>0&&ie<q.left+q.len;if(oe||(X.extendedOrdinalPositions||(X.extendedOrdinalPositions=X.getExtendedPositions()),te=X.extendedOrdinalPositions),te&&te.length){var ae=X.getIndexOfPoint(ie,te),le=correctFloat$8(ae%1);if(ae>=0&&ae<te.length){var ce=te[Math.floor(ae)],ue=te[Math.ceil(ae)],ge=ue-ce;return te[Math.floor(ae)]+le*ge}var ye=te.length,we=te[0],ve=te[ye-1],be=(ve-we)/(ye-1);return ae<0?we+be*ae:ve+be*(ae-ye)}return j}function C(j,q){var X=g.Additions.findIndexOf(j,q,!0);if(j[X]===q)return X;var K=(q-j[X])/(j[X+1]-j[X]);return X+K}function P(){var j=this;j.ordinal||(j.ordinal=new g.Additions(j))}function k(){var j=this;j.isXAxis&&defined$D(j.options.overscroll)&&j.max===j.dataMax&&(!j.chart.mouseIsDown||j.isInternal)&&(!j.eventArgs||j.eventArgs&&j.eventArgs.trigger!=="navigator")&&(j.max+=j.options.overscroll,!j.isInternal&&defined$D(j.userMin)&&(j.min+=j.options.overscroll))}function z(){var j=this;j.horiz&&!j.isDirty&&(j.isDirty=j.isOrdinal&&j.chart.navigator&&!j.chart.navigator.adaptToUpdatedData)}function $(){var j=this;j.ordinal&&(j.ordinal.beforeSetTickPositions(),j.tickInterval=j.ordinal.postProcessTickInterval(j.tickInterval))}function D(j){var q=this,X=q.xAxis[0],K=X.options.overscroll,ee=j.originalEvent.chartX,te=q.options.chart.panning,ie=!1;if(te&&te.type!=="y"&&X.options.ordinal&&X.series.length){var oe=q.mouseDownX,ae=X.getExtremes(),le=ae.dataMax,ce=ae.min,ue=ae.max,ge=q.hoverPoints,ye=X.closestPointRange||X.ordinal&&X.ordinal.overscrollPointsRange,we=X.translationSlope*(X.ordinal.slope||ye),ve=(oe-ee)/we,be={ordinal:{positions:X.ordinal.getExtendedPositions()}},_e=X.index2val,Ce=X.val2lin,Ee=void 0,Te=void 0,$e=void 0,Ge=void 0;be.ordinal.positions?Math.abs(ve)>1&&(ge&&ge.forEach(function(Ne){Ne.setState()}),ve<0?($e=be,Ge=X.ordinal.positions?X:be):($e=X.ordinal.positions?X:be,Ge=be),Te=Ge.ordinal.positions,le>Te[Te.length-1]&&Te.push(le),q.fixedRange=ue-ce,Ee=X.navigatorAxis.toFixedRange(null,null,_e.apply($e,[Ce.apply($e,[ce,!0])+ve]),_e.apply(Ge,[Ce.apply(Ge,[ue,!0])+ve])),Ee.min>=Math.min(ae.dataMin,ce)&&Ee.max<=Math.max(le,ue)+K&&X.setExtremes(Ee.min,Ee.max,!0,!1,{trigger:"pan"}),q.mouseDownX=ee,css$3(q.container,{cursor:"move"})):ie=!0}else ie=!0;ie||te&&/y/.test(te.type)?K&&(X.max=X.dataMax+K):j.preventDefault()}function F(){var j=this.xAxis;j&&j.options.ordinal&&(delete j.ordinal.index,delete j.ordinal.extendedOrdinalPositions)}function N(j,q){var X=this,K=X.ordinal,ee=K.positions,te=K.slope,ie=K.extendedOrdinalPositions;if(!ee)return j;var oe=ee.length,ae;if(ee[0]<=j&&ee[oe-1]>=j)ae=C(ee,j);else{if(ie||(ie=K.getExtendedPositions&&K.getExtendedPositions(),K.extendedOrdinalPositions=ie),!(ie&&ie.length))return j;var le=ie.length;te||(te=(ie[le-1]-ie[0])/le);var ce=C(ie,ee[0]);if(j>=ie[0]&&j<=ie[le-1])ae=C(ie,j)-ce;else if(j<ie[0]){var ue=ie[0]-j,ge=ue/te;ae=-ce-ge}else{var ue=j-ie[le-1],ge=ue/te;ae=ge+le-ce}}return q?ae:te*(ae||0)+K.offset}var W=(function(){function j(q){this.index={},this.axis=q}return j.prototype.beforeSetTickPositions=function(){var q=this.axis,X=q.ordinal,K=q.getExtremes(),ee=K.min,te=K.max,ie=q.isXAxis&&!!q.options.breaks,oe=q.options.ordinal,ae=q.chart.options.chart.ignoreHiddenSeries,le,ce,ue,ge,ye,we,ve,be,_e=[],Ce=Number.MAX_VALUE,Ee=!1;if(oe||ie){if(q.series.forEach(function(Te,$e){if(ce=[],(!ae||Te.visible!==!1)&&(Te.takeOrdinalPosition!==!1||ie)&&(_e=_e.concat(Te.processedXData),le=_e.length,_e.sort(function(Ge,Ne){return Ge-Ne}),Ce=Math.min(Ce,pick$1a(Te.closestPointRange,Ce)),le)){for($e=0;$e<le-1;)_e[$e]!==_e[$e+1]&&ce.push(_e[$e+1]),$e++;ce[0]!==_e[0]&&ce.unshift(_e[0]),_e=ce}Te.isSeriesBoosting&&(be=!0)}),be&&(_e.length=0),le=_e.length,le>2){for(ue=_e[1]-_e[0],ve=le-1;ve--&&!Ee;)_e[ve+1]-_e[ve]!==ue&&(Ee=!0);!q.options.keepOrdinalPadding&&(_e[0]-ee>ue||te-_e[_e.length-1]>ue)&&(Ee=!0)}else q.options.overscroll&&(le===2?Ce=_e[1]-_e[0]:le===1?(Ce=q.options.overscroll,_e=[_e[0],_e[0]+Ce]):Ce=X.overscrollPointsRange);Ee||q.forceOrdinal?(q.options.overscroll&&(X.overscrollPointsRange=Ce,_e=_e.concat(X.getOverscrollPositions())),X.positions=_e,ge=q.ordinal2lin(Math.max(ee,_e[0]),!0),ye=Math.max(q.ordinal2lin(Math.min(te,_e[_e.length-1]),!0),1),X.slope=we=(te-ee)/(ye-ge),X.offset=ee-ge*we):(X.overscrollPointsRange=pick$1a(q.closestPointRange,X.overscrollPointsRange),X.positions=q.ordinal.slope=X.offset=void 0)}q.isOrdinal=oe&&Ee,X.groupIntervalFactor=null},j.findIndexOf=function(q,X,K){for(var ee=0,te=q.length-1,ie;ee<te;)ie=Math.ceil((ee+te)/2),q[ie]<=X?ee=ie:te=ie-1;return q[ee]===X||K?ee:-1},j.prototype.getExtendedPositions=function(){var q=this,X=q.axis,K=X.constructor.prototype,ee=X.chart,te=X.series[0].currentDataGrouping,ie=te?te.count+te.unitName:"raw",oe=X.options.overscroll,ae=X.getExtremes(),le,ce=void 0,ue=q.index;return ue||(ue=q.index={}),ue[ie]||(le={series:[],chart:ee,forceOrdinal:!1,getExtremes:function(){return{min:ae.dataMin,max:ae.dataMax+oe}},getGroupPixelWidth:K.getGroupPixelWidth,getTimeTicks:K.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:K.ordinal2lin,getIndexOfPoint:K.getIndexOfPoint,val2lin:K.val2lin},le.ordinal.axis=le,X.series.forEach(function(ge){ce={xAxis:le,xData:ge.xData.slice(),chart:ee,destroyGroupedData:H.noop,getProcessedData:Series$f.prototype.getProcessedData,applyGrouping:Series$f.prototype.applyGrouping},ce.xData=ce.xData.concat(q.getOverscrollPositions()),ce.options={dataGrouping:te?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[te.unitName,[te.count]]]}:{enabled:!1}},le.series.push(ce),ge.processData.apply(ce)}),X.applyGrouping.call(le),ce.closestPointRange!==ce.basePointRange&&ce.currentDataGrouping&&(le.forceOrdinal=!0),X.ordinal.beforeSetTickPositions.apply({axis:le}),ue[ie]=le.ordinal.positions),ue[ie]},j.prototype.getGroupIntervalFactor=function(q,X,K){var ee=this;ee.axis;var te=K.processedXData,ie=te.length,oe=[],ae,le,ce=ee.groupIntervalFactor;if(!ce){for(le=0;le<ie-1;le++)oe[le]=te[le+1]-te[le];oe.sort(function(ue,ge){return ue-ge}),ae=oe[Math.floor(ie/2)],q=Math.max(q,te[0]),X=Math.min(X,te[ie-1]),ee.groupIntervalFactor=ce=ie*ae/(X-q)}return ce},j.prototype.getIndexOfPoint=function(q,X){var K=this,ee=K.axis,te=K.positions?K.positions[0]:0,ie=ee.series[0].points&&ee.series[0].points[0]&&ee.series[0].points[0].plotX||ee.minPixelPadding;ee.series.length>1&&ee.series.forEach(function(le){defined$D(le.points[0])&&defined$D(le.points[0].plotX)&&le.points[0].plotX<ie&&(ie=le.points[0].plotX)});var oe=ee.translationSlope*(K.slope||ee.closestPointRange||K.overscrollPointsRange),ae=(q-ie)/oe;return j.findIndexOf(X,te)+ae},j.prototype.getOverscrollPositions=function(){var q=this,X=q.axis,K=X.options.overscroll,ee=q.overscrollPointsRange,te=[],ie=X.dataMax;if(defined$D(ee))for(;ie<=X.dataMax+K;)ie+=ee,te.push(ie);return te},j.prototype.postProcessTickInterval=function(q){var X=this,K=X.axis,ee=X.slope,te;return ee?K.options.breaks?te=K.closestPointRange||q:te=q/(ee/K.closestPointRange):te=q,te},j})();g.Additions=W})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$S=Utilities.addEvent,find$f=Utilities.find,fireEvent$m=Utilities.fireEvent,isArray$c=Utilities.isArray,isNumber$z=Utilities.isNumber,pick$19=Utilities.pick,BrokenAxis;(function(g){var d=[];function a(N,W){if(d.indexOf(N)===-1&&(d.push(N),N.keepProps.push("brokenAxis"),addEvent$S(N,"init",P),addEvent$S(N,"afterInit",p),addEvent$S(N,"afterSetTickPositions",C),addEvent$S(N,"afterSetOptions",v)),d.indexOf(W)===-1){d.push(W);var j=W.prototype;j.drawBreaks=$,j.gappedPath=D,addEvent$S(W,"afterGeneratePoints",k),addEvent$S(W,"afterRender",z)}return N}g.compose=a;function p(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function v(){var N=this;N.brokenAxis&&N.brokenAxis.hasBreaks&&(N.options.ordinal=!1)}function C(){var N=this,W=N.brokenAxis;if(W&&W.hasBreaks){for(var j=N.tickPositions,q=N.tickPositions.info,X=[],K=0;K<j.length;K++)W.isInAnyBreak(j[K])||X.push(j[K]);N.tickPositions=X,N.tickPositions.info=q}}function P(){var N=this;N.brokenAxis||(N.brokenAxis=new F(N))}function k(){var N=this,W=N.isDirty,j=N.options.connectNulls,q=N.points,X=N.xAxis,K=N.yAxis;if(W)for(var ee=q.length;ee--;){var te=q[ee],ie=te.y===null&&j===!1,oe=!ie&&(X&&X.brokenAxis&&X.brokenAxis.isInAnyBreak(te.x,!0)||K&&K.brokenAxis&&K.brokenAxis.isInAnyBreak(te.y,!0));te.visible=oe?!1:te.options.visible!==!1}}function z(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$19(this.pointArrayMap,["y"]))}function $(N,W){var j=this,q=j.points,X,K,ee,te;if(N&&N.brokenAxis&&N.brokenAxis.hasBreaks){var ie=N.brokenAxis;W.forEach(function(oe){X=ie&&ie.breakArray||[],K=N.isXAxis?N.min:pick$19(j.options.threshold,N.min),q.forEach(function(ae){te=pick$19(ae["stack"+oe.toUpperCase()],ae[oe]),X.forEach(function(le){isNumber$z(K)&&isNumber$z(te)&&(ee=!1,K<le.from&&te>le.to||K>le.from&&te<le.from?ee="pointBreak":(K<le.from&&te>le.from&&te<le.to||K>le.from&&te>le.to&&te<le.from)&&(ee="pointInBreak"),ee&&fireEvent$m(N,ee,{point:ae,brk:le}))})})})}}function D(){var N=this.currentDataGrouping,W=N&&N.gapSize,j=this.points.slice(),q=this.yAxis,X=this.options.gapSize,K=j.length-1,ee;if(X&&K>0){this.options.gapUnit!=="value"&&(X*=this.basePointRange),W&&W>X&&W>=this.basePointRange&&(X=W);for(var te=void 0,ie=void 0;K--;)if(ie&&ie.visible!==!1||(ie=j[K+1]),te=j[K],!(ie.visible===!1||te.visible===!1)){if(ie.x-te.x>X){var oe=(te.x+ie.x)/2;j.splice(K+1,0,{isNull:!0,x:oe}),q.stacking&&this.options.stacking&&(ee=q.stacking.stacks[this.stackKey][oe]=new StackItem$1(q,q.options.stackLabels,!1,oe,this.stack),ee.total=0)}ie=te}}return this.getGraphPath(j)}var F=(function(){function N(W){this.hasBreaks=!1,this.axis=W}return N.isInBreak=function(W,j){var q=W.repeat||1/0,X=W.from,K=W.to-W.from,ee=j>=X?(j-X)%q:q-(X-j)%q,te;return W.inclusive?te=ee<=K:te=ee<K&&ee!==0,te},N.lin2Val=function(W){var j=this,q=j.brokenAxis,X=q&&q.breakArray;if(!X||!isNumber$z(W))return W;var K=W,ee,te;for(te=0;te<X.length&&(ee=X[te],!(ee.from>=K));te++)(ee.to<K||N.isInBreak(ee,K))&&(K+=ee.len);return K},N.val2Lin=function(W){var j=this,q=j.brokenAxis,X=q&&q.breakArray;if(!X||!isNumber$z(W))return W;var K=W,ee,te;for(te=0;te<X.length;te++)if(ee=X[te],ee.to<=W)K-=ee.len;else{if(ee.from>=W)break;if(N.isInBreak(ee,W)){K-=W-ee.from;break}}return K},N.prototype.findBreakAt=function(W,j){return find$f(j,function(q){return q.from<W&&W<q.to})},N.prototype.isInAnyBreak=function(W,j){var q=this,X=q.axis,K=X.options.breaks||[],ee=K.length,te,ie,oe;if(ee&&isNumber$z(W)){for(;ee--;)N.isInBreak(K[ee],W)&&(te=!0,ie||(ie=pick$19(K[ee].showPoints,!X.isXAxis)));te&&j?oe=te&&!ie:oe=te}return oe},N.prototype.setBreaks=function(W,j){var q=this,X=q.axis,K=isArray$c(W)&&!!W.length;X.isDirty=q.hasBreaks!==K,q.hasBreaks=K,X.options.breaks=X.userOptions.breaks=W,X.forceRedraw=!0,X.series.forEach(function(ee){ee.isDirty=!0}),!K&&X.val2lin===N.val2Lin&&(delete X.val2lin,delete X.lin2val),K&&(X.userOptions.ordinal=!1,X.lin2val=N.lin2Val,X.val2lin=N.val2Lin,X.setExtremes=function(ee,te,ie,oe,ae){if(q.hasBreaks){for(var le=this.options.breaks||[],ce=void 0;ce=q.findBreakAt(ee,le);)ee=ce.to;for(;ce=q.findBreakAt(te,le);)te=ce.from;te<ee&&(te=ee)}X.constructor.prototype.setExtremes.call(this,ee,te,ie,oe,ae)},X.setAxisTranslation=function(){if(X.constructor.prototype.setAxisTranslation.call(this),q.unitLength=void 0,q.hasBreaks){var ee=X.options.breaks||[],te=[],ie=[],oe=pick$19(X.pointRangePadding,0),ae=0,le,ce,ue=X.userMin||X.min,ge=X.userMax||X.max,ye,we;ee.forEach(function(ve){ce=ve.repeat||1/0,isNumber$z(ue)&&isNumber$z(ge)&&(N.isInBreak(ve,ue)&&(ue+=ve.to%ce-ue%ce),N.isInBreak(ve,ge)&&(ge-=ge%ce-ve.from%ce))}),ee.forEach(function(ve){if(ye=ve.from,ce=ve.repeat||1/0,isNumber$z(ue)&&isNumber$z(ge)){for(;ye-ce>ue;)ye-=ce;for(;ye<ue;)ye+=ce;for(we=ye;we<ge;we+=ce)te.push({value:we,move:"in"}),te.push({value:we+ve.to-ve.from,move:"out",size:ve.breakSize})}}),te.sort(function(ve,be){return ve.value===be.value?(ve.move==="in"?0:1)-(be.move==="in"?0:1):ve.value-be.value}),le=0,ye=ue,te.forEach(function(ve){le+=ve.move==="in"?1:-1,le===1&&ve.move==="in"&&(ye=ve.value),le===0&&isNumber$z(ye)&&(ie.push({from:ye,to:ve.value,len:ve.value-ye-(ve.size||0)}),ae+=ve.value-ye-(ve.size||0))}),q.breakArray=ie,isNumber$z(ue)&&isNumber$z(ge)&&isNumber$z(X.min)&&(q.unitLength=ge-ue-ae+oe,fireEvent$m(X,"afterBreaks"),X.staticScale?X.transA=X.staticScale:q.unitLength&&(X.transA*=(ge-X.min+oe)/q.unitLength),oe&&(X.minPixelPadding=X.transA*(X.minPointOffset||0)),X.min=ue,X.max=ge)}}),pick$19(j,!0)&&X.chart.redraw()},N})();g.Additions=F})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;BrokenAxis$1.compose(G$7.Axis,G$7.Series);var format$8=FormatUtilities.format,seriesProto$3=Series$f.prototype,addEvent$R=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$C=Utilities.defined,error$4=Utilities.error,extend$1a=Utilities.extend,isNumber$y=Utilities.isNumber,merge$12=Utilities.merge,pick$18=Utilities.pick,approximations=H.approximations={sum:function(g){var d=g.length,a;if(!d&&g.hasNulls)a=null;else if(d)for(a=0;d--;)a+=g[d];return a},average:function(g){var d=g.length,a=approximations.sum(g);return isNumber$y(a)&&d&&(a=correctFloat$7(a/d)),a},averages:function(){var g=[];return[].forEach.call(arguments,function(d){g.push(approximations.average(d))}),typeof g[0]>"u"?void 0:g},open:function(g){return g.length?g[0]:g.hasNulls?null:void 0},high:function(g){return g.length?arrayMax$5(g):g.hasNulls?null:void 0},low:function(g){return g.length?arrayMin$5(g):g.hasNulls?null:void 0},close:function(g){return g.length?g[g.length-1]:g.hasNulls?null:void 0},ohlc:function(g,d,a,p){if(g=approximations.open(g),d=approximations.high(d),a=approximations.low(a),p=approximations.close(p),isNumber$y(g)||isNumber$y(d)||isNumber$y(a)||isNumber$y(p))return[g,d,a,p]},range:function(g,d){if(g=approximations.low(g),d=approximations.high(d),isNumber$y(g)||isNumber$y(d))return[g,d];if(g===null&&d===null)return null}},applyGrouping=function(){var g=this,d=g.chart,a=g.options,p=a.dataGrouping,v=g.allowDG!==!1&&p&&pick$18(p.enabled,d.options.isStock),C=g.visible||!d.options.chart.ignoreHiddenSeries,P,k,z=this.currentDataGrouping,$,D,F=!1;if(v&&!g.requireSorting&&(g.requireSorting=F=!0),k=skipDataGrouping(g)||!v,F&&(g.requireSorting=!1),!k){g.destroyGroupedData();var N=void 0,W=p.groupAll?g.xData:g.processedXData,j=p.groupAll?g.yData:g.processedYData,q=d.plotSizeX,X=g.xAxis,K=X.options.ordinal,ee=g.groupPixelWidth;if(ee&&W&&W.length){P=!0,g.isDirty=!0,g.points=null;var te=X.getExtremes(),ie=te.min,oe=te.max,ae=K&&X.ordinal&&X.ordinal.getGroupIntervalFactor(ie,oe,g)||1,le=ee*(oe-ie)/q*ae,ce=X.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(le,p.units||defaultDataGroupingUnits),Math.min(ie,W[0]),Math.max(oe,W[W.length-1]),X.options.startOfWeek,W,g.closestPointRange),ue=seriesProto$3.groupData.apply(g,[W,j,ce,p.approximation]),ge=ue.groupedXData,ye=ue.groupedYData,we=0;for(p&&p.smoothed&&ge.length&&(p.firstAnchor="firstPoint",p.anchor="middle",p.lastAnchor="lastPoint",error$4(32,!1,d,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(g,ge,oe),N=1;N<ce.length;N++)(!ce.info.segmentStarts||ce.info.segmentStarts.indexOf(N)===-1)&&(we=Math.max(ce[N]-ce[N-1],we));$=ce.info,$.gapSize=we,g.closestPointRange=ce.info.totalRange,g.groupMap=ue.groupMap,C&&adjustExtremes(X,ge),p.groupAll&&(g.allGroupedData=ye,D=g.cropData(ge,ye,X.min,X.max,1),ge=D.xData,ye=D.yData,g.cropStart=D.start),g.processedXData=ge,g.processedYData=ye}else g.groupMap=null;g.hasGroupedData=P,g.currentDataGrouping=$,g.preventGraphAnimation=(z&&z.totalRange)!==($&&$.totalRange)}},skipDataGrouping=function(g){if(g.isCartesian&&!g.isDirty&&!g.xAxis.isDirty&&!g.yAxis.isDirty)return!1},groupData=function(g,d,a,p){var v=this,C=v.data,P=v.options&&v.options.data,k=[],z=[],$=[],D=g.length,F,N,W,j=!!d,q=[],X,K=v.pointArrayMap,ee=K&&K.length,te=["x"].concat(K||["y"]),ie=this.options.dataGrouping&&this.options.dataGrouping.groupAll,oe=0,ae=0,le,ce,ue;function ge(be){return typeof be=="function"?be:approximations[be]?approximations[be]:approximations[v.getDGApproximation&&v.getDGApproximation()||"average"]}for(X=ge(p),ee?K.forEach(function(){q.push([])}):q.push([]),le=ee||1,ce=0;ce<=D&&!(g[ce]>=a[0]);ce++);for(ce;ce<=D;ce++){for(;typeof a[oe+1]<"u"&&g[ce]>=a[oe+1]||ce===D;){for(F=a[oe],v.dataGroupInfo={start:ie?ae:v.cropStart+ae,length:q[0].length},W=X.apply(v,q),v.pointClass&&!defined$C(v.dataGroupInfo.options)&&(v.dataGroupInfo.options=merge$12(v.pointClass.prototype.optionsToObject.call({series:v},v.options.data[v.cropStart+ae])),te.forEach(function(be){delete v.dataGroupInfo.options[be]})),typeof W<"u"&&(k.push(F),z.push(W),$.push(v.dataGroupInfo)),ae=ce,ue=0;ue<le;ue++)q[ue].length=0,q[ue].hasNulls=!1;if(oe+=1,ce===D)break}if(ce===D)break;if(K){var ye=v.options.dataGrouping&&v.options.dataGrouping.groupAll?ce:v.cropStart+ce,we=C&&C[ye]||v.pointClass.prototype.applyOptions.apply({series:v},[P[ye]]),ve=void 0;for(ue=0;ue<ee;ue++)ve=we[K[ue]],isNumber$y(ve)?q[ue].push(ve):ve===null&&(q[ue].hasNulls=!0)}else N=j?d[ce]:null,isNumber$y(N)?q[0].push(N):N===null&&(q[0].hasNulls=!0)}return{groupedXData:k,groupedYData:z,groupMap:$}},anchorPoints=function(g,d,a){var p=g.options,v=p.dataGrouping,C=g.currentDataGrouping&&g.currentDataGrouping.gapSize,P;if(v&&g.xData&&C&&g.groupMap){var k=d.length-1,z=v.anchor,$=pick$18(v.firstAnchor,z),D=pick$18(v.lastAnchor,z);if(z&&z!=="start"){var F=C*{middle:.5,end:1}[z];for(P=d.length-1;P--&&P>0;)d[P]+=F}if($&&$!=="start"&&g.xData[0]>=d[0]){var N=g.groupMap[0].start,W=g.groupMap[0].length,j=void 0;isNumber$y(N)&&isNumber$y(W)&&(j=N+(W-1)),d[0]={middle:d[0]+.5*C,end:d[0]+C,firstPoint:g.xData[0],lastPoint:j&&g.xData[j]}[$]}if(D&&D!=="start"&&C&&d[k]>=a-C){var q=g.groupMap[g.groupMap.length-1].start;d[k]={middle:d[k]+.5*C,end:d[k]+C,firstPoint:q&&g.xData[q],lastPoint:g.xData[g.xData.length-1]}[D]}}},adjustExtremes=function(g,d){defined$C(d[0])&&isNumber$y(g.min)&&isNumber$y(g.dataMin)&&d[0]<g.min&&((!defined$C(g.options.min)&&g.min<=g.dataMin||g.min===g.dataMin)&&(g.min=Math.min(d[0],g.min)),g.dataMin=Math.min(d[0],g.dataMin)),defined$C(d[d.length-1])&&isNumber$y(g.max)&&isNumber$y(g.dataMax)&&d[d.length-1]>g.max&&((!defined$C(g.options.max)&&isNumber$y(g.dataMax)&&g.max>=g.dataMax||g.max===g.dataMax)&&(g.max=Math.max(d[d.length-1],g.max)),g.dataMax=Math.max(d[d.length-1],g.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(g,d){g&&(this.groupedData[d]=g.destroy?g.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var g=this,d=g.series;d.forEach(function(a){a.groupPixelWidth=void 0,a.groupPixelWidth=g.getGroupPixelWidth&&g.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var g=this.series,d=g.length,a,p=0,v=!1,C,P;for(a=d;a--;)P=g[a].options.dataGrouping,P&&(p=Math.max(p,pick$18(P.groupPixelWidth,commonOptions.groupPixelWidth)));for(a=d;a--;)P=g[a].options.dataGrouping,P&&(C=(g[a].processedXData||g[a].data).length,(g[a].groupPixelWidth||C>this.chart.plotSizeX/p||C&&P.forced)&&(v=!0));return v?p:0};Axis.prototype.setDataGrouping=function(g,d){var a=this,p;if(d=pick$18(d,!0),g||(g={forced:!1,units:null}),this instanceof Axis)for(p=this.series.length;p--;)this.series[p].update({dataGrouping:g},!1);else this.chart.options.series.forEach(function(v){v.dataGrouping=g},!1);a.ordinal&&(a.ordinal.slope=void 0),d&&this.chart.redraw()};addEvent$R(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$R(Point$4,"update",function(){if(this.dataGroup)return error$4(24,!1,this.series.chart),!1});addEvent$R(Tooltip,"headerFormatter",function(g){var d=this.chart,a=d.time,p=g.labelConfig,v=p.series,C=v.options,P=v.tooltipOptions,k=C.dataGrouping,z=P.xDateFormat,$,D=v.xAxis,F,N,W,j,q=P[g.isFooter?"footerFormat":"headerFormat"];D&&D.options.type==="datetime"&&k&&isNumber$y(p.key)&&(F=v.currentDataGrouping,N=k.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,F?(W=N[F.unitName],F.count===1?z=W[0]:(z=W[1],$=W[2])):!z&&N&&D.dateTime&&(z=D.dateTime.getXDateFormat(p.x,P.dateTimeLabelFormats)),j=a.dateFormat(z,p.key),$&&(j+=a.dateFormat($,p.key+F.totalRange-1)),v.chart.styledMode&&(q=this.styledModeFormat(q)),g.text=format$8(q,{point:extend$1a(p.point,{key:j}),series:v},d),g.preventDefault())});addEvent$R(Series$f,"destroy",seriesProto$3.destroyGroupedData);addEvent$R(Series$f,"afterSetOptions",function(g){var d=g.options,a=this.type,p=this.chart.options.plotOptions,v=DefaultOptions.defaultOptions.plotOptions[a].dataGrouping,C=this.useCommonDataGrouping&&commonOptions;if(specificOptions[a]||C){v||(v=merge$12(commonOptions,specificOptions[a]));var P=this.chart.rangeSelector;d.dataGrouping=merge$12(C,v,p.series&&p.series.dataGrouping,p[a].dataGrouping,this.userOptions.dataGrouping,!d.isInternal&&P&&isNumber$y(P.selected)&&P.buttonOptions[P.selected].dataGrouping)}});addEvent$R(Axis,"afterSetScale",function(){this.series.forEach(function(g){g.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$24=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=(function(g){__extends$24(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.close=void 0,a.high=void 0,a.low=void 0,a.open=void 0,a.options=void 0,a.plotClose=void 0,a.plotOpen=void 0,a.series=void 0,a}return d.prototype.getClassName=function(){return g.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},d.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},d.prototype.resolveColor=function(){g.prototype.resolveColor.call(this),this.resolveUpColor()},d.prototype.getZone=function(){var a=g.prototype.getZone.call(this);return this.resolveUpColor(),a},d.prototype.applyOptions=function(){return g.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},d})(ColumnSeries$g.prototype.pointClass),__extends$23=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$19=Utilities.extend,merge$11=Utilities.merge,OHLCSeries$1=(function(g){__extends$23(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.yData=void 0,a}return d.prototype.drawPoints=function(){var a=this,p=a.points,v=a.chart,C=function(P,k,z){var $=P[0],D=P[1];typeof $[2]=="number"&&($[2]=Math.max(z+k,$[2])),typeof D[2]=="number"&&(D[2]=Math.min(z-k,D[2]))};p.forEach(function(P){var k,z,$,D,F,N=P.graphic,W,j=!N,q;typeof P.plotY<"u"&&(N||(P.graphic=N=v.renderer.path().add(a.group)),v.styledMode||N.attr(a.pointAttribs(P,P.selected&&"select")),q=N.strokeWidth(),$=q%2/2,W=Math.round(P.plotX)-$,D=Math.round(P.shapeArgs.width/2),F=[["M",W,Math.round(P.yBottom)],["L",W,Math.round(P.plotHigh)]],P.open!==null&&(k=Math.round(P.plotOpen)+$,F.push(["M",W,k],["L",W-D,k]),C(F,q/2,k)),P.close!==null&&(z=Math.round(P.plotClose)+$,F.push(["M",W,z],["L",W+D,z]),C(F,q/2,z)),N[j?"attr":"animate"]({d:F}).addClass(P.getClassName(),!0))})},d.prototype.init=function(){g.prototype.init.apply(this,arguments),this.options.stacking=void 0},d.prototype.pointAttribs=function(a,p){var v=g.prototype.pointAttribs.call(this,a,p),C=this.options;return delete v.fill,!a.options.color&&C.upColor&&a.open<a.close&&(v.stroke=C.upColor),v},d.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]},d.prototype.translate=function(){var a=this,p=a.yAxis,v=!!a.modifyValue,C=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];g.prototype.translate.apply(a),a.points.forEach(function(P){[P.open,P.high,P.low,P.close,P.low].forEach(function(k,z){k!==null&&(v&&(k=a.modifyValue(k)),P[C[z]]=p.toPixels(k,!0))}),P.tooltipPos[1]=P.plotHigh+p.pos-a.chart.plotTop})},d.defaultOptions=merge$11(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),d})(ColumnSeries$f);extend$19(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$22=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),defaultOptions$c=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$10=Utilities.merge,CandlestickSeries=(function(g){__extends$22(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.pointAttribs=function(a,p){var v=ColumnSeries$e.prototype.pointAttribs.call(this,a,p),C=this.options,P=a.open<a.close,k=C.lineColor||this.color,z=a.color||this.color,$;return v["stroke-width"]=C.lineWidth,v.fill=a.options.color||P&&C.upColor||z,v.stroke=a.options.lineColor||P&&C.upLineColor||k,p&&($=C.states[p],v.fill=$.color||v.fill,v.stroke=$.lineColor||v.stroke,v["stroke-width"]=$.lineWidth||v["stroke-width"]),v},d.prototype.drawPoints=function(){var a=this,p=a.points,v=a.chart,C=a.yAxis.reversed;p.forEach(function(P){var k=P.graphic,z,$,D,F,N,W,j,q,X,K,ee=!k;typeof P.plotY<"u"&&(k||(P.graphic=k=v.renderer.path().add(a.group)),a.chart.styledMode||k.attr(a.pointAttribs(P,P.selected&&"select")).shadow(a.options.shadow),j=k.strokeWidth()%2/2,q=Math.round(P.plotX)-j,z=P.plotOpen,$=P.plotClose,D=Math.min(z,$),F=Math.max(z,$),K=Math.round(P.shapeArgs.width/2),N=C?F!==P.yBottom:Math.round(D)!==Math.round(P.plotHigh),W=C?Math.round(D)!==Math.round(P.plotHigh):F!==P.yBottom,D=Math.round(D)+j,F=Math.round(F)+j,X=[],X.push(["M",q-K,F],["L",q-K,D],["L",q+K,D],["L",q+K,F],["Z"],["M",q,D],["L",q,N?Math.round(C?P.yBottom:P.plotHigh):D],["M",q,F],["L",q,W?Math.round(C?P.plotHigh:P.yBottom):F]),k[ee?"attr":"animate"]({d:X}).addClass(P.getClassName(),!0))})},d.defaultOptions=merge$10(OHLCSeries.defaultOptions,defaultOptions$c.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$c.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),d})(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$21=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$x=Utilities.isNumber,FlagsPoint=(function(g){__extends$21(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.isValid=function(){return isNumber$x(this.y)||typeof this.y>"u"},d.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey},d})(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$f.prototype,defined$B=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var g=this,d=g.options,a=g.chart,p=g.points,v=p.length-1,C,P,k=d.onSeries,z=k&&a.get(k),$=d.onKey||"y",D=z&&z.options.step,F=z&&z.points,N=F&&F.length,W=a.inverted,j=g.xAxis,q=g.yAxis,X=0,K,ee,te,ie,oe;if(z&&z.visible&&N)for(X=(z.pointXOffset||0)+(z.barW||0)/2,ie=z.currentDataGrouping,ee=F[N-1].x+(ie?ie.totalRange:0),stableSort$4(p,function(ae,le){return ae.x-le.x}),$="plot"+$[0].toUpperCase()+$.substr(1);N--&&p[v]&&(K=F[N],C=p[v],C.y=K.y,!(K.x<=C.x&&typeof K[$]<"u"&&(C.x<=ee&&(C.plotY=K[$],K.x<C.x&&!D&&(te=F[N+1],te&&typeof te[$]<"u"&&(oe=(C.x-K.x)/(te.x-K.x),C.plotY+=oe*(te[$]-K[$]),C.y+=oe*(te.y-K.y)))),v--,N++,v<0))););p.forEach(function(ae,le){var ce;ae.plotX+=X,(typeof ae.plotY>"u"||W)&&(ae.plotX>=0&&ae.plotX<=j.len?W?(ae.plotY=j.translate(ae.x,0,1,0,1),ae.plotX=defined$B(ae.y)?q.translate(ae.y,0,0,0,1):0):ae.plotY=(j.opposite?0:g.yAxis.len)+j.offset:ae.shapeArgs={}),P=p[le-1],P&&P.plotX===ae.plotX&&(typeof P.stackIndex>"u"&&(P.stackIndex=0),ce=P.stackIndex+1),ae.stackIndex=ce}),this.onSeries=z}},symbols$4=SVGRenderer.prototype.symbols;symbols$4.flag=function(g,d,a,p,v){var C=v&&v.anchorX||g,P=v&&v.anchorY||d,k=symbols$4.circle(C-1,P-1,2,2);return k.push(["M",C,P],["L",g,d+p],["L",g,d],["L",g+a,d],["L",g+a,d+p],["L",g,d+p],["Z"]),k};function createPinSymbol(g){symbols$4[g+"pin"]=function(d,a,p,v,C){var P=C&&C.anchorX,k=C&&C.anchorY,z;if(g==="circle"&&v>p&&(d-=Math.round((v-p)/2),p=v),z=symbols$4[g](d,a,p,v),P&&k){var $=P;if(g==="circle")$=d+p/2;else{var D=z[0],F=z[1];D[0]==="M"&&F[0]==="L"&&($=(D[1]+F[1])/2)}var N=a>k?a:a+v;z.push(["M",$,N],["L",P,k]),z=z.concat(symbols$4.circle(P-1,k-1,2,2))}return z}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$4.circlepin,Renderer.prototype.symbols.flag=symbols$4.flag,Renderer.prototype.symbols.squarepin=symbols$4.squarepin);var __extends$20=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$d=H.noop,distribute=R.distribute,Series$c=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$Q=Utilities.addEvent,defined$A=Utilities.defined,extend$18=Utilities.extend,merge$$=Utilities.merge,objectEach$g=Utilities.objectEach,wrap$f=Utilities.wrap,FlagsSeries=(function(g){__extends$20(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.animate=function(a){a&&this.setClip()},d.prototype.drawPoints=function(){var a=this,p=a.points,v=a.chart,C=v.renderer,P,k,z=v.inverted,$=a.options,D=$.y,F,N,W,j,q,X,K,ee,te=a.yAxis,ie={},oe=[],ae;for(N=p.length;N--;)W=p[N],ee=(z?W.plotY:W.plotX)>a.xAxis.len,P=W.plotX,q=W.stackIndex,F=W.options.shape||$.shape,k=W.plotY,typeof k<"u"&&(k=W.plotY+D-(typeof q<"u"&&q*$.stackDistance)),W.anchorX=q?void 0:W.plotX,X=q?void 0:W.plotY,ae=F!=="flag",j=W.graphic,typeof k<"u"&&P>=0&&!ee?(j&&W.hasNewShapeType()&&(j=j.destroy()),j||(j=W.graphic=C.label("",null,null,F,null,null,$.useHTML).addClass("highcharts-point").add(a.markerGroup),W.graphic.div&&(W.graphic.div.point=W),j.isNew=!0),j.attr({align:ae?"center":"left",width:$.width,height:$.height,"text-align":$.textAlign}),v.styledMode||j.attr(a.pointAttribs(W)).css(merge$$($.style,W.style)).shadow($.shadow),P>0&&(P-=j.strokeWidth()%2),K={y:k,anchorY:X},$.allowOverlapX&&(K.x=P,K.anchorX=W.anchorX),j.attr({text:W.options.title||$.title||"A"})[j.isNew?"attr":"animate"](K),$.allowOverlapX||(ie[W.plotX]?ie[W.plotX].size=Math.max(ie[W.plotX].size,j.width):ie[W.plotX]={align:ae?.5:0,size:j.width,target:P,anchorX:P}),W.tooltipPos=[P,k+te.pos-v.plotTop]):j&&(W.graphic=j.destroy());$.allowOverlapX||(objectEach$g(ie,function(le){le.plotX=le.anchorX,oe.push(le)}),distribute(oe,z?te.len:this.xAxis.len,100),p.forEach(function(le){var ce=le.graphic&&ie[le.plotX];ce&&(le.graphic[le.graphic.isNew?"attr":"animate"]({x:ce.pos+ce.align*ce.size,anchorX:le.anchorX}),defined$A(ce.pos)?le.graphic.isNew=!1:(le.graphic.attr({x:-9999,anchorX:-9999}),le.graphic.isNew=!0))})),$.useHTML&&wrap$f(a.markerGroup,"on",function(le){return SVGElement.prototype.on.apply(le.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},d.prototype.drawTracker=function(){var a=this,p=a.points;g.prototype.drawTracker.call(this),p.forEach(function(v){var C=v.graphic;C&&(v.unbindMouseOver&&v.unbindMouseOver(),v.unbindMouseOver=addEvent$Q(C.element,"mouseover",function(){v.stackIndex>0&&!v.raised&&(v._y=C.y,C.attr({y:v._y-8}),v.raised=!0),p.forEach(function(P){P!==v&&P.raised&&P.graphic&&(P.graphic.attr({y:P._y}),P.raised=!1)})}))})},d.prototype.pointAttribs=function(a,p){var v=this.options,C=a&&a.color||this.color,P=v.lineColor,k=a&&a.lineWidth,z=a&&a.fillColor||v.fillColor;return p&&(z=v.states[p].fillColor,P=v.states[p].lineColor,k=v.states[p].lineWidth),{fill:z||C,stroke:P||C,"stroke-width":k||v.lineWidth||0}},d.prototype.setClip=function(){Series$c.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},d.defaultOptions=merge$$(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),d})(ColumnSeries$c);extend$18(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$d,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$c.prototype.init,invertGroups:noop$d,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$P=Utilities.addEvent,defined$z=Utilities.defined,pick$17=Utilities.pick,ScrollbarAxis=(function(){function g(){}return g.compose=function(d,a){if(g.composed.indexOf(d)===-1)g.composed.push(d);else return d;var p=function(v){var C=pick$17(v.options&&v.options.min,v.min),P=pick$17(v.options&&v.options.max,v.max);return{axisMin:C,axisMax:P,scrollMin:defined$z(v.dataMin)?Math.min(C,v.min,v.dataMin,pick$17(v.threshold,1/0)):C,scrollMax:defined$z(v.dataMax)?Math.max(P,v.max,v.dataMax,pick$17(v.threshold,-1/0)):P}};return addEvent$P(d,"afterInit",function(){var v=this;v.options&&v.options.scrollbar&&v.options.scrollbar.enabled&&(v.options.scrollbar.vertical=!v.horiz,v.options.startOnTick=v.options.endOnTick=!1,v.scrollbar=new a(v.chart.renderer,v.options.scrollbar,v.chart),addEvent$P(v.scrollbar,"changed",function(C){var P=p(v),k=P.axisMin,z=P.axisMax,$=P.scrollMin,D=P.scrollMax,F=D-$,N,W;!defined$z(k)||!defined$z(z)||(v.horiz&&!v.reversed||!v.horiz&&v.reversed?(N=$+F*this.to,W=$+F*this.from):(N=$+F*(1-this.from),W=$+F*(1-this.to)),this.shouldUpdateExtremes(C.DOMType)?v.setExtremes(W,N,!0,C.DOMType!=="mousemove"&&C.DOMType!=="touchmove",C):this.setRange(this.from,this.to))}))}),addEvent$P(d,"afterRender",function(){var v=this,C=p(v),P=C.scrollMin,k=C.scrollMax,z=v.scrollbar,$=v.axisTitleMargin+(v.titleOffset||0),D=v.chart.scrollbarsOffsets,F=v.options.margin||0,N,W,j;z&&(v.horiz?(v.opposite||(D[1]+=$),z.position(v.left,v.top+v.height+2+D[1]-(v.opposite?F:0),v.width,v.height),v.opposite||(D[1]+=F),N=1):(v.opposite&&(D[0]+=$),z.position(v.left+v.width+2+D[0]-(v.opposite?0:F),v.top,v.width,v.height),v.opposite&&(D[0]+=F),N=0),D[N]+=z.size+z.options.margin,isNaN(P)||isNaN(k)||!defined$z(v.min)||!defined$z(v.max)||v.min===v.max?z.setRange(0,1):(W=(v.min-P)/(k-P),j=(v.max-P)/(k-P),v.horiz&&!v.reversed||!v.horiz&&v.reversed?z.setRange(W,j):z.setRange(1-j,1-W)))}),addEvent$P(d,"afterGetOffset",function(){var v=this,C=v.horiz?2:1,P=v.scrollbar;P&&(v.chart.scrollbarsOffsets=[0,0],v.chart.axisOffset[C]+=P.size+P.options.margin)}),d},g.composed=[],g})(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$b=DefaultOptions.defaultOptions,addEvent$O=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$y=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$l=Utilities.fireEvent,merge$_=Utilities.merge,pick$16=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=(function(){function g(d,a,p){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(d,a,p)}return g.compose=function(d){ScrollbarAxis.compose(d,g)},g.swapXY=function(d,a){return a&&d.forEach(function(p){for(var v=p.length,C,P=0;P<v;P+=2)C=p[P+1],typeof C=="number"&&(p[P+1]=p[P+2],p[P+2]=C)}),d},g.prototype.addEvents=function(){var d=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,p=this.scrollbarGroup.element,v=this.track.element,C=this.mouseDownHandler.bind(this),P=this.mouseMoveHandler.bind(this),k=this.mouseUpHandler.bind(this),z=[[a[d[0]].element,"click",this.buttonToMinClick.bind(this)],[a[d[1]].element,"click",this.buttonToMaxClick.bind(this)],[v,"click",this.trackClick.bind(this)],[p,"mousedown",C],[p.ownerDocument,"mousemove",P],[p.ownerDocument,"mouseup",k]];H.hasTouch&&z.push([p,"touchstart",C],[p.ownerDocument,"touchmove",P],[p.ownerDocument,"touchend",k]),z.forEach(function($){addEvent$O.apply(null,$)}),this._events=z},g.prototype.buttonToMaxClick=function(d){var a=this,p=(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(a.from+p,a.to+p),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.buttonToMinClick=function(d){var a=this,p=correctFloat$6(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(correctFloat$6(a.from-p),correctFloat$6(a.to-p)),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.cursorToScrollbarPosition=function(d){var a=this,p=a.options,v=p.minWidth>a.calculatedWidth?p.minWidth:0;return{chartX:(d.chartX-a.x-a.xOffset)/(a.barWidth-v),chartY:(d.chartY-a.y-a.yOffset)/(a.barWidth-v)}},g.prototype.destroy=function(){var d=this,a=d.chart.scroller;d.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(p){d[p]&&d[p].destroy&&(d[p]=d[p].destroy())}),a&&d===a.scrollbar&&(a.scrollbar=null,destroyObjectProperties$3(a.scrollbarButtons))},g.prototype.drawScrollbarButton=function(d){var a=this,p=a.renderer,v=a.scrollbarButtons,C=a.options,P=a.size,k=p.g().add(a.group),z;v.push(k),z=p.rect().addClass("highcharts-scrollbar-button").add(k),a.chart.styledMode||z.attr({stroke:C.buttonBorderColor,"stroke-width":C.buttonBorderWidth,fill:C.buttonBackgroundColor}),z.attr(z.crisp({x:-.5,y:-.5,width:P+1,height:P+1,r:C.buttonBorderRadius},z.strokeWidth())),z=p.path(g.swapXY([["M",P/2+(d?-1:1),P/2-3],["L",P/2+(d?-1:1),P/2+3],["L",P/2+(d?2:-2),P/2]],C.vertical)).addClass("highcharts-scrollbar-arrow").add(v[d]),a.chart.styledMode||z.attr({fill:C.buttonArrowColor})},g.prototype.init=function(d,a,p){var v=this;v.scrollbarButtons=[],v.renderer=d,v.userOptions=a,v.options=merge$_(ScrollbarDefaults,defaultOptions$b.scrollbar,a),v.chart=p,v.size=pick$16(v.options.size,v.options.height),a.enabled&&(v.render(),v.addEvents())},g.prototype.mouseDownHandler=function(d){var a=this,p=a.chart.pointer.normalize(d),v=a.cursorToScrollbarPosition(p);a.chartX=v.chartX,a.chartY=v.chartY,a.initPositions=[a.from,a.to],a.grabbedCenter=!0},g.prototype.mouseMoveHandler=function(d){var a=this,p=a.chart.pointer.normalize(d),v=a.options,C=v.vertical?"chartY":"chartX",P=a.initPositions||[],k,z,$;a.grabbedCenter&&(!d.touches||d.touches[0][C]!==0)&&(z=a.cursorToScrollbarPosition(p)[C],k=a[C],$=z-k,a.hasDragged=!0,a.updatePosition(P[0]+$,P[1]+$),a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}))},g.prototype.mouseUpHandler=function(d){var a=this;a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:d.type,DOMEvent:d}),a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null},g.prototype.position=function(d,a,p,v){var C=this,P=C.options,k=P.vertical,z=C.rendered?"animate":"attr",$=v,D=0;C.x=d,C.y=a+this.trackBorderWidth,C.width=p,C.height=v,C.xOffset=$,C.yOffset=D,k?(C.width=C.yOffset=p=D=C.size,C.xOffset=$=0,C.barWidth=v-p*2,C.x=d=d+C.options.margin):(C.height=C.xOffset=v=$=C.size,C.barWidth=p-v*2,C.y=C.y+C.options.margin),C.group[z]({translateX:d,translateY:C.y}),C.track[z]({width:p,height:v}),C.scrollbarButtons[1][z]({translateX:k?0:p-$,translateY:k?v-D:0})},g.prototype.removeEvents=function(){this._events.forEach(function(d){removeEvent$4.apply(null,d)}),this._events.length=0},g.prototype.render=function(){var d=this,a=d.renderer,p=d.options,v=d.size,C=d.chart.styledMode,P=a.g("scrollbar").attr({zIndex:p.zIndex,translateY:-99999}).add();d.group=P,d.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:p.trackBorderRadius||0,height:v,width:v}).add(P),C||d.track.attr({fill:p.trackBackgroundColor,stroke:p.trackBorderColor,"stroke-width":p.trackBorderWidth}),d.trackBorderWidth=d.track.strokeWidth(),d.track.attr({y:-this.trackBorderWidth%2/2}),d.scrollbarGroup=a.g().add(P),d.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:v,width:v,r:p.barBorderRadius||0}).add(d.scrollbarGroup),d.scrollbarRifles=a.path(g.swapXY([["M",-3,v/4],["L",-3,2*v/3],["M",0,v/4],["L",0,2*v/3],["M",3,v/4],["L",3,2*v/3]],p.vertical)).addClass("highcharts-scrollbar-rifles").add(d.scrollbarGroup),C||(d.scrollbar.attr({fill:p.barBackgroundColor,stroke:p.barBorderColor,"stroke-width":p.barBorderWidth}),d.scrollbarRifles.attr({stroke:p.rifleColor,"stroke-width":1})),d.scrollbarStrokeWidth=d.scrollbar.strokeWidth(),d.scrollbarGroup.translate(-d.scrollbarStrokeWidth%2/2,-d.scrollbarStrokeWidth%2/2),d.drawScrollbarButton(0),d.drawScrollbarButton(1)},g.prototype.setRange=function(d,a){var p=this,v=p.options,C=v.vertical,P=v.minWidth,k=p.barWidth,z=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$y(k)){var $=k*Math.min(a,1),D,F;d=Math.max(d,0),D=Math.ceil(k*d),p.calculatedWidth=F=correctFloat$6($-D),F<P&&(D=(k-P+F)*d,F=P);var N=Math.floor(D+p.xOffset+p.yOffset),W=F/2-.5;p.from=d,p.to=a,C?(p.scrollbarGroup[z]({translateY:N}),p.scrollbar[z]({height:F}),p.scrollbarRifles[z]({translateY:W}),p.scrollbarTop=N,p.scrollbarLeft=0):(p.scrollbarGroup[z]({translateX:N}),p.scrollbar[z]({width:F}),p.scrollbarRifles[z]({translateX:W}),p.scrollbarLeft=N,p.scrollbarTop=0),F<=12?p.scrollbarRifles.hide():p.scrollbarRifles.show(!0),v.showFull===!1&&(d<=0&&a>=1?p.group.hide():p.group.show()),p.rendered=!0}},g.prototype.shouldUpdateExtremes=function(d){return pick$16(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||d==="mouseup"||d==="touchend"||!defined$y(d)},g.prototype.trackClick=function(d){var a=this,p=a.chart.pointer.normalize(d),v=a.to-a.from,C=a.y+a.scrollbarTop,P=a.x+a.scrollbarLeft;a.options.vertical&&p.chartY>C||!a.options.vertical&&p.chartX>P?a.updatePosition(a.from+v,a.to+v):a.updatePosition(a.from-v,a.to-v),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:d})},g.prototype.update=function(d){this.destroy(),this.init(this.chart.renderer,merge$_(!0,this.options,d),this.chart)},g.prototype.updatePosition=function(d,a){a>1&&(d=correctFloat$6(1-correctFloat$6(a-d)),a=1),d<0&&(a=correctFloat$6(a-d),d=0),this.from=d,this.to=a},g.defaultOptions=ScrollbarDefaults,g})();defaultOptions$b.scrollbar=merge$_(!0,Scrollbar.defaultOptions,defaultOptions$b.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$N=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$x=Utilities.defined,isNumber$w=Utilities.isNumber,pick$15=Utilities.pick,NavigatorAxisAdditions=(function(){function g(d){this.axis=d}return g.prototype.destroy=function(){this.axis=void 0},g.prototype.toFixedRange=function(d,a,p,v){var C=this,P=C.axis,k=P.chart,z=k&&k.fixedRange,$=(P.pointRange||0)/2,D=pick$15(p,P.translate(d,!0,!P.horiz)),F=pick$15(v,P.translate(a,!0,!P.horiz)),N=z&&(F-D)/z;return defined$x(p)||(D=correctFloat$5(D+$)),defined$x(v)||(F=correctFloat$5(F-$)),N>.7&&N<1.3&&(v?D=F-z:F=D+z),(!isNumber$w(D)||!isNumber$w(F))&&(D=F=void 0),{min:D,max:F}},g})(),NavigatorAxis=(function(){function g(){}return g.compose=function(d){d.keepProps.push("navigatorAxis"),addEvent$N(d,"init",function(){var a=this;a.navigatorAxis||(a.navigatorAxis=new NavigatorAxisAdditions(a))}),addEvent$N(d,"zoom",function(a){var p=this,v=p.chart,C=v.options,P=C.navigator,k=p.navigatorAxis,z=C.chart.pinchType,$=C.rangeSelector,D=C.chart.zoomType,F;p.isXAxis&&(P&&P.enabled||$&&$.enabled)&&(D==="y"?a.zoomed=!1:(!isTouchDevice$2&&D==="xy"||isTouchDevice$2&&z==="xy")&&p.options.range&&(F=k.previousZoom,defined$x(a.newMin)?k.previousZoom=[p.min,p.max]:F&&(a.newMin=F[0],a.newMax=F[1],k.previousZoom=void 0))),typeof a.zoomed<"u"&&a.preventDefault()})},g.AdditionsClass=NavigatorAxisAdditions,g})(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$a=DefaultOptions.defaultOptions,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$M=Utilities.addEvent,clamp$c=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$w=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$2=Utilities.erase,extend$17=Utilities.extend,find$e=Utilities.find,isArray$b=Utilities.isArray,isNumber$v=Utilities.isNumber,merge$Z=Utilities.merge,pick$14=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$b=Utilities.splat,defaultSeriesType,numExt=function(g){for(var d=[],a=1;a<arguments.length;a++)d[a-1]=arguments[a];var p=[].filter.call(d,isNumber$v);if(p.length)return Math[g].apply(0,p)};defaultSeriesType=typeof seriesTypes$6.areaspline>"u"?"line":"areaspline";extend$17(defaultOptions$a,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(g,d,a,p,v){var C=(v&&v.width||0)/2,P=Math.round(C/3)+.5,k=v&&v.height||0;return[["M",-C-1,.5],["L",C,.5],["L",C,k+.5],["L",-C-1,k+.5],["L",-C-1,.5],["M",-P,4],["L",-P,k-3],["M",P-1,4],["L",P-1,k-3]]};var Navigator=(function(){function g(d){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(d)}return g.prototype.drawHandle=function(d,a,p,v){var C=this,P=C.navigatorOptions.handles.height;C.handles[a][v](p?{translateX:Math.round(C.left+C.height/2),translateY:Math.round(C.top+parseInt(d,10)+.5-P)}:{translateX:Math.round(C.left+parseInt(d,10)),translateY:Math.round(C.top+C.height/2-P/2-1)})},g.prototype.drawOutline=function(d,a,p,v){var C=this,P=C.navigatorOptions.maskInside,k=C.outline.strokeWidth(),z=k/2,$=k%2/2,D=C.outlineHeight,F=C.scrollbarHeight||0,N=C.size,W=C.left-F,j=C.top,q,X;p?(W-=z,q=j+a+$,a=j+d+$,X=[["M",W+D,j-F-$],["L",W+D,q],["L",W,q],["L",W,a],["L",W+D,a],["L",W+D,j+N+F]],P&&X.push(["M",W+D,q-z],["L",W+D,a+z])):(d+=W+F-$,a+=W+F-$,j+=z,X=[["M",W,j],["L",d,j],["L",d,j+D],["L",a,j+D],["L",a,j],["L",W+N+F*2,j]],P&&X.push(["M",d-z,j],["L",a+z,j])),C.outline[v]({d:X})},g.prototype.drawMasks=function(d,a,p,v){var C=this,P=C.left,k=C.top,z=C.height,$,D,F,N;p?(F=[P,P,P],N=[k,k+d,k+a],D=[z,z,z],$=[d,a-d,C.size-a]):(F=[P,P+d,P+a],N=[k,k,k],D=[d,a-d,C.size-a],$=[z,z,z]),C.shades.forEach(function(W,j){W[v]({x:F[j],y:N[j],width:D[j],height:$[j]})})},g.prototype.renderElements=function(){var d=this,a=d.navigatorOptions,p=a.maskInside,v=d.chart,C=v.inverted,P=v.renderer,k,z={cursor:C?"ns-resize":"ew-resize"};d.navigatorGroup=k=P.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!p,p,!p].forEach(function($,D){d.shades[D]=P.rect().addClass("highcharts-navigator-mask"+(D===1?"-inside":"-outside")).add(k),v.styledMode||d.shades[D].attr({fill:$?a.maskFill:"rgba(0,0,0,0)"}).css(D===1&&z)}),d.outline=P.path().addClass("highcharts-navigator-outline").add(k),v.styledMode||d.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor}),a.handles.enabled&&[0,1].forEach(function($){if(a.handles.inverted=v.inverted,d.handles[$]=P.symbol(a.handles.symbols[$],-a.handles.width/2-1,0,a.handles.width,a.handles.height,a.handles),d.handles[$].attr({zIndex:7-$}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][$]).add(k),!v.styledMode){var D=a.handles;d.handles[$].attr({fill:D.backgroundColor,stroke:D.borderColor,"stroke-width":D.lineWidth}).css(z)}})},g.prototype.update=function(d){(this.series||[]).forEach(function(p){p.baseSeries&&delete p.baseSeries.navigatorSeries}),this.destroy();var a=this.chart.options;merge$Z(!0,a.navigator,this.options,d),this.init(this.chart)},g.prototype.render=function(d,a,p,v){var C=this,P=C.chart,k,z,$,D=C.scrollbarHeight,F,N=C.xAxis,W=N.pointRange||0,j=N.navigatorAxis.fake?P.xAxis[0]:N,q=C.navigatorEnabled,X,K,ee=C.rendered,te=P.inverted,ie,oe,ae,le,ce=P.xAxis[0].minRange,ue=P.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$w(p))){if(d=correctFloat$4(d-W/2),a=correctFloat$4(a+W/2),!isNumber$v(d)||!isNumber$v(a))if(ee)p=0,v=pick$14(N.width,j.width);else return;C.left=pick$14(N.left,P.plotLeft+D+(te?P.plotWidth:0)),C.size=K=F=pick$14(N.len,(te?P.plotHeight:P.plotWidth)-2*D),te?k=D:k=F+2*D,p=pick$14(p,N.toPixels(d,!0)),v=pick$14(v,N.toPixels(a,!0)),(!isNumber$v(p)||Math.abs(p)===1/0)&&(p=0,v=k),oe=N.toValue(p,!0),ae=N.toValue(v,!0),le=Math.abs(correctFloat$4(ae-oe)),le<ce?this.grabbedLeft?p=N.toPixels(ae-ce-W,!0):this.grabbedRight&&(v=N.toPixels(oe+ce+W,!0)):defined$w(ue)&&correctFloat$4(le-W)>ue&&(this.grabbedLeft?p=N.toPixels(ae-ue-W,!0):this.grabbedRight&&(v=N.toPixels(oe+ue+W,!0))),C.zoomedMax=clamp$c(Math.max(p,v),0,K),C.zoomedMin=clamp$c(C.fixedWidth?C.zoomedMax-C.fixedWidth:Math.min(p,v),0,K),C.range=C.zoomedMax-C.zoomedMin,K=Math.round(C.zoomedMax),X=Math.round(C.zoomedMin),q&&(C.navigatorGroup.attr({visibility:"visible"}),ie=ee&&!C.hasDragged?"animate":"attr",C.drawMasks(X,K,te,ie),C.drawOutline(X,K,te,ie),C.navigatorOptions.handles.enabled&&(C.drawHandle(X,0,te,ie),C.drawHandle(K,1,te,ie))),C.scrollbar&&(te?($=C.top-D,z=C.left-D+(q||!j.opposite?0:(j.titleOffset||0)+j.axisTitleMargin),D=F+2*D):($=C.top+(q?C.height:-D),z=C.left-D),C.scrollbar.position(z,$,k,D),C.scrollbar.setRange(C.zoomedMin/(F||1),C.zoomedMax/(F||1))),C.rendered=!0}},g.prototype.addMouseEvents=function(){var d=this,a=d.chart,p=a.container,v=[],C,P;d.mouseMoveHandler=C=function(k){d.onMouseMove(k)},d.mouseUpHandler=P=function(k){d.onMouseUp(k)},v=d.getPartsEvents("mousedown"),v.push(addEvent$M(a.renderTo,"mousemove",C),addEvent$M(p.ownerDocument,"mouseup",P)),hasTouch&&(v.push(addEvent$M(a.renderTo,"touchmove",C),addEvent$M(p.ownerDocument,"touchend",P)),v.concat(d.getPartsEvents("touchstart"))),d.eventsToUnbind=v,d.series&&d.series[0]&&v.push(addEvent$M(d.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},g.prototype.getPartsEvents=function(d){var a=this,p=[];return["shades","handles"].forEach(function(v){a[v].forEach(function(C,P){p.push(addEvent$M(C.element,d,function(k){a[v+"Mousedown"](k,P)}))})}),p},g.prototype.shadesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var p=this,v=p.chart,C=p.xAxis,P=p.zoomedMin,k=p.left,z=p.size,$=p.range,D=d.chartX,F,N,W,j;v.inverted&&(D=d.chartY,k=p.top),a===1?(p.grabbedCenter=D,p.fixedWidth=$,p.dragOffset=D-P):(j=D-k-$/2,a===0?j=Math.max(0,j):a===2&&j+$>=z&&(j=z-$,p.reversedExtremes?(j-=$,N=p.getUnionExtremes().dataMin):F=p.getUnionExtremes().dataMax),j!==P&&(p.fixedWidth=$,W=C.navigatorAxis.toFixedRange(j,j+$,N,F),defined$w(W.min)&&v.xAxis[0].setExtremes(Math.min(W.min,W.max),Math.max(W.min,W.max),!0,null,{trigger:"navigator"})))},g.prototype.handlesMousedown=function(d,a){d=this.chart.pointer.normalize(d);var p=this,v=p.chart,C=v.xAxis[0],P=p.reversedExtremes;a===0?(p.grabbedLeft=!0,p.otherHandlePos=p.zoomedMax,p.fixedExtreme=P?C.min:C.max):(p.grabbedRight=!0,p.otherHandlePos=p.zoomedMin,p.fixedExtreme=P?C.max:C.min),v.fixedRange=null},g.prototype.onMouseMove=function(d){var a=this,p=a.chart,v=a.left,C=a.navigatorSize,P=a.range,k=a.dragOffset,z=p.inverted,$;(!d.touches||d.touches[0].pageX!==0)&&(d=p.pointer.normalize(d),$=d.chartX,z&&(v=a.top,$=d.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,$-v,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,$-v)):a.grabbedCenter&&(a.hasDragged=!0,$<k?$=k:$>C+k-P&&($=C+k-P),a.render(0,0,$-k,$-k+P)),a.hasDragged&&a.scrollbar&&pick$14(a.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(d.DOMType=d.type,setTimeout(function(){a.onMouseUp(d)},0)))},g.prototype.onMouseUp=function(d){var a=this,p=a.chart,v=a.xAxis,C=a.scrollbar,P=d.DOMEvent||d,k=p.inverted,z=a.rendered&&!a.hasDragged?"animate":"attr",$,D,F,N,W,j;(a.hasDragged&&(!C||!C.hasDragged)||d.trigger==="scrollbar")&&(F=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?N=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(W=a.fixedExtreme),a.zoomedMax===a.size&&(W=a.reversedExtremes?F.dataMin:F.dataMax),a.zoomedMin===0&&(N=a.reversedExtremes?F.dataMax:F.dataMin),j=v.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,N,W),defined$w(j.min)&&p.xAxis[0].setExtremes(Math.min(j.min,j.max),Math.max(j.min,j.max),!0,a.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:P})),d.DOMType!=="mousemove"&&d.DOMType!=="touchmove"&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber$v(a.zoomedMin)&&isNumber$v(a.zoomedMax)&&(D=Math.round(a.zoomedMin),$=Math.round(a.zoomedMax),a.shades&&a.drawMasks(D,$,k,z),a.outline&&a.drawOutline(D,$,k,z),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(D,0,k,z),a.drawHandle($,1,k,z)))},g.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(d){d()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},g.prototype.removeBaseSeriesEvents=function(){var d=this.baseSeries||[];this.navigatorEnabled&&d[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&d.forEach(function(a){removeEvent$3(a,"updatedData",this.updatedDataHandler)},this),d[0].xAxis&&removeEvent$3(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},g.prototype.init=function(d){var a=d.options,p=a.navigator,v=p.enabled,C=a.scrollbar,P=C.enabled,k=v?p.height:0,z=P?C.height:0;this.handles=[],this.shades=[],this.chart=d,this.setBaseSeries(),this.height=k,this.scrollbarHeight=z,this.scrollbarEnabled=P,this.navigatorEnabled=v,this.navigatorOptions=p,this.scrollbarOptions=C,this.outlineHeight=k+z,this.opposite=pick$14(p.opposite,!!(!v&&d.inverted));var $=this,D=$.baseSeries,F=d.xAxis.length,N=d.yAxis.length,W=D&&D[0]&&D[0].xAxis||d.xAxis[0]||{options:{}};d.isDirtyBox=!0,$.navigatorEnabled?($.xAxis=new Axis(d,merge$Z({breaks:W.options.breaks,ordinal:W.options.ordinal},p.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:F,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},d.inverted?{offsets:[z,0,-z,0],width:k}:{offsets:[0,-z,0,z],height:k})),$.yAxis=new Axis(d,merge$Z(p.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:N,isInternal:!0,reversed:pick$14(p.yAxis&&p.yAxis.reversed,d.yAxis[0]&&d.yAxis[0].reversed,!1),zoomEnabled:!1},d.inverted?{width:k}:{height:k})),D||p.series.data?$.updateNavigatorSeries(!1):d.series.length===0&&($.unbindRedraw=addEvent$M(d,"beforeRedraw",function(){d.series.length>0&&!$.series&&($.setBaseSeries(),$.unbindRedraw())})),$.reversedExtremes=d.inverted&&!$.xAxis.reversed||!d.inverted&&$.xAxis.reversed,$.renderElements(),$.addMouseEvents()):($.xAxis={chart:d,navigatorAxis:{fake:!0},translate:function(j,q){var X=d.xAxis[0],K=X.getExtremes(),ee=X.len-2*z,te=numExt("min",X.options.min,K.dataMin),ie=numExt("max",X.options.max,K.dataMax)-te;return q?j*ie/ee+te:ee*(j-te)/ie},toPixels:function(j){return this.translate(j)},toValue:function(j){return this.translate(j,!0)}},$.xAxis.navigatorAxis.axis=$.xAxis,$.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind($.xAxis.navigatorAxis)),d.options.scrollbar.enabled&&(d.scrollbar=$.scrollbar=new Scrollbar(d.renderer,merge$Z(d.options.scrollbar,{margin:$.navigatorEnabled?0:10,vertical:d.inverted}),d),addEvent$M($.scrollbar,"changed",function(j){var q=$.size,X=q*this.to,K=q*this.from;$.hasDragged=$.scrollbar.hasDragged,$.render(0,0,K,X),this.shouldUpdateExtremes(j.DOMType)&&setTimeout(function(){$.onMouseUp(j)})})),$.addBaseSeriesEvents(),$.addChartEvents()},g.prototype.getUnionExtremes=function(d){var a=this.chart.xAxis[0],p=this.xAxis,v=p.options,C=a.options,P;return(!d||a.dataMin!==null)&&(P={dataMin:pick$14(v&&v.min,numExt("min",C.min,a.dataMin,p.dataMin,p.min)),dataMax:pick$14(v&&v.max,numExt("max",C.max,a.dataMax,p.dataMax,p.max))}),P},g.prototype.setBaseSeries=function(d,a){var p=this.chart,v=this.baseSeries=[];d=d||p.options&&p.options.navigator.baseSeries||(p.series.length?find$e(p.series,function(C){return!C.options.isInternal}).index:0),(p.series||[]).forEach(function(C,P){!C.options.isInternal&&(C.options.showInNavigator||(P===d||C.options.id===d)&&C.options.showInNavigator!==!1)&&v.push(C)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)},g.prototype.updateNavigatorSeries=function(d,a){var p=this,v=p.chart,C=p.baseSeries,P,k,z=p.navigatorOptions.series,$,D={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},F=p.series=(p.series||[]).filter(function(N){var W=N.baseSeries;return C.indexOf(W)<0?(W&&(removeEvent$3(W,"updatedData",p.updatedDataHandler),delete W.navigatorSeries),N.chart&&N.destroy(),!1):!0});C&&C.length&&C.forEach(function(W){var j=W.navigatorSeries,q=extend$17({color:W.color,visible:W.visible},isArray$b(z)?defaultOptions$a.navigator.series:z);if(!(j&&p.navigatorOptions.adaptToUpdatedData===!1)){D.name="Navigator "+C.length,P=W.options||{},$=P.navigatorOptions||{},q.dataLabels=splat$b(q.dataLabels),k=merge$Z(P,D,q,$),k.pointRange=pick$14(q.pointRange,$.pointRange,defaultOptions$a.plotOptions[k.type||"line"].pointRange);var X=$.data||q.data;p.hasNavigatorData=p.hasNavigatorData||!!X,k.data=X||P.data&&P.data.slice(0),j&&j.options?j.update(k,a):(W.navigatorSeries=v.initSeries(k),W.navigatorSeries.baseSeries=W,F.push(W.navigatorSeries))}}),(z.data&&!(C&&C.length)||isArray$b(z))&&(p.hasNavigatorData=!1,z=splat$b(z),z.forEach(function(N,W){D.name="Navigator "+(F.length+1),k=merge$Z(defaultOptions$a.navigator.series,{color:v.series[W]&&!v.series[W].options.isInternal&&v.series[W].color||v.options.colors[W]||v.options.colors[0]},D,N),k.data=N.data,k.data&&(p.hasNavigatorData=!0,F.push(v.initSeries(k)))})),d&&this.addBaseSeriesEvents()},g.prototype.addBaseSeriesEvents=function(){var d=this,a=d.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(addEvent$M(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),a.forEach(function(p){p.eventsToUnbind.push(addEvent$M(p,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),p.eventsToUnbind.push(addEvent$M(p,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&p.xAxis&&p.eventsToUnbind.push(addEvent$M(p,"updatedData",this.updatedDataHandler)),p.eventsToUnbind.push(addEvent$M(p,"remove",function(){this.navigatorSeries&&(erase$2(d.series,this.navigatorSeries),defined$w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},g.prototype.getBaseSeriesMin=function(d){return this.baseSeries.reduce(function(a,p){return Math.min(a,p.xData?p.xData[0]:a)},d)},g.prototype.modifyNavigatorAxisExtremes=function(){var d=this.xAxis,a;typeof d.getExtremes<"u"&&(a=this.getUnionExtremes(!0),a&&(a.dataMin!==d.min||a.dataMax!==d.max)&&(d.min=a.dataMin,d.max=a.dataMax))},g.prototype.modifyBaseAxisExtremes=function(){var d=this,a=d.chart.navigator,p=d.getExtremes(),v=p.min,C=p.max,P=p.dataMin,k=p.dataMax,z=C-v,$=a.stickToMin,D=a.stickToMax,F=pick$14(d.options.overscroll,0),N,W,j=a.series&&a.series[0],q=!!d.setExtremes,X=d.eventArgs&&d.eventArgs.trigger==="rangeSelectorButton";X||($&&(W=P,N=W+z),D&&(N=k+F,$||(W=Math.max(P,N-z,a.getBaseSeriesMin(j&&j.xData?j.xData[0]:-Number.MAX_VALUE)))),q&&($||D)&&isNumber$v(W)&&(d.min=d.userMin=W,d.max=d.userMax=N)),a.stickToMin=a.stickToMax=null},g.prototype.updatedDataHandler=function(){var d=this.chart.navigator,a=this,p=this.navigatorSeries;d.stickToMax=d.reversedExtremes?Math.round(d.zoomedMin)===0:Math.round(d.zoomedMax)>=Math.round(d.size),d.stickToMin=d.shouldStickToMin(a,d),p&&!d.hasNavigatorData&&(p.options.pointStart=a.xData[0],p.setData(a.options.data,!1,null,!1))},g.prototype.shouldStickToMin=function(d,a){var p=a.getBaseSeriesMin(d.xData[0]),v=d.xAxis,C=v.max,P=v.min,k=v.options.range,z=!0;return isNumber$v(C)&&isNumber$v(P)?k&&C-p>0?z=C-p<k&&!this.chart.fixedRange:z=P<=p:z=!1,z},g.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$M(this.chart,"redraw",function(){var d=this.navigator,a=d&&(d.baseSeries&&d.baseSeries[0]&&d.baseSeries[0].xAxis||this.xAxis[0]);a&&d.render(a.min,a.max)}),addEvent$M(this.chart,"getMargins",function(){var d=this,a=d.navigator,p=a.opposite?"plotTop":"marginBottom";d.inverted&&(p=a.opposite?"marginRight":"plotLeft"),d[p]=(d[p]||0)+(a.navigatorEnabled||!d.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},g.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$2(this.chart.xAxis,this.xAxis),erase$2(this.chart.axes,this.xAxis)),this.yAxis&&(erase$2(this.chart.yAxis,this.yAxis),erase$2(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(d){d.destroy&&d.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(d){this[d]&&this[d].destroy&&this[d].destroy(),this[d]=null},this),[this.handles].forEach(function(d){destroyObjectProperties$2(d)},this)},g})();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$M(Chart$1,"beforeShowResetZoom",function(){var g=this.options,d=g.navigator,a=g.rangeSelector;if((d&&d.enabled||a&&a.enabled)&&(!isTouchDevice$1&&g.chart.zoomType==="x"||isTouchDevice$1&&g.chart.pinchType==="x"))return!1}),addEvent$M(Chart$1,"beforeRender",function(){var g=this.options;(g.navigator.enabled||g.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$M(Chart$1,"afterSetChartSize",function(){var g=this.legend,d=this.navigator,a,p,v,C;d&&(p=g&&g.options,v=d.xAxis,C=d.yAxis,a=d.scrollbarHeight,this.inverted?(d.left=d.opposite?this.chartWidth-a-d.height:this.spacing[3]+a,d.top=this.plotTop+a):(d.left=pick$14(v.left,this.plotLeft+a),d.top=d.navigatorOptions.top||this.chartHeight-d.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(p&&p.verticalAlign==="bottom"&&p.layout!=="proximate"&&p.enabled&&!p.floating?g.legendHeight+pick$14(p.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),v&&C&&(this.inverted?v.options.left=C.options.left=d.left:v.options.top=C.options.top=d.top,v.setAxisSize(),C.setAxisSize()))}),addEvent$M(Chart$1,"update",function(g){var d=g.options.navigator||{},a=g.options.scrollbar||{};!this.navigator&&!this.scroller&&(d.enabled||a.enabled)&&(merge$Z(!0,this.options.navigator,d),merge$Z(!0,this.options.scrollbar,a),delete g.options.navigator,delete g.options.scrollbar)}),addEvent$M(Chart$1,"afterUpdate",function(g){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$14(g.redraw,!0)&&this.redraw(g.animation))}),addEvent$M(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$M(Series$f,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(g){var d,a=g.navigator;a&&g.xAxis[0]&&(d=g.xAxis[0].getExtremes(),a.render(d.min,d.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$9=DefaultOptions.defaultOptions,addEvent$L=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$v=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$16=Utilities.extend,find$d=Utilities.find,fireEvent$k=Utilities.fireEvent,isNumber$u=Utilities.isNumber,merge$Y=Utilities.merge,objectEach$f=Utilities.objectEach,pad=Utilities.pad,pick$13=Utilities.pick,pInt$3=Utilities.pInt,splat$a=Utilities.splat;extend$16(defaultOptions$9,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$16(defaultOptions$9.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=(function(){function g(d){this.buttons=void 0,this.buttonOptions=g.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=d,this.init(d)}return g.prototype.clickButton=function(d,a){var p=this,v=p.chart,C=p.buttonOptions[d],P=v.xAxis[0],k=v.scroller&&v.scroller.getUnionExtremes()||P||{},z=k.dataMin,$=k.dataMax,D,F=P&&Math.round(Math.min(P.max,pick$13($,P.max))),N=C.type,W,j=C._range,q,X,K,ee,te,ie=C.dataGrouping;if(!(z===null||$===null)){if(v.fixedRange=j,p.setSelected(d),ie&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(P||{chart:this.chart},ie,!1),this.frozenStates=C.preserveDataGrouping),N==="month"||N==="year")P?(ee={range:C,max:F,chart:v,dataMin:z,dataMax:$},D=P.minFromRange.call(ee),isNumber$u(ee.newMax)&&(F=ee.newMax)):j=C;else if(j)D=Math.max(F-j,z),F=Math.min(D+j,$);else if(N==="ytd")if(P)typeof $>"u"&&(z=Number.MAX_VALUE,$=Number.MIN_VALUE,v.series.forEach(function(oe){var ae=oe.xData;z=Math.min(ae[0],z),$=Math.max(ae[ae.length-1],$)}),a=!1),te=p.getYTDExtremes($,z,v.time.useUTC),D=q=te.min,F=te.max;else{p.deferredYTDClick=d;return}else N==="all"&&P&&(v.navigator&&v.navigator.baseSeries[0]&&(v.navigator.baseSeries[0].xAxis.options.range=void 0),D=z,F=$);defined$v(D)&&(D+=C._offsetMin),defined$v(F)&&(F+=C._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=d+1),P?P.setExtremes(D,F,pick$13(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:C}):(W=splat$a(v.options.xAxis)[0],K=W.range,W.range=j,X=W.min,W.min=q,addEvent$L(v,"load",function(){W.range=K,W.min=X})),fireEvent$k(this,"afterBtnClick")}},g.prototype.setSelected=function(d){this.selected=this.options.selected=d},g.prototype.init=function(d){var a=this,p=d.options.rangeSelector,v=p.buttons||a.defaultButtons.slice(),C=p.selected,P=function(){var k=a.minInput,z=a.maxInput;k&&k.blur&&fireEvent$k(k,"blur"),z&&z.blur&&fireEvent$k(z,"blur")};a.chart=d,a.options=p,a.buttons=[],a.buttonOptions=v,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$L(d.container,"mousedown",P)),this.eventsToUnbind.push(addEvent$L(d,"resize",P)),v.forEach(a.computeButtonRange),typeof C<"u"&&v[C]&&this.clickButton(C,!1),this.eventsToUnbind.push(addEvent$L(d,"load",function(){d.xAxis&&d.xAxis[0]&&addEvent$L(d.xAxis[0],"setExtremes",function(k){this.max-this.min!==d.fixedRange&&k.trigger!=="rangeSelectorButton"&&k.trigger!=="updatedData"&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))},g.prototype.updateButtonStates=function(){var d=this,a=this.chart,p=this.dropdown,v=a.xAxis[0],C=Math.round(v.max-v.min),P=!v.hasVisibleSeries,k=24*36e5,z=a.scroller&&a.scroller.getUnionExtremes()||v,$=z.dataMin,D=z.dataMax,F=d.getYTDExtremes(D,$,a.time.useUTC),N=F.min,W=F.max,j=d.selected,q=isNumber$u(j),X=d.options.allButtonsEnabled,K=d.buttons;d.buttonOptions.forEach(function(ee,te){var ie=ee._range,oe=ee.type,ae=ee.count||1,le=K[te],ce=0,ue,ge,ye=ee._offsetMax-ee._offsetMin,we=te===j,ve=ie>D-$,be=ie<v.minRange,_e=!1,Ce=!1,Ee=ie===C;(oe==="month"||oe==="year")&&C+36e5>={month:28,year:365}[oe]*k*ae-ye&&C-36e5<={month:31,year:366}[oe]*k*ae+ye?Ee=!0:oe==="ytd"?(Ee=W-N+ye===C,_e=!we):oe==="all"&&(Ee=v.max-v.min>=D-$,Ce=!we&&q&&Ee),ue=!X&&(ve||be||Ce||P),ge=we&&Ee||Ee&&!q&&!_e||we&&d.frozenStates,ue?ce=3:ge&&(q=!0,ce=2),le.state!==ce&&(le.setState(ce),p&&(p.options[te+1].disabled=ue,ce===2&&(p.selectedIndex=te+1)),ce===0&&j===te&&d.setSelected())})},g.prototype.computeButtonRange=function(d){var a=d.type,p=d.count||1,v={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:168*3600*1e3};v[a]?d._range=v[a]*p:(a==="month"||a==="year")&&(d._range={month:30,year:365}[a]*24*36e5*p),d._offsetMin=pick$13(d.offsetMin,0),d._offsetMax=pick$13(d.offsetMax,0),d._range+=d._offsetMax-d._offsetMin},g.prototype.getInputValue=function(d){var a=d==="min"?this.minInput:this.maxInput,p=this.chart.options.rangeSelector,v=this.chart.time;return a?(a.type==="text"&&p.inputDateParser||this.defaultInputDateParser)(a.value,v.useUTC,v):0},g.prototype.setInputValue=function(d,a){var p=this.options,v=this.chart.time,C=d==="min"?this.minInput:this.maxInput,P=d==="min"?this.minDateBox:this.maxDateBox;if(C){var k=C.getAttribute("data-hc-time"),z=defined$v(k)?Number(k):void 0;if(defined$v(a)){var $=z;defined$v($)&&C.setAttribute("data-hc-time-previous",$),C.setAttribute("data-hc-time",a),z=a}C.value=v.dateFormat(this.inputTypeFormats[C.type]||p.inputEditDateFormat,z),P&&P.attr({text:v.dateFormat(p.inputDateFormat,z)})}},g.prototype.setInputExtremes=function(d,a,p){var v=d==="min"?this.minInput:this.maxInput;if(v){var C=this.inputTypeFormats[v.type],P=this.chart.time;if(C){var k=P.dateFormat(C,a);v.min!==k&&(v.min=k);var z=P.dateFormat(C,p);v.max!==z&&(v.max=z)}}},g.prototype.showInput=function(d){var a=d==="min"?this.minDateBox:this.maxDateBox,p=d==="min"?this.minInput:this.maxInput;if(p&&a&&this.inputGroup){var v=p.type==="text",C=this.inputGroup,P=C.translateX,k=C.translateY,z=this.options.inputBoxWidth;css$2(p,{width:v?a.width+(z?-2:20)+"px":"auto",height:v?a.height-2+"px":"auto",border:"2px solid silver"}),v&&z?css$2(p,{left:P+a.x+"px",top:k+"px"}):css$2(p,{left:Math.min(Math.round(a.x+P-(p.offsetWidth-a.width)/2),this.chart.chartWidth-p.offsetWidth)+"px",top:k-(p.offsetHeight-a.height)/2+"px"})}},g.prototype.hideInput=function(d){var a=d==="min"?this.minInput:this.maxInput;a&&css$2(a,{top:"-9999em",border:0,width:"1px",height:"1px"})},g.prototype.defaultInputDateParser=function(d,a,p){var v=function($){return $.length>6&&($.lastIndexOf("-")===$.length-6||$.lastIndexOf("+")===$.length-6)},C=d.split("/").join("-").split(" ").join("T");if(C.indexOf("T")===-1&&(C+="T00:00"),a)C+="Z";else if(H.isSafari&&!v(C)){var P=new Date(C).getTimezoneOffset()/60;C+=P<=0?"+"+pad(-P)+":00":"-"+pad(P)+":00"}var k=Date.parse(C);if(!isNumber$u(k)){var z=d.split("-");k=Date.UTC(pInt$3(z[0]),pInt$3(z[1])-1,pInt$3(z[2]))}return p&&a&&isNumber$u(k)&&(k+=p.getTimezoneOffset(k)),k},g.prototype.drawInput=function(d){var a=this,p=a.chart,v=a.div,C=a.inputGroup,P=this,k=p.renderer.style||{},z=p.renderer,$=p.options.rangeSelector,D=defaultOptions$9.lang,F=d==="min";function N(){var ee=P.getInputValue(d),te=p.xAxis[0],ie=p.scroller&&p.scroller.xAxis?p.scroller.xAxis:te,oe=ie.dataMin,ae=ie.dataMax,le=P.maxInput,ce=P.minInput;ee!==Number(X.getAttribute("data-hc-time-previous"))&&isNumber$u(ee)&&(X.setAttribute("data-hc-time-previous",ee),F&&le&&isNumber$u(oe)?ee>Number(le.getAttribute("data-hc-time"))?ee=void 0:ee<oe&&(ee=oe):ce&&isNumber$u(ae)&&(ee<Number(ce.getAttribute("data-hc-time"))?ee=void 0:ee>ae&&(ee=ae)),typeof ee<"u"&&te.setExtremes(F?ee:te.min,F?te.max:ee,void 0,void 0,{trigger:"rangeSelectorInput"}))}var W=D[F?"rangeSelectorFrom":"rangeSelectorTo"]||"",j=z.label(W,0).addClass("highcharts-range-label").attr({padding:W?2:0,height:W?$.inputBoxHeight:0}).add(C),q=z.label("",0).addClass("highcharts-range-input").attr({padding:2,width:$.inputBoxWidth,height:$.inputBoxHeight,"text-align":"center"}).on("click",function(){P.showInput(d),P[d+"Input"].focus()});p.styledMode||q.attr({stroke:$.inputBoxBorderColor,"stroke-width":1}),q.add(C);var X=createElement$3("input",{name:d,className:"highcharts-range-selector"},void 0,v);X.setAttribute("type",preferredInputType($.inputDateFormat||"%b %e, %Y")),p.styledMode||(j.css(merge$Y(k,$.labelStyle)),q.css(merge$Y({color:palette.neutralColor80},k,$.inputStyle)),css$2(X,extend$16({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:k.fontSize,fontFamily:k.fontFamily,top:"-9999em"},$.inputStyle))),X.onfocus=function(){P.showInput(d)},X.onblur=function(){X===H.doc.activeElement&&N(),P.hideInput(d),P.setInputValue(d),X.blur()};var K=!1;return X.onchange=function(){K||(N(),P.hideInput(d),X.blur())},X.onkeypress=function(ee){ee.keyCode===13&&N()},X.onkeydown=function(ee){K=!0,(ee.keyCode===38||ee.keyCode===40)&&N()},X.onkeyup=function(){K=!1},{dateBox:q,input:X,label:j}},g.prototype.getPosition=function(){var d=this.chart,a=d.options.rangeSelector,p=a.verticalAlign==="top"?d.plotTop-d.axisOffset[0]:0;return{buttonTop:p+a.buttonPosition.y,inputTop:p+a.inputPosition.y-10}},g.prototype.getYTDExtremes=function(d,a,p){var v=this.chart.time,C,P=new v.Date(d),k=v.get("FullYear",P),z=p?v.Date.UTC(k,0,1):+new v.Date(k,0,1);C=Math.max(a,z);var $=P.getTime();return{max:Math.min(d||$,$),min:C}},g.prototype.render=function(d,a){var p=this.chart,v=p.renderer,C=p.container,P=p.options,k=P.rangeSelector,z=pick$13(P.chart.style&&P.chart.style.zIndex,0)+1,$=k.inputEnabled,D=this.rendered;if(k.enabled!==!1){if(!D&&(this.group=v.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:z}),this.buttonOptions.length&&this.renderButtons(),C.parentNode&&C.parentNode.insertBefore(this.div,C),$)){this.inputGroup=v.g("input-group").add(this.group);var F=this.drawInput("min");this.minDateBox=F.dateBox,this.minLabel=F.label,this.minInput=F.input;var N=this.drawInput("max");this.maxDateBox=N.dateBox,this.maxLabel=N.label,this.maxInput=N.input}if($){this.setInputValue("min",d),this.setInputValue("max",a);var W=p.scroller&&p.scroller.getUnionExtremes()||p.xAxis[0]||{};if(defined$v(W.dataMin)&&defined$v(W.dataMax)){var j=p.xAxis[0].minRange||0;this.setInputExtremes("min",W.dataMin,Math.min(W.dataMax,this.getInputValue("max"))-j),this.setInputExtremes("max",Math.max(W.dataMin,this.getInputValue("min"))+j,W.dataMax)}if(this.inputGroup){var q=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(X){if(X){var K=X.getBBox().width;K&&(X.attr({x:q}),q+=K+k.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},g.prototype.renderButtons=function(){var d=this,a=this,p=a.buttons,v=a.chart,C=a.options,P=defaultOptions$9.lang,k=v.renderer,z=merge$Y(C.buttonTheme),$=z&&z.states,D=z.width||28;delete z.width,delete z.states,this.buttonGroup=k.g("range-selector-buttons").add(this.group);var F=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$L(F,"touchstart",function(){F.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(N){var W=N[0],j=N[1];addEvent$L(F,W,function(){var q=p[d.currentButtonIndex()];q&&fireEvent$k(q.element,j||W)})}),this.zoomText=k.label(P&&P.rangeSelectorZoom||"",0).attr({padding:C.buttonTheme.padding,height:C.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(C.labelStyle),z["stroke-width"]=pick$13(z["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,F),this.buttonOptions.forEach(function(N,W){createElement$3("option",{textContent:N.title||N.text},void 0,F),p[W]=k.button(N.text,0,0,function(j){var q=N.events&&N.events.click,X;q&&(X=q.call(N,j)),X!==!1&&d.clickButton(W),d.isActive=!0},z,$&&$.hover,$&&$.select,$&&$.disabled).attr({"text-align":"center",width:D}).add(d.buttonGroup),N.title&&p[W].attr("title",N.title)})},g.prototype.alignElements=function(){var d=this,a=this,p=a.buttonGroup,v=a.buttons,C=a.chart,P=a.group,k=a.inputGroup,z=a.options,$=a.zoomText,D=C.options,F=D.exporting&&D.exporting.enabled!==!1&&D.navigation&&D.navigation.buttonOptions,N=z.buttonPosition,W=z.inputPosition,j=z.verticalAlign,q=function(be,_e){return F&&d.titleCollision(C)&&j==="top"&&_e.align==="right"&&_e.y-be.getBBox().height-12<(F.y||0)+(F.height||0)+C.spacing[0]?-40:0},X=C.plotLeft;if(P&&N&&W){var K=N.x-C.spacing[3];if(p){if(this.positionButtons(),!this.initialButtonGroupWidth){var ee=0;$&&(ee+=$.getBBox().width+5),v.forEach(function(be,_e){ee+=be.width,_e!==v.length-1&&(ee+=z.buttonSpacing)}),this.initialButtonGroupWidth=ee}X-=C.spacing[3],this.updateButtonStates();var te=q(p,N);this.alignButtonGroup(te),P.placed=p.placed=C.hasLoaded}var ie=0;k&&(ie=q(k,W),W.align==="left"?K=X:W.align==="right"&&(K=-Math.max(C.axisOffset[1],-ie)),k.align({y:W.y,width:k.getBBox().width,align:W.align,x:W.x+K-2},!0,C.spacingBox),k.placed=C.hasLoaded),this.handleCollision(ie),P.align({verticalAlign:j},!0,C.spacingBox);var oe=P.alignAttr.translateY,ae=P.getBBox().height+20,le=0;if(j==="bottom"){var ce=C.legend&&C.legend.options,ue=ce&&ce.verticalAlign==="bottom"&&ce.enabled&&!ce.floating?C.legend.legendHeight+pick$13(ce.margin,10):0;ae=ae+ue-20,le=oe-ae-(z.floating?0:z.y)-(C.titleOffset?C.titleOffset[2]:0)-10}j==="top"?(z.floating&&(le=0),C.titleOffset&&C.titleOffset[0]&&(le=C.titleOffset[0]),le+=C.margin[0]-C.spacing[0]||0):j==="middle"&&(W.y===N.y?le=oe:(W.y||N.y)&&(W.y<0||N.y<0?le-=Math.min(W.y,N.y):le=oe-ae)),P.translate(z.x,z.y+Math.floor(le));var ge=this,ye=ge.minInput,we=ge.maxInput,ve=ge.dropdown;z.inputEnabled&&ye&&we&&(ye.style.marginTop=P.translateY+"px",we.style.marginTop=P.translateY+"px"),ve&&(ve.style.marginTop=P.translateY+"px")}},g.prototype.alignButtonGroup=function(d,a){var p=this,v=p.chart,C=p.options,P=p.buttonGroup;p.buttons;var k=C.buttonPosition,z=v.plotLeft-v.spacing[3],$=k.x-v.spacing[3];k.align==="right"?$+=d-z:k.align==="center"&&($-=z/2),P&&P.align({y:k.y,width:pick$13(a,this.initialButtonGroupWidth),align:k.align,x:$},!0,v.spacingBox)},g.prototype.positionButtons=function(){var d=this,a=d.buttons,p=d.chart,v=d.options,C=d.zoomText,P=p.hasLoaded?"animate":"attr",k=v.buttonPosition,z=p.plotLeft,$=z;C&&C.visibility!=="hidden"&&(C[P]({x:pick$13(z+k.x,z)}),$+=k.x+C.getBBox().width+5),this.buttonOptions.forEach(function(D,F){a[F].visibility!=="hidden"?(a[F][P]({x:$}),$+=a[F].width+v.buttonSpacing):a[F][P]({x:z})})},g.prototype.handleCollision=function(d){var a=this,p=this,v=p.chart,C=p.buttonGroup,P=p.inputGroup,k=this.options,z=k.buttonPosition,$=k.dropdown,D=k.inputPosition,F=function(){var j=0;return a.buttons.forEach(function(q){var X=q.getBBox();X.width>j&&(j=X.width)}),j},N=function(j){if(P&&C){var q=P.alignAttr.translateX+P.alignOptions.x-d+P.getBBox().x+2,X=P.alignOptions.width,K=C.alignAttr.translateX+C.getBBox().x;return K+j>q&&q+X>K&&z.y<D.y+P.getBBox().height}return!1},W=function(){P&&C&&P.attr({translateX:P.alignAttr.translateX+(v.axisOffset[1]>=-d?0:-d),translateY:P.alignAttr.translateY+C.getBBox().height+10})};if(C){if($==="always"){this.collapseButtons(d),N(F())&&W();return}$==="never"&&this.expandButtons()}P&&C?D.align===z.align||N(this.initialButtonGroupWidth+20)?$==="responsive"?(this.collapseButtons(d),N(F())&&W()):W():$==="responsive"&&this.expandButtons():C&&$==="responsive"&&(this.initialButtonGroupWidth>v.plotWidth?this.collapseButtons(d):this.expandButtons())},g.prototype.collapseButtons=function(d){var a=this,p=a.buttons,v=a.buttonOptions,C=a.chart,P=a.dropdown,k=a.options,z=a.zoomText,$=C.userOptions.rangeSelector&&C.userOptions.rangeSelector.buttonTheme||{},D=function(W){return{text:W?W+" ▾":"▾",width:"auto",paddingLeft:pick$13(k.buttonTheme.paddingLeft,$.padding,8),paddingRight:pick$13(k.buttonTheme.paddingRight,$.padding,8)}};z&&z.hide();var F=!1;v.forEach(function(W,j){var q=p[j];q.state!==2?q.hide():(q.show(),q.attr(D(W.text)),F=!0)}),F||(P&&(P.selectedIndex=0),p[0].show(),p[0].attr(D(this.zoomText&&this.zoomText.textStr)));var N=k.buttonPosition.align;this.positionButtons(),(N==="right"||N==="center")&&this.alignButtonGroup(d,p[this.currentButtonIndex()].getBBox().width),this.showDropdown()},g.prototype.expandButtons=function(){var d=this,a=d.buttons,p=d.buttonOptions,v=d.options,C=d.zoomText;this.hideDropdown(),C&&C.show(),p.forEach(function(P,k){var z=a[k];z.show(),z.attr({text:P.text,width:v.buttonTheme.width||28,paddingLeft:pick$13(v.buttonTheme.paddingLeft,"unset"),paddingRight:pick$13(v.buttonTheme.paddingRight,"unset")}),z.state<2&&z.setState(0)}),this.positionButtons()},g.prototype.currentButtonIndex=function(){var d=this.dropdown;return d&&d.selectedIndex>0?d.selectedIndex-1:0},g.prototype.showDropdown=function(){var d=this,a=d.buttonGroup,p=d.buttons,v=d.chart,C=d.dropdown;if(a&&C){var P=a.translateX,k=a.translateY,z=p[this.currentButtonIndex()].getBBox();css$2(C,{left:v.plotLeft+P+"px",top:k+.5+"px",width:z.width+"px",height:z.height+"px"}),this.hasVisibleDropdown=!0}},g.prototype.hideDropdown=function(){var d=this.dropdown;d&&(css$2(d,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},g.prototype.getHeight=function(){var d=this,a=d.options,p=d.group,v=a.inputPosition,C=a.buttonPosition,P=a.y,k=C.y,z=v.y,$=0,D;return a.height?a.height:(this.alignElements(),$=p?p.getBBox(!0).height+13+P:0,D=Math.min(z,k),(z<0&&k<0||z>0&&k>0)&&($+=Math.abs(D)),$)},g.prototype.titleCollision=function(d){return!(d.options.title.text||d.options.subtitle.text)},g.prototype.update=function(d){var a=this.chart;merge$Y(!0,a.options.rangeSelector,d),this.destroy(),this.init(a),this.render()},g.prototype.destroy=function(){var d=this,a=d.minInput,p=d.maxInput;d.eventsToUnbind&&(d.eventsToUnbind.forEach(function(v){return v()}),d.eventsToUnbind=void 0),destroyObjectProperties$1(d.buttons),a&&(a.onfocus=a.onblur=a.onchange=null),p&&(p.onfocus=p.onblur=p.onchange=null),objectEach$f(d,function(v,C){v&&C!=="chart"&&(v instanceof SVGElement?v.destroy():v instanceof window.HTMLElement&&discardElement$2(v)),v!==g.prototype[C]&&(d[C]=null)},this)},g})();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(g){var d=g.indexOf("%L")!==-1;if(d)return"text";var a=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(v){return g.indexOf("%"+v)!==-1}),p=["H","k","I","l","M","S"].some(function(v){return g.indexOf("%"+v)!==-1});return a&&p?"datetime-local":a?"date":p?"time":"text"}Axis.prototype.minFromRange=function(){var g=this.range,d=g.type,a,p=this.max,v,C,P=this.chart.time,k=function(z,$){var D=d==="year"?"FullYear":"Month",F=new P.Date(z),N=P.get(D,F);return P.set(D,F,N+$),N===P.get(D,F)&&P.set("Date",F,0),F.getTime()-z};return isNumber$u(g)?(a=p-g,C=g):(a=p+k(p,-g.count),this.chart&&(this.chart.fixedRange=p-a)),v=pick$13(this.dataMin,Number.MIN_VALUE),isNumber$u(a)||(a=v),a<=v&&(a=v,typeof C>"u"&&(C=k(a,g.count)),this.newMax=Math.min(a+C,this.dataMax)),isNumber$u(p)||(a=void 0),a};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(g){var d,a=g.rangeSelector,p,v,C;function P(){a&&(d=g.xAxis[0].getExtremes(),p=g.legend,C=a&&a.options.verticalAlign,isNumber$u(d.min)&&a.render(d.min,d.max),p.display&&C==="top"&&C===p.options.verticalAlign&&(v=merge$Y(g.spacingBox),p.options.layout==="vertical"?v.y=g.plotTop:v.y+=a.getHeight(),p.group.placed=!1,p.align(v)))}if(a){var k=find$d(chartDestroyEvents_1,function(z){return z[0]===g});k||chartDestroyEvents_1.push([g,[addEvent$L(g.xAxis[0],"afterSetExtremes",function(z){a&&a.render(z.min,z.max)}),addEvent$L(g,"redraw",P)]]),P()}};addEvent$L(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$L(Chart$1,"beforeRender",function(){var g=this,d=g.axes,a=g.rangeSelector,p;a&&(isNumber$u(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),d.forEach(function(v){v.updateNames(),v.setScale()}),g.getAxisMargins(),a.render(),p=a.options.verticalAlign,a.options.floating||(p==="bottom"?this.extraBottomMargin=!0:p!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$L(Chart$1,"update",function(g){var d=this,a=g.options,p=a.rangeSelector,v=d.rangeSelector,C,P=this.extraBottomMargin,k=this.extraTopMargin;p&&p.enabled&&!defined$v(v)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=v=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,v&&(initRangeSelector_1(this),C=p&&p.verticalAlign||v.options&&v.options.verticalAlign,v.options.floating||(C==="bottom"?this.extraBottomMargin=!0:C!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==P||this.extraTopMargin!==k)&&(this.isDirtyBox=!0))}),addEvent$L(Chart$1,"render",function(){var g=this,d=g.rangeSelector,a;d&&!d.options.floating&&(d.render(),a=d.options.verticalAlign,a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0))}),addEvent$L(Chart$1,"getMargins",function(){var g=this.rangeSelector,d;g&&(d=g.getHeight(),this.extraTopMargin&&(this.plotTop+=d),this.extraBottomMargin&&(this.marginBottom+=d))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$L(Chart$1,"destroy",function(){for(var d=0;d<chartDestroyEvents_1.length;d++){var a=chartDestroyEvents_1[d];if(a[0]===this){a[1].forEach(function(p){return p()}),chartDestroyEvents_1.splice(d,1);return}}}),H.RangeSelector=RangeSelector}var __extends$1$=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),animObject$5=animationExports.animObject,format$7=FormatUtilities.format,getOptions$3=DefaultOptions.getOptions,pointTooltipFormatter=Point$4.prototype.tooltipFormatter,_a$c=Series$f.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$K=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$b=Utilities.clamp,defined$u=Utilities.defined,extend$15=Utilities.extend,find$c=Utilities.find,isNumber$t=Utilities.isNumber,isString$4=Utilities.isString,merge$X=Utilities.merge,pick$12=Utilities.pick,splat$9=Utilities.splat,StockChart=(function(g){__extends$1$(d,g);function d(){return g!==null&&g.apply(this,arguments)||this}return d.prototype.init=function(a,p){var v=getOptions$3(),C=a.xAxis,P=a.yAxis,k=pick$12(a.navigator&&a.navigator.enabled,v.navigator.enabled,!0);a.xAxis=a.yAxis=void 0;var z=merge$X({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:k},scrollbar:{enabled:pick$12(v.scrollbar&&v.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$12(v.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$12(v.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=C,a.yAxis=P,z.xAxis=splat$9(a.xAxis||{}).map(function($,D){return merge$X(getDefaultAxisOptions("xAxis",$),v.xAxis,v.xAxis&&v.xAxis[D],$,getForcedAxisOptions("xAxis",a))}),z.yAxis=splat$9(a.yAxis||{}).map(function($,D){return merge$X(getDefaultAxisOptions("yAxis",$),v.yAxis,v.yAxis&&v.yAxis[D],$)}),g.prototype.init.call(this,z,p)},d.prototype.createAxis=function(a,p){return p.axis=merge$X(getDefaultAxisOptions(a,p.axis),p.axis,getForcedAxisOptions(a,this.userOptions)),g.prototype.createAxis.call(this,a,p)},d})(Chart$1);(function(g){function d(a,p,v){return new g(a,p,v)}g.stockChart=d})(StockChart||(StockChart={}));function getDefaultAxisOptions(g,d){return g==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:g==="yAxis"?{labels:{y:-2},opposite:pick$12(d.opposite,!0),showLastLabel:!!(d.categories||d.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(g,d){if(g==="xAxis"){var a=getOptions$3(),p=pick$12(d.navigator&&d.navigator.enabled,a.navigator.enabled,!0),v={type:"datetime",categories:void 0};return p&&(v.startOnTick=!1,v.endOnTick=!1),v}return{}}addEvent$K(Series$f,"setOptions",function(g){var d;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?d={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(d={marker:{enabled:!1,radius:2}}),d&&(g.plotOptions[this.type]=merge$X(g.plotOptions[this.type],d)))});addEvent$K(Axis,"autoLabelAlign",function(g){var d=this.chart,a=this.options,p=d._labelPanes=d._labelPanes||{},v,C=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(v=a.top+","+a.height,!p[v]&&C.enabled&&(C.x===15&&(C.x=0),typeof C.align>"u"&&(C.align="right"),p[v]=this,g.align="right",g.preventDefault()))});addEvent$K(Axis,"destroy",function(){var g=this.chart,d=this.options&&this.options.top+","+this.options.height;d&&g._labelPanes&&g._labelPanes[d]===this&&delete g._labelPanes[d]});addEvent$K(Axis,"getPlotLinePath",function(g){var d=this,a=this.isLinked&&!this.series?this.linkedParent.series:this.series,p=d.chart,v=p.renderer,C=d.left,P=d.top,k,z,$,D,F=[],N=[],W,j,q=g.translatedValue,X=g.value,K=g.force,ee;function te(ie){var oe=ie==="xAxis"?"yAxis":"xAxis",ae=d.options[oe];return isNumber$t(ae)?[p[oe][ae]]:isString$4(ae)?[p.get(ae)]:a.map(function(le){return le[oe]})}(p.options.isStock&&g.acrossPanes!==!1&&d.coll==="xAxis"||d.coll==="yAxis")&&(g.preventDefault(),N=te(d.coll),W=d.isXAxis?p.yAxis:p.xAxis,W.forEach(function(ie){if(!defined$u(ie.options.id)||ie.options.id.indexOf("navigator")===-1){var oe=ie.isXAxis?"yAxis":"xAxis",ae=defined$u(ie.options[oe])?p[oe][ie.options[oe]]:p[oe][0];d===ae&&N.push(ie)}}),j=N.length?[]:[d.isXAxis?p.yAxis[0]:p.xAxis[0]],N.forEach(function(ie){j.indexOf(ie)===-1&&!find$c(j,function(oe){return oe.pos===ie.pos&&oe.len===ie.len})&&j.push(ie)}),ee=pick$12(q,d.translate(X,null,null,g.old)),isNumber$t(ee)&&(d.horiz?j.forEach(function(ie){var oe;z=ie.pos,D=z+ie.len,k=$=Math.round(ee+d.transB),K!=="pass"&&(k<C||k>C+d.width)&&(K?k=$=clamp$b(k,C,C+d.width):oe=!0),oe||F.push(["M",k,z],["L",$,D])}):j.forEach(function(ie){var oe;k=ie.pos,$=k+ie.len,z=D=Math.round(P+d.height-ee),K!=="pass"&&(z<P||z>P+d.height)&&(K?z=D=clamp$b(z,P,P+d.height):oe=!0),oe||F.push(["M",k,z],["L",$,D])})),g.path=F.length>0?v.crispPolyLine(F,g.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(g,d){for(var a=0;a<g.length;a=a+2){var p=g[a],v=g[a+1];p[1]===v[1]&&(p[1]=v[1]=Math.round(p[1])-d%2/2),p[2]===v[2]&&(p[2]=v[2]=Math.round(p[2])+d%2/2)}return g};addEvent$K(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$K(Axis,"afterDrawCrosshair",function(g){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$t(this.min)||!isNumber$t(this.max))){var d=this.chart,a=this.logarithmic,p=this.crosshair.label,v=this.horiz,C=this.opposite,P=this.left,k=this.top,z=this.crossLabel,$,D,F,N=p.format,W="",j,q,X=this.options.tickPosition==="inside",K=this.crosshair.snap!==!1,ee=0,te=g.e||this.cross&&this.cross.e,ie=g.point,oe=this.min,ae=this.max;a&&(oe=a.lin2log(oe),ae=a.lin2log(ae)),q=v?"center":C?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",z||(z=this.crossLabel=d.renderer.label("",0,void 0,p.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(ie?ie.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:p.align||q,padding:pick$12(p.padding,8),r:pick$12(p.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||z.attr({fill:p.backgroundColor||ie&&ie.series&&ie.series.color||palette.neutralColor60,stroke:p.borderColor||"","stroke-width":p.borderWidth||0}).css(extend$15({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},p.style||{}))),v?($=K?(ie.plotX||0)+P:te.chartX,D=k+(C?0:this.height)):($=C?this.width+P:0,D=K?(ie.plotY||0)+k:te.chartY),!N&&!p.formatter&&(this.dateTime&&(W="%b %d, %Y"),N="{value"+(W?":"+W:"")+"}");var le=K?this.isXAxis?ie.x:ie.y:this.toValue(v?te.chartX:te.chartY),ce=ie?ie.series.isPointInside(ie):isNumber$t(le)&&le>oe&&le<ae,ue="";N?ue=format$7(N,{value:le},d):p.formatter&&isNumber$t(le)&&(ue=p.formatter.call(this,le)),z.attr({text:ue,x:$,y:D,visibility:ce?"visible":"hidden"}),F=z.getBBox(),isNumber$t(z.y)&&(v?(X&&!C||!X&&C)&&(D=z.y-F.height):D=z.y-F.height/2),v?j={left:P-F.x,right:P+this.width-F.x}:j={left:this.labelAlign==="left"?P:0,right:this.labelAlign==="right"?P+this.width:d.chartWidth},z.translateX<j.left&&(ee=j.left-z.translateX),z.translateX+F.width>=j.right&&(ee=-(z.translateX+F.width-j.right)),z.attr({x:$+ee,y:D,anchorX:v?$:this.opposite?0:d.chartWidth,anchorY:v?this.opposite?d.chartHeight:0:D+F.height/2})}});Series$f.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$f.prototype.setCompare=function(g){this.initCompare(g),this.userOptions.compare=g};Series$f.prototype.initCompare=function(g){this.modifyValue=g==="value"||g==="percent"?function(d,a){var p=this.compareValue;return typeof d<"u"&&typeof p<"u"?(g==="value"?d-=p:d=100*(d/p)-(this.options.compareBase===100?0:100),a&&(a.change=d),d):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$f.prototype.forceCropping=function(){var g=this.chart,d=this.options,a=d.dataGrouping,p=this.allowDG!==!1&&a&&pick$12(a.enabled,g.options.isStock);return p};Series$f.prototype.processData=function(g){var d=this,a,p=-1,v,C,P=d.options.compareStart===!0?0:1,k,z;if(seriesProcessData.apply(this,arguments),d.xAxis&&d.processedYData){for(v=d.processedXData,C=d.processedYData,k=C.length,d.pointArrayMap&&(p=d.pointArrayMap.indexOf(d.options.pointValKey||d.pointValKey||"y")),a=0;a<k-P;a++)if(z=C[a]&&p>-1?C[a][p]:C[a],isNumber$t(z)&&v[a+P]>=d.xAxis.min&&z!==0){d.compareValue=z;break}}};addEvent$K(Series$f,"afterGetExtremes",function(g){var d=g.dataExtremes;if(this.modifyValue&&d){var a=[this.modifyValue(d.dataMin),this.modifyValue(d.dataMax)];d.dataMin=arrayMin$4(a),d.dataMax=arrayMax$4(a)}});Axis.prototype.setCompare=function(g,d){this.isXAxis||(this.series.forEach(function(a){a.setCompare(g)}),pick$12(d,!0)&&this.chart.redraw())};Point$4.prototype.tooltipFormatter=function(g){var d=this,a=d.series.chart.numberFormatter;return g=g.replace("{point.change}",(d.change>0?"+":"")+a(d.change,pick$12(d.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[g])};addEvent$K(Series$f,"render",function(){var g=this.chart,d;if(!(g.is3d&&g.is3d())&&!g.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(d=this.yAxis.len,this.xAxis.axisLine){var a=g.plotTop+g.plotHeight-this.yAxis.pos-this.yAxis.len,p=Math.floor(this.xAxis.axisLine.strokeWidth()/2);a>=0&&(d-=Math.max(p-a,0))}if((!g.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$X(g.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=d),g.hasRendered){var v=animObject$5(this.options.animation),C=this.getSharedClipKey(v),P=g.sharedClips[C];if(P){P.animate({width:this.xAxis.len,height:d});var k=g.sharedClips[C+"m"];k&&k.animate({width:this.xAxis.len})}}}});addEvent$K(Chart$1,"update",function(g){var d=g.options;"scrollbar"in d&&this.navigator&&(merge$X(!0,this.options.scrollbar,d.scrollbar),this.navigator.update({},!1),delete d.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;G$6.Scrollbar=Scrollbar;G$6.StockChart=G$6.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$6.Axis);OrdinalAxis$1.compose(G$6.Axis,G$6.Series,G$6.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$8.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$W=Utilities.merge;function addClass$1(g,d){g.classList?g.classList.add(d):g.className.indexOf(d)<0&&(g.className+=d)}function escapeStringForHTML$1(g){return g.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(g){return doc$f.getElementById(g)}function getFakeMouseEvent$2(g){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(g);if(doc$f.createEvent){var d=doc$f.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(g,!0,!0,win$6,g==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),d}return{type:g}}function getHeadingTagNameForElement$1(g){var d=function(C){var P=parseInt(C.slice(1),10),k=Math.min(6,P+1);return"h"+k},a=function(C){return/H[1-6]/.test(C)},p=function(C){for(var P=C;P=P.previousSibling;){var k=P.tagName||"";if(a(k))return k}return""},v=function(C){var P=p(C);if(P)return d(P);var k=C.parentElement;if(!k)return"p";var z=k.tagName;return a(z)?d(z):v(k)};return v(g)}function removeElement$5(g){g&&g.parentNode&&g.parentNode.removeChild(g)}function reverseChildNodes$1(g){for(var d=g.childNodes.length;d--;)g.appendChild(g.childNodes[d])}function setElAttrs$4(g,d){Object.keys(d).forEach(function(a){var p=d[a];p===null?g.removeAttribute(a):g.setAttribute(a,p)})}function stripHTMLTagsFromString$2(g){return typeof g=="string"?g.replace(/<\/?[^>]+(>|$)/g,""):g}function visuallyHideElement$2(g){var d={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$W(!0,g.style,d)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$t=Utilities.defined,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent;function getChartTitle$5(g){return stripHTMLTags$3(g.options.title.text||g.langFormat("accessibility.defaultChartTitle",{chart:g}))}function getAxisDescription$2(g){return g&&(g.userOptions&&g.userOptions.accessibility&&g.userOptions.accessibility.description||g.axisTitle&&g.axisTitle.textStr||g.options.id||g.categories&&"categories"||g.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(g){var d=g.options||{};return d.accessibility&&typeof d.accessibility.rangeDescription<"u"?d.accessibility.rangeDescription:g.categories?getCategoryAxisRangeDesc(g):g.dateTime&&(g.min===0||g.dataMin===0)?getAxisTimeLengthDesc(g):getAxisFromToDescription(g)}function getCategoryAxisRangeDesc(g){var d=g.chart;return g.dataMax&&g.dataMin?d.langFormat("accessibility.axis.rangeCategories",{chart:d,axis:g,numCategories:g.dataMax-g.dataMin+1}):""}function getAxisTimeLengthDesc(g){var d=g.chart,a={},p="Seconds";a.Seconds=((g.max||0)-(g.min||0))/1e3,a.Minutes=a.Seconds/60,a.Hours=a.Minutes/60,a.Days=a.Hours/24,["Minutes","Hours","Days"].forEach(function(C){a[C]>2&&(p=C)});var v=a[p].toFixed(p!=="Seconds"&&p!=="Minutes"?1:0);return d.langFormat("accessibility.axis.timeRange"+p,{chart:d,axis:g,range:v.replace(".0","")})}function getAxisFromToDescription(g){var d=g.chart,a=d.options&&d.options.accessibility&&d.options.accessibility.screenReaderSection.axisRangeDateFormat||"",p=function(v){return g.dateTime?d.time.dateFormat(a,g[v]):g[v]};return d.langFormat("accessibility.axis.rangeFromTo",{chart:d,axis:g,rangeFrom:p("min"),rangeTo:p("max")})}function getSeriesFirstPointElement$1(g){if(g.points&&g.points.length){var d=find$b(g.points,function(a){return!!a.graphic});return d&&d.graphic&&d.graphic.element}}function getSeriesA11yElement$1(g){var d=getSeriesFirstPointElement$1(g);return d&&d.parentNode||g.graph&&g.graph.element||g.group&&g.group.element}function unhideChartElementFromAT$7(g,d){d.setAttribute("aria-hidden",!1),!(d===g.renderTo||!d.parentNode||d.parentNode===doc$e.body)&&(Array.prototype.forEach.call(d.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(g,d.parentNode))}function hideSeriesFromAT$1(g){var d=getSeriesA11yElement$1(g);d&&d.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(g,d){return d?(g.series||[]).filter(function(a){return a.name===d}):g.series}function getPointFromXY$1(g,d,a){for(var p=g.length,v;p--;)if(v=find$b(g[p].points||[],function(C){return C.x===d&&C.y===a}),v)return v}function getRelativePointAxisPosition(g,d){if(!defined$t(g.dataMin)||!defined$t(g.dataMax))return 0;var a=g.toPixels(g.dataMin),p=g.toPixels(g.dataMax),v=g.coll==="xAxis"?"x":"y",C=g.toPixels(d[v]||0);return(C-a)/(p-a)}function scrollToPoint$1(g){var d=g.series.xAxis,a=g.series.yAxis,p=d&&d.scrollbar?d:a,v=p&&p.scrollbar;if(v&&defined$t(v.to)&&defined$t(v.from)){var C=v.to-v.from,P=getRelativePointAxisPosition(p,g);v.updatePosition(P-C/2,P+C/2),fireEvent$j(v,"changed",{from:v.from,to:v.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$a=Utilities.find;function KeyboardNavigationHandler(g,d){this.chart=g,this.keyCodeMap=d.keyCodeMap||[],this.validate=d.validate,this.init=d.init,this.terminate=d.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(g){var d=g.which||g.keyCode,a=this.response.noHandler,p=find$a(this.keyCodeMap,function(v){return v[0].indexOf(d)>-1});return p?a=p[1].call(this,d,g):d===9&&(a=this.response[g.shiftKey?"prev":"next"]),a}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$14=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$14(DOMElementProvider.prototype,{createElement:function(){var g=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(g),g},destroyCreatedElements:function(){this.elements.forEach(function(g){removeElement$4(g)}),this.elements=[]}});var addEvent$J=Utilities.addEvent,extend$13=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$13(EventProvider.prototype,{addEvent:function(){var g=addEvent$J.apply(H,arguments);return this.eventRemovers.push(g),g},removeAddedEvents:function(){this.eventRemovers.forEach(function(g){g()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$12=Utilities.extend,fireEvent$i=Utilities.fireEvent,merge$V=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(g){this.chart=g,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(g,d){var a=d.type;doc$c.createEvent&&(g.dispatchEvent||g.fireEvent)?g.dispatchEvent?g.dispatchEvent(d):g.fireEvent(a,d):fireEvent$i(g,a,d)},fakeClickEvent:function(g){if(g){var d=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(g,d)}},addProxyGroup:function(g){this.createOrUpdateProxyContainer();var d=this.createElement("div");return Object.keys(g||{}).forEach(function(a){g[a]!==null&&d.setAttribute(a,g[a])}),this.chart.a11yProxyContainer.appendChild(d),d},createOrUpdateProxyContainer:function(){var g=this.chart,d=g.renderer.box;g.a11yProxyContainer=g.a11yProxyContainer||this.createProxyContainerElement(),d.nextSibling!==g.a11yProxyContainer&&g.container.insertBefore(g.a11yProxyContainer,d.nextSibling)},createProxyContainerElement:function(){var g=doc$c.createElement("div");return g.className="highcharts-a11y-proxy-container",g},createProxyButton:function(g,d,a,p,v){var C=g.element,P=this.createElement("button"),k=merge$V({"aria-label":C.getAttribute("aria-label")},a);return Object.keys(k).forEach(function(z){k[z]!==null&&P.setAttribute(z,k[z])}),P.className="highcharts-a11y-proxy-button",g.hasClass("highcharts-no-tooltip")&&(P.className+=" highcharts-no-tooltip"),v&&this.addEvent(P,"click",v),this.setProxyButtonStyle(P),this.updateProxyButtonPosition(P,p||g),this.proxyMouseEventsForButton(C,P),d.appendChild(P),k["aria-hidden"]||unhideChartElementFromAT$6(this.chart,P),P},getElementPosition:function(g){var d=g.element,a=this.chart.renderTo;if(a&&d&&d.getBoundingClientRect){var p=d.getBoundingClientRect(),v=a.getBoundingClientRect();return{x:p.left-v.left,y:p.top-v.top,width:p.right-p.left,height:p.bottom-p.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(g){merge$V(!0,g.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),g.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(g,d){var a=this.getElementPosition(d);merge$V(!0,g.style,{width:(a.width||1)+"px",height:(a.height||1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})},proxyMouseEventsForButton:function(g,d){var a=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(p){var v=p.indexOf("touch")===0;a.addEvent(d,p,function(C){var P=v?a.cloneTouchEvent(C):a.cloneMouseEvent(C);g&&a.fireEventOnWrappedOrUnwrappedElement(g,P),C.stopPropagation(),p!=="touchstart"&&p!=="touchmove"&&p!=="touchend"&&C.preventDefault()},{passive:!1})})},cloneMouseEvent:function(g){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(g.type,g);if(doc$c.createEvent){var d=doc$c.createEvent("MouseEvent");if(d.initMouseEvent)return d.initMouseEvent(g.type,g.bubbles,g.cancelable,g.view||win$5,g.detail,g.screenX,g.screenY,g.clientX,g.clientY,g.ctrlKey,g.altKey,g.shiftKey,g.metaKey,g.button,g.relatedTarget),d}return getFakeMouseEvent$1(g.type)},cloneTouchEvent:function(g){var d=function(v){for(var C=[],P=0;P<v.length;++P){var k=v.item(P);k&&C.push(k)}return C};if(typeof win$5.TouchEvent=="function"){var a=new win$5.TouchEvent(g.type,{touches:d(g.touches),targetTouches:d(g.targetTouches),changedTouches:d(g.changedTouches),ctrlKey:g.ctrlKey,shiftKey:g.shiftKey,altKey:g.altKey,metaKey:g.metaKey,bubbles:g.bubbles,cancelable:g.cancelable,composed:g.composed,detail:g.detail,view:g.view});return g.defaultPrevented&&a.preventDefault(),a}var p=this.cloneMouseEvent(g);return p.touches=g.touches,p.changedTouches=g.changedTouches,p.targetTouches=g.targetTouches,p},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$12(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$I=Utilities.addEvent,fireEvent$h=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$I(doc$b,"keydown",function(g){var d=g.which||g.keyCode,a=27;d===a&&H.charts&&H.charts.forEach(function(p){p&&p.dismissPopupContent&&p.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var g=this;fireEvent$h(this,"dismissPopupContent",{},function(){g.tooltip&&g.tooltip.hide(0),g.hideExportMenu()})};function KeyboardNavigation(g,d){this.init(g,d)}KeyboardNavigation.prototype={init:function(g,d){var a=this,p=this.eventProvider=new EventProvider;this.chart=g,this.components=d,this.modules=[],this.currentModuleIx=0,this.update(),p.addEvent(this.tabindexContainer,"keydown",function(v){return a.onKeydown(v)}),p.addEvent(this.tabindexContainer,"focus",function(v){return a.onFocus(v)}),["mouseup","touchend"].forEach(function(v){return p.addEvent(doc$b,v,function(){return a.onMouseUp()})}),["mousedown","touchstart"].forEach(function(v){return p.addEvent(g.renderTo,v,function(){a.isClickingChart=!0})}),p.addEvent(g.renderTo,"mouseover",function(){a.pointerIsOverChart=!0}),p.addEvent(g.renderTo,"mouseout",function(){a.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(g){var d=this.chart.options.accessibility,a=d&&d.keyboardNavigation,p=this.components;this.updateContainerTabindex(),a&&a.enabled&&g&&g.length?(this.modules=g.reduce(function(v,C){var P=p[C].getKeyboardNavigation();return v.concat(P)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(g){var d=this.chart,a=g.relatedTarget&&d.container.contains(g.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!a&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var g=this.chart,d=this.modules&&this.modules[this.currentModuleIx||0];d&&d.terminate&&d.terminate(),g.focusElement&&g.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(g){var d=g||win$4.event,a,p=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,p){var v=p.run(d);v===p.response.success?a=!0:v===p.response.prev?a=this.prev():v===p.response.next&&(a=this.next()),a&&(d.preventDefault(),d.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(g){var d=this.modules&&this.modules[this.currentModuleIx];d&&d.terminate&&d.terminate(g),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=g;var a=this.modules&&this.modules[this.currentModuleIx];if(a){if(a.validate&&!a.validate())return this.move(g);if(a.init)return a.init(g),!0}return this.currentModuleIx=0,this.exiting=!0,g>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var g="highcharts-end-of-chart-marker-"+this.chart.index,d=getElement$1(g);this.removeExitAnchor(),d?(this.makeElementAnExitAnchor(d),this.exitAnchor=d):this.createExitAnchor()},updateContainerTabindex:function(){var g=this.chart.options.accessibility,d=g&&g.keyboardNavigation,a=!(d&&d.enabled===!1),p=this.chart,v=p.container,C;p.renderTo.hasAttribute("tabindex")?(v.removeAttribute("tabindex"),C=p.renderTo):C=v,this.tabindexContainer=C;var P=C.getAttribute("tabindex");a&&!P?C.setAttribute("tabindex","0"):a||p.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(g){var d=this.tabindexContainer.getAttribute("tabindex")||0;g.setAttribute("class","highcharts-exit-anchor"),g.setAttribute("tabindex",d),g.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(g)},createExitAnchor:function(){var g=this.chart,d=this.exitAnchor=doc$b.createElement("div");g.renderTo.appendChild(d),this.makeElementAnExitAnchor(d)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(g){var d=this.chart,a=this;this.eventProvider.addEvent(g,"focus",function(p){var v=p||win$4.event,C,P=v.relatedTarget&&d.container.contains(v.relatedTarget),k=!(P||a.exiting);k?(a.tabbingInBackwards=!0,a.tabindexContainer.focus(),delete a.tabbingInBackwards,v.preventDefault(),a.modules&&a.modules.length&&(a.currentModuleIx=a.modules.length-1,C=a.modules[a.currentModuleIx],C&&C.validate&&!C.validate()?a.prev():C&&C.init(-1))):a.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$4=animationExports.animObject,addEvent$H=Utilities.addEvent,extend$11=Utilities.extend,find$9=Utilities.find,fireEvent$g=Utilities.fireEvent,isNumber$s=Utilities.isNumber,pick$11=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(g,d){var a=g.allItems[d].pageIx,p=g.currentPage;typeof a<"u"&&a+1!==p&&g.scroll(1+a-p)}function shouldDoLegendA11y(g){var d=g.legend&&g.legend.allItems,a=g.options.legend.accessibility||{};return!!(d&&d.length&&!(g.colorAxis&&g.colorAxis.length)&&a.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(g){var d=this.legend.allItems,a=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return d[g]?(isNumber$s(a)&&d[a]&&fireEvent$g(d[a].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,g),this.setFocusToElement(d[g].legendItem,d[g].a11yProxyElement),fireEvent$g(d[g].legendGroup.element,"mouseover"),!0):!1};addEvent$H(Legend,"afterColorizeItem",function(g){var d=this.chart,a=d.options.accessibility,p=g.item;a.enabled&&p&&p.a11yProxyElement&&p.a11yProxyElement.setAttribute("aria-pressed",g.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$11(LegendComponent.prototype,{init:function(){var g=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===g.chart&&(g.updateProxiesPositions(),g.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(g.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(d){this.chart===g.chart&&this.chart.renderer&&g.updateProxyPositionForItem(d.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===g.chart&&this.chart.renderer&&g.recreateProxies()&&syncTimeout$1(function(){return g.updateProxiesPositions()},animObject$4(pick$11(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var g=this.chart.legend,d=g.allItems||[],a=g.currentPage||1,p=g.clipHeight||0;d.forEach(function(v){var C=v.pageIx||0,P=v._legendItemPos?v._legendItemPos[1]:0,k=v.legendItem?Math.round(v.legendItem.getBBox().height):0,z=P+k-g.pages[C]>p||C!==a-1;v.a11yProxyElement&&(v.a11yProxyElement.style.visibility=z?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var g=0,d=this.proxyElementsList;g<d.length;g++){var a=d[g],p=a.element,v=a.posElement;this.updateProxyButtonPosition(p,v)}},updateProxyPositionForItem:function(g){var d=find$9(this.proxyElementsList,function(a){return a.item===g});d&&this.updateProxyButtonPosition(d.element,d.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var g=this.chart,d=stripHTMLTags$2((g.legend&&g.legend.options.title&&g.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),a=g.langFormat("accessibility.legend.legendLabel"+(d?"":"NoTitle"),{chart:g,legendTitle:d,chartTitle:getChartTitle$4(g)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",a)},addLegendProxyGroup:function(){var g=this.chart.options.accessibility,d=g.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:d})},addLegendListContainer:function(){if(this.legendProxyGroup){var g=this.legendListContainer=this.createElement("ul");g.style.listStyle="none",this.legendProxyGroup.appendChild(g)}},proxyLegendItems:function(){var g=this,d=this.chart.legend&&this.chart.legend.allItems||[];d.forEach(function(a){a.legendItem&&a.legendItem.element&&g.proxyLegendItem(a)})},proxyLegendItem:function(g){if(!(!g.legendItem||!g.legendGroup||!this.legendListContainer)){var d=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(g.name),item:g}),a={tabindex:-1,"aria-pressed":g.visible,"aria-label":d},p=g.legendGroup.div?g.legendItem:g.legendGroup,v=this.createElement("li");this.legendListContainer.appendChild(v),g.a11yProxyElement=this.createProxyButton(g.legendItem,v,a,p),this.proxyElementsList.push({item:g,element:g.a11yProxyElement,posElement:p})}},getKeyboardNavigation:function(){var g=this.keyCodes,d=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[g.left,g.right,g.up,g.down],function(p){return d.onKbdArrowKey(this,p)}],[[g.enter,g.space],function(p){return H.isFirefox&&p===g.space?this.response.success:d.onKbdClick(this)}]],validate:function(){return d.shouldHaveLegendNavigation()},init:function(p){return d.onKbdNavigationInit(p)},terminate:function(){a.legend.allItems.forEach(function(p){return p.setState("",!0)})}})},onKbdArrowKey:function(g,d){var a=this.keyCodes,p=g.response,v=this.chart,C=v.options.accessibility,P=v.legend.allItems.length,k=d===a.left||d===a.up?-1:1,z=v.highlightLegendItem(this.highlightedLegendItemIx+k);return z?(this.highlightedLegendItemIx+=k,p.success):P>1&&C.keyboardNavigation.wrapAround?(g.init(k),p.success):p[k>0?"next":"prev"]},onKbdClick:function(g){var d=this.chart.legend.allItems[this.highlightedLegendItemIx];return d&&d.a11yProxyElement&&fireEvent$g(d.a11yProxyElement,"click"),g.response.success},shouldHaveLegendNavigation:function(){var g=this.chart,d=g.options.legend||{},a=g.legend&&g.legend.allItems,p=g.colorAxis&&g.colorAxis.length,v=d.accessibility||{};return!!(a&&g.legend.display&&!p&&v.enabled&&v.keyboardNavigation&&v.keyboardNavigation.enabled)},onKbdNavigationInit:function(g){var d=this.chart,a=d.legend.allItems.length-1,p=g>0?0:a;d.highlightLegendItem(p),this.highlightedLegendItemIx=p}});var extend$10=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(g){return g.exportSVGElements&&g.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var g=getExportMenuButtonElement(this);if(g){var d=g.element;d.onclick&&d.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var g=this,d=g.exportDivElements;d&&g.exportContextMenu&&(d.forEach(function(a){a&&a.className==="highcharts-menu-item"&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout"))}),g.highlightedExportItemIx=0,g.exportContextMenu.hideMenu(),g.container.focus())};Chart$1.prototype.highlightExportItem=function(g){var d=this.exportDivElements&&this.exportDivElements[g],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],p;return d&&d.tagName==="LI"&&!(d.children&&d.children.length)?(p=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,d.focus&&p&&d.focus(),a&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout")),d.onmouseover&&d.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=g,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var g=this,d;if(g.exportDivElements){for(d=g.exportDivElements.length;d--;)if(g.highlightExportItem(d))return!0}return!1};function exportingShouldHaveA11y(g){var d=g.options.exporting,a=getExportMenuButtonElement(g);return!!(d&&d.enabled!==!1&&d.accessibility&&d.accessibility.enabled&&a&&a.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$10(MenuComponent.prototype,{init:function(){var g=this.chart,d=this;this.addEvent(g,"exportMenuShown",function(){d.onMenuShown()}),this.addEvent(g,"exportMenuHidden",function(){d.onMenuHidden()})},onMenuHidden:function(){var g=this.chart.exportContextMenu;g&&g.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var g=this.chart,d=g.exportContextMenu;d&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(g,d)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(g){var d=this.exportButtonProxy;d&&d.setAttribute("aria-expanded",g)},onChartRender:function(){var g=this.chart,d=g.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(g)){this.exportProxyGroup=this.addProxyGroup(d.landmarkVerbosity==="all"?{"aria-label":g.langFormat("accessibility.exporting.exportRegionLabel",{chart:g,chartTitle:getChartTitle$3(g)}),role:"region"}:{});var a=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(a,this.exportProxyGroup,{"aria-label":g.langFormat("accessibility.exporting.menuButtonLabel",{chart:g}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var g=this.chart,d=g.exportDivElements;if(d&&d.length){d.forEach(function(p){p&&(p.tagName==="LI"&&!(p.children&&p.children.length)?p.setAttribute("tabindex",-1):p.setAttribute("aria-hidden","true"))});var a=d[0]&&d[0].parentNode;a&&(a.removeAttribute("aria-hidden"),a.setAttribute("aria-label",g.langFormat("accessibility.exporting.chartMenuLabel",{chart:g})))}},getKeyboardNavigation:function(){var g=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[g.left,g.up],function(){return a.onKbdPrevious(this)}],[[g.right,g.down],function(){return a.onKbdNext(this)}],[[g.enter,g.space],function(){return a.onKbdClick(this)}]],validate:function(){return!!d.exporting&&d.options.exporting.enabled!==!1&&d.options.exporting.accessibility.enabled!==!1},init:function(){var p=a.exportButtonProxy,v=d.exportingGroup;v&&p&&d.setFocusToElement(v,p)},terminate:function(){d.hideExportMenu()}})},onKbdPrevious:function(g){for(var d=this.chart,a=d.options.accessibility,p=g.response,v=d.highlightedExportItemIx||0;v--;)if(d.highlightExportItem(v))return p.success;return a.keyboardNavigation.wrapAround?(d.highlightLastExportItem(),p.success):p.prev},onKbdNext:function(g){for(var d=this.chart,a=d.options.accessibility,p=g.response,v=(d.highlightedExportItemIx||0)+1;v<d.exportDivElements.length;++v)if(d.highlightExportItem(v))return p.success;return a.keyboardNavigation.wrapAround?(d.highlightExportItem(0),p.success):p.next},onKbdClick:function(g){var d=this.chart,a=d.exportDivElements[d.highlightedExportItemIx],p=getExportMenuButtonElement(d).element;return this.isExportMenuShown?this.fakeClickEvent(a):(this.fakeClickEvent(p),d.highlightExportItem(0)),g.response.success}});var seriesTypes$5=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$s=Utilities.defined,extend$$=Utilities.extend,fireEvent$f=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$f.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(g){seriesTypes$5[g]&&(seriesTypes$5[g].prototype.keyboardMoveVertical=!1)});function getPointIndex(g){var d=g.index,a=g.series.points,p=a.length;if(a[d]!==g){for(;p--;)if(a[p]===g)return p}else return d}function isSkipSeries(g){var d=g.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation,p=g.options.accessibility||{},v=p.keyboardNavigation;return v&&v.enabled===!1||p.enabled===!1||g.options.enableMouseTracking===!1||!g.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=g.points.length}function isSkipPoint(g){var d=g.series.chart.options.accessibility,a=g.options.accessibility&&g.options.accessibility.enabled===!1;return g.isNull&&d.keyboardNavigation.seriesNavigation.skipNullPoints||g.visible===!1||g.isInside===!1||a||isSkipSeries(g.series)}function getClosestPoint(g,d,a,p){var v=1/0,C,P,k,z=d.points.length,$=function(D){return!(defined$s(D.plotX)&&defined$s(D.plotY))};if(!$(g)){for(;z--;)C=d.points[z],!$(C)&&(k=(g.plotX-C.plotX)*(g.plotX-C.plotX)*a+(g.plotY-C.plotY)*(g.plotY-C.plotY)*1,k<v&&(v=k,P=z));return defined$s(P)?d.points[P]:void 0}}Point$4.prototype.highlight=function(){var g=this.series.chart;return this.isNull?g.tooltip&&g.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&g.setFocusToElement(this.graphic),g.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(g){var d=this,a=d.series,p=d.highlightedPoint,v=p&&getPointIndex(p)||0,C=p&&p.series.points,P=d.series&&d.series[d.series.length-1],k=P&&P.points&&P.points[P.points.length-1],z,$;if(!a[0]||!a[0].points)return!1;if(!p)$=g?a[0].points[0]:k;else if(z=a[p.series.index+(g?1:-1)],$=C[v+(g?1:-1)],!$&&z&&($=z.points[g?0:z.points.length-1]),!$)return!1;return isSkipPoint($)?(z=$.series,isSkipSeries(z)?d.highlightedPoint=g?z.points[z.points.length-1]:z.points[0]:d.highlightedPoint=$,d.highlightAdjacentPoint(g)):$.highlight()};Series$f.prototype.highlightFirstValidPoint=function(){var g=this.chart.highlightedPoint,d=(g&&g.series)===this?getPointIndex(g):0,a=this.points,p=a.length;if(a&&p){for(var v=d;v<p;++v)if(!isSkipPoint(a[v]))return a[v].highlight();for(var C=d;C>=0;--C)if(!isSkipPoint(a[C]))return a[C].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(g){var d=this,a=d.highlightedPoint,p=d.series&&d.series[d.series.length-1],v=p&&p.points&&p.points[p.points.length-1],C,P,k;return d.highlightedPoint?(C=d.series[a.series.index+(g?-1:1)],!C||(P=getClosestPoint(a,C,4),!P)?!1:isSkipSeries(C)?(P.highlight(),k=d.highlightAdjacentSeries(g),k||(a.highlight(),!1)):(P.highlight(),P.series.highlightFirstValidPoint())):(C=g?d.series&&d.series[0]:p,P=g?C&&C.points&&C.points[0]:v,P?P.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(g){var d=this.highlightedPoint,a=1/0,p;return!defined$s(d.plotX)||!defined$s(d.plotY)?!1:(this.series.forEach(function(v){isSkipSeries(v)||v.points.forEach(function(C){if(!(!defined$s(C.plotY)||!defined$s(C.plotX)||C===d)){var P=C.plotY-d.plotY,k=Math.abs(C.plotX-d.plotX),z=Math.abs(P)*Math.abs(P)+k*k*4;v.yAxis&&v.yAxis.reversed&&(P*=-1),!(P<=0&&g||P>=0&&!g||z<5||isSkipPoint(C))&&z<a&&(a=z,p=C)}})}),p?p.highlight():!1)};function highlightFirstValidPointInChart(g){var d=!1;return delete g.highlightedPoint,d=g.series.reduce(function(a,p){return a||p.highlightFirstValidPoint()},!1),d}function highlightLastValidPointInChart(g){for(var d=g.series.length,a=d,p=!1;a--&&(g.highlightedPoint=g.series[a].points[g.series[a].points.length-1],p=g.series[a].highlightFirstValidPoint(),!p););return p}function updateChartFocusAfterDrilling(g){highlightFirstValidPointInChart(g),g.focusElement&&g.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(g,d){this.keyCodes=d,this.chart=g}extend$$(SeriesKeyboardNavigation.prototype,{init:function(){var g=this,d=this.chart,a=this.eventProvider=new EventProvider;a.addEvent(Series$f,"destroy",function(){return g.onSeriesDestroy(this)}),a.addEvent(d,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),a.addEvent(d,"drilldown",function(p){var v=p.point,C=v.series;g.lastDrilledDownPoint={x:v.x,y:v.y,seriesName:C?C.name:""}}),a.addEvent(d,"drillupall",function(){setTimeout(function(){g.onDrillupAll()},10)}),a.addEvent(Point$4,"afterSetState",function(){var p=this,v=p.graphic&&p.graphic.element;d.highlightedPoint===p&&doc$a.activeElement!==v&&v&&v.focus&&v.focus()})},onDrillupAll:function(){var g=this.lastDrilledDownPoint,d=this.chart,a=g&&getSeriesFromName(d,g.seriesName),p;g&&a&&defined$s(g.x)&&defined$s(g.y)&&(p=getPointFromXY(a,g.x,g.y)),d.container&&d.container.focus(),p&&p.highlight&&p.highlight(),d.focusElement&&d.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var g=this,d=this.keyCodes,a=this.chart,p=a.inverted;return new KeyboardNavigationHandler(a,{keyCodeMap:[[p?[d.up,d.down]:[d.left,d.right],function(v){return g.onKbdSideways(this,v)}],[p?[d.left,d.right]:[d.up,d.down],function(v){return g.onKbdVertical(this,v)}],[[d.enter,d.space],function(v,C){var P=a.highlightedPoint;return P&&(C.point=P,fireEvent$f(P.series,"click",C),P.firePointEvent("click")),this.response.success}]],init:function(v){return g.onHandlerInit(this,v)},terminate:function(){return g.onHandlerTerminate()}})},onKbdSideways:function(g,d){var a=this.keyCodes,p=d===a.right||d===a.down;return this.attemptHighlightAdjacentPoint(g,p)},onKbdVertical:function(g,d){var a=this.chart,p=this.keyCodes,v=d===p.down||d===p.right,C=a.options.accessibility.keyboardNavigation.seriesNavigation;if(C.mode&&C.mode==="serialize")return this.attemptHighlightAdjacentPoint(g,v);var P=a.highlightedPoint&&a.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return a[P](v),g.response.success},onHandlerInit:function(g,d){var a=this.chart;return d>0?highlightFirstValidPointInChart(a):highlightLastValidPointInChart(a),g.response.success},onHandlerTerminate:function(){var g=this.chart;g.tooltip&&g.tooltip.hide(0);var d=g.highlightedPoint&&g.highlightedPoint.series;d&&d.onMouseOut&&d.onMouseOut(),g.highlightedPoint&&g.highlightedPoint.onMouseOut&&g.highlightedPoint.onMouseOut(),delete g.highlightedPoint},attemptHighlightAdjacentPoint:function(g,d){var a=this.chart,p=a.options.accessibility.keyboardNavigation.wrapAround,v=a.highlightAdjacentPoint(d);return v?g.response.success:p?g.init(d?1:-1):g.response[d?"next":"prev"]},onSeriesDestroy:function(g){var d=this.chart,a=d.highlightedPoint&&d.highlightedPoint.series===g;a&&(delete d.highlightedPoint,d.focusElement&&d.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(g){var d=g.annotations||[];return d.reduce(function(a,p){return p.options&&p.options.visible!==!1&&(a=a.concat(p.labels)),a},[])}function getLabelText(g){return g.options&&g.options.accessibility&&g.options.accessibility.description||g.graphic&&g.graphic.text&&g.graphic.text.textStr||""}function getAnnotationLabelDescription(g){var d=g.options&&g.options.accessibility&&g.options.accessibility.description;if(d)return d;var a=g.chart,p=getLabelText(g),v=g.points,C=function(N){return N.graphic&&N.graphic.element&&N.graphic.element.getAttribute("aria-label")||""},P=function(N){var W=N.accessibility&&N.accessibility.valueDescription||C(N),j=N&&N.series.name||"";return(j?j+", ":"")+"data point "+W},k=v.filter(function(N){return!!N.graphic}).map(P).filter(function(N){return!!N}),z=k.length,$=z>1?"MultiplePoints":z?"SinglePoint":"NoPoints",D="accessibility.screenReaderSection.annotations.description"+$,F={annotationText:p,annotation:g,numPoints:z,annotationPoint:k[0],additionalAnnotationPoints:k.slice(1)};return a.langFormat(D,F)}function getAnnotationListItems(g){var d=getChartAnnotationLabels(g);return d.map(function(a){var p=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(a)));return p?"<li>"+p+"</li>":""})}function getAnnotationsInfoHTML$1(g){var d=g.annotations;if(!(d&&d.length))return"";var a=getAnnotationListItems(g);return'<ul style="list-style-type: none">'+a.join(" ")+"</ul>"}function getPointAnnotationTexts$1(g){var d=getChartAnnotationLabels(g.series.chart),a=d.filter(function(p){return p.points.indexOf(g)>-1});return a.length?a.map(function(p){return""+getLabelText(p)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$6=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$8=Utilities.find,isNumber$r=Utilities.isNumber,pick$10=Utilities.pick,defined$r=Utilities.defined;function findFirstPointWithGraphic(g){var d=g.index;return!g.series||!g.series.data||!defined$r(d)?null:find$8(g.series.data,function(a){return!!(a&&typeof a.index<"u"&&a.index>d&&a.graphic&&a.graphic.element)})||null}function shouldAddDummyPoint(g){var d=g.series&&g.series.is("sunburst"),a=g.isNull;return a&&!d}function makeDummyElement(g,d){var a=g.series.chart.renderer,p=a.rect(d.x,d.y,1,1);return p.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),p}function addDummyPointElement(g){var d=g.series,a=findFirstPointWithGraphic(g),p=a&&a.graphic,v=p?p.parentGroup:d.graph||d.group,C=a?{x:pick$10(g.plotX,a.plotX,0),y:pick$10(g.plotY,a.plotY,0)}:{x:pick$10(g.plotX,0),y:pick$10(g.plotY,0)},P=makeDummyElement(g,C);if(v&&v.element)return g.graphic=P,g.hasDummyGraphic=!0,P.add(v),v.element.insertBefore(P.element,p?p.element:null),P.element}function hasMorePointsThanDescriptionThreshold(g){var d=g.chart.options.accessibility,a=d.series.pointDescriptionEnabledThreshold;return!!(a!==!1&&g.points&&g.points.length>=a)}function shouldSetScreenReaderPropsOnPoints(g){var d=g.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(g)&&!d.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(g){var d=g.chart.options.accessibility,a=d.keyboardNavigation.seriesNavigation;return!!(g.points&&(g.points.length<a.pointNavigationEnabledThreshold||a.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(g){var d=g.chart,a=d.options.chart,p=a.options3d&&a.options3d.enabled,v=d.series.length>1,C=d.options.accessibility.series.describeSingleSeries,P=(g.options.accessibility||{}).exposeAsGroupOnly,k=p&&v;return!k&&(v||C||P||hasMorePointsThanDescriptionThreshold(g))}function pointNumberToString(g,d){var a=g.series.chart,p=a.options.accessibility.point||{},v=g.series.tooltipOptions||{},C=a.options.lang;return isNumber$r(d)?numberFormat(d,p.valueDecimals||v.valueDecimals||-1,C.decimalPoint,C.accessibility.thousandsSep||C.thousandsSep):d}function getSeriesDescriptionText(g){var d=g.options.accessibility||{},a=d.description;return a&&g.chart.langFormat("accessibility.series.description",{description:a,series:g})||""}function getSeriesAxisDescriptionText(g,d){var a=g[d];return g.chart.langFormat("accessibility.series."+d+"Description",{name:getAxisDescription$1(a),series:g})}function getPointA11yTimeDescription(g){var d=g.series,a=d.chart,p=a.options.accessibility.point||{},v=d.xAxis&&d.xAxis.dateTime;if(v){var C=v.getXDateFormat(g.x||0,a.options.tooltip.dateTimeLabelFormats),P=p.dateFormatter&&p.dateFormatter(g)||p.dateFormat||C;return a.time.dateFormat(P,g.x||0,void 0)}}function getPointXDescription(g){var d=getPointA11yTimeDescription(g),a=g.series.xAxis||{},p=a.categories&&defined$r(g.category)&&(""+g.category).replace("<br/>"," "),v=g.id&&g.id.indexOf("highcharts-")<0,C="x, "+g.x;return g.name||d||p||(v?g.id:C)}function getPointArrayMapValueDescription(g,d,a){var p=d||"",v=a||"",C=function(k){var z=pointNumberToString(g,pick$10(g[k],g.options[k]));return k+": "+p+z+v},P=g.series.pointArrayMap;return P.reduce(function(k,z){return k+(k.length?", ":"")+C(z)},"")}function getPointValue(g){var d=g.series,a=d.chart.options.accessibility.point||{},p=d.tooltipOptions||{},v=a.valuePrefix||p.valuePrefix||"",C=a.valueSuffix||p.valueSuffix||"",P=typeof g.value<"u"?"value":"y",k=pointNumberToString(g,g[P]);return g.isNull?d.chart.langFormat("accessibility.series.nullPointValue",{point:g}):d.pointArrayMap?getPointArrayMapValueDescription(g,v,C):v+k+C}function getPointAnnotationDescription(g){var d=g.series.chart,a="accessibility.series.pointAnnotationsDescription",p=getPointAnnotationTexts(g),v={point:g,annotations:p};return p.length?d.langFormat(a,v):""}function getPointValueDescription(g){var d=g.series,a=d.chart,p=a.options.accessibility.point.valueDescriptionFormat,v=pick$10(d.xAxis&&d.xAxis.options.accessibility&&d.xAxis.options.accessibility.enabled,!a.angular),C=v?getPointXDescription(g):"",P={point:g,index:defined$r(g.index)?g.index+1:"",xDescription:C,value:getPointValue(g),separator:v?", ":""};return format$6(p,P,a)}function defaultPointDescriptionFormatter$1(g){var d=g.series,a=d.chart,p=getPointValueDescription(g),v=g.options&&g.options.accessibility&&g.options.accessibility.description,C=v?" "+v:"",P=a.series.length>1&&d.name?" "+d.name+".":"",k=getPointAnnotationDescription(g),z=k?" "+k:"";return g.accessibility=g.accessibility||{},g.accessibility.valueDescription=p,p+C+P+z}function setPointScreenReaderAttribs(g,d){var a=g.series,p=a.chart.options.accessibility.point||{},v=a.options.accessibility||{},C=stripHTMLTags$1(v.pointDescriptionFormatter&&v.pointDescriptionFormatter(g)||p.descriptionFormatter&&p.descriptionFormatter(g)||defaultPointDescriptionFormatter$1(g));d.setAttribute("role","img"),d.setAttribute("aria-label",C)}function describePointsInSeries(g){var d=shouldSetScreenReaderPropsOnPoints(g),a=shouldSetKeyboardNavPropsOnPoints(g);(d||a)&&g.points.forEach(function(p){var v=p.graphic&&p.graphic.element||shouldAddDummyPoint(p)&&addDummyPointElement(p),C=p.options&&p.options.accessibility&&p.options.accessibility.enabled===!1;v&&(v.setAttribute("tabindex","-1"),v.style.outline="0",d&&!C?setPointScreenReaderAttribs(p,v):v.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(g){var d=g.chart,a=d.types||[],p=getSeriesDescriptionText(g),v=function(D){return d[D]&&d[D].length>1&&g[D]},C=getSeriesAxisDescriptionText(g,"xAxis"),P=getSeriesAxisDescriptionText(g,"yAxis"),k={name:g.name||"",ix:g.index+1,numSeries:d.series&&d.series.length,numPoints:g.points&&g.points.length,series:g},z=a.length>1?"Combination":"",$=d.langFormat("accessibility.series.summary."+g.type+z,k)||d.langFormat("accessibility.series.summary.default"+z,k);return $+(p?" "+p:"")+(v("yAxis")?" "+P:"")+(v("xAxis")?" "+C:"")}function describeSeriesElement(g,d){var a=g.options.accessibility||{},p=g.chart.options.accessibility,v=p.landmarkVerbosity;a.exposeAsGroupOnly?d.setAttribute("role","img"):v==="all"&&d.setAttribute("role","region"),d.setAttribute("tabindex","-1"),d.style.outline="0",d.setAttribute("aria-label",stripHTMLTags$1(p.series.descriptionFormatter&&p.series.descriptionFormatter(g)||defaultSeriesDescriptionFormatter$1(g)))}function describeSeries$1(g){var d=g.chart,a=getSeriesFirstPointElement(g),p=getSeriesA11yElement(g),v=d.is3d&&d.is3d();p&&(p.lastChild===a&&!v&&reverseChildNodes(p),describePointsInSeries(g),unhideChartElementFromAT$4(d,p),shouldDescribeSeriesElement(g)?describeSeriesElement(g,p):p.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=(function(){function g(d,a){this.chart=d,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(a)}return g.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},g.prototype.announce=function(d){var a=this;AST.setElementHTML(this.announceRegion,d),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){a.announceRegion.innerHTML="",delete a.clearAnnouncementRegionTimer},1e3)},g.prototype.addAnnounceRegion=function(d){var a=this.chart.announcerContainer||this.createAnnouncerContainer(),p=this.domElementProvider.createElement("div");return setElAttrs$3(p,{"aria-hidden":!1,"aria-live":d}),visuallyHideElement$1(p),a.appendChild(p),p},g.prototype.createAnnouncerContainer=function(){var d=this.chart,a=doc$9.createElement("div");return setElAttrs$3(a,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),d.renderTo.insertBefore(a,d.renderTo.firstChild),d.announcerContainer=a,a},g})(),extend$_=Utilities.extend,defined$q=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(g){return!!g.options.accessibility.announceNewData.enabled}function findPointInDataArray(g){var d=g.series.data.filter(function(a){return g.x===a.x&&g.y===a.y});return d.length===1?d[0]:g}function getUniqueSeries(g,d){var a=(g||[]).concat(d||[]).reduce(function(p,v){return p[v.name+v.index]=v,p},{});return Object.keys(a).map(function(p){return a[p]})}var NewDataAnnouncer=function(g){this.chart=g};extend$_(NewDataAnnouncer.prototype,{init:function(){var g=this.chart,d=g.options.accessibility.announceNewData,a=d.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(g,a),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var g=this,d=this.chart,a=this.eventProvider;a.addEvent(d,"afterDrilldown",function(){g.lastAnnouncementTime=0}),a.addEvent(Series$f,"updatedData",function(){g.onSeriesUpdatedData(this)}),a.addEvent(d,"afterAddSeries",function(p){g.onSeriesAdded(p.series)}),a.addEvent(Series$f,"addPoint",function(p){g.onPointAdded(p.point)}),a.addEvent(d,"redraw",function(){g.announceDirtyData()})},onSeriesUpdatedData:function(g){var d=this.chart;g.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[g.name+g.index]=g)},onSeriesAdded:function(g){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[g.name+g.index]=g,this.dirty.newSeries=defined$q(this.dirty.newSeries)?void 0:g)},onPointAdded:function(g){var d=g.series.chart;this.chart===d&&chartHasAnnounceEnabled(d)&&(this.dirty.newPoint=defined$q(this.dirty.newPoint)?void 0:g)},announceDirtyData:function(){var g=this.chart,d=this;if(g.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=findPointInDataArray(a)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(p){return d.dirty.allSeries[p]}),this.dirty.newSeries,a),this.dirty={allSeries:{}}}},queueAnnouncement:function(g,d,a){var p=this,v=this.chart,C=v.options.accessibility.announceNewData;if(C.enabled){var P=+new Date,k=P-this.lastAnnouncementTime,z=Math.max(0,C.minAnnounceInterval-k),$=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,g),D=this.buildAnnouncementMessage($,d,a);D&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:P,message:D,series:$},this.queuedAnnouncementTimer=setTimeout(function(){p&&p.announcer&&(p.lastAnnouncementTime=+new Date,p.announcer.announce(p.queuedAnnouncement.message),delete p.queuedAnnouncement,delete p.queuedAnnouncementTimer)},z))}},buildAnnouncementMessage:function(g,d,a){var p=this.chart,v=p.options.accessibility.announceNewData;if(v.announcementFormatter){var C=v.announcementFormatter(g,d,a);if(C!==!1)return C.length?C:null}var P=H.charts&&H.charts.length>1?"Multiple":"Single",k=d?"newSeriesAnnounce"+P:a?"newPointAnnounce"+P:"newDataAnnounce",z=getChartTitle$2(p);return p.langFormat("accessibility.announceNewData."+k,{chartTitle:z,seriesDesc:d?defaultSeriesDescriptionFormatter(d):null,pointDesc:a?defaultPointDescriptionFormatter(a):null,point:a,series:d})}});var addEvent$G=Utilities.addEvent,merge$U=Utilities.merge;function isWithinDescriptionThreshold(g){var d=g.chart.options.accessibility;return g.points.length<d.series.pointDescriptionEnabledThreshold||d.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(g){var d=g.chart,a=d.options.accessibility.enabled,p=(g.options.accessibility&&g.options.accessibility.enabled)!==!1;return a&&p&&isWithinDescriptionThreshold(g)}function hasIndividualPointMarkerOptions(g){return!!(g._hasPointMarkers&&g.points&&g.points.length)}function unforceSeriesMarkerOptions(g){var d=g.resetA11yMarkerOptions;d&&merge$U(!0,g.options,{marker:{enabled:d.enabled,states:{normal:{opacity:d.states&&d.states.normal&&d.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(g){merge$U(!0,g,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(g){return g.marker.states&&g.marker.states.normal&&g.marker.states.normal.opacity||1}function unforcePointMarkerOptions(g){merge$U(!0,g.marker,{states:{normal:{opacity:getPointMarkerOpacity(g)}}})}function handleForcePointMarkers(g){for(var d=g.points.length;d--;){var a=g.points[d],p=a.options;delete a.hasForcedA11yMarker,p.marker&&(p.marker.enabled?(unforcePointMarkerOptions(p),a.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(p),a.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$G(Series$f,"render",function(){var g=this,d=g.options;shouldForceMarkers(g)?(d.marker&&d.marker.enabled===!1&&(g.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(g.options)),hasIndividualPointMarkerOptions(g)&&handleForcePointMarkers(g)):g.a11yMarkersForced&&(delete g.a11yMarkersForced,unforceSeriesMarkerOptions(g))}),addEvent$G(Series$f,"afterSetOptions",function(g){this.resetA11yMarkerOptions=merge$U(g.options.marker||{},this.userOptions.marker||{})}),addEvent$G(Series$f,"afterRender",function(){var g=this;g.chart.styledMode&&(g.markerGroup&&g.markerGroup[g.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(g)&&g.points.forEach(function(d){d.graphic&&(d.graphic[d.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),d.graphic[d.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$Z=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$Z(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var g=this;this.addEvent(Tooltip,"refresh",function(){this.chart===g.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(g){g.labelBySeries&&g.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var g=this.chart;g.series.forEach(function(d){var a=(d.options.accessibility&&d.options.accessibility.enabled)!==!1&&d.visible;a?describeSeries(d):hideSeriesFromAT(d)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$c=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Y=Utilities.extend,pick$$=Utilities.pick;function chartHasMapZoom(g){return!!(g.mapZoom&&g.mapNavButtons&&g.mapNavButtons.length)}H.Axis.prototype.panStep=function(g,d){var a=d||3,p=this.getExtremes(),v=(p.max-p.min)/a*g,C=p.max+v,P=p.min+v,k=C-P;g<0&&P<p.dataMin?(P=p.dataMin,C=P+k):g>0&&C>p.dataMax&&(C=p.dataMax,P=C-k),this.setExtremes(P,C)};var ZoomComponent=noop$c;ZoomComponent.prototype=new AccessibilityComponent;extend$Y(ZoomComponent.prototype,{init:function(){var g=this,d=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){g.addEvent(d,a,function(){g.updateProxyOverlays()})})},onChartUpdate:function(){var g=this.chart,d=this;g.mapNavButtons&&g.mapNavButtons.forEach(function(a,p){unhideChartElementFromAT$3(g,a.element),d.setMapNavButtonAttrs(a.element,"accessibility.zoom.mapZoom"+(p?"Out":"In"))})},setMapNavButtonAttrs:function(g,d){var a=this.chart,p=a.langFormat(d,{chart:a});setElAttrs$2(g,{tabindex:-1,role:"button","aria-label":p})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var g=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),g.resetZoomButton&&this.recreateProxyButtonAndGroup(g.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",g.langFormat("accessibility.zoom.resetZoomButton",{chart:g})),g.drillUpButton&&this.recreateProxyButtonAndGroup(g.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",g.langFormat("accessibility.drillUpButton",{chart:g,buttonText:g.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(g,d,a,p){removeElement(this[a]),this[a]=this.addProxyGroup(),this[d]=this.createProxyButton(g,this[a],{"aria-label":p,tabindex:-1})},getMapZoomNavigation:function(){var g=this.keyCodes,d=this.chart,a=this;return new KeyboardNavigationHandler(d,{keyCodeMap:[[[g.up,g.down,g.left,g.right],function(p){return a.onMapKbdArrow(this,p)}],[[g.tab],function(p,v){return a.onMapKbdTab(this,v)}],[[g.space,g.enter],function(){return a.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(d)},init:function(p){return a.onMapNavInit(p)}})},onMapKbdArrow:function(g,d){var a=this.keyCodes,p=d===a.up||d===a.down?"yAxis":"xAxis",v=d===a.left||d===a.up?-1:1;return this.chart[p][0].panStep(v),g.response.success},onMapKbdTab:function(g,d){var a,p=this.chart,v=g.response,C=d.shiftKey,P=C&&!this.focusedMapNavButtonIx||!C&&this.focusedMapNavButtonIx;return p.mapNavButtons[this.focusedMapNavButtonIx].setState(0),P?(p.mapZoom(),v[C?"prev":"next"]):(this.focusedMapNavButtonIx+=C?-1:1,a=p.mapNavButtons[this.focusedMapNavButtonIx],p.setFocusToElement(a.box,a.element),a.setState(2),v.success)},onMapKbdClick:function(g){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),g.response.success},onMapNavInit:function(g){var d=this.chart,a=d.mapNavButtons[0],p=d.mapNavButtons[1],v=g>0?a:p;d.setFocusToElement(v.box,v.element),v.setState(2),this.focusedMapNavButtonIx=g>0?0:1},simpleButtonNavigation:function(g,d,a){var p=this.keyCodes,v=this,C=this.chart;return new KeyboardNavigationHandler(C,{keyCodeMap:[[[p.tab,p.up,p.down,p.left,p.right],function(P,k){var z=P===p.tab&&k.shiftKey||P===p.left||P===p.up;return this.response[z?"prev":"next"]}],[[p.space,p.enter],function(){var P=a(this,C);return pick$$(P,this.response.success)}]],validate:function(){var P=C[g]&&C[g].box&&v[d];return P},init:function(){C.setFocusToElement(C[g].box,v[d])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(g,d){d.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(g,d){return d.drillUp(),g.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$F=Utilities.addEvent,extend$X=Utilities.extend;function shouldRunInputNavigation(g){return!!(g.rangeSelector&&g.rangeSelector.inputGroup&&g.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&g.options.rangeSelector.inputEnabled!==!1&&g.rangeSelector.minInput&&g.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(g){var d=this.rangeSelector&&this.rangeSelector.buttons||[],a=this.highlightedRangeSelectorItemIx,p=this.rangeSelector&&this.rangeSelector.selected;return typeof a<"u"&&d[a]&&a!==p&&d[a].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=g,d[g]?(this.setFocusToElement(d[g].box,d[g].element),g!==p&&(this.oldRangeSelectorItemState=d[g].state,d[g].setState(1)),!0):!1};addEvent$F(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$X(RangeSelectorComponent.prototype,{init:function(){var g=this.chart;this.announcer=new Announcer(g,"polite")},onChartUpdate:function(){var g=this.chart,d=this,a=g.rangeSelector;a&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),a.buttons&&a.buttons.length&&a.buttons.forEach(function(p){d.setRangeButtonAttrs(p)}),a.maxInput&&a.minInput&&["minInput","maxInput"].forEach(function(p,v){var C=a[p];C&&(unhideChartElementFromAT$2(g,C),d.setRangeInputAttrs(C,"accessibility.rangeSelector."+(v?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var g=this.chart,d=g.rangeSelector,a=d&&d.dropdown,p=d&&d.buttons||[],v=function(C){return C.setAttribute("aria-hidden",!0)};d&&d.hasVisibleDropdown&&a?(unhideChartElementFromAT$2(g,a),p.forEach(function(C){return v(C.element)})):(a&&v(a),p.forEach(function(C){return unhideChartElementFromAT$2(g,C.element)}))},setDropdownAttrs:function(){var g=this.chart,d=g.rangeSelector&&g.rangeSelector.dropdown;if(d){var a=g.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:g.options.lang.rangeSelectorZoom});d.setAttribute("aria-label",a),d.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(g){setElAttrs$1(g.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(g,d){var a=this.chart;setElAttrs$1(g,{tabindex:-1,"aria-label":a.langFormat(d,{chart:a})})},onButtonNavKbdArrowKey:function(g,d){var a=g.response,p=this.keyCodes,v=this.chart,C=v.options.accessibility.keyboardNavigation.wrapAround,P=d===p.left||d===p.up?-1:1,k=v.highlightRangeSelectorButton(v.highlightedRangeSelectorItemIx+P);return k?a.success:C?(g.init(P),a.success):a[P>0?"next":"prev"]},onButtonNavKbdClick:function(g){var d=g.response,a=this.chart,p=a.oldRangeSelectorItemState===3;return p||this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element),d.success},onAfterBtnClick:function(){var g=this.chart,d=getAxisRangeDescription$1(g.xAxis[0]),a=g.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:g,axisRangeDescription:d});a&&this.announcer.announce(a)},onInputKbdMove:function(g){var d=this.chart,a=d.rangeSelector,p=d.highlightedInputRangeIx=(d.highlightedInputRangeIx||0)+g,v=p>1||p<0;if(v)d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[g<0?"prev":"next"]());else if(a){var C=a[p?"maxDateBox":"minDateBox"],P=a[p?"maxInput":"minInput"];C&&P&&d.setFocusToElement(C,P)}},onInputNavInit:function(g){var d=this,a=this,p=this.chart,v=g>0?0:1,C=p.rangeSelector,P=C&&C[v?"maxDateBox":"minDateBox"],k=C&&C.minInput,z=C&&C.maxInput,$=v?z:k;if(p.highlightedInputRangeIx=v,P&&k&&z){p.setFocusToElement(P,$),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var D=function(W){var j=(W.which||W.keyCode)===d.keyCodes.tab;j&&(W.preventDefault(),W.stopPropagation(),a.onInputKbdMove(W.shiftKey?-1:1))},F=addEvent$F(k,"keydown",D),N=addEvent$F(z,"keydown",D);this.removeInputKeydownHandler=function(){F(),N()}}},onInputNavTerminate:function(){var g=this.chart.rangeSelector||{};g.maxInput&&g.hideInput("max"),g.minInput&&g.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var g=this,d=this.chart,a=d.rangeSelector,p=a&&a.dropdown;a&&p&&(d.setFocusToElement(a.buttonGroup,p),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$F(p,"keydown",function(v){var C=(v.which||v.keyCode)===g.keyCodes.tab;C&&(v.preventDefault(),v.stopPropagation(),d.accessibility&&(d.accessibility.keyboardNavigation.tabindexContainer.focus(),d.accessibility.keyboardNavigation[v.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var g=this.chart,d=this.keyCodes,a=this;return new KeyboardNavigationHandler(g,{keyCodeMap:[[[d.left,d.right,d.up,d.down],function(p){return a.onButtonNavKbdArrowKey(this,p)}],[[d.enter,d.space],function(){return a.onButtonNavKbdClick(this)}]],validate:function(){return!!(g.rangeSelector&&g.rangeSelector.buttons&&g.rangeSelector.buttons.length)},init:function(p){var v=g.rangeSelector;if(v&&v.hasVisibleDropdown)a.initDropdownNav();else if(v){var C=v.buttons.length-1;g.highlightRangeSelectorButton(p>0?0:C)}},terminate:function(){a.removeDropdownKeydownHandler&&(a.removeDropdownKeydownHandler(),delete a.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var g=this.chart,d=this;return new KeyboardNavigationHandler(g,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(g)},init:function(a){d.onInputNavInit(a)},terminate:function(){d.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$5=FormatUtilities.format,doc$8=H.doc,extend$W=Utilities.extend,pick$_=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(g){return g.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(g,d){return d.mapTitle?g.langFormat("accessibility.chartTypes.mapTypeDescription",d):g.langFormat("accessibility.chartTypes.unknownMap",d)}function getTypeDescForCombinationChart(g,d){return g.langFormat("accessibility.chartTypes.combinationChart",d)}function getTypeDescForEmptyChart(g,d){return g.langFormat("accessibility.chartTypes.emptyChart",d)}function buildTypeDescriptionFromSeries(g,d,a){var p=d[0],v=g.langFormat("accessibility.seriesTypeDescriptions."+p,a),C=g.series&&g.series.length<2?"Single":"Multiple";return(g.langFormat("accessibility.chartTypes."+p+C,a)||g.langFormat("accessibility.chartTypes.default"+C,a))+(v?" "+v:"")}function getTableSummary(g){return g.langFormat("accessibility.table.tableSummary",{chart:g})}Chart$1.prototype.getTypeDescription=function(g){var d=g[0],a=this.series&&this.series[0]||{},p={numSeries:this.series.length,numPoints:a.points&&a.points.length,chart:this,mapTitle:a.mapTitle};return d?d==="map"?getTypeDescForMapChart(this,p):this.types.length>1?getTypeDescForCombinationChart(this,p):buildTypeDescriptionFromSeries(this,g,p):getTypeDescForEmptyChart(this,p)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$W(InfoRegionsComponent.prototype,{init:function(){var g=this.chart,d=this;this.initRegionsDefinitions(),this.addEvent(g,"aftergetTableAST",function(a){d.onDataTableCreated(a)}),this.addEvent(g,"afterViewData",function(a){d.dataTableDiv=a,setTimeout(function(){d.focusDataTable()},300)}),this.announcer=new Announcer(g,"assertive")},initRegionsDefinitions:function(){var g=this;this.screenReaderSections={before:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.beforeChartFormatter;return a?a(d):g.defaultBeforeChartFormatter(d)},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.renderTo.firstChild)},afterInserted:function(){typeof g.sonifyButtonId<"u"&&g.initSonifyButton(g.sonifyButtonId),typeof g.dataTableButtonId<"u"&&g.initDataTableButton(g.dataTableButtonId)}},after:{element:null,buildContent:function(d){var a=d.options.accessibility.screenReaderSection.afterChartFormatter;return a?a(d):g.defaultAfterChartFormatter()},insertIntoDOM:function(d,a){a.renderTo.insertBefore(d,a.container.nextSibling)},afterInserted:function(){g.chart.accessibility&&g.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var g=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(d){g.updateScreenReaderSection(d)})},getLinkedDescriptionElement:function(){var g=this.chart.options,d=g.accessibility.linkedDescription;if(d){if(typeof d!="string")return d;var a=format$5(d,this.chart),p=doc$8.querySelectorAll(a);if(p.length===1)return p[0]}},setLinkedDescriptionAttrs:function(){var g=this.linkedDescriptionElement;g&&(g.setAttribute("aria-hidden","true"),addClass(g,"highcharts-linked-description"))},updateScreenReaderSection:function(g){var d=this.chart,a=this.screenReaderSections[g],p=a.buildContent(d),v=a.element=a.element||this.createElement("div"),C=v.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(v,g),AST.setElementHTML(C,p),v.appendChild(C),a.insertIntoDOM(v,d),visuallyHideElement(C),unhideChartElementFromAT$1(d,C),a.afterInserted&&a.afterInserted()},setScreenReaderSectionAttribs:function(g,d){var a="accessibility.screenReaderSection."+d+"RegionLabel",p=this.chart,v=p.langFormat(a,{chart:p,chartTitle:getChartTitle$1(p)}),C="highcharts-screen-reader-region-"+d+"-"+p.index;setElAttrs(g,{id:C,"aria-label":v}),g.style.position="relative",p.options.accessibility.landmarkVerbosity==="all"&&v&&g.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var g=this.chart,d=g.options.accessibility.screenReaderSection.beforeChartFormat,a=this.getAxesDescription(),p=g.sonify&&g.options.sonification&&g.options.sonification.enabled,v="highcharts-a11y-sonify-data-btn-"+g.index,C="hc-linkto-highcharts-data-table-"+g.index,P=getAnnotationsInfoHTML(g),k=g.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:g}),z={headingTagName:getHeadingTagNameForElement(g.renderTo),chartTitle:getChartTitle$1(g),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:a.xAxis,yAxisDescription:a.yAxis,playAsSoundButton:p?this.getSonifyButtonText(v):"",viewTableButton:g.getCSV?this.getDataTableButtonText(C):"",annotationsTitle:P?k:"",annotationsList:P},$=H.i18nFormat(d,z,g);return this.dataTableButtonId=C,this.sonifyButtonId=v,stripEmptyHTMLTags($)},defaultAfterChartFormatter:function(){var g=this.chart,d=g.options.accessibility.screenReaderSection.afterChartFormat,a={endOfChartMarker:this.getEndOfChartMarkerText()},p=H.i18nFormat(d,a,g);return stripEmptyHTMLTags(p)},getLinkedDescription:function(){var g=this.linkedDescriptionElement,d=g&&g.innerHTML||"";return stripHTMLTagsFromString(d)},getLongdescText:function(){var g=this.chart.options,d=g.caption,a=d&&d.text,p=this.getLinkedDescription();return g.accessibility.description||p||a||""},getTypeDescriptionText:function(){var g=this.chart;return g.types?g.options.accessibility.typeDescription||g.getTypeDescription(g.types):""},getDataTableButtonText:function(g){var d=this.chart,a=d.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+g+'">'+a+"</button>"},getSonifyButtonText:function(g){var d=this.chart;if(d.options.sonification&&d.options.sonification.enabled===!1)return"";var a=d.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:d,chartTitle:getChartTitle$1(d)});return'<button id="'+g+'">'+a+"</button>"},getSubtitleText:function(){var g=this.chart.options.subtitle;return stripHTMLTagsFromString(g&&g.text||"")},getEndOfChartMarkerText:function(){var g=this.chart,d=g.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:g}),a="highcharts-end-of-chart-marker-"+g.index;return'<div id="'+a+'">'+d+"</div>"},onDataTableCreated:function(g){var d=this.chart;if(d.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var a=g.tree.attributes||{};a.tabindex=-1,a.summary=getTableSummary(d),g.tree.attributes=a}},focusDataTable:function(){var g=this.dataTableDiv,d=g&&g.getElementsByTagName("table")[0];d&&d.focus&&d.focus()},initSonifyButton:function(g){var d=this,a=this.sonifyButton=getElement(g),p=this.chart,v=function(C){a&&(a.setAttribute("aria-hidden","true"),a.setAttribute("aria-label","")),C.preventDefault(),C.stopPropagation();var P=p.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:p});d.announcer.announce(P),setTimeout(function(){a&&(a.removeAttribute("aria-hidden"),a.removeAttribute("aria-label")),p.sonify&&p.sonify()},1e3)};a&&p&&(setElAttrs(a,{tabindex:-1}),a.onclick=function(C){var P=p.options.accessibility&&p.options.accessibility.screenReaderSection.onPlayAsSoundClick;(P||v).call(this,C,p)})},initDataTableButton:function(g){var d=this.viewDataTableButton=getElement(g),a=this.chart,p=g.replace("hc-linkto-","");d&&(setElAttrs(d,{tabindex:-1,"aria-expanded":!!getElement(p)}),d.onclick=a.options.accessibility.screenReaderSection.onViewDataTableClick||function(){a.viewData()})},getAxesDescription:function(){var g=this.chart,d=function(k,z){var $=g[k];return $.length>1||$[0]&&pick$_($[0].options.accessibility&&$[0].options.accessibility.enabled,z)},a=!!g.types&&g.types.indexOf("map")<0,p=!!g.hasCartesianSeries,v=d("xAxis",!g.angular&&p&&a),C=d("yAxis",p&&a),P={};return v&&(P.xAxis=this.getAxisDescriptionText("xAxis")),C&&(P.yAxis=this.getAxisDescriptionText("yAxis")),P},getAxisDescriptionText:function(g){var d=this.chart,a=d[g];return d.langFormat("accessibility.axis."+g+"Description"+(a.length>1?"Plural":"Singular"),{chart:d,names:a.map(function(p){return getAxisDescription(p)}),ranges:a.map(function(p){return getAxisRangeDescription(p)}),numAxes:a.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$V=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$V(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var g=this.chart,d="highcharts-title-"+g.index,a=stripHTMLTags(g.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(g)}));if(a.length){var p=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");p.textContent=a,p.id=d,g.renderTo.insertBefore(p,g.renderTo.firstChild)}},setSVGContainerLabel:function(){var g=this.chart,d=g.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(g)});g.renderer.box&&d.length&&g.renderer.box.setAttribute("aria-label",d)},setGraphicContainerAttrs:function(){var g=this.chart,d=g.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(g)});d.length&&g.container.setAttribute("aria-label",d)},setRenderToAttrs:function(){var g=this.chart;g.options.accessibility.landmarkVerbosity!=="disabled"?g.renderTo.setAttribute("role","region"):g.renderTo.removeAttribute("role"),g.renderTo.setAttribute("aria-label",g.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(g),chart:g}))},makeCreditsAccessible:function(){var g=this.chart,d=g.credits;d&&(d.textStr&&d.element.setAttribute("aria-label",g.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(d.textStr)})),unhideChartElementFromAT(g,d.element))},getKeyboardNavigation:function(){var g=this.chart;return new KeyboardNavigationHandler(g,{keyCodeMap:[],validate:function(){return!0},init:function(){var d=g.accessibility;d&&d.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var g=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&g)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var d=doc$6.createElement("div"),a="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";d.style.backgroundImage="url("+a+")",doc$6.body.appendChild(d);var p=(d.currentStyle||win$3.getComputedStyle(d)).backgroundImage;return doc$6.body.removeChild(d),p==="none"}return!1},setHighContrastTheme:function(g){g.highContrastModeActive=!0;var d=g.options.accessibility.highContrastTheme;g.update(d,!1),g.series.forEach(function(a){var p=d.plotOptions[a.type]||{};a.update({color:p.color||"windowText",colors:[p.color||"windowText"],borderColor:p.borderColor||"window"}),a.points.forEach(function(v){v.options&&v.options.color&&v.update({color:p.color||"windowText",borderColor:p.borderColor||"window"},!1)})}),g.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$3=Utilities.error,pick$Z=Utilities.pick;function traverseSetOption(g,d,a){for(var p=g,v,C=0;C<d.length-1;++C)v=d[C],p=p[v]=pick$Z(p[v],{});p[d[d.length-1]]=a}function deprecateFromOptionsMap(g,d,a,p){function v(k,z){return z.reduce(function($,D){return $[D]},k)}var C=v(g.options,d),P=v(g.options,a);Object.keys(p).forEach(function(k){var z,$=C[k];typeof $<"u"&&(traverseSetOption(P,p[k],$),error$3(32,!1,g,(z={},z[d.join(".")+"."+k]=a.join(".")+"."+p[k].join("."),z)))})}function copyDeprecatedChartOptions(g){var d=g.options.chart,a=g.options.accessibility||{};["description","typeDescription"].forEach(function(p){var v;d[p]&&(a[p]=d[p],error$3(32,!1,g,(v={},v["chart."+p]="use accessibility."+p,v)))})}function copyDeprecatedAxisOptions(g){g.axes.forEach(function(d){var a=d.options;a&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,error$3(32,!1,g,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(g){var d={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};g.series.forEach(function(a){Object.keys(d).forEach(function(p){var v,C=a.options[p];typeof C<"u"&&(traverseSetOption(a.options,d[p],p==="skipKeyboardNavigation"?!C:C),error$3(32,!1,g,(v={},v["series."+p]="series."+d[p].join("."),v)))})})}function copyDeprecatedTopLevelAccessibilityOptions(g){deprecateFromOptionsMap(g,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(g){deprecateFromOptionsMap(g,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(g){deprecateFromOptionsMap(g,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(g){copyDeprecatedChartOptions(g),copyDeprecatedAxisOptions(g),g.series&&copyDeprecatedSeriesOptions(g),copyDeprecatedTopLevelAccessibilityOptions(g),copyDeprecatedKeyboardNavigationOptions(g),copyDeprecatedLangOptions(g)}var format$4=FormatUtilities.format,pick$Y=Utilities.pick;function stringTrim$1(g){return g.trim&&g.trim()||g.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(g,d){var a=g.indexOf("#each("),p=g.indexOf("#plural("),v=g.indexOf("["),C=g.indexOf("]"),P,k;if(a>-1){var z=g.slice(a).indexOf(")")+a,$=g.substring(0,a),D=g.substring(z+1),F=g.substring(a+6,z),N=F.split(","),W=Number(N[1]),j=void 0;if(k="",P=d[N[0]],P){W=isNaN(W)?P.length:W,j=W<0?P.length+W:Math.min(W,P.length);for(var q=0;q<j;++q)k+=$+P[q]+D}return k.length?k:""}if(p>-1){var X=g.slice(p).indexOf(")")+p,K=g.substring(p+8,X),ee=K.split(","),te=Number(d[ee[0]]);switch(te){case 0:k=pick$Y(ee[4],ee[1]);break;case 1:k=pick$Y(ee[2],ee[1]);break;case 2:k=pick$Y(ee[3],ee[1]);break;default:k=ee[1]}return k?stringTrim$1(k):""}if(v>-1){var ie=g.substring(0,v),oe=Number(g.substring(v+1,C)),ae=void 0;return P=d[ie],!isNaN(oe)&&P&&(oe<0?(ae=P[P.length+oe],typeof ae>"u"&&(ae=P[0])):(ae=P[oe],typeof ae>"u"&&(ae=P[P.length-1]))),typeof ae<"u"?ae:""}return"{"+g+"}"}H.i18nFormat=function(g,d,a){var p=function(z,$){var D=z.slice($||0),F=D.indexOf("{"),N=D.indexOf("}");if(F>-1&&N>F)return{statement:D.substring(F+1,N),begin:$+F+1,end:$+N}},v=[],C,P,k=0;do C=p(g,k),P=g.substring(k,C&&C.begin-1),P.length&&v.push({value:P,type:"constant"}),C&&v.push({value:C.statement,type:"statement"}),k=C?C.end+1:k+1;while(C);return v.forEach(function(z){z.type==="statement"&&(z.value=formatExtendedStatement(z.value,d))}),format$4(v.reduce(function(z,$){return z+$.value},""),d,a)};Chart$1.prototype.langFormat=function(g,d){for(var a=g.split("."),p=this.options.lang,v=0;v<a.length;++v)p=p&&p[a[v]];return typeof p=="string"?H.i18nFormat(p,d,this):""};var addEvent$E=Utilities.addEvent,extend$U=Utilities.extend,pick$X=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(g){if(!g.focusBorderDestroyHook){var d=g.destroy;g.destroy=function(){return g.focusBorder&&g.focusBorder.destroy&&g.focusBorder.destroy(),d.apply(g,arguments)},g.focusBorderDestroyHook=d}}function removeDestroyFocusBorderHook(g){g.focusBorderDestroyHook&&(g.destroy=g.focusBorderDestroyHook,delete g.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(g){for(var d=[],a=1;a<arguments.length;a++)d[a-1]=arguments[a];g.focusBorderUpdateHooks||(g.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(p){var v=p+"Setter",C=g[v]||g._defaultSetter;g.focusBorderUpdateHooks[v]=C,g[v]=function(){var P=C.apply(g,arguments);return g.addFocusBorder.apply(g,d),P}}))}function removeUpdateFocusBorderHooks(g){g.focusBorderUpdateHooks&&(Object.keys(g.focusBorderUpdateHooks).forEach(function(d){var a=g.focusBorderUpdateHooks[d];a===g._defaultSetter?delete g[d]:g[d]=a}),delete g.focusBorderUpdateHooks)}extend$U(SVGElement.prototype,{addFocusBorder:function(g,d){this.focusBorder&&this.removeFocusBorder();var a=this.getBBox(),p=pick$X(g,3);a.x+=this.translateX?this.translateX:0,a.y+=this.translateY?this.translateY:0;var v=a.x-p,C=a.y-p,P=a.width+2*p,k=a.height+2*p;function z(q){var X=0,K=0;return q.attr("text-anchor")==="middle"?X=K=.5:q.rotation?X=.25:K=.75,{x:X,y:K}}var $=this instanceof SVGLabel;if(this.element.nodeName==="text"||$){var D=!!this.rotation,F=$?{x:D?1:0,y:0}:z(this),N=+this.attr("x"),W=+this.attr("y");if(isNaN(N)||(v=N-a.width*F.x-p),isNaN(W)||(C=W-a.height*F.y-p),$&&D){var j=P;P=k,k=j,isNaN(N)||(v=N-a.height*F.x-p),isNaN(W)||(C=W-a.width*F.y-p)}}this.focusBorder=this.renderer.rect(v,C,P,k,parseInt((d&&d.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:d&&d.stroke,"stroke-width":d&&d.strokeWidth}),addUpdateFocusBorderHooks(this,g,d),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var g=this.focusElement,d=this.options.accessibility.keyboardNavigation.focusBorder;g&&(g.removeFocusBorder(),d.enabled&&g.addFocusBorder(d.margin,{stroke:d.style.color,strokeWidth:d.style.lineWidth,r:d.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(g,d){var a=this.options.accessibility.keyboardNavigation.focusBorder,p=d||g.element;p&&p.focus&&(p.hcEvents&&p.hcEvents.focusin||addEvent$E(p,"focusin",function(){}),p.focus(),a.hideBrowserFocusOutline&&(p.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=g,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$8=DefaultOptions.defaultOptions,addEvent$D=Utilities.addEvent,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,merge$T=Utilities.merge;merge$T(!0,defaultOptions$8,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(g){this.init(g)}Accessibility.prototype={init:function(g){if(this.chart=g,!doc$5.addEventListener||!g.renderer.isSVG){g.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(g),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(g,this.components),this.update()},initComponents:function(){var g=this.chart,d=g.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},d.customComponents&&extend$T(this.components,d.customComponents);var a=this.components;this.getComponentOrder().forEach(function(p){a[p].initBase(g),a[p].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var g=Object.keys(this.components).filter(function(d){return d!=="series"});return["series"].concat(g)},update:function(){var g=this.components,d=this.chart,a=d.options.accessibility;fireEvent$e(d,"beforeA11yUpdate"),d.types=this.getChartTypes(),this.getComponentOrder().forEach(function(p){g[p].onChartUpdate(),fireEvent$e(d,"afterA11yComponentUpdate",{name:p,component:g[p]})}),this.keyboardNavigation.update(a.keyboardNavigation.order),!d.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(d),fireEvent$e(d,"afterA11yUpdate",{accessibility:this})},destroy:function(){var g=this.chart||{},d=this.components;Object.keys(d).forEach(function(a){d[a].destroy(),d[a].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),g.renderTo&&g.renderTo.setAttribute("aria-hidden",!0),g.focusElement&&g.focusElement.removeFocusBorder()},getChartTypes:function(){var g={};return this.chart.series.forEach(function(d){g[d.type]=1}),Object.keys(g)}};Chart$1.prototype.updateA11yEnabled=function(){var g=this.accessibility,d=this.options.accessibility;d&&d.enabled?g?g.update():this.accessibility=g=new Accessibility(this):g?(g.destroy&&g.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$D(Chart$1,"render",function(g){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var d=this.accessibility;d&&d.getComponentOrder().forEach(function(a){d.components[a].onChartRender()})});addEvent$D(Chart$1,"update",function(g){var d=g.options.accessibility;d&&(d.customComponents&&(this.options.accessibility.customComponents=d.customComponents,delete d.customComponents),merge$T(!0,this.options.accessibility,d),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$D(Point$4,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(g){addEvent$D(Chart$1,g,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(g){addEvent$D(Series$f,g,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(g){addEvent$D(Chart$1,g,function(){this.accessibility&&this.accessibility.update()})});addEvent$D(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$C=Utilities.addEvent,fireEvent$d=Utilities.fireEvent,objectEach$e=Utilities.objectEach,pick$W=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var g=this,d=function(p){addEvent$C(p,H.isTouchDevice?"touchstart":"mousedown",function(v){g.onMouseDown(v)},{passive:!1})};if(d(this.graphic.element),(g.labels||[]).forEach(function(p){p.options.useHTML&&p.graphic.text&&d(p.graphic.text.element)}),objectEach$e(g.options.events,function(p,v){var C=function(P){(v!=="click"||!g.cancelClick)&&p.call(g,g.chart.pointer.normalize(P),g.target)};(g.nonDOMEvents||[]).indexOf(v)===-1?g.graphic.on(v,C):addEvent$C(g,v,C,{passive:!1})}),g.options.draggable&&(addEvent$C(g,"drag",g.onDrag),!g.graphic.renderer.styledMode)){var a={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[g.options.draggable]};g.graphic.css(a),(g.labels||[]).forEach(function(p){p.options.useHTML&&p.graphic.text&&p.graphic.text.css(a)})}g.isUpdating||fireEvent$d(g,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(g){var d=this,a=d.chart.pointer,p,v;g.preventDefault&&g.preventDefault(),g.button!==2&&(g=a.normalize(g),p=g.chartX,v=g.chartY,d.cancelClick=!1,d.chart.hasDraggedAnnotation=!0,d.removeDrag=addEvent$C(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(C){d.hasDragged=!0,C=a.normalize(C),C.prevChartX=p,C.prevChartY=v,fireEvent$d(d,"drag",C),p=C.chartX,v=C.chartY},H.isTouchDevice?{passive:!1}:void 0),d.removeMouseUp=addEvent$C(H.doc,H.isTouchDevice?"touchend":"mouseup",function(C){var P=pick$W(d.target&&d.target.annotation,d.target);P&&(P.cancelClick=d.hasDragged),d.cancelClick=d.hasDragged,d.hasDragged=!1,d.chart.hasDraggedAnnotation=!1,fireEvent$d(pick$W(P,d),"afterUpdate"),d.onMouseUp(C)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(g){var d=this.chart,a=this.target||this,p=d.options.annotations,v=d.annotations.indexOf(a);this.removeDocEvents(),p[v]=a.options},onDrag:function(g){if(this.chart.isInsidePlot(g.chartX-this.chart.plotLeft,g.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var d=this.mouseMoveToTranslation(g);this.options.draggable==="x"&&(d.y=0),this.options.draggable==="y"&&(d.x=0),this.points.length?this.translate(d.x,d.y):(this.shapes.forEach(function(a){a.translate(d.x,d.y)}),this.labels.forEach(function(a){a.translate(d.x,d.y)})),this.redraw(!1)}},mouseMoveToRadians:function(g,d,a){var p=g.prevChartY-a,v=g.prevChartX-d,C=g.chartY-a,P=g.chartX-d,k;return this.chart.inverted&&(k=v,v=p,p=k,k=P,P=C,C=k),Math.atan2(C,P)-Math.atan2(p,v)},mouseMoveToTranslation:function(g){var d=g.chartX-g.prevChartX,a=g.chartY-g.prevChartY,p;return this.chart.inverted&&(p=a,a=d,d=p),{x:d,y:a}},mouseMoveToScale:function(g,d,a){var p=g.prevChartX-d,v=g.prevChartY-a,C=g.chartX-d,P=g.chartY-a,k=(C||1)/(p||1),z=(P||1)/(v||1),$;return this.chart.inverted&&($=z,z=k,k=$),{x:k,y:z}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$S=Utilities.merge,pick$V=Utilities.pick,ControlPoint=(function(){function g(d,a,p,v){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=d,this.target=a,this.options=p,this.index=pick$V(p.index,v)}return g.prototype.setVisibility=function(d){this.graphic.attr("visibility",d?"visible":"hidden"),this.options.visible=d},g.prototype.render=function(){var d=this.chart,a=this.options;this.graphic=d.renderer.symbol(a.symbol,0,0,a.width,a.height).add(d.controlPointsGroup).css(a.style),this.setVisibility(a.visible),this.addEvents()},g.prototype.redraw=function(d){this.graphic[d?"animate":"attr"](this.options.positioner.call(this,this.target))},g.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},g.prototype.update=function(d){var a=this.chart,p=this.target,v=this.index,C=merge$S(!0,this.options,d);this.destroy(),this.constructor(a,p,C,v),this.render(a.controlPointsGroup),this.redraw()},g})(),defined$p=Utilities.defined,fireEvent$c=Utilities.fireEvent,MockPoint=(function(){function g(d,a,p){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:d,getPlotBox:Series$f.prototype.getPlotBox},this.target=a||null,this.options=p,this.applyOptions(this.getOptions())}return g.fromPoint=function(d){return new g(d.series.chart,null,{x:d.x,y:d.y,xAxis:d.series.xAxis,yAxis:d.series.yAxis})},g.pointToPixels=function(d,a){var p=d.series,v=p.chart,C=d.plotX,P=d.plotY,k;return v.inverted&&(d.mock?(C=d.plotY,P=d.plotX):(C=v.plotWidth-d.plotY,P=v.plotHeight-d.plotX)),p&&!a&&(k=p.getPlotBox(),C+=k.translateX,P+=k.translateY),{x:C,y:P}},g.pointToOptions=function(d){return{x:d.x,y:d.y,xAxis:d.series.xAxis,yAxis:d.series.yAxis}},g.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},g.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},g.prototype.applyOptions=function(d){this.command=d.command,this.setAxis(d,"x"),this.setAxis(d,"y"),this.refresh()},g.prototype.setAxis=function(d,a){var p=a+"Axis",v=d[p],C=this.series.chart;this.series[p]=v instanceof Axis?v:defined$p(v)?C[p][v]||C.get(v):null},g.prototype.toAnchor=function(){var d=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(d[0]=this.plotY,d[1]=this.plotX),d},g.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},g.prototype.isInsidePlot=function(){var d=this.plotX,a=this.plotY,p=this.series.xAxis,v=this.series.yAxis,C={x:d,y:a,isInsidePlot:!0};return p&&(C.isInsidePlot=defined$p(d)&&d>=0&&d<=p.len),v&&(C.isInsidePlot=C.isInsidePlot&&defined$p(a)&&a>=0&&a<=v.len),fireEvent$c(this.series.chart,"afterIsInsidePlot",C),C.isInsidePlot},g.prototype.refresh=function(){var d=this.series,a=d.xAxis,p=d.yAxis,v=this.getOptions();a?(this.x=v.x,this.plotX=a.toPixels(v.x,!0)):(this.x=null,this.plotX=v.x),p?(this.y=v.y,this.plotY=p.toPixels(v.y,!0)):(this.y=null,this.plotY=v.y),this.isInside=this.isInsidePlot()},g.prototype.translate=function(d,a,p,v){this.hasDynamicOptions()||(this.plotX+=p,this.plotY+=v,this.refreshOptions())},g.prototype.scale=function(d,a,p,v){if(!this.hasDynamicOptions()){var C=this.plotX*p,P=this.plotY*v,k=(1-p)*d,z=(1-v)*a;this.plotX=k+C,this.plotY=z+P,this.refreshOptions()}},g.prototype.rotate=function(d,a,p){if(!this.hasDynamicOptions()){var v=Math.cos(p),C=Math.sin(p),P=this.plotX,k=this.plotY,z=void 0,$=void 0;P-=d,k-=a,z=P*v-k*C,$=P*C+k*v,this.plotX=z+d,this.plotY=$+a,this.refreshOptions()}},g.prototype.refreshOptions=function(){var d=this.series,a=d.xAxis,p=d.yAxis;this.x=this.options.x=a?this.options.x=a.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=p?p.toValue(this.plotY,!0):this.plotY},g})(),isObject$a=Utilities.isObject,isString$3=Utilities.isString,merge$R=Utilities.merge,splat$8=Utilities.splat,controllableMixin={init:function(g,d,a){this.annotation=g,this.chart=g.chart,this.options=d,this.points=[],this.controlPoints=[],this.index=a,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var g=this.options;return g.points||g.point&&splat$8(g.point)},attrsFromOptions:function(g){var d=this.constructor.attrsMap,a={},p,v,C=this.chart.styledMode;for(p in g)v=d[p],v&&(!C||["fill","stroke","stroke-width"].indexOf(v)===-1)&&(a[v]=g[p]);return a},anchor:function(g){var d=g.series.getPlotBox(),a=g.series.chart,p=g.mock?g.toAnchor():Tooltip.prototype.getAnchor.call({chart:g.series.chart},g),v={x:p[0]+(this.options.x||0),y:p[1]+(this.options.y||0),height:p[2]||0,width:p[3]||0};return{relativePosition:v,absolutePosition:merge$R(v,{x:v.x+(g.mock?d.translateX:a.plotLeft),y:v.y+(g.mock?d.translateY:a.plotTop)})}},point:function(g,d){if(g&&g.series)return g;if(!d||d.series===null){if(isObject$a(g))d=new MockPoint(this.chart,this,g);else if(isString$3(g))d=this.chart.get(g)||null;else if(typeof g=="function"){var a=g.call(d,this);d=a.series?a:new MockPoint(this.chart,this,g)}}return d},linkPoints:function(){var g=this.getPointsOptions(),d=this.points,a=g&&g.length||0,p,v;for(p=0;p<a;p++){if(v=this.point(g[p],d[p]),!v){d.length=0;return}v.mock&&v.refresh(),d[p]=v}return d},addControlPoints:function(){var g=this.options.controlPoints;(g||[]).forEach(function(d,a){var p=merge$R(this.options.controlPointOptions,d);p.index||(p.index=a),g[a]=p,this.controlPoints.push(new ControlPoint(this.chart,this,p))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(g){this.controlPoints.forEach(function(d){d.render()})},redraw:function(g){this.controlPoints.forEach(function(d){d.redraw(g)})},transform:function(g,d,a,p,v){if(this.chart.inverted){var C=d;d=a,a=C}this.points.forEach(function(P,k){this.transformPoint(g,d,a,p,v,k)},this)},transformPoint:function(g,d,a,p,v,C){var P=this.points[C];P.mock||(P=this.points[C]=MockPoint.fromPoint(P)),P[g](d,a,p,v)},translate:function(g,d){this.transform("translate",null,null,g,d)},translatePoint:function(g,d,a){this.transformPoint("translate",null,null,g,d,a)},translateShape:function(g,d){var a=this.annotation.chart,p=this.annotation.userOptions,v=a.annotations.indexOf(this.annotation),C=a.options.annotations[v];this.translatePoint(g,d,0),C[this.collection][this.index].point=this.options.point,p[this.collection][this.index].point=this.options.point},rotate:function(g,d,a){this.transform("rotate",g,d,a)},scale:function(g,d,a,p){this.transform("scale",g,d,a,p)},setControlPointsVisibility:function(g){this.controlPoints.forEach(function(d){d.setVisibility(g)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(g){g.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(g){var d=this.annotation,a=merge$R(!0,this.options,g),p=this.graphic.parentGroup;this.destroy(),this.constructor(d,a,this.index),this.render(p),this.redraw()}},addEvent$B=Utilities.addEvent,defined$o=Utilities.defined,merge$Q=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(g,d){var a={attributes:{id:g}},p={stroke:d.color||"none",fill:d.color||"rgba(0, 0, 0, 0.75)"};a.children=d.children&&d.children.map(function(P){return merge$Q(p,P)});var v=merge$Q(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},d,a),C=this.definition(v);return C.id=g,C};function createMarkerSetter(g){return function(d){this.attr(g,"url(#"+d+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(g){var d=g.options,a=g.chart,p=a.options.defs,v=d.fill,C=defined$o(v)&&v!=="none"?v:d.stroke,P=function(k){var z=d[k],$,D,F,N;if(z){for(F in p)if($=p[F],(z===($.attributes&&$.attributes.id)||z===$.id)&&$.tagName==="marker"){D=$;break}D&&(N=g[k]=a.renderer.addMarker((d.id||uniqueKey$2())+"-"+z,merge$Q(D,{color:C})),g.attr(k,N.getAttribute("id")))}};["markerStart","markerEnd"].forEach(P)}};addEvent$B(Chart$1,"afterGetContainer",function(){this.options.defs=merge$Q(defaultMarkers,this.options.defs||{})});var extend$S=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=(function(){function g(d,a,p){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(d,a,p),this.collection="shapes"}return g.prototype.toD=function(){var d=this.options.d;if(d)return typeof d=="function"?d.call(this):d;var a=this.points,p=a.length,v=p,C=a[0],P=v&&this.anchor(C).absolutePosition,k=0,z,$=[];if(P)for($.push(["M",P.x,P.y]);++k<p&&v;)C=a[k],z=C.command||"L",P=this.anchor(C).absolutePosition,z==="M"?$.push([z,P.x,P.y]):z==="L"?$.push([z,P.x,P.y]):z==="Z"&&$.push([z]),v=C.series.visible;return v?this.chart.renderer.crispLine($,this.graphic.strokeWidth()):null},g.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},g.prototype.render=function(d){var a=this.options,p=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(p).add(d),a.className&&this.graphic.addClass(a.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(d),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+a.snap*2}),controllableMixin.render.call(this),extend$S(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},g.prototype.redraw=function(d){var a=this.toD(),p=d?"animate":"attr";a?(this.graphic[p]({d:a}),this.tracker[p]({d:a})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!a,controllableMixin.redraw.call(this,d)},g.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},g})(),merge$P=Utilities.merge,ControllableRect=(function(){function g(d,a,p){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(d,a,p),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(a).add(d),controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[d?"animate":"attr"]({x:a.x,y:a.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,d)},g.attrsMap=merge$P(ControllablePath.attrsMap,{width:"width",height:"height"}),g})(),merge$O=Utilities.merge,ControllableCircle=(function(){function g(d,a,p){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(d,a,p),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(a).add(d),controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[d?"animate":"attr"]({x:a.x,y:a.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,d)},g.prototype.setRadius=function(d){this.options.r=d},g.attrsMap=merge$O(ControllablePath.attrsMap,{r:"r"}),g})(),format$3=FormatUtilities.format,symbols$3=SVGRenderer.prototype.symbols,extend$R=Utilities.extend,isNumber$q=Utilities.isNumber,pick$U=Utilities.pick,ControllableLabel=(function(){function g(d,a,p){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(d,a,p),this.collection="labels"}return g.alignedPosition=function(d,a){var p=d.align,v=d.verticalAlign,C=(a.x||0)+(d.x||0),P=(a.y||0)+(d.y||0),k,z;return p==="right"?k=1:p==="center"&&(k=2),k&&(C+=(a.width-(d.width||0))/k),v==="bottom"?z=1:v==="middle"&&(z=2),z&&(P+=(a.height-(d.height||0))/z),{x:Math.round(C),y:Math.round(P)}},g.justifiedOptions=function(d,a,p,v){var C=p.align,P=p.verticalAlign,k=a.box?0:a.padding||0,z=a.getBBox(),$={align:C,verticalAlign:P,x:p.x,y:p.y,width:a.width,height:a.height},D=(v.x||0)-d.plotLeft,F=(v.y||0)-d.plotTop,N;return N=D+k,N<0&&(C==="right"?$.align="left":$.x=($.x||0)-N),N=D+z.width-k,N>d.plotWidth&&(C==="left"?$.align="right":$.x=($.x||0)+d.plotWidth-N),N=F+k,N<0&&(P==="bottom"?$.verticalAlign="top":$.y=($.y||0)-N),N=F+z.height-k,N>d.plotHeight&&(P==="top"?$.verticalAlign="bottom":$.y=($.y||0)+d.plotHeight-N),$},g.prototype.translatePoint=function(d,a){controllableMixin.translatePoint.call(this,d,a,0)},g.prototype.translate=function(d,a){var p=this.annotation.chart,v=this.annotation.userOptions,C=p.annotations.indexOf(this.annotation),P=p.options.annotations,k=P[C];if(p.inverted){var z=d;d=a,a=z}this.options.x+=d,this.options.y+=a,k[this.collection][this.index].x=this.options.x,k[this.collection][this.index].y=this.options.y,v[this.collection][this.index].x=this.options.x,v[this.collection][this.index].y=this.options.y},g.prototype.render=function(d){var a=this.options,p=this.attrsFromOptions(a),v=a.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,a.shape,null,null,a.useHTML,null,"annotation-label").attr(p).add(d),this.annotation.chart.styledMode||(v.color==="contrast"&&(v.color=this.annotation.chart.renderer.getContrast(g.shapesWithoutBackground.indexOf(a.shape)>-1?"#FFFFFF":a.backgroundColor)),this.graphic.css(a.style).shadow(a.shadow)),a.className&&this.graphic.addClass(a.className),this.graphic.labelrank=a.labelrank,controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.options,p=this.text||a.format||a.text,v=this.graphic,C=this.points[0];v.attr({text:p?format$3(p,C.getLabelConfig(),this.annotation.chart):a.formatter.call(C,this)});var P=this.anchor(C),k=this.position(P);k?(v.alignAttr=k,k.anchorX=P.absolutePosition.x,k.anchorY=P.absolutePosition.y,v[d?"animate":"attr"](k)):v.attr({x:0,y:-9999}),v.placed=!!k,controllableMixin.redraw.call(this,d)},g.prototype.anchor=function(d){var a=controllableMixin.anchor.apply(this,arguments),p=this.options.x||0,v=this.options.y||0;return a.absolutePosition.x-=p,a.absolutePosition.y-=v,a.relativePosition.x-=p,a.relativePosition.y-=v,a},g.prototype.position=function(d){var a=this.graphic,p=this.annotation.chart,v=this.points[0],C=this.options,P=d.absolutePosition,k=d.relativePosition,z,$,D,F,N=v.series.visible&&MockPoint.prototype.isInsidePlot.call(v),W=a.width,j=W===void 0?0:W,q=a.height,X=q===void 0?0:q;return N&&(C.distance?z=Tooltip.prototype.getPosition.call({chart:p,distance:pick$U(C.distance,16)},j,X,{plotX:k.x,plotY:k.y,negative:v.negative,ttBelow:v.ttBelow,h:k.height||k.width}):C.positioner?z=C.positioner.call(this):($={x:P.x,y:P.y,width:0,height:0},z=g.alignedPosition(extend$R(C,{width:j,height:X}),$),this.options.overflow==="justify"&&(z=g.alignedPosition(g.justifiedOptions(p,a,C,z),$))),C.crop&&(D=z.x-p.plotLeft,F=z.y-p.plotTop,N=p.isInsidePlot(D,F)&&p.isInsidePlot(D+j,F+X))),N?z:null},g.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},g.shapesWithoutBackground=["connector"],g})();symbols$3.connector=function(g,d,a,p,v){var C=v&&v.anchorX,P=v&&v.anchorY,k,z,$=a/2;return isNumber$q(C)&&isNumber$q(P)&&(k=[["M",C,P]],z=d-P,z<0&&(z=-p-z),z<a&&($=C<g+a/2?z:a-z),P>d+p?k.push(["L",g+$,d+p]):P<d?k.push(["L",g+$,d]):C<g?k.push(["L",g,d+p/2]):C>g+a&&k.push(["L",g+a,d+p/2])),k||[]};var ControllableImage=(function(){function g(d,a,p){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(d,a,p),this.collection="shapes"}return g.prototype.render=function(d){var a=this.attrsFromOptions(this.options),p=this.options;this.graphic=this.annotation.chart.renderer.image(p.src,0,-9e9,p.width,p.height).attr(a).add(d),this.graphic.width=p.width,this.graphic.height=p.height,controllableMixin.render.call(this)},g.prototype.redraw=function(d){var a=this.anchor(this.points[0]),p=ControllableLabel.prototype.position.call(this,a);p?this.graphic[d?"animate":"attr"]({x:p.x,y:p.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!p,controllableMixin.redraw.call(this,d)},g.attrsMap={width:"width",height:"height",zIndex:"zIndex"},g})(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$A=Utilities.addEvent,defined$n=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$Q=Utilities.extend,find$7=Utilities.find,fireEvent$b=Utilities.fireEvent,merge$N=Utilities.merge,pick$T=Utilities.pick,splat$7=Utilities.splat,wrap$e=Utilities.wrap,Annotation=(function(){function g(d,a){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var p;this.chart=d,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$N(this.defaultOptions,a),this.userOptions=a,p=this.getLabelsAndShapesOptions(this.options,a),this.options.labels=p.labels,this.options.shapes=p.shapes,this.init(d,this.options)}return g.prototype.init=function(){var d=this.chart,a=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(d,a)},g.prototype.getLabelsAndShapesOptions=function(d,a){var p={};return["labels","shapes"].forEach(function(v){d[v]&&(a[v]?p[v]=splat$7(a[v]).map(function(C,P){return merge$N(d[v][P],C)}):p[v]=d[v])}),p},g.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(d,a){var p=this.initShape(d,a);merge$N(!0,this.options.shapes[a],p.options)},this)},g.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(d,a){var p=this.initLabel(d,a);merge$N(!0,this.options.labels[a],p.options)},this)},g.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},g.prototype.setClipAxes=function(){var d=this.chart.xAxis,a=this.chart.yAxis,p=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(v,C){var P=C&&(C.point||C.points&&C.points[0]);return[d[P&&P.xAxis]||v[0],a[P&&P.yAxis]||v[1]]},[]);this.clipXAxis=p[0],this.clipYAxis=p[1]},g.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},g.prototype.setLabelCollector=function(){var d=this;d.labelCollector=function(){return d.labels.reduce(function(a,p){return p.options.allowOverlap||a.push(p.graphic),a},[])},d.chart.labelCollectors.push(d.labelCollector)},g.prototype.setOptions=function(d){this.options=merge$N(this.defaultOptions,d)},g.prototype.redraw=function(d){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,d),this.redrawItems(this.labels,d),controllableMixin.redraw.call(this,d)},g.prototype.redrawItems=function(d,a){for(var p=d.length;p--;)this.redrawItem(d[p],a)},g.prototype.renderItems=function(d){for(var a=d.length;a--;)this.renderItem(d[a])},g.prototype.render=function(){var d=this.chart.renderer;this.graphic=d.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=d.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=d.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},g.prototype.setVisibility=function(d){var a=this.options,p=this.chart.navigationBindings,v=pick$T(d,!a.visible);this.graphic.attr("visibility",v?"visible":"hidden"),v||(this.setControlPointsVisibility(!1),p.activeAnnotation===this&&p.popup&&p.popup.formType==="annotation-toolbar"&&fireEvent$b(p,"closePopup")),a.visible=v},g.prototype.setControlPointsVisibility=function(d){var a=function(p){p.setControlPointsVisibility(d)};controllableMixin.setControlPointsVisibility.call(this,d),this.shapes.forEach(a),this.labels.forEach(a)},g.prototype.destroy=function(){var d=this.chart,a=function(p){p.destroy()};this.labels.forEach(a),this.shapes.forEach(a),this.clipXAxis=null,this.clipYAxis=null,erase$1(d.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,d)},g.prototype.remove=function(){return this.chart.removeAnnotation(this)},g.prototype.update=function(d,a){var p=this.chart,v=this.getLabelsAndShapesOptions(this.userOptions,d),C=p.annotations.indexOf(this),P=merge$N(!0,this.userOptions,d);P.labels=v.labels,P.shapes=v.shapes,this.destroy(),this.constructor(p,P),p.options.annotations[C]=P,this.isUpdating=!0,pick$T(a,!0)&&p.redraw(),fireEvent$b(this,"afterUpdate"),this.isUpdating=!1},g.prototype.initShape=function(d,a){var p=merge$N(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},d),v=new g.shapesMap[p.type](this,p,a);return v.itemType="shape",this.shapes.push(v),v},g.prototype.initLabel=function(d,a){var p=merge$N(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},d),v=new ControllableLabel(this,p,a);return v.itemType="label",this.labels.push(v),v},g.prototype.redrawItem=function(d,a){d.linkPoints(),d.shouldBeDrawn()?(d.graphic||this.renderItem(d),d.redraw(pick$T(a,!0)&&d.graphic.placed),d.points.length&&this.adjustVisibility(d)):this.destroyItem(d)},g.prototype.adjustVisibility=function(d){var a=!1,p=d.graphic;d.points.forEach(function(v){v.series.visible!==!1&&v.visible!==!1&&(a=!0)}),a?p.visibility==="hidden"&&p.show():p.hide()},g.prototype.destroyItem=function(d){erase$1(this[d.itemType+"s"],d),d.destroy()},g.prototype.renderItem=function(d){d.render(d.itemType==="label"?this.labelsGroup:this.shapesGroup)},g.ControlPoint=ControlPoint,g.MockPoint=MockPoint,g.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},g.types={},g})();merge$N(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$N(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$n(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(g,d,a,p){d=d||Annotation,extend$Q(g.prototype,merge$N(d.prototype,a)),g.prototype.defaultOptions=merge$N(g.prototype.defaultOptions,p||{})};extend$Q(chartProto,{initAnnotation:function(g){var d=Annotation.types[g.type]||Annotation,a=new d(this,g);return this.annotations.push(a),a},addAnnotation:function(g,d){var a=this.initAnnotation(g);return this.options.annotations.push(a.options),pick$T(d,!0)&&(a.redraw(),a.graphic.attr({opacity:1})),a},removeAnnotation:function(g){var d=this.annotations,a=g.coll==="annotations"?g:find$7(d,function(p){return p.options.id===g});a&&(fireEvent$b(a,"remove"),erase$1(this.options.annotations,a.options),erase$1(d,a),a.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(g){g.redraw(),g.graphic.animate({opacity:1},g.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$A(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(g){g.plotBoxClip=this.renderer.clipRect(this.plotBox),g.controlPointsGroup=g.renderer.g("control-points").attr({zIndex:99}).clip(g.plotBoxClip).add(),g.options.annotations.forEach(function(d,a){if(!g.annotations.some(function(v){return v.options===d})){var p=g.initAnnotation(d);g.options.annotations[a]=p.options}}),g.drawAnnotations(),addEvent$A(g,"redraw",g.drawAnnotations),addEvent$A(g,"destroy",function(){g.plotBoxClip.destroy(),g.controlPointsGroup.destroy()}),addEvent$A(g,"exportData",function(d){var a=g.annotations,p=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,v=!d.dataRows[1].xValues,C=g.options.lang&&g.options.lang.exportData&&g.options.lang.exportData.annotationHeader,P=function(j){var q;return p&&(q=p(j),q!==!1)?q:(q=C+" "+j,v?{columnTitle:q,topLevelColumnTitle:q}:q)},k=d.dataRows[0].length,z=g.options.exporting&&g.options.exporting.csv&&g.options.exporting.csv.annotations&&g.options.exporting.csv.annotations.itemDelimiter,$=g.options.exporting&&g.options.exporting.csv&&g.options.exporting.csv.annotations&&g.options.exporting.csv.annotations.join;a.forEach(function(j){j.options.labelOptions.includeInDataExport&&j.labels.forEach(function(q){if(q.options.text){var X=q.options.text;q.points.forEach(function(K){var ee=K.x,te=K.series.xAxis?K.series.xAxis.options.index:-1,ie=!1;if(te===-1){for(var oe=d.dataRows[0].length,ae=new Array(oe),le=0;le<oe;++le)ae[le]="";ae.push(X),ae.xValues=[],ae.xValues[te]=ee,d.dataRows.push(ae),ie=!0}if(ie||d.dataRows.forEach(function(ce,ue){!ie&&ce.xValues&&te!==void 0&&ee===ce.xValues[te]&&($&&ce.length>k?ce[ce.length-1]+=z+X:ce.push(X),ie=!0)}),!ie){for(var oe=d.dataRows[0].length,ae=new Array(oe),le=0;le<oe;++le)ae[le]="";ae[0]=ee,ae.push(X),ae.xValues=[],te!==void 0&&(ae.xValues[te]=ee),d.dataRows.push(ae)}})}})});var D=0;d.dataRows.forEach(function(j){D=Math.max(D,j.length)});for(var F=D-d.dataRows[0].length,N=0;N<F;N++){var W=P(N+1);v?(d.dataRows[0].push(W.topLevelColumnTitle),d.dataRows[1].push(W.columnTitle)):d.dataRows[0].push(W)}})});wrap$e(Pointer.prototype,"onContainerMouseDown",function(g){this.chart.hasDraggedAnnotation||g.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(g){g.navigation||(g.navigation={updates:[],update:function(d,a){this.updates.forEach(function(p){p.update.call(p.context,d,a)})}})},addUpdate:function(g,d){d.navigation||this.initUpdate(d),d.navigation.updates.push({update:g,context:d})}},format$2=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$z=Utilities.addEvent,attr=Utilities.attr,fireEvent$a=Utilities.fireEvent,isArray$a=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$p=Utilities.isNumber,isObject$9=Utilities.isObject,merge$M=Utilities.merge,objectEach$d=Utilities.objectEach,pick$S=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(g,d){var a=win$2.Element.prototype,p=a.matches||a.msMatchesSelector||a.webkitMatchesSelector,v=null;if(a.closest)v=a.closest.call(g,d);else do{if(p.call(g,d))return g;g=g.parentElement||g.parentNode}while(g!==null&&g.nodeType===1);return v}var bindingsUtils={getFieldType:function(g){return{string:"text",number:"number",boolean:"checkbox"}[typeof g]},updateRectSize:function(g,d){var a=d.chart,p=d.options.typeOptions,v=isNumber$p(p.xAxis)&&a.xAxis[p.xAxis],C=isNumber$p(p.yAxis)&&a.yAxis[p.yAxis];if(v&&C){var P=v.toValue(g[v.horiz?"chartX":"chartY"]),k=C.toValue(g[C.horiz?"chartX":"chartY"]),z=P-p.point.x,$=p.point.y-k;d.update({typeOptions:{background:{width:a.inverted?$:z,height:a.inverted?z:$}}})}},getAssignedAxis:function(g){return g.filter(function(d){var a=d.axis.min,p=d.axis.max,v=pick$S(d.axis.minPointOffset,0);return isNumber$p(a)&&isNumber$p(p)&&d.value>=a-v&&d.value<=p+v&&!d.axis.options.isInternal})[0]}},NavigationBindings=(function(){function g(d,a){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=d,this.options=a,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return g.prototype.initEvents=function(){var d=this,a=d.chart,p=d.container,v=d.options;d.boundClassNames={},objectEach$d(v.bindings||{},function(C){d.boundClassNames[C.className]=C}),[].forEach.call(p,function(C){d.eventsToUnbind.push(addEvent$z(C,"click",function(P){var k=d.getButtonEvents(C,P);k&&k.button.className.indexOf("highcharts-disabled-btn")===-1&&d.bindingsButtonClick(k.button,k.events,P)}))}),objectEach$d(v.events||{},function(C,P){isFunction$1(C)&&d.eventsToUnbind.push(addEvent$z(d,P,C,{passive:!1}))}),d.eventsToUnbind.push(addEvent$z(a.container,"click",function(C){!a.cancelClick&&a.isInsidePlot(C.chartX-a.plotLeft,C.chartY-a.plotTop,{visiblePlotOnly:!0})&&d.bindingsChartClick(this,C)})),d.eventsToUnbind.push(addEvent$z(a.container,H.isTouchDevice?"touchmove":"mousemove",function(C){d.bindingsContainerMouseMove(this,C)},H.isTouchDevice?{passive:!1}:void 0))},g.prototype.initUpdate=function(){var d=this;chartNavigation.addUpdate(function(a){d.update(a)},this.chart)},g.prototype.bindingsButtonClick=function(d,a,p){var v=this,C=v.chart;v.selectedButtonElement&&(fireEvent$a(v,"deselectButton",{button:v.selectedButtonElement}),v.nextEvent&&(v.currentUserDetails&&v.currentUserDetails.coll==="annotations"&&C.removeAnnotation(v.currentUserDetails),v.mouseMoveEvent=v.nextEvent=!1)),v.selectedButton=a,v.selectedButtonElement=d,fireEvent$a(v,"selectButton",{button:d}),a.init&&a.init.call(v,d,p),(a.start||a.steps)&&C.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},g.prototype.bindingsChartClick=function(d,a){d=this.chart;var p=this,v=p.activeAnnotation,C=p.selectedButton,P=d.renderer.boxWrapper;v&&(!v.cancelClick&&!a.activeAnnotation&&a.target.parentNode&&!closestPolyfill(a.target,"."+PREFIX$1+"popup")?fireEvent$a(p,"closePopup"):v.cancelClick&&setTimeout(function(){v.cancelClick=!1},0)),!(!C||!C.start)&&(p.nextEvent?(p.nextEvent(a,p.currentUserDetails),p.steps&&(p.stepIndex++,C.steps[p.stepIndex]?p.mouseMoveEvent=p.nextEvent=C.steps[p.stepIndex]:(fireEvent$a(p,"deselectButton",{button:p.selectedButtonElement}),P.removeClass(PREFIX$1+"draw-mode"),C.end&&C.end.call(p,a,p.currentUserDetails),p.nextEvent=!1,p.mouseMoveEvent=!1,p.selectedButton=null))):(p.currentUserDetails=C.start.call(p,a),p.currentUserDetails&&C.steps?(p.stepIndex=0,p.steps=!0,p.mouseMoveEvent=p.nextEvent=C.steps[p.stepIndex]):(fireEvent$a(p,"deselectButton",{button:p.selectedButtonElement}),P.removeClass(PREFIX$1+"draw-mode"),p.steps=!1,p.selectedButton=null,C.end&&C.end.call(p,a,p.currentUserDetails))))},g.prototype.bindingsContainerMouseMove=function(d,a){this.mouseMoveEvent&&this.mouseMoveEvent(a,this.currentUserDetails)},g.prototype.fieldsToOptions=function(d,a){return objectEach$d(d,function(p,v){var C=parseFloat(p),P=v.split("."),k=a,z=P.length-1;isNumber$p(C)&&!p.match(/px/g)&&!v.match(/format/g)&&(p=C),p!==""&&p!=="undefined"&&P.forEach(function($,D){var F=pick$S(P[D+1],"");z===D?k[$]=p:(k[$]||(k[$]=F.match(/\d/g)?[]:{}),k=k[$])})}),a},g.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},g.prototype.annotationToFields=function(d){var a=d.options,p=g.annotationsEditable,v=p.nestedOptions,C=this.utils.getFieldType,P=pick$S(a.type,a.shapes&&a.shapes[0]&&a.shapes[0].type,a.labels&&a.labels[0]&&a.labels[0].itemType,"label"),k=g.annotationsNonEditable[a.langKey]||[],z={langKey:a.langKey,type:P};function $(D,F,N,W){var j;N&&D&&k.indexOf(F)===-1&&((N.indexOf&&N.indexOf(F))>=0||N[F]||N===!0)&&(isArray$a(D)?(W[F]=[],D.forEach(function(q,X){isObject$9(q)?(W[F][X]={},objectEach$d(q,function(K,ee){$(K,ee,v[F],W[F][X])})):$(q,0,v[F],W[F])})):isObject$9(D)?(j={},isArray$a(W)?(W.push(j),j[F]={},j=j[F]):W[F]=j,objectEach$d(D,function(q,X){$(q,X,F===0?N:v[F],j)})):F==="format"?W[F]=[format$2(D,d.labels[0].points[0]).toString(),"text"]:isArray$a(W)?W.push([D,C(D)]):W[F]=[D,C(D)])}return objectEach$d(a,function(D,F){F==="typeOptions"?(z[F]={},objectEach$d(a[F],function(N,W){$(N,W,v,z[F])})):$(D,F,p[P],z)}),z},g.prototype.getClickedClassNames=function(d,a){for(var p=a.target,v=[],C;p;)if(C=attr(p,"class"),C&&(v=v.concat(C.split(" ").map(function(P){return[P,p]}))),p=p.parentNode,p===d)return v;return v},g.prototype.getButtonEvents=function(d,a){var p=this,v=this.getClickedClassNames(d,a),C;return v.forEach(function(P){p.boundClassNames[P[0]]&&!C&&(C={events:p.boundClassNames[P[0]],button:P[1]})}),C},g.prototype.update=function(d){this.options=merge$M(!0,this.options,d),this.removeEvents(),this.initEvents()},g.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(d){d()})},g.prototype.destroy=function(){this.removeEvents()},g.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},g.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},g})();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var g=this,d=g.options;d&&d.navigation&&d.navigation.bindings&&(g.navigationBindings=new NavigationBindings(g,d.navigation),g.navigationBindings.initEvents(),g.navigationBindings.initUpdate())};addEvent$z(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$z(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$z(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$z(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(g){var d=g.prototype.defaultOptions.events&&g.prototype.defaultOptions.events.click;function a(p){var v=this,C=v.chart.navigationBindings,P=C.activeAnnotation;d&&d.call(v,p),P!==v?(C.deselectAnnotation(),C.activeAnnotation=v,v.setControlPointsVisibility(!0),fireEvent$a(C,"showPopup",{annotation:v,formType:"annotation-toolbar",options:C.annotationToFields(v),onSubmit:function(k){var z={},$;k.actionType==="remove"?(C.activeAnnotation=!1,C.chart.removeAnnotation(v)):(C.fieldsToOptions(k.fields,z),C.deselectAnnotation(),$=z.typeOptions,v.options.type==="measure"&&($.crosshairY.enabled=$.crosshairY.strokeWidth!==0,$.crosshairX.enabled=$.crosshairX.strokeWidth!==0),v.update(z))}})):fireEvent$a(C,"closePopup"),p.activeAnnotation=!0}merge$M(!0,g.prototype.defaultOptions.events,{click:a})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$d(Annotation.types,function(g){selectableAnnotation(g)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),p=this.utils.getAssignedAxis(d.yAxis),v=this.chart.options.navigation;if(!(!a||!p))return this.chart.addAnnotation(merge$M({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:p.value,xAxis:a.axis.options.index,yAxis:p.axis.options.index},r:5}]},v.annotationsOptions,v.bindings.circleAnnotation.annotationsOptions))},steps:[function(g,d){var a=d.options.shapes[0].point,p=this.chart.inverted,v,C,P;isNumber$p(a.xAxis)&&isNumber$p(a.yAxis)&&(v=this.chart.xAxis[a.xAxis].toPixels(a.x),C=this.chart.yAxis[a.yAxis].toPixels(a.y),P=Math.max(Math.sqrt(Math.pow(p?C-g.chartX:v-g.chartX,2)+Math.pow(p?v-g.chartY:C-g.chartY,2)),5)),d.update({shapes:[{r:P}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),p=this.utils.getAssignedAxis(d.yAxis);if(!(!a||!p)){var v=a.value,C=p.value,P=a.axis.options.index,k=p.axis.options.index,z=this.chart.options.navigation;return this.chart.addAnnotation(merge$M({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:P,yAxis:k,x:v,y:C},{xAxis:P,yAxis:k,x:v,y:C},{xAxis:P,yAxis:k,x:v,y:C},{xAxis:P,yAxis:k,x:v,y:C}]}]},z.annotationsOptions,z.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(g,d){var a=d.options.shapes[0].points,p=this.chart.pointer.getCoordinates(g),v=this.utils.getAssignedAxis(p.xAxis),C=this.utils.getAssignedAxis(p.yAxis),P,k;v&&C&&(P=v.value,k=C.value,a[1].x=P,a[2].x=P,a[2].y=k,a[3].y=k,d.update({shapes:[{points:a}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(g){var d=this.chart.pointer.getCoordinates(g),a=this.utils.getAssignedAxis(d.xAxis),p=this.utils.getAssignedAxis(d.yAxis),v=this.chart.options.navigation;if(!(!a||!p))return this.chart.addAnnotation(merge$M({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:p.axis.options.index,x:a.value,y:p.value},overflow:"none",crop:!0}]},v.annotationsOptions,v.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$z(Chart$1,"render",function(){var g=this,d=g.navigationBindings,a="highcharts-disabled-btn";if(g&&d){var p=!1;g.series.forEach(function(v){!v.options.isInternal&&v.visible&&(p=!0)}),objectEach$d(d.boundClassNames,function(v,C){if(g.navigationBindings&&g.navigationBindings.container&&g.navigationBindings.container[0]){var P=g.navigationBindings.container[0].querySelectorAll("."+C);if(P)for(var k=0;k<P.length;k++){var z=P[k];v.noDataState==="normal"||p?z.className.indexOf(a)!==-1&&z.classList.remove(a):z.className.indexOf(a)===-1&&(z.className+=" "+a)}}})}});addEvent$z(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$2=DefaultOptions.getOptions,addEvent$y=Utilities.addEvent,createElement$2=Utilities.createElement,defined$m=Utilities.defined,fireEvent$9=Utilities.fireEvent,isArray$9=Utilities.isArray,isObject$8=Utilities.isObject,isString$2=Utilities.isString,objectEach$c=Utilities.objectEach,pick$R=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$d=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$d(Pointer.prototype,"onContainerMouseDown",function(g,d){var a=d.target&&d.target.className;isString$2(a)&&a.indexOf(PREFIX+"popup-field")>=0||g.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(g,d,a){this.init(g,d,a)};H.Popup.prototype={init:function(g,d,a){this.chart=a,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,g),this.lang=this.getLangpack(),this.iconsURL=d,this.addCloseBtn()},addCloseBtn:function(){var g=this,d,a=this.iconsURL;d=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),d.style["background-image"]="url("+(a.match(/png|svg|jpeg|jpg|gif/ig)?a:a+"close.svg")+")",["click","touchstart"].forEach(function(p){addEvent$y(d,p,function(){g.chart?fireEvent$9(g.chart.navigationBindings,"closePopup"):g.closePopup()})})},addColsContainer:function(g){var d,a;return a=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,g),d=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,g),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,d),{lhsCol:a,rhsCol:d}},addInput:function(g,d,a,p){var v=g.split("."),C=v[v.length-1],P=this.lang,k=PREFIX+d+"-"+C;k.match(indexFilter)||createElement$2(LABEL,{htmlFor:k},void 0,a).appendChild(doc$3.createTextNode(P[C]||C)),p!==""&&createElement$2(INPUT,{name:k,value:p[0],type:p[1],className:PREFIX+"popup-field"},void 0,a).setAttribute(PREFIX+"data-name",g)},addButton:function(g,d,a,p,v){var C=this,P=this.closePopup,k=this.getFields,z;return z=createElement$2(BUTTON,void 0,void 0,g),z.appendChild(doc$3.createTextNode(d)),["click","touchstart"].forEach(function($){addEvent$y(z,$,function(){return P.call(C),p(k(v,a))})}),z},getFields:function(g,d){var a=g.querySelectorAll("input"),p="#"+PREFIX+"select-series > option:checked",v="#"+PREFIX+"select-volume > option:checked",C=g.querySelectorAll(p)[0],P=g.querySelectorAll(v)[0],k,z,$;return $={actionType:d,linkedTo:C&&C.getAttribute("value"),fields:{}},[].forEach.call(a,function(D){z=D.getAttribute(PREFIX+"data-name"),k=D.getAttribute(PREFIX+"data-series-id"),k?$.seriesId=D.value:z?$.fields[z]=D.value:$.type=D.value}),P&&($.fields["params.volumeSeriesID"]=P.getAttribute("value")),$},showPopup:function(){var g=this.container,d=PREFIX+"annotation-toolbar",a=g.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,g.innerHTML="",g.className.indexOf(d)>=0&&(g.classList.remove(d),g.removeAttribute("style")),g.appendChild(a),g.style.display="block",g.style.height=""},closePopup:function(){var g=pick$R(this.popup&&this.popup.container,this.container);g.style.display="none"},showForm:function(g,d,a,p){d&&(this.popup=d.navigationBindings.popup,this.showPopup(),g==="indicators"&&this.indicators.addForm.call(this,d,a,p),g==="annotation-toolbar"&&this.annotations.addToolbar.call(this,d,a,p),g==="annotation-edit"&&this.annotations.addForm.call(this,d,a,p),g==="flag"&&this.annotations.addForm.call(this,d,a,p,!0),this.formType=g,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$2().lang.navigation.popup},annotations:{addToolbar:function(g,d,a){var p=this,v=this.lang,C=this.popup.container,P=this.showForm,k=PREFIX+"annotation-toolbar",z;C.className.indexOf(k)===-1&&(C.className+=" "+k),g&&(C.style.top=g.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,C).appendChild(doc$3.createTextNode(pick$R(v[d.langKey]||d.langKey,d.shapes&&d.shapes[0].type))),z=this.addButton(C,v.removeButton||"remove","remove",a,C),z.className+=" "+PREFIX+"annotation-remove-button",z.style["background-image"]="url("+this.iconsURL+"destroy.svg)",z=this.addButton(C,v.editButton||"edit","edit",function(){P.call(p,"annotation-edit",g,d,a)},C),z.className+=" "+PREFIX+"annotation-edit-button",z.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(g,d,a,p){var v=this.popup.container,C=this.lang,P,k;g&&(k=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,v),k.appendChild(doc$3.createTextNode(C[d.langKey]||d.langKey||"")),k=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,v),P=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,v),this.annotations.addFormFields.call(this,k,g,"",d,[],!0),this.addButton(P,p?C.addButton||"add":C.saveButton||"save",p?"add":"save",a,v))},addFormFields:function(g,d,a,p,v,C){var P=this,k=this.annotations.addFormFields,z=this.addInput,$=this.lang,D,F;d&&(objectEach$c(p,function(N,W){D=a!==""?a+"."+W:W,isObject$8(N)&&(!isArray$9(N)||isArray$9(N)&&isObject$8(N[0])?(F=$[W]||W,F.match(indexFilter)||v.push([!0,F,g]),k.call(P,g,d,D,N,v,!1)):v.push([P,D,"annotation",g,N]))}),C&&(stableSort$3(v,function(N){return N[1].match(/format/g)?-1:1}),isFirefox&&v.reverse(),v.forEach(function(N){N[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,N[2]).appendChild(doc$3.createTextNode(N[1])):z.apply(N[0],N.splice(1))})))}},indicators:{addForm:function(g,d,a){var p,v=this.indicators,C=this.lang,P;g&&(this.tabs.init.call(this,g),p=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(p[0]),v.addIndicatorList.call(this,g,p[0],"add"),P=p[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(P,C.addButton||"add","add",a,P),this.addColsContainer(p[1]),v.addIndicatorList.call(this,g,p[1],"edit"),P=p[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(P,C.saveButton||"save","edit",a,P),this.addButton(P,C.removeButton||"remove","remove",a,P))},addIndicatorList:function(g,d,a){var p=this,v=d.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],C=d.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],P=a==="edit",k=P?g.series:g.options.plotOptions,z=this.indicators.addFormFields,$,D,F;g&&(D=createElement$2(UL,{className:PREFIX+"indicator-list"},null,v),$=C.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$c(k,function(N,W){var j=N.options;if(N.params||j&&j.params){var q=p.indicators.getNameType(N,W),X=q.type;F=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,D),F.appendChild(doc$3.createTextNode(q.name)),["click","touchstart"].forEach(function(K){addEvent$y(F,K,function(){z.call(p,g,P?N:k[X],q.type,$),P&&N.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+X,value:N.options.id},null,$).setAttribute(PREFIX+"data-series-id",N.options.id)})})}}),D.childNodes.length>0&&D.childNodes[0].click())},getNameType:function(g,d){var a=g.options,p=H.seriesTypes,v=p[d]&&p[d].prototype.nameBase||d.toUpperCase(),C=d;return a&&a.type&&(C=g.options.type,v=g.name),{name:v,type:C}},listAllSeries:function(g,d,a,p,v){var C=PREFIX+d+"-type-"+g,P=this.lang,k,z;a&&(createElement$2(LABEL,{htmlFor:C},null,p).appendChild(doc$3.createTextNode(P[d]||d)),k=createElement$2(SELECT,{name:C,className:PREFIX+"popup-field"},null,p),k.setAttribute("id",PREFIX+"select-"+d),a.series.forEach(function($){z=$.options,!z.params&&z.id&&z.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:z.id},null,k).appendChild(doc$3.createTextNode(z.name||z.id))}),defined$m(v)&&(k.value=v))},addFormFields:function(g,d,a,p){var v=d.params||d.options.params,C=this.indicators.getNameType;p.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,p).appendChild(doc$3.createTextNode(C(d,a).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+a,value:a},null,p),this.indicators.listAllSeries.call(this,a,"series",g,p,d.linkedParent&&v.volumeSeriesID),v.volumeSeriesID&&this.indicators.listAllSeries.call(this,a,"volume",g,p,d.linkedParent&&d.linkedParent.options.id),this.indicators.addParamInputs.call(this,g,"params",v,a,p)},addParamInputs:function(g,d,a,p,v){var C=this,P=this.indicators.addParamInputs,k=this.addInput,z;g&&objectEach$c(a,function($,D){z=d+"."+D,$!==void 0&&(isObject$8($)?(k.call(C,z,p,v,""),P.call(C,g,z,$,p,v)):z!=="params.volumeSeriesID"&&k.call(C,z,p,v,[$,"text"]))})},getAmount:function(){var g=this.series,d=0;return g.forEach(function(a){var p=a.options;(a.params||p&&p.params)&&d++}),d}},tabs:{init:function(g){var d=this.tabs,a=this.indicators.getAmount.call(g),p;g&&(p=d.addMenuItem.call(this,"add"),d.addMenuItem.call(this,"edit",a),d.addContentItem.call(this,"add"),d.addContentItem.call(this,"edit"),d.switchTabs.call(this,a),d.selectTab.call(this,p,0))},addMenuItem:function(g,d){var a=this.popup.container,p=PREFIX+"tab-item",v=this.lang,C;return d===0&&(p+=" "+PREFIX+"tab-disabled"),C=createElement$2(SPAN,{className:p},void 0,a),C.appendChild(doc$3.createTextNode(v[g+"Button"]||g)),C.setAttribute(PREFIX+"data-tab-type",g),C},addContentItem:function(){var g=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,g)},switchTabs:function(g){var d=this,a=this.popup.container,p=a.querySelectorAll("."+PREFIX+"tab-item"),v;p.forEach(function(C,P){v=C.getAttribute(PREFIX+"data-tab-type"),!(v==="edit"&&g===0)&&["click","touchstart"].forEach(function(k){addEvent$y(C,k,function(){d.tabs.deselectAll.call(d),d.tabs.selectTab.call(d,this,P)})})})},selectTab:function(g,d){var a=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");g.className+=" "+PREFIX+"tab-item-active",a[d].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var g=this.popup.container,d=g.querySelectorAll("."+PREFIX+"tab-item"),a=g.querySelectorAll("."+PREFIX+"tab-item-content"),p;for(p=0;p<d.length;p++)d[p].classList.remove(PREFIX+"tab-item-active"),a[p].classList.remove(PREFIX+"tab-item-show")}}};addEvent$y(NavigationBindings,"showPopup",function(g){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(g.formType,this.chart,g.options,g.onSubmit)});addEvent$y(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$x=Utilities.addEvent,extend$P=Utilities.extend,merge$L=Utilities.merge,pick$Q=Utilities.pick,splat$6=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=(function(){function g(d,a){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(d,a)}return g.prototype.init=function(d,a){this.chart=a,this.background=[],a.pane.push(this),this.setOptions(d)},g.prototype.setOptions=function(d){this.options=d=merge$L(this.defaultOptions,this.chart.angular?{background:{}}:void 0,d)},g.prototype.render=function(){var d=this.options,a=this.options.background,p=this.chart.renderer,v,C;if(this.group||(this.group=p.g("pane-group").attr({zIndex:d.zIndex||0}).add()),this.updateCenter(),a)for(a=splat$6(a),v=Math.max(a.length,this.background.length||0),C=0;C<v;C++)a[C]&&this.axis?this.renderBackground(merge$L(this.defaultBackgroundOptions,a[C]),C):this.background[C]&&(this.background[C]=this.background[C].destroy(),this.background.splice(C,1))},g.prototype.renderBackground=function(d,a){var p="animate",v={class:"highcharts-pane "+(d.className||"")};this.chart.styledMode||extend$P(v,{fill:d.backgroundColor,stroke:d.borderColor,"stroke-width":d.borderWidth}),this.background[a]||(this.background[a]=this.chart.renderer.path().add(this.group),p="attr"),this.background[a][p]({d:this.axis.getPlotBandPath(d.from,d.to,d)}).attr(v)},g.prototype.updateCenter=function(d){this.center=(d||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},g.prototype.update=function(d,a){merge$L(!0,this.options,d),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(p){p.pane===this&&(p.pane=null,p.update({},a))},this)},g})();function isInsidePane(g,d,a){return Math.sqrt(Math.pow(g-a[0],2)+Math.pow(d-a[1],2))<=a[2]/2}Chart$1.prototype.getHoverPane=function(g){var d=this,a;return g&&d.pane.forEach(function(p){var v=g.chartX-d.plotLeft,C=g.chartY-d.plotTop,P=d.inverted?C:v,k=d.inverted?v:C;isInsidePane(P,k,p.center)&&(a=p)}),a};addEvent$x(Chart$1,"afterIsInsidePlot",function(g){var d=this;d.polar&&(g.isInsidePlot=d.pane.some(function(a){return isInsidePane(g.x,g.y,a.center)}))});addEvent$x(Pointer,"beforeGetHoverData",function(g){var d=this.chart;d.polar?(d.hoverPane=d.getHoverPane(g),g.filter=function(a){return a.visible&&!(!g.shared&&a.directTouch)&&pick$Q(a.options.enableMouseTracking,!0)&&(!d.hoverPane||a.xAxis.pane===d.hoverPane)}):d.hoverPane=void 0});addEvent$x(Pointer,"afterGetHoverData",function(g){var d=this.chart;g.hoverPoint&&g.hoverPoint.plotX&&g.hoverPoint.plotY&&d.hoverPane&&!isInsidePane(g.hoverPoint.plotX,g.hoverPoint.plotY,d.hoverPane.center)&&(g.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$7=DefaultOptions.defaultOptions,noop$b=H.noop,addEvent$w=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$l=Utilities.defined,extend$O=Utilities.extend,fireEvent$8=Utilities.fireEvent,merge$K=Utilities.merge,pick$P=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$c=Utilities.wrap,RadialAxis;(function(g){var d=[],a={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},p={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},v={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function C(){this.autoConnect=this.isCircular&&typeof pick$P(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function P(_e,Ce){return d.indexOf(_e)===-1&&(d.push(_e),addEvent$w(_e,"afterInit",ee),addEvent$w(_e,"autoLabelAlign",te),addEvent$w(_e,"destroy",ie),addEvent$w(_e,"init",oe),addEvent$w(_e,"initialAxisTranslation",ae)),d.indexOf(Ce)===-1&&(d.push(Ce),addEvent$w(Ce,"afterGetLabelPosition",le),addEvent$w(Ce,"afterGetPosition",ce),wrap$c(Ce.prototype,"getMarkPath",be)),_e}g.compose=P;function k(){var _e=this;return function(){if(_e.isRadial&&_e.tickPositions&&_e.options.labels&&_e.options.labels.allowOverlap!==!0)return _e.tickPositions.map(function(Ce){return _e.ticks[Ce]&&_e.ticks[Ce].label}).filter(function(Ce){return!!Ce})}}function z(){return noop$b}function $(_e,Ce,Ee){var Te=this.pane.center,$e=_e.value,Ge,Ne,ke,Fe;return this.isCircular?(defined$l($e)?_e.point&&(Ge=_e.point.shapeArgs||{},Ge.start&&($e=this.chart.inverted?this.translate(_e.point.rectPlotY,!0):_e.point.x)):(ke=_e.chartX||0,Fe=_e.chartY||0,$e=this.translate(Math.atan2(Fe-Ee,ke-Ce)-this.startAngleRad,!0)),Ne=this.getPosition($e),ke=Ne.x,Fe=Ne.y):(defined$l($e)||(ke=_e.chartX,Fe=_e.chartY),defined$l(ke)&&defined$l(Fe)&&(Ee=Te[1]+this.chart.plotTop,$e=this.translate(Math.min(Math.sqrt(Math.pow(ke-Ce,2)+Math.pow(Fe-Ee,2)),Te[2]/2)-Te[3]/2,!0))),[$e,ke||0,Fe||0]}function D(_e,Ce,Ee){var Te=this.pane.center,$e=this.chart,Ge=this.left||0,Ne=this.top||0,ke,Fe=pick$P(Ce,Te[2]/2-this.offset),We;return typeof Ee>"u"&&(Ee=this.horiz?0:this.center&&-this.center[3]/2),Ee&&(Fe+=Ee),this.isCircular||typeof Ce<"u"?(We=this.chart.renderer.symbols.arc(Ge+Te[0],Ne+Te[1],Fe,Fe,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),We.xBounds=[Ge+Te[0]],We.yBounds=[Ne+Te[1]-Fe]):(ke=this.postTranslate(this.angleRad,Fe),We=[["M",this.center[0]+$e.plotLeft,this.center[1]+$e.plotTop],["L",ke.x,ke.y]]),We}function F(){var _e=this.constructor.prototype;_e.getOffset.call(this),this.chart.axisOffset[this.side]=0}function N(_e,Ce,Ee){var Te=this.chart,$e=function(Kt){if(typeof Kt=="string"){var oi=parseInt(Kt,10);return nt.test(Kt)&&(oi=oi*ke/100),oi}return Kt},Ge=this.center,Ne=this.startAngleRad,ke=Ge[2]/2,Fe=Math.min(this.offset,0),We=this.left||0,De=this.top||0,nt=/%$/,gt=this.isCircular,at,lt,pt,mt,Dt,Ct,Mt=pick$P($e(Ee.outerRadius),ke),St=$e(Ee.innerRadius),Gt=pick$P($e(Ee.thickness),10);if(this.options.gridLineInterpolation==="polygon")Ct=this.getPlotLinePath({value:_e}).concat(this.getPlotLinePath({value:Ce,reverse:!0}));else{_e=Math.max(_e,this.min),Ce=Math.min(Ce,this.max);var At=this.translate(_e),ai=this.translate(Ce);gt||(Mt=At||0,St=ai||0),Ee.shape==="circle"||!gt?(at=-Math.PI/2,lt=Math.PI*1.5,Dt=!0):(at=Ne+(At||0),lt=Ne+(ai||0)),Mt-=Fe,Gt-=Fe,Ct=Te.renderer.symbols.arc(We+Ge[0],De+Ge[1],Mt,Mt,{start:Math.min(at,lt),end:Math.max(at,lt),innerR:pick$P(St,Mt-Gt),open:Dt}),gt&&(pt=(lt+at)/2,mt=We+Ge[0]+Ge[2]/2*Math.cos(pt),Ct.xBounds=pt>-Math.PI/2&&pt<Math.PI/2?[mt,Te.plotWidth]:[0,mt],Ct.yBounds=[De+Ge[1]+Ge[2]/2*Math.sin(pt)],Ct.yBounds[0]+=pt>-Math.PI&&pt<0||pt>Math.PI?-10:10)}return Ct}function W(_e){var Ce=this,Ee=this.pane.center,Te=this.chart,$e=Te.inverted,Ge=_e.reverse,Ne=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},ke=Ne.innerRadius||"0%",Fe=Ne.outerRadius||"100%",We=Ee[0]+Te.plotLeft,De=Ee[1]+Te.plotTop,nt=this.height,gt=_e.isCrosshair,at=Ee[3]/2,lt=_e.value,pt,mt,Dt,Ct,Mt,St,Gt,At,ai,Kt=this.getPosition(lt),oi=Kt.x,ci=Kt.y;if(gt&&(At=this.getCrosshairPosition(_e,We,De),lt=At[0],oi=At[1],ci=At[2]),this.isCircular)mt=Math.sqrt(Math.pow(oi-We,2)+Math.pow(ci-De,2)),Dt=typeof ke=="string"?relativeLength$2(ke,1):ke/mt,Ct=typeof Fe=="string"?relativeLength$2(Fe,1):Fe/mt,Ee&&at&&(pt=at/mt,Dt<pt&&(Dt=pt),Ct<pt&&(Ct=pt)),ai=[["M",We+Dt*(oi-We),De-Dt*(De-ci)],["L",oi-(1-Ct)*(oi-We),ci+(1-Ct)*(De-ci)]];else if(lt=this.translate(lt),lt&&(lt<0||lt>nt)&&(lt=0),this.options.gridLineInterpolation==="circle")ai=this.getLinePath(0,lt,at);else if(ai=[],Te[$e?"yAxis":"xAxis"].forEach(function(hi){hi.pane===Ce.pane&&(Mt=hi)}),Mt){Gt=Mt.tickPositions,Mt.autoConnect&&(Gt=Gt.concat([Gt[0]])),Ge&&(Gt=Gt.slice().reverse()),lt&&(lt+=at);for(var dt=0;dt<Gt.length;dt++)St=Mt.getPosition(Gt[dt],lt),ai.push(dt?["L",St.x,St.y]:["M",St.x,St.y])}return ai}function j(_e,Ce){var Ee=this.translate(_e);return this.postTranslate(this.isCircular?Ee:this.angleRad,pick$P(this.isCircular?Ce:Ee<0?0:Ee,this.center[2]/2)-this.offset)}function q(){var _e=this.center,Ce=this.chart,Ee=this.options.title;return{x:Ce.plotLeft+_e[0]+(Ee.x||0),y:Ce.plotTop+_e[1]-{high:.5,middle:.25,low:0}[Ee.align]*_e[2]+(Ee.y||0)}}function X(_e){_e.beforeSetTickPositions=C,_e.createLabelCollector=k,_e.getCrosshairPosition=$,_e.getLinePath=D,_e.getOffset=F,_e.getPlotBandPath=N,_e.getPlotLinePath=W,_e.getPosition=j,_e.getTitlePosition=q,_e.postTranslate=ue,_e.setAxisSize=ye,_e.setAxisTranslation=we,_e.setOptions=ve}function K(_e){_e.isHidden=!0,_e.createLabelCollector=z,_e.getOffset=noop$b,_e.redraw=ge,_e.render=ge,_e.setScale=noop$b,_e.setCategories=noop$b,_e.setTitle=noop$b}function ee(){var _e=this.chart,Ce=this.options,Ee=_e.angular&&this.isXAxis,Te=this.pane,$e=Te&&Te.options;!Ee&&Te&&(_e.angular||_e.polar)&&(this.angleRad=(Ce.angle||0)*Math.PI/180,this.startAngleRad=($e.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$P($e.endAngle,$e.startAngle+360)-90)*Math.PI/180,this.offset=Ce.offset||0)}function te(_e){this.isRadial&&(_e.align=void 0,_e.preventDefault())}function ie(){if(this.chart&&this.chart.labelCollectors){var _e=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;_e>=0&&this.chart.labelCollectors.splice(_e,1)}}function oe(_e){var Ce=this.chart,Ee=Ce.inverted,Te=Ce.angular,$e=Ce.polar,Ge=this.isXAxis,Ne=this.coll,ke=Te&&Ge,Fe=Ce.options,We=_e.userOptions.pane||0,De=this.pane=Ce.pane&&Ce.pane[We],nt;if(Ne==="colorAxis"){this.isRadial=!1;return}Te?(ke?K(this):X(this),nt=!Ge,nt&&(this.defaultPolarOptions=p)):$e&&(X(this),nt=this.horiz,this.defaultPolarOptions=nt?a:merge$K(Ne==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,v),Ee&&Ne==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),Te||$e?(this.isRadial=!0,Fe.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&Ce.labelCollectors.push(this.labelCollector)):this.isRadial=!1,De&&nt&&(De.axis=this),this.isCircular=nt}function ae(){this.isRadial&&this.beforeSetTickPositions()}function le(_e){var Ce=this.label;if(Ce){var Ee=this.axis,Te=Ce.getBBox(),$e=Ee.options.labels,Ge=(Ee.translate(this.pos)+Ee.startAngleRad+Math.PI/2)/Math.PI*180%360,Ne=Math.round(Ge),ke=defined$l($e.y)?0:-Te.height*.3,Fe=$e.y,We,De=20,nt=$e.align,gt="end",at=Ne<0?Ne+360:Ne,lt=at,pt=0,mt=0;Ee.isRadial&&(We=Ee.getPosition(this.pos,Ee.center[2]/2+relativeLength$2(pick$P($e.distance,-25),Ee.center[2]/2,-Ee.center[2]/2)),$e.rotation==="auto"?Ce.attr({rotation:Ge}):defined$l(Fe)||(Fe=Ee.chart.renderer.fontMetrics(Ce.styles&&Ce.styles.fontSize).b-Te.height/2),defined$l(nt)||(Ee.isCircular?(Te.width>Ee.len*Ee.tickInterval/(Ee.max-Ee.min)&&(De=0),Ge>De&&Ge<180-De?nt="left":Ge>180+De&&Ge<360-De?nt="right":nt="center"):nt="center",Ce.attr({align:nt})),nt==="auto"&&Ee.tickPositions.length===2&&Ee.isCircular&&(at>90&&at<180?at=180-at:at>270&&at<=360&&(at=540-at),lt>180&&lt<=360&&(lt=360-lt),(Ee.pane.options.startAngle===Ne||Ee.pane.options.startAngle===Ne+360||Ee.pane.options.startAngle===Ne-360)&&(gt="start"),Ne>=-90&&Ne<=90||Ne>=-360&&Ne<=-270||Ne>=270&&Ne<=360?nt=gt==="start"?"right":"left":nt=gt==="start"?"left":"right",lt>70&&lt<110&&(nt="center"),at<15||at>=180&&at<195?pt=Te.height*.3:at>=15&&at<=35?pt=gt==="start"?0:Te.height*.75:at>=195&&at<=215?pt=gt==="start"?Te.height*.75:0:at>35&&at<=90?pt=gt==="start"?-Te.height*.25:Te.height:at>215&&at<=270&&(pt=gt==="start"?Te.height:-Te.height*.25),lt<15?mt=gt==="start"?-Te.height*.15:Te.height*.15:lt>165&&lt<=180&&(mt=gt==="start"?Te.height*.15:-Te.height*.15),Ce.attr({align:nt}),Ce.translate(mt,pt+ke)),_e.pos.x=We.x+($e.x||0),_e.pos.y=We.y+(Fe||0))}}function ce(_e){this.axis.getPosition&&extend$O(_e.pos,this.axis.getPosition(this.pos))}function ue(_e,Ce){var Ee=this.chart,Te=this.center;return _e=this.startAngleRad+_e,{x:Ee.plotLeft+Te[0]+Math.cos(_e)*Ce,y:Ee.plotTop+Te[1]+Math.sin(_e)*Ce}}function ge(){this.isDirty=!1}function ye(){var _e=this.constructor.prototype,Ce,Ee;_e.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),Ce=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(Ee=this.postTranslate(this.angleRad,Ce[3]/2),Ce[0]=Ee.x-this.chart.plotLeft,Ce[1]=Ee.y-this.chart.plotTop),this.len=this.width=this.height=(Ce[2]-Ce[3])*pick$P(this.sector,1)/2)}function we(){var _e=this.constructor.prototype;_e.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function ve(_e){var Ce=this.options=merge$K(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$7[this.coll],_e);Ce.plotBands||(Ce.plotBands=[]),fireEvent$8(this,"afterSetOptions")}function be(_e,Ce,Ee,Te,$e,Ge,Ne){var ke=this.axis,Fe,We;return ke.isRadial?(Fe=ke.getPosition(this.pos,ke.center[2]/2+Te),We=["M",Ce,Ee,"L",Fe.x,Fe.y]):We=_e.call(this,Ce,Ee,Te,$e,Ge,Ne),We}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$1_=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),pointProto=Point$4.prototype,defined$k=Utilities.defined,isNumber$o=Utilities.isNumber,AreaRangePoint$1=(function(g){__extends$1_(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.high=void 0,a.low=void 0,a.options=void 0,a.plotHigh=void 0,a.plotLow=void 0,a.plotHighX=void 0,a.plotLowX=void 0,a.plotX=void 0,a.series=void 0,a}return d.prototype.setState=function(){var a=this.state,p=this.series,v=p.chart.polar;defined$k(this.plotHigh)||(this.plotHigh=p.yAxis.toPixels(this.high,!0)),defined$k(this.plotLow)||(this.plotLow=this.plotY=p.yAxis.toPixels(this.low,!0)),p.stateMarkerGraphic&&(p.lowerStateMarkerGraphic=p.stateMarkerGraphic,p.stateMarkerGraphic=p.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,v&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=a,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,v&&(this.plotX=this.plotLowX),p.stateMarkerGraphic&&(p.upperStateMarkerGraphic=p.stateMarkerGraphic,p.stateMarkerGraphic=p.lowerStateMarkerGraphic,p.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},d.prototype.haloPath=function(){var a=this.series.chart.polar,p=[];return this.plotY=this.plotLow,a&&(this.plotX=this.plotLowX),this.isInside&&(p=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,a&&(this.plotX=this.plotHighX),this.isTopInside&&(p=p.concat(pointProto.haloPath.apply(this,arguments))),p},d.prototype.isValid=function(){return isNumber$o(this.low)&&isNumber$o(this.high)},d})(AreaSeries$1.prototype.pointClass),__extends$1Z=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$a=H.noop,seriesProto$1=Series$f.prototype,defined$j=Utilities.defined,extend$N=Utilities.extend,isArray$8=Utilities.isArray,pick$O=Utilities.pick,merge$J=Utilities.merge,AreaRangeSeries$2=(function(g){__extends$1Z(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.lowerStateMarkerGraphic=void 0,a.xAxis=void 0,a}return d.prototype.toYData=function(a){return[a.low,a.high]},d.prototype.highToXY=function(a){var p=this.chart,v=this.xAxis.postTranslate(a.rectPlotX||0,this.yAxis.len-a.plotHigh);a.plotHighX=v.x-p.plotLeft,a.plotHigh=v.y-p.plotTop,a.plotLowX=a.plotX},d.prototype.translate=function(){var a=this,p=a.yAxis,v=!!a.modifyValue;areaProto.translate.apply(a),a.points.forEach(function(C){var P=C.high,k=C.plotY;C.isNull?C.plotY=null:(C.plotLow=k,C.plotHigh=p.translate(v?a.modifyValue(P,C):P,0,1,0,1),v&&(C.yBottom=C.plotHigh))}),this.chart.polar&&this.points.forEach(function(C){a.highToXY(C),C.tooltipPos=[(C.plotHighX+C.plotLowX)/2,(C.plotHigh+C.plotLow)/2]})},d.prototype.getGraphPath=function(a){var p=[],v=[],C,P=areaProto.getGraphPath,k,z,$,D,F=this.options,N=this.chart.polar,W=N&&F.connectEnds!==!1,j=F.connectNulls,q=F.step,X,K;for(a=a||this.points,C=a.length;C--;){k=a[C];var ee=N?{plotX:k.rectPlotX,plotY:k.yBottom,doCurve:!1}:{plotX:k.plotX,plotY:k.plotY,doCurve:!1};!k.isNull&&!W&&!j&&(!a[C+1]||a[C+1].isNull)&&v.push(ee),z={polarPlotY:k.polarPlotY,rectPlotX:k.rectPlotX,yBottom:k.yBottom,plotX:pick$O(k.plotHighX,k.plotX),plotY:k.plotHigh,isNull:k.isNull},v.push(z),p.push(z),!k.isNull&&!W&&!j&&(!a[C-1]||a[C-1].isNull)&&v.push(ee)}return D=P.call(this,a),q&&(q===!0&&(q="left"),F.step={left:"right",center:"center",right:"left"}[q]),X=P.call(this,p),K=P.call(this,v),F.step=q,$=[].concat(D,X),!this.chart.polar&&K[0]&&K[0][0]==="M"&&(K[0]=["L",K[0][1],K[0][2]]),this.graphPath=$,this.areaPath=D.concat(K),$.isArea=!0,$.xMap=D.xMap,this.areaPath.xMap=D.xMap,$},d.prototype.drawDataLabels=function(){var a=this.points,p=a.length,v,C=[],P=this.options.dataLabels,k,z,$=this.chart.inverted,D,F;if(P){if(isArray$8(P)?(D=P[0]||{enabled:!1},F=P[1]||{enabled:!1}):(D=extend$N({},P),D.x=P.xHigh,D.y=P.yHigh,F=extend$N({},P),F.x=P.xLow,F.y=P.yLow),D.enabled||this._hasPointLabels){for(v=p;v--;)k=a[v],k&&(z=D.inside?k.plotHigh<k.plotLow:k.plotHigh>k.plotLow,k.y=k.high,k._plotY=k.plotY,k.plotY=k.plotHigh,C[v]=k.dataLabel,k.dataLabel=k.dataLabelUpper,k.below=z,$?D.align||(D.align=z?"right":"left"):D.verticalAlign||(D.verticalAlign=z?"top":"bottom"));for(this.options.dataLabels=D,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),v=p;v--;)k=a[v],k&&(k.dataLabelUpper=k.dataLabel,k.dataLabel=C[v],delete k.dataLabels,k.y=k.low,k.plotY=k._plotY)}if(F.enabled||this._hasPointLabels){for(v=p;v--;)k=a[v],k&&(z=F.inside?k.plotHigh<k.plotLow:k.plotHigh>k.plotLow,k.below=!z,$?F.align||(F.align=z?"left":"right"):F.verticalAlign||(F.verticalAlign=z?"bottom":"top"));this.options.dataLabels=F,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(D.enabled)for(v=p;v--;)k=a[v],k&&(k.dataLabels=[k.dataLabelUpper,k.dataLabel].filter(function(N){return!!N}));this.options.dataLabels=P}},d.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},d.prototype.drawPoints=function(){var a=this,p=a.points.length,v,C;for(seriesProto$1.drawPoints.apply(a,arguments),C=0;C<p;)v=a.points[C],v.origProps={plotY:v.plotY,plotX:v.plotX,isInside:v.isInside,negative:v.negative,zone:v.zone,y:v.y},v.lowerGraphic=v.graphic,v.graphic=v.upperGraphic,v.plotY=v.plotHigh,defined$j(v.plotHighX)&&(v.plotX=v.plotHighX),v.y=pick$O(v.high,v.origProps.y),v.negative=v.y<(a.options.threshold||0),a.zones.length&&(v.zone=v.getZone()),a.chart.polar||(v.isInside=v.isTopInside=typeof v.plotY<"u"&&v.plotY>=0&&v.plotY<=a.yAxis.len&&v.plotX>=0&&v.plotX<=a.xAxis.len),C++;for(seriesProto$1.drawPoints.apply(a,arguments),C=0;C<p;)v=a.points[C],v.upperGraphic=v.graphic,v.graphic=v.lowerGraphic,v.origProps&&(extend$N(v,v.origProps),delete v.origProps),C++},d.defaultOptions=merge$J(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),d})(AreaSeries$1);extend$N(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$1Y=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$I=Utilities.merge,extend$M=Utilities.extend,AreaSplineRangeSeries=(function(g){__extends$1Y(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.data=void 0,a.points=void 0,a}return d.defaultOptions=merge$I(AreaRangeSeries$2.defaultOptions),d})(AreaRangeSeries$2);extend$M(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$1X=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$9=H.noop,extend$L=Utilities.extend,merge$H=Utilities.merge,pick$N=Utilities.pick,BoxPlotSeries=(function(g){__extends$1X(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.pointAttribs=function(){return{}},d.prototype.translate=function(){var a=this,p=a.yAxis,v=a.pointArrayMap;g.prototype.translate.apply(a),a.points.forEach(function(C){v.forEach(function(P){C[P]!==null&&(C[P+"Plot"]=p.translate(C[P],0,1,0,1))}),C.plotHigh=C.highPlot})},d.prototype.drawPoints=function(){var a=this,p=a.points,v=a.options,C=a.chart,P=C.renderer,k,z,$,D,F,N,W,j=0,q,X,K,ee,te,ie=a.doQuartiles!==!1,oe,ae=a.options.whiskerLength;p.forEach(function(le){var ce=le.graphic,ue=ce?"animate":"attr",ge=le.shapeArgs,ye={},we={},ve={},be={},_e=le.color||a.color;if(typeof le.plotY<"u"){X=Math.round(ge.width),K=Math.floor(ge.x),ee=K+X,te=Math.round(X/2),k=Math.floor(ie?le.q1Plot:le.lowPlot),z=Math.floor(ie?le.q3Plot:le.lowPlot),$=Math.floor(le.highPlot),D=Math.floor(le.lowPlot),ce||(le.graphic=ce=P.g("point").add(a.group),le.stem=P.path().addClass("highcharts-boxplot-stem").add(ce),ae&&(le.whiskers=P.path().addClass("highcharts-boxplot-whisker").add(ce)),ie&&(le.box=P.path(q).addClass("highcharts-boxplot-box").add(ce)),le.medianShape=P.path(N).addClass("highcharts-boxplot-median").add(ce)),C.styledMode||(we.stroke=le.stemColor||v.stemColor||_e,we["stroke-width"]=pick$N(le.stemWidth,v.stemWidth,v.lineWidth),we.dashstyle=le.stemDashStyle||v.stemDashStyle||v.dashStyle,le.stem.attr(we),ae&&(ve.stroke=le.whiskerColor||v.whiskerColor||_e,ve["stroke-width"]=pick$N(le.whiskerWidth,v.whiskerWidth,v.lineWidth),ve.dashstyle=le.whiskerDashStyle||v.whiskerDashStyle||v.dashStyle,le.whiskers.attr(ve)),ie&&(ye.fill=le.fillColor||v.fillColor||_e,ye.stroke=v.lineColor||_e,ye["stroke-width"]=v.lineWidth||0,ye.dashstyle=le.boxDashStyle||v.boxDashStyle||v.dashStyle,le.box.attr(ye)),be.stroke=le.medianColor||v.medianColor||_e,be["stroke-width"]=pick$N(le.medianWidth,v.medianWidth,v.lineWidth),be.dashstyle=le.medianDashStyle||v.medianDashStyle||v.dashStyle,le.medianShape.attr(be));var Ce=void 0;W=le.stem.strokeWidth()%2/2,j=K+te+W,Ce=[["M",j,z],["L",j,$],["M",j,k],["L",j,D]],le.stem[ue]({d:Ce}),ie&&(W=le.box.strokeWidth()%2/2,k=Math.floor(k)+W,z=Math.floor(z)+W,K+=W,ee+=W,Ce=[["M",K,z],["L",K,k],["L",ee,k],["L",ee,z],["L",K,z],["Z"]],le.box[ue]({d:Ce})),ae&&(W=le.whiskers.strokeWidth()%2/2,$=$+W,D=D+W,oe=/%$/.test(ae)?te*parseFloat(ae)/100:ae/2,Ce=[["M",j-oe,$],["L",j+oe,$],["M",j-oe,D],["L",j+oe,D]],le.whiskers[ue]({d:Ce})),F=Math.round(le.medianPlot),W=le.medianShape.strokeWidth()%2/2,F=F+W,Ce=[["M",K,F],["L",ee,F]],le.medianShape[ue]({d:Ce})}})},d.prototype.toYData=function(a){return[a.low,a.q1,a.median,a.q3,a.high]},d.defaultOptions=merge$H(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),d})(ColumnSeries$h);extend$L(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$9,setStackedPoints:noop$9});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$8=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$n=Utilities.isNumber,merge$G=Utilities.merge,pick$M=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=(function(){function g(d,a){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$8,this.init(d,a)}return g.prototype.init=function(d,a){this.options=d,this.visible=!0,this.chart=a.chart,this.legend=a},g.prototype.addToLegend=function(d){d.splice(this.options.legendIndex,0,this)},g.prototype.drawLegendSymbol=function(d){var a=this.chart,p=this.options,v=pick$M(d.options.itemDistance,20),C=p.ranges,P=p.connectorDistance,k;if(this.fontMetrics=a.renderer.fontMetrics(p.labels.style.fontSize),!C||!C.length||!isNumber$n(C[0].value)){d.options.bubbleLegend.autoRanges=!0;return}stableSort$2(C,function(F,N){return N.value-F.value}),this.ranges=C,this.setOptions(),this.render();var z=this.getMaxLabelSize(),$=this.ranges[0].radius,D=$*2;k=P-$+z.width,k=k>0?k:0,this.maxLabel=z,this.movementX=p.labels.align==="left"?k:0,this.legendItemWidth=D+k+v,this.legendItemHeight=D+this.fontMetrics.h/2},g.prototype.setOptions=function(){var d=this.ranges,a=this.options,p=this.chart.series[a.seriesIndex],v=this.legend.baseline,C={zIndex:a.zIndex,"stroke-width":a.borderWidth},P={zIndex:a.zIndex,"stroke-width":a.connectorWidth},k={align:this.legend.options.rtl||a.labels.align==="left"?"right":"left",zIndex:a.zIndex},z=p.options.marker.fillOpacity,$=this.chart.styledMode;d.forEach(function(D,F){$||(C.stroke=pick$M(D.borderColor,a.borderColor,p.color),C.fill=pick$M(D.color,a.color,z!==1?color$a(p.color).setOpacity(z).get("rgba"):p.color),P.stroke=pick$M(D.connectorColor,a.connectorColor,p.color)),d[F].radius=this.getRangeRadius(D.value),d[F]=merge$G(d[F],{center:d[0].radius-d[F].radius+v}),$||merge$G(!0,d[F],{bubbleAttribs:merge$G(C),connectorAttribs:merge$G(P),labelAttribs:k})},this)},g.prototype.getRangeRadius=function(d){var a=this.options,p=this.options.seriesIndex,v=this.chart.series[p],C=a.ranges[0].value,P=a.ranges[a.ranges.length-1].value,k=a.minSize,z=a.maxSize;return v.getRadius.call(this,P,C,k,z,d)},g.prototype.render=function(){var d=this.chart.renderer,a=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=d.g("bubble-legend"),this.legendItem=d.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(p){p.value>=a&&this.renderRange(p)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},g.prototype.renderRange=function(d){var a=this.ranges[0],p=this.legend,v=this.options,C=v.labels,P=this.chart,k=P.series[v.seriesIndex],z=P.renderer,$=this.symbols,D=$.labels,F=d.center,N=Math.abs(d.radius),W=v.connectorDistance||0,j=C.align,q=p.options.rtl,X=v.borderWidth,K=v.connectorWidth,ee=a.radius||0,te=F-N-X/2+K/2,ie=this.fontMetrics,oe=ie.f/2-(ie.h-ie.f)/2,ae=(te%1?1:.5)-(K%2?0:.5),le=z.styledMode,ce=q||j==="left"?-W:W;j==="center"&&(ce=0,v.connectorDistance=0,d.labelAttribs.align="center");var ue=te+v.labels.y,ge=ee+ce+v.labels.x;$.bubbleItems.push(z.circle(ee,F+ae,N).attr(le?{}:d.bubbleAttribs).addClass((le?"highcharts-color-"+k.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(v.className||"")).add(this.legendSymbol)),$.connectors.push(z.path(z.crispLine([["M",ee,te],["L",ee+ce,te]],v.connectorWidth)).attr(le?{}:d.connectorAttribs).addClass((le?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(v.connectorClassName||"")).add(this.legendSymbol));var ye=z.text(this.formatLabel(d),ge,ue+oe).attr(le?{}:d.labelAttribs).css(le?{}:C.style).addClass("highcharts-bubble-legend-labels "+(v.labels.className||"")).add(this.legendSymbol);D.push(ye),ye.placed=!0,ye.alignAttr={x:ge,y:ue+oe}},g.prototype.getMaxLabelSize=function(){var d=this.symbols.labels,a,p;return d.forEach(function(v){p=v.getBBox(!0),a?a=p.width>a.width?p:a:a=p}),a||{}},g.prototype.formatLabel=function(d){var a=this.options,p=a.labels.formatter,v=a.labels.format,C=this.chart.numberFormatter;return v?FormatUtilities.format(v,d):p?p.call(d):C(d.value,1)},g.prototype.hideOverlappingLabels=function(){var d=this.chart,a=this.options.labels.allowOverlap,p=this.symbols;!a&&p&&(d.hideOverlappingLabels(p.labels),p.labels.forEach(function(v,C){v.newOpacity?v.newOpacity!==v.oldOpacity&&p.connectors[C].show():p.connectors[C].hide()}))},g.prototype.getRanges=function(){var d=this.legend.bubbleLegend,a=d.chart.series,p=d.options.ranges,v,C,P=Number.MAX_VALUE,k=-Number.MAX_VALUE;return a.forEach(function(z){z.isBubble&&!z.ignoreSeries&&(C=z.zData.filter(isNumber$n),C.length&&(P=pick$M(z.options.zMin,Math.min(P,Math.max(arrayMin$3(C),z.options.displayNegative===!1?z.options.zThreshold:-Number.MAX_VALUE))),k=pick$M(z.options.zMax,Math.max(k,arrayMax$3(C)))))}),P===k?v=[{value:k}]:v=[{value:P},{value:(P+k)/2},{value:k,autoRanges:!0}],p.length&&p[0].radius&&v.reverse(),v.forEach(function(z,$){p&&p[$]&&(v[$]=merge$G(p[$],z))}),v},g.prototype.predictBubbleSizes=function(){var d=this.chart,a=this.fontMetrics,p=d.legend.options,v=p.floating,C=p.layout==="horizontal",P=C?d.legend.lastLineHeight:0,k=d.plotSizeX,z=d.plotSizeY,$=d.series[this.options.seriesIndex],D=Math.ceil($.minPxSize),F=Math.ceil($.maxPxSize),N=Math.min(z,k),W,j=$.options.maxSize;return v||!/%$/.test(j)?W=F:(j=parseFloat(j),W=(N+P-a.h/2)*j/100/(j/100+1),(C&&z-W>=k||!C&&k-W>=z)&&(W=F)),[D,Math.ceil(W)]},g.prototype.updateRanges=function(d,a){var p=this.legend.options.bubbleLegend;p.minSize=d,p.maxSize=a,p.ranges=this.getRanges()},g.prototype.correctSizes=function(){var d=this.legend,a=this.chart,p=a.series[this.options.seriesIndex],v=p.maxPxSize,C=this.options.maxSize;Math.abs(Math.ceil(v)-C)>1&&(this.updateRanges(this.options.minSize,p.maxPxSize),d.render())},g})(),setOptions=DefaultOptions.setOptions,addEvent$v=Utilities.addEvent,objectEach$b=Utilities.objectEach,wrap$b=Utilities.wrap,BubbleLegendComposition;(function(g){var d=[];function a($,D,F){var N=this,W=N.legend,j=v(N)>=0,q,X;W&&W.options.enabled&&W.bubbleLegend&&W.options.bubbleLegend.autoRanges&&j?(q=W.bubbleLegend.options,X=W.bubbleLegend.predictBubbleSizes(),W.bubbleLegend.updateRanges(X[0],X[1]),q.placed||(W.group.placed=!1,W.allItems.forEach(function(K){K.legendGroup.translateY=null})),W.render(),N.getMargins(),N.axes.forEach(function(K){K.visible&&K.render(),q.placed||(K.setScale(),K.updateNames(),objectEach$b(K.ticks,function(ee){ee.isNew=!0,ee.isNewLabel=!0}))}),q.placed=!0,N.getMargins(),$.call(N,D,F),W.bubbleLegend.correctSizes(),z(W,C(W))):($.call(N,D,F),W&&W.options.enabled&&W.bubbleLegend&&(W.render(),z(W,C(W))))}function p($,D,F){d.indexOf($)===-1&&(d.push($),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$b($.prototype,"drawChartBox",a)),d.indexOf(D)===-1&&(d.push(D),addEvent$v(D,"afterGetAllItems",P)),d.indexOf(F)===-1&&(d.push(F),addEvent$v(F,"legendItemClick",k))}g.compose=p;function v($){for(var D=$.series,F=0;F<D.length;){if(D[F]&&D[F].isBubble&&D[F].visible&&D[F].zData.length)return F;F++}return-1}function C($){var D=$.allItems,F=[],N=D.length,W,j=0,q=0;for(j=0;j<N;j++)if(D[j].legendItemHeight&&(D[j].itemHeight=D[j].legendItemHeight),D[j]===D[N-1]||D[j+1]&&D[j]._legendItemPos[1]!==D[j+1]._legendItemPos[1]){for(F.push({height:0}),W=F[F.length-1],q;q<=j;q++)D[q].itemHeight>W.height&&(W.height=D[q].itemHeight);W.step=j}return F}function P($){var D=this,F=D.bubbleLegend,N=D.options,W=N.bubbleLegend,j=v(D.chart);F&&F.ranges&&F.ranges.length&&(W.ranges.length&&(W.autoRanges=!!W.ranges[0].autoRanges),D.destroyItem(F)),j>=0&&N.enabled&&W.enabled&&(W.seriesIndex=j,D.bubbleLegend=new BubbleLegendItem(W,D),D.bubbleLegend.addToLegend($.allItems))}function k(){var $=this,D=$.chart,F=$.visible,N=$.chart.legend,W;N&&N.bubbleLegend&&($.visible=!F,$.ignoreSeries=F,W=v(D)>=0,N.bubbleLegend.visible!==W&&(N.update({bubbleLegend:{enabled:W}}),N.bubbleLegend.visible=W),$.visible=F)}function z($,D){var F=$.allItems,N=$.options.rtl,W,j,q,X=0;F.forEach(function(K,ee){W=K.legendGroup.translateX,j=K._legendItemPos[1],q=K.movementX,(q||N&&K.ranges)&&(q=N?W-K.options.maxSize/2:W+q,K.legendGroup.attr({translateX:q})),ee>D[X].step&&X++,K.legendGroup.attr({translateY:Math.round(j+D[X].height/2)}),K._legendItemPos[1]=j+D[X].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$1W=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$K=Utilities.extend,BubblePoint=(function(g){__extends$1W(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.haloPath=function(a){return Point$4.prototype.haloPath.call(this,a===0?0:(this.marker&&this.marker.radius||0)+a)},d})(ScatterPoint$2);extend$K(BubblePoint.prototype,{ttBelow:!1});var __extends$1V=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),color$9=Color.parse,noop$7=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$a=Utilities.clamp,extend$J=Utilities.extend,isNumber$m=Utilities.isNumber,merge$F=Utilities.merge,pick$L=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=(function(g){__extends$1V(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.maxPxSize=void 0,a.minPxSize=void 0,a.options=void 0,a.points=void 0,a.radii=void 0,a.yData=void 0,a.zData=void 0,a}return d.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(p){var v=p.graphic;v&&v.width&&(this.hasRendered||v.attr({x:p.plotX,y:p.plotY,width:1,height:1}),v.animate(this.markerAttribs(p),this.options.animation))},this)},d.prototype.getRadii=function(a,p,v){var C,P,k=this.zData,z=this.yData,$=v.minPxSize,D=v.maxPxSize,F=[],N;for(P=0,C=k.length;P<C;P++)N=k[P],F.push(this.getRadius(a,p,$,D,N,z[P]));this.radii=F},d.prototype.getRadius=function(a,p,v,C,P,k){var z=this.options,$=z.sizeBy!=="width",D=z.zThreshold,F=p-a,N=.5;if(k===null||P===null)return null;if(isNumber$m(P)){if(z.sizeByAbsoluteValue&&(P=Math.abs(P-D),p=F=Math.max(p-D,Math.abs(a-D)),a=0),P<a)return v/2-1;F>0&&(N=(P-a)/F)}return $&&N>=0&&(N=Math.sqrt(N)),Math.ceil(v+N*(C-v))/2},d.prototype.hasData=function(){return!!this.processedXData.length},d.prototype.pointAttribs=function(a,p){var v=this.options.marker,C=v.fillOpacity,P=Series$f.prototype.pointAttribs.call(this,a,p);return C!==1&&(P.fill=color$9(P.fill).setOpacity(C).get("rgba")),P},d.prototype.translate=function(){var a,p=this.data,v,C,P=this.radii;for(g.prototype.translate.call(this),a=p.length;a--;)v=p[a],C=P?P[a]:0,isNumber$m(C)&&C>=this.minPxSize/2?(v.marker=extend$J(v.marker,{radius:C,width:2*C,height:2*C}),v.dlBox={x:v.plotX-C,y:v.plotY-C,width:2*C,height:2*C}):v.shapeArgs=v.plotY=v.dlBox=void 0},d.compose=BubbleLegendComposition$1.compose,d.defaultOptions=merge$F(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,p=this.point.z;return isNumber$m(p)?a(p,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),d})(ScatterSeries$3);extend$J(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$7,bubblePadding:!0,buildKDTree:noop$7,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var g=this,d=this.len,a=this.chart,p=0,v=d,C=this.isXAxis,P=C?"xData":"yData",k=this.min,z={},$=Math.min(a.plotWidth,a.plotHeight),D=Number.MAX_VALUE,F=-Number.MAX_VALUE,N=this.max-k,W=d/N,j=[];this.series.forEach(function(q){var X=q.options,K;q.bubblePadding&&(q.visible||!a.options.chart.ignoreHiddenSeries)&&(g.allowZoomOutside=!0,j.push(q),C&&(["minSize","maxSize"].forEach(function(ee){var te=X[ee],ie=/%$/.test(te);te=pInt$2(te),z[ee]=ie?$*te/100:te}),q.minPxSize=z.minSize,q.maxPxSize=Math.max(z.maxSize,z.minSize),K=q.zData.filter(isNumber$m),K.length&&(D=pick$L(X.zMin,clamp$a(arrayMin$2(K),X.displayNegative===!1?X.zThreshold:-Number.MAX_VALUE,D)),F=pick$L(X.zMax,Math.max(F,arrayMax$2(K))))))}),j.forEach(function(q){var X=q[P],K=X.length,ee;if(C&&q.getRadii(D,F,q),N>0)for(;K--;)isNumber$m(X[K])&&g.dataMin<=X[K]&&X[K]<=g.max&&(ee=q.radii?q.radii[K]:0,p=Math.min((X[K]-k)*W-ee,p),v=Math.max((X[K]-k)*W+ee,v))}),j.length&&N>0&&!this.logarithmic&&(v-=d,W*=(d+Math.max(0,p)-Math.min(v,d))/d,[["min","userMin",p],["max","userMax",v]].forEach(function(q){typeof pick$L(g.options[q[0]],g[q[1]])>"u"&&(g[q[0]]+=q[2]/W)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$1U=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$I=Utilities.extend,isNumber$l=Utilities.isNumber,ColumnRangePoint=(function(g){__extends$1U(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.series=void 0,a.options=void 0,a.barX=void 0,a.pointWidth=void 0,a.shapeType=void 0,a}return d.prototype.isValid=function(){return isNumber$l(this.low)},d})(AreaRangePoint);extend$I(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$1T=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$6=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$9=Utilities.clamp,merge$E=Utilities.merge,pick$K=Utilities.pick,extend$H=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=(function(g){__extends$1T(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return d.prototype.setOptions=function(){return merge$E(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},d.prototype.translate=function(){var a=this,p=a.yAxis,v=a.xAxis,C=v.startAngleRad,P,k=a.chart,z=a.xAxis.isRadial,$=Math.max(k.chartWidth,k.chartHeight)+999,D;function F(N){return clamp$9(N,-$,$)}columnProto$3.translate.apply(a),a.points.forEach(function(N){var W=N.shapeArgs||{},j=a.options.minPointLength,q,X,K;if(N.plotHigh=D=F(p.translate(N.high,0,1,0,1)),N.plotLow=F(N.plotY),K=D,X=pick$K(N.rectPlotY,N.plotY)-D,Math.abs(X)<j?(q=j-X,X+=q,K-=q/2):X<0&&(X*=-1,K-=X),z)P=N.barX+C,N.shapeType="arc",N.shapeArgs=a.polarArc(K+X,K,P,P+N.pointWidth);else{W.height=X,W.y=K;var ee=W.x,te=ee===void 0?0:ee,ie=W.width,oe=ie===void 0?0:ie;N.tooltipPos=k.inverted?[p.len+p.pos-k.plotLeft-K-X/2,v.len+v.pos-k.plotTop-te-oe/2,X]:[v.left-k.plotLeft+te+oe/2,p.pos-k.plotTop+K+X/2,X]}})},d.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},d.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},d.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},d.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},d.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},d.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},d.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},d.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},d.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},d.defaultOptions=merge$E(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),d})(AreaRangeSeries$1);extend$H(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$6,getSymbol:noop$6,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$1S=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),colProto=ColumnSeries$h.prototype,clamp$8=Utilities.clamp,merge$D=Utilities.merge,pick$J=Utilities.pick,ColumnPyramidSeries=(function(g){__extends$1S(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.translate=function(){var a=this,p=a.chart,v=a.options,C=a.dense=a.closestPointRange*a.xAxis.transA<2,P=a.borderWidth=pick$J(v.borderWidth,C?0:1),k=a.yAxis,z=v.threshold,$=a.translatedThreshold=k.getThreshold(z),D=pick$J(v.minPointLength,5),F=a.getColumnMetrics(),N=F.width,W=a.barW=Math.max(N,1+2*P),j=a.pointXOffset=F.offset;p.inverted&&($-=.5),v.pointPadding&&(W=Math.ceil(W)),colProto.translate.apply(a),a.points.forEach(function(q){var X=pick$J(q.yBottom,$),K=999+Math.abs(X),ee=clamp$8(q.plotY,-K,k.len+K),te=q.plotX+j,ie=W/2,oe=Math.min(ee,X),ae=Math.max(ee,X)-oe,le,ce,ue,ge,ye,we,ve,be,_e,Ce,Ee,Te;q.barX=te,q.pointWidth=N,q.tooltipPos=p.inverted?[k.len+k.pos-p.plotLeft-ee,a.xAxis.len-te-ie,ae]:[te+ie,ee+k.pos-p.plotTop,ae],le=z+(q.total||q.y),v.stacking==="percent"&&(le=z+(q.y<0)?-100:100),ue=k.toPixels(le,!0),ce=p.plotHeight-ue-(p.plotHeight-$),ge=ce?ie*(oe-ue)/ce:0,ye=ce?ie*(oe+ae-ue)/ce:0,ve=te-ge+ie,be=te+ge+ie,_e=te+ye+ie,Ce=te-ye+ie,Ee=oe-D,Te=oe+ae,q.y<0&&(Ee=oe,Te=oe+ae+D),p.inverted&&(we=p.plotWidth-oe,ce=ue-(p.plotWidth-$),ge=ie*(ue-we)/ce,ye=ie*(ue-(we-ae))/ce,ve=te+ie+ge,be=ve-2*ge,_e=te-ye+ie,Ce=te+ye+ie,Ee=oe,Te=oe+ae-D,q.y<0&&(Te=oe+ae+D)),q.shapeType="path",q.shapeArgs={x:ve,y:Ee,width:be-ve,height:ae,d:[["M",ve,Ee],["L",be,Ee],["L",_e,Te],["L",Ce,Te],["Z"]]}})},d.defaultOptions=merge$D(ColumnSeries$h.defaultOptions,{}),d})(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$1R=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$C=Utilities.merge,extend$G=Utilities.extend,ErrorBarSeries=(function(g){__extends$1R(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},d.prototype.drawDataLabels=function(){var a=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(p){p.y=p[a]}))},d.prototype.toYData=function(a){return[a.low,a.high]},d.defaultOptions=merge$C(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),d})(BoxPlotSeries);extend$G(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$1Q=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),Point$3=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=(function(g){__extends$1Q(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a.shapeArgs=void 0,a}return d.prototype.setState=function(a){this.state=a},d})(Point$3),__extends$1P=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$5=H.noop,Series$b=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$7=Utilities.clamp,isNumber$k=Utilities.isNumber,extend$F=Utilities.extend,merge$B=Utilities.merge,pick$I=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=(function(g){__extends$1P(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a.yAxis=void 0,a}return d.prototype.translate=function(){var a=this,p=a.yAxis,v=a.options,C=p.center;a.generatePoints(),a.points.forEach(function(P){var k=merge$B(v.dial,P.dial),z=pInt$1(pick$I(k.radius,"80%"))*C[2]/200,$=pInt$1(pick$I(k.baseLength,"70%"))*z/100,D=pInt$1(pick$I(k.rearLength,"10%"))*z/100,F=k.baseWidth||3,N=k.topWidth||1,W=v.overshoot,j=p.startAngleRad+p.translate(P.y,null,null,null,!0);(isNumber$k(W)||v.wrap===!1)&&(W=isNumber$k(W)?W/180*Math.PI:0,j=clamp$7(j,p.startAngleRad-W,p.endAngleRad+W)),j=j*180/Math.PI,P.shapeType="path";var q=k.path||[["M",-D,-F/2],["L",$,-F/2],["L",z,-N/2],["L",z,N/2],["L",$,F/2],["L",-D,F/2],["Z"]];P.shapeArgs={d:q,translateX:C[0],translateY:C[1],rotation:j},P.plotX=C[0],P.plotY=C[1]})},d.prototype.drawPoints=function(){var a=this,p=a.chart,v=a.yAxis.center,C=a.pivot,P=a.options,k=P.pivot,z=p.renderer;a.points.forEach(function($){var D=$.graphic,F=$.shapeArgs,N=F.d,W=merge$B(P.dial,$.dial);D?(D.animate(F),F.d=N):$.graphic=z[$.shapeType](F).attr({rotation:F.rotation,zIndex:1}).addClass("highcharts-dial").add(a.group),p.styledMode||$.graphic[D?"animate":"attr"]({stroke:W.borderColor||"none","stroke-width":W.borderWidth||0,fill:W.backgroundColor||palette.neutralColor100})}),C?C.animate({translateX:v[0],translateY:v[1]}):(a.pivot=z.circle(0,0,pick$I(k.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(v[0],v[1]).add(a.group),p.styledMode||a.pivot.attr({"stroke-width":k.borderWidth||0,stroke:k.borderColor||palette.neutralColor20,fill:k.backgroundColor||palette.neutralColor100}))},d.prototype.animate=function(a){var p=this;a||p.points.forEach(function(v){var C=v.graphic;C&&(C.attr({rotation:p.yAxis.startAngleRad*180/Math.PI}),C.animate({rotation:v.shapeArgs.rotation},p.options.animation))})},d.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$b.prototype.render.call(this),this.group.clip(this.chart.clipRect)},d.prototype.setData=function(a,p){Series$b.prototype.setData.call(this,a,!1),this.processData(),this.generatePoints(),pick$I(p,!0)&&this.chart.redraw()},d.prototype.hasData=function(){return!!this.points.length},d.defaultOptions=merge$B(Series$b.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),d})(Series$b);extend$F(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$5,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$1O=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=(function(g){__extends$1O(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.degree=NaN,a.mass=NaN,a.radius=NaN,a.options=void 0,a.series=void 0,a.value=null,a}return d.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$4.prototype.destroy.apply(this,arguments)},d.prototype.firePointEvent=function(){var a=this.series,p=a.options;if(this.isParentNode&&p.parentNode){var v=p.allowPointSelect;p.allowPointSelect=p.parentNode.allowPointSelect,Point$4.prototype.firePointEvent.apply(this,arguments),p.allowPointSelect=v}else Point$4.prototype.firePointEvent.apply(this,arguments)},d.prototype.select=function(){var a=this,p=this.series,v=p.chart;a.isParentNode?(v.getSelectedPoints=v.getSelectedParentNodes,Point$4.prototype.select.apply(this,arguments),v.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$4.prototype.select.apply(this,arguments)},d})(BubbleSeries$1.prototype.pointClass),addEvent$u=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(g,d){var a=this.chart.pointer.normalize(d);g.fixedPosition={chartX:a.chartX,chartY:a.chartY,plotX:g.plotX,plotY:g.plotY},g.inDragMode=!0},onMouseMove:function(g,d){if(g.fixedPosition&&g.inDragMode){var a=this,p=a.chart,v=p.pointer.normalize(d),C=g.fixedPosition.chartX-v.chartX,P=g.fixedPosition.chartY-v.chartY,k=void 0,z=void 0,$=p.graphLayoutsLookup;(Math.abs(C)>5||Math.abs(P)>5)&&(k=g.fixedPosition.plotX-C,z=g.fixedPosition.plotY-P,p.isInsidePlot(k,z)&&(g.plotX=k,g.plotY=z,g.hasDragged=!0,this.redrawHalo(g),$.forEach(function(D){D.restartSimulation()})))}},onMouseUp:function(g,d){g.fixedPosition&&(g.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),g.inDragMode=g.hasDragged=!1,this.options.fixedDraggable||delete g.fixedPosition)},redrawHalo:function(g){g&&this.halo&&this.halo.attr({d:g.haloPath(this.options.states.hover.halo.size)})}};addEvent$u(Chart$1,"load",function(){var g=this,d,a,p;g.container&&(d=addEvent$u(g.container,"mousedown",function(v){var C=g.hoverPoint;C&&C.series&&C.series.hasDraggableNodes&&C.series.options.draggable&&(C.series.onMouseDown(C,v),a=addEvent$u(g.container,"mousemove",function(P){return C&&C.series&&C.series.onMouseMove(C,P)}),p=addEvent$u(g.container.ownerDocument,"mouseup",function(P){return a(),p(),C&&C.series&&C.series.onMouseUp(C,P)}))})),addEvent$u(g,"destroy",function(){d()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(g,d){return(d-g)/g},repulsiveForceFunction:function(g,d){return(d-g)/g*(d>g?1:0)},barycenter:function(){var g=this.options.gravitationalConstant,d=this.barycenter.xFactor,a=this.barycenter.yFactor;d=(d-(this.box.left+this.box.width)/2)*g,a=(a-(this.box.top+this.box.height)/2)*g,this.nodes.forEach(function(p){p.fixedPosition||(p.plotX-=d/p.mass/p.degree,p.plotY-=a/p.mass/p.degree)})},repulsive:function(g,d,a){var p=d*this.diffTemperature/g.mass/g.degree;g.fixedPosition||(g.plotX+=a.x*p,g.plotY+=a.y*p)},attractive:function(g,d,a){var p=g.getMass(),v=-a.x*d*this.diffTemperature,C=-a.y*d*this.diffTemperature;g.fromNode.fixedPosition||(g.fromNode.plotX-=v*p.fromNode/g.fromNode.degree,g.fromNode.plotY-=C*p.fromNode/g.fromNode.degree),g.toNode.fixedPosition||(g.toNode.plotX+=v*p.toNode/g.toNode.degree,g.toNode.plotY+=C*p.toNode/g.toNode.degree)},integrate:function(g,d){var a=-g.options.friction,p=g.options.maxSpeed,v=d.prevX,C=d.prevY,P=(d.plotX+d.dispX-v)*a,k=(d.plotY+d.dispY-C)*a,z=Math.abs,$=z(P)/(P||1),D=z(k)/(k||1);P=$*Math.min(p,Math.abs(P)),k=D*Math.min(p,Math.abs(k)),d.prevX=d.plotX+d.dispX,d.prevY=d.plotY+d.dispY,d.plotX+=P,d.plotY+=k,d.temperature=g.vectorLength({x:P,y:k})},getK:function(g){return Math.pow(g.box.width*g.box.height/g.nodes.length,.5)}},euler:{attractiveForceFunction:function(g,d){return g*g/d},repulsiveForceFunction:function(g,d){return d*d/g},barycenter:function(){var g=this.options.gravitationalConstant,d=this.barycenter.xFactor,a=this.barycenter.yFactor;this.nodes.forEach(function(p){if(!p.fixedPosition){var v=p.getDegree(),C=v*(1+v/2);p.dispX+=(d-p.plotX)*g*C/p.degree,p.dispY+=(a-p.plotY)*g*C/p.degree}})},repulsive:function(g,d,a,p){g.dispX+=a.x/p*d/g.degree,g.dispY+=a.y/p*d/g.degree},attractive:function(g,d,a,p){var v=g.getMass(),C=a.x/p*d,P=a.y/p*d;g.fromNode.fixedPosition||(g.fromNode.dispX-=C*v.fromNode/g.fromNode.degree,g.fromNode.dispY-=P*v.fromNode/g.fromNode.degree),g.toNode.fixedPosition||(g.toNode.dispX+=C*v.toNode/g.toNode.degree,g.toNode.dispY+=P*v.toNode/g.toNode.degree)},integrate:function(g,d){var a;d.dispX+=d.dispX*g.options.friction,d.dispY+=d.dispY*g.options.friction,a=d.temperature=g.vectorLength({x:d.dispX,y:d.dispY}),a!==0&&(d.plotX+=d.dispX/a*Math.min(Math.abs(d.dispX),g.temperature),d.plotY+=d.dispY/a*Math.min(Math.abs(d.dispY),g.temperature))},getK:function(g){return Math.pow(g.box.width*g.box.height/g.nodes.length,.3)}}};var extend$E=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(g){this.box=g,this.boxSize=Math.min(g.width,g.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$E(QuadTreeNode.prototype,{insert:function(g,d){var a;this.isInternal?this.nodes[this.getBoxPosition(g)].insert(g,d-1):(this.isEmpty=!1,this.body?d?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,d-1),this.body=!0),this.nodes[this.getBoxPosition(g)].insert(g,d-1)):(a=new QuadTreeNode({top:g.plotX,left:g.plotY,width:.1,height:.1}),a.body=g,a.isInternal=!1,this.nodes.push(a)):(this.isInternal=!1,this.body=g))},updateMassAndCenter:function(){var g=0,d=0,a=0;this.isInternal?(this.nodes.forEach(function(p){p.isEmpty||(g+=p.mass,d+=p.plotX*p.mass,a+=p.plotY*p.mass)}),d/=g,a/=g):this.body&&(g=this.body.mass,d=this.body.plotX,a=this.body.plotY),this.mass=g,this.plotX=d,this.plotY=a},divideBox:function(){var g=this.box.width/2,d=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:g,height:d}),this.nodes[1]=new QuadTreeNode({left:this.box.left+g,top:this.box.top,width:g,height:d}),this.nodes[2]=new QuadTreeNode({left:this.box.left+g,top:this.box.top+d,width:g,height:d}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+d,width:g,height:d})},getBoxPosition:function(g){var d=g.plotX<this.box.left+this.box.width/2,a=g.plotY<this.box.top+this.box.height/2,p;return d?a?p=0:p=3:a?p=1:p=2,p}});var QuadTree=H.QuadTree=function(g,d,a,p){this.box={left:g,top:d,width:a,height:p},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$E(QuadTree.prototype,{insertNodes:function(g){g.forEach(function(d){this.root.insert(d,this.maxDepth)},this)},visitNodeRecursive:function(g,d,a){var p;g||(g=this.root),g===this.root&&d&&(p=d(g)),p!==!1&&(g.nodes.forEach(function(v){if(v.isInternal){if(d&&(p=d(v)),p===!1)return;this.visitNodeRecursive(v,d,a)}else v.body&&d&&d(v.body);a&&a(v)},this),g===this.root&&a&&a(g))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(g){g.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$t=Utilities.addEvent,clamp$6=Utilities.clamp,defined$i=Utilities.defined,extend$D=Utilities.extend,isFunction=Utilities.isFunction,pick$H=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$D(H.layouts["reingold-fruchterman"].prototype,{init:function(g){this.options=g,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[g.integration],this.enableSimulation=g.enableSimulation,this.attractiveForce=pick$H(g.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$H(g.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=g.approximation},updateSimulation:function(g){this.enableSimulation=pick$H(g,this.options.enableSimulation)},start:function(){var g=this,d=this.series,a=this.options;g.currentStep=0,g.forces=d[0]&&d[0].forces||[],g.chart=d[0]&&d[0].chart,g.initialRendering&&(g.initPositions(),d.forEach(function(p){p.finishedAnimating=!0,p.render()})),g.setK(),g.resetSimulation(a),g.enableSimulation&&g.step()},step:function(){var g=this,d=this.series;this.options,g.currentStep++,g.approximation==="barnes-hut"&&(g.createQuadTree(),g.quadTree.calculateMassAndCenter()),g.forces.forEach(function(a){g[a+"Forces"](g.temperature)}),g.applyLimits(g.temperature),g.temperature=g.coolDown(g.startTemperature,g.diffTemperature,g.currentStep),g.prevSystemTemperature=g.systemTemperature,g.systemTemperature=g.getSystemTemperature(),g.enableSimulation&&(d.forEach(function(a){a.chart&&a.render()}),g.maxIterations--&&isFinite(g.temperature)&&!g.isStable()?(g.simulation&&H.win.cancelAnimationFrame(g.simulation),g.simulation=H.win.requestAnimationFrame(function(){g.step()})):g.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(g,d,a,p){this.box={left:g,top:d,width:a,height:p}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(g,d){g.forEach(function(a){d.indexOf(a)===-1&&d.push(a)})},removeElementFromCollection:function(g,d){var a=d.indexOf(g);a!==-1&&d.splice(a,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(g){this.maxIterations=pick$H(g,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(g){this.initialRendering=g},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var g=this.options.initialPositions;isFunction(g)?(g.call(this),this.nodes.forEach(function(d){defined$i(d.prevX)||(d.prevX=d.plotX),defined$i(d.prevY)||(d.prevY=d.plotY),d.dispX=0,d.dispY=0})):g==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var g=this.box,d=this.nodes,a=d.length+1,p=2*Math.PI/a,v=d.filter(function($){return $.linksTo.length===0}),C=[],P={},k=this.options.initialPositionRadius;function z($){$.linksFrom.forEach(function(D){P[D.toNode.id]||(P[D.toNode.id]=!0,C.push(D.toNode),z(D.toNode))})}v.forEach(function($){C.push($),z($)}),C.length?d.forEach(function($){C.indexOf($)===-1&&C.push($)}):C=d,C.forEach(function($,D){$.plotX=$.prevX=pick$H($.plotX,g.width/2+k*Math.cos(D*p)),$.plotY=$.prevY=pick$H($.plotY,g.height/2+k*Math.sin(D*p)),$.dispX=0,$.dispY=0})},setRandomPositions:function(){var g=this.box,d=this.nodes,a=d.length+1;function p(v){var C=v*v/Math.PI;return C=C-Math.floor(C),C}d.forEach(function(v,C){v.plotX=v.prevX=pick$H(v.plotX,g.width*p(C)),v.plotY=v.prevY=pick$H(v.plotY,g.height*p(a+C)),v.dispX=0,v.dispY=0})},force:function(g){this.integration[g].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var g=0,d=0,a=0;return this.nodes.forEach(function(p){d+=p.plotX*p.mass,a+=p.plotY*p.mass,g+=p.mass}),this.barycenter={x:d,y:a,xFactor:d/g,yFactor:a/g},this.barycenter},barnesHutApproximation:function(g,d){var a=this,p=a.getDistXY(g,d),v=a.vectorLength(p),C,P;return g!==d&&v!==0&&(d.isInternal?d.boxSize/v<a.options.theta&&v!==0?(P=a.repulsiveForce(v,a.k),a.force("repulsive",g,P*d.mass,p,v),C=!1):C=!0:(P=a.repulsiveForce(v,a.k),a.force("repulsive",g,P*d.mass,p,v))),C},repulsiveForces:function(){var g=this;g.approximation==="barnes-hut"?g.nodes.forEach(function(d){g.quadTree.visitNodeRecursive(null,function(a){return g.barnesHutApproximation(d,a)})}):g.nodes.forEach(function(d){g.nodes.forEach(function(a){var p,v,C;d!==a&&!d.fixedPosition&&(C=g.getDistXY(d,a),v=g.vectorLength(C),v!==0&&(p=g.repulsiveForce(v,g.k),g.force("repulsive",d,p*a.mass,C,v)))})})},attractiveForces:function(){var g=this,d,a,p;g.links.forEach(function(v){v.fromNode&&v.toNode&&(d=g.getDistXY(v.fromNode,v.toNode),a=g.vectorLength(d),a!==0&&(p=g.attractiveForce(a,g.k),g.force("attractive",v,p,d,a)))})},applyLimits:function(){var g=this,d=g.nodes;d.forEach(function(a){a.fixedPosition||(g.integration.integrate(g,a),g.applyLimitBox(a,g.box),a.dispX=0,a.dispY=0)})},applyLimitBox:function(g,d){var a=g.radius;g.plotX=clamp$6(g.plotX,d.left+a,d.width-a),g.plotY=clamp$6(g.plotY,d.top+a,d.height-a)},coolDown:function(g,d,a){return g-d*a},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(g,d){return g+d.temperature},0)},vectorLength:function(g){return Math.sqrt(g.x*g.x+g.y*g.y)},getDistR:function(g,d){var a=this.getDistXY(g,d);return this.vectorLength(a)},getDistXY:function(g,d){var a=g.plotX-d.plotX,p=g.plotY-d.plotY;return{x:a,y:p,absX:Math.abs(a),absY:Math.abs(p)}}});addEvent$t(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(g){g.stop()})});addEvent$t(Chart$1,"render",function(){var g,d=!1;function a(p){p.maxIterations--&&isFinite(p.temperature)&&!p.isStable()&&!p.enableSimulation&&(p.beforeStep&&p.beforeStep(),p.step(),g=!1,d=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(p){p.start()});!g;)g=!0,this.graphLayoutsLookup.forEach(a);d&&this.series.forEach(function(p){p&&p.layout&&p.render()})}});addEvent$t(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(g){g.updateSimulation(!1)}),this.redraw())});addEvent$t(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(g){g.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$s=Utilities.addEvent,extendClass=Utilities.extendClass,pick$G=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var g=this,d=g.series,a=[];return d.forEach(function(p){p.parentNode&&p.parentNode.selected&&a.push(p.parentNode)}),a};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(g,d,a,p){return Math.min(g,(a.marker.radius+p.marker.radius)/2)},barycenter:function(){var g=this,d=g.options.gravitationalConstant,a=g.box,p=g.nodes,v,C;p.forEach(function(P){g.options.splitSeries&&!P.isParentNode?(v=P.series.parentNode.plotX,C=P.series.parentNode.plotY):(v=a.width/2,C=a.height/2),P.fixedPosition||(P.plotX-=(P.plotX-v)*d/(P.mass*Math.sqrt(p.length)),P.plotY-=(P.plotY-C)*d/(P.mass*Math.sqrt(p.length)))})},repulsive:function(g,d,a,p){var v=d*this.diffTemperature/g.mass/g.degree,C=a.x*v,P=a.y*v;g.fixedPosition||(g.plotX+=C,g.plotY+=P),p.fixedPosition||(p.plotX-=C,p.plotY-=P)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(g){g&&g.calculateParentRadius()})},isStable:function(){var g=Math.abs(this.prevSystemTemperature-this.systemTemperature),d=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(d)<1&&g<1e-5||this.temperature<=0},setCircularPositions:function(){var g=this,d=g.box,a=g.nodes,p=a.length+1,v=2*Math.PI/p,C,P,k=g.options.initialPositionRadius;a.forEach(function(z,$){g.options.splitSeries&&!z.isParentNode?(C=z.series.parentNode.plotX,P=z.series.parentNode.plotY):(C=d.width/2,P=d.height/2),z.plotX=z.prevX=pick$G(z.plotX,C+k*Math.cos(z.index||$*v)),z.plotY=z.prevY=pick$G(z.plotY,P+k*Math.sin(z.index||$*v)),z.dispX=0,z.dispY=0})},repulsiveForces:function(){var g=this,d,a,p,v=g.options.bubblePadding;g.nodes.forEach(function(C){C.degree=C.mass,C.neighbours=0,g.nodes.forEach(function(P){d=0,C!==P&&!C.fixedPosition&&(g.options.seriesInteraction||C.series===P.series)&&(p=g.getDistXY(C,P),a=g.vectorLength(p)-(C.marker.radius+P.marker.radius+v),a<0&&(C.degree+=.01,C.neighbours++,d=g.repulsiveForce(-a/Math.sqrt(C.neighbours),g.k,C,P)),g.force("repulsive",C,d*P.mass,p,P,a))})})},applyLimitBox:function(g){var d=this,a,p,v=.01;d.options.splitSeries&&!g.isParentNode&&d.options.parentNodeLimit&&(a=d.getDistXY(g,g.series.parentNode),p=g.series.parentNodeRadius-g.marker.radius-d.vectorLength(a),p<0&&p>-2*g.marker.radius&&(g.plotX-=a.x*v,g.plotY-=a.y*v)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$s(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$1N=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),color$8=Color.parse,Series$a=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$r=Utilities.addEvent,clamp$5=Utilities.clamp,defined$h=Utilities.defined,extend$C=Utilities.extend,fireEvent$7=Utilities.fireEvent,isArray$7=Utilities.isArray,isNumber$j=Utilities.isNumber,merge$A=Utilities.merge,pick$F=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=(function(g){__extends$1N(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.chart=void 0,a.data=void 0,a.layout=void 0,a.options=void 0,a.points=void 0,a.xData=void 0,a}return d.prototype.accumulateAllPoints=function(a){var p=a.chart,v=[],C,P;for(C=0;C<p.series.length;C++)if(a=p.series[C],a.is("packedbubble")&&a.visible||!p.options.chart.ignoreHiddenSeries)for(P=0;P<a.yData.length;P++)v.push([null,null,a.yData[P],a.index,P,{id:P,marker:{radius:0}}]);return v},d.prototype.addLayout=function(){var a=this,p=a.options.layoutAlgorithm,v=a.chart.graphLayoutsStorage,C=a.chart.graphLayoutsLookup,P=a.chart.options.chart,k;v||(a.chart.graphLayoutsStorage=v={},a.chart.graphLayoutsLookup=C=[]),k=v[p.type],k||(p.enableSimulation=defined$h(P.forExport)?!P.forExport:p.enableSimulation,v[p.type]=k=new H.layouts[p.type],k.init(p),C.splice(k.index,0,k)),a.layout=k,a.points.forEach(function(z){z.mass=2,z.degree=1,z.collisionNmb=1}),k.setArea(0,0,a.chart.plotWidth,a.chart.plotHeight),k.addElementsToCollection([a],k.series),k.addElementsToCollection(a.points,k.nodes)},d.prototype.addSeriesLayout=function(){var a=this,p=a.options.layoutAlgorithm,v=a.chart.graphLayoutsStorage,C=a.chart.graphLayoutsLookup,P=merge$A(p,p.parentNodeOptions,{enableSimulation:a.layout.options.enableSimulation}),k;k=v[p.type+"-series"],k||(v[p.type+"-series"]=k=new H.layouts[p.type],k.init(P),C.splice(k.index,0,k)),a.parentNodeLayout=k,this.createParentNodes()},d.prototype.calculateParentRadius=function(){var a=this,p,v=20,C=20;p=a.seriesBox(),a.parentNodeRadius=clamp$5(Math.sqrt(2*a.parentNodeMass/Math.PI)+v,C,p?Math.max(Math.sqrt(Math.pow(p.width,2)+Math.pow(p.height,2))/2+v,C):Math.sqrt(2*a.parentNodeMass/Math.PI)+v),a.parentNode&&(a.parentNode.marker.radius=a.parentNode.radius=a.parentNodeRadius)},d.prototype.calculateZExtremes=function(){var a=this.chart,p=this.options.zMin,v=this.options.zMax,C=1/0,P=-1/0;return p&&v?[p,v]:(a.series.forEach(function(k){k.yData.forEach(function(z){defined$h(z)&&(z>P&&(P=z),z<C&&(C=z))})}),p=pick$F(p,C),v=pick$F(v,P),[p,v])},d.prototype.checkOverlap=function(a,p){var v=a[0]-p[0],C=a[1]-p[1],P=a[2]+p[2];return Math.sqrt(v*v+C*C)-Math.abs(P)<-.001},d.prototype.createParentNodes=function(){var a=this,p=a.chart,v=a.parentNodeLayout,C,P=a.parentNode,k=a.pointClass;a.parentNodeMass=0,a.points.forEach(function(z){a.parentNodeMass+=Math.PI*Math.pow(z.marker.radius,2)}),a.calculateParentRadius(),v.nodes.forEach(function(z){z.seriesIndex===a.index&&(C=!0)}),v.setArea(0,0,p.plotWidth,p.plotHeight),C||(P||(P=new k().init(this,{mass:a.parentNodeRadius/2,marker:{radius:a.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:a.parentNodeRadius,isParentNode:!0,seriesIndex:a.index})),a.parentNode&&(P.plotX=a.parentNode.plotX,P.plotY=a.parentNode.plotY),a.parentNode=P,v.addElementsToCollection([a],v.series),v.addElementsToCollection([P],v.nodes))},d.prototype.deferLayout=function(){var a=this,p=a.options.layoutAlgorithm;a.visible&&(a.addLayout(),p.splitSeries&&a.addSeriesLayout())},d.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(a){a.removeElementFromCollection(this,a.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$a.prototype.destroy.apply(this,arguments)},d.prototype.drawDataLabels=function(){var a=this.options.dataLabels.textPath,p=this.points;Series$a.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$a.prototype.drawDataLabels.apply(this,arguments),this.points=p,this.options.dataLabels.textPath=a)},d.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var a=this,p=a.chart,v={},C=this.layout.options.parentNodeOptions.marker,P={fill:C.fillColor||color$8(a.color).brighten(.4).get(),opacity:C.fillOpacity,stroke:C.lineColor||a.color,"stroke-width":C.lineWidth};this.parentNodesGroup||(a.parentNodesGroup=a.plotGroup("parentNodesGroup","parentNode",a.visible?"inherit":"hidden",.1,p.seriesGroup),a.group.attr({zIndex:2})),this.calculateParentRadius(),v=merge$A({x:a.parentNode.plotX-a.parentNodeRadius,y:a.parentNode.plotY-a.parentNodeRadius,width:a.parentNodeRadius*2,height:a.parentNodeRadius*2},P),a.parentNode.graphic||(a.graph=a.parentNode.graphic=p.renderer.symbol(P.symbol).add(a.parentNodesGroup)),a.parentNode.graphic.attr(v)}},d.prototype.drawTracker=function(){var a=this,p=a.parentNode,v;g.prototype.drawTracker.call(this),p&&(v=isArray$7(p.dataLabels)?p.dataLabels:p.dataLabel?[p.dataLabel]:[],p.graphic&&(p.graphic.element.point=p),v.forEach(function(C){C.div?C.div.point=p:C.element.point=p}))},d.prototype.getPointRadius=function(){var a=this,p=a.chart,v=p.plotWidth,C=p.plotHeight,P=a.options,k=P.useSimulation,z=Math.min(v,C),$={},D=[],F=p.allDataPoints,N,W,j,q,X;["minSize","maxSize"].forEach(function(K){var ee=parseInt(P[K],10),te=/%$/.test(P[K]);$[K]=te?z*ee/100:ee*Math.sqrt(F.length)}),p.minRadius=N=$.minSize/Math.sqrt(F.length),p.maxRadius=W=$.maxSize/Math.sqrt(F.length),X=k?a.calculateZExtremes():[N,W],(F||[]).forEach(function(K,ee){j=k?clamp$5(K[2],X[0],X[1]):K[2],q=a.getRadius(X[0],X[1],N,W,j),q===0&&(q=null),F[ee][2]=q,D.push(q)}),a.radii=D},d.prototype.init=function(){return Series$a.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$r(this,"updatedData",function(){this.chart.series.forEach(function(a){a.type===this.type&&(a.isDirty=!0)},this)})),this},d.prototype.onMouseUp=function(a){if(a.fixedPosition&&!a.removed){var p,v,C=this.layout,P=this.parentNodeLayout;P&&C.options.dragBetweenSeries&&P.nodes.forEach(function(k){a&&a.marker&&k!==a.series.parentNode&&(p=C.getDistXY(a,k),v=C.vectorLength(p)-k.marker.radius-a.marker.radius,v<0&&(k.series.addPoint(merge$A(a.options,{plotX:a.plotX,plotY:a.plotY}),!1),C.removeElementFromCollection(a,C.nodes),a.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},d.prototype.placeBubbles=function(a){var p=this,v=p.checkOverlap,C=p.positionBubble,P=[],k=1,z=0,$=0,D,F,N=[],W;if(F=a.sort(function(j,q){return q[2]-j[2]}),F.length){if(P.push([[0,0,F[0][2],F[0][3],F[0][4]]]),F.length>1)for(P.push([[0,0-F[1][2]-F[0][2],F[1][2],F[1][3],F[1][4]]]),W=2;W<F.length;W++)F[W][2]=F[W][2]||1,D=C(P[k][z],P[k-1][$],F[W]),v(D,P[k][0])?(P.push([]),$=0,P[k+1].push(C(P[k][z],P[k][0],F[W])),k++,z=0):k>1&&P[k-1][$+1]&&v(D,P[k-1][$+1])?($++,P[k].push(C(P[k][z],P[k-1][$],F[W])),z++):(z++,P[k].push(D));p.chart.stages=P,p.chart.rawPositions=[].concat.apply([],P),p.resizeRadius(),N=p.chart.rawPositions}return N},d.prototype.positionBubble=function(a,p,v){var C=Math.sqrt,P=Math.asin,k=Math.acos,z=Math.pow,$=Math.abs,D=C(z(a[0]-p[0],2)+z(a[1]-p[1],2)),F=k((z(D,2)+z(v[2]+p[2],2)-z(v[2]+a[2],2))/(2*(v[2]+p[2])*D)),N=P($(a[0]-p[0])/D),W=a[1]-p[1]<0?0:Math.PI,j=(a[0]-p[0])*(a[1]-p[1])<0?1:-1,q=W+F+N*j,X=Math.cos(q),K=Math.sin(q),ee=p[0]+(p[2]+v[2])*K,te=p[1]-(p[2]+v[2])*X;return[ee,te,v[2],v[3],v[4]]},d.prototype.render=function(){var a=this,p=[];Series$a.prototype.render.apply(this,arguments),a.options.dataLabels.allowOverlap||(a.data.forEach(function(v){isArray$7(v.dataLabels)&&v.dataLabels.forEach(function(C){p.push(C)})}),a.options.useSimulation&&a.chart.hideOverlappingLabels(p))},d.prototype.resizeRadius=function(){var a=this.chart,p=a.rawPositions,v=Math.min,C=Math.max,P=a.plotLeft,k=a.plotTop,z=a.plotHeight,$=a.plotWidth,D,F,N,W,j,q,X,K,ee;for(D=N=Number.POSITIVE_INFINITY,F=W=Number.NEGATIVE_INFINITY,ee=0;ee<p.length;ee++)j=p[ee][2],D=v(D,p[ee][0]-j),F=C(F,p[ee][0]+j),N=v(N,p[ee][1]-j),W=C(W,p[ee][1]+j);if(q=[F-D,W-N],X=[($-P)/q[0],(z-k)/q[1]],K=v.apply([],X),Math.abs(K-1)>1e-10){for(ee=0;ee<p.length;ee++)p[ee][2]*=K;this.placeBubbles(p)}else a.diffY=z/2+k-N-(W-N)/2,a.diffX=$/2+P-D-(F-D)/2},d.prototype.seriesBox=function(){var a=this,p=a.chart,v=a.data,C=Math.max,P=Math.min,k,z=[p.plotLeft,p.plotLeft+p.plotWidth,p.plotTop,p.plotTop+p.plotHeight];return v.forEach(function($){defined$h($.plotX)&&defined$h($.plotY)&&$.marker.radius&&(k=$.marker.radius,z[0]=P(z[0],$.plotX-k),z[1]=C(z[1],$.plotX+k),z[2]=P(z[2],$.plotY-k),z[3]=C(z[3],$.plotY+k))}),isNumber$j(z.width/z.height)?z:null},d.prototype.setVisible=function(){var a=this;Series$a.prototype.setVisible.apply(a,arguments),a.parentNodeLayout&&a.graph?a.visible?(a.graph.show(),a.parentNode.dataLabel&&a.parentNode.dataLabel.show()):(a.graph.hide(),a.parentNodeLayout.removeElementFromCollection(a.parentNode,a.parentNodeLayout.nodes),a.parentNode.dataLabel&&a.parentNode.dataLabel.hide()):a.layout&&(a.visible?a.layout.addElementsToCollection(a.points,a.layout.nodes):a.points.forEach(function(p){a.layout.removeElementFromCollection(p,a.layout.nodes)}))},d.prototype.translate=function(){var a=this,p=a.chart,v=a.data,C=a.index,P,k,z,$,D=a.options.useSimulation;for(a.processedXData=a.xData,a.generatePoints(),defined$h(p.allDataPoints)||(p.allDataPoints=a.accumulateAllPoints(a),a.getPointRadius()),D?z=p.allDataPoints:(z=a.placeBubbles(p.allDataPoints),a.options.draggable=!1),$=0;$<z.length;$++)z[$][3]===C&&(P=v[z[$][4]],k=pick$F(z[$][2],void 0),D||(P.plotX=z[$][0]-p.plotLeft+p.diffX,P.plotY=z[$][1]-p.plotTop+p.diffY),isNumber$j(k)&&(P.marker=extend$C(P.marker,{radius:k,width:2*k,height:2*k}),P.radius=k));D&&a.deferLayout(),fireEvent$7(a,"afterTranslate")},d.defaultOptions=merge$A(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,p=this.point.value;return isNumber$j(p)?a(p,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),d})(BubbleSeries);extend$C(PackedBubbleSeries.prototype,{alignDataLabel:Series$a.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$1M=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),noop$4=H.noop,Series$9=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$B=Utilities.extend,merge$z=Utilities.merge,PolygonSeries=(function(g){__extends$1M(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return d.prototype.getGraphPath=function(){for(var a=LineSeries$2.prototype.getGraphPath.call(this),p=a.length+1;p--;)(p===a.length||a[p][0]==="M")&&p>0&&a.splice(p,0,["Z"]);return this.areaPath=a,a},d.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},d.defaultOptions=merge$z(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),d})(ScatterSeries$2);extend$B(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$9.prototype.drawTracker,setStackedPoints:noop$4});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$q=Utilities.addEvent,objectEach$a=Utilities.objectEach,WaterfallAxis;(function(g){var d=(function(){function k(z){this.axis=z,this.stacks={changed:!1}}return k.prototype.renderStackTotals=function(){var z=this.axis,$=z.waterfall.stacks,D=z.stacking&&z.stacking.stackTotalGroup,F=new StackItem$1(z,z.options.stackLabels,!1,0,void 0);this.dummyStackItem=F,objectEach$a($,function(N){objectEach$a(N,function(W){F.total=W.stackTotal,W.label&&(F.label=W.label),StackItem$1.prototype.render.call(F,D),W.label=F.label,delete F.label})}),F.total=null},k})();g.Composition=d;function a(k,z){addEvent$q(k,"init",P),addEvent$q(k,"afterBuildStacks",p),addEvent$q(k,"afterRender",v),addEvent$q(z,"beforeRedraw",C)}g.compose=a;function p(){var k=this,z=k.waterfall.stacks;z&&(z.changed=!1,delete z.alreadyChanged)}function v(){var k=this,z=k.options.stackLabels;z&&z.enabled&&k.waterfall.stacks&&k.waterfall.renderStackTotals()}function C(){for(var k=this.axes,z=this.series,$=z.length;$--;)z[$].options.stacking&&(k.forEach(function(D){D.isXAxis||(D.waterfall.stacks.changed=!0)}),$=0)}function P(){var k=this;k.waterfall||(k.waterfall=new d(k))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$1L=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),isNumber$i=Utilities.isNumber,WaterfallPoint=(function(g){__extends$1L(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return d.prototype.getClassName=function(){var a=Point$4.prototype.getClassName.call(this);return this.isSum?a+=" highcharts-sum":this.isIntermediateSum&&(a+=" highcharts-intermediate-sum"),a},d.prototype.isValid=function(){return isNumber$i(this.y)||this.isSum||!!this.isIntermediateSum},d})(ColumnSeries$h.prototype.pointClass),__extends$1K=(function(){var g=function(d,a){return g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(p,v){p.__proto__=v}||function(p,v){for(var C in v)v.hasOwnProperty(C)&&(p[C]=v[C])},g(d,a)};return function(d,a){g(d,a);function p(){this.constructor=d}d.prototype=a===null?Object.create(a):(p.prototype=a.prototype,new p)}})(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$A=Utilities.extend,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,objectEach$9=Utilities.objectEach,pick$E=Utilities.pick;function ownProp(g,d){return Object.hasOwnProperty.call(g,d)}var WaterfallSeries=(function(g){__extends$1K(d,g);function d(){var a=g!==null&&g.apply(this,arguments)||this;return a.chart=void 0,a.data=void 0,a.options=void 0,a.points=void 0,a.stackedYNeg=void 0,a.stackedYPos=void 0,a.stackKey=void 0,a.xData=void 0,a.yAxis=void 0,a.yData=void 0,a}return d.prototype.generatePoints=function(){var a,p,v,C;for(ColumnSeries$8.prototype.generatePoints.apply(this),v=0,p=this.points.length;v<p;v++)a=this.points[v],C=this.processedYData[v],(a.isIntermediateSum||a.isSum)&&(a.y=correctFloat$2(C))},d.prototype.translate=function(){var a=this,p=a.options,v=a.yAxis,C,P=pick$E(p.minPointLength,5),k=P/2,z=p.threshold||0,$=z,D=z,F=p.stacking,N=v.waterfall.stacks[a.stackKey],W,j,q;ColumnSeries$8.prototype.translate.apply(a);for(var X=a.points,K=0;K<X.length;K++){var ee=X[K],te=a.processedYData[K],ie=ee.shapeArgs;if(!(!ie||!isNumber$h(te))){var oe=[0,te],ae=ee.y;if(F){if(N){var le=N[K];F==="overlap"?(W=le.stackState[le.stateIndex--],C=ae>=0?W:W-ae,ownProp(le,"absolutePos")&&delete le.absolutePos,ownProp(le,"absoluteNeg")&&delete le.absoluteNeg):(ae>=0?(W=le.threshold+le.posTotal,le.posTotal-=ae,C=W):(W=le.threshold+le.negTotal,le.negTotal-=ae,C=W-ae),le.posTotal||ownProp(le,"absolutePos")&&(le.posTotal=le.absolutePos,delete le.absolutePos),le.negTotal||ownProp(le,"absoluteNeg")&&(le.negTotal=le.absoluteNeg,delete le.absoluteNeg)),ee.isSum||(le.connectorThreshold=le.threshold+le.stackTotal),v.reversed?(j=ae>=0?C-ae:C+ae,q=C):(j=C,q=C-ae),ee.below=j<=z,ie.y=v.translate(j,!1,!0,!1,!0)||0,ie.height=Math.abs(ie.y-(v.translate(q,!1,!0,!1,!0)||0));var ce=v.waterfall.dummyStackItem;ce&&(ce.x=K,ce.label=N[K].label,ce.setOffset(a.pointXOffset||0,a.barW||0,a.stackedYNeg[K],a.stackedYPos[K]))}}else C=Math.max($,$+ae)+oe[0],ie.y=v.translate(C,!1,!0,!1,!0)||0,ee.isSum?(ie.y=v.translate(oe[1],!1,!0,!1,!0)||0,ie.height=Math.min(v.translate(oe[0],!1,!0,!1,!0)||0,v.len)-ie.y,ee.below=oe[1]<=z):ee.isIntermediateSum?(ae>=0?(j=oe[1]+D,q=D):(j=D,q=oe[1]+D),v.reversed&&(j^=q,q^=j,j^=q),ie.y=v.translate(j,!1,!0,!1,!0)||0,ie.height=Math.abs(ie.y-Math.min(v.translate(q,!1,!0,!1,!0)||0,v.len)),D+=oe[1],ee.below=j<=z):(ie.height=te>0?(v.translate($,!1,!0,!1,!0)||0)-ie.y:(v.translate($,!1,!0,!1,!0)||0)-(v.translate($-te,!1,!0,!1,!0)||0),$+=te,ee.below=$<z),ie.height<0&&(ie.y+=ie.height,ie.height*=-1);ee.plotY=ie.y=Math.round(ie.y||0)-a.borderWidth%2/2,ie.height=Math.max(Math.round(ie.height||0),.001),ee.yBottom=ie.y+ie.height,ie.height<=P&&!ee.isNull?(ie.height=P,ie.y-=k,ee.plotY=ie.y,ee.y<0?ee.minPointLengthOffset=-k:ee.minPointLengthOffset=k):(ee.isNull&&(ie.width=0),ee.minPointLengthOffset=0);var ue=ee.plotY+(ee.negative?ie.height:0);ee.below&&(ee.plotY+=ie.height),ee.tooltipPos&&(a.chart.inverted?ee.tooltipPos[0]=v.len-ue:ee.tooltipPos[1]=ue)}}},d.prototype.processData=function(a){var p=this,v=p.options,C=p.yData,P=v.data,k,z=C.length,$=v.threshold||0,D,F,N,W,j,q;for(F=D=N=W=0,q=0;q<z;q++)j=C[q],k=P&&P[q]?P[q]:{},j==="sum"||k.isSum?C[q]=correctFloat$2(F):j==="intermediateSum"||k.isIntermediateSum?(C[q]=correctFloat$2(D),D=0):(F+=j,D+=j),N=Math.min(F,N),W=Math.max(F,W);g.prototype.processData.call(this,a),v.stacking||(p.dataMin=N+$,p.dataMax=W)},d.prototype.toYData=function(a){return a.isSum?"sum":a.isIntermediateSum?"intermediateSum":a.y},d.prototype.updateParallelArrays=function(a,p){g.prototype.updateParallelArrays.call(this,a,p),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},d.prototype.pointAttribs=function(a,p){var v=this.options.upColor,C;return v&&!a.options.color&&(a.color=a.y>0?v:null),C=ColumnSeries$8.prototype.pointAttribs.call(this,a,p),delete C.dashstyle,C},d.prototype.getGraphPath=function(){return[["M",0,0]]},d.prototype.getCrispPath=function(){var a=this.data,p=this.yAxis,v=a.length,C=Math.round(this.graph.strokeWidth())%2/2,P=Math.round(this.borderWidth)%2/2,k=this.xAxis.reversed,z=this.yAxis.reversed,$=this.options.stacking,D=[],F,N,W,j,q,X,K,ee,te;for(te=1;te<v;te++)if(ee=a[te].shapeArgs,j=a[te-1],K=a[te-1].shapeArgs,N=p.waterfall.stacks[this.stackKey],X=j.y>0?-K.height:0,N&&K&&ee&&(W=N[te-1],$?(F=W.connectorThreshold,q=Math.round(p.translate(F,0,1,0,1)+(z?X:0))-C):q=K.y+j.minPointLengthOffset+P-C,D.push(["M",(K.x||0)+(k?0:K.width||0),q],["L",(ee.x||0)+(k&&ee.width||0),q])),K&&D.length&&(!$&&j.y<0&&!z||j.y>0&&z)){var ie=D[D.length-2];ie&&typeof ie[2]=="number"&&(ie[2]+=K.height||0);var oe=D[D.length-1];oe&&typeof oe[2]=="number"&&(oe[2]+=K.height||0)}return D},d.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},d.prototype.setStackedPoints=function(){var a=this,p=a.options,v=a.yAxis.waterfall.stacks,C=p.threshold,P=C||0,k=P,z=a.stackKey,$=a.xData,D=$.length,F,N,W,j,q,X,K,ee,te,ie,oe,ae,le;function ce(ge,ye,we,ve){if(!X)N.stackState[0]=ge,X=N.stackState.length;else for(we;we<X;we++)N.stackState[we]+=ve;N.stackState.push(N.stackState[X-1]+ye)}if(a.yAxis.stacking.usePercentage=!1,W=j=q=P,a.visible||!a.chart.options.chart.ignoreHiddenSeries){le=v.changed,ae=v.alreadyChanged,ae&&ae.indexOf(z)<0&&(le=!0),v[z]||(v[z]={}),F=v[z];for(var ue=0;ue<D;ue++)oe=$[ue],(!F[oe]||le)&&(F[oe]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:le&&F[oe]?F[oe].label:void 0}),N=F[oe],ie=a.yData[ue],ie>=0?N.posTotal+=ie:N.negTotal+=ie,te=p.data[ue],K=N.absolutePos=N.posTotal,ee=N.absoluteNeg=N.negTotal,N.stackTotal=K+ee,X=N.stackState.length,te&&te.isIntermediateSum?(ce(q,j,0,q),q=j,j=C,P^=k,k^=P,P^=k):te&&te.isSum?(ce(C,W,X),P=C):(ce(P,ie,0,W),te&&(W+=ie,j+=ie)),N.stateIndex++,N.threshold=P,P+=N.stackTotal;v.changed=!1,v.alreadyChanged||(v.alreadyChanged=[]),v.alreadyChanged.push(z)}},d.prototype.getExtremes=function(){var a=this.options.stacking,p,v,C,P;return a?(p=this.yAxis,v=p.waterfall.stacks,C=this.stackedYNeg=[],P=this.stackedYPos=[],a==="overlap"?objectEach$9(v[this.stackKey],function(k){C.push(arrayMin$1(k.stackState)),P.push(arrayMax$1(k.stackState))}):objectEach$9(v[this.stackKey],function(k){C.push(k.negTotal+k.threshold),P.push(k.posTotal+k.threshold)}),{dataMin:arrayMin$1(C),dataMax:arrayMax$1(P)}):{dataMin:this.dataMin,dataMax:this.dataMax}},d.defaultOptions=merge$y(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),d})(ColumnSeries$8);extend$A(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$3=animationExports.animObject,seriesTypes$4=SeriesRegistry$1.seriesTypes,addEvent$p=Utilities.addEvent,defined$g=Utilities.defined,find$6=Utilities.find,isNumber$g=Utilities.isNumber,pick$D=Utilities.pick,splat$5=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$a=Utilities.wrap,seriesProto=Series$f.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(g){var d=this,a=d.chart,p=d.xAxis,v=p.pane.center,C=g.chartX-v[0]-a.plotLeft,P=g.chartY-v[1]-a.plotTop;return this.searchKDTree({clientX:180+Math.atan2(C,P)*(-180/Math.PI)})};seriesProto.getConnectors=function(g,d,a,p){var v,C,P,k,z,$,D,F,N,W,j,q,X=1.5,K=X+1,ee,te,ie,oe,ae,le,ce,ue,ge,ye=p?1:0;return d>=0&&d<=g.length-1?v=d:d<0?v=g.length-1+d:v=0,C=v-1<0?g.length-(1+ye):v-1,P=v+1>g.length-1?ye:v+1,k=g[C],z=g[P],$=k.plotX,D=k.plotY,F=z.plotX,N=z.plotY,W=g[v].plotX,j=g[v].plotY,ee=(X*W+$)/K,te=(X*j+D)/K,ie=(X*W+F)/K,oe=(X*j+N)/K,ae=Math.sqrt(Math.pow(ee-W,2)+Math.pow(te-j,2)),le=Math.sqrt(Math.pow(ie-W,2)+Math.pow(oe-j,2)),ce=Math.atan2(te-j,ee-W),ue=Math.atan2(oe-j,ie-W),ge=Math.PI/2+(ce+ue)/2,Math.abs(ce-ge)>Math.PI/2&&(ge-=Math.PI),ee=W+Math.cos(ge)*ae,te=j+Math.sin(ge)*ae,ie=W+Math.cos(Math.PI+ge)*le,oe=j+Math.sin(Math.PI+ge)*le,q={rightContX:ie,rightContY:oe,leftContX:ee,leftContY:te,plotX:W,plotY:j},a&&(q.prevPointCont=this.getConnectors(g,C,!1,p)),q};seriesProto.toXY=function(g){var d=this.chart,a=this.xAxis,p=this.yAxis,v=g.plotX,C=g.plotY,P=g.series,k=d.inverted,z=g.y,$=k?v:p.len-C,D;if(k&&P&&!P.isRadialBar&&(g.plotY=C=typeof z=="number"&&p.translate(z)||0),g.rectPlotX=v,g.rectPlotY=C,p.center&&($+=p.center[3]/2),isNumber$g(C)){var F=k?p.postTranslate(C,$):a.postTranslate(v,$);g.plotX=g.polarPlotX=F.x-d.plotLeft,g.plotY=g.polarPlotY=F.y-d.plotTop}this.kdByAngle?(D=(v/Math.PI*180+a.pane.options.startAngle)%360,D<0&&(D+=360),g.clientX=D):g.clientX=g.plotX};seriesTypes$4.spline&&(wrap$a(seriesTypes$4.spline.prototype,"getPointSpline",function(g,d,a,p){var v,C;if(this.chart.polar)if(!p)v=["M",a.plotX,a.plotY];else{C=this.getConnectors(d,p,!0,this.connectEnds);var P=C.prevPointCont&&C.prevPointCont.rightContX,k=C.prevPointCont&&C.prevPointCont.rightContY;v=["C",isNumber$g(P)?P:C.plotX,isNumber$g(k)?k:C.plotY,isNumber$g(C.leftContX)?C.leftContX:C.plotX,isNumber$g(C.leftContY)?C.leftContY:C.plotY,C.plotX,C.plotY]}else v=g.call(this,d,a,p);return v}),seriesTypes$4.areasplinerange&&(seriesTypes$4.areasplinerange.prototype.getPointSpline=seriesTypes$4.spline.prototype.getPointSpline));addEvent$p(Series$f,"afterTranslate",function(){var g=this,d=g.chart;if(d.polar&&g.xAxis){if(g.kdByAngle=d.tooltip&&d.tooltip.shared,g.kdByAngle?g.searchPoint=g.searchPointByAngle:g.options.findNearestPointBy="xy",!g.preventPostTranslate)for(var a=g.points,p=a.length;p--;)g.toXY(a[p]),!d.hasParallelCoordinates&&!g.yAxis.reversed&&a[p].y<g.yAxis.min&&(a[p].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!g.eventsToUnbind.push(addEvent$p(g,"afterRender",function(){var v;d.polar&&(v=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:v[0],y:v[1],r:v[2]/2,innerR:v[3]/2}):this.clipCircle=d.renderer.clipCircle(v[0],v[1],v[2]/2,v[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$a(seriesTypes$4.line.prototype,"getGraphPath",function(g,d){var a=this,p,v,C;if(this.chart.polar){for(d=d||this.points,p=0;p<d.length;p++)if(!d[p].isNull){v=p;break}this.options.connectEnds!==!1&&typeof v<"u"&&(this.connectEnds=!0,d.splice(d.length,0,d[v]),C=!0),d.forEach(function(k){typeof k.polarPlotY>"u"&&a.toXY(k)})}var P=g.apply(this,[].slice.call(arguments,1));return C&&d.pop(),P});var polarAnimate=function(g,d){var a=this,p=this.chart,v=this.options.animation,C=this.group,P=this.markerGroup,k=this.xAxis.center,z=p.plotLeft,$=p.plotTop,D,F,N,W,j,q;p.polar?a.isRadialBar?d||(a.startAngleRad=pick$D(a.translatedThreshold,a.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(a,d)):p.renderer.isSVG&&(v=animObject$3(v),a.is("column")?d||(F=k[3]/2,a.points.forEach(function(X){N=X.graphic,W=X.shapeArgs,j=W&&W.r,q=W&&W.innerR,N&&W&&(N.attr({r:F,innerR:F}),N.animate({r:j,innerR:q},a.options.animation))})):d?(D={translateX:k[0]+z,translateY:k[1]+$,scaleX:.001,scaleY:.001},C.attr(D),P&&P.attr(D)):(D={translateX:z,translateY:$,scaleX:1,scaleY:1},C.animate(D,v),P&&P.animate(D,v))):g.call(this,d)};wrap$a(seriesProto,"animate",polarAnimate);seriesTypes$4.column&&(arearangeProto=seriesTypes$4.arearange.prototype,columnProto$2=seriesTypes$4.column.prototype,columnProto$2.polarArc=function(g,d,a,p){var v=this.xAxis.center,C=this.yAxis.len,P=v[3]/2,k=C-d+P,z=C-pick$D(g,C)+P;return this.yAxis.reversed&&(k<0&&(k=P),z<0&&(z=P)),{x:v[0],y:v[1],r:k,innerR:z,start:a,end:p}},wrap$a(columnProto$2,"animate",polarAnimate),wrap$a(columnProto$2,"translate",function(g){var d=this,a=d.options,p=a.threshold,v=a.stacking,C=d.chart,P=d.xAxis,k=d.yAxis,z=k.reversed,$=k.center,D=P.startAngleRad,F=P.endAngleRad,N=F-D,W,j,q,X,K,ee,te,ie,oe,ae,le,ce,ue,ge,ye,we;if(d.preventPostTranslate=!0,g.call(d),P.isRadial)for(j=d.points,X=j.length,K=k.translate(k.min),ee=k.translate(k.max),p=a.threshold||0,C.inverted&&isNumber$g(p)&&(W=k.translate(p),defined$g(W)&&(W<0?W=0:W>N&&(W=N),d.translatedThreshold=W+D));X--;)q=j[X],ge=q.barX,ae=q.x,le=q.y,q.shapeType="arc",C.inverted?(q.plotY=k.translate(le),v&&k.stacking?(ue=k.stacking.stacks[(le<0?"-":"")+d.stackKey],d.visible&&ue&&ue[ae]&&(q.isNull||(ce=ue[ae].points[d.getStackIndicator(void 0,ae,d.index).key],te=k.translate(ce[0]),ie=k.translate(ce[1]),defined$g(te)&&(te=Utilities.clamp(te,0,N))))):(te=W,ie=q.plotY),te>ie&&(ie=[te,te=ie][0]),z?ie>K?ie=K:te<ee?te=ee:(te>K||ie<ee)&&(te=ie=N):te<K?te=K:ie>ee?ie=ee:(ie<K||te>ee)&&(te=ie=0),k.min>k.max&&(te=ie=z?N:0),te+=D,ie+=D,$&&(q.barX=ge+=$[3]/2),ye=Math.max(ge,0),we=Math.max(ge+q.pointWidth,0),q.shapeArgs={x:$&&$[0],y:$&&$[1],r:we,innerR:ye,start:te,end:ie},q.opacity=te===ie?0:void 0,q.plotY=(defined$g(d.translatedThreshold)&&(te<d.translatedThreshold?te:ie))-D):(te=ge+D,q.shapeArgs=d.polarArc(q.yBottom,q.plotY,te,te+q.pointWidth)),d.toXY(q),C.inverted?(oe=k.postTranslate(q.rectPlotY,ge+q.pointWidth/2),q.tooltipPos=[oe.x-C.plotLeft,oe.y-C.plotTop]):q.tooltipPos=[q.plotX,q.plotY],$&&(q.ttBelow=q.plotY>$[1])}),columnProto$2.findAlignments=function(g,d){var a,p;return d.align===null&&(g>20&&g<160?a="left":g>200&&g<340?a="right":a="center",d.align=a),d.verticalAlign===null&&(g<45||g>315?p="bottom":g>135&&g<225?p="top":p="middle",d.verticalAlign=p),d},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$a(columnProto$2,"alignDataLabel",function(g,d,a,p,v,C){var P=this.chart,k=pick$D(p.inside,!!this.options.stacking),z,$,D;P.polar?(z=d.rectPlotX/Math.PI*180,P.inverted?(this.forceDL=P.isInsidePlot(d.plotX,Math.round(d.plotY)),k&&d.shapeArgs?($=d.shapeArgs,D=this.yAxis.postTranslate((($.start||0)+($.end||0))/2-this.xAxis.startAngleRad,d.barX+d.pointWidth/2),v={x:D.x-P.plotLeft,y:D.y-P.plotTop}):d.tooltipPos&&(v={x:d.tooltipPos[0],y:d.tooltipPos[1]}),p.align=pick$D(p.align,"center"),p.verticalAlign=pick$D(p.verticalAlign,"middle")):this.findAlignments&&(p=this.findAlignments(z,p)),seriesProto.alignDataLabel.call(this,d,a,p,v,C),this.isRadialBar&&d.shapeArgs&&d.shapeArgs.start===d.shapeArgs.end&&a.hide(!0)):g.call(this,d,a,p,v,C)}));wrap$a(pointerProto,"getCoordinates",function(g,d){var a=this.chart,p={xAxis:[],yAxis:[]};return a.polar?a.axes.forEac