/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.portlet;

import com.vaadin.portlet.VaadinPortlet;
import com.vaadin.portlet.VaadinPortletRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class VaadinPortletTest {
    private VaadinPortlet sut;
    private PortletRequest portletRequest;
    private PortalContext portalContext;

    @Before
    public void setup() {
        this.sut = new VaadinPortlet();
        this.portletRequest = (PortletRequest)Mockito.mock(PortletRequest.class);
        this.portalContext = (PortalContext)Mockito.mock(PortalContext.class);
        Mockito.when((Object)this.portletRequest.getPortalContext()).thenReturn((Object)this.portalContext);
    }

    private void mockPortalInfo(String name) {
        Mockito.when((Object)this.portalContext.getPortalInfo()).thenReturn((Object)name);
    }

    private VaadinPortletRequest createRequest() {
        VaadinPortletRequest request = this.sut.createVaadinRequest(this.portletRequest);
        return request;
    }

    @Test
    public void gateInRequestIsCreated() {
        this.mockPortalInfo("gatein");
        VaadinPortletRequest request = this.createRequest();
        MatcherAssert.assertThat((Object)request, (Matcher)IsInstanceOf.instanceOf(VaadinPortlet.VaadinGateInRequest.class));
    }

    @Test
    public void liferayRequestIsCreated() {
        this.mockPortalInfo("liferay");
        VaadinPortletRequest request = this.createRequest();
        MatcherAssert.assertThat((Object)request, (Matcher)IsInstanceOf.instanceOf(VaadinPortlet.VaadinLiferayRequest.class));
    }

    @Test
    public void webspherePortalRequestIsCreated() {
        this.mockPortalInfo("websphere portal");
        VaadinPortletRequest request = this.createRequest();
        MatcherAssert.assertThat((Object)request, (Matcher)IsInstanceOf.instanceOf(VaadinPortlet.VaadinWebSpherePortalRequest.class));
    }

    @Test
    public void defaultPortletRequestIsCreated() {
        this.mockPortalInfo("foobar");
        VaadinPortletRequest request = this.createRequest();
        MatcherAssert.assertThat((Object)request, (Matcher)IsInstanceOf.instanceOf(VaadinPortletRequest.class));
    }
}

