/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.portlet;

import com.vaadin.portlet.VaadinPortlet;
import com.vaadin.portlet.VaadinPortletService;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class VaadinHttpAndPortletRequestTestBase<T extends VaadinPortlet.VaadinHttpAndPortletRequest> {
    protected VaadinPortlet.VaadinHttpAndPortletRequest sut;
    protected HttpServletRequest servletRequest;
    protected PortletRequest portletRequest;
    protected VaadinPortletService vaadinPortletService;

    protected abstract T createSut();

    @Before
    public void setup() {
        this.portletRequest = (PortletRequest)Mockito.mock(PortletRequest.class);
        this.vaadinPortletService = (VaadinPortletService)Mockito.mock(VaadinPortletService.class);
        this.servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.sut = this.createSut();
    }

    @Test
    public void parameterIsFetchedFromServletRequest() {
        Mockito.when((Object)this.servletRequest.getParameter("foo")).thenReturn((Object)"bar");
        String parameter = this.sut.getParameter("foo");
        MatcherAssert.assertThat((Object)parameter, (Matcher)Is.is((Object)"bar"));
    }

    @Test
    public void originalParameterIsOverridden() {
        Mockito.when((Object)this.servletRequest.getParameter("foo")).thenReturn((Object)"braa");
        Mockito.when((Object)this.portletRequest.getParameter("foo")).thenReturn((Object)"bar");
        String parameter = this.sut.getParameter("foo");
        MatcherAssert.assertThat((Object)parameter, (Matcher)Is.is((Object)"bar"));
    }

    @Test
    public void remoteAddressIsFetchedFromServletRequest() {
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"foo");
        String remoteAddr = this.sut.getRemoteAddr();
        MatcherAssert.assertThat((Object)remoteAddr, (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void remoteHostIsFetchedFromServletRequest() {
        Mockito.when((Object)this.servletRequest.getRemoteHost()).thenReturn((Object)"foo");
        String remoteHost = this.sut.getRemoteHost();
        MatcherAssert.assertThat((Object)remoteHost, (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void remotePortIsFetchedFromServletRequest() {
        Mockito.when((Object)this.servletRequest.getRemotePort()).thenReturn((Object)12345);
        int remotePort = this.sut.getRemotePort();
        MatcherAssert.assertThat((Object)remotePort, (Matcher)Is.is((Object)12345));
    }

    @Test
    public void headerIsFetchedFromServletRequest() {
        Mockito.when((Object)this.servletRequest.getHeader("foo")).thenReturn((Object)"bar");
        String header = this.sut.getHeader("foo");
        MatcherAssert.assertThat((Object)header, (Matcher)Is.is((Object)"bar"));
    }

    @Test
    public void headerNamesAreFetchedFromServletRequest() {
        Enumeration expectedHeaderNames = (Enumeration)Mockito.mock(Enumeration.class);
        Mockito.when((Object)this.servletRequest.getHeaderNames()).thenReturn((Object)expectedHeaderNames);
        Enumeration actualHeaderNames = this.sut.getHeaderNames();
        MatcherAssert.assertThat((Object)actualHeaderNames, (Matcher)Is.is((Object)expectedHeaderNames));
    }

    @Test
    public void headersAreFetchedFromServletRequest() {
        Enumeration expectedHeaders = (Enumeration)Mockito.mock(Enumeration.class);
        Mockito.when((Object)this.servletRequest.getHeaders("foo")).thenReturn((Object)expectedHeaders);
        Enumeration actualHeaders = this.sut.getHeaders("foo");
        MatcherAssert.assertThat((Object)actualHeaders, (Matcher)Is.is((Object)expectedHeaders));
    }

    @Test
    public void parameterMapIsFetchedFromServletRequest() {
        Map expectedParameterMap = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)this.servletRequest.getParameterMap()).thenReturn((Object)expectedParameterMap);
        Map actualParameterMap = this.sut.getParameterMap();
        MatcherAssert.assertThat((Object)actualParameterMap, (Matcher)Is.is((Object)expectedParameterMap));
    }
}

