/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.portlet;

import com.vaadin.portlet.VaadinPortlet;
import com.vaadin.portlet.VaadinPortletRequest;
import com.vaadin.portlet.VaadinPortletService;
import com.vaadin.portlet.WrappedPortletSession;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.UI;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class VaadinPortletServiceTest {
    private VaadinPortletService sut;
    private VaadinPortletRequest request;
    private DeploymentConfiguration conf;

    @Before
    public void setup() throws ServiceException {
        VaadinPortlet portlet = (VaadinPortlet)Mockito.mock(VaadinPortlet.class);
        this.conf = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        this.sut = new VaadinPortletService(portlet, this.conf);
        this.request = (VaadinPortletRequest)Mockito.mock(VaadinPortletRequest.class);
    }

    private void mockFileLocationProperty(String location) {
        this.mockPortalProperty("vaadin.resources.path", location);
    }

    private void mockPortalProperty(String name, String value) {
        Mockito.when((Object)this.request.getPortalProperty(name)).thenReturn((Object)value);
    }

    private void mockFileLocationPreference(String location) {
        Mockito.when((Object)this.request.getPortletPreference("vaadin.resources.path")).thenReturn((Object)location);
    }

    private void mockLocationDeploymentConfiguration(String location) {
        Mockito.when((Object)this.conf.getApplicationOrSystemProperty("vaadin.resources.path", null)).thenReturn((Object)location);
    }

    private String getStaticFileLocation() {
        return this.sut.getStaticFileLocation((VaadinRequest)this.request);
    }

    private String getTheme() {
        return this.sut.getConfiguredTheme((VaadinRequest)this.request);
    }

    private void mockThemeProperty(String theme) {
        this.mockPortalProperty("vaadin.theme", theme);
    }

    private void mockWidgetsetProperty(String widgetset) {
        this.mockPortalProperty("vaadin.widgetset", widgetset);
    }

    private void mockWidgetsetConfiguration(String widgetset) {
        Mockito.when((Object)this.conf.getWidgetset(null)).thenReturn((Object)widgetset);
    }

    @Test
    public void preferencesOverrideDeploymentConfiguration() {
        this.mockFileLocationPreference("prefs");
        this.mockLocationDeploymentConfiguration("conf");
        String location = this.getStaticFileLocation();
        MatcherAssert.assertThat((Object)location, (Matcher)Is.is((Object)"prefs"));
    }

    @Test
    public void deploymentConfigurationOverridesProperties() {
        this.mockFileLocationPreference(null);
        this.mockLocationDeploymentConfiguration("conf");
        this.mockFileLocationProperty("props");
        String location = this.getStaticFileLocation();
        MatcherAssert.assertThat((Object)location, (Matcher)Is.is((Object)"conf"));
    }

    @Test
    public void defaultFileLocationIsSet() {
        this.mockFileLocationPreference(null);
        this.mockLocationDeploymentConfiguration(null);
        this.mockFileLocationProperty(null);
        String location = this.getStaticFileLocation();
        MatcherAssert.assertThat((Object)location, (Matcher)Is.is((Object)"/html"));
    }

    @Test
    public void trailingSlashesAreTrimmedFromStaticFileLocation() {
        this.mockFileLocationPreference("/content////");
        String staticFileLocation = this.getStaticFileLocation();
        MatcherAssert.assertThat((Object)staticFileLocation, (Matcher)Is.is((Object)"/content"));
    }

    @Test
    public void themeCanBeOverridden() {
        this.mockThemeProperty("foobar");
        String theme = this.getTheme();
        MatcherAssert.assertThat((Object)theme, (Matcher)Is.is((Object)"foobar"));
    }

    @Test
    public void defaultThemeIsSet() {
        this.mockThemeProperty(null);
        String theme = this.getTheme();
        MatcherAssert.assertThat((Object)theme, (Matcher)Is.is((Object)"valo"));
    }

    private String getWidgetset() {
        return this.sut.getConfiguredWidgetset((VaadinRequest)this.request);
    }

    @Test
    public void defaultWidgetsetIsSet() {
        this.mockWidgetsetProperty(null);
        this.mockWidgetsetConfiguration(null);
        String widgetset = this.getWidgetset();
        MatcherAssert.assertThat((Object)widgetset, (Matcher)Is.is((Object)"com.vaadin.DefaultWidgetSet"));
    }

    @Test
    public void configurationWidgetsetOverridesProperty() {
        this.mockWidgetsetProperty("foo");
        this.mockWidgetsetConfiguration("bar");
        String widgetset = this.getWidgetset();
        MatcherAssert.assertThat((Object)widgetset, (Matcher)Is.is((Object)"bar"));
    }

    @Test
    public void oldDefaultWidgetsetIsMappedToDefaultWidgetset() {
        this.mockWidgetsetConfiguration(null);
        this.mockWidgetsetProperty("com.vaadin.portal.gwt.PortalDefaultWidgetSet");
        String widgetset = this.getWidgetset();
        MatcherAssert.assertThat((Object)widgetset, (Matcher)Is.is((Object)"com.vaadin.DefaultWidgetSet"));
    }

    @Test
    public void oldDefaultWidgetSetIsNotMappedToDefaultWidgetset() {
        this.mockWidgetsetConfiguration("com.vaadin.portal.gwt.PortalDefaultWidgetSet");
        this.mockWidgetsetProperty(null);
        String widgetset = this.getWidgetset();
        MatcherAssert.assertThat((Object)widgetset, (Matcher)Is.is((Object)"com.vaadin.portal.gwt.PortalDefaultWidgetSet"));
    }

    @Test
    public void findUIDoesntThrowNPE() {
        try {
            ReentrantLock mockLock = (ReentrantLock)Mockito.mock(ReentrantLock.class);
            Mockito.when((Object)mockLock.isHeldByCurrentThread()).thenReturn((Object)true);
            WrappedPortletSession emptyWrappedSession = (WrappedPortletSession)Mockito.mock(WrappedPortletSession.class);
            Mockito.when((Object)emptyWrappedSession.getAttribute("null.lock", 1)).thenReturn((Object)mockLock);
            VaadinRequest requestWithUIIDSet = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)requestWithUIIDSet.getParameter("v-uiId")).thenReturn((Object)"1");
            Mockito.when((Object)requestWithUIIDSet.getWrappedSession()).thenReturn((Object)emptyWrappedSession);
            UI ui = this.sut.findUI(requestWithUIIDSet);
            Assert.assertNull((String)"Unset session did not return null", (Object)ui);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"findUI threw a NullPointerException");
        }
    }
}

