/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.portlet;

import com.vaadin.portlet.VaadinPortletRequest;
import com.vaadin.portlet.VaadinPortletService;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class VaadinPortletRequestTest {
    private PortletRequest request;
    private VaadinPortletRequest sut;
    private VaadinPortletService service;
    private PortletPreferences preferences;

    @Before
    public void setup() {
        this.request = (PortletRequest)Mockito.mock(PortletRequest.class);
        this.service = (VaadinPortletService)Mockito.mock(VaadinPortletService.class);
        this.sut = new VaadinPortletRequest(this.request, this.service);
        this.preferences = (PortletPreferences)Mockito.mock(PortletPreferences.class);
        Mockito.when((Object)this.request.getPreferences()).thenReturn((Object)this.preferences);
    }

    @Test
    public void portletPreferenceIsFetched() {
        Mockito.when((Object)this.preferences.getValue((String)Matchers.eq((Object)"foo"), Matchers.anyString())).thenReturn((Object)"bar");
        String value = this.sut.getPortletPreference("foo");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void defaultValueForPortletPreferenceIsNull() {
        Mockito.when((Object)this.preferences.getValue(Matchers.anyString(), (String)Matchers.isNull(String.class))).thenReturn(null);
        String value = this.sut.getPortletPreference("foo");
        Assert.assertNull((Object)value);
    }
}

