/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.popover;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.popover.PopoverPosition;
import com.vaadin.flow.component.popover.PopoverVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

@Tag(value="vaadin-popover")
@NpmPackage(value="@vaadin/popover", version="25.0.0-alpha16")
@JsModule.Container(value={@JsModule(value="@vaadin/popover/src/vaadin-popover.js"), @JsModule(value="./vaadin-popover/popover.ts")})
public class Popover
extends Component
implements HasAriaLabel,
HasComponents,
HasThemeVariant<PopoverVariant> {
    private static Integer defaultHideDelay;
    private static Integer defaultFocusDelay;
    private static Integer defaultHoverDelay;
    static final AtomicBoolean uiInitListenerRegistered;
    private Component target;
    private Registration targetAttachRegistration;
    private Registration targetDetachRegistration;
    private boolean autoAddedToTheUi;
    private boolean openOnClick = true;
    private boolean openOnHover = false;
    private boolean openOnFocus = false;

    public Popover() {
        this.getElement().setProperty("opened", false);
        this.updateTrigger();
        this.setRole("dialog");
    }

    public Popover(Component ... components) {
        this();
        this.add(components);
    }

    public static void setDefaultFocusDelay(int defaultFocusDelay) {
        Popover.defaultFocusDelay = defaultFocusDelay;
        Popover.applyConfiguration();
    }

    public static void setDefaultHideDelay(int defaultHideDelay) {
        Popover.defaultHideDelay = defaultHideDelay;
        Popover.applyConfiguration();
    }

    public static void setDefaultHoverDelay(int defaultHoverDelay) {
        Popover.defaultHoverDelay = defaultHoverDelay;
        Popover.applyConfiguration();
    }

    private static void applyConfiguration() {
        if (UI.getCurrent() != null) {
            Popover.applyConfigurationForUI(UI.getCurrent());
        }
        if (uiInitListenerRegistered.compareAndSet(false, true)) {
            VaadinService.getCurrent().addUIInitListener((UIInitListener & Serializable)e -> Popover.applyConfigurationForUI(e.getUI()));
        }
    }

    private static void applyConfigurationForUI(UI ui) {
        ui.getElement().executeJs("((window.Vaadin ||= {}).Flow ||= {}).popover ||= {}", new Serializable[0]);
        if (defaultHideDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultHideDelay = $0;popover.setDefaultHideDelay?.($0)", new Serializable[]{defaultHideDelay});
        }
        if (defaultFocusDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultFocusDelay = $0;popover.setDefaultFocusDelay?.($0)", new Serializable[]{defaultFocusDelay});
        }
        if (defaultHoverDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultHoverDelay = $0;popover.setDefaultHoverDelay?.($0)", new Serializable[]{defaultHoverDelay});
        }
    }

    public void setOpened(boolean opened) {
        if (opened != this.isOpened()) {
            this.getElement().setProperty("opened", opened);
            this.fireEvent(new OpenedChangeEvent(this, false));
        }
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public void setModal(boolean modal) {
        this.getElement().setProperty("modal", modal);
    }

    public void setModal(boolean modal, boolean backdropVisible) {
        this.setModal(modal);
        this.setBackdropVisible(backdropVisible);
    }

    public boolean isModal() {
        return this.getElement().getProperty("modal", false);
    }

    public void setBackdropVisible(boolean backdropVisible) {
        this.getElement().setProperty("withBackdrop", backdropVisible);
    }

    public boolean isBackdropVisible() {
        return this.getElement().getProperty("withBackdrop", false);
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setRole(String role) {
        Objects.requireNonNull(role, "Role cannot be null");
        this.getElement().setProperty("role", role);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void setOverlayRole(String role) {
        Objects.requireNonNull(role, "Role cannot be null");
        this.setRole(role);
    }

    public String getRole() {
        return this.getElement().getProperty("role");
    }

    @Deprecated(since="25.0", forRemoval=true)
    public String getOverlayRole() {
        return this.getRole();
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    public boolean isCloseOnOutsideClick() {
        return !this.getElement().getProperty("noCloseOnOutsideClick", false);
    }

    public void setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.getElement().setProperty("noCloseOnOutsideClick", !closeOnOutsideClick);
    }

    public void setPosition(PopoverPosition position) {
        this.getElement().setProperty("position", position.getPosition());
    }

    public PopoverPosition getPosition() {
        String positionString = this.getElement().getProperty("position");
        return Arrays.stream(PopoverPosition.values()).filter(p -> p.getPosition().equals(positionString)).findFirst().orElse(null);
    }

    public void setFor(String id) {
        this.getElement().setProperty("for", id);
    }

    public String getFor() {
        return this.getElement().getProperty("for");
    }

    public void setFocusDelay(int focusDelay) {
        this.getElement().setProperty("focusDelay", (double)focusDelay);
    }

    public int getFocusDelay() {
        return this.getElement().getProperty("focusDelay", 0);
    }

    public void setHoverDelay(int hoverDelay) {
        this.getElement().setProperty("hoverDelay", (double)hoverDelay);
    }

    public int getHoverDelay() {
        return this.getElement().getProperty("hoverDelay", 0);
    }

    public void setHideDelay(int hideDelay) {
        this.getElement().setProperty("hideDelay", (double)hideDelay);
    }

    public int getHideDelay() {
        return this.getElement().getProperty("hideDelay", 0);
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnClick = openOnClick;
        this.updateTrigger();
    }

    public boolean isOpenOnClick() {
        return this.openOnClick;
    }

    public void setOpenOnFocus(boolean openOnFocus) {
        this.openOnFocus = openOnFocus;
        this.updateTrigger();
    }

    public boolean isOpenOnFocus() {
        return this.openOnFocus;
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.openOnHover = openOnHover;
        this.updateTrigger();
    }

    public boolean isOpenOnHover() {
        return this.openOnHover;
    }

    private void updateTrigger() {
        JsonArray trigger = Json.createArray();
        if (this.isOpenOnClick()) {
            trigger.set(trigger.length(), "click");
        }
        if (this.isOpenOnHover()) {
            trigger.set(trigger.length(), "hover");
        }
        if (this.isOpenOnFocus()) {
            trigger.set(trigger.length(), "focus");
        }
        this.getElement().setPropertyJson("trigger", (JsonValue)trigger);
    }

    public void setTarget(Component target) {
        if (target instanceof Text) {
            throw new IllegalArgumentException("Text as a target is not supported. Consider wrapping the Text inside a Div.");
        }
        if (this.target != null) {
            this.targetAttachRegistration.remove();
            this.targetDetachRegistration.remove();
        }
        this.removeFromUiIfAutoAdded();
        this.target = target;
        if (target == null) {
            this.getElement().executeJs("this.target = null", new Serializable[0]);
            return;
        }
        target.getUI().ifPresent(this::onTargetAttach);
        this.targetAttachRegistration = target.addAttachListener((ComponentEventListener & Serializable)e -> this.onTargetAttach(e.getUI()));
        this.targetDetachRegistration = target.addDetachListener((ComponentEventListener & Serializable)e -> this.removeFromUiIfAutoAdded());
    }

    private void removeFromUiIfAutoAdded() {
        if (this.autoAddedToTheUi) {
            this.autoAddedToTheUi = false;
            Optional maybeParent = this.getParent();
            if (maybeParent.isPresent() && ((Component)maybeParent.get()).getChildren().anyMatch(child -> child == this)) {
                this.getElement().removeFromParent();
            }
        }
    }

    private void onTargetAttach(UI ui) {
        if (this.target != null) {
            if (this.getElement().getNode().getParent() == null) {
                this.getElement().removeFromTree(false);
                ui.addToModalComponent((Component)this);
                this.autoAddedToTheUi = true;
            }
            this.getElement().executeJs("this.target = $0", new Serializable[]{this.target.getElement()});
        }
    }

    public Component getTarget() {
        return this.target;
    }

    public void setWidth(String width) {
        this.getElement().setProperty("contentWidth", width);
    }

    public void setHeight(String height) {
        this.getElement().setProperty("contentHeight", height);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("Popover does not support adding styles");
    }

    static {
        uiInitListenerRegistered = new AtomicBoolean(false);
    }

    @DomEvent(value="opened-changed")
    public static class OpenedChangeEvent
    extends ComponentEvent<Popover> {
        private final boolean opened;

        public OpenedChangeEvent(Popover source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

