/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.servlet;

import com.vaadin.osgi.resources.VaadinResourceService;
import com.vaadin.server.VaadinServlet;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.LogService;

@Component
public class VaadinServletRegistration {
    private static final String MISSING_ANNOTATION_MESSAGE_FORMAT = "The property '%s' must be set in a '%s' without the '%s' annotation!";
    private static final String URL_PATTERNS_NOT_SET_MESSAGE_FORMAT = "The property '%s' must be set when the 'urlPatterns' attribute is not set!";
    private static final String SERVLET_PATTERN = "osgi.http.whiteboard.servlet.pattern";
    private static final String VAADIN_RESOURCES_PARAM = "servlet.init.Resources";
    private final Map<ServiceReference<VaadinServlet>, ServletRegistration> registeredServlets = Collections.synchronizedMap(new LinkedHashMap());
    private VaadinResourceService vaadinService;
    private LogService logService;

    @Activate
    void activate(BundleContext bundleContext) throws Exception {
        for (ServletRegistration registration : this.registeredServlets.values()) {
            registration.register(this.vaadinService);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, service=VaadinServlet.class, policy=ReferencePolicy.DYNAMIC)
    void bindVaadinServlet(VaadinServlet servlet, ServiceReference<VaadinServlet> reference) {
        this.log(3, "VaadinServlet Registration");
        Hashtable<String, Object> properties = this.getProperties(reference);
        WebServlet annotation = servlet.getClass().getAnnotation(WebServlet.class);
        if (!this.validateSettings(annotation, properties)) {
            return;
        }
        if (annotation != null) {
            properties.put("osgi.http.whiteboard.servlet.asyncSupported", Boolean.toString(annotation.asyncSupported()));
        }
        ServletRegistration registration = new ServletRegistration(servlet, reference, properties);
        this.registeredServlets.put(reference, registration);
        registration.register(this.vaadinService);
    }

    private boolean validateSettings(WebServlet annotation, Hashtable<String, Object> properties) {
        if (!properties.containsKey(SERVLET_PATTERN)) {
            if (annotation == null) {
                this.log(1, String.format(MISSING_ANNOTATION_MESSAGE_FORMAT, SERVLET_PATTERN, VaadinServlet.class.getSimpleName(), WebServlet.class.getName()));
                return false;
            }
            if (annotation.urlPatterns().length == 0) {
                this.log(1, String.format(URL_PATTERNS_NOT_SET_MESSAGE_FORMAT, SERVLET_PATTERN));
                return false;
            }
        }
        return true;
    }

    private void log(int level, String message) {
        if (this.logService != null) {
            this.logService.log(level, message);
        }
    }

    void unbindVaadinServlet(ServiceReference<VaadinServlet> reference) {
        ServletRegistration servletRegistration = this.registeredServlets.remove(reference);
        if (servletRegistration != null) {
            servletRegistration.unregister();
        }
    }

    @Reference
    void setVaadinResourceService(VaadinResourceService vaadinService) {
        this.vaadinService = vaadinService;
    }

    void unsetVaadinResourceService(VaadinResourceService vaadinService) {
        if (this.vaadinService == vaadinService) {
            this.vaadinService = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    void setLogService(LogService logService) {
        this.logService = logService;
    }

    void unsetLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }

    private Hashtable<String, Object> getProperties(ServiceReference<VaadinServlet> reference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            properties.put(key, reference.getProperty(key));
        }
        return properties;
    }

    private static class ServletRegistration {
        private final VaadinServlet servlet;
        private final ServiceReference<VaadinServlet> servletRef;
        private final Hashtable<String, Object> properties;
        private volatile ServiceRegistration<Servlet> registration;

        public ServletRegistration(VaadinServlet servlet, ServiceReference<VaadinServlet> servletRef, Hashtable<String, Object> properties) {
            this.servlet = Objects.requireNonNull(servlet);
            this.servletRef = Objects.requireNonNull(servletRef);
            this.properties = properties;
        }

        public void register(VaadinResourceService vaadinService) {
            if (this.registration != null) {
                return;
            }
            if (vaadinService == null) {
                return;
            }
            String resourcePath = String.format("/%s", vaadinService.getResourcePathPrefix());
            this.properties.put(VaadinServletRegistration.VAADIN_RESOURCES_PARAM, resourcePath);
            BundleContext bundleContext = this.servletRef.getBundle().getBundleContext();
            this.registration = bundleContext.registerService(Servlet.class, (Object)this.servlet, this.properties);
        }

        public void unregister() {
            if (this.registration == null) {
                return;
            }
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.registration = null;
        }
    }
}

