/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayoutVariant;
import com.vaadin.flow.component.orderedlayout.ThemableLayout;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.shared.Registration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@Tag(value="vaadin-horizontal-layout")
@NpmPackage(value="@vaadin/horizontal-layout", version="25.0.0-beta5")
@JsModule(value="@vaadin/horizontal-layout/src/vaadin-horizontal-layout.js")
public class HorizontalLayout
extends Component
implements ThemableLayout,
FlexComponent,
ClickNotifier<HorizontalLayout>,
HasThemeVariant<HorizontalLayoutVariant> {
    private Map<Element, Registration> childDetachListenerMap = new HashMap<Element, Registration>();
    private ElementDetachListener childDetachListener = new ElementDetachListener(){

        public void onDetach(ElementDetachEvent e) {
            boolean childDetachedFromLayout;
            Element child = e.getSource();
            boolean bl = childDetachedFromLayout = !HorizontalLayout.this.getElement().getChildren().anyMatch(layoutChild -> Objects.equals(child, layoutChild));
            if (childDetachedFromLayout) {
                child.removeAttribute("slot");
                HorizontalLayout.this.childDetachListenerMap.get(child).remove();
                HorizontalLayout.this.childDetachListenerMap.remove(child);
            }
        }
    };

    public HorizontalLayout() {
        this.setSpacing(true);
    }

    public HorizontalLayout(Component ... children) {
        this();
        this.add(children);
    }

    public HorizontalLayout(FlexComponent.JustifyContentMode justifyContentMode, Component ... children) {
        this(children);
        this.setJustifyContentMode(justifyContentMode);
    }

    public HorizontalLayout(FlexComponent.Alignment alignment, Component ... children) {
        this(children);
        this.setDefaultVerticalComponentAlignment(alignment);
    }

    @Override
    public void setSpacing(boolean spacing) {
        ThemableLayout.super.setSpacing(spacing);
    }

    public void setVerticalComponentAlignment(FlexComponent.Alignment alignment, Component ... componentsToAlign) {
        this.setAlignSelf(alignment, (HasElement[])componentsToAlign);
    }

    public FlexComponent.Alignment getVerticalComponentAlignment(Component component) {
        return this.getAlignSelf((HasElement)component);
    }

    public void setDefaultVerticalComponentAlignment(FlexComponent.Alignment alignment) {
        this.setAlignItems(alignment);
    }

    public FlexComponent.Alignment getDefaultVerticalComponentAlignment() {
        return this.getAlignItems();
    }

    @Override
    public void setAlignItems(FlexComponent.Alignment alignment) {
        FlexComponent.super.setAlignItems(alignment);
    }

    @Override
    public FlexComponent.Alignment getAlignItems() {
        return FlexComponent.super.getAlignItems();
    }

    @Override
    public void setAlignSelf(FlexComponent.Alignment alignment, HasElement ... components) {
        FlexComponent.super.setAlignSelf(alignment, components);
    }

    @Override
    public FlexComponent.Alignment getAlignSelf(HasElement component) {
        return FlexComponent.super.getAlignSelf(component);
    }

    public void addAndExpand(Component ... components) {
        this.add(components);
        this.setWidthFull();
        this.expand(components);
    }

    @Override
    public void replace(Component oldComponent, Component newComponent) {
        String oldSlotName = oldComponent != null ? oldComponent.getElement().getAttribute("slot") : null;
        String newSlotName = newComponent != null ? newComponent.getElement().getAttribute("slot") : null;
        FlexComponent.super.replace(oldComponent, newComponent);
        if (newComponent != null && oldComponent != null) {
            if (oldSlotName == null) {
                newComponent.getElement().removeAttribute("slot");
            } else {
                newComponent.getElement().setAttribute("slot", oldSlotName);
            }
            if (newSlotName == null) {
                oldComponent.getElement().removeAttribute("slot");
            } else {
                oldComponent.getElement().setAttribute("slot", newSlotName);
            }
        }
        this.updateChildDetachListeners();
    }

    public void add(Collection<Component> components) {
        this.addToStart(components);
    }

    public void add(Component ... components) {
        this.addToStart(components);
    }

    public void addComponentAtIndex(int index, Component component) {
        Component oldComponent = this.getComponentCount() > index ? this.getComponentAt(index) : null;
        String slotName = oldComponent != null ? oldComponent.getElement().getAttribute("slot") : null;
        FlexComponent.super.addComponentAtIndex(index, component);
        if (slotName == null) {
            component.getElement().removeAttribute("slot");
        } else {
            component.getElement().setAttribute("slot", slotName);
        }
        this.updateChildDetachListeners();
    }

    public void addToStart(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        this.addToStart(Arrays.asList(components));
    }

    public void addToStart(Collection<Component> components) {
        long idx = this.getChildren().filter(child -> {
            String slotName = child.getElement().getAttribute("slot");
            return slotName == null;
        }).count();
        AtomicInteger itemCounter = new AtomicInteger((int)idx);
        components.stream().map(component -> Objects.requireNonNull(component, "Component to add cannot be null")).forEach(component -> {
            boolean isChild = this.getElement().equals((Object)component.getElement().getParent());
            this.getElement().insertChild(isChild ? itemCounter.get() : itemCounter.getAndIncrement(), new Element[]{component.getElement()});
        });
    }

    public void addToMiddle(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        this.addToMiddle(Arrays.asList(components));
    }

    public void addToMiddle(Collection<Component> components) {
        Objects.requireNonNull(components, "Components should not be null");
        long idx = this.getChildren().filter(child -> {
            String slotName = child.getElement().getAttribute("slot");
            return slotName == null || slotName.equals("middle");
        }).count();
        AtomicInteger itemCounter = new AtomicInteger((int)idx);
        components.stream().map(component -> Objects.requireNonNull(component, "Component to add cannot be null")).forEach(component -> {
            if (component instanceof Text) {
                throw new IllegalArgumentException("Text as a middle slot content is not supported. Consider wrapping the Text inside a Div.");
            }
            component.getElement().setAttribute("slot", "middle");
            boolean isChild = this.getElement().equals((Object)component.getElement().getParent());
            this.getElement().insertChild(isChild ? itemCounter.get() : itemCounter.getAndIncrement(), new Element[]{component.getElement()});
        });
        this.updateChildDetachListeners();
    }

    public void addToEnd(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        this.addToEnd(Arrays.asList(components));
    }

    public void addToEnd(Collection<Component> components) {
        Objects.requireNonNull(components, "Components should not be null");
        components.stream().map(component -> Objects.requireNonNull(component, "Component to add cannot be null")).forEach(component -> {
            if (component instanceof Text) {
                throw new IllegalArgumentException("Text as an end slot content is not supported. Consider wrapping the Text inside a Div.");
            }
            component.getElement().setAttribute("slot", "end");
            this.getElement().appendChild(new Element[]{component.getElement()});
        });
        this.updateChildDetachListeners();
    }

    private void updateChildDetachListeners() {
        this.getElement().getChildren().forEach(child -> {
            if (!this.childDetachListenerMap.containsKey(child)) {
                this.childDetachListenerMap.put((Element)child, child.addDetachListener(this.childDetachListener));
            }
        });
    }
}

