/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;

@Element(value="vaadin-message")
public class MessageElement
extends TestBenchElement {
    public String getText() {
        return this.getPropertyString(new String[]{"textContent"});
    }

    public String getTime() {
        return this.getPropertyString(new String[]{"time"});
    }

    public String getUserName() {
        return this.getPropertyString(new String[]{"userName"});
    }

    public String getUserAbbr() {
        return this.getPropertyString(new String[]{"userAbbr"});
    }

    public String getUserImg() {
        return this.getPropertyString(new String[]{"userImg"});
    }

    public int getUserColorIndex() {
        return this.getPropertyInteger(new String[]{"userColorIndex"});
    }

    public String getTheme() {
        return this.getDomAttribute("theme");
    }

    public List<TestBenchElement> getAttachmentElements() {
        return this.$(TestBenchElement.class).withAttributeContainingWord("part", "attachment").all();
    }

    public TestBenchElement getAttachmentByName(String name) {
        return this.getAttachmentElements().stream().filter(el -> name.equals(this.getAttachmentName((TestBenchElement)el))).findFirst().orElse(null);
    }

    public String getAttachmentName(TestBenchElement attachmentElement) {
        List nameSpans = attachmentElement.$(TestBenchElement.class).withAttributeContainingWord("part", "attachment-name").all();
        if (!nameSpans.isEmpty()) {
            return ((TestBenchElement)nameSpans.get(0)).getText();
        }
        return attachmentElement.getDomAttribute("aria-label");
    }

    public boolean hasAttachments() {
        return !this.getAttachmentElements().isEmpty();
    }

    public boolean isImageAttachment(TestBenchElement attachmentElement) {
        String partAttr = attachmentElement.getDomAttribute("part");
        return partAttr != null && partAttr.contains("attachment-image");
    }
}

