/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.messages.MessageListAttachmentsExperimentalFeatureException;
import com.vaadin.flow.component.messages.MessageListItem;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import tools.jackson.databind.node.ArrayNode;

@Tag(value="vaadin-message-list")
@JsModule.Container(value={@JsModule(value="./messageListConnector.js"), @JsModule(value="@vaadin/message-list/src/vaadin-message-list.js")})
@NpmPackage(value="@vaadin/message-list", version="25.1.0-alpha7")
public class MessageList
extends Component
implements HasStyle,
HasSize,
LocaleChangeObserver {
    static final String FEATURE_FLAG_ID = "messageListAttachments";
    private List<MessageListItem> items = new ArrayList<MessageListItem>();
    private boolean pendingUpdate = false;
    private boolean pendingTextUpdate = false;
    private Integer pendingAddItemsIndex;
    private final String CONNECTOR_OBJECT = "window.Vaadin.Flow.messageListConnector";

    public MessageList() {
    }

    public MessageList(Collection<MessageListItem> items) {
        this.setItems(items);
    }

    public MessageList(MessageListItem ... items) {
        this.setItems(items);
    }

    public void setItems(Collection<MessageListItem> items) {
        Objects.requireNonNull(items, "Can't set null item collection to MessageList.");
        items.forEach(item -> Objects.requireNonNull(item, "Can't include null items in MessageList."));
        this.items.forEach(item -> item.setHost(null));
        this.items = new ArrayList<MessageListItem>(items);
        items.forEach(item -> item.setHost(this));
        this.scheduleItemsUpdate();
    }

    public void setItems(MessageListItem ... items) {
        this.setItems(Arrays.asList(items));
    }

    public void addItem(MessageListItem item) {
        Objects.requireNonNull(item, "Can't add null item to MessageList.");
        item.setHost(this);
        this.items.add(item);
        this.scheduleAddItemsUpdate();
    }

    public List<MessageListItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    void scheduleItemsTextUpdate() {
        this.scheduleUpdate();
        this.pendingTextUpdate = true;
    }

    void scheduleAddItemsUpdate() {
        this.scheduleUpdate();
        if (this.pendingAddItemsIndex == null) {
            this.pendingAddItemsIndex = this.items.size() - 1;
        }
    }

    void scheduleItemsUpdate() {
        this.scheduleUpdate();
        this.pendingUpdate = true;
    }

    private void scheduleUpdate() {
        if (this.pendingUpdate || this.pendingTextUpdate || this.pendingAddItemsIndex != null) {
            return;
        }
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.updateClient((UI)ui)));
    }

    private void updateClient(UI ui) {
        if (this.pendingUpdate) {
            this.handleFullUpdate(ui);
        } else {
            this.handleAddItemsUpdate(ui);
            this.handleTextUpdates();
        }
        this.pendingTextUpdate = false;
        this.pendingUpdate = false;
        this.pendingAddItemsIndex = null;
    }

    private void handleFullUpdate(UI ui) {
        this.checkAttachmentsFeatureFlag(ui, this.items);
        this.items.forEach(item -> {
            item.clientText = item.getText();
        });
        ArrayNode itemsJson = JacksonUtils.listToJson(this.items);
        this.getElement().executeJs("window.Vaadin.Flow.messageListConnector.setItems(this, $0, $1)", new Object[]{itemsJson, ui.getLocale().toLanguageTag()});
    }

    private void handleTextUpdates() {
        this.items.forEach(item -> {
            boolean textChanged;
            boolean bl = textChanged = !Objects.equals(item.getText(), item.clientText);
            if (textChanged) {
                if (item.getText() != null && item.clientText != null && item.getText().startsWith(item.clientText)) {
                    String diff = item.getText().substring(item.clientText.length());
                    this.getElement().executeJs("window.Vaadin.Flow.messageListConnector.appendItemText(this, $0, $1)", new Object[]{diff, this.items.indexOf(item)});
                } else {
                    this.getElement().executeJs("window.Vaadin.Flow.messageListConnector.setItemText(this, $0, $1)", new Object[]{item.getText(), this.items.indexOf(item)});
                }
                item.clientText = item.getText();
            }
        });
    }

    private void handleAddItemsUpdate(UI ui) {
        if (this.pendingAddItemsIndex == null) {
            return;
        }
        List<MessageListItem> newItems = this.items.subList(this.pendingAddItemsIndex, this.items.size());
        this.checkAttachmentsFeatureFlag(ui, newItems);
        newItems.forEach(item -> {
            item.clientText = item.getText();
        });
        ArrayNode newItemsJson = JacksonUtils.listToJson(newItems);
        this.getElement().executeJs("window.Vaadin.Flow.messageListConnector.addItems(this, $0, $1)", new Object[]{newItemsJson, ui.getLocale().toLanguageTag()});
    }

    private void checkAttachmentsFeatureFlag(UI ui, List<MessageListItem> itemsToCheck) {
        boolean hasAttachments = itemsToCheck.stream().anyMatch(item -> !item.getAttachments().isEmpty());
        if (hasAttachments) {
            boolean enabled;
            FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
            boolean bl = enabled = featureFlags.isEnabled(FEATURE_FLAG_ID) || featureFlags.isEnabled("aiComponents");
            if (!enabled) {
                throw new MessageListAttachmentsExperimentalFeatureException();
            }
        }
    }

    public void localeChange(LocaleChangeEvent event) {
        this.scheduleItemsUpdate();
    }

    public void setMarkdown(boolean markdown) {
        this.getElement().setProperty("markdown", markdown);
    }

    public boolean isMarkdown() {
        return this.getElement().getProperty("markdown", false);
    }

    public void setAnnounceMessages(boolean announceMessages) {
        this.getElement().setProperty("announceMessages", announceMessages);
    }

    public boolean isAnnounceMessages() {
        return this.getElement().getProperty("announceMessages", false);
    }

    public Registration addAttachmentClickListener(ComponentEventListener<AttachmentClickEvent> listener) {
        return this.addListener(AttachmentClickEvent.class, listener);
    }

    @DomEvent(value="attachment-click-flow")
    public static class AttachmentClickEvent
    extends ComponentEvent<MessageList> {
        private final MessageListItem item;
        private final MessageListItem.Attachment attachment;

        public AttachmentClickEvent(MessageList source, boolean fromClient, @EventData(value="event.detail.itemIndex") int itemIndex, @EventData(value="event.detail.attachmentIndex") int attachmentIndex) {
            super((Component)source, fromClient);
            this.item = source.getItems().get(itemIndex);
            this.attachment = this.item.getAttachments().get(attachmentIndex);
        }

        public MessageListItem getItem() {
            return this.item;
        }

        public MessageListItem.Attachment getAttachment() {
            return this.attachment;
        }
    }
}

