/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.messages.MessageInputI18n;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.util.Objects;

@Tag(value="vaadin-message-input")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.6.3"), @NpmPackage(value="@vaadin/message-input", version="23.6.3"), @NpmPackage(value="@vaadin/vaadin-messages", version="23.6.3")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/message-input/src/vaadin-message-input.js")})
public class MessageInput
extends Component
implements HasSize,
HasStyle,
HasEnabled,
HasTooltip {
    private MessageInputI18n i18n;

    public MessageInput() {
    }

    public MessageInput(ComponentEventListener<SubmitEvent> listener) {
        this.addSubmitListener(listener);
    }

    public Registration addSubmitListener(ComponentEventListener<SubmitEvent> listener) {
        return this.addListener(SubmitEvent.class, listener);
    }

    public MessageInputI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(MessageInputI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n object should not be null");
        this.i18n = i18n;
        this.getElement().setPropertyJson("i18n", (JsonValue)JsonUtils.beanToJson((Object)i18n));
    }

    @DomEvent(value="submit")
    public static class SubmitEvent
    extends ComponentEvent<MessageInput> {
        private final String value;

        public SubmitEvent(MessageInput source, boolean fromClient, @EventData(value="event.detail.value") String value) {
            super((Component)source, fromClient);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

