/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.flow.component.menubar.testbench.MenuBarSubMenuElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Element(value="vaadin-menu-bar-item")
public class MenuBarItemElement
extends TestBenchElement {
    public MenuBarSubMenuElement openSubMenu() {
        this.hover();
        return this.getSubMenu();
    }

    public MenuBarSubMenuElement getSubMenu() {
        this.waitForSubMenu();
        TestBenchElement listBox = this.getPropertyElement(new String[]{"parentElement"});
        TestBenchElement overlayContent = listBox.getPropertyElement(new String[]{"parentElement"});
        TestBenchElement menuOwner = overlayContent.getPropertyElement(new String[]{"parentElement"});
        return (MenuBarSubMenuElement)menuOwner.getPropertyElement(new String[]{"_subMenu"}).wrap(MenuBarSubMenuElement.class);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public List<MenuBarItemElement> getSubMenuItems() {
        return this.getSubMenu().getMenuItems();
    }

    public boolean isExpanded() {
        return this.hasAttribute("expanded");
    }

    public boolean isChecked() {
        return this.hasAttribute("menu-item-checked");
    }

    private void waitForSubMenu() {
        try {
            this.waitUntil(ExpectedConditions.attributeToBe((WebElement)this, (String)"aria-expanded", (String)"true"));
        }
        catch (TimeoutException e) {
            throw new NoSuchElementException("No submenu opened for this menu item.");
        }
    }
}

