/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.flow.component.menubar.testbench.MenuBarButtonElement;
import com.vaadin.flow.component.menubar.testbench.MenuBarItemElement;
import com.vaadin.flow.component.menubar.testbench.MenuBarSubMenuElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;

@Element(value="vaadin-menu-bar")
public class MenuBarElement
extends TestBenchElement {
    public List<MenuBarButtonElement> getButtons() {
        return this.$(MenuBarButtonElement.class).all().stream().filter(element -> !this.isOverflowButton((TestBenchElement)element) && this.isVisible((TestBenchElement)element)).collect(Collectors.toList());
    }

    public MenuBarButtonElement getOverflowButton() {
        MenuBarButtonElement overflowButton = (MenuBarButtonElement)this.$(MenuBarButtonElement.class).withAttribute("slot", "overflow").first();
        if (overflowButton == null || overflowButton.hasAttribute("hidden")) {
            return null;
        }
        return overflowButton;
    }

    private boolean isOverflowButton(TestBenchElement element) {
        return "overflow".equals(element.getAttribute("slot"));
    }

    private boolean isVisible(TestBenchElement element) {
        return (Boolean)this.executeScript("return arguments[0].style.visibility !== 'hidden'", new Object[]{element});
    }

    @Deprecated(since="25.0", forRemoval=true)
    public List<MenuBarItemElement> getSubMenuItems() {
        return this.getSubMenuItems(this.getSubMenu());
    }

    @Deprecated(since="25.0", forRemoval=true)
    public List<MenuBarItemElement> getSubMenuItems(TestBenchElement subMenu) {
        return subMenu.getPropertyElement(new String[]{"_listBox"}).$(MenuBarItemElement.class).all();
    }

    @Deprecated(since="25.0", forRemoval=true)
    public MenuBarSubMenuElement getSubMenu() {
        return (MenuBarSubMenuElement)this.getPropertyElement(new String[]{"_subMenu"}).wrap(MenuBarSubMenuElement.class);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public List<TestBenchElement> getAllSubMenus() {
        return this.$("vaadin-menu-bar-submenu").withAttribute("opened").all();
    }
}

