/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.flow.component.menubar.testbench.MenuBarButtonElement;
import com.vaadin.flow.component.menubar.testbench.MenuBarItemElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Element(value="vaadin-menu-bar")
public class MenuBarElement
extends TestBenchElement {
    public static final String OVERLAY_TAG = "vaadin-menu-bar-overlay";

    public List<MenuBarButtonElement> getButtons() {
        return this.$(MenuBarButtonElement.class).all().stream().filter(element -> !this.isOverflowButton((TestBenchElement)element) && this.isVisible((TestBenchElement)element)).collect(Collectors.toList());
    }

    public MenuBarButtonElement getOverflowButton() {
        MenuBarButtonElement overflowButton = (MenuBarButtonElement)this.$(MenuBarButtonElement.class).withAttribute("slot", "overflow").first();
        if (overflowButton == null || overflowButton.hasAttribute("hidden")) {
            return null;
        }
        return overflowButton;
    }

    private boolean isOverflowButton(TestBenchElement element) {
        return "overflow".equals(element.getAttribute("slot"));
    }

    private boolean isVisible(TestBenchElement element) {
        return (Boolean)this.executeScript("return arguments[0].style.visibility !== 'hidden'", new Object[]{element});
    }

    public List<MenuBarItemElement> getSubMenuItems() {
        return this.getSubMenuItems(this.getSubMenu());
    }

    public List<MenuBarItemElement> getSubMenuItems(TestBenchElement overlay) {
        return overlay.$(MenuBarItemElement.class).all();
    }

    public TestBenchElement getSubMenu() {
        MenuBarButtonElement button = (MenuBarButtonElement)this.$(MenuBarButtonElement.class).withAttribute("expanded").withCondition(this::isVisible).first();
        return button != null ? button.getSubMenu() : null;
    }

    public List<TestBenchElement> getAllSubMenus() {
        this.waitForSubMenu();
        ArrayList<TestBenchElement> elements = new ArrayList<TestBenchElement>();
        this.getDriver().findElements(By.tagName((String)OVERLAY_TAG)).forEach(element -> elements.add((TestBenchElement)element));
        return elements;
    }

    private void waitForSubMenu() {
        this.waitUntil(ExpectedConditions.presenceOfElementLocated((By)By.tagName((String)OVERLAY_TAG)));
    }
}

