/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.MenuItemsArrayGenerator;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.menubar.MenuBarRootItem;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.JsonSerializer;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-menu-bar")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.6.3"), @NpmPackage(value="@vaadin/menu-bar", version="23.6.3"), @NpmPackage(value="@vaadin/vaadin-menu-bar", version="23.6.3"), @NpmPackage(value="@vaadin/tooltip", version="23.6.3")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./menubarConnector.js"), @JsModule(value="@vaadin/menu-bar/src/vaadin-menu-bar.js"), @JsModule(value="@vaadin/tooltip/src/vaadin-tooltip.js")})
public class MenuBar
extends Component
implements HasMenuItems,
HasSize,
HasStyle,
HasTheme,
HasEnabled {
    private MenuManager<MenuBar, MenuItem, SubMenu> menuManager;
    private MenuItemsArrayGenerator<MenuItem> menuItemsArrayGenerator = new MenuItemsArrayGenerator((Component)this);
    private MenuBarI18n i18n;
    private boolean updateScheduled = false;

    public MenuBar() {
        SerializableRunnable resetContent = new SerializableRunnable(){

            public void run() {
                MenuBar.this.resetContent();
            }
        };
        this.menuManager = new MenuManager((Component)this, resetContent, (SerializableBiFunction & Serializable)(menu, contentReset) -> new MenuBarRootItem(this, (SerializableRunnable)contentReset), MenuItem.class, null);
        this.addAttachListener((ComponentEventListener & Serializable)event -> {
            String appId = event.getUI().getInternals().getAppId();
            this.initConnector(appId);
            this.resetContent();
        });
    }

    public MenuItem addItem(String text) {
        return (MenuItem)this.menuManager.addItem(text);
    }

    public MenuItem addItem(Component component) {
        return (MenuItem)this.menuManager.addItem(component);
    }

    public MenuItem addItem(String text, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        return (MenuItem)this.menuManager.addItem(text, clickListener);
    }

    public MenuItem addItem(Component component, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        return (MenuItem)this.menuManager.addItem(component, clickListener);
    }

    public MenuItem addItem(String text, String tooltipText) {
        MenuItem item = this.addItem(text);
        this.setTooltipText(item, tooltipText);
        return item;
    }

    public MenuItem addItem(Component component, String tooltipText) {
        MenuItem item = this.addItem(component);
        this.setTooltipText(item, tooltipText);
        return item;
    }

    public MenuItem addItem(String text, String tooltipText, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        MenuItem item = this.addItem(text, clickListener);
        this.setTooltipText(item, tooltipText);
        return item;
    }

    public MenuItem addItem(Component component, String tooltipText, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        MenuItem item = this.addItem(component, clickListener);
        this.setTooltipText(item, tooltipText);
        return item;
    }

    public List<MenuItem> getItems() {
        return this.menuManager.getItems();
    }

    public void remove(MenuItem ... items) {
        this.menuManager.remove((Component[])items);
    }

    public void removeAll() {
        this.menuManager.removeAll();
    }

    public Stream<Component> getChildren() {
        return this.menuManager.getChildren();
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.getElement().setProperty("openOnHover", openOnHover);
    }

    public boolean isOpenOnHover() {
        return this.getElement().getProperty("openOnHover", false);
    }

    public void addThemeVariants(MenuBarVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(MenuBarVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(MenuBarVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(MenuBarVariant::getVariantName).collect(Collectors.toList()));
    }

    public void setReverseCollapseOrder(boolean reverseCollapseOrder) {
        this.getElement().setProperty("reverseCollapse", reverseCollapseOrder);
    }

    public boolean isReverseCollapseOrder() {
        return this.getElement().getProperty("reverseCollapse", false);
    }

    public MenuBarI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(MenuBarI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    private void setI18nWithJS() {
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        this.removeNullValuesFromJsonObject(i18nJson);
        this.getElement().executeJs("this.i18n = Object.assign({}, this.i18n, $0);", new Serializable[]{i18nJson});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    private void removeNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void resetContent() {
        this.menuItemsArrayGenerator.generate();
        this.updateButtons();
    }

    void updateButtons() {
        if (this.updateScheduled) {
            return;
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.getElement().executeJs("this.$connector.generateItems()", new Serializable[0]);
            this.updateScheduled = false;
        });
        this.updateScheduled = true;
    }

    private void initConnector(String appId) {
        this.getElement().executeJs("window.Vaadin.Flow.menubarConnector.initLazy(this, $0)", new Serializable[]{appId});
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void setTooltipText(MenuItem item, String tooltipText) {
        if (!this.getElement().getChildren().anyMatch(child -> "tooltip".equals(child.getAttribute("slot")))) {
            Element tooltipElement = new Element("vaadin-tooltip");
            tooltipElement.setAttribute("slot", "tooltip");
            tooltipElement.addAttachListener((ElementAttachListener & Serializable)e -> tooltipElement.executeJs("this.generator = ({item}) => { return (item && item.component) ? item.component.tooltip : ''; }", new Serializable[0]));
            this.getElement().appendChild(new Element[]{tooltipElement});
        }
        item.getElement().setProperty("tooltip", tooltipText);
    }

    public static class MenuBarI18n
    implements Serializable {
        private String moreOptions;

        public String getMoreOptions() {
            return this.moreOptions;
        }

        public MenuBarI18n setMoreOptions(String moreOptions) {
            this.moreOptions = moreOptions;
            return this;
        }
    }
}

