/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.migration.AnnotationsRewriteStrategy;
import com.vaadin.flow.migration.Migration;
import com.vaadin.flow.migration.MigrationConfiguration;
import com.vaadin.flow.migration.MigrationFailureException;
import com.vaadin.flow.migration.MigrationToolsException;
import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="migrate-to-p3", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class MigrateMojo
extends AbstractMojo {
    @Parameter
    private File[] resources;
    @Parameter(defaultValue="${project.build.directory}/migration")
    private File migrateFolder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/frontend")
    private File frontendDirectory;
    @Parameter(defaultValue="false")
    private boolean keepOriginal;
    @Parameter(defaultValue="true")
    private boolean ignoreModulizerErrors;
    @Parameter(property="pnpm.enable", defaultValue="false")
    private boolean pnpmEnable;
    @Parameter(defaultValue="ALWAYS")
    private AnnotationsRewriteStrategy annotationsRewrite;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MigrationConfiguration.Builder builder = new MigrationConfiguration.Builder(this.project.getBasedir());
        builder.setAnnotationRewriteStrategy(this.annotationsRewrite);
        builder.setClassFinder(FlowPluginFrontendUtils.getClassFinder(this.project));
        builder.setCompiledClassDirectory(new File(this.project.getBuild().getOutputDirectory()));
        builder.setIgnoreModulizerErrors(this.ignoreModulizerErrors);
        builder.setJavaSourceRoots((File[])this.project.getCompileSourceRoots().stream().map(File::new).toArray(File[]::new));
        builder.setKeepOriginalFiles(this.keepOriginal);
        builder.setResourceDirectories(this.getResources());
        builder.setTargetDirectory(this.frontendDirectory);
        builder.setTemporaryMigrationFolder(this.migrateFolder);
        builder.setPnpmEnabled(this.pnpmEnable);
        MigrationConfiguration configuration = builder.build();
        Migration migration = new Migration(configuration);
        try {
            migration.migrate();
        }
        catch (MigrationToolsException exception) {
            throw new MojoExecutionException(exception.getMessage(), (Exception)((Object)exception));
        }
        catch (MigrationFailureException exception) {
            throw new MojoFailureException(exception.getMessage(), (Throwable)exception);
        }
    }

    private File[] getResources() {
        if (this.resources == null) {
            File webApp = new File(this.project.getBasedir(), "src/main/webapp");
            this.resources = new File[]{webApp};
        }
        return this.resources;
    }
}

