/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.masterdetaillayout;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.masterdetaillayout.ExperimentalFeatureException;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Tag(value="vaadin-master-detail-layout")
@NpmPackage(value="@vaadin/master-detail-layout", version="25.0.0-alpha21")
@JsModule(value="@vaadin/master-detail-layout/src/vaadin-master-detail-layout.js")
public class MasterDetailLayout
extends Component
implements HasSize,
RouterLayout {
    public static final String MASTER_SLOT = "";
    private HasElement detail;
    private PendingJavaScriptResult pendingDetailsUpdate;
    private boolean hasInitialized = false;
    private OverlayMode overlayMode;

    public MasterDetailLayout() {
        this.setOverlayMode(OverlayMode.DRAWER);
    }

    public Component getMaster() {
        return SlotUtils.getElementsInSlot((HasElement)this, (String)MASTER_SLOT).findFirst().flatMap(Element::getComponent).orElse(null);
    }

    public void setMaster(Component component) {
        Objects.requireNonNull(component, "Master component cannot be null");
        SlotUtils.clearSlot((HasElement)this, (String)MASTER_SLOT);
        SlotUtils.addToSlot((HasElement)this, (String)MASTER_SLOT, (Component[])new Component[]{component});
    }

    public Component getDetail() {
        return Optional.ofNullable(this.detail).flatMap(hasElement -> hasElement.getElement().getComponent()).orElse(null);
    }

    public void setDetail(Component component) {
        this.doSetDetail((HasElement)component);
    }

    private void doSetDetail(HasElement hasElement) {
        if (hasElement != null && hasElement instanceof Text) {
            throw new IllegalArgumentException("Text as a slot content is not supported. Consider wrapping the Text inside a Div.");
        }
        if (this.detail != null) {
            this.getElement().removeVirtualChild(new Element[]{this.detail.getElement()});
        }
        this.detail = hasElement;
        if (this.detail != null) {
            this.getElement().appendVirtualChild(new Element[]{this.detail.getElement()});
        }
        this.updateDetails();
    }

    private void updateDetails() {
        if (this.pendingDetailsUpdate != null) {
            this.pendingDetailsUpdate.cancelExecution();
        }
        boolean skipTransition = !this.hasInitialized;
        this.pendingDetailsUpdate = this.getElement().executeJs("this._setDetail($0, $1)", new Object[]{this.detail != null ? this.detail.getElement() : null, skipTransition});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.checkFeatureFlag(attachEvent.getUI());
        this.updateDetails();
        attachEvent.getUI().beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> {
            this.hasInitialized = true;
        });
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.hasInitialized = false;
    }

    public String getMasterSize() {
        return this.getElement().getProperty("masterSize");
    }

    public void setMasterSize(String size) {
        this.getElement().setProperty("masterSize", size);
    }

    public void setMasterSize(float size, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.getElement().setProperty("masterSize", HasSize.getCssSize((float)size, (Unit)unit));
    }

    public String getMasterMinSize() {
        return this.getElement().getProperty("masterMinSize");
    }

    public void setMasterMinSize(String minSize) {
        this.getElement().setProperty("masterMinSize", minSize);
    }

    public void setMasterMinSize(float minSize, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.getElement().setProperty("masterMinSize", HasSize.getCssSize((float)minSize, (Unit)unit));
    }

    public String getDetailSize() {
        return this.getElement().getProperty("detailSize");
    }

    public void setDetailSize(String size) {
        this.getElement().setProperty("detailSize", size);
    }

    public void setDetailSize(float size, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.getElement().setProperty("detailSize", HasSize.getCssSize((float)size, (Unit)unit));
    }

    public String getDetailMinSize() {
        return this.getElement().getProperty("detailMinSize");
    }

    public void setDetailMinSize(String minSize) {
        this.getElement().setProperty("detailMinSize", minSize);
    }

    public void setDetailMinSize(float minSize, Unit unit) {
        Objects.requireNonNull(unit, "Unit cannot be null");
        this.getElement().setProperty("detailMinSize", HasSize.getCssSize((float)minSize, (Unit)unit));
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        if (orientation != null) {
            return Orientation.valueOf(orientation.toUpperCase());
        }
        return Orientation.HORIZONTAL;
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.getElement().setProperty("orientation", orientation.name().toLowerCase(Locale.ENGLISH));
    }

    public Containment getContainment() {
        String containment = this.getElement().getProperty("containment");
        if (containment != null) {
            return Containment.valueOf(containment.toUpperCase());
        }
        return Containment.LAYOUT;
    }

    public void setContainment(Containment containment) {
        Objects.requireNonNull(containment, "Containment cannot be null");
        this.getElement().setProperty("containment", containment.name().toLowerCase(Locale.ENGLISH));
    }

    public OverlayMode getOverlayMode() {
        return this.overlayMode;
    }

    public void setOverlayMode(OverlayMode mode) {
        Objects.requireNonNull(mode, "OverlayMode cannot be null");
        this.overlayMode = mode;
        this.getElement().setProperty("stackOverlay", mode == OverlayMode.STACK);
    }

    public boolean isForceOverlay() {
        return this.getElement().getProperty("forceOverlay", false);
    }

    public void setForceOverlay(boolean forceOverlay) {
        this.getElement().setProperty("forceOverlay", forceOverlay);
    }

    public boolean isAnimationEnabled() {
        return !this.getElement().getProperty("noAnimation", false);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.getElement().setProperty("noAnimation", !enabled);
    }

    public Registration addBackdropClickListener(ComponentEventListener<BackdropClickEvent> listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        return ComponentUtil.addListener((Component)this, BackdropClickEvent.class, listener);
    }

    public Registration addDetailEscapePressListener(ComponentEventListener<DetailEscapePressEvent> listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        return ComponentUtil.addListener((Component)this, DetailEscapePressEvent.class, listener);
    }

    public void showRouterLayoutContent(HasElement content) {
        this.doSetDetail(content);
    }

    public void removeRouterLayoutContent(HasElement oldContent) {
        this.doSetDetail(null);
    }

    private void checkFeatureFlag(UI ui) {
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)ui.getSession().getService().getContext());
        boolean enabled = featureFlags.isEnabled(FeatureFlags.MASTER_DETAIL_LAYOUT_COMPONENT);
        if (!enabled) {
            throw new ExperimentalFeatureException();
        }
    }

    public static enum OverlayMode {
        DRAWER,
        STACK;

    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum Containment {
        LAYOUT,
        VIEWPORT;

    }

    @DomEvent(value="backdrop-click")
    public static class BackdropClickEvent
    extends ComponentEvent<MasterDetailLayout> {
        public BackdropClickEvent(MasterDetailLayout source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="detail-escape-press")
    public static class DetailEscapePressEvent
    extends ComponentEvent<MasterDetailLayout> {
        public DetailEscapePressEvent(MasterDetailLayout source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

