/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.geometry;

import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.geometry.SimpleGeometry;
import java.util.Arrays;
import java.util.List;

public class LineString
extends SimpleGeometry {
    private Coordinate[] coordinates;

    public LineString(List<Coordinate> coordinates) {
        LineString.validateCoordinates(coordinates);
        this.coordinates = coordinates.toArray(new Coordinate[0]);
    }

    public LineString(Coordinate ... coordinates) {
        LineString.validateCoordinates(coordinates);
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "ol/geom/LineString";
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        LineString.validateCoordinates(coordinates);
        this.coordinates = coordinates.toArray(new Coordinate[0]);
        this.markAsDirty();
    }

    public void setCoordinates(Coordinate ... coordinates) {
        LineString.validateCoordinates(coordinates);
        this.coordinates = coordinates;
        this.markAsDirty();
    }

    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void translate(double deltaX, double deltaY) {
        Coordinate[] nextCoordinates = (Coordinate[])Arrays.stream(this.coordinates).map(coordinate -> new Coordinate(coordinate.getX() + deltaX, coordinate.getY() + deltaY)).toArray(Coordinate[]::new);
        this.setCoordinates(nextCoordinates);
    }

    private static void validateCoordinates(Coordinate[] coordinates) {
        if (coordinates == null || coordinates.length < 2) {
            throw new IllegalArgumentException("LineString must have at least 2 coordinates");
        }
    }

    private static void validateCoordinates(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.size() < 2) {
            throw new IllegalArgumentException("LineString must have at least 2 coordinates");
        }
    }
}

