/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.map.MapVariant;
import com.vaadin.flow.component.map.configuration.Configuration;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Extent;
import com.vaadin.flow.component.map.configuration.View;
import com.vaadin.flow.component.map.configuration.layer.VectorLayer;
import com.vaadin.flow.component.map.events.MapClickEvent;
import com.vaadin.flow.component.map.events.MapClusterClickEvent;
import com.vaadin.flow.component.map.events.MapFeatureClickEvent;
import com.vaadin.flow.component.map.events.MapFeatureDropEvent;
import com.vaadin.flow.component.map.events.MapViewMoveEndEvent;
import com.vaadin.flow.component.map.serialization.MapSerializer;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import tools.jackson.databind.node.BaseJsonNode;

public abstract class MapBase
extends Component
implements HasSize,
HasStyle,
HasThemeVariant<MapVariant> {
    private final Configuration configuration = new Configuration();
    private transient MapSerializer serializer;
    private StateTree.ExecutionRegistration pendingConfigurationSync;

    protected MapBase() {
        this.configuration.addPropertyChangeListener(this::configurationPropertyChange);
        this.registerEventListeners();
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public View getView() {
        return this.configuration.getView();
    }

    public void setView(View view) {
        this.configuration.setView(view);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("window.Vaadin.Flow.mapConnector.init(this)", new Object[0]);
        this.configuration.deepMarkAsDirty();
        this.requestConfigurationSync();
    }

    private void requestConfigurationSync() {
        if (this.pendingConfigurationSync != null) {
            return;
        }
        this.getUI().ifPresent(ui -> {
            this.pendingConfigurationSync = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingConfigurationSync = null;
                this.synchronizeConfiguration();
            });
        });
    }

    private void synchronizeConfiguration() {
        LinkedHashSet changedObjects = new LinkedHashSet();
        this.configuration.collectChanges(changedObjects::add);
        BaseJsonNode jsonChanges = this.getSerializer().toJson(changedObjects);
        this.getElement().executeJs("this.$connector.synchronize($0)", new Object[]{jsonChanges});
    }

    private void configurationPropertyChange(PropertyChangeEvent e) {
        this.requestConfigurationSync();
    }

    private void registerEventListeners() {
        this.addViewMoveEndListener((ComponentEventListener<MapViewMoveEndEvent>)(ComponentEventListener & Serializable)event -> {
            double rotation = event.getRotation();
            double zoom = event.getZoom();
            Coordinate center = event.getCenter();
            Extent extent = event.getExtent();
            this.getView().updateInternalViewState(center, rotation, zoom, extent);
        });
        this.addFeatureDropListener((ComponentEventListener<MapFeatureDropEvent>)(ComponentEventListener & Serializable)event -> {
            double deltaX = event.getCoordinate().getX() - event.getStartCoordinate().getX();
            double deltaY = event.getCoordinate().getY() - event.getStartCoordinate().getY();
            if (event.getFeature() != null && event.getFeature().getGeometry() != null) {
                event.getFeature().getGeometry().translate(deltaX, deltaY);
            }
        });
    }

    MapSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new MapSerializer(this);
        }
        return this.serializer;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Registration addViewMoveEndEventListener(ComponentEventListener<MapViewMoveEndEvent> listener) {
        return this.addViewMoveEndListener(listener);
    }

    public Registration addViewMoveEndListener(ComponentEventListener<MapViewMoveEndEvent> listener) {
        return this.addListener(MapViewMoveEndEvent.class, listener);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public Registration addClickEventListener(ComponentEventListener<MapClickEvent> listener) {
        return this.addClickListener(listener);
    }

    public Registration addClickListener(ComponentEventListener<MapClickEvent> listener) {
        return this.addListener(MapClickEvent.class, listener);
    }

    public Registration addFeatureClickListener(VectorLayer layer, ComponentEventListener<MapFeatureClickEvent> listener) {
        return this.addListener(MapFeatureClickEvent.class, (ComponentEventListener & Serializable)event -> {
            if (!Objects.equals(layer, event.getLayer())) {
                return;
            }
            listener.onComponentEvent(event);
        });
    }

    public Registration addFeatureClickListener(ComponentEventListener<MapFeatureClickEvent> listener) {
        return this.addListener(MapFeatureClickEvent.class, listener);
    }

    public Registration addClusterClickListener(ComponentEventListener<MapClusterClickEvent> listener) {
        return this.addListener(MapClusterClickEvent.class, listener);
    }

    public Registration addFeatureDropListener(ComponentEventListener<MapFeatureDropEvent> listener) {
        return this.addListener(MapFeatureDropEvent.class, listener);
    }
}

