/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.configuration.Configuration;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.controls.AttributionControl;
import com.vaadin.flow.component.map.configuration.controls.ScaleControl;
import com.vaadin.flow.component.map.configuration.controls.ZoomControl;
import com.vaadin.flow.component.map.configuration.layer.FeatureLayer;
import com.vaadin.flow.component.map.configuration.layer.Layer;
import com.vaadin.flow.component.map.configuration.layer.TileLayer;
import com.vaadin.flow.component.map.configuration.source.OSMSource;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-map")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/map", version="25.1.0-alpha9"), @NpmPackage(value="ol", version="10.6.1"), @NpmPackage(value="proj4", version="2.17.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/map/src/vaadin-map.js"), @JsModule(value="./vaadin-map/mapConnector.js")})
public class Map
extends MapBase {
    private Layer backgroundLayer;
    private final FeatureLayer featureLayer;
    private final Controls controls = new Controls();

    public static void setUserProjection(String projection) {
        UI.getCurrentOrThrow().getPage().executeJs("window.Vaadin.Flow.mapConnector.setUserProjection($0)", new Object[]{projection});
    }

    public static void defineProjection(String projectionName, String wksDefinition) {
        UI.getCurrentOrThrow().getPage().executeJs("window.Vaadin.Flow.mapConnector.defineProjection($0, $1)", new Object[]{projectionName, wksDefinition});
    }

    public Map() {
        OSMSource source = new OSMSource();
        TileLayer backgroundLayer = new TileLayer();
        backgroundLayer.setSource(source);
        this.setBackgroundLayer(backgroundLayer);
        this.featureLayer = new FeatureLayer();
        this.addLayer(this.featureLayer);
        this.featureLayer.setzIndex(100);
        this.getConfiguration().addControl(this.controls.attributionControl);
        this.getConfiguration().addControl(this.controls.scaleControl);
        this.getConfiguration().addControl(this.controls.zoomControl);
    }

    public Configuration getRawConfiguration() {
        return this.getConfiguration();
    }

    public Layer getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public void setBackgroundLayer(Layer backgroundLayer) {
        Objects.requireNonNull(backgroundLayer);
        if (this.backgroundLayer != null) {
            this.getConfiguration().removeLayer(this.backgroundLayer);
        }
        this.backgroundLayer = backgroundLayer;
        this.getConfiguration().prependLayer(backgroundLayer);
    }

    public FeatureLayer getFeatureLayer() {
        return this.featureLayer;
    }

    public void addLayer(Layer layer) {
        this.getConfiguration().addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this.getConfiguration().removeLayer(layer);
    }

    public Coordinate getCenter() {
        return this.getView().getCenter();
    }

    public void setCenter(Coordinate center) {
        this.getView().setCenter(center);
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.getView().setZoom(zoom);
    }

    public void zoomToFit(List<Feature> features) {
        this.zoomToFit(features, 50, 400);
    }

    public void zoomToFit(List<Feature> features, int padding, int duration) {
        ArrayNode featureIds = JacksonUtils.createArrayNode();
        features.forEach(feature -> featureIds.add(feature.getId()));
        ObjectNode options = JacksonUtils.createObjectNode();
        options.put("padding", padding);
        options.put("duration", duration);
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.getElement().executeJs("this.$connector.zoomToFit($0, $1)", new Object[]{featureIds, options})));
    }

    public Controls getControls() {
        return this.controls;
    }

    public static final class Controls
    implements Serializable {
        private final AttributionControl attributionControl = new AttributionControl();
        private final ScaleControl scaleControl = new ScaleControl();
        private final ZoomControl zoomControl = new ZoomControl();

        private Controls() {
            this.attributionControl.setVisible(true);
            this.scaleControl.setVisible(false);
            this.zoomControl.setVisible(true);
        }

        public AttributionControl getAttribution() {
            return this.attributionControl;
        }

        public ScaleControl getScale() {
            return this.scaleControl;
        }

        public ZoomControl getZoom() {
            return this.zoomControl;
        }
    }
}

