/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.controls;

import com.vaadin.flow.component.map.configuration.controls.Control;
import java.util.Objects;

public class ScaleControl
extends Control {
    private int minWidth = 64;
    private Integer maxWidth;
    private Unit units = Unit.METRIC;
    private DisplayMode displayMode = DisplayMode.LINE;
    private int scaleBarSteps = 4;
    private boolean scaleBarRatioVisible = false;

    @Override
    public String getType() {
        return "ol/control/ScaleLine";
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.markAsDirty();
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
        this.markAsDirty();
    }

    public Unit getUnits() {
        return this.units;
    }

    public void setUnits(Unit units) {
        this.units = Objects.requireNonNull(units, "Units cannot be null");
        this.markAsDirty();
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = Objects.requireNonNull(displayMode, "Display mode cannot be null");
        this.markAsDirty();
    }

    public int getScaleBarSteps() {
        return this.scaleBarSteps;
    }

    public void setScaleBarSteps(int scaleBarSteps) {
        this.scaleBarSteps = scaleBarSteps;
        this.markAsDirty();
    }

    public boolean isScaleBarRatioVisible() {
        return this.scaleBarRatioVisible;
    }

    public void setScaleBarRatioVisible(boolean scaleBarRatioVisible) {
        this.scaleBarRatioVisible = scaleBarRatioVisible;
        this.markAsDirty();
    }

    public static enum Unit {
        DEGREES,
        IMPERIAL,
        NAUTICAL,
        METRIC,
        US;

    }

    public static enum DisplayMode {
        LINE,
        BAR;

    }
}

