/**
 * Copyright 2000-2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See {@literal <https://vaadin.com/commercial-license-and-service-terms>} for the full
 * license.
 */
package com.vaadin.flow.component.map;

import com.vaadin.flow.component.shared.ThemeVariant;

/**
 * Set of theme variants applicable for the {@code vaadin-map} component.
 */
public enum MapVariant implements ThemeVariant {
    /**
     * @deprecated Use {@link #NO_BORDER} instead.
     */
    @Deprecated(since = "25.0", forRemoval = true)
    BORDERLESS("no-border"),
    LUMO_NO_BORDER("no-border"),
    /**
     * @deprecated Use {@link #NO_BORDER} instead.
     */
    @Deprecated
    AURA_NO_BORDER("no-border"),
    NO_BORDER("no-border");

    private final String variant;

    MapVariant(String variant) {
        this.variant = variant;
    }

    /**
     * Gets the variant name.
     *
     * @return variant name
     */
    public String getVariantName() {
        return variant;
    }
}
