/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.map.Map;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.events.FeatureEventDetails;
import com.vaadin.flow.component.map.events.MapEventUtil;
import com.vaadin.flow.component.map.events.MouseEventDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.node.ArrayNode;

@DomEvent(value="map-cluster-click")
public class MapClusterClickEvent
extends ComponentEvent<MapBase> {
    private final List<FeatureEventDetails> features;
    private final MouseEventDetails details;

    public MapClusterClickEvent(Map source, boolean fromClient, @EventData(value="event.detail.features.map(feature => feature.id)") ArrayNode featureIds, @EventData(value="event.detail.layer.id") String layerId, @EventData(value="event.detail.originalEvent.pageX") int pageX, @EventData(value="event.detail.originalEvent.pageY") int pageY, @EventData(value="event.detail.originalEvent.altKey") boolean altKey, @EventData(value="event.detail.originalEvent.ctrlKey") boolean ctrlKey, @EventData(value="event.detail.originalEvent.metaKey") boolean metaKey, @EventData(value="event.detail.originalEvent.shiftKey") boolean shiftKey, @EventData(value="event.detail.originalEvent.button") int button) {
        super((Component)source, fromClient);
        ArrayList<FeatureEventDetails> features = new ArrayList<FeatureEventDetails>();
        for (int i = 0; i < featureIds.size(); ++i) {
            String featureId = featureIds.get(i).asString();
            FeatureEventDetails featureEventDetails = MapEventUtil.getFeatureEventDetails(source.getRawConfiguration(), layerId, featureId);
            features.add(featureEventDetails);
        }
        this.features = Collections.unmodifiableList(features);
        this.details = new MouseEventDetails();
        this.details.setAbsoluteX(pageX);
        this.details.setAbsoluteY(pageY);
        this.details.setButton(MouseEventDetails.MouseButton.of(button));
        this.details.setAltKey(altKey);
        this.details.setCtrlKey(ctrlKey);
        this.details.setMetaKey(metaKey);
        this.details.setShiftKey(shiftKey);
    }

    public List<FeatureEventDetails> getFeatures() {
        return this.features;
    }

    public MouseEventDetails getMouseDetails() {
        return this.details;
    }
}

