/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.feature;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.geometry.Polygon;
import com.vaadin.flow.component.map.configuration.geometry.SimpleGeometry;
import com.vaadin.flow.component.map.configuration.style.Fill;
import com.vaadin.flow.component.map.configuration.style.Stroke;
import com.vaadin.flow.component.map.configuration.style.Style;
import java.util.List;
import java.util.Objects;

public class PolygonFeature
extends Feature {
    public PolygonFeature() {
        this(List.of(new Coordinate(0.0, 0.0)));
    }

    public PolygonFeature(List<Coordinate> coordinates) {
        this.setGeometry(new Polygon(coordinates));
        this.setStyle(PolygonFeature.createDefaultStyle());
    }

    @JsonIgnore
    public Coordinate[][] getCoordinates() {
        return this.getGeometry().getCoordinates();
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        Objects.requireNonNull(coordinates);
        this.getGeometry().setCoordinates(coordinates);
    }

    public void setCoordinates(Coordinate[][] coordinates) {
        Objects.requireNonNull(coordinates);
        this.getGeometry().setCoordinates(coordinates);
    }

    @Override
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Polygon getGeometry() {
        return (Polygon)super.getGeometry();
    }

    @Override
    public void setGeometry(SimpleGeometry geometry) {
        Objects.requireNonNull(geometry);
        if (!(geometry instanceof Polygon)) {
            throw new IllegalArgumentException("Geometry must be a polygon");
        }
        super.setGeometry(geometry);
    }

    private static Style createDefaultStyle() {
        Style style = new Style();
        style.setStroke(new Stroke("hsl(214, 100%, 48%)", 2.0));
        style.setFill(new Fill("hsla(214, 100%, 60%, 0.13)"));
        return style;
    }
}

