/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.geometry;

import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.geometry.SimpleGeometry;
import java.util.Arrays;
import java.util.List;

public class Polygon
extends SimpleGeometry {
    private Coordinate[][] coordinates;

    public Polygon(List<Coordinate> coordinates) {
        Polygon.validateCoordinates(coordinates);
        this.coordinates = new Coordinate[][]{coordinates.toArray(new Coordinate[0])};
    }

    public Polygon(Coordinate[][] coordinates) {
        Polygon.validateCoordinates(coordinates);
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "ol/geom/Polygon";
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        Polygon.validateCoordinates(coordinates);
        this.coordinates = new Coordinate[][]{coordinates.toArray(new Coordinate[0])};
        this.markAsDirty();
    }

    public void setCoordinates(Coordinate[][] coordinates) {
        Polygon.validateCoordinates(coordinates);
        this.coordinates = coordinates;
        this.markAsDirty();
    }

    public Coordinate[][] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void translate(double deltaX, double deltaY) {
        Coordinate[][] nextCoordinates = (Coordinate[][])Arrays.stream(this.coordinates).map(linearRing -> Polygon.translateLinearRing(deltaX, deltaY, linearRing)).toArray(x$0 -> new Coordinate[x$0][]);
        this.setCoordinates(nextCoordinates);
    }

    private static Coordinate[] translateLinearRing(double deltaX, double deltaY, Coordinate[] source) {
        return (Coordinate[])Arrays.stream(source).map(coordinate -> Polygon.translateCoordinates(deltaX, deltaY, coordinate)).toArray(Coordinate[]::new);
    }

    private static Coordinate translateCoordinates(double deltaX, double deltaY, Coordinate source) {
        return new Coordinate(source.getX() + deltaX, source.getY() + deltaY);
    }

    private static void validateCoordinates(Coordinate[][] coordinates) {
        if (coordinates == null || coordinates.length == 0) {
            throw new IllegalArgumentException("Coordinates must not be null or empty");
        }
        for (Coordinate[] linearRing : coordinates) {
            if (linearRing != null && linearRing.length != 0) continue;
            throw new IllegalArgumentException("Coordinates of the linearRing must not be null or empty");
        }
    }

    private static void validateCoordinates(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.isEmpty()) {
            throw new IllegalArgumentException("Coordinates must not be null or empty");
        }
    }
}

