/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login.testbench;

import com.vaadin.flow.component.button.testbench.ButtonElement;
import com.vaadin.flow.component.login.testbench.Login;
import com.vaadin.flow.component.textfield.testbench.PasswordFieldElement;
import com.vaadin.flow.component.textfield.testbench.TextFieldElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

@Element(value="vaadin-login-overlay")
public class LoginOverlayElement
extends TestBenchElement
implements Login {
    public TestBenchElement getLoginOverlayWrapper() {
        return this.$("vaadin-login-overlay-wrapper").first();
    }

    public boolean isOpened() {
        try {
            return this.getPropertyBoolean(new String[]{"opened"});
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    @Override
    public TextFieldElement getUsernameField() {
        return (TextFieldElement)this.$(TextFieldElement.class).id("vaadinLoginUsername");
    }

    @Override
    public PasswordFieldElement getPasswordField() {
        return (PasswordFieldElement)this.$(PasswordFieldElement.class).id("vaadinLoginPassword");
    }

    @Override
    public ButtonElement getSubmitButton() {
        return (ButtonElement)this.$(ButtonElement.class).withAttribute("slot", "submit").first();
    }

    @Override
    public ButtonElement getForgotPasswordButton() {
        return (ButtonElement)this.$(ButtonElement.class).withAttribute("slot", "forgot-password").first();
    }

    private TestBenchElement getFormWrapper() {
        return this.$("vaadin-login-form-wrapper").first();
    }

    @Override
    public TestBenchElement getErrorComponent() {
        return this.getFormWrapper().$(TestBenchElement.class).withAttribute("part", "error-message").first();
    }

    @Override
    public void submit() {
        this.getSubmitButton().click();
    }

    @Override
    public void forgotPassword() {
        this.getForgotPasswordButton().click();
    }

    public String getTitle() {
        return this.getTitleComponent().getPropertyString(new String[]{"textContent"});
    }

    public String getDescription() {
        return this.getLoginOverlayWrapper().$(TestBenchElement.class).withAttribute("part", "description").first().getText();
    }

    public TestBenchElement getTitleComponent() {
        return this.findElements(By.cssSelector((String)"[slot='%s']".formatted("title"))).stream().findFirst().orElse(null);
    }

    @Override
    public String getFormTitle() {
        return this.$(TestBenchElement.class).withAttribute("part", "form-title").first().getText();
    }

    @Override
    public String getErrorMessageTitle() {
        return this.getErrorComponent().$(TestBenchElement.class).withAttribute("part", "error-message-title").first().getText();
    }

    @Override
    public String getErrorMessage() {
        return this.getErrorComponent().$(TestBenchElement.class).withAttribute("part", "error-message-description").first().getText();
    }

    @Override
    public String getAdditionalInformation() {
        return this.getFormWrapper().$(TestBenchElement.class).withAttribute("part", "footer").first().$("div").first().getText();
    }

    public boolean isEnabled() {
        return !Boolean.TRUE.equals(this.getPropertyBoolean(new String[]{"disabled"})) && super.isEnabled();
    }
}

