/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login.testbench;

import com.vaadin.flow.component.button.testbench.ButtonElement;
import com.vaadin.flow.component.login.testbench.Login;
import com.vaadin.flow.component.login.testbench.LoginFormElement;
import com.vaadin.flow.component.textfield.testbench.PasswordFieldElement;
import com.vaadin.flow.component.textfield.testbench.TextFieldElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import org.openqa.selenium.StaleElementReferenceException;

@Element(value="vaadin-login-overlay")
public class LoginOverlayElement
extends TestBenchElement
implements Login {
    public TestBenchElement getLoginOverlayWrapper() {
        return this.$("vaadin-login-overlay-wrapper").onPage().waitForFirst();
    }

    public LoginFormElement getLoginForm() {
        return (LoginFormElement)this.getLoginOverlayWrapper().$(LoginFormElement.class).first();
    }

    public boolean isOpened() {
        try {
            return this.getPropertyBoolean(new String[]{"opened"});
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    @Override
    public TextFieldElement getUsernameField() {
        return this.getLoginForm().getUsernameField();
    }

    @Override
    public PasswordFieldElement getPasswordField() {
        return this.getLoginForm().getPasswordField();
    }

    @Override
    public ButtonElement getSubmitButton() {
        return this.getLoginForm().getSubmitButton();
    }

    @Override
    public ButtonElement getForgotPasswordButton() {
        return this.getLoginForm().getForgotPasswordButton();
    }

    @Override
    public TestBenchElement getErrorComponent() {
        return this.getLoginForm().getErrorComponent();
    }

    @Override
    public void submit() {
        this.getSubmitButton().click();
    }

    @Override
    public void forgotPassword() {
        this.getForgotPasswordButton().click();
    }

    public String getTitle() {
        if (this.hasTitleComponent()) {
            return this.getTitleComponent().getText();
        }
        return this.getLoginOverlayWrapper().$(TestBenchElement.class).attribute("part", "title").first().getPropertyString(new String[]{"textContent"});
    }

    public String getDescription() {
        return this.getLoginOverlayWrapper().$(TestBenchElement.class).attribute("part", "brand").first().$("p").first().getText();
    }

    public boolean hasTitleComponent() {
        return this.getLoginOverlayWrapper().$(TestBenchElement.class).attribute("slot", "title").exists();
    }

    public TestBenchElement getTitleComponent() {
        if (!this.hasTitleComponent()) {
            return null;
        }
        return this.getLoginOverlayWrapper().$(TestBenchElement.class).attribute("slot", "title").first();
    }

    @Override
    public String getFormTitle() {
        return this.getLoginForm().getFormTitle();
    }

    @Override
    public String getErrorMessageTitle() {
        return this.getLoginForm().getErrorMessageTitle();
    }

    @Override
    public String getErrorMessage() {
        return this.getLoginForm().getErrorMessage();
    }

    @Override
    public String getAdditionalInformation() {
        return this.getLoginForm().getAdditionalInformation();
    }

    public boolean isEnabled() {
        return this.getLoginForm().isEnabled();
    }
}

