/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login.examples;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.component.login.LoginOverlay;
import com.vaadin.flow.component.login.examples.AbstractView;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@Route
public class OverlayView
extends AbstractView {
    private final LoginOverlay login = new LoginOverlay();

    public OverlayView() {
        this.init((AbstractLogin)this.login);
        this.login.addLoginListener((ComponentEventListener & Serializable)e -> this.login.close());
        NativeButton button = new NativeButton("open");
        button.setId("open");
        button.addClickListener((ComponentEventListener & Serializable)e -> this.login.setOpened(true));
        this.add(new Component[]{button});
    }

    public void setParameter(BeforeEvent beforeEvent, @OptionalParameter String s) {
        super.setParameter(beforeEvent, s);
        if ("component-title".equals(s)) {
            Div div = new Div(new Component[]{VaadinIcon.VAADIN_H.create(), new H3("Component title")});
            div.setId("componentTitle");
            this.login.setTitle((Component)div);
            NativeButton removeCustomTitle = new NativeButton("Remove title");
            removeCustomTitle.setId("removeCustomTitle");
            removeCustomTitle.addClickListener((ComponentEventListener & Serializable)e -> this.login.setTitle("Make title string again"));
            this.add(new Component[]{removeCustomTitle});
        }
        if ("property-title-description".equals(s)) {
            this.login.setTitle("Property title");
            this.login.setDescription("Property description");
        }
        if ("ptbr".equals(s)) {
            this.login.setI18n(this.getPtBrI18n());
        }
    }

    private LoginI18n getPtBrI18n() {
        LoginI18n i18n = LoginI18n.createDefault();
        i18n.setHeader(new LoginI18n.Header());
        i18n.getHeader().setTitle("Nome do aplicativo");
        i18n.getHeader().setDescription("Descri\u00e7\u00e3o do aplicativo");
        i18n.getForm().setUsername("Usu\u00e1rio");
        i18n.getForm().setTitle("Acesse a sua conta");
        i18n.getForm().setSubmit("Entrar");
        i18n.getForm().setPassword("Senha");
        i18n.getForm().setForgotPassword("Esqueci minha senha");
        i18n.getErrorMessage().setTitle("Usu\u00e1rio/senha inv\u00e1lidos");
        i18n.getErrorMessage().setMessage("Confira seu usu\u00e1rio e senha e tente novamente.");
        i18n.setAdditionalInformation("Caso necessite apresentar alguma informa\u00e7\u00e3o extra para o usu\u00e1rio (como credenciais padr\u00e3o), este \u00e9 o lugar.");
        return i18n;
    }
}

