/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login.examples;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractView
extends Div
implements HasUrlParameter<String> {
    private AbstractLogin login;

    public AbstractView() {
        this.setSizeFull();
    }

    public void init(AbstractLogin login) {
        this.login = login;
        Div info = new Div();
        info.setId("info");
        login.addForgotPasswordListener((ComponentEventListener & Serializable)e -> info.setText("Forgot password button pressed"));
        AtomicInteger failCounter = new AtomicInteger(0);
        login.addLoginListener((ComponentEventListener & Serializable)e -> {
            if ("username".equals(e.getUsername()) && "password".equals(e.getPassword())) {
                failCounter.set(0);
                info.setText("Successful login");
                return;
            }
            login.setError(true);
            if (failCounter.incrementAndGet() > 2) {
                LoginI18n i18n = LoginI18n.createDefault();
                i18n.getErrorMessage().setTitle("You made too many attempts");
                i18n.getErrorMessage().setMessage("Your account was suspended for a while");
                login.setI18n(i18n);
                login.setEnabled(false);
            }
        });
        this.add(new Component[]{login, info});
    }

    public void setParameter(BeforeEvent beforeEvent, @OptionalParameter String s) {
        this.login.setEnabled(!"disable-login".equals(s));
        if ("no-forgot-password".equals(s)) {
            this.login.setForgotPasswordButtonVisible(false);
        }
    }
}

