/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.internal.OverlayAutoAddController;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-login-overlay")
@NpmPackage(value="@vaadin/login", version="25.0.0-alpha19")
@JsModule(value="@vaadin/login/src/vaadin-login-overlay.js")
public class LoginOverlay
extends AbstractLogin
implements HasStyle {
    private Component title;
    private LoginOverlayFooter footer;
    private LoginOverlayCustomFormArea customFormArea;

    public LoginOverlay() {
        this.init();
    }

    public LoginOverlay(LoginI18n i18n) {
        super(i18n);
        this.init();
    }

    private void init() {
        OverlayAutoAddController autoAddController = new OverlayAutoAddController((Component)this);
        autoAddController.setSkipOnNavigation(true);
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.setEnabled(true);
        }
        this.getElement().setProperty("opened", opened);
    }

    public void setTitle(String title) {
        this.setTitle((Component)null);
        this.getElement().setProperty("title", title);
    }

    @Synchronize(property="title", value={"title-changed"})
    public String getTitleAsText() {
        if (this.title != null) {
            return this.title.getElement().getText();
        }
        return this.getElement().getProperty("title");
    }

    public void setTitle(Component title) {
        if (this.title != null) {
            this.title.getElement().removeFromParent();
        }
        this.title = title;
        if (title == null) {
            return;
        }
        SlotUtils.addToSlot((HasElement)this, (String)"title", (Component[])new Component[]{title});
    }

    public Component getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.getElement().setProperty("description", description);
    }

    @Synchronize(property="description", value={"description-changed"})
    public String getDescription() {
        return this.getElement().getProperty("description");
    }

    public LoginOverlayCustomFormArea getCustomFormArea() {
        if (this.customFormArea == null) {
            this.customFormArea = new LoginOverlayCustomFormArea(this);
        }
        return this.customFormArea;
    }

    public LoginOverlayFooter getFooter() {
        if (this.footer == null) {
            this.footer = new LoginOverlayFooter(this);
        }
        return this.footer;
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("LoginOverlay does not support adding styles to overlay wrapper");
    }

    public static final class LoginOverlayCustomFormArea
    extends LoginOverlayContent {
        private LoginOverlayCustomFormArea(LoginOverlay overlay) {
            super("custom-form-area", overlay);
        }
    }

    public static final class LoginOverlayFooter
    extends LoginOverlayContent {
        private LoginOverlayFooter(LoginOverlay overlay) {
            super("footer", overlay);
        }
    }

    static abstract class LoginOverlayContent
    implements Serializable {
        private final LoginOverlay overlay;
        private final String slot;

        protected LoginOverlayContent(String slot, LoginOverlay overlay) {
            this.slot = slot;
            this.overlay = overlay;
        }

        public void add(Component ... components) {
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to add cannot be null");
                SlotUtils.addToSlot((HasElement)this.overlay, (String)this.slot, (Component[])new Component[]{component});
            }
        }

        public void remove(Component ... components) {
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to remove cannot be null");
                Element element = component.getElement();
                if (!this.overlay.getElement().equals((Object)element.getParent()) || !Objects.equals(element.getAttribute("slot"), this.slot)) continue;
                element.removeAttribute("slot");
                this.overlay.getElement().removeChild(new Element[]{element});
            }
        }

        public void removeAll() {
            SlotUtils.clearSlot((HasElement)this.overlay, (String)this.slot);
        }
    }
}

