/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox.testbench;

import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-list-box")
public class ListBoxElement
extends TestBenchElement
implements HasSelectByText {
    public void selectByText(String text) {
        this.getItems().filter(e -> Objects.equals(text, e.getText())).findFirst().orElseThrow(NoSuchElementException::new).click();
    }

    public String getSelectedText() {
        return this.getItems().filter(i -> i.getDomAttribute("selected") != null).findFirst().map(WebElement::getText).orElse(null);
    }

    public List<String> getOptions() {
        return this.getItems().map(WebElement::getText).collect(Collectors.toList());
    }

    private Stream<WebElement> getItems() {
        return this.findElements(By.tagName((String)"vaadin-item")).stream();
    }
}

