/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.listbox.ListBoxBase;
import com.vaadin.flow.component.listbox.VaadinItem;
import com.vaadin.flow.data.selection.SingleSelect;
import java.util.List;
import java.util.stream.IntStream;

public class ListBox<T>
extends ListBoxBase<ListBox<T>, T, T>
implements SingleSelect<ListBox<T>, T> {
    public ListBox() {
        super("selected", Integer.class, null, ListBox::presentationToModel, ListBox::modelToPresentation);
    }

    private static <T> T presentationToModel(ListBox<T> listBox, Integer selectedIndex) {
        if (selectedIndex == null || selectedIndex == -1) {
            return null;
        }
        return (T)listBox.getItemComponents().get(selectedIndex).getItem();
    }

    private static <T> Integer modelToPresentation(ListBox<T> listBox, T selectedItem) {
        if (selectedItem == null) {
            return -1;
        }
        List itemComponents = listBox.getItemComponents();
        return IntStream.range(0, itemComponents.size()).filter(idx -> listBox.getItemId(selectedItem).equals(listBox.getItemId(((VaadinItem)((Object)((Object)itemComponents.get(idx)))).getItem()))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find given value from the item set"));
    }

    protected boolean valueEquals(T value1, T value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.getItemId(value1).equals(this.getItemId(value2));
    }
}

