/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.liferay;

import com.vaadin.osgi.liferay.OsgiUIProvider;
import com.vaadin.osgi.liferay.OsgiVaadinPortlet;
import com.vaadin.osgi.liferay.VaadinLiferayPortletConfiguration;
import com.vaadin.osgi.resources.VaadinResourceService;
import com.vaadin.ui.UI;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.portlet.Portlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class PortletUIServiceTrackerCustomizer
implements ServiceTrackerCustomizer<UI, ServiceObjects<UI>> {
    private static final String RESOURCE_PATH_PREFIX = "/o/%s";
    private static final String DISPLAY_CATEGORY = "com.liferay.portlet.display-category";
    private static final String VAADIN_CATEGORY = "category.vaadin";
    private static final String PORTLET_NAME = "javax.portlet.name";
    private static final String DISPLAY_NAME = "javax.portlet.display-name";
    private static final String PORTLET_SECURITY_ROLE = "javax.portlet.security-role-ref";
    private static final String VAADIN_RESOURCE_PATH = "javax.portlet.init-param.vaadin.resources.path";
    private Map<ServiceReference<UI>, ServiceRegistration<Portlet>> portletRegistrations = new HashMap<ServiceReference<UI>, ServiceRegistration<Portlet>>();
    private VaadinResourceService service;
    private Optional<LogService> logService;

    PortletUIServiceTrackerCustomizer(VaadinResourceService service, LogService logService) {
        this.service = service;
        this.logService = Optional.ofNullable(logService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceObjects<UI> addingService(ServiceReference<UI> uiServiceReference) {
        Bundle bundle = uiServiceReference.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        UI contributedUI = (UI)bundleContext.getService(uiServiceReference);
        try {
            boolean isPortletUi;
            Class<?> uiClass = contributedUI.getClass();
            VaadinLiferayPortletConfiguration portletConfiguration = uiClass.getAnnotation(VaadinLiferayPortletConfiguration.class);
            boolean bl = isPortletUi = uiServiceReference.getProperty("com.vaadin.osgi.liferay.portlet-ui") != null || portletConfiguration != null;
            if (isPortletUi) {
                ServiceObjects<UI> serviceObjects = this.registerPortlet(uiServiceReference, portletConfiguration);
                return serviceObjects;
            }
            ServiceObjects<UI> serviceObjects = null;
            return serviceObjects;
        }
        finally {
            bundleContext.ungetService(uiServiceReference);
        }
    }

    private ServiceObjects<UI> registerPortlet(ServiceReference<UI> reference, VaadinLiferayPortletConfiguration configuration) {
        Bundle bundle = reference.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceObjects serviceObjects = bundleContext.getServiceObjects(reference);
        OsgiUIProvider uiProvider = new OsgiUIProvider((ServiceObjects<UI>)serviceObjects, this.logService);
        Dictionary<String, Object> properties = null;
        properties = configuration != null ? this.createPortletProperties(uiProvider, reference, configuration) : this.createPortletProperties(reference);
        OsgiVaadinPortlet portlet = new OsgiVaadinPortlet(uiProvider);
        ServiceRegistration serviceRegistration = bundleContext.registerService(Portlet.class, (Object)portlet, properties);
        this.portletRegistrations.put(reference, (ServiceRegistration<Portlet>)serviceRegistration);
        return serviceObjects;
    }

    private Dictionary<String, Object> createPortletProperties(OsgiUIProvider uiProvider, ServiceReference<UI> reference, VaadinLiferayPortletConfiguration configuration) {
        String displayName;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String category = configuration.category();
        if (category.trim().isEmpty()) {
            category = VAADIN_CATEGORY;
        }
        this.copyProperty(reference, properties, DISPLAY_CATEGORY, category);
        String portletName = configuration.name();
        if (portletName.trim().isEmpty()) {
            portletName = uiProvider.getDefaultPortletName();
        }
        if ((displayName = configuration.displayName()).trim().isEmpty()) {
            displayName = uiProvider.getDefaultDisplayName();
        }
        this.copyProperty(reference, properties, PORTLET_NAME, portletName);
        this.copyProperty(reference, properties, DISPLAY_NAME, displayName);
        this.copyProperty(reference, properties, PORTLET_SECURITY_ROLE, configuration.securityRole());
        String resourcesPath = String.format(RESOURCE_PATH_PREFIX, this.service.getResourcePathPrefix());
        this.copyProperty(reference, properties, VAADIN_RESOURCE_PATH, resourcesPath);
        return properties;
    }

    private void copyProperty(ServiceReference<UI> serviceReference, Dictionary<String, Object> properties, String key, Object defaultValue) {
        Object value = serviceReference.getProperty(key);
        if (value != null) {
            properties.put(key, value);
        } else if (value == null && defaultValue != null) {
            properties.put(key, defaultValue);
        }
    }

    private Dictionary<String, Object> createPortletProperties(ServiceReference<UI> reference) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            properties.put(key, reference.getProperty(key));
        }
        String resourcesPath = String.format(RESOURCE_PATH_PREFIX, this.service.getResourcePathPrefix());
        properties.put(VAADIN_RESOURCE_PATH, resourcesPath);
        return properties;
    }

    public void modifiedService(ServiceReference<UI> serviceReference, ServiceObjects<UI> ui) {
        Dictionary<String, Object> newProperties = this.createPortletProperties(serviceReference);
        ServiceRegistration<Portlet> registration = this.portletRegistrations.get(serviceReference);
        if (registration != null) {
            registration.setProperties(newProperties);
        }
    }

    public void removedService(ServiceReference<UI> reference, ServiceObjects<UI> ui) {
        ServiceRegistration<Portlet> portletRegistration = this.portletRegistrations.get(reference);
        this.portletRegistrations.remove(reference);
        portletRegistration.unregister();
    }

    void cleanPortletRegistrations() {
        for (ServiceRegistration<Portlet> registration : this.portletRegistrations.values()) {
            registration.unregister();
        }
        this.portletRegistrations.clear();
        this.portletRegistrations = null;
    }
}

