/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.liferay;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.portlet.Portlet;

/**
 * This annotation is used to inform the
 * {@link PortletUIServiceTrackerCustomizer} that this UI should be wrapped in a
 * {@link Portlet} and provides the necessary configuration for that.
 * <p>
 * This only applies to Liferay Portal 7+ with OSGi support.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface VaadinLiferayPortletConfiguration {
    /**
     * Category of the portlet in Liferay menus. By default
     * <i>category.vaadin</i>.
     */
    String category() default "category.vaadin";

    /**
     * Portlet name, must conform to the portlet specification and is used as
     * the key for the portlet.
     */
    String name() default "";

    /**
     * Display name of the portlet.
     */
    String displayName() default "";

    /**
     * Array of allowed security roles. By default, <i>power-user</i> and
     * <i>user</i>.
     */
    String[] securityRole() default { "power-user", "user" };
}
