/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.liferay;

import com.vaadin.portlet.VaadinPortlet;
import com.vaadin.portlet.VaadinPortletService;
import com.vaadin.portlet.VaadinPortletSession;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;

/**
 * {@link VaadinPortletService} class that uses the {@link OsgiUIProvider} to
 * configure the {@link UI} class for a {@link VaadinPortlet}.
 * <p>
 * This only applies to Liferay Portal 7+ with OSGi support.
 *
 * @author Sampsa Sohlman
 *
 * @since 8.1
 */
@SuppressWarnings("serial")
public class OsgiVaadinPortletService extends VaadinPortletService {
    private OsgiUIProvider osgiUIProvider;

    public OsgiVaadinPortletService(VaadinPortlet portlet,
            DeploymentConfiguration deploymentConfiguration,
            OsgiUIProvider osgiUIProvider) throws ServiceException {

        super(portlet, deploymentConfiguration);
        this.osgiUIProvider = osgiUIProvider;
    }

    @Override
    protected VaadinSession createVaadinSession(VaadinRequest request)
            throws ServiceException {

        VaadinSession vaadinSession = new VaadinPortletSession(this);
        vaadinSession.addUIProvider(osgiUIProvider);

        return vaadinSession;
    }

}
