/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.liferay;

import com.vaadin.portlet.VaadinPortlet;
import com.vaadin.portlet.VaadinPortletService;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.ui.UI;

/**
 * {@link VaadinPortlet} that uses an {@link OsgiUIProvider} to configure its
 * {@link UI}.
 * <p>
 * This only applies to Liferay Portal 7+ with OSGi support.
 *
 * @author Sampsa Sohlman
 *
 * @since 8.1
 */
@SuppressWarnings("serial")
public class OsgiVaadinPortlet extends VaadinPortlet {
    private OsgiUIProvider uiProvider;

    public OsgiVaadinPortlet(OsgiUIProvider uiProvider) {
        this.uiProvider = uiProvider;
    }

    @Override
    protected VaadinPortletService createPortletService(
            DeploymentConfiguration configuration) throws ServiceException {
        OsgiVaadinPortletService osgiVaadinPortletService = new OsgiVaadinPortletService(
                this, configuration, uiProvider);
        osgiVaadinPortletService.init();
        return osgiVaadinPortletService;
    }
}
