/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.liferay;

import com.vaadin.osgi.liferay.PortletUIServiceTrackerCustomizer;
import com.vaadin.osgi.resources.VaadinResourceService;
import com.vaadin.ui.UI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component
public class VaadinPortletProvider {
    private ServiceTracker<UI, ServiceObjects<UI>> serviceTracker;
    private PortletUIServiceTrackerCustomizer portletUIServiceTrackerCustomizer;
    private VaadinResourceService vaadinService;
    private LogService logService;

    @Activate
    void activate(BundleContext bundleContext) throws Exception {
        this.portletUIServiceTrackerCustomizer = new PortletUIServiceTrackerCustomizer(this.vaadinService, this.logService);
        this.serviceTracker = new ServiceTracker(bundleContext, UI.class, (ServiceTrackerCustomizer)this.portletUIServiceTrackerCustomizer);
        this.serviceTracker.open();
    }

    @Reference
    void setVaadinResourceService(VaadinResourceService vaadinService) {
        this.vaadinService = vaadinService;
    }

    void unsetVaadinResourceService(VaadinResourceService vaadinService) {
        if (this.vaadinService == vaadinService) {
            this.vaadinService = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    void setLogService(LogService logService) {
        this.logService = logService;
    }

    void unsetLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }

    @Deactivate
    void deactivate() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.portletUIServiceTrackerCustomizer.cleanPortletRegistrations();
            this.portletUIServiceTrackerCustomizer = null;
        }
    }
}

