/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.osgi.liferay;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Optional;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OsgiUIProvider
extends UIProvider {
    private Class<UI> uiClass;
    private ServiceObjects<UI> serviceObjects;
    private boolean prototype;
    private Optional<LogService> logService;

    public OsgiUIProvider(ServiceObjects<UI> serviceObjects, Optional<LogService> logService) {
        this.serviceObjects = serviceObjects;
        this.logService = logService;
        UI ui = (UI)serviceObjects.getService();
        ServiceReference reference = serviceObjects.getServiceReference();
        Object property = reference.getProperty("service.scope");
        this.prototype = "prototype".equals(property);
        this.uiClass = ui.getClass();
        serviceObjects.ungetService((Object)ui);
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
        return this.uiClass;
    }

    public UI createInstance(UICreateEvent event) {
        if (this.prototype) {
            UI ui = (UI)this.serviceObjects.getService();
            ui.addDetachListener((ClientConnector.DetachListener & Serializable)event2 -> this.serviceObjects.ungetService((Object)ui));
            return ui;
        }
        this.logService.ifPresent(log -> log.log(2, "UI services should have a prototype scope! Creating UI instance using the default constructor!"));
        return super.createInstance(event);
    }

    public String getDefaultPortletName() {
        return this.uiClass.getName();
    }

    public String getDefaultDisplayName() {
        return this.uiClass.getSimpleName();
    }
}

