/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.icon.AbstractIcon;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.signals.Signal;

public class SvgIcon
extends AbstractIcon<SvgIcon> {
    private static final String STYLE_FILL = "fill";

    public SvgIcon() {
    }

    public SvgIcon(String src) {
        this.setSrc(src);
    }

    public SvgIcon(String src, String symbol) {
        this(src);
        this.setSymbol(symbol);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public SvgIcon(AbstractStreamResource src) {
        this.setSrc(src);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public SvgIcon(AbstractStreamResource src, String symbol) {
        this(src);
        this.setSymbol(symbol);
    }

    public SvgIcon(DownloadHandler src) {
        this.setSrc(src);
    }

    public SvgIcon(DownloadHandler src, String symbol) {
        this(src);
        this.setSymbol(symbol);
    }

    public SvgIcon(DownloadHandler src, Signal<String> symbolSignal) {
        this(src);
        this.bindSymbol(symbolSignal);
    }

    public SvgIcon(String src, Signal<String> symbolSignal) {
        this(src);
        this.bindSymbol(symbolSignal);
    }

    public void setSrc(String src) {
        this.getElement().setAttribute("src", src);
    }

    public void setSrc(String src, String symbol) {
        this.setSrc(src);
        this.setSymbol(symbol);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setSrc(AbstractStreamResource src) {
        this.getElement().setAttribute("src", src);
    }

    @Deprecated(since="24.8", forRemoval=true)
    public void setSrc(AbstractStreamResource src, String symbol) {
        this.setSrc(src);
        this.setSymbol(symbol);
    }

    public void setSrc(DownloadHandler src) {
        if (src instanceof AbstractDownloadHandler) {
            AbstractDownloadHandler handler = (AbstractDownloadHandler)src;
            handler.inline();
        }
        this.getElement().setAttribute("src", (AbstractStreamResource)new StreamResourceRegistry.ElementStreamResource((ElementRequestHandler)src, this.getElement()));
    }

    public void setSrc(DownloadHandler src, String symbol) {
        this.setSrc(src);
        this.setSymbol(symbol);
    }

    public String getSrc() {
        return this.getElement().getAttribute("src");
    }

    public void setSymbol(String symbol) {
        this.getElement().setProperty("symbol", symbol);
    }

    public String getSymbol() {
        return this.getElement().getProperty("symbol");
    }

    public void bindSymbol(Signal<String> signal) {
        this.getElement().bindProperty("symbol", signal);
    }

    @Override
    public void setColor(String color) {
        this.getStyle().set(STYLE_FILL, color);
    }

    @Override
    public String getColor() {
        return this.getStyle().get(STYLE_FILL);
    }
}

