/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.AbstractIcon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalMapper;
import java.io.Serializable;
import java.util.Locale;

@NpmPackage(value="@vaadin/icons", version="25.1.0-alpha9")
@JsModule(value="@vaadin/icons/vaadin-iconset.js")
public class Icon
extends AbstractIcon<Icon> {
    private static final String ICON_ATTRIBUTE_NAME = "icon";
    private static final String VAADIN_ICON_COLLECTION_NAME = "vaadin";
    private static final String STYLE_FILL = "fill";

    public Icon() {
    }

    public Icon(VaadinIcon icon) {
        this.setIcon(icon);
    }

    public Icon(Signal<VaadinIcon> iconSignal) {
        this.bindIcon(iconSignal);
    }

    public Icon(String icon) {
        this.setIcon(icon);
    }

    public Icon(String collection, String icon) {
        this.setIcon(collection, icon);
    }

    public void setIcon(String icon) {
        if (icon.contains(":")) {
            String[] parts = icon.split(":", 2);
            this.setIcon(parts[0], parts[1]);
        } else {
            String collection = this.getCollection();
            if (collection == null) {
                collection = VAADIN_ICON_COLLECTION_NAME;
            }
            this.setIcon(collection, icon);
        }
    }

    public void setIcon(VaadinIcon icon) {
        this.setIcon(VAADIN_ICON_COLLECTION_NAME, Icon.normalizeIcon(icon));
    }

    public void bindIcon(Signal<VaadinIcon> signal) {
        this.getElement().bindAttribute(ICON_ATTRIBUTE_NAME, signal == null ? null : signal.map((SignalMapper & Serializable)icon -> "vaadin:" + Icon.normalizeIcon(icon)));
    }

    public String getIcon() {
        return this.getElement().getAttribute(ICON_ATTRIBUTE_NAME);
    }

    public void setIcon(String collection, String icon) {
        this.getElement().setAttribute(ICON_ATTRIBUTE_NAME, collection + ":" + icon);
    }

    public String getCollection() {
        String icon = this.getIcon();
        if (icon != null && icon.contains(":")) {
            return icon.substring(0, icon.indexOf(58));
        }
        return null;
    }

    @Override
    public void setColor(String color) {
        if (color == null) {
            this.getStyle().remove(STYLE_FILL);
        } else {
            this.getStyle().set(STYLE_FILL, color);
        }
    }

    @Override
    public String getColor() {
        return this.getStyle().get(STYLE_FILL);
    }

    private static String normalizeIcon(VaadinIcon icon) {
        return icon.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }
}

