/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.icon.AbstractIcon;
import com.vaadin.flow.signals.Signal;
import java.util.Optional;

public class FontIcon
extends AbstractIcon<FontIcon> {
    public FontIcon() {
    }

    public FontIcon(String ... iconClassNames) {
        this.setIconClassNames(iconClassNames);
    }

    public void setIconClassNames(String ... iconClassNames) {
        this.getElement().setProperty("iconClass", iconClassNames.length == 0 ? null : String.join((CharSequence)" ", iconClassNames));
    }

    public String[] getIconClassNames() {
        return Optional.ofNullable(this.getElement().getProperty("iconClass")).map(f -> f.split(" ")).orElse(new String[0]);
    }

    public void setFontFamily(String fontFamily) {
        this.getElement().setProperty("fontFamily", fontFamily);
    }

    public String getFontFamily() {
        return this.getElement().getProperty("fontFamily");
    }

    public void setCharCode(String charCode) {
        this.getElement().setProperty("char", charCode);
    }

    public String getCharCode() {
        return this.getElement().getProperty("char");
    }

    public void bindCharCode(Signal<String> signal) {
        this.getElement().bindProperty("char", signal, null);
    }

    public void setLigature(String ligature) {
        this.getElement().setProperty("ligature", ligature);
    }

    public String getLigature() {
        return this.getElement().getProperty("ligature");
    }

    public void bindLigature(Signal<String> signal) {
        this.getElement().bindProperty("ligature", signal, null);
    }

    @Override
    public void setColor(String color) {
        this.getStyle().set("color", color);
    }

    @Override
    public String getColor() {
        return this.getStyle().get("color");
    }
}

