import { p as xe, L as Le, n as Xc, l as le, k, o as cu, g, c as Sa } from "./indexhtml-D_SVntDb.js";
import { a } from "./state-CdTHPgfy-rX4o8avI.js";
import { r } from "./icons-Dg6-OnOj-aAYaHVZ9.js";
import { o as o$1 } from "./copilot-tree-LIsXUVHb-usDwdJJ5.js";
import { l } from "./base-panel-Bo7cTT-C-C1xDJOaQ.js";
import "./commonjsHelpers-CUmg6egw.js";
var $ = Object.defineProperty, T = Object.getOwnPropertyDescriptor, d = (t, e, p, r2) => {
  for (var l2 = r2 > 1 ? void 0 : r2 ? T(e, p) : e, v = t.length - 1, b; v >= 0; v--)
    (b = t[v]) && (l2 = (r2 ? b(e, p, l2) : b(l2)) || l2);
  return r2 && l2 && $(e, p, l2), l2;
};
let o = class extends l {
  constructor() {
    super(...arguments), this.selectedTab = 0, this.selectedNotificationPosition = "Top right", this.activationShortcutEnabled = Le.isActivationShortcut(), this.aiUsage = Le.isAIUsageAllowed(), this.aiProvider = Le.getAIProvider(), this.themeItems = [
      { label: "System", value: "system" },
      { label: "Light", value: "light" },
      { label: "Dark", value: "dark" }
    ], this.notificationPositionItems = [
      { label: "Top right", value: "Top right" },
      { label: "Bottom right", value: "Bottom right" },
      { label: "Bottom left", value: "Bottom left" },
      { label: "Top left", value: "Top left" }
    ], this.aiUsageItems = [
      { label: "Ask each time", value: "ask" },
      { label: "Allow", value: "yes" },
      { label: "Deny", value: "no" }
    ], this.aiProviderItems = [
      { label: "Any region", value: "ANY" },
      { label: "EU only", value: "EU_ONLY" }
    ], this.toggleActivationShortcut = () => {
      this.activationShortcutEnabled = !this.activationShortcutEnabled, Le.setActivationShortcut(this.activationShortcutEnabled);
    };
  }
  renderKbd(t) {
    const e = t.replace(/<kbd([^>]*)class="([^"]*)"/, '<kbd$1class="$2 font-sans ms-auto"').replace(/<kbd(?![^>]*class=)/, '<kbd class="font-sans ms-auto"');
    return Xc(e);
  }
  render() {
    return le`
      <vaadin-tabs>
        <vaadin-tab ?selected=${this.selectedTab === 0} @click=${() => this.selectedTab = 0}>General</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 1} @click=${() => this.selectedTab = 1}>Shortcuts</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 2} @click=${() => this.selectedTab = 2}>AI</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 3} @click=${() => this.selectedTab = 3}>Features</vaadin-tab>
      </vaadin-tabs>
      ${this.selectedTab === 0 ? this.renderGeneralTab() : null}
      ${this.selectedTab === 1 ? this.renderShortcutsTab() : null} ${this.selectedTab === 2 ? this.renderAiTab() : null}
      ${this.selectedTab === 3 ? this.renderFeaturesTab() : null}
    `;
  }
  renderGeneralTab() {
    const t = Le.getSelectedTheme();
    return le`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="theme">Theme</label>
        <vaadin-select
          accessible-name-ref="theme"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.themeItems}"
          .value="${t}"
          @change="${(e) => {
      Le.setSelectedTheme(
        e.target.value
      );
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="notification-position">Notifications</label>
        <vaadin-select
          accessible-name-ref="notification-position"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.notificationPositionItems}"
          .value="${this.selectedNotificationPosition}"
          @value-changed="${(e) => {
      this.selectedNotificationPosition = e.detail.value;
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="reduce-motion-label">Reduce motion</label>
          <span id="reduce-motion-desc" class="text-secondary text-xs">Disables animations</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="reduce-motion-label"
          aria-describedby="reduce-motion-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="error-reports-label">Send error reports</label>
          <span id="error-reports-desc" class="text-secondary text-xs">Helps us improve the user experience</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="error-reports-label"
          aria-describedby="error-reports-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
    </div>`;
  }
  renderShortcutsTab() {
    const t = o$1.hasFlowComponents();
    return le`<div class="flex flex-col gap-4 pb-2 pt-4 px-4">
      <div class="flex justify-between">
        <div class="flex flex-col">
          <label id="enable-shortcuts-label">Enable keyboard shortcut</label>
          <span id="enable-shortcuts-desc" class="text-secondary text-xs"
            >Open DevTools with ${this.renderKbd(cu.toggleCopilot)}</span
          >
        </div>
        <button
          aria-checked="${this.activationShortcutEnabled}"
          aria-labelledby="enable-shortcuts-label"
          aria-describedby="enable-shortcuts-desc"
          class="my-px"
          role="switch"
          type="button"
          @click=${() => this.toggleActivationShortcut()}>
          <span></span>
        </button>
      </div>
      <vaadin-text-field accessible-name="Search" placeholder="Search...">
        <vaadin-icon class="text-secondary" slot="prefix" .svg="${r.search}"></vaadin-icon>
      </vaadin-text-field>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Global</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.vaadin}"></vaadin-icon>
            <span>Copilot</span>
            ${this.renderKbd(cu.toggleCopilot)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.undo}"></vaadin-icon>
            <span>Undo</span>
            ${this.renderKbd(cu.undo)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.redo}"></vaadin-icon>
            <span>Redo</span>
            ${this.renderKbd(cu.redo)}
          </li>
        </ul>
      </div>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Component Selection</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.sparkles}"></vaadin-icon>
            <span>Open AI prompt</span>
            ${this.renderKbd(cu.openAiPopover)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.code}"></vaadin-icon>
            <span>Go to source</span>
            ${this.renderKbd(cu.goToSource)}
          </li>
          ${t ? le`<li class="flex gap-2 py-2">
                <vaadin-icon .svg="${r.code}"></vaadin-icon>
                <span>Go to attach source</span>
                ${this.renderKbd(cu.goToAttachSource)}
              </li>` : k}
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentCopy}"></vaadin-icon>
            <span>Copy</span>
            ${this.renderKbd(cu.copy)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentPaste}"></vaadin-icon>
            <span>Paste</span>
            ${this.renderKbd(cu.paste)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.fileCopy}"></vaadin-icon>
            <span>Duplicate</span>
            ${this.renderKbd(cu.duplicate)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.turnLeft}"></vaadin-icon>
            <span>Select parent</span>
            ${this.renderKbd(cu.selectParent)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.north}"></vaadin-icon>
            <span>Select previous sibling</span>
            ${this.renderKbd(cu.selectPreviousSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.south}"></vaadin-icon>
            <span>Select first child / next sibling</span>
            ${this.renderKbd(cu.selectNextSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.delete}"></vaadin-icon>
            <span>Delete</span>
            ${this.renderKbd(cu.delete)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.dashboardCustomize}"></vaadin-icon>
            <span>Add component</span>
            <kbd class="font-sans ms-auto">A – Z</kbd>
          </li>
        </ul>
      </div>
    </div>`;
  }
  renderAiTab() {
    const t = g.userInfo?.vaadiner;
    return le`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <div class="flex flex-col py-1.5">
          <label id="ai-usage">AI usage</label>
          <span class="text-secondary text-xs">All AI features are clearly labelled </span>
        </div>
        <vaadin-select
          accessible-name-ref="ai-usage"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.aiUsageItems}"
          .value="${this.aiUsage}"
          @value-changed="${(e) => {
      this.aiUsage = e.detail.value, Le.setAIUsageAllowed(e.detail.value);
    }}"></vaadin-select>
      </div>
      ${t ? le`<div class="flex gap-2 items-start justify-between py-2">
            <label class="py-1.5" id="ai-provider">AI provider</label>
            <vaadin-select
              accessible-name-ref="ai-provider"
              class="flex-shrink-0"
              theme="auto-width no-border"
              .items="${this.aiProviderItems}"
              .value="${this.aiProvider}"
              @value-changed="${(e) => {
      this.aiProvider = e.detail.value, Le.setAIProvider(e.detail.value);
    }}"></vaadin-select>
          </div>` : k}
    </div>`;
  }
  renderFeaturesTab() {
    return le`<copilot-features-panel></copilot-features-panel>`;
  }
};
d([
  a()
], o.prototype, "selectedTab", 2);
d([
  a()
], o.prototype, "selectedNotificationPosition", 2);
d([
  a()
], o.prototype, "activationShortcutEnabled", 2);
d([
  a()
], o.prototype, "aiUsage", 2);
d([
  a()
], o.prototype, "aiProvider", 2);
o = d([
  Sa("copilot-settings-panel")
], o);
const S = {
  header: "Settings",
  tag: xe.SETTINGS
}, P = {
  init(t) {
    t.addPanel(S);
  }
};
window.Vaadin.copilot.plugins.push(P);
export {
  o as CopilotSettingsPanel,
  S as panelConfig
};
