import { v as vc, k, O as Or, l as le, b, u as Ra, cq as dd, c as vo, S as Se, q as cd, o as xe, d as Sa } from "./indexhtml-BElS1XHG.js";
import { r } from "./icons-K0QHw4DH-BOJXAWOH.js";
import "./commonjsHelpers-CUmg6egw.js";
var w = (e, r2, a, c) => {
  for (var s = r2, i = e.length - 1, d; i >= 0; i--)
    (d = e[i]) && (s = d(s) || s);
  return s;
};
const S = "bg-[linear-gradient(to_right,var(--amber-3),var(--amber-5),var(--amber-3),var(--amber-6))] dark:bg-[linear-gradient(to_right,var(--amber-5),var(--amber-7),var(--amber-5),var(--amber-8))]", $ = "bg-[linear-gradient(to_right,var(--blue-3),var(--blue-5),var(--blue-3),var(--blue-6))] dark:bg-[linear-gradient(to_right,var(--blue-4),var(--blue-6),var(--blue-4),var(--blue-7))]", E = "bg-[linear-gradient(to_right,var(--ruby-3),var(--ruby-5),var(--ruby-3),var(--ruby-6))] dark:bg-[linear-gradient(to_right,var(--ruby-4),var(--ruby-6),var(--ruby-4),var(--ruby-7))]", P = "bg-[linear-gradient(to_right,var(--teal-3),var(--teal-5),var(--teal-3),var(--teal-6))] dark:bg-[linear-gradient(to_right,var(--teal-4),var(--teal-6),var(--teal-4),var(--teal-7))]";
let v = class extends vc {
  createRenderRoot() {
    return this;
  }
  connectedCallback() {
    super.connectedCallback(), this.classList.add("flex", "flex-col");
  }
  render() {
    return le`
      <header class="flex items-center pe-2 ps-4 py-2">
        <h2 class="font-bold gap-1 me-auto my-0 text-xs uppercase">Vaadin DevTools</h2>
        <vaadin-button
          aria-label="Close"
          theme="icon tertiary"
          @click=${() => {
      this.closePopover();
    }}>
          <vaadin-icon .svg="${r.close}"></vaadin-icon>
          <vaadin-tooltip slot="tooltip" text="Close"></vaadin-tooltip>
        </vaadin-button>
      </header>
      <div class="flex flex-col gap-4 pb-4 px-4">
        ${this.renderUserButton()} ${this.renderDevelopmentWorkflow()}
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleAppInfoClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.info}"></vaadin-icon>
            App Info
          </vaadin-button>
          <vaadin-button @click="${this.handleAppLogClick}" class="border-0 h-auto justify-start py-2" theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.terminal}"></vaadin-icon>
            App Log
          </vaadin-button>
          ${Or.springSecurityEnabled ? le`
                <vaadin-button
                  @click="${this.handleImpersonateAppUserClick}"
                  class="border-0 h-auto justify-start py-2"
                  theme="tertiary">
                  <vaadin-icon slot="prefix" .svg="${r.accountCircle}"></vaadin-icon>
                  Impersonate App User
                </vaadin-button>
              ` : k}
        </div>
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button class="border-0 h-auto justify-start py-2" theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.help}"></vaadin-icon>
            Help & Support
          </vaadin-button>
          <vaadin-button
            @click="${this.handleSettingsClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.settings}"></vaadin-icon>
            Settings
          </vaadin-button>
        </div>
      </div>
    `;
  }
  renderUserButton() {
    const e = b.userInfo?.validLicense, r$1 = e ? S : $, a = e ? "text-amber-12 dark:text-amber-11" : "text-blue-12 dark:text-blue-11";
    return le`
      <vaadin-button
        class="animate-gradient ${r$1} border-0 gap-3 border-0 h-auto justify-start px-3 py-2 text-start">
        ${this.renderUserImage()}
        <span class="flex flex-col">
          <span>${this.getUserName()}</span>
          <span class="${a} text-xs">${this.getLicenseType()}</span>
        </span>
        <vaadin-icon class="ms-auto" slot="suffix" .svg="${r.moreVert}"></vaadin-icon>
      </vaadin-button>
    `;
  }
  renderUserImage() {
    return b.userInfo?.portraitUrl ? le`<img
        alt="${this.getUserName()}"
        class="rounded-full size-8 object-cover"
        slot="prefix"
        src="https://vaadin.com${b.userInfo.portraitUrl}" />` : k;
  }
  renderDevelopmentWorkflow() {
    const e = Ra(), r2 = dd(), a = this.getDevelopmentWorkflowConfig(e, r2), c = a?.bgClass ?? "", s = a?.colorClass ?? "", i = this.resolveIcon(a), d = a?.rotateIcon ? `rotate-180 ${s}` : s, g = this.resolveTitle(a), b2 = a?.displayMessage ?? "";
    return le`
      <vaadin-button
        data-test-id="development-workflow-btn"
        @click="${this.handleDevelopmentWorkflowClick}"
        class="animation-delay-4000 animate-gradient ${c} border-0 h-auto items-start justify-start py-2 text-start">
        <vaadin-icon class="${d}" slot="prefix" .svg="${i}"></vaadin-icon>
        <span class="flex flex-col">
          <span>${g}</span>
          <span class="text-xs ${s}">${b2}</span>
        </span>
      </vaadin-button>
    `;
  }
  getDevelopmentWorkflowConfig(e, r$1) {
    const a = {
      bgClass: P,
      colorClass: "text-teal-11"
    };
    if (e === "warning" && r$1 === "warning")
      return {
        ...a,
        icon: r.wbIncandescent,
        rotateIcon: true,
        title: "IDE plugin & Hotswap recommended",
        combinedTitle: true,
        displayMessage: "Enable both for optimal development workflow"
      };
    if (e === "warning")
      return {
        ...a,
        icon: r.wbIncandescent,
        rotateIcon: true,
        title: "Hotswap recommended",
        displayMessage: "Applies changes without restarting"
      };
    if (r$1 === "warning")
      return {
        ...a,
        icon: r.code,
        getIcon: true,
        title: "IDE plugin recommended",
        getTitle: true,
        displayMessage: "Simplifies Hotswap setup & config"
      };
    if (e === "error")
      return {
        bgClass: E,
        colorClass: "text-ruby-11",
        icon: r.error,
        title: "Hotswap partially enabled",
        displayMessage: "View details"
      };
  }
  resolveIcon(e) {
    return e ? e.getIcon ? this.getIdeIcon() : e.icon : r.bolt;
  }
  resolveTitle(e) {
    return e ? e.combinedTitle ? this.getCombinedTitle() : e.getTitle ? this.getIdePluginName() : e.title : "Development Workflow";
  }
  getUserName() {
    return [b.userInfo?.firstName, b.userInfo?.lastName].filter(Boolean).join(" ") || "User";
  }
  getLicenseType() {
    return b.userInfo?.validLicense ? "Commercial License" : "Free";
  }
  getIdeIcon() {
    switch (b.idePluginState?.ide) {
      case "intellij":
        return r.intelliJ;
      case "vscode":
        return r.vsCode;
      case "eclipse":
        return r.eclipse;
      default:
        return r.code;
    }
  }
  getIdePluginName() {
    switch (b.idePluginState?.ide) {
      case "intellij":
        return "Vaadin plugin for IntelliJ";
      case "vscode":
        return "Vaadin extension for VS Code";
      case "eclipse":
        return "Vaadin plugin for Eclipse";
      default:
        return "IDE plugin";
    }
  }
  getCombinedTitle() {
    switch (b.idePluginState?.ide) {
      case "intellij":
        return "IntelliJ plugin & Hotswap recommended";
      case "vscode":
        return "VS Code extension & Hotswap recommended";
      case "eclipse":
        return "Eclipse plugin & Hotswap recommended";
      default:
        return "IDE plugin & Hotswap recommended";
    }
  }
  closePopover() {
    const e = this.closest("vaadin-popover");
    e && (e.opened = false);
  }
  handleDevelopmentWorkflowClick() {
    vo("use-dev-workflow-guide"), Se.openPanel(cd), this.closePopover();
  }
  handleAppInfoClick() {
    Se.openPanel(xe.INFO), this.closePopover();
  }
  handleAppLogClick() {
    Se.openPanel(xe.LOG), this.closePopover();
  }
  handleImpersonateAppUserClick() {
    Se.openPanel(xe.IMPERSONATOR), this.closePopover();
  }
  handleSettingsClick() {
    Se.openPanel(xe.SETTINGS), this.closePopover();
  }
};
v = w([
  Sa("copilot-devtools")
], v);
export {
  v as CopilotDevTools
};
