import { m as me, i as Ye, K as Kd, V as Ve, e as k, $ as $d, g, S as Sa } from "./indexhtml-XEEOqH0g.js";
import { a } from "./state-DZirAxnk-Cw62fUpl.js";
import { r } from "./icons-BlmbDoVG-DJcxeVnt.js";
import { o as o$1 } from "./copilot-tree-C-9v89Yx-cZcH3ZZZ.js";
import { V } from "./base-panel-CvWW_-8D-C5OjXvLr.js";
import "./commonjsHelpers-CUmg6egw.js";
var $ = Object.defineProperty, S = Object.getOwnPropertyDescriptor, o = (t, a2, p, r2) => {
  for (var l = r2 > 1 ? void 0 : r2 ? S(a2, p) : a2, v = t.length - 1, b; v >= 0; v--)
    (b = t[v]) && (l = (r2 ? b(a2, p, l) : b(l)) || l);
  return r2 && l && $(a2, p, l), l;
};
let d = class extends V {
  constructor() {
    super(...arguments), this.selectedTab = 0, this.activationShortcutEnabled = Ye.isActivationShortcut(), this.aiUsage = Ye.isAIUsageAllowed(), this.aiProvider = Ye.getAIProvider(), this.themeItems = [
      { label: "System", value: "system" },
      { label: "Light", value: "light" },
      { label: "Dark", value: "dark" }
    ], this.aiUsageItems = [
      { label: "Ask each time", value: "ask" },
      { label: "Allow", value: "yes" },
      { label: "Deny", value: "no" }
    ], this.aiProviderItems = [
      { label: "Any region", value: "ANY" },
      { label: "EU only", value: "EU_ONLY" }
    ], this.toggleActivationShortcut = () => {
      this.activationShortcutEnabled = !this.activationShortcutEnabled, Ye.setActivationShortcut(this.activationShortcutEnabled);
    };
  }
  renderKbd(t) {
    const a2 = t.replace(/<kbd([^>]*)class="([^"]*)"/, '<kbd$1class="$2 font-sans ms-auto"').replace(/<kbd(?![^>]*class=)/, '<kbd class="font-sans ms-auto"');
    return Kd(a2);
  }
  render() {
    return Ve`
      <vaadin-tabs>
        <vaadin-tab ?selected=${this.selectedTab === 0} @click=${() => this.selectedTab = 0}>General</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 1} @click=${() => this.selectedTab = 1}>Shortcuts</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 2} @click=${() => this.selectedTab = 2}>AI</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 3} @click=${() => this.selectedTab = 3}>Features</vaadin-tab>
      </vaadin-tabs>
      ${this.selectedTab === 0 ? this.renderGeneralTab() : null}
      ${this.selectedTab === 1 ? this.renderShortcutsTab() : null} ${this.selectedTab === 2 ? this.renderAiTab() : null}
      ${this.selectedTab === 3 ? this.renderFeaturesTab() : null}
    `;
  }
  renderGeneralTab() {
    const t = Ye.getSelectedTheme();
    return Ve`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="theme">Theme</label>
        <vaadin-select
          accessible-name-ref="theme"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.themeItems}"
          .value="${t}"
          @change="${(a2) => {
      Ye.setSelectedTheme(
        a2.target.value
      );
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="reduce-motion-label">Reduce motion</label>
          <span id="reduce-motion-desc" class="text-secondary text-xs">Disables animations</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="reduce-motion-label"
          aria-describedby="reduce-motion-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="error-reports-label">Send error reports</label>
          <span id="error-reports-desc" class="text-secondary text-xs">Helps us improve the user experience</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="error-reports-label"
          aria-describedby="error-reports-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
    </div>`;
  }
  renderShortcutsTab() {
    const t = o$1.hasFlowComponents();
    return Ve`<div class="flex flex-col gap-4 pb-2 pt-4 px-4">
      <div class="flex justify-between">
        <div class="flex flex-col">
          <label id="enable-shortcuts-label">Enable keyboard shortcut</label>
          <span id="enable-shortcuts-desc" class="text-secondary text-xs"
            >Open Copilot with ${this.renderKbd($d.toggleCopilot)}</span
          >
        </div>
        <button
          aria-checked="${this.activationShortcutEnabled}"
          aria-labelledby="enable-shortcuts-label"
          aria-describedby="enable-shortcuts-desc"
          class="my-px"
          role="switch"
          type="button"
          @click=${() => this.toggleActivationShortcut()}>
          <span></span>
        </button>
      </div>
      <vaadin-text-field accessible-name="Search" placeholder="Search...">
        <vaadin-icon class="text-secondary" slot="prefix" .svg="${r.search}"></vaadin-icon>
      </vaadin-text-field>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Global</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.vaadin}"></vaadin-icon>
            <span>Copilot</span>
            ${this.renderKbd($d.toggleCopilot)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.undo}"></vaadin-icon>
            <span>Undo</span>
            ${this.renderKbd($d.undo)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.redo}"></vaadin-icon>
            <span>Redo</span>
            ${this.renderKbd($d.redo)}
          </li>
        </ul>
      </div>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Component Selection</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.sparkles}"></vaadin-icon>
            <span>Open AI prompt</span>
            ${this.renderKbd($d.openAiPopover)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.code}"></vaadin-icon>
            <span>Go to source</span>
            ${this.renderKbd($d.goToSource)}
          </li>
          ${t ? Ve`<li class="flex gap-2 py-2">
                <vaadin-icon .svg="${r.code}"></vaadin-icon>
                <span>Go to attach source</span>
                ${this.renderKbd($d.goToAttachSource)}
              </li>` : k}
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentCopy}"></vaadin-icon>
            <span>Copy</span>
            ${this.renderKbd($d.copy)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentPaste}"></vaadin-icon>
            <span>Paste</span>
            ${this.renderKbd($d.paste)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.fileCopy}"></vaadin-icon>
            <span>Duplicate</span>
            ${this.renderKbd($d.duplicate)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.turnLeft}"></vaadin-icon>
            <span>Select parent</span>
            ${this.renderKbd($d.selectParent)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.north}"></vaadin-icon>
            <span>Select previous sibling</span>
            ${this.renderKbd($d.selectPreviousSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.south}"></vaadin-icon>
            <span>Select first child / next sibling</span>
            ${this.renderKbd($d.selectNextSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.delete}"></vaadin-icon>
            <span>Delete</span>
            ${this.renderKbd($d.delete)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.dashboardCustomize}"></vaadin-icon>
            <span>Add component</span>
            <kbd class="font-sans ms-auto">A – Z</kbd>
          </li>
        </ul>
      </div>
    </div>`;
  }
  renderAiTab() {
    const t = g.userInfo?.vaadiner;
    return Ve`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <div class="flex flex-col py-1.5">
          <label id="ai-usage">AI usage</label>
          <span class="text-secondary text-xs">All AI features are clearly labelled </span>
        </div>
        <vaadin-select
          accessible-name-ref="ai-usage"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.aiUsageItems}"
          .value="${this.aiUsage}"
          @value-changed="${(a2) => {
      this.aiUsage = a2.detail.value, Ye.setAIUsageAllowed(a2.detail.value);
    }}"></vaadin-select>
      </div>
      ${t ? Ve`<div class="flex gap-2 items-start justify-between py-2">
            <label class="py-1.5" id="ai-provider">AI provider</label>
            <vaadin-select
              accessible-name-ref="ai-provider"
              class="flex-shrink-0"
              theme="auto-width no-border"
              .items="${this.aiProviderItems}"
              .value="${this.aiProvider}"
              @value-changed="${(a2) => {
      this.aiProvider = a2.detail.value, Ye.setAIProvider(a2.detail.value);
    }}"></vaadin-select>
          </div>` : k}
    </div>`;
  }
  renderFeaturesTab() {
    return Ve`<copilot-features-panel></copilot-features-panel>`;
  }
};
o([
  a()
], d.prototype, "selectedTab", 2);
o([
  a()
], d.prototype, "activationShortcutEnabled", 2);
o([
  a()
], d.prototype, "aiUsage", 2);
o([
  a()
], d.prototype, "aiProvider", 2);
d = o([
  Sa("copilot-settings-panel")
], d);
const T = {
  header: "Settings",
  tag: me.SETTINGS
}, A = {
  init(t) {
    t.addPanel(T);
  }
};
window.Vaadin.copilot.plugins.push(A);
export {
  d as CopilotSettingsPanel,
  T as panelConfig
};
