import { c as cc, e as k, x as xr, V as Ve, g, Z as Za, cr as _c, f as fo, k as ke, p as Yc, m as me, S as Sa } from "./indexhtml-XEEOqH0g.js";
import { r } from "./icons-BlmbDoVG-DJcxeVnt.js";
import "./commonjsHelpers-CUmg6egw.js";
var w = (e, n, a, d) => {
  for (var i = n, s = e.length - 1, p; s >= 0; s--)
    (p = e[s]) && (i = p(i) || i);
  return i;
};
const S = "bg-[linear-gradient(to_right,var(--amber-3),var(--amber-5),var(--amber-3),var(--amber-6))] dark:bg-[linear-gradient(to_right,var(--amber-5),var(--amber-7),var(--amber-5),var(--amber-8))]", $ = "bg-[linear-gradient(to_right,var(--blue-3),var(--blue-5),var(--blue-3),var(--blue-6))] dark:bg-[linear-gradient(to_right,var(--blue-4),var(--blue-6),var(--blue-4),var(--blue-7))]", E = "bg-[linear-gradient(to_right,var(--ruby-3),var(--ruby-5),var(--ruby-3),var(--ruby-6))] dark:bg-[linear-gradient(to_right,var(--ruby-4),var(--ruby-6),var(--ruby-4),var(--ruby-7))]", P = "bg-[linear-gradient(to_right,var(--teal-3),var(--teal-5),var(--teal-3),var(--teal-6))] dark:bg-[linear-gradient(to_right,var(--teal-4),var(--teal-6),var(--teal-4),var(--teal-7))]";
let v = class extends cc {
  createRenderRoot() {
    return this;
  }
  connectedCallback() {
    super.connectedCallback(), this.classList.add("flex", "flex-col");
  }
  render() {
    return Ve`
      <header class="flex items-center pe-2 ps-4 py-2">
        <h2 class="font-bold gap-1 me-auto my-0 text-xs uppercase">Vaadin Copilot</h2>
        <vaadin-button
          aria-label="Close"
          theme="icon tertiary"
          @click=${() => {
      this.closePopover();
    }}>
          <vaadin-icon .svg="${r.close}"></vaadin-icon>
          <vaadin-tooltip slot="tooltip" text="Close"></vaadin-tooltip>
        </vaadin-button>
      </header>
      <div class="flex flex-col gap-4 pb-4 px-4">
        ${this.renderUserButton()} ${this.renderDevelopmentWorkflow()}
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleAppInfoClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.info}"></vaadin-icon>
            App Info
          </vaadin-button>
          <vaadin-button @click="${this.handleAppLogClick}" class="border-0 h-auto justify-start py-2" theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.terminal}"></vaadin-icon>
            App Log
          </vaadin-button>
          ${xr.springSecurityEnabled ? Ve`
                <vaadin-button
                  @click="${this.handleImpersonateAppUserClick}"
                  class="border-0 h-auto justify-start py-2"
                  theme="tertiary">
                  <vaadin-icon slot="prefix" .svg="${r.accountCircle}"></vaadin-icon>
                  Impersonate App User
                </vaadin-button>
              ` : k}
        </div>
        <div class="bg-gray-3 dark:bg-gray-6 flex flex-col rounded-md">
          <vaadin-button
            @click="${this.handleHelpAndSupportClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.help}"></vaadin-icon>
            Help & Support
          </vaadin-button>
          <vaadin-button
            @click="${this.handleSettingsClick}"
            class="border-0 h-auto justify-start py-2"
            theme="tertiary">
            <vaadin-icon slot="prefix" .svg="${r.settings}"></vaadin-icon>
            Settings
          </vaadin-button>
        </div>
      </div>
    `;
  }
  renderUserButton() {
    const e = g.userInfo?.validLicense, n = e ? S : $, a = e ? "text-amber-12 dark:text-amber-11" : "text-blue-12 dark:text-blue-11";
    return Ve`
      <vaadin-button
        @click=${this.handleUserLoginClick}
        class="animate-gradient ${n} border-0 gap-3 border-0 h-auto justify-start px-3 py-2 text-start">
        ${this.renderUserImage()}
        <span class="flex flex-col">
          <span>${this.getUserName()}</span>
          <span class="${a} text-xs">${this.getLicenseType()}</span>
        </span>
      </vaadin-button>
    `;
  }
  renderUserImage() {
    return g.userInfo?.portraitUrl ? Ve`<img
        alt="${this.getUserName()}"
        class="rounded-full size-8 object-cover"
        slot="prefix"
        src="https://vaadin.com${g.userInfo.portraitUrl}" />` : k;
  }
  renderDevelopmentWorkflow() {
    const e = Za(), n = _c(), a = this.getDevelopmentWorkflowConfig(e, n), d = a?.bgClass ?? "", i = a?.colorClass ?? "", s = this.resolveIcon(a), p = a?.rotateIcon ? `rotate-180 ${i}` : i, g2 = this.resolveTitle(a), b = a?.displayMessage ?? "";
    return Ve`
      <vaadin-button
        data-test-id="development-workflow-btn"
        @click="${this.handleDevelopmentWorkflowClick}"
        class="animation-delay-4000 animate-gradient ${d} border-0 h-auto items-start justify-start py-2 text-start">
        <vaadin-icon class="${p}" slot="prefix" .svg="${s}"></vaadin-icon>
        <span class="flex flex-col">
          <span>${g2}</span>
          <span class="text-xs ${i}">${b}</span>
        </span>
      </vaadin-button>
    `;
  }
  getDevelopmentWorkflowConfig(e, n) {
    const a = {
      bgClass: P,
      colorClass: "text-teal-11"
    };
    if (e === "warning" && n === "warning")
      return {
        ...a,
        icon: r.wbIncandescent,
        rotateIcon: true,
        title: "IDE plugin & Hotswap recommended",
        combinedTitle: true,
        displayMessage: "Enable both for optimal development workflow"
      };
    if (e === "warning")
      return {
        ...a,
        icon: r.wbIncandescent,
        rotateIcon: true,
        title: "Hotswap recommended",
        displayMessage: "Applies changes without restarting"
      };
    if (n === "warning")
      return {
        ...a,
        icon: r.code,
        getIcon: true,
        title: "IDE plugin recommended",
        getTitle: true,
        displayMessage: "Simplifies Hotswap setup & config"
      };
    if (e === "error")
      return {
        bgClass: E,
        colorClass: "text-ruby-11",
        icon: r.error,
        title: "Hotswap partially enabled",
        displayMessage: "View details"
      };
  }
  resolveIcon(e) {
    return e ? e.getIcon ? this.getIdeIcon() : e.icon : r.bolt;
  }
  resolveTitle(e) {
    return e ? e.combinedTitle ? this.getCombinedTitle() : e.getTitle ? this.getIdePluginName() : e.title : "Development Workflow";
  }
  getUserName() {
    return [g.userInfo?.firstName, g.userInfo?.lastName].filter(Boolean).join(" ") || "Not logged in";
  }
  getLicenseType() {
    return g.userInfo?.validLicense ? "" : "Unlock all Copilot features (includes AI features)";
  }
  getIdeIcon() {
    switch (g.idePluginState?.ide) {
      case "intellij":
        return r.intelliJ;
      case "vscode":
        return r.vsCode;
      case "eclipse":
        return r.eclipse;
      default:
        return r.code;
    }
  }
  getIdePluginName() {
    switch (g.idePluginState?.ide) {
      case "intellij":
        return "Vaadin plugin for IntelliJ";
      case "vscode":
        return "Vaadin extension for VS Code";
      case "eclipse":
        return "Vaadin plugin for Eclipse";
      default:
        return "IDE plugin";
    }
  }
  getCombinedTitle() {
    switch (g.idePluginState?.ide) {
      case "intellij":
        return "IntelliJ plugin & Hotswap recommended";
      case "vscode":
        return "VS Code extension & Hotswap recommended";
      case "eclipse":
        return "Eclipse plugin & Hotswap recommended";
      default:
        return "IDE plugin & Hotswap recommended";
    }
  }
  closePopover() {
    const e = this.closest("vaadin-popover");
    e && (e.opened = false);
  }
  handleUserLoginClick() {
    if (g.userInfo?.validLicense) {
      window.open("https://vaadin.com/myaccount", "_blank", "noopener");
      return;
    }
    g.setLoginCheckActive(true);
  }
  handleDevelopmentWorkflowClick() {
    fo("use-dev-workflow-guide"), ke.openPanel(Yc), this.closePopover();
  }
  handleAppInfoClick() {
    ke.openPanel(me.INFO), this.closePopover();
  }
  handleAppLogClick() {
    ke.openPanel(me.LOG), this.closePopover();
  }
  handleImpersonateAppUserClick() {
    ke.openPanel(me.IMPERSONATOR), this.closePopover();
  }
  handleSettingsClick() {
    ke.openPanel(me.SETTINGS), this.closePopover();
  }
  handleHelpAndSupportClick() {
    ke.openPanel(me.FEEDBACK), this.closePopover();
  }
};
v = w([
  Sa("copilot-devtools")
], v);
export {
  v as CopilotDevTools
};
