/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.testbench;

import com.vaadin.flow.component.grid.testbench.GridColumnElement;
import com.vaadin.flow.component.grid.testbench.GridElement;
import com.vaadin.flow.component.grid.testbench.GridTHTDElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import java.util.Arrays;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class TreeGridElement
extends GridElement {
    @Override
    @Deprecated(since="25.0")
    public void scrollToRow(int row) {
        this.scrollToRowByPath(row);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void scrollToRowAndWait(int row) {
        this.scrollToRowByPath(row);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void scrollToRowAndWait(int ... indexes) {
        this.scrollToRowByPath(indexes);
    }

    @Deprecated(since="25.0", forRemoval=true)
    public void scrollToFlatRowAndWait(int row) {
        this.scrollToRowByFlatIndex(row);
    }

    @Override
    public void scrollToRowByFlatIndex(int rowFlatIndex) {
        super.scrollToRowByFlatIndex(rowFlatIndex);
    }

    public int scrollToRowByPath(int ... path) {
        this.waitUntilLoadingFinished();
        return (int)((Long)this.getCommandExecutor().getDriver().executeAsyncScript("const [element, path, callback] = arguments;\nconst flatIndex = await element.scrollToIndex(...path);\ncallback(flatIndex);\n", new Object[]{this, path})).longValue();
    }

    public GridTHTDElement getCellWaitForRow(int rowFlatIndex, int colIndex) {
        GridColumnElement column = this.getVisibleColumns().get(colIndex);
        return this.getCellWaitForRow(rowFlatIndex, column);
    }

    public GridTHTDElement getCellWaitForRow(int rowFlatIndex, GridColumnElement column) {
        if (this.getFirstVisibleRowIndex() > rowFlatIndex || rowFlatIndex > this.getLastVisibleRowIndex()) {
            this.scrollToRowByFlatIndex(rowFlatIndex);
        }
        GridTRElement row = this.getRow(rowFlatIndex);
        return row.getCell(column);
    }

    public void expandWithClick(int rowFlatIndex) {
        this.expandWithClick(rowFlatIndex, 0);
    }

    public void expandWithClick(int rowFlatIndex, int hierarchyColumnIndex) {
        if (this.isRowExpanded(rowFlatIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowFlatIndex + " was expanded already");
        }
        this.getExpandToggleElement(rowFlatIndex, hierarchyColumnIndex).click();
        this.waitUntilLoadingFinished();
    }

    public void collapseWithClick(int rowFlatIndex) {
        this.collapseWithClick(rowFlatIndex, 0);
    }

    public void collapseWithClick(int rowFlatIndex, int hierarchyColumnIndex) {
        if (this.isRowCollapsed(rowFlatIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowFlatIndex + " was collapsed already");
        }
        this.getExpandToggleElement(rowFlatIndex, hierarchyColumnIndex).click();
        this.waitUntilLoadingFinished();
    }

    public boolean isRowExpanded(int rowFlatIndex, int hierarchyColumnIndex) {
        this.waitUntilLoadingFinished();
        WebElement expandElement = this.getExpandToggleElement(rowFlatIndex, hierarchyColumnIndex);
        return expandElement != null && !"false".equals(expandElement.getDomProperty("expanded"));
    }

    public boolean isRowCollapsed(int rowFlatIndex, int hierarchyColumnIndex) {
        return !this.isRowExpanded(rowFlatIndex, hierarchyColumnIndex);
    }

    public boolean hasExpandToggle(int rowFlatIndex, int hierarchyColumnIndex) {
        try {
            WebElement expandElement = this.getExpandToggleElement(rowFlatIndex, hierarchyColumnIndex);
            return expandElement != null && expandElement.isDisplayed() && "false".equals(expandElement.getDomProperty("leaf"));
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public WebElement getExpandToggleElement(int rowFlatIndex, int hierarchyColumnIndex) {
        GridTHTDElement cell = this.getCell(rowFlatIndex, hierarchyColumnIndex);
        return cell == null ? null : cell.$("vaadin-grid-tree-toggle").first();
    }

    public boolean isDetailsOpen(int rowFlatIndex) {
        try {
            return this.getRow(rowFlatIndex).getDetails().isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasRow(int rowFlatIndex) {
        try {
            return this.getRow(rowFlatIndex) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getRowCount() {
        return super.getRowCount();
    }

    public void scrollToEnd() {
        int[] path = new int[11];
        Arrays.fill(path, -1);
        this.scrollToRowByPath(path);
    }
}

