/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.testbench;

import com.vaadin.flow.component.grid.testbench.GridColumnElement;
import com.vaadin.flow.component.grid.testbench.GridElement;
import com.vaadin.flow.component.grid.testbench.GridTHTDElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class TreeGridElement
extends GridElement {
    public void scrollToRowAndWait(int row) {
        this.waitUntilLoadingFinished();
        this.scrollToRow(row);
        this.waitUntilLoadingFinished();
    }

    public GridTHTDElement getCellWaitForRow(int rowIndex, int colIndex) {
        GridColumnElement column = this.getVisibleColumns().get(colIndex);
        return this.getCellWaitForRow(rowIndex, column);
    }

    public GridTHTDElement getCellWaitForRow(int rowIndex, GridColumnElement column) {
        if (this.getFirstVisibleRowIndex() > rowIndex || rowIndex > this.getLastVisibleRowIndex()) {
            this.scrollToRowAndWait(rowIndex);
        }
        this.waitUntil(test -> !this.isLoadingExpandedRows());
        GridTRElement row = this.getRow(rowIndex);
        return row.getCell(column);
    }

    public void expandWithClick(int rowIndex) {
        this.expandWithClick(rowIndex, 0);
    }

    public void expandWithClick(int rowIndex, int hierarchyColumnIndex) {
        if (this.isRowExpanded(rowIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowIndex + " was expanded already");
        }
        this.getExpandToggleElement(rowIndex, hierarchyColumnIndex).click();
        this.waitUntilLoadingFinished();
    }

    public void collapseWithClick(int rowIndex) {
        this.collapseWithClick(rowIndex, 0);
    }

    public void collapseWithClick(int rowIndex, int hierarchyColumnIndex) {
        if (this.isRowCollapsed(rowIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowIndex + " was collapsed already");
        }
        this.getExpandToggleElement(rowIndex, hierarchyColumnIndex).click();
        this.waitUntilLoadingFinished();
    }

    public boolean isRowExpanded(int rowIndex, int hierarchyColumnIndex) {
        this.waitUntilLoadingFinished();
        WebElement expandElement = this.getExpandToggleElement(rowIndex, hierarchyColumnIndex);
        return expandElement != null && !"false".equals(expandElement.getAttribute("expanded"));
    }

    public boolean isRowCollapsed(int rowIndex, int hierarchyColumnIndex) {
        return !this.isRowExpanded(rowIndex, hierarchyColumnIndex);
    }

    public boolean hasComponentRenderer(int rowIndex, int columnIndex, By searchContentBy) {
        try {
            WebElement rendererElement = this.getComponentRendererElement(rowIndex, columnIndex);
            return rendererElement != null && rendererElement.isDisplayed() && Optional.ofNullable(searchContentBy).map(by -> rendererElement.findElement(by)).map(WebElement::isDisplayed).orElse(searchContentBy == null) != false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasExpandToggle(int rowIndex, int hierarchyColumnIndex) {
        try {
            WebElement expandElement = this.getExpandToggleElement(rowIndex, hierarchyColumnIndex);
            return expandElement != null && expandElement.isDisplayed() && "false".equals(expandElement.getAttribute("leaf"));
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public WebElement getExpandToggleElement(int rowIndex, int hierarchyColumnIndex) {
        GridTHTDElement cell = this.getCell(rowIndex, hierarchyColumnIndex);
        return cell == null ? null : cell.$("vaadin-grid-tree-toggle").first();
    }

    public WebElement getComponentRendererElement(int rowIndex, int columnIndex) {
        return this.getCell(rowIndex, columnIndex).$("flow-component-renderer").first();
    }

    public long getNumberOfExpandedRows() {
        this.waitUntilLoadingFinished();
        return (Long)this.executeScript("return arguments[0].expandedItems.length;", new Object[]{this});
    }

    public boolean isDetailsOpen(int rowIndex) {
        try {
            return this.getRow(rowIndex).getDetails().isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean hasRow(int row) {
        try {
            return this.getRow(row) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLoadingExpandedRows() {
        return (Boolean)this.executeScript("return !!arguments[0].$connector ? (arguments[0].$connector.hasEnsureSubCacheQueue() || arguments[0].$connector.hasParentRequestQueue()) : arguments[0]._cache.isLoading()", new Object[]{this});
    }

    @Override
    protected boolean isLoading() {
        return super.isLoading() || this.isLoadingExpandedRows();
    }
}

