/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.AbstractGridMultiSelectionModel;
import com.vaadin.flow.component.grid.AbstractGridSingleSelectionModel;
import com.vaadin.flow.component.grid.AbstractRow;
import com.vaadin.flow.component.grid.CellFocusEvent;
import com.vaadin.flow.component.grid.ColumnBase;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.ColumnGroupHelpers;
import com.vaadin.flow.component.grid.ColumnLayer;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.ColumnRendering;
import com.vaadin.flow.component.grid.ColumnReorderEvent;
import com.vaadin.flow.component.grid.ColumnResizeEvent;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.component.grid.GridColumnOrderHelper;
import com.vaadin.flow.component.grid.GridDataCommunicator;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridNoneSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridSingleSelectionModel;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.GridSortOrderBuilder;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.grid.ItemDoubleClickEvent;
import com.vaadin.flow.component.grid.SortOrderProvider;
import com.vaadin.flow.component.grid.contextmenu.GridContextMenu;
import com.vaadin.flow.component.grid.dataview.GridDataView;
import com.vaadin.flow.component.grid.dataview.GridLazyDataView;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.grid.dnd.GridDragEndEvent;
import com.vaadin.flow.component.grid.dnd.GridDragStartEvent;
import com.vaadin.flow.component.grid.dnd.GridDropEvent;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.grid.editor.EditorImpl;
import com.vaadin.flow.component.grid.editor.EditorRenderer;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.component.shared.SelectionPreservationHandler;
import com.vaadin.flow.component.shared.SelectionPreservationMode;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataGenerators;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasLazyDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JacksonSerializer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.spring.data.VaadinSpringDataHelpers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

@Tag(value="vaadin-grid")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/grid", version="25.1.0-alpha7"), @NpmPackage(value="@vaadin/tooltip", version="25.1.0-alpha7")})
@JsModule.Container(value={@JsModule(value="@vaadin/grid/src/vaadin-grid.js"), @JsModule(value="@vaadin/grid/src/vaadin-grid-column.js"), @JsModule(value="@vaadin/grid/src/vaadin-grid-sorter.js"), @JsModule(value="@vaadin/checkbox/src/vaadin-checkbox.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./gridConnector.ts"), @JsModule(value="@vaadin/tooltip/src/vaadin-tooltip.js")})
public class Grid<T>
extends Component
implements HasStyle,
HasSize,
Focusable<Grid<T>>,
SortEvent.SortNotifier<Grid<T>, GridSortOrder<T>>,
HasTheme,
HasDataGenerators<T>,
HasListDataView<T, GridListDataView<T>>,
HasDataView<T, Void, GridDataView<T>>,
HasLazyDataView<T, Void, GridLazyDataView<T>> {
    private NestedNullBehavior nestedNullBehavior = NestedNullBehavior.THROW;
    static final String DRAG_SOURCE_DATA_KEY = "drag-source-data";
    private static MultiSortPriority defaultMultiSortPriority = MultiSortPriority.PREPEND;
    private final GridArrayUpdater arrayUpdater;
    private final CompositeDataGenerator<T> gridDataGenerator;
    private final DataCommunicator<T> dataCommunicator;
    private int nextColumnId = 0;
    private GridSelectionModel<T> selectionModel;
    private SelectionMode selectionMode;
    private SerializablePredicate<T> selectableProvider;
    private final DetailsManager detailsManager;
    private Map<String, Column<T>> idToColumnMap = new HashMap<String, Column<T>>();
    private Map<String, Column<T>> keyToColumnMap = new HashMap<String, Column<T>>();
    private final List<GridSortOrder<T>> sortOrder = new ArrayList<GridSortOrder<T>>();
    private SerializableConsumer<?> filterSlot;
    private Class<T> beanType;
    private PropertySet<T> propertySet;
    private DataGenerator<T> itemDetailsDataGenerator;
    private List<Registration> detailsRenderingRegistrations = new ArrayList<Registration>();
    private List<ColumnLayer> columnLayers = new ArrayList<ColumnLayer>();
    private HeaderRow defaultHeaderRow;
    private String uniqueKeyProperty;
    private ValueProvider<T, String> uniqueKeyProvider;
    private Editor<T> editor;
    private SerializableSupplier<Editor<T>> editorFactory = this::createEditor;
    private SerializableFunction<T, String> partNameGenerator = (SerializableFunction & Serializable)item -> null;
    private SerializablePredicate<T> dropFilter = (SerializablePredicate & Serializable)item -> true;
    private SerializablePredicate<T> dragFilter = (SerializablePredicate & Serializable)item -> true;
    private Map<String, SerializableFunction<T, String>> dragDataGenerators = new HashMap<String, SerializableFunction<T, String>>();
    private Registration dataProviderChangeRegistration;
    private SerializableFunction<T, String> tooltipGenerator = (SerializableFunction & Serializable)item -> null;
    private SelectionPreservationHandler<T> selectionPreservationHandler;
    private PendingJavaScriptResult pendingSorterUpdate;
    private static final String EMPTY_STATE_SLOT = "empty-state";
    private Component emptyStateComponent;
    private String emptyStateText;
    private StateTree.ExecutionRegistration pendingScrollRegistration;

    public static void setDefaultMultiSortPriority(MultiSortPriority priority) {
        defaultMultiSortPriority = priority;
    }

    public Grid() {
        this(50);
    }

    public Grid(DataProvider<T, Void> dataProvider) {
        this();
        this.setItems(dataProvider);
    }

    public Grid(BackEndDataProvider<T, Void> dataProvider) {
        this();
        this.setItems(dataProvider);
    }

    public Grid(InMemoryDataProvider<T> inMemoryDataProvider) {
        this();
        this.setItems(inMemoryDataProvider);
    }

    public Grid(ListDataProvider<T> dataProvider) {
        this();
        this.setItems(dataProvider);
    }

    public Grid(Collection<T> items) {
        this();
        this.setItems(items);
    }

    public Grid(int pageSize) {
        this(pageSize, new DataCommunicatorBuilder());
    }

    public Grid(Class<T> beanType, boolean autoCreateColumns) {
        this();
        this.configureBeanType(beanType, autoCreateColumns);
    }

    public Grid(Class<T> beanType) {
        this(beanType, (DataCommunicatorBuilder)true);
    }

    protected <U extends GridArrayUpdater, B extends DataCommunicatorBuilder<T, U>> Grid(Class<T> beanType, B dataCommunicatorBuilder) {
        this(beanType, dataCommunicatorBuilder, true);
    }

    protected <U extends GridArrayUpdater, B extends DataCommunicatorBuilder<T, U>> Grid(Class<T> beanType, B dataCommunicatorBuilder, boolean autoCreateColumns) {
        this(50, dataCommunicatorBuilder);
        Objects.requireNonNull(dataCommunicatorBuilder, "Data communicator builder can't be null");
        this.configureBeanType(beanType, autoCreateColumns);
    }

    protected <U extends GridArrayUpdater, B extends DataCommunicatorBuilder<T, U>> Grid(int pageSize, B dataCommunicatorBuilder) {
        Objects.requireNonNull(dataCommunicatorBuilder, "Data communicator builder can't be null");
        this.arrayUpdater = this.createDefaultArrayUpdater();
        this.gridDataGenerator = new CompositeDataGenerator();
        this.gridDataGenerator.addDataGenerator(this::generateUniqueKeyData);
        this.gridDataGenerator.addDataGenerator(this::generatePartData);
        this.gridDataGenerator.addDataGenerator(this::generateTooltipTextData);
        this.gridDataGenerator.addDataGenerator(this::generateRowsDragAndDropAccess);
        this.gridDataGenerator.addDataGenerator(this::generateDragData);
        this.gridDataGenerator.addDataGenerator(this::generateSelectableData);
        this.dataCommunicator = dataCommunicatorBuilder.build(this.getElement(), this.gridDataGenerator, (GridArrayUpdater)this.arrayUpdater, this::getUniqueKeyProvider);
        this.detailsManager = new DetailsManager(this);
        this.setPageSize(pageSize);
        this.setSelectionModel(SelectionMode.SINGLE.createModel(this), SelectionMode.SINGLE);
        this.columnLayers.add(new ColumnLayer(this));
        this.addDragStartListener(this::onDragStart);
        this.addDragEndListener(this::onDragEnd);
        this.updateMultiSortPriority(defaultMultiSortPriority);
        this.initSelectionPreservationHandler();
    }

    private void generateUniqueKeyData(T item, ObjectNode jsonObject) {
        if (this.uniqueKeyProperty != null && !jsonObject.has(this.uniqueKeyProperty)) {
            jsonObject.put(this.uniqueKeyProperty, this.getUniqueKey(item));
        }
    }

    private void initSelectionPreservationHandler() {
        this.selectionPreservationHandler = new SelectionPreservationHandler<T>(SelectionPreservationMode.PRESERVE_ALL){

            public void onPreserveAll(DataChangeEvent<T> dataChangeEvent) {
            }

            public void onPreserveExisting(DataChangeEvent<T> dataChangeEvent) {
                Map<Object, Object> deselectionCandidateIdsToItems = Grid.this.getSelectedItems().stream().collect(Collectors.toMap(arg_0 -> Grid.this.getDataProvider().getId(arg_0), item -> item));
                if (deselectionCandidateIdsToItems.isEmpty()) {
                    return;
                }
                Stream itemsStream = Grid.this.getDataProvider().fetch(Grid.this.getDataCommunicator().buildQuery(0, Integer.MAX_VALUE));
                Set<Object> existingItemIds = itemsStream.map(arg_0 -> Grid.this.getDataProvider().getId(arg_0)).filter(deselectionCandidateIdsToItems::containsKey).limit(deselectionCandidateIdsToItems.size()).collect(Collectors.toSet());
                existingItemIds.forEach(deselectionCandidateIdsToItems::remove);
                if (Grid.this.getSelectionModel() instanceof GridMultiSelectionModel) {
                    Grid.this.asMultiSelect().deselect(deselectionCandidateIdsToItems.values());
                } else if (!deselectionCandidateIdsToItems.isEmpty()) {
                    Grid.this.deselectAll();
                }
            }

            public void onDiscard(DataChangeEvent<T> dataChangeEvent) {
                Grid.this.deselectAll();
            }
        };
    }

    private void handleDataChange(DataChangeEvent<T> dataChangeEvent) {
        this.onDataProviderChange();
        if (!(dataChangeEvent instanceof DataChangeEvent.DataRefreshEvent) && !(this.getSelectionModel() instanceof GridNoneSelectionModel)) {
            this.selectionPreservationHandler.handleDataChange(dataChangeEvent);
        }
    }

    protected void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached Grid"))).getPage().executeJs("if ($0) window.Vaadin.Flow.gridConnector.initLazy($0)", new Object[]{this.getElement()});
    }

    protected GridArrayUpdater createDefaultArrayUpdater() {
        return new GridArrayUpdaterImpl();
    }

    public Column<T> addColumn(ValueProvider<T, ?> valueProvider) {
        BiFunction<Renderer<T>, String, Column<T>> defaultFactory = this.getDefaultColumnFactory();
        return this.addColumn(valueProvider, defaultFactory);
    }

    protected <C extends Column<T>> C addColumn(ValueProvider<T, ?> valueProvider, BiFunction<Renderer<T>, String, C> columnFactory) {
        String columnId = this.createColumnId(false);
        C column = this.addColumn(new ColumnPathRenderer(columnId, (ValueProvider & Serializable)item -> this.formatValueToSendToTheClient(this.applyValueProvider(valueProvider, item))), columnFactory);
        ((Column)column).comparator = (SerializableComparator & Serializable)(a, b) -> Grid.compareMaybeComparables(this.applyValueProvider(valueProvider, a), this.applyValueProvider(valueProvider, b));
        return column;
    }

    private Object applyValueProvider(ValueProvider<T, ?> valueProvider, T item) {
        Object value;
        block2: {
            try {
                value = valueProvider.apply(item);
            }
            catch (NullPointerException npe) {
                value = null;
                if (NestedNullBehavior.THROW != this.nestedNullBehavior) break block2;
                throw npe;
            }
        }
        return value;
    }

    private String formatValueToSendToTheClient(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public <V extends Component> Column<T> addComponentColumn(ValueProvider<T, V> componentProvider) {
        return this.addColumn((Renderer<T>)new ComponentRenderer(componentProvider));
    }

    public <V extends Comparable<? super V>> Column<T> addColumn(ValueProvider<T, V> valueProvider, String ... sortingProperties) {
        Column<T> column = this.addColumn(valueProvider);
        column.setComparator(valueProvider);
        column.setSortProperty(sortingProperties);
        return column;
    }

    public Column<T> addColumn(Renderer<T> renderer) {
        BiFunction<Renderer<T>, String, Column<T>> defaultFactory = this.getDefaultColumnFactory();
        return this.addColumn(renderer, defaultFactory);
    }

    protected <C extends Column<T>> C addColumn(Renderer<T> renderer, BiFunction<Renderer<T>, String, C> columnFactory) {
        String columnId = this.createColumnId(true);
        Column column = (Column)columnFactory.apply(renderer, columnId);
        this.idToColumnMap.put(columnId, column);
        column.getElement().setProperty("_flowId", columnId);
        column.addAttachListener((ComponentEventListener & Serializable)e -> e.getUI().beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
            if (!column.isVisible() && column.getUI().isPresent()) {
                int nodeId = column.getElement().getNode().getId();
                String appId = e.getUI().getInternals().getAppId();
                this.getElement().executeJs("Vaadin.Flow.clients[$0].getByNodeId($1)._flowId = $2", new Object[]{appId, nodeId, columnId});
            }
        }));
        AbstractColumn current = column;
        this.columnLayers.get(0).addColumn(column);
        for (int i = 1; i < this.columnLayers.size(); ++i) {
            ColumnGroup group = new ColumnGroup(this, current);
            this.columnLayers.get(i).addColumn(group);
            current = group;
        }
        this.getElement().appendChild(new Element[]{current.getElement()});
        this.refreshViewport();
        return (C)column;
    }

    @Deprecated
    protected Column<T> createColumn(Renderer<T> renderer, String columnId) {
        return new Column<T>(this, columnId, renderer);
    }

    protected BiFunction<Renderer<T>, String, Column<T>> getDefaultColumnFactory() {
        return this::createColumn;
    }

    public Column<T> addColumn(String propertyName) {
        BiFunction<Renderer<T>, String, Column<T>> defaultFactory = this.getDefaultColumnFactory();
        return this.addColumn(propertyName, defaultFactory);
    }

    protected <C extends Column<T>> C addColumn(String propertyName, BiFunction<Renderer<T>, String, C> columnFactory) {
        PropertyDefinition property;
        this.checkForBeanGrid();
        Objects.requireNonNull(propertyName, "Property name can't be null");
        try {
            property = (PropertyDefinition)this.propertySet.getProperty(propertyName).get();
        }
        catch (IllegalArgumentException | NoSuchElementException exception) {
            throw new IllegalArgumentException("Can't resolve property name '" + propertyName + "' from '" + String.valueOf(this.propertySet) + "'");
        }
        return this.addColumn(property, columnFactory);
    }

    private Column<T> addColumn(PropertyDefinition<T, ?> property) {
        BiFunction<Renderer<T>, String, Column<T>> defaultFactory = this.getDefaultColumnFactory();
        return this.addColumn(property, defaultFactory);
    }

    private <C extends Column<T>> C addColumn(PropertyDefinition<T, ?> property, BiFunction<Renderer<T>, String, C> columnFactory) {
        Column<T> column = ((Column)this.addColumn((ValueProvider & Serializable)item -> this.runPropertyValueGetter(property, item), columnFactory)).setHeader(property.getCaption());
        try {
            column.setKey(property.getName());
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Multiple columns for the same property: " + property.getName());
        }
        if (Comparable.class.isAssignableFrom(property.getType())) {
            column.setSortable(true);
        }
        return (C)column;
    }

    private Object runPropertyValueGetter(PropertyDefinition<T, ?> property, T item) {
        return property.getGetter().apply(item);
    }

    public void addColumns(String ... propertyNames) {
        this.checkForBeanGrid();
        Objects.requireNonNull(propertyNames, "Property names can't be null");
        Stream.of(propertyNames).forEach(this::addColumn);
    }

    public void setColumns(String ... propertyNames) {
        this.checkForBeanGrid();
        this.getColumns().forEach(this::removeColumn);
        Stream.of(propertyNames).forEach(this::addColumn);
    }

    public void setSortableColumns(String ... propertyNames) {
        this.checkForBeanGrid();
        this.getColumns().forEach(col -> col.setSortable(false));
        for (String property : propertyNames) {
            Column<T> column = this.getColumnByKey(property);
            if (column == null) {
                throw new IllegalArgumentException("The column for the property '" + property + "' could not be found");
            }
            column.setSortable(true);
        }
    }

    private void checkForBeanGrid() {
        if (this.propertySet == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type. To construct Grid from a bean type, please provide a beanType argumentto the constructor: Grid<Person> grid = new Grid<>(Person.class)");
        }
    }

    protected void setColumnKey(String key, Column column) {
        if (this.keyToColumnMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate key for columns: " + key);
        }
        this.keyToColumnMap.put(key, column);
    }

    protected String createColumnId(boolean increment) {
        int id = this.nextColumnId++;
        if (increment) {
            // empty if block
        }
        return "col" + id;
    }

    public HeaderRow prependHeaderRow() {
        if (this.getHeaderRows().size() == 0) {
            return this.addFirstHeaderRow();
        }
        return this.insertColumnLayer(this.getLastHeaderLayerIndex() + 1).asHeaderRow();
    }

    public HeaderRow appendHeaderRow() {
        if (this.getHeaderRows().size() == 0) {
            return this.addFirstHeaderRow();
        }
        return this.insertInmostColumnLayer(true, false).asHeaderRow();
    }

    public void removeHeaderRow(HeaderRow headerRow) {
        Objects.requireNonNull(headerRow);
        List<HeaderRow> headerRows = this.getHeaderRows();
        if (headerRow.equals(this.defaultHeaderRow)) {
            if (headerRows.size() != 1) {
                throw new UnsupportedOperationException("Default header row cannot be removed while there are other header rows.");
            }
            this.removeDefaultHeaderRow();
        } else {
            if (!headerRows.contains(headerRow)) {
                throw new NoSuchElementException("Header to remove cannot be found.");
            }
            if (this.getColumnLayers().get(0).equals(headerRow.layer)) {
                this.removeNonDefaultHeaderInBottomLayer(headerRow);
            } else {
                this.removeColumnLayer(headerRow.layer);
            }
        }
    }

    private void removeNonDefaultHeaderInBottomLayer(HeaderRow headerRow) {
        List<HeaderRow> headerRows = this.getHeaderRows();
        HeaderRow nextHeaderRow = headerRows.get(headerRows.size() - 2);
        ColumnLayer layerToRemove = nextHeaderRow.layer;
        this.moveRowContent(nextHeaderRow, headerRow);
        headerRow.layer.setHeaderRow(nextHeaderRow);
        if (nextHeaderRow.equals(this.defaultHeaderRow)) {
            nextHeaderRow.layer.updateSortingIndicators(true);
        }
        layerToRemove.setHeaderRow(null);
        this.clearRowContent(headerRow);
        this.removeColumnLayer(layerToRemove);
    }

    public void removeAllHeaderRows() {
        List<HeaderRow> headerRows = this.getHeaderRows();
        if (headerRows.isEmpty()) {
            return;
        }
        Collections.reverse(headerRows);
        headerRows.stream().filter(headerRow -> !headerRow.equals(this.defaultHeaderRow)).forEach(this::removeHeaderRow);
        this.removeDefaultHeaderRow();
    }

    private void removeDefaultHeaderRow() {
        this.defaultHeaderRow.getCells().forEach(headerCell -> headerCell.setText(null));
        this.defaultHeaderRow.layer.setHeaderRow(null);
        this.clearRowContent(this.defaultHeaderRow);
        this.defaultHeaderRow = null;
    }

    protected HeaderRow addFirstHeaderRow() {
        this.defaultHeaderRow = this.columnLayers.get(0).asHeaderRow();
        this.columnLayers.get(0).updateSortingIndicators(true);
        return this.defaultHeaderRow;
    }

    protected HeaderRow getDefaultHeaderRow() {
        return this.defaultHeaderRow;
    }

    public FooterRow prependFooterRow() {
        if (this.getFooterRows().size() == 0) {
            return this.columnLayers.get(0).asFooterRow();
        }
        return this.insertInmostColumnLayer(false, true).asFooterRow();
    }

    public FooterRow appendFooterRow() {
        if (this.getFooterRows().size() == 0) {
            return this.columnLayers.get(0).asFooterRow();
        }
        return this.insertColumnLayer(this.getLastFooterLayerIndex() + 1).asFooterRow();
    }

    public void removeFooterRow(FooterRow footerRow) {
        Objects.requireNonNull(footerRow);
        if (!this.getFooterRows().contains(footerRow)) {
            throw new NoSuchElementException("Footer to remove cannot be found.");
        }
        if (this.getColumnLayers().get(0).equals(footerRow.layer)) {
            this.removeFooterInBottomLayer(footerRow);
        } else {
            this.removeColumnLayer(footerRow.layer);
        }
    }

    private void removeFooterInBottomLayer(FooterRow footerRow) {
        List<FooterRow> footerRows = this.getFooterRows();
        if (footerRows.size() == 1) {
            footerRow.getCells().forEach(footerCell -> footerCell.setText(null));
            footerRow.layer.setFooterRow(null);
            this.clearRowContent(footerRow);
            return;
        }
        FooterRow nextFooterRow = footerRows.get(footerRows.indexOf(footerRow) + 1);
        if (nextFooterRow.getCells().size() != footerRow.getCells().size()) {
            throw new UnsupportedOperationException("Top-most footer row cannot have joined cells.");
        }
        ColumnLayer layerToRemove = nextFooterRow.layer;
        this.moveRowContent(nextFooterRow, footerRow);
        footerRow.layer.setFooterRow(nextFooterRow);
        layerToRemove.setFooterRow(null);
        this.clearRowContent(footerRow);
        this.removeColumnLayer(layerToRemove);
    }

    public void removeAllFooterRows() {
        this.getFooterRows().forEach(this::removeFooterRow);
    }

    private void clearRowContent(AbstractRow<? extends AbstractRow.AbstractCell> row) {
        row.cells.clear();
        row.layer = null;
    }

    private void moveRowContent(AbstractRow<? extends AbstractRow.AbstractCell> sourceRow, AbstractRow<? extends AbstractRow.AbstractCell> targetRow) {
        for (int i = 0; i < sourceRow.cells.size(); ++i) {
            AbstractRow.AbstractCell sourceCell = (AbstractRow.AbstractCell)sourceRow.cells.get(i);
            AbstractRow.AbstractCell targetCell = (AbstractRow.AbstractCell)targetRow.cells.get(i);
            if (sourceCell.getComponent() != null) {
                targetCell.setComponent(sourceCell.getComponent());
                continue;
            }
            targetCell.setText(sourceCell.getText());
        }
    }

    protected List<ColumnLayer> getColumnLayers() {
        return Collections.unmodifiableList(this.columnLayers);
    }

    public List<HeaderRow> getHeaderRows() {
        List<HeaderRow> rows = this.columnLayers.stream().filter(ColumnLayer::isHeaderRow).map(ColumnLayer::asHeaderRow).collect(Collectors.toList());
        Collections.reverse(rows);
        return rows;
    }

    public List<FooterRow> getFooterRows() {
        return this.columnLayers.stream().filter(ColumnLayer::isFooterRow).map(ColumnLayer::asFooterRow).collect(Collectors.toList());
    }

    public void addThemeVariants(GridVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(GridVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(GridVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(GridVariant::getVariantName).collect(Collectors.toList()));
    }

    private ColumnLayer insertColumnLayer(int index) {
        ColumnLayer innerLayer = this.columnLayers.get(index - 1);
        List<AbstractColumn<?>> groups = ColumnGroupHelpers.wrapInSeparateColumnGroups(innerLayer.getColumns(), this);
        ColumnGroupHelpers.propagateTextAlign(innerLayer.getColumns(), groups);
        ColumnLayer layer = new ColumnLayer(this, groups);
        this.columnLayers.add(index, layer);
        return layer;
    }

    protected ColumnLayer insertColumnLayer(int index, List<AbstractColumn<?>> columns) {
        ColumnLayer layer = new ColumnLayer(this, columns);
        this.columnLayers.add(index, layer);
        return layer;
    }

    protected void removeColumnLayer(ColumnLayer layer) {
        if (layer.equals(this.columnLayers.get(0))) {
            throw new IllegalArgumentException("The bottom column layer cannot be removed");
        }
        layer.getColumns().forEach(column -> {
            Element parent = column.getElement().getParent();
            int insertIndex = parent.indexOfChild(column.getElement());
            parent.insertChild(insertIndex, (Element[])((ColumnGroup)column).getChildColumns().stream().map(HasElement::getElement).toArray(Element[]::new));
            column.getElement().removeFromParent();
        });
        this.columnLayers.remove(layer);
    }

    private ColumnLayer insertInmostColumnLayer(boolean forHeaderRow, boolean forFooterRow) {
        ColumnLayer bottomLayer = this.columnLayers.get(0);
        List<AbstractColumn<?>> columns = bottomLayer.getColumns();
        List<AbstractColumn<?>> groups = ColumnGroupHelpers.wrapInSeparateColumnGroups(columns, this);
        ColumnGroupHelpers.propagateTextAlign(columns, groups);
        ColumnLayer newBottomLayer = new ColumnLayer(this, columns);
        IntStream.range(0, groups.size()).forEach(i -> {
            if (forFooterRow) {
                ((AbstractColumn)columns.get(i)).moveFooterContent((AbstractColumn)groups.get(i));
            }
            if (forHeaderRow) {
                ((AbstractColumn)columns.get(i)).moveHeaderContent((AbstractColumn)groups.get(i));
            }
        });
        if (forFooterRow && bottomLayer.isHeaderRow()) {
            newBottomLayer.setHeaderRow(bottomLayer.asHeaderRow());
            bottomLayer.setHeaderRow(null);
        }
        if (forHeaderRow && bottomLayer.isFooterRow()) {
            newBottomLayer.setFooterRow(bottomLayer.asFooterRow());
            bottomLayer.setFooterRow(null);
        }
        bottomLayer.setColumns(groups);
        this.columnLayers.add(0, newBottomLayer);
        if (bottomLayer.isHeaderRow() && bottomLayer.asHeaderRow().equals(this.defaultHeaderRow)) {
            bottomLayer.updateSortingIndicators(true);
            newBottomLayer.updateSortingIndicators(false);
        }
        return newBottomLayer;
    }

    private int getLastHeaderLayerIndex() {
        for (int i = this.columnLayers.size() - 1; i >= 0; --i) {
            if (!this.columnLayers.get(i).isHeaderRow()) continue;
            return i;
        }
        return -1;
    }

    private int getLastFooterLayerIndex() {
        for (int i = this.columnLayers.size() - 1; i >= 0; --i) {
            if (!this.columnLayers.get(i).isFooterRow()) continue;
            return i;
        }
        return -1;
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "data provider cannot be null");
        if (SelectionPreservationMode.PRESERVE_EXISTING.equals((Object)this.getSelectionPreservationMode()) && !dataProvider.isInMemory()) {
            throw new UnsupportedOperationException("Lazy data providers do not support preserve existing selection mode.");
        }
        this.handleDataProviderChange(dataProvider);
        this.deselectAll();
        this.filterSlot = this.getDataCommunicator().setDataProvider(dataProvider, null);
        if (this.getSelectionModel() instanceof GridMultiSelectionModel) {
            GridMultiSelectionModel model = (GridMultiSelectionModel)this.getSelectionModel();
            model.setSelectAllCheckboxVisibility(model.getSelectAllCheckboxVisibility());
        }
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.getDataCommunicator().getDataProvider();
    }

    public GridDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public GridDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public GridDataView<T> getGenericDataView() {
        return new GridDataView<T>(this.getDataCommunicator(), this);
    }

    public GridListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public GridListDataView<T> getListDataView() {
        return new GridListDataView<T>(this.getDataCommunicator(), this, this::onInMemoryFilterOrSortingChange);
    }

    public GridLazyDataView<T> setItems(BackEndDataProvider<T, Void> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getLazyDataView();
    }

    public GridLazyDataView<T> setItemsPageable(SpringData.FetchCallback<Pageable, T> fetchCallback) {
        return (GridLazyDataView)this.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> Grid.handleSpringFetchCallback(query, fetchCallback));
    }

    public GridLazyDataView<T> setItemsPageable(SpringData.FetchCallback<Pageable, T> fetchCallback, SpringData.CountCallback<Pageable> countCallback) {
        return (GridLazyDataView)this.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> Grid.handleSpringFetchCallback(query, fetchCallback), (CallbackDataProvider.CountCallback & Serializable)query -> Grid.handleSpringCountCallback(query, countCallback));
    }

    private static <PAGEABLE, T> Stream<T> handleSpringFetchCallback(Query<T, Void> query, SpringData.FetchCallback<PAGEABLE, T> fetchCallback) {
        PageRequest pageable = VaadinSpringDataHelpers.toSpringPageRequest(query);
        List<T> itemList = fetchCallback.fetch(pageable);
        return itemList.stream();
    }

    private static <PAGEABLE> int handleSpringCountCallback(Query<?, Void> query, SpringData.CountCallback<PAGEABLE> countCallback) {
        PageRequest pageable = VaadinSpringDataHelpers.toSpringPageRequest(query);
        long count = countCallback.count(pageable);
        if (count > Integer.MAX_VALUE) {
            LoggerFactory.getLogger(Grid.class).warn("The count of items in the backend ({}) exceeds the maximum supported by the Grid.", (Object)count);
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    public GridLazyDataView<T> getLazyDataView() {
        return new GridLazyDataView<T>(this.getDataCommunicator(), this);
    }

    public DataCommunicator<T> getDataCommunicator() {
        return this.dataCommunicator;
    }

    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 50);
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("The pageSize should be greater than zero. Was " + pageSize);
        }
        this.getElement().setProperty("pageSize", (double)pageSize);
        this.getElement().executeJs("if (this.$connector) { this.$connector.reset() }", new Object[0]);
        this.getDataCommunicator().setPageSize(pageSize);
        this.setViewportRange(0, pageSize);
        this.getDataCommunicator().reset();
    }

    public GridSelectionModel<T> getSelectionModel() {
        assert (this.selectionModel != null) : "No selection model set by " + ((Object)((Object)this)).getClass().getName() + " constructor";
        return this.selectionModel;
    }

    protected void setSelectionModel(GridSelectionModel<T> model, SelectionMode selectionMode) {
        Objects.requireNonNull(model, "selection model cannot be null");
        Objects.requireNonNull(selectionMode, "selection mode cannot be null");
        if (this.selectionModel != null && this.selectionModel instanceof AbstractGridExtension) {
            ((AbstractGridExtension)((Object)this.selectionModel)).remove();
        }
        this.selectionModel = model;
        this.selectionMode = selectionMode;
        this.updateSelectionModeOnClient();
    }

    protected void updateSelectionModeOnClient() {
        this.getElement().executeJs("if (this.$connector) { this.$connector.setSelectionMode($0) }", new Object[]{this.selectionMode.name()});
    }

    public SelectionMode getSelectionMode() {
        assert (this.selectionMode != null) : "No selection mode set by " + ((Object)((Object)this)).getClass().getName() + " constructor";
        return this.selectionMode;
    }

    public GridSelectionModel<T> setSelectionMode(SelectionMode selectionMode) {
        Objects.requireNonNull(selectionMode, "Selection mode cannot be null.");
        GridSelectionModel model = selectionMode.createModel(this);
        this.setSelectionModel(model, selectionMode);
        return model;
    }

    SerializablePredicate<T> getItemSelectableProvider() {
        return this.selectableProvider;
    }

    public void setItemSelectableProvider(SerializablePredicate<T> provider) {
        this.selectableProvider = provider;
        this.getDataCommunicator().reset();
        GridSelectionModel<T> gridSelectionModel = this.selectionModel;
        if (gridSelectionModel instanceof AbstractGridMultiSelectionModel) {
            AbstractGridMultiSelectionModel multiSelectionModel = (AbstractGridMultiSelectionModel)gridSelectionModel;
            multiSelectionModel.updateSelectAllCheckBoxVisibility();
        }
    }

    boolean isItemSelectable(T item) {
        return this.selectableProvider == null || this.selectableProvider.test(item);
    }

    public SingleSelect<Grid<T>, T> asSingleSelect() {
        GridSelectionModel<T> model = this.getSelectionModel();
        if (!(model instanceof GridSingleSelectionModel)) {
            throw new IllegalStateException("Grid is not in single select mode, it needs to be explicitly set to such with setSelectionMode(SelectionMode.SINGLE) before being able to use single selection features.");
        }
        return ((GridSingleSelectionModel)model).asSingleSelect();
    }

    public MultiSelect<Grid<T>, T> asMultiSelect() {
        GridSelectionModel<T> model = this.getSelectionModel();
        if (!(model instanceof GridMultiSelectionModel)) {
            throw new IllegalStateException("Grid is not in multi select mode, it needs to be explicitly set to such with setSelectionMode(SelectionMode.MULTI) before being able to use multi selection features.");
        }
        return ((GridMultiSelectionModel)model).asMultiSelect();
    }

    public Set<T> getSelectedItems() {
        return this.getSelectionModel().getSelectedItems();
    }

    public void select(T item) {
        this.getSelectionModel().select(item);
    }

    public void deselect(T item) {
        this.getSelectionModel().deselect(item);
    }

    public void deselectAll() {
        this.getSelectionModel().deselectAll();
    }

    public void setSelectionPreservationMode(SelectionPreservationMode selectionPreservationMode) {
        if (SelectionPreservationMode.PRESERVE_EXISTING.equals((Object)selectionPreservationMode) && !this.getDataProvider().isInMemory()) {
            throw new UnsupportedOperationException("Lazy data providers do not support preserve existing selection mode.");
        }
        this.selectionPreservationHandler.setSelectionPreservationMode(selectionPreservationMode);
    }

    public SelectionPreservationMode getSelectionPreservationMode() {
        return this.selectionPreservationHandler.getSelectionPreservationMode();
    }

    void doClientSideSelection(Set<T> items) {
        this.callSelectionFunctionForItems("doSelection", items);
    }

    void doClientSideDeselection(Set<T> items) {
        this.callSelectionFunctionForItems("doDeselection", items);
    }

    boolean isInActiveRange(T item) {
        return this.getDataCommunicator().getKeyMapper().has(item);
    }

    private void callSelectionFunctionForItems(String function, Set<T> items) {
        if (items.isEmpty()) {
            return;
        }
        ArrayNode jsonArray = JacksonUtils.createArrayNode();
        for (T item : items) {
            JsonNode jsonObject = item != null ? this.generateJsonForSelection(item) : null;
            jsonArray.add(jsonObject);
        }
        this.callJsFunctionBeforeClientResponse("$connector." + function, new Serializable[]{jsonArray, Boolean.valueOf(false)});
    }

    private JsonNode generateJsonForSelection(T item) {
        ObjectNode json = JacksonUtils.createObjectNode();
        json.put("key", this.getDataCommunicator().getKeyMapper().key(item));
        return json;
    }

    private void callJsFunctionBeforeClientResponse(String functionName, Serializable ... arguments) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.getElement().callJsFunction(functionName, arguments)));
    }

    protected void scheduleScrollExecution(SerializableRunnable action) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> {
            if (this.pendingScrollRegistration != null) {
                this.pendingScrollRegistration.remove();
            }
            this.pendingScrollRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                action.run();
                this.pendingScrollRegistration = null;
            });
        });
    }

    public Registration addSelectionListener(SelectionListener<Grid<T>, T> listener) {
        return this.getSelectionModel().addSelectionListener(listener);
    }

    public void setItemDetailsRenderer(Renderer<T> renderer) {
        this.detailsRenderingRegistrations.forEach(Registration::remove);
        this.detailsRenderingRegistrations.clear();
        if (renderer == null) {
            return;
        }
        Rendering rendering = renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper(), "rowDetailsRenderer");
        rendering.getDataGenerator().ifPresent(renderingDataGenerator -> {
            this.itemDetailsDataGenerator = renderingDataGenerator;
            Registration & Serializable detailsRenderingDataGeneratorRegistration = (Registration & Serializable)() -> {
                this.detailsManager.destroyAllData();
                this.itemDetailsDataGenerator = null;
            };
            this.detailsRenderingRegistrations.add(detailsRenderingDataGeneratorRegistration);
        });
        this.detailsRenderingRegistrations.add(rendering.getRegistration());
    }

    @Synchronize(value={"column-reordering-allowed-changed"})
    public boolean isColumnReorderingAllowed() {
        return this.getElement().getProperty("columnReorderingAllowed", false);
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        if (this.isColumnReorderingAllowed() != columnReorderingAllowed) {
            this.getElement().setProperty("columnReorderingAllowed", columnReorderingAllowed);
        }
    }

    private List<ColumnBase<?>> getTopLevelColumns() {
        return this.getElement().getChildren().map(element -> element.getComponent()).filter(component -> component.isPresent() && component.get() instanceof ColumnBase).map(component -> (ColumnBase)component.get()).collect(Collectors.toList());
    }

    public List<Column<T>> getColumns() {
        ArrayList ret = new ArrayList();
        this.getTopLevelColumns().forEach(column -> this.appendChildColumns(ret, (ColumnBase<?>)column));
        return Collections.unmodifiableList(ret);
    }

    public Column<T> getColumnByKey(String columnKey) {
        return this.keyToColumnMap.get(columnKey);
    }

    protected final Column<T> getColumnByInternalId(String internalId) {
        return this.idToColumnMap.get(internalId);
    }

    public void removeColumnByKey(String columnKey) {
        Objects.requireNonNull(columnKey, "columnKey should not be null");
        Column<T> columnByKey = this.getColumnByKey(columnKey);
        if (columnByKey == null) {
            throw new IllegalArgumentException("The column with key '" + columnKey + "' is not part of this Grid");
        }
        this.removeColumn(columnByKey);
    }

    void ensureOwner(Column<T> column) {
        if (!((Object)((Object)column.getGrid())).equals((Object)this) || column.getElement().getParent() == null) {
            throw new IllegalArgumentException("The column with key '" + column.getKey() + "' is not owned by this Grid");
        }
    }

    public void removeColumn(Column<T> column) {
        Objects.requireNonNull(column, "column should not be null");
        this.ensureOwner(column);
        ArrayList<GridSortOrder<T>> order = new ArrayList<GridSortOrder<T>>();
        this.setSortOrder(order, false);
        this.removeColumnAndColumnGroupsIfNeeded(column);
        column.destroyDataGenerators();
        this.keyToColumnMap.remove(column.getKey());
        this.idToColumnMap.remove(column.getInternalId());
    }

    public void removeColumns(Column<T> ... columns) {
        for (Column<T> column : columns) {
            this.removeColumn(column);
        }
    }

    public void removeAllColumns() {
        this.getColumns().forEach(c -> this.removeColumn((Column<T>)c));
    }

    private void removeColumnAndColumnGroupsIfNeeded(Column<?> column) {
        Component parent = (Component)column.getParent().get();
        parent.getElement().removeChild(new Element[]{column.getElement()});
        this.columnLayers.get(0).removeColumn(column);
        if (!parent.equals((Object)this)) {
            this.removeEmptyColumnGroups((ColumnGroup)parent, 1);
        }
    }

    private void removeEmptyColumnGroups(ColumnGroup columnGroup, int columnLayerIndex) {
        Component parent = (Component)columnGroup.getParent().get();
        if (columnGroup.getChildColumns().size() == 0) {
            parent.getElement().removeChild(new Element[]{columnGroup.getElement()});
            this.columnLayers.get(columnLayerIndex).removeColumn(columnGroup);
            if (!parent.equals((Object)this)) {
                this.removeEmptyColumnGroups((ColumnGroup)parent, columnLayerIndex + 1);
            }
        }
    }

    public void setDetailsVisible(T item, boolean visible) {
        this.detailsManager.setDetailsVisible(item, visible);
    }

    public void setDetailsVisibleOnClick(boolean detailsVisibleOnClick) {
        this.getElement().setProperty("__disallowDetailsOnClick", !detailsVisibleOnClick);
    }

    public boolean isDetailsVisibleOnClick() {
        return !this.getElement().getProperty("__disallowDetailsOnClick", false);
    }

    public boolean isDetailsVisible(T item) {
        return this.detailsManager.isDetailsVisible(item);
    }

    public Registration addSortListener(ComponentEventListener<SortEvent<Grid<T>, GridSortOrder<T>>> listener) {
        return this.addListener(SortEvent.class, listener);
    }

    public void setMultiSort(boolean multiSort) {
        this.doSetMultiSort(multiSort);
    }

    public void setMultiSort(boolean multiSort, MultiSortPriority priority) {
        this.doSetMultiSort(multiSort);
        this.updateMultiSortPriority(priority);
    }

    public void setMultiSort(boolean multiSort, boolean onShiftClickOnly) {
        this.doSetMultiSort(multiSort);
        if (multiSort) {
            this.updateMultiSortOnShiftClick(onShiftClickOnly);
        }
    }

    public void setMultiSort(boolean multiSort, MultiSortPriority priority, boolean onShiftClickOnly) {
        this.doSetMultiSort(multiSort);
        this.updateMultiSortPriority(priority);
        if (multiSort) {
            this.updateMultiSortOnShiftClick(onShiftClickOnly);
        }
    }

    private void doSetMultiSort(boolean multiSort) {
        this.getElement().setAttribute("multi-sort", multiSort);
        if (!multiSort) {
            this.updateMultiSortOnShiftClick(false);
        }
    }

    private void updateMultiSortOnShiftClick(boolean multiSortOnShiftClick) {
        this.getElement().setProperty("multiSortOnShiftClick", multiSortOnShiftClick);
    }

    private void updateMultiSortPriority(MultiSortPriority priority) {
        Objects.requireNonNull(priority, "Multi-sort priority must not be null");
        this.getElement().setAttribute("multi-sort-priority", priority == MultiSortPriority.APPEND ? "append" : "prepend");
    }

    public boolean isMultiSort() {
        String multiSort = this.getElement().getAttribute("multi-sort");
        if (multiSort != null && multiSort.length() == 0) {
            multiSort = "true";
        }
        return Boolean.parseBoolean(multiSort);
    }

    @ClientCallable
    private void updateContextMenuTargetItem(String key, String colId) {
        this.getElement().setProperty("_contextMenuTargetItemKey", key);
        this.getElement().setProperty("_contextMenuTargetColumnId", colId);
    }

    public void setAriaLabel(String ariaLabel) {
        if (ariaLabel == null) {
            this.getElement().removeProperty("accessibleName");
        } else {
            this.getElement().setProperty("accessibleName", ariaLabel);
        }
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public GridContextMenu<T> addContextMenu() {
        return new GridContextMenu(this);
    }

    private List<Column<T>> fetchChildColumns(ColumnGroup columnGroup) {
        ArrayList<Column<T>> ret = new ArrayList<Column<T>>();
        columnGroup.getChildColumns().forEach(column -> this.appendChildColumns((List<Column<T>>)ret, (ColumnBase<?>)column));
        return ret;
    }

    private void appendChildColumns(List<Column<T>> list, ColumnBase<?> column) {
        if (column instanceof Column) {
            list.add((Column)column);
        } else if (column instanceof ColumnGroup) {
            list.addAll(this.fetchChildColumns((ColumnGroup)column));
        }
    }

    @ClientCallable
    private void select(String key) {
        this.findByKey(String.valueOf(key)).ifPresent(this.getSelectionModel()::selectFromClient);
    }

    @ClientCallable
    private void deselect(String key) {
        this.findByKey(String.valueOf(key)).ifPresent(this.getSelectionModel()::deselectFromClient);
    }

    private Optional<T> findByKey(String key) {
        Objects.requireNonNull(key);
        Optional<Object> item = Optional.ofNullable(this.getDataCommunicator().getKeyMapper().get(key));
        if (!item.isPresent()) {
            LoggerFactory.getLogger(Grid.class).debug("Key not found: {}. This can happen due to user action while changing the data provider.", (Object)key);
        }
        return item;
    }

    @AllowInert
    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void confirmUpdate(int id) {
        this.getDataCommunicator().confirmUpdate(id);
    }

    @AllowInert
    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setViewportRange(int start, int length) {
        if (length > 500 && length / this.getPageSize() > 10 && this.isAllRowsVisible()) {
            throw new IllegalArgumentException("Attempted to fetch more items from server than allowed in one go. Maximum allowed page count is 10. Consider not using setAllRowsVisible(true) when you have a large amount of items (not only to cover this issue but also to avoid performance bottlenecks resulting from transferring the full item data set at once and then rendering an excess amount of DOM elements). If for some reason this is not an option, increase the page size of the grid so that rendering every item at once doesn't result in a request for over 10 pages.");
        }
        this.getDataCommunicator().setViewportRange(start, length);
    }

    @ClientCallable
    private void setDetailsVisible(String key) {
        if (key == null) {
            this.detailsManager.setDetailsVisibleFromClient(Collections.emptySet());
        } else {
            this.findByKey(key).map(Collections::singleton).ifPresent(this.detailsManager::setDetailsVisibleFromClient);
        }
    }

    @ClientCallable
    private void sortersChanged(ArrayNode sorters) {
        GridSortOrderBuilder sortOrderBuilder = new GridSortOrderBuilder();
        block8: for (int i = 0; i < sorters.size(); ++i) {
            JsonNode sorter = sorters.get(i);
            Column<T> column = this.idToColumnMap.get(sorter.get("path").asString());
            if (column == null) {
                throw new IllegalArgumentException("Received a sorters changed call from the client for a non-existent column");
            }
            if (!sorter.has("direction") || sorter.get("direction").getNodeType() != JsonNodeType.STRING) continue;
            switch (sorter.get("direction").asString()) {
                case "asc": {
                    sortOrderBuilder.thenAsc(column);
                    continue block8;
                }
                case "desc": {
                    sortOrderBuilder.thenDesc(column);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Received a sorters changed call from the client containing an invalid sorting direction");
                }
            }
        }
        this.setSortOrder(sortOrderBuilder.build(), true);
    }

    public void sort(List<GridSortOrder<T>> order) {
        if (order == null) {
            order = Collections.emptyList();
        }
        if (!this.isMultiSort() && order.size() > 1) {
            LoggerFactory.getLogger(Grid.class).warn("Multiple sort columns provided but multi-sorting is not enabled.");
            order = order.subList(0, 1);
        }
        this.setSortOrder(order, false);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.initConnector();
        this.updateClientSideSorterIndicators(this.sortOrder);
        this.updateSelectionModeOnClient();
        if (this.getDataProvider() != null) {
            this.handleDataProviderChange(this.getDataProvider());
        }
        this.dataCommunicator.reset();
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderChangeRegistration != null) {
            this.dataProviderChangeRegistration.remove();
            this.dataProviderChangeRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    private void setSortOrder(List<GridSortOrder<T>> order, boolean userOriginated) {
        Objects.requireNonNull(order, "Sort order list cannot be null");
        if (this.sortOrder.equals(order)) {
            return;
        }
        if (!userOriginated) {
            this.updateClientSideSorterIndicators(order);
        }
        this.sortOrder.clear();
        if (order.isEmpty()) {
            this.getDataCommunicator().setBackEndSorting(Collections.emptyList());
            this.getDataCommunicator().setInMemorySorting((SerializableComparator)DataViewUtils.getComponentSortComparator((Component)this).orElse(null));
            this.fireEvent((ComponentEvent)new SortEvent((Component)this, new ArrayList<GridSortOrder<T>>(this.sortOrder), userOriginated));
            return;
        }
        this.sortOrder.addAll(order);
        this.updateSorting(userOriginated);
    }

    public List<GridSortOrder<T>> getSortOrder() {
        return Collections.unmodifiableList(this.sortOrder);
    }

    private void updateClientSideSorterIndicators() {
        this.updateClientSideSorterIndicators(this.sortOrder);
    }

    private void updateClientSideSorterIndicators(List<GridSortOrder<T>> order) {
        if (this.pendingSorterUpdate != null && !this.pendingSorterUpdate.isSentToBrowser()) {
            this.pendingSorterUpdate.cancelExecution();
        }
        ArrayNode directions = JacksonUtils.createArrayNode();
        for (GridSortOrder<T> gridSortOrder : order) {
            ObjectNode direction = JacksonUtils.createObjectNode();
            String columnId = ((Column)gridSortOrder.getSorted()).getInternalId();
            direction.put("column", columnId);
            if (gridSortOrder.getDirection() != null) {
                switch (gridSortOrder.getDirection()) {
                    case ASCENDING: {
                        direction.put("direction", "asc");
                        break;
                    }
                    case DESCENDING: {
                        direction.put("direction", "desc");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown gridSortOrder: " + String.valueOf(gridSortOrder.getDirection()));
                    }
                }
            }
            directions.add((JsonNode)direction);
        }
        if (this.getElement().getNode().isAttached()) {
            this.pendingSorterUpdate = this.getElement().executeJs("if (this.$connector) { this.$connector.setSorterDirections($0) }", new Object[]{directions});
        }
    }

    private void updateSorting(boolean userOriginated) {
        this.updateInMemorySorting(DataViewUtils.getComponentSortComparator((Component)this).orElse(null));
        ArrayList sortProperties = new ArrayList();
        this.sortOrder.stream().map(order -> ((Column)order.getSorted()).getSortOrder(order.getDirection())).forEach(s -> s.forEach(sortProperties::add));
        this.getDataCommunicator().setBackEndSorting(sortProperties);
        this.fireEvent((ComponentEvent)new SortEvent((Component)this, new ArrayList<GridSortOrder<T>>(this.sortOrder), userOriginated));
    }

    protected SerializableComparator<T> createSortingComparator() {
        BinaryOperator operator = (comparator1, comparator2) -> comparator1.thenComparing((Comparator)comparator2)::compare;
        return this.sortOrder.stream().map(order -> ((Column)order.getSorted()).getComparator(order.getDirection())).reduce(operator).orElse(null);
    }

    public void setAllRowsVisible(boolean allRowsVisible) {
        this.getElement().setProperty("allRowsVisible", allRowsVisible);
    }

    @Synchronize(value={"all-rows-visible-changed"})
    public boolean isAllRowsVisible() {
        return this.getElement().getProperty("allRowsVisible", false);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getDataCommunicator().reset();
    }

    public Registration addValueProvider(String property, ValueProvider<T, ?> valueProvider) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(valueProvider);
        return this.addDataGenerator((DataGenerator & Serializable)(item, data) -> data.set(property, JacksonSerializer.toJson((Object)this.applyValueProvider(valueProvider, item))));
    }

    public Registration addDataGenerator(DataGenerator<T> dataGenerator) {
        return this.gridDataGenerator.addDataGenerator(dataGenerator);
    }

    protected static int compareMaybeComparables(Object a, Object b) {
        if (Grid.hasCommonComparableBaseType(a, b)) {
            return Grid.compareComparables(a, b);
        }
        return Grid.compareComparables(Objects.toString(a, ""), Objects.toString(b, ""));
    }

    public void configureBeanType(Class<T> beanType, boolean autoCreateColumns) {
        Objects.requireNonNull(beanType, "Bean type can't be null");
        if (this.beanType != null) {
            throw new IllegalStateException("configureBeanType can only be called for a Grid without a beanType set");
        }
        if (!this.getColumns().isEmpty()) {
            throw new IllegalStateException("configureBeanType can only be called for a Grid without any columns");
        }
        this.beanType = beanType;
        this.propertySet = BeanPropertySet.get(beanType);
        if (autoCreateColumns) {
            this.propertySet.getProperties().filter(property -> !property.isSubProperty()).forEach(this::addColumn);
        }
    }

    public Class<T> getBeanType() {
        return this.beanType;
    }

    public PropertySet<T> getPropertySet() {
        return this.propertySet;
    }

    public Registration addItemClickListener(ComponentEventListener<ItemClickEvent<T>> listener) {
        return this.addListener(ItemClickEvent.class, Objects.requireNonNull(listener));
    }

    public Registration addColumnResizeListener(ComponentEventListener<ColumnResizeEvent<T>> listener) {
        return this.addListener(ColumnResizeEvent.class, Objects.requireNonNull(listener));
    }

    public Registration addItemDoubleClickListener(ComponentEventListener<ItemDoubleClickEvent<T>> listener) {
        return this.addListener(ItemDoubleClickEvent.class, Objects.requireNonNull(listener));
    }

    public Registration addCellFocusListener(ComponentEventListener<CellFocusEvent<T>> listener) {
        return this.addListener(CellFocusEvent.class, Objects.requireNonNull(listener));
    }

    public Editor<T> getEditor() {
        if (this.editor == null) {
            this.editor = (Editor)this.editorFactory.get();
        }
        return this.editor;
    }

    public void setPartNameGenerator(SerializableFunction<T, String> partNameGenerator) {
        Objects.requireNonNull(partNameGenerator, "Part name generator can not be null");
        this.partNameGenerator = partNameGenerator;
        this.refreshViewport();
    }

    public void recalculateColumnWidths() {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> this.getElement().callJsFunction("recalculateColumnWidths", new Object[0])));
    }

    public SerializableFunction<T, String> getPartNameGenerator() {
        return this.partNameGenerator;
    }

    private void generateTooltipTextData(T item, ObjectNode jsonObject) {
        ObjectNode tooltips = JacksonUtils.createObjectNode();
        String rowTooltip = (String)this.tooltipGenerator.apply(item);
        if (rowTooltip != null) {
            tooltips.put("row", rowTooltip);
        }
        this.idToColumnMap.forEach((id, column) -> {
            String cellTooltip = (String)column.tooltipGenerator.apply(item);
            if (cellTooltip != null) {
                tooltips.put(id, cellTooltip);
            }
        });
        if (!JacksonUtils.getKeys((JsonNode)tooltips).isEmpty()) {
            jsonObject.set("gridtooltips", (JsonNode)tooltips);
        }
    }

    private void generatePartData(T item, ObjectNode jsonObject) {
        ObjectNode part = JacksonUtils.createObjectNode();
        String rowPartName = (String)this.partNameGenerator.apply(item);
        if (rowPartName != null) {
            part.put("row", rowPartName);
        }
        this.idToColumnMap.forEach((id, column) -> {
            String cellPartName = (String)column.getPartNameGenerator().apply(item);
            if (cellPartName != null) {
                part.put(id, cellPartName);
            }
        });
        if (!JacksonUtils.getKeys((JsonNode)part).isEmpty()) {
            jsonObject.set("part", (JsonNode)part);
        }
    }

    private void generateRowsDragAndDropAccess(T item, ObjectNode jsonObject) {
        if (this.getDropMode() != null && !this.dropFilter.test(item)) {
            jsonObject.put("dropDisabled", true);
        }
        if (this.isRowsDraggable() && !this.dragFilter.test(item)) {
            jsonObject.put("dragDisabled", true);
        }
    }

    private void generateDragData(T item, ObjectNode jsonObject) {
        ObjectNode dragData = JacksonUtils.createObjectNode();
        this.dragDataGenerators.entrySet().forEach(entry -> dragData.put((String)entry.getKey(), (String)((SerializableFunction)entry.getValue()).apply(item)));
        if (!JacksonUtils.getKeys((JsonNode)dragData).isEmpty()) {
            jsonObject.set("dragData", (JsonNode)dragData);
        }
    }

    private void generateSelectableData(T item, ObjectNode jsonObject) {
        if (this.selectableProvider != null) {
            boolean selectable = this.selectableProvider.test(item);
            jsonObject.put("selectable", selectable);
        }
    }

    protected Editor<T> createEditor() {
        return new EditorImpl<T>(this, this.propertySet);
    }

    protected ValueProvider<T, String> getUniqueKeyProvider() {
        return this.uniqueKeyProvider;
    }

    protected void setUniqueKeyProvider(ValueProvider<T, String> uniqueKeyProvider) {
        this.uniqueKeyProvider = uniqueKeyProvider;
    }

    protected String getUniqueKeyProperty() {
        return this.uniqueKeyProperty;
    }

    protected void setUniqueKeyProperty(String uniqueKeyProperty) {
        this.uniqueKeyProperty = uniqueKeyProperty;
        if (uniqueKeyProperty != null) {
            this.getElement().callJsFunction("$connector.updateUniqueItemIdPath", new Object[]{uniqueKeyProperty});
        }
    }

    protected GridArrayUpdater getArrayUpdater() {
        return this.arrayUpdater;
    }

    protected void onDataProviderChange() {
        SerializableSupplier<Editor<T>> factory = this.editorFactory;
        this.editorFactory = (SerializableSupplier & Serializable)() -> null;
        try {
            Editor<T> editor = this.getEditor();
            if (editor != null) {
                if (this.getEditor().isBuffered()) {
                    this.getEditor().cancel();
                } else {
                    this.getEditor().closeEditor();
                }
            }
        }
        finally {
            this.editorFactory = factory;
        }
    }

    private static boolean hasCommonComparableBaseType(Object a, Object b) {
        if (a instanceof Comparable && b instanceof Comparable) {
            Class<?> bClass;
            Class<?> aClass = a.getClass();
            if (aClass == (bClass = b.getClass())) {
                return true;
            }
            Class baseType = ReflectTools.findCommonBaseType(aClass, bClass);
            if (Comparable.class.isAssignableFrom(baseType)) {
                return true;
            }
        }
        return a == null && b instanceof Comparable || b == null && a instanceof Comparable;
    }

    private static int compareComparables(Object a, Object b) {
        return Comparator.nullsLast(Comparator.naturalOrder()).compare(a, b);
    }

    private void handleDataProviderChange(DataProvider<T, ?> dataProvider) {
        this.onDataProviderChange();
        if (this.dataProviderChangeRegistration != null) {
            this.dataProviderChangeRegistration.remove();
        }
        this.dataProviderChangeRegistration = dataProvider.addDataProviderListener(this::handleDataChange);
    }

    public Registration addDropListener(ComponentEventListener<GridDropEvent<T>> listener) {
        return this.addListener(GridDropEvent.class, listener);
    }

    public Registration addDragStartListener(ComponentEventListener<GridDragStartEvent<T>> listener) {
        return this.addListener(GridDragStartEvent.class, listener);
    }

    public Registration addDragEndListener(ComponentEventListener<GridDragEndEvent<T>> listener) {
        return this.addListener(GridDragEndEvent.class, listener);
    }

    public void setDropMode(GridDropMode dropMode) {
        this.getElement().setProperty("dropMode", dropMode == null ? null : dropMode.getClientName());
        this.refreshViewport();
    }

    public GridDropMode getDropMode() {
        String dropMode = this.getElement().getProperty("dropMode");
        Optional<GridDropMode> mode = Arrays.stream(GridDropMode.values()).filter(dm -> dm.getClientName().equals(dropMode)).findFirst();
        return mode.orElse(null);
    }

    public void setRowsDraggable(boolean rowsDraggable) {
        this.getElement().setProperty("rowsDraggable", rowsDraggable);
        this.refreshViewport();
    }

    public boolean isRowsDraggable() {
        return this.getElement().getProperty("rowsDraggable", false);
    }

    public SerializablePredicate<T> getDropFilter() {
        return this.dropFilter;
    }

    public SerializablePredicate<T> getDragFilter() {
        return this.dragFilter;
    }

    public void setDropFilter(SerializablePredicate<T> dropFilter) {
        Objects.requireNonNull(dropFilter, "Drop filter can not be null");
        this.dropFilter = dropFilter;
        this.refreshViewport();
    }

    public void setDragFilter(SerializablePredicate<T> dragFilter) {
        Objects.requireNonNull(dragFilter, "Drag filter can not be null");
        this.dragFilter = dragFilter;
        this.refreshViewport();
    }

    public void setDragDataGenerator(String type, SerializableFunction<T, String> dragDataGenerator) {
        this.dragDataGenerators.put(type, dragDataGenerator);
        ArrayNode types = JacksonUtils.createArrayNode();
        this.dragDataGenerators.keySet().forEach(arg_0 -> ((ArrayNode)types).add(arg_0));
        this.getElement().setPropertyJson("__dragDataTypes", (BaseJsonNode)types);
        this.refreshViewport();
    }

    public void setTooltipGenerator(SerializableFunction<T, String> tooltipGenerator) {
        this.tooltipGenerator = Objects.requireNonNull(tooltipGenerator, "Tooltip generator cannot be null");
        this.addTooltipElementToTooltipSlot();
        this.refreshViewport();
    }

    public Tooltip.TooltipPosition getTooltipPosition() {
        String position = this.getTooltipElement().map(tooltipElement -> tooltipElement.getAttribute("position")).orElse(null);
        return Tooltip.TooltipPosition.fromPosition((String)position);
    }

    public void setTooltipPosition(Tooltip.TooltipPosition position) {
        Objects.requireNonNull(position, "Position cannot be null");
        this.addTooltipElementToTooltipSlot();
        this.getTooltipElement().ifPresent(tooltipElement -> tooltipElement.setAttribute("position", position.getPosition()));
    }

    public boolean isTooltipMarkdownEnabled() {
        return this.getTooltipElement().map(tooltipElement -> tooltipElement.getProperty("markdown", false)).orElse(false);
    }

    public void setTooltipMarkdownEnabled(boolean markdownEnabled) {
        this.addTooltipElementToTooltipSlot();
        this.getTooltipElement().ifPresent(tooltipElement -> tooltipElement.setProperty("markdown", markdownEnabled));
    }

    private void addTooltipElementToTooltipSlot() {
        if (this.getTooltipElement().isPresent()) {
            return;
        }
        Element tooltipElement = new Element("vaadin-tooltip");
        tooltipElement.addAttachListener((ElementAttachListener & Serializable)e -> tooltipElement.executeJs("this.generator = ({item, column}) => { return (item && item.gridtooltips && column) ? item.gridtooltips[column._flowId] ?? item.gridtooltips['row'] : ''; }", new Object[0]));
        SlotUtils.addToSlot((HasElement)this, (String)"tooltip", (Element[])new Element[]{tooltipElement});
    }

    private Optional<Element> getTooltipElement() {
        return this.getElement().getChildren().filter(child -> Objects.equals(child.getAttribute("slot"), "tooltip")).findFirst();
    }

    public void setSelectionDragDetails(int draggedItemsCount, Map<String, String> dragData) {
        this.getElement().setProperty("__selectionDraggedItemsCount", (double)draggedItemsCount);
        if (dragData != null) {
            ObjectNode json = JacksonUtils.createObjectNode();
            dragData.entrySet().forEach(e -> json.put((String)e.getKey(), (String)e.getValue()));
            this.getElement().setPropertyJson("__selectionDragData", (BaseJsonNode)json);
        } else {
            this.getElement().setProperty("__selectionDragData", null);
        }
    }

    public Registration addColumnReorderListener(ComponentEventListener<ColumnReorderEvent<T>> listener) {
        return this.addListener(ColumnReorderEvent.class, Objects.requireNonNull(listener));
    }

    public void setColumnOrder(Column<T> ... columns) {
        this.setColumnOrder(Arrays.asList(columns));
    }

    public void setColumnOrder(List<Column<T>> columns) {
        new GridColumnOrderHelper<T>(this).setColumnOrder(columns);
        this.updateClientSideSorterIndicators(this.sortOrder);
        this.fireColumnReorderEvent(this.getColumns());
    }

    private void fireColumnReorderEvent(List<Column<T>> columns) {
        this.fireEvent(new ColumnReorderEvent<T>(this, false, columns));
    }

    public void scrollToIndex(int rowIndex) {
        this.setViewportRangeByIndex(rowIndex);
        this.scheduleScrollExecution((SerializableRunnable & Serializable)() -> this.getElement().callJsFunction("scrollToIndex", new Object[]{rowIndex}));
    }

    private void setViewportRangeByIndex(int rowIndex) {
        int pageSize = this.getPageSize();
        int viewportSizeEstimate = 40;
        int targetPageStartIndex = rowIndex - rowIndex % pageSize;
        int lastIndex = rowIndex + viewportSizeEstimate;
        int lastIndexPageStartIndex = lastIndex - lastIndex % pageSize;
        int lastIndexPageEndIndex = lastIndexPageStartIndex + pageSize - 1;
        int preloadedItemsCount = lastIndexPageEndIndex - targetPageStartIndex + 1;
        this.setViewportRange(targetPageStartIndex, preloadedItemsCount);
    }

    public void scrollToItem(T item) {
        Objects.requireNonNull(item, "Item to scroll to cannot be null.");
        Object dataView = this.getDataProvider().isInMemory() ? this.getListDataView() : this.getLazyDataView();
        String itemKey = this.getDataCommunicator().getKeyMapper().key(item);
        int itemIndex = (Integer)dataView.getItemIndex(item).orElseThrow(() -> new NoSuchElementException("Item to scroll to cannot be found: " + String.valueOf(item)));
        this.setViewportRangeByIndex(itemIndex);
        this.scheduleScrollExecution((SerializableRunnable & Serializable)() -> this.getElement().callJsFunction("$connector.scrollToItem", new Object[]{itemKey, itemIndex}));
    }

    public void scrollToStart() {
        this.scrollToIndex(0);
    }

    public void scrollToEnd() {
        this.scheduleScrollExecution((SerializableRunnable & Serializable)() -> this.getElement().executeJs("this.scrollToIndex(this._flatSize)", new Object[0]));
    }

    public void scrollToColumn(int columnIndex) {
        this.getElement().callJsFunction("scrollToColumn", new Object[]{columnIndex});
    }

    public void scrollToColumn(Column<T> column) {
        this.getElement().callJsFunction("scrollToColumn", new Object[]{column.getElement()});
    }

    private void onDragStart(GridDragStartEvent<T> event) {
        ComponentUtil.setData((Component)this, (String)DRAG_SOURCE_DATA_KEY, event.getDraggedItems());
        this.getUI().ifPresent(ui -> ui.getInternals().setActiveDragSourceComponent((Component)this));
    }

    private void onDragEnd(GridDragEndEvent<T> event) {
        ComponentUtil.setData((Component)this, (String)DRAG_SOURCE_DATA_KEY, null);
        this.getUI().ifPresent(ui -> ui.getInternals().setActiveDragSourceComponent(null));
    }

    public void setNestedNullBehavior(NestedNullBehavior nestedNullBehavior) {
        this.nestedNullBehavior = nestedNullBehavior;
    }

    public NestedNullBehavior getNestedNullBehavior() {
        return this.nestedNullBehavior;
    }

    public void setColumnRendering(ColumnRendering columnRendering) {
        this.getElement().setProperty("columnRendering", columnRendering == null ? ColumnRendering.EAGER.getPropertyValue() : columnRendering.getPropertyValue());
    }

    public ColumnRendering getColumnRendering() {
        return ColumnRendering.fromPropertyValue(this.getElement().getProperty("columnRendering"));
    }

    private void onInMemoryFilterOrSortingChange(SerializablePredicate<T> filter, SerializableComparator<T> sortComparator) {
        this.updateInMemorySorting(sortComparator);
        this.updateInMemoryFiltering(filter);
    }

    private void updateInMemoryFiltering(SerializablePredicate<T> componentInMemoryFilter) {
        assert (this.filterSlot != null) : "Filter Slot is supposed not to be empty when set the filter";
        SerializableConsumer<?> inMemoryFilter = this.filterSlot;
        inMemoryFilter.accept(componentInMemoryFilter);
    }

    private void updateInMemorySorting(SerializableComparator<T> componentSorting) {
        SerializableComparator<T> currentClientSorting = this.createSortingComparator();
        if (componentSorting != null) {
            if (currentClientSorting != null) {
                this.getDataCommunicator().setInMemorySorting(this.combineSortings(currentClientSorting, componentSorting));
            } else {
                this.getDataCommunicator().setInMemorySorting(componentSorting);
            }
        } else {
            this.getDataCommunicator().setInMemorySorting(currentClientSorting);
        }
    }

    private SerializableComparator<T> combineSortings(SerializableComparator<T> originalSorting, SerializableComparator<T> addedSorting) {
        Objects.requireNonNull(originalSorting);
        Objects.requireNonNull(addedSorting);
        return (SerializableComparator & Serializable)(c1, c2) -> {
            int result = originalSorting.compare(c1, c2);
            if (result == 0) {
                result = addedSorting.compare(c1, c2);
            }
            return result;
        };
    }

    private String getUniqueKey(T item) {
        return Optional.ofNullable(this.getUniqueKeyProvider()).map(provider -> (String)provider.apply(item)).orElse(this.getDataCommunicator().getKeyMapper().key(item));
    }

    public void setEmptyStateComponent(Component emptyStateComponent) {
        this.emptyStateText = null;
        this.emptyStateComponent = emptyStateComponent;
        this.updateEmptyStateContent();
    }

    public void setEmptyStateText(String emptyStateText) {
        this.emptyStateComponent = null;
        this.emptyStateText = emptyStateText;
        this.updateEmptyStateContent();
    }

    public Component getEmptyStateComponent() {
        return this.emptyStateComponent;
    }

    public String getEmptyStateText() {
        return this.emptyStateText;
    }

    private void updateEmptyStateContent() {
        if (this.emptyStateComponent != null) {
            SlotUtils.setSlot((HasElement)this, (String)EMPTY_STATE_SLOT, (Component[])new Component[]{this.emptyStateComponent});
        } else if (this.emptyStateText != null) {
            SlotUtils.setSlot((HasElement)this, (String)EMPTY_STATE_SLOT, (Component[])new Component[]{new Span(this.emptyStateText)});
        } else {
            SlotUtils.clearSlot((HasElement)this, (String)EMPTY_STATE_SLOT);
        }
    }

    protected void refreshViewport() {
        ((GridDataCommunicator)this.getDataCommunicator()).refreshViewport();
    }

    public static enum MultiSortPriority {
        APPEND,
        PREPEND;

    }

    protected static class DataCommunicatorBuilder<T, U extends ArrayUpdater>
    implements Serializable {
        protected DataCommunicatorBuilder() {
        }

        protected DataCommunicator<T> build(Element element, CompositeDataGenerator<T> dataGenerator, U arrayUpdater, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
            return new GridDataCommunicator<T>(element, dataGenerator, (ArrayUpdater)arrayUpdater);
        }
    }

    public static enum NestedNullBehavior {
        THROW,
        ALLOW_NULLS;

    }

    private class DetailsManager
    extends AbstractGridExtension<T> {
        private final HashMap<Object, T> detailsVisible;

        public DetailsManager(Grid<T> grid2) {
            super(grid2);
            this.detailsVisible = new HashMap();
        }

        public void setDetailsVisible(T item, boolean visible) {
            Object itemId = this.getItemId(item);
            boolean refresh = false;
            if (!visible) {
                refresh = this.detailsVisible.remove(itemId) != null;
            } else {
                this.detailsVisible.put(itemId, item);
                refresh = true;
            }
            if (Grid.this.itemDetailsDataGenerator != null && refresh) {
                this.refresh(item);
                if (!this.detailsVisible.containsKey(itemId)) {
                    Grid.this.itemDetailsDataGenerator.destroyData(item);
                }
            }
        }

        public boolean isDetailsVisible(T item) {
            return Grid.this.itemDetailsDataGenerator != null && this.detailsVisible.containsKey(this.getItemId(item));
        }

        public void generateData(T item, ObjectNode jsonObject) {
            if (Grid.this.itemDetailsDataGenerator != null && this.isDetailsVisible(item)) {
                jsonObject.put("detailsOpened", true);
                Grid.this.itemDetailsDataGenerator.generateData(item, jsonObject);
            }
        }

        public void destroyData(T item) {
            this.detailsVisible.remove(this.getItemId(item));
            if (Grid.this.itemDetailsDataGenerator != null) {
                Grid.this.itemDetailsDataGenerator.destroyData(item);
            }
        }

        public void destroyAllData() {
            if (Grid.this.itemDetailsDataGenerator != null) {
                Grid.this.itemDetailsDataGenerator.destroyAllData();
            }
        }

        public void refreshData(T item) {
            if (Grid.this.itemDetailsDataGenerator != null) {
                if (this.isDetailsVisible(item)) {
                    Grid.this.itemDetailsDataGenerator.refreshData(item);
                } else {
                    Grid.this.itemDetailsDataGenerator.destroyData(item);
                }
            }
        }

        private void setDetailsVisibleFromClient(Set<T> items) {
            HashSet toRefresh = new HashSet();
            toRefresh.addAll(this.detailsVisible.values());
            toRefresh.addAll(items);
            this.detailsVisible.clear();
            for (Object item : items) {
                this.detailsVisible.put(this.getItemId(item), item);
            }
            if (Grid.this.itemDetailsDataGenerator != null) {
                for (Object item : toRefresh) {
                    this.refresh(item);
                }
            }
        }

        private Object getItemId(T item) {
            return Grid.this.getDataProvider().getId(item);
        }
    }

    public static enum SelectionMode {
        SINGLE,
        MULTI,
        NONE;


        protected <T> GridSelectionModel<T> createModel(final Grid<T> grid) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new AbstractGridSingleSelectionModel<T>(grid){

                    @Override
                    protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                        grid.fireEvent((ComponentEvent)event);
                    }

                    @Override
                    public void setDeselectAllowed(boolean deselectAllowed) {
                        super.setDeselectAllowed(deselectAllowed);
                        grid.getElement().setProperty("__deselectDisallowed", !deselectAllowed);
                    }
                };
                case 1 -> new AbstractGridMultiSelectionModel<T>(grid){

                    @Override
                    protected void fireSelectionEvent(SelectionEvent<Grid<T>, T> event) {
                        grid.fireEvent((ComponentEvent)event);
                    }
                };
                case 2 -> new GridNoneSelectionModel();
            };
        }
    }

    private class GridArrayUpdaterImpl
    implements GridArrayUpdater {
        private GridArrayUpdaterImpl() {
        }

        public UpdateQueue startUpdate(int sizeChange) {
            return new UpdateQueue(Grid.this.getElement(), sizeChange);
        }

        public void initialize() {
            Grid.this.setViewportRange(0, Grid.this.getPageSize());
        }
    }

    @Tag(value="vaadin-grid-column")
    public static class Column<T>
    extends AbstractColumn<Column<T>> {
        private final String columnInternalId;
        private String columnKey;
        private boolean sortingEnabled;
        private Component editorComponent;
        private EditorRenderer<T> editorRenderer;
        private SortOrderProvider sortOrderProvider = (SortOrderProvider & Serializable)direction -> {
            String key = this.getKey();
            if (key == null) {
                return Stream.empty();
            }
            return Stream.of(new QuerySortOrder(key, direction));
        };
        private SerializableComparator<T> comparator;
        private Registration columnDataGeneratorRegistration;
        private Registration editorDataGeneratorRegistration;
        private Renderer<T> renderer;
        private Rendering<T> rendering;
        private SerializableFunction<T, String> partNameGenerator = (SerializableFunction & Serializable)item -> null;
        private SerializableFunction<T, String> tooltipGenerator = (SerializableFunction & Serializable)item -> null;

        public Column(Grid<T> grid, String columnId, Renderer<T> renderer) {
            super(grid);
            Objects.requireNonNull(renderer);
            this.columnInternalId = columnId;
            this.renderer = renderer;
            this.comparator = (SerializableComparator & Serializable)(a, b) -> 0;
            this.rendering = renderer.render(this.getElement(), (DataKeyMapper)((KeyMapper)this.getGrid().getDataCommunicator().getKeyMapper()));
            Optional dataGenerator = this.rendering.getDataGenerator();
            if (dataGenerator.isPresent()) {
                this.columnDataGeneratorRegistration = grid.addDataGenerator((DataGenerator)dataGenerator.get());
            }
        }

        protected void destroyDataGenerators() {
            if (this.columnDataGeneratorRegistration != null) {
                this.columnDataGeneratorRegistration.remove();
                this.columnDataGeneratorRegistration = null;
            }
            if (this.editorDataGeneratorRegistration != null) {
                this.editorDataGeneratorRegistration.remove();
                this.editorDataGeneratorRegistration = null;
            }
        }

        protected String getInternalId() {
            return this.columnInternalId;
        }

        public Renderer<T> getRenderer() {
            return this.renderer;
        }

        public Column<T> setRenderer(Renderer<T> renderer) {
            this.renderer = Objects.requireNonNull(renderer, "Renderer must not be null.");
            this.destroyDataGenerators();
            if (this.rendering != null) {
                this.rendering.getRegistration().remove();
            }
            this.rendering = renderer.render(this.getElement(), (DataKeyMapper)((KeyMapper)this.getGrid().getDataCommunicator().getKeyMapper()));
            this.columnDataGeneratorRegistration = this.rendering.getDataGenerator().map(dataGenerator -> this.grid.addDataGenerator(dataGenerator)).orElse(null);
            if (this.editorRenderer != null) {
                Rendering editorRendering = this.editorRenderer.render(this.getElement(), null);
                this.editorDataGeneratorRegistration = editorRendering.getDataGenerator().map(dataGenerator -> this.grid.addDataGenerator(dataGenerator)).orElse(null);
            }
            this.getGrid().refreshViewport();
            return this;
        }

        public Column<T> setWidth(String width) {
            this.getElement().setProperty("width", width);
            return this;
        }

        @Synchronize(value={"column-drag-resize"})
        public String getWidth() {
            return this.getElement().getProperty("width");
        }

        public Column<T> setFlexGrow(int flexGrow) {
            this.getElement().setProperty("flexGrow", (double)flexGrow);
            return this;
        }

        @Synchronize(value={"column-drag-resize"})
        public int getFlexGrow() {
            return this.getElement().getProperty("flexGrow", 1);
        }

        public Column<T> setAutoWidth(boolean autoWidth) {
            this.getElement().setProperty("autoWidth", autoWidth);
            return this;
        }

        public boolean isAutoWidth() {
            return this.getElement().getProperty("autoWidth", false);
        }

        public Column<T> setKey(String key) {
            Objects.requireNonNull(key, "Column key cannot be null");
            if (this.columnKey != null) {
                throw new IllegalStateException("Column key cannot be changed");
            }
            this.getGrid().setColumnKey(key, this);
            this.columnKey = key;
            return this;
        }

        public String getKey() {
            return this.columnKey;
        }

        @Override
        public Element getElement() {
            return super.getElement();
        }

        public Column<T> setComparator(Comparator<T> comparator) {
            Objects.requireNonNull(comparator, "Comparator must not be null");
            this.setSortable(true);
            this.comparator = comparator::compare;
            return this;
        }

        public <V extends Comparable<? super V>> Column<T> setComparator(ValueProvider<T, V> keyExtractor) {
            Objects.requireNonNull(keyExtractor, "Key extractor must not be null");
            this.setComparator(Comparator.comparing(keyExtractor, Comparator.nullsLast(Comparator.naturalOrder())));
            return this;
        }

        public SerializableComparator<T> getComparator(SortDirection sortDirection) {
            boolean reverse;
            Objects.requireNonNull(this.comparator, "No comparator defined for sorted column.");
            this.setSortable(true);
            boolean bl = reverse = sortDirection != SortDirection.ASCENDING;
            return reverse ? this.comparator.reversed()::compare : this.comparator;
        }

        public Column<T> setSortProperty(String ... properties) {
            Objects.requireNonNull(properties, "Sort properties must not be null");
            this.setSortable(true);
            this.sortOrderProvider = (SortOrderProvider & Serializable)dir -> Arrays.stream(properties).map(s -> new QuerySortOrder(s, dir));
            return this;
        }

        public Column<T> setSortOrderProvider(SortOrderProvider provider) {
            Objects.requireNonNull(provider, "Sort order provider must not be null");
            this.setSortable(true);
            this.sortOrderProvider = provider;
            return this;
        }

        public Stream<QuerySortOrder> getSortOrder(SortDirection direction) {
            return this.sortOrderProvider.apply(direction);
        }

        public Column<T> setSortable(boolean sortable) {
            if (this.sortingEnabled == sortable) {
                return this;
            }
            this.sortingEnabled = sortable;
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow != null) {
                ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).getColumn().setSortingIndicators(sortable);
            }
            return this;
        }

        public boolean isSortable() {
            return this.sortingEnabled;
        }

        public Column<T> setHeader(String labelText) {
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow == null) {
                defaultHeaderRow = this.getGrid().addFirstHeaderRow();
            }
            ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).setText(labelText);
            this.grid.updateClientSideSorterIndicators();
            return this;
        }

        public Column<T> setFooter(String labelText) {
            ((FooterRow.FooterCell)this.getGrid().getColumnLayers().get(0).asFooterRow().getCell(this)).setText(labelText);
            return this;
        }

        public Column<T> setHeader(Component headerComponent) {
            HeaderRow defaultHeaderRow = this.getGrid().getDefaultHeaderRow();
            if (defaultHeaderRow == null) {
                defaultHeaderRow = this.getGrid().addFirstHeaderRow();
            }
            ((HeaderRow.HeaderCell)defaultHeaderRow.getCell(this)).setComponent(headerComponent);
            this.grid.updateClientSideSorterIndicators();
            return this;
        }

        public Column<T> setFooter(Component footerComponent) {
            ((FooterRow.FooterCell)this.getGrid().getColumnLayers().get(0).asFooterRow().getCell(this)).setComponent(footerComponent);
            return this;
        }

        public Column<T> setEditorComponent(Component editorComponent) {
            if (editorComponent == null) {
                this.setEditorComponent((SerializableFunction)null);
            } else {
                this.setEditorComponent((SerializableFunction & Serializable)item -> editorComponent);
            }
            this.editorComponent = editorComponent;
            return this;
        }

        public Column<T> setEditorComponent(SerializableFunction<T, ? extends Component> componentCallback) {
            this.editorComponent = null;
            if (this.editorRenderer == null && componentCallback != null) {
                this.setupColumnEditor();
            }
            if (this.editorRenderer != null) {
                this.editorRenderer.setComponentFunction(componentCallback);
            }
            return this;
        }

        public Component getEditorComponent() {
            return this.editorComponent;
        }

        public Column<T> setPartNameGenerator(SerializableFunction<T, String> partNameGenerator) {
            Objects.requireNonNull(partNameGenerator, "Part name generator can not be null");
            this.partNameGenerator = partNameGenerator;
            this.getGrid().refreshViewport();
            return this;
        }

        public Column<T> setTooltipGenerator(SerializableFunction<T, String> tooltipGenerator) {
            this.tooltipGenerator = Objects.requireNonNull(tooltipGenerator, "Tooltip generator can not be null");
            this.grid.addTooltipElementToTooltipSlot();
            this.getGrid().refreshViewport();
            return this;
        }

        public SerializableFunction<T, String> getPartNameGenerator() {
            return this.partNameGenerator;
        }

        public SerializableFunction<T, String> getTooltipGenerator() {
            return this.tooltipGenerator;
        }

        public boolean isRowHeader() {
            return this.getElement().getProperty("rowHeader", false);
        }

        public Column<T> setRowHeader(boolean rowHeader) {
            this.getElement().setProperty("rowHeader", rowHeader);
            return this;
        }

        @Override
        protected Column<?> getBottomLevelColumn() {
            return this;
        }

        private void setupColumnEditor() {
            this.editorRenderer = new EditorRenderer(this.grid.getEditor(), this.columnInternalId);
            Rendering editorRendering = this.editorRenderer.render(this.getElement(), null);
            Optional dataGenerator = editorRendering.getDataGenerator();
            if (dataGenerator.isPresent()) {
                this.editorDataGeneratorRegistration = this.grid.addDataGenerator((DataGenerator)dataGenerator.get());
            }
        }
    }

    public static interface SpringData
    extends Serializable {

        @FunctionalInterface
        public static interface CountCallback<PAGEABLE>
        extends Serializable {
            public long count(PAGEABLE var1);
        }

        @FunctionalInterface
        public static interface FetchCallback<PAGEABLE, T>
        extends Serializable {
            public List<T> fetch(PAGEABLE var1);
        }
    }

    public static abstract class AbstractGridExtension<T>
    implements DataGenerator<T> {
        private Grid<T> grid;
        private Registration registration;

        public AbstractGridExtension(Grid<T> grid) {
            this.extend(grid);
        }

        protected void refresh(T item) {
            this.getGrid().getDataCommunicator().refresh(item);
        }

        protected void extend(Grid<T> grid) {
            this.grid = grid;
            this.registration = this.getGrid().addDataGenerator(this);
        }

        protected void remove() {
            this.registration.remove();
        }

        protected Grid<T> getGrid() {
            return this.grid;
        }
    }

    protected static class UpdateQueue
    implements ArrayUpdater.Update {
        private final ArrayList<SerializableRunnable> queue = new ArrayList();
        private final Element element;

        protected UpdateQueue(Element element, int size) {
            this.element = element;
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
            this.getElement().setProperty("size", (double)size);
        }

        public void set(int start, List<JsonNode> items) {
            this.enqueue("$connector.set", Integer.valueOf(start), (Serializable)items.stream().collect(JacksonUtils.asArray()));
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            this.enqueue("$connector.confirm", Integer.valueOf(updateId));
            this.commit();
        }

        public void commit() {
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        public void enqueue(String name, Serializable ... arguments) {
            this.queue.add((SerializableRunnable & Serializable)() -> this.getElement().callJsFunction(name, arguments));
        }

        protected Element getElement() {
            return this.element;
        }
    }
}

